#ifndef _TCSUPERSPICE_DATABASE_H
#define _TCSUPERSPICE_DATABASE_H

#include <afxtempl.h>
#include "TCFileFunctions.h"
#include "TCSpiceParameters.h"
#include "TCGraphicBitMapVectorObject.h"
#include "TCSchematicObjectData.h"

#include <afxtempl.h>

class TCCreateSymbolFromSchematicData;

class TCSymbolEditorData : public CObject
{
	public:	TCSymbolEditorData(void);
			TCSymbolEditorData(TCSymbolEditorData &CSymbolEditorData);
			~TCSymbolEditorData(void);

			CString CSymbolFileName;
			CString CSymbolName;

			void operator = (TCSymbolEditorData &CSymbolEditorData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCSymbolEditorData)

};

class TCSymbolDataBaseDataList : public CObject
{
	public:	TCSymbolDataBaseDataList(void);// This class is only used as a dummy for file error checking
			TCSymbolDataBaseDataList(TCSymbolDataBaseDataList &CSymbolDataBaseDataList);
			~TCSymbolDataBaseDataList(void);

			void operator = (TCSymbolDataBaseDataList &CSymbolDataBaseDataList);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCSymbolDataBaseDataList)

};

class TCComponentDataBaseData : public CObject
{
	public:	TCComponentDataBaseData(void);
			TCComponentDataBaseData(TCComponentDataBaseData &CComponentDataBaseData);
			~TCComponentDataBaseData(void);

			int		use_index;
			int		symbol_file_index;
			int		symbol_index;
			int		model_file_index;
			int		model_index;
			int		component_file_index;
			int		component_index;

			CString CSymbolName;
			CString CSymbolFileName;
			CString CSymbolPathName;
			CString CModelName;
			CString CModelFileName;
			CString CModelPathName;

			CString CComponentFileName;
			CString CComponentPathName;
			CString CComponentName;
			CString CComponentType;
			CString CComponentDescription;

			void operator = (TCComponentDataBaseData &CComponentDataBaseData);
			bool operator != (TCComponentDataBaseData &CComponentDataBaseData);
			bool operator == (TCComponentDataBaseData &CComponentDataBaseData);

			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCComponentDataBaseData)

};

class TCDataBaseClipboard : public CObject
{
	public:	TCDataBaseClipboard(void);
			TCDataBaseClipboard(TCDataBaseClipboard &CDataBaseClipboard);
			~TCDataBaseClipboard(void);

			TCComponentDataBaseData CSource;
			TCComponentDataBaseData CDestination;
			TCComponentDataBaseData CFileSource;
			TCComponentDataBaseData CFileDestination;

			int model_file_count;
			int symbol_file_count;
			int model_count;
			int symbol_count;

			CString GetNewModelName(void);
			CString GetNewSymbolName(void);
			CString GetNewModelFileName(void);
			CString GetNewSymboFilelName(void);

			void operator = (TCDataBaseClipboard &CDataBaseClipboard);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCDataBaseClipboard)

};

class TCComponentDataBaseList : public CObject
{
	public:	TCComponentDataBaseList(void);
			TCComponentDataBaseList(TCComponentDataBaseList &CComponentDataBaseList);
			~TCComponentDataBaseList(void);

			CString	CName;
			CString	CPath;
			CString CType;
			CString CNotes;

			CString CComboEdit;
			int		index;

			CArray <TCComponentDataBaseData, TCComponentDataBaseData&> CComponentList;

			void operator = (TCComponentDataBaseList &CComponentDataBaseList);
	
			void Serialize(CArchive& CArchiveFile);

			bool Get(TCComponentDataBaseData &CComponentDataBaseData);
			bool Set(TCComponentDataBaseData &CComponentDataBaseData);

			int  Find(TCComponentDataBaseData &CComponentDataBaseData);
			bool Load(void);
			bool Save(void);

			DECLARE_SERIAL(TCComponentDataBaseList)

};

class TCComponentDataBase : public CObject
{
	public:	TCComponentDataBase(void);
			TCComponentDataBase(TCComponentDataBase &CComponentDataBase);
			~TCComponentDataBase(void);

			CString CComboEdit;
			int		index;

			CArray <TCComponentDataBaseList, TCComponentDataBaseList> CFileList;

			void operator = (TCComponentDataBase &CComponentDataBase);
	
			void Serialize(CArchive& CArchiveFile);
			bool Save(void);
			bool Load(void);

			bool Get(TCComponentDataBaseData &CComponentDataBaseData);
			bool Set(TCComponentDataBaseData &CComponentDataBaseData);

			DECLARE_SERIAL(TCComponentDataBase)

};


class TCCircuitsNameData : public CObject
{
	public:	TCCircuitsNameData(void);
			TCCircuitsNameData(TCCircuitsNameData &CBlank);
			~TCCircuitsNameData(void);

			HTREEITEM HTreeItem;

			CString CName;
			
			CArray <TCNameValueData, TCNameValueData&> CAttributes;
			

			void operator = (TCCircuitsNameData &CCircuitsNameData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCCircuitsNameData)

};

class TCCircuitsDataBaseData : public CObject
{
	public:	TCCircuitsDataBaseData(void);
			TCCircuitsDataBaseData(TCCircuitsDataBaseData &CCircuitsDataBaseData);
			~TCCircuitsDataBaseData(void);

			CArray <TCCircuitsNameData, TCCircuitsNameData&> CCircuitNameList;
			CString CPath;
			CString CName;
			CString CIndex;
			int		index;
			HTREEITEM HTreeItem;

			bool Save(int index);
			bool Save(void);
			bool Load(void);
			bool LoadCircuitList(CString CPath);
			int Find(CString CName);

			void operator = (TCCircuitsDataBaseData &CCircuitsDataBaseData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCCircuitsDataBaseData)

};

class TCSymbolDataBaseData : public CObject
{
	public:	TCSymbolDataBaseData(void);
			TCSymbolDataBaseData(TCSymbolDataBaseData &CSymbolDataBaseData);
			~TCSymbolDataBaseData(void);

			CString CPath;
			CString CName;
			CString CType;
			CString CNotes;
			CString CComboEdit;
			int		index;
			HTREEITEM HTreeItem;

			CArray <TCSchematicObjectData, TCSchematicObjectData&> CSymbolList;

			void operator = (TCSymbolDataBaseData &CSymbolDataBaseData);
	
			void Serialize(CArchive& CArchiveFile);
			bool Load(void);
			bool Save(void);
			bool New(void);

			bool CopyToNewDir(void);

			int Find(CString CName);

			bool Get(TCSchematicObjectData &CSchematicObjectData);
			bool Set(TCSchematicObjectData &CSchematicObjectData, int insert_index = -1);

			CArray<TCSchematicPinData, TCSchematicPinData &> &GetPinListData(TCSchematicObjectData &CSchematicObjectData);

			DECLARE_SERIAL(TCSymbolDataBaseData)

};

class TCSpiceNodeNames : public CObject
{
	public:	TCSpiceNodeNames(void);
			TCSpiceNodeNames(TCSpiceNodeNames &CSpiceNodeNames);
			~TCSpiceNodeNames(void);

			int							basic_spice_type;
			CString						CBasicSpiceType;
			CArray <CString, CString>	CDeviceNodes;	

			void operator = (TCSpiceNodeNames &CSpiceNodeNames);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCSpiceNodeNames)

};

class TCCircuitsDataBase : public CObject
{
	public:	TCCircuitsDataBase(void);
			TCCircuitsDataBase(TCCircuitsDataBase &CCircuitsDataBaseData);
			~TCCircuitsDataBase(void);

			CArray <CString, CString> CReseved;

			CString CPath;
			CString CName;
			CString CIndex;
			int		index;

			bool Save(void);
			bool Load(void);

			CArray <TCCircuitsDataBaseData, TCCircuitsDataBaseData&> CFileList;

			void operator = (TCCircuitsDataBase &CCircuitsDataBase);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCCircuitsDataBase)

};

class TCSymbolDataBase : public CObject
{
	public:	TCSymbolDataBase(void);
			TCSymbolDataBase(TCSymbolDataBase &CSymbolDataBase);
			~TCSymbolDataBase(void);

			CString CComboEdit;
			int		index;

			CArray <TCSymbolDataBaseData, TCSymbolDataBaseData&> CFileList;

			void operator = (TCSymbolDataBase &CSymbolDataBase);
	
			void Serialize(CArchive& CArchiveFile);
			bool Save(void);
			bool Load(void);

			bool Get(TCSchematicObjectData &CSchematicObjectData);
			bool Set(TCSchematicObjectData &CSchematicObjectData, bool save, int insert_index = -1);

			CArray<TCSchematicPinData, TCSchematicPinData &> &GetPinListData(TCSchematicObjectData &CSchematicObjectData);

			DECLARE_SERIAL(TCSymbolDataBase)

};


class TCModelDataBaseData : public CObject
{
	public:	TCModelDataBaseData(void);
			TCModelDataBaseData(TCModelDataBaseData &CModelDataBaseData);
			~TCModelDataBaseData(void);

			CString CPath;
			CString CName;
			CString CType;
			CString CNotes;

			CString CComboEdit;
			int		index;
			HTREEITEM HTreeItem;

			TCSpiceParametersList CParametersList;

			void operator = (TCModelDataBaseData &CModelDataBaseData);
	
			void Serialize(CArchive& CArchiveFile);
			bool Load(void);
			bool Save(void);
			bool Get(TCSpiceParameters &CSpiceParameters);
			bool Set(TCSpiceParameters &CSpiceParameters, int insert_index = -1);
			TCSpiceParameters *GetPointer(TCSpiceParameters &CSpiceParameters);


			DECLARE_SERIAL(TCModelDataBaseData)

};

class TCModelDataBase : public CObject
{
	public:	TCModelDataBase(void);
			TCModelDataBase(TCModelDataBase &CModelDataBase);
			~TCModelDataBase(void);

			CString CComboEdit;
			int		index;
			TCSpiceParameters CMAutoWCSpiceParameters;
			
			CArray <TCModelDataBaseData, TCModelDataBaseData &> CFileList;

			void operator = (TCModelDataBase &CModelDataBase);
	
			void Serialize(CArchive& CArchiveFile);

			bool Save(void);
			bool Load(void);

			bool Get(TCSpiceParameters &CSpiceParameters);
			bool Set(TCSpiceParameters &CSpiceParameters, int insert_index = -1);
			TCSpiceParameters *GetPointer(TCSpiceParameters &CSpiceParameters, bool auto_wc = false);

			TCSpiceParameters *GetAutoWCPointer(TCSpiceParameters &CSpiceParameters);
			TCSpiceParameters *GetWCMCModelPointer(TCSpiceParameters &CSpiceParameters,CString CWCMCRunType);

			DECLARE_SERIAL(TCModelDataBase)

};

class TCSuperSpiceDataBase : public CObject
{
	private:	TCSchematicObjectData	CMSchematicObjectData;			// Main data structure
																		    // to be filled from Access data base			
				TCSchematicPinData	CMSchematicPointingLeftPinData;	// Local scratchpad
				TCSchematicPinData	CMSchematicPointingUpPinData;		// Local scratchpad
				TCSchematicPinData	CMSchematicPointingDownPinData;
				TCSchematicPinData	CMSchematicPointingRightPinData;
				TCLineData			CMSymbolData;			// Local scratchpad

	public:
			TCSuperSpiceDataBase(void);
			~TCSuperSpiceDataBase(void);

			TCSymbolDataBase	CSymbolDataBase;
			TCModelDataBase		CModelDataBase;
			TCCircuitsDataBase CCircuitsDataBase;

			TCComponentDataBaseData CComponentFileNames;
			TCComponentDataBaseData CSuperSpiceComponentFileNames;
			TCDataBaseClipboard		CClipboard;

			CString CSuperSpiceModelLibName;
			CString CSuperSpiceSymbolLibName;
			CString CSuperSpiceSymbolListName;
			CString CSuperSpiceModelListName;
			CString CSuperSpiceComponentListName;
			CString CSuperSpiceNameCircuits;
			CString CTextModelList;
			CString CTextSymbolList;
			CString CTextCircuitsList;
			CString CSuperSpiceDataBaseName;
			CString CSuperSpiceClipboardName;
			CString CSuperSpiceFilterName;
			CString CSuperSpiceEquationsName;
			CString CSuperSpiceInitName;
			CString	CParamDefsFileName;
			CString	CParamDefsModelName;


			float component_scale;

			CArray <TCSchematicObjectData, TCSchematicObjectData&> CMDefaults;
			CArray <CString, CString&> CReferanceDesignator;

			CArray <CString, CString &> CTestPointNames;

			CArray <TCSpiceNodeNames, TCSpiceNodeNames&> CSpiceNodeNames;
			CArray <int, int> CSpiceNodeParameterStartIndex;

			int Find(CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSchematicObjectDataList, CString CName);
			
			void Serialize(CArchive& CArchiveFile);

			bool Save(CString CFileName);
			bool Load(CString CFileName);
			bool SaveAs(CString CFileName);
			bool LoadAs(CString CFileName);

			bool SaveSymbols(void);
			bool LoadSymbols(void);
			bool SaveModels(void);
			bool LoadModels(void);
			bool SaveCircuits(void);
			bool LoadCircuits(void);
			bool SaveSymbolsList(void);
			bool LoadSymbolsList(void);
			bool SaveModelsList(void);
			bool LoadModelsList(void);
			bool SaveCircuitsList(void);
			bool LoadCircuitsList(void);

			bool AddModelFile(CString CFileName);
			bool ReloadModelFile(CString CFileName);
			bool RemoveModelFile(int id);
			bool RemoveModel(int file_index, int model_index);
			bool AddSymbolFile(CString CFileName);
			bool NewSymbolFile(CString CFileName);
			bool NewSymbol(CString CFileName);
			bool RemoveSymbolFile(int id);
			bool RemoveSymbol(int file_index, int symbol_index);
			int  FindModelFile(CString CFileName);
			int  FindSymbolFile(CString CFileName);
			bool AddSymbol(int file_index, CString CFileName);
			bool NewSymbol(int file_index, CString CFileName);
			bool AddModel(int file_index, CString CFileName);
			int FindSymbolfromRecord(CString CRecord);
			bool AddModelToUserLibrary(CString CModelFileName);

			bool AddCircuitsFile(CString CFileName);
			bool RemoveCircuitsFile(int id);
			int  FindCircuitsFile(CString CFileName);

			bool CopySymbol(TCDataBaseClipboard &CDataBaseClipboard);
			bool PasteSymbol(TCDataBaseClipboard &CDataBaseClipboard);
			bool CopyModel(TCDataBaseClipboard &CDataBaseClipboard);
			bool PasteModel(TCDataBaseClipboard &CDataBaseClipboard);

			bool CopySymbolFile(TCDataBaseClipboard &CDataBaseClipboard);
			bool PasteSymbolFile(TCDataBaseClipboard &CDataBaseClipboard);
			bool CopyModelFile(TCDataBaseClipboard &CDataBaseClipboard);
			bool PasteModelFile(TCDataBaseClipboard &CDataBaseClipboard);

			bool SaveSuperSpiceSymbols(void);
			bool LoadSuperSpiceSymbols(void);
			bool AddDefaultSuperSpiceModels(void);
			bool AddDefaultSuperSpiceSymbols(void);
			bool AddDefaultSuperSpiceCircuits(void);

			bool CheckAndCorrectSymbolData(TCSchematicObjectData &CSchematicObjectData);
			bool CheckAndCorrectSymbolData(TCComponentDataBaseData *PCComponentDataBaseData);
			bool CheckAndCorrectModelData(TCComponentDataBaseData *PCComponentDataBaseData, bool m_check);
			bool CheckAndCorrectModelData(TCComponentDataBaseData *PCComponentDataBaseData, int symbol_type);

			int	 GetModelType(TCComponentDataBaseData &CComponentDataBaseData);
			int	 GetSymbolType(TCComponentDataBaseData &CComponentDataBaseData);
			bool GetModel(TCSpiceParameters &CSpiceParameters);
			bool SetModel(TCSpiceParameters &CSpiceParameters);
			TCSpiceParameters *GetModelPointer(TCSpiceParameters &CSpiceParameters, bool auto_wc = false);
			bool GetSymbol(TCSchematicObjectData &CSchematicObjectData);
			bool SetSymbol(TCSchematicObjectData &CSchematicObjectData);
			bool DoublicateSymbol(CString CNewFileName, TCSchematicObjectData &CSchematicObjectDataOld);

			int GetGraphicTypeFromModelType(TCSchematicObjectData &CSchematicObjectData);
			int GetGraphicTypeFromModelType(CString CText);
			
			void SetSchematicObjectData(TCSchematicObjectData &CSchematicObjectData, bool set_model);
			bool GetSchematicObjectData(TCSchematicObjectData &CSchematicObjectData);
			void DoSpecialProcessing(TCSchematicObjectData &CSchematicObjectData);

			bool GetComponent(TCComponentDataBaseData CComponentDataBaseData, TCSchematicObjectData &CSchematicObjectData);
			bool SetComponent(TCSchematicObjectData &CSchematicObjectData);
			bool GetModel(TCComponentDataBaseData &CComponentDataBaseData, TCSchematicObjectData &CSchematicObjectData);
			double EvaluateComponentValue(CString CFileName, CString CRecordName, CString CTextValue);
			CString GetSchematicParameters(CString CFileName, CString CRecordName);

			CString TCSuperSpiceDataBase::GetRecordName(TCSpiceParameters &CSpiceParameters, double width, double length);

			CArray<TCSchematicPinData, TCSchematicPinData &> &GetPinListData(TCSchematicObjectData &CSchematicObjectData);

			void SetupComponentFileNames(void);
			void SetupFilePaths(CString &CFilePath);

			void Init(void);
			void Setup(void);
			void Setup3(void);
			void Setup3a(void);
			void Setup4(void);
			void Setup5(void);
			void Setup6(void);
			void Setup7(void);
			void Setup8(void);

			void SetupSymbolNames(void);
			void SetupTestPointNames(void);
			void SetupBoxWaveformCursor(void);
			void SetupWaveform(void);
			void SetupSolderBlob(void);
			void SetupLabel(void);
			void SetupPointingUpPin(void);
			void SetupPointingLeftPin(void);
			void SetupPointingDownPin(void);
			void SetupPointingRightPin(void);
			void SetupNPNTransister(void);
			void SetupPNPTransister(void);
			void SetupNJFetTransister(void);
			void SetupPJFetTransister(void);
			void SetupResisister(void);
			void SetupICResisister(void);
			void SetupCapacitor(void);
			void SetupICCapacitor(void);
			void SetupInductor(void);
			void SetupInductorCored(void);
			void SetupNMos(void);
			void SetupPMos(void);
			void SetupDiode(void);
			void SetupOpAmp(void);

			void SetupVDC(void);
			void SetupVSine(void);
			void SetupVPulse(void);
			void SetupVExp(void);
			void SetupVPWL(void);
			void SetupVSFFM(void);

			void SetupIDC(void);
			void SetupISine(void);
			void SetupIPulse(void);
			void SetupIExp(void);
			void SetupIPWL(void);
			void SetupISFFM(void);
			void SetupVariableResistor(void);


			void SetupISRC(void);
			void SetupZener(void);
			void SetupTestPoint(void);
			void SetupVCVS(void);
			void SetupVCIS(void);
			void SetupICVS(void);
			void SetupICIS(void);
			void SetupGround(void);
			void SetupPageConnecterInput(void);
			void SetupPageConnecterOutput(void);
			void SetupPageConnecterBidirectional(void);
			void SetupSubcurcuitConnecter(void);
			void SetupThyresistor(void);
			void SetupShottky(void);
			void SetupDiac(void);
			void SetupGTO(void);
			void SetupTransformer(void);
			void SetupTransmissionLine(void);
			void SetupTriac(void);
			void SetupVSwitch(void);
			void SetupISwitch(void);
			void SetupDualGateNMos(void);
			void SetupDualGatePMos(void);
			void SetupNIGBP(void);
			void SetupPIGBP(void);
			void SetupMultiplier(void);
			void SetupDivider(void);
			void SetupNonLinearSource(void);
			void Setup4TerninalNPNTransister(void);
			void Setup4TerninalPNPTransister(void);
			void Setup4TerninalNMos(void);
			void Setup4TerninalPMos(void);
			void SetupNGasFet(void);
			void SetupPGasFet(void);
			void Setup4TerminalNGasFet(void);
			void Setup4TerminalPGasFet(void);
			void Setup4TerninalNJFetTransister(void);
			void Setup4TerninalPJFetTransister(void);
			void SetupBuffer(void);
			void SetupVCA(void);
			void Setup2InputAmp(void);
			void SetupUnijunction(void);

			void SetupGenericPin2Component(void);
			void SetupGenericPin3Component(void);
			void SetupGenericPin4Component(void);
			void SetupGenericPin5Component(void);
			void SetupGenericPin6Component(void);
			void SetupGenericPin7Component(void);
			void SetupGenericPin8Component(void);
			void SetupGenericPin9Component(void);
			void SetupGenericPin10Component(void);
			void SetupGenericPin11Component(void);
			void SetupGenericPin12Component(void);
			void SetupGenericPin13Component(void);
			void SetupGenericPin14Component(void);
			void SetupGenericPin15Component(void);
			void SetupGenericPin16Component(void);


			void SetupAnd(void);
			void SetupNand(void);
			void SetupOr(void);
			void SetupNor(void);
			void SetupExOr(void);
			void SetupExNor(void);
			void SetupDType(void);
			void SetupJKType(void);
			void SetupSchmitt(void);
			void SetupInvertor(void);
			void Setup8BitCounter(void);
			void SetupLDO5Pin(void);
			void SetupCrystal(void);
			
			void SetupFuse(void);
			void SetupThermistor(void);
			void SetupVaristor(void);

			void SetupTriode(void);
			void SetupTetrode(void);
			void SetupPentode(void);
			void SetupTubeDiodeSingle(void);
			void SetupTubeDiodeDualCommonCathode(void);
			void SetupTubeDiodeDualIndividualCathode(void);

			void SetupTriodeHeater(void);
			void SetupTube8Pin(void);
			void SetupTriodeDualHeater(void);
			void SetupTriodeDual(void);
			void SetupTetrodeHeater(void);
			void SetupPentodeHeater(void);
			void SetupTubeDiodeSingleHeater(void);
			void SetupTubeDiodeDualCommonCathodeHeater(void);
			void SetupTubeDiodeDualIndividualCathodeHeater(void);
			void SetupTriodeCommonHeater(void);
			void SetupTubeDiodeCommonHeater(void);
			void SetupTubeDiodeDualCommonHeater(void);

			void SetupDigitalAnd(void);
			void SetupDigitalNand(void);
			void SetupDigitalOr(void);
			void SetupDigitalNor(void);
			void SetupDigitalExOr(void);
			void SetupDigitalExNor(void);
			void SetupDigitalInvertor(void);
			void SetupAToD(void);
			void SetupDToA(void);
			void SetupLaplaceTransform(void);


			void SetupPinLeftComponentSymbol(void);
			void SetupPinRightComponentSymbol(void);
			void SetupPinUpComponentSymbol(void);
			void SetupPinDownComponentSymbol(void);
			void SetupCurveComponentSymbol(void);
			void SetupInductorSemicircleComponentSymbol(void);

			void SetupTransformerDual(void);
			void SetupTransformerTriple(void);
			void SetupTransformerQuad(void);

			void SetupTransformerCenterTapedSingle(void);
			void SetupTransformerCenterTapedDual(void);
			void SetupTransformerCenterTapedTriple(void);
			void SetupTransformerCenterTapedQuad(void);
			void SetupTransformerFlyback(void);
			void SetupTransformerTubeOutput(void);
			void SetupOneCenterTapTransformer(void);
			void SetupDualOneCenterTapTransformer(void);
			void SetupMoter(void);
			void SetupMoterTacho(void);
			void SetupCCFL(void);
			void SetupTitleBlock(void);

			void SetupDigital3InputAnd(void);
			void SetupDigital3InputNand(void);
			void SetupDigital3InputOr(void);
			void SetupDigital3InputNor(void);
			void Setup3InputAnd(void);
			void Setup3InputNand(void);
			void Setup3InputOr(void);
			void Setup3InputNor(void);

			void SetupSpiceNodeNames(void);
			void SetupPinLocations(void);

			bool SetupDynamicSymbolComponent(TCLineData &CData);

			void RescaleComponents(float scale);
			bool GetDeviceCurrentNodeNames(TCSchematicObjectData *CSchematicObjectData, CArray <CString, CString> &CDeviceNodes);
			int	 GetSpiceModelType(TCSchematicObjectData *CSchematicObjectData);
			int	 GetSpiceModelType(CString CName);

			int  GetSpicePowerPolarity(CString CRecordType);

			void SaveSymbolLocations(void);
			void LoadSymbolLocations(void);


			bool PlaceCircuit(CString CFolderName, CString CFileName);
			void DisplayCircuitProperties(CString CFolderName, CString CFileName);

			void PlaceSymbolFromModel(int model_file_index, int model_index);
			void PlaceSymbolFromSymbol(int symbol_file_index, int symbol_index, int graphic_type = 0);
			int FindGraphicIdFromSubcircuit(TCSpiceParameters &CSpiceParameters, int &symbol_file_index, int &symbol_index);
			bool IsSymbolAvailableFromModel(TCDataBaseIdInfo &CDataBaseIdInfo);
			void SetWaveFormDefaultSize(unsigned short width, unsigned short height);
			void SetDefaultModelDisplayed(TCComponentDataBaseData &CComponentDataBaseData);
			void SetDefaultSymbolDisplayed(TCComponentDataBaseData &CComponentDataBaseData);
			void SetDefaultModelDisplayed(TCSchematicObjectData &CSchematicObjectData);
			void SetDefaultSymbolDisplayed(TCSchematicObjectData &CSchematicObjectData);
			int  GetPropertyView(CString CModelType);
			bool FindSymbolFromModelDescription(TCSpiceParameters &CSpiceParameters, int &symbol_file_index, int &symbol_index);
			int FindInternalSymbolFromModelType(TCSpiceParameters &CSpiceParameters);
			int FindInternalSymbolFromLibrary(TCSpiceParameters &CSpiceParameters, int &symbol_file_index, int &symbol_index);
			void SetSymbolViewType(TCSchematicObjectData &CSchematicObjectData, TCSpiceParameters &CSpiceParameters);
			void UpdateWaveFormSize(unsigned short width, unsigned short height);

			bool RenameModel(CString CFileName, CString COldName, CString CNewName);
			bool RenameSymbol(CString CFileName, CString COldName, CString CNewName);

			int SetSymbolPinName(CString CFileName, CString CSymbolName, int pin_id, CString CText);
			int SetSymbolAllPinNames(CString CFileName, CString CSymbolName, TCSchematicObjectData &CSchematicObjectData);

			bool CreateSymbolFromSchematic(TCCreateSymbolFromSchematicData &CCreateSymbolFromSchematicData);
			bool CreateSchematicSymbol(TCCreateSymbolFromSchematicData &CCreateSymbolFromSchematicData, TCSchematicObjectData &CSchematicObjectData);
			bool CreateSymbolForModel(void);


			bool GetCircuitAttributes(CString CCircuitType, CString CircuitName, CArray <TCNameValueData, TCNameValueData&> &CAttributes);
			bool GetCircuitAttributes(CString CFolderName, CString CFileName, TCCircuitsNameData &CCircuitsNameData);
			bool SetCircuitAttributes(CString CFolderName, CString CFileName, TCCircuitsNameData &CCircuitsNameData);

			CString GetDefaultFileNameFromId(int id);
			CString CreateReRunFileFromModel(CString CFilePath, CString CFileName, CString CModelName);

			int FindModels(CString CModel, CArray <CString, CString> &CModelNames, CArray <HTREEITEM,  HTREEITEM> &CHandles);
			int FindSymbols(CString CSymbol, CArray <CString, CString> &CSymbolNames, CArray <HTREEITEM,  HTREEITEM> &CHandles);

			DECLARE_SERIAL(TCSuperSpiceDataBase)
};


#endif
