#include "float.h"
#include "TDVersion.h"
#include "TESuperSpiceEnums.h"
#include "TEPropertyViewTypes.h"
#include "TESuperSpiceLabelEnums.h"
#include "stdafx.h"
#include "TCFileFunctions.h"
#include "TCStringFunctions.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCOutputWaveformData.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



extern bool SaveGenericToArchive(CObject *, CString);
extern bool LoadGenericFromArchive(CObject *, CString);

extern TCSuperSpiceGlobalData GCSuperSpiceGlobalData;
extern TCSuperSpiceDataBase GCSuperSpiceDataBase; // Global


IMPLEMENT_SERIAL(TCSuperSpiceDataBase, CObject, ID_VERSION_NUMBER)


//////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////
void TCSuperSpiceDataBase::Serialize(CArchive& CArchiveFile)
{
	try
	{
		CArchiveFile.SerializeClass(RUNTIME_CLASS(TCSuperSpiceDataBase));
	}
	catch(...)
	{
		_fpreset();

		return;
	}

	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{

	}
	else
	{

	}

	CComponentFileNames.Serialize(CArchiveFile);
	CSuperSpiceComponentFileNames.Serialize(CArchiveFile);
	CClipboard.Serialize(CArchiveFile);
}

bool TCSuperSpiceDataBase::Save(CString CFileName)
{
	SaveGenericToArchive(this, CFileName);// ignor if failed

	bool flag = false;

	if(!SaveSuperSpiceSymbols()) flag = true;
	
	if(!SaveSymbolsList())		flag = true;
	if(!SaveModelsList())		flag = true;
	if(!SaveCircuitsList())	flag = true;

	return !flag;
}
bool TCSuperSpiceDataBase::SaveAs(CString CFileName)
{
	bool flag = false;

	CString CNewFileName= ExtractFileName(CFileName);
	CString CFilePath	= ExtractPathName(CFileName);

	CNewFileName = RemoveExtention(CNewFileName);

	GCSuperSpiceGlobalData.CGeneric.CDataBaseInitFileName = CFileName;
	CComponentFileNames.CSymbolFileName		= CNewFileName + ".ssl";
	CComponentFileNames.CModelFileName		= CNewFileName + ".sml";
	CComponentFileNames.CComponentFileName	= CNewFileName + ".scl";

	CComponentFileNames.CSymbolPathName		= CFilePath;
	CComponentFileNames.CModelPathName		= CFilePath;
	CComponentFileNames.CComponentPathName	= CFilePath;

	if(!SaveGenericToArchive(this, CFileName)) flag = true;
	if(!SaveSymbolsList())		flag = true;
	if(!SaveModelsList())		flag = true;
	if(!SaveCircuitsList())	flag = true;

	return !flag;
}
bool TCSuperSpiceDataBase::LoadAs(CString CFileName)
{
	bool flag = false;
 
	CString CNewFileName= ExtractFileName(CFileName);
	CString CFilePath	= ExtractPathName(CFileName);

	CNewFileName = RemoveExtention(CNewFileName);

	GCSuperSpiceGlobalData.CGeneric.CDataBaseInitFileName = CFileName;
	CComponentFileNames.CSymbolFileName		= CFilePath + CNewFileName + ".ssl";
	CComponentFileNames.CModelFileName		= CFilePath + CNewFileName + ".sml";
	CComponentFileNames.CComponentFileName	= CFilePath + CNewFileName + ".skl";

	if(!LoadGenericFromArchive(this, CFileName)) flag = true; 
	if(!LoadSymbolsList())		flag = true;
	if(!LoadModelsList())		flag = true;
	if(!LoadCircuitsList())	flag = true;
	if(!LoadSymbols())			flag = true;
	if(!LoadModels())			flag = true;
	if(!LoadCircuits())		flag = true;

	return !flag;
}

bool TCSuperSpiceDataBase::Load(CString CFileName)
{
	if(!LoadGenericFromArchive(this, CFileName)) // Loads the model/symbols list file names
	{
		SetupComponentFileNames();

		AddDefaultSuperSpiceModels();
		AddDefaultSuperSpiceSymbols();//  generic starter parts
		AddDefaultSuperSpiceCircuits();

		LoadSuperSpiceSymbols();// Might still load ok

		return false;
	}

	SetupComponentFileNames();

	bool flag = false;

	if(!LoadSuperSpiceSymbols()) flag = true;

	if(!LoadSymbolsList())			flag = true;// Loads the model/symbols list 
	if(!LoadModelsList())			flag = true;
	if(!LoadCircuitsList())			flag = true;
	if(!LoadSymbols())				flag = true;// Loads the model/symbols
	if(!LoadModels())				flag = true;
	if(!LoadCircuits())				flag = true;

	return !flag;
}

void TCSuperSpiceDataBase::SetupFilePaths(CString &CFilePath)
{
	CString CUserName = GetInitName();

	CUserName += '\\';
	CSuperSpiceComponentFileNames.CSymbolPathName	 = CFilePath + CUserName;
	CSuperSpiceComponentFileNames.CModelPathName	 = CFilePath + CUserName;
	CSuperSpiceComponentFileNames.CComponentPathName = CFilePath + CUserName;

	CComponentFileNames.CSymbolPathName		= CFilePath + CUserName;
	CComponentFileNames.CModelPathName		= CFilePath + CUserName;
	CComponentFileNames.CComponentPathName	= CFilePath + CUserName;

	for(int p = E_GENERIC_2_COMPONENT; p < E_SYMBOL_INDUCTOR_SEMICIRCLE_COMPONENT; p++)
	{
		CMDefaults[p].CSymbolData.CFilePath = CFilePath + CUserName; 
		CMDefaults[p].CSymbolData.CChildFileName = CFilePath + CUserName;
	}
}

void TCSuperSpiceDataBase::SetupComponentFileNames(void)
{
	CString &CFileName = CSuperSpiceComponentFileNames.CSymbolFileName;
	CString &CFilePath = CSuperSpiceComponentFileNames.CSymbolPathName;

	int count = CMDefaults.GetSize();

	for(int p = 0; p < count; p++)
	{
		CMDefaults[p].CSymbolData.CFileName = CFileName;
		CMDefaults[p].CSymbolData.CFilePath = CFilePath;
	}
}

			
bool TCSuperSpiceDataBase::SaveSuperSpiceSymbols(void)
{
	int p, count;

	CFile CDataFile;

	CString CFileName = CSuperSpiceComponentFileNames.CSymbolPathName +
		                 CSuperSpiceComponentFileNames.CSymbolFileName;

	if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite)) return false;

	CArchive CArchiveFile(&CDataFile, CArchive::store);

	try
	{
		CArchiveFile.SerializeClass(RUNTIME_CLASS(TCSymbolDataBaseDataList));
	}
	catch(...)
	{
		_fpreset();

		return false;
	}

	count = CMDefaults.GetSize();

	CArchiveFile << count;

	for(p = 0; p < count; p++)
	{
		CMDefaults[p].Serialize(CArchiveFile);
	}

	return true;
}

bool TCSuperSpiceDataBase::LoadSuperSpiceSymbols(void)
{
	int p, count, count2;

	CFile CDataFile;

	CString CPath, CName, CDummy;

	CPath = CSuperSpiceComponentFileNames.CSymbolPathName;
	CName = CSuperSpiceComponentFileNames.CSymbolFileName;

	CString CModelPath = CSuperSpiceComponentFileNames.CModelPathName;
	CString CModelFileName = CSuperSpiceComponentFileNames.CModelFileName;

	CString CFileName = CPath + CName;

	if(!CDataFile.Open(CFileName, CFile::modeRead | CFile::shareDenyNone)) return false;

	CArchive CArchiveFile(&CDataFile, CArchive::load);

	try
	{
		CArchiveFile.SerializeClass(RUNTIME_CLASS(TCSymbolDataBaseDataList));
	}
	catch(...)
	{
		_fpreset();

		return false;
	}

	count = CMDefaults.GetSize();

	CArchiveFile >> count2;

	TCSchematicObjectData CSchematicObjectData;

	for(p = 0; p < count; p++)
	{
		if(p == E_WAVEFORM_COMPONENT)
		{
			CSchematicObjectData.Serialize(CArchiveFile);

			continue;
		}

		CMDefaults[p].Serialize(CArchiveFile);

		CMDefaults[p].CSymbolData.CFilePath = CPath;
		CMDefaults[p].CSymbolData.CFileName = CName;
	}

	return true;
}

bool TCSuperSpiceDataBase::SaveSymbolsList(void)
{
	CString CFileName = CComponentFileNames.CSymbolPathName +
			            CComponentFileNames.CSymbolFileName;

	return SaveGenericToArchive(&CSymbolDataBase, CFileName);
}
bool TCSuperSpiceDataBase::LoadSymbolsList(void)
{
	CString CFileName = CComponentFileNames.CSymbolPathName +
			            CComponentFileNames.CSymbolFileName;

	return LoadGenericFromArchive(&CSymbolDataBase, CFileName);
}
bool TCSuperSpiceDataBase::SaveModelsList(void)
{
	CString CFileName = CComponentFileNames.CModelPathName +
			            CComponentFileNames.CModelFileName;

	return SaveGenericToArchive(&CModelDataBase, CFileName);
}
bool TCSuperSpiceDataBase::LoadModelsList(void)
{
	CString CFileName = CComponentFileNames.CModelPathName +
			            CComponentFileNames.CModelFileName;

	return LoadGenericFromArchive(&CModelDataBase, CFileName);
}

bool TCSuperSpiceDataBase::AddDefaultSuperSpiceModels(void)
{
	// if no default init found try an load intrinsic superspice models

	CString CFileName = CSuperSpiceComponentFileNames.CModelPathName +
			            CSuperSpiceComponentFileNames.CModelFileName;

	AddModelFile(CFileName);

	// now get and add list of shipped symbols

	CString CFileNameList = CSuperSpiceComponentFileNames.CModelPathName + CTextModelList;

	if(!FileExists(CFileNameList)) return true;

	CString CFilePath = GetSuperSpiceSystemDir();

	ifstream CTextFile;
	CString CTextLine;

	char *buff = new char[2048];

	if(!buff) return false;

	CTextFile.open(CFileNameList, ios::in);

	if(CTextFile.fail()) 
	{
		delete [] buff;

		return false;
	}

	while(!CTextFile.eof())
	{
		CTextFile.getline(buff, 2046);
	
		CTextLine = buff;

		CTextLine.TrimLeft();
		CTextLine.TrimRight();

		CFileName = CFilePath + CTextLine;

		if(!FileExists(CFileName)) continue;

		AddModelFile(CFileName);
	}

	delete [] buff;

	return true;
}

bool TCSuperSpiceDataBase::AddDefaultSuperSpiceSymbols(void)
{
	// get and add list of shipped symbols

	CString CFileName;

	CString CFileNameList = CSuperSpiceComponentFileNames.CSymbolPathName + CTextSymbolList;

	if(!FileExists(CFileNameList)) return true;

	CString CFilePath = GetSuperSpiceSystemDir();

	ifstream CTextFile;
	CString CTextLine;

	char *buff = new char[2048];

	if(!buff) return false;

	CTextFile.open(CFileNameList, ios::in);

	if(CTextFile.fail()) 
	{
		delete [] buff;

		return false;
	}

	while(!CTextFile.eof())
	{
		CTextFile.getline(buff, 2046);
	
		CTextLine = buff;

		CTextLine.TrimLeft();
		CTextLine.TrimRight();

		CFileName = CFilePath + CTextLine;

		if(!FileExists(CFileName)) continue;

		AddSymbolFile(CFileName);
	}

	delete [] buff;

	return true;
}

bool TCSuperSpiceDataBase::AddDefaultSuperSpiceCircuits(void)
{
	// get and add list of shipped circuits

	CString CFileName;

	CString CFileNameList = CSuperSpiceComponentFileNames.CComponentPathName + CTextCircuitsList;

	if(!FileExists(CFileNameList)) return true;

	CString CFilePath = GetSuperSpiceSystemDir();

	ifstream CTextFile;
	CString CTextLine;

	char *buff = new char[2048];

	if(!buff) return false;

	CTextFile.open(CFileNameList, ios::in);

	if(CTextFile.fail()) 
	{
		delete [] buff;

		return false;
	}

	while(!CTextFile.eof())
	{
		CTextFile.getline(buff, 2046);
	
		CTextLine = buff;

		CTextLine.TrimLeft();
		CTextLine.TrimRight();

		CFileName = CFilePath + CTextLine;

		AddCircuitsFile(CFileName); // if no files in that directory will not add
	}

	delete [] buff;

	return true;
}

bool TCSuperSpiceDataBase::SaveCircuitsList(void)
{
	CString CFileName = CComponentFileNames.CComponentPathName +
			            CComponentFileNames.CComponentFileName;

	return SaveGenericToArchive(&CCircuitsDataBase, CFileName);
}

bool TCSuperSpiceDataBase::LoadCircuitsList(void)
{
	CString CFileName = CComponentFileNames.CComponentPathName +
			            CComponentFileNames.CComponentFileName;

	return LoadGenericFromArchive(&CCircuitsDataBase, CFileName);
}

bool TCSuperSpiceDataBase::SaveSymbols(void)
{
	return CSymbolDataBase.Save();
}
bool TCSuperSpiceDataBase::LoadSymbols(void)
{
	return CSymbolDataBase.Load();
}
bool TCSuperSpiceDataBase::SaveModels(void)
{
	return CModelDataBase.Save();
}
bool TCSuperSpiceDataBase::LoadModels(void)
{
	return CModelDataBase.Load();
}
bool TCSuperSpiceDataBase::SaveCircuits(void)
{
	return CCircuitsDataBase.Save();
}
bool TCSuperSpiceDataBase::LoadCircuits(void)
{
	return CCircuitsDataBase.Load();
}

TCSuperSpiceDataBase::~TCSuperSpiceDataBase(void)
{

}

TCSuperSpiceDataBase::TCSuperSpiceDataBase(void)
{
	CMDefaults.SetSize(E_MAX_COMPONENT, E_MAX_COMPONENT);
	CReferanceDesignator.SetSize(E_MAX_COMPONENT, E_MAX_COMPONENT);

	CSuperSpiceModelLibName		= "SuperSpice.lib";
	CSuperSpiceSymbolLibName	= "SuperSpice.ssm";
	CSuperSpiceSymbolListName	= "SuperSpice.ssl";
	CSuperSpiceModelListName	= "SuperSpice.sml";
	CSuperSpiceComponentListName= "SuperSpice.skl";
	CSuperSpiceNameCircuits		= "SuperSpice.ssc";
	CTextModelList				= "SuperSpiceModelList.txt";			
	CTextSymbolList				= "SuperSpiceSymbolList.txt";
	CTextCircuitsList			= "SuperSpiceCircuitList.txt";
	CSuperSpiceDataBaseName		= "SuperSpice.sdb";
	CSuperSpiceClipboardName	= "SuperSpice.scb";
	CSuperSpiceFilterName		= "SuperSpice.sff";
	CSuperSpiceEquationsName	= "SuperSpice.sef";
	CSuperSpiceInitName         = "SuperSpice.ssi";
	CParamDefsFileName			= "Parameters.lib";// Look in default <system> folder for parameters.lib
	CParamDefsModelName			= "ParamDefs_xn"; // default, changable by user

#ifdef RELEASE_OEM1
	CSuperSpiceModelLibName		= "MEMSystem.lib";
	CSuperSpiceSymbolLibName	= "MEMSystem.ssm";
	CSuperSpiceSymbolListName	= "MEMSystem.ssl";
	CSuperSpiceModelListName	= "MEMSystem.sml";
	CSuperSpiceComponentListName= "MEMSystem.skl";
	CSuperSpiceNameCircuits		= "MEMSystem.ssc";
	CTextModelList				= "MEMSystemModelList.txt";			
	CTextSymbolList				= "MEMSystemSymbolList.txt";
	CTextCircuitsList			= "MEMSystemCircuitList.txt";
	CSuperSpiceDataBaseName		= "MEMSystem.sdb";
	CSuperSpiceClipboardName	= "MEMSystem.scb";
	CSuperSpiceFilterName		= "MEMSystem.sff";
	CSuperSpiceEquationsName	= "MEMSystem.sef";
	CSuperSpiceInitName         = "MEMSystem.ssi";
#endif

	GCSuperSpiceGlobalData.CGeneric.CComponentPropertyCurrentPin.SetSize(E_MAX_COMPONENT);
}

void TCSuperSpiceDataBase::Init(void)
{
	CString CModelType = "MODEL";
	component_scale = 2.0;// used later, where the fuck is the m_ ?

	CComponentFileNames.CSymbolFileName		= CSuperSpiceSymbolListName;//Superspice Symbol List
	CComponentFileNames.CModelFileName		= CSuperSpiceModelListName;//Superspice Model List
	CComponentFileNames.CComponentFileName	= CSuperSpiceComponentListName;//Superspice component List

	CSuperSpiceComponentFileNames.CSymbolFileName		= CSuperSpiceSymbolLibName;//Superspice Symbol 
	CSuperSpiceComponentFileNames.CModelFileName		= CSuperSpiceModelLibName;//Superspice model libaray 
	CSuperSpiceComponentFileNames.CComponentFileName	= CSuperSpiceNameCircuits;//Superspice circuits, changed from components 
	
	CString &CFileName = CSuperSpiceComponentFileNames.CSymbolFileName;

	int p;

	for(int p = 0; p < E_MAX_COMPONENT; p++)
	{
		CReferanceDesignator[p] = "X";

		TCSchematicObjectData &CLSchematicObjectData = CMDefaults[p];

		CLSchematicObjectData.CReserved.CStringArray.SetSize(E_RESERVED_SCHEMATIC_OBJECT_DATA_MAX);// PCB Package type and name
		CLSchematicObjectData.CReserved.CIntArray.SetSize(E_RESERVED_INT_COMPONENT_DATA_MAX);// PCB Package, incude in netlist

		CLSchematicObjectData.CReserved.CStringArray[E_RESERVED_PCB_PACKAGE_NAME] = "SMD";
		CLSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_PCB_INCLUDE]		= true;
		CLSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_SPICE_INCLUDE]	= true;
		CLSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_POWER]	= 0;
		CLSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_TRANSIENT_POWER] = 0;
		

		CLSchematicObjectData.attached_model_type = E_SPICE_DOT_MODEL;

		CLSchematicObjectData.CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER, E_COMPONENT_MAX_LABEL_NUMBER);

		CLSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabelType = "Device Type";
		CLSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only = true;
		CLSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabelType = "Spice Name";
		CLSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabelType = "Value";
		CLSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabelType = "RefDes";
		CLSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only	= true;
		CLSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].read_only = true;

		CLSchematicObjectData.CSymbolData.CFileName	= CFileName;
	}

	for(p = E_GENERIC_2_COMPONENT; p < E_SYMBOL_INDUCTOR_SEMICIRCLE_COMPONENT; p++)
	{
		CMDefaults[p].attached_model_type = E_SPICE_SCHEMATIC;
		CMDefaults[p].CSpiceParameters.CDataBaseIdInfo.CModelType = "";
		CMDefaults[p].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_SCHEMATIC;
	}


	CReferanceDesignator[E_URC_TRANSMISSION_LINE] = "U";

	CReferanceDesignator[E_XSPICE_DIGITAL]			= "A";
	CMDefaults[E_XSPICE_DIGITAL].attached_model_type	= E_SPICE_DOT_MODEL;
	CMDefaults[E_XSPICE_DIGITAL].type = E_SPICE_XSPICE_DIGITAL;
	CMDefaults[E_XSPICE_DIGITAL].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_XSPICE_DIGITAL].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_XSPICE_DIGITAL].CSpiceParameters.CDataBaseIdInfo.CRecordType = "A";
	CMDefaults[E_XSPICE_DIGITAL].component_property_view_type = E_PROPERTY_GENERIC_MODEL;

	CReferanceDesignator[E_LAPLACE_TRANSFORM]			= "A";
	CMDefaults[E_LAPLACE_TRANSFORM].attached_model_type	= E_SPICE_DOT_MODEL;
	CMDefaults[E_LAPLACE_TRANSFORM].type = E_LAPLACE_TRANSFORM;
	CMDefaults[E_LAPLACE_TRANSFORM].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_LAPLACE_TRANSFORM].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_LAPLACE_TRANSFORM].CSpiceParameters.CDataBaseIdInfo.CRecordType = "s_xfer";
	CMDefaults[E_LAPLACE_TRANSFORM].component_property_view_type = E_PROPERTY_LAPLACE_TRANSFORM;
	CMDefaults[E_LAPLACE_TRANSFORM].CLabelListData.SetSize(E_COMPONENT_LAPLACE_NORMALISED_FREQUENCY + 1);
	CMDefaults[E_LAPLACE_TRANSFORM].CLabelListData[E_COMPONENT_LAPLACE_NUMERATOR].CLabelType = "N";
	CMDefaults[E_LAPLACE_TRANSFORM].CLabelListData[E_COMPONENT_LAPLACE_DENOMINATOR].CLabelType = "D";
	CMDefaults[E_LAPLACE_TRANSFORM].CLabelListData[E_COMPONENT_LAPLACE_NORMALISED_FREQUENCY].CLabelType = "Ref.Freq.";
	CMDefaults[E_LAPLACE_TRANSFORM].CLabelListData[E_COMPONENT_LAPLACE_GAIN].CLabelType = "Gain";
	CMDefaults[E_LAPLACE_TRANSFORM].CLabelListData[E_COMPONENT_LAPLACE_NORMALISED_FREQUENCY].CLabelValue = "1";
	CMDefaults[E_LAPLACE_TRANSFORM].CLabelListData[E_COMPONENT_LAPLACE_GAIN].CLabelValue = "1";
	CMDefaults[E_LAPLACE_TRANSFORM].CLabelListData[E_COMPONENT_LAPLACE_NUMERATOR].CLabelValue = "1";
	CMDefaults[E_LAPLACE_TRANSFORM].CLabelListData[E_COMPONENT_LAPLACE_DENOMINATOR].CLabelValue = "s + 1";
	CMDefaults[E_LAPLACE_TRANSFORM].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "Laplace";
	CMDefaults[E_LAPLACE_TRANSFORM].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Laplace Transform";
	CMDefaults[E_LAPLACE_TRANSFORM].CLabelListData[E_COMPONENT_VALUE].CLabel = "Laplace";
	CMDefaults[E_LAPLACE_TRANSFORM].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "A?";
	CMDefaults[E_LAPLACE_TRANSFORM].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_LAPLACE_TRANSFORM].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_LAPLACE_TRANSFORM].CPinListData.SetSize(2, 2);
	CMDefaults[E_LAPLACE_TRANSFORM].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_LAPLACE_TRANSFORM].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_LAPLACE_TRANSFORM].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "in";
	CMDefaults[E_LAPLACE_TRANSFORM].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_LAPLACE_TRANSFORM].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_LAPLACE_TRANSFORM].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_LAPLACE_TRANSFORM].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "out";
	CMDefaults[E_LAPLACE_TRANSFORM].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_LAPLACE_TRANSFORM].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_LAPLACE_TRANSFORM].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_LAPLACE_TRANSFORM].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].connection_type = E_SCHEMATIC_PIN_ANALOGUE_INPUT;
	CMDefaults[E_LAPLACE_TRANSFORM].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].connection_type = E_SCHEMATIC_PIN_ANALOGUE_OUTPUT;

	CReferanceDesignator[E_NONLINEAR_DEPENDANT_SOURCE]	= "B";

	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].component_property_view_type = E_PROPERTY_CONTROLED_SOURCE;
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CSpiceParameters.CDataBaseIdInfo.CRecordType = "B";	
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].f_validate_label_value = false;
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CLabelListData.SetSize(E_COMPONENT_CONTROLLED_SOURCE_PARAMETERS + 1);
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Nonlinear Controlled Source";
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "NonlinearControlledSource";
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CLabelListData[E_COMPONENT_VALUE].CLabel = "NonlinearControlledSource";
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "B?";
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CLabelListData[E_COMPONENT_CONTROLLED_SOURCE_PARAMETERS].is_visable = false;
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData.SetSize(4, 4);
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "o1";
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "o2";
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].connection_type = E_SCHEMATIC_PIN_ANALOGUE_INPUT;
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].connection_type = E_SCHEMATIC_PIN_ANALOGUE_INPUT;
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].connection_type = E_SCHEMATIC_PIN_ANALOGUE_OUTPUT;
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].connection_type = E_SCHEMATIC_PIN_ANALOGUE_OUTPUT;


	CReferanceDesignator[E_LOSSLESS_TRANSMISSION_LINE_COMPONENT] = "T";
	CMDefaults[E_LOSSLESS_TRANSMISSION_LINE_COMPONENT].attached_model_type	= E_SPICE_DOT_MODEL;
	CMDefaults[E_LOSSLESS_TRANSMISSION_LINE_COMPONENT].type = E_LOSSLESS_TRANSMISSION_LINE_COMPONENT;
	CMDefaults[E_LOSSLESS_TRANSMISSION_LINE_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_LOSSLESS_TRANSMISSION_LINE_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_LOSSLESS_TRANSMISSION_LINE_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "T";
	CMDefaults[E_LOSSLESS_TRANSMISSION_LINE_COMPONENT].component_property_view_type = E_PROPERTY_GENERIC_MODEL;

	CReferanceDesignator[E_SUBCIRCUIT_COMPONENT] = "X";
	CMDefaults[E_SUBCIRCUIT_COMPONENT].attached_model_type	= E_SUBCIRCUIT_COMPONENT;
	CMDefaults[E_SUBCIRCUIT_COMPONENT].type = E_SUBCIRCUIT_COMPONENT;
	CMDefaults[E_SUBCIRCUIT_COMPONENT].component_property_view_type = E_PROPERTY_SUBCIRCUIT;
	CMDefaults[E_SUBCIRCUIT_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_SUBCIRCUIT_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;

	CMDefaults[E_WAVEFORM_COMPONENT].CLabelListData.SetSize(E_WAVEFORM_ENABLE + 1);
	CMDefaults[E_WAVEFORM_COMPONENT].CLocation.x = 96;
	CMDefaults[E_WAVEFORM_COMPONENT].CLocation.y = 96;
	CMDefaults[E_WAVEFORM_COMPONENT].width	= 1000;
	CMDefaults[E_WAVEFORM_COMPONENT].height = 700;
	CMDefaults[E_WAVEFORM_COMPONENT].PCOutputWaveformDataHeader = new TCOutputWaveformDataHeader;
	CMDefaults[E_WAVEFORM_COMPONENT].CLabelListData[E_WAVEFORM_TITLE].CLabel = "(Untitled";
	CMDefaults[E_WAVEFORM_COMPONENT].CLabelListData[E_WAVEFORM_TITLE].read_only = false;
	CMDefaults[E_WAVEFORM_COMPONENT].CLabelListData[E_WAVEFORM_PLOT_NAME].CLabel = "(NULL)";
	CMDefaults[E_WAVEFORM_COMPONENT].CLabelListData[E_WAVEFORM_PLOT_NAME].read_only = true;
	CMDefaults[E_WAVEFORM_COMPONENT].CLabelListData[E_WAVEFORM_DATE_AND_TIME].CLabel = "(NULL)";
	CMDefaults[E_WAVEFORM_COMPONENT].CLabelListData[E_WAVEFORM_DATE_AND_TIME].read_only = true;
	CMDefaults[E_WAVEFORM_COMPONENT].CLabelListData[E_WAVEFORM_ENABLE].CLabel = "Inactive";
	CMDefaults[E_WAVEFORM_COMPONENT].CLabelListData[E_WAVEFORM_ENABLE].read_only = true;

	CMDefaults[E_WAVEFORM_COMPONENT].format_spice_value = false;
	CReferanceDesignator[E_WAVEFORM_COMPONENT] = "W";

	if(CMDefaults[E_WAVEFORM_COMPONENT].PCOutputWaveformDataHeader)
	{
		TCOutputWaveformDataHeader &COutputWaveformDataHeader = *CMDefaults[E_WAVEFORM_COMPONENT].PCOutputWaveformDataHeader;

		CMDefaults[E_WAVEFORM_COMPONENT].CLabelListData[E_WAVEFORM_TITLE].CLabel = COutputWaveformDataHeader.CTitle;
		CMDefaults[E_WAVEFORM_COMPONENT].CLabelListData[E_WAVEFORM_PLOT_NAME].CLabel = COutputWaveformDataHeader.CPlotName;
		CMDefaults[E_WAVEFORM_COMPONENT].CLabelListData[E_WAVEFORM_DATE_AND_TIME].CLabel = COutputWaveformDataHeader.CDateAndTime;
	}

	CMDefaults[E_WAVEFORM_COMPONENT].CLabelListData[E_WAVEFORM_TITLE].is_visable = true;
	CMDefaults[E_WAVEFORM_COMPONENT].CLabelListData[E_WAVEFORM_PLOT_NAME].is_visable = true;
	CMDefaults[E_WAVEFORM_COMPONENT].CLabelListData[E_WAVEFORM_DATE_AND_TIME].is_visable = true;
	CMDefaults[E_WAVEFORM_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "W1";
	CMDefaults[E_WAVEFORM_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_WAVEFORM_COMPONENT].CLabelListData[E_WAVEFORM_ENABLE].is_visable = true;

	CReferanceDesignator[E_WIRE_COMPONENT] = "Node";
	CMDefaults[E_WIRE_COMPONENT].attached_model_type  = 9;
	CMDefaults[E_WIRE_COMPONENT].type = E_WIRE_COMPONENT;
	CMDefaults[E_WIRE_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = "";
	CMDefaults[E_WIRE_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_WIRE_COMPONENT].CLabelListData[E_WIRE_NET_NAME].CLabel = "Node?";
	CMDefaults[E_WIRE_COMPONENT].CLabelListData[E_WIRE_NET_NAME].is_visable = true;
	CMDefaults[E_WIRE_COMPONENT].CLabelListData[E_WIRE_NET_VOLTAGE].CLabel = "?V";
	CMDefaults[E_WIRE_COMPONENT].CLabelListData[E_WIRE_NET_VOLTAGE].read_only = true;
	CMDefaults[E_WIRE_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_WIRE_COMPONENT].CLabelListData[E_WIRE_NET_CONNECTION_DOT1].CLabel = ".";
	CMDefaults[E_WIRE_COMPONENT].CLabelListData[E_WIRE_NET_CONNECTION_DOT2].CLabel = ".";
	CMDefaults[E_WIRE_COMPONENT].f_vector_graphic = true;//added 27 Aug 2002 for decompile of symbols
	
	CMDefaults[E_SYMBOL_POINTING_UP_PIN_COMPONENT].attached_model_type  = 9;
	CMDefaults[E_SYMBOL_POINTING_UP_PIN_COMPONENT].type = E_SYMBOL_POINTING_UP_PIN_COMPONENT;
	CMDefaults[E_SYMBOL_POINTING_UP_PIN_COMPONENT].format_spice_value = false;
	CMDefaults[E_SYMBOL_POINTING_UP_PIN_COMPONENT].attached_model_type  = 9;
	CMDefaults[E_SYMBOL_POINTING_UP_PIN_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = "";
	CMDefaults[E_SYMBOL_POINTING_UP_PIN_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_SYMBOL_POINTING_UP_PIN_COMPONENT].CPinListData.SetSize(1, 1);
	CMDefaults[E_SYMBOL_POINTING_UP_PIN_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_SYMBOL_POINTING_UP_PIN_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "UPin";

	CMDefaults[E_SYMBOL_POINTING_DOWN_PIN_COMPONENT].attached_model_type  = 9;
	CMDefaults[E_SYMBOL_POINTING_DOWN_PIN_COMPONENT].type = E_SYMBOL_POINTING_DOWN_PIN_COMPONENT;
	CMDefaults[E_SYMBOL_POINTING_DOWN_PIN_COMPONENT].format_spice_value = false;
	CMDefaults[E_SYMBOL_POINTING_DOWN_PIN_COMPONENT].attached_model_type  = 9;
	CMDefaults[E_SYMBOL_POINTING_DOWN_PIN_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = "";
	CMDefaults[E_SYMBOL_POINTING_DOWN_PIN_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_SYMBOL_POINTING_DOWN_PIN_COMPONENT].CPinListData.SetSize(1, 1);
	CMDefaults[E_SYMBOL_POINTING_DOWN_PIN_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_SYMBOL_POINTING_DOWN_PIN_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "DPin";

	CMDefaults[E_SYMBOL_POINTING_LEFT_PIN_COMPONENT].attached_model_type  = 9;
	CMDefaults[E_SYMBOL_POINTING_LEFT_PIN_COMPONENT].type = E_SYMBOL_POINTING_LEFT_PIN_COMPONENT;
	CMDefaults[E_SYMBOL_POINTING_LEFT_PIN_COMPONENT].format_spice_value = false;
	CMDefaults[E_SYMBOL_POINTING_LEFT_PIN_COMPONENT].attached_model_type  = 9;
	CMDefaults[E_SYMBOL_POINTING_LEFT_PIN_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = "";
	CMDefaults[E_SYMBOL_POINTING_LEFT_PIN_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_SYMBOL_POINTING_LEFT_PIN_COMPONENT].CPinListData.SetSize(1, 1);
	CMDefaults[E_SYMBOL_POINTING_LEFT_PIN_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_SYMBOL_POINTING_LEFT_PIN_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "LPin";

	CMDefaults[E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT].attached_model_type  = 9;
	CMDefaults[E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT].type = E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT;
	CMDefaults[E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT].format_spice_value = false;
	CMDefaults[E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT].attached_model_type  = 9;
	CMDefaults[E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = "RPin";
	CMDefaults[E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT].CPinListData.SetSize(1, 1);
	CMDefaults[E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "";

	CMDefaults[E_SYMBOL_CURVE_COMPONENT].attached_model_type  = 9;
	CMDefaults[E_SYMBOL_CURVE_COMPONENT].type = E_SYMBOL_CURVE_COMPONENT;
	CMDefaults[E_SYMBOL_CURVE_COMPONENT].format_spice_value = false;
	CMDefaults[E_SYMBOL_CURVE_COMPONENT].attached_model_type  = 9;
	CMDefaults[E_SYMBOL_CURVE_COMPONENT].CLabelListData[E_COMPONENT_VALUE].is_visable = false;
	CMDefaults[E_SYMBOL_CURVE_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = "";
	CMDefaults[E_SYMBOL_CURVE_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_SYMBOL_CURVE_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Curve";
//	CMDefaults[E_SYMBOL_CURVE_COMPONENT].CPinListData.SetSize(1, 1);
//	CMDefaults[E_SYMBOL_CURVE_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);

	CMDefaults[E_CURVE_COMPONENT].type = E_CURVE_COMPONENT;
	CMDefaults[E_CURVE_COMPONENT].format_spice_value = false;
	CMDefaults[E_CURVE_COMPONENT].attached_model_type  = 9;

	CReferanceDesignator[E_LABEL_COMPONENT] = "";
	CMDefaults[E_LABEL_COMPONENT].attached_model_type  = 9;
	CMDefaults[E_LABEL_COMPONENT].type = E_LABEL_COMPONENT;
	CMDefaults[E_LABEL_COMPONENT].CLabelListData[E_COMPONENT_VALUE].is_visable = false;
	CMDefaults[E_LABEL_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = "";
	CMDefaults[E_LABEL_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_LABEL_COMPONENT].CLabel = "SuperSpice";
	CMDefaults[E_LABEL_COMPONENT].format_spice_value = false;

	CReferanceDesignator[E_GROUND] = "G";
	CMDefaults[E_GROUND].attached_model_type  = 9;
	CMDefaults[E_GROUND].type = E_GROUND;
	CMDefaults[E_GROUND].component_property_view_type = E_PROPERTY_CONNECTORS;
	CMDefaults[E_GROUND].CSpiceParameters.CDataBaseIdInfo.CModelType = "";
	CMDefaults[E_GROUND].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_GROUND].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "0";
	CMDefaults[E_GROUND].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "GROUND";
	CMDefaults[E_GROUND].CLabelListData[E_COMPONENT_VALUE].CLabel = "NA";
	CMDefaults[E_GROUND].CLabelListData[E_COMPONENT_VALUE].is_visable = false;
	CMDefaults[E_GROUND].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "G0";
	CMDefaults[E_GROUND].CPinListData.SetSize(1, 1);
	CMDefaults[E_GROUND].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_GROUND].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel = "0";
//	CMDefaults[E_GROUND].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].read_only = true;
	CMDefaults[E_GROUND].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "GND";
	CMDefaults[E_GROUND].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "0";
	CMDefaults[E_GROUND].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "0V";
	CMDefaults[E_GROUND].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?!";
//	CMDefaults[E_GROUND].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].read_only = true;

	CReferanceDesignator[E_PAGE_CONNECTER_INPUT] = "CONT";
	CMDefaults[E_PAGE_CONNECTER_INPUT].attached_model_type  = 9;
	CMDefaults[E_PAGE_CONNECTER_INPUT].type = E_PAGE_CONNECTER_INPUT;
	CMDefaults[E_PAGE_CONNECTER_INPUT].component_property_view_type = E_PROPERTY_CONNECTORS;
	CMDefaults[E_PAGE_CONNECTER_INPUT].CSpiceParameters.CDataBaseIdInfo.CModelType = "";
	CMDefaults[E_PAGE_CONNECTER_INPUT].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_PAGE_CONNECTER_INPUT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "NA";
	CMDefaults[E_PAGE_CONNECTER_INPUT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Input Page Connector";
 	CMDefaults[E_PAGE_CONNECTER_INPUT].CLabelListData[E_COMPONENT_VALUE].CLabel = "NA";
	CMDefaults[E_PAGE_CONNECTER_INPUT].CLabelListData[E_COMPONENT_VALUE].is_visable = false;
	CMDefaults[E_PAGE_CONNECTER_INPUT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "TSTV?";
 	CMDefaults[E_PAGE_CONNECTER_INPUT].CPinListData.SetSize(1, 1);
	CMDefaults[E_PAGE_CONNECTER_INPUT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PAGE_CONNECTER_INPUT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "";
	CMDefaults[E_PAGE_CONNECTER_INPUT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_PAGE_CONNECTER_INPUT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PAGE_CONNECTER_INPUT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PAGE_CONNECTER_INPUT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel = "Name?";
	CMDefaults[E_PAGE_CONNECTER_INPUT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].is_visable = true;

	CReferanceDesignator[E_PAGE_CONNECTER_OUTPUT] = "CONT";
	CMDefaults[E_PAGE_CONNECTER_OUTPUT].attached_model_type  = 9;
	CMDefaults[E_PAGE_CONNECTER_OUTPUT].type = E_PAGE_CONNECTER_OUTPUT;
	CMDefaults[E_PAGE_CONNECTER_OUTPUT].component_property_view_type = E_PROPERTY_CONNECTORS;
	CMDefaults[E_PAGE_CONNECTER_OUTPUT].CSpiceParameters.CDataBaseIdInfo.CModelType = "";
	CMDefaults[E_PAGE_CONNECTER_OUTPUT].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_PAGE_CONNECTER_OUTPUT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "NA";
	CMDefaults[E_PAGE_CONNECTER_OUTPUT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Output Page Connector";
 	CMDefaults[E_PAGE_CONNECTER_OUTPUT].CLabelListData[E_COMPONENT_VALUE].CLabel = "N/A";
	CMDefaults[E_PAGE_CONNECTER_OUTPUT].CLabelListData[E_COMPONENT_VALUE].is_visable = false;
	CMDefaults[E_PAGE_CONNECTER_OUTPUT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "TSTV?";
	CMDefaults[E_PAGE_CONNECTER_OUTPUT].CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = false;
	CMDefaults[E_PAGE_CONNECTER_OUTPUT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = false;
 	CMDefaults[E_PAGE_CONNECTER_OUTPUT].CPinListData.SetSize(1, 1);
	CMDefaults[E_PAGE_CONNECTER_OUTPUT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PAGE_CONNECTER_OUTPUT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "CP";
	CMDefaults[E_PAGE_CONNECTER_OUTPUT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_PAGE_CONNECTER_OUTPUT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PAGE_CONNECTER_OUTPUT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PAGE_CONNECTER_OUTPUT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel = "Name?";
	CMDefaults[E_PAGE_CONNECTER_OUTPUT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].is_visable = true;

	CReferanceDesignator[E_PAGE_CONNECTER_BIDIRECTIONAL] = "CONT";
	CMDefaults[E_PAGE_CONNECTER_BIDIRECTIONAL].attached_model_type  = 9;
	CMDefaults[E_PAGE_CONNECTER_BIDIRECTIONAL].type = E_PAGE_CONNECTER_BIDIRECTIONAL;
	CMDefaults[E_PAGE_CONNECTER_BIDIRECTIONAL].component_property_view_type = E_PROPERTY_CONNECTORS;
	CMDefaults[E_PAGE_CONNECTER_BIDIRECTIONAL].CSpiceParameters.CDataBaseIdInfo.CModelType = "";
	CMDefaults[E_PAGE_CONNECTER_BIDIRECTIONAL].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_PAGE_CONNECTER_BIDIRECTIONAL].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "NA";
	CMDefaults[E_PAGE_CONNECTER_BIDIRECTIONAL].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "In/Out Page Connector";
 	CMDefaults[E_PAGE_CONNECTER_BIDIRECTIONAL].CLabelListData[E_COMPONENT_VALUE].CLabel = "N/A";
	CMDefaults[E_PAGE_CONNECTER_BIDIRECTIONAL].CLabelListData[E_COMPONENT_VALUE].is_visable = false;
	CMDefaults[E_PAGE_CONNECTER_BIDIRECTIONAL].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "TSTV?";
 	CMDefaults[E_PAGE_CONNECTER_BIDIRECTIONAL].CPinListData.SetSize(1, 1);
	CMDefaults[E_PAGE_CONNECTER_BIDIRECTIONAL].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PAGE_CONNECTER_BIDIRECTIONAL].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "CP";
	CMDefaults[E_PAGE_CONNECTER_BIDIRECTIONAL].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_PAGE_CONNECTER_BIDIRECTIONAL].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PAGE_CONNECTER_BIDIRECTIONAL].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PAGE_CONNECTER_BIDIRECTIONAL].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel = "Name?";
	CMDefaults[E_PAGE_CONNECTER_BIDIRECTIONAL].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].is_visable = true;

	CReferanceDesignator[E_SUBCIRCUIT_PIN_CONNECTER] = "SUBCNT";
	CMDefaults[E_SUBCIRCUIT_PIN_CONNECTER].attached_model_type  = 9;
	CMDefaults[E_SUBCIRCUIT_PIN_CONNECTER].format_spice_value = false;
	CMDefaults[E_SUBCIRCUIT_PIN_CONNECTER].type = E_PAGE_CONNECTER_INPUT;
	CMDefaults[E_SUBCIRCUIT_PIN_CONNECTER].component_property_view_type = E_PROPERTY_SUBCIRCUIT_PIN_CONNECTORS;
	CMDefaults[E_SUBCIRCUIT_PIN_CONNECTER].CSpiceParameters.CDataBaseIdInfo.CModelType = "";
	CMDefaults[E_SUBCIRCUIT_PIN_CONNECTER].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_SUBCIRCUIT_PIN_CONNECTER].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "NA";
	CMDefaults[E_SUBCIRCUIT_PIN_CONNECTER].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Subcircuit Connector";
 	CMDefaults[E_SUBCIRCUIT_PIN_CONNECTER].CLabelListData[E_COMPONENT_VALUE].CLabel = "#";
	CMDefaults[E_SUBCIRCUIT_PIN_CONNECTER].CLabelListData[E_COMPONENT_VALUE].is_visable = false;
	CMDefaults[E_SUBCIRCUIT_PIN_CONNECTER].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "";
 	CMDefaults[E_SUBCIRCUIT_PIN_CONNECTER].CPinListData.SetSize(1, 1);
	CMDefaults[E_SUBCIRCUIT_PIN_CONNECTER].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_SUBCIRCUIT_PIN_CONNECTER].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "";
	CMDefaults[E_SUBCIRCUIT_PIN_CONNECTER].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_SUBCIRCUIT_PIN_CONNECTER].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_SUBCIRCUIT_PIN_CONNECTER].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_SUBCIRCUIT_PIN_CONNECTER].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel = "Name?";
	CMDefaults[E_SUBCIRCUIT_PIN_CONNECTER].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].is_visable = true;


	CReferanceDesignator[E_TITLE_BLOCK] = "%";
	CMDefaults[E_TITLE_BLOCK].attached_model_type  = 9;

	CMDefaults[E_TITLE_BLOCK].type = E_TITLE_BLOCK;
	CMDefaults[E_TITLE_BLOCK].format_spice_value = false;
	CMDefaults[E_TITLE_BLOCK].f_validate_label_value = false;
	CMDefaults[E_TITLE_BLOCK].component_property_view_type = E_PROPERTY_TITLE_BLOCK;
	CMDefaults[E_TITLE_BLOCK].CSpiceParameters.CDataBaseIdInfo.CModelType = "";
	CMDefaults[E_TITLE_BLOCK].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_TITLE_BLOCK].CLabelListData.SetSize(E_TITLE_BLOCK_OFN + 1);
	CMDefaults[E_TITLE_BLOCK].CSpiceParameters.use_model = false;
	
	for(p = 0; p < E_TITLE_BLOCK_OFN + 1; p++) CMDefaults[E_TITLE_BLOCK].CLabelListData[p].is_visable = true;
	
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_TITLE_HEADER].CLabel = "Title:";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_TITLE].CLabel = "Your Schematic Title";
 	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_FILE_NAME_HEADER].CLabel = "File Name:";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_FILE_NAME].CLabel = "Schematic.sss";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_DESIGNER_HEADER].CLabel = "Designer:";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_DESIGNER].CLabel = "Kevin Aylward";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_CREATED_HEADER].CLabel = "Created:";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_CREATED].CLabel = "1/1/2000";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_DRAWN_HEADER].CLabel = "Drawn by:";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_DRAWN].CLabel = "Kevin Aylward";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_DISCRIPTION_HEADER].CLabel = "Description:";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_DISCRIPTION1].CLabel = "Description line one";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_DISCRIPTION2].CLabel = "Description line two";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_SIZE_HEADER].CLabel = "Page size:";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_SIZE].CLabel = "A";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_DOC_NUMBER_HEADER].CLabel = "Document Number";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_DOC_NUMBER].CLabel = "ABC-01-01-01";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_REV_HEADER].CLabel = "Rev.";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_REV].CLabel = "1.0";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_DATE_HEADER].CLabel = "Date:";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_DATE].CLabel = "1st. Jan. 2002";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_SHEET].CLabel = "Sheet";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_NOF].CLabel = "1";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_OF].CLabel = "of";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_OFN].CLabel = "1";
	CMDefaults[E_TITLE_BLOCK].CLabelListData[E_TITLE_BLOCK_REFDES].is_visable = false;
	CMDefaults[E_TITLE_BLOCK].CReserved.CIntArray.SetSize(E_RESERVED_INT_COMPONENT_DATA_MAX);
	CMDefaults[E_TITLE_BLOCK].CReserved.CStringArray.SetSize(E_RESERVED_SCHEMATIC_OBJECT_DATA_MAX);
	CMDefaults[E_TITLE_BLOCK].CReserved.CIntArray[E_RESERVED_INT_COMPONENT_PCB_INCLUDE] = 0;// do not include in spice netlist
	CMDefaults[E_TITLE_BLOCK].CReserved.CIntArray[E_RESERVED_INT_COMPONENT_SPICE_INCLUDE] = 0;// do not include in pcb netlist
	CMDefaults[E_TITLE_BLOCK].CReserved.CIntArray[E_RESERVED_INT_COMPONENT_POWER] = 0;
	CMDefaults[E_TITLE_BLOCK].CReserved.CIntArray[E_RESERVED_INT_COMPONENT_TRANSIENT_POWER] = 0;

	CReferanceDesignator[E_TEST_MARKER] = "TST";
	CMDefaults[E_TEST_MARKER].attached_model_type  = 9;
	CMDefaults[E_TEST_MARKER].version  = E_TEST_POINT_MAGDEG;
	CMDefaults[E_TEST_MARKER].type = E_TEST_MARKER;
	CMDefaults[E_TEST_MARKER].component_property_view_type = E_PROPERTY_TEST_MARKERS;
	CMDefaults[E_TEST_MARKER].CSpiceParameters.CDataBaseIdInfo.CModelType = "";
	CMDefaults[E_TEST_MARKER].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_TEST_MARKER].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "N/A";
	CMDefaults[E_TEST_MARKER].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "VM";
 	CMDefaults[E_TEST_MARKER].CLabelListData[E_COMPONENT_VALUE].CLabel = "N/A";
	CMDefaults[E_TEST_MARKER].CLabelListData[E_COMPONENT_VALUE].is_visable = false;
	CMDefaults[E_TEST_MARKER].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "?";
	CMDefaults[E_TEST_MARKER].CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = false;
	CMDefaults[E_TEST_MARKER].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = false;
 	CMDefaults[E_TEST_MARKER].CPinListData.SetSize(1, 1);
	CMDefaults[E_TEST_MARKER].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_TEST_MARKER].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "TST";
	CMDefaults[E_TEST_MARKER].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_TEST_MARKER].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_TEST_MARKER].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_TEST_MARKER].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel = "Node?";
	CMDefaults[E_TEST_MARKER].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].is_visable = true;

	CReferanceDesignator[E_RESISTOR_COMPONENT] = "R";
	CMDefaults[E_RESISTOR_COMPONENT].format_spice_value = false;
	CMDefaults[E_RESISTOR_COMPONENT].CSpiceParameters.CData.SetSize(2);
	CMDefaults[E_RESISTOR_COMPONENT].CSpiceParameters.use_model = false;
	CMDefaults[E_RESISTOR_COMPONENT].CSpiceParameters.CData[0].CName = "TC1";
	CMDefaults[E_RESISTOR_COMPONENT].CSpiceParameters.CData[0].value = 0;
	CMDefaults[E_RESISTOR_COMPONENT].CSpiceParameters.CData[1].CName = "TC2";
	CMDefaults[E_RESISTOR_COMPONENT].CSpiceParameters.CData[1].value = 0;
	CMDefaults[E_RESISTOR_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_RESISTOR_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_RESISTOR_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "R";
	CMDefaults[E_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_VALUE].read_only = false;
	CMDefaults[E_RESISTOR_COMPONENT].component_property_view_type = E_PROPERTY_RESISTOR;
	CMDefaults[E_RESISTOR_COMPONENT].CLabelListData.SetSize(E_COMPONENT_RESISTOR_RESISTANCE + 1);
	CMDefaults[E_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_RESISTOR_WIDTH].CLabelType = "W";
	CMDefaults[E_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_RESISTOR_LENGTH].CLabelType = "L";
	CMDefaults[E_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_RESISTOR_TEMPCO1].CLabelType = "TC1";
	CMDefaults[E_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_RESISTOR_TEMPCO2].CLabelType = "TC2";
	CMDefaults[E_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_RESISTOR_RESISTANCE].CLabelType = "R";	
	CMDefaults[E_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Resistor";
	CMDefaults[E_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "Resistor";
	CMDefaults[E_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "1k";
	CMDefaults[E_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "R?";
	CMDefaults[E_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_VALUE].is_visable = true;
	CMDefaults[E_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_RESISTOR_COMPONENT].CPinListData.SetSize(2, 2);
	CMDefaults[E_RESISTOR_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_RESISTOR_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_RESISTOR_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_RESISTOR_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_RESISTOR_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_RESISTOR_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_RESISTOR_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_RESISTOR_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_RESISTOR_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_RESISTOR_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_COMPONENT_FUSE] = "X";
	CMDefaults[E_COMPONENT_FUSE].format_spice_value = false;
	CMDefaults[E_COMPONENT_FUSE].CSpiceParameters.use_model = true;
	CMDefaults[E_COMPONENT_FUSE].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_COMPONENT_FUSE].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_COMPONENT_FUSE].CSpiceParameters.CDataBaseIdInfo.CRecordType = "X";
	CMDefaults[E_COMPONENT_FUSE].CLabelListData[E_COMPONENT_VALUE].read_only = false;
	CMDefaults[E_COMPONENT_FUSE].component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;
	CMDefaults[E_COMPONENT_FUSE].CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER);
	CMDefaults[E_COMPONENT_FUSE].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Fuse";
	CMDefaults[E_COMPONENT_FUSE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "Fuse";
	CMDefaults[E_COMPONENT_FUSE].CLabelListData[E_COMPONENT_VALUE].CLabel = "Fuse";
	CMDefaults[E_COMPONENT_FUSE].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	CMDefaults[E_COMPONENT_FUSE].CLabelListData[E_COMPONENT_VALUE].is_visable = false;
	CMDefaults[E_COMPONENT_FUSE].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_COMPONENT_FUSE].CPinListData.SetSize(2, 2);
	CMDefaults[E_COMPONENT_FUSE].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_COMPONENT_FUSE].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_COMPONENT_FUSE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_COMPONENT_FUSE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_COMPONENT_FUSE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_COMPONENT_FUSE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_COMPONENT_FUSE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_COMPONENT_FUSE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_COMPONENT_FUSE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_COMPONENT_FUSE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_SPICE_THERMISTOR] = "X";
	CMDefaults[E_SPICE_THERMISTOR].format_spice_value = false;
	CMDefaults[E_SPICE_THERMISTOR].CSpiceParameters.use_model = true;
	CMDefaults[E_SPICE_THERMISTOR].f_validate_label_value = false;
	CMDefaults[E_SPICE_THERMISTOR].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_SPICE_THERMISTOR].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_SPICE_THERMISTOR].CSpiceParameters.CDataBaseIdInfo.CRecordType = "X";
	CMDefaults[E_SPICE_THERMISTOR].CLabelListData[E_COMPONENT_VALUE].read_only = false;
	CMDefaults[E_SPICE_THERMISTOR].component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;
	CMDefaults[E_SPICE_THERMISTOR].CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER);
	CMDefaults[E_SPICE_THERMISTOR].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Thermistor";
	CMDefaults[E_SPICE_THERMISTOR].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "Thermistor";
	CMDefaults[E_SPICE_THERMISTOR].CLabelListData[E_COMPONENT_VALUE].CLabel = "Thermistor";
	CMDefaults[E_SPICE_THERMISTOR].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	CMDefaults[E_SPICE_THERMISTOR].CLabelListData[E_COMPONENT_VALUE].is_visable = true;
	CMDefaults[E_SPICE_THERMISTOR].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_SPICE_THERMISTOR].CPinListData.SetSize(2, 2);
	CMDefaults[E_SPICE_THERMISTOR].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_SPICE_THERMISTOR].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_SPICE_THERMISTOR].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_SPICE_THERMISTOR].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_SPICE_THERMISTOR].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_SPICE_THERMISTOR].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_SPICE_THERMISTOR].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_SPICE_THERMISTOR].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_SPICE_THERMISTOR].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_SPICE_THERMISTOR].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_VARISTOR_MOV] = "X";
	CMDefaults[E_VARISTOR_MOV].format_spice_value = false;
	CMDefaults[E_VARISTOR_MOV].attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_VARISTOR_MOV].CSpiceParameters.use_model = true;
	CMDefaults[E_VARISTOR_MOV].f_validate_label_value = false;
	CMDefaults[E_VARISTOR_MOV].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_VARISTOR_MOV].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_VARISTOR_MOV].CSpiceParameters.CDataBaseIdInfo.CRecordType = "X";
	CMDefaults[E_VARISTOR_MOV].CLabelListData[E_COMPONENT_VALUE].read_only = false;
	CMDefaults[E_VARISTOR_MOV].component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;
	CMDefaults[E_VARISTOR_MOV].CLabelListData.SetSize(E_COMPONENT_MAX_LABEL_NUMBER);
	CMDefaults[E_VARISTOR_MOV].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Varistor";
	CMDefaults[E_VARISTOR_MOV].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "Varistor";
	CMDefaults[E_VARISTOR_MOV].CLabelListData[E_COMPONENT_VALUE].CLabel = "Varistor";
	CMDefaults[E_VARISTOR_MOV].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	CMDefaults[E_VARISTOR_MOV].CLabelListData[E_COMPONENT_VALUE].is_visable = true;
	CMDefaults[E_VARISTOR_MOV].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_VARISTOR_MOV].CPinListData.SetSize(2, 2);
	CMDefaults[E_VARISTOR_MOV].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_VARISTOR_MOV].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_VARISTOR_MOV].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_VARISTOR_MOV].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_VARISTOR_MOV].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_VARISTOR_MOV].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_VARISTOR_MOV].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_VARISTOR_MOV].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_VARISTOR_MOV].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_VARISTOR_MOV].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";


	CReferanceDesignator[E_VARIABLE_RESISTOR] = "A";
	CMDefaults[E_VARIABLE_RESISTOR].format_spice_value = true;
	CMDefaults[E_VARIABLE_RESISTOR].CSpiceParameters.CData.SetSize(4);
	CMDefaults[E_VARIABLE_RESISTOR].CSpiceParameters.use_model = false;
	CMDefaults[E_VARIABLE_RESISTOR].CSpiceParameters.CData[0].CName = "r";
	CMDefaults[E_VARIABLE_RESISTOR].CSpiceParameters.CData[0].value = 1e3;
	CMDefaults[E_VARIABLE_RESISTOR].CSpiceParameters.CData[1].CName = "position";
	CMDefaults[E_VARIABLE_RESISTOR].CSpiceParameters.CData[1].value = 0.0;
	CMDefaults[E_VARIABLE_RESISTOR].CSpiceParameters.CData[2].CName = "log";
	CMDefaults[E_VARIABLE_RESISTOR].CSpiceParameters.CData[2].value = 0;
	CMDefaults[E_VARIABLE_RESISTOR].CSpiceParameters.CData[3].CName = "log_multiplier";
	CMDefaults[E_VARIABLE_RESISTOR].CSpiceParameters.CData[3].value = 1.0;
	CMDefaults[E_VARIABLE_RESISTOR].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_VARIABLE_RESISTOR].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_VARIABLE_RESISTOR].CSpiceParameters.CDataBaseIdInfo.CRecordType = "R";
	CMDefaults[E_VARIABLE_RESISTOR].CLabelListData[E_COMPONENT_VALUE].read_only = false;
	CMDefaults[E_VARIABLE_RESISTOR].component_property_view_type = E_PROPERTY_VARIABLE_RESISTOR;
	CMDefaults[E_VARIABLE_RESISTOR].CLabelListData.SetSize(E_COMPONENT_VARABLE_RESISTOR_LOG_MULTIPLYER + 1);
	CMDefaults[E_VARIABLE_RESISTOR].CLabelListData[E_COMPONENT_VARABLE_RESISTOR_RESISTANCE].CLabelType = "R";
	CMDefaults[E_VARIABLE_RESISTOR].CLabelListData[E_COMPONENT_VARABLE_RESISTOR_RESISTANCE].is_visable = true;
	CMDefaults[E_VARIABLE_RESISTOR].CLabelListData[E_COMPONENT_VARABLE_RESISTOR_ROTATION].CLabelType = "Rot.";
	CMDefaults[E_VARIABLE_RESISTOR].CLabelListData[E_COMPONENT_VARABLE_RESISTOR_ROTATION].is_visable = true;
	CMDefaults[E_VARIABLE_RESISTOR].CLabelListData[E_COMPONENT_VARABLE_RESISTOR_LOG].CLabelType = "FALSE";
	CMDefaults[E_VARIABLE_RESISTOR].CLabelListData[E_COMPONENT_VARABLE_RESISTOR_LOG_MULTIPLYER].CLabelType = "1";
	CMDefaults[E_VARIABLE_RESISTOR].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Variable Resistor";
	CMDefaults[E_VARIABLE_RESISTOR].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "VariableResistor";
	CMDefaults[E_VARIABLE_RESISTOR].CLabelListData[E_COMPONENT_VALUE].CLabel = "1k";
	CMDefaults[E_VARIABLE_RESISTOR].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "A?";
	CMDefaults[E_VARIABLE_RESISTOR].CLabelListData[E_COMPONENT_VALUE].is_visable = false;
	CMDefaults[E_VARIABLE_RESISTOR].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_VARIABLE_RESISTOR].CPinListData.SetSize(3, 3);
	CMDefaults[E_VARIABLE_RESISTOR].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_VARIABLE_RESISTOR].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_VARIABLE_RESISTOR].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_VARIABLE_RESISTOR].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_VARIABLE_RESISTOR].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_VARIABLE_RESISTOR].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_VARIABLE_RESISTOR].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_VARIABLE_RESISTOR].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "o";
	CMDefaults[E_VARIABLE_RESISTOR].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_VARIABLE_RESISTOR].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_VARIABLE_RESISTOR].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_VARIABLE_RESISTOR].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_VARIABLE_RESISTOR].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_VARIABLE_RESISTOR].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_VARIABLE_RESISTOR].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_IC_RESISTOR_COMPONENT] = "R";
	CMDefaults[E_IC_RESISTOR_COMPONENT].format_spice_value = true;
	CMDefaults[E_IC_RESISTOR_COMPONENT].CSpiceParameters.use_model = true;
	CMDefaults[E_IC_RESISTOR_COMPONENT].CSpiceParameters.CData.SetSize(5);
	CMDefaults[E_IC_RESISTOR_COMPONENT].CSpiceParameters.CData[0].CName = "TC1";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CSpiceParameters.CData[0].value = 0;
	CMDefaults[E_IC_RESISTOR_COMPONENT].CSpiceParameters.CData[1].CName = "TC2";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CSpiceParameters.CData[1].value = 0;
	CMDefaults[E_IC_RESISTOR_COMPONENT].CSpiceParameters.CData[2].CName = "W";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CSpiceParameters.CData[2].value = (float)10e-6;
	CMDefaults[E_IC_RESISTOR_COMPONENT].CSpiceParameters.CData[3].CName = "L";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CSpiceParameters.CData[3].value = (float)1e-6;
	CMDefaults[E_IC_RESISTOR_COMPONENT].CSpiceParameters.CData[4].CName = "RSH";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CSpiceParameters.CData[4].value = 100;
	CMDefaults[E_IC_RESISTOR_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_IC_RESISTOR_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_IC_RESISTOR_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "R";
	CMDefaults[E_IC_RESISTOR_COMPONENT].component_property_view_type = E_PROPERTY_IC_RESISTOR;
	CMDefaults[E_IC_RESISTOR_COMPONENT].CLabelListData.SetSize(E_COMPONENT_RESISTOR_RESISTANCE + 1);
	CMDefaults[E_IC_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_RESISTOR_WIDTH].CLabelType = "W";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_RESISTOR_WIDTH].CLabelValue = "1u";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_RESISTOR_LENGTH].CLabelType = "L";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_RESISTOR_LENGTH].CLabelValue = "10u";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_RESISTOR_TEMPCO1].CLabelType = "TC1";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_RESISTOR_RESISTIVITY].CLabelType = "R/Sq";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_RESISTOR_RESISTIVITY].CLabelValue = "100";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_RESISTOR_TEMPCO2].CLabelType = "TC2";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_RESISTOR_RESISTANCE].CLabelType = "R";	
	CMDefaults[E_IC_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_RESISTOR_RESISTANCE].CLabelValue = "1k";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_RESISTOR_RESISTANCE].is_visable = true;
	CMDefaults[E_IC_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "IC Resistor";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "ICResistor";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "R?";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_IC_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_VALUE].is_visable = false;
	CMDefaults[E_IC_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_VALUE].read_only = true;
	CMDefaults[E_IC_RESISTOR_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "ICResistor";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CPinListData.SetSize(2, 2);
	CMDefaults[E_IC_RESISTOR_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_IC_RESISTOR_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_IC_RESISTOR_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].connection_type =  1;

	CReferanceDesignator[E_CAPACITOR_COMPONENT] = "C";
	CMDefaults[E_CAPACITOR_COMPONENT].format_spice_value = false;
	CMDefaults[E_CAPACITOR_COMPONENT].CSpiceParameters.CData.SetSize(3);
	CMDefaults[E_CAPACITOR_COMPONENT].CSpiceParameters.use_model = false;
	CMDefaults[E_CAPACITOR_COMPONENT].CSpiceParameters.CData[0].CName = "IC";
	CMDefaults[E_CAPACITOR_COMPONENT].CSpiceParameters.CData[0].value = 0;
	CMDefaults[E_CAPACITOR_COMPONENT].CSpiceParameters.CData[1].CName = "TC1";
	CMDefaults[E_CAPACITOR_COMPONENT].CSpiceParameters.CData[1].value = 0;
	CMDefaults[E_CAPACITOR_COMPONENT].CSpiceParameters.CData[2].CName = "TC2";
	CMDefaults[E_CAPACITOR_COMPONENT].CSpiceParameters.CData[2].value = 0;
	CMDefaults[E_CAPACITOR_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_CAPACITOR_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_CAPACITOR_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "C";
	CMDefaults[E_CAPACITOR_COMPONENT].component_property_view_type = E_PROPERTY_CAPACITOR;
	CMDefaults[E_CAPACITOR_COMPONENT].CLabelListData.SetSize(E_COMPONENT_CAPACITOR_CAPAPACITANCE + 1);
	CMDefaults[E_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_VALUE].read_only = false;
	CMDefaults[E_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_CAPACITOR_IC].CLabelType = "IC";
	CMDefaults[E_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_CAPACITOR_WIDTH].CLabelType = "W";
	CMDefaults[E_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_CAPACITOR_LENGTH].CLabelType = "L";
	CMDefaults[E_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_CAPACITOR_TEMPCO1].CLabelType = "TC1";
	CMDefaults[E_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_CAPACITOR_TEMPCO2].CLabelType = "TC2";
	CMDefaults[E_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Capacitor";
	CMDefaults[E_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "Capacitor";
	CMDefaults[E_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "1n";
	CMDefaults[E_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "C?";
	CMDefaults[E_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_VALUE].is_visable = true;
	CMDefaults[E_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;	
	CMDefaults[E_CAPACITOR_COMPONENT].CPinListData.SetSize(2, 2);
	CMDefaults[E_CAPACITOR_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_CAPACITOR_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_CAPACITOR_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_CAPACITOR_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_CAPACITOR_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_CAPACITOR_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_CAPACITOR_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_CAPACITOR_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_CAPACITOR_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_CAPACITOR_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_IC_CAPACITOR_COMPONENT] = "C";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].format_spice_value = true;
	CMDefaults[E_IC_RESISTOR_COMPONENT].CSpiceParameters.use_model = true;
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CSpiceParameters.CData.SetSize(6);
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CSpiceParameters.CData[0].CName = "IC";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CSpiceParameters.CData[0].value = 0;
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CSpiceParameters.CData[1].CName = "TC1";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CSpiceParameters.CData[1].value = 0;
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CSpiceParameters.CData[2].CName = "TC2";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CSpiceParameters.CData[2].value = 0;
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CSpiceParameters.CData[3].CName = "W";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CSpiceParameters.CData[3].value = (float)10e-6;
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CSpiceParameters.CData[4].CName = "L";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CSpiceParameters.CData[4].value = (float)10e-6;
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CSpiceParameters.CData[5].CName = "CJ";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CSpiceParameters.CData[5].value = (float)1e-15;
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "C";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].component_property_view_type = E_PROPERTY_IC_CAPACITOR;
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CLabelListData.SetSize(E_COMPONENT_CAPACITOR_CAPAPACITANCE + 1);
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_CAPACITOR_IC].CLabelType = "IC";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_CAPACITOR_WIDTH].CLabelType = "W";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_CAPACITOR_WIDTH].CLabelValue = "100u";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_CAPACITOR_LENGTH].CLabelType = "L";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_CAPACITOR_LENGTH].CLabelValue = "100u";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_CAPACITOR_TEMPCO1].CLabelType = "TC1";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_CAPACITOR_TEMPCO2].CLabelType = "TC2";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_CAPACITOR_CAPAPACITANCE].CLabelType = "C";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_CAPACITOR_CAPAPACITANCE].CLabelValue = "10p";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_CAPACITOR_CAPAPACITANCE].is_visable = true;
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_CAPACITOR_CAPACITIVITY].CLabelType = "F/Sq.M";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_CAPACITOR_CAPACITIVITY].CLabelValue = "1m";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "IC Capacitor";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "ICCapacitor";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "C?";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_VALUE].read_only = true;
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_VALUE].is_visable = false;
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "ICCapacitor";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CPinListData.SetSize(2, 2);
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_INDUCTOR_COMPONENT] = "L";
	CMDefaults[E_INDUCTOR_COMPONENT].format_spice_value = false;
	CMDefaults[E_INDUCTOR_COMPONENT].CSpiceParameters.CData.SetSize(3);
	CMDefaults[E_INDUCTOR_COMPONENT].CSpiceParameters.use_model = false;
	CMDefaults[E_INDUCTOR_COMPONENT].CSpiceParameters.CData[0].CName = "IC";
	CMDefaults[E_INDUCTOR_COMPONENT].CSpiceParameters.CData[0].value = 0;
	CMDefaults[E_INDUCTOR_COMPONENT].CSpiceParameters.CData[1].CName = "TC1";
	CMDefaults[E_INDUCTOR_COMPONENT].CSpiceParameters.CData[1].value = 0;
	CMDefaults[E_INDUCTOR_COMPONENT].CSpiceParameters.CData[2].CName = "TC2";
	CMDefaults[E_INDUCTOR_COMPONENT].CSpiceParameters.CData[2].value = 0;
	CMDefaults[E_INDUCTOR_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_INDUCTOR_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_INDUCTOR_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "L";
	CMDefaults[E_INDUCTOR_COMPONENT].component_property_view_type = E_PROPERTY_INDUCTOR;
	CMDefaults[E_INDUCTOR_COMPONENT].CLabelListData.SetSize(E_COMPONENT_INDUCTOR_TEMPCO2 + 1);
	CMDefaults[E_INDUCTOR_COMPONENT].CLabelListData[E_COMPONENT_VALUE].read_only = false;
	CMDefaults[E_INDUCTOR_COMPONENT].CLabelListData[E_COMPONENT_INDUCTOR_AL].CLabelType = "Al";
	CMDefaults[E_INDUCTOR_COMPONENT].CLabelListData[E_COMPONENT_INDUCTOR_IC].CLabelType = "IC";
	CMDefaults[E_INDUCTOR_COMPONENT].CLabelListData[E_COMPONENT_INDUCTOR_N].CLabelType = "N";
	CMDefaults[E_INDUCTOR_COMPONENT].CLabelListData[E_COMPONENT_INDUCTOR_TEMPCO1].CLabelType = "TC1";
	CMDefaults[E_INDUCTOR_COMPONENT].CLabelListData[E_COMPONENT_INDUCTOR_TEMPCO2].CLabelType = "TC2";
	CMDefaults[E_INDUCTOR_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Inductor";
	CMDefaults[E_INDUCTOR_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "Inductor";
	CMDefaults[E_INDUCTOR_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "1u";
	CMDefaults[E_INDUCTOR_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "L?";
	CMDefaults[E_INDUCTOR_COMPONENT].CLabelListData[E_COMPONENT_VALUE].is_visable = true;
	CMDefaults[E_INDUCTOR_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;	
	CMDefaults[E_INDUCTOR_COMPONENT].CPinListData.SetSize(2, 2);
	CMDefaults[E_INDUCTOR_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_INDUCTOR_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_INDUCTOR_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_INDUCTOR_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_INDUCTOR_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_INDUCTOR_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_INDUCTOR_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_INDUCTOR_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_INDUCTOR_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_INDUCTOR_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_INDUCTOR_COMPONENT_CORED] = "X";
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].format_spice_value = false;
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].CSpiceParameters.CDataBaseIdInfo.CRecordType = "X";
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Core Inductor";
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "InductorIronCoreModel";
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].CLabelListData[E_COMPONENT_VALUE].CLabel = "InductorIronCoreModel_XN";
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].CLabelListData[E_COMPONENT_VALUE].is_visable = false;
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;	
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].CPinListData.SetSize(2, 2);
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CMDefaults[E_FREQUENCY_CRYSTAL].attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_FREQUENCY_CRYSTAL].f_validate_label_value = false;
	CMDefaults[E_FREQUENCY_CRYSTAL].component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;// this needs a new dialog box when transformer is changed
	CMDefaults[E_FREQUENCY_CRYSTAL].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_FREQUENCY_CRYSTAL].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Crystal";
	CMDefaults[E_FREQUENCY_CRYSTAL].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "XTAL_XN";
	CMDefaults[E_FREQUENCY_CRYSTAL].CLabelListData[E_COMPONENT_VALUE].CLabel = "XTAL_XN";
	CMDefaults[E_FREQUENCY_CRYSTAL].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	CMDefaults[E_FREQUENCY_CRYSTAL].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_FREQUENCY_CRYSTAL].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_FREQUENCY_CRYSTAL].CPinListData.SetSize(2, 2);
	CMDefaults[E_FREQUENCY_CRYSTAL].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_FREQUENCY_CRYSTAL].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_FREQUENCY_CRYSTAL].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_FREQUENCY_CRYSTAL].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_FREQUENCY_CRYSTAL].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_FREQUENCY_CRYSTAL].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_DIODE_COMPONENT] = "D";
	CMDefaults[E_DIODE_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_DIODE_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_DIODE_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "D";
	CMDefaults[E_DIODE_COMPONENT].component_property_view_type = E_PROPERTY_DIODE;
	CMDefaults[E_DIODE_COMPONENT].CLabelListData.SetSize(E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE + 1);
	CMDefaults[E_DIODE_COMPONENT].CLabelListData[E_COMPONENT_DIODE_M].CLabelType = "M";
	CMDefaults[E_DIODE_COMPONENT].CLabelListData[E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE].CLabelType = "BV";
	CMDefaults[E_DIODE_COMPONENT].CLabelListData[E_COMPONENT_DIODE_M].CLabelValue = "1";
	CMDefaults[E_DIODE_COMPONENT].CLabelListData[E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE].CLabelValue = "100";
	CMDefaults[E_DIODE_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "D1N4148";
	CMDefaults[E_DIODE_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Diode";
	CMDefaults[E_DIODE_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "D1N4148_XN";
	CMDefaults[E_DIODE_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "D?";
	CMDefaults[E_DIODE_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_DIODE_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_DIODE_COMPONENT].CPinListData.SetSize(2, 2);
	CMDefaults[E_DIODE_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_DIODE_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_DIODE_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "a";
	CMDefaults[E_DIODE_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_DIODE_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_DIODE_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_DIODE_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "c";
	CMDefaults[E_DIODE_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_DIODE_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_DIODE_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_ZENER_COMPONENT] = "D";
	CMDefaults[E_ZENER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_ZENER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_ZENER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "D";
	CMDefaults[E_ZENER_COMPONENT].component_property_view_type = E_PROPERTY_DIODE;
	CMDefaults[E_ZENER_COMPONENT].CLabelListData.SetSize(E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE + 1);
	CMDefaults[E_ZENER_COMPONENT].CLabelListData[E_COMPONENT_DIODE_M].CLabelType = "M";
	CMDefaults[E_ZENER_COMPONENT].CLabelListData[E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE].CLabelType = "BV";
	CMDefaults[E_ZENER_COMPONENT].CLabelListData[E_COMPONENT_DIODE_M].CLabelValue = "1";
	CMDefaults[E_ZENER_COMPONENT].CLabelListData[E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE].CLabelValue = "100";
	CMDefaults[E_ZENER_COMPONENT].mirror_state = E_MIRRORED_NORMAL;
	CMDefaults[E_ZENER_COMPONENT].rotation_state = E_FORTH_QUADRANT;
	CMDefaults[E_ZENER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "ZenerGeneric";
	CMDefaults[E_ZENER_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Zenor Diode";
	CMDefaults[E_ZENER_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "ZenerGeneric_XN";
	CMDefaults[E_ZENER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "D?";
	CMDefaults[E_ZENER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_ZENER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_ZENER_COMPONENT].CPinListData.SetSize(2, 2);
	CMDefaults[E_ZENER_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_ZENER_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_ZENER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "a";
	CMDefaults[E_ZENER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_ZENER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_ZENER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_ZENER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "c";
	CMDefaults[E_ZENER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_ZENER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_ZENER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_SHOTTKY_COMPONENT] = "D";
	CMDefaults[E_SHOTTKY_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_SHOTTKY_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_SHOTTKY_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "D";
	CMDefaults[E_SHOTTKY_COMPONENT].component_property_view_type = E_PROPERTY_DIODE;
	CMDefaults[E_SHOTTKY_COMPONENT].CLabelListData.SetSize(E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE + 1);
	CMDefaults[E_SHOTTKY_COMPONENT].CLabelListData[E_COMPONENT_DIODE_M].CLabelType = "M";
	CMDefaults[E_SHOTTKY_COMPONENT].CLabelListData[E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE].CLabelType = "BV";
	CMDefaults[E_SHOTTKY_COMPONENT].CLabelListData[E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE].CLabelValue = "20";
	CMDefaults[E_SHOTTKY_COMPONENT].CLabelListData[E_COMPONENT_DIODE_M].CLabelValue = "1";
	CMDefaults[E_SHOTTKY_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "SchottkyGeneric";
	CMDefaults[E_SHOTTKY_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Schoktty Diode";
	CMDefaults[E_SHOTTKY_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "SchottkyGeneric_XN";
	CMDefaults[E_SHOTTKY_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "D?";
	CMDefaults[E_SHOTTKY_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_SHOTTKY_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_SHOTTKY_COMPONENT].CPinListData.SetSize(2, 2);
	CMDefaults[E_SHOTTKY_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_SHOTTKY_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_SHOTTKY_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "a";
	CMDefaults[E_SHOTTKY_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_SHOTTKY_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_SHOTTKY_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_SHOTTKY_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "c";
	CMDefaults[E_SHOTTKY_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_SHOTTKY_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_SHOTTKY_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	
	CMDefaults[E_DIAC_COMPONENT].attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_DIAC_COMPONENT].component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;// 
	CMDefaults[E_DIAC_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;

	CMDefaults[E_DIAC_COMPONENT].mirror_state = E_MIRRORED_NORMAL;
	CMDefaults[E_DIAC_COMPONENT].rotation_state = E_FORTH_QUADRANT;
	CMDefaults[E_DIAC_COMPONENT].CLabelListData.SetSize(E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE + 1);
	CMDefaults[E_DIAC_COMPONENT].CLabelListData[E_COMPONENT_DIODE_M].CLabelType = "M";
	CMDefaults[E_DIAC_COMPONENT].CLabelListData[E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE].CLabelType = "BV";
	CMDefaults[E_DIAC_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "DiacGeneric";
	CMDefaults[E_DIAC_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Diac";
	CMDefaults[E_DIAC_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "DiacGeneric_XN ";
	CMDefaults[E_DIAC_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	CMDefaults[E_DIAC_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_DIAC_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_DIAC_COMPONENT].CPinListData.SetSize(2, 2);
	CMDefaults[E_DIAC_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_DIAC_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_DIAC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "a";
	CMDefaults[E_DIAC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_DIAC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_DIAC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_DIAC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "c";
	CMDefaults[E_DIAC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_DIAC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_DIAC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_DC_VOLTAGE_SOURCE] = "V";
	CMDefaults[E_DC_VOLTAGE_SOURCE].attached_model_type  = E_SPICE_GENERATOR;
	CMDefaults[E_DC_VOLTAGE_SOURCE].component_property_view_type = E_PROPERTY_DC_VOLTAGE_SOURCE; 
	CMDefaults[E_DC_VOLTAGE_SOURCE].CSpiceParameters.CDataBaseIdInfo.CModelType = "VDC";
	CMDefaults[E_DC_VOLTAGE_SOURCE].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_DC_VOLTAGE_SOURCE].CSpiceParameters.CDataBaseIdInfo.CRecordType = "VDC";
	CMDefaults[E_DC_VOLTAGE_SOURCE].CSpiceParameters.use_model = false;
	CMDefaults[E_DC_VOLTAGE_SOURCE].f_validate_label_value = false;
	CMDefaults[E_DC_VOLTAGE_SOURCE].CLabelListData.SetSize(E_GENERATOR_PHASE_VALUE + 1);
	CMDefaults[E_DC_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only	= true;
	CMDefaults[E_DC_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_VALUE].read_only		= true;
	CMDefaults[E_DC_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only	= true;
	CMDefaults[E_DC_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "VDC";
	CMDefaults[E_DC_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = false;
	CMDefaults[E_DC_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "V";
	CMDefaults[E_DC_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_VALUE].CLabel = "?";
	CMDefaults[E_DC_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "V?";
	CMDefaults[E_DC_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_DC_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_DC_VALUE].is_visable = true;
	CMDefaults[E_DC_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_DC_VALUE].CLabelType = "DC";	
	CMDefaults[E_DC_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_AC_VALUE].CLabelType = "AC";
	CMDefaults[E_DC_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_PHASE_VALUE].CLabelType = "Phase";
	CMDefaults[E_DC_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_AC_IMD1].CLabelType = "I.M.D.1";
	CMDefaults[E_DC_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_AC_IMD1].CLabel		= "1";
	CMDefaults[E_DC_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_AC_IMD2].CLabelType = "I.M.D.2";
	CMDefaults[E_DC_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_AC_IMD2].CLabel		= "1";
	CMDefaults[E_DC_VOLTAGE_SOURCE].CPinListData.SetSize(2, 2);
	CMDefaults[E_DC_VOLTAGE_SOURCE].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_DC_VOLTAGE_SOURCE].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_DC_VOLTAGE_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_DC_VOLTAGE_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_DC_VOLTAGE_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_DC_VOLTAGE_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_DC_VOLTAGE_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_DC_VOLTAGE_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_DC_VOLTAGE_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_DC_VOLTAGE_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_SINE_VOLTAGE_SOURCE] = "V";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].attached_model_type  = E_SPICE_GENERATOR;
	CMDefaults[E_SINE_VOLTAGE_SOURCE].component_property_view_type = E_PROPERTY_SINE_VOLTAGE_SOURCE;
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CSpiceParameters.CDataBaseIdInfo.CModelType = "VSIN";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CSpiceParameters.CDataBaseIdInfo.CRecordType = "VSIN";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CSpiceParameters.use_model = false;
	CMDefaults[E_SINE_VOLTAGE_SOURCE].f_validate_label_value = false;
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CLabelListData.SetSize(E_GENERATOR_SINE_DAMPING_VALUE + 1);
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only	= true;
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_VALUE].read_only		= true;
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only	= true;
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "VSine";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = false;
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "V";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_VALUE].CLabel = "?";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "V?";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_SINE_AMPLITUDE_VALUE].is_visable = true;
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_DC_VALUE].CLabelType = "DC";	
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_AC_VALUE].CLabelType = "AC";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_PHASE_VALUE].CLabelType = "Phase";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_SINE_AMPLITUDE_VALUE].CLabelType = "VPk";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_SINE_FREQUENCY_VALUE].CLabelType = "F";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_SINE_OFFSET_VALUE].CLabelType = "Offset";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_SINE_DELAY_VALUE].CLabelType = "Delay";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_SINE_DAMPING_VALUE].CLabelType = "Damping";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_SINE_IMD1].CLabelType = "I.M.D.1";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_SINE_IMD2].CLabelType = "I.M.D.2";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CPinListData.SetSize(2, 2);
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_PULSE_VOLTAGE_SOURCE] = "V";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].attached_model_type  = E_SPICE_GENERATOR ;
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].component_property_view_type = E_PROPERTY_PULSE_VOLTAGE_SOURCE;
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CSpiceParameters.CDataBaseIdInfo.CModelType = "VPULSE";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CSpiceParameters.CDataBaseIdInfo.CRecordType = "VPULSE";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CSpiceParameters.use_model = false;
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].f_validate_label_value = false;
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData.SetSize(E_GENERATOR_PULSE_PERIOD_VALUE + 1);
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only	= true;
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_VALUE].read_only		= true;
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only	= true;
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_DC_VALUE].CLabelType = "DC";	
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_AC_VALUE].CLabelType = "AC";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_PHASE_VALUE].CLabelType = "Phase";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_PULSE_START_AMPLITUDE_VALUE].CLabelType = "V1";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_PULSE_STOP_AMPLITUDE_VALUE].CLabelType = "V2";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_PULSE_DELAY_VALUE].CLabelType = "Td";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_PULSE_RISE_TIME_VALUE].CLabelType = "Tr";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_PULSE_FALL_TIME_VALUE].CLabelType = "Tf";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_PULSE_WIDTH_VALUE].CLabelType = "Width";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_PULSE_PERIOD_VALUE].CLabelType = "Period";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_PULSE_IMD1].CLabelType = "I.M.D.1";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_PULSE_IMD2].CLabelType = "I.M.D.2";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "VPulse";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = false;
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "V";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_VALUE].CLabel = "?";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "V?";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CPinListData.SetSize(2, 2);
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_EXPONENTIAL_VOLTAGE_SOURCE] = "V";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].attached_model_type  = E_SPICE_GENERATOR;
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].component_property_view_type = E_PROPERTY_EXPONENTIAL_VOLTAGE_SOURCE;
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CSpiceParameters.CDataBaseIdInfo.CModelType = "VEXP";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CSpiceParameters.CDataBaseIdInfo.CRecordType = "VEXP";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].f_validate_label_value = false;
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CSpiceParameters.use_model = false;
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData.SetSize(E_GENERATOR_EXP_TAU2_VALUE + 1);
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only	= true;
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_VALUE].read_only		= true;
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only	= true;
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_DC_VALUE].CLabelType = "DC";	
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_AC_VALUE].CLabelType = "AC";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_PHASE_VALUE].CLabelType = "Phase";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_EXP_START_VALUE].CLabelType = "V1";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_EXP_STOP_VALUE].CLabelType = "V2";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_EXP_TAU1_DELAY_VALUE].CLabelType = "Tau1 delay";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_EXP_TAU1_VALUE].CLabelType = "Tau1";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_EXP_TAU2_DELAY_VALUE].CLabelType = "Tau2 delay";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_EXP_TAU2_VALUE].CLabelType = "Tau2";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "VExp";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "VExp";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_EXP_IMD1].CLabelType = "I.M.D.1";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_EXP_IMD2].CLabelType = "I.M.D.2";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = false;
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "V";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_VALUE].CLabel = "?";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "V?";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;	
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CPinListData.SetSize(2, 2);
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_DC_VALUE].CLabelType = "DC";	
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_AC_VALUE].CLabelType = "AC";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_PHASE_VALUE].CLabelType = "Phase";

	CReferanceDesignator[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE] = "V";
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].attached_model_type  = E_SPICE_GENERATOR;
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].component_property_view_type = E_PROPERTY_PIECEWISE_LINEAR_VOLTAGE_SOURCE;
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CSpiceParameters.CDataBaseIdInfo.CModelType = "VPWL";
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CSpiceParameters.CDataBaseIdInfo.CRecordType = "VPWL";
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CSpiceParameters.use_model = false;
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CLabelListData.SetSize(E_GENERATOR_PWL_IMD2 + 1);
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only	= true;
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_VALUE].read_only		= true;
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only	= true;
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_DC_VALUE].CLabelType = "DC";	
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_AC_VALUE].CLabelType = "AC";
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_PHASE_VALUE].CLabelType = "Phase";
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_PWL_IMD1].CLabelType = "I.M.D.1";
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CLabelListData[E_GENERATOR_PWL_IMD2].CLabelType = "I.M.D.2";
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].f_validate_label_value = false;
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "VPWL";
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = false;
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "V";
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_VALUE].CLabel = "?";
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "V?";
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CPinListData.SetSize(2, 2);
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_SINGLE_FREQ_VOLTAGE_FM] = "V";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].attached_model_type  = E_SPICE_GENERATOR;
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].component_property_view_type = E_PROPERTY_SINGLE_FREQ_VOLTAGE_FM;
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CSpiceParameters.CDataBaseIdInfo.CModelType = "VSFFM";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CSpiceParameters.CDataBaseIdInfo.CRecordType = "VSFFM";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CSpiceParameters.use_model = false;
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].f_validate_label_value = false;
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CLabelListData.SetSize(E_GENERATOR_SFFM_OFFSET_VALUE + 1);
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only	= true;
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CLabelListData[E_COMPONENT_VALUE].read_only		= true;
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only	= true;
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CLabelListData[E_GENERATOR_DC_VALUE].CLabelType = "DC";	
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CLabelListData[E_GENERATOR_AC_VALUE].CLabelType = "AC";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CLabelListData[E_GENERATOR_PHASE_VALUE].CLabelType = "Phase";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CLabelListData[E_GENERATOR_SFFM_CARRIER_AMPLITUDE_VALUE].CLabelType = "VPk";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CLabelListData[E_GENERATOR_SFFM_MODULATION_INDEX_VALUE].CLabelType = "m";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CLabelListData[E_GENERATOR_SFFM_CARRIER_FREQUENCY_VALUE].CLabelType = "Fc";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CLabelListData[E_GENERATOR_SFFM_MODULATION_FREQUENCY_VALUE].CLabelType = "Fm";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CLabelListData[E_GENERATOR_SFFM_OFFSET_VALUE].CLabelType = "Offset";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "VSFFM";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CLabelListData[E_GENERATOR_SFFM_IMD1].CLabelType = "I.M.D.1";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CLabelListData[E_GENERATOR_SFFM_IMD2].CLabelType = "I.M.D.2";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = true;
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "V";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CLabelListData[E_COMPONENT_VALUE].CLabel = "?";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "V?";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;	
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CPinListData.SetSize(2, 2);
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_DC_CURRENT_SOURCE] = "I";
	CMDefaults[E_DC_CURRENT_SOURCE].attached_model_type  = E_SPICE_GENERATOR;
	CMDefaults[E_DC_CURRENT_SOURCE].component_property_view_type = E_PROPERTY_DC_CURRENT_SOURCE;
	CMDefaults[E_DC_CURRENT_SOURCE].CSpiceParameters.CDataBaseIdInfo.CModelType = "IDC";
	CMDefaults[E_DC_CURRENT_SOURCE].CSpiceParameters.CDataBaseIdInfo.CRecordType= "IDC";
	CMDefaults[E_DC_CURRENT_SOURCE].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_DC_CURRENT_SOURCE].CSpiceParameters.use_model = false;
	CMDefaults[E_DC_CURRENT_SOURCE].f_validate_label_value = false;
	CMDefaults[E_DC_CURRENT_SOURCE].CLabelListData.SetSize(E_GENERATOR_PHASE_VALUE + 1);
	CMDefaults[E_DC_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only	= true;
	CMDefaults[E_DC_CURRENT_SOURCE].CLabelListData[E_COMPONENT_VALUE].read_only		= true;
	CMDefaults[E_DC_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only	= true;
	CMDefaults[E_DC_CURRENT_SOURCE].CLabelListData[E_GENERATOR_DC_VALUE].CLabelType = "DC";	
	CMDefaults[E_DC_CURRENT_SOURCE].CLabelListData[E_GENERATOR_AC_VALUE].CLabelType = "AC";
	CMDefaults[E_DC_CURRENT_SOURCE].CLabelListData[E_GENERATOR_PHASE_VALUE].CLabelType = "Phase";
	CMDefaults[E_DC_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "IDC";
	CMDefaults[E_DC_CURRENT_SOURCE].CLabelListData[E_GENERATOR_AC_IMD1].CLabelType = "I.M.D.1";
	CMDefaults[E_DC_CURRENT_SOURCE].CLabelListData[E_GENERATOR_AC_IMD2].CLabelType = "I.M.D.2";
	CMDefaults[E_DC_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = false;
	CMDefaults[E_DC_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "I";
	CMDefaults[E_DC_CURRENT_SOURCE].CLabelListData[E_COMPONENT_VALUE].CLabel = "?";
	CMDefaults[E_DC_CURRENT_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "I?";
	CMDefaults[E_DC_CURRENT_SOURCE].CLabelListData[E_GENERATOR_DC_VALUE].is_visable = true;
	CMDefaults[E_DC_CURRENT_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;	
	CMDefaults[E_DC_CURRENT_SOURCE].CPinListData.SetSize(2, 2);
	CMDefaults[E_DC_CURRENT_SOURCE].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_DC_CURRENT_SOURCE].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_DC_CURRENT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_DC_CURRENT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_DC_CURRENT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_DC_CURRENT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_DC_CURRENT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_DC_CURRENT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_DC_CURRENT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_DC_CURRENT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_SINE_CURRENT_SOURCE] = "I";
	CMDefaults[E_SINE_CURRENT_SOURCE].attached_model_type  = E_SPICE_GENERATOR;
	CMDefaults[E_SINE_CURRENT_SOURCE].component_property_view_type = E_PROPERTY_SINE_CURRENT_SOURCE;
	CMDefaults[E_SINE_CURRENT_SOURCE].CSpiceParameters.CDataBaseIdInfo.CModelType = "isource";
	CMDefaults[E_SINE_CURRENT_SOURCE].CSpiceParameters.CDataBaseIdInfo.CRecordType = "ISIN";
	CMDefaults[E_SINE_CURRENT_SOURCE].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_SINE_CURRENT_SOURCE].CSpiceParameters.use_model = false;
	CMDefaults[E_SINE_CURRENT_SOURCE].f_validate_label_value = false;
	CMDefaults[E_SINE_CURRENT_SOURCE].CLabelListData.SetSize(E_GENERATOR_SINE_DAMPING_VALUE + 1);
	CMDefaults[E_SINE_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only	= true;
	CMDefaults[E_SINE_CURRENT_SOURCE].CLabelListData[E_COMPONENT_VALUE].read_only		= true;
	CMDefaults[E_SINE_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only	= true;
	CMDefaults[E_SINE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_DC_VALUE].CLabelType = "DC";	
	CMDefaults[E_SINE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_AC_VALUE].CLabelType = "AC";
	CMDefaults[E_SINE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_PHASE_VALUE].CLabelType = "Phase";
	CMDefaults[E_SINE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_SINE_AMPLITUDE_VALUE].CLabelType = "IPk";
	CMDefaults[E_SINE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_SINE_FREQUENCY_VALUE].CLabelType = "F";
	CMDefaults[E_SINE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_SINE_OFFSET_VALUE].CLabelType = "Offset";
	CMDefaults[E_SINE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_SINE_DELAY_VALUE].CLabelType = "Delay";
	CMDefaults[E_SINE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_SINE_DAMPING_VALUE].CLabelType = "Damping";
	CMDefaults[E_SINE_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "ISine";
	CMDefaults[E_SINE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_SINE_IMD1].CLabelType = "I.M.D.1";
	CMDefaults[E_SINE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_SINE_IMD2].CLabelType = "I.M.D.2";
	CMDefaults[E_SINE_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = false;
	CMDefaults[E_SINE_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "I";
	CMDefaults[E_SINE_CURRENT_SOURCE].CLabelListData[E_COMPONENT_VALUE].CLabel = "?";
	CMDefaults[E_SINE_CURRENT_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "I?";
	CMDefaults[E_SINE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_SINE_AMPLITUDE_VALUE].is_visable = true;
	CMDefaults[E_SINE_CURRENT_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;	
	CMDefaults[E_SINE_CURRENT_SOURCE].CPinListData.SetSize(2, 2);
	CMDefaults[E_SINE_CURRENT_SOURCE].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_SINE_CURRENT_SOURCE].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_SINE_CURRENT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_SINE_CURRENT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_SINE_CURRENT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_SINE_CURRENT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_SINE_CURRENT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_SINE_CURRENT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_SINE_CURRENT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_SINE_CURRENT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_PULSE_CURRENT_SOURCE] = "I";
	CMDefaults[E_PULSE_CURRENT_SOURCE].attached_model_type  = E_SPICE_GENERATOR ;
	CMDefaults[E_PULSE_CURRENT_SOURCE].component_property_view_type = E_PROPERTY_PULSE_CURRENT_SOURCE;
	CMDefaults[E_PULSE_CURRENT_SOURCE].CSpiceParameters.CDataBaseIdInfo.CModelType = "isource";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CSpiceParameters.CDataBaseIdInfo.CRecordType = "IPULSE";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_PULSE_CURRENT_SOURCE].CSpiceParameters.use_model = false;
	CMDefaults[E_PULSE_CURRENT_SOURCE].f_validate_label_value = false;
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData.SetSize(E_GENERATOR_PULSE_PERIOD_VALUE + 1);
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only	= true;
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData[E_COMPONENT_VALUE].read_only		= true;
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only	= true;
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_DC_VALUE].CLabelType = "DC";	
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_AC_VALUE].CLabelType = "AC";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_PHASE_VALUE].CLabelType = "Phase";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_PULSE_START_AMPLITUDE_VALUE].CLabelType = "I1";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_PULSE_STOP_AMPLITUDE_VALUE].CLabelType = "I2";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_PULSE_DELAY_VALUE].CLabelType = "Td";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_PULSE_RISE_TIME_VALUE].CLabelType = "Tr";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_PULSE_FALL_TIME_VALUE].CLabelType = "Tf";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_PULSE_WIDTH_VALUE].CLabelType = "Width";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_PULSE_PERIOD_VALUE].CLabelType = "Period";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "IPulse";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_PULSE_IMD1].CLabelType = "I.M.D.1";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData[E_GENERATOR_PULSE_IMD2].CLabelType = "I.M.D.2";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = false;
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "I";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData[E_COMPONENT_VALUE].CLabel = "?";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "I?";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;	
	CMDefaults[E_PULSE_CURRENT_SOURCE].CPinListData.SetSize(2, 2);
	CMDefaults[E_PULSE_CURRENT_SOURCE].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PULSE_CURRENT_SOURCE].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PULSE_CURRENT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_EXPONENTIAL_CURRENT_SOURCE] = "I";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].attached_model_type  = E_SPICE_GENERATOR;
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].component_property_view_type = E_PROPERTY_EXPONENTIAL_CURRENT_SOURCE;
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CSpiceParameters.CDataBaseIdInfo.CModelType = "isource";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CSpiceParameters.CDataBaseIdInfo.CRecordType = "IEXP";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CSpiceParameters.use_model = false;
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].f_validate_label_value = false;
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CLabelListData.SetSize(E_GENERATOR_EXP_TAU2_VALUE + 1);
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only	= true;
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CLabelListData[E_COMPONENT_VALUE].read_only		= true;
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only	= true;
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CLabelListData[E_GENERATOR_DC_VALUE].CLabelType = "DC";	
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CLabelListData[E_GENERATOR_AC_VALUE].CLabelType = "AC";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CLabelListData[E_GENERATOR_PHASE_VALUE].CLabelType = "Phase";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CLabelListData[E_GENERATOR_EXP_START_VALUE].CLabelType = "I1";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CLabelListData[E_GENERATOR_EXP_STOP_VALUE].CLabelType = "I2";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CLabelListData[E_GENERATOR_EXP_TAU1_DELAY_VALUE].CLabelType = "Tau1 delay";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CLabelListData[E_GENERATOR_EXP_TAU1_VALUE].CLabelType = "Tau1=0";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CLabelListData[E_GENERATOR_EXP_TAU2_DELAY_VALUE].CLabelType = "Tau2 delay";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CLabelListData[E_GENERATOR_EXP_TAU2_VALUE].CLabelType = "Tau2";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "IExp";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CLabelListData[E_GENERATOR_EXP_IMD1].CLabelType = "I.M.D.1";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CLabelListData[E_GENERATOR_EXP_IMD2].CLabelType = "I.M.D.2";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = false;
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "I";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CLabelListData[E_COMPONENT_VALUE].CLabel = "?";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "I?";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;	
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CPinListData.SetSize(2, 2);
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_PIECEWISE_LINEAR_CURRENT_SOURCE] = "I";
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].attached_model_type  = E_SPICE_GENERATOR ;
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].component_property_view_type = E_PROPERTY_PIECEWISE_LINEAR_CURRENT_SOURCE;
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CSpiceParameters.CDataBaseIdInfo.CModelType = "isource";
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CSpiceParameters.CDataBaseIdInfo.CRecordType = "IPWL";	
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CSpiceParameters.use_model = false;
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].f_validate_label_value = false;
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CLabelListData.SetSize(E_GENERATOR_PWL_IMD2 + 1);
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only	= true;
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CLabelListData[E_COMPONENT_VALUE].read_only		= true;
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only	= true;
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CLabelListData[E_GENERATOR_DC_VALUE].CLabelType = "DC";	
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CLabelListData[E_GENERATOR_AC_VALUE].CLabelType = "AC";
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CLabelListData[E_GENERATOR_PHASE_VALUE].CLabelType = "Phase";
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "IPWL";
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CLabelListData[E_GENERATOR_PWL_IMD1].CLabelType = "I.M.D.1";
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CLabelListData[E_GENERATOR_PWL_IMD2].CLabelType = "I.M.D.2";
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = false;
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "I";
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CLabelListData[E_COMPONENT_VALUE].CLabel = "?";
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "I?";
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CPinListData.SetSize(2, 2);
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_SINGLE_FREQ_CURRENT_FM] = "I";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].attached_model_type  = E_SPICE_GENERATOR;
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].component_property_view_type = E_PROPERTY_SINGLE_FREQ_CURRENT_FM;
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CSpiceParameters.CDataBaseIdInfo.CModelType = "isource";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CSpiceParameters.CDataBaseIdInfo.CRecordType = "ISFFM";	
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CSpiceParameters.CDataBaseIdInfo.model_type = -1;
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CSpiceParameters.use_model = false;
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].f_validate_label_value = false;
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CLabelListData.SetSize(E_GENERATOR_SFFM_OFFSET_VALUE + 1);
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only	= true;
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CLabelListData[E_COMPONENT_VALUE].read_only		= true;
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only	= true;
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CLabelListData[E_GENERATOR_DC_VALUE].CLabelType = "DC";	
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CLabelListData[E_GENERATOR_AC_VALUE].CLabelType = "AC";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CLabelListData[E_GENERATOR_PHASE_VALUE].CLabelType = "Phase";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CLabelListData[E_GENERATOR_SFFM_CARRIER_AMPLITUDE_VALUE].CLabelType = "IPk";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CLabelListData[E_GENERATOR_SFFM_MODULATION_INDEX_VALUE].CLabelType = "m";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CLabelListData[E_GENERATOR_SFFM_CARRIER_FREQUENCY_VALUE].CLabelType = "Fc";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CLabelListData[E_GENERATOR_SFFM_MODULATION_FREQUENCY_VALUE].CLabelType = "Fm";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CLabelListData[E_GENERATOR_SFFM_OFFSET_VALUE].CLabelType = "Offset";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "ISFFM";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CLabelListData[E_GENERATOR_SFFM_IMD1].CLabelType = "I.M.D.1";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CLabelListData[E_GENERATOR_SFFM_IMD2].CLabelType = "I.M.D.2";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = true;
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "I";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CLabelListData[E_COMPONENT_VALUE].CLabel = "?";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "I?";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CPinListData.SetSize(2, 2);
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CMDefaults[E_GENERIC_2_COMPONENT].attached_model_type = E_SPICE_SCHEMATIC;
	CMDefaults[E_GENERIC_2_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "2Pin";
	CMDefaults[E_GENERIC_2_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "Generic2";
	CMDefaults[E_GENERIC_2_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "Generic2";
	CMDefaults[E_GENERIC_2_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	CMDefaults[E_GENERIC_2_COMPONENT].CLabelListData[E_COMPONENT_VALUE].is_visable = true;
	CMDefaults[E_GENERIC_2_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_GENERIC_2_COMPONENT].CPinListData.SetSize(2, 2);
	CMDefaults[E_GENERIC_2_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_GENERIC_2_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_GENERIC_2_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_GENERIC_2_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_GENERIC_2_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_GENERIC_2_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_GENERIC_2_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_GENERIC_2_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_GENERIC_2_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_GENERIC_2_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_NPN_TRANSISTER_COMPONENT] = "QN";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "NPN";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordFileName = "StandardBipoler.lib";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].component_property_view_type = E_PROPERTY_BIPOLAR;
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CLabelListData.SetSize(E_COMPONENT_BIPOLAR_PARAMETERS + 1);
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_M].CLabelType = "M";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_NUM_RESERVED].CLabelType = "Reserved";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_PARAMETERS].CLabelType = "Parameters";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_M].CLabelValue = "1";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_NUM_RESERVED].CLabelValue = "";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_PARAMETERS].CLabelValue = "";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "Q2N3904";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "NPN Bipolar Transistor";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "Q2N3904";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "Q?";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CPinListData.SetSize(3, 3);
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "c";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "b";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "e";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_PNP_TRANSISTER_COMPONENT] = "QP";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "PNP";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].component_property_view_type = E_PROPERTY_BIPOLAR;
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].mirror_state = E_MIRRORED_INVERTED;
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].rotation_state = E_THIRD_QUADRANT;
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CLabelListData.SetSize(E_COMPONENT_BIPOLAR_PARAMETERS + 1);
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_M].CLabelType = "M";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_NUM_RESERVED].CLabelType = "Reserved";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_PARAMETERS].CLabelType = "Parameters";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_M].CLabelValue = "1";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_NUM_RESERVED].CLabelValue = "";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_PARAMETERS].CLabelValue = "";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "Q2N3906";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "PNP Bipolar Transistor";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "Q2N3906";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "Q?";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CPinListData.SetSize(3, 3);
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "c";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "b";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "e";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_PMOS_TRANSISTER_COMPONENT] = "MP";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "PMOS";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].component_property_view_type = E_PROPERTY_MOSFET;
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].mirror_state = E_MIRRORED_INVERTED;
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].rotation_state = E_THIRD_QUADRANT;
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CLabelListData.SetSize(E_COMPONENT_FET_PARAMETERS + 1);
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelType = "L";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelType = "W";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelType = "M";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelValue = "1";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelValue = "0";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = "0";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_ENABLE_AS].CLabelValue = "1";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "pmos";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "P Channel Mosfet";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "pmos";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "M?";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CPinListData.SetSize(3, 3);
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "d";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "s";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_NMOS_TRANSISTER_COMPONENT] = "MN";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "NMOS";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].component_property_view_type = E_PROPERTY_MOSFET;
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CLabelListData.SetSize(E_COMPONENT_FET_PARAMETERS + 1);
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelType = "L";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelType = "W";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelType = "M";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelValue = "1";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelValue = "0";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = "0";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelValue = "1";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_ENABLE_AS].CLabelType = "1(1u/1u)";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "BSim3_3nmos";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Mosfet Transistor";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "BSim3_3nmos_XN";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "M?";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CPinListData.SetSize(3, 3);
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "d";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "s";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_NJFET_TRANSISTER_COMPONENT] = "JN";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "NJF";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].component_property_view_type = E_PROPERTY_FET;
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CLabelListData.SetSize(E_COMPONENT_FET_PARAMETERS + 1);
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelType = "L";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelType = "A";//was W
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelType = "M";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelValue = "0";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = "0";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelValue = "";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_ENABLE_AS].CLabelType = "1(1u/1u)";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "U309";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "N Channel Junction Fet";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "U309";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "J?";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = "1";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CPinListData.SetSize(3, 3);
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "d";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "s";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_PJFET_TRANSISTER_COMPONENT] = "JP";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "PJF";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].component_property_view_type = E_PROPERTY_FET;
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CLabelListData.SetSize(E_COMPONENT_FET_PARAMETERS + 1);
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelType = "L";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelType = "A";//was W
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelType = "M";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelValue = "0";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = "0";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelValue = "";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_ENABLE_AS].CLabelType = "1(1u/1u)";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "pjfet";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "P Channel Junction Fet";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "pjfet_XN";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "J?";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = "1";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CPinListData.SetSize(3, 3);
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "d";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "s";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_NGASFET_TRANSISTER_COMPONENT] = "Z";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "NMF";	
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].component_property_view_type = E_PROPERTY_MESFET;
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CLabelListData.SetSize(E_COMPONENT_FET_PARAMETERS + 1);
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelType = "L";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelType = "A";//was W
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelType = "M";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelValue = "0";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = "0";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelValue = "";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_ENABLE_AS].CLabelType = "1(1u/1u)";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CLabelListData.SetSize(E_COMPONENT_FET_PARAMETERS + 1);
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "ngasfet";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "N channel Gasfet";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "ngasfet_XN";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "J?";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = "1";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CPinListData.SetSize(3, 3);
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "d";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "s";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_PGASFET_TRANSISTER_COMPONENT] = "Z";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "PMF";	
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].component_property_view_type = E_PROPERTY_MESFET;
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CLabelListData.SetSize(E_COMPONENT_FET_PARAMETERS + 1);
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelType = "L";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelType = "A";//was W
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelType = "M";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelValue = "0";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = "0";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelValue = "";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_ENABLE_AS].CLabelType = "1(1u/1u)";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "pgasfet";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "P Channel Gasfet";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "pgasfet_XN";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "J?";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = "1";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CPinListData.SetSize(3, 3);
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "d";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "s";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	Setup3();
	Setup4();

	CString CPCBName;

	int count = CMDefaults.GetSize();

	for(p = 0; p < count; p++)
	{
		TCSchematicObjectData &CSchematicObjectData = CMDefaults[p];

		if(CReferanceDesignator[p] != "X")// sensible defaults for pcb names
		{
			CPCBName = CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

			CSchematicObjectData.CReserved.CStringArray[E_RESERVED_PCB_COMPONENT_NAME] = CPCBName;
		}
		else
		{
			CSchematicObjectData.CReserved.CStringArray[E_RESERVED_PCB_COMPONENT_NAME] = CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel;
		}
	}

	for(p = E_DC_VOLTAGE_SOURCE; p <= E_SINGLE_FREQ_CURRENT_FM ; p++)
	{
		TCSchematicObjectData &CSchematicObjectData = CMDefaults[p];

		CSchematicObjectData.CReserved.CIntArray[0] = false;
	}

	SetupSpiceNodeNames();
}

void TCSuperSpiceDataBase::SetupSymbolNames(void)
{
	CMDefaults[E_SUBCIRCUIT_COMPONENT].CSymbolData.CName = "(Subcircuit)";
	CMDefaults[E_BOX_WAVEFORM_CURSOR].CSymbolData.CName = "Box cursor";
	CMDefaults[E_WAVEFORM_COMPONENT].CSymbolData.CName = "(Waveform)";
	CMDefaults[E_POINTING_UP_PIN_COMPONENT].CSymbolData.CName = "PointingUpPin";
	CMDefaults[E_POINTING_DOWN_PIN_COMPONENT].CSymbolData.CName = "PointingDownPin";
	CMDefaults[E_POINTING_LEFT_PIN_COMPONENT].CSymbolData.CName = "PointingLeftPin";
	CMDefaults[E_POINTING_RIGHT_PIN_COMPONENT].CSymbolData.CName = "PointingRightPin";
	CMDefaults[E_SYMBOL_POINTING_UP_PIN_COMPONENT].CSymbolData.CName = "Symbol Pin Up";
	CMDefaults[E_SYMBOL_POINTING_DOWN_PIN_COMPONENT].CSymbolData.CName = "Symbol Pin Down";
	CMDefaults[E_SYMBOL_POINTING_LEFT_PIN_COMPONENT].CSymbolData.CName = "Symbol Pin Left";
	CMDefaults[E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT].CSymbolData.CName = "Symbol Pin Right";
	CMDefaults[E_SYMBOL_CURVE_COMPONENT].CSymbolData.CName = "Symbol Pin Curve";


	CMDefaults[E_WIRE_COMPONENT].CSymbolData.CName = "Wire";
	CMDefaults[E_CONNECTION_DOT].CSymbolData.CName = "ConnectionDot";
	CMDefaults[E_LABEL_COMPONENT].CSymbolData.CName = "Label";
	CMDefaults[E_TEST_MARKER].CSymbolData.CName = "TestMarker";
	CMDefaults[E_CONNECTER_POWER].CSymbolData.CName = "Power Connector";
	CMDefaults[E_PAGE_CONNECTER_INPUT].CSymbolData.CName = "InputConnector";
	CMDefaults[E_PAGE_CONNECTER_OUTPUT].CSymbolData.CName = "OutputConnector";
	CMDefaults[E_PAGE_CONNECTER_BIDIRECTIONAL].CSymbolData.CName = "BiDirectionalConector";
	CMDefaults[E_CURVE_COMPONENT].CSymbolData.CName = "Curve component";

	CMDefaults[E_SUBCIRCUIT_PIN_CONNECTER].CSymbolData.CName = "Subcircuit Pin Connector";
	CMDefaults[E_LAPLACE_TRANSFORM].CSymbolData.CName = "Laplace Transform";
	CMDefaults[E_GROUND].CSymbolData.CName = "Ground";

	CMDefaults[E_DC_VOLTAGE_SOURCE].CSymbolData.CName = "DCVoltageGenerator";
	CMDefaults[E_SINE_VOLTAGE_SOURCE].CSymbolData.CName = "SineVoltageGenerator";
	CMDefaults[E_PULSE_VOLTAGE_SOURCE].CSymbolData.CName = "PulseVoltageGenerator";
	CMDefaults[E_EXPONENTIAL_VOLTAGE_SOURCE].CSymbolData.CName = "ExpVoltageGenerator";
	CMDefaults[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE].CSymbolData.CName = "PWLVoltageGenerator";
	CMDefaults[E_SINGLE_FREQ_VOLTAGE_FM].CSymbolData.CName = "SFFMVoltageGenerator";
	CMDefaults[E_DC_CURRENT_SOURCE].CSymbolData.CName = "DCCurrentGenerator";
	CMDefaults[E_SINE_CURRENT_SOURCE].CSymbolData.CName = "SineCurrentGenerator";
	CMDefaults[E_PULSE_CURRENT_SOURCE].CSymbolData.CName = "PulseCurrentGenerator";
	CMDefaults[E_EXPONENTIAL_CURRENT_SOURCE].CSymbolData.CName = "ExpCurrentGenerator";
	CMDefaults[E_PIECEWISE_LINEAR_CURRENT_SOURCE].CSymbolData.CName = "PWLCurrentGenerator";
	CMDefaults[E_SINGLE_FREQ_CURRENT_FM].CSymbolData.CName = "SFFMCurrentGenerator";

	CMDefaults[E_RESISTOR_COMPONENT].CSymbolData.CName = "Resistor";
	CMDefaults[E_IC_RESISTOR_COMPONENT].CSymbolData.CName = "ICResistor";
	CMDefaults[E_CAPACITOR_COMPONENT].CSymbolData.CName = "Capacitor";
	CMDefaults[E_IC_CAPACITOR_COMPONENT].CSymbolData.CName = "ICCapacitor";
	CMDefaults[E_INDUCTOR_COMPONENT].CSymbolData.CName = "Inductor";
	
	CMDefaults[E_DIODE_COMPONENT].CSymbolData.CName = "Diode";
	CMDefaults[E_ZENER_COMPONENT].CSymbolData.CName = "Zener";
	CMDefaults[E_SHOTTKY_COMPONENT].CSymbolData.CName = "Schottky";

	
	CMDefaults[E_NPN_TRANSISTER_COMPONENT].CSymbolData.CName = "NPN3Terminal";
	CMDefaults[E_PNP_TRANSISTER_COMPONENT].CSymbolData.CName = "PNP3Terminal";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CSymbolData.CName = "NPN4Terminal";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CSymbolData.CName = "PNP4Terminal";


	CMDefaults[E_NMOS_TRANSISTER_COMPONENT].CSymbolData.CName = "NMOS3Terminal";
	CMDefaults[E_PMOS_TRANSISTER_COMPONENT].CSymbolData.CName = "PMOS3Terminal";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CSymbolData.CName = "NMOS4Terminal";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CSymbolData.CName = "PMOS4Terminal";
	CMDefaults[E_NJFET_TRANSISTER_COMPONENT].CSymbolData.CName = "NJFET3terminal";
	CMDefaults[E_PJFET_TRANSISTER_COMPONENT].CSymbolData.CName = "PJFET3terminal";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CSymbolData.CName = "NJFET4terminal";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CSymbolData.CName = "PJFET4terminal";
	CMDefaults[E_NGASFET_TRANSISTER_COMPONENT].CSymbolData.CName = "NGASFET3Terminal";
	CMDefaults[E_PGASFET_TRANSISTER_COMPONENT].CSymbolData.CName = "PGASFET3Terminal";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CSymbolData.CName = "NGASFET4Terminal";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CSymbolData.CName = "PGASFET4Terminal";

	CMDefaults[E_VCVSRC_COMPONENT].CSymbolData.CName = "VCVS";
	CMDefaults[E_ICVSRC_COMPONENT].CSymbolData.CName = "ICVS";
	CMDefaults[E_VCISRC_COMPONENT].CSymbolData.CName = "VCIC";
	CMDefaults[E_ICISRC_COMPONENT].CSymbolData.CName = "ICIC";
	CMDefaults[E_NONLINEAR_DEPENDANT_SOURCE].CSymbolData.CName = "NonlinearControlledSource";

	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CSymbolData.CName = "TransmissionLine";

	CMDefaults[E_VSWITCH_COMPONENT].CSymbolData.CName = "VSwitch";
	CMDefaults[E_ISWITCH_COMPONENT].CSymbolData.CName = "ISwitch";

	CMDefaults[E_TRANSFORMER_COMPONENT].CSymbolData.CName = "Transformer4Terminal";

	
	CMDefaults[E_5_PIN_OP_AMP_COMPONENT].CSymbolData.CName = "OpAmp5Pin";
	CMDefaults[E_7_PIN_OPAMP_COMPONENT].CSymbolData.CName = "OpAmp7Pin";
	CMDefaults[E_8_PIN_OP_AMP_COMPONENT].CSymbolData.CName = "OpAmp8Pin";
	CMDefaults[E_14_PIN_OP_AMP_COMPONENT].CSymbolData.CName = "OpAmp14Pin";
	CMDefaults[E_COMPONENT_DIVIDER].CSymbolData.CName = "Divider";

	CMDefaults[E_TRIODE_VALVE].CSymbolData.CName = "Triode";
	CMDefaults[E_TETRODE_VALVE].CSymbolData.CName = "Tetrode";
	CMDefaults[E_PENTODE_VALVE].CSymbolData.CName = "Pentode";

	CMDefaults[E_DIAC_COMPONENT].Rename("Diac");
	CMDefaults[E_NIGBP_COMPONENT].Rename("NIGBP");
	CMDefaults[E_PIGBP_COMPONENT].Rename("PIGBP");
	CMDefaults[E_THRYSISTER_COMPONENT].Rename("Thyrsistor");
	CMDefaults[E_GTO_COMPONENT].Rename("GTO");
	CMDefaults[E_TRIAC_COMPONENT].Rename("Triac");
	CMDefaults[E_DUAL_GATE_NMOSFET].Rename("DualGateNMOS4Terminal");
	CMDefaults[E_DUAL_GATE_PMOSFET].Rename("DualGatePMOS4Terminal");
	CMDefaults[E_UNIJUNCTION_COMPONENT].Rename("NUnijunction3terminal");

	CMDefaults[E_BUFFER_COMPONENT].Rename("Buffer");
	CMDefaults[E_MULIPLIER_COMPONENT].Rename("Multiplier");
	CMDefaults[E_VCA_COMPONENT].Rename("VCA");

	CMDefaults[E_GENERIC_2INPUT_AMP].CSymbolData.CName = "2InputAmp";

	CMDefaults[E_GENERIC_2_COMPONENT].Rename("2PinBlock");
	CMDefaults[E_GENERIC_3_COMPONENT].Rename("3PinBlock");
	CMDefaults[E_GENERIC_4_COMPONENT].Rename("4PinBlock");
	CMDefaults[E_GENERIC_5_COMPONENT].Rename("5PinBlock");
	CMDefaults[E_GENERIC_6_COMPONENT].Rename("6PinBlock");
	CMDefaults[E_GENERIC_7_COMPONENT].Rename("7PinBlock");
	CMDefaults[E_GENERIC_8_COMPONENT].Rename("8PinBlock");
	CMDefaults[E_GENERIC_9_COMPONENT].Rename("9PinBlock");
	CMDefaults[E_GENERIC_10_COMPONENT].Rename("10PinBlock");
	CMDefaults[E_GENERIC_11_COMPONENT].Rename("11PinBlock");
	CMDefaults[E_GENERIC_12_COMPONENT].Rename("12PinBlock");
	CMDefaults[E_GENERIC_13_COMPONENT].Rename("13PinBlock");
	CMDefaults[E_GENERIC_14_COMPONENT].Rename("14PinBlock");
	CMDefaults[E_GENERIC_15_COMPONENT].Rename("15PinBlock");
	CMDefaults[E_GENERIC_16_COMPONENT].Rename("16PinBlock");
	CMDefaults[E_GENERIC_17_COMPONENT].Rename("17PinBlock");
	CMDefaults[E_GENERIC_18_COMPONENT].Rename("18PinBlock");
	CMDefaults[E_GENERIC_19_COMPONENT].Rename("19PinBlock");
	CMDefaults[E_GENERIC_20_COMPONENT].Rename("20PinBlock");

	CMDefaults[E_NAND_GATE].CSymbolData.CName = "Analog NANDGATE";
	CMDefaults[E_NOR_GATE].CSymbolData.CName = "Analog NOR";
	CMDefaults[E_OR_GATE].CSymbolData.CName = "Analog OR";
	CMDefaults[E_AND_GATE].CSymbolData.CName = "Analog AND";
	CMDefaults[E_EXCLUSIVE_OR].CSymbolData.CName = "Analog Ex-Or";
	CMDefaults[E_EXCLUSIVE_NOR].CSymbolData.CName = "Analog Ex-Nor";
	CMDefaults[E_INVERTOR].CSymbolData.CName = "Analog Invertor";
	CMDefaults[E_SCHMITT_TRIGGER].CSymbolData.CName = "Analog Schmitt";
	CMDefaults[E_DTYPE].CSymbolData.CName = "Analog DType";
	CMDefaults[E_JKTYPE].CSymbolData.CName = "Analog JK";
	CMDefaults[E_8BIT_COUNTER].CSymbolData.CName = "Analog Counter";
	CMDefaults[E_LOSSLESS_TRANSMISSION_LINE_COMPONENT].CSymbolData.CName = "URC Transmission Line";
	CMDefaults[E_OPTO_COUPLER].CSymbolData.CName = "Opto Coupler";
	CMDefaults[E_NPN_DARLINGTON].CSymbolData.CName = "NPN Darlington";
	CMDefaults[E_PNP_DARLINGTON].CSymbolData.CName = "PNP Darlington";
	CMDefaults[E_FREQUENCY_CRYSTAL].CSymbolData.CName = "Crystal";
	CMDefaults[E_RESERVED_GENERIC_LDO].CSymbolData.CName = "LDO";

	CMDefaults[E_DIGITAL_AND].CSymbolData.CName = "Digital AND";
	CMDefaults[E_DIGITAL_NAND].CSymbolData.CName = "Digital NAND";
	CMDefaults[E_DIGITAL_OR].CSymbolData.CName = "Digital OR";
	CMDefaults[E_DIGITAL_NOR].CSymbolData.CName = "Digital NOR";
	CMDefaults[E_DIGITAL_EX_OR].CSymbolData.CName = "Digital EX-OR";
	CMDefaults[E_DIGITAL_EX_NOR].CSymbolData.CName = "Digital EX-NOR";
	CMDefaults[E_DIGITAL_INVERTOR].CSymbolData.CName = "Digital Invertor";
	CMDefaults[E_DIGITAL_SCHMITT_TRIGGER].CSymbolData.CName = "Digital Schmitt";// not sure yet if this makes sense
	CMDefaults[E_VARIABLE_RESISTOR].CSymbolData.CName = "Variable Resistor";

	CMDefaults[E_ANALOG_TO_DIGITAL].CSymbolData.CName = "A/D Interface";
	CMDefaults[E_DIGITAL_TO_ANALOG].CSymbolData.CName = "D/A Interface";

	CMDefaults[E_TRANSFORMER_DUAL].CSymbolData.CName = "Dual Transformer";
	CMDefaults[E_TRANSFORMER_TRIPLE].CSymbolData.CName = "Triple Transformer";
	CMDefaults[E_TRANSFORMER_QUAD].CSymbolData.CName = "Quad Transformer";

	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CSymbolData.CName = "Single Center Taped Transformer";
	CMDefaults[E_TRANSFORMER_DUAL_CENTERTAPED].CSymbolData.CName = "Dual Center Taped Transformer";
	CMDefaults[E_TRANSFORMER_TRIPLE_CENTERTAPED].CSymbolData.CName = "Triple Center Taped Transformer";
	CMDefaults[E_TRANSFORMER_QUAD_CENTERTAPED].CSymbolData.CName = "Quad Center Taped Transformer";
	CMDefaults[E_TRANSFORMER_ONE_CENTER_TAP].CSymbolData.CName = "One Center Taped Transformer";
	CMDefaults[E_TRANSFORMER_DUAL_ONE_CENTER_TAP].CSymbolData.CName = "Dual One Center Taped Transformer";

	CMDefaults[E_TRANSFORMER_TUBE_OUTPUT].CSymbolData.CName = "Tube Output Transformer";
	CMDefaults[E_TRANSFORMER_FLYBACK_TRIPLE].CSymbolData.CName = "Flyback Triple Transformer";

	CMDefaults[E_TUBE_DIODE_SINGLE].CSymbolData.CName = "Tube Diode";
	CMDefaults[E_TUBE_DIODE_DUAL_COMMON_CATHODE].CSymbolData.CName = "Tube Diode Common Cathode";
	CMDefaults[E_TUBE_DIODE_DUAL_INDIVIDUAL_CATHODES].CSymbolData.CName = "Tube Diode Seperate Cathodes";

	CMDefaults[E_VARISTOR_MOV].CSymbolData.CName = "Varistor/MOV";
	CMDefaults[E_SPICE_THERMISTOR].CSymbolData.CName = "Thermistor";
	CMDefaults[E_COMPONENT_FUSE].CSymbolData.CName = "Fuse";
	
	CMDefaults[E_INDUCTOR_COMPONENT_CORED].CSymbolData.CName = "Cored Inductor";

	CMDefaults[E_TUBE_8PIN].CSymbolData.CName = "Tube, 8 Pin";
	CMDefaults[E_TRIODE_VALVE_DUAL].CSymbolData.CName = "Triode, Dual";
	CMDefaults[E_TRIODE_VALVE_DUAL_HEATER].CSymbolData.CName = "Triode, Dual Heater";
	CMDefaults[E_TRIODE_VALVE_HEATER].CSymbolData.CName = "Triode, Heater";
	CMDefaults[E_TETRODE_VALVE_HEATER].CSymbolData.CName = "Tetrode, Heater";
	CMDefaults[E_PENTODE_VALVE_HEATER].CSymbolData.CName = "Pentode, Heater";
	CMDefaults[E_TUBE_DIODE_SINGLE_HEATER].CSymbolData.CName = "Tube Diode, Heater";
	CMDefaults[E_TUBE_DIODE_DUAL_COMMON_CATHODE_HEATER].CSymbolData.CName = "Tube Diode Common Cathode, Heater";
	CMDefaults[E_TUBE_DIODE_DUAL_INDIVIDUAL_CATHODES_HEATER].CSymbolData.CName = "Tube Diode Seperate Cathodes, Heater";
	CMDefaults[E_TUBE_DIODE_COMMON_CATHODE_HEATER].CSymbolData.CName = "Tube Diode, Common Heater";
	CMDefaults[E_TUBE_TRIODE_COMMON_CATHODE_HEATER].CSymbolData.CName = "Tube Triode, Common Heater";
	CMDefaults[E_TUBE_DIODE_DUAL_CATHODE_HEATER].CSymbolData.CName = "Tube Dual Diode, Common Heater";

	CMDefaults[E_MOTER].CSymbolData.CName = "Motor";
	CMDefaults[E_MOTER_TACHO].CSymbolData.CName = "Motor with Tacho";
	CMDefaults[E_CCFL].CSymbolData.CName = "Florecent Lamp";

	CMDefaults[E_TITLE_BLOCK].CSymbolData.CName = "Title:";

	CMDefaults[E_DIGITAL_AND_3IN].CSymbolData.CName = "Digital 4Input AND";
	CMDefaults[E_DIGITAL_NAND_3IN].CSymbolData.CName = "Digital 4Input NAND";
	CMDefaults[E_DIGITAL_OR_3IN].CSymbolData.CName = "Digital 4Input OR";
	CMDefaults[E_DIGITAL_NOR_3IN].CSymbolData.CName = "Digital 3Input NOR";

	CMDefaults[E_ANALOG_AND_3IN].CSymbolData.CName = "Analog 4Input AND";
	CMDefaults[E_ANALOG_NAND_3IN].CSymbolData.CName = "Analog 4Input NAND";
	CMDefaults[E_ANALOG_OR_3IN].CSymbolData.CName = "Analog 4Input OR";
	CMDefaults[E_ANALOG_NOR_3IN].CSymbolData.CName = "Analog 4Input NOR";

	int count = CMDefaults.GetSize();

	CString CSystemDir = GetSuperSpiceSystemDir();
	CString CDefaultLibName = "GenericDemos.lib";

	CString CPCBName;

	for(int p = 0; p < count; p++)
	{
		TCSchematicObjectData &CSchematicObjectData = CMDefaults[p];

		CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFilePath = CSystemDir;
		
		switch(p)
		{
			case E_RESISTOR_COMPONENT:
			case E_INDUCTOR_COMPONENT:
			case E_CAPACITOR_COMPONENT:
			case E_IC_RESISTOR_COMPONENT:
			case E_IC_CAPACITOR_COMPONENT:

			CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFilePath = GetInitDirectory();
				
			CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName = GCSuperSpiceDataBase.CSuperSpiceModelLibName; break;
	

			case E_VCISRC_COMPONENT:
			case E_ICISRC_COMPONENT:
//			case E_NONLINEAR_DEPENDANT_SOURCE: // Oct 2017 removed default
				
			CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName = "Functional.lib"; break;
			
			case E_TRIODE_VALVE:
			case E_PENTODE_VALVE:
			case E_TETRODE_VALVE:
			case E_TUBE_DIODE_SINGLE:
			case E_TUBE_DIODE_DUAL_COMMON_CATHODE:
			case E_TUBE_DIODE_DUAL_INDIVIDUAL_CATHODES:
			case E_TUBE_8PIN:
			case E_TRIODE_VALVE_DUAL:
			case E_TRIODE_VALVE_DUAL_HEATER:
			case E_TRIODE_VALVE_HEATER:
			case E_PENTODE_VALVE_HEATER:
			case E_TETRODE_VALVE_HEATER:
			case E_TUBE_DIODE_SINGLE_HEATER:
			case E_TUBE_DIODE_DUAL_COMMON_CATHODE_HEATER:
			case E_TUBE_DIODE_DUAL_INDIVIDUAL_CATHODES_HEATER:
				
			CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName = "Tubes.lib";break;

			case E_INDUCTOR_COMPONENT_CORED:
			case E_TRANSFORMER_COMPONENT:
			case E_TRANSFORMER_DUAL:
			case E_TRANSFORMER_TRIPLE:
			case E_TRANSFORMER_QUAD:
			case E_TRANSFORMER_SINGLE_CENTERTAPED:
			case E_TRANSFORMER_DUAL_CENTERTAPED:
			case E_TRANSFORMER_TRIPLE_CENTERTAPED:
			case E_TRANSFORMER_QUAD_CENTERTAPED:
			case E_TRANSFORMER_TUBE_OUTPUT:
			case E_TRANSFORMER_FLYBACK_TRIPLE:

			CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName = "Transformers.lib";break;

			case E_DIGITAL_AND:
			case E_DIGITAL_NAND:
			case E_DIGITAL_OR:
			case E_DIGITAL_NOR:
			case E_DIGITAL_EX_OR:
			case E_DIGITAL_EX_NOR:
			case E_DIGITAL_INVERTOR:
			case E_DIGITAL_SCHMITT_TRIGGER:
			case E_ANALOG_TO_DIGITAL:
			case E_DIGITAL_TO_ANALOG:

			CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName = "XSpiceDigital.lib";break;

			case E_NAND_GATE:
			case E_NOR_GATE:
			case E_AND_GATE:
			case E_OR_GATE:		 
			case E_EXCLUSIVE_OR:
			case E_EXCLUSIVE_NOR:
			case E_INVERTOR:
			case E_SCHMITT_TRIGGER:
			case E_DTYPE:
			case E_JKTYPE:
			case E_8BIT_COUNTER:

			CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName = "AnalogueDigitalLogic.lib";break;

			case E_VARIABLE_RESISTOR:			
			case E_LAPLACE_TRANSFORM:
			case E_MULIPLIER_COMPONENT:
			case E_COMPONENT_DIVIDER:

			CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName = "XSpiceAnalogue.lib";break;

			default: CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName = CDefaultLibName;
		}

		CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = CSchematicObjectData.CSymbolData.CName;
	}
}

void TCSuperSpiceDataBase::SetupSpiceNodeNames(void)
{
	CSpiceNodeNames.SetSize(E_NUMBER_OF_BASIC_SPICE_TYPES_VER1);
	CSpiceNodeParameterStartIndex.SetSize(E_NUMBER_OF_BASIC_SPICE_TYPES_VER1);

	int count = CSpiceNodeNames.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{
		CSpiceNodeNames[p].basic_spice_type = p;
		CSpiceNodeParameterStartIndex[p]	= 0;
	}

	CSpiceNodeNames[E_SPICE_NULL].CBasicSpiceType = "X";
	CSpiceNodeNames[E_SPICE_NULL].CDeviceNodes.SetSize(1);
	CSpiceNodeNames[E_SPICE_NULL].CDeviceNodes[0] = "i";

	CSpiceNodeNames[E_SPICE_R].CBasicSpiceType = "R";
	CSpiceNodeNames[E_SPICE_R].CDeviceNodes.SetSize(3);
	CSpiceNodeParameterStartIndex[E_SPICE_R] = 3;
	CSpiceNodeNames[E_SPICE_R].CDeviceNodes[0] = "i";
	CSpiceNodeNames[E_SPICE_R].CDeviceNodes[1] = "-i";
	CSpiceNodeNames[E_SPICE_R].CDeviceNodes[2] = "p";

	CSpiceNodeNames[E_SPICE_L].CBasicSpiceType = "L";
	CSpiceNodeNames[E_SPICE_L].CDeviceNodes.SetSize(4);
	CSpiceNodeParameterStartIndex[E_SPICE_L] = 3;
	CSpiceNodeNames[E_SPICE_L].CDeviceNodes[0] = "i";
	CSpiceNodeNames[E_SPICE_L].CDeviceNodes[1] = "-i";
	CSpiceNodeNames[E_SPICE_L].CDeviceNodes[2] = "p";
	CSpiceNodeNames[E_SPICE_L].CDeviceNodes[3] = "flux";

	CSpiceNodeNames[E_SPICE_C].CBasicSpiceType = "C";
	CSpiceNodeNames[E_SPICE_C].CDeviceNodes.SetSize(3);
	CSpiceNodeParameterStartIndex[E_SPICE_C] = 3;
	CSpiceNodeNames[E_SPICE_C].CDeviceNodes[0] = "i";
	CSpiceNodeNames[E_SPICE_C].CDeviceNodes[1] = "-i";
	CSpiceNodeNames[E_SPICE_C].CDeviceNodes[2] = "p";

	CSpiceNodeNames[E_SPICE_SW].CBasicSpiceType = "SW";
	CSpiceNodeNames[E_SPICE_SW].CDeviceNodes.SetSize(2);
	CSpiceNodeParameterStartIndex[E_SPICE_SW] = 2;
	CSpiceNodeNames[E_SPICE_SW].CDeviceNodes[0] = "i";
	CSpiceNodeNames[E_SPICE_SW].CDeviceNodes[1] = "-i";
//	CSpiceNodeNames[E_SPICE_SW].CDeviceNodes[2] = "cont_n_node";
//	CSpiceNodeNames[E_SPICE_SW].CDeviceNodes[3] = "cont_p_node";
//	CSpiceNodeNames[E_SPICE_SW].CDeviceNodes[4] = "p";
 
	CSpiceNodeNames[E_SPICE_CSW].CBasicSpiceType = "CSW";
	CSpiceNodeNames[E_SPICE_CSW].CDeviceNodes.SetSize(2);
	CSpiceNodeParameterStartIndex[E_SPICE_CSW] = 2;
	CSpiceNodeNames[E_SPICE_CSW].CDeviceNodes[0] = "i";
	CSpiceNodeNames[E_SPICE_CSW].CDeviceNodes[1] = "-i";
//	CSpiceNodeNames[E_SPICE_CSW].CDeviceNodes[2] = "cont_n_node";
//	CSpiceNodeNames[E_SPICE_CSW].CDeviceNodes[3] = "cont_p_node";
//	CSpiceNodeNames[E_SPICE_CSW].CDeviceNodes[4] = "p";


	// Transmission line currents code here works, but has been disabled because
	// The engine has a problem.
	CSpiceNodeNames[E_SPICE_URC].CBasicSpiceType = "URC";
/*	CSpiceNodeNames[E_SPICE_URC].CDeviceNodes.SetSize(2);
	CSpiceNodeNames[E_SPICE_URC].CDeviceNodes[0] = "i1";
	CSpiceNodeNames[E_SPICE_URC].CDeviceNodes[1] = "i2";
	CSpiceNodeParameterStartIndex[E_SPICE_URC] = 2;*/

	CSpiceNodeNames[E_SPICE_LTRA].CBasicSpiceType = "LTRA";
/*	CSpiceNodeNames[E_SPICE_LTRA].CDeviceNodes.SetSize(2);
	CSpiceNodeNames[E_SPICE_LTRA].CDeviceNodes[0] = "i1";
	CSpiceNodeNames[E_SPICE_LTRA].CDeviceNodes[1] = "i2";
	CSpiceNodeParameterStartIndex[E_SPICE_LTRA] = 2;*/

	CSpiceNodeNames[E_SPICE_LLTL].CBasicSpiceType = "T";
/*	CSpiceNodeNames[E_SPICE_LLTL].CDeviceNodes.SetSize(2);
	CSpiceNodeNames[E_SPICE_LLTL].CDeviceNodes[0] = "i1";
	CSpiceNodeNames[E_SPICE_LLTL].CDeviceNodes[1] = "i2";
	CSpiceNodeParameterStartIndex[E_SPICE_LLTL] = 2;*/

	CSpiceNodeNames[E_SPICE_D].CBasicSpiceType = "D";
	CSpiceNodeNames[E_SPICE_D].CDeviceNodes.SetSize(5);
	CSpiceNodeParameterStartIndex[E_SPICE_D] = 3;
	CSpiceNodeNames[E_SPICE_D].CDeviceNodes[0] = "id";
	CSpiceNodeNames[E_SPICE_D].CDeviceNodes[1] = "-id";
	CSpiceNodeNames[E_SPICE_D].CDeviceNodes[2] = "p";
	CSpiceNodeNames[E_SPICE_D].CDeviceNodes[3] = "gd";
	CSpiceNodeNames[E_SPICE_D].CDeviceNodes[4] = "vd";

	CSpiceNodeNames[E_SPICE_NPN].CBasicSpiceType = "NPN";
	CSpiceNodeNames[E_SPICE_NPN].CDeviceNodes.SetSize(10);
	CSpiceNodeParameterStartIndex[E_SPICE_NPN] = 5;
	CSpiceNodeNames[E_SPICE_NPN].CDeviceNodes[0] = "ic";
	CSpiceNodeNames[E_SPICE_NPN].CDeviceNodes[1] = "ib";
	CSpiceNodeNames[E_SPICE_NPN].CDeviceNodes[2] = "ie";
	CSpiceNodeNames[E_SPICE_NPN].CDeviceNodes[3] = "is";

	CSpiceNodeNames[E_SPICE_NPN].CDeviceNodes[4] = "p";  // power
	CSpiceNodeNames[E_SPICE_NPN].CDeviceNodes[5] = "gm";
	CSpiceNodeNames[E_SPICE_NPN].CDeviceNodes[6] = "vbe";
	CSpiceNodeNames[E_SPICE_NPN].CDeviceNodes[7] = "vce"; // Changed from vbc 13th Oct 2017
	CSpiceNodeNames[E_SPICE_NPN].CDeviceNodes[8] = "gpi"; // input conductance hie
	CSpiceNodeNames[E_SPICE_NPN].CDeviceNodes[9] = "go";  // output conductance


	CSpiceNodeNames[E_SPICE_PNP].CBasicSpiceType = "PNP";
	CSpiceNodeNames[E_SPICE_PNP].CDeviceNodes.SetSize(10);
	CSpiceNodeParameterStartIndex[E_SPICE_PNP] = 5;
	CSpiceNodeNames[E_SPICE_PNP].CDeviceNodes[0] = "ic";
	CSpiceNodeNames[E_SPICE_PNP].CDeviceNodes[1] = "ib";
	CSpiceNodeNames[E_SPICE_PNP].CDeviceNodes[2] = "ie";
	CSpiceNodeNames[E_SPICE_PNP].CDeviceNodes[3] = "is";

	CSpiceNodeNames[E_SPICE_PNP].CDeviceNodes[4] = "p";  // power
	CSpiceNodeNames[E_SPICE_PNP].CDeviceNodes[5] = "gm";
	CSpiceNodeNames[E_SPICE_PNP].CDeviceNodes[6] = "vbe";
	CSpiceNodeNames[E_SPICE_PNP].CDeviceNodes[7] = "vce"; // Changed from vbc 13th Oct 2017
	CSpiceNodeNames[E_SPICE_PNP].CDeviceNodes[8] = "gpi"; // input conductance hie
	CSpiceNodeNames[E_SPICE_PNP].CDeviceNodes[9] = "go";  // output conductance 

	CSpiceNodeNames[E_SPICE_NJF].CBasicSpiceType = "NJF";
	CSpiceNodeNames[E_SPICE_NJF].CDeviceNodes.SetSize(7);
	CSpiceNodeParameterStartIndex[E_SPICE_NJF] = 5;
	CSpiceNodeNames[E_SPICE_NJF].CDeviceNodes[0] = "id";
	CSpiceNodeNames[E_SPICE_NJF].CDeviceNodes[1] = "ig";
	CSpiceNodeNames[E_SPICE_NJF].CDeviceNodes[2] = "is";
	CSpiceNodeNames[E_SPICE_NJF].CDeviceNodes[3] = "igd";
	CSpiceNodeNames[E_SPICE_NJF].CDeviceNodes[4] = "p";
	CSpiceNodeNames[E_SPICE_NJF].CDeviceNodes[5] = "gm";
	CSpiceNodeNames[E_SPICE_NJF].CDeviceNodes[6] = "vgs";
	
	CSpiceNodeNames[E_SPICE_PJF].CBasicSpiceType = "PJF";
	CSpiceNodeNames[E_SPICE_PJF].CDeviceNodes.SetSize(7);
	CSpiceNodeParameterStartIndex[E_SPICE_PJF] = 5;
	CSpiceNodeNames[E_SPICE_PJF].CDeviceNodes[0] = "id";
	CSpiceNodeNames[E_SPICE_PJF].CDeviceNodes[1] = "ig";
	CSpiceNodeNames[E_SPICE_PJF].CDeviceNodes[2] = "is";
	CSpiceNodeNames[E_SPICE_PJF].CDeviceNodes[3] = "igd";
	CSpiceNodeNames[E_SPICE_PJF].CDeviceNodes[4] = "p";
	CSpiceNodeNames[E_SPICE_PJF].CDeviceNodes[5] = "gm";
	CSpiceNodeNames[E_SPICE_PJF].CDeviceNodes[6] = "vgs";

	CSpiceNodeNames[E_SPICE_NMOS].CBasicSpiceType = "NMOS";
	CSpiceNodeNames[E_SPICE_NMOS].CDeviceNodes.SetSize(16);
	CSpiceNodeParameterStartIndex[E_SPICE_NMOS] = 5;
	CSpiceNodeNames[E_SPICE_NMOS].CDeviceNodes[0] = "id";
	CSpiceNodeNames[E_SPICE_NMOS].CDeviceNodes[1] = "ig";
	CSpiceNodeNames[E_SPICE_NMOS].CDeviceNodes[2] = "is";
	CSpiceNodeNames[E_SPICE_NMOS].CDeviceNodes[3] = "ib";
	CSpiceNodeNames[E_SPICE_NMOS].CDeviceNodes[4] = "p";
	CSpiceNodeNames[E_SPICE_NMOS].CDeviceNodes[5] = "gm";
	CSpiceNodeNames[E_SPICE_NMOS].CDeviceNodes[6] = "vgs";
	CSpiceNodeNames[E_SPICE_NMOS].CDeviceNodes[7] = "vdsat";
	CSpiceNodeNames[E_SPICE_NMOS].CDeviceNodes[8] = "vds";
	CSpiceNodeNames[E_SPICE_NMOS].CDeviceNodes[9] = "vgst";
	CSpiceNodeNames[E_SPICE_NMOS].CDeviceNodes[10] = "vth";
	CSpiceNodeNames[E_SPICE_NMOS].CDeviceNodes[11] = "gds";
	CSpiceNodeNames[E_SPICE_NMOS].CDeviceNodes[12] = "gmbs";
	CSpiceNodeNames[E_SPICE_NMOS].CDeviceNodes[13] = "cgs";
	CSpiceNodeNames[E_SPICE_NMOS].CDeviceNodes[14] = "cgd";
	CSpiceNodeNames[E_SPICE_NMOS].CDeviceNodes[15] = "cgb"; // Added 27th Sept

	CSpiceNodeNames[E_SPICE_PMOS].CBasicSpiceType = "PMOS";
	CSpiceNodeNames[E_SPICE_PMOS].CDeviceNodes.SetSize(16);
	CSpiceNodeParameterStartIndex[E_SPICE_PMOS] = 5;
	CSpiceNodeNames[E_SPICE_PMOS].CDeviceNodes[0] = "id";
	CSpiceNodeNames[E_SPICE_PMOS].CDeviceNodes[1] = "ig";
	CSpiceNodeNames[E_SPICE_PMOS].CDeviceNodes[2] = "is";
	CSpiceNodeNames[E_SPICE_PMOS].CDeviceNodes[3] = "ib";
	CSpiceNodeNames[E_SPICE_PMOS].CDeviceNodes[4] = "p";
	CSpiceNodeNames[E_SPICE_PMOS].CDeviceNodes[5] = "gm";
	CSpiceNodeNames[E_SPICE_PMOS].CDeviceNodes[6] = "vgs";
	CSpiceNodeNames[E_SPICE_PMOS].CDeviceNodes[7] = "vdsat";
	CSpiceNodeNames[E_SPICE_PMOS].CDeviceNodes[8] = "vds";
	CSpiceNodeNames[E_SPICE_PMOS].CDeviceNodes[9] = "vgst";
	CSpiceNodeNames[E_SPICE_PMOS].CDeviceNodes[10] = "vth";
	CSpiceNodeNames[E_SPICE_PMOS].CDeviceNodes[11] = "gds";
	CSpiceNodeNames[E_SPICE_PMOS].CDeviceNodes[12] = "gmbs";
	CSpiceNodeNames[E_SPICE_PMOS].CDeviceNodes[13] = "cgs";
	CSpiceNodeNames[E_SPICE_PMOS].CDeviceNodes[14] = "cgd";
	CSpiceNodeNames[E_SPICE_PMOS].CDeviceNodes[15] = "cgb"; // Added 27th Sept

	CSpiceNodeNames[E_SPICE_NMF].CBasicSpiceType = "NMF";
	CSpiceNodeNames[E_SPICE_NMF].CDeviceNodes.SetSize(7);
	CSpiceNodeParameterStartIndex[E_SPICE_NMF] = 5;
	CSpiceNodeNames[E_SPICE_NMF].CDeviceNodes[0] = "id";
	CSpiceNodeNames[E_SPICE_NMF].CDeviceNodes[1] = "ig";
	CSpiceNodeNames[E_SPICE_NMF].CDeviceNodes[2] = "is";
	CSpiceNodeNames[E_SPICE_NMF].CDeviceNodes[3] = "ib";
	CSpiceNodeNames[E_SPICE_NMF].CDeviceNodes[4] = "p";
	CSpiceNodeNames[E_SPICE_NMF].CDeviceNodes[5] = "gm";
	CSpiceNodeNames[E_SPICE_NMF].CDeviceNodes[6] = "vgs";

	CSpiceNodeNames[E_SPICE_PMF].CBasicSpiceType = "PMF";
	CSpiceNodeNames[E_SPICE_PMF].CDeviceNodes.SetSize(7);
	CSpiceNodeParameterStartIndex[E_SPICE_PMF] = 5;
	CSpiceNodeNames[E_SPICE_PMF].CDeviceNodes[0] = "id";
	CSpiceNodeNames[E_SPICE_PMF].CDeviceNodes[1] = "ig";
	CSpiceNodeNames[E_SPICE_PMF].CDeviceNodes[2] = "is";
	CSpiceNodeNames[E_SPICE_PMF].CDeviceNodes[3] = "ib";
	CSpiceNodeNames[E_SPICE_PMF].CDeviceNodes[4] = "p";
	CSpiceNodeNames[E_SPICE_PMF].CDeviceNodes[5] = "gm";
	CSpiceNodeNames[E_SPICE_PMF].CDeviceNodes[6] = "vgs";

	CSpiceNodeNames[E_SPICE_B].CBasicSpiceType = "B";
	CSpiceNodeNames[E_SPICE_B].CDeviceNodes.SetSize(2);
	CSpiceNodeParameterStartIndex[E_SPICE_B] = 3;
	CSpiceNodeNames[E_SPICE_B].CDeviceNodes[0] = "i";
	CSpiceNodeNames[E_SPICE_B].CDeviceNodes[1] = "-i";

	CSpiceNodeNames[E_SPICE_E].CBasicSpiceType = "E";
	CSpiceNodeNames[E_SPICE_E].CDeviceNodes.SetSize(2);
	CSpiceNodeParameterStartIndex[E_SPICE_E] = 3;
	CSpiceNodeNames[E_SPICE_E].CDeviceNodes[0] = "i";
	CSpiceNodeNames[E_SPICE_E].CDeviceNodes[1] = "-i";

	CSpiceNodeNames[E_SPICE_G].CBasicSpiceType = "G";
	CSpiceNodeNames[E_SPICE_G].CDeviceNodes.SetSize(2);
	CSpiceNodeParameterStartIndex[E_SPICE_G] = 3;
	CSpiceNodeNames[E_SPICE_G].CDeviceNodes[0] = "i";
	CSpiceNodeNames[E_SPICE_G].CDeviceNodes[1] = "-i";

	CSpiceNodeNames[E_SPICE_H].CBasicSpiceType = "H";
	CSpiceNodeNames[E_SPICE_H].CDeviceNodes.SetSize(2);
	CSpiceNodeParameterStartIndex[E_SPICE_H] = 3;
	CSpiceNodeNames[E_SPICE_H].CDeviceNodes[0] = "i";
	CSpiceNodeNames[E_SPICE_H].CDeviceNodes[1] = "-i";

	CSpiceNodeNames[E_SPICE_F].CBasicSpiceType = "F";
	CSpiceNodeNames[E_SPICE_F].CDeviceNodes.SetSize(2);
	CSpiceNodeParameterStartIndex[E_SPICE_F] = 3;
	CSpiceNodeNames[E_SPICE_F].CDeviceNodes[0] = "i";
	CSpiceNodeNames[E_SPICE_F].CDeviceNodes[1] = "-i";

	int q = E_SPICE_VDC;
	CString CText;

	for(p = E_DC_VOLTAGE_SOURCE; p < E_RESISTOR_COMPONENT; p++)
	{
		CText = CMDefaults[p].CSpiceParameters.CDataBaseIdInfo.CRecordType;

		CSpiceNodeNames[q].CBasicSpiceType = CText;
		
		CSpiceNodeNames[q].CDeviceNodes.SetSize(3);
		CSpiceNodeNames[q].CDeviceNodes[0] = "i";
		CSpiceNodeNames[q].CDeviceNodes[1] = "-i";
		CSpiceNodeNames[q].CDeviceNodes[2] = "p";
		CSpiceNodeParameterStartIndex[q] = 3;

		q++;
	}
	
	CSpiceNodeNames[E_SPICE_VSRC].CDeviceNodes.SetSize(3);
	CSpiceNodeParameterStartIndex[E_SPICE_VSRC] = 3;
	CSpiceNodeNames[E_SPICE_VSRC].CDeviceNodes[0] = "i";
	CSpiceNodeNames[E_SPICE_VSRC].CDeviceNodes[1] = "-i";
	CSpiceNodeNames[E_SPICE_VSRC].CDeviceNodes[2] = "p";
	CSpiceNodeNames[E_SPICE_VSRC].CBasicSpiceType = "VSRC";

	CSpiceNodeNames[E_SPICE_XSPICE_DIGITAL].CBasicSpiceType = "A";
}