
#include "TDVersion.h"
#include "TEPropertyViewTypes.h"
#include "TESuperSpiceEnums.h"
#include "stdafx.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSuperSpiceGlobalData.h"



#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

void TCSuperSpiceDataBase::Setup3(void)
{

	CString CModelType = "MODEL";

	CMDefaults[E_NIGBP_COMPONENT].attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_NIGBP_COMPONENT].component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;// this needs a new dialog box when transformer is changed
	CMDefaults[E_NIGBP_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_NIGBP_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "2Nxxx";
	CMDefaults[E_NIGBP_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "N Type Insulated Gate Bipolar";
	CMDefaults[E_NIGBP_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "Q2Nxxx";
	CMDefaults[E_NIGBP_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	CMDefaults[E_NIGBP_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_NIGBP_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_NIGBP_COMPONENT].CPinListData.SetSize(3, 3);
	CMDefaults[E_NIGBP_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NIGBP_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NIGBP_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NIGBP_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "c";
	CMDefaults[E_NIGBP_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_NIGBP_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NIGBP_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NIGBP_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g";
	CMDefaults[E_NIGBP_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_NIGBP_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NIGBP_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NIGBP_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "e";
	CMDefaults[E_NIGBP_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_NIGBP_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NIGBP_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CMDefaults[E_PIGBP_COMPONENT].attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_PIGBP_COMPONENT].component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;// this needs a new dialog box when transformer is changed
	CMDefaults[E_PIGBP_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_PIGBP_COMPONENT].mirror_state = E_MIRRORED_NORMAL;
	CMDefaults[E_PIGBP_COMPONENT].rotation_state = E_THIRD_QUADRANT;
	CMDefaults[E_PIGBP_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "2Nxxx";
	CMDefaults[E_PIGBP_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "P Type Insulated Gate Bipolar";
	CMDefaults[E_PIGBP_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "XIGBP";
	CMDefaults[E_PIGBP_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	CMDefaults[E_PIGBP_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_PIGBP_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_PIGBP_COMPONENT].CPinListData.SetSize(3, 3);
	CMDefaults[E_PIGBP_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PIGBP_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PIGBP_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PIGBP_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "c";
	CMDefaults[E_PIGBP_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_PIGBP_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PIGBP_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PIGBP_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g";
	CMDefaults[E_PIGBP_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_PIGBP_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PIGBP_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PIGBP_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "e";
	CMDefaults[E_PIGBP_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_PIGBP_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PIGBP_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
 
	CMDefaults[E_THRYSISTER_COMPONENT].attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_THRYSISTER_COMPONENT].component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;// this needs a new dialog box when transformer is changed
	CMDefaults[E_THRYSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_THRYSISTER_COMPONENT].mirror_state = E_MIRRORED_INVERTED;
	CMDefaults[E_THRYSISTER_COMPONENT].rotation_state = E_FORTH_QUADRANT;
	CMDefaults[E_THRYSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "SCR";
	CMDefaults[E_THRYSISTER_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Silicon Controled Rectifier";
	CMDefaults[E_THRYSISTER_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "SCR_XN";
	CMDefaults[E_THRYSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	CMDefaults[E_THRYSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_THRYSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_THRYSISTER_COMPONENT].CPinListData.SetSize(3, 3);
	CMDefaults[E_THRYSISTER_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_THRYSISTER_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_THRYSISTER_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_THRYSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "a";
	CMDefaults[E_THRYSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_THRYSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_THRYSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_THRYSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g";
	CMDefaults[E_THRYSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_THRYSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_THRYSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_THRYSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "c";
	CMDefaults[E_THRYSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_THRYSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_THRYSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CMDefaults[E_GTO_COMPONENT].attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_GTO_COMPONENT].component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;// this needs a new dialog box when transformer is changed
	CMDefaults[E_GTO_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_GTO_COMPONENT].mirror_state = E_MIRRORED_INVERTED;
	CMDefaults[E_GTO_COMPONENT].rotation_state = E_FORTH_QUADRANT;
	CMDefaults[E_GTO_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "2nxxx";
	CMDefaults[E_GTO_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Gate Turn Off Triac";
	CMDefaults[E_GTO_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "XNxxx";
	CMDefaults[E_GTO_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	CMDefaults[E_GTO_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_GTO_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_GTO_COMPONENT].CPinListData.SetSize(3, 3);
	CMDefaults[E_GTO_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_GTO_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_GTO_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_GTO_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "a";
	CMDefaults[E_GTO_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_GTO_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_GTO_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_GTO_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g";
	CMDefaults[E_GTO_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_GTO_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_GTO_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_GTO_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "c";
	CMDefaults[E_GTO_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_GTO_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_GTO_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
		
	CMDefaults[E_UNIJUNCTION_COMPONENT].attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_UNIJUNCTION_COMPONENT].component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;// this needs a new dialog box when transformer is changed
	CMDefaults[E_UNIJUNCTION_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_UNIJUNCTION_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "2Nxxx";
	CMDefaults[E_UNIJUNCTION_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Unijunction Transistor";
	CMDefaults[E_UNIJUNCTION_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "X2Nxxx";
	CMDefaults[E_UNIJUNCTION_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	CMDefaults[E_UNIJUNCTION_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_UNIJUNCTION_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_UNIJUNCTION_COMPONENT].CPinListData.SetSize(3, 3);
	CMDefaults[E_UNIJUNCTION_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_UNIJUNCTION_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_UNIJUNCTION_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_UNIJUNCTION_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "d";
	CMDefaults[E_UNIJUNCTION_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_UNIJUNCTION_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_UNIJUNCTION_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_UNIJUNCTION_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g";
	CMDefaults[E_UNIJUNCTION_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_UNIJUNCTION_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_UNIJUNCTION_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_UNIJUNCTION_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "s";
	CMDefaults[E_UNIJUNCTION_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_UNIJUNCTION_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_UNIJUNCTION_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	
	CMDefaults[E_TRIAC_COMPONENT].attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_TRIAC_COMPONENT].component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;// this needs a new dialog box when transformer is changed
	CMDefaults[E_TRIAC_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_TRIAC_COMPONENT].mirror_state = E_MIRRORED_INVERTED;
	CMDefaults[E_TRIAC_COMPONENT].rotation_state = E_FORTH_QUADRANT;
	CMDefaults[E_TRIAC_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "Triac";
	CMDefaults[E_TRIAC_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Triac";
 	CMDefaults[E_TRIAC_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "Triac_XN";
	CMDefaults[E_TRIAC_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	CMDefaults[E_TRIAC_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_TRIAC_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
 	CMDefaults[E_TRIAC_COMPONENT].CPinListData.SetSize(3, 3);
	CMDefaults[E_TRIAC_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_TRIAC_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_TRIAC_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_TRIAC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "a";
	CMDefaults[E_TRIAC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_TRIAC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_TRIAC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_TRIAC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g";
	CMDefaults[E_TRIAC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_TRIAC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_TRIAC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_TRIAC_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "c";
	CMDefaults[E_TRIAC_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_TRIAC_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_TRIAC_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CMDefaults[E_GENERIC_3_COMPONENT].attached_model_type = E_SPICE_SCHEMATIC;
	CMDefaults[E_GENERIC_3_COMPONENT].f_validate_label_value = false;
	CMDefaults[E_GENERIC_3_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Generic3Pin";
	CMDefaults[E_GENERIC_3_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "XGP";
	CMDefaults[E_GENERIC_3_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "Generic3Pin";
	CMDefaults[E_GENERIC_3_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	CMDefaults[E_GENERIC_3_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_GENERIC_3_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_GENERIC_3_COMPONENT].CPinListData.SetSize(3, 3);
	CMDefaults[E_GENERIC_3_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_GENERIC_3_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_GENERIC_3_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_GENERIC_3_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	CMDefaults[E_GENERIC_3_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_GENERIC_3_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_GENERIC_3_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_GENERIC_3_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	CMDefaults[E_GENERIC_3_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_GENERIC_3_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_GENERIC_3_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_GENERIC_3_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "o";
	CMDefaults[E_GENERIC_3_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_GENERIC_3_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_GENERIC_3_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	// 4 terminal	
	CReferanceDesignator[E_NPN_4TERM_TRANSISTER_COMPONENT] = "QN";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "NPN";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].component_property_view_type = E_PROPERTY_BIPOLAR;
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CLabelListData.SetSize(E_COMPONENT_BIPOLAR_PARAMETERS + 1);
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_M].CLabelType = "M";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_NUM_RESERVED].CLabelType = "Reserved";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_PARAMETERS].CLabelType = "Parameters";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_M].CLabelValue = "1";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_NUM_RESERVED].CLabelValue = "";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_PARAMETERS].CLabelValue = "";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "2N2222";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "NPN Bipolar Transistor";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "Q2N2222";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "Q?";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CPinListData.SetSize(4, 4);
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "c";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "b";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "e";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "sub";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NPN_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_PNP_4TERM_TRANSISTER_COMPONENT] = "QP";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "PNP";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].component_property_view_type = E_PROPERTY_BIPOLAR;
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].mirror_state = E_MIRRORED_INVERTED;
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].rotation_state = E_THIRD_QUADRANT;
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CLabelListData.SetSize(E_COMPONENT_BIPOLAR_PARAMETERS + 1);
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "Q2N2907";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "PNP Bipolar Transitor";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "Q2N2907";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "Q?";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_M].CLabelType = "M";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_NUM_RESERVED].CLabelType = "Reserved";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_PARAMETERS].CLabelType = "Parameters";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_M].CLabelValue = "1";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_NUM_RESERVED].CLabelValue = "";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_BIPOLAR_PARAMETERS].CLabelValue = "";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CPinListData.SetSize(4, 4);
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "c";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "b";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "e";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "sub";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PNP_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_PMOS_4TERM_TRANSISTER_COMPONENT] = "MP";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "PMOS";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].component_property_view_type = E_PROPERTY_MOSFET;
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].mirror_state = E_MIRRORED_INVERTED;
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].rotation_state = E_THIRD_QUADRANT;
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData.SetSize(E_COMPONENT_FET_PARAMETERS + 1);
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelType = "L";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelType = "W";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelType = "M";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelValue = "0";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = "0";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelValue = "1";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_ENABLE_AS].CLabelType = "1(1u/1u)";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "2SJ50";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "N Channel Mosfet";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "M2SJ50";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "M?";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CPinListData.SetSize(4, 4);
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "d";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "s";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "sub";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_NMOS_4TERM_TRANSISTER_COMPONENT] = "MN";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "NMOS";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].component_property_view_type = E_PROPERTY_MOSFET;
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData.SetSize(E_COMPONENT_FET_PARAMETERS + 1);
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelType = "L";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelType = "W";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelType = "M";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelValue = "0";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = "0";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelValue = "1";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_ENABLE_AS].CLabelType = "1(1u/1u)";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "BSim3_3nmos";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "N Channel Mosfet";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "BSim3_3nmos_XN";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "M?";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CPinListData.SetSize(4, 4);
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "d";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "s";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "sub";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NMOS_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_4TERM_NJFET_TRANSISTER_COMPONENT] = "JN";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "NJF";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].component_property_view_type = E_PROPERTY_FET;
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CLabelListData.SetSize(E_COMPONENT_FET_PARAMETERS + 1);
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelType = "L";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelType = "A";//was W
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelType = "Parameters";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelValue = "0";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = "0";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelValue = "";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_ENABLE_AS].CLabelType = "1(1u/1u)";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "U309";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "N Channel JFet";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "JU309";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "J?";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = "1";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CPinListData.SetSize(4, 4);
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "d";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "s";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "sub";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_4TERM_NJFET_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_4TERM_PJFET_TRANSISTER_COMPONENT] = "JP";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "PJF";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].component_property_view_type = E_PROPERTY_FET;
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CLabelListData.SetSize(E_COMPONENT_FET_PARAMETERS + 1);
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelType = "L";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelType = "A";//was W
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelType = "Parameters";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelValue = "0";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = "0";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelValue = "";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_ENABLE_AS].CLabelType = "1(1u/1u)";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "pjfet";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "P Channel JFet";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "pjfet_XN";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "J?";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = "1";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CPinListData.SetSize(4, 4);
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "d";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "s";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "b";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_4TERM_PJFET_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_NGASFET_4TERM_TRANSISTER_COMPONENT] = "Z";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "NMF";	
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].component_property_view_type = E_PROPERTY_MESFET;
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData.SetSize(E_COMPONENT_FET_PARAMETERS + 1);
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelType = "L";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelType = "A";//was W
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelType = "Parameters";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelValue = "0";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = "0";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelValue = "";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_ENABLE_AS].CLabelType = "1(1u/1u)";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "ngasfet_XN";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "N Channel Gasfet";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "ngasfet";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "J?";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = "1";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData.SetSize(4, 4);
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "d";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "s";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "sub";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_NGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_PGASFET_4TERM_TRANSISTER_COMPONENT] = "Z";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "PMF";	
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].component_property_view_type = E_PROPERTY_MESFET;
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData.SetSize(E_COMPONENT_FET_PARAMETERS + 1);
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelType = "L";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelType = "W";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelType = "Parameters";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_LENGTH].CLabelValue = "0";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = "0";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_M].CLabelValue = "";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_ENABLE_AS].CLabelType = "1(1u/1u)";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "pgasfet_XN";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "P Channel GasFet";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "pgasfet";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "J?";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CLabelListData[E_COMPONENT_FET_WIDTH].CLabelValue = "1";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData.SetSize(4, 4);
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "d";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "s";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "sub";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_PGASFET_4TERM_TRANSISTER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	Setup3a();
	Setup7();
}