
#include "TDVersion.h"
#include "TEPropertyViewTypes.h"
#include "TESuperSpiceEnums.h"
#include "stdafx.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSuperSpiceGlobalData.h"



#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

void TCSuperSpiceDataBase::Setup3a(void)
{

	CString CModelType = "MODEL";

	CReferanceDesignator[E_VCVSRC_COMPONENT] = "E";
	CMDefaults[E_VCVSRC_COMPONENT].attached_model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_VCVSRC_COMPONENT].format_spice_value = false;
	CMDefaults[E_VCVSRC_COMPONENT].component_property_view_type = E_PROPERTY_CONTROLED_SOURCE;
	CMDefaults[E_VCVSRC_COMPONENT].CSpiceParameters.use_model = false; 
	CMDefaults[E_VCVSRC_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "E";
	CMDefaults[E_VCVSRC_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_VCVSRC_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_VCVSRC_COMPONENT].CLabelListData.SetSize(E_COMPONENT_CONTROLLED_SOURCE_PARAMETERS + 1);
	CMDefaults[E_VCVSRC_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "E";
	CMDefaults[E_VCVSRC_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only = true;
	CMDefaults[E_VCVSRC_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only = true;
	CMDefaults[E_VCVSRC_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Voltage Controlled Voltage Source";
 	CMDefaults[E_VCVSRC_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "1";
	CMDefaults[E_VCVSRC_COMPONENT].CLabelListData[E_COMPONENT_VALUE].read_only = false;
	CMDefaults[E_VCVSRC_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "E?";
	CMDefaults[E_VCVSRC_COMPONENT].CLabelListData[E_COMPONENT_VALUE].is_visable = true;
	CMDefaults[E_VCVSRC_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_VCVSRC_COMPONENT].CLabelListData[E_COMPONENT_CONTROLLED_SOURCE_PARAMETERS].is_visable = false;
   	CMDefaults[E_VCVSRC_COMPONENT].CPinListData.SetSize(4, 4);
	CMDefaults[E_VCVSRC_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_VCVSRC_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_VCVSRC_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_VCVSRC_COMPONENT].CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_VCVSRC_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+i";
	CMDefaults[E_VCVSRC_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_VCVSRC_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_VCVSRC_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_VCVSRC_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-i";
	CMDefaults[E_VCVSRC_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_VCVSRC_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_VCVSRC_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_VCVSRC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+o";
	CMDefaults[E_VCVSRC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_VCVSRC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_VCVSRC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_VCVSRC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-o";
	CMDefaults[E_VCVSRC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CMDefaults[E_VCVSRC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_VCVSRC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_ICVSRC_COMPONENT] = "H";
	CMDefaults[E_ICVSRC_COMPONENT].attached_model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_ICVSRC_COMPONENT].format_spice_value = false;
	CMDefaults[E_ICVSRC_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_ICVSRC_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_ICVSRC_COMPONENT].component_property_view_type = E_PROPERTY_CONTROLED_SOURCE;
	CMDefaults[E_ICVSRC_COMPONENT].CSpiceParameters.use_model = false;
	CMDefaults[E_ICVSRC_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "H";
	CMDefaults[E_ICVSRC_COMPONENT].CLabelListData.SetSize(E_COMPONENT_CONTROLLED_SOURCE_PARAMETERS + 1);
	CMDefaults[E_ICVSRC_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "H";
	CMDefaults[E_ICVSRC_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Current Controlled Voltage Source";
 	CMDefaults[E_ICVSRC_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "1";
	CMDefaults[E_ICVSRC_COMPONENT].CLabelListData[E_COMPONENT_VALUE].read_only = false;
	CMDefaults[E_ICVSRC_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "H?";
	CMDefaults[E_ICVSRC_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only = true;
	CMDefaults[E_ICVSRC_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only = true;
	CMDefaults[E_ICVSRC_COMPONENT].CLabelListData[E_COMPONENT_VALUE].is_visable = true;
	CMDefaults[E_ICVSRC_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_ICVSRC_COMPONENT].CLabelListData[E_COMPONENT_CONTROLLED_SOURCE_PARAMETERS].is_visable = false;
   	CMDefaults[E_ICVSRC_COMPONENT].CPinListData.SetSize(4, 4);
	CMDefaults[E_ICVSRC_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_ICVSRC_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_ICVSRC_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_ICVSRC_COMPONENT].CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_ICVSRC_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+i";
	CMDefaults[E_ICVSRC_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_ICVSRC_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_ICVSRC_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_ICVSRC_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-i";
	CMDefaults[E_ICVSRC_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_ICVSRC_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_ICVSRC_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_ICVSRC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+o";
	CMDefaults[E_ICVSRC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_ICVSRC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_ICVSRC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_ICVSRC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-o";
	CMDefaults[E_ICVSRC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CMDefaults[E_ICVSRC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_ICVSRC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_VCISRC_COMPONENT] = "G";
	CMDefaults[E_VCISRC_COMPONENT].attached_model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_VCISRC_COMPONENT].format_spice_value = false;
	CMDefaults[E_VCISRC_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_VCISRC_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_VCISRC_COMPONENT].component_property_view_type = E_PROPERTY_CONTROLED_SOURCE;
	CMDefaults[E_VCISRC_COMPONENT].CSpiceParameters.use_model = false;
	CMDefaults[E_VCISRC_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "G";
	CMDefaults[E_VCISRC_COMPONENT].CLabelListData.SetSize(E_COMPONENT_CONTROLLED_SOURCE_PARAMETERS + 1);
	CMDefaults[E_VCISRC_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "G";
	CMDefaults[E_VCISRC_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Voltage Controlled Current Source";
 	CMDefaults[E_VCISRC_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "1";
	CMDefaults[E_VCISRC_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "G?";
	CMDefaults[E_VCISRC_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only = true;
	CMDefaults[E_VCISRC_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only = true;
	CMDefaults[E_VCISRC_COMPONENT].CLabelListData[E_COMPONENT_VALUE].is_visable = true;
	CMDefaults[E_VCISRC_COMPONENT].CLabelListData[E_COMPONENT_VALUE].read_only = false;
	CMDefaults[E_VCISRC_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_VCISRC_COMPONENT].CLabelListData[E_COMPONENT_CONTROLLED_SOURCE_PARAMETERS].is_visable = false;
   	CMDefaults[E_VCISRC_COMPONENT].CPinListData.SetSize(4, 4);
	CMDefaults[E_VCISRC_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_VCISRC_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_VCISRC_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_VCISRC_COMPONENT].CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_VCISRC_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+i";
	CMDefaults[E_VCISRC_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_VCISRC_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_VCISRC_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_VCISRC_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-i";
	CMDefaults[E_VCISRC_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_VCISRC_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_VCISRC_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_VCISRC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+o";
	CMDefaults[E_VCISRC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_VCISRC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_VCISRC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_VCISRC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-o";
	CMDefaults[E_VCISRC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CMDefaults[E_VCISRC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_VCISRC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_ICISRC_COMPONENT] = "F";
	CMDefaults[E_ICISRC_COMPONENT].attached_model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_ICISRC_COMPONENT].format_spice_value = false;
	CMDefaults[E_ICISRC_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_ICISRC_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_ICISRC_COMPONENT].component_property_view_type = E_PROPERTY_CONTROLED_SOURCE;
	CMDefaults[E_ICISRC_COMPONENT].CSpiceParameters.use_model = false;
	CMDefaults[E_ICISRC_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "F";
	CMDefaults[E_ICISRC_COMPONENT].CLabelListData.SetSize(E_COMPONENT_CONTROLLED_SOURCE_PARAMETERS + 1);
	CMDefaults[E_ICISRC_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "F";
	CMDefaults[E_ICISRC_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Current Controlled Current Source";
 	CMDefaults[E_ICISRC_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "1";
	CMDefaults[E_ICISRC_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "F?";
	CMDefaults[E_ICISRC_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only = true;
	CMDefaults[E_ICISRC_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only = true;
	CMDefaults[E_ICISRC_COMPONENT].CLabelListData[E_COMPONENT_VALUE].is_visable = true;
	CMDefaults[E_ICISRC_COMPONENT].CLabelListData[E_COMPONENT_VALUE].read_only = false;
	CMDefaults[E_ICISRC_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_ICISRC_COMPONENT].CLabelListData[E_COMPONENT_CONTROLLED_SOURCE_PARAMETERS].is_visable = false;
   	CMDefaults[E_ICISRC_COMPONENT].CPinListData.SetSize(4, 4);
	CMDefaults[E_ICISRC_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_ICISRC_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_ICISRC_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_ICISRC_COMPONENT].CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_ICISRC_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+i";
	CMDefaults[E_ICISRC_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_ICISRC_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_ICISRC_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_ICISRC_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-i";
	CMDefaults[E_ICISRC_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_ICISRC_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_ICISRC_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_ICISRC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+o";
	CMDefaults[E_ICISRC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_ICISRC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_ICISRC_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_ICISRC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-o";
	CMDefaults[E_ICISRC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CMDefaults[E_ICISRC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_ICISRC_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CMDefaults[E_TRANSFORMER_COMPONENT].attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_TRANSFORMER_COMPONENT].mirror_state = E_MIRRORED_INVERTED;
	CMDefaults[E_TRANSFORMER_COMPONENT].rotation_state = E_SECOND_QUADRANT;
	CMDefaults[E_TRANSFORMER_COMPONENT].f_validate_label_value = false;
	CMDefaults[E_TRANSFORMER_COMPONENT].component_property_view_type = E_PROPERTY_TRANSFORMER;
	CMDefaults[E_TRANSFORMER_COMPONENT].CLabelListData.SetSize(E_COMPONENT_TRANSFORMER_TEMPCO2 + 1);
	CMDefaults[E_TRANSFORMER_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_TRANSFORMER_COMPONENT].CLabelListData[E_COMPONENT_TRANSFORMER_COUPLING].CLabelValue = ".99";
	CMDefaults[E_TRANSFORMER_COMPONENT].CLabelListData[E_COMPONENT_TRANSFORMER_L1].CLabelType = "L1";
	CMDefaults[E_TRANSFORMER_COMPONENT].CLabelListData[E_COMPONENT_TRANSFORMER_L2].CLabelType = "L2";
	CMDefaults[E_TRANSFORMER_COMPONENT].CLabelListData[E_COMPONENT_TRANSFORMER_L1].CLabelValue = "1m";
	CMDefaults[E_TRANSFORMER_COMPONENT].CLabelListData[E_COMPONENT_TRANSFORMER_L2].CLabelValue = "1m";
	CMDefaults[E_TRANSFORMER_COMPONENT].CLabelListData[E_COMPONENT_TRANSFORMER_COUPLING].CLabelType = "K";
	CMDefaults[E_TRANSFORMER_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "Transformer";
	CMDefaults[E_TRANSFORMER_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Transformer";
	CMDefaults[E_TRANSFORMER_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only = true;
	CMDefaults[E_TRANSFORMER_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "1/1";// n1:n2
	CMDefaults[E_TRANSFORMER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	CMDefaults[E_TRANSFORMER_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_TRANSFORMER_COMPONENT].CPinListData.SetSize(4, 4);
	CMDefaults[E_TRANSFORMER_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_TRANSFORMER_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_TRANSFORMER_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_TRANSFORMER_COMPONENT].CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_TRANSFORMER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+1";
	CMDefaults[E_TRANSFORMER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_TRANSFORMER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_TRANSFORMER_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_TRANSFORMER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-1";
	CMDefaults[E_TRANSFORMER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_TRANSFORMER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_TRANSFORMER_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_TRANSFORMER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+2";
	CMDefaults[E_TRANSFORMER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_TRANSFORMER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_TRANSFORMER_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_TRANSFORMER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-2";
	CMDefaults[E_TRANSFORMER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CMDefaults[E_TRANSFORMER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_TRANSFORMER_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
 
	CMDefaults[E_TRANSFORMER_DUAL] = CMDefaults[E_TRANSFORMER_COMPONENT];
	CMDefaults[E_TRANSFORMER_TRIPLE] = CMDefaults[E_TRANSFORMER_DUAL];
	CMDefaults[E_TRANSFORMER_QUAD] = CMDefaults[E_TRANSFORMER_TRIPLE];
	CMDefaults[E_TRANSFORMER_FLYBACK_TRIPLE] = CMDefaults[E_TRANSFORMER_DUAL];

	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].mirror_state = E_MIRRORED_INVERTED;
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].rotation_state = E_SECOND_QUADRANT;
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].f_validate_label_value = false;
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].component_property_view_type = E_PROPERTY_TRANSFORMER;
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CLabelListData.SetSize(E_COMPONENT_TRANSFORMER_TEMPCO2 + 1);
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CLabelListData[E_COMPONENT_TRANSFORMER_COUPLING].CLabelValue = ".99";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CLabelListData[E_COMPONENT_TRANSFORMER_L1].CLabelType = "L1";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CLabelListData[E_COMPONENT_TRANSFORMER_L2].CLabelType = "L2";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CLabelListData[E_COMPONENT_TRANSFORMER_L1].CLabelValue = "1m";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CLabelListData[E_COMPONENT_TRANSFORMER_L2].CLabelValue = "1m";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CLabelListData[E_COMPONENT_TRANSFORMER_COUPLING].CLabelType = "K";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "Transformer";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Transformer";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only = true;
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CLabelListData[E_COMPONENT_VALUE].CLabel = "1/1";// n1:n2
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData.SetSize(6, 6);
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[4].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[5].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+1";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "ct1";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-1";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+2";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[4].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "ct2";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[4].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "5";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[4].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[4].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[5].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-2";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[5].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "6";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[5].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED].CPinListData[5].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CMDefaults[E_TRANSFORMER_DUAL_CENTERTAPED] = CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED];
	CMDefaults[E_TRANSFORMER_TRIPLE_CENTERTAPED] = CMDefaults[E_TRANSFORMER_DUAL_CENTERTAPED];
	CMDefaults[E_TRANSFORMER_QUAD_CENTERTAPED] = CMDefaults[E_TRANSFORMER_TRIPLE_CENTERTAPED];
	CMDefaults[E_TRANSFORMER_TUBE_OUTPUT] = CMDefaults[E_TRANSFORMER_SINGLE_CENTERTAPED];



	CReferanceDesignator[E_TRANSMISSION_LINE_COMPONENT] = "O";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].attached_model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "LTRA";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CSpiceParameters.use_model = true;// 
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CSpiceParameters.CData.SetSize(5);
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CSpiceParameters.CData[0].CName = "R";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CSpiceParameters.CData[0].value = 1e-3;
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CSpiceParameters.CData[1].CName = "C";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CSpiceParameters.CData[1].value = 100e-9;
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CSpiceParameters.CData[2].CName = "L";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CSpiceParameters.CData[2].value = 1e-6;
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CSpiceParameters.CData[3].CName = "G";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CSpiceParameters.CData[3].value = 1e-6;
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CSpiceParameters.CData[4].CName = "LEN";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CSpiceParameters.CData[4].value = 1;
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CLabelListData.SetSize(E_COMPONENT_TRANSMISSION_LINE_G0 + 1);
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CLabelListData[E_COMPONENT_TRANSMISSION_LINE_Z0].CLabelType = "Z0";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CLabelListData[E_COMPONENT_TRANSMISSION_LINE_R0].CLabelType = "R";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CLabelListData[E_COMPONENT_TRANSMISSION_LINE_L0].CLabelType = "L";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CLabelListData[E_COMPONENT_TRANSMISSION_LINE_C0].CLabelType = "C";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CLabelListData[E_COMPONENT_TRANSMISSION_LINE_G0].CLabelType = "G";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CLabelListData[E_COMPONENT_TRANSMISSION_LINE_TD].CLabelType = "Td";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CLabelListData[E_COMPONENT_TRANSMISSION_LINE_LENGTH].CLabelType = "LEN";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CLabelListData[E_COMPONENT_TRANSMISSION_LINE_F0].CLabelType = "F";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CLabelListData[E_COMPONENT_TRANSMISSION_LINE_Z0].read_only	= true;
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CLabelListData[E_COMPONENT_TRANSMISSION_LINE_TD].read_only	= true;
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CLabelListData[E_COMPONENT_TRANSMISSION_LINE_F0].read_only	= true;
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].component_property_view_type = E_PROPERTY_TRANSMISSION_LINE;
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "LTRA";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].f_validate_label_value = false;
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "TRG50";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Transmission Line";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only = true;
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "TRG50";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CLabelListData[E_COMPONENT_VALUE].read_only = true;
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "T?";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CPinListData.SetSize(4, 4);
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+1";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-1";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+2";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-2";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_TRANSMISSION_LINE_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_DUAL_GATE_NMOSFET] = "X";
	CMDefaults[E_DUAL_GATE_NMOSFET].attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_DUAL_GATE_NMOSFET].component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;// this needs a new dialog box when transformer is changed
	CMDefaults[E_DUAL_GATE_NMOSFET].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_DUAL_GATE_NMOSFET].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "2Nxxxx";
	CMDefaults[E_DUAL_GATE_NMOSFET].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "N Channel Dual gate Mosfet";
	CMDefaults[E_DUAL_GATE_NMOSFET].CLabelListData[E_COMPONENT_VALUE].CLabel = "X2Nxxx";
	CMDefaults[E_DUAL_GATE_NMOSFET].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "M?";
	CMDefaults[E_DUAL_GATE_NMOSFET].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_DUAL_GATE_NMOSFET].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	CMDefaults[E_DUAL_GATE_NMOSFET].CPinListData.SetSize(4, 4);
	CMDefaults[E_DUAL_GATE_NMOSFET].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_DUAL_GATE_NMOSFET].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_DUAL_GATE_NMOSFET].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_DUAL_GATE_NMOSFET].CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_DUAL_GATE_NMOSFET].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "d";
	CMDefaults[E_DUAL_GATE_NMOSFET].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_DUAL_GATE_NMOSFET].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_DUAL_GATE_NMOSFET].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_DUAL_GATE_NMOSFET].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g1";
	CMDefaults[E_DUAL_GATE_NMOSFET].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_DUAL_GATE_NMOSFET].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_DUAL_GATE_NMOSFET].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_DUAL_GATE_NMOSFET].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "s";
	CMDefaults[E_DUAL_GATE_NMOSFET].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_DUAL_GATE_NMOSFET].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_DUAL_GATE_NMOSFET].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_DUAL_GATE_NMOSFET].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g2";
	CMDefaults[E_DUAL_GATE_NMOSFET].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CMDefaults[E_DUAL_GATE_NMOSFET].CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_DUAL_GATE_NMOSFET].CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_DUAL_GATE_PMOSFET] = "X";
	CMDefaults[E_DUAL_GATE_PMOSFET].attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_DUAL_GATE_PMOSFET].component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;// this needs a new dialog box when transformer is changed
	CMDefaults[E_DUAL_GATE_PMOSFET].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	CMDefaults[E_DUAL_GATE_PMOSFET].mirror_state = E_MIRRORED_INVERTED;
	CMDefaults[E_DUAL_GATE_PMOSFET].rotation_state = E_THIRD_QUADRANT;
	CMDefaults[E_DUAL_GATE_PMOSFET].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "2Nxxx";
	CMDefaults[E_DUAL_GATE_PMOSFET].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "P Channel Dual Gate Mosfet";
 	CMDefaults[E_DUAL_GATE_PMOSFET].CLabelListData[E_COMPONENT_VALUE].CLabel = "X2Nxxx";
	CMDefaults[E_DUAL_GATE_PMOSFET].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "M?";
	CMDefaults[E_DUAL_GATE_PMOSFET].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_DUAL_GATE_PMOSFET].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
 	CMDefaults[E_DUAL_GATE_PMOSFET].CPinListData.SetSize(4, 4);
	CMDefaults[E_DUAL_GATE_PMOSFET].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_DUAL_GATE_PMOSFET].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_DUAL_GATE_PMOSFET].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_DUAL_GATE_PMOSFET].CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_DUAL_GATE_PMOSFET].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "d";
	CMDefaults[E_DUAL_GATE_PMOSFET].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_DUAL_GATE_PMOSFET].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_DUAL_GATE_PMOSFET].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_DUAL_GATE_PMOSFET].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g1";
	CMDefaults[E_DUAL_GATE_PMOSFET].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_DUAL_GATE_PMOSFET].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_DUAL_GATE_PMOSFET].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_DUAL_GATE_PMOSFET].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "s";
	CMDefaults[E_DUAL_GATE_PMOSFET].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_DUAL_GATE_PMOSFET].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_DUAL_GATE_PMOSFET].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_DUAL_GATE_PMOSFET].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g2";
	CMDefaults[E_DUAL_GATE_PMOSFET].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_DUAL_GATE_PMOSFET].CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_DUAL_GATE_PMOSFET].CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_VSWITCH_COMPONENT] = "S";
	CMDefaults[E_VSWITCH_COMPONENT].attached_model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_VSWITCH_COMPONENT].CSpiceParameters.CData.SetSize(4);
	CMDefaults[E_VSWITCH_COMPONENT].CSpiceParameters.CData[0].CName = "Ron";
	CMDefaults[E_VSWITCH_COMPONENT].CSpiceParameters.CData[0].value = (float)1e-3;
	CMDefaults[E_VSWITCH_COMPONENT].CSpiceParameters.CData[1].CName = "Roff";
	CMDefaults[E_VSWITCH_COMPONENT].CSpiceParameters.CData[1].value = (float)1e6;
	CMDefaults[E_VSWITCH_COMPONENT].CSpiceParameters.CData[2].CName = "Vt";
	CMDefaults[E_VSWITCH_COMPONENT].CSpiceParameters.CData[2].value = 1;
	CMDefaults[E_VSWITCH_COMPONENT].CSpiceParameters.CData[3].CName = "Vh";
	CMDefaults[E_VSWITCH_COMPONENT].CSpiceParameters.CData[3].value = 0;
	CMDefaults[E_VSWITCH_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_VSWITCH_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_VSWITCH_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "SW";
	CMDefaults[E_VSWITCH_COMPONENT].component_property_view_type = E_PROPERTY_SWITCH;
	CMDefaults[E_VSWITCH_COMPONENT].CLabelListData.SetSize(E_COMPONENT_VSWITCH_VH + 1);
	CMDefaults[E_VSWITCH_COMPONENT].CLabelListData[E_COMPONENT_VSWITCH_RON].CLabelType = "Ron";
	CMDefaults[E_VSWITCH_COMPONENT].CLabelListData[E_COMPONENT_VSWITCH_ROFF].CLabelType = "Roff";
	CMDefaults[E_VSWITCH_COMPONENT].CLabelListData[E_COMPONENT_VSWITCH_VT].CLabelType = "Vt";
	CMDefaults[E_VSWITCH_COMPONENT].CLabelListData[E_COMPONENT_VSWITCH_VH].CLabelType = "Vh";
	CMDefaults[E_VSWITCH_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "VSwitch";
	CMDefaults[E_VSWITCH_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Voltage Controled Switch";
 	CMDefaults[E_VSWITCH_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only = true;
	CMDefaults[E_VSWITCH_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "";
	CMDefaults[E_VSWITCH_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "S?";
	CMDefaults[E_VSWITCH_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_VSWITCH_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
 	CMDefaults[E_VSWITCH_COMPONENT].CPinListData.SetSize(4, 4);
	CMDefaults[E_VSWITCH_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_VSWITCH_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_VSWITCH_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_VSWITCH_COMPONENT].CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_VSWITCH_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+Vc";
	CMDefaults[E_VSWITCH_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_VSWITCH_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_VSWITCH_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_VSWITCH_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-Vc";
	CMDefaults[E_VSWITCH_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_VSWITCH_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_VSWITCH_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_VSWITCH_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "Ra";
	CMDefaults[E_VSWITCH_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_VSWITCH_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_VSWITCH_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_VSWITCH_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "Rb";
	CMDefaults[E_VSWITCH_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CMDefaults[E_VSWITCH_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_VSWITCH_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	CReferanceDesignator[E_ISWITCH_COMPONENT] = "CS";
	CMDefaults[E_ISWITCH_COMPONENT].attached_model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_ISWITCH_COMPONENT].CSpiceParameters.CData.SetSize(4);
	CMDefaults[E_ISWITCH_COMPONENT].CSpiceParameters.CData[0].CName = "Ron";
	CMDefaults[E_ISWITCH_COMPONENT].CSpiceParameters.CData[0].value = (float)1e-3;
	CMDefaults[E_ISWITCH_COMPONENT].CSpiceParameters.CData[1].CName = "Roff";
	CMDefaults[E_ISWITCH_COMPONENT].CSpiceParameters.CData[1].value = (float)1e6;
	CMDefaults[E_ISWITCH_COMPONENT].CSpiceParameters.CData[2].CName = "It";
	CMDefaults[E_ISWITCH_COMPONENT].CSpiceParameters.CData[2].value = 1;
	CMDefaults[E_ISWITCH_COMPONENT].CSpiceParameters.CData[3].CName = "Ih";
	CMDefaults[E_ISWITCH_COMPONENT].CSpiceParameters.CData[3].value = 0;
	CMDefaults[E_ISWITCH_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	CMDefaults[E_ISWITCH_COMPONENT].CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_MODEL;
	CMDefaults[E_ISWITCH_COMPONENT].CSpiceParameters.CDataBaseIdInfo.CRecordType = "CSW";
	CMDefaults[E_ISWITCH_COMPONENT].component_property_view_type = E_PROPERTY_SWITCH;
	CMDefaults[E_ISWITCH_COMPONENT].CLabelListData.SetSize(E_COMPONENT_ISWITCH_IH + 1);
	CMDefaults[E_ISWITCH_COMPONENT].CLabelListData[E_COMPONENT_VSWITCH_RON].CLabelType = "Ron";
	CMDefaults[E_ISWITCH_COMPONENT].CLabelListData[E_COMPONENT_VSWITCH_ROFF].CLabelType = "Roff";
	CMDefaults[E_ISWITCH_COMPONENT].CLabelListData[E_COMPONENT_ISWITCH_IT].CLabelType = "IT";
	CMDefaults[E_ISWITCH_COMPONENT].CLabelListData[E_COMPONENT_ISWITCH_IH].CLabelType = "IH";
	CMDefaults[E_ISWITCH_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "ISwitch";
	CMDefaults[E_ISWITCH_COMPONENT].CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Current Controlled Switch";
 	CMDefaults[E_ISWITCH_COMPONENT].CLabelListData[E_COMPONENT_VALUE].CLabel = "";
	CMDefaults[E_ISWITCH_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "S?";
	CMDefaults[E_ISWITCH_COMPONENT].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CMDefaults[E_ISWITCH_COMPONENT].CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
  	CMDefaults[E_ISWITCH_COMPONENT].CPinListData.SetSize(4, 4);
	CMDefaults[E_ISWITCH_COMPONENT].CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_ISWITCH_COMPONENT].CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_ISWITCH_COMPONENT].CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_ISWITCH_COMPONENT].CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	CMDefaults[E_ISWITCH_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+Ic";
	CMDefaults[E_ISWITCH_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	CMDefaults[E_ISWITCH_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_ISWITCH_COMPONENT].CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_ISWITCH_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-Ic";
	CMDefaults[E_ISWITCH_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	CMDefaults[E_ISWITCH_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_ISWITCH_COMPONENT].CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_ISWITCH_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "Ra";
	CMDefaults[E_ISWITCH_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	CMDefaults[E_ISWITCH_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_ISWITCH_COMPONENT].CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	CMDefaults[E_ISWITCH_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "Rb";
	CMDefaults[E_ISWITCH_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	CMDefaults[E_ISWITCH_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	CMDefaults[E_ISWITCH_COMPONENT].CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
}