#include "TDVersion.h"
#include "TEPropertyViewTypes.h"
#include "TESuperSpiceEnums.h"
#include "stdafx.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSuperSpiceGlobalData.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

void TCSuperSpiceDataBase::Setup4(void)
{
	int p;

	int size;

	CString CModelType = "MODEL";

	size = sizeof(CString);

	Setup5();

	TCSchematicObjectData* PCMDefaults = &CMDefaults[E_GENERIC_2INPUT_AMP];

	PCMDefaults->attached_model_type = E_SPICE_SCHEMATIC;
	PCMDefaults->CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "X2InputAmp";
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "2 Input Amp";
 	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLabel = "X2InputAmp";
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = true;
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLocation.x = 68;
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLocation.y = 32;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocation.x = 68;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocation.y = 40;
  	PCMDefaults->CPinListData.SetSize(7, 7);
	PCMDefaults->CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[4].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[5].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[6].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+i1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-i1";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+i2";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-i2";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "o";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "5";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[5].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "Vcc";
	PCMDefaults->CPinListData[5].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "6";
	PCMDefaults->CPinListData[5].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[5].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[6].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "Vee";
	PCMDefaults->CPinListData[6].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "7";
	PCMDefaults->CPinListData[6].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[6].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";


	PCMDefaults = &CMDefaults[E_VCA_COMPONENT];

	PCMDefaults->attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;// this needs a new dialog box when transformer is changed
	PCMDefaults->CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "VCA";
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Voltage Controlled Amplifier";
 	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLabel = "VCA";
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLocation.x = 68;
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLocation.y = 32;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocation.x = 68;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocation.y = 40;
  	PCMDefaults->CPinListData.SetSize(7, 7);
	PCMDefaults->CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[4].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[5].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[6].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "=i";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-i";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+Vc";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-Vc";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "out";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "5";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[5].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "Vcc";
	PCMDefaults->CPinListData[5].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "6";
	PCMDefaults->CPinListData[5].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[5].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[6].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "Vcc";
	PCMDefaults->CPinListData[6].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "7";
	PCMDefaults->CPinListData[6].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[6].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	PCMDefaults = &CMDefaults[E_5_PIN_OP_AMP_COMPONENT];

	PCMDefaults->attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "OPA27";
	PCMDefaults->CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "OpAmp";
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLabel = "OPA27";
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLocation.x = 68;
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLocation.y = 32;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocation.x = 68;
	PCMDefaults->CPinListData.SetSize(5, 5);
	PCMDefaults->CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[4].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "VCC";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "6";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "VEE";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "7";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "OUT";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	int count = CMDefaults.GetSize();

	int width, height, increment;

	increment = 20;

	for(p = 0; p < count; p++)
	{
		TCSchematicObjectData &CLSchematicObjectData = CMDefaults[p];

		size = CLSchematicObjectData.CLabelListData.GetSize();
		
		if(size) CLSchematicObjectData.FormatRecordName();

		width = (int)((CLSchematicObjectData.width + CLSchematicObjectData.CLocationOffset.x)  * component_scale);
		height = (int)((CLSchematicObjectData.height + CLSchematicObjectData.CLocationOffset.y) * component_scale);

		CPoint CZeroStart(width, -height/2);
		CPoint CIncrement(0, increment);

		int r;

		for(r = 0; r < E_COMPONENT_MAX_LABEL_NUMBER; r++)
		{
			if(!size) continue;

			TCGraphicObjectData &CGraphicObjectData = CLSchematicObjectData.CLabelListData[r];

			CGraphicObjectData.CLocations_Mirror.SetSize(2, 2);

			CGraphicObjectData.CLocations_Mirror[0].CQuadrant.SetSize(4, 4);
			CGraphicObjectData.CLocations_Mirror[1].CQuadrant.SetSize(4, 4);

			CGraphicObjectData.CLocations_Mirror[0].CQuadrant[0] = CZeroStart + CIncrement;
			CGraphicObjectData.CLocations_Mirror[0].CQuadrant[1] = CZeroStart + CIncrement;
			CGraphicObjectData.CLocations_Mirror[0].CQuadrant[2] = CZeroStart + CIncrement;
			CGraphicObjectData.CLocations_Mirror[0].CQuadrant[3] = CZeroStart + CIncrement;

			CGraphicObjectData.CLocations_Mirror[1].CQuadrant[0] = CZeroStart + CIncrement;
			CGraphicObjectData.CLocations_Mirror[1].CQuadrant[1] = CZeroStart + CIncrement;
			CGraphicObjectData.CLocations_Mirror[1].CQuadrant[2] = CZeroStart + CIncrement;
			CGraphicObjectData.CLocations_Mirror[1].CQuadrant[3] = CZeroStart + CIncrement;

			CIncrement.y += increment;
		}

		for(r = E_COMPONENT_MAX_LABEL_NUMBER; r < size; r++)
		{
			TCGraphicObjectData &CGraphicObjectData = CLSchematicObjectData.CLabelListData[r];

			CGraphicObjectData.CLocation = CZeroStart + CIncrement;

			CIncrement.y += increment;
		}
	}

	CPoint ClocationTop(48, -20);
	CPoint ClocationBottom(48, 48);

	CPoint ClocationLeft(-16, 12);
	CPoint ClocationRight(84, 12);
	CPoint COffset(0, -32);

//
	PCMDefaults = &CMDefaults[E_WAVEFORM_COMPONENT];

	PCMDefaults->CLabelListData[E_WAVEFORM_ENABLE].CLocations_Mirror.SetSize(2, 2);
	PCMDefaults->CLabelListData[E_WAVEFORM_ENABLE].CLocations_Mirror[0].CQuadrant.SetSize(4, 4);
	PCMDefaults->CLabelListData[E_WAVEFORM_ENABLE].CLocations_Mirror[1].CQuadrant.SetSize(4, 4);

	SetWaveFormDefaultSize(PCMDefaults->width, PCMDefaults->height);
//
	PCMDefaults = &CMDefaults[E_RESISTOR_COMPONENT];

	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[0].CQuadrant[0] = ClocationBottom;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[1].CQuadrant[0] = ClocationBottom;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[0].CQuadrant[2] = ClocationBottom;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[1].CQuadrant[2] = ClocationBottom;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[0].CQuadrant[0] = ClocationTop;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[1].CQuadrant[0] = ClocationTop;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[0].CQuadrant[2] = ClocationTop;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[1].CQuadrant[2] = ClocationTop;

	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[0].CQuadrant[1] = ClocationRight;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[1].CQuadrant[1] = ClocationRight;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[0].CQuadrant[3] = ClocationRight;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[1].CQuadrant[3] = ClocationRight;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[0].CQuadrant[1] = ClocationLeft;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[1].CQuadrant[1] = ClocationLeft;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[0].CQuadrant[3] = ClocationLeft;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[1].CQuadrant[3] = ClocationLeft;


	PCMDefaults = &CMDefaults[E_CAPACITOR_COMPONENT];

	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[0].CQuadrant[0] = ClocationBottom;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[1].CQuadrant[0] = ClocationBottom + COffset;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[0].CQuadrant[2] = ClocationBottom;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[1].CQuadrant[2] = ClocationBottom + COffset;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[0].CQuadrant[0] = ClocationTop;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[1].CQuadrant[0] = ClocationTop;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[0].CQuadrant[2] = ClocationTop;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[1].CQuadrant[2] = ClocationTop;

	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[0].CQuadrant[1] = ClocationRight;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[1].CQuadrant[1] = ClocationRight;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[0].CQuadrant[3] = ClocationRight;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[1].CQuadrant[3] = ClocationRight;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[0].CQuadrant[1] = ClocationLeft;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[1].CQuadrant[1] = ClocationLeft;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[0].CQuadrant[3] = ClocationLeft;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[1].CQuadrant[3] = ClocationLeft;

	PCMDefaults = &CMDefaults[E_INDUCTOR_COMPONENT];

	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[0].CQuadrant[0] = ClocationBottom;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[1].CQuadrant[0] = ClocationBottom;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[0].CQuadrant[2] = ClocationBottom;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[1].CQuadrant[2] = ClocationBottom;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[0].CQuadrant[0] = ClocationTop;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[1].CQuadrant[0] = ClocationTop;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[0].CQuadrant[2] = ClocationTop;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[1].CQuadrant[2] = ClocationTop;

	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[0].CQuadrant[1] = ClocationRight;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[1].CQuadrant[1] = ClocationRight;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[0].CQuadrant[3] = ClocationRight;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[1].CQuadrant[3] = ClocationRight;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[0].CQuadrant[1] = ClocationLeft;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[1].CQuadrant[1] = ClocationLeft;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[0].CQuadrant[3] = ClocationLeft;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[1].CQuadrant[3] = ClocationLeft;

	PCMDefaults = &CMDefaults[E_DIODE_COMPONENT];

	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[0].CQuadrant[0] = ClocationBottom;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[1].CQuadrant[0] = ClocationBottom;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[0].CQuadrant[2] = ClocationBottom;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[1].CQuadrant[2] = ClocationBottom;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[0].CQuadrant[0] = ClocationTop;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[1].CQuadrant[0] = ClocationTop;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[0].CQuadrant[2] = ClocationTop;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[1].CQuadrant[2] = ClocationTop;
	
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[0].CQuadrant[1] = ClocationRight;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[1].CQuadrant[1] = ClocationRight;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[0].CQuadrant[3] = ClocationRight;
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLocations_Mirror[1].CQuadrant[3] = ClocationRight;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[0].CQuadrant[1] = ClocationLeft;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[1].CQuadrant[1] = ClocationLeft;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[0].CQuadrant[3] = ClocationLeft;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLocations_Mirror[1].CQuadrant[3] = ClocationLeft;


	TCSchematicObjectData &CGraphicData = CMDefaults[E_TITLE_BLOCK];

	CGraphicData.CLocations_Mirror.SetSize(2, 2);

	CGraphicData.CLocations_Mirror[0].CQuadrant.SetSize(4, 4);
	CGraphicData.CLocations_Mirror[1].CQuadrant.SetSize(4, 4);

	int x_step = 192;
	int y_step = 48;


	ClocationLeft.x = 1;
	ClocationLeft.y = 0;

	for(int r = 0; r < E_TITLE_BLOCK_OFN + 1; r++)
	{
		TCGraphicObjectData &CGraphicObjectData = CGraphicData.CLabelListData[r];

		CGraphicObjectData.CLocations_Mirror.SetSize(2, 2);

		CGraphicObjectData.CLocations_Mirror[0].CQuadrant.SetSize(4, 4);
		CGraphicObjectData.CLocations_Mirror[1].CQuadrant.SetSize(4, 4);

		CGraphicObjectData.CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

		ClocationLeft.y += y_step;
	}


	int x_start = 8;

	ClocationLeft.y = 12;
	ClocationLeft.x	 = x_start;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_TITLE_HEADER].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	ClocationLeft.x	 += x_step;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_TITLE].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	ClocationLeft.y += y_step;
	ClocationLeft.x	 = x_start;
	
	CGraphicData.CLabelListData[E_TITLE_BLOCK_FILE_NAME_HEADER].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	ClocationLeft.x	 += x_step;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_FILE_NAME].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	ClocationLeft.y += y_step;
	ClocationLeft.x	 = x_start;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_DESIGNER_HEADER].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	ClocationLeft.x	 += x_step;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_DESIGNER].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	ClocationLeft.y += y_step;
	ClocationLeft.x	 = x_start;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_CREATED_HEADER].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	ClocationLeft.x	 += x_step;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_CREATED].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	ClocationLeft.y += y_step;
	ClocationLeft.x	 = x_start;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_DRAWN_HEADER].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	ClocationLeft.x	 += x_step;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_DRAWN].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	ClocationLeft.y += y_step;
	ClocationLeft.x	 = x_start;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_DISCRIPTION_HEADER].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	ClocationLeft.x	 += x_step;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_DISCRIPTION1].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	ClocationLeft.y += y_step;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_DISCRIPTION2].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	ClocationLeft.y += y_step;
	ClocationLeft.x	 = x_start;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_SIZE_HEADER].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	ClocationLeft.x	 += x_step;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_DOC_NUMBER_HEADER].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	ClocationLeft.x	 += x_step;
	ClocationLeft.x	 += x_step;
	ClocationLeft.x	 -= 16;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_REV_HEADER].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	ClocationLeft.y += y_step;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_REV].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	ClocationLeft.x	 = 32;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_SIZE].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;


	ClocationLeft.x	 += x_step;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_DOC_NUMBER].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;


	ClocationLeft.y += y_step;
	ClocationLeft.x	 = x_start;
	
	CGraphicData.CLabelListData[E_TITLE_BLOCK_DATE_HEADER].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	ClocationLeft.x	 += x_step;
	ClocationLeft.x	 -= 64;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_DATE].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	ClocationLeft.x	 += 64;
	ClocationLeft.x	 += x_step;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_SHEET].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	x_step = 64;

	ClocationLeft.x	 += x_step;
	ClocationLeft.x	 += x_step;
	ClocationLeft.x	 -= 16;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_NOF].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	x_step = 48;
	ClocationLeft.x	 += x_step;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_OF].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;

	ClocationLeft.x	 += x_step;

	CGraphicData.CLabelListData[E_TITLE_BLOCK_OFN].CLocations_Mirror[0].CQuadrant[0] = ClocationLeft;
}
