
#include "TDVersion.h"
#include "TEPropertyViewTypes.h"
#include "TESuperSpiceEnums.h"
#include "stdafx.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSuperSpiceGlobalData.h"



#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

void TCSuperSpiceDataBase::Setup7(void)
{
	CString CModelType = "MODEL";

	TCSchematicObjectData* PCMDefaults = &CMDefaults[E_BUFFER_COMPONENT];

	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "XBuffer";
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Buffer";
 	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLabel = "XBuffer";
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
   	PCMDefaults->CPinListData.SetSize(4, 4);
	PCMDefaults->CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "in";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "out";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "Vcc";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "Vee";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	PCMDefaults = &CMDefaults[E_MULIPLIER_COMPONENT];

	CReferanceDesignator[E_MULIPLIER_COMPONENT] = "X";
	PCMDefaults->CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	PCMDefaults->attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;//E_PROPERTY_MULTYPLIER;// 
	PCMDefaults->CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "Multiplier";
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Multiplier Component";
 	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLabel = "XMultiplier";
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "A?";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
   	PCMDefaults->CPinListData.SetSize(3, 3);
	PCMDefaults->CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);	
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "i1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "i2";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "o";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].connection_type = E_SCHEMATIC_PIN_ANALOGUE_INPUT;
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].connection_type = E_SCHEMATIC_PIN_ANALOGUE_INPUT;
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].connection_type = E_SCHEMATIC_PIN_ANALOGUE_OUTPUT;

	PCMDefaults = &CMDefaults[E_COMPONENT_DIVIDER];

	CReferanceDesignator[E_COMPONENT_DIVIDER] = "X";
	PCMDefaults->attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->CSpiceParameters.CDataBaseIdInfo.CModelType = CModelType;
	PCMDefaults->component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;//E_PROPERTY_MULTYPLIER;// same dialog box to set gain
	PCMDefaults->CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "Divider";
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Divider Component";
 	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLabel = "XDivider";
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
   	PCMDefaults->CPinListData.SetSize(3, 3);
	PCMDefaults->CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);	
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "Numerator";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "Denominater";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "o";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].connection_type = E_SCHEMATIC_PIN_ANALOGUE_INPUT;
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].connection_type = E_SCHEMATIC_PIN_ANALOGUE_INPUT;
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].connection_type = E_SCHEMATIC_PIN_ANALOGUE_OUTPUT;

	PCMDefaults = &CMDefaults[E_GENERIC_4_COMPONENT];

	PCMDefaults->attached_model_type = E_SPICE_SCHEMATIC;
	PCMDefaults->CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->f_validate_label_value = false;
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Generic4Pin";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "Generic4Pin";
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLabel = "Generic4Pin";
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	PCMDefaults->CPinListData.SetSize(4, 4);
	PCMDefaults->CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "+";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "o1";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "o2";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	PCMDefaults = &CMDefaults[E_GENERIC_5_COMPONENT];

	PCMDefaults->attached_model_type = E_SPICE_SCHEMATIC;
	PCMDefaults->f_validate_label_value = false;
	PCMDefaults->CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Generic5Pin";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "Generic5Pin";
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLabel = "Generic5Pin";
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	PCMDefaults->CPinListData.SetSize(5, 5);
	PCMDefaults->CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[4].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "-";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";


	// Valves

	PCMDefaults = &CMDefaults[E_TRIODE_VALVE];

	PCMDefaults->attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;// this needs a new dialog box when transformer dialog is changed
	PCMDefaults->CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->f_validate_label_value = false;
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Triode";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "ECC83";
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLabel = "ECC83";
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	PCMDefaults->CPinListData.SetSize(3, 3);
	PCMDefaults->CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "a";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "k";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";


	PCMDefaults = &CMDefaults[E_TETRODE_VALVE];

	PCMDefaults->attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;
	PCMDefaults->CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->f_validate_label_value = false;
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Tetrode";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "6L6";
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLabel = "6L6";
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	PCMDefaults->CPinListData.SetSize(4, 4);
	PCMDefaults->CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "a";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "sc";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "5";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "k";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "8";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	PCMDefaults = &CMDefaults[E_PENTODE_VALVE];

	PCMDefaults->attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;// this needs a new dialog box when transformer is changed
	PCMDefaults->f_validate_label_value = false;
	PCMDefaults->CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Pentode";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "EL34";
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLabel = "EL34";
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	PCMDefaults->CPinListData.SetSize(5, 5);
	PCMDefaults->CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[4].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "a";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "sc1";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "sc2";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "g";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "5";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "k";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "8";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	PCMDefaults = &CMDefaults[E_TUBE_DIODE_SINGLE];

	PCMDefaults->attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;// this needs a new dialog box when transformer dialog is changed
	PCMDefaults->CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->f_validate_label_value = false;
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "TubeDiode";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "6D22S";
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLabel = "6D22S";
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	PCMDefaults->CPinListData.SetSize(2, 2);
	PCMDefaults->CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "a";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "k";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	PCMDefaults = &CMDefaults[E_TUBE_DIODE_DUAL_COMMON_CATHODE];

	PCMDefaults->attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;// this needs a new dialog box when transformer dialog is changed
	PCMDefaults->CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->f_validate_label_value = false;
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Tube Dual Diode Seperate Cathodes";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "????";
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLabel = "????";
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	PCMDefaults->CPinListData.SetSize(3, 3);
	PCMDefaults->CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "a1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "k";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "a2";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	PCMDefaults = &CMDefaults[E_TUBE_DIODE_DUAL_INDIVIDUAL_CATHODES];

	PCMDefaults->attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;// this needs a new dialog box when transformer dialog is changed
	PCMDefaults->CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->f_validate_label_value = false;
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "Tube Dual Diode Seperate Cathodes";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "????";
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLabel = "????";
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	PCMDefaults->CPinListData.SetSize(4, 4);
	PCMDefaults->CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "a1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "k1";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "a2";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "k2";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	PCMDefaults = &CMDefaults[E_RESERVED_GENERIC_LDO];

	PCMDefaults->attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->f_validate_label_value = false;
	PCMDefaults->component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;// this needs a new dialog box when transformer is changed
	PCMDefaults->CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "LDO";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "TPS75518";
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLabel = "TPS75518";
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	PCMDefaults->CPinListData.SetSize(5, 5);
	PCMDefaults->CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[4].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "IN";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].is_visable = true;

	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "/EN";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].is_visable = true;

	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "GND";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].is_visable = true;

	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "PG/R";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].is_visable = true;

	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "OUT";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_NAME].is_visable = true;

//////////////////////////////////////////////////////////////////Digital, Analog versions with Power Pins
	
	PCMDefaults = &CMDefaults[E_AND_GATE];

	PCMDefaults->attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;// this needs a new dialog box when transformer is changed
	PCMDefaults->f_validate_label_value = false;
	PCMDefaults->CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "AND";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "AAND";
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLabel = "AND";
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	PCMDefaults->CPinListData.SetSize(5, 5);
	PCMDefaults->CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[4].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "in1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "in2";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "out";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "VDD";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "VSS";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "5";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	PCMDefaults = &CMDefaults[E_NAND_GATE];

	PCMDefaults->attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;// this needs a new dialog box when transformer is changed
	PCMDefaults->f_validate_label_value = false;
	PCMDefaults->CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "NAND";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "ANAND";
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLabel = "NAND";
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	PCMDefaults->CPinListData.SetSize(5, 5);
	PCMDefaults->CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[4].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "in1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "in2";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "out";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "VDD";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "VSS";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "5";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	PCMDefaults = &CMDefaults[E_OR_GATE];

	PCMDefaults->attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;// this needs a new dialog box when transformer is changed
	PCMDefaults->f_validate_label_value = false;
	PCMDefaults->CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	PCMDefaults->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = "OR";
	PCMDefaults->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = "AOR";
	PCMDefaults->CLabelListData[E_COMPONENT_VALUE].CLabel = "OR";
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = "X?";
	PCMDefaults->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;
	PCMDefaults->CPinListData.SetSize(5, 5);
	PCMDefaults->CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[1].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[2].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[3].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[4].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "in1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "1";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[0].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "in2";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "2";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[1].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "out";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "3";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[2].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "VDD";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "4";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[3].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = "VSS";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = "5";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_VOLTAGE].CLabel = "?V";
	PCMDefaults->CPinListData[4].CLabelListData[E_COMPONENT_PIN_CURENT].CLabel = "?A";

	Setup8();

}