// TCSuperSpiceDoc.cpp : implementation of the TCSuperSpiceDoc class


#include "stdafx.h"
#include "SuperSpice.h"
#include "resource.h"
#include "Generic.h" 
#include "TEPropertyViewTypes.h" 
#include "TESuperSpiceMsgStringsEnums.h"
#include "TESuperSpiceOpionsEnums.h"
#include "TCRealTimeData.h"
#include "TCStringFunctions.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCSuperSpiceClipboard.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSuperSpiceMainFrame.h"
#include "TCOutputWaveformChildFrame.h"
#include "TCReRuns.h"
#include "TCSchematicManager.h"
#include "TCSuperSpiceDoc.h"
#include "TCSuperSpiceControlItem.h"
#include "TCSuperSpiceServerItem.h"
#include "TCSuperSpiceView.h"
#include "TCOpenSchematicPage.h"
#include "TCSuperSpiceSchematicProperty.h"
#include "TCSchematicManager.h"
#include "TCComponentValue.h"
#include "TCComponentText.h"
#include "TCReferanceDesignator.h"
#include "TCComponentTypeName.h"
#include "TCSinglePinLable.h"
#include "TCPinInfoDlg.h"
#include "TCComponentSpiceName.h"
#include "TCNetList.h"
#include "TCAddText1.h"
#include "TCWirePropertiesDlg.h"
#include "TCWireLableDlg.h"
#include "TCSimulationSetup.h"
#include "TCSuperSpiceTextDoc.h"
#include "TCProgramOptionsMasterSheet.h"
#include "TCMasterFetDlg.h"
#include "TCMasterMOSFETDlg.h"
#include "TCMasterBipolarDlg.h"
#include "TCMasterSubcircuitDlg.h"
#include "TCMasterSubcircuitLargeDlg.h"
#include "TCMasterGeneratorDCVoltDlg.h"
#include "TCMasterGeneratorSineVoltDlg.h"
#include "TCMasterGeneratorPulseVoltDlg.h"
#include "TCMasterGeneratorExpVoltDlg.h"
#include "TCMasterGeneratorPWLVoltDlg.h"
#include "TCMasterGeneratorSFFMVoltDlg.h"
#include "TCMasterResistorDlg.h"
#include "TCMasterCapacitorDlg.h"
#include "TCMasterInductorDlg.h"
#include "TCMasterDiodeDlg.h"
#include "TCMasterTransformerDlg.h"
#include "TCMasterTransmissionLineDlg.h"
#include "TCMasterLosslessTransmissionLineDlg.h"
#include "TCMasterSwitchDlg.h"
#include "TCMasterControlledSourceDlg.h"
#include "TCMasterURCDlg.h"
#include "TCConnectorDlg.h"
#include "TCTestPointDlg.h"
#include "TCMasterValueDlg.h"
#include "TCComponentLibaryDlg.h"
#include "TCDocumentWindowsListDlg.h"
#include "TCSubcircuitPinConnectorDlg.h"
#include "TCMasterSymbolDlg.h"
#include "TCAuthorization.h"
#include "TCOutputWaveformView.h"
#include "TCOutputWaveformDoc.h"
#include "TCMasterWaveformPropPages.h"
#include "TCFloatingCursorDlg.h"
#include "TCSetTemperatureDlg.h"
#include "TCMasterGenericModelDlg.h"
#include "TCSymbolEditorDoc.h"
#include "TCMasterGenericSubcircuitDlg.h"
#include "TCMasterModelDlg.h"
#include "TCMasterLaplaceDlg.h"
#include "TCMasterFantasticFilterPropertySheet.h"
#include "TCElectronicFormulars.h"
#include "TCMasterVariableResistorDlg.h"
#include "TCPoleZeroDialog.h"
#include "TCCreateSymbolFromSchematic.h"
#include "TCSensitivityDialog.h"
#include "TCTitleBlockDlg.h"
#include "TCAnalysisMainPropPage.h"
#include "TCSearchOnSchematic.h"
#include "TCXSpiceProgressDlg.h"
#include "TCFindModelDlg.h"
#include "TCGeneralReportsTab.h"
#include "TCWorkspaceTree.h"
#include "TEAnalysisExtra.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CDC GlobalCDCTemp;
extern TCSuperSpiceClipboard GCSuperSpiceClipboard;
extern TCSuperSpiceDataBase GCSuperSpiceDataBase;
extern TCSuperSpiceGlobalData GCSuperSpiceGlobalData;
extern TCMultyTaskedString CGlobalStatusMessage;
extern CPoint GlobalMouseOffset;
extern TCAuthorization	GCAuthorization;
extern HDC	HDCMDestCmp;
extern int g_last_active_program_options_page;
extern TCElectronicFormulars GCElectronicFormulars;
extern int	g_last_active_fantastic_filter_property_page;
extern TCFantasticFilter GCFantasticFilter;
extern UINT	GSuperSpiceToXSpiceMessageID;
extern CPoint GlobalMousePosition;
extern TCSuperSpiceDoc *PCSuperSpiceDocLastFocused;
extern TCSuperSpiceView *PCSuperSpiceViewLastFocused;
extern int GetPropertyViewType(CString CModelType);
extern double SpiceMKSStringToFloat(CString &CTextData);
extern CString FloatToMKSString(double data);
extern CString CSuperSpiceXSpiceMessage;
extern TCMultyTaskedString CGlobalXSpiceMessage;
extern TCMultyTaskedString CGlobalXSpiceStatusNull;
int g_mks_invalid_value = IDS_ERR_INVALID_VALUE;
extern TCGeneralReportsTab GCGeneralReportsTab;
extern TCWorkspaceTree GCWorkspaceTree;
extern CString GCSchParamsName;
extern CString CGlobalRunStatus;

double MKSStringToFloat(CString &CTextData);
CString GetOEMProgramName(void);
CString GetWebSiteName(void);
CString GetSupportEMailName(void);
void ClearAllVars(void);

TCAnalysisSetup CAnalysisSetupDebug;
double Log(double value);

enum TE_MARCHING_WAVEFORM_STATE
{
	E_MARCHING_WAVEFORM_NULL,
	E_MARCHING_WAVEFORM_OPENING_FILE,
	E_MARCHING_WAVEFORM_READING_HEADER,
	E_MARCHING_WAVEFORM_READING_DATA,
};

CString FloatToSpiceMKSString(double);
/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceDoc

IMPLEMENT_DYNCREATE(TCSuperSpiceDoc, COleServerDoc)
IMPLEMENT_SERIAL(TCSuperSpiceDocData, CObject, ID_VERSION_NUMBER)

BEGIN_MESSAGE_MAP(TCSuperSpiceDoc, COleServerDoc)
	//{{AFX_MSG_MAP(TCSuperSpiceDoc)
	
	ON_COMMAND(ID_RUN_CREATENETLIST, OnRunCreateNetlist)
	ON_UPDATE_COMMAND_UI(ID_RUN_RUN, OnUpdateRunRun)
	ON_COMMAND(ID_OPTIONS_PROGRAM, OnOptionsProgram)
	ON_COMMAND(ID_VIEW_SCHEMATIC, OnViewSchematic)
	ON_COMMAND(ID_VIEW_SCHEMATICFILES, OnViewSchematicFiles)
	ON_COMMAND(ID_RUN_STOP, OnRunQuit)
	ON_COMMAND(ID_VIEW_TOP_LEVEL_FILES, OnViewTopLevelFiles)
	ON_COMMAND(ID_SETUP_SETTEMPERATURE, OnSetupSetTemperature)
	ON_COMMAND(ID_FILE_LOADSPICEDATAFILE, OnFileLoadSpiceDataFile)
	ON_COMMAND(ID_FILE_LOADACLIPBOARD, OnFileLoadaclipboard)
	ON_COMMAND(ID_FILE_SAVECURRENTCLIPBOARD, OnFileSavecurrentclipboard)
	ON_COMMAND(ID_SETUPS_DISPLAYSTARTMESSAGE, OnSetupsDisplayStartMessage)
	ON_COMMAND(ID_FILE_NEWTEXTFILE, OnFileNewTextFile)
	ON_COMMAND(ID_COMPONENTS_CREATESYMBOLFROMSCHEMATIC, OnComponentsCreateSymbolFromSchematic)
	ON_COMMAND(ID_COMPONENTS_CREATESYMBOLFORMODEL, OnComponentsCreateSymbolForModel)
	ON_COMMAND(ID_FILE_CREATESUBCKTMODELFROMSCHEMATIC, OnFileCreateSubcktModelFromSchematic)
	ON_COMMAND(ID_FILE_CREATEMODELANDSYMBOLFROMSCHEMATIC, OnFileCreateModelandSymbolFromSchematic)
	ON_COMMAND(ID_FILE_SAVEASTEXTDATAFILES, OnFileSaveastextdatafiles)
	ON_COMMAND(ID_VIEW_ANALYSIS_LOOPGAIN, OnViewAnalysisLoopGain)
	ON_COMMAND(ID_VIEW_ANALYSIS_TRANSIENTFREQUENCY, OnViewAnalysisTransientFrequency)
	ON_COMMAND(ID_VIEW_ANALYSISSETUP, OnViewAnalysisSetup)
	ON_COMMAND(ID_VIEW_ANALYSISRESULTS_TRANSIENTPULSE, OnViewAnalysisresultsTransientPulse)
	ON_COMMAND(ID_VIEW_REPORTS_PULSEANALYSIS, OnViewReportsPulseAnalysis)
	ON_COMMAND(ID_SETUPS_XSPICEPROGRESSRATE, OnSetupsXSpiceProgressRate)
	ON_COMMAND(ID_FILE_REPORTS_CREATETRANSIENTPOWER, OnFileReportsCreateTransientPower)
	ON_COMMAND(ID_VIEW_REPORTS_TRANSIENTPOWER, OnViewReportsTransientPower)
	ON_COMMAND(ID_COMPONENTS_FINDMODEL, OnComponentsFindModel)
	ON_COMMAND(ID_VIEW_ANALYSISRESULTS_TRANSIENTAVERAGES, OnViewAnalysisresultsTransientAverages)
	ON_COMMAND(ID_FILE_REPORTS_CREATETRANSIENTAVERAGES, OnFileReportsCreateTransientAverages)
	ON_COMMAND(ID_VIEW_REPORTS_TRANSIENTAVERAGES, OnViewReportsTransientAverages)
	ON_COMMAND(ID_FILE_REPORTS_CREATETRANSIENTPULSE, OnFileReportsPulseAnalysis)
	ON_COMMAND(ID_RUN_PAUSECONTINUE, OnRunPauseContinue)
	ON_UPDATE_COMMAND_UI(ID_RUN_PAUSECONTINUE, OnUpdateRunPauseContinue)
	ON_COMMAND(ID_RUN_ENABLEMARCHINGWAVEFORMS, OnRunEnableMarchingWaveforms)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEMARCHINGWAVEFORMS, OnUpdateRunEnableMarchingWaveforms)
	ON_COMMAND(ID_RUN_RUNASOPERATINGPOINTDESIGNER, OnRunRunasOperatingPointDesigner)
	ON_COMMAND(ID_SETUPS_DESIGNERSETUP, OnSetupsDesignerSetup)
	ON_COMMAND(ID_VIEW_PARAMETERLISTRERUNFILE, OnViewParameterlistrerunfile)
	ON_COMMAND(ID_VIEW_MONTECARLORERUNFILE, OnViewMonteCarloReRunFile)
	ON_COMMAND(ID_VIEW_PARAMETERLISTGENERATERFILE, OnViewParameterlistgeneraterfile)
	ON_COMMAND(ID_VIEW_MULTIPARAMETERSWEEPFILE, OnViewMultiParameterSweepFile)
	ON_COMMAND(ID_FILE_CREATEMULTIPLEPARAMETERSWEEPFILE, OnFileCreateMultipleParameterSweepFile)
	ON_COMMAND(ID_VIEW_WORSTCASERERUNFILE, OnViewWorstCaseReRunFile)
	//}}AFX_MSG_MAP
	// Enable default OLE container implementation
/*
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, COleServerDoc::OnUpdatePasteMenu)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE_LINK, COleServerDoc::OnUpdatePasteLinkMenu)
	ON_UPDATE_COMMAND_UI(ID_OLE_EDIT_CONVERT, COleServerDoc::OnUpdateObjectVerbMenu)
	ON_COMMAND(ID_OLE_EDIT_CONVERT, COleServerDoc::OnEditConvert)
	ON_UPDATE_COMMAND_UI(ID_OLE_EDIT_LINKS, COleServerDoc::OnUpdateEditLinksMenu)
	ON_COMMAND(ID_OLE_EDIT_LINKS, COleServerDoc::OnEditLinks)
	ON_UPDATE_COMMAND_UI(ID_OLE_VERB_FIRST, COleServerDoc::OnUpdateObjectVerbMenu)
	ON_COMMAND(ID_FILE_SEND_MAIL, OnFileSendMail)
	ON_UPDATE_COMMAND_UI(ID_FILE_SEND_MAIL, OnUpdateFileSendMail)
*/
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(TCSuperSpiceDoc, COleServerDoc)
	//{{AFX_DISPATCH_MAP(TCSuperSpiceDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//      DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_ISuperS to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {0290C288-590E-11D0-9196-F6D029BC0B3F}
static const IID IID_ISuperS =
{ 0x290c288, 0x590e, 0x11d0, { 0x91, 0x96, 0xf6, 0xd0, 0x29, 0xbc, 0xb, 0x3f } };

BEGIN_INTERFACE_MAP(TCSuperSpiceDoc, COleServerDoc)
	INTERFACE_PART(TCSuperSpiceDoc, IID_ISuperS, Dispatch)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceDoc construction/destruction

TCSuperSpiceDoc::TCSuperSpiceDoc()
{
	// Use OLE compound files
	EnableCompoundFile();

	// TODO: add one-time construction code here

	EnableAutomation();

	AfxOleLockApp();
	
	InitRefDesignators();

	*CMSuperSpiceDocData.PCAnalysisSetup = GCSuperSpiceGlobalData.CAnalysisSetup;

	CMSuperSpiceDocData.PCAnalysisSetup->PCDoc = this;

	PCParentSuperSpiceDoc	= NULL;// hirerachical support
	top_level				= true;
	HProjectFileTree		= NULL;

	PCMNetList = new TCNetList;

	if(!PCMNetList) return;

	PCMNetList->PCBillOfMaterials = &CMBillOfMaterialsList;

	HSpiceEngineProcess	= NULL;
	HSpiceEngineThread	= NULL;
	SpiceEngineProcessId = 0; 
	SpiceEngineThreadId = 0;
	m_marching_waveform_enabled = false;
	m_marching_default_size = 0;
	m_marching_waveform_state = E_MARCHING_WAVEFORM_NULL;
	m_marching_waiting_to_open_file = false;
	m_marching_waiting_to_read_data = false;
	m_marching_waiting_to_read_header = false;
	m_is_simulation_paused = false;
	m_marching_error = false;

	m_marching_last_data_point      = 0;
	m_marching_current_header_type  = -1;
	m_runs_counter					= 0;

	h_msg = 0;

//	timer_handle = 0;
	PCSuperSpiceViewTimer = NULL;

	CMSuperSpiceDocData.CWaveformDataRuns.PCDoc = this;

	CMSuperSpiceDocData.PCDoc = this;

	PCMNetList->top_level = top_level;

	PCMSearchOnSchematicDlg = new TCSearchOnSchematic;
	PCMXSpiceProgressDlg = new TCXSpiceProgressDlg;

	PCMSearchOnSchematicDlg->m_search_type = E_FIND_ON_SCHEMATIC_REF_DES;
	PCMSearchOnSchematicDlg->m_search_method = E_FIND_ON_SCHEMATIC_EXACT_TEXT;

	CMSuperSpiceDocData.CMasterSymbolEditor = GetInitDirectory() + "SuperSpice.sym";

	m_debug_mode = false;

	CVersionInfo = GCSuperSpiceGlobalData.CVersionInfo;
}

TCSuperSpiceDoc::~TCSuperSpiceDoc()
{
//	if(timer_handle) KillTimer(NULL, timer_handle);

	DeleteSchematicManagerList();
	AfxOleUnlockApp();

	if(this == PCSuperSpiceDocLastFocused)
	{
		PCSuperSpiceDocLastFocused = NULL;
		PCSuperSpiceViewLastFocused = NULL;
	}

	delete PCMSearchOnSchematicDlg;
	delete PCMXSpiceProgressDlg;

	if(PCMNetList) delete PCMNetList;
}

bool TCSuperSpiceDoc::SetParent(TCSuperSpiceDoc *PCSuperSpiceDoc, CString CFileName, CArray <CString, CString&> &CRefIDList, CString CRefDes)
{
	PCParentSuperSpiceDoc	= PCSuperSpiceDoc;
	CParentFileName			= CFileName;
	top_level				= false;

	int p, count;

	count = CRefIDList.GetSize();

	CParentRefIDList.SetSize(count);

	for(p = 0; p < count; p++) CParentRefIDList[p] = CRefIDList[p];

	CParentRefDes = CRefDes;

	if(PCMNetList)PCMNetList->top_level	= false;

	CMSuperSpiceDocData.CWaveformDataRuns.PCDoc = this;

	RegenerateSchematicDocumentsWindowList(false);//CParentRefIDList needs updated

	if(PCParentSuperSpiceDoc)// update data pointers
	{
		CMSuperSpiceDocData.CWaveformDataRuns.Load(GetTopLevelDoc()->CMSuperSpiceDocData.CWaveformDataRuns);
	}

	PCMNetList->PCBillOfMaterials = &GetTopLevelDoc()->CMBillOfMaterialsList;

	return true;
}

void TCSuperSpiceDoc::InitDocument(void)
{
	fm_load_file_first_window = FALSE;

	CSchematicManagerList.SetSize(0);

	*CMSuperSpiceDocData.PCAnalysisSetup = GCSuperSpiceGlobalData.CAnalysisSetup;
	CMSuperSpiceDocData.PCAnalysisSetup->PCDoc = this;

//	CMSuperSpiceDocData.PCAnalysisSetup->CParameterDefsSweepParameters.CData.SetSize(0); // Clear variables

	//fudge to make sure default stays 0.0
	CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_FREQ_ENABLE] = 0.0;
	CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CReserved.CStringArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] = "None";

	InitDefaults();

	InitPageList();
	
}
void TCSuperSpiceDoc::InitRefDesignators()
{
	int count = GCSuperSpiceDataBase.CReferanceDesignator.GetSize();

	CConvertIdToRefId.SetSize(count, count);
	CConvertIdToSpiceRefId.SetSize(count, count);

	for(int p = 0; p < count; p++)
	{
		CConvertIdToRefId[p]		= E_REF_DESIGNATOR_SUBCIRCUIT;
		CConvertIdToSpiceRefId[p]	= E_REF_DESIGNATOR_SUBCIRCUIT;
	}

	CConvertIdToRefId[E_LABEL_COMPONENT] = -1;
	CConvertIdToSpiceRefId[E_LABEL_COMPONENT] = -1;

	CConvertIdToSpiceRefId[E_WAVEFORM_COMPONENT] = E_REF_DESIGNATOR_WAVEFORM;
	CConvertIdToSpiceRefId[E_SUBCIRCUIT_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_WIRE_COMPONENT] = E_REF_DESIGNATOR_WIRE;
	CConvertIdToSpiceRefId[E_GROUND] = E_REF_DESIGNATOR_GROUND;
	CConvertIdToSpiceRefId[E_PAGE_CONNECTER_INPUT] = E_REF_DESIGNATOR_WIRE;
	CConvertIdToSpiceRefId[E_SUBCIRCUIT_PIN_CONNECTER] = E_REF_DESIGNATOR_WIRE;
	CConvertIdToSpiceRefId[E_CONNECTER_POWER] = E_REF_DESIGNATOR_POWER;
	CConvertIdToSpiceRefId[E_PAGE_CONNECTER_OUTPUT] = E_REF_DESIGNATOR_WIRE;
	CConvertIdToSpiceRefId[E_PAGE_CONNECTER_BIDIRECTIONAL] = E_REF_DESIGNATOR_WIRE;
	CConvertIdToSpiceRefId[E_RESISTOR_COMPONENT] = E_REF_DESIGNATOR_R;
	CConvertIdToSpiceRefId[E_VARIABLE_RESISTOR] = E_REF_XSPICE_DIGITAL;
	CConvertIdToSpiceRefId[E_IC_RESISTOR_COMPONENT] = E_REF_DESIGNATOR_R;
	CConvertIdToSpiceRefId[E_CAPACITOR_COMPONENT] = E_REF_DESIGNATOR_C;
	CConvertIdToSpiceRefId[E_IC_CAPACITOR_COMPONENT] = E_REF_DESIGNATOR_C;
	CConvertIdToSpiceRefId[E_INDUCTOR_COMPONENT] = E_REF_DESIGNATOR_L;
	CConvertIdToSpiceRefId[E_DIODE_COMPONENT] = E_REF_DESIGNATOR_DIODE;
	CConvertIdToSpiceRefId[E_ZENER_COMPONENT] = E_REF_DESIGNATOR_DIODE;
	CConvertIdToSpiceRefId[E_SHOTTKY_COMPONENT] = E_REF_DESIGNATOR_DIODE;
	CConvertIdToSpiceRefId[E_DIAC_COMPONENT] = E_REF_DESIGNATOR_DIODE;

	CConvertIdToSpiceRefId[E_DC_VOLTAGE_SOURCE] = E_REF_DESIGNATOR_VOLTAGE;
	CConvertIdToSpiceRefId[E_SINE_VOLTAGE_SOURCE] = E_REF_DESIGNATOR_VOLTAGE;
	CConvertIdToSpiceRefId[E_PULSE_VOLTAGE_SOURCE] = E_REF_DESIGNATOR_VOLTAGE;
	CConvertIdToSpiceRefId[E_EXPONENTIAL_VOLTAGE_SOURCE] = E_REF_DESIGNATOR_VOLTAGE;
	CConvertIdToSpiceRefId[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE] = E_REF_DESIGNATOR_VOLTAGE;
	CConvertIdToSpiceRefId[E_SINGLE_FREQ_VOLTAGE_FM] = E_REF_DESIGNATOR_VOLTAGE;
	CConvertIdToSpiceRefId[E_DC_CURRENT_SOURCE] = E_REF_DESIGNATOR_CURRENT;
	CConvertIdToSpiceRefId[E_SINE_CURRENT_SOURCE] = E_REF_DESIGNATOR_CURRENT;
	CConvertIdToSpiceRefId[E_PULSE_CURRENT_SOURCE] = E_REF_DESIGNATOR_CURRENT;
	CConvertIdToSpiceRefId[E_EXPONENTIAL_CURRENT_SOURCE] = E_REF_DESIGNATOR_CURRENT;
	CConvertIdToSpiceRefId[E_PIECEWISE_LINEAR_CURRENT_SOURCE] = E_REF_DESIGNATOR_CURRENT;
	CConvertIdToSpiceRefId[E_SINGLE_FREQ_CURRENT_FM] = E_REF_DESIGNATOR_CURRENT;
	
	CConvertIdToSpiceRefId[E_GENERIC_2_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_NPN_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_Q;
	CConvertIdToSpiceRefId[E_PNP_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_Q;
	CConvertIdToSpiceRefId[E_NMOS_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_M;
	CConvertIdToSpiceRefId[E_PMOS_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_M;
	CConvertIdToSpiceRefId[E_NJFET_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_J;
	CConvertIdToSpiceRefId[E_PJFET_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_J;
	CConvertIdToSpiceRefId[E_NGASFET_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_MESFET;
	CConvertIdToSpiceRefId[E_PGASFET_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_MESFET;
	CConvertIdToSpiceRefId[E_NIGBP_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;//E_REF_DESIGNATOR_NIGBP;
	CConvertIdToSpiceRefId[E_PIGBP_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;//E_REF_DESIGNATOR_PIGBP;
	CConvertIdToSpiceRefId[E_THRYSISTER_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;//E_REF_DESIGNATOR_SCR;
	CConvertIdToSpiceRefId[E_GTO_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;//E_REF_DESIGNATOR_GTO;
	CConvertIdToSpiceRefId[E_UNIJUNCTION_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;//E_REF_DESIGNATOR_UJ;
	CConvertIdToSpiceRefId[E_TRIAC_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;//E_REF_DESIGNATOR_TRIAC;
	CConvertIdToSpiceRefId[E_GENERIC_3_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_NPN_4TERM_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_Q;
	CConvertIdToSpiceRefId[E_PNP_4TERM_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_Q;
	CConvertIdToSpiceRefId[E_NMOS_4TERM_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_M;
	CConvertIdToSpiceRefId[E_PMOS_4TERM_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_M;
	CConvertIdToSpiceRefId[E_4TERM_NJFET_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_J;
	CConvertIdToSpiceRefId[E_4TERM_PJFET_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_J;
	CConvertIdToSpiceRefId[E_VCVSRC_COMPONENT] = E_REF_DESIGNATOR_VCVS;
	CConvertIdToSpiceRefId[E_ICVSRC_COMPONENT] = E_REF_DESIGNATOR_ICVS;
	CConvertIdToSpiceRefId[E_VCISRC_COMPONENT] = E_REF_DESIGNATOR_VCIS;
	CConvertIdToSpiceRefId[E_ICISRC_COMPONENT] = E_REF_DESIGNATOR_ICIS;
	CConvertIdToSpiceRefId[E_TRANSFORMER_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;//E_REF_DESIGNATOR_TRANSFORMER;
	CConvertIdToSpiceRefId[E_TRANSMISSION_LINE_COMPONENT] = E_REF_DESIGNATOR_TRANSMISSION_LINE;
	CConvertIdToSpiceRefId[E_DUAL_GATE_NMOSFET] = E_REF_DESIGNATOR_SUBCIRCUIT;//E_REF_DESIGNATOR_NDUALGATE;
	CConvertIdToSpiceRefId[E_DUAL_GATE_PMOSFET] = E_REF_DESIGNATOR_SUBCIRCUIT;//E_REF_DESIGNATOR_PDUALGATE;
	CConvertIdToSpiceRefId[E_VSWITCH_COMPONENT] = E_REF_DESIGNATOR_VSWITCH;
	CConvertIdToSpiceRefId[E_ISWITCH_COMPONENT] = E_REF_DESIGNATOR_ISWITCH;
	CConvertIdToSpiceRefId[E_BUFFER_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_MULIPLIER_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_7_PIN_OPAMP_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_8_PIN_OP_AMP_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_14_PIN_OP_AMP_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_COMPONENT_DIVIDER] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_GENERIC_4_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_GENERIC_5_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_GENERIC_6_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_GENERIC_7_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_GENERIC_2INPUT_AMP] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_VCA_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_5_PIN_OP_AMP_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_GENERIC_8_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_GENERIC_9_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_GENERIC_10_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_GENERIC_11_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_GENERIC_12_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_GENERIC_13_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_GENERIC_14_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_GENERIC_15_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_GENERIC_16_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_MULIPLIER_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;//E_REF_DESIGNATOR_FILTER;
	CConvertIdToSpiceRefId[E_TRANSFORMER_DUAL] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_TRANSFORMER_TRIPLE] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_TRANSFORMER_QUAD] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_TRANSFORMER_SINGLE_CENTERTAPED] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_TRANSFORMER_DUAL_CENTERTAPED] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_TRANSFORMER_TRIPLE_CENTERTAPED] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_TRANSFORMER_QUAD_CENTERTAPED] = E_REF_DESIGNATOR_SUBCIRCUIT;

	CConvertIdToSpiceRefId[E_TRIODE_VALVE] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_TETRODE_VALVE] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_PENTODE_VALVE] = E_REF_DESIGNATOR_SUBCIRCUIT;

	CConvertIdToSpiceRefId[E_XSPICE_DIGITAL] = E_REF_XSPICE_DIGITAL;
	CConvertIdToSpiceRefId[E_LOSSLESS_TRANSMISSION_LINE_COMPONENT] = E_REF_LOSSLESS_TRANSMISSION_LINE_COMPONENT;

	CConvertIdToSpiceRefId[E_LAPLACE_TRANSFORM] = E_REF_XSPICE_DIGITAL;
	CConvertIdToSpiceRefId[E_NONLINEAR_DEPENDANT_SOURCE] = E_REF_NONLINEAR_DEPENDANT_SOURCE;// to do, E_REF_NONLINEAR_DEPENDANT_SOURCE;

	CConvertIdToSpiceRefId[E_TRANSFORMER_TUBE_OUTPUT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_TRANSFORMER_FLYBACK_TRIPLE] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_TUBE_DIODE_SINGLE] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_TUBE_DIODE_DUAL_COMMON_CATHODE] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_TUBE_DIODE_DUAL_INDIVIDUAL_CATHODES] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_VARISTOR_MOV] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_SPICE_THERMISTOR] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToSpiceRefId[E_COMPONENT_FUSE] = E_REF_DESIGNATOR_R;
	CConvertIdToSpiceRefId[E_FREQUENCY_CRYSTAL] = E_REF_DESIGNATOR_SUBCIRCUIT;

	CConvertIdToRefId[E_WAVEFORM_COMPONENT] = E_REF_DESIGNATOR_WAVEFORM;
	CConvertIdToRefId[E_SUBCIRCUIT_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_WIRE_COMPONENT] = E_REF_DESIGNATOR_WIRE;
	CConvertIdToRefId[E_GROUND] = E_REF_DESIGNATOR_GROUND;
	CConvertIdToRefId[E_PAGE_CONNECTER_INPUT] = E_REF_DESIGNATOR_PAGE_CONNECTION;
	CConvertIdToRefId[E_SUBCIRCUIT_PIN_CONNECTER] = E_REF_DESIGNATOR_PAGE_CONNECTION;
	CConvertIdToRefId[E_CONNECTER_POWER] = E_REF_DESIGNATOR_POWER;
	CConvertIdToRefId[E_PAGE_CONNECTER_OUTPUT] = E_REF_DESIGNATOR_PAGE_CONNECTION;
	CConvertIdToRefId[E_PAGE_CONNECTER_BIDIRECTIONAL] = E_REF_DESIGNATOR_PAGE_CONNECTION;
	CConvertIdToRefId[E_TEST_MARKER] = E_REF_DESIGNATOR_TEST_MARKER;
	CConvertIdToRefId[E_RESISTOR_COMPONENT] = E_REF_DESIGNATOR_R;
	CConvertIdToRefId[E_VARIABLE_RESISTOR] = E_REF_XSPICE_DIGITAL;
	CConvertIdToRefId[E_IC_RESISTOR_COMPONENT] = E_REF_DESIGNATOR_R;
	CConvertIdToRefId[E_CAPACITOR_COMPONENT] = E_REF_DESIGNATOR_C;
	CConvertIdToRefId[E_IC_CAPACITOR_COMPONENT] = E_REF_DESIGNATOR_C;
	CConvertIdToRefId[E_INDUCTOR_COMPONENT] = E_REF_DESIGNATOR_L;
	CConvertIdToRefId[E_DIODE_COMPONENT] = E_REF_DESIGNATOR_DIODE;
	CConvertIdToRefId[E_ZENER_COMPONENT] = E_REF_DESIGNATOR_DIODE;
	CConvertIdToRefId[E_SHOTTKY_COMPONENT] = E_REF_DESIGNATOR_DIODE;
	CConvertIdToRefId[E_DIAC_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;

	CConvertIdToRefId[E_DC_VOLTAGE_SOURCE] = E_REF_DESIGNATOR_VOLTAGE;
	CConvertIdToRefId[E_SINE_VOLTAGE_SOURCE] = E_REF_DESIGNATOR_VOLTAGE;
	CConvertIdToRefId[E_PULSE_VOLTAGE_SOURCE] = E_REF_DESIGNATOR_VOLTAGE;
	CConvertIdToRefId[E_EXPONENTIAL_VOLTAGE_SOURCE] = E_REF_DESIGNATOR_VOLTAGE;
	CConvertIdToRefId[E_PIECEWISE_LINEAR_VOLTAGE_SOURCE] = E_REF_DESIGNATOR_VOLTAGE;
	CConvertIdToRefId[E_SINGLE_FREQ_VOLTAGE_FM] = E_REF_DESIGNATOR_VOLTAGE;
	CConvertIdToRefId[E_DC_CURRENT_SOURCE] = E_REF_DESIGNATOR_CURRENT;
	CConvertIdToRefId[E_SINE_CURRENT_SOURCE] = E_REF_DESIGNATOR_CURRENT;
	CConvertIdToRefId[E_PULSE_CURRENT_SOURCE] = E_REF_DESIGNATOR_CURRENT;
	CConvertIdToRefId[E_EXPONENTIAL_CURRENT_SOURCE] = E_REF_DESIGNATOR_CURRENT;
	CConvertIdToRefId[E_PIECEWISE_LINEAR_CURRENT_SOURCE] = E_REF_DESIGNATOR_CURRENT;
	CConvertIdToRefId[E_SINGLE_FREQ_CURRENT_FM] = E_REF_DESIGNATOR_CURRENT;
	
	CConvertIdToRefId[E_GENERIC_2_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_NPN_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_Q;
	CConvertIdToRefId[E_PNP_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_Q;
	CConvertIdToRefId[E_NMOS_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_M;
	CConvertIdToRefId[E_PMOS_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_M;
	CConvertIdToRefId[E_NJFET_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_J;
	CConvertIdToRefId[E_PJFET_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_J;
	CConvertIdToRefId[E_NGASFET_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_MESFET;
	CConvertIdToRefId[E_PGASFET_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_MESFET;
	CConvertIdToRefId[E_NIGBP_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;//E_REF_DESIGNATOR_NIGBP;
	CConvertIdToRefId[E_PIGBP_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;//E_REF_DESIGNATOR_PIGBP;
	CConvertIdToRefId[E_THRYSISTER_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;//E_REF_DESIGNATOR_SCR;
	CConvertIdToRefId[E_GTO_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;//E_REF_DESIGNATOR_GTO;
	CConvertIdToRefId[E_UNIJUNCTION_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;//E_REF_DESIGNATOR_UJ;
	CConvertIdToRefId[E_TRIAC_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;//E_REF_DESIGNATOR_TRIAC;
	CConvertIdToRefId[E_GENERIC_3_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_NPN_4TERM_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_Q;
	CConvertIdToRefId[E_PNP_4TERM_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_Q;
	CConvertIdToRefId[E_NMOS_4TERM_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_M;
	CConvertIdToRefId[E_PMOS_4TERM_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_M;
	CConvertIdToRefId[E_4TERM_NJFET_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_J;
	CConvertIdToRefId[E_4TERM_PJFET_TRANSISTER_COMPONENT] = E_REF_DESIGNATOR_J;
	CConvertIdToRefId[E_VCVSRC_COMPONENT] = E_REF_DESIGNATOR_VCVS;
	CConvertIdToRefId[E_ICVSRC_COMPONENT] = E_REF_DESIGNATOR_ICVS;
	CConvertIdToRefId[E_VCISRC_COMPONENT] = E_REF_DESIGNATOR_VCIS;
	CConvertIdToRefId[E_ICISRC_COMPONENT] = E_REF_DESIGNATOR_ICIS;
	CConvertIdToRefId[E_TRANSFORMER_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;//E_REF_DESIGNATOR_TRANSFORMER;
	CConvertIdToRefId[E_TRANSMISSION_LINE_COMPONENT] = E_REF_DESIGNATOR_TRANSMISSION_LINE;
	CConvertIdToRefId[E_DUAL_GATE_NMOSFET] = E_REF_DESIGNATOR_SUBCIRCUIT;//E_REF_DESIGNATOR_NDUALGATE;
	CConvertIdToRefId[E_DUAL_GATE_PMOSFET] = E_REF_DESIGNATOR_SUBCIRCUIT;//E_REF_DESIGNATOR_PDUALGATE;
	CConvertIdToRefId[E_VSWITCH_COMPONENT] = E_REF_DESIGNATOR_VSWITCH;
	CConvertIdToRefId[E_ISWITCH_COMPONENT] = E_REF_DESIGNATOR_ISWITCH;
	CConvertIdToRefId[E_BUFFER_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_MULIPLIER_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;//E_REF_DESIGNATOR_FILTER;
	CConvertIdToRefId[E_7_PIN_OPAMP_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_8_PIN_OP_AMP_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_14_PIN_OP_AMP_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_COMPONENT_DIVIDER] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_GENERIC_4_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_GENERIC_5_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_GENERIC_6_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_GENERIC_7_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_GENERIC_2INPUT_AMP] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_VCA_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;//E_REF_DESIGNATOR_VCA;
	CConvertIdToRefId[E_5_PIN_OP_AMP_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;

	CConvertIdToRefId[E_TRIODE_VALVE]  = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_TETRODE_VALVE] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_PENTODE_VALVE] = E_REF_DESIGNATOR_SUBCIRCUIT;

	CConvertIdToRefId[E_GENERIC_8_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_GENERIC_9_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_GENERIC_10_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_GENERIC_11_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_GENERIC_12_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_GENERIC_13_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_GENERIC_14_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_GENERIC_15_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_GENERIC_16_COMPONENT] = E_REF_DESIGNATOR_SUBCIRCUIT;

	CConvertIdToRefId[E_XSPICE_DIGITAL] = E_REF_XSPICE_DIGITAL;
	CConvertIdToRefId[E_LOSSLESS_TRANSMISSION_LINE_COMPONENT] = E_REF_LOSSLESS_TRANSMISSION_LINE_COMPONENT;
	CConvertIdToRefId[E_LAPLACE_TRANSFORM] = E_REF_XSPICE_DIGITAL;
	CConvertIdToRefId[E_NONLINEAR_DEPENDANT_SOURCE] = E_REF_NONLINEAR_DEPENDANT_SOURCE; // KA Oct 2017

	CConvertIdToRefId[E_TRANSFORMER_DUAL] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_TRANSFORMER_TRIPLE] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_TRANSFORMER_QUAD] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_TRANSFORMER_SINGLE_CENTERTAPED] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_TRANSFORMER_DUAL_CENTERTAPED] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_TRANSFORMER_TRIPLE_CENTERTAPED] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_TRANSFORMER_QUAD_CENTERTAPED] = E_REF_DESIGNATOR_SUBCIRCUIT;


	CConvertIdToRefId[E_TRANSFORMER_TUBE_OUTPUT] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_TRANSFORMER_FLYBACK_TRIPLE] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_TUBE_DIODE_SINGLE] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_TUBE_DIODE_DUAL_COMMON_CATHODE] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_TUBE_DIODE_DUAL_INDIVIDUAL_CATHODES] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_VARISTOR_MOV] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_SPICE_THERMISTOR] = E_REF_DESIGNATOR_SUBCIRCUIT;
	CConvertIdToRefId[E_COMPONENT_FUSE] = E_REF_DESIGNATOR_R;
	CConvertIdToRefId[E_FREQUENCY_CRYSTAL] = E_REF_DESIGNATOR_SUBCIRCUIT;

	CConvertIdToRefId[E_URC_TRANSMISSION_LINE] = E_REF_DESIGNATOR_URC;
}

int TCSuperSpiceDoc::CConvertViewTypeToGeneratorID(int view_type)
{
	//This is to get ref designator for user sources
	switch(view_type)
	{
		case E_PROPERTY_DC_VOLTAGE_SOURCE: return E_DC_VOLTAGE_SOURCE;
		case E_PROPERTY_SINE_VOLTAGE_SOURCE:return E_SINE_VOLTAGE_SOURCE;
		case E_PROPERTY_PULSE_VOLTAGE_SOURCE:return E_PULSE_VOLTAGE_SOURCE;
		case E_PROPERTY_EXPONENTIAL_VOLTAGE_SOURCE:return E_EXPONENTIAL_VOLTAGE_SOURCE;
		case E_PROPERTY_PIECEWISE_LINEAR_VOLTAGE_SOURCE:return E_PIECEWISE_LINEAR_VOLTAGE_SOURCE;
		case E_PROPERTY_SINGLE_FREQ_VOLTAGE_FM:return E_SINGLE_FREQ_VOLTAGE_FM;
		case E_PROPERTY_DC_CURRENT_SOURCE:return E_DC_CURRENT_SOURCE;
		case E_PROPERTY_SINE_CURRENT_SOURCE:return E_SINE_CURRENT_SOURCE;
		case E_PROPERTY_PULSE_CURRENT_SOURCE:return E_PULSE_CURRENT_SOURCE;
		case E_PROPERTY_EXPONENTIAL_CURRENT_SOURCE:return E_EXPONENTIAL_CURRENT_SOURCE;
		case E_PROPERTY_PIECEWISE_LINEAR_CURRENT_SOURCE:return E_PIECEWISE_LINEAR_CURRENT_SOURCE;
		case E_PROPERTY_SINGLE_FREQ_CURRENT_FM:return E_SINGLE_FREQ_CURRENT_FM;

		default: return 0;
	}
}

void TCSuperSpiceDoc::InitDefaults(void)
{	
	CMSchematicPageDataDefault.page_number = 0; // Not actually used

	CMSchematicPageDataDefault.CPageTitle.LoadString(IDS_DEFAULT_PAGE_TITLE);

/*
//	CMSchematicPageDataDefault.CPageInfo.LoadString(IDS_DEFAULT_PAGE_INFO);

	CMSchematicPageDataDefault.CPageInfo = GetOEMProgramName();

	CMSchematicPageDataDefault.CPageInfo += "\r\nemail: " + GetSupportEMailName();

	CMSchematicPageDataDefault.CPageInfo += "\r\nhttp:" + GetWebSiteName();
*/
	CMSchematicPageDataDefault.CPageInfo = "";

	CMSuperSpiceDocData.CRefId.SetSize(E_REF_DESIGNATOR_MAX, E_REF_DESIGNATOR_MAX);
	
	for(int p = 0; p < E_REF_DESIGNATOR_MAX; p++) CMSuperSpiceDocData.CRefId[p] = 0;
}

void TCSuperSpiceDoc::InitPageList(void)
{
	CMPageId.Clear();
}

int TCSuperSpiceDoc::GetNewPageId(CString CPageTitle)
{
	return CMPageId.GetNewPageId(CPageTitle);
}

void TCSuperSpiceDoc::RemovePageId(int page_id)
{
	CMPageId.RemovePageId(page_id);
}

void TCSuperSpiceDoc::DeleteSchematicManagerList(void)
{
	TCSchematicManager *PCSchematicManager;

	int count = CSchematicManagerList.GetSize();

	for(int p = 0; p < count; p++)
	{
		PCSchematicManager = CSchematicManagerList.GetAt(p);

		if(PCSchematicManager) delete PCSchematicManager;
	}

	CSchematicManagerList.SetSize(0);
}

BOOL TCSuperSpiceDoc::IsLastPageInList(TCSchematicManager *PCSchematicManager)
{
	int q = 0;

	TCSchematicManager *PCSchematicManagerInList;

	int count = CSchematicManagerList.GetSize();

	for(int p = 0; p < count; p++)
	{
		PCSchematicManagerInList = CSchematicManagerList.GetAt(p);

		if(PCSchematicManagerInList->GetPageId() == PCSchematicManager->GetPageId()) q++;
	}

	if(q > 1) return FALSE;

	return TRUE;
}

void TCSuperSpiceDoc::AddToSchematicManagerList(TCSchematicManager *PCSchematicManager)
{
	CSchematicManagerList.Add(PCSchematicManager);
}

void TCSuperSpiceDoc::RemoveFromSchematicManagerList(TCSchematicManager *PCSchematicManager)
{
	int count = CSchematicManagerList.GetSize();

	for(int p = 0; p < count; p++)
	{
		if(PCSchematicManager == CSchematicManagerList.GetAt(p)) 
		{
			CSchematicManagerList.RemoveAt(p);	

			if(PCSchematicManager) delete PCSchematicManager;

			return;
		}
	}
}


BOOL TCSuperSpiceDoc::OnNewDocument()
{
	DeleteSchematicManagerList();

	InitDocument();

	POSITION pos = GetFirstViewPosition();

	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) GetNextView(pos);

	TCSchematicManager *PCSchematicManager = CreateNewSchematicManager();

	if (!COleServerDoc::OnNewDocument())
	{
		RemoveFromSchematicManagerList(PCSchematicManager);
		return FALSE;
	}

	int page_id = GetNewPageId(CMSchematicPageDataDefault.CPageTitle);
	
	PCSchematicManager->SetPageId(page_id);

	PCSuperSpiceView->SetPageId(page_id);

	CMSchematicPageDataDefault.page_number = page_id;

	PCSchematicManager->SetPageData(CMSchematicPageDataDefault);

	PCSchematicManager->SetView(( CView *)PCSuperSpiceView);

	PCSuperSpiceView->SetSchematicManager(PCSchematicManager);

	PCSchematicManager->CreateTitleBlock();
	PCSchematicManager->CreateInitGnd();
//	PCSchematicManager->CreateInitTestMarker();

	PCSuperSpiceView->GetParent()->GetWindowPlacement(&sm_load_file_first_window_placment);

	sm_load_file_first_window_placment.showCmd = SW_SHOWMAXIMIZED;

//	PCSuperSpiceView->GetParent()->SetWindowPlacement(&sm_load_file_first_window_placment);

	return TRUE;
}

BOOL TCSuperSpiceDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	DeleteSchematicManagerList();
	InitDocument();

	POSITION pos = GetFirstViewPosition();

	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) GetNextView(pos);

	TCSchematicManager *PCSchematicManager = CreateNewSchematicManager();

	if(!PCSchematicManager) return false;

	PCSchematicManager->SetView((CView *)PCSuperSpiceView);

	if (!COleServerDoc::OnOpenDocument(lpszPathName))
	{
		RemoveFromSchematicManagerList(PCSchematicManager);
			
		return FALSE;
	}

	if(!PCSchematicManager->IsActiveView())	
	{
		PCSuperSpiceView->SetSchematicManager(NULL);
		
		return TRUE;
	}

	if(PCSuperSpiceView) 
	{
		PCSuperSpiceView->SetSchematicManager(PCSchematicManager);

		PCSchematicManager->Zoom(PCSchematicManager->CMSchematicManagerData.zoom, PCSuperSpiceView->GetState());
	}

	SetFileNames(lpszPathName);

	LoadWorkspace();

	CMCreateSymbolFromSchematicData.CSchematicName = lpszPathName;
	CMCreateSymbolFromSchematicData.Load();

	RegenerateSchematicDocumentsWindowList(false);
	
	TCSchematicPageData &CSchematicPageData = PCSchematicManager->GetPageData();

	CSchematicPageData.CFileName = CMSchematicPageDataDefault.CFileName;

	fm_load_file_first_window = TRUE;

	return TRUE;
}

TCSchematicManager *TCSuperSpiceDoc::CreateNewSchematicManager(void)
{
	TCSchematicManager *PCSchematicManager = new TCSchematicManager;

	if(!PCSchematicManager) return NULL; 

	PCSchematicManager->PCWaveformDataRuns = &CMSuperSpiceDocData.CWaveformDataRuns;

	AddToSchematicManagerList(PCSchematicManager);

	return PCSchematicManager;
}

void TCSuperSpiceDoc::OnViewInitialUpdate(CView *PCView)
{
	PCView;
}



TCSchematicManager *TCSuperSpiceDoc::FindSchematicManager(CView *PCView)
{
	TCSchematicManager *PCSchematicManager;

	int count = CSchematicManagerList.GetSize();

	for(int p = 0; p < count; p++)
	{
		PCSchematicManager = CSchematicManagerList.GetAt(p);

		if(PCSchematicManager->GetView() != PCView) continue;

		return PCSchematicManager;
	}

	return NULL;
}


void TCSuperSpiceDoc::EnsureActiveViewAt0InList(void)
{
	TCSchematicManager *PCSchematicManager;
	TCSchematicManager *PCSchematicManagerSwop;

	int count = CSchematicManagerList.GetSize();

	for(int p = 0; p < count; p++)
	{
		PCSchematicManager = CSchematicManagerList.GetAt(p);

		if(PCSchematicManager->GetView() == NULL) continue;

		PCSchematicManagerSwop = CSchematicManagerList.GetAt(0);

		CSchematicManagerList.SetAt(0, PCSchematicManager);

		CSchematicManagerList.SetAt(p, PCSchematicManagerSwop);

		return;
	}

}
/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceDoc server implementation

COleServerItem* TCSuperSpiceDoc::OnGetEmbeddedItem()
{
	// OnGetEmbeddedItem is called by the framework to get the COleServerItem
	//  that is associated with the document.  It is only called when necessary.

	TCSuperSpiceServerItem* pItem = new TCSuperSpiceServerItem(this);
	ASSERT_VALID(pItem);
	return pItem;
}

/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceDoc serialization

void TCSuperSpiceDoc::Serialize(CArchive& ar)
{
	// Calling the base class COleServerDoc enables serialization
	//  of the container document's COleClientItem objects.
	COleServerDoc::Serialize(ar);

	CMSuperSpiceDocData.Serialize(ar);
	CVersionInfo.Serialize(ar);

	TCSchematicManager	*PCSchematicManager;
	TCSuperSpiceView	*PCSuperSpiceView;
	int					page_id;
	CSize				CViewSize;
	int					count;
	int					system_state;
	int save_serialize = 12345678;
	int load_serialize = 3456;

	WINDOWPLACEMENT		s_window_placment;	

	s_window_placment = GetDefaultWindowPlacment();

	if (ar.IsStoring())
	{
		count = CSchematicManagerList.GetSize();

		PCSchematicManager = CSchematicManagerList.GetAt(0);

		TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCSchematicManager->GetView();
		system_state = PCSuperSpiceView->GetState();

		ar <<system_state;

		ar << count;

		EnsureActiveViewAt0InList();

		for(int p = 0; p < count; p++)
		{
			PCSchematicManager = CSchematicManagerList.GetAt(p);

			PCSchematicManager->Serialize(ar); 

			CView *PCSchematicView = PCSchematicManager->GetView();

			if(PCSchematicManager->IsActiveView()) PCSchematicView->GetParent()->GetWindowPlacement(&s_window_placment);

			ar.Write(&s_window_placment, sizeof(WINDOWPLACEMENT));
		}
	}
	else
	{	
		POSITION pos = GetFirstViewPosition();

		ar >> system_state;

		ar >> count;

		for(int p = 0; p < count; p++)
		{	
			if(p) // Stuff first window into framework generated window 
			{	
				PCSchematicManager = CreateNewSchematicManager();

				PCSchematicManager->Serialize(ar);

				//setup waveform data pointers
				PCSchematicManager->UpdateSchematicWaveforms(*CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]);

				ar.Read(&s_window_placment, sizeof(WINDOWPLACEMENT));

				page_id = PCSchematicManager->GetPageId();
				CViewSize = PCSchematicManager->GetViewSize();
				
				if(PCSchematicManager->IsActiveView()) 
				{
					PCSuperSpiceView = (TCSuperSpiceView *) CreateNewView(this);

					PCSuperSpiceView->GetParent()->SetWindowPlacement(&s_window_placment);

					PCSchematicManager->SetView((CView *) PCSuperSpiceView);

					PCSuperSpiceView->SetSchematicManager(PCSchematicManager);

					PCSuperSpiceView->SetPageId(page_id);
					PCSuperSpiceView->SetState((TE_GRAPHICS_MANAGER_SYSTEM_STATE) system_state);

					PCSuperSpiceView->SetScrollBarPosition(PCSchematicManager->GetScrollBarPosition());
		
					PCSuperSpiceView->SetViewSize(CViewSize);

					PCSchematicManager->Zoom(PCSchematicManager->CMSchematicManagerData.zoom, PCSuperSpiceView->GetState());
				}
				else
				{
					PCSchematicManager->SetView(NULL);
				}

				TCSchematicPageData CPageData;

				CPageData = PCSchematicManager->GetPageData();

				CMPageId.Update(page_id, CPageData.CPageTitle); 
				 
			}
			else 
			{
				PCSuperSpiceView = (TCSuperSpiceView *) GetNextView(pos);

				PCSchematicManager	= CSchematicManagerList.GetAt(0);

				PCSchematicManager->Serialize(ar);

				PCSchematicManager->UpdateSchematicWaveforms(*CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]);

				ar.Read(&sm_load_file_first_window_placment, sizeof(WINDOWPLACEMENT));

				page_id = PCSchematicManager->GetPageId();
				CViewSize = PCSchematicManager->GetViewSize();

				PCSuperSpiceView->SetPageId(page_id);
				PCSuperSpiceView->SetViewSize(CViewSize);
				PCSuperSpiceView->SetState((TE_GRAPHICS_MANAGER_SYSTEM_STATE) system_state);

				TCSchematicPageData CPageData;

				CPageData = PCSchematicManager->GetPageData();

				CMPageId.Update(page_id, CPageData.CPageTitle); 

				if(PCSchematicManager->IsActiveView()) 
				{
					PCSchematicManager->SetView((CView *) PCSuperSpiceView);

					// Cannot set window placement here as it has not yet been created
				}
				else PCSchematicManager->SetView(NULL);

			}
		}

		CMWaveformAnalyisisData = CMSuperSpiceDocData.PCAnalysisSetup->CReRun;
	}

	if(ar.IsStoring())
	{
		ar << save_serialize;
	}
	else
	{
		ar >> load_serialize;

		if(save_serialize != load_serialize)
		{
			AfxMessageBox(IDS_INVALID_FILE);

			return;
		}
	}
}

TCSuperSpiceDocData::TCSuperSpiceDocData()
{
	m_graphic_counter = 0;
	PCAnalysisSetup = new TCAnalysisSetup;

	CWaveformDataRuns.SetSize(1);
}

TCSuperSpiceDocData::~TCSuperSpiceDocData()
{
	if(PCAnalysisSetup) delete PCAnalysisSetup;
}

void TCSuperSpiceDocData::Serialize(CArchive& ar)
{
	CObject::Serialize(ar);

	PCAnalysisSetup->Serialize(ar);

	int count;
	int p;
	int number_of_runs = 1;

	if (ar.IsStoring())
	{
		ar << CMasterNetListFileName;
		ar << CMasterIncludeFileName;
		ar << CMasterOutputTextFileName;
		ar << CMasterModelFileName;
		ar << CMasterWorkspaceFileName;
		ar << CMasterOutputDataFileName;
		ar << CMasterOutputWaveform;
		ar << CSymbolFileName;
		ar << CMasterTextNotes;
		ar << m_graphic_counter;

		count = CWaveformDataRuns.CRuns.GetSize();

		ar << count;

		count = CRefId.GetSize();
	
		ar << count;

		for(p = 0; p < count; p++) ar << CRefId[p];
	}	
	else
	{
		ar >> CMasterNetListFileName;
		ar >> CMasterIncludeFileName;
		ar >> CMasterOutputTextFileName;
		ar >> CMasterModelFileName;
		ar >> CMasterWorkspaceFileName;
		ar >> CMasterOutputDataFileName;
		ar >> CMasterOutputWaveform;
		ar >> CSymbolFileName;
		ar >> CMasterTextNotes;
		ar >> m_graphic_counter;
		ar >> number_of_runs;

		ar >> count;

		if(count > CRefId.GetSize())
			CRefId.SetSize(count, count);

		for(p = 0; p < count; p++) ar >> CRefId[p];

		if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.load_last_output_data)
		{	
			CWaveformDataRuns.Load(CMasterOutputDataFileName, number_of_runs, PCDoc, NULL, 0);// need to figure out how to reload wc cleanly
			
			GCWorkspaceTree.LoadSignalsList(&CWaveformDataRuns, -1);
		}

		CString CExt = GetFileExtention(CSymbolFileName);
	
		CExt.MakeLower();

		if(CExt == "srp") CSymbolFileName = ""; //backwards compatability
	}
}

/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceDoc diagnostics

#ifdef _DEBUG
void TCSuperSpiceDoc::AssertValid() const
{
	COleServerDoc::AssertValid();
}

void TCSuperSpiceDoc::Dump(CDumpContext& dc) const
{
	COleServerDoc::Dump(dc);
}
#endif //_DEBUG

////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceDoc commands

void TCSuperSpiceDoc::OnViewDrawAll(CView *PCView, TCSchematicManager *PCSchematicManager)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;

	if(!PCSchematicManager) 
	{
		PCSchematicManager = FindSchematicManager(PCView);

		if(!PCSchematicManager) return;

		PCSuperSpiceView->SetSchematicManager(PCSchematicManager);
	}

	
	if(fm_load_file_first_window) // nasty fix on load file
	{
		fm_load_file_first_window = FALSE;

		if(!PCParentSuperSpiceDoc)// this WILL be redone
		{
		PCSuperSpiceView->GetParent()->SetWindowPlacement(&sm_load_file_first_window_placment);

		PCSuperSpiceView->SetScrollSizesZoomed(PCSchematicManager->GetZoom());

		PCSuperSpiceView->SetScrollBarPosition(PCSchematicManager->GetScrollBarPosition());
		}

		SetWindowTitle((CMDIChildWnd *)PCSuperSpiceView->GetParent());

		PCSchematicManager->SetView(PCView);
	}

	if(PCSchematicManager) PCSchematicManager->DrawAll();
}


CView * TCSuperSpiceDoc::OnViewNewView(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceNewView	  = (TCSuperSpiceView *) CreateNewView(this);
	TCSuperSpiceView *PCSuperSpiceCurrentView = (TCSuperSpiceView *) PCView;

	int page_id = PCSuperSpiceCurrentView->GetPageId();

	CSize CViewSize = PCSuperSpiceCurrentView->GetViewSize();

	TCSchematicManager *PCNewSchematicManager = CreateNewSchematicManager();
	
	if(!PCNewSchematicManager) return NULL;

	TCSchematicManager *PCSchematicManager =  PCSuperSpiceCurrentView->GetSchematicManager();	

	if(!PCSchematicManager) return NULL;

	PCNewSchematicManager->SetView(( CView *)PCSuperSpiceNewView);

	PCSuperSpiceNewView->SetSchematicManager(PCNewSchematicManager);

	PCSuperSpiceNewView->SetPageId(page_id);
	PCSuperSpiceNewView->SetViewSize(CViewSize);
	PCSuperSpiceNewView->m_current_waveform_type = PCSuperSpiceCurrentView->m_current_waveform_type;

	PCNewSchematicManager->SetPageId(page_id);
	PCNewSchematicManager->SetViewSize(CViewSize);

	TCSchematicPageData CPageData;

	CPageData = PCSchematicManager->GetPageData();

	PCNewSchematicManager->SetPageData(CPageData);

	PCNewSchematicManager->SetScrollBarPosition(PCSchematicManager->GetScrollBarPosition());
	
	PCSuperSpiceNewView->SetScrollBarPosition(PCSchematicManager->GetScrollBarPosition());

	*PCNewSchematicManager = *PCSchematicManager;

	SetWindowTitle((CMDIChildWnd *)PCSuperSpiceNewView->GetParent());

	PCSuperSpiceNewView->ShowWindow(SW_SHOW); 
	PCSuperSpiceNewView->UpdateWindow();

	return (CView *) PCSuperSpiceNewView;
}


CView * TCSuperSpiceDoc::OnViewNewPage(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;

	TCSuperSpiceView *PCSuperSpiceNewView = (TCSuperSpiceView *) CreateNewView(this);

	TCSchematicManager *PCNewSchematicManager = CreateNewSchematicManager();

	if(!PCNewSchematicManager) return NULL;

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
		
	PCNewSchematicManager->SetView(( CView *)PCSuperSpiceNewView);

	PCSuperSpiceNewView->SetSchematicManager(PCNewSchematicManager);

	int page_id = GetNewPageId(CMSchematicPageDataDefault.CPageTitle);

	CSize CViewSize = PCSuperSpiceView->GetViewSize();

	PCNewSchematicManager->SetPageId(page_id);
	PCNewSchematicManager->SetViewSize(CViewSize);
	
	PCSuperSpiceNewView->SetPageId(page_id);
	PCSuperSpiceNewView->SetViewSize(CViewSize);

	TCSchematicPageData CPageData;

	CPageData = PCSchematicManager->GetPageData();

	CPageData.page_number = page_id;

	PCNewSchematicManager->SetPageData(CPageData);

	SetWindowTitle((CMDIChildWnd *)PCSuperSpiceNewView->GetParent());

	return (CView *) PCSuperSpiceNewView;
}

void TCSuperSpiceDoc::OnViewCopyPage(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;

	TCSchematicManager *PCSchematicManager =  PCSuperSpiceView->GetSchematicManager();	

	if(!PCSchematicManager) return;

	TCSuperSpiceView *PCSuperSpiceNewView = (TCSuperSpiceView *) OnViewNewView(PCView);

	TCSchematicManager *PCNewSchematicManager =  PCSuperSpiceNewView->GetSchematicManager();	

	if(!PCNewSchematicManager) return;

	int page_id = GetNewPageId(CMSchematicPageDataDefault.CPageTitle);

	TCSchematicPageData CPageData;

	CPageData = PCSchematicManager->GetPageData();

	CPageData.page_number = page_id;

	PCNewSchematicManager->SetPageData(CPageData);

	PCSuperSpiceNewView->SetPageId(page_id);
	PCNewSchematicManager->SetPageId(page_id);
	PCSuperSpiceNewView->m_current_waveform_type = PCSuperSpiceView->m_current_waveform_type;

	PCSuperSpiceNewView->ShowWindow(SW_SHOW); 
	PCSuperSpiceNewView->UpdateWindow();

	SetWindowTitle((CMDIChildWnd *)PCSuperSpiceNewView->GetParent());
}

void TCSuperSpiceDoc::OnViewDestroyWindow(CView *PCView, TCSchematicManager *PCSchematicManager)
{
	PCView;

	if(!PCSchematicManager) return; // Already procesed by DeletePage

	if(IsLastPageInList(PCSchematicManager))
	{
		PCSchematicManager->SetView(NULL); // do not destroy page info
											// only destroy the view
		return;
	}
			
	RemoveFromSchematicManagerList(PCSchematicManager);	
}

CView *TCSuperSpiceDoc::OnViewOpenPage(CView *PCView,  TCSchematicManager *PCSchematicManager)
{
	PCSchematicManager;
	TCOpenSchematicPage COpenPageDlg;
	TCSchematicManager *PCSchematicManagerInList;
	int index;

	COpenPageDlg.SetData(CMPageId.CPageIdData);

	COpenPageDlg.DoModal();

	if(COpenPageDlg.IsOk())
	{
		index = COpenPageDlg.GetData();

		int count = CSchematicManagerList.GetSize();

		int page_id = CMPageId.CPageIdData.GetAt(index).page_id;

		for(int p = 0; p < count; p++) 
		{
			PCSchematicManagerInList = CSchematicManagerList.GetAt(p);

			if(PCSchematicManagerInList->GetPageId() != page_id) continue;
			
			if(PCSchematicManagerInList->IsActiveView())
			{
				CWnd *PCChildWnd = PCSchematicManagerInList->GetView()->GetParent();
			
				PCChildWnd->ShowWindow(SW_SHOWNORMAL);
				PCChildWnd->BringWindowToTop();

				return PCSchematicManagerInList->GetView();
			}
			else
			{		
				return OpenPage(PCSchematicManagerInList);
			}	
		}
	}

	return PCView; 
}

CView *TCSuperSpiceDoc::OpenPage(TCSchematicManager *PCSchematicManager)
{
	TCSuperSpiceView *PCSuperSpiceNewView	  = (TCSuperSpiceView *) CreateNewView(this);

	if(!PCSchematicManager) return NULL;

	if(!PCSuperSpiceNewView) return NULL;

	PCSchematicManager->SetView(( CView *) PCSuperSpiceNewView);

	PCSuperSpiceNewView->SetSchematicManager(PCSchematicManager);

	PCSuperSpiceNewView->SetPageId(PCSchematicManager->GetPageId());

	SetWindowTitle((CMDIChildWnd *)PCSuperSpiceNewView->GetParent());

	return (CView *) PCSuperSpiceNewView;
}


void TCSuperSpiceDoc::OnViewDeletePage(CView *PCView, TCSchematicManager *PCSchematicManager)
{
	PCView;


	TCSchematicManager *PCSchematicManagerInList;
	TCSuperSpiceView *PCSuperSpiceView;

	if(!PCSchematicManager) return;

	CArray <TCSchematicManager *, TCSchematicManager *> CSchematicManagerTempList;

	CSchematicManagerTempList.SetSize(0);

	int page_id = 0;

	int count = CSchematicManagerList.GetSize();

	bool last_page = true;

	int p;

	for(p = 0; p < count; p++) // First find all pages
	{
		PCSchematicManagerInList = CSchematicManagerList.GetAt(p);

		page_id = PCSchematicManager->GetPageId();

		if(PCSchematicManagerInList->GetPageId() == page_id)
		{
			CSchematicManagerTempList.Add(PCSchematicManagerInList);
		}
		else last_page = false;// see if any other pages, if none do not delete
	}

	if(last_page)
	{
		AfxMessageBox(IDS_NO_DELETE_PAGE);

		return;
	}
	
	RemovePageId(page_id);

	count = CSchematicManagerTempList.GetSize();

	for(p = 0; p < count; p++) // Now delete all pages and open views
	{
		PCSchematicManagerInList = CSchematicManagerTempList.GetAt(p);

		PCSuperSpiceView = (TCSuperSpiceView *) PCSchematicManagerInList->GetView();

		PCSuperSpiceView->SetSchematicManager(NULL); // Inform the view to inform the 
													// doc intercept of destroy window
													// that window has already been destroyed

		if(PCSuperSpiceView) PCSuperSpiceView->GetParent()->DestroyWindow();
	
		RemoveFromSchematicManagerList(PCSchematicManagerInList);
	}

	GenerateUniqueSchematicManagers();
}   

TCOutputWaveformDoc *TCSuperSpiceDoc::DisplayOutputGraphics(CString CFileName)
{
	if(!FileExists(CFileName))// create default graphic output
	{
		CreateOutputWaveformFile(CMSuperSpiceDocData.CMasterOutputWaveform);
	}
 
	TCOutputWaveformDoc *PCDoc;

//	WINDOWPLACEMENT	s_window_placment = GetWindowPlacement(this);
	WINDOWPLACEMENT	s_window_placment = GetViewPlacement(this);

	if(CDocumentWindowsList.IsOpen(CFileName))
	{// activate document view

		PCDoc = (TCOutputWaveformDoc *)CDocumentWindowsList.Open(this, CFileName);

		if(!PCDoc)// windows dialogs this error
		{
			return NULL;
		}

		PCDoc->PCParentSuperSpiceDoc = this;
	}
	else
	{
		SetupGraphWindowSize(s_window_placment);

		PCDoc = (TCOutputWaveformDoc *)CDocumentWindowsList.Open(this, CFileName);

		if(!PCDoc)// windows dialogs this error
		{
			RestoreGraphWindowSize();

			return NULL;
		}

		PCDoc->PCParentSuperSpiceDoc = this;
		
		//restore signals setup, once wavefprm knows its parent

		PCDoc->UpdateAllViews(NULL, NULL);

		RestoreGraphWindowSize();
	}

	SyncWindowType(PCDoc, s_window_placment);

	return PCDoc;
}

void TCSuperSpiceDoc::OnViewDisplaySchematic(CView *PCView)
{
	PCView;
	ActivateADocumentView(this);
}
void TCSuperSpiceDoc::OnViewSchematic() 
{
	ActivateADocumentView(this);
}


TCSuperSpiceTextDoc  *TCSuperSpiceDoc::DisplayTextBasedDocument(CString CFileName)
{
	if(CFileName == "")
	{
		AfxMessageBox(IDS_MUST_SAVE_ONCE);

		return NULL;
	}

	if(!FileExists(CFileName))
	{
		AfxMessageBox(IDS_FILE_NOT_EXISTS);

		return NULL;
	}
 
	WINDOWPLACEMENT	s_window_placment = ::GetWindowPlacement(this);

	// adds to document list
	TCSuperSpiceTextDoc  *PCDoc = (TCSuperSpiceTextDoc *)CDocumentWindowsList.Open(this, CFileName);

	if(!PCDoc)// windows dialogs this error
	{
		return NULL;
	}
		
	PCDoc->PCParentSuperSpiceDoc = this;

//	AddModelLibaryDoc(this, CFileName);

	SyncWindowType(PCDoc, s_window_placment);

	return PCDoc;
}

void TCSuperSpiceDoc::SyncWindowType(CDocument *PCDoc, WINDOWPLACEMENT &s_window_placment)
{
	// if maximized, make new window maximised
	WINDOWPLACEMENT	s_synced_window_placment;

	if(!PCDoc) return;

	s_synced_window_placment = ::GetWindowPlacement(PCDoc);

	if(s_window_placment.showCmd == SW_SHOWMAXIMIZED)
		s_synced_window_placment.showCmd = s_window_placment.showCmd;

	POSITION pos = PCDoc->GetFirstViewPosition();

	CView* PCView = PCDoc->GetNextView(pos);

	if(!PCView) return;

	PCView->GetParent()->SetWindowPlacement(&s_synced_window_placment);
}

void TCSuperSpiceDoc::OnViewDisplayPoleZeroText(CView *PCView)
{
	PCView;

	TCPoleZeroDialog CPoleZeroDialog;

	CPoleZeroDialog.PCWaveformDataRuns = &CMSuperSpiceDocData.CWaveformDataRuns;

	CPoleZeroDialog.DoModal();
}

void TCSuperSpiceDoc::OnViewDisplaySensitivityText(CView *PCView)
{
	PCView;

	TCSensitivityDialog CSensitivityDialog;

	CSensitivityDialog.PCWaveformDataRuns = &CMSuperSpiceDocData.CWaveformDataRuns;

	CSensitivityDialog.DoModal();
}

TCSymbolEditorDoc  *TCSuperSpiceDoc::DisplaySymbolEditorDocument(CString CFileName, CString CSymbolFileName, CString CSymbolName)
{
	CArray <CString, CString&>	CDummyList;
	CString CDummyText;
	bool f_file_auto_created = false;

	WINDOWPLACEMENT	s_window_placment = ::GetWindowPlacement(this);

	if(CFileName == "")
	{
		f_file_auto_created = true;

		DisplayError(IDS_ERR_WARNING, IDS_UNTITLED_SYMBOL_FILE);

		CDocumentWindowsList.Create(CFileName, E_SYMBOL_DOCUMENT, this, CDummyList, CDummyText);
	}

	if(!FileExists(CFileName))
	{
		f_file_auto_created = true;

		DisplayError(IDS_ERR_WARNING, IDS_NEW_SYMBOL_FILE);

		if(!CreateSymbolEditorFile(CFileName))
		{
			CDocumentWindowsList.Create(CMSuperSpiceDocData.CMasterSymbolEditor, E_SYMBOL_DOCUMENT, this, CDummyList, CDummyText);
		}

		CDocumentWindowsList.Create(CFileName, E_SYMBOL_DOCUMENT, this, CDummyList, CDummyText);
	}
 
	// adds to document list

	bool is_open = false;
	
	if(CDocumentWindowsList.IsOpen(CFileName)) is_open = true;

	TCSymbolEditorDoc  *PCDoc = (TCSymbolEditorDoc *)CDocumentWindowsList.Open(this, CFileName);

	if(!PCDoc)// May not be in list, so try adding it
	{
		CDocumentWindowsList.Create(CFileName, E_SYMBOL_DOCUMENT, this, CDummyList, CDummyText);

		PCDoc = (TCSymbolEditorDoc *)CDocumentWindowsList.Open(this, CFileName);

		if(!PCDoc) return NULL;
	}
		
	RegenerateSchematicDocumentsWindowList(false);

	PCDoc->PCParentSuperSpiceDoc = this;

	SyncWindowType(PCDoc, s_window_placment);

	DisplayError(IDS_HELP_NOTE, IDS_SYMED_HELP_NOTE1);
	DisplayError(IDS_HELP_NOTE, IDS_SYMED_HELP_NOTE2);
	DisplayError(IDS_HELP_NOTE, IDS_SYMED_HELP_NOTE5);


	if(!is_open || f_file_auto_created)
	{
		POSITION pos = PCDoc->GetFirstViewPosition();

		TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *) PCDoc->GetNextView(pos);
	
		PCDoc->DisplayComponentLib(PCSymbolEditorView, CSymbolFileName, CSymbolName);

		return PCDoc;
	}

	if(CSymbolName != "")
	{
		PCDoc->CMSymbolEditorData.CSymbolFileName = CSymbolFileName;
		
		PCDoc->CMSymbolEditorData.CSymbolName = CSymbolName;

		TCSymbolEditorView *PCSymbolEditorView = PCDoc->GetView();

		PCDoc->UnCompileSymbol(PCSymbolEditorView->GetSchematicManager(), PCDoc->CMSymbolEditorData);

		PCDoc->SetPathName(CFileName);
	}

	return PCDoc;
}

TCSuperSpiceDoc* TCSuperSpiceDoc::DisplayChildSchematicDocument(CString CFileName, CString CRefID)
{
	if(!FileExists(CFileName))
	{
		AfxMessageBox(IDS_FILE_NOT_EXISTS);

		return NULL;
	}
 
	//no way of disbling subckts from trying to load a data file without over riding global
	int load_last_output_data = GCSuperSpiceGlobalData.CProgramOptions.CGeneral.load_last_output_data;

	GCSuperSpiceGlobalData.CProgramOptions.CGeneral.load_last_output_data = false;
		
//////Get current window placement
	
	WINDOWPLACEMENT	s_window_placment = GetWindowPlacement(this);

	TCSuperSpiceDoc  *PCDoc = (TCSuperSpiceDoc *)CDocumentWindowsList.Open(this, CFileName);

	GCSuperSpiceGlobalData.CProgramOptions.CGeneral.load_last_output_data = load_last_output_data;

	if(!PCDoc)// windows dialogs this error
	{
		return NULL;
	}
		
	CArray <CString, CString&> CNewRefIdList;

	CreateRefDesList(CNewRefIdList, CRefID);

	CRefID = GetNewRefDes(CRefID);

	PCDoc->SetParent(this, CFileName, CNewRefIdList, CRefID);

	CMDIChildWnd *PCView = (CMDIChildWnd *)PCDoc->m_viewList.GetHead();

	PCDoc->SetWindowTitle((CMDIChildWnd *) PCView->GetParent());// to update ref des in title

	PCDoc->RestorePinHierarchyNames();// for probing

	//added 2nd June2002, CDocumentWindowsList.IsOpen() failing, added PCSuperSpiceDoc as well
	CDocumentWindowsList.Create(CFileName, E_SCHEMATIC_DOCUMENT, this, CNewRefIdList, CRefID, PCDoc);

	RegenerateSchematicDocumentsWindowList(false);

	PCDoc->UpdateAllViews(NULL, NULL);

	if(GetTopLevelDoc()->CMWaveformAnalyisisData.power_enable) 
	{
		PCDoc->GenerateUniqueSchematicManagers();
		PCDoc->CalculateAllTransientPowers();
	}

	SyncWindowType(PCDoc, s_window_placment);

	SyncAnalysisSetup(PCDoc);

	return PCDoc;
}

TCSuperSpiceDoc *TCSuperSpiceDoc::CreateNewChildSchematicDocument(CString CFileName)
{
	TCSuperSpiceDoc *PDoc;

	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp*) AfxGetApp();

	CMultiDocTemplate *PCMultiDocTemplate = PCSuperSpiceApp->GetSuperSpiceDocTemplate();

	if(!PCMultiDocTemplate) return NULL;

	PDoc = (TCSuperSpiceDoc *)PCMultiDocTemplate->OpenDocumentFile(NULL);

	if(!PDoc) return NULL;

	PDoc->DoSave(CFileName, true);

	return PDoc;
}

bool TCSuperSpiceDoc::CreateChildSchematicPins(TCSchematicObjectData &CSchematicObjectData)
{
	TCSchematicManager *PCSchematicManager;
	CView *PCView;
	CPoint CMousePosition;

	if(!CSchematicManagerList.GetSize()) return false;// if fails whole system is fucked so ignore

	PCSchematicManager = CSchematicManagerList[0];

	if(!PCSchematicManager) return false;// Cant happan;

	POSITION pos = GetFirstViewPosition();

	PCView = (TCSuperSpiceView *)GetNextView(pos);

	if(!PCView) false;// Cant happan

	CMousePosition.x = 64;
	CMousePosition.y = 64;

	int count;

	count = CSchematicObjectData.CPinListData.GetSize();

	if(!count) return false;// Should not ever happen;

	int p = 0;

	int y_counter = 0;

	CString CPinName;

	for(p = 0; p < count; p++)// this relies on the fact that each new pin conector is put insequance from 0
	{
		CMousePosition.x += 48;

		CPinName = CSchematicObjectData.CPinListData[p].CLabelListData[E_COMPONENT_PIN_NAME].CLabel;

		//generate new connector
		OnViewIdleStateGetGraphic(PCView, 0, CMousePosition, E_SUBCIRCUIT_PIN_CONNECTER, 0);
	
		//place new connector on page
		OnViewGotGraphicStateLBDown(PCView, 0, 0, CMousePosition);
		OnViewGotGraphicOnCancel(PCView);

		//set connector name
		PCSchematicManager->SetPinLabel(p, 0, E_COMPONENT_PIN_NET_NAME, CPinName, true);
	
		CPinName.Format("%d", p);//set connector pin ID

		PCSchematicManager->SetLabel(p, E_COMPONENT_VALUE, CPinName, true);

		y_counter++;

		if(y_counter > 15) // 16 connectors to a line
		{
			y_counter = 0;

			CMousePosition.y += 64;
		}		
	}

	return true;
}

void TCSuperSpiceDoc::OnViewDecendSchematic(CView *PCView, CPoint CMousePosition, UINT mouse_flags) 
{	//GCSuperSpiceGlobalData.CGeneral.open_subcurcuits_in_new_window;
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();

	if(!PCSchematicManager) return;

	OnLButtonDblClk(PCView, CMousePosition, mouse_flags);
}

CView *TCSuperSpiceDoc::GetTopLevelSchematicView(void)
{
	TCSuperSpiceDoc *PCSuperSpiceDoc = GetTopLevelDoc();

	POSITION pos = PCSuperSpiceDoc->GetFirstViewPosition();

	TCSuperSpiceView *PCViewInList;

	PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

	if(!PCViewInList) return NULL;

	return PCViewInList;
}

void TCSuperSpiceDoc::OnViewAccendSchematic(CView *PCView) 
{
	PCView;

	if(CParentFileName == "") return;

	if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.open_subcurcuits_in_new_window)
	{
		//setfocus to parent
	}
	else
	{
//		OnCloseDocument();

		//open parent
	}

}

void TCSuperSpiceDoc::OnViewDisplayOutputText(CView *PCView)
{
	PCView;
	//out for subcircuit makes no sense
	GetTopLevelDoc()->DisplayTextBasedDocument(CMSuperSpiceDocData.CMasterOutputTextFileName);
}

void TCSuperSpiceDoc::OnViewDisplayModelsText(CView *PCView)
{
	PCView;
	DisplayTextBasedDocument(CMSuperSpiceDocData.CMasterModelFileName);
}

void TCSuperSpiceDoc::OnViewDisplayInputText(CView *PCView)
{
	PCView;
	
	CString CText, CFileName;

	if(CParentRefDes != "")
	{
		if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
		{
			CArray <CString, CString&>	CDummyList;
			CString CDummyText;

			CText = ExtractFileName(CMSuperSpiceDocData.CMasterNetListFileName);

			CText = RemoveExtention(CText);

			CText = CText + '%' + CParentRefDes;

			CText.Replace(":", "%");

			CText += ".cir";

			CFileName = ExtractPathName(CMSuperSpiceDocData.CMasterNetListFileName);

			CFileName += CText;

			// ensure in the list
			CDocumentWindowsList.Create(CFileName, E_NETLIST_DOCUMENT, this, CDummyList, CDummyText);

			RegenerateSchematicDocumentsWindowList(false);

			DisplayTextBasedDocument(CFileName);
		}
		else DisplayTextBasedDocument(CMSuperSpiceDocData.CMasterNetListFileName);
	}

	else DisplayTextBasedDocument(CMSuperSpiceDocData.CMasterNetListFileName);
}

void TCSuperSpiceDoc::OnViewDisplayPCBNetlist(CView *PCView)
{
	PCView;
	CString CText;

	CText = RemoveExtention(CMSuperSpiceDocData.CMasterNetListFileName);

	CText += ".net";

	DisplayTextBasedDocument(CText);
}

void TCSuperSpiceDoc::OnViewDisplaySubcktNetlist(CView *PCView)
{
	PCView;
	CString CText;

	CText = RemoveExtention(CMSuperSpiceDocData.CMasterNetListFileName);

	CText += ".mod";

	DisplayTextBasedDocument(CText);
}

void TCSuperSpiceDoc::OnViewDisplayOutputGraph(CView *PCView)
{
	PCView;
	//out graph for subcircuit makes no sense
	GetTopLevelDoc()->DisplayOutputGraphics(CMSuperSpiceDocData.CMasterOutputWaveform);
}

TCSuperSpiceTextDoc  *TCSuperSpiceDoc::OnViewDisplayDesignNotes(CView *PCView)
{
	PCView;
	CString CText;
	TCSuperSpiceTextDoc  *PCDoc = NULL;

	if(!FileExists(CMSuperSpiceDocData.CMasterTextNotes))
	{
		CreateNullFile(CMSuperSpiceDocData.CMasterTextNotes);

		PCDoc = DisplayTextBasedDocument(CMSuperSpiceDocData.CMasterTextNotes);
	
		// will add timestamp logging function as in notepad
//		CText.Format(".LOG", CMSuperSpiceDocData.CMasterTextNotes);
		
//		PCDoc->SetText(CText);

//		PCDoc->DoSave(CMSuperSpiceDocData.CMasterTextNotes, true);
	}
	else
	{
		PCDoc = DisplayTextBasedDocument(CMSuperSpiceDocData.CMasterTextNotes);

		if(!PCDoc) return NULL;
	}

	return PCDoc;
}

TCSymbolEditorDoc  *TCSuperSpiceDoc::OnViewDisplaySymbolEditor(CView *PCView)
{
	PCView;

	return (TCSymbolEditorDoc *) DisplaySymbolEditorDocument(CMSuperSpiceDocData.CMasterSymbolEditor);
}

TCSuperSpiceTextDoc  *TCSuperSpiceDoc::OnViewDisplayIncludeText(CView *PCView)
{
	PCView;
	CString CText;
	TCSuperSpiceTextDoc  *PCDoc = NULL;

	if(!FileExists(CMSuperSpiceDocData.CMasterIncludeFileName))
	{
		CreateNullFile(CMSuperSpiceDocData.CMasterIncludeFileName);

		PCDoc = DisplayTextBasedDocument(CMSuperSpiceDocData.CMasterIncludeFileName);

		if(!PCDoc) return NULL;

		CText.Format("*** %s, You may add additional spice statements in this file ***", CMSuperSpiceDocData.CMasterIncludeFileName);
		
		PCDoc->SetText(CText);

		PCDoc->DoSave(CMSuperSpiceDocData.CMasterIncludeFileName, true);
	}
	else
	{
		PCDoc = DisplayTextBasedDocument(CMSuperSpiceDocData.CMasterIncludeFileName);

		if(!PCDoc) return NULL;
	}

	return PCDoc;
}

TCSuperSpiceTextDoc  *TCSuperSpiceDoc::OnViewDisplaySpiceErrorLog(CView *PCView) 
{
	PCView;
	CString CText;
	TCSuperSpiceTextDoc  *PCDoc = NULL;

	if(!FileExists(CMSuperSpiceDocData.CMasterSpiceEngineLogFileName))
	{
		AfxMessageBox(IDS_FILE_NOT_EXISTS);

		if(!PCDoc) return NULL;
	}
	else
	{

		CFile CDataFile;// force the framework to open in read only status

		if(!CDataFile.Open(CMSuperSpiceDocData.CMasterSpiceEngineLogFileName, CFile::modeRead | CFile::shareDenyNone)) return false;

		PCDoc = DisplayTextBasedDocument(CMSuperSpiceDocData.CMasterSpiceEngineLogFileName);

		CDataFile.Close();

		if(!PCDoc) return NULL;
	}

	return PCDoc;
}


CDocument * TCSuperSpiceDoc::DisplayFile(CMultiDocTemplate *PCMultiDocTemplate, CDocument *CDoc, CString CFileName)
{
	CFile CDataFile;

	if(!CDoc)
	{
		// If no file make one, this is to give more user friendly feedback
		if(!CDataFile.Open(CFileName, CFile::modeRead))
		{
			if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite))
			{
				AfxGetMainWnd()->MessageBox("Unable to create file");
				return NULL;
			}
		}
		CDataFile.Close();

		CDoc = PCMultiDocTemplate->OpenDocumentFile(CFileName);

		return CDoc;
	}

	ActivateADocumentView(CDoc);

	return CDoc;
}

bool TCSuperSpiceDoc::LoadWorkspace(void)
{
	// This is messy, will be changed later, data is stored in wrong place
	CString CText = ReplaceFileExtension(CMSuperSpiceDocData.CMasterWorkspaceFileName, "sws");

	//no way of disbling subckts from trying to load a data file without over riding global
	int load_last_output_data = GCSuperSpiceGlobalData.CProgramOptions.CGeneral.load_last_output_data;

	GCSuperSpiceGlobalData.CProgramOptions.CGeneral.load_last_output_data = false;

	if(!LoadGenericFromArchive(&CDocumentWindowsList, CText)) 
	{
		GCSuperSpiceGlobalData.CProgramOptions.CGeneral.load_last_output_data = load_last_output_data;

		return false;
	}

	GCSuperSpiceGlobalData.CProgramOptions.CGeneral.load_last_output_data = load_last_output_data;

	CDocumentWindowsList.Restore(this);

	int count = CDocumentWindowsList.CDocList.GetSize();

	TCSuperSpiceTextDoc *PCSuperSpiceTextDoc;
	TCSuperSpiceDoc		*PCSuperSpiceDoc;
	TCOutputWaveformDoc *PCOutputWaveformDoc;
	TCSymbolEditorDoc* PCSymbolEditorDoc;
	

	// This could be simpler if all superspice documents were derived from an intermediate document to CDocument
	for(int p = 0; p < count; p++)
	{
		PCSuperSpiceTextDoc = (TCSuperSpiceTextDoc *) CDocumentWindowsList.CDocList[p].PCDoc;
		PCSuperSpiceDoc = (TCSuperSpiceDoc *) PCSuperSpiceTextDoc;
		PCOutputWaveformDoc = (TCOutputWaveformDoc *) PCSuperSpiceDoc;
		PCSymbolEditorDoc = (TCSymbolEditorDoc*) PCSuperSpiceDoc;

		if(!PCSuperSpiceTextDoc) continue;

		switch(CDocumentWindowsList.CDocList[p].type)
		{
			case E_GENERIC_TEXT:			PCSuperSpiceTextDoc->PCParentSuperSpiceDoc = this; break;
			case E_SCHEMATIC_DOCUMENT:		PCSuperSpiceDoc->SetParent(this, CThisFileName, CDocumentWindowsList.CDocList[p].CParentRefIDList, CDocumentWindowsList.CDocList[p].CParentRefDes); 
											PCSuperSpiceDoc->UpdateAllViews(NULL, NULL);break;
											
			case E_NETLIST_DOCUMENT:		PCSuperSpiceTextDoc->PCParentSuperSpiceDoc = this; break;
			case E_OUTPUT_TEXT_DOCUMENT:	PCSuperSpiceTextDoc->PCParentSuperSpiceDoc = this; break;
			case E_WAVEFORM_DOCUMENT:		PCOutputWaveformDoc->PCParentSuperSpiceDoc = this;
											PCOutputWaveformDoc->UpdateAllViews(NULL, NULL);
											if(GetTopLevelDoc() != this) CGlobalStatusMessage = "SS Warning: Waveform Doc not top level";
											break;
			case E_SYMBOL_DOCUMENT:			PCSymbolEditorDoc->PCParentSuperSpiceDoc = this;break;
			case E_SPICE_LIBARY_DOCUMENT:	PCSuperSpiceTextDoc->PCParentSuperSpiceDoc = this; break;

			case E_SPICE_MODEL_DOCUMENT:	PCSuperSpiceTextDoc->PCParentSuperSpiceDoc = this; break;

			case E_SPICE_ENGINE_LOG_DOCUMENT: PCSuperSpiceTextDoc->PCParentSuperSpiceDoc = this;

			default:  break;
		}
	}

	return true;
}

bool TCSuperSpiceDoc::SaveWorkspace(void)
{
	CMCreateSymbolFromSchematicData.Save();

	if(FileExists(CMSuperSpiceDocData.CMasterOutputDataFileName))
			CMSuperSpiceDocData.CWaveformDataRuns.Save(CMSuperSpiceDocData.CMasterOutputDataFileName, (CMSuperSpiceDocData.PCAnalysisSetup->CReRun.enable == E_RERUN_SWEEP_TYPE_WC_RERUN_FILE));

	// This is messy, will be changed later, data is stored in wrong place
	if(CMSuperSpiceDocData.CMasterWorkspaceFileName == "") 
	{
		CGlobalStatusMessage = "Warning, no workspace to save";
		return false;
	}

	CString CText = ReplaceFileExtension(CMSuperSpiceDocData.CMasterWorkspaceFileName, "sws");

	return SaveGenericToArchive(&CDocumentWindowsList, CText);
}

void TCSuperSpiceDoc::SetFileNames(CString CPathAndName)
{
	CThisFileName = CPathAndName;
	CString CText;

	CArray <CString, CString&>	CDummyList;
	CString CDummyText;

//	CDocumentWindowsList.Create(CPathAndName, E_SCHEMATIC_DOCUMENT, this, CDummyList, CDummyText);

	CString CFileNameNoExt = RemoveExtention(CPathAndName);

	h_msg = RegisterWindowMessage(CSuperSpiceXSpiceMessage + CFileNameNoExt);

	CMSuperSpiceDocData.CMasterTextNotes = CFileNameNoExt + "Notes.txt";
	CDocumentWindowsList.Create(CMSuperSpiceDocData.CMasterTextNotes, E_GENERIC_TEXT, this, CDummyList, CDummyText);

	CMSuperSpiceDocData.CMasterOutputTextFileName = CFileNameNoExt + ".out";
	CDocumentWindowsList.Create(CMSuperSpiceDocData.CMasterOutputTextFileName, E_OUTPUT_TEXT_DOCUMENT, this, CDummyList, CDummyText);

	CMSuperSpiceDocData.CMasterNetListFileName = CFileNameNoExt + ".cir";
	CDocumentWindowsList.Create(CMSuperSpiceDocData.CMasterNetListFileName, E_NETLIST_DOCUMENT, this, CDummyList, CDummyText);

	CText = CFileNameNoExt + ".net";
	CDocumentWindowsList.Create(CText, E_GENERIC_TEXT, this, CDummyList, CDummyText);

	CMSuperSpiceDocData.PCAnalysisSetup->CFileName = CPathAndName;
	CMSuperSpiceDocData.PCAnalysisSetup->CSchematicName = CPathAndName;

	CMSuperSpiceDocData.CMasterIncludeFileName = CFileNameNoExt + ".lib";
	CDocumentWindowsList.Create(CMSuperSpiceDocData.CMasterIncludeFileName, E_SPICE_LIBARY_DOCUMENT, this, CDummyList, CDummyText);

	CMSuperSpiceDocData.CMasterSpiceEngineLogFileName = CFileNameNoExt + ".log";
	CDocumentWindowsList.Create(CMSuperSpiceDocData.CMasterSpiceEngineLogFileName, E_SPICE_ENGINE_LOG_DOCUMENT, this, CDummyList, CDummyText);

	//20th feb 2002
	CMSuperSpiceDocData.CMasterWorkspaceFileName = CFileNameNoExt + "ProjectWorkspace.sws";

	CMSuperSpiceDocData.CMasterOutputWaveform = CFileNameNoExt + "Graph.ssg";
	CDocumentWindowsList.Create(CMSuperSpiceDocData.CMasterOutputWaveform, E_WAVEFORM_DOCUMENT, this, CDummyList, CDummyText);

	if(!FileExists(CMSuperSpiceDocData.CMasterOutputWaveform))// create default graphic output
	{
		CreateOutputWaveformFile(CMSuperSpiceDocData.CMasterOutputWaveform);
	}
	
	CDocumentWindowsList.Create(CMSuperSpiceDocData.CMasterSymbolEditor, E_SYMBOL_DOCUMENT, this, CDummyList, CDummyText);

	CMSuperSpiceDocData.CMasterOutputDataFileName = ReplaceFileExtension(CPathAndName, "out");

	CString CTemp;

	CTemp = RemoveExtention(CPathAndName);

	CMSuperSpiceDocData.CMasterModelFileName = CTemp + "Models" + ".lib";
	
	CDocumentWindowsList.Create(CMSuperSpiceDocData.CMasterModelFileName, E_SPICE_LIBARY_DOCUMENT, this, CDummyList, CDummyText);

	CMSuperSpiceDocData.PCAnalysisSetup->CFileName = CMSuperSpiceDocData.CMasterNetListFileName;
	CMSuperSpiceDocData.PCAnalysisSetup->CIncludeNameList.SetAtGrow(0, CMSuperSpiceDocData.CMasterIncludeFileName);
	CMSuperSpiceDocData.PCAnalysisSetup->CIncludeNameList.SetAtGrow(1, CMSuperSpiceDocData.CMasterModelFileName);

	CMSchematicPageDataDefault.CFileName = CPathAndName;
}

bool TCSuperSpiceDoc::AddSymbolEditorDoc(CDocument *PCDoc, CString CFileName)
{
	CArray <CString, CString&>	CDummyList;
	CString CDummyText;

	CDocumentWindowsList.Create(CFileName, E_SYMBOL_DOCUMENT, this, CDummyList, CDummyText, PCDoc);

	RegenerateSchematicDocumentsWindowList(false);

	return true;
}

bool TCSuperSpiceDoc::AddGraphOutputDoc(CDocument *PCDoc, CString CFileName)
{
	CArray <CString, CString&>	CDummyList;
	CString CDummyText;

	CDocumentWindowsList.Create(CFileName, E_WAVEFORM_DOCUMENT, this, CDummyList, CDummyText, PCDoc);

	RegenerateSchematicDocumentsWindowList(false);

	return true;
}

bool TCSuperSpiceDoc::AddModelLibaryDoc(CDocument *PCDoc, CString CFileName)
{
	CArray <CString, CString&>	CDummyList;
	CString CDummyText;

	CDocumentWindowsList.Create(CFileName, E_SPICE_LIBARY_DOCUMENT, this, CDummyList, CDummyText, PCDoc);

	RegenerateSchematicDocumentsWindowList(false);

	return true;
}

void TCSuperSpiceDoc::SetWindowTitle(CMDIChildWnd *PCChildWnd)// Called only after already called by the framework
{
	CString CPageTitle;
	CString CAppend;

	if(!PCChildWnd) return;

	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCChildWnd->GetActiveView(); 

	if(!PCSuperSpiceView) return;

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();

	if(!PCSchematicManager) return;

	TCSchematicPageData CPageData;

	CPageData = PCSchematicManager->GetPageData();

	CPageTitle = CPageData.CPageTitle;

	int page_number = CPageData.page_number;

	CAppend.Format(" %s %d", CPageTitle, page_number);

	if(PCParentSuperSpiceDoc) CAppend += " (Subcircuit Schematic)";
	else CAppend += " (Top Level Schematic)";

	if(IsModified()) CAppend += "*";

	if(CParentRefDes != "")
	{
		CAppend += " - " + CParentRefDes;
	}

	::SetWindowTitle(PCChildWnd, CAppend);

}

void TCSuperSpiceDoc::PutBackReferanceDesignatorsInClipboard(void)
{
	TCSchematicManager *PCSchematicManager = GCSuperSpiceClipboard.GetSchematicManager();

	if(!PCSchematicManager)return;

	CArray<TCSchematicObject*, TCSchematicObject*> &GraphicList = 
	PCSchematicManager->GetGraphicList();

	CString CText;
	int type;

	int count = GraphicList.GetSize();

	for(int p = 0; p < count; p++)
	{
		type = GraphicList[p]->GetType();

		PutBackReferanceDesignator(type);
	}
}

void TCSuperSpiceDoc::PutNewReferanceDesignatorsInClipboard(TCSchematicManager *PCDocSchematicManager)
{
	TCSchematicManager *PCSchematicManager = GCSuperSpiceClipboard.GetSchematicManager();

	PCDocSchematicManager;

	if(!PCSchematicManager)return;

	CArray<TCSchematicObject*, TCSchematicObject*> &GraphicList = 
	PCSchematicManager->GetGraphicList();

	CString CText;
	int type;

	CDC CDCTemp;

	if(!CDCTemp.CreateCompatibleDC(NULL)) return;

	int count = GraphicList.GetSize();

	for(int p = 0; p < count; p++)
	{
		type = GraphicList[p]->GetType();

		CText = GetNewReferanceDesignator(GraphicList[p]->CMSchematicObjectData);

		if(CText != "") GraphicList[p]->SetLabel(&CDCTemp, E_COMPONENT_DESIGNATOR, CText);

		if(type == E_WAVEFORM_COMPONENT)  GraphicList[p]->SetLabel(&CDCTemp, E_WAVEFORM_ENABLE, "Inactive");
		else if(type == E_SUBCIRCUIT_PIN_CONNECTER)
		{
			PCSchematicManager->SetLabel(p, E_COMPONENT_VALUE, "#");
		}
	}
}

void TCSuperSpiceDoc::PutBackReferanceDesignator(int id)
{
	if(id < 0) return;
return;
/*
	if(!(id < CConvertIdToRefId.GetSize()))
	{
		ASSERT(0);

		return;
	}

	id = CConvertIdToRefId[id];

	if(id > -1)
	{
		if(CMSuperSpiceDocData.CRefId[id] < 1)
		{
			ASSERT(0);

			return;
		}
		--CMSuperSpiceDocData.CRefId[id];
	}*/
}

CString TCSuperSpiceDoc::GetNewReferanceDesignator(TCSchematicObjectData &CSchematicObjectData)
{
	//internal symbol, type is directly got
	if(CSchematicObjectData.type) return GetNewReferanceDesignator(CSchematicObjectData.type);

	// sources code in version parameter
	if(CSchematicObjectData.attached_model_type == E_SPICE_GENERATOR) 
	{
		CString CText;

		CText = GetNewReferanceDesignator(CSchematicObjectData.version);

		if(CText == "") DisplayError(IDS_ERR_ERROR, IDS_NOSRC_FOR_SYMBOL);
		
		return CText;
	}
		
	if(CSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC || 
	   CSchematicObjectData.attached_model_type == E_SPICE_DOT_SUBCIRCUIT)

			return GetNewReferanceDesignator(0);// will return X subcircuit types

	// extract the internal graphic id that is asssociated with the .model [spice type]
	// returns 0 if no model attached.

	int id = GCSuperSpiceDataBase.GetGraphicTypeFromModelType(CSchematicObjectData);

	return GetNewReferanceDesignator(id);
}

CString TCSuperSpiceDoc::GetNewReferanceDesignator(int id)
{
	if(id < 0) return "";

	if(!(id < CConvertIdToRefId.GetSize()))
	{
		ASSERT(0);

		return "";
	}

	CString CText, CRefText;

	CRefText = GCSuperSpiceDataBase.CReferanceDesignator[id];

	id = CConvertIdToRefId[id];

	if(id < 0)
	{
		return "";
	}

	if(!(id < CMSuperSpiceDocData.CRefId.GetSize()))
	{
		ASSERT(0);

		return "?";
	}

	int n = ++CMSuperSpiceDocData.CRefId[id];

	CText.Format("%s%d", CRefText, n);
	
	return CText;
}

void TCSuperSpiceDoc::PlaceSymbolFromSymbol(CView *PCView, int symbol_file_index, int symbol_index, int graphic_type)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSuperSpiceView *PCViewInList = NULL;
	int id;
	CString CText;

	PCSuperSpiceView->OnCancelCommand();

	int page_id			= PCSuperSpiceView->GetPageId();

	CPoint CMousePosition = GlobalMousePosition;

	TCSchematicObjectData	CSchematicObjectData;

	if(!graphic_type) // indexs valid
	{
		CArray <TCSymbolDataBaseData, TCSymbolDataBaseData &> &CFiles = GCSuperSpiceDataBase.CSymbolDataBase.CFileList;

		CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList= CFiles[symbol_file_index].CSymbolList;

		CSchematicObjectData = CSymbolList[symbol_index];
	}

	CString CFileName = CSchematicObjectData.CSymbolData.CChildFileName;

	CFileName.MakeLower();

	CString CLocalFileName = GetPathName();

	CLocalFileName.MakeLower();

	if(CLocalFileName == CFileName && CFileName != "") 
	{
		AfxMessageBox(IDS_RECUSIVE_SYMBOL);

		return;
	}

	// added to resync labels
	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel =  CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName;

	// this was needed for things like semi resistors for FormatLabels(); to work
//	TCSpiceParameters *PCSpiceParameters = GCSuperSpiceDataBase.GetModelPointer(CSchematicObjectData.CSpiceParameters);

//	if(PCSpiceParameters) CSchematicObjectData.CSpiceParameters = *PCSpiceParameters;

	CSchematicObjectData.FormatLabels();

	short version = 0;

	if(!graphic_type)
	{
		CText = GetNewReferanceDesignator(CSchematicObjectData);

		version = CSchematicObjectData.version;
	}
	else 
	{
		CText = GetNewReferanceDesignator(graphic_type);
	}

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCViewInList->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->IdleStateGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);

		if(system_state == E_GRAPHICS_MANAGER_STATE_IDLE)return;

		id = PCSchematicManager->GetLastCreatedId();

		if(id < 0) continue;

		if(CText != "")
			PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);

		if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");

	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	RegenerateSchematicDocumentsWindowList(false);
	SetModifiedFlag(TRUE);
	SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());

	return; 
}

bool TCSuperSpiceDoc::DisplayComponentLibaryDlg(TCSchematicObjectData &CSchematicObjectData)
{
	TCComponentDataBaseData CComponentDataBaseData;

	TCMasterSymbolDlg CComponentLibaryDlg;
		
	CComponentLibaryDlg.DoModal();

	if(CComponentLibaryDlg.button_pressed == E_LIB_CANCEL) return false;

	CComponentDataBaseData = CComponentLibaryDlg.CComponentDataBaseData;

	CComponentDataBaseData.use_index = false;// search for the model attached to the symbol from name

	if(!GCSuperSpiceDataBase.GetComponent(CComponentDataBaseData, CSchematicObjectData))
	{
		AfxMessageBox(IDS_NO_DB_SYMBOL);

		return false;
	}

	if(!CSchematicObjectData.CSymbolData.CData.GetSize())
	{
		AfxMessageBox(IDS_UNABLETO_PLACE_SYM);

		return false;
	}

	CString CText = CSchematicObjectData.CSymbolData.CChildFileName;

	TCSuperSpiceDoc *PCSuperSpiceDoc = NULL;

	if(CComponentLibaryDlg.button_pressed == E_LIB_OPEN_SCHEMATIC)
	{
		if(!FileExists(CText))
		{
			if(AfxMessageBox(IDS_CREATE_NEW_SCH, MB_YESNO) == IDNO) return false;

			PCSuperSpiceDoc = CreateNewChildSchematicDocument(CText);
		
			if(!PCSuperSpiceDoc) return false;

			PCSuperSpiceDoc->CreateChildSchematicPins(CSchematicObjectData);
	
			PCSuperSpiceDoc->DoSave(CText, true);
		}
		else DisplayChildSchematicDocument(CText, "");


		return false;// dont place component
	}

	GCSuperSpiceDataBase.CheckAndCorrectSymbolData(CSchematicObjectData);

	return ValidateComponent(CText);
}

CString TCSuperSpiceDoc::SaveAsSchematicDlg(CString CText)
{
	CString CFileName;

	CFileDialog	CLoadFileDialog(false, ".sss", CText, 0,"Schematic Files  (*.sss)| *.sss||");

	if(CLoadFileDialog.DoModal() != IDOK) 
	{
		CFileName = CLoadFileDialog.GetPathName();

		return "";
	}

	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return CFileName;

	CMSchematicPageDataDefault.CFileName = CFileName;

	return CFileName;
}

bool TCSuperSpiceDoc::ValidateComponent(CString CName)
{
	CString CTemp = ExtractFileName(CParentFileName);

	if(CName == "") return true;

	CTemp = RemoveExtention(CTemp);
	CName = RemoveExtention(CName);

	CName.MakeUpper();
	CTemp.MakeUpper();

	if(CName == CTemp)
	{
		AfxMessageBox(IDS_RECUSIVE_SYMBOL);

		return false;
	}

	CTemp = RemoveExtention(CThisFileName);
	CTemp.MakeUpper();

	if(CName == CTemp)
	{
		AfxMessageBox(IDS_RECUSIVE_SYMBOL);

		return false;
	}

	return true;
}
/////////////////////////////////

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewSizingWaveformWindowMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->SizingWaveformWindowMouseMoved(nFlags, CScaledPoint);	
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewSizingWaveformWindowLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->SizingWaveformWindowLBUp(nFlags, CScaledPoint);	
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state;
}



TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewSizingWaveformWindowLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->SizingWaveformWindowLBDown(nFlags, CScaledPoint);	
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewIdleStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSuperSpiceView *PCViewInList = NULL;
	int id;
	CString CText;

	TCSchematicObjectData CSchematicObjectData;

	if(!graphic_type)
	{
		if(!DisplayComponentLibaryDlg(CSchematicObjectData)) return E_GRAPHICS_MANAGER_STATE_IDLE;

		version = CSchematicObjectData.version;

		CText = GetNewReferanceDesignator(CSchematicObjectData);
	}
	else
	{
		CText = GetNewReferanceDesignator(graphic_type);
	}

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCViewInList->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->IdleStateGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);

		if(system_state == E_GRAPHICS_MANAGER_STATE_IDLE)return system_state;

		id = PCSchematicManager->GetLastCreatedId();

		if(id < 0) continue;

		if(CText != "")
			PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);

		GetAndSetSubCktID(PCSchematicManager, PCSchematicManager->PCMLastCreatedGraphic);

		if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");

	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	RegenerateSchematicDocumentsWindowList(false);
	SetModifiedFlag(TRUE);
	SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGraphicsSelectedStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList = NULL;
	int id;

	TCSchematicObjectData CSchematicObjectData;

	CString CText;

	if(!graphic_type)
	{
		if(!DisplayComponentLibaryDlg(CSchematicObjectData)) return E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED;

		CText = GetNewReferanceDesignator(CSchematicObjectData);
	}
	else
	{
		CText = GetNewReferanceDesignator(graphic_type);
	}

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->GraphicsSelectedStateGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);
		
		if(system_state == E_GRAPHICS_MANAGER_STATE_IDLE)return system_state;

		id = PCSchematicManager->GetLastCreatedId();

		if(id < 0) continue;

		if(CText != "")
			PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);

		if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");

	}
	
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	RegenerateSchematicDocumentsWindowList(false);
	SetModifiedFlag(TRUE);
	SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());	
	
	return system_state; 
}



TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGraphicsMovingStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	int id;
	TCSuperSpiceView *PCViewInList = NULL;

	TCSchematicObjectData CSchematicObjectData;

	CString CText;

	if(!graphic_type)
	{
		if(!DisplayComponentLibaryDlg(CSchematicObjectData)) return E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING;

		CText = GetNewReferanceDesignator(CSchematicObjectData);
	}
	else
	{
		CText = GetNewReferanceDesignator(graphic_type);
	}

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->GraphicsMovingStateGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);
		
		if(system_state == E_GRAPHICS_MANAGER_STATE_IDLE)return system_state;

		id = PCSchematicManager->GetLastCreatedId();;

		if(id < 0) continue;

		if(CText != "")
			PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);
	
		if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	RegenerateSchematicDocumentsWindowList(false);
	SetModifiedFlag(TRUE);
	SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());

	return system_state; 	
}
	
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewSelectRegionStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	int id;
	TCSuperSpiceView *PCViewInList = NULL;

	TCSchematicObjectData CSchematicObjectData;

	CString CText;

	if(!graphic_type)
	{
		if(!DisplayComponentLibaryDlg(CSchematicObjectData)) return E_GRAPHICS_MANAGER_STATE_SELECT_REGION;

		CText = GetNewReferanceDesignator(CSchematicObjectData);
	}
	else
	{
		CText = GetNewReferanceDesignator(graphic_type);
	}

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom); // normalize offset
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); // normalize mouse position

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->SelectRegionStateGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);
		
		if(system_state == E_GRAPHICS_MANAGER_STATE_IDLE)return system_state;

		id = PCSchematicManager->GetLastCreatedId();

		if(id < 0) continue;

		if(CText != "")
			PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);

		if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");

	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	RegenerateSchematicDocumentsWindowList(false);
	SetModifiedFlag(TRUE);
	SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());

	return system_state; 
}
		 
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGotGraphicStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	int id;
	TCSuperSpiceView *PCViewInList;

	TCSchematicObjectData CSchematicObjectData;

	CString CText;

	if(!graphic_type)
	{
		if(!DisplayComponentLibaryDlg(CSchematicObjectData)) return E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC;

		CText = GetNewReferanceDesignator(CSchematicObjectData);
	}
	else
	{
		CText = GetNewReferanceDesignator(graphic_type);
	}

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->GotGraphicStateGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);
	
		if(system_state == E_GRAPHICS_MANAGER_STATE_IDLE)return system_state;

		id = PCSchematicManager->GetLastCreatedId();;

		if(id < 0) continue;

		if(CText != "")
			PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);

		if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");
	}  
		
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	RegenerateSchematicDocumentsWindowList(false);
	return system_state; 	
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewDrawingWireGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	int id;
	CString CText;

	TCSchematicObjectData CSchematicObjectData;

	if(!graphic_type)
	{
		if(!DisplayComponentLibaryDlg(CSchematicObjectData)) return E_GRAPHICS_MANAGER_STATE_IDLE;

		CText = GetNewReferanceDesignator(CSchematicObjectData);
	}
	else
	{
		CText = GetNewReferanceDesignator(graphic_type);
	}

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->DrawingWireGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);
	
		if(system_state == E_GRAPHICS_MANAGER_STATE_IDLE)return system_state;

		id = PCSchematicManager->GetLastCreatedId();

		if(id < 0) continue;

		if(CText != "")
			PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);

		if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");
	}  
		
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	RegenerateSchematicDocumentsWindowList(false);
	return system_state; 	
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewWaitingToDrawWireGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	int id;
	CString CText;

	TCSchematicObjectData CSchematicObjectData;

	if(!graphic_type)
	{
		if(!DisplayComponentLibaryDlg(CSchematicObjectData)) return E_GRAPHICS_MANAGER_STATE_IDLE;

		CText = GetNewReferanceDesignator(CSchematicObjectData);
	}
	else
	{
		CText = GetNewReferanceDesignator(graphic_type);
	}

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 


	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->WaitingToDrawWireGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);
	
		if(system_state == E_GRAPHICS_MANAGER_STATE_IDLE)return system_state;

		id = PCSchematicManager->GetLastCreatedId();

		if(id < 0) continue;

		if(CText != "")
			PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);

		if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");

	}  
		
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{

		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	RegenerateSchematicDocumentsWindowList(false);
	return system_state; 	
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGotClipboardGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSuperSpiceView *PCViewInList = 0;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	int id;
	CString CText;

	TCSchematicObjectData CSchematicObjectData;

	if(!graphic_type)
	{
		if(!DisplayComponentLibaryDlg(CSchematicObjectData)) return E_GRAPHICS_MANAGER_STATE_IDLE;

		CText = GetNewReferanceDesignator(CSchematicObjectData);
	}
	else
	{
		CText = GetNewReferanceDesignator(graphic_type);
	}

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->GotClipboardGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);

		if(system_state == E_GRAPHICS_MANAGER_STATE_IDLE)return system_state;

		id = PCSchematicManager->GetLastCreatedId();

		if(id < 0) continue;

		if(CText != "")
			PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);

		if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	RegenerateSchematicDocumentsWindowList(false);
	SetModifiedFlag(TRUE);
	SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());

	return system_state; 
}


TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewIdleDrawWire(CView *PCView, int page_id, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSuperSpiceView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		if(PCViewInList == PCView) system_state = PCSchematicManager->IdleDrawWire(CScaledPoint);

		else PCSchematicManager->IdleDrawWire(CScaledPoint);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	SetModifiedFlag(TRUE);
	SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());
	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGraphicsSelectedDrawWire(CView *PCView, int page_id, CPoint CMousePosition)
{
		TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSuperSpiceView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		float that_zoom = PCSchematicManager->GetZoom();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		if(PCViewInList == PCView) system_state = PCSchematicManager->GraphicsSelectedDrawWire(CScaledPoint);

		else PCSchematicManager->GraphicsSelectedDrawWire(CScaledPoint);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	SetModifiedFlag(TRUE);
	SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());
	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGraphicsMovingDrawWire(CView *PCView, int page_id, CPoint CMousePosition)
{	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSuperSpiceView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		if(PCViewInList == PCView) system_state = PCSchematicManager->GraphicsMovingDrawWire(CScaledPoint);

		else PCSchematicManager->GraphicsMovingDrawWire(CScaledPoint);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	SetModifiedFlag(TRUE);
	SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());
	return system_state; 
}
	
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewSelectRegionDrawWire(CView *PCView, int page_id, CPoint CMousePosition)
{	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSuperSpiceView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom); // normalize offset
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); // normalize mouse position

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		if(PCViewInList == PCView) system_state = PCSchematicManager->SelectRegionDrawWire(CScaledPoint);

		else PCSchematicManager->SelectRegionDrawWire(CScaledPoint);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	SetModifiedFlag(TRUE);
	SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());
	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGotGraphicDrawWire(CView *PCView, int page_id, CPoint CMousePosition)
{	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSuperSpiceView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		if(PCViewInList == PCView) system_state = PCSchematicManager->GotGraphicDrawWire(CScaledPoint);

		else PCSchematicManager->GotGraphicDrawWire(CScaledPoint);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	SetModifiedFlag(TRUE);
	SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());
	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGotClipboardDrawWire(CView *PCView, int page_id, CPoint CMousePosition)
{	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSuperSpiceView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 


	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		if(PCViewInList == PCView) system_state = PCSchematicManager->GotClipboardDrawWire(CScaledPoint);

		else PCSchematicManager->GotClipboardDrawWire(CScaledPoint);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}
 
	SetModifiedFlag(TRUE);
	SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());
	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewDrawingWireDrawWire(CView *PCView, int page_id, CPoint CMousePosition)
{	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSuperSpiceView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		if(PCViewInList == PCView) system_state = PCSchematicManager->DrawingWireDrawWire(CScaledPoint);

		else PCSchematicManager->DrawingWireDrawWire(CScaledPoint);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	SetModifiedFlag(TRUE);
	SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());
	return system_state; 
}


TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewIdleStateLBDown(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	TCTestPointData CTestPointData;

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		PCSchematicManager->CTestPointData.clear_waveforms = false;

		system_state = PCSchematicManager->IdleStateLBDown(mouse_flags, CScaledPoint);

		if(PCSchematicManager->CTestPointData.update_graph_views) 
		{
			CTestPointData = PCSchematicManager->CTestPointData;
		}
	}  

	if(CTestPointData.update_graph_views) 
	{
		if(mouse_flags & MK_SHIFT)// shift deletes, non-shift adds
		{
			GetTopLevelDoc()->ChangeGraphWaveform(CTestPointData);
		}

		else if(mouse_flags & MK_ALT)
		{
			GetTopLevelDoc()->ChangeGraphWaveform(CTestPointData);
		}
	}

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCSchematicManager->CTestPointData.update_graph_views = false;

		PCViewInList->SetState(system_state);
	}

	return system_state; 	
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewWaveformOnClickLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	TCTestPointData CTestPointData;

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->WaveformOnClickStateLBDown(nFlags, CScaledPoint);
	
		if(PCSchematicManager->CTestPointData.update_graph_views) 
		{
			CTestPointData = PCSchematicManager->CTestPointData;
		}
	}  

	if(CTestPointData.update_graph_views) GetTopLevelDoc()->ChangeGraphWaveform(CTestPointData);

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id) continue;

		PCSchematicManager->CTestPointData.update_graph_views = false;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGraphicsSelectedStateLBDown(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	TCTestPointData CTestPointData;

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->GraphicsSelectedStateLBDown(mouse_flags, CScaledPoint);
	
		if(PCSchematicManager->CTestPointData.update_graph_views) 
		{
			CTestPointData = PCSchematicManager->CTestPointData;
		}
	}  
		
	if(CTestPointData.update_graph_views) 
	{
		if(mouse_flags & MK_SHIFT)// shift deletes, non-shift adds
		{
			GetTopLevelDoc()->ChangeGraphWaveform(CTestPointData);
		}

		else if(mouse_flags & MK_ALT)
		{
			GetTopLevelDoc()->ChangeGraphWaveform(CTestPointData);
		}
	}

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCSchematicManager->CTestPointData.update_graph_views = false;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGraphicsMovingStateLBDown(CView *PCView,  int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->GraphicsMovingStateLBDown(mouse_flags, CScaledPoint);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewSelectRegionStateLBDown(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom); // normalize offset
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); // normalize mouse position

	TCSuperSpiceView *PCViewInList;

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->SelectRegionStateLBDown(mouse_flags, CScaledPoint);
	}  
	
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGotGraphicStateLBDown(CView *PCView,  int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	if(!PCSchematicManager) return system_state;

	TCSchematicObject *PCSchematicObject = PCSchematicManager->GetLastCreatedGraphic();

	if(!PCSchematicObject) return system_state;

	int graphic_type = PCSchematicObject->GetType();
	int id;

//	CString CText = GetNewReferanceDesignator(graphic_type);

	CString CText = GetNewReferanceDesignator(PCSchematicObject->CMSchematicObjectData);

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();
	
	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	TCTestPointData CTestPointData;

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->GotGraphicStateLBDown(mouse_flags, CScaledPoint);

		if(!GCSuperSpiceGlobalData.CDrawData.repeat_pasting)
			system_state = OnViewGotGraphicOnCancel(PCViewInList);

		if(PCSchematicManager->CTestPointData.update_graph_views) 
		{
			CTestPointData = PCSchematicManager->CTestPointData;
		}

		id = PCSchematicManager->GetLastCreatedId();

		if(id < 0) continue;

		if(CText != "")
			PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);

		if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");
	}  

	if(CTestPointData.update_graph_views) GetTopLevelDoc()->ChangeGraphWaveform(CTestPointData);

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCSchematicManager->CTestPointData.update_graph_views = false;

		PCViewInList->SetState(system_state);
	}

	RegenerateSchematicDocumentsWindowList(false);
	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGotClipboardLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	PutNewReferanceDesignatorsInClipboard(PCSchematicManager);

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();
	
	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);
		
		system_state = PCSchematicManager->GotClipboardLBDown(nFlags, CScaledPoint);
		
		GCSuperSpiceClipboard.Zoom(that_zoom);

		// this is so pastiing filters does not keep repasting
		if(PCSchematicManager->m_auto_keep_pasting) // keep pasting until canceled
			GCSuperSpiceClipboard.PasteComponents(PCSchematicManager, CScaledPoint, CThisFileName);
		
		else 
		{
			PCSchematicManager->m_auto_keep_pasting = true;

			PCSchematicManager->GraphicsSelectedOnCancel();

			system_state = E_GRAPHICS_MANAGER_STATE_IDLE;
		}

		if(!GCSuperSpiceGlobalData.CDrawData.repeat_pasting)
			system_state = OnViewGotClipboardOnCancel(PCViewInList);

		GCSuperSpiceClipboard.Zoom(that_zoom);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewDrawingWireLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	int id;

	CString CText = GetNewReferanceDesignator(E_WIRE_COMPONENT); 

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();
	
	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->DrawingWireLBDown(nFlags, CScaledPoint);
		
		id = PCSchematicManager->GetLastCreatedId();

		if(id < 0) continue;

		TCSchematicObject *PCSchematicObject = PCSchematicManager->GetLastCreatedGraphic();
		
		if(!PCSchematicObject) continue;

//		PCSchematicManager->SetLabel(id, E_WIRE_NET_NAME, CText); // removed for component based net names
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	RegenerateSchematicDocumentsWindowList(false);

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewWaitingToDrawWireLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();
	
	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->WaitingToDrawWireLBDown(nFlags, CScaledPoint);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewDrawingWireLBDblClk(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();
	
	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->DrawingWireLBDblClk(nFlags, CScaledPoint);	
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewIdleStateLBUp(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->IdleStateLBUp(mouse_flags, CScaledPoint);	
	}  
		
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}


TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGraphicsSelectedStateLBUp(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();
	
	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->GraphicsSelectedStateLBUp(mouse_flags, CScaledPoint);
		}	  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGraphicsMovingStateLBUp(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	TCTestPointData CTestPointData;

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->GraphicsMovingStateLBUp(mouse_flags, CScaledPoint);
	
		if(PCSchematicManager->CTestPointData.update_graph_views) 
		{
			CTestPointData = PCSchematicManager->CTestPointData;
		}
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	if(CTestPointData.update_graph_views) GetTopLevelDoc()->ChangeGraphWaveform(CTestPointData);

	return system_state; 
}

void TCSuperSpiceDoc::OnViewUndelete(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	POSITION pos = GetFirstViewPosition();

	int page_id = PCSuperSpiceView->GetPageId();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCSchematicManager->Undelete();
	}
}

void TCSuperSpiceDoc::ChangeGraphWaveform(TCTestPointData &CTestPointData)
{
	TCOutputWaveformDoc *PCOutputWaveformDoc = (TCOutputWaveformDoc *)CDocumentWindowsList.IsOpen(CMSuperSpiceDocData.CMasterOutputWaveform);

	if(!PCOutputWaveformDoc) return;

	PCOutputWaveformDoc->ChangeWaveform(CTestPointData);
}

void TCSuperSpiceDoc::UpdateNets(TCSchematicManager *PCSchematicManager, bool correct_wires)
{
	CGlobalStatusMessage = E_STATUS_MSG_UPDATING_NET_NAMES;

	TCSuperSpiceView *PCViewInList;

	if(!PCSchematicManager) return;

	int page_id = PCSchematicManager->GetPageId();

	CArray <int, int> CWireLabelUpdateIds;

	PCSchematicManager->UpdateAndGetWireLabelIds(CWireLabelUpdateIds, correct_wires); //passed by referance

	int count = CWireLabelUpdateIds.GetSize();
	int id, p;
	CString CText;

	POSITION pos = GetFirstViewPosition();

	CString CLable;

	int last_id = -1;

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		for(p = 0; p < count; p++)
		{
			id		= CWireLabelUpdateIds[p];

			if(last_id == id) continue;

			CText = GetNewReferanceDesignator(E_WIRE_COMPONENT);

			last_id = id;

			PCSchematicManager->SetLabel(id, E_WIRE_NET_NAME, CText);
		}

		PCSchematicManager->MakeSameWiresHaveSameName();
		PCSchematicManager->NameAllTestPoints();

		PCSchematicManager->DrawAll();
	}

	RegenerateSchematicDocumentsWindowList(false);
//	RegenerateSchematicDocumentsWindowList(true);

	CGlobalStatusMessage = E_STATUS_MSG_NET_NAMES_UPDATED;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewSelectRegionStateLBUp(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom); // normalize offset
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); // normalize mouse position

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->SelectRegionStateLBUp(mouse_flags, CScaledPoint);
	}  
	
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGotGraphicStateLBUp(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->GotGraphicStateLBUp(mouse_flags, CScaledPoint);	
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGotClipboardLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->GotClipboardLBUp(nFlags, CScaledPoint);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewDrawingWireLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->DrawingWireLBUp(nFlags, CScaledPoint);
	}  
	//Ignore system state for this condition
/*
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}
*/
	return system_state;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewWaitingToDrawWireLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->WaitingToDrawWireLBUp(nFlags, CScaledPoint);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewIdleStateMouseMoved(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		float that_zoom = PCSchematicManager->GetZoom();

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->IdleStateMouseMoved(mouse_flags, CScaledPoint);
	
		// Update x, y mouse status bar
	}  
	
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGraphicsSelectedStateMouseMoved(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->GraphicsSelectedStateMouseMoved(mouse_flags, CScaledPoint);	
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	if(system_state == E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING) SetModifiedFlag(TRUE);

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGraphicsMovingStateMouseMoved(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->GraphicsMovingStateMouseMoved(mouse_flags, CScaledPoint);	
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}
 
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewSelectRegionStateMouseMoved(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom); // normalize offset
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); // normalize mouse position

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->SelectRegionStateMouseMoved(mouse_flags, CScaledPoint);
	} 
	
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}


TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGotGraphicStateMouseMoved(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->GotGraphicStateMouseMoved(mouse_flags, CScaledPoint);
	} 

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGotClipboardMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->GotClipboardMouseMoved(nFlags, CScaledPoint);
	}  
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewDrawingWireMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->DrawingWireMouseMoved(nFlags, CScaledPoint);
	}  
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewWaitingToDrawWireMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->WaitingToDrawWireMouseMoved(nFlags, CScaledPoint);
	}  
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}

void TCSuperSpiceDoc::OnViewRotate(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();

	if(!PCSchematicManager) return;

	int page_id = PCSchematicManager->GetPageId();

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		PCSchematicManager->Rotate();
	}  
}

void TCSuperSpiceDoc::OnViewMirror(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();

	if(!PCSchematicManager) return;

	int page_id = PCSchematicManager->GetPageId();

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		PCSchematicManager->Mirror();
	}
}
void TCSuperSpiceDoc::OnViewFlip(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();

	if(!PCSchematicManager) return;

	int page_id = PCSchematicManager->GetPageId();

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		PCSchematicManager->Flip();
	}
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewEditDelete(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	POSITION pos = GetFirstViewPosition();
	TCSuperSpiceView *PCViewInList;

	int page_id = PCSuperSpiceView->GetPageId();

	TCTestPointData CTestPointData;

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		PCSchematicManager->DeleteSelectedGraphics(true);

		if(PCSchematicManager->CTestPointData.update_graph_views) 
		{
			CTestPointData = PCSchematicManager->CTestPointData;
		}
	}  

	if(CTestPointData.update_graph_views) GetTopLevelDoc()->ChangeGraphWaveform(CTestPointData);

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCSchematicManager->CTestPointData.update_graph_views = false;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	RegenerateSchematicDocumentsWindowList(true);// used to caues crash!!!
//	RegenerateSchematicDocumentsWindowList(false); // added if open do not remove from RemoveAllOfType()

	SetModifiedFlag(TRUE);

	SetWindowTitle((CMDIChildWnd *)PCView->GetParent());

	return system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewEditCancel(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();


	POSITION pos = GetFirstViewPosition();
	TCSuperSpiceView *PCViewInList;

	int page_id = PCSuperSpiceView->GetPageId();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewEditCut(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	POSITION pos = GetFirstViewPosition();
	TCSuperSpiceView *PCViewInList;

	int page_id = PCSuperSpiceView->GetPageId();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;
	
		GCSuperSpiceClipboard.CutComponents(PCSchematicManager);
	}  
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	SetModifiedFlag(TRUE);

	SetWindowTitle((CMDIChildWnd *)PCView->GetParent());

	return system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewEditPaste(CView *PCView, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	PutNewReferanceDesignatorsInClipboard(PCSchematicManager);

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();
	TCSuperSpiceView *PCViewInList;

	int page_id = PCSuperSpiceView->GetPageId();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		GCSuperSpiceClipboard.Zoom(that_zoom);

		if(!GCSuperSpiceClipboard.PasteComponents(PCSchematicManager, CScaledPoint, CThisFileName)) return system_state;

		GCSuperSpiceClipboard.Zoom(1);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	SetModifiedFlag(TRUE);

	SetWindowTitle((CMDIChildWnd *)PCView->GetParent());

	return E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD;  
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewEditCopy(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSchematicManager *PCSchematicManager;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	POSITION pos = GetFirstViewPosition();
	TCSuperSpiceView *PCViewInList;

	int page_id = PCSuperSpiceView->GetPageId();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		GCSuperSpiceClipboard.CopyComponents(PCSchematicManager);

		GCSuperSpiceClipboard.Zoom(1);

		return system_state;
	}  
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewEditToWindowsClipboard(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSchematicManager *PCSchematicManager;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	POSITION pos = GetFirstViewPosition();
	TCSuperSpiceView *PCViewInList;

	int page_id = PCSuperSpiceView->GetPageId();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		GCSuperSpiceClipboard.CopyComponentsToWindowsClipboard(PCSchematicManager);

		GCSuperSpiceClipboard.Zoom(1);

		return system_state;
	}  
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewEditSelectAll(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSchematicManager *PCSchematicManager;

	POSITION pos = GetFirstViewPosition();
	TCSuperSpiceView *PCViewInList;

	int page_id = PCSuperSpiceView->GetPageId();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		PCSchematicManager->SetSelectAll();
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED);
	}

	return E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewIdleOnCancel(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSchematicManager *PCSchematicManager;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	if(PCSchematicManager) PCSchematicManager->DrawAll();

	POSITION pos = GetFirstViewPosition();
	TCSuperSpiceView *PCViewInList;

	SetAllSubCktIDs();

	int page_id = PCSuperSpiceView->GetPageId();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		system_state = PCSchematicManager->IdleOnCancel();
	}

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGraphicsMovingOnCancel(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSchematicManager *PCSchematicManager;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	POSITION pos = GetFirstViewPosition();
	TCSuperSpiceView *PCViewInList;

	int page_id = PCSuperSpiceView->GetPageId();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		system_state = PCSchematicManager->GraphicsMovingOnCancel();
	}

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state;
}	

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewSelectRegionOnCancel(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSchematicManager *PCSchematicManager;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	POSITION pos = GetFirstViewPosition();
	TCSuperSpiceView *PCViewInList;

	int page_id = PCSuperSpiceView->GetPageId();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		system_state = PCSchematicManager->SelectRegionOnCancel();	
	}

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGotGraphicOnCancel(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSchematicManager *PCSchematicManager;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	POSITION pos = GetFirstViewPosition();
	TCSuperSpiceView *PCViewInList;

	PCSchematicManager = PCSuperSpiceView->GetSchematicManager();

	if(!PCSchematicManager) return system_state;

	TCSchematicObject *PCSchematicObject = PCSchematicManager->GetLastCreatedGraphic();
	
	if(PCSchematicObject)
		PutBackReferanceDesignator(PCSchematicObject->GetType());
	
	SetAllSubCktIDs();

	int page_id = PCSuperSpiceView->GetPageId();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		system_state = PCSchematicManager->GotGraphicOnCancel();
	}

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGraphicsSelectedOnCancel(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TCSchematicManager *PCSchematicManager;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	int page_id = PCSuperSpiceView->GetPageId();

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		system_state = PCSchematicManager->GraphicsSelectedOnCancel();
	}
	
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}


TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewGotClipboardOnCancel(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSuperSpiceView *PCViewInList;
	TCSchematicManager *PCSchematicManager;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	PutBackReferanceDesignatorsInClipboard();

	int page_id = PCSuperSpiceView->GetPageId();

	POSITION pos = GetFirstViewPosition();

	SetAllSubCktIDs();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		system_state = PCSchematicManager->GotClipboardOnCancel();
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewDrawingWireOnCancel(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSchematicManager *PCSchematicManager;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	POSITION pos = GetFirstViewPosition();
	TCSuperSpiceView *PCViewInList;

	int page_id = PCSuperSpiceView->GetPageId();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		system_state = PCSchematicManager->DrawingWireOnCancel();
	}

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewWaitingToDrawWireOnCancel(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSchematicManager *PCSchematicManager;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	POSITION pos = GetFirstViewPosition();
	TCSuperSpiceView *PCViewInList;

	int page_id = PCSuperSpiceView->GetPageId();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		system_state = PCSchematicManager->WaitingToDrawWireOnCancel();
	}

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return system_state;
}

void TCSuperSpiceDoc::OnViewShowNetNames(CView *PCView, int show)
{
	PCView;
	TCSchematicManager *PCSchematicManager;

	POSITION pos = GetFirstViewPosition();
	TCSuperSpiceView *PCViewInList;

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCSchematicManager->ShowNetNames(show);
	}
}

void TCSuperSpiceDoc::ClearPinCurrentsAndVoltages(void)
{
	TCSchematicManager *PCSchematicManager;

	POSITION pos = GetFirstViewPosition();
	TCSuperSpiceView *PCViewInList;

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCSchematicManager->ClearPinCurrentsAndVoltages();
	}
}

void TCSuperSpiceDoc::OnViewShowDcCurrents(CView *PCView, int show)
{
	PCView;
	TCSchematicManager *PCSchematicManager;

	POSITION pos = GetFirstViewPosition();
	TCSuperSpiceView *PCViewInList;

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCSchematicManager->ShowDcCurrents(show);
	}
}
void TCSuperSpiceDoc::OnViewShowDcVoltages(CView *PCView, int show)
{
	PCView;
	TCSchematicManager *PCSchematicManager;

	POSITION pos = GetFirstViewPosition();
	TCSuperSpiceView *PCViewInList;

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCSchematicManager->ShowDcVoltages(show);
	}
}

void TCSuperSpiceDoc::OnViewProperties(CView *PCView, TCSchematicManager *PCSchematicManager)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;

	TCSuperSpiceSchematicProperty CPropertyPage;

	TCSuperSpiceGlobalData CData;

	if(!PCSchematicManager)
	{
		ASSERT(0);
		return;
	}

	CData.CPageData		= PCSchematicManager->GetPageData();
	CData.CDrawData		= GCSuperSpiceGlobalData.CDrawData;
	CData.CColorData	= GCSuperSpiceGlobalData.CColorData;
	CData.CFontData		= GCSuperSpiceGlobalData.CFontData;

	//This may have changed from saveas, so update
	CData.CPageData.CFileName = CMSchematicPageDataDefault.CFileName;

	CPropertyPage.SetData(CData);

	if(CPropertyPage.DoModal() != IDOK)
	{
		return;
	}

	CData = CPropertyPage.GetData();

	bool colour_flag = false;
	bool connection_dots = false;

	if(CData.CDrawData.display_connection_dots)
	if(GCSuperSpiceGlobalData.CDrawData.connection_dot_size != CData.CDrawData.connection_dot_size) connection_dots = true;

	GCSuperSpiceGlobalData.CDrawData	= CData.CDrawData;

	if(GCSuperSpiceGlobalData.CColorData != CData.CColorData) colour_flag = true;

	GCSuperSpiceGlobalData.CColorData	= CData.CColorData;
	GCSuperSpiceGlobalData.CFontData	= CData.CFontData;

	POSITION pos = GetFirstViewPosition();
	TCSuperSpiceView *PCViewInList;

	int page_id = PCSuperSpiceView->GetPageId();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		PCSchematicManager->SetPageData(CData.CPageData);

		UpdatePageIdData(CData.CPageData, page_id);

		SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());	// Page number and title may have changed
	
		PCSchematicManager->UpdateSchematicObject();

		if(colour_flag) 
		{
			PCSchematicManager->SetSelectAll(); 

			PCSchematicManager->ResetSelectAll(true); //redraw to reflect all changes, including pins
		}

		if(connection_dots) PCSchematicManager->DisplayAllConnectionDots();

		PCSchematicManager->DrawAll();
	}  
}


void TCSuperSpiceDoc::UpdatePageIdData(TCSchematicPageData &CPageData, int page_id)
{
	TCPageIdData CPageIdData;

	int index = CMPageId.GetPageIndex(page_id);

	if(index < 0) return;

	CPageIdData = CMPageId.CPageIdData.GetAt(index);

	CPageIdData.CPageTitle	= CPageData.CPageTitle;
	CPageIdData.CPageTitle.Format("%s %d", CPageIdData.CPageTitle, CPageData.page_number);

	CMPageId.CPageIdData.SetAt(index, CPageIdData);
}

void TCSuperSpiceDoc::OnCloseDocument() 
{
	SaveLastState();

	CDocumentWindowsList.Close();

	if(PCParentSuperSpiceDoc) PCParentSuperSpiceDoc->OnNotifyDocumentClosed(this);

	GCWorkspaceTree.Remove(this);

	COleServerDoc::OnCloseDocument();
}
// the framewok causes fucking major problems, hence above and below
void TCSuperSpiceDoc::SaveLastState(void)
{
	CDocumentWindowsList.UpdateWindowPosition();

	SaveWorkspace();

	GCSuperSpiceGlobalData.CProgramOptions.CGeneral.CLastWorkspaceLoaded = CThisFileName;
}

void TCSuperSpiceDoc::DeleteContents() 
{
	// TODO: Add your specialized code here and/or call the base class
		
	
	// reset page count to do 
	COleServerDoc::DeleteContents();
}
void  TCSuperSpiceDoc::OnViewPropertyAccelerater(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();

	CPoint CMousePosition;

	if(PCSchematicManager->IsComponentOutlined())
	{
		CMousePosition = PCSchematicManager->GetComponentOutlinePosition();	

		PCSchematicManager->EraseComponentOutline();

		OnLButtonDblClk(PCView, CMousePosition, 0);

		return;
	}
	
	if(PCSchematicManager->GetGraphicSelectedPosition(&CMousePosition))
	{
		CMousePosition += PCSchematicManager->GetViewPortOrigin();
		OnLButtonDblClk(PCView, CMousePosition, 0);

		return;
	}

	OnViewProperties(PCView, PCSchematicManager);
}

void TCSuperSpiceDoc::DecendIntoSchematic(TCSchematicManager *PCSchematicManager, CView *PCView,TCSchematicComponentInfo &CSchematicComponentInfo)
{
	PCView;
	
	CString CText;
	TCSchematicObject *PCSchematicObject;

	if(!PCSchematicManager) return;
		
	PCSchematicObject = PCSchematicManager->GetSchematicObject(CSchematicComponentInfo.id);
	
	if(!PCSchematicObject) return;

	TCSchematicObjectData CSchematicObjectData, *PCSchematicObjectData;

	PCSchematicObjectData = PCSchematicManager->GetSchematicObjectData(CSchematicComponentInfo.id);
	
	if(!PCSchematicObjectData) return;

	CSchematicObjectData = *PCSchematicObjectData;

	if(E_SCHEMATIC_OBJECT != CSchematicComponentInfo.type) return;
 
	CText = CSchematicObjectData.CSymbolData.CChildFileName;

	if(CText == "") 
	{
		AfxMessageBox(IDS_NULL_SYMBOL_FILENAME);

		return;
	}

	TCSuperSpiceDoc *PCSuperSpiceDoc = NULL;

	CString CRefID = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	CArray <CString, CString&> CNewRefIdList;

	CreateRefDesList(CNewRefIdList, CRefID);

	CString CNewRefId = GetNewRefDes(CRefID);
	CString CNewFileName, CNewTempFileName;

	if(!FileExists(CText))
	{
		CText = GetRelativeFileName(CText);

		if(FileExists(CText))
			CSchematicObjectData.CSymbolData.CChildFileName = CText;// update
	}

	if(!FileExists(CText))
	{
		if(AfxMessageBox(IDS_CREATE_NEW_SCH, MB_YESNO) == IDYES)
		{
			CDocumentWindowsList.Remove(CText, false);// get rid of old data in file list window

			CNewFileName = SaveAsSchematicDlg(CText);

			if(CNewFileName == "") return;

			CNewTempFileName = CNewFileName;

			CText.MakeLower();
			CNewTempFileName.MakeLower();	

			if(CNewTempFileName != CText)//create a new copy in database
			{
				GCSuperSpiceDataBase.DoublicateSymbol(CNewFileName, CSchematicObjectData);
			}

			PCSuperSpiceDoc = CreateNewChildSchematicDocument(CNewFileName);

			if(!PCSuperSpiceDoc)
			{
				AfxMessageBox(IDS_UNABLE_TO_CREATE_SCH);

				return;
			}

			PCSchematicManager->SetSchematicObjectData(CSchematicComponentInfo.id, CSchematicObjectData);

			PCSuperSpiceDoc->CreateChildSchematicPins(CSchematicObjectData);

			PCSuperSpiceDoc->SetParent(this, CNewFileName, CNewRefIdList, CNewRefId);

			// need save  dialog box
			PCSuperSpiceDoc->DoSave(CNewFileName, true);

			PCSuperSpiceDoc->OnCloseDocument();

			CDocumentWindowsList.Create(CNewFileName, E_SCHEMATIC_DOCUMENT, this, CNewRefIdList, CRefID);

			RegenerateSchematicDocumentsWindowList(false);
			
			DisplayChildSchematicDocument(CNewFileName, CRefID);

			return;
		}
		else return;
	}

	PCSuperSpiceDoc = DisplayChildSchematicDocument(CText, CRefID);
}

void TCSuperSpiceDoc::OnLButtonDblClk(CView *PCView, CPoint CMousePosition, UINT mouse_flags)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSchematicComponentInfo CSchematicComponentInfo;

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	bool fine = false;

	if(mouse_flags & MK_SHIFT) fine = true;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	CPoint CNewOffset = (CPoint) (COffset - PCSchematicManager->GetViewPortOrigin());

	CSchematicComponentInfo = PCSchematicManager->InspectSchematicObject((CPoint) (CMousePosition - CNewOffset), fine, true);

	if(mouse_flags & MK_CONTROL) 
	{	
		DecendIntoSchematic(PCSchematicManager, PCView, CSchematicComponentInfo);
	
		return;
	}

	if(CSchematicComponentInfo.id < 0) 
	{
		OnViewProperties(PCView, PCSchematicManager);

		EraseComponentOutline();

		return;
	}
	switch(CSchematicComponentInfo.type)
	{
		case E_SCHEMATIC_OBJECT: InspectSchematicObject(PCSchematicManager, PCView, CSchematicComponentInfo); break;	
			
		case E_SCHEMATIC_TEXT_LABEL: InspectSchematicTextLableObject(PCSchematicManager, PCView, CSchematicComponentInfo); break;

		case E_SCHEMATIC_WIRE: InspectSchematicWireObject(PCSchematicManager, PCView, CSchematicComponentInfo); break;	

		case E_SCHEMATIC_LABEL: InspectSchematicLabelObject(PCSchematicManager, PCView, CSchematicComponentInfo);break;	

		case E_WAVEFORM_OBJECT_SCREEN: InspectWaveformObject(PCSchematicManager, PCView, CSchematicComponentInfo); break;	

		case E_SCHEMATIC_PIN: InspectSchematicPinObject(PCSchematicManager, PCView, CSchematicComponentInfo);break;	
			

		case E_SCHEMATIC_PIN_LABEL: InspectSchematicPinLabelObject(PCSchematicManager, PCView, CSchematicComponentInfo);break;	

		}
	
	EraseComponentOutline();
}

void TCSuperSpiceDoc::InspectWaveformObject(TCSchematicManager *PCSchematicManager, CView *PCView, TCSchematicComponentInfo &CSchematicComponentInfo)
{
	PCView;
	TCSuperSpiceView *PCViewInList;
	
	if(!PCSchematicManager) return;

	int page_id = PCSchematicManager->GetPageId();

	CString CText;
	TCSchematicObject *PCSchematicObject;
		
	PCSchematicObject = PCSchematicManager->GetSchematicObject(CSchematicComponentInfo.id);
	
	if(!PCSchematicObject) return;

	TCSchematicObjectData CSchematicObjectData, *PCSchematicObjectData;

	PCSchematicObjectData = PCSchematicManager->GetSchematicObjectData(CSchematicComponentInfo.id);
	
	if(!PCSchematicObjectData) return;

	CSchematicObjectData = *PCSchematicObjectData;

	TCMasterWaveformPropPages CMasterWaveformPropPages;

	CMasterWaveformPropPages.CSchematicObjectData = CSchematicObjectData;
	CMasterWaveformPropPages.PCOutputWaveformData = CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0];
	CMasterWaveformPropPages.CLabels.POutputWaveformData = CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0];
	CMasterWaveformPropPages.CPageOptions.POutputWaveformData  = CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0];
	CMasterWaveformPropPages.CGraphSetup.POutputWaveformData  = CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0];
	CMasterWaveformPropPages.CSignalSetup.POutputWaveformData  = CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0];
	CMasterWaveformPropPages.CCalculator.POutputWaveformData  = CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0];

	if(CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize() == 1)
	if(PCSchematicObjectData->PCOutputWaveformDataHeader && CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0])//Make sure data base has this objects current signal list
	{
		int type = CSchematicObjectData.PCOutputWaveformDataHeader->type;

		if(!(type < CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]->CRecords.GetSize()))
		{
			DisplayError(IDS_ERR_ERROR, IDS_NO_GRAPH_DATA);

			return;
		}

		TCOutputWaveformDataHeader &COutputWaveformDataHeader = CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]->CRecords[type].CHeader;

		COutputWaveformDataHeader.SetDisplayedSignals(*PCSchematicObjectData->PCOutputWaveformDataHeader);
	}

	if(CMasterWaveformPropPages.DoModal() != IDOK) return;

	BeginWaitCursor();

	CSchematicObjectData = CMasterWaveformPropPages.CSchematicObjectData;

// Update data pointer

	if(CSchematicObjectData.PCOutputWaveformDataHeader)
	{
		int type = CSchematicObjectData.PCOutputWaveformDataHeader->type;

		TCOutputWaveformDataHeader &COutputWaveformDataHeader = CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]->CRecords[type].CHeader;		

		if(CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0])
			type = CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]->GetWaveFormHeaderIndex(type);
		if(type > -1)
		if(type < CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]->CRecords.GetSize())
		{
			CMSuperSpiceDocData.CWaveformDataRuns.SetupMathFunctionData();

			CSchematicObjectData.CLabelListData[E_WAVEFORM_PLOT_NAME].CLabel = COutputWaveformDataHeader.CPlotName;
			CSchematicObjectData.CLabelListData[E_WAVEFORM_DATE_AND_TIME].CLabel = COutputWaveformDataHeader.CDateAndTime;

			if(type != E_SPICE_RECORD_MATH_0)// do not destroy data base with math data
				CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]->CRecords[type].CHeader = *CSchematicObjectData.PCOutputWaveformDataHeader;
		
			COutputWaveformDataHeader.SyncAllRuns();
		}
	}

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		PCSchematicObject = PCSchematicManager->GetSchematicObject(CSchematicComponentInfo.id);

		PCSchematicManager->SetSchematicObjectData(CSchematicComponentInfo.id, CSchematicObjectData);
	}

	EndWaitCursor();
}

void TCSuperSpiceDoc::InspectSchematicObject(TCSchematicManager *PCSchematicManager, CView *PCView, TCSchematicComponentInfo &CSchematicComponentInfo)
{
	PCView;
	TCSuperSpiceView *PCViewInList;
	
	if(!PCSchematicManager) return;

	int page_id = PCSchematicManager->GetPageId();

	CString CText;
	TCSchematicObject *PCSchematicObject;
		
	PCSchematicObject = PCSchematicManager->GetSchematicObject(CSchematicComponentInfo.id);
	
	if(!PCSchematicObject) return;

	TCSchematicObjectData CSchematicObjectData, *PCSchematicObjectData;

	PCSchematicObjectData = PCSchematicManager->GetSchematicObjectData(CSchematicComponentInfo.id);
	
	if(!PCSchematicObjectData) return;

	CString COldFileName = PCSchematicObject->CMSchematicObjectData.CSymbolData.CChildFileName;

	CSchematicObjectData = *PCSchematicObjectData;
	int type = PCSchematicObject->GetType();
	if(PCSchematicObject->GetType() == E_CONNECTION_DOT) return;

	int view_type = CSchematicObjectData.component_property_view_type;
	TCTestPointData CTestPointData;

	if(view_type == E_PROPERTY_NULL) return;

	if((type >=E_DC_VOLTAGE_SOURCE && type <= E_SINGLE_FREQ_CURRENT_FM) ||
		CSchematicObjectData.attached_model_type == E_SPICE_GENERATOR)// need to update symbol data base
	{
		if(IsBadReadPtr(CSchematicObjectData.PCGeneratorData, 4))
		{
			AfxMessageBox(IDS_INVALID_GENERATOR_POINTER);

			return;
		}

		if(view_type == E_PROPERTY_DC_VOLTAGE_SOURCE)
		{
			TCMasterGeneratorDCVoltDlg CGenerator;

			CGenerator.CSchematicObjectData = CSchematicObjectData;
		
			if(CGenerator.DoModal() != IDOK) return;

			CSchematicObjectData = CGenerator.CSchematicObjectData;
		}
		else if(view_type == E_PROPERTY_SINE_VOLTAGE_SOURCE)
		{
			TCMasterGeneratorSineVoltDlg CGenerator;

			CGenerator.CSchematicObjectData = CSchematicObjectData;
		
			if(CGenerator.DoModal() != IDOK) return;

			CSchematicObjectData = CGenerator.CSchematicObjectData;

		}
		else if(view_type == E_PROPERTY_PULSE_VOLTAGE_SOURCE)
		{
			TCMasterGeneratorPulseVoltDlg CGenerator;

			CGenerator.CSchematicObjectData = CSchematicObjectData;
		
			if(CGenerator.DoModal() != IDOK) return;

			CSchematicObjectData = CGenerator.CSchematicObjectData;
		}
		else if(view_type == E_PROPERTY_EXPONENTIAL_VOLTAGE_SOURCE)
		{
			TCMasterGeneratorExpVoltDlg CGenerator;

			CGenerator.CSchematicObjectData = CSchematicObjectData;
		
			if(CGenerator.DoModal() != IDOK) return;

			CSchematicObjectData = CGenerator.CSchematicObjectData;
		}
		else if(view_type == E_PROPERTY_PIECEWISE_LINEAR_VOLTAGE_SOURCE)
		{
			TCMasterGeneratorPWLVoltDlg CGenerator;

			CGenerator.CSchematicObjectData = CSchematicObjectData;
		
			if(CGenerator.DoModal() != IDOK) return;

			CSchematicObjectData = CGenerator.CSchematicObjectData;
		}
		else if(view_type == E_PROPERTY_SINGLE_FREQ_VOLTAGE_FM)
		{
			TCMasterGeneratorSFFMVoltDlg CGenerator;

			CGenerator.CSchematicObjectData = CSchematicObjectData;
		
			if(CGenerator.DoModal() != IDOK) return;

			CSchematicObjectData = CGenerator.CSchematicObjectData;
		}
		else if(view_type == E_PROPERTY_DC_CURRENT_SOURCE)
		{
			TCMasterGeneratorDCVoltDlg CGenerator;

			CGenerator.CSchematicObjectData = CSchematicObjectData;
		
			if(CGenerator.DoModal() != IDOK) return;

			CSchematicObjectData = CGenerator.CSchematicObjectData;
		}
		else if(view_type == E_PROPERTY_SINE_CURRENT_SOURCE)
		{
			TCMasterGeneratorSineVoltDlg CGenerator;

			CGenerator.CSchematicObjectData = CSchematicObjectData;
		
			if(CGenerator.DoModal() != IDOK) return;

			CSchematicObjectData = CGenerator.CSchematicObjectData;
		}
		else if(view_type == E_PROPERTY_PULSE_CURRENT_SOURCE)
		{
			TCMasterGeneratorPulseVoltDlg CGenerator;

			CGenerator.CSchematicObjectData = CSchematicObjectData;
		
			if(CGenerator.DoModal() != IDOK) return;

			CSchematicObjectData = CGenerator.CSchematicObjectData;
		}
		else if(view_type == E_PROPERTY_EXPONENTIAL_CURRENT_SOURCE)
		{
			TCMasterGeneratorExpVoltDlg CGenerator;

			CGenerator.CSchematicObjectData = CSchematicObjectData;
		
			if(CGenerator.DoModal() != IDOK) return;

			CSchematicObjectData = CGenerator.CSchematicObjectData;
		}
		else if(view_type == E_PROPERTY_PIECEWISE_LINEAR_CURRENT_SOURCE)
		{
			TCMasterGeneratorPWLVoltDlg CGenerator;

			CGenerator.CSchematicObjectData = CSchematicObjectData;
		
			if(CGenerator.DoModal() != IDOK) return;

			CSchematicObjectData = CGenerator.CSchematicObjectData;
		}
		else if(view_type == E_PROPERTY_SINGLE_FREQ_CURRENT_FM)
		{
			TCMasterGeneratorSFFMVoltDlg CGenerator;

			CGenerator.CSchematicObjectData = CSchematicObjectData;
		
			if(CGenerator.DoModal() != IDOK) return;

			CSchematicObjectData = CGenerator.CSchematicObjectData;
		}
	}
	else
	{
	if(CSchematicObjectData.CPinListData.GetSize() < 5)
	{
		GCSuperSpiceDataBase.GetModel(CSchematicObjectData.CSpiceParameters);

		if(CSchematicObjectData.component_property_view_type)
		{
			if (CSchematicObjectData.component_property_view_type == E_PROPERTY_FET ||
				CSchematicObjectData.component_property_view_type == E_PROPERTY_MESFET)
			{
				TCMasterFetDlg CComponentProperties;

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			}
			else if(CSchematicObjectData.component_property_view_type == E_PROPERTY_MOSFET)
			{
				TCMasterMOSFETDlg CComponentProperties;

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			}
			else if (CSchematicObjectData.component_property_view_type == E_PROPERTY_BIPOLAR)
			{
				TCMasterBipolarDlg CComponentProperties;

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			}
			else if(CSchematicObjectData.component_property_view_type == E_PROPERTY_RESISTOR ||
				CSchematicObjectData.component_property_view_type == E_PROPERTY_THERMISTOR)
			{
				TCMasterResistorDlg CComponentProperties;

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			}
			else if(CSchematicObjectData.component_property_view_type == E_PROPERTY_CAPACITOR)
			{
				TCMasterCapacitorDlg CComponentProperties;

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			}
			else if(CSchematicObjectData.component_property_view_type == E_PROPERTY_INDUCTOR)
			{
				TCMasterInductorDlg CComponentProperties;

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			}
			else if(CSchematicObjectData.component_property_view_type == E_PROPERTY_DIODE)
			{
				TCMasterDiodeDlg CComponentProperties;

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			}
			else if(CSchematicObjectData.component_property_view_type == E_PROPERTY_LAPLACE_TRANSFORM)
			{
				TCMasterLaplaceDlg CComponentProperties;

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			}
			else if(CSchematicObjectData.component_property_view_type == E_PROPERTY_TRANSFORMER)
			{
				TCMasterTransformerDlg CComponentProperties;

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			}

			else if(CSchematicObjectData.component_property_view_type == E_PROPERTY_TRANSMISSION_LINE)
			{
				TCMasterTransmissionLineDlg CComponentProperties;

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			} 
			else if(CSchematicObjectData.component_property_view_type == E_PROPERTY_LOSSLESS_TRANSMISSION_LINE)
			{
				TCMasterLosslessTransmissionLineDlg CComponentProperties;

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			} 
			else if(CSchematicObjectData.component_property_view_type == E_PROPERTY_GENERIC_MODEL)
			{
				TCMasterGenericModelDlg CComponentProperties;

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			} 
			else if(CSchematicObjectData.component_property_view_type == E_PROPERTY_SWITCH || CSchematicObjectData.component_property_view_type == E_PROPERTY_ISWITCH)
			{
				TCMasterSwitchDlg CComponentProperties;

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			}
			else if(view_type == E_PROPERTY_CONTROLED_SOURCE)
			{
				TCMasterControlledSourceDlg CComponentProperties;

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			}
			else if(view_type == E_PROPERTY_CONNECTORS)
			{
				TCConnectorDlg CComponentProperties;

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			}
			else if(view_type == E_PROPERTY_SUBCIRCUIT_PIN_CONNECTORS)
			{
				TCSubcircuitConnectorDlg CComponentProperties;

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			}
			else if(view_type == E_PROPERTY_TEST_MARKERS)
			{
				TCTestPointDlg CComponentProperties;

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				CTestPointData.COld		= PCSchematicObject->GetPinLabel(0, E_COMPONENT_PIN_NET_NAME);
				CTestPointData.old_type = CSchematicObjectData.version;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;

				CTestPointData.update_graph_views = true;
				CTestPointData.new_type = CSchematicObjectData.version;

				CTestPointData.COld.MakeLower();
			}
			else if(view_type == E_PROPERTY_IC_RESISTOR || view_type == E_PROPERTY_IC_CAPACITOR)
			{
				TCMasterValueDlg CComponentProperties;

				GCSuperSpiceDataBase.GetModel(CSchematicObjectData.CSpiceParameters);

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			}
			else if(view_type == E_PROPERTY_VARIABLE_RESISTOR)
			{
				TCMasterVariableResistorDlg CComponentProperties;

				GCSuperSpiceDataBase.GetModel(CSchematicObjectData.CSpiceParameters);

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			}
			else if(view_type == E_PROPERTY_URC_TRANSMISSION_LINE)
			{
				
				TCMasterURCDlg CComponentProperties;

				GCSuperSpiceDataBase.GetModel(CSchematicObjectData.CSpiceParameters);

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			}
			else if(view_type == E_PROPERTY_TITLE_BLOCK)
			{
				TCTitleBlockDlg CTitleBlockDlg;

				CTitleBlockDlg.CSchematicObjectData = CSchematicObjectData;

				if(CTitleBlockDlg.DoModal() != IDOK) return;

				CSchematicObjectData = CTitleBlockDlg.CSchematicObjectData;	
			}

			else //if
			{
				if(CSchematicObjectData.component_property_view_type == E_PROPERTY_GENERIC_SUBCIRCUIT)
				{
					TCMasterGenericSubcircuitDlg CComponentProperties;

					CComponentProperties.CSchematicObjectData.Copy(CSchematicObjectData);

					if(CComponentProperties.DoModal() != IDOK) return;

					CSchematicObjectData.Copy(CComponentProperties.CSchematicObjectData);
				}
				else
				{
					TCMasterGenericModelDlg CComponentProperties;

					CComponentProperties.CSchematicObjectData = CSchematicObjectData;

					if(CComponentProperties.DoModal() != IDOK) return;

					CSchematicObjectData = CComponentProperties.CSchematicObjectData;
				}
			}
		}
		else
		{
			if(CSchematicObjectData.component_property_view_type != E_PROPERTY_GENERIC_MODEL)
			{
				TCMasterSubcircuitDlg CComponentProperties;

				GCSuperSpiceDataBase.GetModel(CSchematicObjectData.CSpiceParameters);

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			}
			else if(CSchematicObjectData.component_property_view_type == E_PROPERTY_GENERIC_SUBCIRCUIT)
			{
				TCMasterGenericSubcircuitDlg CComponentProperties;

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			}
			else
			{
				TCMasterGenericModelDlg CComponentProperties;

				CComponentProperties.CSchematicObjectData = CSchematicObjectData;

				if(CComponentProperties.DoModal() != IDOK) return;

				CSchematicObjectData = CComponentProperties.CSchematicObjectData;
			}
		}
	}
	else
	{
		TCMasterSubcircuitLargeDlg CComponentProperties;

		GCSuperSpiceDataBase.GetModel(CSchematicObjectData.CSpiceParameters);

		CComponentProperties.CSchematicObjectData = CSchematicObjectData;

		if(CComponentProperties.DoModal() != IDOK) return;

		CSchematicObjectData = CComponentProperties.CSchematicObjectData;
	}
	} 

	bool set_model = true;

	if(CSchematicObjectData.component_property_view_type >= E_PROPERTY_DC_VOLTAGE_SOURCE &&
		CSchematicObjectData.component_property_view_type <= E_PROPERTY_SINGLE_FREQ_CURRENT_FM ||
		CSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC || ((CSchematicObjectData.type < E_DC_VOLTAGE_SOURCE) && CSchematicObjectData.type) ||
		CSchematicObjectData.component_property_view_type == E_PROPERTY_TITLE_BLOCK ||
		CSchematicObjectData.component_property_view_type == E_PROPERTY_TRANSMISSION_LINE)
	{
		set_model = false;
	}

	if(PCSchematicObject->m_type != E_WAVEFORM_COMPONENT)// two risky
		GCSuperSpiceDataBase.SetSchematicObjectData(CSchematicObjectData, set_model);


	// only keep parameter data in the data base, not the model;
	CSchematicObjectData.CSpiceParameters.CData.SetSize(0);

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		PCSchematicManager->SetSchematicObjectData(CSchematicComponentInfo.id, CSchematicObjectData);

		int type = CSchematicObjectData.type;

		if(type == E_GROUND || type == E_PAGE_CONNECTER_INPUT || type == E_SUBCIRCUIT_PIN_CONNECTER ||
		   type == E_PAGE_CONNECTER_OUTPUT || type == E_PAGE_CONNECTER_BIDIRECTIONAL)
		{
			PCSchematicManager->UpdateNetNamesFromPinNames(CSchematicComponentInfo.id);		
		}
		
		PCSchematicObject = PCSchematicManager->GetSchematicObject(CSchematicComponentInfo.id);

		if(!PCSchematicObject) continue;

		UpdateChildSchematicRefDesignator(PCSchematicObject->CMSchematicObjectData.CSymbolData.CChildFileName, 
			                              PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel);
		if(view_type == E_PROPERTY_TEST_MARKERS) 
		{
			AfxGetApp()->BeginWaitCursor();
			CTestPointData.CNew	= PCSchematicObject->GetPinLabel(0, E_COMPONENT_PIN_NET_NAME);
			CTestPointData.CNew.MakeLower();// spice is lower case;
			PCSchematicManager->ChangeWaveform(CTestPointData);
			PCSchematicManager->DrawAll();
			AfxGetApp()->EndWaitCursor();
		}
	}

	if(CSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC && COldFileName != "")
	{
		bool f_remove_old = false;

		COldFileName.MakeLower();

		CString CNewFileName = PCSchematicObject->CMSchematicObjectData.CSymbolData.CChildFileName;

		CNewFileName.MakeLower();

		if(COldFileName != CNewFileName) f_remove_old =true;

		RegenerateSchematicDocumentsWindowList(f_remove_old);//updated, true renoves good data //lastif attached schematic has been changed need to up date file list
	}

	if(view_type == E_PROPERTY_TEST_MARKERS) ChangeGraphWaveform(CTestPointData);

	if(PCSchematicObject->m_type == E_SUBCIRCUIT_PIN_CONNECTER && PCParentSuperSpiceDoc)
	{
		int pin_id = (int)SpiceMKSStringToFloat(PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel);

		CText = PCSchematicObject->CMSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;

		pin_id = SetSymbolPinName(pin_id, CText);

		if(pin_id > -1)// No id found, if name found, change id
		{
			PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel.Format("%d", pin_id);
			//redraw
			PCSchematicManager->SetSchematicObjectData(CSchematicComponentInfo.id, PCSchematicObject->CMSchematicObjectData);
		}
	}

	else if(PCSchematicObject->m_type == E_SUBCIRCUIT_COMPONENT)
	{
		CString CFileName = PCSchematicObject->CMSchematicObjectData.CSymbolData.CFilePath + PCSchematicObject->CMSchematicObjectData.CSymbolData.CFileName;

		if(CFileName != "") SetSchematicPinNames(PCSchematicObject);
	}

	CopySchematicDataToSameSelected(CSchematicObjectData);

	float value;
	CString CRefDes, CValue;

	switch(PCSchematicObject->CMSchematicObjectData.component_property_view_type)
	{
		case E_PROPERTY_RESISTOR:
		case E_PROPERTY_CAPACITOR:
		case E_PROPERTY_INDUCTOR:

		CValue = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel;

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CValue);

		CRefDes = PCSchematicObject->GetLabel(E_COMPONENT_DESIGNATOR); 
		
		ModifyComponentValue(CRefDes, value); 

		break;

		default: ModifyComponentValue(PCSchematicObject);
	}
}

void TCSuperSpiceDoc::CopySchematicDataToSameSelected(TCSchematicObjectData &CSchematicObjectData)
{
	POSITION pos = GetFirstViewPosition();

	CString CSymbolName = CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel;
	CString CRefDes;

	int label_count = CSchematicObjectData.CLabelListData.GetSize();

	TCSchematicObject *PCSchematicObject;
	TCSuperSpiceView *PCViewInList;
	TCSchematicManager *PCSchematicManager;

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		CArray <TCSchematicObject *, TCSchematicObject *> &CGraphicList = PCSchematicManager->CMSchematicManagerData.CGraphicList;
		
		int scount = CGraphicList.GetSize();

		for(int q = 0; q < scount; q++)
		{
			PCSchematicObject = CGraphicList[q];

			if(!PCSchematicObject->m_selected) continue;
			if(PCSchematicObject->m_type == E_WAVEFORM_COMPONENT) continue;
			if(PCSchematicObject->CMSchematicObjectData.PCOutputWaveformDataHeader) continue;
			if(PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel != CSymbolName) continue;
			
			if(PCSchematicObject->CMSchematicObjectData.PCGeneratorData && CSchematicObjectData.PCGeneratorData)
				*PCSchematicObject->CMSchematicObjectData.PCGeneratorData = *CSchematicObjectData.PCGeneratorData;

			PCSchematicObject->CMSchematicObjectData.CSpiceParameters.CopyInfo(CSchematicObjectData.CSpiceParameters);

			CRefDes = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

			PCSchematicObject->CMSchematicObjectData.f_validate_label_value			= CSchematicObjectData.f_validate_label_value;
			PCSchematicObject->CMSchematicObjectData.format_spice_value				= CSchematicObjectData.format_spice_value;
			PCSchematicObject->CMSchematicObjectData.component_property_view_type	= CSchematicObjectData.component_property_view_type;
			PCSchematicObject->CMSchematicObjectData.version						= CSchematicObjectData.version;
			PCSchematicObject->CMSchematicObjectData.attached_model_type			= CSchematicObjectData.attached_model_type;

			if(label_count != PCSchematicObject->CMSchematicObjectData.CLabelListData.GetSize()) continue;

			for(int r = 0; r < label_count; r++)
			{			
				PCSchematicObject->CMSchematicObjectData.CLabelListData[r].is_visable = CSchematicObjectData.CLabelListData[r].is_visable;

				if(r == E_COMPONENT_DESIGNATOR) continue;

				PCSchematicObject->CMSchematicObjectData.CLabelListData[r].CLabelValue = CSchematicObjectData.CLabelListData[r].CLabelValue;

				PCSchematicManager->SetLabel(q, r, CSchematicObjectData.CLabelListData[r].CLabel, true);
			}
		}
	}
}

void TCSuperSpiceDoc::InspectSchematicTextLableObject(TCSchematicManager *PCSchematicManager, CView *PCView, TCSchematicComponentInfo &CSchematicComponentInfo)
{
	PCView;
	TCSuperSpiceView *PCViewInList;
	
	int page_id = PCSchematicManager->GetPageId();

	CString CText;
	TCSchematicObject *PCSchematicObject;
		
	PCSchematicObject = PCSchematicManager->GetSchematicObject(CSchematicComponentInfo.id);

	TCAddText1 CDlgText;

	CDlgText.CMEditAddText = PCSchematicObject->GetLabel();

	if(CDlgText.DoModal() == IDCANCEL) return;

	CText = CDlgText.CMEditAddText;

	if(CText == "") return; // Do not change null strings
							// To do: invalidate all white space strings
	
	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		PCSchematicManager->SetLabel(CSchematicComponentInfo.id, CSchematicComponentInfo.label_id, CText);
	}
}
void TCSuperSpiceDoc::InspectSchematicWireObject(TCSchematicManager *PCSchematicManager, CView *PCView,TCSchematicComponentInfo &CSchematicComponentInfo)
{
	TCWirePropertiesDlg CWirePropertiesDlg;

	PCView;
	TCSuperSpiceView *PCViewInList;
	
	if(!PCSchematicManager) return;

	int page_id = PCSchematicManager->GetPageId();

	CString CText;
	TCSchematicObject *PCSchematicObject;
		
	PCSchematicObject = PCSchematicManager->GetSchematicObject(CSchematicComponentInfo.id);

	if(!PCSchematicObject) return;

	TCSchematicObjectData CSchematicObjectData, *PCSchematicObjectData;

	PCSchematicObjectData = PCSchematicManager->GetSchematicObjectData(CSchematicComponentInfo.id);
	
	if(!PCSchematicObjectData) return;

	CSchematicObjectData = *PCSchematicObjectData;
	CWirePropertiesDlg.SetData(CSchematicObjectData);

	if(CWirePropertiesDlg.DoModal() != IDOK) return;

	CSchematicObjectData = CWirePropertiesDlg.GetData();

	int f_update_other_node_names = false;

	CString CTempText = CSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel;

	CTempText.MakeLower();

	f_update_other_node_names = E_UPDATE_OTHER_NODE_NAMES_SET_USER_PREFERED;

	if(CTempText.Find("node") > -1) // only fix real use names, normal net names
	{
		f_update_other_node_names = false;

		PCSchematicObjectData->user_label_preferred = false;
	}

//	GCSuperSpiceDataBase.CMDefaults[PCSchematicObject->GetType()].Copy(CSchematicObjectData);
	if(PCSchematicObject->m_type != E_WAVEFORM_COMPONENT)// two risky
		GCSuperSpiceDataBase.SetSchematicObjectData(CSchematicObjectData, false);

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		PCSchematicManager->SetSchematicObjectData(CSchematicComponentInfo.id, CSchematicObjectData);
		
		PCSchematicManager->MakeSameWiresHaveSameName(CSchematicComponentInfo.id, f_update_other_node_names);
	}
}

void TCSuperSpiceDoc::InspectSchematicPinObject(TCSchematicManager *PCSchematicManager, CView *PCView, TCSchematicComponentInfo &CSchematicComponentInfo)
{
	PCView;
	TCSuperSpiceView *PCViewInList;
	
	int page_id = PCSchematicManager->GetPageId();

	CString CText;
	TCSchematicObject *PCSchematicObject;
		
	PCSchematicObject = PCSchematicManager->GetSchematicObject(CSchematicComponentInfo.id);
	
	if(!PCSchematicObject) return;

	PCSchematicObject->UpdateSchematicObjectData();
		
	TCPinInfoDlg CPinInfoDlg;

	TCSchematicObjectData CSchematicObjectData, *PCSchematicObjectData;

	PCSchematicObjectData = PCSchematicManager->GetSchematicObjectData(CSchematicComponentInfo.id);
	
	if(!PCSchematicObjectData) return;

	CSchematicObjectData = *PCSchematicObjectData;

	if(CSchematicObjectData.component_property_view_type == E_PROPERTY_CONNECTORS)
	{
		TCConnectorDlg CComponentProperties;
		CComponentProperties.CSchematicObjectData = CSchematicObjectData;

		if(CComponentProperties.DoModal() != IDOK) return;

		CSchematicObjectData = CComponentProperties.CSchematicObjectData;
	}
	else
	{
		CPinInfoDlg.SetData(CSchematicObjectData, CSchematicComponentInfo.pin_id);

		if(CPinInfoDlg.DoModal() != IDOK) return;

		CSchematicObjectData = CPinInfoDlg.GetData();
	}

//	GCSuperSpiceDataBase.CMDefaults[PCSchematicObject->GetType()].Copy(CSchematicObjectData);
	if(PCSchematicObject->m_type != E_WAVEFORM_COMPONENT)// two risky
		GCSuperSpiceDataBase.SetSchematicObjectData(CSchematicObjectData, false);

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		PCSchematicManager->SetSchematicObjectData(CSchematicComponentInfo.id, CSchematicObjectData);

		int type = CSchematicObjectData.type;

		if(type == E_GROUND || type == E_PAGE_CONNECTER_INPUT || type == E_SUBCIRCUIT_PIN_CONNECTER ||
		   type == E_PAGE_CONNECTER_OUTPUT || type == E_PAGE_CONNECTER_BIDIRECTIONAL)
		{
			PCSchematicManager->UpdateNetNamesFromPinNames(CSchematicComponentInfo.id, CSchematicComponentInfo.pin_id);
		}
	}
}

void TCSuperSpiceDoc::InspectSchematicLabelObject(TCSchematicManager *PCSchematicManager, CView *PCView, TCSchematicComponentInfo &CSchematicComponentInfo)
{
	PCView;
	TCSuperSpiceView *PCViewInList;

	TCSchematicObject *PCSchematicObject;
		
	PCSchematicObject = PCSchematicManager->GetSchematicObject(CSchematicComponentInfo.id);

	int label	= CSchematicComponentInfo.label_id;
	int object_type = PCSchematicObject->GetType();
	bool read_only;

	if(object_type == E_WAVEFORM_COMPONENT)
	{
		InspectSchematicWaveformLabelObject(PCSchematicManager, PCView, CSchematicComponentInfo);

		return;
	}

	CString CText = CSchematicComponentInfo.CText;
	CString CTempText;

	TCSchematicObjectData CSchematicObjectDataBase;
	CSchematicObjectDataBase = GCSuperSpiceDataBase.CMDefaults[object_type];

	if(!(label < CSchematicObjectDataBase.CLabelListData.GetSize())) return;
	if(label < 0) return;

//	read_only = !!CSchematicObjectDataBase.CLabelListData[label].read_only;
	read_only = PCSchematicObject->CMSchematicObjectData.CLabelListData[label].read_only;

	int f_update_other_node_names = false;

	if(object_type == E_WIRE_COMPONENT)
	{
		TCWireLableDlg CWireLableDlg;

		CWireLableDlg.m_lable_id	= label;
		CWireLableDlg.CEditWireText = CText;

		if(CWireLableDlg.DoModal() != IDOK) return;
			
		CText = CWireLableDlg.CEditWireText;

		CTempText = CText;

		CTempText.MakeLower();

		f_update_other_node_names = E_UPDATE_OTHER_NODE_NAMES_SET_USER_PREFERED;

		if(CTempText.Find("node") > -1) // only fix real use names, normal net names
		{
			PCSchematicObject->m_user_label_preferred = false;

			PCSchematicObject->CMSchematicObjectData.user_label_preferred = false;

			f_update_other_node_names = false;
		}

	}
	else
	{
	switch(label)
	{
		case E_COMPONENT_VALUE:// And Wire voltage
		{
			if(CSchematicObjectDataBase.f_validate_label_value)
			{
				TCComponentValue CComponentValue;

				if(PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC) read_only = true;

				CComponentValue.CMComponentValue	= CText;
				CComponentValue.read_only			= read_only;
		
				if(CComponentValue.DoModal() != IDOK) return;

				CText = CComponentValue.CMComponentValue;
			}
			else
			{
				TCComponentText CComponentText;

				if(PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC) read_only = true;

				CComponentText.CMEditComponentText	= CText;
				CComponentText.read_only			= read_only;

				if(CComponentText.DoModal() != IDOK) return;

				CText = CComponentText.CMEditComponentText;
			}

		}break;

		case E_COMPONENT_DESIGNATOR:
		{
				TCReferanceDesignator CComponentText;

				CComponentText.CEditReferanceDesignator = CText;

				if(CComponentText.DoModal() != IDOK) return;

				CText = CComponentText.CEditReferanceDesignator;
		}break;

		case E_COMPONENT_SPICE_MODEL_NAME:
		{ //node name
			TCComponentSpiceName CComponentText;

			if(PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC) read_only = true;

			CComponentText.CEditSpiceName	= CText;
			CComponentText.read_only		= read_only;

			if(CComponentText.DoModal() != IDOK) return;

			CText = CComponentText.CEditSpiceName;


		}break;

		case E_COMPONENT_SYMBOL_NAME:
		{//node lable
			TCComponentTypeName CComponentText;

			CComponentText.CEditComponentTypeName	= CText;
			CComponentText.read_only				= read_only;

			if(CComponentText.DoModal() != IDOK) return;

			CText = CComponentText.CEditComponentTypeName;

		}break;

		default:
		{
			if(object_type == E_TITLE_BLOCK)
			{
				TCComponentText CComponentText;

				if(PCSchematicObject->CMSchematicObjectData.attached_model_type == E_SPICE_SCHEMATIC) read_only = true;
				
				CComponentText.CMEditComponentText	= CText;
				CComponentText.read_only			= false;

				if(CComponentText.DoModal() != IDOK) return;

				CText = CComponentText.CMEditComponentText;		
			}
			else return;
/*			{
				TCComponentValue CComponentValue;

				CComponentValue.CMComponentValue	= CText;
				CComponentValue.read_only			= false;
		
				if(CComponentValue.DoModal() != IDOK) return;

				CText = CComponentValue.CMComponentValue;
			}*/
		}
	}
	}
/*
	if(CText == "") CText = " ";// let blamk but displayed ones been seen

	if(!(ext_lable_index < 0))
	{		
		PCSchematicObject->CMSchematicObjectData.CLabelListData[label].CLabelValue = CText;// ignor other views for now!!!

		CText = CPreText + '=' + CText;
	}
*/
	CSchematicObjectDataBase.CLabelListData[label].CLabel = CText;

	GCSuperSpiceDataBase.CMDefaults[object_type].Copy(CSchematicObjectDataBase);

	int page_id = PCSchematicManager->GetPageId();

	POSITION pos = GetFirstViewPosition();

	TCSchematicObjectData CSchematicObjectData;

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		PCSchematicManager->SetLabel(CSchematicComponentInfo.id, CSchematicComponentInfo.label_id, CText, true, f_update_other_node_names);

		PCSchematicObject = PCSchematicManager->GetSchematicObject(CSchematicComponentInfo.id);

		if(label == E_COMPONENT_SPICE_MODEL_NAME)
			PCSchematicObject->CMSchematicObjectData.Rename(CText);

		if(label == E_COMPONENT_DESIGNATOR)
		{
			UpdateChildSchematicRefDesignator(PCSchematicObject->CMSchematicObjectData.CSymbolData.CChildFileName, CText);
		}
		
		if(!PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only)
		{
			PCSchematicObject->CMSchematicObjectData.FormatRecordName();

			PCSchematicObject->FormatLabels();
			//PCSchematicObject->CMSchematicObjectData.FormatSpiceValue();
		}
		// force label updates etc
		CSchematicObjectData = PCSchematicObject->CMSchematicObjectData;

		PCSchematicManager->SetSchematicObjectData(CSchematicComponentInfo.id, CSchematicObjectData);		
	}

	if(label != E_COMPONENT_VALUE) return;

	float value;
	CString CRefDes;
	
	CString CValue = PCSchematicObject->GetLabel(E_COMPONENT_VALUE);

	value = (float) GetTopLevelDoc()->EvaluateComponentValue(CValue);

	switch(PCSchematicObject->CMSchematicObjectData.component_property_view_type)
	{
		case E_PROPERTY_RESISTOR:
		case E_PROPERTY_CAPACITOR:
		case E_PROPERTY_INDUCTOR:

		CRefDes = PCSchematicObject->GetLabel(E_COMPONENT_DESIGNATOR); break;

		default: return;
	}

	ModifyComponentValue(CRefDes, value);
}

void TCSuperSpiceDoc::InspectSchematicWaveformLabelObject(TCSchematicManager *PCSchematicManager, CView *PCView,TCSchematicComponentInfo &CSchematicComponentInfo)
{
	TCSuperSpiceView *PCViewInList = (TCSuperSpiceView *)PCView;
	
	if(!PCViewInList) return;

	if(!PCSchematicManager) return;

	TCSchematicObject *PCSchematicObject;
		
	PCSchematicObject = PCSchematicManager->GetSchematicObject(CSchematicComponentInfo.id);

	int label	= CSchematicComponentInfo.label_id;
	int object_type = PCSchematicObject->GetType();

	CString CText = CSchematicComponentInfo.CText;

	TCSchematicObjectData CSchematicObjectDataBase;
	CSchematicObjectDataBase = GCSuperSpiceDataBase.CMDefaults[object_type];

	if(!(label < CSchematicObjectDataBase.CLabelListData.GetSize())) return;

	switch(label)
	{
		case E_WAVEFORM_PLOT_NAME:
		{
			TCComponentText CComponentText;

			CComponentText.CMEditComponentText	= CText;

			if(CComponentText.DoModal() != IDOK) return;

			CText = CComponentText.CMEditComponentText;

		}break;

		case E_COMPONENT_DESIGNATOR:
		{
				TCReferanceDesignator CComponentText;

				CComponentText.CEditReferanceDesignator = CText;

				if(CComponentText.DoModal() != IDOK) return;

				CText = CComponentText.CEditReferanceDesignator;
		}break;

		case E_WAVEFORM_DATE_AND_TIME:
		{ //node name
			TCComponentText CComponentText;

			CComponentText.CMEditComponentText	= CText;

			if(CComponentText.DoModal() != IDOK) return;

			CText = CComponentText.CMEditComponentText;


		}break;

		case E_WAVEFORM_TITLE:
		{//node lable
			TCComponentText CComponentText;

			CComponentText.CMEditComponentText	= CText;

			if(CComponentText.DoModal() != IDOK) return;

			CText = CComponentText.CMEditComponentText;

		}break;

		default: return;
	}

	CSchematicObjectDataBase.CLabelListData[label].CLabel = CText;

	GCSuperSpiceDataBase.CMDefaults[object_type].Copy(CSchematicObjectDataBase);

	int page_id = PCSchematicManager->GetPageId();

	POSITION pos = GetFirstViewPosition();

	TCSchematicObjectData CSchematicObjectData;

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		PCSchematicManager->SetLabel(CSchematicComponentInfo.id, CSchematicComponentInfo.label_id, CText, true, false);
	
		if(label == E_WAVEFORM_TITLE)
		{

		}
	}
}

void TCSuperSpiceDoc::Print(CView *PCView, CDC *PCDC)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();

	// more to do this is testing
	PCSchematicManager->PrintAll(PCDC);
}

void TCSuperSpiceDoc::InspectSchematicPinLabelObject(TCSchematicManager *PCSchematicManager, CView *PCView, TCSchematicComponentInfo &CSchematicComponentInfo)
{
	PCView;
	TCSuperSpiceView *PCViewInList;
	
	TCSchematicObject *PCSchematicObject;
		
	PCSchematicObject = PCSchematicManager->GetSchematicObject(CSchematicComponentInfo.id);
	
	if(!PCSchematicObject) return;

	int pin	= CSchematicComponentInfo.pin_id;
	int label = CSchematicComponentInfo.label_id;
	int object_type = PCSchematicObject->GetType();
		
	CString CText = CSchematicComponentInfo.CText;

//	TCSchematicObjectData CSchematicObjectDataBase;
//	CSchematicObjectDataBase = GCSuperSpiceDataBase.CMDefaults[object_type];
	
	TCSinglePinLable CComponentText;

	CComponentText.CEditLable = CText;
	CComponentText.m_lable_id = label;
	
	if(CComponentText.DoModal() != IDOK) return;

	CText = CComponentText.CEditLable;

	CText.TrimLeft();
	CText.TrimRight();

	if(object_type == E_SUBCIRCUIT_PIN_CONNECTER)
	{
		if(CText.GetAt(0) == 'v' || CText.GetAt(0) == 'V' || CText.GetAt(0) == '+' || CText.GetAt(0) == '-')
		{
			AfxMessageBox(IDS_V_NOT_ALLOWED_SUBCKT);

			CText.SetAt(0, 's');
		}
	}
		
	int page_id = PCSchematicManager->GetPageId();

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		PCSchematicManager->SetPinLabel(CSchematicComponentInfo.id, pin, label, CText, true);
	}

	if(PCSchematicObject->m_type == E_SUBCIRCUIT_PIN_CONNECTER && PCParentSuperSpiceDoc)
	{
		int pin_id = (int)SpiceMKSStringToFloat(PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel);

		pin_id = SetSymbolPinName(pin_id, CText);

		if(pin_id > -1)// No id found, if name found, change id
		{
			PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel.Format("%d", pin_id);
			//redraw
			PCSchematicManager->SetSchematicObjectData(CSchematicComponentInfo.id, PCSchematicObject->CMSchematicObjectData);
		}
	}

	else if(PCSchematicObject->m_type == E_SUBCIRCUIT_COMPONENT)
	{
		CString CFileName = PCSchematicObject->CMSchematicObjectData.CSymbolData.CFilePath + PCSchematicObject->CMSchematicObjectData.CSymbolData.CFileName;

		if(CFileName != "") SetSchematicPinNames(PCSchematicObject);
	}
}

int TCSuperSpiceDoc::SetSymbolPinName(int pin_id, CString CText)
{
	if(!PCParentSuperSpiceDoc)	return -2;
	if(pin_id < 0)				return -2;
	if(CParentRefDes == "")		return -2;//should not happen

	TCSchematicObject *PCSchematicObject = PCParentSuperSpiceDoc->FindSchematicObject(CParentRefDes);

	if(!PCSchematicObject) 
	{
		DisplayError(IDS_ERR_WARNING, IDS_NO_SCH_SYM_FOUND);

		return -2;
	}

	CString CSymbolName, CSymbolFileName;

	CSymbolFileName = PCSchematicObject->CMSchematicObjectData.CSymbolData.CFilePath + PCSchematicObject->CMSchematicObjectData.CSymbolData.CFileName;

	if(CSymbolFileName == "") return -2;

	CSymbolName = PCSchematicObject->CMSchematicObjectData.CSymbolData.CName;

	if(CSymbolName == "") return -2;

	SetAllSymbolsPinName(CSymbolFileName, CSymbolName, pin_id, CText);

	int value =  GCSuperSpiceDataBase.SetSymbolPinName(CSymbolFileName, CSymbolName, pin_id, CText);

	if(value == -2) DisplayError(IDS_ERR_WARNING, IDS_SYM_NOT_INDB);

	return value;
}

int TCSuperSpiceDoc::SetAllSymbolsPinName(CString CSymbolFileName, CString CSymbolName, int pin_id, CString CText)
{
	// Set data base symbol pin name
	// Set all other symbols pin name on schematic

	TCSchematicObject *PCSchematicObject;
	TCSchematicManager *PCSchematicManager;
	CString CFileName;

	int value = -2;
	int number_of_pins;
	CString CPinName;

	TCSuperSpiceDoc *PSpiceDoc = PCParentSuperSpiceDoc;

	if(!PSpiceDoc) PSpiceDoc = this;

	int count = PSpiceDoc->CMUniqueSchematicManagerList.GetSize();

	CSymbolFileName.MakeLower();
	CSymbolName.MakeLower();

	for(int p = 0; p < count; p++)
	{
		PCSchematicManager = PSpiceDoc->CMUniqueSchematicManagerList[p];

		CArray <TCSchematicObject *, TCSchematicObject *> &CGraphicList = PCSchematicManager->CMSchematicManagerData.CGraphicList;
		
		int scount = CGraphicList.GetSize();

		for(int q = 0; q < scount; q++)
		{
			PCSchematicObject = CGraphicList[q];

			if(PCSchematicObject->m_type != E_SUBCIRCUIT_COMPONENT) continue;

			CFileName = PCSchematicObject->CMSchematicObjectData.CSymbolData.CFilePath + PCSchematicObject->CMSchematicObjectData.CSymbolData.CFileName;
			 
			if(CFileName == "") continue;

			CFileName.MakeLower();

			if(CSymbolFileName != CFileName) continue;

			CFileName = PCSchematicObject->CMSchematicObjectData.CSymbolData.CName;

			CFileName.MakeLower();

			if(CSymbolName != CFileName) continue;

			number_of_pins = PCSchematicObject->GetNumberOfPins();

			if(!(pin_id < number_of_pins)) //check if pin id exists, if not return id for same name pin 
			{
				CText.MakeLower();

				for(int r =0; r < number_of_pins; r++)
				{
					CPinName = PCSchematicObject->CMSchematicObjectData.CPinListData[r].CLabelListData[E_COMPONENT_PIN_NAME].CLabel;

					CPinName.MakeLower();

					if(CPinName == CText)
					{
						value = r;

						break;
					}
				}

			}
			else PCSchematicManager->SetPinLabel(q, pin_id, E_COMPONENT_PIN_NAME, CText);		
		}
	}

	return value;
}


void TCSuperSpiceDoc::SetSchematicPinNames(TCSchematicObject *PCSchematicObject)
{
	if(!PCSchematicObject) return;

	CString CFileName = PCSchematicObject->CMSchematicObjectData.CSymbolData.CChildFileName;

	TCSuperSpiceDoc *PCSuperSpiceDoc;

	bool flag_is_open = false;
	
	PCSuperSpiceDoc = (TCSuperSpiceDoc*) CDocumentWindowsList.IsOpen(CFileName);

	if(PCSuperSpiceDoc) flag_is_open = true;

	CArray <CString, CString&> CRefIDList;//dummys
	CString CRefDes;

	CMultiDocTemplate *PCMultiDocTemplate = (CMultiDocTemplate *)GetDocTemplate();

	if(!PCMultiDocTemplate) return;

	if(!PCSuperSpiceDoc)
	{
		if(!FileExists(CFileName)) return;

		PCSuperSpiceDoc = (TCSuperSpiceDoc *)PCMultiDocTemplate->OpenDocumentFile(CFileName, false);// invisable

		if(!PCSuperSpiceDoc) return;
	
		PCSuperSpiceDoc->SetParent(this, CThisFileName, CRefIDList, CRefDes);

	}

// Now do the stuff
	//PCSchematicObject source pin labels

///
	PCSuperSpiceDoc->GenerateUniqueSchematicManagers();

	int count = PCSuperSpiceDoc->CMUniqueSchematicManagerList.GetSize();

	CRefDes.MakeLower();

	CString CText;
	int		pin_id;
	CString CPinID;

	int pin_count;

	pin_count = PCSchematicObject->CMSchematicObjectData.CPinListData.GetSize();

	for(int p = 0; p < count; p++)
	{
		TCSchematicManager *PCSchematicManager = PCSuperSpiceDoc->CMUniqueSchematicManagerList[p];

		CArray <TCSchematicObject *, TCSchematicObject *> &CGraphicList = PCSchematicManager->CMSchematicManagerData.CGraphicList;
		
		int scount = CGraphicList.GetSize();

		for(int q = 0; q < scount; q++)
		{
			TCSchematicObject *PCSchematicConnector = CGraphicList[q];

			if(PCSchematicConnector->m_type != E_SUBCIRCUIT_PIN_CONNECTER) continue;

			pin_id = (int)SpiceMKSStringToFloat(PCSchematicConnector->CMSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel);

			if(!(pin_id < pin_count)) continue;// if

			CText = PCSchematicObject->CMSchematicObjectData.CPinListData[pin_id].CLabelListData[E_COMPONENT_PIN_NAME].CLabel;
	
			PCSchematicManager->SetPinLabel(q, 0, E_COMPONENT_PIN_NET_NAME, CText, true);
		}
	}	


	PCSuperSpiceDoc->OnSaveDocument(CFileName);

	if(!flag_is_open)PCSuperSpiceDoc->OnCloseDocument();
}

void TCSuperSpiceDoc::OnEditFindOnSchematic(CView *PCView)
{
	if(PCMSearchOnSchematicDlg->DoModal() != IDOK) return;

	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();

	if(!PCSchematicManager) return;

	PCSchematicManager->ResetSelectAll(true);

	CArray <TCSchematicObject *, TCSchematicObject *> &CGraphicList = PCSchematicManager->CMSchematicManagerData.CGraphicList;
		
	int scount = CGraphicList.GetSize();
	int name_type = E_COMPONENT_DESIGNATOR;

	CString CSymbolText;
	CString CSearchText = PCMSearchOnSchematicDlg->CSearchText;

	CSearchText.MakeLower();
	CSearchText.TrimLeft();
	CSearchText.TrimRight();

	CString CMsg;
	CString CPosition;

	bool found = false;

	switch(PCMSearchOnSchematicDlg->m_search_type)
	{
		case E_FIND_ON_SCHEMATIC_SYMBOL:	name_type = E_COMPONENT_SYMBOL_NAME;break;
		case E_FIND_ON_SCHEMATIC_VALUE:		name_type = E_COMPONENT_VALUE;break;
		case E_FIND_ON_SCHEMATIC_MODEL:		name_type = E_COMPONENT_SPICE_MODEL_NAME;break;
		case E_FIND_ON_SCHEMATIC_REF_DES:	name_type = E_COMPONENT_DESIGNATOR;break;
		case E_FIND_ON_SCHEMATIC_NET_NAME:	name_type = E_WIRE_NET_NAME;break;
	}

	for(int q = 0; q < scount; q++)
	{
		TCSchematicObject *PCSchematicObject = CGraphicList[q];

		if(PCMSearchOnSchematicDlg->m_search_type == E_FIND_ON_SCHEMATIC_NET_NAME)
		{
			if(CGraphicList[q]->m_type != E_WIRE_COMPONENT) continue;
		}
		else if(CGraphicList[q]->m_type == E_WIRE_COMPONENT) continue;

		CSymbolText = PCSchematicObject->CMSchematicObjectData.CLabelListData[name_type].CLabel;
		
		CSymbolText.MakeLower();

		if(PCMSearchOnSchematicDlg->m_search_method == E_FIND_ON_SCHEMATIC_EXACT_TEXT)
		{
			if(CSymbolText != CSearchText) continue;
		}
		else
		{
			if(CSymbolText.Find(CSearchText) < 0) continue;
		}

		PCSchematicManager->SetSelect(q, false);

		found = true;
	}

	if(!found) DisplayError(IDS_SEARCH_RESULTS, IDS_NO_TEXT_MATCH);
}

TCSchematicObject *TCSuperSpiceDoc::FindSchematicObject(CString CRefDes, TCSchematicManager **PCSchematicManagerFound)
{
	TCSchematicManager *PCSchematicManager;
	CString CText;

	GenerateUniqueSchematicManagers();

	int count = CMUniqueSchematicManagerList.GetSize();

	CRefDes.MakeLower();

	for(int p = 0; p < count; p++)
	{
		PCSchematicManager = CMUniqueSchematicManagerList[p];

		CArray <TCSchematicObject *, TCSchematicObject *> &CGraphicList = PCSchematicManager->CMSchematicManagerData.CGraphicList;
		
		int scount = CGraphicList.GetSize();

		for(int q = 0; q < scount; q++)
		{
			CText = CGraphicList[q]->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;
			 
			CText.MakeLower();

			if(CText != CRefDes) continue;
				
			if(PCSchematicManagerFound) *PCSchematicManagerFound = PCSchematicManager;
				
			return CGraphicList[q];
		}
	}

	if(PCSchematicManagerFound) *PCSchematicManagerFound = NULL;

	return NULL;
}

int TCSuperSpiceDoc::GetNumberOfSubCktConnectors(void)
{
	int number = 0;
	TCSchematicManager *PCSchematicManager;

	GenerateUniqueSchematicManagers();

	int count = CMUniqueSchematicManagerList.GetSize();

	for(int p = 0; p < count; p++)
	{
		PCSchematicManager = CMUniqueSchematicManagerList[p];

		CArray <TCSchematicObject *, TCSchematicObject *> &CGraphicList = PCSchematicManager->CMSchematicManagerData.CGraphicList;
		
		int scount = CGraphicList.GetSize();

		for(int q = 0; q < scount; q++)
		{
			if(CGraphicList[q]->m_type != E_SUBCIRCUIT_PIN_CONNECTER) continue;
			 
			number++;
		}
	}

	return number;
}

CString TCSuperSpiceDoc::GetNewSubcktID(void)
{
	CString CSubCktID;

	TCSchematicManager *PCSchematicManager;

	GenerateUniqueSchematicManagers();

	int manager_count = CMUniqueSchematicManagerList.GetSize();

	CString CPinID;
	int pin_id;
	bool flag;

	int r;

	for(r = 0; r < 4096; r++)//large number to prevent lockup on errors
	{
		flag = false;

		for(int p = 0; p < manager_count; p++)// search all connectores for the first missing r value
		{
			PCSchematicManager = CMUniqueSchematicManagerList[p];

			CArray <TCSchematicObject *, TCSchematicObject *> &CGraphicList = PCSchematicManager->CMSchematicManagerData.CGraphicList;
		
			int scount = CGraphicList.GetSize();

			for(int q = 0; q < scount; q++)
			{
				if(CGraphicList[q]->m_type != E_SUBCIRCUIT_PIN_CONNECTER) continue;
			 
				CPinID = CGraphicList[q]->CMSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel;
		
				if(CPinID == "#") continue;

				pin_id = (int)SpiceMKSStringToFloat(CPinID);

				if(r == pin_id)
				{
					flag = true;

					break;
				}
			}

			if(flag)break;
		}

		if(!flag) break;// no match found, therefor ok to use.
	}

	CSubCktID.Format("%d", r);

	return CSubCktID;
}

void TCSuperSpiceDoc::SetSubCktID(TCSchematicManager *PCSchematicManager, TCSchematicObject *PCSchematicObject, CString CID)
{
	if(!PCSchematicObject) return;
	if(!PCSchematicManager) return;

	int id = PCSchematicManager->FindGraphicId(PCSchematicObject);

	if(id < 0) return;

	PCSchematicManager->SetLabel(id, E_COMPONENT_VALUE, CID, true);
}

void TCSuperSpiceDoc::GetAndSetSubCktID(TCSchematicManager *PCSchematicManager, CString CRefDes)
{
	if(CRefDes == "") return;
	if(!PCSchematicManager) return;

	TCSchematicObject *PCSchematicObject = FindSchematicObject(CRefDes);

	if(!PCSchematicObject) return;

	if(PCSchematicObject->m_type != E_SUBCIRCUIT_PIN_CONNECTER)return;

	CString CSubCktID = GetNewSubcktID();

	SetSubCktID(PCSchematicManager, PCSchematicObject, CSubCktID);
}

void TCSuperSpiceDoc::GetAndSetSubCktID(TCSchematicManager *PCSchematicManager, TCSchematicObject *PCSchematicObject)
{
	if(!PCSchematicObject) return;
	if(!PCSchematicManager) return;

	if(PCSchematicObject->m_type != E_SUBCIRCUIT_PIN_CONNECTER)return;

	CString CSubCktID = GetNewSubcktID();

	SetSubCktID(PCSchematicManager, PCSchematicObject, CSubCktID);
}

void TCSuperSpiceDoc::SetAllSubCktIDs(void)
{
	TCSchematicManager *PCSchematicManager;
	TCSchematicObject *PCSchematicObject;

	GenerateUniqueSchematicManagers();
	CString CPinID, CID;

	CDC CDCTemp;

	if(!CDCTemp.CreateCompatibleDC(NULL)) return;

	int count = CMUniqueSchematicManagerList.GetSize();

	for(int p = 0; p < count; p++)
	{
		PCSchematicManager = CMUniqueSchematicManagerList[p];

		CArray <TCSchematicObject *, TCSchematicObject *> &CGraphicList = PCSchematicManager->CMSchematicManagerData.CGraphicList;
		
		int scount = CGraphicList.GetSize();

		for(int q = 0; q < scount; q++)
		{
			PCSchematicObject = CGraphicList[q];

			if(PCSchematicObject->m_type != E_SUBCIRCUIT_PIN_CONNECTER) continue;
			 
			CPinID = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel;

			if(CPinID != "#") continue;

			GetAndSetSubCktID(PCSchematicManager, PCSchematicObject);
		}
	}
}

bool TCSuperSpiceDoc::IsSubCktIDValid(CString CID)
{
	int id = (int)SpiceMKSStringToFloat(CID);

	if(id < 0) return false;

	int count = GetNumberOfSubCktConnectors();

	if((!(id < count)))return false;

	TCSchematicManager *PCSchematicManager;

	GenerateUniqueSchematicManagers();

	int manager_count = CMUniqueSchematicManagerList.GetSize();

	CString CPinID;
	int pin_id;

	for(int p = 0; p < manager_count; p++)
	{
		PCSchematicManager = CMUniqueSchematicManagerList[p];

		CArray <TCSchematicObject *, TCSchematicObject *> &CGraphicList = PCSchematicManager->CMSchematicManagerData.CGraphicList;
		
		int scount = CGraphicList.GetSize();

		for(int q = 0; q < scount; q++)
		{
			if(CGraphicList[q]->m_type != E_SUBCIRCUIT_PIN_CONNECTER) continue;
			 
			CPinID = CGraphicList[q]->CMSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel;
		
			pin_id = (int)SpiceMKSStringToFloat(CID);

			if(pin_id == id) return false;
		}
	}

	return true;
}

bool TCSuperSpiceDoc::GetSchematicTestPoints(CArray <TCTestPointData, TCTestPointData&> &CTestPointDataList)
{
	TCSchematicManager *PCSchematicManager;

	int count = CMUniqueSchematicManagerList.GetSize();

	bool flag = false;
	int test_point_count;
	bool f_found;

	TCSchematicObject *PCSchematicObject;

	TCTestPointData CTestPointData;

	for(int p = 0; p < count; p++)
	{
		PCSchematicManager = CMUniqueSchematicManagerList[p];

		CArray <TCSchematicObject *, TCSchematicObject *> &CGraphicList = PCSchematicManager->CMSchematicManagerData.CGraphicList;
		
		int scount = CGraphicList.GetSize();

		for(int q = 0; q < scount; q++)
		{
			PCSchematicObject = CGraphicList[q];
			 
			if(PCSchematicObject->m_type != E_TEST_MARKER)continue;

			flag = true;

			CTestPointData.CNew		= PCSchematicObject->GetPinLabel(0, E_COMPONENT_PIN_NET_NAME);
			CTestPointData.new_type = PCSchematicObject->CMSchematicObjectData.version;
			CTestPointData.CNew.MakeLower();
			CTestPointData.COld = "";
			CTestPointData.version = CTestPointData.new_type;
			CTestPointData.update_graph_views = true;

			// dont add twice
			test_point_count = CTestPointDataList.GetSize();
			f_found = false;

			for(int r = 0; r < test_point_count; r++)
			{
				if(CTestPointDataList[r].CNew !=  CTestPointData.CNew) continue;

				f_found = true;

				break;
			}

			if(!f_found) CTestPointDataList.Add(CTestPointData);	
		}
	}

	return flag;
}

void TCSuperSpiceDoc::OnViewSetZoomCenter(CView *PCView, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSchematicManager *PCSchematicManager;

	PCSchematicManager = PCSuperSpiceView->GetSchematicManager();

	if(!PCSchematicManager) return;

	CPoint	CScrollOrigin	= PCSuperSpiceView->GetScrollBarPosition();
	float	zoom			= PCSchematicManager->GetZoom();

	CMousePosition.x = 	(int)((CMousePosition.x + CScrollOrigin.x) / zoom);
	CMousePosition.y = 	(int)((CMousePosition.y + CScrollOrigin.y) / zoom);

	PCSchematicManager->SetZoomCenter(CMousePosition);
}

void TCSuperSpiceDoc::OnViewZoomIn(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSchematicManager *PCSchematicManager;

	PCSchematicManager = PCSuperSpiceView->GetSchematicManager();

	if(!PCSchematicManager) return;

	float zoom = PCSchematicManager->GetZoom();

	if(zoom >= 4.0 ) return;

	if(PCSchematicManager->zoom_index > GCSuperSpiceGlobalData.max_index - 1) return;

	PCSchematicManager->zoom_index++;

	CPoint CCurrentOrigin = PCSuperSpiceView->GetScrollBarPosition();	

	float zoom_t = GCSuperSpiceGlobalData.ZoomArray[PCSchematicManager->zoom_index];
//	PCSchematicManager->SetZoom(zoom * GCSuperSpiceGlobalData.CGeneric.zoom_scale_rate_facter);
	PCSchematicManager->SetZoom(zoom_t);

	zoom = PCSchematicManager->GetZoom();

	CPoint CZoomCenter = PCSchematicManager->GetZoomCenter();

	CZoomCenter.x = (int)(CZoomCenter.x * zoom); // Zoom about current center
	CZoomCenter.y = (int)(CZoomCenter.y * zoom);

	CRect WindowData;

	PCView->GetClientRect(&WindowData);

	int width = WindowData.Width();
	int height = WindowData.Height();

	CCurrentOrigin.x =  CZoomCenter.x - width / 2;
	CCurrentOrigin.y =  CZoomCenter.y - height / 2;

	PCSuperSpiceView->SetScrollBarPosition(CCurrentOrigin);
	PCSchematicManager->SetScrollBarPosition(CCurrentOrigin);

	PCSchematicManager->Zoom(zoom, PCSuperSpiceView->GetState());
	PCSchematicManager->DrawAll();
}

bool TCSuperSpiceDoc::OnViewCheckZoomIn(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSchematicManager *PCSchematicManager;

	PCSchematicManager = PCSuperSpiceView->GetSchematicManager();

	if(!PCSchematicManager) return false;

	if(PCSchematicManager->zoom_index > GCSuperSpiceGlobalData.max_index) return false;
	if(PCSchematicManager->GetZoom() >= 4.0 ) return false;

	return true;
}
void TCSuperSpiceDoc::OnViewZoomOut(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSchematicManager *PCSchematicManager;

	PCSchematicManager = PCSuperSpiceView->GetSchematicManager();

	if(!PCSchematicManager) return;

	float zoom = PCSchematicManager->GetZoom();

	if(zoom <= 1.0/16.0) return;

	if(PCSchematicManager->zoom_index < 1) return;

	PCSchematicManager->zoom_index--;

	CPoint CCurrentOrigin = PCSuperSpiceView->GetScrollBarPosition();

//	PCSchematicManager->SetZoom(zoom / GCSuperSpiceGlobalData.CGeneric.zoom_scale_rate_facter);

	float zoom_t = GCSuperSpiceGlobalData.ZoomArray[PCSchematicManager->zoom_index];

	PCSchematicManager->SetZoom(zoom_t);

	zoom = PCSchematicManager->GetZoom();
 
	CPoint CZoomCenter =  PCSchematicManager->GetZoomCenter();
  
	CZoomCenter.x = (int)(CZoomCenter.x * zoom); // Zoom about current center
	CZoomCenter.y = (int)(CZoomCenter.y * zoom);

	CRect WindowData;

	PCView->GetClientRect(&WindowData);

	int width = WindowData.Width();
	int height = WindowData.Height();

	CCurrentOrigin.x =  CZoomCenter.x - width / 2;
	CCurrentOrigin.y =  CZoomCenter.y - height / 2;

	PCSuperSpiceView->SetScrollBarPosition(CCurrentOrigin);
	PCSchematicManager->SetScrollBarPosition(CCurrentOrigin);

	PCSchematicManager->Zoom(zoom, PCSuperSpiceView->GetState());
	
	PCSchematicManager->DrawAll();
}

bool TCSuperSpiceDoc::OnViewCheckZoomOut(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSchematicManager *PCSchematicManager;

	PCSchematicManager = PCSuperSpiceView->GetSchematicManager();

	if(!PCSchematicManager) return false;

	if(PCSchematicManager->zoom_index < 0) return false;
	if(PCSchematicManager->GetZoom() <= 1.0/16.0) return false;

	return true;
}

void TCSuperSpiceDoc::OnViewZoomCenter(CView *PCView, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;
	TCSchematicManager *PCSchematicManager;

	PCSchematicManager = PCSuperSpiceView->GetSchematicManager();

	if(!PCSchematicManager) return;

	CPoint COrigin = PCSuperSpiceView->GetScrollBarPosition();

	CRect WindowData;

	PCView->GetClientRect(&WindowData);

	int width = WindowData.Width();
	int height = WindowData.Height();

	CMousePosition.x =  CMousePosition.x - width / 2;
	CMousePosition.y =  CMousePosition.y - height / 2;

	COrigin.x = COrigin.x + CMousePosition.x;
	COrigin.y = COrigin.y + CMousePosition.y;

	PCSuperSpiceView->SetScrollBarPosition(COrigin);
	PCSchematicManager->SetScrollBarPosition(COrigin);

	PCSchematicManager->DrawAll();
}


void TCSuperSpiceDoc::InitaliseAnalysisSetup(void)
{
	UpdateAllNets(false);

	//CMSuperSpiceDocData.PCAnalysisSetup will be modified here
	if(!PCMNetList->InitaliseAnalysisSetup(CMUniqueSchematicManagerList, *CMSuperSpiceDocData.PCAnalysisSetup, CParentRefDes))
	{
		CGlobalStatusMessage = E_STATUS_MSG_ANALYSIS_INIT_FAILED;
		// Pop up error report
		return;
	}

	PCMNetList->RestoreToSubcktNets();//added 22nd may 2002

	UpdateAllSchematics();
}

void TCSuperSpiceDoc::GenerateUniqueSchematicManagers(void)
{
	TCSchematicManager *PCSchematicManager;
	CArray <int, int> Cid;
	int id;
	bool flag = false;

	CMUniqueSchematicManagerList.SetSize(0);

	int count = CSchematicManagerList.GetSize();

	for(int p = 0; p < count; p++)
	{
		PCSchematicManager = CSchematicManagerList[p];

		id = PCSchematicManager->GetPageId();
		
		int count2 = Cid.GetSize();

		for(int q = 0; q < count2; q++)
		{
			if(id == Cid[q] && PCSchematicManager)
			{
				flag = true;
				break;
			}
		}

		if(!flag) 
		{
			Cid.Add(id);
			CMUniqueSchematicManagerList.Add(PCSchematicManager);
		}
		flag = false;
	}
}
void TCSuperSpiceDoc::EraseComponentOutline(void)
{
	TCSuperSpiceView *PCViewInList;
	TCSchematicManager *PCSchematicManager;

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCSchematicManager->EraseComponentOutline();

		PCSchematicManager->DrawAll();
	}
}

void TCSuperSpiceDoc::UpdateAllSchematics(void)
{
	TCSuperSpiceView	*PCViewInList;
	TCSchematicManager *PCSchematicManager;
	TCSchematicManager *PCSchematicManagerNew;
	POSITION pos;

	int count = CMUniqueSchematicManagerList.GetSize();

	for(int p = 0; p < count; p++)
	{
		PCSchematicManager = CMUniqueSchematicManagerList[p];

		pos = GetFirstViewPosition();

		while (pos != NULL)
		{
			PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

			PCSchematicManagerNew = PCViewInList->GetSchematicManager();

			if(!PCSchematicManagerNew) continue;

			if(PCSchematicManager == PCSchematicManagerNew) 
			{
				PCSchematicManagerNew->DrawAll();

				continue;
			}
			if(PCSchematicManager->GetPageId() != PCSchematicManagerNew->GetPageId()) continue;

			*PCSchematicManagerNew = *PCSchematicManager;

			PCSchematicManagerNew->SetView(PCViewInList);// restore original view

			PCSchematicManagerNew->DrawAll();
		}
	}
}

TCSuperSpiceDoc	*TCSuperSpiceDoc::GetTopLevelDoc(void)
{
	TCSuperSpiceDoc	*PCSuperSpiceDoc;
	TCSuperSpiceDoc	*PCSuperSpiceTestDoc;

	if(!PCParentSuperSpiceDoc) return this;

	PCSuperSpiceTestDoc = PCParentSuperSpiceDoc;

	if(PCSuperSpiceTestDoc)
	if(IsBadReadPtr(PCSuperSpiceTestDoc, sizeof(TCSuperSpiceDoc))) 
	{
		ASSERT(0);

		PCParentSuperSpiceDoc = NULL;

		return this;
	}

	while(PCSuperSpiceTestDoc)
	{
		PCSuperSpiceDoc = PCSuperSpiceTestDoc->PCParentSuperSpiceDoc;

		if(!PCSuperSpiceDoc)  return PCSuperSpiceTestDoc;

		if(IsBadReadPtr(PCSuperSpiceDoc, sizeof(TCSuperSpiceDoc))) 
		{
			ASSERT(0);

			PCSuperSpiceTestDoc->PCParentSuperSpiceDoc = NULL;

			return NULL;
		}

		PCSuperSpiceTestDoc = PCSuperSpiceDoc;
	}

	ASSERT(0);

	return this;
}

bool TCSuperSpiceDoc::GetWaveformFileType(void)
{
	return false;
}

void TCSuperSpiceDoc::OnViewSimulationSetup()
{
	TCSuperSpiceDoc	*PCToplevelDoc = GetTopLevelDoc();

	if(!PCToplevelDoc) return;// program fault

	PCSuperSpiceDocLastFocused = PCToplevelDoc;// added to get calculate in tran averages to work

	TCSimulationSetup CSimulationSetup;
	
	InitaliseAnalysisSetup();

	TCAnalysisSetup &CAnalysisSetup = *CMSuperSpiceDocData.PCAnalysisSetup;
	CSimulationSetup.CAnalysisSetup = CAnalysisSetup;

	// need to get/overwrite top level simulation setup data for some of the data

	CSimulationSetup.CAnalysisSetup.CopyGlobal(*PCToplevelDoc->CMSuperSpiceDocData.PCAnalysisSetup);

	if(CSimulationSetup.DoModal() == IDOK)
	{
		*CMSuperSpiceDocData.PCAnalysisSetup = CSimulationSetup.CAnalysisSetup;

		PCToplevelDoc->CMSuperSpiceDocData.PCAnalysisSetup->CopyGlobal(CSimulationSetup.CAnalysisSetup);

		TCBerklySpiceOptionsSetupData CBerklySpiceOptionsSetupData = GCSuperSpiceGlobalData.CAnalysisSetup.CBerklySpiceOptionsSetupData;
		TCParametricSetupData CParametricSetupData = GCSuperSpiceGlobalData.CAnalysisSetup.CParametricSetupData;

//		GCSuperSpiceGlobalData.CAnalysisSetup = *CMSuperSpiceDocData.PCAnalysisSetup; // Aug 2016, more trouble than worth

		// keep data base copy with the same options always.
//		GCSuperSpiceGlobalData.CAnalysisSetup.CBerklySpiceOptionsSetupData = CBerklySpiceOptionsSetupData;
//		GCSuperSpiceGlobalData.CAnalysisSetup.CParametricSetupData = CParametricSetupData;

	}

	SetupWaveformAnalyisisData();

	EraseComponentOutline();
}

TCAnalysisSetup	&TCSuperSpiceDoc::GetAnalysisSetup(void)
{
	if(!this)
	{
		return CAnalysisSetupDebug;
	}

	return *CMSuperSpiceDocData.PCAnalysisSetup;
}

void TCSuperSpiceDoc::RegenerateSchematicDocumentsWindowList(bool auto_delete)
{
	int mcount, scount, p, q;// auto deletes remove the schematic from view
	CString CText;

	TCSchematicManager *PCSchematicManager;

	if(auto_delete) CDocumentWindowsList.RemoveAllSchematicDocuments(false);// dont close open docs

	GenerateUniqueSchematicManagers();

	mcount = CMUniqueSchematicManagerList.GetSize();

	CString CNewRefId;
	CString CRefID;

	CArray <CString, CString&> CNewRefIdList;

	for(p = 0; p < mcount; p++)
	{
		PCSchematicManager = CMUniqueSchematicManagerList[p];
		
		CArray <TCSchematicObject *, TCSchematicObject *> &CGraphicList = PCSchematicManager->CMSchematicManagerData.CGraphicList;
		
		scount = CGraphicList.GetSize();

		for(q = 0; q < scount; q++)
		{
			CText = CGraphicList[q]->CMSchematicObjectData.CSymbolData.CChildFileName;
			 
			if(CText == "") continue;

			if(!FileExists(CText))
			{
				CText = GetRelativeFileName(CText);

				if(FileExists(CText))
					CGraphicList[q]->CMSchematicObjectData.CSymbolData.CChildFileName = CText;// update
			}

			CRefID = CGraphicList[q]->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;
			
			CreateRefDesList(CNewRefIdList, CRefID);// sets up member CParentRefIDList

			CNewRefId = GetNewRefDes(CRefID);

			// Create leaves intact existing data for the same file name
			CDocumentWindowsList.CreateSchematic(CText, this, CNewRefIdList, CNewRefId);
		}
	}

	RefreshWorkSpaceWindow();
}

CString	TCSuperSpiceDoc::GetNewRefDes(CString CRefDes)// needed for probing wires
{
	if(CParentRefDes == "") return CRefDes;

	CString CNewRefId;

	CNewRefId = CParentRefDes + ':' + CRefDes;

	return CNewRefId;
}

void TCSuperSpiceDoc::CreateRefDesList(CArray <CString, CString&> &CNewRefIdList, CString CRefID)
{
	int p, des_count, q;

	CArray <CString, CString&> CRefDesList;

	GetRefDesList(CRefDesList, CRefID);// scan all componets for same subcircuit type

	des_count = CRefDesList.GetSize();

	CNewRefIdList.SetSize(des_count, 128);

	CString CText;

	CString CNewRefId;
	
	int parent_count = CParentRefIDList.GetSize();

	if(!parent_count)// i.e toplevel only
	{
		for(p = 0; p < des_count; p++)
		{
			CText = CRefDesList[p];

//			CText.Remove('X');// temp testing

			CNewRefIdList[p] = CText;
		}

		return;
	}

	CNewRefIdList.SetSize(0, 128);

	for(p = 0; p < parent_count; p++)// need recusive function again to do
	{
		for(q = 0; q < des_count; q++)
		{
			CText = CParentRefIDList[p] + ':' + CRefDesList[q];//eg. subcircuit X34.X53

//			CText.Remove('X');// temp testing

			CNewRefIdList.Add(CText);
		}
	}
}

void TCSuperSpiceDoc::GetRefDesList(CArray <CString, CString&> &CRefDesList)
{
	GenerateUniqueSchematicManagers();

	TCSchematicManager *PCSchematicManager;
	int component_count;

	int count = CMUniqueSchematicManagerList.GetSize();

	CString CText;

	CRefDesList.SetSize(0, 128);
	int type;

	for(int p = 0; p < count; p++)
	{
		PCSchematicManager = CMUniqueSchematicManagerList[p];

		CArray <TCSchematicObject *, TCSchematicObject *> &CGraphicList = PCSchematicManager->CMSchematicManagerData.CGraphicList;
		
		component_count = CGraphicList.GetSize();

		for(int q = 0; q < component_count; q++)
		{
			type = CGraphicList[q]->CMSchematicObjectData.type;

			if(type)
			if(type < E_DC_VOLTAGE_SOURCE || type == E_TITLE_BLOCK) continue;

			CText = CGraphicList[q]->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

			CRefDesList.Add(CText);
		}
	}
}

void TCSuperSpiceDoc::GetRefDesList(CArray <CString, CString&> &CRefDesList, CString CRefID)
{
	GenerateUniqueSchematicManagers();

	TCSchematicManager *PCSchematicManager;
	int component_count;

	int count = CMUniqueSchematicManagerList.GetSize();

	CRefDesList.SetSize(0, 128);

	CString CText;
	CString CFileName;

	int p;

	for(p = 0; p < count; p++)// first find schematic attached to refdes passed in, I should have passed this through!
	{
		PCSchematicManager = CMUniqueSchematicManagerList[p];

		CArray <TCSchematicObject *, TCSchematicObject *> &CGraphicList = PCSchematicManager->CMSchematicManagerData.CGraphicList;
		
		component_count = CGraphicList.GetSize();

		for(int q = 0; q < component_count; q++)
		{
			CText = CGraphicList[q]->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

			if(CRefID != CText) continue;

			CFileName = CGraphicList[q]->CMSchematicObjectData.CSymbolData.CChildFileName;
		}
	}

	if(CFileName == "") return;// should not accur;

	for(p = 0; p < count; p++)// now  find all refs attached to this schematic
	{
		PCSchematicManager = CMUniqueSchematicManagerList[p];

		CArray <TCSchematicObject *, TCSchematicObject *> &CGraphicList = PCSchematicManager->CMSchematicManagerData.CGraphicList;
		
		component_count = CGraphicList.GetSize();

		for(int q = 0; q < component_count; q++)
		{
			CText = CGraphicList[q]->CMSchematicObjectData.CSymbolData.CChildFileName;

			if(CText == "") continue;
			if(CFileName != CText) continue;

			CText = CGraphicList[q]->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

			CRefDesList.Add(CText);
		}
	}
}

void TCSuperSpiceDoc::UpdateChildSchematicRefDesignator(CString CFileName, CString CNewRefDes)
{
	int				p, count;

	TCSuperSpiceDoc *PCDoc;
	CString			CNewRefId;

	CArray <CString, CString&> CNewRefIdList;

	count = CDocumentWindowsList.CDocList.GetSize();

	for(p = 0; p < count; p++)
	{
		TCDocumentWindowsListData &CDocumentWindowsListData = CDocumentWindowsList.CDocList[p];

		if(CDocumentWindowsListData.type != E_SCHEMATIC_DOCUMENT) continue;

		if(CDocumentWindowsListData.CFileName != CFileName) continue;

		PCDoc = (TCSuperSpiceDoc *)CDocumentWindowsList.IsOpen(CFileName);

		if(!PCDoc) continue;

		CreateRefDesList(CNewRefIdList, CNewRefDes);

		CNewRefId = GetNewRefDes(CNewRefDes);

		int q, ref_count;// should have wraped this up in a class, fix the string array

		ref_count = CNewRefIdList.GetSize();

		CDocumentWindowsListData.CParentRefDes = CNewRefId;
		CDocumentWindowsListData.CParentRefIDList.SetSize(count);

		for(q = 0; q < ref_count; q++) CDocumentWindowsListData.CParentRefIDList[q] = CNewRefIdList[q];

		PCDoc->SetParent(this, CFileName, CNewRefIdList, CNewRefId);
	}
}

bool TCSuperSpiceDoc::CopySymbolsSchematicsToNewDir(CString CPath)
{
	TCSuperSpiceDoc *PCSuperSpiceDoc = NULL;

	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp *)AfxGetApp();

	if(!PCSuperSpiceApp) return false;

	CMultiDocTemplate *PCMSuperSpiceDocTemplate = PCSuperSpiceApp->GetSuperSpiceDocTemplate();

	if(!PCMSuperSpiceDocTemplate) return false;//major system error

	int mcount, scount, p, q;
	CString CNewSchematicName;
	CString COldSchematicName;

	TCSchematicManager *PCSchematicManager;

	GenerateUniqueSchematicManagers();

	mcount = CMUniqueSchematicManagerList.GetSize();

	bool flag = true;

	for(p = 0; p < mcount; p++)
	{
		PCSchematicManager = CMUniqueSchematicManagerList[p];
		
		CArray <TCSchematicObject *, TCSchematicObject *> &CGraphicList = PCSchematicManager->CMSchematicManagerData.CGraphicList;
		
		scount = CGraphicList.GetSize();

		for(q = 0; q < scount; q++)
		{
			if(CGraphicList[q]->CMSchematicObjectData.attached_model_type != E_SPICE_SCHEMATIC)continue;

			COldSchematicName = ExtractFileName(CGraphicList[q]->CMSchematicObjectData.CSymbolData.CChildFileName);
			 
			if(COldSchematicName == "") continue;

			CNewSchematicName = CPath + COldSchematicName;

			if(!CopyFile(CGraphicList[q]->CMSchematicObjectData.CSymbolData.CChildFileName, CNewSchematicName, 0))  {flag = false; continue;};

			PCSuperSpiceDoc = (TCSuperSpiceDoc *)PCMSuperSpiceDocTemplate->OpenDocumentFile(CNewSchematicName, false);

			if(!PCSuperSpiceDoc) {flag = false; continue;}

			PCSuperSpiceDoc->CopySymbolsSchematicsToNewDir(CPath);
			PCSuperSpiceDoc->ChangeSymbolsSchematicsDir(CPath);
			PCSuperSpiceDoc->RegenerateSchematicDocumentsWindowList(true);
			PCSuperSpiceDoc->OnSaveDocument(CNewSchematicName);
			PCSuperSpiceDoc->OnCloseDocument();
		}
	}

	return flag;
}

bool TCSuperSpiceDoc::ChangeSymbolsSchematicsDir(CString CPath)
{
	int mcount, scount, p, q;
	CString CNewSchematicName;
	CString COldSchematicName;

	TCSchematicManager *PCSchematicManager;

	GenerateUniqueSchematicManagers();

	mcount = CMUniqueSchematicManagerList.GetSize();

	for(p = 0; p < mcount; p++)
	{
		PCSchematicManager = CMUniqueSchematicManagerList[p];
		
		CArray <TCSchematicObject *, TCSchematicObject *> &CGraphicList = PCSchematicManager->CMSchematicManagerData.CGraphicList;
		
		scount = CGraphicList.GetSize();

		for(q = 0; q < scount; q++)
		{
			COldSchematicName = ExtractFileName(CGraphicList[q]->CMSchematicObjectData.CSymbolData.CChildFileName);

			CNewSchematicName = CPath + COldSchematicName;

			CGraphicList[q]->CMSchematicObjectData.CSymbolData.CChildFileName = CNewSchematicName;
		}
	}

	return true;
}

void TCSuperSpiceDoc::OnRunRunDebugMode(CView *PCView, bool renetlist) 
{
	int window_state = GCSuperSpiceGlobalData.CProgramOptions.CSpiceEngine.run_minimised;

	GCSuperSpiceGlobalData.CProgramOptions.CSpiceEngine.run_minimised = false;

	m_debug_mode = true;

	OnRunRun(PCView, renetlist);

	StopTimer();// keep spice engine open

	GCSuperSpiceGlobalData.CProgramOptions.CSpiceEngine.run_minimised = window_state;

	m_debug_mode = false;
}

void TCSuperSpiceDoc::OnRunRun(CView *PCView, bool renetlist)
{
	ClearError();
	ClearAllVars(); // In Equation.cpp, stops vars building up

	CMSuperSpiceDocData.PCAnalysisSetup->parameter_sweep_mode = false;//Ensure Schematic param sweeps are initially disabled 

	m_marching_waveform_enabled = false;
	m_is_simulation_paused = false;

	DisplayError(IDS_EER_STATUS, IDS_NETLIST_START);

	if(PCSuperSpiceViewTimer) 
	{
		AfxMessageBox(IDS_SIM_ALREADY_STARTED);
		return;
	}

	if(!GCAuthorization.VerifyAtNetList())
	{
		CGlobalStatusMessage.LoadString(IDS_INVALID_PASSWORD_FILE);
		
		return;
	}

	TCSuperSpiceDoc	*PCDoc = GetTopLevelDoc();

	if(!PCDoc)
	{
		CGlobalStatusMessage.LoadString(IDS_INTERNAL_ERROR);

		DisplayError(CGlobalStatusMessage, IDS_NO_TOP_LEVEL, 0);

		return;
	}

	if(!PCDoc->top_level)
	{
		CGlobalStatusMessage.LoadString(IDS_NO_TOP_LEVEL); 

		CString CMsg;

		CMsg.LoadString(IDS_INTERNAL_ERROR);

		DisplayError(CMsg, CGlobalStatusMessage, 0);

		return;
	}

	// Force only test point signals to be displayed
	if(IsGraphicsModified()) // Added 16th November 2013 to prevent display of duff signals on schematic change
	{
		ClearAllWaveforms();	
	}

	CMTestPointDataList.SetSize(0, 16);//Netlister will back stuff this data

	if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.graph_default_setups)
	{
		if(CDocumentWindowsList.IsOpen(CMSuperSpiceDocData.CMasterOutputWaveform))
		{
			CDocumentWindowsList.Close(CMSuperSpiceDocData.CMasterOutputWaveform);
		}

		DeleteFile(CMSuperSpiceDocData.CMasterOutputWaveform);
	}

	CString COutputFileName;

	m_runs_counter	= 0;

	int old_number_of_runs = CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize();

	if(GCAuthorization.m_build_type2 != E_FULL_RELEASE_STUDENT && GCAuthorization.m_build_type2 != E_RESTRICTED_RELEASE_STUDENT && GCAuthorization.m_build_type2 != E_AUTHORIZATION_MASTER_PASSWORD_STUDENT)// 
	if(!SetupParameterRuns())// setsup CWaveformDataRuns, with new size;
	{
		DisplayError(IDS_ERR_ERROR, IDS_INVALID_PRAM_SETUP, 0);

		return;
	}

	CMSuperSpiceDocData.CWaveformDataRuns.Save(CMSuperSpiceDocData.CMasterOutputDataFileName, (CMSuperSpiceDocData.PCAnalysisSetup->CReRun.enable == E_RERUN_SWEEP_TYPE_WC_RERUN_FILE));

	COutputFileName = CMSuperSpiceDocData.CMasterOutputDataFileName;
	
	old_number_of_runs;
	
	// need to use the top level document PCView to avoid timer problems.

	POSITION pos = GetFirstViewPosition();

	if(!pos) return;

	CView* PCThisView = GetNextView(pos);

	if(!PCView) return;// cannot really fail

	PCMRunsView		= PCThisView;
	m_renetlist		= renetlist;

	SetLoopGainSource();

	MarchingWaveformOverides();

	if(!RunSpiceEngine(PCThisView, COutputFileName, renetlist, 0))
	{// force cancel of other runs
		m_runs_counter = CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize();

		m_runs_counter++;
	}

	m_runs_counter++;

	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp *) AfxGetApp();

	PCSuperSpiceApp->SendSuperSpiceAck(h_msg);

	MarchingWaveformStart(1);
}

void TCSuperSpiceDoc::OnRunRunasOperatingPointDesigner() 
{
	TCSuperSpiceDoc *PCSuperSpiceDoc = GetTopLevelDoc();

	TCReRun &CReRun = PCSuperSpiceDoc->CMSuperSpiceDocData.PCAnalysisSetup->CReRun;

	if(!CReRun.CReserved.CIntArray[E_DESIGNER_SELECTED_DEVICES])
	{
		DisplayError(IDS_ERR_ERROR, IDS_DESIGNER_NONE_SELECTED, 0);

		return;
	}

	CReRun.CReserved.CIntArray[E_DESIGNER_ENABLE_OPERATING_POINT] = true;

	PCSuperSpiceDoc->OnRunRun((TCSuperSpiceView*) m_viewList.GetHead(), true);
}

void TCSuperSpiceDoc::OnSetupsDesignerSetup() 
{
	TCReRun &CReRun = CMSuperSpiceDocData.PCAnalysisSetup->CReRun;

	CMDesignerDlg.m_design_all_resistors = (int) CReRun.CReserved.CIntArray[E_DESIGNER_SELECTED_DEVICES];

	if(CMDesignerDlg.DoModal() != IDOK) return;

	CReRun.CReserved.CIntArray[E_DESIGNER_SELECTED_DEVICES] = (float) CMDesignerDlg.m_design_all_resistors;
}

bool TCSuperSpiceDoc::RunSpiceEngine(CView *PCView, CString COutputFileName, bool renetlist, int format) 
{
	TCSuperSpiceDoc	*PCDoc = GetTopLevelDoc();

	if(!PCDoc) 
	{
		DisplayError(IDS_ERR_SYSTEM_ERROR, "", 0);

		return false;
	}

	RegenerateSchematicDocumentsWindowList(false);// better safe then sorry

	if(CThisFileName == "") 
	{
		AfxMessageBox(IDS_MUST_SAVE_ONCE);

		return false;
	}

	if(GCAuthorization.m_build_type == E_DEMO_RELEASE)
	{
		if(GetNumberOfComponents() > E_MAX_NUM_NET_LINES)
		{
			CString CTrialExceeded;

			CTrialExceeded.LoadString(IDS_CIRCUIT_SIZE_EXCEEDED);
			
			AfxMessageBox(CTrialExceeded);

			return false;
		}
	}

	CArray <CString, CString>  CPinListDummy;//not required for top level

	if(renetlist)
	{
		if(!PCDoc->CreateNetlist(format, CPinListDummy))
		{
			CGlobalStatusMessage.LoadString(IDS_UNABLE_TO_NETLIST);

			DisplayError(IDS_ERR_ERROR, IDS_NO_NETLIST, 0);

			return false;
		}
	}
	else // save any user modified netlist changes
	{
		if(!FileExists(CMSuperSpiceDocData.CMasterNetListFileName))
		{
			CGlobalStatusMessage.LoadString(IDS_UNABLE_TO_NETLIST);

			DisplayError(IDS_ERR_ERROR, IDS_UNABLE_TO_NETLIST, 0);

			return false;
		}

		TCSuperSpiceTextDoc *PCSuperSpiceTextDoc = (TCSuperSpiceTextDoc *)CDocumentWindowsList.IsOpen(CMSuperSpiceDocData.CMasterNetListFileName);

		if(PCSuperSpiceTextDoc)// update netlist text display
		{
			SaveGenericToArchive(PCSuperSpiceTextDoc, CMSuperSpiceDocData.CMasterNetListFileName);
		}
	}

	if(!SetupMC()) 
	{
		DisplayError(IDS_ERR_ERROR, IDS_UNABLE_TO_CREATE_MC);

		return false;//check an run MC if enabled
	}
	// Now run the spice engine

	CString CSpiceProgramName;
	CString CCommandLine;

	CSpiceProgramName = GCSuperSpiceGlobalData.CProgramOptions.CSpiceEngine.CSpiceEngineName;

	if(!FileExists(CSpiceProgramName))
	{
		if(AfxMessageBox(IDS_ERR_NO_SPICE_ENGINE, MB_YESNO) == IDYES)
		{
			g_last_active_program_options_page = 1;

			OnOptionsProgram();
		}
		else return false;
	}

	CSpiceProgramName = GCSuperSpiceGlobalData.CProgramOptions.CSpiceEngine.CSpiceEngineName;

	if(!FileExists(CSpiceProgramName))
	{
		DisplayError(IDS_ERR_ERROR, IDS_ERR_NO_SPICE_ENGINE);

		return false;
	}
 
	DisplayError(IDS_EER_STATUS, IDS_STARTING_SPICE_ENGINE);

	if(!GCSuperSpiceGlobalData.CProgramOptions.CSpiceEngine.default_command)
	{

		CCommandLine.Format("%s %s %s", CSpiceProgramName, CMSuperSpiceDocData.CMasterNetListFileName,
					    GCSuperSpiceGlobalData.CProgramOptions.CSpiceEngine.CCommandLine);

	}
	else
	{
		if(m_debug_mode) CCommandLine.Format("-r \"%s\" \"%s\"", COutputFileName, CMSuperSpiceDocData.CMasterNetListFileName);
		else 	CCommandLine.Format("-r \"%s\" -b \"%s\"", COutputFileName, CMSuperSpiceDocData.CMasterNetListFileName);
	}

	if(PCDoc->top_level) 
	{
		StartTimer(PCView);

		m_simulation_counter = 0;
	}

	if(FileExists(COutputFileName))// helps to avoid old data still being displayed on errors
	{
		DeleteFile(COutputFileName);
	}

	if(GCSuperSpiceGlobalData.CProgramOptions.CSpiceEngine.display_xspice_status) CCommandLine = "-d " + CCommandLine;

	if(!RunSpiceEngine(CSpiceProgramName, CCommandLine))
	{
		StopTimer();
	
		DisplayError(IDS_ERR_ERROR, IDS_ERRORS_IN_SIM, 0);

		return false;
	}

	return true;
}

void TCSuperSpiceDoc::StartTimer(CView *PCTimerView)
{
	if(!PCTimerView) return;

	if(IsBadWindowHandle(PCTimerView))
	{
		DisplayError(IDS_ERR_SYSTEM_ERROR, "", 0);

		return;
	}

	if(!PCTimerView->SetTimer(1, 100, NULL))
	{
		AfxMessageBox(IDS_ERR_NO_TIMERS);

		DisplayError(IDS_ERR_SYSTEM_ERROR, IDS_ERR_NO_TIMERS, 0);

		PCSuperSpiceViewTimer = NULL;
	}

	m_timer_counter = 0;

	PCSuperSpiceViewTimer = (TCSuperSpiceView *)PCTimerView;
}

void TCSuperSpiceDoc::StopTimer(void)
{
	if(PCSuperSpiceViewTimer) PCSuperSpiceViewTimer->KillTimer(1);

	PCSuperSpiceViewTimer = NULL;
}

bool TCSuperSpiceDoc::RunSpiceEngine(CString CProgramName, CString CCommandLine)
{
	PROCESS_INFORMATION info;

	STARTUPINFO info_startup;

	ZeroMemory(&info_startup, sizeof(info_startup));

	info_startup.cb = sizeof(STARTUPINFO);

	info_startup.dwFlags = STARTF_USESHOWWINDOW;

	if(GCSuperSpiceGlobalData.CProgramOptions.CSpiceEngine.run_minimised)
		info_startup.wShowWindow = SW_SHOWMINIMIZED;
	else info_startup.wShowWindow = SW_SHOWNORMAL;

	CString CErrorMessage;

	CCommandLine = "\"" +CProgramName +"\"" + ' ' + CCommandLine;

	if(!CreateProcess(CProgramName.GetBuffer(CProgramName.GetLength() + 1), CCommandLine.GetBuffer(CCommandLine.GetLength() + 1),  
		               NULL, NULL, false, 0, NULL, NULL, &info_startup, &info))
	{
		StopTimer();

		DisplayError(IDS_ERR_SYSTEM_ERROR, IDS_UNABLE_TO_START_SIM, 0);

		return false;
	}

	 CGlobalStatusMessage.LoadString(IDS_RUNNING_ENGINE);

	 DisplayError(IDS_EER_STATUS, CGlobalStatusMessage);

	 HSpiceEngineProcess = info.hProcess;
	 HSpiceEngineThread = info.hThread;
	 SpiceEngineProcessId = info.dwProcessId; 
	 SpiceEngineThreadId = info.dwThreadId;

	 CString CRunNumber, CNumberOfRuns;

	 int number_of_runs = CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize();

	 CRunNumber.Format("%d", m_runs_counter + 1);
	 CNumberOfRuns.Format("%d", number_of_runs);

	 if(number_of_runs > 1)
	 {
		 CGlobalRunStatus = "Engine Run " + CRunNumber + " of " + CNumberOfRuns + ": ";
	 }
	 else CGlobalRunStatus = "";

	return true;//temp
}

void  TCSuperSpiceDoc::TimerCallBack(void)
{
	if(!top_level) return;

	m_timer_counter++;

	if(HSpiceEngineProcess)
	{
		DWORD status;

		GetExitCodeProcess(HSpiceEngineProcess, &status);

		if(status == STILL_ACTIVE) 
		{
			ProcessMarchingWaveforms(1);

			return;
		}
	}

	StopTimer();

	if(HSpiceEngineProcess)CloseHandle(HSpiceEngineProcess);
	if(HSpiceEngineThread) CloseHandle(HSpiceEngineThread);
		
	HSpiceEngineProcess = NULL;
	HSpiceEngineThread  = NULL;
	SpiceEngineProcessId = 0; 
	SpiceEngineThreadId = 0;

	OnRunStop();

	if(CheckAndRunNextSpiceRun()) return;

	OnSpiceEngineIsFinished();
}

bool TCSuperSpiceDoc::ProcessMarchingWaveforms(int state)
{
	if(!m_marching_waveform_enabled) return false;

	if(m_is_simulation_paused) return false;

	if(m_marching_waiting_to_read_data | m_marching_waiting_to_open_file | m_marching_waiting_to_read_header)
	{
		m_marching_waiting_to_read_data = false;
		m_marching_waiting_to_open_file = false;	
		m_marching_waiting_to_read_header = false;

		return false;
	}

	m_marching_waiting_to_read_data = false;	// ensure any while loop is killed on each timer message
	m_marching_waiting_to_open_file = false;	// ensure any while loop is killed on each timer message
	m_marching_waiting_to_read_header = false;

	if(!state) 
	{
		SendContinueCommand();

		return MarchingWaveformEnd(0);// Force termination
	}

	switch(m_marching_waveform_state)
	{			
		case E_MARCHING_WAVEFORM_OPENING_FILE:		MarchingWaveformOpeningFile(state); break;
		case E_MARCHING_WAVEFORM_READING_HEADER:	MarchingWaveformReadingHeader(state);break;
		case E_MARCHING_WAVEFORM_READING_DATA:		MarchingWaveformReadingData(state);break;

		default: m_marching_waveform_state = E_MARCHING_WAVEFORM_NULL;
	} 

	SendContinueCommand();

	return true;
}


void TCSuperSpiceDoc::MarchingWaveformReset(void)
{
	m_marching_waveform_state = E_MARCHING_WAVEFORM_NULL;
	m_marching_waiting_to_open_file = false;
	m_marching_waiting_to_read_data = false;
	m_marching_waiting_to_read_header = false;
	m_marching_last_data_point = 0;
	m_marching_current_header_type = -1;
	m_marching_xspice_header_counter = 0;
	m_marching_error = false;
	
	CMarchingHeaderList.SetSize(0);

	CMWaveformFileStream.clear();

	if(CMWaveformFileStream.is_open()) 
	{
		CMWaveformFileStream.close();

		if(CMWaveformFileStream.fail())
		{
			DisplayError(IDS_EER_STATUS, "Error in closing marching waveform file", 0);
		}
	}

	CMWaveformFileStream.clear();
}

void TCSuperSpiceDoc::MarchingWaveformAddHeader(int header)
{
	CMarchingHeaderList.Add(header);
}

int TCSuperSpiceDoc::MarchingWaveformGetHeader(void)
{
	int count = CMarchingHeaderList.GetSize();

	if(!count) return -1;

	if(!(m_marching_xspice_header_counter < count)) return -1;

	return CMarchingHeaderList[m_marching_xspice_header_counter];
}

bool TCSuperSpiceDoc::MarchingWaveformStart(int state)
{
	TCAnalysisSetup &CAnalysisSetup = *CMSuperSpiceDocData.PCAnalysisSetup;

	if(!CAnalysisSetup.CTransientSetupData.CSweepData.enable) return false;
	if(!CAnalysisSetup.CTransientSetupData.enable_marching_waveforms) return false; 

	MarchingWaveformReset();

	if(!state) return false;
	if(!m_runs_counter) return false;
	if(!CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]) return false;

	int number_of_runs = CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize();

	m_marching_display = CMSuperSpiceDocData.CWaveformDataRuns.LoadStart(number_of_runs, this);

	if(m_marching_display < 0) return false;

	CMWaveformFileStream.clear();

	CString CMsg;

	CMsg.LoadString(IDS_STARTUNG_WAVEFORM_MARCHING);

	DisplayError(IDS_EER_STATUS, CMsg, 0);

	CMSuperSpiceDocData.CWaveformDataRuns.CMWaveformAnalyisisData = CMWaveformAnalyisisData;

	m_marching_waveform_enabled = true;
	m_marching_waveform_state = E_MARCHING_WAVEFORM_OPENING_FILE;

	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp *) AfxGetApp();

	PCSuperSpiceApp->SendEnableMarchingWaveforms(h_msg, true);

	return true;
}

bool TCSuperSpiceDoc::MarchingWaveformOpeningFile(int state)
{
	if(!m_marching_waveform_enabled) return false;
	if(!state) return MarchingWaveformEnd(1);
	if(m_marching_waveform_state != E_MARCHING_WAVEFORM_OPENING_FILE) return false;

	int run_number = m_runs_counter - 1;

	if(run_number < 0) return false;//cant happen 

	if(m_marching_waiting_to_open_file) return false;// avoid infine loop if called by timer again

	m_marching_waiting_to_open_file = true;

	CString CFileName, CBaseName, CNewName;

	CBaseName = RemoveExtention(CMSuperSpiceDocData.CMasterOutputDataFileName);

	CString CMsg;

	while(m_marching_waiting_to_open_file)// keep looking and ignor any more timer messages, other timer messages can clear this flag
	{
		ProcessWindowsMessages(); // This will cancel m_marching_waiting_to_open_file if the timer is called

		if(!m_marching_waiting_to_open_file) return false;

		if(!m_marching_waveform_enabled) return false; //This may be set via ProcessWindowsMessages()

		if(m_is_simulation_paused) return false;//This may be set via ProcessWindowsMessages()

		SendPauseCommand();

		if(!run_number) m_marching_default_size = CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]->OpenFile(CMWaveformFileStream, CMSuperSpiceDocData.CMasterOutputDataFileName, this, &CMSuperSpiceDocData.CWaveformDataRuns, 0);
		else //not yet debuged/implemented
		{
			CNewName.Format("%s%d.out", CBaseName, run_number);

			m_marching_default_size =  CMSuperSpiceDocData.CWaveformDataRuns.CRuns[run_number]->OpenFile(CMWaveformFileStream, CNewName, this, &CMSuperSpiceDocData.CWaveformDataRuns, run_number);
		}
	
		CMWaveformFileStream.clear();

		SendContinueCommand();

		if(!m_marching_default_size) continue;// Keep trying

		m_marching_waiting_to_open_file = false;
	}

	CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]->m_marching_waveform_type = E_SPICE_RECORD_TRANSIENT;

	CMsg.LoadString(IDS_DATA_FILE_OPENED);

	DisplayError(IDS_EER_STATUS, CMsg, 0);

	m_marching_waveform_state = E_MARCHING_WAVEFORM_READING_HEADER;

	return true;
}

bool TCSuperSpiceDoc::MarchingWaveformReadingHeader(int state)
{
	if(!m_marching_waveform_enabled) return false;
	if(!state) return MarchingWaveformEnd(1);
	if(m_marching_waiting_to_read_header) return false;
	if(m_marching_waveform_state != E_MARCHING_WAVEFORM_READING_HEADER) return false;
	if(MarchingWaveformGetHeader() < 0) return false;
	// For simplicity, if a first header read fails not all of the header is there
	// the sequence will terminate. Its very unlikely for a header to not be ready

	m_marching_waiting_to_read_header = true;

	int run_number = m_runs_counter - 1;

	if(run_number < 0) return false;//cant happen 

	TCOutputWaveformData &COutputWaveformData = *CMSuperSpiceDocData.CWaveformDataRuns.CRuns[run_number];

	int status = 0;

	SendPauseCommand();

	while(m_marching_waiting_to_read_header)
	{
		ProcessWindowsMessages();

		if(!m_marching_waveform_enabled) return false;
		if(!m_marching_waiting_to_read_header) return false;

		if(m_is_simulation_paused) return false;//This may be set via ProcessWindowsMessages()

		status = COutputWaveformData.ReadNextHeader(CMWaveformFileStream, m_marching_default_size);

		CMWaveformFileStream.clear();

		if(!status) continue; // keep looking for header

		if(status == -1) 
		{
			return MarchingWaveformEnd(1);// error 
		}

		m_marching_waiting_to_read_header = false;
	}

	CString CMsg;

	CMsg.LoadString(IDS_DATA_HEADER_READ);

	DisplayError(IDS_EER_STATUS, CMsg, 0);

	m_marching_xspice_header_counter++;// look for next header after next data
	m_marching_current_header_type = status - 1;

	m_marching_waveform_state = E_MARCHING_WAVEFORM_READING_DATA;

	return true;
}

bool TCSuperSpiceDoc::MarchingWaveformReadingData(int state)
{
	if(!m_marching_waveform_enabled) return false;
	if(!state) return MarchingWaveformEnd(1);
	if(m_marching_waiting_to_read_data) return false;
	if(m_marching_waveform_state != E_MARCHING_WAVEFORM_READING_DATA) return false;

	int run_number = m_runs_counter - 1;

	if(run_number < 0) return false;//cant happen 

	int data_point = 0;

	m_marching_waiting_to_read_data = true;

	TCOutputWaveformData &COutputWaveformData = *CMSuperSpiceDocData.CWaveformDataRuns.CRuns[run_number];

	SendPauseCommand();

	while(m_marching_waiting_to_read_data)// keep looking and ignor any more timer messages, other timer messages can clear this flag
	{
		ProcessWindowsMessages();// This will cancel m_marching_waiting_to_read_data if the timer is called

		if(!m_marching_waveform_enabled) return false;
		if(!m_marching_waiting_to_read_data) return false;

		if(m_is_simulation_paused) return false;//This may be set via ProcessWindowsMessages()

		data_point = COutputWaveformData.ReadNextData(CMWaveformFileStream);

		CMWaveformFileStream.clear();

		if(data_point < 0) return MarchingWaveformEnd(1);

		if(m_marching_current_header_type != E_SPICE_RECORD_TRANSIENT)
		{
			if(!data_point) continue;// not finished reading in non marching waveforms

			m_marching_waiting_to_read_data = false;

			m_marching_last_data_point = 0;

			break;
		}

		if(!(data_point > m_marching_last_data_point)) continue;

		m_marching_last_data_point = data_point;

		m_marching_waiting_to_read_data = false;

		data_point = 0;
	}

	if(data_point < 0) return MarchingWaveformEnd(1);

	if(!data_point) return true; //Look for more data next time around.

	CString CMsg;

	CMsg.LoadString(IDS_DATA_FILE_READ);

	DisplayError(IDS_EER_STATUS, CMsg, 0);
	//Transient must always be the last data set in the file
	if(m_marching_current_header_type != E_SPICE_RECORD_TRANSIENT)// pausing can cause a premerture end of data read, not sure why
		m_marching_waveform_state = E_MARCHING_WAVEFORM_READING_HEADER;

	return true;
}

void TCSuperSpiceDoc::MarchingWaveformFinalRead(void)
{
	if(m_marching_waveform_state != E_MARCHING_WAVEFORM_READING_DATA) return;
	if(m_marching_current_header_type < 0) return;
	TCOutputWaveformData &COutputWaveformData = *CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0];

	if(CMWaveformFileStream.is_open()) COutputWaveformData.ReadNextData(CMWaveformFileStream);

	CMWaveformFileStream.clear();
}

bool TCSuperSpiceDoc::MarchingWaveformEnd(int state)
{
	MarchingWaveformReset();

	if(!state) m_marching_error = true;

	bool value = false;

	int run_number = m_runs_counter - 1;

	if(run_number < 0) return false;

	if(!(run_number < CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize())) return false;

	TCOutputWaveformData &COutputWaveformData = *CMSuperSpiceDocData.CWaveformDataRuns.CRuns[run_number];

	COutputWaveformData.ReadDataEnded();

	if(!state && m_marching_waveform_enabled) // normal terminate
	{
		CMSuperSpiceDocData.CWaveformDataRuns.CMWaveformAnalyisisData = COutputWaveformData.CMWaveformAnalyisisData;

		CMWaveformAnalyisisData = CMSuperSpiceDocData.CWaveformDataRuns.CMWaveformAnalyisisData;

		value = !!CMSuperSpiceDocData.CWaveformDataRuns.LoadEnd(m_marching_display);
	}
	else COutputWaveformData.ReadDataEnded();

	if(state) 
	{
		TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp *) AfxGetApp();

		PCSuperSpiceApp->SendXSpiceQuitMessage(GetTopLevelDoc()->h_msg);

		m_marching_error = true;

		CGlobalStatusMessage.LoadString(IDS_DATA_LOAD_ERROR);

		DisplayError(IDS_ERR_ERROR, CGlobalStatusMessage, 0);

		GCGeneralReportsTab.DisplayLogFile(CMSuperSpiceDocData.CMasterSpiceEngineLogFileName, TE_STATUS_REPORT_FILE_LOG);
	}

	m_marching_waveform_enabled = false;

	return value;
}

void TCSuperSpiceDoc::MarchingWaveformOverides(void)
{
	TCAnalysisSetup &CAnalysisSetup = *CMSuperSpiceDocData.PCAnalysisSetup;

	if(!CAnalysisSetup.CTransientSetupData.CSweepData.enable) 
	{
		CAnalysisSetup.CTransientSetupData.enable_marching_waveforms = false;

		return;
	}

	if(!CAnalysisSetup.CTransientSetupData.enable_marching_waveforms)
	{
		CMSuperSpiceDocData.PCAnalysisSetup->CBerklySpiceOptionsSetupData.COptionsFloatData[E_OPTIONS_SIM_WAIT_TIME].m_include = false;

		 return;
	}

	CString CMsg, CMsgHeader;

	if(CMSuperSpiceDocData.PCAnalysisSetup->CBerklySpiceOptionsSetupData.COptionsFloatData[E_OPTIONS_SIM_WAIT_TIME].m_include && 
	   CMSuperSpiceDocData.PCAnalysisSetup->CBerklySpiceOptionsSetupData.COptionsFloatData[E_OPTIONS_SIM_WAIT_TIME].value)
	{
		CMsg.LoadString(IDS_SIM_WAIT_ENABLED);

		DisplayError(IDS_ERR_WARNING, CMsg, 0);
	}

	CMsgHeader.LoadString(IDS_MARCHING_WAVEFORM_DISABLES_RUNS);

	if(CAnalysisSetup.CTemperatureSetupData.CSweepData.enable)
	if(CAnalysisSetup.CTemperatureSetupData.CSweepData.sweep_type != E_TEMPERATURE_SWEEP_VOLTS_V_TEMP)
	{
		CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = false;

		CMsg = "temperature runs";

		CMsg = CMsgHeader + CMsg;

		DisplayError(IDS_ERR_WARNING, CMsg, 0);
	}
	
	if(CAnalysisSetup.CNoiseSetupData.enable)
	{
		CAnalysisSetup.CNoiseSetupData.enable = false;

		CMsg = "noise analysis";

		CMsg = CMsgHeader + CMsg;

		DisplayError(IDS_ERR_WARNING, CMsg, 0);
	}

	if(CAnalysisSetup.CSensitivitySetupData.enable_ac)
	{
		CAnalysisSetup.CSensitivitySetupData.enable_ac = false;

		CMsg = "ac sensitivity";

		CMsg = CMsgHeader + CMsg;

		DisplayError(IDS_ERR_WARNING, CMsg, 0);
	}

	if(CAnalysisSetup.CSensitivitySetupData.enable_dc)
	{
		CAnalysisSetup.CSensitivitySetupData.enable_dc;

		CMsg = "dc sensitivity";

		CMsg = CMsgHeader + CMsg;

		DisplayError(IDS_ERR_WARNING, CMsg, 0);
	}

	if(CAnalysisSetup.CPoleZeroSetupData.enable)
	{ 
		CAnalysisSetup.CPoleZeroSetupData.enable = false;

		CMsg = "pole-zero";

		CMsg = CMsgHeader + CMsg;

		DisplayError(IDS_ERR_WARNING, CMsg, 0);
	}

	if(CAnalysisSetup.CDistortionSetupData.enable)
	{
		CAnalysisSetup.CDistortionSetupData.enable = false;

		CMsg = "distorion analysis";

		CMsg = CMsgHeader + CMsg;

		DisplayError(IDS_ERR_WARNING, CMsg, 0);
	}

	if(CAnalysisSetup.CReRun.enable)
	{
		CAnalysisSetup.CReRun.enable = false;

		CMsg = "worst case re-runs";

		CMsg = CMsgHeader + CMsg;

		DisplayError(IDS_ERR_WARNING, CMsg, 0);
	}

	if(CAnalysisSetup.CParametricSetupData.CSweepData.enable)
	{
		CAnalysisSetup.CParametricSetupData.CSweepData.enable = false;

		CMsg = "parametric sweep";

		CMsg = CMsgHeader + CMsg;

		DisplayError(IDS_ERR_WARNING, CMsg, 0);
	}
		
	if(CAnalysisSetup.COutputSelectData.text_file_type)// force binary for marching waveform
	{
		CAnalysisSetup.COutputSelectData.text_file_type = false;

		CMsg.LoadString(IDS_BINARY_DEFAULTED);

		CMsg = CMsgHeader + CMsg;

		DisplayError(IDS_ERR_WARNING, CMsg, 0);
	}
}

void TCSuperSpiceDoc::SendContinueCommand(void)
{
	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp *) AfxGetApp();

	PCSuperSpiceApp->SendContinueCommand(h_msg);

//	m_is_simulation_paused = false;
}

void TCSuperSpiceDoc::SendPauseCommand(void)
{
	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp *) AfxGetApp();

	PCSuperSpiceApp->SendPauseCommand(h_msg);

//	m_is_simulation_paused = true;
}

bool TCSuperSpiceDoc::SetupParameterRuns(void)
{
	if(!CMSuperSpiceDocData.PCAnalysisSetup) return false;
	// only model files get updated, no renetlisting is done	

	if(!CMSuperSpiceDocData.PCAnalysisSetup->CReRun.enable &&
	   !(CMSuperSpiceDocData.PCAnalysisSetup->CTemperatureSetupData.CSweepData.enable &&
		 CMSuperSpiceDocData.PCAnalysisSetup->CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_MULTY_RUNS) &&
	   !CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData.CSweepData.enable)
	{
		CMSuperSpiceDocData.CWaveformDataRuns.SetSize(1);
	}

	if(GCAuthorization.m_build_type == E_FULL_RELEASE_STUDENT || GCAuthorization.m_build_type2 == E_RESTRICTED_RELEASE_STUDENT || GCAuthorization.m_build_type2 == E_AUTHORIZATION_MASTER_PASSWORD_STUDENT)
	{
		DisplayError(IDS_EER_STATUS, IDS_STUDENT_FEATURE_MSG);
	
		return false;
	}

	SetupParameterWCCorner();// Added 22nd Nov 2014

	if(!CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData.CSweepData.enable)
	if(!(CMSuperSpiceDocData.PCAnalysisSetup->CTemperatureSetupData.CSweepData.enable &&
		 CMSuperSpiceDocData.PCAnalysisSetup->CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_MULTY_RUNS))
		if(!CMSuperSpiceDocData.PCAnalysisSetup->CReRun.enable)
		{
			CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]->CRunDiscription = "Single Run";

			return true;
		}



	// never gets here now. Moved to parameter sweep
	if(CMSuperSpiceDocData.PCAnalysisSetup->CTemperatureSetupData.CSweepData.sweep_type != E_TEMPERATURE_SWEEP_VOLTS_V_TEMP)
	if(CMSuperSpiceDocData.PCAnalysisSetup->CTemperatureSetupData.CSweepData.enable) 
	{
		CMSuperSpiceDocData.PCAnalysisSetup->CReRun.enable = false;
		CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData.CSweepData.enable = false;


		if(!SetupTempRunNames("")) return false;// adds to existing runs array

			CreateModelLines();

		return true;
	}

	if(CMSuperSpiceDocData.PCAnalysisSetup->CReRun.enable == E_RERUN_SWEEP_TYPE_WC_RERUN_FILE || CMSuperSpiceDocData.PCAnalysisSetup->CReRun.enable == E_RERUN_SWEEP_TYPE_WC_MODEL_FILES)// only WC, no temp
	{
		CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData.CSweepData.enable = false;

		int mode = 0;// do do, selects betwee showing nominal run

		if(SetupWorstCase(mode) == "") return false;

		return true;
	}

	if(CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData.CSweepData.enable)
	{
		if(!SetupParameterSweep()) return false;

		CreateModelLines();

		return true;
	} 

	CreateModelLines();

	return true;
}

void TCSuperSpiceDoc::SetupParameterWCCorner(void)
{
	int p;

	CArray <TCWorstCaseData, TCWorstCaseData&> &CWorstCase = CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CWorstCase;

	CMSuperSpiceDocData.PCAnalysisSetup->CReRun.SetStrength();// sets up strong, weak, nominal 

	CArray <CString, CString> CModelArray;

	CModelArray.SetSize(3);

	CModelArray[0] = "_XS";
	CModelArray[1] = "_XN";
	CModelArray[2] = "_XW";

	// Default all nominal
	CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CRunType[E_WORST_CASE_NPN] = CModelArray[1];
	CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CRunType[E_WORST_CASE_PNP] = CModelArray[1];
	CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CRunType[E_WORST_CASE_NMOS] = CModelArray[1];
	CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CRunType[E_WORST_CASE_PMOS] = CModelArray[1];
	CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CRunType[E_WORST_CASE_RLC] = CModelArray[1];
	CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CRunType[E_WORST_CASE_GENERATOR] = CModelArray[1];
	CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CRunType[E_WORST_CASE_SUB] = CModelArray[1];
	CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CRunType[E_WORST_CASE_QR] = CModelArray[1];
	CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CRunType[E_WORST_CASE_TEMP] = CModelArray[1];

	for(p = 0; p < 3; p++)
	{
		if(CWorstCase[E_WORST_CASE_NPN].CStrength[p])// find first enabled 
		{
			CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CRunType[E_WC_NPN] = CModelArray[p];

			break;
		}
	}
	for(p = 0; p < 3; p++)
	{
		if(CWorstCase[E_WORST_CASE_PNP].CStrength[p])// find first enabled 
		{
			CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CRunType[E_WC_PNP] = CModelArray[p];

			break;
		}
	}
	for(p = 0; p < 3; p++)
	{
		if(CWorstCase[E_WORST_CASE_NMOS].CStrength[p])// find first enabled 
		{
			CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CRunType[E_WC_NMOS] = CModelArray[p];

			break;
		}
	}
	for(p = 0; p < 3; p++)
	{
		if(CWorstCase[E_WORST_CASE_PMOS].CStrength[p])// find first enabled 
		{
			CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CRunType[E_WC_PMOS] = CModelArray[p];

			break;
		}
	}
	for(p = 0; p < 3; p++)
	{
		if(CWorstCase[E_WORST_CASE_RLC].CStrength[p])// find first enabled 
		{
			CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CRunType[E_WC_RLC] = CModelArray[p];

			break;
		}
	}
	for(p = 0; p < 3; p++)
	{
		if(CWorstCase[E_WORST_CASE_GENERATOR].CStrength[p])// find first enabled 
		{
			CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CRunType[E_WC_GENERATOR] = CModelArray[p];

			break;
		}
	}
	for(p = 0; p < 3; p++)
	{
		if(CWorstCase[E_WORST_CASE_SUB].CStrength[p])// find first enabled 
		{
			CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CRunType[E_WC_SUBCKT] = CModelArray[p];

			break;
		}
	}
	for(p = 0; p < 3; p++)
	{
		if(CWorstCase[E_WORST_CASE_QR].CStrength[p])// find first enabled 
		{
			CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CRunType[E_WC_QRC] = CModelArray[p];

			break;
		}
	}
	for(p = 0; p < 3; p++)
	{
		if(CWorstCase[E_WORST_CASE_TEMP].CStrength[p])// find first enabled 
		{
			CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CRunType[E_SPICE_TEMP] = CModelArray[p];

			break;
		}
	}
}

void TCSuperSpiceDoc::SetupWCParameterNonSweepValues(TCSelectParameter &CSelectParameter)
{
	double value=1;

	if(CSelectParameter.CSweepData.enable) return; // Ignore sweept ones

	if(!GetBOMWCComponentValue(CSelectParameter.CRefDesignator, value)) return; 

	CSelectParameter.CSweepData.enable = true;

	CSelectParameter.CSweepData.start = value; // forces a single entry at the wc value
	CSelectParameter.CSweepData.stop = value;  // This is a round about way, but uses existing code
	CSelectParameter.CSweepData.step = value;
	CSelectParameter.CSweepData.type = E_PARAMETER_SWEEP_TYPE_LINEAR;
}

bool TCSuperSpiceDoc::GetBOMWCComponentValue(CString CRefDes, double &value)
{
	// RCL WC for parameter sweeps

	char type;
	double mult = 1;
	double alpha = 0;
	CString CParamParentRefDes, CLCParentRefDes;

	value = 1;// default
	
	CLCParentRefDes = CParentRefDes;

	CLCParentRefDes.MakeLower();
	CRefDes.MakeLower();

	TCWorstCaseData &CWorstCase = CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CWorstCase[E_WORST_CASE_RLC];
	
	int  hierarchy = CRefDes.Find(':');// Only compare with this schematic

	if(!(hierarchy < 0))
	{
		CParamParentRefDes = CRefDes.Right(CRefDes.GetLength() - hierarchy -1);

		if(CParamParentRefDes != CLCParentRefDes) return false;

		CRefDes = CRefDes.Left(hierarchy);
	}

	TCSchematicObject *PCSchematicObject = FindSchematicObject(CRefDes);

	if(!PCSchematicObject) return false;

	type = CRefDes.GetAt(0);

//	if(type != 'r' && type != 'c' && type != 'l' && type != 'v' && type != 'i') return false;

	if(type != 'r' && type != 'c' && type != 'l') return false;

	if(CWorstCase.strong)// select only one corner
		alpha = -1;
	else if(CWorstCase.nominal)
		alpha = 0;
	else if(CWorstCase.weak)
			alpha = 1;

	if(!alpha) return false;// don't add lines for nominal, gives less garbage in sweep file.

	if(type == 'r')
	{
		value = PCSchematicObject->CMSchematicObjectData.GetComponentValue(E_COMPONENT_VALUE);

		mult = 1 + alpha * CMSuperSpiceDocData.PCAnalysisSetup->CReRun.resistor_tol/100;	
	}
	else if(type == 'c')
	{
		value = PCSchematicObject->CMSchematicObjectData.GetComponentValue(E_COMPONENT_VALUE);

		mult = 1 + alpha * CMSuperSpiceDocData.PCAnalysisSetup->CReRun.capacitor_tol/100;
	}
	else if(type == 'l')
	{
		value = PCSchematicObject->CMSchematicObjectData.GetComponentValue(E_COMPONENT_VALUE);

		mult = 1 + alpha * CMSuperSpiceDocData.PCAnalysisSetup->CReRun.inductor_tol/100;
	}
/*
	else if(type == 'v' || type == 'i')
	{
		mult = 1 + alpha * CMSuperSpiceDocData.PCAnalysisSetup->CReRun.generator_tol/100;
	}
*/	
	value *= mult;

	return true;
}

bool TCSuperSpiceDoc::GenerateMCData(CString CFileName)
{
	TCReRuns CReRuns;
	CMBillOfMaterialsList;
	CArray <TCReRunData, TCReRunData &> CDataList;

	TCReRunData CData;

	int number_of_runs = (int)CMSuperSpiceDocData.PCAnalysisSetup->CReRun.number_of_wc_runs;

	int count = CMBillOfMaterialsList.GetSize();

	char test;

	for(int p = 0; p < count; p++)
	{
		TCBillOfMaterials &CBillOfMaterials = CMBillOfMaterialsList[p];

		CBillOfMaterials.CMCRunType = GetMCRunType(CBillOfMaterials); //_XW from NPN name etc

		CBillOfMaterials.CRefDes.MakeLower();

		test = CBillOfMaterials.CRefDes.GetAt(0);

		if(test != 'd' && test != 'q' && test != 'm' && test != 'j'  && test != 'z' &&
		   test != 'r' && test != 'l' && test != 'c') continue;

		CData = CBillOfMaterials;

		CData.CParamName = "";

		if(CBillOfMaterials.property_view == E_PROPERTY_INDUCTOR)
		{	
			CData.mean	= CBillOfMaterials.value;
			CData.sigma = CMSuperSpiceDocData.PCAnalysisSetup->CReRun.inductor_tol/100;
			CData.sigma *= CData.mean / 3;// sigma referenced to mean, the as tol is assumed to be 3 Sigma

			CDataList.Add(CData);

			continue;
		}
		else if(CBillOfMaterials.property_view == E_PROPERTY_RESISTOR )
		{
			CData.mean	= CBillOfMaterials.value;
			CData.sigma = CMSuperSpiceDocData.PCAnalysisSetup->CReRun.resistor_tol/100;
			CData.sigma *= CData.mean / 3;// sigma referenced to mean, the as tol is assumed to be 3 Sigma

			CDataList.Add(CData);

			continue;
		}

		else if(CBillOfMaterials.property_view == E_PROPERTY_CAPACITOR)
		{
			CData.mean	= CBillOfMaterials.value;
			CData.sigma = CMSuperSpiceDocData.PCAnalysisSetup->CReRun.capacitor_tol/100;
			CData.sigma *= CData.mean / 3;// sigma referenced to mean, the as tol is assumed to be 3 Sigma

			CDataList.Add(CData);

			continue;
		}

		if(CBillOfMaterials.GetFirstParameter(CData.CParamName, CData.mean, CData.sigma))
		{
			CData.CModelName = CData.CRefDes + CData.CModelName;

			CDataList.Add(CData);

			while(CBillOfMaterials.GetNextParameter(CData.CParamName, CData.mean, CData.sigma)) CDataList.Add(CData);
		}
	}

	return CReRuns.GenerateMonteCarlo(CFileName, CDataList, number_of_runs, CMSuperSpiceDocData.PCAnalysisSetup->CReRun.distribution);
}

CString TCSuperSpiceDoc::GetMCRunType(TCBillOfMaterials &CBillOfMaterials)
{
	CString CModelType = CBillOfMaterials.CModelType;
	CString CWCType = "_XN";
		
	int count, p, type=0;

	count = CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CWorstCase.GetSize(); // e.g. NPN is _XW
		
	if(!(E_WORST_CASE_COUNT < count)) return CWCType; // can't happen

	type = CMSuperSpiceDocData.PCAnalysisSetup->CReRun.GetModifiedSpiceModelType(CModelType); 

	if(!type) return CWCType;

	switch(type)
	{
		case E_SPICE_NPN: CModelType = "NPN" ; break;
		case E_SPICE_PNP: CModelType = "PNP" ; break;
		case E_SPICE_NJF: CModelType = "NMOS" ; break;
		case E_SPICE_PJF: CModelType = "PMOS" ; break;
		case E_SPICE_NMF: CModelType = "NMOS" ; break;
		case E_SPICE_PMF: CModelType = "PMOS" ; break;
		case E_SPICE_NMOS: CModelType = "NMOS" ; break;
		case E_SPICE_PMOS: CModelType = "PMOS" ; break;

		case E_WC_RLC: CModelType = "RLC" ;break;// Added 20th May 2016 fix for MC in resister models

//		default: return CModelType;
		default: return CWCType;
	}

	for(p = 0; p < E_WORST_CASE_COUNT; p++)
	{
		TCWorstCaseData &CWorstCaseData = CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CWorstCase[p];
 
		CWCType = CWorstCaseData.CTypeName;

		if(CWCType != CModelType) continue;

		if(CWorstCaseData.nominal)
			return "_XN";

		else if(CWorstCaseData.strong)
			return "_XS";

		else if(CWorstCaseData.weak)
			return "_XW";

		return CWCType;
	}

	return CWCType;
}

bool TCSuperSpiceDoc::SetupMC(void)
{
	if(CMSuperSpiceDocData.PCAnalysisSetup->CReRun.enable != E_RERUN_SWEEP_TYPE_MC_RERUN_FILE) return true;

	TCParametricSetupData &CParametricSetupData = CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData;

	double temp = CParametricSetupData.CSweepData.index;

	CParametricSetupData.CSweepData.index = 0;// Why? will check to remove this.

	CString CFileName = RemoveExtention(CThisFileName);

	CFileName += "MC.rrn";

	if(!GenerateMCData(CFileName)) return false;

	if(!SetupSweepFile(CFileName)) return false;

	CParametricSetupData.CSweepData.index = temp;

	return true;
}


bool TCSuperSpiceDoc::SetupNextParameterRun(void)
{ 
	if(CMSuperSpiceDocData.PCAnalysisSetup->CTemperatureSetupData.CSweepData.enable &&
	   (CMSuperSpiceDocData.PCAnalysisSetup->CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_MULTY_RUNS)) 
		if(!CMSuperSpiceDocData.PCAnalysisSetup->CReRun.enable)// cant get here unless rerun.enable == 1
			if(!SetupNextTemperatureRun()) 
			{
				RestoreTemp();

				return false;
			}
			else
			{
				CreateModelLines();

				return true;
			}

	if(CMSuperSpiceDocData.PCAnalysisSetup->CReRun.enable == E_RERUN_SWEEP_TYPE_WC_MODEL_FILES)
	{
		CArray <CString, CString&> CModelLines;

		int mode = 0;

		if(SetupNextWorstCase(mode) == "") 
		{
			return false;
		}
		
		return true;
	}

	if(CMSuperSpiceDocData.PCAnalysisSetup->CReRun.enable == E_RERUN_SWEEP_TYPE_WC_RERUN_FILE) return false;

	if(CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData.CSweepData.enable)
	{
		if(SetupNextParameterSweep() == "") 
		{
			return false;
		}
		
		CreateModelLines();

		return true;
	}

	CreateModelLines();

	return true;
}


CString TCSuperSpiceDoc::SetupWorstCase(int mode)
{
	CString CText;

	if(GCAuthorization.m_build_type2 == E_FULL_RELEASE_STUDENT || GCAuthorization.m_build_type2 == E_RESTRICTED_RELEASE_STUDENT || GCAuthorization.m_build_type2 == E_AUTHORIZATION_MASTER_PASSWORD_STUDENT) return CText;
	if(!CMSuperSpiceDocData.PCAnalysisSetup) return CText;

	int number_of_runs = CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CalculateNumberOfReRuns();

	if(mode) 
	{
		number_of_runs++;// Re-Add in the base run, 13th dec 2008

		CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]->CRunDiscription = "Nominal Run";// Re-Add in the base run, 13th dec 2008
	}

	if(!number_of_runs) return CText;

	CMSuperSpiceDocData.CWaveformDataRuns.SetSize(number_of_runs);
	
	int count = CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize();

	if(!count) return CText;

	CArray <TCWorstCaseData, TCWorstCaseData&> &CWorstCase = CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CWorstCase;

	CMSuperSpiceDocData.PCAnalysisSetup->CReRun.SetStrength();// sets up strong, weak, nominal for array scaning

	CArray <CString, CString> CStrengthArray;
	CString CTesting;

	CStrengthArray.SetSize(3);
	CStrengthArray[0] = 'S';
	CStrengthArray[1] = 'N';
	CStrengthArray[2] = 'W';

	CArray <CString, CString> CModelArray;

	CModelArray.SetSize(3);
	CModelArray[0] = "_XS";
	CModelArray[1] = "_XN";
	CModelArray[2] = "_XW";


	CString CSpacer = ":";// this character takes up less space in the display

	int p,q,r,s,t,u,v,w,x, index;

	index = mode;

	CString CName;

	for(p = 0; p < 3; p++)//NPN
	{
		if(!CWorstCase[0].CStrength[p])	continue;

		for(q = 0; q < 3; q++)//PNP
		{
			if(!CWorstCase[1].CStrength[q])	continue;

			for(r = 0; r < 3; r++)// NMOS
			{
				if(!CWorstCase[2].CStrength[r])	continue;

				for(s = 0; s < 3; s++)//PMOS
				{
					if(!CWorstCase[3].CStrength[s])	continue;

					for(t = 0; t < 3; t++)// Diode
					{
						if(!CWorstCase[4].CStrength[t])	continue;

						for(u = 0; u < 3; u++)//R
						{
							if(!CWorstCase[5].CStrength[u])	continue;

							for(v = 0; v < 3; v++)// L
							{
								if(!CWorstCase[6].CStrength[v])	continue;

								for(w = 0; w < 3; w++)//C
								{
									if(!CWorstCase[7].CStrength[w])	continue;

									// this would be a program fault
									if(!(index < count)) return CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]->CRunDiscription;


									CName = CStrengthArray[p] + CWorstCase[E_WORST_CASE_NPN].CName + CSpacer;
									CName += CStrengthArray[q] + CWorstCase[E_WORST_CASE_PNP].CName + CSpacer;
									CName += CStrengthArray[r] + CWorstCase[E_WORST_CASE_NMOS].CName + CSpacer;
									CName += CStrengthArray[s] + CWorstCase[E_WORST_CASE_PMOS].CName + CSpacer;
									CName += CStrengthArray[u] + CWorstCase[E_WORST_CASE_RLC].CName + CSpacer;
									CName += CStrengthArray[v] + CWorstCase[E_WORST_CASE_GENERATOR].CName + CSpacer;
									CName += CStrengthArray[w] + CWorstCase[E_WORST_CASE_SUB].CName + CSpacer;
									CName += CStrengthArray[t] + CWorstCase[E_WORST_CASE_QR].CName + CSpacer;

									CTesting = CModelArray[p];
									// this stuff replaces the normal model selected on the schematic
	
									for(x = 0; x < 3; x++)//Temperature
									{
										if(!CWorstCase[8].CStrength[x])	continue;

										CMSuperSpiceDocData.CWaveformDataRuns.CRuns[index]->CRunType[E_SPICE_NPN]	= CModelArray[p];
										CMSuperSpiceDocData.CWaveformDataRuns.CRuns[index]->CRunType[E_SPICE_PNP]	= CModelArray[q];
										CMSuperSpiceDocData.CWaveformDataRuns.CRuns[index]->CRunType[E_SPICE_NMOS] = CModelArray[r];
										CMSuperSpiceDocData.CWaveformDataRuns.CRuns[index]->CRunType[E_SPICE_PMOS] = CModelArray[s];
										CMSuperSpiceDocData.CWaveformDataRuns.CRuns[index]->CRunType[E_SPICE_D]  = CModelArray[t];// To moved to NPN, CModelArray[t];
										CMSuperSpiceDocData.CWaveformDataRuns.CRuns[index]->CRunType[E_SPICE_R]	= CModelArray[u];
										CMSuperSpiceDocData.CWaveformDataRuns.CRuns[index]->CRunType[E_SPICE_L]	= CModelArray[v]; // Moved to Generator
										CMSuperSpiceDocData.CWaveformDataRuns.CRuns[index]->CRunType[E_SPICE_C]	= CModelArray[w];

										CMSuperSpiceDocData.CWaveformDataRuns.CRuns[index]->CRunType[E_SPICE_NJF] = CModelArray[r];
										CMSuperSpiceDocData.CWaveformDataRuns.CRuns[index]->CRunType[E_SPICE_PJF] = CModelArray[s];

										CMSuperSpiceDocData.CWaveformDataRuns.CRuns[index]->CRunType[E_SPICE_NMF] = CModelArray[r];
										CMSuperSpiceDocData.CWaveformDataRuns.CRuns[index]->CRunType[E_SPICE_PMF] = CModelArray[s];
								
										CMSuperSpiceDocData.CWaveformDataRuns.CRuns[index]->CRunDiscription = CName + CStrengthArray[x] + CWorstCase[8].CName;

										CTesting = CStrengthArray[x];

										CMSuperSpiceDocData.CWaveformDataRuns.CRuns[index]->CRunType[E_SPICE_TEMP] = CTesting;// passed to options to id temp

										index++;
									}
								}
							}
						}
					}
				}
			}
		}
	}

	SetupNextWorstCase(mode);// setup first models

	return CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]->CRunDiscription;// first run name
}


CString TCSuperSpiceDoc::GetSchematicParameters()
{
	CString CSchematicParameters;

	if(CMSuperSpiceDocData.PCAnalysisSetup->parameter_sweep_mode)
	{
		CSchematicParameters = CMSuperSpiceDocData.PCAnalysisSetup->GetResolvedParameters(CMSuperSpiceDocData.PCAnalysisSetup->CParameterDefsSweepParameters);
	}
	else
	{
		CSchematicParameters = CMSuperSpiceDocData.PCAnalysisSetup->GetResolvedParameters(CMSuperSpiceDocData.PCAnalysisSetup->CSchematicDefsParameters);
	}

	return CSchematicParameters;
}

double TCSuperSpiceDoc::EvaluateComponentValue(CString CLable)
{
	double data = 0;
	
	if(!CMSuperSpiceDocData.PCAnalysisSetup) 
	{
		data = SpiceMKSStringToFloat(CLable);

		return data;
	}

	data = CMSuperSpiceDocData.PCAnalysisSetup->EvaluateComponentValue(CLable);

	return data;
}

void TCSuperSpiceDoc::SetupMultipleParameterSweepPointers(void)
{
	int count;
	int p, flag = false;

	count = CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData.CData.GetSize();

	if(!count) return;

	for(p = 0; p < count; p++)
	{
		if(!CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData.CData[p].PCParameter) continue;

		flag = true;

		break;
	}
	
	if(flag) return;// other then initial schematic load, this will always be set after a net list.

	GenerateUniqueSchematicManagers();

	PCMNetList->InitaliseAnalysisSetup(CMUniqueSchematicManagerList, *CMSuperSpiceDocData.PCAnalysisSetup, CParentRefDes);
}

TCSuperSpiceDoc *TCSuperSpiceDoc::OpenChildSchematic(TCDocumentWindowsListData CDocumentWindowsListData, bool visable)
{
	TCSuperSpiceDoc *PCSuperSpiceDoc;

	CString CErrorText;

	CMultiDocTemplate *PCMultiDocTemplate = (CMultiDocTemplate *)GetDocTemplate();

	if(!PCMultiDocTemplate) return NULL;

	CString CMsg, CFileName;

	if(!FileExists(CDocumentWindowsListData.CFileName)) 
	{
		//try same directory as top_level
		CFileName = GetRelativeFileName(CDocumentWindowsListData.CFileName);

		if(!FileExists(CFileName))
		{
			CMsg.LoadString(IDS_UNABLE_TO_FIND_SCHFILE);

			CErrorText = CMsg + ' ' + CFileName;

			DisplayError(IDS_EER_STATUS, CErrorText, 0);

			return NULL;
		}
	}

	PCSuperSpiceDoc = (TCSuperSpiceDoc *)PCMultiDocTemplate->OpenDocumentFile(CDocumentWindowsListData.CFileName, visable);// invisable

	if(!PCSuperSpiceDoc) 
	{
		CMsg.LoadString(IDS_UNABLE_TO_OPEN_FILE);

		CErrorText = CMsg + ' ' + CFileName;

		DisplayError(IDS_EER_STATUS, CErrorText, 0);

		return NULL;
	}
		
	PCSuperSpiceDoc->SetParent(this, CThisFileName, CDocumentWindowsListData.CParentRefIDList, CDocumentWindowsListData.CParentRefDes);

	SyncAnalysisSetup(PCSuperSpiceDoc);

	return PCSuperSpiceDoc;
}

void TCSuperSpiceDoc::SetupAllChildMultipleParameterSweeps(CArray <TCSelectParameter, TCSelectParameter &> &CData)
{
	TCSuperSpiceDoc *PCCSuperSpiceDoc;

	int p;

	int param_count = CData.GetSize();

	for(p = 0; p < param_count; p++) 
	{
		SetupWCParameterNonSweepValues(CData[p]);
	}

	int count = CDocumentWindowsList.CDocList.GetSize();
	int close_doc = false;
	CArray <TCSchematicObject*, TCSchematicObject*> CSchematicObjectList;
	int number_of_subckts, q;
	CString CSubCktRefDes;

	for(p = 0; p < count; p++)
	{
		TCDocumentWindowsListData &CDocumentWindowsListData = CDocumentWindowsList.CDocList[p];

		if(CDocumentWindowsListData.type != E_SCHEMATIC_DOCUMENT) continue;

		if(!CDocumentWindowsListData.is_open) 
		{
			PCCSuperSpiceDoc = OpenChildSchematic(CDocumentWindowsListData, false);// invisable

			if(!PCCSuperSpiceDoc) continue;

			close_doc = true;
		}
		else
		{
			PCCSuperSpiceDoc = (TCSuperSpiceDoc*) CDocumentWindowsListData.PCDoc;
		}

		if(!PCCSuperSpiceDoc) continue;
	
		number_of_subckts = GetSubCktList(CDocumentWindowsListData.CFileName, CSchematicObjectList);

		// for each schematic subckt of the same type, create repeated CData with appropiate refdes name
		// Bug is all variations of one sweep are done. Fix later
		for(q = 0; q < number_of_subckts; q++)
		{
			CSubCktRefDes = GetSubCktRefDes(CSchematicObjectList[q], CDocumentWindowsListData.CParentRefDes);

			PCCSuperSpiceDoc->CParentRefDes = CSubCktRefDes;

			PCCSuperSpiceDoc->SetupChildMultipleParameterSweeps(CData);
		}

		PCCSuperSpiceDoc->SetupAllChildMultipleParameterSweeps(CData);

		if(close_doc) PCCSuperSpiceDoc->OnCloseDocument();

		close_doc = false;
	}
}

void TCSuperSpiceDoc::SetupChildMultipleParameterSweeps(CArray <TCSelectParameter, TCSelectParameter &> &CData)
{
	SetupMultipleParameterSweepPointers();// get this data

	CArray <TCSelectParameter, TCSelectParameter &> &CThisData = CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData.CData;

	int base_count, added_count, new_count;

	base_count = CData.GetSize();

	added_count = CThisData.GetSize();

	new_count = base_count + added_count;

	if(!new_count) return;

	CArray <TCSelectParameter, TCSelectParameter &> CNewData;

	CNewData.SetSize(new_count);

	int p;

	for(p = 0; p < base_count; p++)
	{
		CNewData[p] = CData[p];
	}

	CString CRefDes;

	for(p = base_count; p < new_count; p++)
	{
		TCSelectParameter &CData = CThisData[p - base_count];
	
		CNewData[p] = CData;

		CRefDes = CData.CRefDesignator;

		if(CParentRefDes != "" && GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist) 
		{
			CRefDes = CRefDes + ":" + CParentRefDes;// add hierarchy.

			CNewData[p].CRefDesignator = CRefDes;
		}
	}

	CData.SetSize(new_count);

	for(p = 0; p < new_count; p++)
	{
		CData[p] = CNewData[p];
	}
}

bool TCSuperSpiceDoc::CreateMultipleParameterSweeps(void)
{
	TCReRuns CReRuns;

	return CreateParameterRerunFile(CReRuns);
}

bool TCSuperSpiceDoc::SetupParameterSweepFile(void)
{
	TCReRuns CReRuns;

	if(!CreateParameterRerunFile(CReRuns)) return false;

	int number_of_runs = CReRuns.CReRunDataList.GetSize();

	if(!number_of_runs) return false;

	number_of_runs++; // include the first nominal run

	CMSuperSpiceDocData.CWaveformDataRuns.SetSize(number_of_runs);

	CString CName;

	CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]->CRunDiscription = "Base Run";

	for(int p = 0; p < number_of_runs - 1; p++)
	{
		CName = CReRuns.CReRunDataList[p].CName;

		if(CName == "") CName.Format("Run %d", p + 1);

		CMSuperSpiceDocData.CWaveformDataRuns.CRuns[p + 1]->CRunDiscription = CName;
		
	}

	return true;
}

bool TCSuperSpiceDoc::CreateParameterRerunFile(TCReRuns &CReRuns)
{
	CString CFileName = CThisFileName;

	CFileName = RemoveExtention(CThisFileName);

	CFileName += "RRN.rrn";

	CReRuns.enable = true;

	SetupMultipleParameterSweepPointers();

	CArray <TCSelectParameter, TCSelectParameter &> CParamData;

	int count = CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData.CData.GetSize();

	CParamData.SetSize(count);

	for(int p = 0; p < count; p++) 
	{
		CParamData[p] = CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData.CData[p];
	}

	SetupAllChildMultipleParameterSweeps(CParamData);

	count = CParamData.GetSize();

	if(!CReRuns.CreateParameterReRuns(CFileName, CParamData))
	{
		DisplayError(IDS_EER_STATUS, IDS_UNABLE_TO_CREATE_RRN_FILE);

		return false;
	}

	return true;
}

bool TCSuperSpiceDoc::SetupSweepFile(CString CRerunFileName)
{
	// Used for Parameters or WC sweep files
	int p;

	TCParametricSetupData &CParametricSetupData = CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData;

	CString CFileName = CParametricSetupData.CValue;

	if(CRerunFileName != "") CFileName = CRerunFileName;

	CParametricSetupData.source_id = 0;//Force a NULL selection
	CParametricSetupData.CSource = "";

	if(!FileExists(CFileName)) 
	{	
		CParametricSetupData.CValue = ReplaceFileExtension(CThisFileName, "rrn");

		CFileName = CParametricSetupData.CValue;
	}

	TCReRuns CReRuns;

	CReRuns.enable = true;

	if(CMSuperSpiceDocData.PCAnalysisSetup->CReRun.enable != E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)// clash with mc
	if(CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CReserved.CIntArray[E_PARAMETER_AUTO_GENERATE_RNN_FILE])// use rrg file to generate the rerun file
	{
		CString CLocalFileName;

		CLocalFileName = RemoveExtention(CFileName);

		CLocalFileName += ".rrg";

		if(!CReRuns.LoadSetup(CLocalFileName))
		{
			DisplayError(IDS_EER_STATUS, IDS_UNABLE_TO_CREATE_RRN_FILE);

			return false;
		}	
	}

	if(!FileExists(CFileName))
	{
		CString CText;

		CText.LoadString(IDS_N0_RERUN_FILE);

		CText += " " + CFileName;

		DisplayError(IDS_EER_STATUS, IDS_N0_RERUN_FILE);

		return false;
	}

	if(!CReRuns.Load(CFileName))
	{
		DisplayError(IDS_EER_STATUS, IDS_INVALID_PARAMETER_FILE);

		return false;
	}

	int number_of_runs = CReRuns.CReRunDataList.GetSize();

	if(!number_of_runs) return false;

	number_of_runs++; // include the first nominal run

	CMSuperSpiceDocData.CWaveformDataRuns.SetSize(number_of_runs);

	CString CName;

	if(CMSuperSpiceDocData.PCAnalysisSetup->CReRun.enable != E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
	{
		CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]->CRunDiscription = "Base Run";

		for(p = 0; p < number_of_runs - 1; p++)
		{
			CName = CReRuns.CReRunDataList[p].CName;

			CMSuperSpiceDocData.CWaveformDataRuns.CRuns[p + 1]->CRunDiscription = CName;
		}
	}
	else
	{
		for(p = 0; p < number_of_runs; p++)
		{
			CName.Format("Run %d", p); // This data does not get passed as GenerateMCData() gets called first 

			CMSuperSpiceDocData.CWaveformDataRuns.CRuns[p]->CRunDiscription = CName;
		}
	}

	return true;
}

bool  TCSuperSpiceDoc::SetupParameterSweep(void)
{
	CString CText;

	if(GCAuthorization.m_build_type2 == E_FULL_RELEASE_STUDENT || GCAuthorization.m_build_type2 == E_RESTRICTED_RELEASE_STUDENT || GCAuthorization.m_build_type == E_AUTHORIZATION_MASTER_PASSWORD_STUDENT) return false;
	if(!CMSuperSpiceDocData.PCAnalysisSetup) return false;

	TCParametricSetupData &CParametricSetupData = CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData;

	if(!CMSuperSpiceDocData.PCAnalysisSetup->CReRun.xspice_run_mode)
		CParametricSetupData.CSweepData.sweep_type = E_PARAMETER_RUN_MODE_MODEL_FILE;
	else
	{
		if(CParametricSetupData.CSweepData.type == E_PARAMETER_SWEEP_TYPE_EXTERNAL_FILE)
			CParametricSetupData.CSweepData.sweep_type = E_PARAMETER_RUN_MODE_EXTERNAL_FILE;
		else
			CParametricSetupData.CSweepData.sweep_type = E_PARAMETER_RUN_MODE_INTERNAL_FILE;
	}

	if(CParametricSetupData.CSweepData.sweep_type == E_PARAMETER_RUN_MODE_EXTERNAL_FILE) return SetupSweepFile(""); //SetupSweepFile used for param and wc
	if(CParametricSetupData.CSweepData.sweep_type == E_PARAMETER_RUN_MODE_INTERNAL_FILE) return SetupParameterSweepFile(); // only for Param sweep file

	int number_of_runs = CParametricSetupData.GetCount();// Assumes only single param sweept

	if(!number_of_runs) return false;

	int source_id = CParametricSetupData.GetSweptRefDesID();

	if(source_id < 0) return false;

	int source_size = CParametricSetupData.CData.GetSize();

	if(!source_size) return false;

	CMSuperSpiceDocData.CWaveformDataRuns.SetSize(number_of_runs);
	
	int count = CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize();

	if(!count) return false;

	double value = 0;

	CString CName = CParametricSetupData.GetSweptParamName();

	value = CParametricSetupData.GetFirstValue();

	for(int p = 0; p < count; p++)
	{
		CText = CName + '=' + FloatToSpiceMKSString(value);

		CMSuperSpiceDocData.CWaveformDataRuns.CRuns[p]->CRunDiscription = CText;

		value = CParametricSetupData.GetNextValue();
	}

	value = CParametricSetupData.GetFirstValue();

	CText = FloatToSpiceMKSString(value);

	CParametricSetupData.CValue = CText;

	// Schematic Param setup
	if(CParametricSetupData.IsSwept(CMSuperSpiceDocData.PCAnalysisSetup->CSelectParameter.CRefDesignator))
	{
		CMSuperSpiceDocData.PCAnalysisSetup->parameter_sweep_mode = true;//

		SetParameterSweepParameter(value);
	}

	return true;
}

void TCSuperSpiceDoc::SetParameterSweepParameter(double value)
{
	TCParametricSetupData &CParametricSetupData = CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData;

	int id;

	id = CParametricSetupData.GetSweptParamID();

	if(id < 0) return;

	CMSuperSpiceDocData.PCAnalysisSetup->SetParameterSweepParameter(id, value);
}

CString TCSuperSpiceDoc::SetupNextWorstCase(int mode)
{
	CString CText;

	int start = mode; 

	if(GCAuthorization.m_build_type2 == E_FULL_RELEASE_STUDENT || GCAuthorization.m_build_type == E_RESTRICTED_RELEASE_STUDENT || GCAuthorization.m_build_type2 == E_AUTHORIZATION_MASTER_PASSWORD_STUDENT) return CText;

	int count = CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize();

	if(!count) return CText;

	if(!(m_runs_counter + start < count)) return CText;

	TCOutputWaveformData &COutputWaveformData = *CMSuperSpiceDocData.CWaveformDataRuns.CRuns[m_runs_counter + start];

	TCReRun &CReRun = CMSuperSpiceDocData.PCAnalysisSetup->CReRun;

	int count1, count2;

	count1 = CReRun.CRunType.GetSize();
	count2 = COutputWaveformData.CRunType.GetSize();
	
	if(!count2) return CText;
	if(!(count2 <= count1)) count2 = count1;


	//CMAnalysisSetup.CReRun.CRunType is passed to netlister
	int p;

	for(p = 0; p < count2; p++) CReRun.CRunType[p] = COutputWaveformData.CRunType[p];
 
///////// If no .subckts swept use a rerun file

	TCWorstCaseData &CWorstCase = CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CWorstCase[E_WORST_CASE_SUB];

	if(CMSuperSpiceDocData.PCAnalysisSetup->CReRun.xspice_run_mode)
		if(!CWorstCase.weak)// use new file method if subckt not swept
			if(!CWorstCase.strong) 
				CMSuperSpiceDocData.PCAnalysisSetup->CReRun.enable = E_RERUN_SWEEP_TYPE_WC_RERUN_FILE;
	
////////

	CText =	CMSuperSpiceDocData.CWaveformDataRuns.CRuns[m_runs_counter + start]->CRunDiscription;

	if(CMSuperSpiceDocData.PCAnalysisSetup->CReRun.enable == E_RERUN_SWEEP_TYPE_WC_MODEL_FILES)
	{
		CreateModelLines();

		return CText;
	}

	//Only gets here for a file wc, and only once
	// need to include base run as the file MC start after the first main run
	// then do not load it in as it contaminates things


	CArray <CString, CString&> CModelLines;

	TCReRuns CReRuns, CReRunsNext;

	CString CFileName = CThisFileName;

	CFileName = RemoveExtention(CThisFileName);

	CFileName += "WC.rrn";

	TCReRunWCData CReRunWCData;
	 
	CReRunWCData.l_sigma = CMSuperSpiceDocData.PCAnalysisSetup->CReRun.inductor_tol/100;
	CReRunWCData.c_sigma = CMSuperSpiceDocData.PCAnalysisSetup->CReRun.capacitor_tol/100;
	CReRunWCData.r_sigma = CMSuperSpiceDocData.PCAnalysisSetup->CReRun.resistor_tol/100;
	CReRunWCData.ps_sigma = CMSuperSpiceDocData.PCAnalysisSetup->CReRun.generator_tol/100;
	CReRunWCData.t_max	= CMSuperSpiceDocData.PCAnalysisSetup->CReRun.temp_max;
	CReRunWCData.t_min	= CMSuperSpiceDocData.PCAnalysisSetup->CReRun.temp_min;
	CReRunWCData.t_nom	= CMSuperSpiceDocData.PCAnalysisSetup->CReRun.temp_nominal;

	for(p = start; p < count; p++)
	{
		//update the netlister each time
		TCOutputWaveformData &CWaveformData = *CMSuperSpiceDocData.CWaveformDataRuns.CRuns[p];

		for(int q = 0; q < count2; q++) CReRun.CRunType[q] = CWaveformData.CRunType[q];
		//update the netlister each time

		CText =	CMSuperSpiceDocData.CWaveformDataRuns.CRuns[p]->CRunDiscription;

		CModelLines.SetSize(0);// clear old data

		if(!CreateWCModelLines(CModelLines, CReRun)) // go down the schematic hirachy and get all models
		{
			return "";		
		}

		TCReRuns CReRunsNext;

		CReRunsNext.CreateWCFromDotModels(CModelLines, CMSuperSpiceDocData.CWaveformDataRuns.CRuns[p]->CRunDiscription, CFileName, CReRunWCData);

		CReRuns += CReRunsNext;
	}

	CReRuns.Save(CFileName);

	return CText;
}

CString	TCSuperSpiceDoc::SetupNextParameterSweep(void)
{
	CString CText;

	if(GCAuthorization.m_build_type2 == E_FULL_RELEASE_STUDENT || GCAuthorization.m_build_type2 == E_RESTRICTED_RELEASE_STUDENT || GCAuthorization.m_build_type2 == E_AUTHORIZATION_MASTER_PASSWORD_STUDENT) return CText;
	if(!CMSuperSpiceDocData.PCAnalysisSetup) return CText;

	TCParametricSetupData &CParametricSetupData = CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData;

	int number_of_runs = CParametricSetupData.CSweepData.GetCount();

	if(!number_of_runs) return CText;

	int count = CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize();

	if(!count) return CText;

	double value;

	value = CParametricSetupData.GetNextValue();

	CText = FloatToSpiceMKSString(value);

	CParametricSetupData.CValue = CText;

	// Schematic Param setup
	if(CParametricSetupData.IsSwept(CMSuperSpiceDocData.PCAnalysisSetup->CSelectParameter.CRefDesignator))
	{
		SetParameterSweepParameter(value);
	}

	return CText;
}

bool TCSuperSpiceDoc::SetupTempRunNames(CString CParamName)
{
	TCTemperatureSetupData &CTemperatureSetupData = CMSuperSpiceDocData.PCAnalysisSetup->CTemperatureSetupData;
	TCBerklySpiceOptionsSetupData &CBerklySpiceOptionsSetupData = CMSuperSpiceDocData.PCAnalysisSetup->CBerklySpiceOptionsSetupData;

	if(!(E_OPTIONS_TEMP < CBerklySpiceOptionsSetupData.COptionsFloatData.GetSize())) return false;

	if(GCAuthorization.m_build_type2 == E_FULL_RELEASE_STUDENT || GCAuthorization.m_build_type2 == E_RESTRICTED_RELEASE_STUDENT || GCAuthorization.m_build_type2 == E_AUTHORIZATION_MASTER_PASSWORD_STUDENT) return false;

	m_restore_temperature = CBerklySpiceOptionsSetupData.COptionsFloatData[E_OPTIONS_TEMP].value;

	int count = CTemperatureSetupData.GetCount();

	if(!count) return false;

	CMSuperSpiceDocData.CWaveformDataRuns.SetSize(count);
	
	count = CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize();

	if(!count) return false;

	CString CText;
	double value;
	float fvalue;

	if(!CTemperatureSetupData.GetFirstValue(value)) return false;

	fvalue = (float)value;

	for(int p = 0; p < count; p++)
	{
		if(!CMSuperSpiceDocData.CWaveformDataRuns.CRuns[p]) return false;

		CText.Format("TempSweep%d%s: %3.3f Degs.", p, CParamName, fvalue); 

		CMSuperSpiceDocData.CWaveformDataRuns.CRuns[p]->CRunDiscription = CText;
			
		if(!CTemperatureSetupData.GetNextValue(value)) break;
			
		fvalue = (float)value;
	}

	SetupTemperatureRuns();// reinit the temp valuse

	return true;
}


bool TCSuperSpiceDoc::SetupTemperatureRuns(void)
{
	TCTemperatureSetupData &CTemperatureSetupData = CMSuperSpiceDocData.PCAnalysisSetup->CTemperatureSetupData;
	TCBerklySpiceOptionsSetupData &CBerklySpiceOptionsSetupData = CMSuperSpiceDocData.PCAnalysisSetup->CBerklySpiceOptionsSetupData;

	double value;

	if(!CTemperatureSetupData.GetFirstValue(value)) return false;

	if(!(E_OPTIONS_TEMP < CBerklySpiceOptionsSetupData.COptionsFloatData.GetSize())) return false;

	m_restore_temperature = CBerklySpiceOptionsSetupData.COptionsFloatData[E_OPTIONS_TEMP].value;

	CBerklySpiceOptionsSetupData.COptionsFloatData[E_OPTIONS_TEMP].value = value;

	return true;
}

bool TCSuperSpiceDoc::SetupNextTemperatureRun(void)
{
	TCTemperatureSetupData &CTemperatureSetupData = CMSuperSpiceDocData.PCAnalysisSetup->CTemperatureSetupData;
	TCBerklySpiceOptionsSetupData &CBerklySpiceOptionsSetupData = CMSuperSpiceDocData.PCAnalysisSetup->CBerklySpiceOptionsSetupData;
	
	double value;

	if(!CTemperatureSetupData.GetNextValue(value)) return false;

	CBerklySpiceOptionsSetupData.COptionsFloatData[E_OPTIONS_TEMP].value = value;

	return true;
}

void TCSuperSpiceDoc::RestoreTemp(void)
{
	if(CMSuperSpiceDocData.PCAnalysisSetup->CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_VOLTS_V_TEMP) return;

	TCBerklySpiceOptionsSetupData &CBerklySpiceOptionsSetupData = CMSuperSpiceDocData.PCAnalysisSetup->CBerklySpiceOptionsSetupData;

	if(E_OPTIONS_TEMP < CBerklySpiceOptionsSetupData.COptionsFloatData.GetSize())
		CBerklySpiceOptionsSetupData.COptionsFloatData[E_OPTIONS_TEMP].value = m_restore_temperature;
				
}


int TCSuperSpiceDoc::CheckAndRunNextSpiceRun(void)
{
	if(!(CMSuperSpiceDocData.PCAnalysisSetup->CTemperatureSetupData.CSweepData.enable &&
		 CMSuperSpiceDocData.PCAnalysisSetup->CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_MULTY_RUNS) && 
		 CMSuperSpiceDocData.PCAnalysisSetup->CReRun.enable != E_RERUN_SWEEP_TYPE_WC_MODEL_FILES &&
		!CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData.CSweepData.enable)return false;

	if(CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData.CSweepData.enable)
	{
		if(CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData.CSweepData.sweep_type == E_PARAMETER_RUN_MODE_EXTERNAL_FILE)  return false;
		if(CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData.CSweepData.sweep_type == E_PARAMETER_RUN_MODE_INTERNAL_FILE)  return false;					
	}

	if(m_runs_counter < CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize())
	{
		if(!CMSuperSpiceDocData.CWaveformDataRuns.CRuns[m_runs_counter]) return false;

		if(!SetupNextParameterRun()) return false;

		CString COutputFileName = RemoveExtention(CMSuperSpiceDocData.CMasterNetListFileName);
		
		CString CText;

		CText.Format("%s%d.out", COutputFileName, m_runs_counter);

		if(!RunSpiceEngine(PCMRunsView, CText, false, 0)) // do not renetlist
		{
			m_runs_counter = CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize();
			m_runs_counter++;

			return false;
		}

		m_runs_counter++;

		return true;
	}

	return false;
}

void TCSuperSpiceDoc::DeleteOldFiles(int old_number_of_runs)
{
	int new_number_of_runs = CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize();

	if(new_number_of_runs >= old_number_of_runs) return;

	CMSuperSpiceDocData.CWaveformDataRuns.DeleteOldFiles(old_number_of_runs);
}

void TCSuperSpiceDoc::OnRunExitEngine(void)
{
	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp *) AfxGetApp();

	PCSuperSpiceApp->SendXSpiceQuitMessage(GetTopLevelDoc()->h_msg);

	CGlobalXSpiceMessage = CGlobalXSpiceStatusNull;

	m_is_simulation_paused = false;// let things happen

	if(SpiceEngineThreadId) GetTopLevelDoc()->MarchingWaveformEnd(1);

	m_runs_counter = 1 + CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize();
}

void TCSuperSpiceDoc::OnRunQuit() 
{
	if(m_runs_counter < 0) return;// crash bug fix 4th december 2004

	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp *) AfxGetApp();

	PCSuperSpiceApp->SendXSpiceQuitMessage(GetTopLevelDoc()->h_msg);

	CGlobalXSpiceMessage = CGlobalXSpiceStatusNull;

	GetTopLevelDoc()->OnRunStop();

	GetTopLevelDoc()->MarchingWaveformEnd(1);

	CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CReserved.CIntArray[E_DESIGNER_ENABLE_OPERATING_POINT] = false;	

	m_runs_counter = 1 + CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize();
}

void TCSuperSpiceDoc::OnRunStop() 
{
	StopTimer();

	if(HSpiceEngineThread /*HSpiceEngineProcess*/)
	{
		DWORD status;

		GetExitCodeProcess(HSpiceEngineProcess, &status);

		if(HSpiceEngineThread) CloseHandle(HSpiceEngineThread);
		if(HSpiceEngineProcess)CloseHandle(HSpiceEngineProcess);

		HSpiceEngineProcess = NULL;
		HSpiceEngineThread  = NULL;
		SpiceEngineProcessId = 0; 
		SpiceEngineThreadId = 0;

		CGlobalStatusMessage = "Simulation canceled";

		return;
	}


	if(HSpiceEngineProcess)CloseHandle(HSpiceEngineProcess);
    if(HSpiceEngineThread) CloseHandle(HSpiceEngineThread);
		
	HSpiceEngineProcess = NULL;
	HSpiceEngineThread  = NULL;
	SpiceEngineProcessId = 0; 
	SpiceEngineThreadId = 0;
}

void TCSuperSpiceDoc::OnSpiceEngineIsFinished(void)
{
	CGlobalXSpiceMessage = CGlobalXSpiceStatusNull;

	CMSuperSpiceDocData.PCAnalysisSetup->parameter_sweep_mode = false;//Ensure Schematic param sweeps are initially disabled 
	
	DisplayError(IDS_EER_STATUS, IDS_SIMULATION_COMPLETE);

	TCSuperSpiceTextDoc *PCSuperSpiceTextDoc = (TCSuperSpiceTextDoc *)CDocumentWindowsList.IsOpen(CMSuperSpiceDocData.CMasterOutputTextFileName);

	ResetSetLoopGainSource();

	if(PCSuperSpiceTextDoc)// update output text display
	{
		LoadGenericFromArchive(PCSuperSpiceTextDoc, CMSuperSpiceDocData.CMasterOutputTextFileName);

		PCSuperSpiceTextDoc->SetModifiedFlag(false);

		PCSuperSpiceTextDoc->UpdateTitle();
	}

	PCSuperSpiceTextDoc = (TCSuperSpiceTextDoc *)CDocumentWindowsList.IsOpen(CMSuperSpiceDocData.CMasterSpiceEngineLogFileName);
	
	if(PCSuperSpiceTextDoc)// update output log display
	{
		LoadGenericFromArchive(PCSuperSpiceTextDoc, CMSuperSpiceDocData.CMasterSpiceEngineLogFileName);
		PCSuperSpiceTextDoc->SetModifiedFlag(false);
		PCSuperSpiceTextDoc->UpdateTitle();
	}

	if(LoadAndUpdateWaveforms()) 
	{
		OpenAndUpdateAllWaveformGraphs();

		if(CMSuperSpiceDocData.PCAnalysisSetup->CTemperatureSetupData.CSweepData.sweep_type != E_TEMPERATURE_SWEEP_VOLTS_V_TEMP)
		if(CMSuperSpiceDocData.PCAnalysisSetup->CTemperatureSetupData.CSweepData.enable)
		{
			TCBerklySpiceOptionsSetupData &CBerklySpiceOptionsSetupData = CMSuperSpiceDocData.PCAnalysisSetup->CBerklySpiceOptionsSetupData;

			CBerklySpiceOptionsSetupData.COptionsFloatData[E_OPTIONS_TEMP].value = m_restore_temperature;
		}

		DisplayError(IDS_EER_STATUS, IDS_DATA_LOAD_OK);

		if(GCSuperSpiceGlobalData.CProgramOptions.CSpiceEngine.beep_when_engine_finished)
			Beep(440, 200);//beep at 440 Hz for 200ms

		DoOutputProcessing();
	}
	else
	{
		CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CReserved.CIntArray[E_DESIGNER_ENABLE_OPERATING_POINT] = false;	

		if(GCSuperSpiceGlobalData.CProgramOptions.CSpiceEngine.beep_when_engine_finished)
		{
			Beep(440, 300);
			Sleep(200);
			Beep(440, 300);
		}
	}
}

TCOutputWaveformDoc *TCSuperSpiceDoc::OpenAndUpdateAllWaveformGraphs(void)
{
	bool flag = CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]->AreWaveformsAvailable();
		
	TCOutputWaveformDoc *PCOutputWaveformDoc = (TCOutputWaveformDoc *)CDocumentWindowsList.IsOpen(CMSuperSpiceDocData.CMasterOutputWaveform);

	if(!flag) if(PCOutputWaveformDoc) {CDocumentWindowsList.Close(CMSuperSpiceDocData.CMasterOutputWaveform); PCOutputWaveformDoc = NULL;}

	if(PCOutputWaveformDoc)// update graphic output display, dont change the existing window that is displayed
	{
		PCOutputWaveformDoc->SetTestPointData(CMTestPointDataList);// data from all lower level schematics

		PCOutputWaveformDoc->UpdateWaveforms(CMSuperSpiceDocData.CMasterOutputDataFileName);	
	}
	else if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.auto_display_graphics && flag)
	{
		PCOutputWaveformDoc = DisplayOutputGraphics(CMSuperSpiceDocData.CMasterOutputWaveform);

		if(PCOutputWaveformDoc)
		{
			PCOutputWaveformDoc->SetTestPointData(CMTestPointDataList);// data from all lower level schematics

			PCOutputWaveformDoc->UpdateWaveforms(CMSuperSpiceDocData.CMasterOutputDataFileName);
			
			if(PCOutputWaveformDoc) ActivateADocumentView(PCOutputWaveformDoc);
		}
	}

	TCSuperSpiceMainFrame *PCSuperSpicMainFrame = (TCSuperSpiceMainFrame *) AfxGetMainWnd();
		
	CMDIChildWnd *PCMDIChildWnd = PCSuperSpicMainFrame->MDIGetActive();

	int waveform_type = -1;

	if(PCOutputWaveformDoc)// Only change window if schematic is showing
	if(PCMDIChildWnd)
	if(!PCMDIChildWnd->IsKindOf(RUNTIME_CLASS(TCOutputWaveformChildFrame)))
	{
		ActivateADocumentView(PCOutputWaveformDoc);

		waveform_type = PCOutputWaveformDoc->m_waveform_type;
	}

	GCWorkspaceTree.LoadSignalsList(&CMSuperSpiceDocData.CWaveformDataRuns, waveform_type);// Update the docked waveform signals list

	return PCOutputWaveformDoc;
}

bool TCSuperSpiceDoc::LoadAndUpdateWaveforms(void)
{
	if(!CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]) return false;

	bool value = false;

	m_marching_error = true;// need to sort out only loading in data if the run is bad.

	if(!m_marching_waveform_enabled || m_marching_error)
	{
		DisplayError(IDS_EER_STATUS, IDS_LOADING_DATA_FILE);

		value = CMSuperSpiceDocData.CWaveformDataRuns.Load(CMSuperSpiceDocData.CMasterOutputDataFileName, CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize(), GetTopLevelDoc(), &CMWaveformAnalyisisData, (CMSuperSpiceDocData.PCAnalysisSetup->CReRun.enable == E_RERUN_SWEEP_TYPE_WC_RERUN_FILE));
	}
	else
	{
		MarchingWaveformFinalRead();// Have a go one last time to read any possible remaining data

		MarchingWaveformEnd(0);// force termination

		value = true;
	}

	m_marching_waveform_enabled = false;

	if(!value) 
	{
		CGlobalStatusMessage.LoadString(IDS_DATA_LOAD_ERROR);

		DisplayError(IDS_ERR_ERROR, CGlobalStatusMessage, 0);

		GCGeneralReportsTab.DisplayLogFile(CMSuperSpiceDocData.CMasterSpiceEngineLogFileName, TE_STATUS_REPORT_FILE_LOG);

		return false;
	}

	GCGeneralReportsTab.DisplayLogFile(CMSuperSpiceDocData.CMasterSpiceEngineLogFileName, TE_STATUS_REPORT_FILE_STATUS);

	UpdateAllViews(NULL, NULL);

	if(GetTopLevelDoc()->CMWaveformAnalyisisData.power_enable) CalculateAllTransientPowers();

	UpdateChildSchematicWaveforms();

	DisplayError(IDS_EER_STATUS, IDS_GRAPHS_UPDATED);

	return true;
}

void TCSuperSpiceDoc::UpdateChildSchematicWaveforms(void)
{
	int count;

	TCSuperSpiceDoc *PCSuperSpiceDoc;

	count = CDocumentWindowsList.CDocList.GetSize();

	for(int p = 0; p < count; p++) 
	{
		if(CDocumentWindowsList.CDocList[p].type != E_SCHEMATIC_DOCUMENT) continue;
		if(!CDocumentWindowsList.CDocList[p].is_open) continue;

		PCSuperSpiceDoc = (TCSuperSpiceDoc *) CDocumentWindowsList.CDocList[p].PCDoc;

		if(!PCSuperSpiceDoc) continue;// double check;

		if(!PCSuperSpiceDoc->IsKindOf(RUNTIME_CLASS(TCSuperSpiceDoc))) // strange bug, need to fix later
		{
			ASSERT(0);

			if(PCSuperSpiceDoc->IsKindOf(RUNTIME_CLASS(TCOutputWaveformDoc)))
				CDocumentWindowsList.CDocList[p].type = E_WAVEFORM_DOCUMENT;

			continue;// needs a SaveAs to reset thiugs
		}

		// pass down the chain from this
		PCSuperSpiceDoc->CMSuperSpiceDocData.CWaveformDataRuns.Load(CMSuperSpiceDocData.CWaveformDataRuns);

		PCSuperSpiceDoc->UpdateAllViews(NULL, NULL);

		if(GetTopLevelDoc()->CMWaveformAnalyisisData.power_enable) PCSuperSpiceDoc->CalculateAllTransientPowers();
		if(GetTopLevelDoc()->CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CReserved.CIntArray[E_DESIGNER_ENABLE_OPERATING_POINT])PCSuperSpiceDoc->UpdateDesignerValues();

		PCSuperSpiceDoc->UpdateChildSchematicWaveforms();
	}
}

void TCSuperSpiceDoc::OnRunCreateNetlist() 
{
	if(!GCAuthorization.VerifyAtNetList()) return; // exit program

	TCSuperSpiceDoc	*PCDoc = GetTopLevelDoc();

	if(!PCDoc)
	{
		DisplayError(IDS_ERR_SYSTEM_ERROR, IDS_UNABLETO_RUN_NETLISTER, 0);

		return;
	}

	double flag = 1.3;

	if(!PCDoc->top_level)
	{
		CGlobalStatusMessage.LoadString(IDS_NO_TOP_LEVEL_NETLIST);

		DisplayError(IDS_ERR_WARNING, IDS_NO_TOP_LEVEL_NETLIST);

		return;
	}

	if(CThisFileName == "") 
	{
		AfxMessageBox(IDS_SAVE_TO_NETLIST);

		return;
	}

	CArray <CString, CString>  CPinListDummy;//not required for top level

	if(!PCDoc->CreateNetlist(0, CPinListDummy) || flag > (3.2))
	{
		return;
	}

	if(GCAuthorization.varify_at_netlist2 != 8)
	{
		ASSERT(0);
		DisplayError(IDS_ERR_ERROR, IDS_NETLIST_HAS_ERRORS, 0);
	}

	if(GCAuthorization.m_not_authorized1) 
	{
		ASSERT(0);
		HDCMDestCmp = NULL;// this will generate graphics problems
	}

	DisplayError(IDS_EER_STATUS, IDS_NETLIST_OK);
}

bool TCSuperSpiceDoc::CreateNetlist(int format, CArray <CString, CString>  &CPinList)
{
//	RegenerateSchematicDocumentsWindowList(true);

	if(GetTopLevelDoc() == this) CMBillOfMaterialsList.SetSize(0);

	CString CStatusMessage, CMsg;

	CMsg.LoadString(IDS_ENGAGING_NETLISTER);
	 
	CStatusMessage =  CMsg + ' ' + CThisFileName;

	DisplayError(IDS_EER_STATUS, CStatusMessage);

	UpdateAllNets();

	if(!CDocumentWindowsList.SaveOpenSchematics())// needed if open subcircuits
	{
		DisplayError(IDS_ERR_WARNING, IDS_UNSAVED_SCH);
	}

	if(!PCMNetList->Create(CMUniqueSchematicManagerList, *CMSuperSpiceDocData.PCAnalysisSetup, this, format, CParentRefDes, CPinList))
	{
		CGlobalStatusMessage = E_STATUS_MSG_NET_LIST_ERRORS;

		DisplayError(IDS_ERR_ERROR, IDS_UNABLE_TO_NETLIST, 0);

		return false;
	}

	if(!PCMNetList->Save())// saves netlist/models and error log
	{
		DisplayError(IDS_ERR_ERROR, IDS_UNABLE_TO_SAVE_NETLIST, 0);

		return false;
	}

	TCSuperSpiceTextDoc *PCSuperSpiceTextDoc = (TCSuperSpiceTextDoc *)CDocumentWindowsList.IsOpen(CMSuperSpiceDocData.CMasterNetListFileName);

	if(PCSuperSpiceTextDoc)// update netlist text display
	{
		LoadGenericFromArchive(PCSuperSpiceTextDoc, CMSuperSpiceDocData.CMasterNetListFileName);

		PCSuperSpiceTextDoc->SetModifiedFlag(false);
	
		PCSuperSpiceTextDoc->UpdateTitle();
	}

	PCSuperSpiceTextDoc = (TCSuperSpiceTextDoc *)CDocumentWindowsList.IsOpen(CMSuperSpiceDocData.CMasterModelFileName);
	
	if(PCSuperSpiceTextDoc)// update model text display
	{
		LoadGenericFromArchive(PCSuperSpiceTextDoc, CMSuperSpiceDocData.CMasterModelFileName);

		PCSuperSpiceTextDoc->SetModifiedFlag(false);

		PCSuperSpiceTextDoc->UpdateTitle();
	}

	UpdateAllSchematics();

	SetupWaveformAnalyisisData();

	if(!CreateAllChildNetlists(format))
	{
		DisplayError(IDS_EER_STATUS, IDS_FAILED_SUBCKT_NETLIST, 0); 

		return false;
	}

	return true;
}

bool TCSuperSpiceDoc::CreateAllChildNetlists(int format)
{
	int p, count;

	if(!top_level)// dont allow subcircuits to be netlisted
	if(GCAuthorization.m_build_type == E_DEMO_RELEASE || GCAuthorization.m_build_type == E_FULL_RELEASE_STUDENT || GCAuthorization.m_build_type == E_RESTRICTED_RELEASE_STUDENT || GCAuthorization.m_build_type == E_AUTHORIZATION_MASTER_PASSWORD_STUDENT)
	{
		return true;// to allow the top level netlist to work for subcircuits
	}

	count = CDocumentWindowsList.CDocList.GetSize();

	CArray <CString, CString>  CPinList;
	CArray <TCSchematicObject*, TCSchematicObject*> CSchematicObjectList;
	int number_of_subckts, q;

	CString CSubCktRefDes;

	for(p = 0; p < count; p++)
	{
		TCDocumentWindowsListData &CDocumentWindowsListData = CDocumentWindowsList.CDocList[p];

		if(CDocumentWindowsListData.type != E_SCHEMATIC_DOCUMENT) continue;

		if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
		{
			if(!CreateChildNetlist(CDocumentWindowsListData.PCDoc, CDocumentWindowsListData.CFileName, 
				CDocumentWindowsListData.CParentRefIDList, CDocumentWindowsListData.CParentRefDes, format, CPinList)) return false;

		}
		else // for each schematic subckt of the same type create seperate netlists with appropiate refdes name
		{
			number_of_subckts = GetSubCktList(CDocumentWindowsListData.CFileName, CSchematicObjectList);

			for(q = 0; q < number_of_subckts; q++)
			{
				GetSubCktPinWires(CSchematicObjectList[q], CPinList);

				CSubCktRefDes = GetSubCktRefDes(CSchematicObjectList[q], CDocumentWindowsListData.CParentRefDes);

				if(!CreateChildNetlist(CDocumentWindowsListData.PCDoc, CDocumentWindowsListData.CFileName, 
					CDocumentWindowsListData.CParentRefIDList, CSubCktRefDes, format, CPinList)) return false;

			}
		}
	}
	
	if(!top_level)// dont allow subcircuits to be netlisted
	if(GCAuthorization.m_build_type == E_DEMO_RELEASE || GCAuthorization.m_build_type == E_FULL_RELEASE_STUDENT || GCAuthorization.m_build_type == E_RESTRICTED_RELEASE_STUDENT || GCAuthorization.m_build_type == E_AUTHORIZATION_MASTER_PASSWORD_STUDENT)
	{
		return false;
	}

	return true;
}

CString TCSuperSpiceDoc::GetSubCktRefDes(TCSchematicObject *PCSchematicObject, CString CBaseRefDes)
{
	CString CText, CRefDes;// extract the base and replace with actual

	CRefDes = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	int end_count = CBaseRefDes.ReverseFind(':');

	if(end_count < 0) return CRefDes;// must be top level

	CText = CBaseRefDes.Left(end_count);

	CText = CText + ":" + CRefDes;

	return CText;
}

int TCSuperSpiceDoc::GetSubCktList(CString CFileName, CArray <TCSchematicObject*, TCSchematicObject*> &CSchematicObjectList)
{
	int count = 0;
	int p, q, component_count;

	TCSchematicManager *PCSchematicManager;
	TCSchematicObject *PCSchematicObject;

	CSchematicObjectList.SetSize(0, 16);

	count = CMUniqueSchematicManagerList.GetSize();

	for(p = 0; p < count; p++)// will do it for all views of the same page
	{
		PCSchematicManager = CSchematicManagerList[p];

		component_count = PCSchematicManager->CMSchematicManagerData.CGraphicList.GetSize();

		for(q = 0; q < component_count; q++)
		{
			PCSchematicObject = PCSchematicManager->CMSchematicManagerData.CGraphicList[q];			

			if(CFileName != PCSchematicObject->CMSchematicObjectData.CSymbolData.CChildFileName) continue;

			CSchematicObjectList.Add(PCSchematicObject);
		}
	}

	count = CSchematicObjectList.GetSize();

	return count;
}

bool TCSuperSpiceDoc::GetSubCktPinWires(TCSchematicObject *PCSchematicObject, CArray <CString, CString>  &CPinList)
{
	int count = PCSchematicObject->CMSchematicObjectData.CPinListData.GetSize();

	CPinList.SetSize(0, count);// remove old data

	CString CText;

	for(int p = 0; p < count; p++)// will do it for all views of the same page
	{
		CText = PCSchematicObject->CMSchematicObjectData.CPinListData[p].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;

		CPinList.Add(CText);
	}
	
	return true;
}

void TCSuperSpiceDoc::RestorePinHierarchyNames(void)
{
	TCSchematicObject *PCSchematicObject;

	int pin_count, r, index;

	int count = CMUniqueSchematicManagerList.GetSize();

	CString CText;

	for(int p = 0; p < count; p++)
	{
		TCSchematicManager *PCSchematicManager = CMUniqueSchematicManagerList[p];

		CArray <TCSchematicObject *, TCSchematicObject *> &CGraphicList = PCSchematicManager->CMSchematicManagerData.CGraphicList;
		
		int scount = CGraphicList.GetSize();

		for(int q = 0; q < scount; q++)
		{
			PCSchematicObject = CGraphicList[q];

			if(PCSchematicObject->m_type) 
			{
				if(PCSchematicObject->m_type < E_DC_VOLTAGE_SOURCE) continue;
			}

			pin_count = PCSchematicObject->GetNumberOfPins();

			for(r = 0; r < pin_count; r++)
			{
				CText = PCSchematicObject->GetPinLabel(r, E_COMPONENT_PIN_NET_NAME);

				index = CText.Find(':');

				if(index < 0) break; // no Hierarchy

				CText = CText.Left(index + 1);
		
				CText += CParentRefDes;

				PCSchematicObject->SetPinLabel(&GlobalCDCTemp, r, E_COMPONENT_PIN_NET_NAME, CText);
			}
		}
	}
}

bool TCSuperSpiceDoc::CreateChildNetlist(CDocument *PCPoc, CString CFileName, CArray <CString, CString&> &CRefIDList, CString CRefDes, int format, CArray <CString, CString>  &CPinList)
{
	TCSuperSpiceDoc *PCSuperSpiceDoc = (TCSuperSpiceDoc *)PCPoc;

	CArray <CString, CString>  CLocalPinList;

	int pin_count = CPinList.GetSize();

	CLocalPinList.SetSize(pin_count);

	bool result;

	CString COrginalParentRef;

	for(int p = 0; p < pin_count; p++) CLocalPinList[p] = CPinList[p];

	CArray <CString, CString> CNetNames;

	if(PCSuperSpiceDoc)// if this doc has it opened, ref id needs changed for each instance
	{
		COrginalParentRef = PCSuperSpiceDoc->CParentRefDes;

		PCSuperSpiceDoc->SetParent(this, CThisFileName, CRefIDList, CRefDes);

		SyncAnalysisSetup(PCSuperSpiceDoc);

		result = PCSuperSpiceDoc->CreateNetlist(format, CLocalPinList);

		PCSuperSpiceDoc->CParentRefDes = COrginalParentRef;

		PCSuperSpiceDoc->RestorePinHierarchyNames();

		PCSuperSpiceDoc->OnSaveDocument(CFileName);// so that the circuit can be probed if opened with no prior netlist

		return result;
	}

	CString CErrorText;

	CMultiDocTemplate *PCMultiDocTemplate = (CMultiDocTemplate *)GetDocTemplate();

	if(!PCMultiDocTemplate) return false;

	CString CMsg;

	if(!FileExists(CFileName)) 
	{
		//try same directory as top_level
		CFileName = GetRelativeFileName(CFileName);

		if(!FileExists(CFileName))
		{
			CMsg.LoadString(IDS_UNABLE_TO_FIND_SCHFILE);

			CErrorText = CMsg + ' ' + CFileName;

			DisplayError(IDS_EER_STATUS, CErrorText, 0);

			return false;
		}
	}

	PCSuperSpiceDoc = (TCSuperSpiceDoc *)PCMultiDocTemplate->OpenDocumentFile(CFileName, false);// invisable

	if(!PCSuperSpiceDoc) 
	{
		CMsg.LoadString(IDS_UNABLE_TO_OPEN_FILE);

		CErrorText = CMsg + ' ' + CFileName;

		DisplayError(IDS_EER_STATUS, CErrorText, 0);

		return false;
	}
		
	PCSuperSpiceDoc->SetParent(this, CThisFileName, CRefIDList, CRefDes);

	SyncAnalysisSetup(PCSuperSpiceDoc);

	if(!PCSuperSpiceDoc->CreateNetlist(format, CLocalPinList))
	{
		PCSuperSpiceDoc->OnCloseDocument();

		return false;
	}

	PCSuperSpiceDoc->OnCloseDocument();

	return true;
}

CString	TCSuperSpiceDoc::GetRelativeFileName(CString CFileName)
{
	CString CNewPathName;

	TCSuperSpiceDoc *PCSSToplevel = GetTopLevelDoc();

	CNewPathName = PCSSToplevel->CThisFileName;

	CFileName = ExtractFileName(CFileName);

	CNewPathName = ExtractPathName(CNewPathName);

	CFileName = CNewPathName + CFileName;

	return CFileName;
}

bool TCSuperSpiceDoc::CreateModelLines(void)
{
	if(PCMNetList) 
		if(!PCMNetList->CreateModelLines(CMUniqueSchematicManagerList, *CMSuperSpiceDocData.PCAnalysisSetup, this, m_runs_counter)) return false;

	TCSuperSpiceTextDoc *PCSuperSpiceTextDoc = (TCSuperSpiceTextDoc *)CDocumentWindowsList.IsOpen(CMSuperSpiceDocData.CMasterModelFileName);
	
	if(PCSuperSpiceTextDoc)// update model text display
	{
		LoadGenericFromArchive(PCSuperSpiceTextDoc, CMSuperSpiceDocData.CMasterModelFileName);

		PCSuperSpiceTextDoc->SetModifiedFlag(false);

		PCSuperSpiceTextDoc->UpdateTitle();
	}

	return CreateAllChildModelLines();
}

bool TCSuperSpiceDoc::CreateAllChildModelLines(void)
{
	int p, count;

	count = CDocumentWindowsList.CDocList.GetSize();

	for(p = 0; p < count; p++)
	{
		TCDocumentWindowsListData &CDocumentWindowsListData = CDocumentWindowsList.CDocList[p];

		if(CDocumentWindowsListData.type != E_SCHEMATIC_DOCUMENT) continue;

		if(!CreateChildModelLines(CDocumentWindowsListData.PCDoc, CDocumentWindowsListData.CFileName, 
			CDocumentWindowsListData.CParentRefIDList, CDocumentWindowsListData.CParentRefDes)) return false;
	}
	
	return true;
}

bool TCSuperSpiceDoc::CreateChildModelLines(CDocument *PCPoc, CString CFileName, CArray <CString, CString&> &CRefIDList, CString CRefDes)
{
	TCSuperSpiceDoc *PCSuperSpiceDoc = (TCSuperSpiceDoc *)PCPoc;

	if(PCSuperSpiceDoc)// if this doc has it opened, ref id has already been set
	{
		SyncAnalysisSetup(PCSuperSpiceDoc);

		return PCSuperSpiceDoc->CreateModelLines();
	}

	CString CErrorText;

	CMultiDocTemplate *PCMultiDocTemplate = (CMultiDocTemplate *)GetDocTemplate();

	if(!PCMultiDocTemplate) return false;

	CString CMsg;

	CMsg.LoadString(IDS_UNABLE_FIND_SUBCKT_SCH);

	if(!FileExists(CFileName)) 
	{
		CErrorText = CMsg + ' ' + CFileName;

		DisplayError(IDS_EER_STATUS, CErrorText, 0);

		return false;
	}

	PCSuperSpiceDoc = (TCSuperSpiceDoc *)PCMultiDocTemplate->OpenDocumentFile(CFileName, false);// invisable

	if(!PCSuperSpiceDoc) 
	{
		CErrorText = CMsg + ' ' + CFileName;

		DisplayError(IDS_EER_STATUS, CErrorText, 0);

		return false;
	}
		
	PCSuperSpiceDoc->SetParent(this, CThisFileName, CRefIDList, CRefDes);

	SyncAnalysisSetup(PCSuperSpiceDoc);

	if(!PCSuperSpiceDoc->CreateModelLines())
	{
		PCSuperSpiceDoc->OnCloseDocument();

		return false;
	}

	PCSuperSpiceDoc->OnCloseDocument();

	return true;
}
////////////////////////

void TCSuperSpiceDoc::GetWCRLCModelLines(CArray <CString, CString&> &CModelLines)
{
	int model_line_count = CModelLines.GetSize();

	TCSchematicObject *PCSchematicObject;
	int count = CMUniqueSchematicManagerList.GetSize();
	int component_count = 0;
	CString CRefDes, CValue, CLine;
	char ref_des;
	int counter = 0;

	CArray <CString, CString&> CLines;

	int p;

	for(p = 0; p < count; p++)
	{
		TCSchematicManager *PCSchematicManager = CMUniqueSchematicManagerList[p];
	
		component_count = PCSchematicManager->CMSchematicManagerData.CGraphicList.GetSize();

		for(int q = 0; q < component_count; q++)
		{
			PCSchematicObject = PCSchematicManager->CMSchematicManagerData.CGraphicList[q];

			if(PCSchematicObject->m_type)
				if(PCSchematicObject->m_type < E_DC_VOLTAGE_SOURCE) continue;// was E_RESISTOR_COMPONENT
			
			CRefDes = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

			CRefDes.MakeLower();

			if(CRefDes == "") continue;

			ref_des = CRefDes.GetAt(0);

			if(ref_des != 'r' && ref_des != 'c' && ref_des != 'l' && ref_des != 'v' && ref_des != 'i') continue;

			CValue = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel; // Jan 2017

			if(ref_des == 'r') // dont include ic resistors i.e attached to models.
			{
				if(PCSchematicObject->CMSchematicObjectData.component_property_view_type == E_PROPERTY_IC_RESISTOR) continue;

				CValue = PCSchematicObject->CMSchematicObjectData.GetComponentValueSpiceString(E_COMPONENT_VALUE);// Jan 2017
			}
			if(ref_des == 'c')
			{
				if(PCSchematicObject->CMSchematicObjectData.component_property_view_type == E_PROPERTY_IC_CAPACITOR) continue;

				CValue = PCSchematicObject->CMSchematicObjectData.GetComponentValueSpiceString(E_COMPONENT_VALUE);// Jan 2017
			}
		
			if(ref_des == 'l')
			{
				CValue = PCSchematicObject->CMSchematicObjectData.GetComponentValueSpiceString(E_COMPONENT_VALUE);// Jan 2017
			}

			if(CParentRefDes != "" && GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist) 
			{
				CRefDes = CRefDes + ":" + CParentRefDes;// add hierarchy.
			}

			CLine = CRefDes + " ";

			if(ref_des == 'v' || ref_des == 'i') 
			{
				TCGeneratorData *PCGeneratorData = PCSchematicObject->CMSchematicObjectData.PCGeneratorData;

				if(!PCSchematicObject->CMSchematicObjectData.IsWorstCaseGenerator()) continue;

				if(PCSchematicObject->m_type == E_DC_VOLTAGE_SOURCE || PCSchematicObject->m_type == E_DC_CURRENT_SOURCE)
				{
					CValue = FloatToMKSString(GetTopLevelDoc()->EvaluateComponentValue(PCGeneratorData->CDCGeneratorData.CDCVoltage));
 
					CValue += " DCVALUE DC";
				}
				else if(PCSchematicObject->m_type == E_SINE_VOLTAGE_SOURCE || PCSchematicObject->m_type == E_SINE_CURRENT_SOURCE)
				{
					CValue = FloatToMKSString(GetTopLevelDoc()->EvaluateComponentValue(PCGeneratorData->CSineGeneratorData.CAmplitude));

					CValue += " AMPLITUDE SINE";
				}
				else if(PCSchematicObject->m_type == E_PULSE_VOLTAGE_SOURCE || PCSchematicObject->m_type == E_SINE_CURRENT_SOURCE)
				{
					CValue = FloatToMKSString(GetTopLevelDoc()->EvaluateComponentValue(PCGeneratorData->CPulseGeneratorData.CEnd));

					CValue += " STOP_AMPLITUDE PULSE";
				}
			}

			CLine += CValue;

			CLines.Add(CLine);

			counter++;
		}
	}

	int new_count = counter + model_line_count;

	CModelLines.SetSize(new_count);

	for(p = model_line_count; p < new_count; p++)
	{
		CModelLines[p] = CLines[p - model_line_count];
	}
}

bool TCSuperSpiceDoc::CreateWCModelLines(CArray <CString, CString&> &CModelLines, TCReRun &CTopReRun)
{
	if(PCMNetList) 
	{
		int count = CTopReRun.CRunType.GetSize();

		CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CRunType.SetSize(count);

		//Pass the type of wc runs to be made
		for(int q = 0; q < count; q++) CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CRunType[q] = CTopReRun.CRunType[q];

		if(!PCMNetList->CreateModelLines(CMUniqueSchematicManagerList, *CMSuperSpiceDocData.PCAnalysisSetup, this, m_runs_counter)) return false;

		CArray <CString, CString&> CTheseModelLines;

		int line_count = PCMNetList->CMModelLines.GetSize();

		if(!line_count) return true;

		int current_count = CModelLines.GetSize();

		int new_count = line_count + current_count;

		CTheseModelLines.SetSize(new_count);

		int p;

		for(p = 0; p < current_count; p++) CTheseModelLines[p] = CModelLines[p];

		for(p = current_count; p < new_count; p++) CTheseModelLines[p] = PCMNetList->CMModelLines[p - current_count];

		CModelLines.SetSize(new_count);

		for(p = 0; p < new_count; p++) CModelLines[p] = CTheseModelLines[p];
	}

	GetWCRLCModelLines(CModelLines);

	return CreateAllWCChildModelLines(CModelLines, CTopReRun);
}

/*  new code 16th Dec 2006.
bool TCSuperSpiceDoc::CreateAllWCChildModelLines(CArray <CString, CString&> &CModelLines, TCReRun &CTopReRun)
{
	int p, count;

	count = CDocumentWindowsList.CDocList.GetSize();

	for(p = 0; p < count; p++)
	{
		TCDocumentWindowsListData &CDocumentWindowsListData = CDocumentWindowsList.CDocList[p];

		if(CDocumentWindowsListData.type != E_SCHEMATIC_DOCUMENT) continue;

		if(!CreateWCChildModelLines(CDocumentWindowsListData.PCDoc, CDocumentWindowsListData.CFileName, 
			CDocumentWindowsListData.CParentRefIDList, CDocumentWindowsListData.CParentRefDes, CModelLines, CTopReRun)) return false;
	}
	
	return true;
}*/

// new code 16th Dec 2006. WC was not setting each seperate instance in subckt, not tested yet
bool TCSuperSpiceDoc::CreateAllWCChildModelLines(CArray <CString, CString&> &CModelLines, TCReRun &CTopReRun)
{
	int p, count;

	count = CDocumentWindowsList.CDocList.GetSize();
	CArray <CString, CString>  CPinList;
	CArray <TCSchematicObject*, TCSchematicObject*> CSchematicObjectList;
	CString CSubCktRefDes;
	int number_of_subckts, q;

	for(p = 0; p < count; p++)
	{
		TCDocumentWindowsListData &CDocumentWindowsListData = CDocumentWindowsList.CDocList[p];

		if(CDocumentWindowsListData.type != E_SCHEMATIC_DOCUMENT) continue;

		if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)// only one type needed
		{
			if(!CreateWCChildModelLines(CDocumentWindowsListData.PCDoc, CDocumentWindowsListData.CFileName, 
				CDocumentWindowsListData.CParentRefIDList, CDocumentWindowsListData.CParentRefDes, CModelLines, CTopReRun)) return false;
		}
		else // for each schematic subckt of the same type create seperate netlists with appropiate refdes name
		{
			number_of_subckts = GetSubCktList(CDocumentWindowsListData.CFileName, CSchematicObjectList);

			for(q = 0; q < number_of_subckts; q++)
			{
				GetSubCktPinWires(CSchematicObjectList[q], CPinList);

				CSubCktRefDes = GetSubCktRefDes(CSchematicObjectList[q], CDocumentWindowsListData.CParentRefDes);

				if(!CreateWCChildModelLines(CDocumentWindowsListData.PCDoc, CDocumentWindowsListData.CFileName, 
					CDocumentWindowsListData.CParentRefIDList, CSubCktRefDes, CModelLines, CTopReRun)) return false;

			}
		}
	}
	
	return true;
}

bool TCSuperSpiceDoc::CreateWCChildModelLines(CDocument *PCPoc, CString CFileName, CArray <CString, CString&> &CRefIDList, CString CRefDes, CArray <CString, CString&> &CModelLines, TCReRun &CTopReRun)
{
	TCSuperSpiceDoc *PCSuperSpiceDoc = (TCSuperSpiceDoc *)PCPoc;

	if(PCSuperSpiceDoc)// if this doc has it opened, ref id has already been set
	{
		SyncAnalysisSetup(PCSuperSpiceDoc);

		return PCSuperSpiceDoc->CreateWCModelLines(CModelLines, CTopReRun);
	}

	CString CErrorText;

	CMultiDocTemplate *PCMultiDocTemplate = (CMultiDocTemplate *)GetDocTemplate();

	if(!PCMultiDocTemplate) return false;

	CString CMsg;

	CMsg.LoadString(IDS_UNABLE_FIND_SUBCKT_SCH);

	if(!FileExists(CFileName)) 
	{
		CErrorText = CMsg + ' ' + CFileName;

		DisplayError(IDS_EER_STATUS, CErrorText, 0);

		return false;
	}

	PCSuperSpiceDoc = (TCSuperSpiceDoc *)PCMultiDocTemplate->OpenDocumentFile(CFileName, false);// invisable

	if(!PCSuperSpiceDoc) 
	{
		CErrorText = CMsg + ' ' + CFileName;

		DisplayError(IDS_EER_STATUS, CErrorText, 0);

		return false;
	}
		
	PCSuperSpiceDoc->SetParent(this, CThisFileName, CRefIDList, CRefDes);

	SyncAnalysisSetup(PCSuperSpiceDoc);

	if(!PCSuperSpiceDoc->CreateWCModelLines(CModelLines, CTopReRun))
	{
		PCSuperSpiceDoc->OnCloseDocument();

		return false;
	}

	PCSuperSpiceDoc->OnCloseDocument();

	return true;
}
///////////
void TCSuperSpiceDoc::SyncAnalysisSetup(TCSuperSpiceDoc *PCChildDoc)
{
	// Each schematic could have different save all volts/currents checked
	// this function sets child the same as parent befor netlisting
	// may add user option to overide this
	// each subcircuit could want different node lists saved so these are not changed
	
	if(!PCChildDoc) return;
	if(!PCChildDoc->CMSuperSpiceDocData.PCAnalysisSetup) return;

	PCChildDoc->CMSuperSpiceDocData.PCAnalysisSetup->CopyGlobal(*CMSuperSpiceDocData.PCAnalysisSetup);

	// only the highest level parameter is swept
	// this passes sweep data to the child

	PCChildDoc->CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData.CValue = 
	CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData.CValue;
}

void TCSuperSpiceDoc::UpdateAllNets(bool correct_wires)
{
	GenerateUniqueSchematicManagers();

	int count = CMUniqueSchematicManagerList.GetSize();

	for(int p = 0; p < count; p++)// will do it for all views of the same page
	{
		UpdateNets(CMUniqueSchematicManagerList[p], correct_wires);
	}
}

void TCSuperSpiceDoc::OnUpdateRunRun(CCmdUI* pCmdUI) 
{
	pCmdUI;
}

int TCSuperSpiceDoc::GetNumberOfComponents()
{
	int number_of_components = 0;
	TCSchematicObject *PCSchematicObject;

	GenerateUniqueSchematicManagers();

	int count = CMUniqueSchematicManagerList.GetSize();
	int component_count = 0;

	for(int p = 0; p < count; p++)
	{
		TCSchematicManager *PCSchematicManager = CMUniqueSchematicManagerList[p];
	
		component_count = PCSchematicManager->CMSchematicManagerData.CGraphicList.GetSize();

		for(int q = 0; q < component_count; q++)
		{
			PCSchematicObject = PCSchematicManager->CMSchematicManagerData.CGraphicList[q];
			
			if(PCSchematicObject->m_type < E_DC_VOLTAGE_SOURCE && PCSchematicObject->m_type) continue;
		
			number_of_components++;
		}
	}

	return number_of_components;
}

BOOL TCSuperSpiceDoc::OnSaveDocument(LPCTSTR lpszPathName) 
{	
	if(!PCMNetList) return false;

	if(GCAuthorization.m_build_type == E_DEMO_RELEASE)
	{
		if(GetNumberOfComponents() > E_MAX_NUM_NET_LINES)
		{
			CString CTrialExceeded;

			CTrialExceeded.LoadString(IDS_CIRCUIT_SIZE_EXCEEDED);
			
			AfxMessageBox(CTrialExceeded);
			
			return false;
		}
	}

	// if above bypased
	if(GCAuthorization.m_build_type == E_DEMO_RELEASE)
	{
		if(GetNumberOfComponents() > E_MAX_NUM_NET_LINES)
		{
			HDCMDestCmp = NULL;
			ASSERT(0);
			return false;
		}
	}

	bool flag = false;

	CString CTemp = lpszPathName;

	CTemp.MakeUpper();
	CThisFileName.MakeUpper();

	if(CTemp != CThisFileName) flag = true;// i.e. save as a new file

	int value = COleServerDoc::OnSaveDocument(lpszPathName);

	if(flag)
	{
		CDocumentWindowsList.Close();				// close all old windows, 
		CDocumentWindowsList.CDocList.SetSize(0);	// remove old stuff

		SetFileNames(lpszPathName);

		return value;
	}


	SetFileNames(lpszPathName);

	return value;
}
// And output text as well
void TCSuperSpiceDoc::OnNotifyDocumentClosed(CDocument *PCDoc)
{
	CDocumentWindowsList.NotifyDocumentClosed(PCDoc);
}

void TCSuperSpiceDoc::OnOptionsProgram() 
{
	TCProgramOptionsMasterSheet CProgramOptionsSheet;

	CProgramOptionsSheet.CProgramOptions = 
	GCSuperSpiceGlobalData.CProgramOptions;

	if(CProgramOptionsSheet.DoModal() == IDOK)
	{
		GCSuperSpiceGlobalData.CProgramOptions = 
		CProgramOptionsSheet.CProgramOptions;
	}
}

void TCSuperSpiceDoc::OnViewTopLevelFiles() 
{
	TCSuperSpiceDoc *PCSuperSpiceDoc = GetTopLevelDoc();

	if(!PCSuperSpiceDoc) return; // SS program failure
	
//	PCSuperSpiceDoc->OnViewSchematicFiles();

	GCWorkspaceTree.RefreshSchematicFiles();
}

void TCSuperSpiceDoc::OnViewSchematicFiles() 
{
	//RegenerateSchematicDocumentsWindowList(true);
	GCWorkspaceTree.Refresh();
}

void TCSuperSpiceDoc::DisplayFile(void)
{
	int index = CDocumentWindowsList.GetDocId(CDocumentWindowsList.CFileIndexedName, "");
			
	if(index < 0) return;

	CString CText;

	if(CDocumentWindowsList.CDocList[index].CParentRefIDList.GetSize())
		CText = CDocumentWindowsList.CDocList[index].CParentRefIDList[0];

	switch(CDocumentWindowsList.CDocList[index].type)
	{
		case E_GENERIC_TEXT:			DisplayTextBasedDocument(CDocumentWindowsList.CFileIndexedName);break;
		case E_SCHEMATIC_DOCUMENT:		DisplayChildSchematicDocument(CDocumentWindowsList.CFileIndexedName, CText);break;
		case E_NETLIST_DOCUMENT:		DisplayTextBasedDocument(CDocumentWindowsList.CFileIndexedName);break;
		case E_OUTPUT_TEXT_DOCUMENT:	DisplayTextBasedDocument(CDocumentWindowsList.CFileIndexedName);break;
		case E_WAVEFORM_DOCUMENT:		DisplayOutputGraphics(CDocumentWindowsList.CFileIndexedName);break;
		case E_SYMBOL_DOCUMENT:			DisplaySymbolEditorDocument(CDocumentWindowsList.CFileIndexedName);break;
		case E_SPICE_LIBARY_DOCUMENT:	DisplayTextBasedDocument(CDocumentWindowsList.CFileIndexedName);break;
		case E_SPICE_MODEL_DOCUMENT:	DisplayTextBasedDocument(CDocumentWindowsList.CFileIndexedName);break;
		case E_SPICE_ENGINE_LOG_DOCUMENT: DisplayTextBasedDocument(CDocumentWindowsList.CFileIndexedName);break;

		default: return;
	}
}

void TCSuperSpiceDoc::RefreshWorkSpaceWindow(void)
{

}

TCOutputWaveformDoc *TCSuperSpiceDoc::OnViewNewGraph(CView *PCView)
{
	CString CText;
	CString CTemp;
	PCView;

	CMSuperSpiceDocData.m_graphic_counter;

	CText = RemoveExtention(CMSuperSpiceDocData.CMasterOutputWaveform);

	CTemp.Format("%s%d.ssg", CText, CMSuperSpiceDocData.m_graphic_counter++);

	if(!FileExists(CTemp))// create graphic output
	{
		if(!CreateOutputWaveformFile(CTemp)) return NULL;
	}

	CDocumentWindowsList.Create(CTemp, E_WAVEFORM_DOCUMENT, GetTopLevelDoc(), CParentRefIDList, CParentRefDes);// does not use CParentRefIDList

	RefreshWorkSpaceWindow();

	return DisplayOutputGraphics(CTemp);
}

bool TCSuperSpiceDoc::CreateOutputWaveformFile(CString CName)
{
	if(GetTopLevelDoc() != this) return false;

	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp *) AfxGetApp();

	CMultiDocTemplate *PCMultiDocTemplate = PCSuperSpiceApp->GetWaveformDisplayDocTemplate();

	if(!PCMultiDocTemplate) return false;

	CMSuperSpiceDocData.CRefId[E_REF_DESIGNATOR_WAVEFORM] = 1;// Reset the graphic window counter

	TCOutputWaveformDoc *PCDoc = (TCOutputWaveformDoc *)PCMultiDocTemplate->OpenDocumentFile(NULL, false);// invisable

	if(!PCDoc) return NULL;

	PCDoc->CSpiceDataFileName = CMSuperSpiceDocData.CMasterOutputTextFileName;
	
	PCDoc->DoSave(CName, true);
	PCDoc->OnCloseDocument();

	return true;
}

bool TCSuperSpiceDoc::CreateSymbolEditorFile(CString CName)
{
	if(GetTopLevelDoc() != this) return false;

	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp *) AfxGetApp();

	CMultiDocTemplate *PCMultiDocTemplate = PCSuperSpiceApp->GetSpiceSchematicSymbolViewDocTemplate();

	if(!PCMultiDocTemplate) return false;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)PCMultiDocTemplate->OpenDocumentFile(NULL, false);// invisable

	if(!PCDoc) return false;

	if(!PCDoc->DoSave(CName, true))// probably a bad file or dirctory name
	{
		return false;
	}

	PCDoc->OnCloseDocument();

	return true;
}


TCOutputWaveformData *TCSuperSpiceDoc::GetOutputWaveformData()
{
	if(IsBadReadPtr(this, sizeof(TCSuperSpiceDoc))) return NULL;

	return CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0];
}

void TCSuperSpiceDoc::DisplayError(CString CDescription, CString CErrorMsg, int error_code)
{
	TCSuperSpiceDoc	*PCLevelDoc = GetTopLevelDoc();

	if(!PCLevelDoc) return;

	GCGeneralReportsTab.DisplayMessage(CDescription, CErrorMsg, error_code);
	
	return;// error window no longer needed
}

void TCSuperSpiceDoc::DisplayError(UINT id, CString CErrorMsg, int error_code)
{
	CString CMsg;

	CMsg.LoadString(id);

	TCSuperSpiceDoc	*PCLevelDoc = GetTopLevelDoc();

	if(!PCLevelDoc) return;

	GCGeneralReportsTab.DisplayMessage(CMsg, CErrorMsg, error_code);
	
	return;
}

void TCSuperSpiceDoc::DisplayError(CString CDescription, UINT id, int error_code)
{
	CString CErrorMsg;

	CErrorMsg.LoadString(id);

	TCSuperSpiceDoc	*PCLevelDoc = GetTopLevelDoc();

	if(!PCLevelDoc) return;

	GCGeneralReportsTab.DisplayMessage(CDescription, CErrorMsg, error_code);
	
	return;
}

void TCSuperSpiceDoc::DisplayError(UINT id1, UINT id2, int error_code)
{
	CString CMsg;
	CString CErrorMsg;

	CMsg.LoadString(id1);
	CErrorMsg.LoadString(id2);

	TCSuperSpiceDoc	*PCLevelDoc = GetTopLevelDoc();

	if(!PCLevelDoc) return;

	GCGeneralReportsTab.DisplayMessage(CMsg, CErrorMsg, error_code);
	
	return;
}

void TCSuperSpiceDoc::DisplayModelLibary(CView *PCView)
{
	PCView;// this will be only a toplevel call

	TCMasterModelDlg CMasterModelDlg;
	
	CMasterModelDlg.m_check = false;

	CMasterModelDlg.enable_edit_model_file = true;

	CMasterModelDlg.DoModal();

	if(CMasterModelDlg.CEditModelFileName == "") return;

	TCSuperSpiceTextDoc *PCSuperSpiceTextDoc;

	CArray <CString, CString&>	CDummyList;
	CString CDummyText;

	// add to workspace window list
//	CDocumentWindowsList.Create(CMasterModelDlg.CEditModelFileName, E_SPICE_LIBARY_DOCUMENT, this, CDummyList, CDummyText);

//	RegenerateSchematicDocumentsWindowList(false);

	PCSuperSpiceTextDoc = DisplayTextBasedDocument(CMasterModelDlg.CEditModelFileName);

	if(!PCSuperSpiceTextDoc)// try opening from main open file
	{
		PCSuperSpiceTextDoc = (TCSuperSpiceTextDoc*) AfxGetApp()->OpenDocumentFile(CMasterModelDlg.CEditModelFileName);
	}
	// tell it to update model libary file data when it saves

	PCSuperSpiceTextDoc->update_model_libary = true;

}

void TCSuperSpiceDoc::ClearError(void)
{
	TCSuperSpiceDoc	*PCLevelDoc = GetTopLevelDoc();

	if(!PCLevelDoc) return;

	GCGeneralReportsTab.ClearMessages();
}

void TCSuperSpiceDoc::SetTemperature(double data)
{
	TCSuperSpiceDoc	*PCLevelDoc = GetTopLevelDoc();

	if(!PCLevelDoc) return;

	TCBerklySpiceOptionsSetupData &CBerklySpiceOptionsSetupData = CMSuperSpiceDocData.PCAnalysisSetup->CBerklySpiceOptionsSetupData;

	if(!(E_OPTIONS_TEMP < CBerklySpiceOptionsSetupData.COptionsFloatData.GetSize())) return;

	CBerklySpiceOptionsSetupData.COptionsFloatData[E_OPTIONS_TEMP].value = data;
}
 
double TCSuperSpiceDoc::GetTemperature(void)
{
	TCSuperSpiceDoc	*PCLevelDoc = GetTopLevelDoc();

	if(!PCLevelDoc) return 0.0;

	TCBerklySpiceOptionsSetupData &CBerklySpiceOptionsSetupData = CMSuperSpiceDocData.PCAnalysisSetup->CBerklySpiceOptionsSetupData;

	if(!(E_OPTIONS_TEMP < CBerklySpiceOptionsSetupData.COptionsFloatData.GetSize())) return 0.0;

	return CBerklySpiceOptionsSetupData.COptionsFloatData[E_OPTIONS_TEMP].value;
}

void TCSuperSpiceDoc::OnSetupSetTemperature() 
{
	TCSetTemperatureDlg	CSetTemperatureDlg;

	CSetTemperatureDlg.PCSuperSpiceDoc = this;

	CSetTemperatureDlg.DoModal();// will callback this to set
}

void TCSuperSpiceDoc::RenumberRefDesignators(CView *PCView)
{
	PCView;

	ResetRefDesignatorsIDs(PCView);

	UpdateAllRefDesignators();
}

void TCSuperSpiceDoc::UpdateAllRefDesignators(void)
{
	GenerateUniqueSchematicManagers();

	int count = CMUniqueSchematicManagerList.GetSize();

	for(int p = 0; p < count; p++)// will do it for all views of the same page
	{
		UpdateRefDesignators(CMUniqueSchematicManagerList[p]);
	}
}

void TCSuperSpiceDoc::UpdateRefDesignators(TCSchematicManager *PCSchematicManager)
{
	if(!PCSchematicManager) return;

	TCSuperSpiceView *PCViewInList;
	TCSuperSpiceView *PCViewFirst;

	TCSchematicManager *PCSchematicManagerFirst = PCSchematicManager;

	PCSchematicManagerFirst;
	PCViewFirst;
	int page_id = PCSchematicManager->GetPageId();

	POSITION pos = GetFirstViewPosition();

	int component_count, p;
	CString CText;

	TCSchematicObject *PCSchematicObject;

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		component_count = PCSchematicManager->CMSchematicManagerData.CGraphicList.GetSize();

		for(p = 0; p < component_count; p++)
		{
			PCSchematicObject = PCSchematicManager->CMSchematicManagerData.CGraphicList[p];

			if(PCSchematicObject->m_type == E_WIRE_COMPONENT) continue;

			CText = GetNewReferanceDesignator(PCSchematicObject->CMSchematicObjectData);

			if(CText != "") PCSchematicManager->SetLabel(p, E_COMPONENT_DESIGNATOR, CText);
		}

		PCSchematicManager->SetSelectAll();
		PCSchematicManager->ResetSelectAll(true);
	}
}

void TCSuperSpiceDoc::RenumberWires(CView *PCView)
{
	PCView;

	int id = CConvertIdToRefId[E_WIRE_COMPONENT];

	CMSuperSpiceDocData.CRefId[id] = 0;

	ClearAllNetNames(PCView);

	UpdateAllNets();

	SetModifiedFlag(true);
}

void TCSuperSpiceDoc::ClearAllNetNames(CView *PCView)
{
	PCView;

	GenerateUniqueSchematicManagers();

	int count = CMUniqueSchematicManagerList.GetSize();

	for(int p = 0; p < count; p++)// will do it for all pages and views of the same page
	{
		CMUniqueSchematicManagerList[p]->ClearAllNetNames();
	}
}
 
void TCSuperSpiceDoc::ResetRefDesignatorsIDs(CView *PCView)
{
	PCView;

	int id = CConvertIdToRefId[E_WIRE_COMPONENT];

	int count  = CMSuperSpiceDocData.CRefId.GetSize();

	int p;
	
	int last_wire_ref = CMSuperSpiceDocData.CRefId[id];// dont renumber wires

	for(p = 0; p < count; p++)
	{
		CMSuperSpiceDocData.CRefId[p] = 0;
	}

	CMSuperSpiceDocData.CRefId[id] = last_wire_ref;
}

void TCSuperSpiceDoc::OnFileLoadSpiceDataFile() 
{
	CString CFileName;
	CString CText, CDirectory;
	char	*p_buff;

	CFileDialog	CLoadFileDialog(true, "out", "*.out", OFN_ALLOWMULTISELECT,"Spice output text files  (*.out)| *.out||");

	CLoadFileDialog.m_ofn.lpstrFile = new char[65536];// this needs modified to allow arbitary nmber of files

	if(!CLoadFileDialog.m_ofn.lpstrFile) 
	{
		AfxMessageBox(IDS_ERR_NO_MEMORY);

		return;
	}

	CText = "*.out";

	strcpy(CLoadFileDialog.m_ofn.lpstrFile, CText);

	CLoadFileDialog.m_ofn.nMaxFile = 65535;

	if(CLoadFileDialog.DoModal() != IDOK) 
	{
		delete [] CLoadFileDialog.m_ofn.lpstrFile;

		return;
	}

	CDirectory = CLoadFileDialog.m_ofn.lpstrFile;

	p_buff = &CLoadFileDialog.m_ofn.lpstrFile[CDirectory.GetLength() + 1];

	CArray <CString, CString> CFileNameList;

	CFileNameList.SetSize(0,128);
 
	while(*p_buff != 0) // stuff all names into array
	{
		CFileName = p_buff;

		p_buff += CFileName.GetLength() + 1;

		CFileName = CDirectory + '\\' + CFileName;

		CFileNameList.Add(CFileName);
	
	}

	delete [] CLoadFileDialog.m_ofn.lpstrFile;
	
	int count = CFileNameList.GetSize();

	if(!count)
	{
		CFileNameList.Add(CDirectory);
	}
		
	count = CFileNameList.GetSize();

	if(!count) return;

	CMSuperSpiceDocData.CWaveformDataRuns.SetSize(count);
	
	count = CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize();

	for(int p = 0; p < count; p++)
	{
//		CMSuperSpiceDocData.CWaveformDataRuns.CRuns[p]->CRunDiscription = ExtractFileName(CFileNameList[p]); //4th Aug 2012 removed

		CMSuperSpiceDocData.CWaveformDataRuns.CRuns[p]->CRunDiscription = CFileNameList[p]; //4th Aug 2012 added
	}

	DisplayError(IDS_EER_STATUS, IDS_ATTEMPTING_TO_LOAD);

	BeginWaitCursor();

	int line_count = 128;

	{
		line_count = GCGeneralReportsTab.m_max_line_count;

//		GCGeneralReportsTab.SetMaxNumberLines(8);// 4th Aug 2012
	}

	if(!CMSuperSpiceDocData.CWaveformDataRuns.Load("", CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize(), GetTopLevelDoc(), &CMWaveformAnalyisisData, 0)) 
	{
		EndWaitCursor();

		GCGeneralReportsTab.SetMaxNumberLines(line_count);

		DisplayError(IDS_ERR_ERROR, IDS_ERR_IN_LOAD, 0);

	//	return;
	}

//	GCGeneralReportsTab.SetMaxNumberLines(line_count); 4th Aug 2012

	UpdateAllViews(NULL, NULL);

	TCOutputWaveformDoc *PCOutputWaveformDoc = (TCOutputWaveformDoc *)CDocumentWindowsList.IsOpen(CMSuperSpiceDocData.CMasterOutputWaveform);
	
	if(PCOutputWaveformDoc)// update graphic output display
	{
		PCOutputWaveformDoc->UpdateWaveforms(CMSuperSpiceDocData.CMasterOutputDataFileName);	
	}

	DisplayError(IDS_EER_STATUS, IDS_GRAPHS_UPDATED);
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewFantasticFilter(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	page_id;

	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();

	PCSchematicManager;// to place the filter from clipboard 
	GCSuperSpiceClipboard;

	TCMasterFantasticFilterPropertySheet CMasterFantasticFilterPropertySheet;

	CMasterFantasticFilterPropertySheet.CFantasticFilter = GCFantasticFilter;

	CMasterFantasticFilterPropertySheet.CElectronicFormulars = GCElectronicFormulars;

	if(CMasterFantasticFilterPropertySheet.DoModal() != IDOK && !CMasterFantasticFilterPropertySheet.button) 
	{
		return E_GRAPHICS_MANAGER_STATE_IDLE;
	}

	if(g_last_active_fantastic_filter_property_page) 
	{
		GCElectronicFormulars = CMasterFantasticFilterPropertySheet.CElectronicFormulars;

		return E_GRAPHICS_MANAGER_STATE_IDLE;
	}
	
	GCFantasticFilter = CMasterFantasticFilterPropertySheet.CFantasticFilter;

	GCElectronicFormulars = CMasterFantasticFilterPropertySheet.CElectronicFormulars;

	nFlags = CMasterFantasticFilterPropertySheet.button;

	if(!GCFantasticFilter.Calculate()) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CString CFileName = GetSuperSpiceFilterDir() + GCFantasticFilter.CFilterFileName;

	BeginWaitCursor();
 
	if(!GCSuperSpiceClipboard.Load(CFileName))
	{
		EndWaitCursor();

		CString CErrorMessage = "Unable to load specified filter schematic file "; 

		CErrorMessage += CFileName;

		AfxMessageBox(CErrorMessage);

		return E_GRAPHICS_MANAGER_STATE_IDLE;
	}
	
	if(!SetFilterValues()) 
	{
		AfxMessageBox(IDS_INVALID_FILTER_SCH);

		// but paste it anyway as best as one can
	}

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state;

	system_state = OnViewFilterPaste(PCView, nFlags, CMousePosition);

	EndWaitCursor();

	return system_state;
}

bool TCSuperSpiceDoc::SetFilterValues(void)
{
	return GCSuperSpiceClipboard.SetFilterValues(GCFantasticFilter);
}

// copied and modified from TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewFilterPaste(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceDoc::OnViewFilterPaste(CView *PCView, UINT nFlags, CPoint CMousePosition)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *)PCView;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSuperSpiceView->GetState();

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	nFlags;

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();
	TCSuperSpiceView *PCViewInList;

	if(nFlags != E_EDIT_FILTER) PutNewReferanceDesignatorsInClipboard(PCSchematicManager);;

	int page_id = PCSuperSpiceView->GetPageId();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		GCSuperSpiceClipboard.Zoom(that_zoom);

		if(!GCSuperSpiceClipboard.PasteComponents(PCSchematicManager, CScaledPoint, CThisFileName)) return system_state;

		PCSchematicManager->m_auto_keep_pasting = false;// do not keep pasting

		GCSuperSpiceClipboard.Zoom(1);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}

	return E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD;  
}

void TCSuperSpiceDoc::OnFileLoadaclipboard() 
{
	CString CFileName = GetSuperSpiceSystemDir();

	CFileName += "*.scl";

	CFileDialog	CLoadFileDialog(true, "scl", CFileName, 0,"SuperSpice Clipboard Files (*.scl)| *.scl||");

	if(CLoadFileDialog.DoModal() != IDOK) return;

	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return;

	GCSuperSpiceClipboard.Load(CFileName);

	POSITION pos = GetFirstViewPosition();

	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) GetNextView(pos);

	PCSuperSpiceView->CSuperSpiceViewData.system_state = E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD;

	OnViewEditPaste(PCSuperSpiceView, PCSuperSpiceView->CSuperSpiceViewData.CLastMousePosition);
}

void TCSuperSpiceDoc::OnFileSavecurrentclipboard() 
{
	CString CFileName = GetSuperSpiceSystemDir();

	CFileName += "*.scl";

	CFileDialog	CSaveFileDialog(false, "scl", CFileName, OFN_OVERWRITEPROMPT, "SuperSpice Clipboard Files (*.scl)| *.scl||");

	if(CSaveFileDialog.DoModal() != IDOK) return;

	CFileName = CSaveFileDialog.GetPathName();

	if(CFileName == "") return;	

	if(GCAuthorization.m_build_type == E_DEMO_RELEASE)
	if(GCSuperSpiceClipboard.GetNumberOfComponents() > E_MAX_NUM_NET_LINES)
	{	
		CString CTrialExceeded;

		CTrialExceeded.LoadString(IDS_CIRCUIT_SIZE_EXCEEDED);
			
		DisplayError(IDS_EER_STATUS, CTrialExceeded);
	
		return;
	}

	if(GCAuthorization.m_build_type == E_DEMO_RELEASE)
	if(GCSuperSpiceClipboard.GetNumberOfComponents() > E_MAX_NUM_NET_LINES)
	{
		return;
	}

	GCSuperSpiceClipboard.Save(CFileName);
}

void TCSuperSpiceDoc::CreatePCBNetlist(int format)
{
	if(!PCMNetList) return;

	if(!GCAuthorization.VerifyAtNetList())
	{
		// exit program
		return;
	}
	
	TCSuperSpiceDoc	*PCDoc = GetTopLevelDoc();

	if(!PCDoc)
	{

		DisplayError(IDS_ERR_SYSTEM_ERROR, IDS_UNABLETO_RUN_NETLISTER, 0);

		return;
	}

	double flag = 1.3;

#ifndef _DEBUG

#endif

	if(!PCDoc->top_level)
	{
		CGlobalStatusMessage.LoadString(IDS_NO_TOP_LEVEL_NETLIST);

		DisplayError(IDS_ERR_WARNING, IDS_NO_TOP_LEVEL_NETLIST);

		return;
	}

	if(CThisFileName == "") 
	{
		AfxMessageBox(IDS_SAVE_TO_NETLIST);

		return;
	}

	CArray <CString, CString>  CPinListDummy;//not required for top level

	BeginWaitCursor();

	int temp_netlist_flag = GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist;

	GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist = true;

	if(!PCDoc->CreateNetlist(format, CPinListDummy) || flag > (3.2))
	{
		EndWaitCursor();

		GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist = temp_netlist_flag;

		return;
	}

	CString CText;

	CText = RemoveExtention(CMSuperSpiceDocData.CMasterNetListFileName);

	CText += ".net";

	TCSuperSpiceTextDoc *PCSuperSpiceTextDoc = (TCSuperSpiceTextDoc *)CDocumentWindowsList.IsOpen(CText);

	if(PCSuperSpiceTextDoc)
	{
		if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
		{
			CDocumentWindowsList.Close(CText);// need to first close to allow the copy to work

			PCMNetList->ReFormatPCBNetlist(CText);

			CDocumentWindowsList.Open(this, CText);
		}
		else
		{
			LoadGenericFromArchive(PCSuperSpiceTextDoc, CText);

			PCSuperSpiceTextDoc->SetModifiedFlag(false);

			PCSuperSpiceTextDoc->UpdateTitle();
		}
	}
	else
	{
		if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist)
			PCMNetList->ReFormatPCBNetlist(CText);
	}

	GCSuperSpiceGlobalData.CProgramOptions.CGeneral.flat_netlist = temp_netlist_flag;

	OnViewDisplayPCBNetlist(NULL);

	EndWaitCursor();
}

void TCSuperSpiceDoc::OnSetupsDisplayStartMessage() 
{
	GCGeneralReportsTab.DisplayHeaderText();;	
}

bool TCSuperSpiceDoc::AddToProjectTree(void)
{
	CArray <TCSchematicObject*, TCSchematicObject*> CSchematicObjectList;

	int count = CDocumentWindowsList.CDocList.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{
		TCDocumentWindowsListData &CDocumentWindowsListData = CDocumentWindowsList.CDocList[p];

		if(CDocumentWindowsListData.type != E_SCHEMATIC_DOCUMENT) continue;

		GCWorkspaceTree.AddSchematicFile(this, CDocumentWindowsListData.CFileName);

		// now open file and look at lower level.

		AddSubCktProjectTree(CDocumentWindowsListData.CFileName);
	}

	for(p = 0; p < count; p++)
	{
		TCDocumentWindowsListData &CDocumentWindowsListData = CDocumentWindowsList.CDocList[p];

		if(CDocumentWindowsListData.type == E_SCHEMATIC_DOCUMENT) continue;

		GCWorkspaceTree.AddSchematicFile(this, CDocumentWindowsListData.CFileName);
	}

	return true;
}

bool TCSuperSpiceDoc::AddSubCktProjectTree(CString CFileName)
{
	CFileName.MakeLower();

	CString CLocalFileName = GetPathName();

	CLocalFileName.MakeLower();

	if(CLocalFileName == CFileName) 
	{
		ASSERT(0);

		return true;// avoid potential recusive addition.
	}

	TCSuperSpiceDoc *PCSuperSpiceDoc;

	bool f_flag = false;

	if(!CDocumentWindowsList.IsOpen(CFileName))f_flag = true;

	PCSuperSpiceDoc = (TCSuperSpiceDoc *)CDocumentWindowsList.Open(this, CFileName);

	if(!PCSuperSpiceDoc) return false;

	if(PCSuperSpiceDoc == this) 
	{	
		if(f_flag) CDocumentWindowsList.Close(CFileName);

		return false;
	}

	if(!PCSuperSpiceDoc->IsKindOf(RUNTIME_CLASS(TCSuperSpiceDoc))) 
	{	
		if(f_flag) CDocumentWindowsList.Close(CFileName);

		return false;
	}

	PCSuperSpiceDoc->PCParentSuperSpiceDoc = this;
	
	PCSuperSpiceDoc->AddToProjectTree();

	if(f_flag) CDocumentWindowsList.Close(CFileName);

	return true;
}

void TCSuperSpiceDoc::SetupGraphWindowSize(WINDOWPLACEMENT &s_window_placment)
{
	if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.auto_display_graphics) return;
//	if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.lock_graph_size_to_window_size) return;

	CRect CWindowRect;

	CWindowRect = s_window_placment.rcNormalPosition;

	TCSchematicObjectData &CSchematicObjectData = GCSuperSpiceDataBase.CMDefaults[E_WAVEFORM_COMPONENT];

	m_graph_width	= CSchematicObjectData.width;
	m_graph_hieght	= CSchematicObjectData.height;

	int cy = ::GetSystemMetrics(SM_CYSCREEN); 
    int cx = ::GetSystemMetrics(SM_CXSCREEN); 

	int x_text = 64;
	int y_text = 64;

	int x_offset = (int) ((64.0*cx)/800.0);
	int y_offset = (int) ((64.0*cy)/600.0);

	int width = x_text; 
	int height = y_text; 

	width = x_offset + width;
	height = y_offset + height;

	width = CWindowRect.Width() - width;  // need to get font hieght, width
	height =  CWindowRect.Height() - height;

	if(height < 16) height = 16;
	if(width < 16) width = 16;

	GCSuperSpiceDataBase.SetWaveFormDefaultSize((unsigned short) width, (unsigned short)height);			
}

void TCSuperSpiceDoc::RestoreGraphWindowSize(void)
{
	if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.auto_display_graphics) return;
//	if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.lock_graph_size_to_window_size) return;

	GCSuperSpiceDataBase.SetWaveFormDefaultSize(m_graph_width, m_graph_hieght);
}

void TCSuperSpiceDoc::OnFileNewTextFile() 
{
	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp *)AfxGetApp();

	if(!PCSuperSpiceApp) return;

	CMultiDocTemplate *PCMSpiceTextViewDocTemplate = PCSuperSpiceApp->GetSpiceOutputTextViewDocTemplate();

	if(!PCMSpiceTextViewDocTemplate) return;

	TCSuperSpiceTextDoc  *PCDoc = (TCSuperSpiceTextDoc *) PCMSpiceTextViewDocTemplate->OpenDocumentFile(NULL);

	if(!PCDoc) return;

	//more to do in attaching
}

void TCSuperSpiceDoc::SetDefaultSymbolPath(TCCreateSymbolFromSchematicData &CCreateSymbolFromSchematicData)
{
	CString CSchematicName;

	CSchematicName = GetPathName();

	CString CSystemDir = GetSuperSpiceSystemDir();

	CCreateSymbolFromSchematicData.CSchematicName = CSchematicName;

	CCreateSymbolFromSchematicData.CSymbolName = ExtractFileName(CSchematicName);

	CCreateSymbolFromSchematicData.CSymbolName = RemoveExtention(CCreateSymbolFromSchematicData.CSymbolName);
	
	if(CMCreateSymbolFromSchematicData.CSymbolFileName == "") 
	{
		CMCreateSymbolFromSchematicData.CSymbolFileName = CSystemDir + "UserSymbols.ssm";
	}

	CMSuperSpiceDocData.CSymbolFileName = CMCreateSymbolFromSchematicData.CSymbolFileName;
}

int TCSuperSpiceDoc::ComponentsCreateSymbolFromSchematic() 
{
	TCCreateSymbolFromSchematic CCreateSymbolFromSchematicDlg;

	SetDefaultSymbolPath(CMCreateSymbolFromSchematicData);

	if(!GetSubCktPinData(CMCreateSymbolFromSchematicData)) 
	{
		return -1;
	}

	CMCreateSymbolFromSchematicData;// member data structure;

	CCreateSymbolFromSchematicDlg.CCreateSymbolFromSchematicData = CMCreateSymbolFromSchematicData;

	if(CCreateSymbolFromSchematicDlg.DoModal() != IDOK) return -1;

	CMCreateSymbolFromSchematicData = CCreateSymbolFromSchematicDlg.CCreateSymbolFromSchematicData;

	CMSuperSpiceDocData.CSymbolFileName = CMCreateSymbolFromSchematicData.CSymbolFileName;

//	ReIDSubCktPins(CMCreateSymbolFromSchematicData); 23 rd May 2008,. No idea why this is done. It makes create symbol have wrong IDs

	if(!GCSuperSpiceDataBase.CreateSymbolFromSchematic(CMCreateSymbolFromSchematicData))
	{
		AfxMessageBox(IDS_UNABLE_TO_CREATE_SYM);

		return -1;
	}

	DisplayError(IDS_EER_STATUS, IDS_SYMBOL_CREATED);

	return IDOK;
}

bool TCSuperSpiceDoc::GetSubCktPinData(TCCreateSymbolFromSchematicData &CCreateSymbolFromSchematicData)
{
	CString CSchematicName;

	CSchematicName = GetPathName();

	if(CSchematicName == "")
	{
		AfxMessageBox(IDS_MUST_SAVE_ONCE);

		return false;
	}

	GenerateUniqueSchematicManagers();

	TCSchematicManager *PCSchematicManager;
	CString CText;

	int count = CMUniqueSchematicManagerList.GetSize();

	CCreateSymbolFromSchematicData.CAll = "";
	CCreateSymbolFromSchematicData.CAllList.SetSize(0, 32);
	CCreateSymbolFromSchematicData.CPinID.SetSize(0, 32);

	CString CPinID, CName;
	int pin_id;
	int f_pins = false;

	for(int p = 0; p < count; p++)
	{
		PCSchematicManager = CMUniqueSchematicManagerList[p];

		CArray <TCSchematicObject *, TCSchematicObject *> &CGraphicList = PCSchematicManager->CMSchematicManagerData.CGraphicList;
		
		int scount = CGraphicList.GetSize();

		for(int q = 0; q < scount; q++)
		{
			if(CGraphicList[q]->m_type != E_SUBCIRCUIT_PIN_CONNECTER) continue;			

			CName = CGraphicList[q]->GetPinLabel(0, E_COMPONENT_PIN_NET_NAME);

			CCreateSymbolFromSchematicData.CAll += CName + " ";

			CPinID = CGraphicList[q]->CMSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel;
		
			pin_id = (int)SpiceMKSStringToFloat(CPinID);

			CCreateSymbolFromSchematicData.CAllList.Add(CName);
			CCreateSymbolFromSchematicData.CPinID.Add(pin_id);

			f_pins = true;
		}
	}

	if(!f_pins)
	{
		DisplayError(IDS_ERR_WARNING, IDS_NO_SUBCKT_CONNECT);
	}
		
	CCreateSymbolFromSchematicData.CAll.TrimLeft();

	CCreateSymbolFromSchematicData.RemoveDeletedFromLists();

	return true;
}

void TCSuperSpiceDoc::ReIDSubCktPins(TCCreateSymbolFromSchematicData &CCreateSymbolFromSchematicData)
{
	TCSchematicManager *PCSchematicManager;
	CString CText;

	int count = CMUniqueSchematicManagerList.GetSize();

	CCreateSymbolFromSchematicData.CPinID.SetSize(0, 32);

	CString CPinID, CName;
	int pin_id = 0;

	for(int p = 0; p < count; p++)
	{
		PCSchematicManager = CMUniqueSchematicManagerList[p];

		CArray <TCSchematicObject *, TCSchematicObject *> &CGraphicList = PCSchematicManager->CMSchematicManagerData.CGraphicList;
		
		int scount = CGraphicList.GetSize();

		for(int q = 0; q < scount; q++)
		{
			if(CGraphicList[q]->m_type != E_SUBCIRCUIT_PIN_CONNECTER) continue;			

			CPinID.Format("%d", pin_id);

			CGraphicList[q]->SetLabel(&GlobalCDCTemp, E_COMPONENT_VALUE, CPinID);

			CCreateSymbolFromSchematicData.CPinID.Add(pin_id);

			pin_id++;
		}
	}
}

void TCSuperSpiceDoc::OnComponentsCreateSymbolForModel() 
{
	if(GCSuperSpiceDataBase.CreateSymbolForModel())
		DisplayError(IDS_EER_STATUS, IDS_SYMBOL_CREATED);
	else DisplayError(IDS_EER_STATUS, IDS_UNABLE_TO_CREATE_SYM);
}

int TCSuperSpiceDoc::FileCreateSubcktModelFromSchematic() 
{
	if(CThisFileName == "") 
	{
		AfxMessageBox(IDS_SAVE_TO_NETLIST);

		return -1;
	}

	BeginWaitCursor();
	DisplayError(IDS_EER_STATUS, IDS_CREATING_NETLIST, 0);

	UpdateAllNets();

	SetDefaultSymbolPath(CMCreateSymbolFromSchematicData);

	if(!GetSubCktPinData(CMCreateSymbolFromSchematicData)) 
	{
		EndWaitCursor();

		return -1;
	}

	CArray <CString, CString>  CPinList;

	int pin_count = CMCreateSymbolFromSchematicData.CAllList.GetSize();

	if(!pin_count) 
	{
		EndWaitCursor();

		return -1;
	}

	CPinList.SetSize(pin_count);

	for(int p = 0; p < pin_count; p++)
	{
		CPinList[p] = CMCreateSymbolFromSchematicData.FindName(p);
	}

	if(!PCMNetList->CreateSubcktModel(CMUniqueSchematicManagerList, *CMSuperSpiceDocData.PCAnalysisSetup, this, CPinList))
	{
		CGlobalStatusMessage = E_STATUS_MSG_NET_LIST_ERRORS;

		DisplayError(IDS_ERR_ERROR, IDS_NETLIST_ERROR, 0);

		EndWaitCursor();

		return -1;
	}

	TCSuperSpiceTextDoc *PCSuperSpiceTextDoc = (TCSuperSpiceTextDoc *)CDocumentWindowsList.IsOpen(CMSuperSpiceDocData.CMasterNetListFileName);

	if(PCSuperSpiceTextDoc)// update netlist text display
	{
		LoadGenericFromArchive(PCSuperSpiceTextDoc, CMSuperSpiceDocData.CMasterNetListFileName);

		PCSuperSpiceTextDoc->SetModifiedFlag(false);

		PCSuperSpiceTextDoc->UpdateTitle();
	}
	else
	{
		DisplayTextBasedDocument(CMSuperSpiceDocData.CMasterNetListFileName);
	}

	UpdateAllSchematics();

	DisplayError(IDS_EER_STATUS, IDS_SUBCKT_MODEL_CREATED);

	GCSuperSpiceDataBase.AddModelToUserLibrary(CMSuperSpiceDocData.CMasterNetListFileName);
	
	EndWaitCursor();

	return IDOK;
}

void TCSuperSpiceDoc::OnComponentsCreateSymbolFromSchematic()
{
	ComponentsCreateSymbolFromSchematic();
}

void TCSuperSpiceDoc::OnFileCreateSubcktModelFromSchematic()
{
	FileCreateSubcktModelFromSchematic();
}

void TCSuperSpiceDoc::OnFileCreateModelandSymbolFromSchematic() 
{
	if(ComponentsCreateSymbolFromSchematic() != IDOK) return;
	if(FileCreateSubcktModelFromSchematic() != IDOK) return;

	TCSchematicObjectData CSchematicObjectData;

	CSchematicObjectData.CSymbolData.CName		= CMCreateSymbolFromSchematicData.CSymbolName;
	CSchematicObjectData.CSymbolData.CFileName	= ExtractFileName(CMCreateSymbolFromSchematicData.CSymbolFileName);
	CSchematicObjectData.CSymbolData.CFilePath	= ExtractPathName(CMCreateSymbolFromSchematicData.CSymbolFileName);

	if(!GCSuperSpiceDataBase.GetSchematicObjectData(CSchematicObjectData)) return;
 
	CSchematicObjectData.attached_model_type = E_SPICE_DOT_SUBCIRCUIT;
	CSchematicObjectData.component_property_view_type = E_PROPERTY_GENERIC_SUBCIRCUIT;

	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.model_type = E_SPICE_DOT_SUBCIRCUIT;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CModelType = "SUBCKT";
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordType = "X";

	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName		= CMCreateSymbolFromSchematicData.CSymbolName + "_XN";
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName	= "UserModels.lib";
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFilePath	= CSchematicObjectData.CSymbolData.CFilePath;
	CSchematicObjectData.CSymbolData.CChildFileName = "";

	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMCreateSymbolFromSchematicData.CSymbolName;
	CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].CLabel = CMCreateSymbolFromSchematicData.CSymbolName + "_XN";

	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CSchematicObjectData.CLabelListData[E_COMPONENT_VALUE].is_visable = false;

	CSchematicObjectData.FormatSpiceName();
	CSchematicObjectData.FormatSpiceValue();

	GCSuperSpiceDataBase.SetSchematicObjectData(CSchematicObjectData, false);// Leave model data alone
}

void TCSuperSpiceDoc::ChangeWaveformColour(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSuperSpiceView *PCViewInList;
	
	if(!PCSuperSpiceView) return;

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();

	if(!PCSchematicManager) return;

	COLORREF colour;

	CColorDialog CColorDialog;

	if(CColorDialog.DoModal() != IDOK) return;

	colour = CColorDialog.GetColor();

	POSITION pos = GetFirstViewPosition();

	pos = GetFirstViewPosition();

	int page_id = PCSuperSpiceView->GetPageId();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCSchematicManager->ChangeColour(PCViewInList->CSuperSpiceViewData.CLastMousePosition, colour);
	}
}

void TCSuperSpiceDoc::ChangeGraphBKGColour(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSuperSpiceView *PCViewInList;
	
	if(!PCSuperSpiceView) return;

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();

	if(!PCSchematicManager) return;

	COLORREF colour;

	CColorDialog CColorDialog;

	if(CColorDialog.DoModal() != IDOK) return;

	colour = CColorDialog.GetColor();

	POSITION pos = GetFirstViewPosition();

	pos = GetFirstViewPosition();

	int page_id = PCSuperSpiceView->GetPageId();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCSchematicManager->ChangeGraphBKGColour(PCViewInList->CSuperSpiceViewData.CLastMousePosition, colour);
	}
}

void TCSuperSpiceDoc::SetGraphicsModified(bool value)
{
	TCSuperSpiceView *PCView = PCSuperSpiceViewLastFocused;

	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSuperSpiceView *PCViewInList;
	
	if(!PCSuperSpiceView) return;

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();

	if(!PCSchematicManager) return;

	POSITION pos = GetFirstViewPosition();

	pos = GetFirstViewPosition();

	int page_id = PCSuperSpiceView->GetPageId();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCSchematicManager->graphics_modified = value;
	}
}

bool TCSuperSpiceDoc::IsGraphicsModified(void)
{
	POSITION pos = GetFirstViewPosition();

	TCSuperSpiceView *PCView = (TCSuperSpiceView *) GetNextView(pos);

	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSuperSpiceView *PCViewInList;
	
	if(!PCSuperSpiceView) return false;

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();

	if(!PCSchematicManager) return false;

	pos = GetFirstViewPosition();

	int page_id = PCSuperSpiceView->GetPageId();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		if(PCSchematicManager->graphics_modified) return true;
	}

	return false;
}

void TCSuperSpiceDoc::ClearAllWaveforms(void)
{
	POSITION pos = GetFirstViewPosition();

	TCSuperSpiceView *PCView = (TCSuperSpiceView *) GetNextView(pos);

	bool flag = CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]->AreWaveformsAvailable();
		
	TCOutputWaveformDoc *PCOutputWaveformDoc = (TCOutputWaveformDoc *)CDocumentWindowsList.IsOpen(CMSuperSpiceDocData.CMasterOutputWaveform);

	if(!flag) if(PCOutputWaveformDoc) {CDocumentWindowsList.Close(CMSuperSpiceDocData.CMasterOutputWaveform); PCOutputWaveformDoc = NULL;}

	if(PCOutputWaveformDoc) PCOutputWaveformDoc->ClearAllWaveforms();

	ClearAllWaveforms(PCView);
}

void TCSuperSpiceDoc::ClearAllWaveforms(CView *PCView)
{
	TCSuperSpiceView *PCSuperSpiceView = (TCSuperSpiceView *) PCView;
	TCSuperSpiceView *PCViewInList;
	
	if(!PCSuperSpiceView) return;

	TCSchematicManager *PCSchematicManager = PCSuperSpiceView->GetSchematicManager();

	if(!PCSchematicManager) return;

	POSITION pos = GetFirstViewPosition();

	pos = GetFirstViewPosition();

	int page_id = PCSuperSpiceView->GetPageId();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCSchematicManager->ClearAllWaveforms();

		PCSchematicManager->graphics_modified = false;
	}
}

void TCSuperSpiceDoc::OnComponentsFindModel() 
{	
	TCFindModelDlg CFindModelDlg;

	if(CFindModelDlg.DoModal() != IDOK) return;

	CFindModelDlg.FindAndDisplayModel(CFindModelDlg.CMModelName);
}

void TCSuperSpiceDoc::SetLoopGainSource(void)
{
	TCAnalysisSetup &CAnalysisSetup = *CMSuperSpiceDocData.PCAnalysisSetup;

	CMWaveformAnalyisisData.CLoopGainSource = CAnalysisSetup.CReRun.CReserved.CStringArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE];

	if(CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] != 1) return;
	if(CAnalysisSetup.CReRun.CReserved.CStringArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] == "None") return;
	if(CAnalysisSetup.CReRun.CReserved.CStringArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] == "") return;

	TCSchematicObject *PCSchematicObject = FindSchematicObject(CMWaveformAnalyisisData.CLoopGainSource);

	if(!PCSchematicObject) return;

	if(!PCSchematicObject->CMSchematicObjectData.PCGeneratorData) return;
		
	PCSchematicObject->CMSchematicObjectData.PCGeneratorData->CDCGeneratorData.CACVoltage = "1.0";

	PCSchematicObject->CMSchematicObjectData.FormatLabels();

	GCGeneralReportsTab.DisplayMessage(IDS_EER_STATUS, IDS_SETTING_LOOP_GAIN_SOURCE, -1);
}

void TCSuperSpiceDoc::ResetSetLoopGainSource(void)
{
	TCAnalysisSetup &CAnalysisSetup = *CMSuperSpiceDocData.PCAnalysisSetup;

	CMWaveformAnalyisisData.CLoopGainSource = CAnalysisSetup.CReRun.CReserved.CStringArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE];

	if(CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] != 1) return;
	if(CAnalysisSetup.CReRun.CReserved.CStringArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] == "None") return;
	if(CAnalysisSetup.CReRun.CReserved.CStringArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] == "") return;

	TCSchematicObject *PCSchematicObject = FindSchematicObject(CMWaveformAnalyisisData.CLoopGainSource);

	if(!PCSchematicObject) return;

	if(!PCSchematicObject->CMSchematicObjectData.PCGeneratorData) return;

	if(!PCSchematicObject->CMSchematicObjectData.PCGeneratorData) return;

	//force the loop gain generator to have a value of unity

	GCGeneralReportsTab.DisplayMessage(IDS_EER_STATUS, IDS_RESETTING_LOOP_GAIN_SOURCE , -1);

	PCSchematicObject->CMSchematicObjectData.PCGeneratorData->CDCGeneratorData.CACVoltage = "0.0";

	PCSchematicObject->CMSchematicObjectData.FormatLabels();
}

bool TCSuperSpiceDoc::SetupWaveformAnalyisisData(void)
{
	if(!CMSuperSpiceDocData.PCAnalysisSetup) return false;

	TCAnalysisSetup &CAnalysisSetup = *CMSuperSpiceDocData.PCAnalysisSetup;

	CMWaveformAnalyisisData.CLoopGainSource = CAnalysisSetup.CReRun.CReserved.CStringArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE];
	CMWaveformAnalyisisData.phase_zero = CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_ZERO_PHASE];
		
	if(CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] == 1)
	{
		CMWaveformAnalyisisData.plot_ac_analysis = true;
		CMWaveformAnalyisisData.ac_analysis_type = E_WAVEFORM_ANALYSIS_LG_LOOP_GAIN;

		CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_IMPEDANCE] = false;
		CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_POWER] = false;
	}
	else if(CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_IMPEDANCE] == 1)
	{
		CMWaveformAnalyisisData.plot_ac_analysis = true;
		CMWaveformAnalyisisData.ac_analysis_type = E_WAVEFORM_ANALYSIS_IMPEDANCE;

		CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_POWER] = false;	
	}
	else if(CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_POWER])
	{
		CMWaveformAnalyisisData.plot_ac_analysis = true;
		CMWaveformAnalyisisData.ac_analysis_type = E_WAVEFORM_ANALYSIS_POWER;
	}
	else CMWaveformAnalyisisData.plot_ac_analysis = false;

	if(CMWaveformAnalyisisData.plot_ac_analysis)
	{
		if(!GetLoopGainNodes(CMWaveformAnalyisisData.CLoopGainSource, CMWaveformAnalyisisData.CLoopGainInputNode, CMWaveformAnalyisisData.CLoopGainOutputNode, CMWaveformAnalyisisData.ac_analysis_type))
		{
			CMWaveformAnalyisisData.CLoopGainInputNode	= "";
			CMWaveformAnalyisisData.CLoopGainOutputNode = "";

			GCGeneralReportsTab.DisplayMessage(IDS_ERR_WARNING, IDS_NO_LOOP_GAIN_VSRC , -1);
		}
	}

	CMWaveformAnalyisisData.trans_frequency = -1.0; //default
	CMWaveformAnalyisisData.trans_last_time = -1.0;
	CMWaveformAnalyisisData.trans_first_time= -1.0;

	CMWaveformAnalyisisData.trans_frequency_enable = !!CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_FREQ_ENABLE];
	CMWaveformAnalyisisData.trans_xing_sign =  (int)CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_POLARITY];
	CMWaveformAnalyisisData.trans_xing_last_count =  (int)CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_LAST_COUNT];
	CMWaveformAnalyisisData.trans_xing_first_count =  (int)CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_FIRST_COUNT];
	CMWaveformAnalyisisData.CTransFrequencySignalName = CAnalysisSetup.CReRun.CReserved.CStringArray[E_TRAN_ANALYSIS_RESERVED_OUTPUT_NAME];
	CMWaveformAnalyisisData.trans_xing_level = CAnalysisSetup.CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_XING_LEVEL];

	return true;
}

bool TCSuperSpiceDoc::CalculateAllTransientPowers(CArray <CString, CString> *PCRefDes, CArray <double, double> *PCPower, int run_number)
{
	if(!(run_number < GetTopLevelDoc()->CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize())) return false;

	if(!GetTopLevelDoc()->CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT)) return false;

	TCSchematicManager *PCSchematicManager;
	
	int component_count;

	int count = CMUniqueSchematicManagerList.GetSize();

	CString CRefDes;
	CArray <CString, CString> CVoltages, CCurrents;

	int type, pin_count, test_count;
	double power_value;
	TCSchematicObject *PCSchematicObject;
	int ref_counter = 0;
	int sign;

	if(PCRefDes && PCPower)
	{
		PCRefDes->SetSize(0);
		PCRefDes->SetSize(256, 256);

		PCPower->SetSize(0);
		PCPower->SetSize(256, 256);
	}

	TCWaveformAnalyisisData CWaveformAnalyisisData = GetTopLevelDoc()->CMWaveformAnalyisisData;

	for(int p = 0; p < count; p++)
	{
		PCSchematicManager = CMUniqueSchematicManagerList[p];

		CArray <TCSchematicObject *, TCSchematicObject *> &CGraphicList = PCSchematicManager->CMSchematicManagerData.CGraphicList;
		
		component_count = CGraphicList.GetSize();

		for(int q = 0; q < component_count; q++)
		{
			PCSchematicObject = CGraphicList[q];

			type = PCSchematicObject->CMSchematicObjectData.type;

			if(type)
			if(type < E_DC_VOLTAGE_SOURCE || type == E_TITLE_BLOCK) continue;

			CRefDes = PCSchematicObject->CMSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

			if(!PCSchematicManager->GetVoltageSignalNames(PCSchematicObject, CVoltages)) continue;
			if(!PCSchematicManager->GetCurrentSignalNames(PCSchematicObject, CCurrents)) continue;

			sign = GCSuperSpiceDataBase.GetSpicePowerPolarity(PCSchematicObject->CMSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordType);

			pin_count = CVoltages.GetSize();

			test_count = CCurrents.GetSize();

			if(pin_count != test_count) continue;

			power_value = 0;

			for(int p = 0; p < pin_count; p++)
			{
				CWaveformAnalyisisData.CPowerVoltName	 = CVoltages[p];
				CWaveformAnalyisisData.CPowerCurrentName = CCurrents[p];

				if(!GetTopLevelDoc()->CMSuperSpiceDocData.CWaveformDataRuns.CalculatePower(CWaveformAnalyisisData, run_number)) continue;

				power_value += CWaveformAnalyisisData.power_value;
			}

			power_value *= sign;

			PCSchematicObject->CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_TRANSIENT_POWER] = (float) power_value;

			if(PCRefDes && PCPower)
			{
				PCRefDes->SetAtGrow(ref_counter, CRefDes);
				PCPower->SetAtGrow(ref_counter, power_value);
			}

			ref_counter++;
		}
	}

	if(PCRefDes && PCPower)
	{
		PCRefDes->SetSize(ref_counter);

		PCPower->SetSize(ref_counter);
	}
/*
	CString CText, CTemp;

	CText.LoadString(IDS_TRANSIENT_POWER_CREATED);

	CTemp.Format(" for run %d.", run_number);

	CText += CTemp;

	GCGeneralReportsTab.DisplayMessage(IDS_EER_STATUS, CText , -1);
*/
	return true;
}

bool TCSuperSpiceDoc::CalculateTransientAverages(TCWaveformAnalyisisData &CWaveformAnalyisisData, int index)
{
	if(index < 0) return false;

	int num_runs = CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize();

	if(!(index < num_runs))  return false;

	if(!CMSuperSpiceDocData.CWaveformDataRuns.CRuns[index]->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT)) return false;

	if(!CMSuperSpiceDocData.CWaveformDataRuns.CalculateTransientAverages(CWaveformAnalyisisData, index)) return false;

	return true;
}

bool TCSuperSpiceDoc::CalculateTransientPower(CString CRefDes, TCWaveformAnalyisisData &CWaveformAnalyisisData, int index)
{
	if(index < 0) return false;

	int num_runs = CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize();

	if(!(index < num_runs))  return false;

	if(!CMSuperSpiceDocData.CWaveformDataRuns.CRuns[index]->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT)) return false;

	TCSchematicManager *PCSchematicManager = NULL;

	TCSchematicObject *PCSchematicObject = FindSchematicObject(CRefDes, &PCSchematicManager);

	if(!PCSchematicObject) return false;
	if(!PCSchematicManager) return false;

	CArray <CString, CString> CVoltages, CCurrents;

	if(!PCSchematicManager->GetVoltageSignalNames(PCSchematicObject, CVoltages)) return false;
	if(!PCSchematicManager->GetCurrentSignalNames(PCSchematicObject, CCurrents)) return false;

	int count = CVoltages.GetSize();

	int test_count = CCurrents.GetSize();

	if(count != test_count) return false;

	double power_value = 0;
	int sign = GCSuperSpiceDataBase.GetSpicePowerPolarity(PCSchematicObject->CMSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordType);

	for(int p = 0; p < count; p++)
	{
		CWaveformAnalyisisData.CPowerVoltName	 = CVoltages[p];
		CWaveformAnalyisisData.CPowerCurrentName = CCurrents[p];

		if(!CMSuperSpiceDocData.CWaveformDataRuns.CalculatePower(CWaveformAnalyisisData, index)) return false;

		power_value += CWaveformAnalyisisData.power_value;
	}

	power_value *= sign;

	CWaveformAnalyisisData.power_value = power_value;

	return true;
}

bool TCSuperSpiceDoc::GetLoopGainNodes(CString CVSourceSource, CString &CInputNode, CString &COutputNode, int ac_analysis_type)
{
	TCSchematicObject *PCSchematicObject = FindSchematicObject(CVSourceSource);

	if(!PCSchematicObject) return false;

	int pin_count = PCSchematicObject->CMSchematicObjectData.CPinListData.GetSize();

	if(pin_count != 2) return false;
	
	CInputNode = PCSchematicObject->GetPinLabel(0, E_COMPONENT_PIN_NET_NAME);
	COutputNode = PCSchematicObject->GetPinLabel(1, E_COMPONENT_PIN_NET_NAME);

	if(ac_analysis_type == E_WAVEFORM_ANALYSIS_LG_LOOP_GAIN)
	{
		if(CInputNode == "0") return false; // must be in series with loop
		if(COutputNode == "0") return false;
	}

	if(COutputNode == CInputNode) return false;

	return true;
}

void TCSuperSpiceDoc::DoOutputProcessing(void)
{
	CString CTranTitle = "Transient Frequency";
	CString CACTitle = "Loop Gain/Phase";
	CString CPulseAnalysisTitle = "Pulse Data";
	CString CTransientAveragesTitle = "Transient Averages";

	if(CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] == 1) DisplayGainAndPhaseMargins(CACTitle);
	if(CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_FREQ_ENABLE]) DisplayTransientFrequency(CTranTitle);
	if(CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CReserved.CIntArray[E_PULSE_ANALYSIS_ENABLE]) DisplayTransientPulseAnalysis(CPulseAnalysisTitle);	
	if(CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CReserved.CIntArray[E_TRAN_RMS_ENABLE]) DisplayTransientAverages(CTransientAveragesTitle);	
	if(CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CReserved.CIntArray[E_DESIGNER_ENABLE_OPERATING_POINT]) UpdateDesignerValues();	
}

void TCSuperSpiceDoc::UpdateDesignerValues(void)
{
	CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CReserved.CIntArray[E_DESIGNER_ENABLE_OPERATING_POINT] = false;	

	// leave lower level for a later update, maybe.
	TCSuperSpiceView *PCViewInList = NULL;

	TCSchematicManager *PCSchematicManager;

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCSchematicManager->UpdateDesignerValues((int)GetTopLevelDoc()->CMSuperSpiceDocData.PCAnalysisSetup->CReRun.CReserved.CIntArray[E_DESIGNER_SELECTED_DEVICES]);
	}
}

void TCSuperSpiceDoc::DisplayTransientAverages(CString CTitle, int run)
{
	CMWaveformAnalyisisData = CMSuperSpiceDocData.PCAnalysisSetup->CReRun;

	if(!CMSuperSpiceDocData.CWaveformDataRuns.CalculateTransientAverages(CMWaveformAnalyisisData, run)) return;

	CMSuperSpiceDocData.PCAnalysisSetup->CReRun = CMWaveformAnalyisisData;

	CString CSignalName = CMWaveformAnalyisisData.CRMSSignalName;

	CString CRMS = FloatToMKSString(CMWaveformAnalyisisData.rms_value);

	CString CRMSRipple = FloatToMKSString(CMWaveformAnalyisisData.rms_ripple_value);

	CString CAVE = FloatToMKSString(CMWaveformAnalyisisData.rms_av_value);

	CString CPkPk = FloatToMKSString(CMWaveformAnalyisisData.rms_pk_value);

	CRMS = CSignalName + " RMS=" + CRMS;

	GCGeneralReportsTab.DisplayMessage(CTitle, CRMS, -1);

	CRMSRipple = CSignalName + " RMS Ripple=" + CRMSRipple;

	GCGeneralReportsTab.DisplayMessage(CTitle, CRMSRipple, -1);

	CAVE = CSignalName + " Average=" + CAVE;

	GCGeneralReportsTab.DisplayMessage(CTitle, CAVE, -1);

	CPkPk = CSignalName + " Pk-Pk=" + CPkPk;

	GCGeneralReportsTab.DisplayMessage(CTitle, CPkPk, -1);
}

void TCSuperSpiceDoc::DisplayTransientPulseAnalysis(CString CTitle, int run)
{
	CMWaveformAnalyisisData = CMSuperSpiceDocData.PCAnalysisSetup->CReRun;

	CMSuperSpiceDocData.CWaveformDataRuns.CalculatePulseData(CMWaveformAnalyisisData, run);

	CMSuperSpiceDocData.PCAnalysisSetup->CReRun = CMWaveformAnalyisisData;

	CString CRiseTime = FloatToMKSString(CMWaveformAnalyisisData.pulse_rise_time);
	CString CFallTime = FloatToMKSString(CMWaveformAnalyisisData.pulse_fall_time);
	CString CWidth = FloatToMKSString(CMWaveformAnalyisisData.pulse_width);
	CString CPeriod = FloatToMKSString(CMWaveformAnalyisisData.pulse_period);
	CString CDelay = FloatToMKSString(CMWaveformAnalyisisData.pulse_delay);

	CString CRefTime = FloatToMKSString(CMWaveformAnalyisisData.pulse_time);
	CString CRiseXingTime = FloatToMKSString(CMWaveformAnalyisisData.pulse_rise_xing_time);
	CString CFallXingTime = FloatToMKSString(CMWaveformAnalyisisData.pulse_fall_xing_time);
	CString CPulseWidthTime = FloatToMKSString(CMWaveformAnalyisisData.pulse_width_mid_time);

	CString CSec = "s";
	CString CAt = " at ";

	CRiseTime += CSec + CAt + CRiseXingTime + CSec;

	CRiseTime = " Rise Time=" + CRiseTime;

	CRiseTime = CMWaveformAnalyisisData.CPulseMeasureSignal + CRiseTime;

	GCGeneralReportsTab.DisplayMessage(CTitle, CRiseTime , -1);

	CFallTime += CSec + CAt + CFallXingTime + CSec;

	CFallTime = " Fall Time=" + CFallTime;

	CFallTime = CMWaveformAnalyisisData.CPulseMeasureSignal + CFallTime;

	GCGeneralReportsTab.DisplayMessage(CTitle, CFallTime , -1);

	CWidth += CSec + CAt + CPulseWidthTime + CSec;

	CWidth = " Pulse Width=" + CWidth;

	CWidth = CMWaveformAnalyisisData.CPulseMeasureSignal + CWidth;

	GCGeneralReportsTab.DisplayMessage(CTitle, CWidth , -1);

	CPeriod += CSec + CAt + CRefTime + CSec;

	CPeriod = " Pulse Period=" + CPeriod;

	CPeriod = CMWaveformAnalyisisData.CPulseMeasureSignal + CPeriod;

	GCGeneralReportsTab.DisplayMessage(CTitle, CPeriod , -1);

	CDelay += CSec + CAt + CRefTime + CSec;

	CDelay = " Pulse Delay=" + CDelay;

	CDelay = CMWaveformAnalyisisData.CPulseMeasureSignal + CDelay;

	GCGeneralReportsTab.DisplayMessage(CTitle, CDelay , -1);
}

void TCSuperSpiceDoc::DisplayTransientFrequency(CString CTitle)
{
	CString CFrequency = FloatToMKSString(CMWaveformAnalyisisData.trans_frequency);

	CFrequency +="Hz";

	CFrequency = "Frequency=" + CFrequency;

	GCGeneralReportsTab.DisplayMessage(CTitle, CFrequency , -1);

	CString CMsg, CData;

	CData = FloatToMKSString(CMWaveformAnalyisisData.trans_first_time) + "S";

	CMsg = "First Xing Time=" + CData + " - ";

	CData = FloatToMKSString(CMWaveformAnalyisisData.trans_last_time) + "S";

	CMsg += "Last Xing Time=" + CData;

	GCGeneralReportsTab.DisplayMessage(CTitle, CMsg , -1);
}

void TCSuperSpiceDoc::DisplayGainAndPhaseMargins(CString CTitle)
{
	CString CPhaseMargin, CGainMargin, CUnityGain, CZeroPhaseFrequency, CLowFGain;
	CString CDB, CDeg;

	if(CMWaveformAnalyisisData.phase_margin != -1000)
	{
		CPhaseMargin = FloatToMKSString(CMWaveformAnalyisisData.phase_margin);

		CDeg =  "Degs.";
	}
	else CPhaseMargin = "Undefined";

	if(CMWaveformAnalyisisData.gain_margin != -100)
	{
		CGainMargin = FloatToMKSString(CMWaveformAnalyisisData.gain_margin);

		CDB = "dB";
	}
	else CGainMargin = "Undefined";

	CUnityGain = FloatToMKSString(CMWaveformAnalyisisData.unity_gain_frequency);
	CZeroPhaseFrequency = FloatToMKSString(CMWaveformAnalyisisData.zero_phase_frequency);
	CLowFGain = FloatToMKSString(CMWaveformAnalyisisData.low_frequency_gain);

	CGainMargin	= "Gain Margin=" + CGainMargin + CDB;
	CPhaseMargin = "Phase Margin=" + CPhaseMargin + CDeg;
	CUnityGain = "Unity Gain Frequency=" + CUnityGain + "Hz";
	CZeroPhaseFrequency = "Zero Phase Frequency=" + CZeroPhaseFrequency + "Hz";
	CLowFGain = "Low Frequency Gain=" + CLowFGain + CDB;

//	CGainMargin = CGainMargin + " - " + CPhaseMargin;
//	CLowFGain = CLowFGain + " - " + CUnityGain;

	GCGeneralReportsTab.DisplayMessage(CTitle, CPhaseMargin , -1);
	GCGeneralReportsTab.DisplayMessage(CTitle, CGainMargin , -1);
	GCGeneralReportsTab.DisplayMessage(CTitle, CUnityGain , -1);
	GCGeneralReportsTab.DisplayMessage(CTitle, CLowFGain , -1);
	GCGeneralReportsTab.DisplayMessage(CTitle, CZeroPhaseFrequency , -1);
	
	TCGainPhaseMargin CGainPhaseMargin;

	if(CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize() > 1)// Only makes sense for more than 1 run.
	if(CMSuperSpiceDocData.CWaveformDataRuns.GetMinMaxLoopGain(CGainPhaseMargin))
	{
		DisplayMinGainAndPhaseMargins(CGainPhaseMargin);
	}
}

void TCSuperSpiceDoc::DisplayMinGainAndPhaseMargins(TCGainPhaseMargin &CGainPhaseMargin)
{
	CString CTitle, CMsg;
	CString CMinPhaseMargin;
	CString CMinGainMargin;
	CString CMinPhaseRunName;
	CString CMinMagRunName;
	CString CValue;

	CTitle = "Stability Summary";

	CValue = FloatToMKSString(CGainPhaseMargin.min_phase);

	CMsg = "Min Phase Margin=" + CValue + "Degs."+ " at run " + CGainPhaseMargin.CMinPhaseName; 

	GCGeneralReportsTab.DisplayMessage(CTitle, CMsg , -1);

	CValue = FloatToMKSString(CGainPhaseMargin.min_mag);

	CMsg = "Min Gain   Margin=" + CValue + "dB"+ " at run " + CGainPhaseMargin.CMinMagName;

	GCGeneralReportsTab.DisplayMessage(CTitle, CMsg , -1);
}

void TCSuperSpiceDoc::OnFileSaveastextdatafiles() 
{
	CString CFileName;

	CFileName = GetPathName();

	CFileName = RemoveExtention(CFileName);

	BeginWaitCursor();

	GCGeneralReportsTab.DisplayMessage(IDS_EER_STATUS, IDS_CREATING_OUTPUT_FILES , -1);

	if(!CMSuperSpiceDocData.CWaveformDataRuns.SaveAsText(CFileName))
	{
		GCGeneralReportsTab.DisplayMessage(IDS_ERR_ERROR, IDS_ERR_WAVEFORM_FILES , -1);
	}
	else
	{
		GCGeneralReportsTab.DisplayMessage(IDS_EER_STATUS, IDS_WAVEFORM_FILES_SAVED, -1);
	}

	EndWaitCursor();
}

void TCSuperSpiceDoc::OnFileReportsDcoperatingpoint(void)
{
	CString CFileName, CMessage;

	CFileName = GetPathName();

	CFileName = RemoveExtention(CFileName);

	CFileName = CFileName + "OpPointReport.txt";

	BeginWaitCursor();

	GCGeneralReportsTab.DisplayMessage(IDS_EER_STATUS, IDS_CREATE_OP_REPORT , -1);

	if(!CMSuperSpiceDocData.CWaveformDataRuns.CreateDCOperatingPointReport(CFileName))
	{
		GCGeneralReportsTab.DisplayMessage(IDS_ERR_ERROR, IDS_ERR_OP_REPORT , -1);
	}
	else
	{
		CString CMsg;
		
		CMsg.LoadString(IDS_SUCCESS_CREATED);

		CMessage = "DC Operating Point Report, "  + CFileName + CMsg;

		GCGeneralReportsTab.DisplayMessage(IDS_EER_STATUS, CMessage, -1);

		AfxGetApp()->OpenDocumentFile(CFileName);
	}

	EndWaitCursor();
}

void TCSuperSpiceDoc::OnViewReportsDcoperatingpoint() 
{
	CString CFileName;

	CFileName = GetPathName();

	CFileName = RemoveExtention(CFileName);

	CFileName = CFileName + "OpPointReport.txt";

	if(!FileExists(CFileName)) {OnFileReportsDcoperatingpoint(); return;}

	AfxGetApp()->OpenDocumentFile(CFileName);
}

void TCSuperSpiceDoc::OnFileReportsNoise(void)
{
	CString CFileName, CMessage;

	CFileName = GetPathName();

	CFileName = RemoveExtention(CFileName);

	CFileName = CFileName + "NoiseReport.txt";

	CMWaveformAnalyisisData = CMSuperSpiceDocData.PCAnalysisSetup->CReRun;

	BeginWaitCursor();

	GCGeneralReportsTab.DisplayMessage(IDS_EER_STATUS, "Creating Noise Report" , -1);

	if(!CMSuperSpiceDocData.CWaveformDataRuns.CreateNoiseReport(CFileName, CMWaveformAnalyisisData))
	{
		GCGeneralReportsTab.DisplayMessage(IDS_ERR_ERROR, "Failed to create noise report" , -1);
	}
	else
	{
		CString CMsg;
		
		CMsg.LoadString(IDS_SUCCESS_CREATED);

		CMessage = "Noise Report Created "  + CFileName + CMsg;

		GCGeneralReportsTab.DisplayMessage(IDS_EER_STATUS, CMessage, -1);

		AfxGetApp()->OpenDocumentFile(CFileName);
	}

	EndWaitCursor();
}

void TCSuperSpiceDoc::OnViewReportsNoise(void)
{
	CString CFileName;

	CFileName = GetPathName();

	CFileName = RemoveExtention(CFileName);

	CFileName = CFileName + "NoiseReport.txt";

	if(!FileExists(CFileName)) {OnFileReportsNoise(); return;}

	AfxGetApp()->OpenDocumentFile(CFileName);
}

void TCSuperSpiceDoc::OnFileReportsDcsweep(void)
{
	CString CFileName, CMessage;

	CFileName = GetPathName();

	CFileName = RemoveExtention(CFileName);

	CFileName = CFileName + "DCSweepReport.txt";

	BeginWaitCursor();

	GCGeneralReportsTab.DisplayMessage(IDS_EER_STATUS, IDS_CREATE_DC_REPORT , -1);

	if(!CMSuperSpiceDocData.CWaveformDataRuns.CreateDCSweepReport(CFileName))
	{
		GCGeneralReportsTab.DisplayMessage(IDS_ERR_ERROR, IDS_ERR_DC_REPORT , -1);
	}
	else
	{
		CString CMsg;
		
		CMsg.LoadString(IDS_SUCCESS_CREATED);

		CMessage = "DC Sweep Report, "  + CFileName + CMsg;

		GCGeneralReportsTab.DisplayMessage(IDS_EER_STATUS, CMessage, -1);

		AfxGetApp()->OpenDocumentFile(CFileName);
	}

	EndWaitCursor();
}

void TCSuperSpiceDoc::OnViewReportsDcsweep() 
{
	CString CFileName;

	CFileName = GetPathName();

	CFileName = RemoveExtention(CFileName);

	CFileName = CFileName + "DCSweepReport.txt";

	if(!FileExists(CFileName)) {OnFileReportsDcsweep(); return;}

	AfxGetApp()->OpenDocumentFile(CFileName);
}

void TCSuperSpiceDoc::OnFileReportsAcsweep(void)
{
	CString CFileName, CMessage;

	CFileName = GetPathName();

	CFileName = RemoveExtention(CFileName);

	CFileName = CFileName + "ACSweepReport.txt";

	BeginWaitCursor();

	GCGeneralReportsTab.DisplayMessage(IDS_EER_STATUS, IDS_CREATE_AC_REPORT , -1);

	if(!CMSuperSpiceDocData.CWaveformDataRuns.CreateACSweepReport(CFileName))
	{
		GCGeneralReportsTab.DisplayMessage(IDS_ERR_ERROR, IDS_ERR_AC_REPORT , -1);
	}
	else
	{
		CString CMsg;
		
		CMsg.LoadString(IDS_SUCCESS_CREATED);

		CMessage = "AC Sweep Report, "  + CFileName + CMsg;

		GCGeneralReportsTab.DisplayMessage(IDS_EER_STATUS, CMessage, -1);

		AfxGetApp()->OpenDocumentFile(CFileName);
	}

	EndWaitCursor();
}

void TCSuperSpiceDoc::OnViewReportsPulseAnalysis() 
{
	CString CFileName;

	CFileName = GetPathName();

	CFileName = RemoveExtention(CFileName);

	CFileName = CFileName + "PulseAnalysisReport.txt";

	CMWaveformAnalyisisData = CMSuperSpiceDocData.PCAnalysisSetup->CReRun;

	if(!FileExists(CFileName)) 
	if(!CMSuperSpiceDocData.CWaveformDataRuns.CreatePulseAnalysisReport(CFileName, CMWaveformAnalyisisData))
	{
		GCGeneralReportsTab.DisplayMessage(IDS_ERR_ERROR, IDS_UNABLE_VIEW_TRANS_AVERAGES, -1);

		return;
	}

	AfxGetApp()->OpenDocumentFile(CFileName);	
}

void TCSuperSpiceDoc::OnFileReportsPulseAnalysis(void)
{
	CString CFileName, CMessage;

	CFileName = GetPathName();

	CFileName = RemoveExtention(CFileName);

	CFileName = CFileName + "PulseAnalysisReport.txt";

	CMWaveformAnalyisisData = CMSuperSpiceDocData.PCAnalysisSetup->CReRun;

	if(!CMSuperSpiceDocData.CWaveformDataRuns.CreatePulseAnalysisReport(CFileName, CMWaveformAnalyisisData))
	{
		GCGeneralReportsTab.DisplayMessage(IDS_ERR_ERROR, IDS_UNABLE_VIEW_TRANS_AVERAGES, -1);

		return;
	}

	OnViewReportsPulseAnalysis();

	return;
}

void TCSuperSpiceDoc::OnViewReportsAcsweep(void)
{
	CString CFileName;

	CFileName = GetPathName();

	CFileName = RemoveExtention(CFileName);

	CFileName = CFileName + "ACSweepReport.txt";

	if(!FileExists(CFileName)) {OnFileReportsAcsweep();return;}

	AfxGetApp()->OpenDocumentFile(CFileName);
}

void TCSuperSpiceDoc::OnViewAnalysisLoopGain() 
{	
	int count = CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize();

	CString CTitle;

	for(int p = 0; p < count; p++)
	{
		if(!CMSuperSpiceDocData.CWaveformDataRuns.CalculateLoopGain(CMWaveformAnalyisisData, p)) continue;

		CTitle = "Loop Gain/Phase: ";

		CTitle += CMSuperSpiceDocData.CWaveformDataRuns.CRuns[p]->CRunDiscription;

		DisplayGainAndPhaseMargins(CTitle);
	}
}

void TCSuperSpiceDoc::OnViewAnalysisTransientFrequency() 
{
	int count = CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize();

	CString CTitle;

	for(int p = 0; p < count; p++)
	{
		if(!CMSuperSpiceDocData.CWaveformDataRuns.CalculateTransientFrequency(CMWaveformAnalyisisData, p)) continue;

		CString CTitle = "Transient Frequency: ";

		CTitle += CMSuperSpiceDocData.CWaveformDataRuns.CRuns[p]->CRunDiscription;

		DisplayTransientFrequency(CTitle);
	}
}

void TCSuperSpiceDoc::CalculateAverageFrequency(TCWaveformAnalyisisData &CWaveformAnalyisisData)
{
	
	CMWaveformAnalyisisData.trans_frequency_enable	= CWaveformAnalyisisData.trans_frequency_enable;			
	CMWaveformAnalyisisData.trans_xing_level		= CWaveformAnalyisisData.trans_xing_level;
	CMWaveformAnalyisisData.trans_xing_first_count	= CWaveformAnalyisisData.trans_xing_first_count;
	CMWaveformAnalyisisData.trans_xing_last_count	= CWaveformAnalyisisData.trans_xing_last_count;
	CMWaveformAnalyisisData.trans_xing_sign			= CWaveformAnalyisisData.trans_xing_sign;
			
	OnViewAnalysisTransientFrequency(); 
}

void TCSuperSpiceDoc::OnViewAnalysisresultsTransientPulse() 
{
	int count = CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize();

	for(int p = 0; p < count; p++)
	{
		CString CTitle  = "Pulse Data: ";

		CTitle += CMSuperSpiceDocData.CWaveformDataRuns.CRuns[p]->CRunDiscription;

		DisplayTransientPulseAnalysis(CTitle, p);
	}
}

void TCSuperSpiceDoc::OnViewAnalysisresultsTransientAverages() 
{
	int count = CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize();

	for(int p = 0; p < count; p++)
	{
		CString CTitle  = "Transient Averages: ";

		CTitle += CMSuperSpiceDocData.CWaveformDataRuns.CRuns[p]->CRunDiscription;

		DisplayTransientAverages(CTitle, p);
	}		
}

void TCSuperSpiceDoc::OnViewAnalysisSetup() 
{
	TCAnalysisMainPropPage CAnalysisMainPropPage;

	CAnalysisMainPropPage.PCAnalysisSetup = CMSuperSpiceDocData.PCAnalysisSetup;

	CAnalysisMainPropPage.PCWaveformDataRuns = &CMSuperSpiceDocData.CWaveformDataRuns;
	CAnalysisMainPropPage.PCSuperSpiceDoc = this;

	CMWaveformAnalyisisData = CMSuperSpiceDocData.PCAnalysisSetup->CReRun;

	CAnalysisMainPropPage.CWaveformAnalyisisData = CMWaveformAnalyisisData;

	CAnalysisMainPropPage.DoModal();

	CMWaveformAnalyisisData = CAnalysisMainPropPage.CWaveformAnalyisisData;

	CMSuperSpiceDocData.PCAnalysisSetup->CReRun = CMWaveformAnalyisisData;
}

void TCSuperSpiceDoc::OnSetupsXSpiceProgressRate() 
{
	if(E_OPTIONS_SIM_WAIT_TIME < CMSuperSpiceDocData.PCAnalysisSetup->CBerklySpiceOptionsSetupData.COptionsFloatData.GetSize())

		PCMXSpiceProgressDlg->CXSpiceProgressData.simulation_wait_time = (int) CMSuperSpiceDocData.PCAnalysisSetup->CBerklySpiceOptionsSetupData.COptionsFloatData[E_OPTIONS_SIM_WAIT_TIME].value;

	if(PCMXSpiceProgressDlg->DoModal() != IDOK) return;	

	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp*) AfxGetApp();

	PCSuperSpiceApp->SendXSpiceSetMsgCounts(h_msg, PCMXSpiceProgressDlg->CXSpiceProgressData);

	if(!(E_OPTIONS_SIM_WAIT_TIME < CMSuperSpiceDocData.PCAnalysisSetup->CBerklySpiceOptionsSetupData.COptionsFloatData.GetSize())) return;

	CMSuperSpiceDocData.PCAnalysisSetup->CBerklySpiceOptionsSetupData.COptionsFloatData[E_OPTIONS_SIM_WAIT_TIME].value = (float) PCMXSpiceProgressDlg->CXSpiceProgressData.simulation_wait_time;
}

bool TCSuperSpiceDoc::CreateTransientPower(void)
{
	CString CFileName;

	CFileName = GetPathName();

	CFileName = RemoveExtention(CFileName);

	CFileName = CFileName + "TransPowerReport.txt";	

	CArray <CString, CString> CRefDes;
	CArray <double, double> CPower;

	int run_count = CMSuperSpiceDocData.CWaveformDataRuns.CRuns.GetSize();
	int q, ref_count;

	if(!run_count) return false;
	if(!CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]) return false;

	CFile CDataFile;

	if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite)) return false;

	char new_line[3];
	new_line[0] = '\r';
	new_line[1] = '\n';
	new_line[2] = '\0';
	
	CString CTextLine;

	CTextLine.LoadString(IDS_FILE_MSG_TRAN_POWER);

	CTextLine = CTextLine + new_line;

	CDataFile.Write(CTextLine, CTextLine.GetLength());

	for(int p = 0; p < run_count; p++)
	{
		if(!CalculateAllTransientPowers(&CRefDes, &CPower, p)) continue;

		CTextLine = new_line;

		CTextLine += "Run name: ";

		CTextLine += CMSuperSpiceDocData.CWaveformDataRuns.CRuns[p]->CRunDiscription;

		CTextLine = CTextLine + new_line;

		CDataFile.Write(CTextLine, CTextLine.GetLength());

		ref_count = CRefDes.GetSize();

		for(q = 0; q < ref_count; q++)
		{
			CTextLine = CRefDes[q];

			CTextLine += " " + FloatToMKSString(CPower[q]);

			CTextLine += "W";

			CTextLine += new_line;

			CDataFile.Write(CTextLine, CTextLine.GetLength());
		}
	}

	CDataFile.Close();

	return true;
}

void TCSuperSpiceDoc::OnFileReportsCreateTransientPower() 
{
	if(!CreateTransientPower())  return;

	OnViewReportsTransientPower();
}

void TCSuperSpiceDoc::OnViewReportsTransientPower() 
{
	CString CFileName;

	CFileName = GetPathName();

	CFileName = RemoveExtention(CFileName);

	CFileName = CFileName + "TransPowerReport.txt";

	if(!FileExists(CFileName)) 
	if(!CreateTransientPower())
	{
		GCGeneralReportsTab.DisplayMessage(IDS_ERR_ERROR, IDS_UNABLE_TO_VIEW_TRANSIENT_POW , -1);

		return;
	}

	AfxGetApp()->OpenDocumentFile(CFileName);
}

void TCSuperSpiceDoc::OnViewReportsTransientAverages() 
{
	CString CFileName;

	CFileName = GetPathName();

	CFileName = RemoveExtention(CFileName);

	CFileName = CFileName + "TransAveragesReport.txt";

	if(!FileExists(CFileName)) 
	if(!CMSuperSpiceDocData.CWaveformDataRuns.CreateTransientAveragesReport(CFileName, CMWaveformAnalyisisData))
	{
		GCGeneralReportsTab.DisplayMessage(IDS_ERR_ERROR, IDS_UNABLE_VIEW_TRANS_AVERAGES, -1);

		return;
	}

	AfxGetApp()->OpenDocumentFile(CFileName);	
}

void TCSuperSpiceDoc::OnViewParameterlistrerunfile() 
{
	TCSuperSpiceDoc *PCDoc = GetTopLevelDoc();

	TCParametricSetupData &CParametricSetupData = PCDoc->CMSuperSpiceDocData.PCAnalysisSetup->CParametricSetupData;

	if(!FileExists(CParametricSetupData.CValue)) 
	{	
		CParametricSetupData.CValue = ReplaceFileExtension(CThisFileName, "rrn");
	}
	
	AfxGetApp()->OpenDocumentFile(CParametricSetupData.CValue);
}

void TCSuperSpiceDoc::OnViewMonteCarloReRunFile() 
{
	TCSuperSpiceDoc *PCDoc = GetTopLevelDoc();
	
	CString CFileName = RemoveExtention(PCDoc->CThisFileName);

	CFileName += "MC.rrn";

	if(!FileExists(CFileName)) 
	{
		DisplayError(IDS_EER_STATUS, IDS_UNABLE_TO_FIND_MC_FILE);

		return;
	}

	AfxGetApp()->OpenDocumentFile(CFileName);
}


void TCSuperSpiceDoc::OnFileCreateMultipleParameterSweepFile() 
{
	TCSuperSpiceDoc *PCDoc = GetTopLevelDoc();

	if(!PCDoc->CreateMultipleParameterSweeps())
	{
		DisplayError(IDS_EER_STATUS, IDS_UNABLE_TO_CREATE_RRN_FILE);

		return ;
	}

	OnViewMultiParameterSweepFile();

	return;
}

void TCSuperSpiceDoc::OnViewMultiParameterSweepFile() 
{
	TCSuperSpiceDoc *PCDoc = GetTopLevelDoc();
	
	CString CFileName = RemoveExtention(PCDoc->CThisFileName);

	CFileName += "RRN.rrn";

	if(!FileExists(CFileName)) 
	{
		DisplayError(IDS_EER_STATUS, IDS_UNABLE_TO_FIND_RR_FILE);

		return;
	}

	AfxGetApp()->OpenDocumentFile(CFileName);	
}

void TCSuperSpiceDoc::OnViewWorstCaseReRunFile() 
{
	TCSuperSpiceDoc *PCDoc = GetTopLevelDoc();
	
	CString CFileName = RemoveExtention(PCDoc->CThisFileName);

	CFileName += "WC.rrn";

	if(!FileExists(CFileName)) 
	{
		DisplayError(IDS_EER_STATUS, IDS_UNABLE_TO_FIND_WC_RERUN_FILE);

		return;
	}

	AfxGetApp()->OpenDocumentFile(CFileName);	
}

void TCSuperSpiceDoc::OnViewParameterlistgeneraterfile() 
{
	TCSuperSpiceDoc *PCDoc = GetTopLevelDoc();
	
	CString CFileName = RemoveExtention(PCDoc->CThisFileName);

	CFileName += ".rrg";

	if(!FileExists(CFileName)) 
	{
		DisplayError(IDS_EER_STATUS, IDS_UNABLE_TO_FIND_RRG_FILE);

		return;
	}

	AfxGetApp()->OpenDocumentFile(CFileName);	
}


void TCSuperSpiceDoc::OnFileReportsCreateTransientAverages() 
{
	CString CFileName;

	CFileName = GetPathName();

	CFileName = RemoveExtention(CFileName);

	CFileName = CFileName + "TransAveragesReport.txt";

	CMWaveformAnalyisisData = CMSuperSpiceDocData.PCAnalysisSetup->CReRun;

	if(!CMSuperSpiceDocData.CWaveformDataRuns.CreateTransientAveragesReport(CFileName, CMWaveformAnalyisisData))
	{
		GCGeneralReportsTab.DisplayMessage(IDS_ERR_ERROR, IDS_UNABLE_VIEW_TRANS_AVERAGES, -1);

		return;
	}

	OnViewReportsTransientAverages();

	return;
}

bool TCSuperSpiceDoc::GetGraphXRange(int waveform_type, double &max, double &min)
{
	if(!CMSuperSpiceDocData.PCAnalysisSetup->CTransientSetupData.full_scale_marching_xaxis) return true;

	//Onlt transient needs this function.

	switch(waveform_type)// 
	{
		case E_SPICE_RECORD_DC:
		{
			max = CMSuperSpiceDocData.PCAnalysisSetup->CDCSetupData.CSweepData1.stop;
			min = CMSuperSpiceDocData.PCAnalysisSetup->CDCSetupData.CSweepData1.start;

			return true;
		}

		case E_SPICE_RECORD_TRANSIENT:
		{
			max = CMSuperSpiceDocData.PCAnalysisSetup->CTransientSetupData.CSweepData.stop;
			min = CMSuperSpiceDocData.PCAnalysisSetup->CTransientSetupData.CSweepData.start;

			return true;
		}

		case E_SPICE_RECORD_AC:
		case E_SPICE_RECORD_NOISE_SPECTRAL:
		case E_SPICE_RECORD_NOISE_INTEGRATED:
		{	

			max = CMSuperSpiceDocData.PCAnalysisSetup->CACSetupData.CSweepData.stop;
			min = CMSuperSpiceDocData.PCAnalysisSetup->CACSetupData.CSweepData.start;

			return true;
		}
	
		default: return false;
	}
}

int  TCSuperSpiceDoc::GetDefaultNumberOfPoints(int waveform_type)
{
	double number_of_points = 0;

	// this aint reallly finished, but only used transient anyway

	switch(waveform_type)
	{
		case E_SPICE_RECORD_DC:
		{
			number_of_points = CMSuperSpiceDocData.PCAnalysisSetup->CDCSetupData.CSweepData1.stop -
								CMSuperSpiceDocData.PCAnalysisSetup->CDCSetupData.CSweepData1.start;

			if(CMSuperSpiceDocData.PCAnalysisSetup->CDCSetupData.CSweepData1.step)
				number_of_points /= CMSuperSpiceDocData.PCAnalysisSetup->CDCSetupData.CSweepData1.step;

			number_of_points = number_of_points;

		} break;

		case E_SPICE_RECORD_TRANSIENT:
		{
			number_of_points = CMSuperSpiceDocData.PCAnalysisSetup->CTransientSetupData.CSweepData.stop - 
								CMSuperSpiceDocData.PCAnalysisSetup->CTransientSetupData.CSweepData.start;

			if(CMSuperSpiceDocData.PCAnalysisSetup->CTransientSetupData.max_compute_step_size)
				number_of_points /= CMSuperSpiceDocData.PCAnalysisSetup->CTransientSetupData.max_compute_step_size;

			number_of_points =  number_of_points * 2;//rough guess

		} break;

		case E_SPICE_RECORD_AC:
		case E_SPICE_RECORD_NOISE_SPECTRAL:
		case E_SPICE_RECORD_NOISE_INTEGRATED:
		{	

			if(CMSuperSpiceDocData.PCAnalysisSetup->CACSetupData.CSweepData.start)

			number_of_points = CMSuperSpiceDocData.PCAnalysisSetup->CACSetupData.CSweepData.stop /
								CMSuperSpiceDocData.PCAnalysisSetup->CACSetupData.CSweepData.start;

			number_of_points = CMSuperSpiceDocData.PCAnalysisSetup->CACSetupData.CSweepData.start * Log(number_of_points);

		} break;
	}

	if(number_of_points < 0) number_of_points = - number_of_points;

	return (int) number_of_points;
}

void TCSuperSpiceDoc::UpdateMarchingWaveforms(int run_number)
{
	TCSuperSpiceView *PCViewInList = NULL;

	TCSchematicManager *PCSchematicManager;

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->m_current_waveform_type < 0) continue;

		PCSchematicManager->UpdateMarchingWaveforms(run_number);
	}
}

void TCSuperSpiceDoc::SetupMarchingWaveforms(int run_number)
{
	TCSuperSpiceView *PCViewInList = NULL;

	TCSchematicManager *PCSchematicManager;

	POSITION pos = GetFirstViewPosition();

	TCOutputWaveformData &COutputWaveformData = *CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0];

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->m_current_waveform_type < 0) continue;

		TCOutputWaveformDataHeader &CHeader = COutputWaveformData.CRecords[PCViewInList->m_current_waveform_type].CHeader;

		PCSchematicManager->SetupMarchingWaveforms(&CMSuperSpiceDocData.CWaveformDataRuns, CHeader.PCSignals, PCViewInList->m_current_waveform_type, run_number);
	}
}

void TCSuperSpiceDoc::OnRunPauseContinue() 
{
	if(m_marching_waveform_state != E_MARCHING_WAVEFORM_READING_DATA) if(!m_is_simulation_paused) return;

	if(m_is_simulation_paused) 
	{
		SendContinueCommand();

		DisplayError(IDS_EER_STATUS, IDS_SIMULATION_CONTINUED, 0);
	}
	else 
	{
		SendPauseCommand();

		DisplayError(IDS_EER_STATUS, IDS_SIMULATION_PAUSED, 0);
	}
	
	m_is_simulation_paused = !m_is_simulation_paused;
}

void TCSuperSpiceDoc::OnUpdateRunPauseContinue(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_is_simulation_paused);
}

void TCSuperSpiceDoc::OnRunEnableMarchingWaveforms() 
{
	CMSuperSpiceDocData.PCAnalysisSetup->CTransientSetupData.enable_marching_waveforms = 
	!CMSuperSpiceDocData.PCAnalysisSetup->CTransientSetupData.enable_marching_waveforms;
	
}

void TCSuperSpiceDoc::OnUpdateRunEnableMarchingWaveforms(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(CMSuperSpiceDocData.PCAnalysisSetup->CTransientSetupData.enable_marching_waveforms);	
}

void TCSuperSpiceDoc::ModifyComponentValue(CString CRefDes, float value, int type)
{
	if(!CMSuperSpiceDocData.PCAnalysisSetup->CTransientSetupData.enable_real_time_changes) return;

	if(!value) return;

	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp*) AfxGetApp();

	if(CParentRefDes != "") CRefDes += ':' + CParentRefDes;	

	CRefDes.MakeLower();

	PCSuperSpiceApp->ModifyComponentValue(h_msg, CRefDes, value, type);
}

void TCSuperSpiceDoc::ModifyComponentValue(TCSchematicObject *PCSchematicObject)
{
	if(!PCSchematicObject->CMSchematicObjectData.PCGeneratorData) return;

	TCGeneratorData &CGeneratorData = *PCSchematicObject->CMSchematicObjectData.PCGeneratorData;

	float value;
	CString CRefDes;//to do

	CRefDes = PCSchematicObject->GetLabel(E_COMPONENT_DESIGNATOR);

	switch(PCSchematicObject->CMSchematicObjectData.component_property_view_type)
	{
		case E_PROPERTY_DC_VOLTAGE_SOURCE:
		case E_PROPERTY_DC_CURRENT_SOURCE:

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CDCGeneratorData.CDCVoltage);

		ModifyComponentValue(CRefDes, value, -1); // type id is in the XSpice code

		break;

		case E_PROPERTY_SINE_VOLTAGE_SOURCE:
		case E_PROPERTY_SINE_CURRENT_SOURCE:		

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CSineGeneratorData.COffset);

		ModifyComponentValue(CRefDes, value, 0); // type id is in the XSpice code

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CSineGeneratorData.CAmplitude);

		ModifyComponentValue(CRefDes, value, 1); 

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CSineGeneratorData.CFrequency);

		ModifyComponentValue(CRefDes, value, 2);

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CSineGeneratorData.CDelay);

		ModifyComponentValue(CRefDes, value, 3);

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CSineGeneratorData.CDamping);

		ModifyComponentValue(CRefDes, value, 4);
		
		break;

		case E_PROPERTY_PULSE_VOLTAGE_SOURCE:
		case E_PROPERTY_PULSE_CURRENT_SOURCE:

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CPulseGeneratorData.CStart);

		ModifyComponentValue(CRefDes, value, 0); 

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CPulseGeneratorData.CEnd);

		ModifyComponentValue(CRefDes, value, 1); 

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CPulseGeneratorData.CDelay);

		ModifyComponentValue(CRefDes, value, 2); 

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CPulseGeneratorData.CRise);

		ModifyComponentValue(CRefDes, value, 3); 

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CPulseGeneratorData.CFall);

		ModifyComponentValue(CRefDes, value, 4); 

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CPulseGeneratorData.CWidth);

		ModifyComponentValue(CRefDes, value, 5); 

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CPulseGeneratorData.CPeriod);

		ModifyComponentValue(CRefDes, value, 6); 

		break;

		case E_PROPERTY_EXPONENTIAL_VOLTAGE_SOURCE:
		case E_PROPERTY_EXPONENTIAL_CURRENT_SOURCE:

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CExponentialGeneratorData.CStart);

		ModifyComponentValue(CRefDes, value, 0); 

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CExponentialGeneratorData.CEnd);

		ModifyComponentValue(CRefDes, value, 1);

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CExponentialGeneratorData.CDelay1);

		ModifyComponentValue(CRefDes, value, 2);

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CExponentialGeneratorData.CRiseTime1);

		ModifyComponentValue(CRefDes, value, 3);

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CExponentialGeneratorData.CDelay2);

		ModifyComponentValue(CRefDes, value, 4);

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CExponentialGeneratorData.CRiseTime2);

		ModifyComponentValue(CRefDes, value, 5);

		break;

		case E_PROPERTY_SINGLE_FREQ_VOLTAGE_FM:
		case E_PROPERTY_SINGLE_FREQ_CURRENT_FM:
		
		value = (float) CGeneratorData.CSFFMGeneratorData.offset;

		ModifyComponentValue(CRefDes, value, 0); 

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CSFFMGeneratorData.CCarrierMagnitude);

		ModifyComponentValue(CRefDes, value, 1); 

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CSFFMGeneratorData.CCarrierFrequency);

		ModifyComponentValue(CRefDes, value, 2);

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CSFFMGeneratorData.CModulationIndex);

		ModifyComponentValue(CRefDes, value, 3);

		value = (float) GetTopLevelDoc()->EvaluateComponentValue(CGeneratorData.CSFFMGeneratorData.CModulationFrequency);

		ModifyComponentValue(CRefDes, value, 4);

		break;
	}
}

void TCSuperSpiceDoc::XSRxWaveformSignal(TCRealTimeData &CRealTimeData)
{
	CRealTimeData;
}

void TCSuperSpiceDoc::DebugTest(void)
{
	TCReRuns CReRuns;

	CReRuns.LoadSetup("C:\\Program Files\\AnaSoft\\SuperSpice\\Test.rrg");
}


