// TCSuperSpiceDoc.h : interface of the TCSuperSpiceDoc class
//
/////////////////////////////////////////////////////////////////////////////
  

#ifndef _TCSUPERSPICE_DOC_H 
#define _TCSUPERSPICE_DOC_H 

#include <afxtempl.h>
#include "TESuperSpiceEnums.h"
#include "TCNumberStack.h"
#include "TCFileFunctions.h"
#include "TCBillOfMaterials.h"
#include "TCDocumentWindowsList.h"
#include "TCSchematicPageData.h"
#include "TCSchematicObject.h"
#include "TCSchematicManager.h"
#include "TCOutputWaveformData.h"
#include "TCCreateSymbolFromSchematicData.h"
#include "TCDesignerDlg.h"


class TCSearchOnSchematic;
class TCNetList;
class TCSuperSpiceServerItem;
class TCSchematicManager;
class TCSuperSpiceView;
class TCSuperSpiceTextDoc;
class TCOutputWaveformDoc;
class TCAnalysisSetup;
class TCOutputWaveformData;
class TCWaveformDataRuns;
class TCSymbolEditorDoc;
class TCSymbolEditorView;
class TCXSpiceProgressDlg;
class TCRealTimeData;
class TCReRuns;

VOID CALLBACK  OnTimer(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime);    

class TCSuperSpiceDocData : public CObject
{
	public:		TCSuperSpiceDocData();
				~TCSuperSpiceDocData();

				CString CMasterNetListFileName;
				CString CMasterIncludeFileName;
				CString CMasterOutputTextFileName;
				CString CMasterModelFileName;
				CString CMasterWorkspaceFileName;
				CString CMasterOutputDataFileName;
				CString CMasterOutputWaveform;
				CString CSymbolFileName;
				CString CMasterTextNotes;
				CString CMasterSymbolEditor;
				CString CMasterSpiceEngineLogFileName;

				CArray <int, int> CRefId;
				TCAnalysisSetup	*PCAnalysisSetup;
				TCSuperSpiceDoc	*PCDoc;

				TCWaveformDataRuns	 CWaveformDataRuns;
				// this is not directly seralised
				// file is loaded

				int m_graphic_counter;

				void Serialize(CArchive& ar);

				DECLARE_SERIAL(TCSuperSpiceDocData)

};



class TCSuperSpiceDoc : public COleServerDoc
{

private: 

		
		TCNetList *PCMNetList;

		void SetFileNames(CString CPathAndName);

		CArray <int, int> CConvertIdToRefId;
		CArray <int, int> CConvertIdToSpiceRefId;

		int CConvertViewTypeToGeneratorID(int view_type);

		void InitRefDesignators(void);

		CArray <TCSchematicManager *, TCSchematicManager *> CSchematicManagerList;
		CArray <TCSchematicManager *, TCSchematicManager *> CMUniqueSchematicManagerList;



		 WINDOWPLACEMENT sm_load_file_first_window_placment;
		 BOOL			 fm_load_file_first_window;
		 

		 TCPageId					CMPageId;

		 int						GetNewPageId(CString CPageTitle);
		 void						RemovePageId(int page_id);
		 int						GetPageIndex(int page_id);
		 void						UpdatePageIdData(TCSchematicPageData &CPageData, int page_id);
		 
		 void						InitPageList(void);
		 void						InitDocument(void);
		 TCSchematicPageData		CMSchematicPageDataDefault;
		 TCCreateSymbolFromSchematicData CMCreateSymbolFromSchematicData;
		 TCDesignerDlg CMDesignerDlg;




		 //

protected: // create from serialization only
	TCSuperSpiceDoc();
	DECLARE_DYNCREATE(TCSuperSpiceDoc)

		void InitDefaults(void);

		 void AddToSchematicManagerList(TCSchematicManager *PCSchematicManager);
		 void RemoveFromSchematicManagerList(TCSchematicManager *PCSchematicManager);
		 void DeleteSchematicManagerList(void);
		 BOOL IsLastPageInList(TCSchematicManager *PCSchematicManager);

		 TCSchematicManager *FindSchematicManager(CView *PCView);
		 void EnsureActiveViewAt0InList(void);

		 void InitaliseAnalysisSetup(void);
		 void GenerateUniqueSchematicManagers(void);

// Attributes
public:

	virtual TCSchematicManager * CreateNewSchematicManager(void);

	TCSuperSpiceServerItem* GetEmbeddedItem()
		{ return (TCSuperSpiceServerItem*)COleServerDoc::GetEmbeddedItem(); }

	CDocument *DisplayFile(CMultiDocTemplate *PCMultiDocTemplate, CDocument *CDoc, CString CFileNAme);

	void EraseComponentOutline(void);

		TCVersionInfo	CVersionInfo;
		TCWaveformAnalyisisData CMWaveformAnalyisisData;
		TCSearchOnSchematic *PCMSearchOnSchematicDlg;
		TCXSpiceProgressDlg *PCMXSpiceProgressDlg;
		TCSuperSpiceDocData	CMSuperSpiceDocData;

			 //
		 HANDLE HSpiceEngineProcess;
		 HANDLE HSpiceEngineThread;
		 DWORD  SpiceEngineProcessId; 
		 DWORD  SpiceEngineThreadId; 
		 UINT	h_msg;

		 TCSuperSpiceDoc *PCMSuperSpiceDocLastFocused;
		 TCSuperSpiceView *PCMSuperSpiceViewLastFocused;

		 HTREEITEM HProjectFileTree;

		 int	m_simulation_counter;
		 bool	m_debug_mode;

		 CArray <TCTestPointData, TCTestPointData&> CMTestPointDataList;
		 CArray <TCBillOfMaterials, TCBillOfMaterials&> CMBillOfMaterialsList;

		 TCSuperSpiceView *PCSuperSpiceViewTimer;
		 void	StartTimer(CView *PCTimerView);
		 void	StopTimer(void);

		 bool	RunSpiceEngine(CString CProgramName, CString CCommandLine);

		 void  OnSpiceEngineIsFinished(void);

		 void  OnRunRun(CView *PCView, bool renetlist = true);
		 void  OnRunRunDebugMode(CView *PCView, bool renetlist = true);

		 void  TimerCallBack(void);

		 void RenumberRefDesignators(CView *PCView);
		 void RenumberWires(CView *PCView);
		 TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewFantasticFilter(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
		TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewFilterPaste(CView *PCView, UINT nFlags, CPoint CMousePosition);
	
		bool SetFilterValues(void);

		void CreatePCBNetlist(int format);

		bool AddToProjectTree(void);
		bool AddSubCktProjectTree(CString CFileName);
		int GetNumberOfComponents();

		bool SetupWaveformAnalyisisData(void);
		void SetLoopGainSource(void);
		void ResetSetLoopGainSource(void);

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(TCSuperSpiceDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual void OnCloseDocument();
	virtual void DeleteContents();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(LPCTSTR lpszPathName);
	protected:
	virtual COleServerItem* OnGetEmbeddedItem();
	//}}AFX_VIRTUAL

// Implementation
public:

	void SyncWindowType(CDocument *PCDoc, WINDOWPLACEMENT &s_window_placment);
	void OnViewSimulationSetup();

	virtual ~TCSuperSpiceDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	void SetDefaultSymbolPath(TCCreateSymbolFromSchematicData &CCreateSymbolFromSchematicData);

	CString GetNewReferanceDesignator(int id);
	void PutBackReferanceDesignator(int id);
	void PutNewReferanceDesignatorsInClipboard(TCSchematicManager *PCDocSchematicManager);
	void PutBackReferanceDesignatorsInClipboard(void);
	CString GetNewReferanceDesignator(TCSchematicObjectData &CSchematicObjectData);

	void UpdateNets(TCSchematicManager *PCSchematicManager, bool correct_wires = true);
	void UpdateAllNets(bool correct_wires = true);
	void UpdateAllSchematics(void);
	void ChangeGraphWaveform(TCTestPointData &CTestPointData);
	void ChangeGraphBKGColour(CView *PCView);


	void ClearAllNetNames(CView *PCView);
	void ResetRefDesignatorsIDs(CView *PCView);
	void UpdateAllRefDesignators(void);
	void UpdateRefDesignators(TCSchematicManager *PCSchematicManager);

	bool GetSchematicTestPoints(CArray <TCTestPointData, TCTestPointData&> &CTestPointDataList);

	void SetupGraphWindowSize(WINDOWPLACEMENT &s_window_placment);
	void RestoreGraphWindowSize(void);
	
	unsigned short m_graph_width;
	unsigned short m_graph_hieght;
	unsigned short m_view_graph_width;
	unsigned short m_view_graph_hieght;

// multy run support
	bool	SetupParameterRuns(void);
	bool	SetupTemperatureRuns(void);
	bool	SetupNextParameterRun(void);
	bool	SetupNextTemperatureRun(void);
	bool	GenerateMCData(CString CFileName);
	bool	SetupMC(void);
	bool    GetBOMWCComponentValue(CString CRefDes, double &value);
	void    SetupWCParameterNonSweepValues(TCSelectParameter &CSelectParameter);
	CString	GetMCRunType(TCBillOfMaterials &CBillOfMaterials);
	bool	RunSpiceEngine(CView *PCView, CString COutputFileName, bool renetlist, int format);
	int		CheckAndRunNextSpiceRun(void);
	bool	SetupTempRunNames(CString CParamName);
	int		m_runs_counter;
	bool	m_renetlist;
	CView	*PCMRunsView;
	double  m_restore_temperature;
	int		m_marching_waveform_state;
	int		m_marching_display;
	bool	m_marching_waveform_enabled;
	int		m_marching_default_size;
	bool	m_marching_waiting_to_read_header;
	bool	m_marching_waiting_to_open_file;
	bool	m_marching_waiting_to_read_data;
	int		m_marching_last_data_point;
	int		m_marching_current_header_type;
	int		m_marching_xspice_header_counter;
	bool	m_is_simulation_paused;
	bool	m_marching_error;
	long	m_timer_counter;
	CArray  <int, int> CMarchingHeaderList;

	TCIFStream CMWaveformFileStream;

	void	RestoreTemp(void);
	CString  SetupWorstCase(int mode);
	CString	SetupNextWorstCase(int mode);
	bool    SetupParameterSweep(void);
	bool	SetupSweepFile(CString CRerunFileName);
	bool	SetupParameterSweepFile(void);
	bool	CreateMultipleParameterSweeps(void);
	bool	CreateParameterRerunFile(TCReRuns &CReRuns);
	void	SetupMultipleParameterSweepPointers(void);
	void	SetupAllChildMultipleParameterSweeps(CArray <TCSelectParameter, TCSelectParameter &> &CData);
	void	SetupChildMultipleParameterSweeps(CArray <TCSelectParameter, TCSelectParameter &> &CData);
	void    SetupParameterWCCorner(void);
	CString GetSchematicParameters(void);
	double  EvaluateComponentValue(CString CLable);
	void    SetParameterSweepParameter(double value); 

	CString	SetupNextParameterSweep(void);
	bool	CreateModelLines(void);
	bool	CreateAllChildModelLines(void);
	bool	CreateChildModelLines(CDocument *PCPoc, CString CFileName, CArray <CString, CString&> &CRefIDList, CString CRefDes);

	bool	CreateWCModelLines(CArray <CString, CString&> &CModelLines, TCReRun &CTopReRun);
	bool	CreateAllWCChildModelLines(CArray <CString, CString&> &CModelLines, TCReRun &CTopReRun);
	bool	CreateWCChildModelLines(CDocument *PCPoc, CString CFileName, CArray <CString, CString&> &CRefIDList, CString CRefDes, CArray <CString, CString&> &CModelLines, TCReRun &CTopReRun);
	void	GetWCRLCModelLines(CArray <CString, CString&> &CModelLines);

	void ChangeWaveformColour(CView *PCView);
	void ClearAllWaveforms(CView *PCView);
	void ClearAllWaveforms(void);
	bool IsGraphicsModified(void);
	void SetGraphicsModified(bool value);
	void OnEditFindOnSchematic(CView *PCView);

	bool GetLoopGainNodes(CString CVSourceSource, CString &CInputNode, CString &COutputNode, int ac_analysis_type);
	void DisplayGainAndPhaseMargins(CString CTitle);
	void DisplayTransientFrequency(CString CTitle);
	void DisplayTransientAverages(CString CTitle, int run = 0);
	void DisplayMinGainAndPhaseMargins(TCGainPhaseMargin &CGainPhaseMargin);

	void DisplayTransientPulseAnalysis(CString CTitle, int run = 0);
	void ModifyComponentValue(CString CRefDes, float value, int type = 0);
	void ModifyComponentValue(TCSchematicObject *PCSchematicObject);
	void XSRxWaveformSignal(TCRealTimeData &CRealTimeData);

	void DebugTest(void);

// multy run support

	TCAnalysisSetup	&GetAnalysisSetup(void);

	CString CThisFileName;

// Start hirerachical support
	TCDocumentWindowsList	CDocumentWindowsList;
	bool					top_level;
	CString					CParentFileName;
	TCSuperSpiceDoc			*PCParentSuperSpiceDoc;
	CArray <CString, CString&>	CParentRefIDList;
	CString					CParentRefDes;
	bool					SetParent(TCSuperSpiceDoc *PCSuperSpiceDoc, CString CFileName, CArray <CString, CString&> &CRefIDList, CString CRefDes);
	void					RegenerateSchematicDocumentsWindowList(bool auto_delete);
	bool					CreateNetlist(int format, CArray <CString, CString>  &CPinList);
	bool					CreateAllChildNetlists(int format);
	bool					CreateChildNetlist(CDocument *PCPoc, CString CFileName, CArray <CString, CString&> &CRefIDList, CString CRefDes, int format, CArray <CString, CString>  &CPinList);
	TCSuperSpiceDoc			*GetTopLevelDoc(void);
	TCSuperSpiceDoc			*OpenChildSchematic(TCDocumentWindowsListData CDocumentWindowsListData, bool visable);
	void					UpdateChildSchematicRefDesignator(CString CFileName, CString CNewRefDes);
	void					CreateRefDesList(CArray <CString, CString&> &CNewRefIdList, CString CRefID);
	CString					GetNewRefDes(CString CRefDes);
	void					GetRefDesList(CArray <CString, CString&> &CRefDesList, CString CRefID);
	void					SyncAnalysisSetup(TCSuperSpiceDoc *PCChildDoc);
	void					UpdateChildSchematicWaveforms(void);
	void					GetRefDesList(CArray <CString, CString&> &CRefDesList);
	CString					GetRelativeFileName(CString CFileName);

	// End hirerachical support

	friend class TCSuperSpiceTextView;
	friend class TCOutputWaveformView;
	friend class TCOutputWaveformDoc;
	friend class TCSuperSpiceView;
	friend class TCSymbolEditorView;
	friend class TCSymbolEditorDoc;
	friend class TCOutputWaveformData;

	CString SaveAsSchematicDlg(CString CText);
	void	OnViewInitialUpdate(CView *PCView);
	void DisplayError(CString CDescription, CString CErrorMsg, int error_code = -1);
	void DisplayError(UINT id, CString CErrorMsg, int error_code = -1);
	void DisplayError(CString CDescription, UINT id, int error_code);
	void DisplayError(UINT id1, UINT id2, int error_code = -1);

	void ClearError(void);

	void OnViewDrawAll(CView *PCView, TCSchematicManager *PCSchematicManager);
	void Print(CView *PCView, CDC *PCDC);

	CView  *OnViewNewPage(CView *PCView);
	CView  *OnViewOpenPage(CView *PCView,  TCSchematicManager *PCSchematicManager);	
	CView  *OnViewNewView(CView *PCView);
	CView  *OpenPage(TCSchematicManager *PCSchematicManager);
	void  OnViewPropertyAccelerater(CView *PCView);
	TCOutputWaveformDoc *OnViewNewGraph(CView *PCView);

	void	SetTemperature(double data);
	double  GetTemperature(void);

	bool GetSubCktPinData(TCCreateSymbolFromSchematicData &CCreateSymbolFromSchematicData);
	void ReIDSubCktPins(TCCreateSymbolFromSchematicData &CCreateSymbolFromSchematicData);

	void OnViewDisplayOutputGraph(CView *PCView);
	void OnViewDisplayOutputText(CView *PCView);
	void OnViewDisplayModelsText(CView *PCView);
	void OnViewDisplayInputText(CView *PCView);
	void OnViewDisplayPCBNetlist(CView *PCView);
	void OnViewDisplaySubcktNetlist(CView *PCView);

	CView *GetTopLevelSchematicView(void);
	bool GetWaveformFileType(void);

	bool AddSymbolEditorDoc(CDocument *PCDoc, CString CFileName);
	bool AddGraphOutputDoc(CDocument *PCDoc, CString CFileName);
	bool AddModelLibaryDoc(CDocument *PCDoc, CString CFileName);

	TCSuperSpiceTextDoc  * OnViewDisplayIncludeText(CView *PCView);
	TCSuperSpiceTextDoc  * OnViewDisplayDesignNotes(CView *PCView);
	TCSuperSpiceTextDoc  * OnViewDisplaySpiceErrorLog(CView *PCView);

	TCSymbolEditorDoc  * OnViewDisplaySymbolEditor(CView *PCView);
	void OnViewDisplaySchematic(CView *PCView);
	TCSuperSpiceTextDoc  *DisplayTextBasedDocument(CString CFileName);
	TCSymbolEditorDoc  *DisplaySymbolEditorDocument(CString CFileName, CString CSymbolFileName = "", CString CSymbolName = "");
	TCOutputWaveformDoc *DisplayOutputGraphics(CString CFileName);
	TCSuperSpiceDoc* DisplayChildSchematicDocument(CString CFileName, CString CRefID);


	int GetSubCktList(CString CFileName, CArray <TCSchematicObject*, TCSchematicObject*> &CSchematicObjectList);
	bool GetSubCktPinWires(TCSchematicObject *PCSchematicObject, CArray <CString, CString>  &CPinList);
	CString GetSubCktRefDes(TCSchematicObject *PCSchematicObject, CString CBaseRefDes);

	void RestorePinHierarchyNames(void);

	int GetNumberOfSubCktConnectors(void);
	CString GetNewSubcktID(void);
	bool IsSubCktIDValid(CString CID);
	void SetSubCktID(TCSchematicManager *PCSchematicManager, TCSchematicObject *PCSchematicObject, CString CID);
	void GetAndSetSubCktID(TCSchematicManager *PCSchematicManager, CString CRefDes);
	void GetAndSetSubCktID(TCSchematicManager *PCSchematicManager, TCSchematicObject *PCSchematicObject);
	void SetAllSubCktIDs(void);
	void DisplayModelLibary(CView *PCView);
	int SetSymbolPinName(int pin_id, CString CText);
	int SetAllSymbolsPinName(CString CSymbolFileName, CString CSymbolName, int pin_id, CString CText);
	void SetSchematicPinNames(TCSchematicObject *PCSchematicObject);
	TCSchematicObject *FindSchematicObject(CString CRefDes, TCSchematicManager **PCSchematicManagerFound = NULL);


	TCSuperSpiceDoc *CreateNewChildSchematicDocument(CString CFileName);
	bool CreateChildSchematicPins(TCSchematicObjectData &CSchematicObjectData);
	bool LoadWorkspace(void);
	bool SaveWorkspace(void);
	bool CreateOutputWaveformFile(CString CName);
	bool CreateSymbolEditorFile(CString CName);
	void SaveLastState(void);
	void DisplayFile(void);
	void DeleteOldFiles(int old_number_of_runs);
	bool LoadAndUpdateWaveforms(void);
	TCOutputWaveformData *GetOutputWaveformData();
	bool CopySymbolsSchematicsToNewDir(CString CPath);
	bool ChangeSymbolsSchematicsDir(CString CPath);

	void OnViewShowNetNames(CView *PCView, int show);
	void OnViewShowDcVoltages(CView *PCView, int show);
	void OnViewShowDcCurrents(CView *PCView, int show);	
	void ClearPinCurrentsAndVoltages(void);

	void OnViewDecendSchematic(CView *PCView, CPoint CMousePosition, UINT mouse_flags); 
	void OnViewAccendSchematic(CView *PCView); 

	void OnViewZoomIn(CView *PCView);
	bool OnViewCheckZoomIn(CView *PCView);
	void OnViewZoomOut(CView *PCView);
	bool OnViewCheckZoomOut(CView *PCView);
	void OnViewZoomCenter(CView *PCView, CPoint CMousePosition);
	void OnViewSetZoomCenter(CView *PCView, CPoint CMousePosition);

	void OnViewRotate(CView *PCView);
	void OnViewMirror(CView *PCView);
	void OnViewFlip(CView *PCView);
	void OnViewUndelete(CView *PCView);

	void OnViewDisplayPoleZeroText(CView *PCView);
	void OnViewDisplaySensitivityText(CView *PCView);

	void UpdateMarchingWaveforms(int run_number);
	void MarchingWaveformOverides(void);
	void SetupMarchingWaveforms(int run_number);
	bool ProcessMarchingWaveforms(int state);
	bool GetGraphXRange(int waveform_type, double &max, double &min);
	int  GetDefaultNumberOfPoints(int waveform_type);

	bool MarchingWaveformStart(int state);
	bool MarchingWaveformOpeningFile(int state);
	bool MarchingWaveformReadingHeader(int state);
	bool MarchingWaveformReadingData(int state);
	bool MarchingWaveformEnd(int state);
	void MarchingWaveformReset(void);
	void MarchingWaveformFinalRead(void);
	void MarchingWaveformAddHeader(int header);
	int  MarchingWaveformGetHeader(void);
	void SendContinueCommand(void);
	void SendPauseCommand(void);

	void CopySchematicDataToSameSelected(TCSchematicObjectData &CSchematicObjectData);
	TCOutputWaveformDoc *OpenAndUpdateAllWaveformGraphs(void);

	void	OnViewDeletePage(CView *PCView, TCSchematicManager *PCSchematicManager);
	void	OnViewCopyPage(CView *PCView);
	void	SetWindowTitle(CMDIChildWnd *PCChildWnd);
	void    OnViewDestroyWindow(CView *PCView, TCSchematicManager *PCSchematicManager);
	void	OnViewProperties(CView *PCView, TCSchematicManager *PCSchematicManager);

	void	OnLButtonDblClk(CView *PCView, CPoint CMousePosition, UINT mouse_flags);
	void	DecendIntoSchematic(TCSchematicManager *PCSchematicManager, CView *PCView,TCSchematicComponentInfo &CSchematicComponentInfo);

	void	InspectSchematicObject(TCSchematicManager *PCSchematicManager, CView *PCView,TCSchematicComponentInfo &CSchematicComponentInfo);
	void	InspectWaveformObject(TCSchematicManager *PCSchematicManager, CView *PCView,TCSchematicComponentInfo &CSchematicComponentInfo);
	void	InspectSchematicWireObject(TCSchematicManager *PCSchematicManager, CView *PCView,TCSchematicComponentInfo &CSchematicComponentInfo);
	void	InspectSchematicPinObject(TCSchematicManager *PCSchematicManager, CView *PCView,TCSchematicComponentInfo &CSchematicComponentInfo);
	void	InspectSchematicLabelObject(TCSchematicManager *PCSchematicManager, CView *PCView,TCSchematicComponentInfo &CSchematicComponentInfo);
	void	InspectSchematicPinLabelObject(TCSchematicManager *PCSchematicManager, CView *PCView,TCSchematicComponentInfo &CSchematicComponentInfo);
	void	InspectSchematicTextLableObject(TCSchematicManager *PCSchematicManager, CView *PCView,TCSchematicComponentInfo &CSchematicComponentInfo);
	void	InspectSchematicWaveformLabelObject(TCSchematicManager *PCSchematicManager, CView *PCView,TCSchematicComponentInfo &CSchematicComponentInfo);

	void OnNotifyDocumentClosed(CDocument *PCDoc);
	bool DisplayComponentLibaryDlg(TCSchematicObjectData &CSchematicObjectData);
	bool ValidateComponent(CString CName);

	bool CalculateAllTransientPowers(CArray <CString, CString> *PCRefDes = NULL, CArray <double, double> *PCPower = NULL, int run_number = 0);
	bool CalculateTransientPower(CString CRefDes, TCWaveformAnalyisisData &CWaveformAnalyisisData, int index);
	bool CalculateTransientAverages(TCWaveformAnalyisisData &CWaveformAnalyisisData, int index);
	void UpdateDesignerValues(void);

	void OnFileReportsDcoperatingpoint(void);
	void OnViewReportsDcoperatingpoint(void);
	void OnFileReportsDcsweep(void);
	void OnViewReportsDcsweep(void);
	void OnFileReportsAcsweep(void);
	void OnViewReportsAcsweep(void);
	void OnFileReportsNoise(void);
	void OnViewReportsNoise(void);
	
	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditCancel(CView *PCView); 
	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditCut(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditPaste(CView *PCView, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditDelete(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditCopy(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditToWindowsClipboard(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditSelectAll(CView *PCView);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewIdleOnCancel(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsSelectedOnCancel(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsMovingOnCancel(CView *PCView);	
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSelectRegionOnCancel(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotGraphicOnCancel(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotClipboardOnCancel(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewDrawingWireOnCancel(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewWaitingToDrawWireOnCancel(CView *PCView);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewIdleStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type = 0, short version = 0);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsSelectedStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type = 0, short version = 0);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsMovingStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type = 0, short version = 0);	
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSelectRegionStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type = 0, short version = 0);		 
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotGraphicStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type = 0, short version = 0);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotClipboardGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type = 0, short version = 0);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewDrawingWireGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type = 0, short version = 0);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewWaitingToDrawWireGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type = 0, short version = 0);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewIdleDrawWire(CView *PCView, int page_id, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsSelectedDrawWire(CView *PCView, int page_id, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsMovingDrawWire(CView *PCView, int page_id, CPoint CMousePosition);	
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSelectRegionDrawWire(CView *PCView, int page_id, CPoint CMousePosition);		 
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotGraphicDrawWire(CView *PCView, int page_id, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotClipboardDrawWire(CView *PCView, int page_id, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewDrawingWireDrawWire(CView *PCView, int page_id, CPoint CMousePosition);



	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewIdleStateLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsSelectedStateLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsMovingStateLBDown(CView *PCView,  int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSelectRegionStateLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotGraphicStateLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotClipboardLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewDrawingWireLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewWaitingToDrawWireLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSizingWaveformWindowLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);

	
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewIdleStateLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsSelectedStateLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsMovingStateLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSelectRegionStateLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotGraphicStateLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotClipboardLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewDrawingWireLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewWaitingToDrawWireLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSizingWaveformWindowLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewIdleStateMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsSelectedStateMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsMovingStateMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSelectRegionStateMouseMoved(CView *PCView,int page_id,  UINT nFlags, CPoint CMousePosition);	
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotGraphicStateMouseMoved(CView *PCView,  int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotClipboardMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewDrawingWireMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewWaitingToDrawWireMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSizingWaveformWindowMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewDrawingWireLBDblClk(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewWaveformOnClickLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);

	void PlaceSymbolFromSymbol(CView *PCView, int symbol_file_index, int symbol_index, int graphic_type);

	friend class TCSuperSpiceTextDoc;

	void RefreshWorkSpaceWindow(void);

	void OnRunStop(void); 
	void OnRunExitEngine(void);

	void DoOutputProcessing(void);

	bool CreateTransientPower(void);
	void CalculateAverageFrequency(TCWaveformAnalyisisData &CWaveformAnalyisisData);
	int ComponentsCreateSymbolFromSchematic(void);
	int FileCreateSubcktModelFromSchematic(void);

// Generated message map functions

	//{{AFX_MSG(TCSuperSpiceDoc)
	afx_msg void OnRunCreateNetlist();
	afx_msg void OnUpdateRunRun(CCmdUI* pCmdUI);
	afx_msg void OnOptionsProgram();
	afx_msg void OnViewSchematic();
	afx_msg void OnViewSchematicFiles();
	afx_msg void OnRunQuit();
	afx_msg void OnViewTopLevelFiles();
	afx_msg void OnSetupSetTemperature();
	afx_msg void OnFileLoadSpiceDataFile();
	afx_msg void OnFileLoadaclipboard();
	afx_msg void OnFileSavecurrentclipboard();
	afx_msg void OnSetupsDisplayStartMessage();
	afx_msg void OnFileNewTextFile();
	afx_msg void OnComponentsCreateSymbolFromSchematic();
	afx_msg void OnComponentsCreateSymbolForModel();
	afx_msg void OnFileCreateSubcktModelFromSchematic();
	afx_msg void OnFileCreateModelandSymbolFromSchematic();
	afx_msg void OnFileSaveastextdatafiles();
	afx_msg void OnViewAnalysisLoopGain();
	afx_msg void OnViewAnalysisTransientFrequency();
	afx_msg void OnViewAnalysisSetup();
	afx_msg void OnViewAnalysisresultsTransientPulse();
	afx_msg void OnViewReportsPulseAnalysis();
	afx_msg void OnSetupsXSpiceProgressRate();
	afx_msg void OnFileReportsCreateTransientPower();
	afx_msg void OnViewReportsTransientPower();
	afx_msg void OnComponentsFindModel();
	afx_msg void OnViewAnalysisresultsTransientAverages();
	afx_msg void OnFileReportsCreateTransientAverages();
	afx_msg void OnViewReportsTransientAverages();
	afx_msg void OnFileReportsPulseAnalysis();
	afx_msg void OnRunPauseContinue();
	afx_msg void OnUpdateRunPauseContinue(CCmdUI* pCmdUI);
	afx_msg void OnRunEnableMarchingWaveforms();
	afx_msg void OnUpdateRunEnableMarchingWaveforms(CCmdUI* pCmdUI);
	afx_msg void OnRunRunasOperatingPointDesigner();
	afx_msg void OnSetupsDesignerSetup();
	afx_msg void OnViewParameterlistrerunfile();
	afx_msg void OnViewMonteCarloReRunFile();
	afx_msg void OnViewParameterlistgeneraterfile();
	afx_msg void OnViewMultiParameterSweepFile();
	afx_msg void OnFileCreateMultipleParameterSweepFile();
	afx_msg void OnViewWorstCaseReRunFile();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

	// Generated OLE dispatch map functions
	//{{AFX_DISPATCH(TCSuperSpiceDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_DISPATCH
	DECLARE_DISPATCH_MAP()
	DECLARE_INTERFACE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
#endif
