
#include "stdafx.h"
#include "math.h"
#include "TESuperSpiceEnums.h"
#include "TESuperSpiceOpionsEnums.h"
#include "TCTestPointData.h"
#include "TCSuperSpiceGlobalData.h"
#include "TDVersion.h"
#include "TCFileFunctions.h"
#include "TCFloatingCursorDlg.h"
#include "TCFantasticFilter.h"
#include "TCElectronicFormulars.h"
#include "TCOutputWaveformData.h"
#include "TCSuperSpiceDataBase.h"
#include "TEAnalysisExtra.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern bool SaveGenericToArchive(CObject *, CString);
extern bool LoadGenericFromArchive(CObject *, CString);
extern void SetMKSNumDigits(int num_digits);
extern int QuantiseLogScale(double &max, double &min);
int QuantiseLog2Scale(double &max, double &min);
double Log(double value);
double Log2(double value);
extern CString FloatToMKSString(double);
extern int CountWords(CString CText);

void ClearAllVars(void);
int EquationSetVaribles(CString CNameEqualsValueList);
int EquationSetVarible(CString CName, CString CValue);
int Equation(CString CExpression, CString CValues, double *data_result);
int Equation(CString CExpression, double *data_result);
double SpiceMKSStringToFloat(CString &CTextData);

extern TCSuperSpiceGlobalData GCSuperSpiceGlobalData;
extern TCSuperSpiceDataBase GCSuperSpiceDataBase; // Global
extern TCElectronicFormulars GCElectronicFormulars;
extern TCFantasticFilter GCFantasticFilter;

bool GetPrinterDC(CDC &CPrinterDC);

// These globals are to avoid this class's header file to be included fucking everwhere !!!
int	g_last_active_schematic_page = 0;
int	g_last_active_program_options_page = 0;
int	g_last_active_simulation_setup_page = 0;
int	g_last_active_component_property_page = 0;
int	g_last_active_generator_property_page = 0;
int	g_last_active_symbol_model_property_page = 0;
int	g_last_active_waveform_property_page = 2;//signals page
int	g_last_active_fantastic_filter_property_page = 0;
int	g_last_active_signal_analysis_property_page = 0;
int g_last_open_file_tree_tab = 0;
int	g_show_all_net_names = false;
int	g_show_all_dc_volts = false;
int	g_show_all_dc_currents = false;
CString GLastFileTreeSymbolFile;
CString GLastFileTreeSymbol;
CString GLastFileTreeModelFile;
CString GLastFileTreeModel;
CString GLastFileTreeFilesFile;
CString GLastFileTreeFiles;


enum E_CLASS_VERSION_NUMBERS
{
	E_TRANSIENT_SETUP_DATA_VER_2 = 1,// added 20th July for UIC bug
	E_SWEEP_VERSION_ORIGINAL	= 0, //added to support multiple parameters.
	E_SWEEP_VERSION_2 = 2,
	E_SELECTPARAMETERS_VERSION_ORIGINAL	= 1,
	E_SELECTPARAMETERS_VERSION_2	= 2,
	
};

IMPLEMENT_SERIAL(TCSuperSpiceGlobalData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSuperSpiceDrawData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSuperSpiceColorData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSuperSpiceGeneric, CObject, ID_VERSION_NUMBER + 1)
IMPLEMENT_SERIAL(TCSuperSpiceConfigData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSuperSpiceFontData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCAnalysisSetup, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCACSetupData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCDCSetupData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCTransientSetupData, CObject, ID_VERSION_NUMBER + E_TRANSIENT_SETUP_DATA_VER_2)
IMPLEMENT_SERIAL(TCParametricSetupData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCStatisticsSetupData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSensitivitySetupData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCTemperatureSetupData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCBerklySpiceOptionsSetupData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCNoiseSetupData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCPoleZeroData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCDistortionData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSpiceOptionsData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSweepData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSpiceNodeList, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCOutput, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCProgramOptions, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCProgramOptionsErrors, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCProgramOptionsGeneral, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSelectParameter, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCOutputSelectData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSpiceEngineOptions, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCReRun, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCPrinterData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCWaveformData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCWorstCaseData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCReserved, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCVersionInfo, CObject, ID_VERSION_NUMBER)


/////////////////////////////////////////
TCVersionInfo::TCVersionInfo(void)
{
	CLoadMajor	= "1";
	CSaveMajor	= "1";
	CMinor	= "0";
	CMicro  = "0";
	CDateAndTime;

	CReserved;
}

TCVersionInfo::TCVersionInfo(TCVersionInfo &CVersionInfo)
{
	*this = CVersionInfo;
}
TCVersionInfo::~TCVersionInfo(void)
{

}

void TCVersionInfo::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);
	CReserved.Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CSaveMajor;
		CArchiveFile << CMinor;
		CArchiveFile << CMicro;
		CArchiveFile << CDateAndTime;
	}
	else
	{
		CArchiveFile >> CLoadMajor;
		CArchiveFile >> CMinor;
		CArchiveFile >> CMicro;
		CArchiveFile >> CDateAndTime;
	}
}

CString TCVersionInfo::GetVersionString(void)
{
	CString CText;

	CText = CLoadMajor + '.';
	CText += CMinor + '.';
	CText += CMicro;

	return CText;
}

void TCVersionInfo::operator = (TCVersionInfo &CVersionInfo)
{
	CSaveMajor		= CVersionInfo.CSaveMajor;
	CLoadMajor		= CVersionInfo.CLoadMajor;
	CMinor			= CVersionInfo.CMinor;
	CMicro			= CVersionInfo.CMicro;
	CDateAndTime	= CVersionInfo.CDateAndTime;

	CReserved		= CVersionInfo.CReserved;
}

bool TCVersionInfo::operator == (TCVersionInfo &CVersionInfo)
{CVersionInfo;
//	return !(*this == CVersionInfo);

return true;
}

bool TCVersionInfo::operator != (TCVersionInfo &CVersionInfo)
{
	if(CLoadMajor != CVersionInfo.CLoadMajor) return false;// only compare major version id
	
	CMinor;
	CMicro;
	CDateAndTime;
	CReserved;

	return true;
}
/////////////////////////////////////////////////////////////////

TCReserved::TCReserved(void)
{

}

TCReserved::TCReserved(TCReserved &CReserved)
{
	*this = CReserved;
}
TCReserved::~TCReserved(void)
{

}

void TCReserved::Serialize(CArchive& CArchiveFile)
{
	int p, count, size;

	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		count = CIntArray.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CArchiveFile << CIntArray[p];

		count = CStringArray.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CArchiveFile << CStringArray[p];
	}
	else
	{
		CArchiveFile >> count;

		size = CIntArray.GetSize();

		if(count > size)// keep compatible with prior versions
			CIntArray.SetSize(count);

		for(p = 0; p < count; p++) CArchiveFile >> CIntArray[p];

		CArchiveFile >> count;

		size = CStringArray.GetSize();

		if(count > size)// keep compatible with prior versions
			CStringArray.SetSize(count);

		for(p = 0; p < count; p++) CArchiveFile >> CStringArray[p];
	}
}

void TCReserved::operator = (TCReserved &CReserved)
{
	int p, count;

	count = CReserved.CIntArray.GetSize();
	
	CIntArray.SetSize(count);

	for(p = 0; p < count; p++) CIntArray[p] = CReserved.CIntArray[p];

	count = CReserved.CStringArray.GetSize();
	
	CStringArray.SetSize(count);

	for(p = 0; p < count; p++) CStringArray[p] = CReserved.CStringArray[p];

}
/////////////////////////////////////////////////////////////////////
TCWorstCaseData::TCWorstCaseData(void)
{
	SelectAllNominal();

	CStrength.SetSize(3);
}

TCWorstCaseData::TCWorstCaseData(TCWorstCaseData &CWorstCaseData)
{
	*this = CWorstCaseData;
}
TCWorstCaseData::~TCWorstCaseData(void)
{

}

void TCWorstCaseData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);
	CReserved.Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << strong;
		CArchiveFile << nominal;
		CArchiveFile << weak;
		CArchiveFile << CName;
	}
	else
	{
		CArchiveFile >> strong;
		CArchiveFile >> nominal;
		CArchiveFile >> weak;
		CArchiveFile >> CName;
	}
}

void TCWorstCaseData::operator = (TCWorstCaseData &CWorstCaseData)
{
	CWorstCaseData;

	strong	= CWorstCaseData.strong;
	nominal = CWorstCaseData.nominal;
	weak	= CWorstCaseData.weak;
	CName	= CWorstCaseData.CName;

	CReserved = CWorstCaseData.CReserved;
}

void TCWorstCaseData::SelectAll(void)
{
	strong	= true;
	nominal = true;
	weak	= true;
}

void TCWorstCaseData::ClearAll(void)
{
	strong	= false;
	nominal = false;
	weak	= false;
}

void TCWorstCaseData::SelectAllNominal(void)
{
	strong	= false;
	nominal = true;
	weak	= false;
}

void TCWorstCaseData::SelectMaxMin(void)
{
	strong	= true;
	nominal = false;
	weak	= true;
}

void TCWorstCaseData::SelectMax(void)
{
	strong	= true;
	nominal = false;
	weak	= false;
}

void TCWorstCaseData::SelectMin(void)
{
	strong	= false;
	nominal = false;
	weak	= true;
}

int  TCWorstCaseData::CalculateNumberOfReRuns(void)
{
	return weak + nominal + strong;
}

void TCWorstCaseData::SetStrength(void)
{
	int count = CStrength.GetSize();// musr be 3! strong, nominal, weak

	if(count != 3) return;

	if(strong) CStrength[0] = true;
	else CStrength[0] = false;

	if(nominal) CStrength[1] = true;
	else CStrength[1] = false;

	if(weak) CStrength[2] = true;
	else CStrength[2] = false;
}

///////////////////////////////////////////////////////
TCWaveformData::TCWaveformData(void)
{
	display_graph_floating_cursor	= false;
	is_placement_valid				= false;

	PCFloatingCursorDlg				= NULL;
	num_digits_displayed			= 6;
	resolution						= 4;
	auto_axis						= true;
	enable_quantisation				= true;
}

TCWaveformData::TCWaveformData(TCWaveformData &CWaveformData)
{
	*this = CWaveformData;
}

TCWaveformData::~TCWaveformData(void)
{
	if(PCFloatingCursorDlg) 
	{
		PCFloatingCursorDlg->DestroyWindow();

		delete PCFloatingCursorDlg;
	}
}

void TCWaveformData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);
	CReserved.Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << display_graph_floating_cursor;
		CArchiveFile << is_placement_valid;
		CArchiveFile << num_digits_displayed;
		CArchiveFile << resolution;
		CArchiveFile << auto_axis;
		CArchiveFile << enable_quantisation;

		CArchiveFile.Write(&s_window_placment, sizeof(s_window_placment));
	}
	else
	{
		CArchiveFile >> display_graph_floating_cursor;
		CArchiveFile >> is_placement_valid;
		CArchiveFile >> num_digits_displayed;
		CArchiveFile >> resolution;
		CArchiveFile >> auto_axis;
		CArchiveFile >> enable_quantisation;

		CArchiveFile.Read(&s_window_placment, sizeof(s_window_placment));

		SetMKSNumDigits(num_digits_displayed);
	}
}

void TCWaveformData::operator = (TCWaveformData &CWaveformData)
{
	display_graph_floating_cursor		= CWaveformData.display_graph_floating_cursor;
	
	s_window_placment	= CWaveformData.s_window_placment;
	is_placement_valid	= CWaveformData.is_placement_valid;
	num_digits_displayed= CWaveformData.num_digits_displayed;
	resolution			= CWaveformData.resolution;
	auto_axis 			= CWaveformData.auto_axis;
	CReserved			= CWaveformData.CReserved;
	enable_quantisation = CWaveformData.enable_quantisation;
}


//////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
TCPrinterData::TCPrinterData(void)
{
	resolution	= 360;
	page_margin	= 16;
	magnification = (float)1.0;
}

TCPrinterData::TCPrinterData(TCPrinterData &CPrinterData)
{
	*this = CPrinterData;
}
TCPrinterData::~TCPrinterData(void)
{

}

void TCPrinterData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);
	CReserved.Serialize(CArchiveFile);;

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << resolution;
		CArchiveFile << page_margin;
		CArchiveFile << magnification;
		CArchiveFile << CPrinterPageOutline;

	}
	else
	{
		CArchiveFile >> resolution;
		CArchiveFile >> page_margin;
		CArchiveFile >> magnification;
		CArchiveFile >> CPrinterPageOutline;
	}
}
void TCPrinterData::operator = (TCPrinterData &CPrinterData)
{
	resolution			= CPrinterData.resolution;
	CPrinterPageOutline	= CPrinterData.CPrinterPageOutline;
	page_margin			= CPrinterData.page_margin;
	magnification		= CPrinterData.magnification;
	CReserved			= CPrinterData.CReserved;
}

void TCPrinterData::SetPrinterPageData(void)
{
	CPrinterPageOutline = GetPrinterPageSize();
	
	int margin = GCSuperSpiceGlobalData.CPrinterData.page_margin;

	CPrinterPageOutline.top		+= margin;
	CPrinterPageOutline.right	-= margin;
	CPrinterPageOutline.bottom	-= margin;
	CPrinterPageOutline.left	+= margin;

	resolution;
}

CRect TCPrinterData::GetPrinterPageSize(void)
{
	CDC CPrinterDC;

	CRect CPageSize(0, 0, 2000, 1600);// set a reasonable default

	if(GetPrinterDC(CPrinterDC))
	{
		CPrinterDC.GetClipBox(&CPageSize);

		CPrinterDC.DeleteDC();
	}
	return CPageSize;
}
float TCPrinterData::GetPrinterZoom(void)
{
	CRect CPageSize = GetPrinterPageSize();

	float zoom;// this is temp

	float x = (float) CPageSize.right;

	zoom = x / 3719 + (float)0.5;

	if(zoom <= 2) 
	{
		zoom = 1;
		
		return zoom;
	}

	if(zoom <= 4) 
	{
		zoom = 2;
		
		return zoom;
	}

	if(zoom <= 8) zoom = 8;//quick and nasty to set power of two fix later

	zoom = 8;

	return (float) zoom;
}
///////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
TCReRun::TCReRun(void)
{
	Setup();
}

void TCReRun::Setup(void)
{
	enable	= false;

	CWorstCase.SetSize(E_WORST_CASE_COMPONENTS_SIZE);

	CWorstCase[E_WORST_CASE_NPN].CName = "N";
	CWorstCase[E_WORST_CASE_PNP].CName = "P";
	CWorstCase[E_WORST_CASE_NMOS].CName = "nM";//more unique
	CWorstCase[E_WORST_CASE_PMOS].CName = "pM";
	CWorstCase[E_WORST_CASE_QR].CName = "QRC";
	CWorstCase[E_WORST_CASE_RLC].CName = "RLC";
	CWorstCase[E_WORST_CASE_SUB].CName = "X";		
	CWorstCase[E_WORST_CASE_GENERATOR].CName = "G";
	CWorstCase[E_WORST_CASE_TEMP].CName = "T";
	CWorstCase[E_WORST_CASE_SUB].CName = "X";

	CWorstCase[E_WORST_CASE_NPN].CTypeName = "NPN";
	CWorstCase[E_WORST_CASE_PNP].CTypeName = "PNP";
	CWorstCase[E_WORST_CASE_NMOS].CTypeName = "NMOS";
	CWorstCase[E_WORST_CASE_PMOS].CTypeName = "PMOS";
	CWorstCase[E_WORST_CASE_RLC].CTypeName = "RLC";   // Added 20th May 2016 fix for MC in resistor models

	temp_nominal	= 27.0;
	temp_min		= -40.0;
	temp_max		= 125;
	capacitor_tol	= 5.0;
	inductor_tol	= 5.0;
	resistor_tol	= 5.0;
	distribution	= 0; // uniform

	qrc_max = 100;				// future expansion, may add asymetric tolerances
	qrc_min = 1;
	qrc_nom = 10;

	number_of_wc_runs = 8.0;
	xspice_run_mode = 1.0;
	generator_tol = 5.0;
	xspice_param_run_mode = 1;

	CRunType.SetSize(E_NUMBER_OF_BASIC_SPICE_TYPES_VER1);

	int count = CRunType.GetSize();

	for(int p = 0; p < count; p++) CRunType[p] = "";

	CReserved.CStringArray.SetSize(E_ANALYSIS_RESERVED_STRINGS_MAX);// added feature 26th jan 2003

	CReserved.CIntArray.SetSize(E_ANALYSIS_RESERVED_MAX);// added feature 26th jan 2003

	CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] = 0;
	CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_ZERO_PHASE] = -180.0;

	CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_IMPEDANCE] = 0;
	CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_POWER] = 0;

	CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_FREQ_ENABLE] = 0.0;
	CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_AVERAGE_FREQ] = 0.0;
	CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_POLARITY] = 1.0;
	CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_FIRST_COUNT] = 1;
	CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_LAST_COUNT] = 2;
	CReserved.CIntArray[E_TRAN_ANALYSIS_RESERVED_XING_LEVEL] = 0.0;

	CReserved.CIntArray[E_TRAN_POWER_START] = 0;
	CReserved.CIntArray[E_TRAN_POWER_END] = 0;
	CReserved.CIntArray[E_TRAN_POWER_ENABLE] = 1.0;
	CReserved.CStringArray[E_TRAN_POWER_RUN_SELECT] = "Single Run";
	CReserved.CStringArray[E_PULSE_ANALYSIS_RUN_SELECT] = CReserved.CStringArray[E_TRAN_POWER_RUN_SELECT];

	CReserved.CIntArray[E_TRAN_RMS_START] = 0;
	CReserved.CIntArray[E_TRAN_RMS_END] = 0;
	CReserved.CIntArray[E_TRAN_RMS_ENABLE] = 0.0;

	CReserved.CStringArray[E_TRAN_RMS_RUN_SELECT] = CReserved.CStringArray[E_TRAN_POWER_RUN_SELECT];

	CReserved.CIntArray[E_DESIGNER_ENABLE_OPERATING_POINT] = 0.0;
	CReserved.CIntArray[E_DESIGNER_SELECTED_DEVICES] = 3.0;

	CReserved.CStringArray[E_ADC_VOLTAGE] = "5V";
	CReserved.CIntArray[E_ADC_INPUT_CAPACITANCE] = (float)5e-12;
	CReserved.CIntArray[E_ADC_OUTPUT_RESISTANCE] = 100.0;
	CReserved.CIntArray[E_ADC_T_RISE_FALL_DELAY] = (float)1e-9;

	CReserved.CIntArray[E_TRAN_CALCULATE_FFT_ON_LOAD] = 0.0;
	CReserved.CIntArray[E_TRAN_CALCULATE_SELECTED_FFT_SIGNALS] = 0.0;
	

	CReserved.CIntArray[E_PARAMETER_AUTO_GENERATE_RNN_FILE] = 0;

	CReserved.CStringArray[E_PARAMETER_MULTIRUN_DC_PARAM] = "None";
	CReserved.CStringArray[E_PARAMETER_MULTIRUN_AC_PARAM] = "None";
	CReserved.CStringArray[E_PARAMETER_MULTIRUN_NOISE_PARAM] = "None";
	CReserved.CStringArray[E_PARAMETER_MULTIRUN_THD_PARAM] = "None";
	CReserved.CStringArray[E_PARAMETER_MULTIRUN_THD_PARAM] = "None";
	CReserved.CStringArray[E_PARAMETER_MULTIRUN_TRAN_PARAM] = "None";

	CReserved.CIntArray[E_PARAMETER_MULTIRUN_ENABLE] = 0;

	CVGeneratorName = "VPSWC";
	CIGeneratorName = "IPSWC";
	CXGeneratorName = "XRR_";
	CRQWCName		= "RQWC";
	CCQWCName		= "CQWC";
}

TCReRun::TCReRun(TCReRun &CReRun)
{
	*this = CReRun;
}

TCReRun::~TCReRun(void)
{

}

void TCReRun::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);
	CReserved.Serialize(CArchiveFile);

	int count, p;
	int fudge_int; // store new var in same place

	if(CArchiveFile.IsStoring())
	{
		fudge_int = enable; // enable 0, 1, 2
		
		fudge_int = fudge_int | (distribution  << 8); // store distribution in 2nd byte

		CArchiveFile << temp_nominal;
		CArchiveFile << temp_min;
		CArchiveFile << temp_max;
		CArchiveFile << capacitor_tol;
		CArchiveFile << inductor_tol;
		CArchiveFile << resistor_tol;
		CArchiveFile << qrc_max;
		CArchiveFile << qrc_min;
		CArchiveFile << qrc_nom;
		CArchiveFile << number_of_wc_runs;
		CArchiveFile << xspice_run_mode;
		CArchiveFile << generator_tol;
		CArchiveFile << xspice_param_run_mode;

		CArchiveFile << fudge_int;

		count = CWorstCase.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CWorstCase[p].Serialize(CArchiveFile);

		count = CRunType.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CArchiveFile << CRunType[p];
	}
	else
	{
		CArchiveFile >> temp_nominal;
		CArchiveFile >> temp_min;
		CArchiveFile >> temp_max;
		CArchiveFile >> capacitor_tol;
		CArchiveFile >> inductor_tol;
		CArchiveFile >> resistor_tol;
		CArchiveFile >> qrc_max;
		CArchiveFile >> qrc_min;
		CArchiveFile >> qrc_nom;
		CArchiveFile >> number_of_wc_runs;
		CArchiveFile >> xspice_run_mode;
		CArchiveFile >> generator_tol;
		CArchiveFile >> xspice_param_run_mode;

		CArchiveFile >> fudge_int;

		enable = (fudge_int & 255); // select 1st byte

		distribution = (fudge_int >> 8); // get 2nd byte

		CArchiveFile >> count;

		CWorstCase.SetSize(count);

		for(p = 0; p < count; p++) CWorstCase[p].Serialize(CArchiveFile);

		CArchiveFile >> count;

		CRunType.SetSize(count);

		for(p = 0; p < count; p++) CArchiveFile >> CRunType[p];

		//examples and old files support
		if(count < E_NUMBER_OF_BASIC_SPICE_TYPES_VER1)
			CRunType.SetSize(E_NUMBER_OF_BASIC_SPICE_TYPES_VER1);

		CWorstCase[E_WORST_CASE_SUB].CName = "X";// overwrite old data, this should not have been saved anyway
		CWorstCase[E_WORST_CASE_RLC].CName = "RLC";
		CWorstCase[E_WORST_CASE_GENERATOR].CName = "G";
		CWorstCase[E_WORST_CASE_QR].CName = "QRC";
	}
}

void TCReRun::operator = (TCReRun &CReRun)
{
	temp_nominal	= CReRun.temp_nominal;
	temp_min		= CReRun.temp_min;
	temp_max		= CReRun.temp_max;
	capacitor_tol	= CReRun.capacitor_tol;
	inductor_tol	= CReRun.inductor_tol;
	resistor_tol	= CReRun.resistor_tol;
	distribution	= CReRun.distribution;

	qrc_max			= CReRun.qrc_max;
	qrc_min	= CReRun.qrc_min;
	qrc_nom	= CReRun.qrc_nom;

	number_of_wc_runs 	= CReRun.number_of_wc_runs;
	xspice_run_mode 	= CReRun.xspice_run_mode;
	generator_tol 	= CReRun.generator_tol;
	xspice_param_run_mode 	= CReRun.xspice_param_run_mode;
	CVGeneratorName = CReRun.CVGeneratorName;
	CIGeneratorName = CReRun.CIGeneratorName;
	CXGeneratorName = CReRun.CXGeneratorName;
	CRQWCName		= CReRun.CRQWCName;
	CCQWCName		= CReRun.CCQWCName;

	CReserved = CReRun.CReserved;

	enable	= CReRun.enable;

	int count = CReRun.CWorstCase.GetSize();

	CWorstCase.SetSize(count);

	int p;

	for(p = 0; p < count; p++)
	{
		CWorstCase[p] = CReRun.CWorstCase[p];
	}

	count = CReRun.CRunType.GetSize();

	CRunType.SetSize(count);

	for(p = 0; p < count; p++) CRunType[p] = CReRun.CRunType[p];
}

void TCReRun::operator = (TCWaveformAnalyisisData &CWaveformAnalyisisData)
{
	CReserved.CIntArray[E_PULSE_ANALYSIS_ENABLE] = (float)CWaveformAnalyisisData.pulse_enable;

	CReserved.CIntArray[E_PULSE_ANALYSIS_MAX_LEVEL] = (float)CWaveformAnalyisisData.pulse_max_level;
	CReserved.CIntArray[E_PULSE_ANALYSIS_MID_LEVEL] = (float)CWaveformAnalyisisData.pulse_mid_level;
	CReserved.CIntArray[E_PULSE_ANALYSIS_MIN_LEVEL] = (float)CWaveformAnalyisisData.pulse_min_level;

	CReserved.CIntArray[E_PULSE_ANALYSIS_XING_COUNT] = (float)CWaveformAnalyisisData.pulse_xing_count;
	CReserved.CIntArray[E_PULSE_ANALYSIS_REF_XING_COUNT] = (float)CWaveformAnalyisisData.pulse_ref_xing_count;

	CReserved.CIntArray[E_PULSE_ANALYSIS_RISE_XING_TIME] = (float)CWaveformAnalyisisData.pulse_rise_xing_time;
	CReserved.CIntArray[E_PULSE_ANALYSIS_RISE_TIME] = (float)CWaveformAnalyisisData.pulse_rise_time;

	CReserved.CIntArray[E_PULSE_ANALYSIS_FALL_XING_TIME] = (float)CWaveformAnalyisisData.pulse_fall_xing_time;
	CReserved.CIntArray[E_PULSE_ANALYSIS_FALL_TIME] = (float)CWaveformAnalyisisData.pulse_fall_time;

	CReserved.CIntArray[E_PULSE_ANALYSIS_WIDTH_MID_TIME] = (float)CWaveformAnalyisisData.pulse_width_mid_time;

	CReserved.CIntArray[E_PULSE_ANALYSIS_POLARITY] = (float)CWaveformAnalyisisData.pulse_width_polarity;
	CReserved.CIntArray[E_PULSE_ANALYSIS_DELAY] = (float)CWaveformAnalyisisData.pulse_delay;
	CReserved.CIntArray[E_PULSE_ANALYSIS_TIME] = (float)CWaveformAnalyisisData.pulse_time;
	CReserved.CIntArray[E_PULSE_ANALYSIS_PERIOD] = (float)CWaveformAnalyisisData.pulse_period;
	CReserved.CIntArray[E_PULSE_ANALYSIS_WIDTH] = (float)CWaveformAnalyisisData.pulse_width;

	CReserved.CStringArray[E_PULSE_ANALYSIS_REFERANCE_SIGNAL_NAME] = CWaveformAnalyisisData.CPulseReferanceSignal;
	CReserved.CStringArray[E_PULSE_ANALYSIS_MEASURE_SIGNAL_NAME] = CWaveformAnalyisisData.CPulseMeasureSignal;
	CReserved.CStringArray[E_PULSE_ANALYSIS_RUN_SELECT] = CWaveformAnalyisisData.CPulseRunSelect;

	CReserved.CStringArray[E_TRAN_POWER_VOLT_NAME] = CWaveformAnalyisisData.CPowerVoltName;
	CReserved.CStringArray[E_TRAN_POWER_CURRENT_NAME] = CWaveformAnalyisisData.CPowerCurrentName;
	CReserved.CStringArray[E_TRAN_POWER_DEVICE_NAME] = CWaveformAnalyisisData.CPowerDeviceName;
	CReserved.CStringArray[E_TRAN_POWER_RUN_SELECT] = CWaveformAnalyisisData.CPowerRunSelect;

	CReserved.CIntArray[E_TRAN_POWER_ENABLE] = (float)CWaveformAnalyisisData.power_enable;
	CReserved.CIntArray[E_TRAN_POWER_START] = (float)CWaveformAnalyisisData.power_start;
	CReserved.CIntArray[E_TRAN_POWER_END] = (float)CWaveformAnalyisisData.power_end;

	CReserved.CStringArray[E_TRAN_RMS_RUN_SELECT] = CWaveformAnalyisisData.CRMSRunSelect;
	CReserved.CStringArray[E_TRAN_RMS_SIGNAL_NAME] = CWaveformAnalyisisData.CRMSSignalName;
	CReserved.CIntArray[E_TRAN_RMS_START] = (float)CWaveformAnalyisisData.rms_start;
	CReserved.CIntArray[E_TRAN_RMS_END] = (float)CWaveformAnalyisisData.rms_end;
	CReserved.CIntArray[E_TRAN_RMS_ENABLE] = (float)CWaveformAnalyisisData.rms_enable;

	CReserved.CStringArray[E_NOISE_REPORT_FREQUENCY_LIST] = CWaveformAnalyisisData.CNoiseReportFrequencyList;
	
}

int TCReRun::GetModifiedSpiceModelType(CString CRecordType)
{
	int type = GCSuperSpiceDataBase.GetSpiceModelType(CRecordType);

	if(type == E_SPICE_C)   type = E_WC_RLC;	   //move C to RC, via alias
	if(type == E_SPICE_D)   type = E_WC_NPN_DIODE;  // move D to NPN via alias
	if(type == E_SPICE_NJF) type = E_SPICE_NMOS;
	if(type == E_SPICE_PJF) type = E_SPICE_PMOS;
	if(type == E_SPICE_NMF) type = E_SPICE_NMOS;
	if(type == E_SPICE_PMF) type = E_SPICE_PMOS;
	if(type == E_SPICE_URC) type = E_WC_RLC;
	if(type == E_SPICE_L)   type = E_WC_RLC;

	if(!type) type = E_WC_SUBCKT;				// use old C id for .subckt  

	return type;
}

int TCReRun::GetSubcktSpiceModelType(CString CSpiceType)
{
	CSpiceType.MakeUpper();

	if(CSpiceType == "NPN") return E_SPICE_NPN;
	else if(CSpiceType == "PNP") return E_SPICE_PNP;
	else if(CSpiceType == "NMOS") return E_SPICE_NMOS;
	else if(CSpiceType == "PMOS") return E_SPICE_PMOS;
	else if(CSpiceType == "NJF") return E_SPICE_NJF;
	else if(CSpiceType == "PJF") return E_SPICE_NJF;
	else if(CSpiceType == "NMF") return E_SPICE_NJF;
	else if(CSpiceType == "PMF") return E_SPICE_PJF;
	else if(CSpiceType == "URC") return E_WC_RLC;
	else if(CSpiceType == "CAP") return E_WC_RLC;
	else if(CSpiceType == "RES") return E_WC_RLC;
	else if(CSpiceType == "IND") return E_WC_RLC;

	return E_WC_SUBCKT;
}

void TCReRun::SelectAll(void)
{
	int count = CWorstCase.GetSize();

	for(int p = 0; p < count; p++)
	{
		CWorstCase[p].SelectAll();
	}
}

void TCReRun::ClearAll(void)
{
	int count = CWorstCase.GetSize();

	for(int p = 0; p < count; p++)
	{
		CWorstCase[p].ClearAll();
	}
}

void TCReRun::AllWeakMaxTemp(void)
{
	int count = CWorstCase.GetSize();

	for(int p = 0; p < count; p++)
	{
		CWorstCase[p].SelectMin();
	}

	CWorstCase[E_WORST_CASE_TEMP].SelectMax();
}

void TCReRun::AllWeakMinTemp(void)
{
	int count = CWorstCase.GetSize();

	for(int p = 0; p < count; p++)
	{
		CWorstCase[p].SelectMin();
	}
}

void TCReRun::AllStrongMaxTemp(void)
{
	int count = CWorstCase.GetSize();

	for(int p = 0; p < count; p++)
	{
		CWorstCase[p].SelectMax();
	}
}
void TCReRun::AllStrongMinTemp(void)
{
	int count = CWorstCase.GetSize();

	for(int p = 0; p < count; p++)
	{
		CWorstCase[p].SelectMax();
	}

	CWorstCase[E_WORST_CASE_TEMP].SelectMin();
}

void TCReRun::SelectMaxMin(void)
{
	int count = CWorstCase.GetSize();

	for(int p = 0; p < count; p++)
	{
		CWorstCase[p].SelectMaxMin();
	}
}

void TCReRun::SelectAllNominal(void)
{
	int count = CWorstCase.GetSize();

	for(int p = 0; p < count; p++)
	{
		CWorstCase[p].SelectAllNominal();
	}
}

void TCReRun::SetStrength(void)
{
	int count = CWorstCase.GetSize();

	for(int p = 0; p < count; p++)
	{
		CWorstCase[p].SetStrength();
	}
}

int TCReRun::CalculateNumberOfReRuns(void)
{
	int number;
	
	int count = CWorstCase.GetSize();

	if(!count) return 0;

	number = CWorstCase[0].CalculateNumberOfReRuns();

	for(int p = 1; p < E_WORST_CASE_COUNT; p++)
	{
		number *= CWorstCase[p].CalculateNumberOfReRuns();
	}

	return number;
}

CString TCReRun::GetADConversionModelName(void)
{
	CString CModelName = CReserved.CStringArray[E_ADC_VOLTAGE];

	CModelName.MakeUpper();

	if(CModelName.Find('.') < 0)
	{
		if(CModelName.Find('V') == -1) CModelName += 'V';
	}
	else
	{
		CModelName.Remove('V');

		CModelName.Replace('.', 'V');// 3.3 to 3V3
	}

	CModelName += "_SS_Auto_A/D_XN";

	return CModelName;
}


CString TCReRun::GetDAConversionModelName(void)
{
	CString CModelName = GetADConversionModelName();

	CModelName.Replace("A/D", "D/A");

	return CModelName;
}

/////////////////////////////////////////////////////////////////
TCSpiceEngineOptions::TCSpiceEngineOptions(void)
{
	spice3_compatible			= true;
	default_command				= true;
	run_minimised				= true;
	beep_when_engine_finished	= true;
	display_loading_status		= false;
	display_xspice_status		= false; // now added xspice feedback
}

TCSpiceEngineOptions::TCSpiceEngineOptions(TCSpiceEngineOptions &CSpiceEngineOptions)
{
	*this = CSpiceEngineOptions;
}
TCSpiceEngineOptions::~TCSpiceEngineOptions(void)
{

}

void TCSpiceEngineOptions::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);
	CReserved.Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << spice3_compatible;
		CArchiveFile << default_command;
		CArchiveFile << run_minimised;
		CArchiveFile << CSpiceEngineName;
		CArchiveFile << CCommandLine;
		CArchiveFile << beep_when_engine_finished;
		CArchiveFile << display_loading_status;
		CArchiveFile << display_xspice_status;
	}
	else
	{
		CArchiveFile >> spice3_compatible;
		CArchiveFile >> default_command;
		CArchiveFile >> run_minimised;
		CArchiveFile >> CSpiceEngineName;
		CArchiveFile >> CCommandLine;
		CArchiveFile >> beep_when_engine_finished;
		CArchiveFile >> display_loading_status;
		CArchiveFile >> display_xspice_status;
	}
}

void TCSpiceEngineOptions::operator = (TCSpiceEngineOptions &CSpiceEngineOptions)
{
	CSpiceEngineName	= CSpiceEngineOptions.CSpiceEngineName;
	CCommandLine		= CSpiceEngineOptions.CCommandLine;
	spice3_compatible	= CSpiceEngineOptions.spice3_compatible;
	default_command		= CSpiceEngineOptions.default_command;
	run_minimised		= CSpiceEngineOptions.run_minimised;
	CReserved			= CSpiceEngineOptions.CReserved;

	beep_when_engine_finished	= CSpiceEngineOptions.beep_when_engine_finished;
	display_loading_status		= CSpiceEngineOptions.display_loading_status;
	display_xspice_status		= CSpiceEngineOptions.display_xspice_status;
}
//////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
TCOutputSelectData::TCOutputSelectData(void)
{
	all_currents = true;
	all_volts	 = true;
	enable_auto_ad_conversion = false;

	index_spice_volt_and_current= 0;
	index_device_current_node	= 0;
	index_output_source			= 0;
	text_file_type				= 0;//default binary not text spice file
}

TCOutputSelectData::TCOutputSelectData(TCOutputSelectData &COutputSelectData)
{
	*this = COutputSelectData;
}
TCOutputSelectData::~TCOutputSelectData(void)
{

}

void TCOutputSelectData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	int p, count;
	int data = 0;

	if(CArchiveFile.IsStoring())
	{
		if(all_volts) data = TE_EXTRA_OUTPUT_ALL_VOLTS;
		if(enable_auto_ad_conversion) data |= TE_EXTRA_OUTPUT_ENABLE_ADC;

		CArchiveFile << all_currents;
		CArchiveFile << data;//all_volts;
		CArchiveFile << text_file_type;
		CArchiveFile << index_output_source;
		CArchiveFile << index_spice_volt_and_current;
		CArchiveFile << index_device_current_node;
		CArchiveFile << CData;

		count = CSpiceVoltAndCurrentList.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++)CArchiveFile << CSpiceVoltAndCurrentList[p];
	}
	else
	{
		CArchiveFile >> all_currents;
		CArchiveFile >> data;//all_volts;
		CArchiveFile >> text_file_type;
		CArchiveFile >> index_output_source;
		CArchiveFile >> index_spice_volt_and_current;
		CArchiveFile >> index_device_current_node;
		CArchiveFile >> CData;

		CArchiveFile >> count;
		
		CSpiceVoltAndCurrentList.SetSize(count, count);

		for(p = 0; p < count; p++)CArchiveFile >> CSpiceVoltAndCurrentList[p];

		if(data & TE_EXTRA_OUTPUT_ALL_VOLTS) all_volts = 1;
		else all_volts = 0;

		if(data & TE_EXTRA_OUTPUT_ENABLE_ADC) enable_auto_ad_conversion = 1;
		else enable_auto_ad_conversion = 0;
	}
}

void TCOutputSelectData::CopyGlobal(TCOutputSelectData &CSetupSource)
{
	all_currents			= CSetupSource.all_currents;
	all_volts				= CSetupSource.all_volts;
	text_file_type			= CSetupSource.text_file_type;
}

void TCOutputSelectData::CopyUnGlobal(TCOutputSelectData &CSetupSource)
{
	CSetupSource;
}
void TCOutputSelectData::operator = (TCOutputSelectData &COutputSelectData)
{
	all_currents			= COutputSelectData.all_currents;
	all_volts				= COutputSelectData.all_volts;
	text_file_type			= COutputSelectData.text_file_type;
	index_device_current_node = COutputSelectData.index_device_current_node;
	index_spice_volt_and_current	= COutputSelectData.index_spice_volt_and_current;
	index_output_source		= COutputSelectData.index_output_source;
	enable_auto_ad_conversion = COutputSelectData.enable_auto_ad_conversion;


	CData = COutputSelectData.CData;

	int count = COutputSelectData.CSpiceVoltAndCurrentList.GetSize();

	CSpiceVoltAndCurrentList.SetSize(count);

	for(int p = 0; p < count; p++)
	{
		CSpiceVoltAndCurrentList[p] = COutputSelectData.CSpiceVoltAndCurrentList[p];
	}
}

bool TCOutputSelectData::Remove(CString CData)
{
	CData.MakeUpper();

	CString CTemp;

	int count = CSpiceVoltAndCurrentList.GetSize();

	for(int p = 0; p < count; p++)
	{
		CTemp = CSpiceVoltAndCurrentList[p];

		CTemp.MakeUpper();

		if(CTemp != CData) continue;

		CSpiceVoltAndCurrentList.RemoveAt(p);

		return true;
	}

	return false;
}


////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

TCSelectParameter::TCSelectParameter(void)
{
	version			= E_SELECTPARAMETERS_VERSION_2;
	PCParameter	= NULL;
	parameter_id	= 0;

}

TCSelectParameter::TCSelectParameter(TCSelectParameter &CSelectParameter)
{
	*this = CSelectParameter;
}

TCSelectParameter::~TCSelectParameter(void)
{

}

void TCSelectParameter::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	// added wc_value ov 2014, but not needed to be serialised
	if(CArchiveFile.IsStoring())
	{
		version = E_SELECTPARAMETERS_VERSION_2;

		CArchiveFile << parameter_id;	
		CArchiveFile << CParameter;
		CArchiveFile << CRefDesignator;
		CArchiveFile << version;

		CSweepData.Serialize(CArchiveFile); 
	}
	else
	{
		CArchiveFile >> parameter_id;	
		CArchiveFile >> CParameter;
		CArchiveFile >> CRefDesignator;
		CArchiveFile >> version;

		if(version > E_SELECTPARAMETERS_VERSION_ORIGINAL)
		{
			CSweepData.Serialize(CArchiveFile); 
		}
	}
}

void TCSelectParameter::operator = (TCSelectParameter &CSelectParameter)
{
	CRefDesignator = CSelectParameter.CRefDesignator;
	version = CSelectParameter.version;
	parameter_id	= CSelectParameter.parameter_id;	
	CParameter		= CSelectParameter.CParameter;
	PCParameter = CSelectParameter.PCParameter;
	CSweepData = CSelectParameter.CSweepData;
}

////////////////////////////////////////////////////////
TCSuperSpiceGlobalData::TCSuperSpiceGlobalData(void)
{
	this;

	load_ok = false;

	max_index = 10;

	ZoomArray[0] = (float)0.125;
	ZoomArray[1] = (float)0.15625;
	ZoomArray[2] = (float)0.1875;
	ZoomArray[3] = (float)0.25;
	ZoomArray[4] = (float)0.28125;
	ZoomArray[5] = (float)0.375;
	ZoomArray[6] = (float)0.5;
	ZoomArray[7] = (float)0.625;
	ZoomArray[8] = (float)0.75;
	ZoomArray[9] = (float)1.0;
	ZoomArray[10] = (float)1.5;
	ZoomArray[11] = (float)2;// not used

	CSchParamsName = "SchParams";

	CAnalysisSetup.CSelectParameter.CRefDesignator = CSchParamsName;
}

TCSuperSpiceGlobalData::~TCSuperSpiceGlobalData(void)
{

}

int TCSuperSpiceGlobalData::GetZoomIndex(float zoom)
{
	for(int p = 0; p < E_ZOOM_ARRAY_SIZE; p++)
	{
		if(ZoomArray[p] >= zoom ) return p;
	}

	return 8;
}

void TCSuperSpiceGlobalData::Serialize(CArchive& CArchiveFile)
{
	double l_load_check = 1237.6489;
	double load_check = 2.34;

	CObject::Serialize(CArchiveFile);
		
	CVersionInfo.Serialize(CArchiveFile);
	CGeneric.Serialize(CArchiveFile); 
	CPageData.Serialize(CArchiveFile);
	CDrawData.Serialize(CArchiveFile);
	CColorData.Serialize(CArchiveFile);
	CConfigData.Serialize(CArchiveFile);
	CFontData.Serialize(CArchiveFile);
	CAnalysisSetup.Serialize(CArchiveFile);
	CProgramOptions.Serialize(CArchiveFile);
	CPrinterData.Serialize(CArchiveFile);
	CWaveformData.Serialize(CArchiveFile);
	CReserved.Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << g_last_active_schematic_page;
		CArchiveFile << g_last_active_program_options_page ;
		CArchiveFile << g_last_active_simulation_setup_page;
		CArchiveFile << g_last_active_component_property_page;
		CArchiveFile << g_last_active_generator_property_page;
		CArchiveFile << g_last_active_symbol_model_property_page;
		CArchiveFile << g_last_active_waveform_property_page;
		CArchiveFile << g_last_active_fantastic_filter_property_page;
		CArchiveFile << g_last_active_signal_analysis_property_page;
		CArchiveFile << g_last_open_file_tree_tab;
		CArchiveFile << GLastFileTreeSymbolFile;
		CArchiveFile << GLastFileTreeSymbol;
		CArchiveFile << GLastFileTreeModelFile;
		CArchiveFile << GLastFileTreeModel;
		CArchiveFile << GLastFileTreeFilesFile;
		CArchiveFile << GLastFileTreeFiles;

		CArchiveFile << g_show_all_net_names;
		CArchiveFile << g_show_all_dc_volts;
		CArchiveFile << g_show_all_dc_currents;

		CArchiveFile << l_load_check;// keep this last
	}
	else
	{
		CArchiveFile >> g_last_active_schematic_page;
		CArchiveFile >> g_last_active_program_options_page ;
		CArchiveFile >> g_last_active_simulation_setup_page;
		CArchiveFile >> g_last_active_component_property_page;
		CArchiveFile >> g_last_active_generator_property_page;
		CArchiveFile >> g_last_active_symbol_model_property_page;
		CArchiveFile >> g_last_active_waveform_property_page;
		CArchiveFile >> g_last_active_fantastic_filter_property_page;
		CArchiveFile >> g_last_active_signal_analysis_property_page;
		CArchiveFile >> g_last_open_file_tree_tab;
		CArchiveFile >> GLastFileTreeSymbolFile;
		CArchiveFile >> GLastFileTreeSymbol;
		CArchiveFile >> GLastFileTreeModelFile;
		CArchiveFile >> GLastFileTreeModel;
		CArchiveFile >> GLastFileTreeFilesFile;
		CArchiveFile >> GLastFileTreeFiles;

		CArchiveFile >> g_show_all_net_names;
		CArchiveFile >> g_show_all_dc_volts;
		CArchiveFile >> g_show_all_dc_currents;

		CArchiveFile >> load_check;// keep this last

		if(load_check == l_load_check) load_ok = true;
		else
		{
			ASSERT(0);
			load_ok = false;
		}
	}
}

void TCSuperSpiceGlobalData::operator = (TCSuperSpiceGlobalData &CSuperSpiceGlobalData)
{
	CVersionInfo	= CSuperSpiceGlobalData.CVersionInfo;
	CGeneric		= CSuperSpiceGlobalData.CGeneric;
	CPageData		= CSuperSpiceGlobalData.CPageData;
	CDrawData		= CSuperSpiceGlobalData.CDrawData;
	CColorData		= CSuperSpiceGlobalData.CColorData;
	CConfigData		= CSuperSpiceGlobalData.CConfigData;
	CFontData		= CSuperSpiceGlobalData.CFontData;
	CAnalysisSetup	= CSuperSpiceGlobalData.CAnalysisSetup;
	CPrinterData    = CSuperSpiceGlobalData.CPrinterData;
	CWaveformData	= CSuperSpiceGlobalData.CWaveformData;
	CReserved 		= CSuperSpiceGlobalData.CReserved;

	CSchParamsName  = CSuperSpiceGlobalData.CSchParamsName;// No Serialize required
}

bool TCSuperSpiceGlobalData::Save(CString CFileName)
{
	CString CElectronicFormularsFileName = GetPathFromPathAndName(CFileName) + GCSuperSpiceDataBase.CSuperSpiceEquationsName;

	GCElectronicFormulars.Save(CElectronicFormularsFileName);

	CElectronicFormularsFileName = GetPathFromPathAndName(CFileName) + GCSuperSpiceDataBase.CSuperSpiceFilterName;

	GCFantasticFilter.Save(CElectronicFormularsFileName);

	return SaveGenericToArchive(this, CFileName);
}

bool TCSuperSpiceGlobalData ::Load(CString CFileName)
{
	CString CElectronicFormularsFileName = GetPathFromPathAndName(CFileName) + GCSuperSpiceDataBase.CSuperSpiceEquationsName;

	GCElectronicFormulars.Load(CElectronicFormularsFileName);

	CElectronicFormularsFileName = GetPathFromPathAndName(CFileName) + GCSuperSpiceDataBase.CSuperSpiceFilterName;

	GCFantasticFilter.Load(CElectronicFormularsFileName);

	return LoadGenericFromArchive(this, CFileName);
}

void TCSuperSpiceGlobalData::Setup(void)
{
	CString CUserDirectory = GetInitDirectory();
	// default will be overwriten if .ssi exits
	CGeneric.CDataBaseInitFileName			= CUserDirectory + GCSuperSpiceDataBase.CSuperSpiceDataBaseName;
	CGeneric.CDataBaseLastModelFileName		= CUserDirectory + ".lib";
	CGeneric.CDataBaseLastSymbolFileName	= CUserDirectory + ".ssm";
	CGeneric.CDataBaseClipboardFileName		= CUserDirectory + GCSuperSpiceDataBase.CSuperSpiceClipboardName;
	CGeneric.CLastOpenFileDlgName			= GetExamplesDir() + ".sss";
	
	CProgramOptions.CSpiceEngine.CSpiceEngineName	= GetProgramDirectory() + "XSpice.exe";

	CAnalysisSetup.CBerklySpiceOptionsSetupData.Setup();
}
///////////////////////////////////////////////////////
///////////////////////////////////////////////////////
TCSuperSpiceDrawData::TCSuperSpiceDrawData(void)
{
	grid_size					= 32;
	symbol_editor_grid_size		= 4;
	symbol_editor_snap_to_distance = 1;
	symbol_editor_snap_to_grid_on = true;
	symbol_editor_overide_snap_to_grid = false;
	is_grid_display_on			= true;
	is_snap_to_grid_on			= true;
	is_rubber_band_on			= true;
	is_draw_orthoganal_on		= false;
	is_move_with_snap_to_grid	= false;
	snap_to_distance			= 8;// required to get wires to join up.
	all_enclosed				= true;
	hyde_labels					= true;
	fastest_drawing_mode		= false;
	draw_schematic_page_border	= true;
	draw_waveform_page_border   = true;
	vector_printing				= true;
	display_connection_dots		= true;
	connection_dot_size			= 8;
	repeat_pasting				= true;
	probe_mode					= false;

	labels_schematic			= false;
	lables_graph				= false;
	lable_graph_x				= 0;
	lable_graph_y				= -40;
	lable_schematic_x			= 0;
	lable_schematic_y			= 16;
	lable_timeout				= 32768;

	wave_graph_x_shrink			= 136;
	wave_graph_y_shrink			= 128;
	wave_graph_no_border_y_shrink	= 40;
	wave_graph_no_border_y_offset	= 32;
}


TCSuperSpiceDrawData::~TCSuperSpiceDrawData(void)
{

}

void TCSuperSpiceDrawData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);
	CReserved.Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << grid_size;
		CArchiveFile << is_grid_display_on;
		CArchiveFile << is_snap_to_grid_on;
		CArchiveFile << is_rubber_band_on;
		CArchiveFile << is_draw_orthoganal_on;
		CArchiveFile << is_move_with_snap_to_grid;
		CArchiveFile << snap_to_distance;
		CArchiveFile << all_enclosed;
		CArchiveFile << hyde_labels;
		CArchiveFile << draw_schematic_page_border;
		CArchiveFile << fastest_drawing_mode;
		CArchiveFile << symbol_editor_grid_size;
		CArchiveFile << symbol_editor_snap_to_distance;
		CArchiveFile << symbol_editor_snap_to_grid_on;
		CArchiveFile << symbol_editor_overide_snap_to_grid;
		CArchiveFile << vector_printing;
		CArchiveFile << display_connection_dots;
		CArchiveFile << connection_dot_size;
		CArchiveFile << repeat_pasting;
		CArchiveFile << probe_mode;

		CArchiveFile << labels_schematic;
		CArchiveFile << lables_graph;
		CArchiveFile << lable_graph_x;
		CArchiveFile << lable_graph_y;
		CArchiveFile << lable_schematic_x;
		CArchiveFile << lable_schematic_y;
		CArchiveFile << lable_timeout;
		CArchiveFile << draw_waveform_page_border; 
	}
	else
	{
		CArchiveFile >> grid_size;
		CArchiveFile >> is_grid_display_on;
		CArchiveFile >> is_snap_to_grid_on;
		CArchiveFile >> is_rubber_band_on;
		CArchiveFile >> is_draw_orthoganal_on;
		CArchiveFile >> is_move_with_snap_to_grid;
		CArchiveFile >> snap_to_distance;
		CArchiveFile >> all_enclosed;
		CArchiveFile >> hyde_labels;
		CArchiveFile >> draw_schematic_page_border;
		CArchiveFile >> fastest_drawing_mode;
		CArchiveFile >> symbol_editor_grid_size;
		CArchiveFile >> symbol_editor_snap_to_distance;
		CArchiveFile >> symbol_editor_snap_to_grid_on;
		CArchiveFile >> symbol_editor_overide_snap_to_grid;
		CArchiveFile >> vector_printing;
		CArchiveFile >> display_connection_dots;
		CArchiveFile >> connection_dot_size;
		CArchiveFile >> repeat_pasting;
		CArchiveFile >> probe_mode;

		CArchiveFile >> labels_schematic;
		CArchiveFile >> lables_graph;
		CArchiveFile >> lable_graph_x;
		CArchiveFile >> lable_graph_y;
		CArchiveFile >> lable_schematic_x;
		CArchiveFile >> lable_schematic_y;
		CArchiveFile >> lable_timeout;
		CArchiveFile >> draw_waveform_page_border;

	} 
}
void TCSuperSpiceDrawData::operator = (TCSuperSpiceDrawData &CSuperSpiceGridData)
{
	grid_size					= CSuperSpiceGridData.grid_size;
	is_grid_display_on			= CSuperSpiceGridData.is_grid_display_on;
	is_snap_to_grid_on			= CSuperSpiceGridData.is_snap_to_grid_on;
	is_rubber_band_on			= CSuperSpiceGridData.is_rubber_band_on;
	is_draw_orthoganal_on		= CSuperSpiceGridData.is_draw_orthoganal_on;
	is_move_with_snap_to_grid	= CSuperSpiceGridData.is_move_with_snap_to_grid;
	snap_to_distance			= CSuperSpiceGridData.snap_to_distance;
	grid_size					= CSuperSpiceGridData.grid_size;
	all_enclosed 				= CSuperSpiceGridData.all_enclosed;
	draw_schematic_page_border	= CSuperSpiceGridData.draw_schematic_page_border;
	draw_waveform_page_border   = CSuperSpiceGridData.draw_waveform_page_border;
	vector_printing				= CSuperSpiceGridData.vector_printing;
	hyde_labels					= CSuperSpiceGridData.hyde_labels;
	fastest_drawing_mode		= CSuperSpiceGridData.fastest_drawing_mode;
	symbol_editor_grid_size		= CSuperSpiceGridData.symbol_editor_grid_size;
	symbol_editor_snap_to_distance = CSuperSpiceGridData.symbol_editor_snap_to_distance;
	symbol_editor_snap_to_grid_on = CSuperSpiceGridData.symbol_editor_snap_to_grid_on;
	symbol_editor_overide_snap_to_grid = CSuperSpiceGridData.symbol_editor_overide_snap_to_grid;
	display_connection_dots			= CSuperSpiceGridData.display_connection_dots;
	connection_dot_size				= CSuperSpiceGridData.connection_dot_size;
	repeat_pasting				= CSuperSpiceGridData.repeat_pasting;
	probe_mode					= CSuperSpiceGridData.probe_mode;

	wave_graph_x_shrink				= CSuperSpiceGridData.wave_graph_x_shrink;
	wave_graph_y_shrink				= CSuperSpiceGridData.wave_graph_y_shrink;
	wave_graph_no_border_y_shrink	= CSuperSpiceGridData.wave_graph_no_border_y_shrink;
	wave_graph_no_border_y_offset	= CSuperSpiceGridData.wave_graph_no_border_y_offset;

	labels_schematic			= CSuperSpiceGridData.labels_schematic;
	lables_graph				= CSuperSpiceGridData.lables_graph;
	lable_graph_x				= CSuperSpiceGridData.lable_graph_x;
	lable_graph_y				= CSuperSpiceGridData.lable_graph_y;
	lable_schematic_x			= CSuperSpiceGridData.lable_schematic_x;
	lable_schematic_y			= CSuperSpiceGridData.lable_schematic_y;
	lable_timeout				= CSuperSpiceGridData.lable_timeout;

	CReserved					= CSuperSpiceGridData.CReserved;
}



/////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
TCSuperSpiceColorData::TCSuperSpiceColorData(void)
{
	background					= RGB(255, 255, 255);
	grid						= RGB(0, 0, 0);     // Black

	component_normal			= RGB(0, 0, 255);	// Blue
	component_selected			= RGB(255 , 0, 0);	// Red
	component_highlighted		= RGB(255, 100, 255); // Magenta 

	pin_normal					= 32767;
	pin_selected				= component_selected;
	pin_highlighted				= component_highlighted;

	pin_text_normal				= component_normal;
	pin_text_selected			= component_selected;
	pin_text_highlighted		= component_highlighted;

	component_text_normal		= RGB(0, 128, 0); //16711680; // Green
	component_text_selected		= component_selected;
	component_text_highlighted	= component_highlighted;

	user_text_normal			= 8323072;
	user_text_selected			= component_selected;
	user_text_highlighted		= component_highlighted;

	wire_normal					= 8323199;
	wire_selected				= component_selected;
	wire_highlighted			= component_highlighted;
	black_white_printing		= false;
}


TCSuperSpiceColorData::~TCSuperSpiceColorData(void)
{

}

void TCSuperSpiceColorData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);
	CReserved.Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << grid;
		CArchiveFile << background;
		CArchiveFile << component_normal;
		CArchiveFile << component_selected;
		CArchiveFile << component_highlighted;
		CArchiveFile << pin_normal;
		CArchiveFile << pin_selected;
		CArchiveFile << pin_highlighted;
		CArchiveFile << component_text_normal;
		CArchiveFile << component_text_selected;
		CArchiveFile << component_text_highlighted;
		CArchiveFile <<	user_text_normal;
		CArchiveFile <<	user_text_selected;
		CArchiveFile <<	user_text_highlighted;
		CArchiveFile <<	pin_text_normal;
		CArchiveFile <<	pin_text_selected;
		CArchiveFile <<	pin_text_highlighted;
		CArchiveFile <<	wire_normal;
		CArchiveFile <<	wire_selected;
		CArchiveFile <<	wire_highlighted;
		CArchiveFile <<	black_white_printing;
	}
	else
	{
		CArchiveFile >> grid;
		CArchiveFile >> background;
		CArchiveFile >> component_normal;
		CArchiveFile >> component_selected	;
		CArchiveFile >> component_highlighted;
		CArchiveFile >> pin_normal;
		CArchiveFile >> pin_selected;
		CArchiveFile >> pin_highlighted;
		CArchiveFile >> component_text_normal;
		CArchiveFile >> component_text_selected;
		CArchiveFile >> component_text_highlighted;
		CArchiveFile >> user_text_normal;
		CArchiveFile >>	user_text_selected;
		CArchiveFile >>	user_text_highlighted;
		CArchiveFile >>	pin_text_normal;
		CArchiveFile >>	pin_text_selected;
		CArchiveFile >>	pin_text_highlighted;
		CArchiveFile >>	wire_normal;
		CArchiveFile >>	wire_selected;
		CArchiveFile >>	wire_highlighted;
		CArchiveFile >>	black_white_printing;
	}
}
void TCSuperSpiceColorData::operator = (TCSuperSpiceColorData &CSuperSpiceColorData)
{
	grid						= CSuperSpiceColorData.grid;
	background					= CSuperSpiceColorData.background;
	component_normal			= CSuperSpiceColorData.component_normal;
	component_selected			= CSuperSpiceColorData.component_selected;
	component_highlighted		= CSuperSpiceColorData.component_highlighted;
	pin_normal					= CSuperSpiceColorData.pin_normal;
	pin_selected				= CSuperSpiceColorData.pin_selected;
	pin_highlighted				= CSuperSpiceColorData.pin_highlighted;
	component_text_normal		= CSuperSpiceColorData.component_text_normal;
	component_text_selected		= CSuperSpiceColorData.component_text_selected;
	component_text_highlighted	= CSuperSpiceColorData.component_text_highlighted;
	user_text_normal			= CSuperSpiceColorData.user_text_normal;
	user_text_selected			= CSuperSpiceColorData.user_text_selected;
	user_text_highlighted		= CSuperSpiceColorData.user_text_highlighted;
	pin_text_normal 			= CSuperSpiceColorData.pin_text_normal;
	pin_text_selected			= CSuperSpiceColorData.pin_text_selected;
	pin_text_highlighted		= CSuperSpiceColorData.pin_text_highlighted;
	wire_normal					= CSuperSpiceColorData.wire_normal;
	wire_selected				= CSuperSpiceColorData.wire_selected;
	wire_highlighted			= CSuperSpiceColorData.wire_highlighted;
	black_white_printing		= CSuperSpiceColorData.black_white_printing;

	CReserved = CSuperSpiceColorData.CReserved;
}

bool TCSuperSpiceColorData::operator != (TCSuperSpiceColorData &CSuperSpiceColorData)
{
//	if(grid						!= CSuperSpiceColorData.grid) return true;
//	if(background					!= CSuperSpiceColorData.background) return true;
//	if(component_normal			!= CSuperSpiceColorData.component_normal) return true;
//	if(component_selected			!= CSuperSpiceColorData.component_selected) return true;
//	if(component_highlighted		!= CSuperSpiceColorData.component_highlighted) return true;
	if(pin_normal					!= CSuperSpiceColorData.pin_normal) return true;
	if(pin_selected				!= CSuperSpiceColorData.pin_selected) return true;
	if(pin_highlighted				!= CSuperSpiceColorData.pin_highlighted) return true;
//	if(component_text_normal		!= CSuperSpiceColorData.component_text_normal) return true;
//	if(component_text_selected		!= CSuperSpiceColorData.component_text_selected) return true;
//	if(component_text_highlighted	!= CSuperSpiceColorData.component_text_highlighted) return true;
//	if(user_text_normal			!= CSuperSpiceColorData.user_text_normal) return true;
//	if(user_text_selected			!= CSuperSpiceColorData.user_text_selected) return true;
//	if(user_text_highlighted		!= CSuperSpiceColorData.user_text_highlighted) return true;
//	if(pin_text_normal 			!= CSuperSpiceColorData.pin_text_normal) return true;
//	if(pin_text_selected			!= CSuperSpiceColorData.pin_text_selected) return true;
//	if(pin_text_highlighted		!= CSuperSpiceColorData.pin_text_highlighted) return true;
//	if(wire_normal					!= CSuperSpiceColorData.wire_normal) return true;
//	if(wire_selected				!= CSuperSpiceColorData.wire_selected) return true;
//	if(wire_highlighted			!= CSuperSpiceColorData.wire_highlighted) return true;

	return false;
}
/////////////////////////////////////////////////
/////////////////////////////////////////////////
TCSuperSpiceGeneric::TCSuperSpiceGeneric(void)
{
	zoom_scale_rate_facter		= 2;
	component_base_font_size	= 200;
	load_toolbar_state			= false;
	ignore_model_path			= true;
}

TCSuperSpiceGeneric::~TCSuperSpiceGeneric(void)
{

}

void TCSuperSpiceGeneric::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);
	CReserved.Serialize(CArchiveFile);
/*
	if(CReserved.CStringArray.GetSize() < SIZE)// For added data
	{

	}
*/
	int count, p;

	if(CArchiveFile.IsStoring())
	{
		load_toolbar_state = true;

		CArchiveFile << CProgramVersion;
		CArchiveFile << CSchematicVersion;
		CArchiveFile << zoom_scale_rate_facter;
		CArchiveFile << load_toolbar_state;
		CArchiveFile << component_base_font_size;
		CArchiveFile << CDataBaseInitFileName;
		CArchiveFile << CDataBaseLastModelFileName;
		CArchiveFile << CDataBaseLastSymbolFileName;
		CArchiveFile << CDataBaseClipboardFileName;
		CArchiveFile << CLastOpenFileDlgName;

		count = CComponentPropertyCurrentPin.GetSize();
		CArchiveFile << count;
		for(p = 0; p < count; p++)CArchiveFile << CComponentPropertyCurrentPin[p];

		CArchiveFile << ignore_model_path;

	}
	else
	{
		CArchiveFile >> CProgramVersion;	//This must be first
		CArchiveFile >> CSchematicVersion;
		CArchiveFile >> zoom_scale_rate_facter;
		CArchiveFile >> load_toolbar_state;
		CArchiveFile >> component_base_font_size;
		CArchiveFile >> CDataBaseInitFileName;
		CArchiveFile >> CDataBaseLastModelFileName;
		CArchiveFile >> CDataBaseLastSymbolFileName;
		CArchiveFile >> CDataBaseClipboardFileName;
		CArchiveFile >> CLastOpenFileDlgName;

		CArchiveFile >> count;
		CComponentPropertyCurrentPin.SetSize(count, count);

		for(p = 0; p < count; p++)CArchiveFile >> CComponentPropertyCurrentPin[p];

		CArchiveFile >> ignore_model_path;
	}
}

void TCSuperSpiceGeneric::operator = (TCSuperSpiceGeneric &CGeneric)
{
	CReserved = CGeneric.CReserved;

	zoom_scale_rate_facter		= CGeneric.zoom_scale_rate_facter;
	component_base_font_size	= CGeneric.component_base_font_size;
	load_toolbar_state			= CGeneric.load_toolbar_state;

	CProgramVersion		= CGeneric.CProgramVersion;
	CSchematicVersion	= CGeneric.CSchematicVersion;

	CDataBaseInitFileName		= CGeneric.CDataBaseInitFileName;
	CDataBaseLastModelFileName	= CGeneric.CDataBaseLastModelFileName;
	CDataBaseLastSymbolFileName	= CGeneric.CDataBaseLastSymbolFileName;
	CDataBaseClipboardFileName	= CGeneric.CDataBaseClipboardFileName;
	CLastOpenFileDlgName		= CGeneric.CLastOpenFileDlgName;

	int count = CGeneric.CComponentPropertyCurrentPin.GetSize();

	CComponentPropertyCurrentPin.SetSize(count);

	for(int p = 0; p < count; p++)
	{
		CComponentPropertyCurrentPin[p] = CGeneric.CComponentPropertyCurrentPin[p];
	}

	ignore_model_path = CGeneric.ignore_model_path;
}


///////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////
TCSuperSpiceFontData::TCSuperSpiceFontData()
{

	component_size	= 200;
	user_size		= 200;
	pin_size		= 140;// want 140, need to fix reloading wrong
	waveform_axis	= 200;
	wave_form_title	= 200;
	wave_form_notes	= 200;
	connection_dot_size	= 8;
	reseved2		= 200;
	reseved3		= 200;
	reseved4		= 200;

	CWaveformAxis	= "Times New Roman";
	CWaveformTitle	= "Times New Roman";
	CWaveformNotes	= "Times New Roman";
	CComponents		= "Times New Roman";
	CUser			= "Times New Roman";
	CPins			= "Times New Roman";
	CConnectionDotFontString	= "Times New Roman";
	CStringReseved2	= "Times New Roman";
	CStringReseved3	= "Times New Roman";
	CStringReseved4	= "Times New Roman";

	CFont CInitFont;

	CInitFont.CreatePointFont(component_size, CComponents, NULL);
	CInitFont.GetLogFont(&CComponentLogFont);
	CComponentLogFont.lfWeight = FW_BOLD;
	CInitFont.DeleteObject();

	CInitFont.CreatePointFont(user_size, CUser, NULL);
	CInitFont.GetLogFont(&CUserLogFont);
	CComponentLogFont.lfWeight = FW_BOLD;
	CInitFont.DeleteObject();

	CInitFont.CreatePointFont(pin_size, CPins, NULL);
	CInitFont.GetLogFont(&CPinsLogFont);
	CInitFont.DeleteObject();

	CInitFont.CreatePointFont(waveform_axis, CWaveformAxis, NULL);
	CInitFont.GetLogFont(&CWaveformAxisLogFont);
	CComponentLogFont.lfWeight = FW_BOLD;
	CInitFont.DeleteObject();

	CInitFont.CreatePointFont(wave_form_title, CWaveformTitle, NULL);
	CInitFont.GetLogFont(&CWaveformTitleLogFont);
	CComponentLogFont.lfWeight = FW_BOLD;
	CInitFont.DeleteObject();

	CInitFont.CreatePointFont(wave_form_notes, CWaveformNotes, NULL);
	CInitFont.GetLogFont(&CWaveformNotesLogFont);
	CInitFont.DeleteObject();
 
	CInitFont.CreatePointFont(connection_dot_size, CConnectionDotFontString, NULL);
	CInitFont.GetLogFont(&CConnectionDotFont);
	CInitFont.DeleteObject();
}

TCSuperSpiceFontData::~TCSuperSpiceFontData()
{

}

void TCSuperSpiceFontData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << component_size;
		CArchiveFile << user_size;
		CArchiveFile << pin_size; 
		CArchiveFile << waveform_axis;
		CArchiveFile << wave_form_title;
		CArchiveFile << wave_form_notes;
		CArchiveFile << connection_dot_size;
		CArchiveFile << reseved2;
		CArchiveFile << reseved3;
		CArchiveFile << reseved4;

		CArchiveFile << CComponents;
		CArchiveFile << CUser;
		CArchiveFile << CPins;
		CArchiveFile << CWaveformAxis;
		CArchiveFile << CWaveformTitle;
		CArchiveFile << CWaveformNotes;
		CArchiveFile << CConnectionDotFontString;
		CArchiveFile << CStringReseved2;
		CArchiveFile << CStringReseved3;
		CArchiveFile << CStringReseved4;

		CArchiveFile.Write(&CComponentLogFont, sizeof(CComponentLogFont));
		CArchiveFile.Write(&CUserLogFont, sizeof(CUserLogFont));
		CArchiveFile.Write(&CPinsLogFont, sizeof(CPinsLogFont));
		CArchiveFile.Write(&CWaveformAxisLogFont, sizeof(CWaveformAxisLogFont));
		CArchiveFile.Write(&CWaveformTitleLogFont, sizeof(CWaveformTitleLogFont));
		CArchiveFile.Write(&CWaveformNotesLogFont, sizeof(CWaveformNotesLogFont));
		CArchiveFile.Write(&CConnectionDotFont, sizeof(CConnectionDotFont));
		CArchiveFile.Write(&CReserved2LogFont, sizeof(CReserved2LogFont));
		CArchiveFile.Write(&CReserved3LogFont, sizeof(CReserved3LogFont));
		CArchiveFile.Write(&CReserved4LogFont, sizeof(CReserved4LogFont));
	}
	else
	{
		CArchiveFile >> component_size;
		CArchiveFile >> user_size;
		CArchiveFile >> pin_size;
		CArchiveFile >> waveform_axis;
		CArchiveFile >> wave_form_title;
		CArchiveFile >> wave_form_notes;
		CArchiveFile >> connection_dot_size;
		CArchiveFile >> reseved2;
		CArchiveFile >> reseved3;
		CArchiveFile >> reseved4;

		CArchiveFile >> CComponents;
		CArchiveFile >> CUser;
		CArchiveFile >> CPins;
		CArchiveFile >> CWaveformAxis;
		CArchiveFile >> CWaveformTitle;
		CArchiveFile >> CWaveformNotes;
		CArchiveFile >> CConnectionDotFontString;
		CArchiveFile >> CStringReseved2;
		CArchiveFile >> CStringReseved3;
		CArchiveFile >> CStringReseved4;

		CArchiveFile.Read(&CComponentLogFont, sizeof(CComponentLogFont));
		CArchiveFile.Read(&CUserLogFont, sizeof(CUserLogFont));
		CArchiveFile.Read(&CPinsLogFont, sizeof(CPinsLogFont));
		CArchiveFile.Read(&CWaveformAxisLogFont, sizeof(CWaveformAxisLogFont));
		CArchiveFile.Read(&CWaveformTitleLogFont, sizeof(CWaveformTitleLogFont));
		CArchiveFile.Read(&CWaveformNotesLogFont, sizeof(CWaveformNotesLogFont));
		CArchiveFile.Read(&CConnectionDotFont, sizeof(CConnectionDotFont));
		CArchiveFile.Read(&CReserved2LogFont, sizeof(CReserved2LogFont));
		CArchiveFile.Read(&CReserved3LogFont, sizeof(CReserved3LogFont));
		CArchiveFile.Read(&CReserved4LogFont, sizeof(CReserved4LogFont));
	
	}
}

void TCSuperSpiceFontData::operator = (TCSuperSpiceFontData &CFontData)
{
	component_size	= CFontData.component_size;
	user_size		= CFontData.user_size;
	pin_size		= CFontData.pin_size; 
	waveform_axis	= CFontData.waveform_axis;
	wave_form_title	= CFontData.wave_form_title;
	wave_form_notes	= CFontData.wave_form_notes;
	CComponents		= CFontData.CComponents;
	CUser			= CFontData.CUser;
	CPins			= CFontData.CPins;
	CWaveformAxis	= CFontData.CWaveformAxis;
	CWaveformTitle	= CFontData.CWaveformTitle;
	CWaveformNotes	= CFontData.CWaveformNotes;
	CConnectionDotFontString	= CFontData.CConnectionDotFontString;
	CStringReseved2	= CFontData.CStringReseved2;
	CStringReseved3	= CFontData.CStringReseved3;
	CStringReseved4	= CFontData.CStringReseved4;
	connection_dot_size		= CFontData.connection_dot_size;
	reseved2		= CFontData.reseved2;
	reseved3		= CFontData.reseved3;
	reseved4		= CFontData.reseved4;

	CComponentLogFont		= CFontData.CComponentLogFont;
	CUserLogFont			= CFontData.CUserLogFont;
	CPinsLogFont			= CFontData.CPinsLogFont;
	CWaveformAxisLogFont	= CFontData.CWaveformAxisLogFont;
	CWaveformTitleLogFont	= CFontData.CWaveformTitleLogFont;
	CWaveformNotesLogFont	= CFontData.CWaveformNotesLogFont;

	CConnectionDotFont	= CFontData.CConnectionDotFont;
	CReserved2LogFont	= CFontData.CReserved2LogFont;
	CReserved3LogFont	= CFontData.CReserved3LogFont;
	CReserved4LogFont	= CFontData.CReserved4LogFont;
}

//////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
TCSuperSpiceConfigData::TCSuperSpiceConfigData(void)
{
	CTestPointData.COld					= "";
	CTestPointData.update_graph_views	= true;
	CTestPointData.new_index			= -1;
	CTestPointData.old_index			= -1;
	CTestPointData.old_type				= E_TEST_POINT_DBDEGS;
	CTestPointData.new_type				= E_TEST_POINT_DBDEGS;
	CTestPointData.version				= -1;
	CTestPointData.CNew					= "";
	CTestPointData.COld					= "";
	
}

TCSuperSpiceConfigData::~TCSuperSpiceConfigData(void)
{

}

void TCSuperSpiceConfigData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);
	CTestPointData.Serialize(CArchiveFile);
	CReserved.Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{

	}
	else
	{

	}
}

void TCSuperSpiceConfigData::operator = (TCSuperSpiceConfigData &CSuperSpiceConfigData)
{
	CReserved = CSuperSpiceConfigData.CReserved;

	CTestPointData = CSuperSpiceConfigData.CTestPointData;
}
/////////////////////////////////////////////////////
TCAnalysisSetup::TCAnalysisSetup()
{
	PCDoc = NULL;

	parameter_sweep_mode = false; // nomal runs, true for sweeps 
	
	CSelectParameter.PCParameter = &CSchematicDefsParameters;

	CSelectParameter.CRefDesignator = GCSuperSpiceGlobalData.CSchParamsName;
}

TCAnalysisSetup::TCAnalysisSetup(TCAnalysisSetup &CAnalysisSetup)
{
	*this = CAnalysisSetup;
}

TCAnalysisSetup::~TCAnalysisSetup()
{

}

int TCAnalysisSetup::FindVoltAndCurrentNode(CString CNode)
{
	CString CTemp;

	CNode.MakeUpper();

	int count = COutputList.CData.GetSize();

	for(int p = 0; p < count; p++)
	{
		CTemp = COutputList.CData[p].CUserName;

		CTemp.MakeUpper();

		if(CTemp == CNode) return p;
	}

	return -1;
}

int TCAnalysisSetup::FindDeviceCurrentNode(CString CNode)
{
	CString CTemp;

	CNode.MakeUpper();

	int count = CDeviceCurrentNodeList.CData.GetSize();

	for(int p = 0; p < count; p++)
	{
		CTemp = CDeviceCurrentNodeList.CData[p].CUserName;

		CTemp.MakeUpper();

		if(CTemp == CNode) return p;
	}

	return -1;
}

void TCAnalysisSetup::RemoveInvalidOutputSelectData(void)
{
	CString CTemp;

	CArray <CString, CString> CStringList;

	int count = COutputSelectData.CSpiceVoltAndCurrentList.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{
		CTemp = COutputSelectData.CSpiceVoltAndCurrentList[p];

		if(FindVoltAndCurrentNode(CTemp) > -1) continue;
		if(FindDeviceCurrentNode(CTemp) > -1) continue;

		CStringList.Add(CTemp);
	}

	count = CStringList.GetSize();

	for(p = 0; p < count; p++)
	{
		COutputSelectData.Remove(CStringList[p]);
	}
}

void TCAnalysisSetup::CopyGlobal(TCAnalysisSetup &CAnalysisSetupSource)
{
	CACSetupData.CopyGlobal(CAnalysisSetupSource.CACSetupData);
	CDCSetupData.CopyGlobal(CAnalysisSetupSource.CDCSetupData);
	CNoiseSetupData.CopyGlobal(CAnalysisSetupSource.CNoiseSetupData);
	CTransientSetupData.CopyGlobal(CAnalysisSetupSource.CTransientSetupData);
	CParametricSetupData.CopyGlobal(CAnalysisSetupSource.CParametricSetupData);
	CStatisticsSetupData.CopyGlobal(CAnalysisSetupSource.CStatisticsSetupData);
	CSensitivitySetupData.CopyGlobal(CAnalysisSetupSource.CSensitivitySetupData);
	CPoleZeroSetupData.CopyGlobal(CAnalysisSetupSource.CPoleZeroSetupData);
	CDistortionSetupData.CopyGlobal(CAnalysisSetupSource.CDistortionSetupData);
	COutputSelectData.CopyGlobal(CAnalysisSetupSource.COutputSelectData);

	CTemperatureSetupData			= CAnalysisSetupSource.CTemperatureSetupData;
	CBerklySpiceOptionsSetupData	= CAnalysisSetupSource.CBerklySpiceOptionsSetupData;
	CReRun							= CAnalysisSetupSource.CReRun;

/*
	CMultiLineData					= CAnalysisSetupSource.CMultiLineData;
	PCDoc							= CAnalysisSetupSource.PCDoc;
	CSchematicDefsParameters		= CAnalysisSetupSource.CSchematicDefsParameters;
	CParameterDefsSweepParameters	= CAnalysisSetupSource.CParameterDefsSweepParameters;
	CSchematicParameters			= CAnalysisSetupSource.CSchematicParameters;
	CSchematicSweepParameters		= CAnalysisSetupSource.CSchematicSweepParameters;
	parameter_sweep_mode			= CAnalysisSetupSource.parameter_sweep_mode;

	CSelectParameter				= CAnalysisSetupSource.CSelectParameter;
	// Restore correct pointer to this on
	CSelectParameter.PCParameter    = &CSchematicDefsParameters;
*/
}

void TCAnalysisSetup::CopyUnGlobal(TCAnalysisSetup &CAnalysisSetupSource)
{
	CAnalysisSetupSource;
}

void TCAnalysisSetup::operator = (TCAnalysisSetup &CAnalysisSetup)
{
	CSchematicName				= CAnalysisSetup.CSchematicName;
	CFileName					= CAnalysisSetup.CFileName;
	CMultiLineData              = CAnalysisSetup.CMultiLineData;
	
	CACSetupData				= CAnalysisSetup.CACSetupData;
	CDCSetupData				= CAnalysisSetup.CDCSetupData;
	CNoiseSetupData				= CAnalysisSetup.CNoiseSetupData;
	CTransientSetupData			= CAnalysisSetup.CTransientSetupData;
	CParametricSetupData		= CAnalysisSetup.CParametricSetupData;
	CStatisticsSetupData		= CAnalysisSetup.CStatisticsSetupData;
	CSensitivitySetupData		= CAnalysisSetup.CSensitivitySetupData;
	CPoleZeroSetupData			= CAnalysisSetup.CPoleZeroSetupData;
	CDistortionSetupData		= CAnalysisSetup.CDistortionSetupData;
	COutputSelectData			= CAnalysisSetup.COutputSelectData;
	CTemperatureSetupData		= CAnalysisSetup.CTemperatureSetupData;
	CBerklySpiceOptionsSetupData= CAnalysisSetup.CBerklySpiceOptionsSetupData;
	CReRun						= CAnalysisSetup.CReRun;
	
	COutputList					= CAnalysisSetup.COutputList;
	CSourceList					= CAnalysisSetup.CSourceList;
	CNodeList					= CAnalysisSetup.CNodeList;
	CDeviceCurrentNodeList		= CAnalysisSetup.CDeviceCurrentNodeList;
	CStaticOutputList			= CAnalysisSetup.CStaticOutputList;
	CReserved1					= CAnalysisSetup.CReserved1;
	CReserved2					= CAnalysisSetup.CReserved2;

	PCDoc							= CAnalysisSetup.PCDoc;
	CSchematicDefsParameters		= CAnalysisSetup.CSchematicDefsParameters;
	CParameterDefsSweepParameters	= CAnalysisSetup.CParameterDefsSweepParameters;
	CSchematicParameters			= CAnalysisSetup.CSchematicParameters;
	CSchematicSweepParameters		= CAnalysisSetup.CSchematicSweepParameters;
	parameter_sweep_mode			= CAnalysisSetup.parameter_sweep_mode;
	CSelectParameter				= CAnalysisSetup.CSelectParameter;
	CSelectParameter.PCParameter    = &CSchematicDefsParameters;

	int p, count;

	count = CAnalysisSetup.CLibraryNameList.GetSize();

	CLibraryNameList.SetSize(count, count);

	for(p = 0; p < count; p++) CLibraryNameList[p] = CAnalysisSetup.CLibraryNameList[p];

	count = CAnalysisSetup.CIncludeNameList.GetSize();

	CIncludeNameList.SetSize(count, count);

	for(p = 0; p < count; p++) CIncludeNameList[p] = CAnalysisSetup.CIncludeNameList[p];
}

void TCAnalysisSetup::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	int save_serialize = 12345678;
	int load_serialize = 3456;

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << save_serialize;
	}
	else
	{
		CArchiveFile >> load_serialize;

		if(save_serialize != load_serialize)
		{
			AfxMessageBox(IDS_INVALID_FILE);

			return;
		}
	}

	CACSetupData.Serialize(CArchiveFile);
	CDCSetupData.Serialize(CArchiveFile);
	CNoiseSetupData.Serialize(CArchiveFile);
	CTransientSetupData.Serialize(CArchiveFile);
	CStatisticsSetupData.Serialize(CArchiveFile);
	CSensitivitySetupData.Serialize(CArchiveFile);
	CTemperatureSetupData.Serialize(CArchiveFile);
	CParametricSetupData.Serialize(CArchiveFile);
	CBerklySpiceOptionsSetupData.Serialize(CArchiveFile);
	CPoleZeroSetupData.Serialize(CArchiveFile);
	CDistortionSetupData.Serialize(CArchiveFile);
	COutputList.Serialize(CArchiveFile);
	CSourceList.Serialize(CArchiveFile);
	CNodeList.Serialize(CArchiveFile);
	CStaticOutputList.Serialize(CArchiveFile);
	COutputSelectData.Serialize(CArchiveFile);
	CDeviceCurrentNodeList.Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring()) // Kludge, using variable rerun saved data.
	{
		PutParametricDataToRereun();

		CReRun.Serialize(CArchiveFile);
	}
	else
	{
		CReRun.Serialize(CArchiveFile);

		PutRereunDataToParametric();
	}
	
	int p, count;

	if(CArchiveFile.IsStoring())
	{
		SaveSchematicParameters();

		CArchiveFile << CSchematicName;

		SaveMultiLineData(CArchiveFile);
		
		count = CLibraryNameList.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CArchiveFile << CLibraryNameList[p];

		count = CIncludeNameList.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CArchiveFile << CIncludeNameList[p];
	}
	else
	{
		CArchiveFile >> CSchematicName;

		LoadMultiLineData(CArchiveFile);

		CArchiveFile >> count;

		CLibraryNameList.SetSize(count, count);

		for(p = 0; p < count; p++) CArchiveFile >> CLibraryNameList[p];

		CArchiveFile >> count;

		CIncludeNameList.SetSize(count, count);

		for(p = 0; p < count; p++) CArchiveFile >> CIncludeNameList[p];

		LoadSchematicParameters();
	}

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << save_serialize;
	}
	else
	{
		CArchiveFile >> load_serialize;

		if(save_serialize != load_serialize)
		{
			AfxMessageBox(IDS_INVALID_FILE);

			return;
		}
	}
}

void TCAnalysisSetup::LoadSchematicParameters()
{
	CMultiLineData.CLines.SetSize(E_ANALYSIS_EXTRA_MAX_COUNT);// Force resize if nessesary

	CSchematicParameters = CMultiLineData.CLines[E_SCHEMATIC_PARAMETERS_DEFS];

	CSchematicDefsParameters.LineToArray(CSchematicParameters);

	CParameterDefsSweepParameters = CSchematicDefsParameters;

	CSchematicSweepParameters = CSchematicParameters;
}

void TCAnalysisSetup::PutParametricDataToRereun(void)
{
	CReRun.CReserved.CStringArray[E_PARAMETER_MULTIRUN_SIGNAL]		= CParametricSetupData.CMultiRunSignal;
	CReRun.CReserved.CStringArray[E_PARAMETER_MULTIRUN_DC_PARAM]	= CParametricSetupData.CMultiRunDCParam;
	CReRun.CReserved.CStringArray[E_PARAMETER_MULTIRUN_AC_PARAM]	= CParametricSetupData.CMultiRunACParam;
	CReRun.CReserved.CStringArray[E_PARAMETER_MULTIRUN_TRAN_PARAM] = CParametricSetupData.CMultiRunTranParam;
	CReRun.CReserved.CStringArray[E_PARAMETER_MULTIRUN_NOISE_PARAM] = CParametricSetupData.CMultiRunNoiseParam;
	CReRun.CReserved.CStringArray[E_PARAMETER_MULTIRUN_THD_PARAM]	= CParametricSetupData.CMultiRunTHDParam;
	CReRun.CReserved.CIntArray[E_PARAMETER_MULTIRUN_ENABLE]			= CParametricSetupData.multi_run_enable;
}
void TCAnalysisSetup::PutRereunDataToParametric(void)
{
	CParametricSetupData.CMultiRunSignal		= CReRun.CReserved.CStringArray[E_PARAMETER_MULTIRUN_SIGNAL];
	CParametricSetupData.CMultiRunDCParam		= CReRun.CReserved.CStringArray[E_PARAMETER_MULTIRUN_DC_PARAM];
	CParametricSetupData.CMultiRunACParam		= CReRun.CReserved.CStringArray[E_PARAMETER_MULTIRUN_AC_PARAM];
	CParametricSetupData.CMultiRunTranParam		= CReRun.CReserved.CStringArray[E_PARAMETER_MULTIRUN_TRAN_PARAM];
	CParametricSetupData.CMultiRunNoiseParam	= CReRun.CReserved.CStringArray[E_PARAMETER_MULTIRUN_NOISE_PARAM];
	CParametricSetupData.CMultiRunTHDParam		= CReRun.CReserved.CStringArray[E_PARAMETER_MULTIRUN_THD_PARAM];
	CParametricSetupData.multi_run_enable		= CReRun.CReserved.CIntArray[E_PARAMETER_MULTIRUN_ENABLE];
}

void TCAnalysisSetup::SaveSchematicParameters()
{
	CSchematicParameters = CSchematicDefsParameters.ArrayToLine();

	int count = CMultiLineData.CLines.GetSize();

	if(count != E_ANALYSIS_EXTRA_MAX_COUNT) 
	{
		CMultiLineData.CLines.SetSize(E_ANALYSIS_EXTRA_MAX_COUNT);
	}

	CMultiLineData.CLines[E_SCHEMATIC_PARAMETERS_DEFS] = CSchematicParameters;
}

double TCAnalysisSetup::EvaluateComponentValue(CString CLable)
{
	CString CParamLine;

	double data = 0;

	if(CLable == "") return 0;

	if(CLable.Find('{') < 0)// no expression to evaluate
	{
		data = SpiceMKSStringToFloat(CLable);

		return data;
	}

	if(parameter_sweep_mode)
	{
		if(CSchematicSweepParameters == "") return data;

		CParamLine = GetResolvedParameters(CParameterDefsSweepParameters);
	}
	else
	{
		if(CSchematicParameters == "") return data;

		CParamLine = GetResolvedParameters(CSchematicDefsParameters);
	}

	if(!EquationSetVaribles(CParamLine)) return data;

	CLable.Remove('{');
	CLable.Remove('}');

	Equation(CLable, &data);

	return data;
}

CString TCAnalysisSetup::GetResolvedParameters(TCSpiceParameters &CParams)
{
	int p, count;
	CString CParamLine, CVariableLine, CValue;
	TCSpiceParameters CLocalSpiceParameters;

	CLocalSpiceParameters = CParams;

	count = CLocalSpiceParameters.CData.GetSize();

	for(p = 0; p < count; p++) // Get all resolved variables
	{
		TCNameValueData &CNameValueData = CLocalSpiceParameters.CData[p];

		if(!CNameValueData.is_text_data)
		{
			CValue.Format("%e", CNameValueData.value);

			CVariableLine += CNameValueData.CName + '=' + CValue + ' ';
		}
	}

	EquationSetVaribles(CVariableLine);

	for(p = 0; p < count; p++) // Set all non resolved variables
	{
		TCNameValueData &CNameValueData = CLocalSpiceParameters.CData[p];

		if(CNameValueData.is_text_data)
		{
			CNameValueData.CValue.Remove('{');
			CNameValueData.CValue.Remove('}');

			Equation(CNameValueData.CValue, &CNameValueData.value);
			 
			CNameValueData.is_text_data = false;
		}
	}

	CParamLine = "";

	for(p = 0; p < count; p++) // Generate resolved param line
	{
		TCNameValueData &CNameValueData = CLocalSpiceParameters.CData[p];

		CValue.Format("%e", CNameValueData.value);

		CParamLine += CNameValueData.CName + "=" + CValue + ' ';// 12 June 2015, changed = to +=
	}
	
	return CParamLine;
}

void TCAnalysisSetup::SetParameterSweepParameter(CString CParam, double value)
{
	value;
/*
	// Not used
	int p, count;

	CParameterDefsSweepParameters = CSchematicDefsParameters;

	count = CParameterDefsSweepParameters.CData.GetSize();

	for(p = 0; p < count; p++)
	{
		TCNameValueData &CNameValueData = CParameterDefsSweepParameters.CData[p];

		if(CNameValueData.CName != CParam) continue;

		CNameValueData.is_text_data = false;
		CNameValueData.value		= value;

		break;
	}

//	CSchematicSweepParameters = CParameterDefsSweepParameters.ConvertToParameterString();
*/
}

void TCAnalysisSetup::SetParameterSweepParameter(int param_id, double value)
{
	int count;

	count = CSchematicDefsParameters.CData.GetSize();

	if(!(param_id < count)) return;

	CParameterDefsSweepParameters = CSchematicDefsParameters;

	TCNameValueData &CNameValueData = CParameterDefsSweepParameters.CData[param_id];

	CNameValueData.value		= value;
	CNameValueData.is_text_data = false;

//	CSchematicSweepParameters = CParameterDefsSweepParameters.ConvertToParameterString();
}

void TCAnalysisSetup::LoadMultiLineData(CArchive& CArchiveFile)
{
	CMultiLineData.Load(CArchiveFile);

	int count = CMultiLineData.CLines.GetSize();

	if(count != E_ANALYSIS_EXTRA_MAX_COUNT)
	{
		CMultiLineData.CLines.SetSize(E_ANALYSIS_EXTRA_MAX_COUNT); // Ensure ok
	}

	CFileName = CMultiLineData.CLines[E_ANALYSIS_SETUP_FILE_NAME];
}

void TCAnalysisSetup::SaveMultiLineData(CArchive& CArchiveFile)
{
	int count = CMultiLineData.CLines.GetSize();
	
	if(count)
		CMultiLineData.CLines[E_ANALYSIS_SETUP_FILE_NAME] = CFileName;// ensure orginal data is saved ok

	CMultiLineData.Save(CArchiveFile);
}

//////////////////////////////////////////////////////////////
TCSweepData::TCSweepData()
{
	start	= 1;
	stop	= 1;
	step	= 1;
	type	= E_PARAMETER_SWEEP_TYPE_LINEAR;
	index  = 0;
	enable	= false;

	sweep_type = E_TEMPERATURE_SWEEP_MULTY_RUNS;
}

TCSweepData::TCSweepData(TCSweepData &CSweepData)
{
	*this = CSweepData;
}

TCSweepData::~TCSweepData()
{

}

void TCSweepData::operator = (TCSweepData &CSweepData)
{
	start	= CSweepData.start;
	stop	= CSweepData.stop;
	step	= CSweepData.step;
	type	= CSweepData.type;
	enable	= CSweepData.enable;
	sweep_type = CSweepData.sweep_type;
	index = CSweepData.index;
	CValueList = CSweepData.CValueList;
}

void TCSweepData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);
	
	struct convert_data			// kludge to stuff data in same place as older versions
	{
		short type : 8;			// this was 16, MS i.e. shit in object versioning, i.e. it dont work
		short version: 8;		// older versions will have this set to zero
		short sweep_type : 16;

	}	s_data;

	int data = 0;
	int version;

	if(CArchiveFile.IsStoring())
	{
		s_data.version		= E_SWEEP_VERSION_2;

		s_data.type			= type;
		s_data.sweep_type	= sweep_type;
		
		memcpy(&data, &s_data, 4);

		CArchiveFile << start;
		CArchiveFile << stop;
		CArchiveFile << step;
		CArchiveFile << data;
		CArchiveFile << enable;

		CArchiveFile << CValueList; 
	}
	else
	{
		CArchiveFile >> start;
		CArchiveFile >> stop;
		CArchiveFile >> step;
		CArchiveFile >> data;
		CArchiveFile >> enable;

		memcpy(&s_data, &data, 4);

		type		= s_data.type;
		sweep_type	= s_data.sweep_type;
		
		version		= s_data.version;

		if(version > E_SWEEP_VERSION_ORIGINAL)
		{
			CArchiveFile >> CValueList; 
		}
	}
}

bool TCSweepData::CreateValueList(void)
{
	if(type > E_PARAMETER_SWEEP_TYPE_LINEAR) return false;
	
	double data_value = 0;

	if(!GetFirstValue(data_value)) return false;

	CValueList = FloatToMKSString(data_value);

	int count = GetCount();//
	
	if(count > 1000)
	{
		if(AfxMessageBox(IDS_STRING_LARGE_RERUN_COUNT, MB_YESNO) != IDYES) return false;	
	}

	for(int p = 0; p < count; p++)
	{	
		if(!GetNextValue(data_value)) break;

		CValueList += " " + FloatToMKSString(data_value);
	}

	return true;
}

bool TCSweepData::GetFirstValue(double &value)
{
	value = start;

	if(!step) step = 1;

	if(step >= 0)// lin only, log to do
	{
		if(stop < start) return false;
	}
	else
	{
		if(start < stop) return false;
	}

	if(type == E_PARAMETER_SWEEP_TYPE_DEC || type == E_PARAMETER_SWEEP_TYPE_OCT) 
	{
		if(start <= 0) start = 1;// eliminate log(0) errors
		if(stop <= 0) stop  = 1;
		if(step <= 0)  step	 = 1;
	}

	if(type == E_PARAMETER_SWEEP_TYPE_LIST)// Overide above added Jan 2017
	{
		CString CWord;

		CWord = GetWord(CValueList, 1);

		value =  SpiceMKSStringToFloat(CWord); 
	}

	index = 1;

	return true;
}

bool TCSweepData::GetNextValue(double &value)
{
	if(!step) step = 1;

	if(type == E_PARAMETER_SWEEP_TYPE_LINEAR)// Id of radio buttons
	{
		value = start + index * step;

		if(step >= 0)
		{
			if(stop < start) return false; 

			if(stop < value) return false;
		}
		else
		{
			if(start < stop) return false;

			if(stop > value) return false;
		}
	}
	else if(type == E_PARAMETER_SWEEP_TYPE_OCT) value = start * pow(2, index/step);

	else value = start * pow(10, index/step);

	index++;

	if(type == E_PARAMETER_SWEEP_TYPE_LIST)// Overide added above Jan 2017
	{
		CString CWord;

		CWord = GetWord(CValueList, index);

		value =  SpiceMKSStringToFloat(CWord); 
	}

	return true;
}

int TCSweepData::GetCount(void)
{
	if(!step) step = 1;

	if(type == E_PARAMETER_SWEEP_TYPE_EXTERNAL_FILE) return 0;//File speced

	if(step >= 0)
	{
		if(stop < start) return 0;
	}
	else
	{
		if(start < stop) return 0;
	}

	double count = 0;

	if(type == E_PARAMETER_SWEEP_TYPE_LINEAR)
	{
		count = (stop - start)/step + 1;
	}
	else if(type == E_PARAMETER_SWEEP_TYPE_DEC)
	{
		if(!start) start = 1;

		count = (int)(step * Log(stop/start)/Log(10));
	}
	else if(type == E_PARAMETER_SWEEP_TYPE_OCT)
	{
		if(!start) start = 1;

		count = (int)(step * Log(stop/start)/Log(2));
	}
	else // list
	{
		count = CountWords(CValueList);
	}

	if(count < 0) count = -count;

	return (int) count;
}

////////////////////////////////
TCACSetupData::TCACSetupData()
{	
	CSweepData.start	= 10;
	CSweepData.stop		= 100e6;
	CSweepData.step		= 50;
	CSweepData.type		= E_PARAMETER_SWEEP_TYPE_LINEAR;
	CSweepData.enable	= true;
	enable_print_all	= false;
	enable_plot_all		= false;
}
TCACSetupData::TCACSetupData(TCACSetupData &CACSetupData)
{
	*this = CACSetupData;
}

TCACSetupData::~TCACSetupData()
{

}

void TCACSetupData::CopyGlobal(TCACSetupData &CACSetupData)
{
	CSweepData = CACSetupData.CSweepData;
	
	enable_print_all	= CACSetupData.enable_print_all;
	enable_plot_all		= CACSetupData.enable_plot_all;
}

void TCACSetupData::CopyUnGlobal(TCACSetupData &CSetupSource)
{
	CSetupSource;
}

void TCACSetupData::operator = (TCACSetupData &CACSetupData)
{
	CSweepData = CACSetupData.CSweepData;
	
	enable_print_all	= CACSetupData.enable_print_all;
	enable_plot_all		= CACSetupData.enable_plot_all;
}

void TCACSetupData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	CSweepData.Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile <<	enable_print_all;
		CArchiveFile <<	enable_plot_all;
	}
	else
	{
		CArchiveFile >>	enable_print_all;
		CArchiveFile >>	enable_plot_all;
	}
}
/////////////////////////////////
TCDCSetupData::TCDCSetupData(void)
{
	CSweepData1.start	= 0;
	CSweepData1.stop	= 5;
	CSweepData1.step	= 10e-3;
	CSweepData1.type	= 1;
	CSweepData1.enable	= false;

	CSweepData2.start	= 0;
	CSweepData2.stop	= 5;
	CSweepData2.step	= 10e-3;
	CSweepData2.type	= 1;
	CSweepData2.enable	= false;
	enable_print_all	= false;
	enable_plot_all		= false;
	enable_operating_point = true;
	display_device_op_points = false;
}

TCDCSetupData::TCDCSetupData(TCDCSetupData &CDCSetupData)
{
	*this = CDCSetupData;
}
TCDCSetupData::~TCDCSetupData(void)
{

}

void TCDCSetupData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	CSweepData1.Serialize(CArchiveFile);
	CSweepData2.Serialize(CArchiveFile);

	int op_point, temp_enable_operating_point;

	if(CArchiveFile.IsStoring())
	{
		temp_enable_operating_point = enable_operating_point | (display_device_op_points << 1);// Bodge use of existing data

		CArchiveFile << CSource1;
		CArchiveFile << CSource2;
		CArchiveFile <<	enable_print_all;
		CArchiveFile <<	enable_plot_all;
		CArchiveFile <<	temp_enable_operating_point;
	}
	else
	{
		CArchiveFile >> CSource1;
		CArchiveFile >> CSource2;
		CArchiveFile >>	enable_print_all;
		CArchiveFile >>	enable_plot_all;
//		CArchiveFile >>	enable_operating_point; 
		
		CArchiveFile >>	op_point; 

		enable_operating_point		= 1 & op_point;

		display_device_op_points	= 2 & op_point;
	}
}

void TCDCSetupData::CopyGlobal(TCDCSetupData &CDCSetupData)
{
	CSweepData1 = CDCSetupData.CSweepData1;
	CSweepData2 = CDCSetupData.CSweepData2;

	enable_print_all		= CDCSetupData.enable_print_all;
	enable_plot_all			= CDCSetupData.enable_plot_all;
	enable_operating_point	= CDCSetupData.enable_operating_point;
	display_device_op_points		= CDCSetupData.display_device_op_points;
}

void TCDCSetupData::CopyUnGlobal(TCDCSetupData &CSetupSource)
{
	CSetupSource;
}
void TCDCSetupData::operator = (TCDCSetupData &CDCSetupData)
{
	CSweepData1 = CDCSetupData.CSweepData1;
	CSweepData2 = CDCSetupData.CSweepData2;
	CSource1	= CDCSetupData.CSource1;
	CSource2	= CDCSetupData.CSource2;
	enable_print_all	= CDCSetupData.enable_print_all;
	enable_plot_all		= CDCSetupData.enable_plot_all;
	enable_operating_point = CDCSetupData.enable_operating_point;
	display_device_op_points		= CDCSetupData.display_device_op_points;
}

////////////////////////
TCStatisticsSetupData::TCStatisticsSetupData()
{
	enable = false;
}
TCStatisticsSetupData::TCStatisticsSetupData(TCStatisticsSetupData &CStatisticsSetupData)
{
	*this = CStatisticsSetupData;
}

TCStatisticsSetupData::~TCStatisticsSetupData()
{

}

void TCStatisticsSetupData::CopyGlobal(TCStatisticsSetupData &CStatisticsSetupData)
{
	enable = CStatisticsSetupData.enable;
}

void TCStatisticsSetupData::CopyUnGlobal(TCStatisticsSetupData &CSetupSource)
{
	CSetupSource;
}
void TCStatisticsSetupData::operator = (TCStatisticsSetupData &CStatisticsSetupData)
{
	enable		= CStatisticsSetupData.enable;
	CReserved	= CStatisticsSetupData.CReserved;
}

void TCStatisticsSetupData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);
	CReserved.Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << enable;

	}
	else
	{
		CArchiveFile >> enable;

	}
}
/////////////////////////////////


////////////////////////////////////
TCSensitivitySetupData::TCSensitivitySetupData(void)
{
	enable_dc			= false;
	enable_ac			= false;
	dc_output_index		= 0;
	ac_output_index		= 0;
	enable_print_all	= false;
	enable_plot_all		= false;
}
TCSensitivitySetupData::TCSensitivitySetupData(TCSensitivitySetupData &CSensitivitySetupData)
{
	*this = CSensitivitySetupData;
}
TCSensitivitySetupData::~TCSensitivitySetupData(void)
{

}

void TCSensitivitySetupData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << enable_ac;
		CArchiveFile << enable_dc;
		CArchiveFile << dc_output_index;
		CArchiveFile << ac_output_index;
		CArchiveFile <<	enable_print_all;
		CArchiveFile <<	enable_plot_all;
		CArchiveFile << COutput;
		CArchiveFile << CStaticOutput;
		CArchiveFile << CSpiceOutputName;
	}
	else
	{
		CArchiveFile >> enable_ac;
		CArchiveFile >> enable_dc;
		CArchiveFile >> dc_output_index;
		CArchiveFile >> ac_output_index;
		CArchiveFile >>	enable_print_all;
		CArchiveFile >>	enable_plot_all;
		CArchiveFile >> COutput;
		CArchiveFile >> CStaticOutput;
		CArchiveFile >> CSpiceOutputName;
	}
}

void TCSensitivitySetupData::CopyGlobal(TCSensitivitySetupData &CSensitivitySetupData)
{
	enable_ac			= CSensitivitySetupData.enable_ac;
	enable_dc			= CSensitivitySetupData.enable_dc;

	enable_print_all	= CSensitivitySetupData.enable_print_all;
	enable_plot_all		= CSensitivitySetupData.enable_plot_all;
}

void TCSensitivitySetupData::CopyUnGlobal(TCSensitivitySetupData &CSetupSource)
{
	CSetupSource;
}

void TCSensitivitySetupData::operator = (TCSensitivitySetupData &CSensitivitySetupData)
{
	enable_ac			= CSensitivitySetupData.enable_ac;
	enable_dc			= CSensitivitySetupData.enable_dc;
	dc_output_index		= CSensitivitySetupData.dc_output_index;
	ac_output_index		= CSensitivitySetupData.ac_output_index;
	CSpiceOutputName	= CSensitivitySetupData.CSpiceOutputName;
	COutput				= CSensitivitySetupData.COutput;
	CStaticOutput		= CSensitivitySetupData.CStaticOutput;
	enable_print_all	= CSensitivitySetupData.enable_print_all;
	enable_plot_all		= CSensitivitySetupData.enable_plot_all;
}
///////////////////////////////////////
TCTemperatureSetupData::TCTemperatureSetupData(void)
{
	CSweepData.start	= 0;
	CSweepData.stop		= 70;
	CSweepData.step		= 10;
	CSweepData.type		= 1;
	CSweepData.enable	= false;
	CSweepData.sweep_type = E_TEMPERATURE_SWEEP_VOLTS_V_TEMP;
}

TCTemperatureSetupData::TCTemperatureSetupData(TCTemperatureSetupData &CTemperatureSetupData)
{
	*this = CTemperatureSetupData;
}
TCTemperatureSetupData::~TCTemperatureSetupData(void)
{

}

void TCTemperatureSetupData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	CSweepData.Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
	}
	else
	{
		CSweepData.sweep_type = E_TEMPERATURE_SWEEP_VOLTS_V_TEMP;// overide all stored verions. Parameters now does multi sweep.
	}
}

void TCTemperatureSetupData::operator = (TCTemperatureSetupData &CTemperatureSetupData)
{
	CSweepData	= CTemperatureSetupData.CSweepData;
}

bool TCTemperatureSetupData::GetFirstValue(double &value)
{
	return CSweepData.GetFirstValue(value);
}

bool TCTemperatureSetupData::GetNextValue(double &value)
{
	return CSweepData.GetNextValue(value);
}

int TCTemperatureSetupData::GetCount(void)
{
	return CSweepData.GetCount();
}
//////////////////////////////////////////
TCSpiceOptionsData::TCSpiceOptionsData(void)
{
	CType		= "(Null)";
	SpiceName	= "(Null)";
	m_include	= false;

}
TCSpiceOptionsData::TCSpiceOptionsData(TCSpiceOptionsData &TCSpiceOptionsData)
{
	*this = TCSpiceOptionsData;
}
TCSpiceOptionsData::~TCSpiceOptionsData(void)
{

}

void TCSpiceOptionsData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CType;
		CArchiveFile << CValue;
		CArchiveFile << SpiceName;
		CArchiveFile << value;
		CArchiveFile << m_include;
	}
	else
	{
		CArchiveFile >> CType;
		CArchiveFile >> CValue;
		CArchiveFile >> SpiceName;
		CArchiveFile >> value;
		CArchiveFile >> m_include;
	}
}
void TCSpiceOptionsData::operator = (TCSpiceOptionsData &CSpiceOptionsData)
{
	CType		= CSpiceOptionsData.CType;
	CValue		= CSpiceOptionsData.CValue;
	SpiceName	= CSpiceOptionsData.SpiceName;
	value		= CSpiceOptionsData.value;
	m_include	= CSpiceOptionsData.m_include;
}
///////////////////////////////////////////
TCBerklySpiceOptionsSetupData::TCBerklySpiceOptionsSetupData(void)
{

}

TCBerklySpiceOptionsSetupData::TCBerklySpiceOptionsSetupData(TCBerklySpiceOptionsSetupData &CBerklySpiceOptionsSetupData)
{
	*this = CBerklySpiceOptionsSetupData;
}
TCBerklySpiceOptionsSetupData::~TCBerklySpiceOptionsSetupData(void)
{

}

void TCBerklySpiceOptionsSetupData::Setup(void)
{
	COptionsFloatData.SetSize(TE_MAX_OPTIONS_FLOAT, TE_MAX_OPTIONS_FLOAT);

	COptionsFloatData[E_OPTIONS_ABSTOL].value	= 1e-12;
	COptionsFloatData[E_OPTIONS_ABSTOL].CType.LoadString(E_SPICE_OPTIONS_ABSTOL);
	COptionsFloatData[E_OPTIONS_ABSTOL].SpiceName = "ABSTOL";

	COptionsFloatData[E_OPTIONS_CHG_TOL].value	= 1e-15;
	COptionsFloatData[E_OPTIONS_CHG_TOL].CType.LoadString(E_SPICE_OPTIONS_CHG_TOL);
	COptionsFloatData[E_OPTIONS_CHG_TOL].SpiceName = "CHGTOL";

	COptionsFloatData[E_OPTIONS_DEFAD].value	= 0.0;
	COptionsFloatData[E_OPTIONS_DEFAD].CType.LoadString(E_SPICE_OPTIONS_DFAD);
	COptionsFloatData[E_OPTIONS_DEFAD].SpiceName = "DEFAD";
	COptionsFloatData[E_OPTIONS_DEFAS].value	= 0.0; 
	COptionsFloatData[E_OPTIONS_DEFAS].CType.LoadString(E_SPICE_OPTIONS_IDFAS);
	COptionsFloatData[E_OPTIONS_DEFAS].SpiceName = "DEFAS";
	COptionsFloatData[E_OPTIONS_DEFL].value		= 100.0e-6;
	COptionsFloatData[E_OPTIONS_DEFL].CType.LoadString(E_SPICE_OPTIONS_DEFL);
	COptionsFloatData[E_OPTIONS_DEFL].SpiceName = "DEFL";

	COptionsFloatData[E_OPTIONS_DEFW].value		= 100.0e-6;
	COptionsFloatData[E_OPTIONS_DEFW].CType.LoadString(E_SPICE_OPTIONS_DEFW);
	COptionsFloatData[E_OPTIONS_DEFW].SpiceName = "DEFW";

	COptionsFloatData[E_OPTIONS_GMIN].value		= 10e-12;
	COptionsFloatData[E_OPTIONS_GMIN].CType.LoadString(E_SPICE_OPTIONS_GMIN);
	COptionsFloatData[E_OPTIONS_GMIN].SpiceName = "GMIN";
	COptionsFloatData[E_OPTIONS_GMIN].m_include = true;

	COptionsFloatData[E_OPTIONS_ITL1].value		= 5000;
	COptionsFloatData[E_OPTIONS_ITL1].CType.LoadString(E_SPICE_OPTIONS_ITL1);
	COptionsFloatData[E_OPTIONS_ITL1].SpiceName = "ITL1";
	COptionsFloatData[E_OPTIONS_ITL1].m_include = true;

	COptionsFloatData[E_OPTIONS_ITL2].value		= 5000;
	COptionsFloatData[E_OPTIONS_ITL2].CType.LoadString(E_SPICE_OPTIONS_ITL2);
	COptionsFloatData[E_OPTIONS_ITL2].SpiceName = "ITL2";
	COptionsFloatData[E_OPTIONS_ITL2].m_include = true;

	COptionsFloatData[E_OPTIONS_ITL3].value		= 100;
	COptionsFloatData[E_OPTIONS_ITL3].CType.LoadString(E_SPICE_OPTIONS_ITL3);
	COptionsFloatData[E_OPTIONS_ITL3].SpiceName = "ITL3";

	COptionsFloatData[E_OPTIONS_ITL4].value		= 20;
	COptionsFloatData[E_OPTIONS_ITL4].CType.LoadString(E_SPICE_OPTIONS_ITL4);
	COptionsFloatData[E_OPTIONS_ITL4].SpiceName = "ITL4";
	COptionsFloatData[E_OPTIONS_ITL4].m_include = true;

	COptionsFloatData[E_OPTIONS_ITL5].value		= 0;
	COptionsFloatData[E_OPTIONS_ITL5].CType.LoadString(E_SPICE_OPTIONS_ITL5);
	COptionsFloatData[E_OPTIONS_ITL5].SpiceName = "ITL5";

	COptionsFloatData[E_OPTIONS_ITL6].value		= 0;
	COptionsFloatData[E_OPTIONS_ITL6].CType.LoadString(E_SPICE_OPTIONS_ITL6);
	COptionsFloatData[E_OPTIONS_ITL6].SpiceName = "ITL6";

	COptionsFloatData[E_OPTIONS_TRTOL].value	= 7.0;
	COptionsFloatData[E_OPTIONS_TRTOL].CType.LoadString(E_SPICE_OPTIONS_TRANTOL);	
	COptionsFloatData[E_OPTIONS_TRTOL].SpiceName = "TRTOL";
	COptionsFloatData[E_OPTIONS_PIVREL].value	= 1e-3;
	COptionsFloatData[E_OPTIONS_PIVREL].CType.LoadString(E_SPICE_OPTIONS_PIV_REL);
	COptionsFloatData[E_OPTIONS_PIVREL].SpiceName = "PIVREL";
	COptionsFloatData[E_OPTIONS_PIVTOL].value	= 1e-13;
	COptionsFloatData[E_OPTIONS_PIVTOL].CType.LoadString(E_SPICE_OPTIONS_PIV_TOL);
	COptionsFloatData[E_OPTIONS_PIVTOL].SpiceName = "PIVTOL";
	COptionsFloatData[E_OPTIONS_REL_TOL].value	= 1e-3;
	COptionsFloatData[E_OPTIONS_REL_TOL].CType.LoadString(E_SPICE_OPTIONS_REL_TOL);
	COptionsFloatData[E_OPTIONS_REL_TOL].SpiceName = "RELTOL";
	COptionsFloatData[E_OPTIONS_TNOM].value		= 27;
	COptionsFloatData[E_OPTIONS_TNOM].CType.LoadString(E_SPICE_OPTIONS_TNOM);
	COptionsFloatData[E_OPTIONS_TNOM].SpiceName = "TNOM";
	COptionsFloatData[E_OPTIONS_TEMP].value		= 27;
	COptionsFloatData[E_OPTIONS_TEMP].CType.LoadString(E_SPICE_OPTIONS_TEMP);
	COptionsFloatData[E_OPTIONS_TEMP].SpiceName = "TEMP";
	COptionsFloatData[E_OPTIONS_TEMP].m_include = true;
	COptionsFloatData[E_OPTIONS_VNTOL].value	= 1e-6;
	COptionsFloatData[E_OPTIONS_VNTOL].CType.LoadString(E_SPICE_OPTIONS_VN_TOL);
	COptionsFloatData[E_OPTIONS_VNTOL].SpiceName = "VNTOL";

	COptionsFloatData[E_OPTIONS_GEAR_ORDER].value	= 2;
	COptionsFloatData[E_OPTIONS_GEAR_ORDER].CType.LoadString(E_SPICE_OPTIONS_GEAR_ORDER);
	COptionsFloatData[E_OPTIONS_GEAR_ORDER].SpiceName = "ORDER";

	COptionsFloatData[E_OPTIONS_GMINSTEPPING].value	= 1000;
	COptionsFloatData[E_OPTIONS_GMINSTEPPING].CType.LoadString(E_SPICE_OPTIONS_GMIN_STEPING);
	COptionsFloatData[E_OPTIONS_GMINSTEPPING].SpiceName = "GMINSTEPS";
	COptionsFloatData[E_OPTIONS_GMINSTEPPING].m_include = true;

	COptionsFloatData[E_OPTIONS_SOURCE_STEPPING].value	= 5000;
	COptionsFloatData[E_OPTIONS_SOURCE_STEPPING].CType.LoadString(E_SPICE_OPTIONS_SOURCE_STEPING);
	COptionsFloatData[E_OPTIONS_SOURCE_STEPPING].SpiceName = "SRCSTEPS";
	COptionsFloatData[E_OPTIONS_SOURCE_STEPPING].m_include = true;

	COptionsFloatData[E_OPTIONS_RAMP_TIME].value	= 1e-10;
	COptionsFloatData[E_OPTIONS_RAMP_TIME].CType.LoadString(E_SPICE_OPTIONS_RAMP_TIME);
	COptionsFloatData[E_OPTIONS_RAMP_TIME].SpiceName = "RAMPTIME";

	COptionsFloatData[E_OPTIONS_MAX_OP_ALTER].value	= 1000;
	COptionsFloatData[E_OPTIONS_MAX_OP_ALTER].CType.LoadString(E_SPICE_OPTIONS_MAX_OP_ALTER);
	COptionsFloatData[E_OPTIONS_MAX_OP_ALTER].SpiceName = "MAXOPALTER";

	COptionsFloatData[E_OPTIONS_MAX_EVT_ITER].value	= 1000;
	COptionsFloatData[E_OPTIONS_MAX_EVT_ITER].CType.LoadString(E_SPICE_OPTIONS_MAX_EVT_ITER);
	COptionsFloatData[E_OPTIONS_MAX_EVT_ITER].SpiceName = "MAXEVTITER";

	COptionsFloatData[E_OPTIONS_CONV_STEP].value	= 0.01;
	COptionsFloatData[E_OPTIONS_CONV_STEP].CType.LoadString(E_SPICE_OPTIONS_CONV_STEP);
	COptionsFloatData[E_OPTIONS_CONV_STEP].SpiceName = "CONVSTEP";

	COptionsFloatData[E_OPTIONS_CONV_ABS_STEP].value	= 1e-6;
	COptionsFloatData[E_OPTIONS_CONV_ABS_STEP].CType.LoadString(E_SPICE_OPTIONS_CONV_ABS_STEP);
	COptionsFloatData[E_OPTIONS_CONV_ABS_STEP].SpiceName = "CONVABSSTEP";

	COptionsFloatData[E_OPTIONS_DESIGNER_VOLTAGE_ACCURACY].value	= 1;
	COptionsFloatData[E_OPTIONS_DESIGNER_VOLTAGE_ACCURACY].CType.LoadString(E_SPICE_OPTIONS_DESIGNER_VOLTAGE_ACCURACY);
	COptionsFloatData[E_OPTIONS_DESIGNER_VOLTAGE_ACCURACY].SpiceName = "ssdesv";

	COptionsFloatData[E_OPTIONS_DESIGNER_CURRENT_ACCURACY].value	= 10000;
	COptionsFloatData[E_OPTIONS_DESIGNER_CURRENT_ACCURACY].CType.LoadString(E_SPICE_OPTIONS_DESIGNER_CURRENT_ACCURACY);
	COptionsFloatData[E_OPTIONS_DESIGNER_CURRENT_ACCURACY].SpiceName = "ssdesi";

	COptionsFloatData[E_OPTIONS_FLOAT_DATA].value	= 1;
	COptionsFloatData[E_OPTIONS_FLOAT_DATA].CType.LoadString(E_SPICE_OPTIONS_FLOAT_DATA);
	COptionsFloatData[E_OPTIONS_FLOAT_DATA].SpiceName = "floatdata";
	COptionsFloatData[E_OPTIONS_FLOAT_DATA].m_include = true;

	COptionsFloatData[E_OPTIONS_SIM_WAIT_TIME].value	= 0;
	COptionsFloatData[E_OPTIONS_SIM_WAIT_TIME].CType.LoadString(E_SPICE_OPTIONS_SIM_WAIT_TIME);
	COptionsFloatData[E_OPTIONS_SIM_WAIT_TIME].SpiceName = "simwaittime";
	
	//realtimemode 0=file only, 1=file and coms, coms only

	COptionsStringData.SetSize(TE_MAX_OPTIONS_STRING, TE_MAX_OPTIONS_STRING);

	COptionsStringData[E_OPTIONS_BADMOS3].CType.LoadString(E_SPICE_OPTIONS_BADMOS3);
	COptionsStringData[E_OPTIONS_BADMOS3].SpiceName	= " BADMOS3";

	COptionsStringData[E_OPTIONS_KEEPOPINFO].CType.LoadString(E_SPICE_OPTIONS_KEEPOPINFO); 
	COptionsStringData[E_OPTIONS_KEEPOPINFO].SpiceName	= "KEEPOPINFO";

	COptionsStringData[E_OPTIONS_METHOD].CValue		= "GEAR";
	COptionsStringData[E_OPTIONS_METHOD].CType.LoadString(E_SPICE_OPTIONS_METHOD);
	COptionsStringData[E_OPTIONS_METHOD].SpiceName		= "METHOD";

	COptionsStringData[E_OPTIONS_LIST].CType.LoadString(E_SPICE_OPTIONS_LIST);
	COptionsStringData[E_OPTIONS_LIST].SpiceName = "LIST";

	COptionsStringData[E_TRYTOCOMPACT].CType.LoadString(E_SPICE_OPTIONS_TRYTOCOMPACT);
	COptionsStringData[E_TRYTOCOMPACT].SpiceName = "TRYTOCOMPACT";

	COptionsStringData[E_OPTIONS_ACCT].CType.LoadString(E_SPICE_OPTIONS_ACCT); 
	COptionsStringData[E_OPTIONS_ACCT].SpiceName = "ACCT";
	
	COptionsStringData[E_OPTIONS_NOMOD].CType.LoadString(E_SPICE_OPTIONS_NOMOD);
	COptionsStringData[E_OPTIONS_NOMOD].SpiceName = "NOMOD";

	COptionsStringData[E_OPTIONS_NOPAGE].CType.LoadString(E_SPICE_OPTIONS_NOPAGE);
	COptionsStringData[E_OPTIONS_NOPAGE].SpiceName = "NOPAGE";

	COptionsStringData[E_OPTIONS_NODE].CType.LoadString(E_SPICE_OPTIONS_NODE);
	COptionsStringData[E_OPTIONS_NODE].SpiceName = "NODE";

	COptionsStringData[E_OPTIONS_OPTS].CType.LoadString(E_SPICE_OPTIONS_OPTS);
	COptionsStringData[E_OPTIONS_OPTS].SpiceName = "OPTS";

	COptionsStringData[E_OPTIONS_RSHUNT].CType.LoadString(E_SPICE_OPTIONS_RSHUNT);
	COptionsStringData[E_OPTIONS_RSHUNT].SpiceName = "RSHUNT";
	COptionsStringData[E_OPTIONS_RSHUNT].CValue		= "100Meg";

	COptionsStringData[E_OPTIONS_PSPICE_PROBE].CType.LoadString(E_SPICE_OPTIONS_PSPICE_PROBE);
	COptionsStringData[E_OPTIONS_PSPICE_PROBE].SpiceName = ".PROBE";

	COptionsStringData[E_OPTIONS_NO_OP_ALTER].CType.LoadString(E_SPICE_OPTIONS_NO_OP_ALTER);
	COptionsStringData[E_OPTIONS_NO_OP_ALTER].SpiceName = "NOOPALTER";
	COptionsStringData[E_OPTIONS_NO_OP_ALTER].CValue	= "FALSE";

	COptionsStringData[E_OPTIONS_CONV_LIMIT].CType.LoadString(E_SPICE_OPTIONS_CONV_LIMIT);
	COptionsStringData[E_OPTIONS_CONV_LIMIT].SpiceName = "CONVLIMIT";

	COptionsFloatData[E_OPTIONS_VARGMIN].value		= 1;
	COptionsFloatData[E_OPTIONS_VARGMIN].CType.LoadString(E_SPICE_OPTIONS_VARGMIN);
	COptionsFloatData[E_OPTIONS_VARGMIN].SpiceName = "VARGMIN";
	COptionsFloatData[E_OPTIONS_VARGMIN].m_include = true;

	last_string_option_selected = 0;
	last_float_option_selected	= 0;
	tran_nodeset				= 0;
}

void TCBerklySpiceOptionsSetupData::RemoveFloat(CString CText)
{
	int p, count;

	count = COptionsFloatData.GetSize();

	for(p = 0; p < count; p++)
	{
		if(CText != COptionsFloatData[p].SpiceName) continue;

		COptionsFloatData.RemoveAt(p);

		return;
	}
}
void TCBerklySpiceOptionsSetupData::RemoveString(CString CText)
{
	int p, count;

	count = COptionsStringData.GetSize();

	for(p = 0; p < count; p++)
	{
		if(CText != COptionsStringData[p].SpiceName) continue;

		COptionsStringData.RemoveAt(p);

		return;
	}
}
void TCBerklySpiceOptionsSetupData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	int count, p;

	struct sdata
	{
		short float_option:16;
		short tran_nodeset:16;
	} ;

	sdata data;

	if(CArchiveFile.IsStoring())
	{
	//	CArchiveFile << data;//last_float_option_selected;

		data.float_option = last_float_option_selected;
		data.tran_nodeset = tran_nodeset;

		CArchiveFile.Write(&data, sizeof(data));

		CArchiveFile << last_string_option_selected;

		count = COptionsStringData.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) COptionsStringData[p].Serialize(CArchiveFile);

		count = COptionsFloatData.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) COptionsFloatData[p].Serialize(CArchiveFile);
	}
	else
	{
		Setup();//LoadString not functioning on construction

	//	CArchiveFile >> last_float_option_selected;

		CArchiveFile.Read(&data, sizeof(data));

		last_float_option_selected = data.float_option;

		tran_nodeset = !!data.tran_nodeset;

		CArchiveFile >> last_string_option_selected;

		CArchiveFile >> count;

		int size = COptionsStringData.GetSize();
	
		if(count > size)// keep original
			COptionsStringData.SetSize(count, count);

		for(p = 0; p < count; p++) COptionsStringData[p].Serialize(CArchiveFile);

		CArchiveFile >> count;

		size = COptionsFloatData.GetSize();

		if(count > size)// keep original
			COptionsFloatData.SetSize(count, count);

		for(p = 0; p < count; p++) COptionsFloatData[p].Serialize(CArchiveFile);
	}
}
void TCBerklySpiceOptionsSetupData::operator = (TCBerklySpiceOptionsSetupData &CBerklySpiceOptionsSetupData)
{
	last_string_option_selected = CBerklySpiceOptionsSetupData.last_string_option_selected;
	last_float_option_selected  = CBerklySpiceOptionsSetupData.last_float_option_selected;
	tran_nodeset				= CBerklySpiceOptionsSetupData.tran_nodeset;

	int count = CBerklySpiceOptionsSetupData.COptionsStringData.GetSize();

	COptionsStringData.SetSize(count, count);

	int p;

	for(p = 0; p < count; p++)
	{
		COptionsStringData[p] = CBerklySpiceOptionsSetupData.COptionsStringData[p];
	}

	count = CBerklySpiceOptionsSetupData.COptionsFloatData.GetSize();

	COptionsFloatData.SetSize(count, count);

	for(p = 0; p < count; p++)
	{
		COptionsFloatData[p] = CBerklySpiceOptionsSetupData.COptionsFloatData[p];
	}
}

//////////////////////////////

/////////////////////
TCTransientSetupData::TCTransientSetupData(void)
{
	
	CSweepData.start	= 0;
	CSweepData.stop		= (float)1e-3;
	CSweepData.step		= (float)10e-6;
	CSweepData.type		= 0;// ignored
	CSweepData.enable	= false;
	max_compute_step_size = (float)10e-6;
	frequency			= 1e6;
	fourier_enable		= false;
	output_index		= 0;
	enable_print_all	= false;
	enable_plot_all		= false;
	enable_print_all_fourier = false;
	enable_plot_all_fourier = false;
	use_initial_conditions = false;
	max_calc_is_print_time = true;
	linearize_transient_data = false;
	enable_marching_waveforms = false;
	full_scale_marching_xaxis = true;
	enable_real_time_changes = false;// 

	m_loaded_version = GetRuntimeClass()->m_wSchema;
}

TCTransientSetupData::TCTransientSetupData(TCTransientSetupData &CTransientSetupData)
{
	*this = CTransientSetupData;
}
TCTransientSetupData::~TCTransientSetupData(void)
{

}

void TCTransientSetupData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	CSweepData.Serialize(CArchiveFile);

	int dummy = enable_plot_all_fourier;

	int local_data = 0;

	if(CArchiveFile.IsStoring())
	{
		// schema stuff is shit. so fudged it

		if(use_initial_conditions)	local_data = E_TRANSIENT_SETUP_USE_INITIAL_CONDITION;
		if(max_calc_is_print_time)	local_data |= E_TRANSIENT_SETUP_MAX_CALC_IS_PRINT_TIME;
		if(linearize_transient_data)local_data |= E_TRANSIENT_SETUP_LINEARIZE_TRANSIENT_DATA;
		if(enable_marching_waveforms)local_data |= E_TRANSIENT_SETUP_ENABLE_MARCHING_WAVEFORMS;
		if(full_scale_marching_xaxis) local_data |= E_TRANSIENT_SETUP_MARCHING_XAXIS;
		if(enable_real_time_changes) local_data |= E_TRANSIENT_SETUP_ENABLE_REAL_TIME;

		if(enable_plot_all_fourier == 1) dummy = 2;// tells me this is the latest version!
		else dummy = -2;
		
		CArchiveFile << frequency;
		CArchiveFile << max_compute_step_size;
		CArchiveFile << fourier_enable;
		CArchiveFile << output_index;
		CArchiveFile << COutput;	
		CArchiveFile << CSpiceOutputName;
		CArchiveFile <<	enable_print_all;
		CArchiveFile <<	enable_plot_all;
		CArchiveFile <<	enable_print_all_fourier;
		CArchiveFile <<	dummy;
		CArchiveFile <<	local_data;
	}
	else
	{
		CArchiveFile >> frequency;
		CArchiveFile >> max_compute_step_size;
		CArchiveFile >> fourier_enable;
		CArchiveFile >> output_index;
		CArchiveFile >> COutput;
		CArchiveFile >> CSpiceOutputName;
		CArchiveFile >>	enable_print_all;
		CArchiveFile >>	enable_plot_all;
		CArchiveFile >>	enable_print_all_fourier;
		CArchiveFile >>	dummy;

		if(dummy == 2 || dummy == -2)// latest version, so read it in
		{
			CArchiveFile >>	local_data;

			if(dummy == 2) enable_plot_all_fourier = 1;
			else enable_plot_all_fourier = 0;

			if(local_data & E_TRANSIENT_SETUP_USE_INITIAL_CONDITION) use_initial_conditions = true;
			else use_initial_conditions = false;
			
			if(local_data & E_TRANSIENT_SETUP_MAX_CALC_IS_PRINT_TIME) max_calc_is_print_time = true;
			else max_calc_is_print_time = false;

			if(local_data & E_TRANSIENT_SETUP_LINEARIZE_TRANSIENT_DATA) linearize_transient_data = true;
			else linearize_transient_data = false;

			if(local_data & E_TRANSIENT_SETUP_ENABLE_MARCHING_WAVEFORMS) enable_marching_waveforms = true;
			else enable_marching_waveforms = false;

			if(local_data & E_TRANSIENT_SETUP_MARCHING_XAXIS) full_scale_marching_xaxis = true;
			else full_scale_marching_xaxis = false;

			if(local_data & E_TRANSIENT_SETUP_ENABLE_REAL_TIME) enable_real_time_changes = true;
			else enable_real_time_changes = false;					
		}
	}
}

void TCTransientSetupData::CopyGlobal(TCTransientSetupData &CTransientSetupData)
{
	CSweepData		= CTransientSetupData.CSweepData;
	frequency		= CTransientSetupData.frequency;
	max_compute_step_size = CTransientSetupData.max_compute_step_size;
	fourier_enable	= CTransientSetupData.fourier_enable;

	enable_print_all	= CTransientSetupData.enable_print_all;
	enable_plot_all		= CTransientSetupData.enable_plot_all;
	enable_print_all_fourier = CTransientSetupData.enable_print_all_fourier;
	enable_plot_all_fourier = CTransientSetupData.enable_plot_all_fourier;
	use_initial_conditions = CTransientSetupData.use_initial_conditions;
	max_calc_is_print_time = CTransientSetupData.max_calc_is_print_time;
	linearize_transient_data = CTransientSetupData.linearize_transient_data;
	enable_marching_waveforms	= CTransientSetupData.enable_marching_waveforms;
	full_scale_marching_xaxis = CTransientSetupData.full_scale_marching_xaxis;
	enable_real_time_changes  = CTransientSetupData.enable_real_time_changes;


	m_loaded_version = CTransientSetupData.m_loaded_version;
}

void TCTransientSetupData::CopyUnGlobal(TCTransientSetupData &CSetupSource)
{
	CSetupSource;
}

void TCTransientSetupData::operator = (TCTransientSetupData &CTransientSetupData)
{
	CSweepData		= CTransientSetupData.CSweepData;
	frequency		= CTransientSetupData.frequency;
	max_compute_step_size = CTransientSetupData.max_compute_step_size;
	fourier_enable	= CTransientSetupData.fourier_enable;
	output_index		= CTransientSetupData.output_index;
	CSpiceOutputName = CTransientSetupData.CSpiceOutputName;
	COutput			= CTransientSetupData.COutput;
	enable_print_all	= CTransientSetupData.enable_print_all;
	enable_plot_all		= CTransientSetupData.enable_plot_all;
	enable_print_all_fourier = CTransientSetupData.enable_print_all_fourier;
	enable_plot_all_fourier = CTransientSetupData.enable_plot_all_fourier;
	use_initial_conditions = CTransientSetupData.use_initial_conditions;
	max_calc_is_print_time = CTransientSetupData.max_calc_is_print_time;
	linearize_transient_data = CTransientSetupData.linearize_transient_data;
	enable_marching_waveforms	= CTransientSetupData.enable_marching_waveforms;
	full_scale_marching_xaxis = CTransientSetupData.full_scale_marching_xaxis;
	enable_real_time_changes  = CTransientSetupData.enable_real_time_changes;

	m_loaded_version = CTransientSetupData.m_loaded_version;
}

////////////////
TCParametricSetupData::TCParametricSetupData(void)
{
	CSweepData.start	= 1;
	CSweepData.stop		= 1;
	CSweepData.step		= 1;
	CSweepData.type		= E_PARAMETER_SWEEP_TYPE_LINEAR;
	CSweepData.enable	= false;
	CSweepData.index	= 0;
	CSweepData.sweep_type = E_PARAMETER_RUN_MODE_INTERNAL_FILE;
	source_id			= 0;
}

TCParametricSetupData::TCParametricSetupData(TCParametricSetupData &CParametricSetupData)
{
	*this = CParametricSetupData;
}
TCParametricSetupData::~TCParametricSetupData(void)
{

}

void TCParametricSetupData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	CSweepData.Serialize(CArchiveFile);
 
	int count, p;

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << source_id;
		CArchiveFile << CSource;
		CArchiveFile << CValue;

		count = CData.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CData[p].Serialize(CArchiveFile);
	}
	else
	{
		CArchiveFile >> source_id;
		CArchiveFile >> CSource;
		CArchiveFile >> CValue;

		CArchiveFile >> count;

		CData.SetSize(count, count);

		for(p = 0; p < count; p++) CData[p].Serialize(CArchiveFile);

		// this will be either 0 or E_PARAMETER_RUN_MODE_EXTERNAL_FILE
		if(!CSweepData.sweep_type) CSweepData.sweep_type = E_PARAMETER_RUN_MODE_INTERNAL_FILE; 			
	}
}

void TCParametricSetupData::CopyGlobal(TCParametricSetupData &CParametricSetupData)
{
	CParametricSetupData;
	CSweepData;
}

void TCParametricSetupData::CopyUnGlobal(TCParametricSetupData &CSetupSource)
{
	CSetupSource;
}

void TCParametricSetupData::operator = (TCParametricSetupData &CParametricSetupData)
{
	CSweepData		= CParametricSetupData.CSweepData;
	CSource			= CParametricSetupData.CSource;
	source_id 		= CParametricSetupData.source_id;
	CValue			= CParametricSetupData.CValue;
	CRecordName		= CParametricSetupData.CRecordName;


	CMultiRunSignal = CParametricSetupData.CMultiRunSignal;
	CMultiRunDCParam = CParametricSetupData.CMultiRunDCParam;
	CMultiRunACParam = CParametricSetupData.CMultiRunACParam;
	CMultiRunNoiseParam = CParametricSetupData.CMultiRunNoiseParam;
	CMultiRunTranParam = CParametricSetupData.CMultiRunTranParam;
	CMultiRunTHDParam = CParametricSetupData.CMultiRunTHDParam;
	multi_run_enable = CParametricSetupData.multi_run_enable;

	int count = CParametricSetupData.CData.GetSize();

	CData.SetSize(count, count);

	for(int p = 0; p < count; p++)
	{
		CData[p] = CParametricSetupData.CData[p];
	}
}

bool TCParametricSetupData::IsSwept(CString CRefDes)
{
	int count = CData.GetSize();

	for(int p = 0; p < count; p++)
	{
		TCSelectParameter &CSelectParameter = CData[p];
		
		if(CSelectParameter.CRefDesignator != CRefDes) continue;

		if(CSelectParameter.CSweepData.enable) return true;
	}

	return false;
}

void TCParametricSetupData::DisableSchParamsSweep(void)
{
	int count = CData.GetSize();

	for(int p = 0; p < count; p++)
	{
		TCSelectParameter &CSelectParameter = CData[p];
		
		if(CSelectParameter.CRefDesignator != GCSuperSpiceGlobalData.CSchParamsName) continue;

		CSelectParameter.CSweepData.enable = false;

		break;
	}
}

int TCParametricSetupData::GetSchParamsID(void)
{
	int count = CData.GetSize();

	for(int p = 0; p < count; p++)
	{
		TCSelectParameter &CSelectParameter = CData[p];
		
		if(CSelectParameter.CRefDesignator != GCSuperSpiceGlobalData.CSchParamsName) continue;

		return p;
	}

	return -1;
}

int  TCParametricSetupData::GetNumberOfParamsSwept(void)
{
	int counter = 0;
	int count = CData.GetSize();

	for(int p = 0; p < count; p++)
	{
		TCSelectParameter &CSelectParameter = CData[p];

		if(CSelectParameter.CSweepData.enable) counter++;
	}

	return counter;
}

void TCParametricSetupData::DisableAll(void)
{
	int count = CData.GetSize();

	for(int p = 0; p < count; p++)
	{
		CData[p].CSweepData.enable = false;
	}
}

int	TCParametricSetupData::GetFirstSweptID(void)
{
	int count = CData.GetSize();

	for(int p = 0; p < count; p++)
	{
		if(CData[p].CSweepData.enable) return p;
	}

	return -1;
}

bool TCParametricSetupData::IsValidSingleRun(void)
{
	CString CTest; 

	int count = CData.GetSize();

	if(!count) return false;

	for(int p = 0; p < count; p++)
	{
		TCSelectParameter &CSelectParameter = CData[p];

		if(!CSelectParameter.CSweepData.enable) continue;

		CTest = CSelectParameter.CRefDesignator;

		CTest.MakeUpper();

		// only RLC and V/I can use single run_mode = 0;
		if(CTest.GetAt(0) == 'R' || CTest.GetAt(0) == 'L' || CTest.GetAt(0) == 'C' || CTest.GetAt(0) == 'V' || CTest.GetAt(0) == 'I' ) continue;

		return false;
	}

	return true;
}

double TCParametricSetupData::GetFirstValue(void)
{
	int id;
	double data = 0;

	id = GetFirstSweptID();

	if(id < 0) return 0;

	CData[id].CSweepData.GetFirstValue(data);

	return data;
}	

double TCParametricSetupData::GetNextValue(void)
{
	int id;
	double data = 0;

	id = GetFirstSweptID();

	if(id < 0) return 0;

	CData[id].CSweepData.GetNextValue(data);

	return data;
}

CString TCParametricSetupData::GetSweptParamName(void) 
{
	int id;

	id = GetFirstSweptID();

	if(id < 0) return "";

	return CData[id].CParameter;
}  

int TCParametricSetupData::GetSweptParamID(void) 
{
	int id;

	id = GetFirstSweptID();

	if(id < 0) return id;

	return CData[id].parameter_id;
} 

int TCParametricSetupData::GetSweptRefDesID(void) 
{
	int id;

	id = GetFirstSweptID();

	return id;
}

CString TCParametricSetupData::GetSweptRefDes(void)
{
	int id;

	id = GetFirstSweptID();

	if(id < 0) return "";

	return CData[id].CRefDesignator;
}

int TCParametricSetupData::GetCount(void) 
{
	int id;

	id = GetFirstSweptID();

	if(id < 0) return 0;

	return CData[id].CSweepData.GetCount();
} 
//////////////////////
TCNoiseSetupData::TCNoiseSetupData(void)
{
	enable			= false;
	enable_summary	= false;
	CSummaryPoints	= "1";
	output_index	= 0;
	CSource			= "???";
	COutput			= "???";
	enable_print_all	= false;
	enable_plot_all		= false;
}
TCNoiseSetupData::TCNoiseSetupData(TCNoiseSetupData &CNoiseSetupData)
{
	*this = CNoiseSetupData;
}
TCNoiseSetupData::~TCNoiseSetupData(void)
{

}

void TCNoiseSetupData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << enable;
		CArchiveFile << enable_summary;
		CArchiveFile << CSummaryPoints;
		CArchiveFile << output_index;
		CArchiveFile << CSource;
		CArchiveFile << COutput;
		CArchiveFile << CSpiceOutputName;
		CArchiveFile <<	enable_print_all;
		CArchiveFile <<	enable_plot_all;
	}
	else
	{
		CArchiveFile >> enable;
		CArchiveFile >> enable_summary;
		CArchiveFile >> CSummaryPoints;
		CArchiveFile >> output_index;
		CArchiveFile >> CSource;
		CArchiveFile >> COutput;
		CArchiveFile >> CSpiceOutputName;
		CArchiveFile >>	enable_print_all;
		CArchiveFile >>	enable_plot_all;
	}
}

void TCNoiseSetupData::CopyGlobal(TCNoiseSetupData &CNoiseSetupData)
{
	enable			= CNoiseSetupData.enable;
	enable_summary	= CNoiseSetupData.enable_summary;
	CSummaryPoints	= CNoiseSetupData.CSummaryPoints;

	enable_print_all	= CNoiseSetupData.enable_print_all;
	enable_plot_all		= CNoiseSetupData.enable_plot_all;
}

void TCNoiseSetupData::CopyUnGlobal(TCNoiseSetupData &CSetupSource)
{
	CSetupSource;
}

void TCNoiseSetupData::operator = (TCNoiseSetupData &CNoiseSetupData)
{
	enable			= CNoiseSetupData.enable;
	enable_summary	= CNoiseSetupData.enable_summary;
	CSummaryPoints	= CNoiseSetupData.CSummaryPoints;

	output_index = CNoiseSetupData.output_index;
	CSpiceOutputName = CNoiseSetupData.CSpiceOutputName;
	CSource		= CNoiseSetupData.CSource;
	COutput		= CNoiseSetupData.COutput;
	enable_print_all	= CNoiseSetupData.enable_print_all;
	enable_plot_all		= CNoiseSetupData.enable_plot_all;
}

////////////////////////
TCPoleZeroData::TCPoleZeroData(void)
{
	type	= 2;// pole and zero
	enable = false;
	output_index1 = 0;
	output_index2 = 0;
}
TCPoleZeroData::TCPoleZeroData(TCPoleZeroData &CPoleZeroData)
{
	*this = CPoleZeroData;
}
TCPoleZeroData::~TCPoleZeroData(void)
{

}

void TCPoleZeroData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile <<	type;
		CArchiveFile <<	enable;
		CArchiveFile <<	CSource1;
		CArchiveFile <<	CSource2;
		CArchiveFile <<	COutput1;
		CArchiveFile <<	COutput2;
		CArchiveFile <<	output_index1;
		CArchiveFile <<	output_index2;
	}
	else
	{
		CArchiveFile >>	type;
		CArchiveFile >>	enable;
		CArchiveFile >>	CSource1;
		CArchiveFile >>	CSource2;
		CArchiveFile >>	COutput1;
		CArchiveFile >>	COutput2;
		CArchiveFile >>	output_index1;
		CArchiveFile >>	output_index2;
	}
}

void TCPoleZeroData::CopyGlobal(TCPoleZeroData &CPoleZeroData)
{
	enable	= CPoleZeroData.enable;
	type	= CPoleZeroData.type;
}

void TCPoleZeroData::CopyUnGlobal(TCPoleZeroData &CSetupSource)
{
	CSetupSource;
}
void TCPoleZeroData::operator = (TCPoleZeroData &CPoleZeroData)
{
	enable		= CPoleZeroData.enable;
	type		= CPoleZeroData.type;
	CSource1	= CPoleZeroData.CSource1;
	CSource2	= CPoleZeroData.CSource2;
	COutput1	= CPoleZeroData.COutput1;
	COutput2	= CPoleZeroData.COutput2;
	output_index1 	= CPoleZeroData.output_index1;
	output_index2 	= CPoleZeroData.output_index2;
}
///////////////////////////////////

TCDistortionData::TCDistortionData(void)
{
	type				= 0;//THD
	enable				= false;
	frequency			= .9;
	enable_print_all	= false;
	enable_plot_all		= false;
}
TCDistortionData::TCDistortionData(TCDistortionData &CDistortionData)
{
	*this = CDistortionData;
}
TCDistortionData::~TCDistortionData(void)
{

}

void TCDistortionData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << type;
		CArchiveFile << enable;
		CArchiveFile << frequency;
		CArchiveFile <<	enable_print_all;
		CArchiveFile <<	enable_plot_all;
	}
	else
	{
		CArchiveFile >> type;
		CArchiveFile >> enable;
		CArchiveFile >> frequency;
		CArchiveFile >>	enable_print_all;
		CArchiveFile >>	enable_plot_all;
	}
}

void TCDistortionData::CopyGlobal(TCDistortionData &CDistortionData)
{
	type		= CDistortionData.type;
	enable		= CDistortionData.enable;
	frequency	= CDistortionData.frequency;
	enable_print_all	= CDistortionData.enable_print_all;
	enable_plot_all		= CDistortionData.enable_plot_all;
}

void TCDistortionData::CopyUnGlobal(TCDistortionData &CSetupSource)
{
	CSetupSource;
}

void TCDistortionData::operator = (TCDistortionData &CDistortionData)
{
	type		= CDistortionData.type;
	enable		= CDistortionData.enable;
	frequency	= CDistortionData.frequency;
	enable_print_all	= CDistortionData.enable_print_all;
	enable_plot_all		= CDistortionData.enable_plot_all;
}
/////////////////////////////////////////////////////////
TCSpiceNodeList::TCSpiceNodeList(void)
{
	
}
TCSpiceNodeList::TCSpiceNodeList(TCSpiceNodeList &COutputList)
{
	*this = COutputList;
}
TCSpiceNodeList::~TCSpiceNodeList(void)
{

}

void TCSpiceNodeList::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	int count, p;

	if(CArchiveFile.IsStoring())
	{
		count = CData.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CData[p].Serialize(CArchiveFile);

	}
	else
	{
		CArchiveFile >> count;

		CData.SetSize(count, count);

		for(p = 0; p < count; p++) CData[p].Serialize(CArchiveFile);

	}
}
void TCSpiceNodeList::operator = (TCSpiceNodeList &COutputList)
{
	int count = COutputList.CData.GetSize();

	CData.SetSize(count, count);
	
	for(int p = 0; p < count; p++) CData[p] = COutputList.CData[p];

}
/////////////////////////
TCOutput::TCOutput(void)
{
	type = 0;
}
TCOutput::TCOutput(TCOutput &COutput)
{
	*this = COutput;
}
TCOutput::~TCOutput(void)
{

}

void TCOutput::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile <<	CSpiceName;
		CArchiveFile <<	CUserName;
		CArchiveFile <<	type;
	}
	else
	{
		CArchiveFile >>	CSpiceName;
		CArchiveFile >>	CUserName;
		CArchiveFile >>	type;
	}
}
void TCOutput::operator = (TCOutput &COutput)
{
	CSpiceName	= COutput.CSpiceName;
	CUserName	= COutput.CUserName;
	type		= COutput.type;
}

//////////////////////////////////////////


TCProgramOptions::TCProgramOptions(void)
{

}

TCProgramOptions::TCProgramOptions(TCProgramOptions &TCProgramOptions)
{
	*this = TCProgramOptions;
}
TCProgramOptions::~TCProgramOptions(void)
{

}

void TCProgramOptions::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);
	CReserved.Serialize(CArchiveFile);

	CGeneral.Serialize(CArchiveFile);
	CErrors.Serialize(CArchiveFile);
	CSpiceEngine.Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{

	}
	else
	{

	}
}
void TCProgramOptions::operator = (TCProgramOptions &CProgramOptions)
{
	CGeneral		= CProgramOptions.CGeneral;
	CErrors			= CProgramOptions.CErrors;
	CSpiceEngine	= CProgramOptions.CSpiceEngine;

	CReserved		= CProgramOptions.CReserved;
}

TCProgramOptionsGeneral::TCProgramOptionsGeneral(void)
{
	save_on_exit						= true;
	load_on_start 						= true;
	prompt_save_model_files_on_exit		= false;
	prompt_save_symbol_files_on_exit	= false;
	prompt_save_component_files_on_exit = false;
	open_subcurcuits_in_new_window		= true;
	auto_display_graphics				= true;
	graph_default_setups				= false;
	auto_connect_analog_input_pins		= true;
	auto_connect_analog_output_pins		= true;
	auto_connect_digital_input_pins		= false;
	load_last_output_data				= true;
	calculate_fft_on_load				= false;
	calculate_selected_fft_signals		= false;
	flat_netlist						= true;
	interperlated_points				= false;
	save_subckt_currents				= true;
	display_signal_x2					= false;
	auto_update_calc_graph				= false;
	check_for_vi_sources				= true;
	flatten_nested_subckts				= true;
	lock_graph_size_to_window_size		= true;

	save_model_files_on_exit		= true;
	save_symbol_files_on_exit		= true;
	save_component_files_on_exit	= true;

	f_net_list_doc_open 	= false;
	f_output_text_doc_open 	= false;
	f_waveform_doc_open 	= false;
	f_symbol_doc_open 		= false;
	f_include_doc_open 		= false;
}

TCProgramOptionsGeneral::TCProgramOptionsGeneral(TCProgramOptionsGeneral &CProgramOptionsGeneral)
{
	*this = CProgramOptionsGeneral;
}
TCProgramOptionsGeneral::~TCProgramOptionsGeneral(void)
{

}

void TCProgramOptionsGeneral::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);
	CReserved.Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << save_on_exit;
		CArchiveFile << load_on_start;
		CArchiveFile << prompt_save_model_files_on_exit;
		CArchiveFile << prompt_save_symbol_files_on_exit;
		CArchiveFile << prompt_save_component_files_on_exit;
		CArchiveFile << open_subcurcuits_in_new_window;
		CArchiveFile << save_model_files_on_exit;
		CArchiveFile << save_symbol_files_on_exit;
		CArchiveFile << save_component_files_on_exit;
		CArchiveFile << auto_display_graphics;
		CArchiveFile << auto_connect_analog_input_pins;
		CArchiveFile << auto_connect_analog_output_pins;
		CArchiveFile << auto_connect_digital_input_pins;
		CArchiveFile << load_last_output_data;
		CArchiveFile << calculate_fft_on_load;
		CArchiveFile << calculate_selected_fft_signals;
		CArchiveFile << flat_netlist;
		CArchiveFile << interperlated_points;
		CArchiveFile << save_subckt_currents;
		CArchiveFile << graph_default_setups;
		CArchiveFile << display_signal_x2;
		CArchiveFile << auto_update_calc_graph;
		CArchiveFile << check_for_vi_sources;
		CArchiveFile << flatten_nested_subckts;
		CArchiveFile << lock_graph_size_to_window_size;



		CArchiveFile << f_net_list_doc_open;
		CArchiveFile << f_output_text_doc_open;
		CArchiveFile << f_waveform_doc_open;
		CArchiveFile << f_symbol_doc_open;
		CArchiveFile << f_include_doc_open;

		CArchiveFile << CLastWorkspaceLoaded;

	}
	else
	{
		CArchiveFile >> save_on_exit;
		CArchiveFile >> load_on_start;
		CArchiveFile >> prompt_save_model_files_on_exit;
		CArchiveFile >> prompt_save_symbol_files_on_exit;
		CArchiveFile >> prompt_save_component_files_on_exit;
		CArchiveFile >> open_subcurcuits_in_new_window;
		CArchiveFile >> save_model_files_on_exit;
		CArchiveFile >> save_symbol_files_on_exit;
		CArchiveFile >> save_component_files_on_exit;
		CArchiveFile >> auto_display_graphics;
		CArchiveFile >> auto_connect_analog_input_pins;
		CArchiveFile >> auto_connect_analog_output_pins;
		CArchiveFile >> auto_connect_digital_input_pins;
		CArchiveFile >> load_last_output_data;
		CArchiveFile >> calculate_fft_on_load;
		CArchiveFile >> calculate_selected_fft_signals;
		CArchiveFile >> flat_netlist;
		CArchiveFile >> interperlated_points;
		CArchiveFile >> save_subckt_currents;
		CArchiveFile >> graph_default_setups;
		CArchiveFile >> display_signal_x2;
		CArchiveFile >> auto_update_calc_graph;
		CArchiveFile >> check_for_vi_sources;
		CArchiveFile >> flatten_nested_subckts;
		CArchiveFile >> lock_graph_size_to_window_size;


		CArchiveFile >> f_net_list_doc_open;
		CArchiveFile >> f_output_text_doc_open;
		CArchiveFile >> f_waveform_doc_open;
		CArchiveFile >> f_symbol_doc_open;
		CArchiveFile >> f_include_doc_open;

		CArchiveFile >> CLastWorkspaceLoaded;
	}
}
void TCProgramOptionsGeneral::operator = (TCProgramOptionsGeneral &CProgramOptionsGeneral)
{
	save_on_exit	= CProgramOptionsGeneral.save_on_exit;
	load_on_start	= CProgramOptionsGeneral.load_on_start;

	prompt_save_model_files_on_exit		= CProgramOptionsGeneral.prompt_save_model_files_on_exit;
	prompt_save_symbol_files_on_exit	= CProgramOptionsGeneral.prompt_save_symbol_files_on_exit;
	prompt_save_component_files_on_exit = CProgramOptionsGeneral.prompt_save_component_files_on_exit;
	open_subcurcuits_in_new_window		= CProgramOptionsGeneral.open_subcurcuits_in_new_window;
	save_model_files_on_exit			= CProgramOptionsGeneral.save_model_files_on_exit;
	save_symbol_files_on_exit			= CProgramOptionsGeneral.save_symbol_files_on_exit;
	save_component_files_on_exit		= CProgramOptionsGeneral.save_component_files_on_exit;
	auto_display_graphics				= CProgramOptionsGeneral.auto_display_graphics;
	auto_connect_analog_input_pins		= CProgramOptionsGeneral.auto_connect_analog_input_pins;
	auto_connect_analog_output_pins		= CProgramOptionsGeneral.auto_connect_analog_output_pins;
	auto_connect_digital_input_pins		= CProgramOptionsGeneral.auto_connect_digital_input_pins;
	load_last_output_data				= CProgramOptionsGeneral.load_last_output_data;
	calculate_fft_on_load				= CProgramOptionsGeneral.calculate_fft_on_load;
	calculate_selected_fft_signals		= CProgramOptionsGeneral.calculate_selected_fft_signals;
	flat_netlist						= CProgramOptionsGeneral.flat_netlist;
	interperlated_points				= CProgramOptionsGeneral.interperlated_points;
	save_subckt_currents				= CProgramOptionsGeneral.save_subckt_currents;
	graph_default_setups				= CProgramOptionsGeneral.graph_default_setups;
	display_signal_x2					= CProgramOptionsGeneral.display_signal_x2;
	auto_update_calc_graph				= CProgramOptionsGeneral.auto_update_calc_graph;
	check_for_vi_sources				= CProgramOptionsGeneral.check_for_vi_sources;
	flatten_nested_subckts				= CProgramOptionsGeneral.flatten_nested_subckts;
	lock_graph_size_to_window_size		= CProgramOptionsGeneral.lock_graph_size_to_window_size;

	f_net_list_doc_open		= CProgramOptionsGeneral.f_net_list_doc_open;
	f_output_text_doc_open	= CProgramOptionsGeneral.f_output_text_doc_open;
	f_waveform_doc_open		= CProgramOptionsGeneral.f_waveform_doc_open;
	f_symbol_doc_open		= CProgramOptionsGeneral.f_symbol_doc_open;
	f_include_doc_open		= CProgramOptionsGeneral.f_include_doc_open;

	CLastWorkspaceLoaded = CProgramOptionsGeneral.CLastWorkspaceLoaded;

	CReserved = CProgramOptionsGeneral.CReserved;

}


///////////////////////////////////////////////
TCProgramOptionsErrors::TCProgramOptionsErrors(void)
{

}
TCProgramOptionsErrors::TCProgramOptionsErrors(TCProgramOptionsErrors &CProgramOptionsErrors)
{
	*this = CProgramOptionsErrors;
}
TCProgramOptionsErrors::~TCProgramOptionsErrors(void)
{

}

void TCProgramOptionsErrors::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{

	}
	else
	{

	}
}
void TCProgramOptionsErrors::operator = (TCProgramOptionsErrors &CProgramOptionsErrors)
{
	CProgramOptionsErrors;
}
