#ifndef _TCSUPERSPICE_GLOBAL_DATA_H
#define _TCSUPERSPICE_GLOBAL_DATA_H


#include <afxtempl.h>
#include "TCSpiceParameters.h"
#include "TCSchematicPageData.h"
#include "TCTestPointData.h"
#include "TCStringFunctions.h"

class TCWaveformAnalyisisData;
class TCFloatingCursorDlg;
class TCSuperSpiceDoc;

enum TE_GENERAL_ENUMS
{
	E_ZOOM_ARRAY_SIZE = 64,
	E_ZOOM_ARRAY_COUNT = 24,
};

enum TE_TEMPERATURE_SWEEP
{
	E_TEMPERATURE_SWEEP_MULTY_RUNS=0,
	E_TEMPERATURE_SWEEP_VOLTS_V_TEMP,
};

enum TE_EXTRA_ANALYSIS_RESERVED_FLOATS
{
	E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE,
	E_AC_ANALYSIS_RESERVED_LOOPGAIN_ZERO_PHASE,

	E_TRAN_ANALYSIS_RESERVED_FREQ_ENABLE,
	E_TRAN_ANALYSIS_RESERVED_AVERAGE_FREQ,
	E_TRAN_ANALYSIS_RESERVED_POLARITY,
	E_TRAN_ANALYSIS_RESERVED_FIRST_COUNT,
	E_TRAN_ANALYSIS_RESERVED_LAST_COUNT,
	E_TRAN_ANALYSIS_RESERVED_XING_LEVEL,

	E_PULSE_ANALYSIS_ENABLE,
	E_PULSE_ANALYSIS_MAX_LEVEL,
	E_PULSE_ANALYSIS_MID_LEVEL,
	E_PULSE_ANALYSIS_MIN_LEVEL,
	E_PULSE_ANALYSIS_XING_COUNT,
	E_PULSE_ANALYSIS_REF_XING_COUNT,
	E_PULSE_ANALYSIS_RISE_XING_TIME,
	E_PULSE_ANALYSIS_RISE_TIME,
	E_PULSE_ANALYSIS_FALL_XING_TIME,
	E_PULSE_ANALYSIS_FALL_TIME,
	E_PULSE_ANALYSIS_POLARITY,
	E_PULSE_ANALYSIS_WIDTH_MID_TIME,
	E_PULSE_ANALYSIS_WIDTH,
	E_PULSE_ANALYSIS_PERIOD,
	E_PULSE_ANALYSIS_DELAY,
	E_PULSE_ANALYSIS_TIME,

	E_AC_ANALYSIS_RESERVED_IMPEDANCE,
	E_AC_ANALYSIS_RESERVED_POWER,

	E_TRAN_POWER_ENABLE,
	E_TRAN_POWER_START,
	E_TRAN_POWER_END,

	E_TRAN_RMS_ENABLE,
	E_TRAN_RMS_START,
	E_TRAN_RMS_END,

	E_DESIGNER_ENABLE_OPERATING_POINT,
	E_DESIGNER_SELECTED_DEVICES,
	E_ADC_INPUT_CAPACITANCE,
	E_ADC_OUTPUT_RESISTANCE,
	E_PARAMETER_AUTO_GENERATE_RNN_FILE,
	E_ADC_T_RISE_FALL_DELAY,

	E_TRAN_CALCULATE_FFT_ON_LOAD,
	E_TRAN_CALCULATE_SELECTED_FFT_SIGNALS,

	E_NOISE_REPORT_FREQUENCY,

	E_PARAMETER_MULTIRUN_ENABLE,

	E_AC_ANALYSIS_FREQ_DEVICE_MODE,

	E_ANALYSIS_RESERVED_MAX,
};

enum TE_DESIGNER_TYPE_RUNS
{
	E_DEVICE_DESIGNER_ALL_DEVICES = 0,
	E_DEVICE_DESIGNER_SELECTED_RESISTORS,
	E_DEVICE_DESIGNER_SELECTED_MOSFETS,
	E_DEVICE_DESIGNER_SELECTED_RESISTORS_AND_MOSFETS,
};

enum TE_EXTRA_ANALYSIS_RESERVED_STRINGS
{
	E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE_STRING = E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE,
	E_TRAN_ANALYSIS_RESERVED_OUTPUT_NAME,
	E_PULSE_ANALYSIS_MEASURE_SIGNAL_NAME,
	E_PULSE_ANALYSIS_REFERANCE_SIGNAL_NAME,
	E_PULSE_ANALYSIS_RUN_SELECT,

	E_TRAN_POWER_VOLT_NAME,
	E_TRAN_POWER_CURRENT_NAME,
	E_TRAN_POWER_DEVICE_NAME,
	E_TRAN_POWER_RUN_SELECT,

	E_TRAN_RMS_SIGNAL_NAME,
	E_TRAN_RMS_RUN_SELECT,

	E_ADC_VOLTAGE,

	E_PARAMETER_MULTIRUN_SIGNAL,
	E_PARAMETER_MULTIRUN_DC_PARAM,
	E_PARAMETER_MULTIRUN_AC_PARAM,
	E_PARAMETER_MULTIRUN_NOISE_PARAM,
	E_PARAMETER_MULTIRUN_THD_PARAM,
	E_PARAMETER_MULTIRUN_TRAN_PARAM,
	E_AC_ANALYSIS_REF_DES_SWEPT_DEVICE,
	E_AC_ANALYSIS_REF_DES_SWEPT_DEVICE_FREQ,

	E_NOISE_REPORT_FREQUENCY_LIST,
	
	E_ANALYSIS_RESERVED_STRINGS_MAX,// = E_ANALYSIS_RESERVED_MAX,
};


enum E_PARAMETER_RUN_MODE_TYPE
{
	E_PARAMETER_RUN_MODE_NULL          = 0,
	E_PARAMETER_RUN_MODE_RESERVED1     = 1,
	E_PARAMETER_RUN_MODE_MODEL_FILE    = 2, // Atempt to recreate orginal varying of models to get parameter sweeps
	E_PARAMETER_RUN_MODE_EXTERNAL_FILE = 3,// Compatability with prior mess Nov 2014, use ext user rrn file
	E_PARAMETER_RUN_MODE_RESERVED2     = 4,
	E_PARAMETER_RUN_MODE_INTERNAL_FILE = 5,// Compatability with prior mess, use internal rrn file
};

enum TE_PARAMETER_SWEEP_TYPE
{
	E_PARAMETER_SWEEP_TYPE_DEC,
	E_PARAMETER_SWEEP_TYPE_OCT,
	E_PARAMETER_SWEEP_TYPE_LINEAR,
	E_PARAMETER_SWEEP_TYPE_EXTERNAL_FILE,	//= E_PARAMETER_RUN_MODE_EXTERNAL_FILE
	E_PARAMETER_SWEEP_TYPE_LIST,
	
};

enum TE_RERUN_SWEEP_TYPE
{
	E_RERUN_SWEEP_TYPE_NONE = 0,
	E_RERUN_SWEEP_TYPE_WC_MODEL_FILES,	//1 WC change model files
	E_RERUN_SWEEP_TYPE_MC_RERUN_FILE,	//2 Internal MC sweep file
	E_RERUN_SWEEP_TYPE_WC_RERUN_FILE,	//3 Internal WC Sweep file
};


class TCReserved : public CObject
{
	public:	TCReserved(void);
			TCReserved(TCReserved &CReserved);
			~TCReserved(void);

			CArray <float, float>		CIntArray;// can double as any 4 byte
			CArray <CString, CString>	CStringArray;

			void operator = (TCReserved &CReserved);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCReserved)

};

class TCVersionInfo : public CObject
{
	public:	TCVersionInfo(void);
			TCVersionInfo(TCVersionInfo &CVersionInfo);
			~TCVersionInfo(void);

			CString CLoadMajor;
			CString CMinor;
			CString CMicro;
			CString CDateAndTime;
			CString CSaveMajor;
			CString GetVersionString(void);

			TCReserved CReserved;

			void operator = (TCVersionInfo &CVersionInfo);
			bool operator != (TCVersionInfo &CVersionInfo);
			bool operator == (TCVersionInfo &CVersionInfo);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCVersionInfo)

};

class TCWaveformData : public CObject
{
	public:	TCWaveformData(void);
			TCWaveformData(TCWaveformData &CWaveformData);
			~TCWaveformData(void);

			WINDOWPLACEMENT		s_window_placment;
			
			int	is_placement_valid;

			TCFloatingCursorDlg *PCFloatingCursorDlg;
			int		num_digits_displayed;

			int display_graph_floating_cursor;
			int	resolution;
			int auto_axis;
			int enable_quantisation;

			TCReserved CReserved;

			void operator = (TCWaveformData &CWaveformData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCWaveformData)

};

class TCPrinterData : public CObject
{
	public:	TCPrinterData(void);
			TCPrinterData(TCPrinterData &CPrinterData);
			~TCPrinterData(void);

			float	resolution;
			float	magnification;
			int		page_margin;
			CRect	CPrinterPageOutline;

			void SetPrinterPageData();
			CRect GetPrinterPageSize(void);
			float GetPrinterZoom(void);

			TCReserved CReserved;

			void operator = (TCPrinterData &CPrinterData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCPrinterData)

};

class TCWorstCaseData : public CObject
{
	public:	TCWorstCaseData(void);
			TCWorstCaseData(TCWorstCaseData &CWorstCaseData);
			~TCWorstCaseData(void);

			int strong;// more convienient for dlg
			int nominal;
			int weak;

			CArray <bool, bool> CStrength;// more convienient for scaning through
								// does not need saved

			CString CName;
			CString CTypeName;
			CString CID;

			TCReserved CReserved;

			void SelectAll(void);
			void ClearAll(void);
			int  CalculateNumberOfReRuns(void);
			void SelectMaxMin(void);
			void SelectMax(void);
			void SelectMin(void);
			void SetStrength(void);
			void SelectAllNominal(void);

			void operator = (TCWorstCaseData &CWorstCaseData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCWorstCaseData)

};

enum TE_WORST_CASE_TYPES
{
	E_WORST_CASE_MAX,
	E_WORST_CASE_NOMINAL,
	E_WORST_CASE_MIN,

	E_WORST_CASE_TYPES_SIZE
};

enum TE_WORST_CASE_COMPONENTS
{
	E_WORST_CASE_NPN,
	E_WORST_CASE_PNP,
	E_WORST_CASE_NMOS,
	E_WORST_CASE_PMOS,
	E_WORST_CASE_QR,
	E_WORST_CASE_RLC,
	E_WORST_CASE_GENERATOR,
	E_WORST_CASE_SUB,
	E_WORST_CASE_TEMP,
	E_WORST_CASE_COUNT,
	E_WORST_CASE_RESERVED1,
	E_WORST_CASE_RESERVED2,
	E_WORST_CASE_RESERVED3,
	E_WORST_CASE_RESERVED4,
	E_WORST_CASE_RESERVED5,
	E_WORST_CASE_RESERVED6,
	E_WORST_CASE_RESERVED7,
	E_WORST_CASE_RESERVED8,


	E_WORST_CASE_COMPONENTS_SIZE
};

class TCReRun : public CObject
{
	public:	TCReRun(void);
			TCReRun(TCReRun &CReRun);
			~TCReRun(void);

			CArray <TCWorstCaseData, TCWorstCaseData&> CWorstCase;
			CArray <CString, CString&> CRunType;

			int	  enable;
			double temp_nominal;
			double temp_min;
			double temp_max;
			double capacitor_tol;
			double inductor_tol;
			double resistor_tol;
			double qrc_max;// future expansion, may add asymetric tolerances
			double qrc_min;
			double qrc_nom;
			double number_of_wc_runs;
			double xspice_run_mode;
			double generator_tol;
			double xspice_param_run_mode;
			int    distribution;
			CString CVGeneratorName;
			CString CIGeneratorName;
			CString CXGeneratorName;
			CString CRQWCName;
			CString CCQWCName;

			TCReserved CReserved;

			void operator = (TCReRun &CReRun);
			void operator = (TCWaveformAnalyisisData &CWaveformAnalyisisData);
	
			void Serialize(CArchive& CArchiveFile);

			void SelectAll(void);
			void ClearAll(void);
			int  CalculateNumberOfReRuns(void);
			void SelectMaxMin(void);
			void SetStrength(void);
			void SelectAllNominal(void);
			void Setup(void);
			int GetModifiedSpiceModelType(CString CRecordType); // Added to fix moving of coupled W, N, S, types.
			int GetSubcktSpiceModelType(CString CSpiceType); // subckt spice model 

			void AllWeakMaxTemp(void);
			void AllWeakMinTemp(void);
			void AllStrongMaxTemp(void);
			void AllStrongMinTemp(void);

			CString GetADConversionModelName(void);
			CString GetDAConversionModelName(void);

			DECLARE_SERIAL(TCReRun)

};

class TCSuperSpiceGeneric : public CObject
{
	public:	TCSuperSpiceGeneric(void);
			TCSuperSpiceGeneric(TCSuperSpiceGeneric &CSuperSpiceGeneric){*this = CSuperSpiceGeneric;};
			~TCSuperSpiceGeneric(void);

			float	zoom_scale_rate_facter;
			int		component_base_font_size;
			CString	CProgramVersion;
			CString	CSchematicVersion;
			int		load_toolbar_state;
			CString CDataBaseInitFileName;
			CString CDataBaseLastModelFileName;
			CString CDataBaseLastSymbolFileName;
			CString CDataBaseClipboardFileName;
			CString CLastOpenFileDlgName;

			TCReserved CReserved;

			
			CArray <int, int>	CComponentPropertyCurrentPin;

			int ignore_model_path;

			void operator = (TCSuperSpiceGeneric &CGeneric);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCSuperSpiceGeneric)

};


class TCSuperSpiceDrawData : public CObject
{
	public:	TCSuperSpiceDrawData(void);
			TCSuperSpiceDrawData(TCSuperSpiceDrawData &CSuperSpiceDrawData){*this = CSuperSpiceDrawData;};

			~TCSuperSpiceDrawData(void);

			void operator = (TCSuperSpiceDrawData &CSuperSpiceGridData);
	
			void Serialize(CArchive& CArchiveFile);

			int	grid_size;
			int	is_grid_display_on;
			int	is_snap_to_grid_on;
			int	is_rubber_band_on;
			int is_draw_orthoganal_on;
			int is_move_with_snap_to_grid;
			int snap_to_distance;
			int all_enclosed;
			int hyde_labels;
			int fastest_drawing_mode;
			int draw_schematic_page_border;
			int draw_waveform_page_border;
			int vector_printing;
			int display_connection_dots;
			int connection_dot_size;
			int repeat_pasting;
			int probe_mode;

			int symbol_editor_grid_size;
			int symbol_editor_snap_to_distance;
			char symbol_editor_snap_to_grid_on;
			char symbol_editor_overide_snap_to_grid;

			int labels_schematic;
			int lables_graph;
			int lable_graph_x;
			int lable_graph_y;
			int lable_schematic_x;
			int lable_schematic_y;
			int lable_timeout;

			int wave_graph_x_shrink;
			int wave_graph_y_shrink;
			int wave_graph_no_border_y_shrink;
			int wave_graph_no_border_y_offset;

			TCReserved CReserved;

			DECLARE_SERIAL(TCSuperSpiceDrawData)

};

class TCSuperSpiceColorData : public CObject
{

	public:	TCSuperSpiceColorData(void);
			TCSuperSpiceColorData(TCSuperSpiceColorData &CSuperSpiceColorData){*this = CSuperSpiceColorData;};
			~TCSuperSpiceColorData(void);

			COLORREF	background;
			COLORREF	grid;
			COLORREF	component_normal;
			COLORREF	component_selected;
			COLORREF	component_highlighted;
			COLORREF	pin_normal;
			COLORREF	pin_selected;
			COLORREF	pin_highlighted;
			COLORREF	component_text_normal;
			COLORREF	component_text_selected;
			COLORREF	component_text_highlighted;
			COLORREF	pin_text_normal;
			COLORREF	pin_text_selected;
			COLORREF	pin_text_highlighted;
			COLORREF	user_text_normal;
			COLORREF	user_text_selected;
			COLORREF	user_text_highlighted;
			COLORREF	wire_normal;
			COLORREF	wire_selected;
			COLORREF	wire_highlighted;
			int			black_white_printing;

			TCReserved CReserved;

			void operator = (TCSuperSpiceColorData &CSuperSpiceColorData);
			bool operator != (TCSuperSpiceColorData &CSuperSpiceColorData);

			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCSuperSpiceColorData)

};	
	
class TCSuperSpiceConfigData : public CObject
{
	public:	TCSuperSpiceConfigData(void);
			TCSuperSpiceConfigData(TCSuperSpiceConfigData &CSuperSpiceConfigData){*this = CSuperSpiceConfigData;};

			~TCSuperSpiceConfigData(void);
			TCReserved CReserved;

			TCTestPointData CTestPointData;

			void operator = (TCSuperSpiceConfigData &CSuperSpiceConfigData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCSuperSpiceConfigData)

};


class TCSuperSpiceFontData  : public CObject
{
	public:
			
			CString CComponents;
			CString CUser;
			CString CPins;
			CString CWaveformAxis;
			CString CWaveformTitle;
			CString CWaveformNotes;

			CString CConnectionDotFontString;
			CString CStringReseved2;
			CString CStringReseved3;
			CString CStringReseved4;


			LOGFONT CComponentLogFont;
			LOGFONT CUserLogFont;
			LOGFONT CPinsLogFont;
			LOGFONT CWaveformAxisLogFont;
			LOGFONT CWaveformTitleLogFont;
			LOGFONT CWaveformNotesLogFont;

			LOGFONT CConnectionDotFont;
			LOGFONT CReserved2LogFont;
			LOGFONT CReserved3LogFont;
			LOGFONT CReserved4LogFont;

			int	  component_size;
			int   user_size;
			int	  pin_size;
			int	  waveform_axis;
			int	  wave_form_title;
			int	  wave_form_notes;

			int  connection_dot_size;
			int  reseved2;
			int  reseved3;
			int  reseved4;

			
			public:	TCSuperSpiceFontData(void);
			TCSuperSpiceFontData(TCSuperSpiceFontData &CFontData){*this = CFontData;};

			~TCSuperSpiceFontData(void);

			void operator = (TCSuperSpiceFontData &CFontData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCSuperSpiceFontData)
	
};

class TCSweepData : public CObject
{
	public:	TCSweepData();
			TCSweepData(TCSweepData &CSweepData);
			~TCSweepData();

			double	start;
			double	stop;
			double	step;
			int		type;
			int		enable;
			int		sweep_type;

			bool	GetFirstValue(double &value);
			bool	GetNextValue(double &value);
			int		GetCount(void);
			double	index;

			CString	CValueList;
			bool CreateValueList(void);

			void operator = (TCSweepData &CSweepData);

			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCSweepData)
};

class TCACSetupData : public CObject
{
	public:	TCACSetupData();
			TCACSetupData(TCACSetupData &CACSetupData);
			~TCACSetupData();

			TCSweepData CSweepData;
			int enable_print_all;
			int enable_plot_all;
			
			void operator = (TCACSetupData &CACSetupData);
			void CopyGlobal(TCACSetupData &CSetupSource);
			void CopyUnGlobal(TCACSetupData &CSetupSource);


			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCACSetupData)
};
class TCDCSetupData : public CObject
{
	public:	TCDCSetupData(void);
			TCDCSetupData(TCDCSetupData &CDCSetupData);
			~TCDCSetupData(void);

			TCSweepData CSweepData1;
			TCSweepData CSweepData2;
			CString CSource1;
			CString CSource2;
			int enable_print_all;
			int enable_plot_all;
			int enable_operating_point;
			int display_device_op_points;

			void operator = (TCDCSetupData &CDCSetupData);
			void CopyGlobal(TCDCSetupData &CSetupSource);
			void CopyUnGlobal(TCDCSetupData &CSetupSource);

	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCDCSetupData)

};

class TCOutput : public CObject
{
	public:	TCOutput(void);
			TCOutput(TCOutput &COutput);
			~TCOutput(void);

			CString CSpiceName;
			CString CUserName;
			int		type;// volt or amp in Vrefdes

			void operator = (TCOutput &COutput);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCOutput)

};

class TCSpiceNodeList : public CObject
{
	public:	TCSpiceNodeList(void);
			TCSpiceNodeList(TCSpiceNodeList &COutputList);
			~TCSpiceNodeList(void);

			CArray <TCOutput, TCOutput&> CData;

			void operator = (TCSpiceNodeList &COutputList);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCSpiceNodeList)

};

class TCNoiseSetupData : public CObject
{
	public:	TCNoiseSetupData(void);
			TCNoiseSetupData(TCNoiseSetupData &CNoiseSetupData);
			~TCNoiseSetupData(void);

			int		enable;
			int		enable_summary;

			CString CSummaryPoints;
			CString CSource;
			CString COutput;
			CString CSpiceOutputName;
			int		output_index;;
			int		enable_print_all;
			int		enable_plot_all;

			void operator = (TCNoiseSetupData &CNoiseSetupData);
			void CopyGlobal(TCNoiseSetupData &CSetupSource);
			void CopyUnGlobal(TCNoiseSetupData &CSetupSource);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCNoiseSetupData)

};

enum TE_TRANSIENT_SETUP
{ 
	E_TRANSIENT_SETUP_USE_INITIAL_CONDITION  = 1,
	E_TRANSIENT_SETUP_MAX_CALC_IS_PRINT_TIME = 2,
	E_TRANSIENT_SETUP_LINEARIZE_TRANSIENT_DATA  = 4,
	E_TRANSIENT_SETUP_ENABLE_MARCHING_WAVEFORMS = 8,
	E_TRANSIENT_SETUP_MARCHING_XAXIS			= 16,
	E_TRANSIENT_SETUP_ENABLE_REAL_TIME			=32,
};

class TCTransientSetupData : public CObject
{
	public:	TCTransientSetupData(void);
			TCTransientSetupData(TCTransientSetupData &CTransientSetupData);
			~TCTransientSetupData(void);

			TCSweepData CSweepData;

			CString COutput;
			CString CSpiceOutputName;
			int		output_index;
			double	max_compute_step_size;

			int m_loaded_version;

			double	frequency;
			int		fourier_enable;
			int enable_print_all;
			int enable_plot_all;
			int enable_print_all_fourier;
			int enable_plot_all_fourier;
			int use_initial_conditions;
			int max_calc_is_print_time;
			int linearize_transient_data;
			int enable_marching_waveforms;
			int full_scale_marching_xaxis;
			int enable_real_time_changes;

			void operator = (TCTransientSetupData &CTransientSetupData);
			void CopyGlobal(TCTransientSetupData &CSetupSource);
			void CopyUnGlobal(TCTransientSetupData &CSetupSource);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCTransientSetupData)

};
class TCStatisticsSetupData : public CObject
{
	public:	TCStatisticsSetupData();
			TCStatisticsSetupData(TCStatisticsSetupData &CStatisticsSetupData);
			~TCStatisticsSetupData();

			int enable;
			TCReserved CReserved;

			void operator = (TCStatisticsSetupData &CStatisticsSetupData);
			void CopyGlobal(TCStatisticsSetupData &CSetupSource);
			void CopyUnGlobal(TCStatisticsSetupData &CSetupSource);

			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCStatisticsSetupData)
};

class TCSensitivitySetupData : public CObject
{
	public:	TCSensitivitySetupData(void);
			TCSensitivitySetupData(TCSensitivitySetupData &CSensitivitySetupData);
			~TCSensitivitySetupData(void);

			CString COutput;
			CString CStaticOutput;
			CString CSpiceOutputName;
			int		ac_output_index;//ac
			int		dc_output_index;//dc

			int enable_dc;
			int enable_ac;
			int enable_print_all;
			int enable_plot_all;

			void operator = (TCSensitivitySetupData &CSensitivitySetupData);
			void CopyGlobal(TCSensitivitySetupData &CSetupSource);
			void CopyUnGlobal(TCSensitivitySetupData &CSetupSource);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCSensitivitySetupData)

};

class TCTemperatureSetupData : public CObject
{
	public:	TCTemperatureSetupData(void);
			TCTemperatureSetupData(TCTemperatureSetupData &CTemperatureSetupData);
			~TCTemperatureSetupData(void);

			void operator = (TCTemperatureSetupData &CTemperatureSetupData);
	
			TCSweepData CSweepData;

			bool GetFirstValue(double &value);
			bool GetNextValue(double &value);
			int	 GetCount(void);

			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCTemperatureSetupData)

};

class TCSpiceOptionsData : public CObject
{
	public:	TCSpiceOptionsData(void);
			TCSpiceOptionsData(TCSpiceOptionsData &CSpiceOptionsData);
			~TCSpiceOptionsData(void);

			CString CType;
			CString CValue;
			CString SpiceName;
			double  value;
			int		m_include;

			void operator = (TCSpiceOptionsData &TCSpiceOptionsData);
			void CopyGlobal(TCSpiceOptionsData &CSetupSource);
			void CopyUnGlobal(TCSpiceOptionsData &CSetupSource);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCSpiceOptionsData)

};

class TCBerklySpiceOptionsSetupData : public CObject
{
	public:	TCBerklySpiceOptionsSetupData(void);
			TCBerklySpiceOptionsSetupData(TCBerklySpiceOptionsSetupData &CBerklySpiceOptionsSetupData);
			~TCBerklySpiceOptionsSetupData(void);

			CArray <TCSpiceOptionsData, TCSpiceOptionsData&> COptionsStringData;
			CArray <TCSpiceOptionsData, TCSpiceOptionsData&> COptionsFloatData;

			int		last_float_option_selected;
			int		last_string_option_selected;
			bool	tran_nodeset;
			void	Setup(void);
			void	RemoveFloat(CString CText);
			void	RemoveString(CString CText);

			void operator = (TCBerklySpiceOptionsSetupData &CBerklySpiceOptionsSetupData);

			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCBerklySpiceOptionsSetupData)

};

class TCSelectParameter : public CObject
{
	public:	TCSelectParameter(void);
			TCSelectParameter(TCSelectParameter &CSelectParameter);
			~TCSelectParameter(void);

			int			version;
			int			parameter_id;
			CString		CParameter;

			TCSpiceParameters	*PCParameter;
			CString				CRefDesignator;
			TCSweepData			CSweepData;
	
			

			void operator = (TCSelectParameter &CSelectParameter);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCSelectParameter)

}; 

class TCParametricSetupData : public CObject
{
	public:	TCParametricSetupData(void);
			TCParametricSetupData(TCParametricSetupData &CParametricSetupData);
			~TCParametricSetupData(void);

			int			source_id;
			CString		CSource;
			CString		CValue;      
			CString		CRecordName;
			CString		CMultiRunSignal;
			CString		CMultiRunACParam;
			CString		CMultiRunDCParam;
			CString		CMultiRunTranParam;
			CString		CMultiRunNoiseParam;
			CString		CMultiRunTHDParam;
			int			multi_run_enable;

			TCSweepData CSweepData;

			CArray <TCSelectParameter, TCSelectParameter &> CData;
			void CopyGlobal(TCParametricSetupData &CSetupSource);
			void CopyUnGlobal(TCParametricSetupData &CSetupSource);
			bool IsSwept(CString CRefDes);
			int  GetNumberOfParamsSwept(void);

			void DisableAll(void);

			int	GetFirstSweptID(void);
			double GetFirstValue(void);		   // For single selected sweeps, e.g. Schematic parameters
			double GetNextValue(void);		   // For single selected sweeps, e.g. Schematic parameters
			CString GetSweptParamName(void);   // For single selected sweeps, e.g. Schematic parameters
			CString GetSweptRefDes(void);      // For single selected sweeps, e.g. Schematic parameters
			int GetSweptParamID(void);         // For single selected sweeps, e.g. Schematic parameters
			int GetSweptRefDesID(void);        // For single selected sweeps, e.g. Schematic parameters
			int GetCount(void);				   // For single selected sweeps, e.g. Schematic parameters
			bool IsValidSingleRun(void);
			void DisableSchParamsSweep(void);
			int GetSchParamsID(void);

			void operator = (TCParametricSetupData &CParametricSetupData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCParametricSetupData)
};

class TCPoleZeroData : public CObject
{
	public:	TCPoleZeroData(void);
			TCPoleZeroData(TCPoleZeroData &CPoleZeroData);
			~TCPoleZeroData(void);

			CString CSource1;
			CString CSource2;
			CString COutput1;
			CString COutput2;

			int output_index1;
			int output_index2;

			int type;
			int enable;

			void operator = (TCPoleZeroData &CPoleZeroData);
			void CopyGlobal(TCPoleZeroData &CSetupSource);
			void CopyUnGlobal(TCPoleZeroData &CSetupSource);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCPoleZeroData)

};

class TCDistortionData : public CObject
{
	public:	TCDistortionData(void);
			TCDistortionData(TCDistortionData &CDistortionData);
			~TCDistortionData(void);

			int		type;
			int		enable;
			double	frequency;
			void operator = (TCDistortionData &CDistortionData);
			void CopyGlobal(TCDistortionData &CSetupSource);
			void CopyUnGlobal(TCDistortionData &CSetupSource);
			int enable_print_all;
			int enable_plot_all;
			
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCDistortionData)

};

enum TE_EXTRA_OUTPUT_SELECT
{
	TE_EXTRA_OUTPUT_ALL_VOLTS = 1,
	TE_EXTRA_OUTPUT_ENABLE_ADC = 2,
};

class TCOutputSelectData : public CObject
{
	public:	TCOutputSelectData(void);
			TCOutputSelectData(TCOutputSelectData &COutputSelectData);
			~TCOutputSelectData(void);

			int	all_currents;
			int	all_volts;
			int text_file_type;

			int index_spice_volt_and_current;
			int index_device_current_node;
			int index_output_source;
			int enable_auto_ad_conversion;

			CString	CData;

			CArray <CString, CString> CSpiceVoltAndCurrentList;

			bool Remove(CString CData);

			void operator = (TCOutputSelectData &COutputSelectData);
			void CopyGlobal(TCOutputSelectData &CSetupSource);
			void CopyUnGlobal(TCOutputSelectData &CSetupSource);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCOutputSelectData)

};

class TCAnalysisSetup : public CObject
{
	public:	TCAnalysisSetup();
			TCAnalysisSetup(TCAnalysisSetup &CAnalysisSetup);
			~TCAnalysisSetup();

			CString							CSchematicName;
			CString							CFileName;
			TCMultiLineString				CMultiLineData;  // Added to add new saved data compatible with old versions
			CArray <CString, CString&>		CLibraryNameList;
			CArray <CString, CString&>		CIncludeNameList;
			TCSpiceNodeList					COutputList;
			TCSpiceNodeList					CStaticOutputList;
			TCSpiceNodeList					CSourceList;
			TCSpiceNodeList					CNodeList;
			TCSpiceNodeList					CDeviceCurrentNodeList;
			
			TCACSetupData					CACSetupData;
			TCDCSetupData					CDCSetupData;
			TCNoiseSetupData				CNoiseSetupData;
			TCTransientSetupData			CTransientSetupData;
			TCStatisticsSetupData			CStatisticsSetupData;
			TCSensitivitySetupData			CSensitivitySetupData;
			TCParametricSetupData			CParametricSetupData;
			TCTemperatureSetupData			CTemperatureSetupData;
			TCBerklySpiceOptionsSetupData	CBerklySpiceOptionsSetupData;
			TCPoleZeroData					CPoleZeroSetupData;
			TCDistortionData				CDistortionSetupData;
			TCOutputSelectData				COutputSelectData;
			TCReRun							CReRun;
			
			TCReserved						CReserved1;
			TCReserved						CReserved2;
			TCSuperSpiceDoc					*PCDoc;

			TCSpiceParameters				CSchematicDefsParameters;
			TCSpiceParameters				CParameterDefsSweepParameters;// may be usful
			CString							CSchematicParameters;
			CString							CSchematicSweepParameters;
			TCSelectParameter				CSelectParameter;
			int								parameter_sweep_mode;

			void PutParametricDataToRereun(void);
			void PutRereunDataToParametric(void);
			void LoadSchematicParameters();
			void SaveSchematicParameters();
			double EvaluateComponentValue(CString CLable);
			void SetParameterSweepParameter(CString CParam, double value);
			void SetParameterSweepParameter(int param_id, double value);
			CString GetResolvedParameters(TCSpiceParameters &CParams);

			void operator = (TCAnalysisSetup &CAnalysisSetup);
			void CopyGlobal(TCAnalysisSetup &CSetupSource);
			void CopyUnGlobal(TCAnalysisSetup &CSetupSource);

			void Serialize(CArchive& CArchiveFile);
			void LoadMultiLineData(CArchive& CArchiveFile);
			void SaveMultiLineData(CArchive& CArchiveFile);

			int FindVoltAndCurrentNode(CString CNode);
			int FindDeviceCurrentNode(CString CNode);
			void RemoveInvalidOutputSelectData(void);

			DECLARE_SERIAL(TCAnalysisSetup)
};

class TCProgramOptionsErrors : public CObject
{
	public:	TCProgramOptionsErrors(void);
			TCProgramOptionsErrors(TCProgramOptionsErrors &CProgramOptionsErrors);
			~TCProgramOptionsErrors(void);

			void operator = (TCProgramOptionsErrors &CProgramOptionsErrors);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCProgramOptionsErrors)

};

class TCProgramOptionsGeneral : public CObject
{
	public:	TCProgramOptionsGeneral(void);
			TCProgramOptionsGeneral(TCProgramOptionsGeneral &CProgramOptionsGeneral);
			~TCProgramOptionsGeneral(void);

			int save_on_exit;
			int load_on_start;
			int prompt_save_model_files_on_exit;
			int prompt_save_symbol_files_on_exit;
			int prompt_save_component_files_on_exit;
			int open_subcurcuits_in_new_window;
			int save_model_files_on_exit;
			int save_symbol_files_on_exit;
			int save_component_files_on_exit;
			int auto_display_graphics;
			int auto_connect_analog_input_pins;
			int auto_connect_analog_output_pins;
			int auto_connect_digital_input_pins;
			int graph_default_setups;
			int display_signal_x2;
			int auto_update_calc_graph;
			int check_for_vi_sources;

			int f_net_list_doc_open;
			int f_output_text_doc_open;
			int f_waveform_doc_open;
			int f_symbol_doc_open;
			int f_include_doc_open;

			int	load_last_output_data;
			int calculate_fft_on_load;
			int calculate_selected_fft_signals;

			int flat_netlist;
			int interperlated_points;
			int save_subckt_currents;
			int flatten_nested_subckts;
			int lock_graph_size_to_window_size;
			CString CLastWorkspaceLoaded;

			TCReserved CReserved;

			void operator = (TCProgramOptionsGeneral &CProgramOptionsGeneral);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCProgramOptionsGeneral)

};

class TCSpiceEngineOptions : public CObject
{
	public:	TCSpiceEngineOptions(void);
			TCSpiceEngineOptions(TCSpiceEngineOptions &CSpiceEngineOptions);
			~TCSpiceEngineOptions(void);

			int		spice3_compatible;
			int		default_command;
			int		run_minimised;
			int		beep_when_engine_finished;
			int		display_loading_status;
			int		display_xspice_status;

			CString CSpiceEngineName;
			CString CCommandLine;

			TCReserved CReserved;

			void operator = (TCSpiceEngineOptions &CSpiceEngineOptions);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCSpiceEngineOptions)

};

class TCProgramOptions : public CObject
{
	public:	TCProgramOptions(void);
			TCProgramOptions(TCProgramOptions &CProgramOptions);
			~TCProgramOptions(void);

			TCProgramOptionsGeneral CGeneral;
			TCProgramOptionsErrors	CErrors;
			TCSpiceEngineOptions	CSpiceEngine;

			TCReserved CReserved;


			void operator = (TCProgramOptions &CProgramOptions);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCProgramOptions)

};


class TCSuperSpiceGlobalData : public CObject
{

	public:	TCSuperSpiceGlobalData(void);
			TCSuperSpiceGlobalData(TCSuperSpiceGlobalData &CSuperSpiceGlobalData){*this = CSuperSpiceGlobalData;};

			~TCSuperSpiceGlobalData(void);

			void operator = (TCSuperSpiceGlobalData &CSuperSpiceGlobalData);
	
			void Serialize(CArchive& CArchiveFile);
			void Setup(void);

			CString					CSchParamsName; // Needs to be before TCAnalysisSetup

			TCVersionInfo			CVersionInfo;
			TCSuperSpiceGeneric		CGeneric;
			TCSchematicPageData		CPageData;
			TCSuperSpiceDrawData	CDrawData;
			TCSuperSpiceColorData	CColorData;
			TCSuperSpiceConfigData	CConfigData;
			TCSuperSpiceFontData	CFontData;
			TCAnalysisSetup			CAnalysisSetup;
			TCProgramOptions		CProgramOptions;
			TCPrinterData			CPrinterData;
			TCWaveformData			CWaveformData;
			

			TCReserved CReserved;

			float ZoomArray[E_ZOOM_ARRAY_SIZE];
			int max_index;
			int GetZoomIndex(float zoom);

			bool load_ok;

			bool Save(CString CFileName);
			bool Load(CString CFileName);

			DECLARE_SERIAL(TCSuperSpiceGlobalData)
};

#endif