// TCSuperSpiceMainFrame.cpp : implementation of the TCSuperSpiceMainFrame class
//

#include "stdafx.h"
#include "afxpriv.h"
#include <htmlhelp.h>
#include "Generic.h"
#include "TCSuperSpiceGlobalData.h"
#include "TESuperSpiceMsgStringsEnums.h"
#include "TCStringFunctions.h"
#include "TCFloatingCursorData.h"
#include "SuperSpice.h"
#include "Themes.h"
#include "TCSuperSpiceMainFrame.h"
#include "TCPasswordId.h"
#include "TCFileFunctions.h"
#include "TCMKSConvert.h"
#include "EToolbars.h"
#include "TCSuperSpiceDoc.h"
#include "TESuperSpiceMessages.h"
#include "TCSuperSpiceView.h"
#include "TCGeneralReportsTab.h"
#include "TCWorkspaceTree.h"
#include "TCSymbolPreDoc.h"
#include "TCSymbolPreView.h"
#include "TCModelPreViewView.h"
#include "TCModelPreViewDoc.h"
#include "TCModelSymbolTab.h"
#include "TCFloatingCursorDlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceMainFrame


CPoint GlobalMousePosition;
CPoint GlobalMouseOffset;
float  global_zoom;
TCMultyTaskedString CGlobalStatusMessage;
TCMultyTaskedString CGlobalXSpiceMessage;
CString CGlobalRunStatus;

extern TCMultyTaskedString CGlobalXSpiceStatusNull;
extern TCSuperSpiceGlobalData GCSuperSpiceGlobalData;
extern TCSuperSpiceDataBase	GCSuperSpiceDataBase; 
extern CDC GlobalCDCTemp;
extern int	g_last_open_file_tree_tab;
extern TCSuperSpiceDoc *PCSuperSpiceDocLastFocused;

extern TCSuperSpiceView *PCSuperSpiceViewLastFocused;

CString GetProgramDirectory(void);
CString GetWebSiteName();
CString GetKevinsTutorialWebSiteName(void);
 
TCGeneralReportsTab GCGeneralReportsTab;
TCWorkspaceTree GCWorkspaceTree;
TCModelSymbolTab CModelSymbolTab;


void SetDataCursorBar(TCFloatingCursorData &CFloatingCursorData);
TCFloatingCursorDlg CDataCursorBar;

class TCSuperSpiceTextDoc;

CString GetHelpFileName(void);

IMPLEMENT_DYNAMIC(TCSuperSpiceMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(TCSuperSpiceMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(TCSuperSpiceMainFrame)
	ON_WM_CREATE()
	ON_WM_PAINT()
	ON_WM_CLOSE()
	ON_WM_DESTROY()
	ON_COMMAND(ID_HELP_GETCOMPUTERPASSWORD, OnHelpGetComputerPassword)
	ON_COMMAND(ID_HELP_ANASOFTWEBSITE, OnHelpAnasoftWebSite)
	ON_WM_HELPINFO()
	ON_COMMAND(ID_HELP_READMETXT, OnHelpReadmetxt)
//	ON_COMMAND(ID_HELP_HELP, OnHelp)
	ON_COMMAND(ID_HELP_SPICE3MANUAL, OnHelpSpice3manual)
	ON_COMMAND(ID_HELP_XSPICEMANUAL, OnHelpXspiceManual)
	ON_COMMAND(ID_FILE_NEWTEXTFILE, OnFileNewTextFile)
	ON_COMMAND(XTP_ID_CUSTOMIZE, OnCustomize)
		
	ON_COMMAND_RANGE(ID_VIEW_TOOLBAR_PIN_CONNECTORS, ID_TOOLBARS_XPSTYLE, OnToolBars)
	ON_UPDATE_COMMAND_UI_RANGE(ID_VIEW_TOOLBAR_PIN_CONNECTORS, ID_TOOLBARS_XPSTYLE, OnUpdateToolBars)
	ON_MESSAGE(XTPWM_DOCKINGPANE_NOTIFY, OnDockingPaneNotify)

	ON_COMMAND_RANGE(ID_TOOLBARS_DATAREADOUT, ID_TOOLBARS_OUTPUTREPRTBAR, OnShowDockedWindows)
	ON_UPDATE_COMMAND_UI_RANGE(ID_TOOLBARS_DATAREADOUT, ID_TOOLBARS_OUTPUTREPRTBAR, OnUpdateDockedWindows)

	ON_COMMAND_RANGE(ID_TOOLBARS_MODELFILES, ID_TOOLBARS_FILESTAB, OnShowDockedWindows)
	ON_UPDATE_COMMAND_UI_RANGE(ID_TOOLBARS_MODELFILES, ID_TOOLBARS_FILESTAB, OnUpdateDockedWindows)

	ON_UPDATE_COMMAND_UI_RANGE(ID_THEME_DEFAULT, ID_THEME_ACD, OnUpdateTheme)
	ON_COMMAND_RANGE(ID_THEME_DEFAULT, ID_THEME_FANCY, OnSwitchTheme)

	ON_COMMAND(ID_VIEW_OFFICE2007FRAME, OnViewOffice2007Frame)
	ON_UPDATE_COMMAND_UI(ID_VIEW_OFFICE2007FRAME, OnUpdateViewOffice2007Frame)
	ON_COMMAND(ID_HELP_ANALOGTUTORIALS, OnHelpAnalogtutorials)
	//}}AFX_MSG_MAP


	ON_COMMAND(ID_HELP, CMDIFrameWnd::OnHelp) 

	ON_UPDATE_COMMAND_UI(ID_MOUSE_POSITION, OnUpdateMousePosition)
	ON_UPDATE_COMMAND_UI(ID_STATUS_MESSAGE, OnUpdateStatusMessage)
	ON_UPDATE_COMMAND_UI(ID_XSPICE_MSG, OnUpdateXSpiceMessage)


END_MESSAGE_MAP()
 

static UINT indicators[] =
{
//	ID_SEPARATOR,           // status line indicator
	ID_XSPICE_MSG,
	ID_STATUS_MESSAGE,
	ID_MOUSE_POSITION,
	ID_SEPARATOR,			// status line indicator for F1 Help
}; 

static UINT uMenuIcons[] =
{
	IDR_ALL_BUTTONS,
	IDR_ALL_BUTTONS_TOOLBAR_2,
};
/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceMainFrame construction/destruction

TCSuperSpiceMainFrame::TCSuperSpiceMainFrame()
{
	// TODO: add member initialization code here
	
	GlobalMousePosition.x = 0;
	GlobalMousePosition.y = 0;
	GlobalMouseOffset.x	  = 0;
	GlobalMouseOffset.y	  = 0;
	CGlobalStatusMessage  = E_STATUS_MSG_IDLE;

	h_last_msg			= 0;
	m_last_msg_time		= 0;
	m_last_msg_wparm	= 0;
	m_last_msg_lparm	= 0;

	m_nCurrentTheme		= ID_THEME_VISUALSTUDIO2008;
	m_bOffice2007Frame  = 2;

	PCMSignalData	= NULL;
	PCMX1Y1Data		= NULL;
	PCMX2Y2Data		= NULL;
	PCMDXDYData		= NULL;
}

TCSuperSpiceMainFrame::~TCSuperSpiceMainFrame()
{

}

int TCSuperSpiceMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if(CXTPMDIFrameWnd::OnCreate(lpCreateStruct) == -1) return -1;

	if(CreateXTremeCtrlBars() == -1) return -1;	

	LoadToolBarState();

	SetupTabWindow();

	m_paneManager.InstallDockingPanes(this);

	m_paneManager.SetTheme(xtpPaneThemeVisualStudio2008);

	if(CreateDockingPanes() < 0) return -1;

	LoadPanesState();

	return 0;
}


int TCSuperSpiceMainFrame::CreateXTremeCtrlBars(void)
{
	if(CreateMainFrameStatusBar() < 0) return -1;

	if (!InitCommandBars()) return -1;

	XTPPaintManager()->SetTheme(xtpThemeVisualStudio2008);

	CXTPCommandBars* pCommandBars = GetCommandBars();

    if(pCommandBars == NULL)
    {
        TRACE0("Failed to create command bars object.\n");
        return -1;      // fail to create
    }

	if(CreateMenuBar() < 0) return -1;

	if(CreateMenuToolBar() < 0) return -1;

	if(CreateXTToolbar("General", IDR_TOOLBAR_GENERAL, xtpBarTop, true) < 0) return -1;

	DockControlBarNextTo(IDR_MAINFRAME, IDR_TOOLBAR_GENERAL);

	if(CreateXTToolbar("Zoom", IDR_ZOOM, xtpBarTop, true) < 0) return -1;

	DockControlBarNextTo(IDR_TOOLBAR_GENERAL, IDR_ZOOM);

	if(CreateXTToolbar("Basic Components", IDR_BASIC_COMPONENTS, xtpBarTop, true) < 0) return -1;

	DockControlBarNextTo(IDR_ZOOM, IDR_BASIC_COMPONENTS);

	if(CreateXTToolbar("Document Windows", IDR_TOOLBAR_WINDOWS, xtpBarTop, true) < 0) return -1;

	if(CreateXTToolbar("Graphs", IDR_TOOLBAR_GRAPH, xtpBarTop, true) < 0) return -1;

	DockControlBarNextTo(IDR_TOOLBAR_WINDOWS, IDR_TOOLBAR_GRAPH);

	if(CreateXTToolbar("Spice Run Analysis", IDR_TOOLBAR_RUN_ENABLE, xtpBarTop, true) < 0) return -1;

	DockControlBarNextTo(IDR_TOOLBAR_GRAPH, IDR_TOOLBAR_RUN_ENABLE);

	// not initially displayed

	if(CreateXTToolbar("Vacumme Tubes", IDR_TOOLBAR_TUBES, xtpBarTop, true) < 0) return -1;

	if(CreateXTToolbar("Generic Components", IDR_TOOLBAR_GENERIC, xtpBarTop, true) < 0) return -1;

	DockControlBarNextTo(IDR_TOOLBAR_TUBES, IDR_TOOLBAR_GENERIC);

	if(CreateXTToolbar("Transformers", IDR_TOOLBAR_TRANSFORMERS, xtpBarTop, true) < 0) return -1;

	DockControlBarNextTo(IDR_TOOLBAR_GENERIC, IDR_TOOLBAR_TRANSFORMERS);

	if(CreateXTToolbar("Digital Components", IDR_TOOLBAR_DIGITAL, xtpBarTop, true) < 0) return -1;

	DockControlBarNextTo(IDR_TOOLBAR_TRANSFORMERS, IDR_TOOLBAR_DIGITAL);

	if(CreateXTToolbar("Additional Components", IDR_TOOLBAR_MORE_COMPONENTS, xtpBarTop, true) < 0) return -1;


	ShowToolbar(IDR_TOOLBAR_TUBES, false); // so that toolbars are positioned correctly on boot up
	ShowToolbar(IDR_TOOLBAR_GENERIC, false);
	ShowToolbar(IDR_TOOLBAR_TRANSFORMERS, false);
	ShowToolbar(IDR_TOOLBAR_DIGITAL, false);
	ShowToolbar(IDR_TOOLBAR_MORE_COMPONENTS, false);

	//Right side toolbars

	if(CreateXTToolbar("Symbol Editor", IDR_TOOLBAR_SYMBOL_EDITOR, xtpBarRight, true) < 0) return -1;

	if(CreateXTToolbar("Pin Connectors", IDR_TOOLBAR_PIN_CONNECTORS, xtpBarRight, true) < 0) return -1;

	DockControlBarNextTo(IDR_TOOLBAR_SYMBOL_EDITOR, IDR_TOOLBAR_PIN_CONNECTORS);

	if(CreateXTToolbar("Additional Components", IDR_MISC_TOOLBAR, xtpBarRight, true) < 0) return -1;

	DockControlBarNextTo(IDR_TOOLBAR_PIN_CONNECTORS, IDR_MISC_TOOLBAR);

	return 0;
}

int TCSuperSpiceMainFrame::CreateMainFrameStatusBar(void)
{
 	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");

		return -1;      // fail to create
	}

	return 0;
}

int TCSuperSpiceMainFrame::CreateMenuBar(void)
{
	CXTPCommandBars* pCommandBars = GetCommandBars();

	if(!pCommandBars) return 0;

	CXTPCommandBar* pMenuBar = pCommandBars->SetMenu(_T("Menu Bar"), IDR_MAINFRAME);
    
	if(pMenuBar == NULL)
    {
        TRACE0("Failed to create menu bar.\n");

        return -1;      // fail to create
    }

	return 0;
}

int TCSuperSpiceMainFrame::CreateMenuToolBar(void)
{
	CXTPCommandBars* pCommandBars = GetCommandBars();

	if(!pCommandBars) return 0;

    CXTPToolBar* pToolBar = (CXTPToolBar*) pCommandBars->Add(_T("Standard"), xtpBarTop);
    
	if (!pToolBar || !pToolBar->LoadToolBar(IDR_MAINFRAME))
    {
        TRACE0("Failed to create toolbar\n");

        return -1;
    }
	return 0;
}


int TCSuperSpiceMainFrame::CreateXTToolbar(CString CName, int resorce_id, XTPBarPosition position, int visable)
{
	CXTPCommandBars* pCommandBars = GetCommandBars();

	if(!pCommandBars) return 0;

	CXTPToolBar* pBar = (CXTPToolBar*)pCommandBars->Add(_T(CName), position);

	if (!pBar || !pBar->LoadToolBar(resorce_id))
	{
		TRACE0("Failed to create toolbar\n");

		return -1;
	}

	if(!visable) pBar->SetVisible(FALSE);

	return 0;
}

int TCSuperSpiceMainFrame::CreateDockingPanes(void)
{
	int x, y;

	x = 200;
	y = 250;

	CXTPDockingPanePaintManager* pPaintManager = m_paneManager.GetPaintManager();

	CXTPTabPaintManager* pTabPaintManager = pPaintManager->GetTabPaintManager();

	pTabPaintManager->SetLayout(xtpTabLayoutMultiRow);

	CXTPDockingPane* pPaneModelFiles = m_paneManager.CreatePane(ID_TOOLBARS_MODELFILESTAB, CRect(0, 0, x, y), xtpPaneDockLeft);

	if(!pPaneModelFiles) return -1;

	CXTPDockingPane* pPaneSymbolFiles = m_paneManager.CreatePane(ID_TOOLBARS_SYMBOLFILESTAB, CRect(0, 0, x, y), xtpPaneDockLeft);

	if(!pPaneSymbolFiles) return -1;

	CXTPDockingPane* pPaneSignalsFiles = m_paneManager.CreatePane(ID_TOOLBARS_WAVEFORMSIGNALSLISTTAB, CRect(0, 0, x, y), xtpPaneDockLeft);

	if(!pPaneSignalsFiles) return -1;

	CXTPDockingPane* pPaneCircuits = m_paneManager.CreatePane(ID_TOOLBARS_CIRCUITBLOCKSTAB, CRect(0, 0, x, y), xtpPaneDockLeft);

	if(!pPaneCircuits) return -1;

	CXTPDockingPane* pPaneFiles = m_paneManager.CreatePane(ID_TOOLBARS_FILESTAB, CRect(0, 0, x, y), xtpPaneDockLeft);

	if(!pPaneFiles) return -1;

	m_paneManager.AttachPane(pPaneSymbolFiles, pPaneModelFiles);
	m_paneManager.AttachPane(pPaneSignalsFiles, pPaneSymbolFiles);
	m_paneManager.AttachPane(pPaneCircuits, pPaneSignalsFiles);
	m_paneManager.AttachPane(pPaneFiles, pPaneCircuits);

	pPaneModelFiles->Select();

	CXTPDockingPane* pPaneModel = m_paneManager.CreatePane(ID_TOOLBARS_MODELDATATAB, CRect(0, 0, x, 100), xtpPaneDockTop, pPaneModelFiles);

	if(!pPaneModel) return -1;

	CXTPDockingPane* pPaneSymbol = m_paneManager.CreatePane(ID_TOOLBARS_SYMBOLTAB, CRect(0, 0, x, 100), xtpPaneDockTop, pPaneModelFiles);

	if(!pPaneSymbol) return -1;

	m_paneManager.AttachPane(pPaneSymbol, pPaneModel);

	// Output bars on main frame bottom
	CXTPDockingPane* pPane = m_paneManager.CreatePane(ID_TOOLBARS_OUTPUTREPRTBAR, CRect(0, 0, 500, 150), xtpPaneDockBottom);

	if(!pPane) return -1;

	CXTPDockingPane* pPaneDataCursor = m_paneManager.CreatePane(ID_TOOLBARS_DATAREADOUT, CRect(0, 0, 100, 150), xtpPaneDockRight, pPane);

	if(!pPaneDataCursor) return -1;

	// Set the icons for the docking pane tabs.
	int nIDIcons[] = {ID_TOOLBARS_MODELFILESTAB, 
					  ID_TOOLBARS_SYMBOLFILESTAB,
					  ID_TOOLBARS_FILESTAB,
					  ID_TOOLBARS_CIRCUITBLOCKSTAB,
					  ID_TOOLBARS_WAVEFORMSIGNALSLISTTAB
					 };
		
	m_paneManager.SetIcons(IDB_IL_TAB, nIDIcons,_countof(nIDIcons), RGB(255, 255, 255));

	int IDIcons[] = {ID_TOOLBARS_MODELDATATAB, 
					  ID_TOOLBARS_SYMBOLTAB
					};

	m_paneManager.SetIcons(IDB_IL_TABGENERAL, IDIcons,_countof(IDIcons), RGB(255, 255, 255));

	return 0;
}

void TCSuperSpiceMainFrame::DockControlBarNextTo(int resource_id_left, int resource_id_right)
{
	CXTPCommandBars* pCommandBars = GetCommandBars();

	if(!pCommandBars) return;

    CXTPToolBar* pToolBarLeft = (CXTPToolBar*) pCommandBars->GetToolBar(resource_id_left);

	if(!pToolBarLeft) return;

	CXTPToolBar* pToolBarRight = (CXTPToolBar*) pCommandBars->GetToolBar(resource_id_right);

	if(!pToolBarRight) return;

	DockRightOf(pToolBarRight, pToolBarLeft);
}


void TCSuperSpiceMainFrame::SetupTabWindow(void)
{
	VERIFY(m_MTIClientWnd.Attach(this));

	m_MTIClientWnd.EnableToolTips();

	m_MTIClientWnd.GetPaintManager()->SetPosition(xtpTabPositionBottom);

	// Set the menu id for the tab control, make IDC_ACTIVATE the
	// default menu item.
//	m_wndMDITabWindow.SetMenuID(IDR_TAB_POPUP, 0, IDC_ACTIVATE);
}



/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceMainFrame diagnostics

#ifdef _DEBUG
void TCSuperSpiceMainFrame::AssertValid() const
{
	CXTPMDIFrameWnd ::AssertValid();
}

void TCSuperSpiceMainFrame::Dump(CDumpContext& dc) const
{
	CXTPMDIFrameWnd ::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceMainFrame message handlers

void TCSuperSpiceMainFrame::OnPaint() 
{
	CXTPMDIFrameWnd ::OnPaint();

}

void TCSuperSpiceMainFrame::OnCustomize()
{
    // Get a pointer to the command bars object.
    CXTPCommandBars* pCommandBars = GetCommandBars();
    if(pCommandBars != NULL)
    {
        // Instanciate the customize dialog object.
        CXTPCustomizeSheet dlg(pCommandBars);

        // Add the options page to the customize dialog.
        CXTPCustomizeOptionsPage pageOptions(&dlg);
        dlg.AddPage(&pageOptions);

        // Add the commands page to the customize dialog.
        CXTPCustomizeCommandsPage* pCommands = dlg.GetCommandsPage();
        pCommands->AddCategories(IDR_MAINFRAME);

        // Use the command bar manager to initialize the
        // customize dialog.
        pCommands->InsertAllCommandsCategory();
        pCommands->InsertBuiltInMenus(IDR_MAINFRAME);
        pCommands->InsertNewMenuCategory();

        // Dispaly the dialog.
        dlg.DoModal();
    }
}  
 
void TCSuperSpiceMainFrame::LoadPanesState(void)
{
	if(!GCSuperSpiceGlobalData.CGeneric.load_toolbar_state) return;

	CString CSectionName;

	CSectionName.LoadString(IDS_DOCKING_SECTION);

	CString CPanesName  = CSectionName + "Panes";

	CXTPDockingPaneLayout CPaneLayout(&m_paneManager);

	if (CPaneLayout.Load(_T(CPanesName)))
	{
		m_paneManager.SetLayout(&CPaneLayout);
	}
}

void TCSuperSpiceMainFrame::LoadToolBarState()
{
	if(!GCSuperSpiceGlobalData.CGeneric.load_toolbar_state) return;

	CString CSectionName;

	CSectionName.LoadString(IDS_DOCKING_SECTION);

	CString CBarsName	= CSectionName + "Bars";					 		

	LoadCommandBars(_T(CBarsName));
}

void TCSuperSpiceMainFrame::SaveToolBarsAndPanesState(void)
{
	CString CSectionName;

	CSectionName.LoadString(IDS_DOCKING_SECTION);

	CString CBarsName	= CSectionName + "Bars";
	CString CPanesName  = CSectionName + "Panes";

	// Save the docking panes
	CXTPDockingPaneLayout CPaneLayout(&m_paneManager);

	m_paneManager.GetLayout(&CPaneLayout);

	CPaneLayout.Save(_T(CPanesName));

	SaveCommandBars(_T(CBarsName));
}

void TCSuperSpiceMainFrame::OnClose() 
{
	SaveToolBarsAndPanesState();

	CString CSectionName;

	CSectionName.LoadString(IDS_MAINWINDOW_SECTION_NAME);

	SaveWindowLayout(this, CSectionName);

	//Save documents in order
	TCSuperSpiceApp *PCSuperSpiceApp;// overide the framework

	PCSuperSpiceApp = (TCSuperSpiceApp *) AfxGetApp();
	
	if(!PCSuperSpiceApp->CloseWorkSpaces()) return;// close top level superspice doc first, dont close if cancelled

	CXTPMDIFrameWnd ::OnClose();
}

void TCSuperSpiceMainFrame::OnUpdateMousePosition(CCmdUI *pCmdUI)
{
	pCmdUI->Enable();

	CString CText;
	int x, y;
	  
	float global_zoom = 1;

	if(PCSuperSpiceViewLastFocused) if(!IsBadCodePtr((FARPROC) PCSuperSpiceViewLastFocused)) 
		global_zoom = PCSuperSpiceViewLastFocused->CSuperSpiceViewData.PCMSchematicManager->GetZoom();

	x = (int)((GlobalMousePosition.x - GlobalMouseOffset.x) / global_zoom);
	y = (int)((GlobalMousePosition.y - GlobalMouseOffset.y) / global_zoom);

	CText.Format("X=%d, Y=%d", x, y);

	pCmdUI->SetText(CText); 
}
void TCSuperSpiceMainFrame::OnUpdateStatusMessage(CCmdUI *pCmdUI)
{
	pCmdUI->Enable();	

	CGlobalXSpiceMessage.Remove('\n');

	pCmdUI->SetText(CGlobalStatusMessage); 
}

void TCSuperSpiceMainFrame::OnUpdateXSpiceMessage(CCmdUI *pCmdUI)
{
	pCmdUI->Enable();	

	pCmdUI->SetText(CGlobalXSpiceMessage); 
}


void TCSuperSpiceMainFrame::RecalcLayout(BOOL bNotify) 
{	
	CXTPMDIFrameWnd ::RecalcLayout(bNotify);
}

void TCSuperSpiceMainFrame::OnHelpGetComputerPassword() 
{
	TCPasswordId CPasswordId;

	CPasswordId.DoModal();
}

void TCSuperSpiceMainFrame::OnHelpAnasoftWebSite() 
{
	CString CText;

	CText = GetWebSiteName();

	if(!ShellExecute(NULL, "open", CText, NULL, NULL, SW_SHOWNORMAL))
	{
		CGlobalStatusMessage.LoadString(IDS_UNABLETO_FIND_IE);

		GCGeneralReportsTab.DisplayMessage(IDS_ERR_WARNING, CGlobalStatusMessage, -1);
	}
}

void TCSuperSpiceMainFrame::OnHelpAnalogtutorials()
{
	CString CText;

	CText = GetKevinsTutorialWebSiteName();

	if(!ShellExecute(NULL, "open", CText, NULL, NULL, SW_SHOWNORMAL))
	{
		CGlobalStatusMessage.LoadString(IDS_UNABLETO_FIND_IE);

		GCGeneralReportsTab.DisplayMessage(IDS_ERR_WARNING, CGlobalStatusMessage, -1);
	}
}

void TCSuperSpiceMainFrame::OnHelp()
{
	AfxGetApp()->WinHelpInternal(0, HELP_CONTENTS);
}

BOOL TCSuperSpiceMainFrame::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	pHelpInfo;

	AfxGetApp()->WinHelpInternal(0, HELP_CONTENTS);
	
	return true;
}

void TCSuperSpiceMainFrame::OnHelpReadmetxt() 
{
	CString CText = GetProgramDirectory();

	CText += "Readme.txt";

	AfxGetApp()->OpenDocumentFile(CText);
}

void TCSuperSpiceMainFrame::OnHelpSpice3manual() 
{
	CString CText;

	CString CHelpFileName = GetProgramDirectory();

	CHelpFileName += GetHelpFileName();

	CHelpFileName += "::/html/Spice3F5Manual.html";

	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp *)AfxGetApp();

	PCSuperSpiceApp->Help(CHelpFileName);
}

void TCSuperSpiceMainFrame::OnHelpXspiceManual() 
{
	CString CText = GetProgramDirectory();

	CText += "xspice.txt";

	AfxGetApp()->OpenDocumentFile(CText);	
}



BOOL TCSuperSpiceMainFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	// TODO: Add your specialized code here and/or call the base class
	
	return CXTPMDIFrameWnd ::OnCreateClient(lpcs, pContext);
}

void TCSuperSpiceMainFrame::OnFileNewTextFile() 
{
	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp *)AfxGetApp();

	if(!PCSuperSpiceApp) return;

	CMultiDocTemplate *PCMSpiceTextViewDocTemplate = PCSuperSpiceApp->GetSpiceOutputTextViewDocTemplate();

	if(!PCMSpiceTextViewDocTemplate) return;

	TCSuperSpiceTextDoc  *PCDoc = (TCSuperSpiceTextDoc *) PCMSpiceTextViewDocTemplate->OpenDocumentFile(NULL);

	if(!PCDoc) return;	
}

void TCSuperSpiceMainFrame::OnFileNewTextFilePublic(void)
{
	OnFileNewTextFile();
}
 
bool TCSuperSpiceMainFrame::OnComponentsCreateSymbolForModel(void)
{
	return GCSuperSpiceDataBase.CreateSymbolForModel();
}


void TCSuperSpiceMainFrame::SetXSpiceStatusText(CString CText)
{
	CText = CGlobalRunStatus + CText; 

	CGlobalXSpiceMessage = CText;//Update geneal global value;

	m_wndStatusBar.SetPaneText(m_wndStatusBar.CommandToIndex(ID_XSPICE_MSG), CText);
}

BOOL TCSuperSpiceMainFrame::PreTranslateMessage(MSG* pMsg) 
{
//	WORD data = HIWORD(pMsg->wParam);

//	if(data == 1) 
//	{
//		data = 1;
//	}

	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp *) AfxGetApp();

	if(!PCSuperSpiceApp->super_spice_xspice_message) return CXTPMDIFrameWnd::PreTranslateMessage(pMsg);
	
	if(!PCSuperSpiceDocLastFocused && !h_last_msg) 
	{
		return CXTPMDIFrameWnd::PreTranslateMessage(pMsg);
	}
	else if(IsBadCodePtr((FARPROC) PCSuperSpiceDocLastFocused)) //if focus lost, try and keep processing data
	{
		if(!h_last_msg) return CXTPMDIFrameWnd::PreTranslateMessage(pMsg);	
	}
	else 
	{
		TCSuperSpiceDoc *PCSuperSpiceDoc = PCSuperSpiceDocLastFocused->GetTopLevelDoc();

		if(!PCSuperSpiceDoc) return CXTPMDIFrameWnd::PreTranslateMessage(pMsg);// program fault somewhere, on close usually

		h_last_msg = PCSuperSpiceDocLastFocused->GetTopLevelDoc()->h_msg; //remember last good mesage handle.
	}

	if(h_last_msg != pMsg->message) return CXTPMDIFrameWnd::PreTranslateMessage(pMsg);

	if(pMsg->hwnd == m_hWnd) return true;
	if(pMsg->wParam < E_XS_TO_SS_MSG_ACK) return true; // Ignore own messages

	if(IsDoublicateMsg(pMsg))return true;// Dont know why XS to SS dublicates messages
	
	PCSuperSpiceApp->ProccessSuperSpiceXSpiceMessage(pMsg);
	
	return true;
}

bool  TCSuperSpiceMainFrame::IsDoublicateMsg(MSG* pMsg)
{
	if(pMsg->time == m_last_msg_time && pMsg->wParam == m_last_msg_wparm && pMsg->lParam == m_last_msg_lparm) return true;
		
	m_last_msg_time		= pMsg->time;
	m_last_msg_wparm	= pMsg->wParam;
	m_last_msg_lparm	= pMsg->lParam;

	return false;
}

/*
void TCSuperSpiceMainFrame::OnStatusReportBar() 
{
	CControlBar* pBar = &CDockingStatusWindow;

	if (pBar != NULL)
	{
		ShowControlBar(pBar, (pBar->GetStyle() & WS_VISIBLE) == 0, FALSE);
	}	
}

void TCSuperSpiceMainFrame::OnUpdateStatusReportBar(CCmdUI* pCmdUI) 
{
	CControlBar* pBar = &CDockingStatusWindow;

	if (pBar != NULL)
	{
		pCmdUI->SetCheck((pBar->GetStyle() & WS_VISIBLE) != 0);
		return;
	}
	pCmdUI->ContinueRouting();	
}
*/

void TCSuperSpiceMainFrame::SetDataCursorBar(TCFloatingCursorData &CFloatingCursorData)
{
	if(!PCMX1Y1Data) return;
	if(!PCMX2Y2Data) return;
	if(!PCMDXDYData) return;

	CXTPDockingPane* pPane = m_paneManager.FindPane(ID_TOOLBARS_DATAREADOUT);

	if(!pPane) return;

	CString CDataText;

	CDataText = "Run: " + CFloatingCursorData.CRun;
	pPane->SetTitle(CDataText);

	CDataText = CFloatingCursorData.CSignalNameHeader + CFloatingCursorData.CSignalName;
	PCMSignalData->SetPrompt(CDataText);

	CDataText =  "X1: ";
	CDataText += FloatToMKSString(CFloatingCursorData.x1);
	PCMX1Y1Data->SetCaption(CDataText);

	CDataText =  "Y1: ";
	CDataText += FloatToMKSString(CFloatingCursorData.y1);
	PCMX1Y1Data->SetValue(CDataText);

	CDataText =  "X2: ";
	CDataText += FloatToMKSString(CFloatingCursorData.x2);
	PCMX2Y2Data->SetCaption(CDataText);

	CDataText =  "Y2: ";
	CDataText += FloatToMKSString(CFloatingCursorData.y2);
	PCMX2Y2Data->SetValue(CDataText);
	
	CDataText =  "DX: ";
	CDataText += FloatToMKSString(CFloatingCursorData.dx);
	PCMDXDYData->SetCaption(CDataText);

	CDataText =  "DY: ";
	CDataText += FloatToMKSString(CFloatingCursorData.dy);
	PCMDXDYData->SetValue(CDataText);
}

void SetDataCursorBar(TCFloatingCursorData &CFloatingCursorData)
{
	((TCSuperSpiceMainFrame*)AfxGetMainWnd())->SetDataCursorBar(CFloatingCursorData);
}

void TCSuperSpiceMainFrame::ShowToolbar(int id, bool visable)
{
	CXTPCommandBars* pCommandBars = GetCommandBars();

	if(!pCommandBars) return;

	CXTPToolBar* pToolBar = (CXTPToolBar*) pCommandBars->GetToolBar(id);

	if(!pToolBar) return;

	pToolBar->SetVisible(visable);
}

void TCSuperSpiceMainFrame::OnToolBars(UINT nID)
{
	CXTPCommandBars* pCommandBars = GetCommandBars();

	if(!pCommandBars) return;

	int id = GetToolBarIdFromMenuId(nID);

	if(!id) return;

	CXTPToolBar* pToolBar = (CXTPToolBar*) pCommandBars->GetToolBar(id);

	if(!pToolBar) return;

	pToolBar->SetVisible(!pToolBar->IsVisible());
}

void TCSuperSpiceMainFrame::OnUpdateToolBars(CCmdUI* pCmdUI)
{
	CXTPCommandBars* pCommandBars = GetCommandBars();

	if(!pCommandBars) return;

	int id = GetToolBarIdFromMenuId(pCmdUI->m_nID);

	if(!id) return;

	CXTPToolBar* pToolBar = (CXTPToolBar*) pCommandBars->GetToolBar(id);

	if(!pToolBar) return;

	pCmdUI->SetCheck(pToolBar->IsVisible() ? TRUE : FALSE);
}

int TCSuperSpiceMainFrame::GetToolBarIdFromMenuId(int id)
{
	switch(id)
	{
		case ID_TOOLBAR_MAIN: return IDR_MAINFRAME;
		case ID_TOOLBAR_WINDOWS: return IDR_TOOLBAR_WINDOWS;
		case ID_TOOLBAR_RUNENABLES: return IDR_TOOLBAR_RUN_ENABLE;
		case ID_TOOLBARS_MISC: return IDR_MISC_TOOLBAR;
		case ID_TOOLBARS_SYMBOLEDITOR: return IDR_TOOLBAR_SYMBOL_EDITOR;
		case ID_TOOLBARS_PINCONECTORS: return IDR_TOOLBAR_PIN_CONNECTORS;
		case ID_TOOLBAR_GRAPHSELECT: return IDR_TOOLBAR_GRAPH;
		case ID_TOOLBAR_TUBES: return IDR_TOOLBAR_TUBES;
		case ID_TOOLBAR_GENERICCOMPONENTS: return IDR_TOOLBAR_GENERIC;
		case ID_TOOLBAR_TRANSFORMERS: return IDR_TOOLBAR_TRANSFORMERS;
		case ID_TOOLBARS_DIGITAL: return IDR_TOOLBAR_DIGITAL;
		case ID_TOOLBARS_MORECOMPONENTS: return IDR_TOOLBAR_MORE_COMPONENTS;
		case ID_TOOLBAR_ZOOM: return IDR_ZOOM;
		case ID_TOOLBAR_MAINCOMPONENTS: return IDR_BASIC_COMPONENTS;
		case ID_TOOLBAR_GENERALSETUPS: return IDR_TOOLBAR_GENERAL;

	}

	return 0;
}


void TCSuperSpiceMainFrame::OnShowDockedWindows(UINT nID)
{
	if(m_paneManager.IsPaneClosed(nID)) m_paneManager.ShowPane(nID); 

	else m_paneManager.ClosePane(nID);
}


void TCSuperSpiceMainFrame::OnUpdateDockedWindows(CCmdUI* pCmdUI)
{
	int check = m_paneManager.IsPaneClosed(pCmdUI->m_nID);

	pCmdUI->SetCheck(!check ? TRUE : FALSE);
}


LRESULT TCSuperSpiceMainFrame::OnDockingPaneNotify(WPARAM wParam, LPARAM lParam)
{
	if (wParam == XTP_DPN_SHOWWINDOW)
	{
		CXTPDockingPane* pPane = (CXTPDockingPane*)lParam;

		if(!pPane) return false;

		if (!pPane->IsValid())
		{
			switch (pPane->GetID())
			{
				case ID_TOOLBARS_OUTPUTREPRTBAR:			return CreateOutputReportBar(pPane); 

				case ID_TOOLBARS_DATAREADOUT:				return CreatePropertyGridwaveformDataBar(pPane);

				case ID_TOOLBARS_MODELFILESTAB:				return CreateModelFilesTab(pPane); 						
					
				case ID_TOOLBARS_SYMBOLFILESTAB :			return CreateSymbolFilesTab(pPane); 	
	
				case ID_TOOLBARS_WAVEFORMSIGNALSLISTTAB:	return CreateWaveformListTab(pPane);

				case ID_TOOLBARS_FILESTAB:					return CreateWorkspaceFilesTab(pPane);

				case ID_TOOLBARS_CIRCUITBLOCKSTAB:			return CreateCircuitFilesTab(pPane);

				case ID_TOOLBARS_MODELDATATAB:				return CreateModelPreviewTab(pPane); 

				case ID_TOOLBARS_SYMBOLTAB:					return CreateSymbolPreviewTab(pPane);
			}
		}
		return true;
	}
	
	return false;
}

bool TCSuperSpiceMainFrame::CreateOutputReportBar(CXTPDockingPane* pPane)
{
	if (!GCGeneralReportsTab.GetSafeHwnd())		
	{
		GCGeneralReportsTab.Create(WS_VSCROLL | WS_HSCROLL |ES_AUTOHSCROLL|ES_MULTILINE|WS_VISIBLE, CXTPEmptyRect(), this, 0);
	}
	else return false;
			
	pPane->Attach(&GCGeneralReportsTab);
			
	pPane->SetTitle("Reports");
	
	GCGeneralReportsTab.m_enable = true;
				
	GCGeneralReportsTab.SetMaxNumberLines(1024);

	GCGeneralReportsTab.DisplayHeaderText(); 

	return true;
}

bool TCSuperSpiceMainFrame::CreatePropertyGridwaveformDataBar(CXTPDockingPane* pPane)
{
	if (!CMPropertyGridWaveformDataBar.GetSafeHwnd())
	{
		if(!CMPropertyGridWaveformDataBar.Create( CRect(0, 0, 0, 0), this, 0 )) return false;

		CMPropertyGridWaveformDataBar.SetOwner(this);
	}

	pPane->Attach(&CMPropertyGridWaveformDataBar); 

	pPane->SetTitle("Run: Normal");

	PCMSignalData      = CMPropertyGridWaveformDataBar.AddCategory(_T("None"));

	if(!PCMSignalData)  return false;

	PCMX1Y1Data	= PCMSignalData->AddChildItem(new CXTPPropertyGridItem(_T("X1: 0.0"), _T("Y1: 0.0")));
	PCMX2Y2Data	= PCMSignalData->AddChildItem(new CXTPPropertyGridItem(_T("X2: 0.0"), _T("Y2: 0.0")));
	PCMDXDYData  = PCMSignalData->AddChildItem(new CXTPPropertyGridItem(_T("DX: 0.0"), _T("DY: 0.0")));

	if(!PCMX1Y1Data) return false;
	if(!PCMX2Y2Data) return false;
	if(!PCMDXDYData) return false;

	PCMX1Y1Data->SetReadOnly(TRUE);
	PCMX2Y2Data->SetReadOnly(TRUE);
	PCMDXDYData->SetReadOnly(TRUE);

	CMPropertyGridWaveformDataBar.ShowHelp(false);
	PCMSignalData->Expand();

	return true;
}

bool TCSuperSpiceMainFrame::CreateWorkspaceTabs(void)
{

	return true;
}

bool TCSuperSpiceMainFrame::CreateModelFilesTab(CXTPDockingPane* pPane)
{
	TCSuperSpiceApp *PCApp = (TCSuperSpiceApp *)AfxGetApp();

	if(!GCWorkspaceTree.PCMModelTreeDoc)
		GCWorkspaceTree.PCMModelTreeDoc = (TCModelTreeDoc *) PCApp->GetModelTreeTemplate()->CreateNewDocument();

	if(!GCWorkspaceTree.PCMModelTreeDoc) return false;

	pPane->AttachView(this, RUNTIME_CLASS(TCModelTreeView), GCWorkspaceTree.PCMModelTreeDoc);

	pPane->SetTitle("Model Files");

	GCWorkspaceTree.PCMModelTreeDoc->Refresh();

	return true;
}

bool TCSuperSpiceMainFrame::CreateSymbolFilesTab(CXTPDockingPane* pPane)
{
	TCSuperSpiceApp *PCApp = (TCSuperSpiceApp *)AfxGetApp();

	if(!GCWorkspaceTree.PCMSymbolTreeDoc)
		GCWorkspaceTree.PCMSymbolTreeDoc = (TCSymbolTreeDoc *) PCApp->GetSymbolTreeTemplate()->CreateNewDocument();

	if(!GCWorkspaceTree.PCMSymbolTreeDoc) return false;

	pPane->AttachView(this, RUNTIME_CLASS(TCSymbolTreeView), GCWorkspaceTree.PCMSymbolTreeDoc);

	pPane->SetTitle("Symbol Files");

	GCWorkspaceTree.PCMSymbolTreeDoc->Refresh();

	return true;
}

bool TCSuperSpiceMainFrame::CreateWaveformListTab(CXTPDockingPane* pPane)
{
	TCSuperSpiceApp *PCApp = (TCSuperSpiceApp *)AfxGetApp();

	if(!GCWorkspaceTree.PCMSignalsTreeDoc)
		GCWorkspaceTree.PCMSignalsTreeDoc = (TCSignalsTreeDoc *) PCApp->GetSignalsTreeTemplate()->CreateNewDocument();

	if(!GCWorkspaceTree.PCMSignalsTreeDoc) return false;

	pPane->AttachView(this, RUNTIME_CLASS(TCSignalsTreeView), GCWorkspaceTree.PCMSignalsTreeDoc);

	pPane->SetTitle("Signals");

	return true;
}

bool TCSuperSpiceMainFrame::CreateCircuitFilesTab(CXTPDockingPane* pPane)
{
	TCSuperSpiceApp *PCApp = (TCSuperSpiceApp *)AfxGetApp();

	GCWorkspaceTree.PCMCircuitsTreeDoc = (TCCircuitsTreeDoc *) PCApp->GetCircuitsTreeTemplate()->CreateNewDocument();

	if(!GCWorkspaceTree.PCMCircuitsTreeDoc)
		if(!GCWorkspaceTree.PCMCircuitsTreeDoc) return false;

	pPane->AttachView(this, RUNTIME_CLASS(TCCircuitsTreeView), GCWorkspaceTree.PCMCircuitsTreeDoc);

	pPane->SetTitle("Circuits");

	GCWorkspaceTree.PCMCircuitsTreeDoc->Refresh();

	return true;
}

bool TCSuperSpiceMainFrame::CreateWorkspaceFilesTab(CXTPDockingPane* pPane)
{
	TCSuperSpiceApp *PCApp = (TCSuperSpiceApp *)AfxGetApp();

	if(!GCWorkspaceTree.PCMFileTreeDoc)
		GCWorkspaceTree.PCMFileTreeDoc = (TCFileTreeDoc *) PCApp->GetFileTreeTemplate()->CreateNewDocument();

	if(!GCWorkspaceTree.PCMFileTreeDoc) return false;

	pPane->AttachView(this, RUNTIME_CLASS(TCFileTreeView), GCWorkspaceTree.PCMFileTreeDoc);

	pPane->SetTitle("Files");

	GCWorkspaceTree.PCMFileTreeDoc->Refresh();

	return true;
}

bool TCSuperSpiceMainFrame::CreateModelSymbolPreviwDataTabs(void)
{

	return true;
}

bool TCSuperSpiceMainFrame::CreateModelPreviewTab(CXTPDockingPane* pPane)
{
	TCSuperSpiceApp *PCApp = (TCSuperSpiceApp *)AfxGetApp();

	if(!CModelSymbolTab.PCModelPreviewDoc)
		CModelSymbolTab.PCModelPreviewDoc = (TCModelPreviewDoc *) PCApp->GetModelPreviewTemplate()->CreateNewDocument();

	if(!CModelSymbolTab.PCModelPreviewDoc) return false;

	pPane->AttachView(this, RUNTIME_CLASS(TCModelPreViewView), CModelSymbolTab.PCModelPreviewDoc);

	pPane->SetTitle("Model");

	return true;
}

bool TCSuperSpiceMainFrame::CreateSymbolPreviewTab(CXTPDockingPane* pPane)
{
	TCSuperSpiceApp *PCApp = (TCSuperSpiceApp *)AfxGetApp();

	if(!CModelSymbolTab.PCMSymbolPreDoc)
		CModelSymbolTab.PCMSymbolPreDoc = (TCSymbolPreDoc *) PCApp->GetSymbolPreviewTemplate()->CreateNewDocument();

	if(!CModelSymbolTab.PCMSymbolPreDoc) return false;

	pPane->AttachView(this, RUNTIME_CLASS(TCSymbolPreView), CModelSymbolTab.PCMSymbolPreDoc);

	pPane->SetTitle("Symbol");

	return true;
}


void TCSuperSpiceMainFrame::RedrawPane(UINT nID)
{
	if(m_paneManager.IsPaneClosed(nID)) return;

	m_paneManager.ClosePane(nID);

	m_paneManager.ShowPane(nID);
}

void TCSuperSpiceMainFrame::RedrawAllPanes(void)
{
	RedrawPane(ID_TOOLBARS_OUTPUTREPRTBAR);
	RedrawPane(ID_TOOLBARS_DATAREADOUT);
	
	RedrawPane(ID_TOOLBARS_CIRCUITBLOCKSTAB);
	RedrawPane(ID_TOOLBARS_FILESTAB);
	RedrawPane(ID_TOOLBARS_WAVEFORMSIGNALSLISTTAB);
	RedrawPane(ID_TOOLBARS_SYMBOLFILESTAB);
	RedrawPane(ID_TOOLBARS_MODELFILESTAB);

	RedrawPane(ID_TOOLBARS_SYMBOLTAB);
	RedrawPane(ID_TOOLBARS_MODELDATATAB);
}

void TCSuperSpiceMainFrame::OnDestroy()
{
	CMDIFrameWnd::OnDestroy();

	m_MTIClientWnd.Detach();
}

BOOL TCSuperSpiceMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
    // Size the window to 90%/95% screen size and center it 
    cs.cy = (int)(::GetSystemMetrics(SM_CYSCREEN) *.90); 
    cs.cx = (int)(::GetSystemMetrics(SM_CXSCREEN) *.95); 
    cs.y = (int)(((cs.cy / 0.90) - cs.cy) / 2); 
    cs.x = (int)(((cs.cx / 0.95) - cs.cx) / 2);


	return CXTPMDIFrameWnd ::PreCreateWindow(cs);
}

void TCSuperSpiceMainFrame::SetCustomTheme(CXTPPaintManager* pTheme)
{
	CXTPPaintManager::SetCustomTheme(pTheme);
/*
	if ((m_bOffice2007Frame == 1) || ((pTheme->BaseTheme() == xtpThemeOffice2007 || pTheme->BaseTheme() == xtpThemeRibbon) &&
		(m_bOffice2007Frame == 2)))
	{
		EnableOffice2007Frame(GetCommandBars());
	}
	else
	{
		EnableOffice2007Frame(0);
	}
*/
	GetCommandBars()->RedrawCommandBars();
}

void TCSuperSpiceMainFrame::OnUpdateTheme(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck(pCmdUI->m_nID == m_nCurrentTheme ? TRUE : FALSE);
}
void TCSuperSpiceMainFrame::OnSwitchTheme(UINT nTheme)
{
	switch (nTheme)
	{
		case ID_THEME_DEFAULT: SetCustomTheme(new CXTPDefaultTheme()); m_paneManager.SetTheme(xtpPaneThemeGrippered);break;
		case ID_THEME_OFFICE_XP: SetCustomTheme(new CXTPOfficeTheme()); m_paneManager.SetTheme(xtpPaneThemeDefault);break;
		case ID_THEME_OFFICE_2003: SetCustomTheme(new CXTPOffice2003Theme()); m_paneManager.SetTheme(xtpPaneThemeOffice2003);break;
		case ID_THEME_WINDOWS_XP: SetCustomTheme(new CXTPNativeXPTheme()); m_paneManager.SetTheme(xtpPaneThemeWinNative);break;
		case ID_THEME_RIBBON: SetCustomTheme(new CXTPRibbonTheme()); m_paneManager.SetTheme(xtpPaneThemeCustom);break;
		case ID_THEME_OFFICE2007: SetCustomTheme(new CXTPOffice2007Theme()); m_paneManager.SetTheme(xtpPaneThemeOffice2007);break;
		case ID_THEME_VISUALSTUDIO2008: SetCustomTheme(new CXTPVisualStudio2008Theme()); m_paneManager.SetTheme(xtpPaneThemeVisualStudio2008);break;

		case ID_THEME_MAC: SetCustomTheme(new CCustomMacTheme()); m_paneManager.SetTheme(xtpPaneThemeGrippered);break;
		case ID_THEME_GRAY: SetCustomTheme(new CCustomGrayTheme()); m_paneManager.SetTheme(xtpPaneThemeGrippered);break;
		case ID_THEME_ICY: SetCustomTheme(new CCustomIcyTheme()); m_paneManager.SetTheme(xtpPaneThemeGrippered);break;
		case ID_THEME_GRAD: SetCustomTheme(new CCustomGradientTheme()); m_paneManager.SetTheme(xtpPaneThemeGrippered);break;
		case ID_THEME_BEVEL: SetCustomTheme(new CCustomBevelTheme()); m_paneManager.SetTheme(xtpPaneThemeGrippered);break;
		case ID_THEME_FANCY: SetCustomTheme(new CCustomFancyTheme()); m_paneManager.SetTheme(xtpPaneThemeGrippered);break;
		case ID_THEME_ACD: SetCustomTheme(new CCustomBackgroundTheme()); m_paneManager.SetTheme(xtpPaneThemeGrippered);break;
	}

	// overide styles and keep tabs as multiline
	CXTPDockingPanePaintManager* pPaintManager = m_paneManager.GetPaintManager();

	CXTPTabPaintManager* pTabPaintManager = pPaintManager->GetTabPaintManager();

	pTabPaintManager->SetLayout(xtpTabLayoutMultiRow);

	m_nCurrentTheme = nTheme;
}

void TCSuperSpiceMainFrame::OnViewOffice2007Frame()
{
	m_bOffice2007Frame = m_bOffice2007Frame + 1;
	if (m_bOffice2007Frame == 3) m_bOffice2007Frame = 0;

	OnSwitchTheme(m_nCurrentTheme);
}

void TCSuperSpiceMainFrame::OnUpdateViewOffice2007Frame(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(TRUE);
	pCmdUI->SetCheck(m_bOffice2007Frame);
}
