// TCSuperSpiceMainFrame.h : interface of the TCSuperSpiceMainFrame class
//
/////////////////////////////////////////////////////////////////////////////
//#include "TCDockingStatusWindow.h"
#include "TCFloatingCursorDlg.h"



class TCSuperSpiceMainFrame : public CXTPMDIFrameWnd, CXTPOffice2007FrameHook 
{

	DECLARE_DYNAMIC(TCSuperSpiceMainFrame)
public:
	TCSuperSpiceMainFrame();

	UINT h_last_msg;
	DWORD m_last_msg_time;
	WPARAM m_last_msg_wparm;
	LPARAM m_last_msg_lparm;

	UINT m_nCurrentTheme;

	UINT m_bOffice2007Frame;

// Attributes
public:

	CStatusBar			m_wndStatusBar;
	CXTPToolBar				m_wndToolBar; 
	CXTPDockingPaneManager	m_paneManager;
	CXTPPropertyGrid		CMPropertyGridWaveformDataBar;

	// data readout grid
	CXTPPropertyGridItem* PCMSignalData;
	CXTPPropertyGridItem* PCMX1Y1Data;
	CXTPPropertyGridItem* PCMX2Y2Data;
	CXTPPropertyGridItem* PCMDXDYData;


	// Tab Window support

	CXTPTabClientWnd		m_MTIClientWnd;

	void SetupTabWindow(void);

// Tab Window support

// Operations
public:

	void DocXTremeCtrlBars(void);
	int  CreateXTremeCtrlBars(void);

	bool IsDoublicateMsg(MSG* pMsg);

	void OnFileNewTextFilePublic(void);
	bool OnComponentsCreateSymbolForModel(void);
	void DockControlBarNextTo(int resource_id_left, int resource_id_right);

	void SetXSpiceStatusText(CString CText);

	int CreateMainFrameStatusBar(void);
	int CreateMenuBar(void);
	int CreateMenuToolBar(void);
	int CreateXTToolbar(CString CName, int resorce_id, XTPBarPosition position, int visable);
	int CreateDockingPanes(void);
	int GetToolBarIdFromMenuId(int id);

	CImageList  CMWorkSpacebarTabImages;
	
	CImageList  CMCreateGeneralTabImages;

	bool CreateOutputReportBar(CXTPDockingPane* pPane);
	bool CreatePropertyGridwaveformDataBar(CXTPDockingPane* pPane);

	bool CreateWorkspaceTabs(void);
	bool CreateModelFilesTab(CXTPDockingPane* pPane);
	bool CreateSymbolFilesTab(CXTPDockingPane* pPane);
	bool CreateWaveformListTab(CXTPDockingPane* pPane);
	bool CreateCircuitFilesTab(CXTPDockingPane* pPane);
	bool CreateWorkspaceFilesTab(CXTPDockingPane* pPane);

	bool CreateModelSymbolPreviwDataTabs(void);
	bool CreateModelPreviewTab(CXTPDockingPane* pPane);
	bool CreateSymbolPreviewTab(CXTPDockingPane* pPane);

	void SetDataCursorBar(TCFloatingCursorData &CFloatingCursorData);

	void RedrawPane(UINT nID);
	void RedrawAllPanes(void);
	void ShowToolbar(int id, bool visable);

	void LoadToolBarState(void);
	void LoadPanesState(void);
	void SaveToolBarsAndPanesState(void);
	void SetCustomTheme(CXTPPaintManager* pTheme);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(TCSuperSpiceMainFrame)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void RecalcLayout(BOOL bNotify = TRUE);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual BOOL OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~TCSuperSpiceMainFrame();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:  


// Generated message map functions
protected:
	//{{AFX_MSG(TCSuperSpiceMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnPaint();
	afx_msg void OnClose();
	afx_msg void OnDestroy();
	afx_msg void OnHelp();
	afx_msg void OnHelpGetComputerPassword();
	afx_msg void OnHelpAnasoftWebSite();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void OnHelpReadmetxt();
	afx_msg void OnHelpSpice3manual();
	afx_msg void OnHelpXspiceManual();
	afx_msg void OnFileNewTextFile();
	afx_msg void OnToolBars(UINT nID);
	afx_msg void OnUpdateToolBars(CCmdUI* pCmdUI);
	afx_msg LRESULT OnDockingPaneNotify(WPARAM wParam, LPARAM lParam);
	afx_msg void OnShowDockedWindows(UINT nID);
	afx_msg void OnUpdateDockedWindows(CCmdUI* pCmdUI);
	afx_msg void OnCustomize();
	afx_msg void OnUpdateTheme(CCmdUI* pCmdUI);
	afx_msg void OnSwitchTheme(UINT nTheme);
	afx_msg void OnUpdateViewOffice2007Frame(CCmdUI* pCmdUI);
	afx_msg void OnViewOffice2007Frame();
	//}}AFX_MSG

	afx_msg void OnUpdateMousePosition(CCmdUI *pCmdUI);
	afx_msg void OnUpdateStatusMessage(CCmdUI *pCmdUI);
	afx_msg void OnUpdateXSpiceMessage(CCmdUI *pCmdUI);

	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnHelpAnalogtutorials();
};

/////////////////////////////////////////////////////////////////////////////
