// TCSuperSpiceSchematicProperty1.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TDVersion.h"
#include "TCFontDialog.h"
#include "TCSuperSpiceSchematicPropertyPages.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern int g_last_active_schematic_page;
extern TCSuperSpiceGlobalData	GCSuperSpiceGlobalData;

IMPLEMENT_DYNCREATE(TCSuperSpiceSchematicProperty1, CPropertyPage)
IMPLEMENT_DYNCREATE(TCSuperSpiceSchematicProperty2, CPropertyPage)
IMPLEMENT_DYNCREATE(TCSuperSpiceSchematicProperty3, CPropertyPage)
IMPLEMENT_DYNCREATE(TCSuperSpiceSchematicProperty4, CPropertyPage)


TCSuperSpiceSchematicProperty1::TCSuperSpiceSchematicProperty1() : CPropertyPage(TCSuperSpiceSchematicProperty1::IDD)
{
	//{{AFX_DATA_INIT(TCSuperSpiceSchematicProperty1)
	CMPageTitle = _T("");
	m_page_number = 0;
	CMPageInfo = _T("");
	CMEditFileName = _T("");
	//}}AFX_DATA_INIT
}

TCSuperSpiceSchematicProperty1::~TCSuperSpiceSchematicProperty1()
{

}

void TCSuperSpiceSchematicProperty1::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCSuperSpiceSchematicProperty1)
	DDX_Control(pDX, IDC_PAGE_NUMBER_SPIN, CMPageNumberSpin);
	DDX_Control(pDX, IDC_PAGE_TITLE, CMEditPageTitle);
	DDX_Text(pDX, IDC_PAGE_TITLE, CMPageTitle);
	DDX_Text(pDX, IDC_PAGE_NUMBER, m_page_number);
	DDX_Text(pDX, IDC_PAGE_INFO, CMPageInfo);
	DDX_Text(pDX, IDC_EDIT_FILE_NAME, CMEditFileName);
	//}}AFX_DATA_MAP


}


BEGIN_MESSAGE_MAP(TCSuperSpiceSchematicProperty1, CPropertyPage)
	//{{AFX_MSG_MAP(TCSuperSpiceSchematicProperty1)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

TCSchematicPageData &TCSuperSpiceSchematicProperty1::GetData(void)
{
	CMData.page_number	= m_page_number;
	CMData.CPageInfo	= CMPageInfo;
	CMData.CPageTitle	= CMPageTitle;
	CMData.CFileName	= CMEditFileName;

	return CMData;
}

BOOL TCSuperSpiceSchematicProperty1::SetData(TCSchematicPageData &CData)
{
	CMData	= CData;

	m_page_number	= CMData.page_number;
	CMPageInfo		= CMData.CPageInfo ;
	CMPageTitle		= CMData.CPageTitle;
	CMEditFileName	= CMData.CFileName;

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceSchematicProperty2 property page

TCSuperSpiceSchematicProperty2::TCSuperSpiceSchematicProperty2() : CPropertyPage(TCSuperSpiceSchematicProperty2::IDD)
{
	//{{AFX_DATA_INIT(TCSuperSpiceSchematicProperty2)
	m_is_grid_display_on = FALSE;
	m_is_snap_to_grid_on = FALSE;
	m_is_move_with_snap_to_grid = FALSE;
	m_is_draw_orthoganal_on = FALSE;
	m_is_rubber_band_on = FALSE;
	m_grid_size = 0;
	m_snap_to_distance = 0;
	m_all_enclosed = FALSE;
	m_hyde_labels = FALSE;
	m_fastest_drawing_mode = FALSE;
	m_symbol_editor_grid_size = 0;
	m_symbol_editor_snap_to_distance = 0;
	m_draw_schematic_page_border = FALSE;
	m_draw_waveform_page_border = FALSE;
	m_vector_printing = FALSE;
	m_display_connection_dots = FALSE;
	m_connection_dot_size = 0;
	m_labels_schematic = FALSE;
	m_lables_graph = FALSE;
	m_lable_graph_x = 0;
	m_lable_graph_y = 0;
	m_lable_schematic_x = 0;
	m_lable_schematic_y = 0;
	m_repeat_pasting = FALSE;
	//}}AFX_DATA_INIT
}

TCSuperSpiceSchematicProperty2::~TCSuperSpiceSchematicProperty2()
{
}

void TCSuperSpiceSchematicProperty2::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCSuperSpiceSchematicProperty2)
	DDX_Check(pDX, IDC_CHECK_DISPLAY_GRID, m_is_grid_display_on);
	DDX_Check(pDX, IDC_CHECK_SNAP_TO_GRID, m_is_snap_to_grid_on);
	DDX_Check(pDX, IDC_CHECK_MOVE_ON_GRID, m_is_move_with_snap_to_grid);
	DDX_Check(pDX, IDC_CHECK_DRAW_ORTHOGANAL_WIRES, m_is_draw_orthoganal_on);
	DDX_Check(pDX, IDC_CHECK_RUBBERBAND, m_is_rubber_band_on);
	DDX_Text(pDX, IDC_EDIT_GRID_SIZE, m_grid_size);
	DDV_MinMaxInt(pDX, m_grid_size, 1, 32765);
	DDX_Text(pDX, IDC_EDIT_SNAP_TO_DISTANCE, m_snap_to_distance);
	DDX_Check(pDX, IDC_CHECK_ALL_ENCLOSED, m_all_enclosed);
	DDX_Check(pDX, IDC_CHECK_HYDE_LABELS, m_hyde_labels);
	DDX_Check(pDX, IDC_CHECK_FASTEST_DRAWING_MODE, m_fastest_drawing_mode);
	DDX_Text(pDX, IDC_EDIT_GRID_SIZE_SYMBOL_EDITOR, m_symbol_editor_grid_size);
	DDX_Text(pDX, IDC_EDIT_SNAP_TO_DISTANCE_SYMBOL_EDITOR, m_symbol_editor_snap_to_distance);
	DDX_Check(pDX, IDC_CHECK_FASTEST_DRAW_PAGE_OUTLINE, m_draw_schematic_page_border);
	DDX_Check(pDX, IDC_CHECK_VECTOR_PRINTING, m_draw_waveform_page_border); // re-assigned m_vector_printing
	DDX_Check(pDX, IDC_CHECK_DISPLAY_CONNECTION_DOTS, m_display_connection_dots);
	DDX_Text(pDX, IDC_EDIT_CONNECTION_DOT_SIZE, m_connection_dot_size);
	DDV_MinMaxUInt(pDX, m_connection_dot_size, 0, 256);
	DDX_Check(pDX, IDC_CHECK_FLOATING_LABLR_SCHEMATIC, m_labels_schematic);
	DDX_Check(pDX, IDC_CHECK_FLOATING_LABLR_GRAPHS, m_lables_graph);
	DDX_Text(pDX, IDC_EDIT_LABLE_GRAPH_X, m_lable_graph_x);
	DDX_Text(pDX, IDC_EDIT_LABLE_GRAPH_Y, m_lable_graph_y);
	DDX_Text(pDX, IDC_EDIT_LABLE_SCH_X, m_lable_schematic_x);
	DDX_Text(pDX, IDC_EDIT_LABLE_SCH_Y, m_lable_schematic_y);
	DDX_Check(pDX, IDC_CHECK_FASTEST_DRAW_REPEAT_PASTE, m_repeat_pasting);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCSuperSpiceSchematicProperty2, CPropertyPage)
	//{{AFX_MSG_MAP(TCSuperSpiceSchematicProperty2)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

TCSuperSpiceDrawData &TCSuperSpiceSchematicProperty2::GetData(void)
{
	CMData.grid_size				= m_grid_size;
	CMData.is_grid_display_on		= m_is_grid_display_on;
	CMData.is_snap_to_grid_on		= m_is_snap_to_grid_on;
	CMData.is_rubber_band_on		= m_is_rubber_band_on;
	CMData.is_draw_orthoganal_on	= m_is_draw_orthoganal_on;
	CMData.is_move_with_snap_to_grid= m_is_move_with_snap_to_grid;
	CMData.snap_to_distance			= m_snap_to_distance;
	CMData.all_enclosed				= m_all_enclosed;
	CMData.hyde_labels				= m_hyde_labels;
	CMData.fastest_drawing_mode		= m_fastest_drawing_mode;
	CMData.symbol_editor_snap_to_distance = m_symbol_editor_snap_to_distance;
	CMData.symbol_editor_grid_size = m_symbol_editor_grid_size;
	CMData.draw_schematic_page_border	= m_draw_schematic_page_border;
	CMData.draw_waveform_page_border	= m_draw_waveform_page_border;
	
	CMData.vector_printing			= m_vector_printing;
	CMData.display_connection_dots	= m_display_connection_dots;
	CMData.connection_dot_size		= m_connection_dot_size;
	CMData.repeat_pasting			= m_repeat_pasting;

	CMData.labels_schematic			= m_labels_schematic;
	CMData.lables_graph				= m_lables_graph;
	CMData.lable_graph_x			= m_lable_graph_x;
	CMData.lable_graph_y			= m_lable_graph_y;
	CMData.lable_schematic_x		= m_lable_schematic_x;
	CMData.lable_schematic_y		= m_lable_schematic_y;
//	CMData.lable_timeout			= m_lable_timeout;

	return CMData;
}

BOOL TCSuperSpiceSchematicProperty2::SetData(TCSuperSpiceDrawData &CData)
{
	CMData = CData;

	m_grid_size					= CMData.grid_size;
	m_is_grid_display_on		= CMData.is_grid_display_on;
	m_is_snap_to_grid_on		= CMData.is_snap_to_grid_on;
	m_is_rubber_band_on			= CMData.is_rubber_band_on;
	m_is_draw_orthoganal_on		= CMData.is_draw_orthoganal_on;
	m_is_move_with_snap_to_grid	= CMData.is_move_with_snap_to_grid;
	m_snap_to_distance			= CMData.snap_to_distance;
	m_all_enclosed				= CMData.all_enclosed;
	m_hyde_labels				= CMData.hyde_labels;
	m_fastest_drawing_mode		= CMData.fastest_drawing_mode;
	m_symbol_editor_snap_to_distance = CMData.symbol_editor_snap_to_distance;
	m_symbol_editor_grid_size = CMData.symbol_editor_grid_size;
	m_draw_schematic_page_border = CMData.draw_schematic_page_border;
	m_draw_waveform_page_border = CMData.draw_waveform_page_border;
	m_vector_printing			= CMData.vector_printing;
	m_display_connection_dots	= CMData.display_connection_dots;
	m_connection_dot_size		= CMData.connection_dot_size;
	m_repeat_pasting			= CMData.repeat_pasting;

	m_labels_schematic			= CMData.labels_schematic;
	m_lables_graph				= CMData.lables_graph;
	m_lable_graph_x				= CMData.lable_graph_x;
	m_lable_graph_y				= CMData.lable_graph_y;
	m_lable_schematic_x			= CMData.lable_schematic_x;
	m_lable_schematic_y			= CMData.lable_schematic_y;
//	m_lable_timeout				= CMData.lable_timeout;

//	if(m_lable_timeout < 0) m_lable_timeout = 3000;

	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceSchematicProperty3 property page

TCSuperSpiceSchematicProperty3::TCSuperSpiceSchematicProperty3() : CPropertyPage(TCSuperSpiceSchematicProperty3::IDD)
{
	//{{AFX_DATA_INIT(TCSuperSpiceSchematicProperty3)
	m_black_white_printing = FALSE;
	//}}AFX_DATA_INIT
}

TCSuperSpiceSchematicProperty3::~TCSuperSpiceSchematicProperty3()
{

}

void TCSuperSpiceSchematicProperty3::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCSuperSpiceSchematicProperty3)
	DDX_Check(pDX, IDC_CHECK_BW_PRINTING, m_black_white_printing);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCSuperSpiceSchematicProperty3, CPropertyPage)
	//{{AFX_MSG_MAP(TCSuperSpiceSchematicProperty3)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

TCSuperSpiceColorData &TCSuperSpiceSchematicProperty3::GetData(void)
{
	return CMData;
}

BOOL TCSuperSpiceSchematicProperty3::SetData(TCSuperSpiceColorData &CData)
{
	CMData = CData;
	


	return TRUE;
}

BOOL TCSuperSpiceSchematicProperty3::OnInitDialog()
{
	m_black_white_printing = CMData.black_white_printing;

	CDialog::OnInitDialog();

	CMListBackgroundColor.SubclassDlgItem(IDC_LIST_BACKGROUND_COLOR, this);
	CMListBackgroundColor.LoadList();

	CMListGridColor.SubclassDlgItem(IDC_LIST_GRID_COLOR, this);
	CMListGridColor.LoadList();
	
	CMListComponentColorNormal.SubclassDlgItem(IDC_LIST_COMPONENT_NORMAL, this);
	CMListComponentColorNormal.LoadList();
	CMListComponentColorHighlighted.SubclassDlgItem(IDC_LIST_COMPONENT_HIGHLIGHTED, this);
	CMListComponentColorHighlighted.LoadList();
	CMListComponentColorSelected.SubclassDlgItem(IDC_LIST_COMPONENT_SELECTED, this);
	CMListComponentColorSelected.LoadList();

	CMListComponentTextColorNormal.SubclassDlgItem(IDC_LIST_COMPONENT_TEXT_NORMAL, this);
	CMListComponentTextColorNormal.LoadList();
	CMListComponentTextColorHighlighted.SubclassDlgItem(IDC_LIST_COMPONENT_TEXT_HIGHLIGHTED, this);
	CMListComponentTextColorHighlighted.LoadList();
	CMListComponentTextColorSelected.SubclassDlgItem(IDC_LIST_COMPONENT_TEXT_SELECTED, this);
	CMListComponentTextColorSelected.LoadList();

	CMListPinColorNormal.SubclassDlgItem(IDC_LIST_COMPONENT_PIN_NORMAL, this);
	CMListPinColorNormal.LoadList();
	CMListPinColorHighlighted.SubclassDlgItem(IDC_LIST_COMPONENT_PIN_HIGHLIGHTED, this);
	CMListPinColorHighlighted.LoadList();
	CMListPinColorSelected.SubclassDlgItem(IDC_LIST_COMPONENT_PIN_SELECTED, this);
	CMListPinColorSelected.LoadList();

	CMListUserTextColorNormal.SubclassDlgItem(IDC_LIST_COMPONENT_USER_TEXT_NORMAL, this);
	CMListUserTextColorNormal.LoadList();
	CMListUserTextColorHighlighted.SubclassDlgItem(IDC_LIST_USER_TEXT_HIGHLIGHTED, this);
	CMListUserTextColorHighlighted.LoadList();
	CMListUserTextColorSelected.SubclassDlgItem(IDC_LIST_USER_TEXT_SELECTED, this);
	CMListUserTextColorSelected.LoadList();

	CMListPinTextColorNormal.SubclassDlgItem(IDC_LIST_COMPONENT_PIN_TEXT_NORMAL, this);
	CMListPinTextColorNormal.LoadList();
	CMListPinTextColorHighlighted.SubclassDlgItem(IDC_LIST_COMPONENT_PIN_TEXT_HIGHLIGHTED, this);
	CMListPinTextColorHighlighted.LoadList();
	CMListPinTextColorSelected.SubclassDlgItem(IDC_LIST_COMPONENT_PIN_TEXT_SELECTED, this);
	CMListPinTextColorSelected.LoadList();

	CMListWireColorNormal.SubclassDlgItem(IDC_LIST_WIRE_NORMAL, this);
	CMListWireColorNormal.LoadList();
	CMListWireColorHighlighted.SubclassDlgItem(IDC_LIST_WIRE_HIGHLIGHTED, this);
	CMListWireColorHighlighted.LoadList();
	CMListWireColorSelected.SubclassDlgItem(IDC_LIST_WIRE_SELECTED, this);
	CMListWireColorSelected.LoadList();

	CMListBackgroundColor.SetColorRef(CMData.background);
	CMListGridColor.SetColorRef(CMData.grid);

	CMListComponentColorNormal.SetColorRef(CMData.component_normal);
	CMListComponentColorHighlighted.SetColorRef(CMData.component_highlighted);
	CMListComponentColorSelected.SetColorRef(CMData.component_selected);

	CMListComponentTextColorNormal.SetColorRef(CMData.component_text_normal);
	CMListComponentTextColorHighlighted.SetColorRef(CMData.component_text_highlighted);
	CMListComponentTextColorSelected.SetColorRef(CMData.component_text_selected);

	CMListPinColorNormal.SetColorRef(CMData.pin_normal);
	CMListPinColorHighlighted.SetColorRef(CMData.pin_highlighted);
	CMListPinColorSelected.SetColorRef(CMData.pin_selected);

	CMListUserTextColorNormal.SetColorRef(CMData.user_text_normal);
	CMListUserTextColorSelected.SetColorRef(CMData.user_text_selected);
	CMListUserTextColorHighlighted.SetColorRef(CMData.user_text_highlighted);

	CMListPinTextColorNormal.SetColorRef(CMData.pin_text_normal);
	CMListPinTextColorHighlighted.SetColorRef(CMData.pin_text_highlighted);
	CMListPinTextColorSelected.SetColorRef(CMData.pin_text_selected);
	
	CMListWireColorNormal.SetColorRef(CMData.wire_normal);
	CMListWireColorHighlighted.SetColorRef(CMData.wire_highlighted);
	CMListWireColorSelected.SetColorRef(CMData.wire_selected);

	return true;
}


void TCSuperSpiceSchematicProperty3::OnOK() 
{
	CMData.background					= CMListBackgroundColor.GetColorRef();
	CMData.grid							= CMListGridColor.GetColorRef();

	CMData.component_normal				= CMListComponentColorNormal.GetColorRef();
	CMData.component_highlighted		= CMListComponentColorHighlighted.GetColorRef();
	CMData.component_selected			= CMListComponentColorSelected.GetColorRef();

	CMData.component_text_normal		= CMListComponentTextColorNormal.GetColorRef();
	CMData.component_text_highlighted	= CMListComponentTextColorHighlighted.GetColorRef();
	CMData.component_text_selected		= CMListComponentTextColorSelected.GetColorRef();

	CMData.pin_normal					= CMListPinColorNormal.GetColorRef();
	CMData.pin_highlighted				= CMListPinColorHighlighted.GetColorRef();
	CMData.pin_selected					= CMListPinColorSelected.GetColorRef();

	CMData.user_text_normal				= CMListUserTextColorNormal.GetColorRef();
	CMData.user_text_selected			= CMListUserTextColorSelected.GetColorRef();
	CMData.user_text_highlighted		= CMListUserTextColorHighlighted.GetColorRef();

	CMData.pin_text_normal				= CMListPinTextColorNormal.GetColorRef();
	CMData.pin_text_highlighted			= CMListPinTextColorHighlighted.GetColorRef();
	CMData.pin_text_selected			= CMListPinTextColorSelected.GetColorRef();

	CMData.wire_normal					= CMListWireColorNormal.GetColorRef();
	CMData.wire_highlighted				= CMListWireColorHighlighted.GetColorRef();
	CMData.wire_selected				= CMListWireColorSelected.GetColorRef();
	CMData.black_white_printing			= m_black_white_printing;

	CPropertyPage::OnOK();
}
/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceSchematicProperty4 property page

TCSuperSpiceSchematicProperty4::TCSuperSpiceSchematicProperty4() : CPropertyPage(TCSuperSpiceSchematicProperty4::IDD)
{
	//{{AFX_DATA_INIT(TCSuperSpiceSchematicProperty4)
	CEditAddedText = _T("");
	m_added_text_size = 0;
	CEditComponent = _T("");
	m_component_size = 0;
	CEditPins = _T("");
	m_pins_size = 0;
	m_graph_title_size = 0;
	CEditGraphTitle = _T("");
	//}}AFX_DATA_INIT
}

TCSuperSpiceSchematicProperty4::~TCSuperSpiceSchematicProperty4()
{
}

void TCSuperSpiceSchematicProperty4::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCSuperSpiceSchematicProperty4)
	DDX_Text(pDX, IDC_EDIT_ADDED_TEXT, CEditAddedText);
	DDX_Text(pDX, IDC_EDIT_ADDED_TEXT_SIZE, m_added_text_size);
	DDX_Text(pDX, IDC_EDIT_COMPONENT_FONT, CEditComponent);
	DDX_Text(pDX, IDC_EDIT_COMPONENT_SIZE, m_component_size);
	DDX_Text(pDX, IDC_EDIT_PINS_FONT, CEditPins);
	DDX_Text(pDX, IDC_EDIT_PINS_SIZE, m_pins_size);
	DDX_Text(pDX, IDC_EDIT_GRAPH_TITAL_SIZE, m_graph_title_size);
	DDX_Text(pDX, IDC_EDIT_GRAPH_TITLE, CEditGraphTitle);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCSuperSpiceSchematicProperty4, CPropertyPage)
	//{{AFX_MSG_MAP(TCSuperSpiceSchematicProperty4)
	ON_BN_CLICKED(IDC_BUTTON_SELECT_COMMONENT_FONT, OnButtonSelectCommonentFont)
	ON_BN_CLICKED(IDC_BUTTON_SELECT_PINS_FONT, OnButtonSelectPinsFont)
	ON_BN_CLICKED(IDC_BUTTON_SELECT_USER1_FONT, OnButtonSelectUser1Font)
	ON_BN_CLICKED(IDC_BUTTON_SELECT_GRAPH_FONT, OnButtonSelectGraphFont)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

TCSuperSpiceFontData &TCSuperSpiceSchematicProperty4::GetData()
{
	return CMSuperSpiceFontData;
}

void TCSuperSpiceSchematicProperty4::SetData(TCSuperSpiceFontData CSuperSpiceFontData)
{
	CMSuperSpiceFontData = CSuperSpiceFontData;

	CEditComponent	= CMSuperSpiceFontData.CComponents;
	CEditAddedText	= CMSuperSpiceFontData.CUser;
	CEditPins		= CMSuperSpiceFontData.CPins;
	CEditGraphTitle = CMSuperSpiceFontData.CWaveformTitle;

	m_component_size	= CMSuperSpiceFontData.component_size / 10;
	m_added_text_size	= CMSuperSpiceFontData.user_size / 10;
	m_pins_size			= CMSuperSpiceFontData.pin_size / 10;
	m_graph_title_size	= CMSuperSpiceFontData.wave_form_title /10;

	sm_component_log_font	= CMSuperSpiceFontData.CComponentLogFont;
	sm_pins_log_font		= CMSuperSpiceFontData.CPinsLogFont;
	sm_added_text_log_font  = CMSuperSpiceFontData.CUserLogFont;
	sm_graph_log_font       = CMSuperSpiceFontData.CWaveformTitleLogFont;
}

BOOL TCSuperSpiceSchematicProperty4::OnSetActive() 
{
	g_last_active_schematic_page = 3;
	
	return CPropertyPage::OnSetActive();
}

BOOL TCSuperSpiceSchematicProperty3::OnSetActive() 
{
	g_last_active_schematic_page = 2;
	
	BOOL result = CPropertyPage::OnSetActive();

	CMListBackgroundColor.SetScrollPos(SB_VERT, 5, TRUE);
 
	return result;
}

BOOL TCSuperSpiceSchematicProperty1::OnSetActive() 
{
	g_last_active_schematic_page = 0;
	
	return CPropertyPage::OnSetActive();
}

BOOL TCSuperSpiceSchematicProperty2::OnSetActive() 
{
	g_last_active_schematic_page = 1;
	
	return CPropertyPage::OnSetActive();
}


void TCSuperSpiceSchematicProperty4::OnButtonSelectCommonentFont() 
{

	TCFontDialog CSelectFontDialog;

	CSelectFontDialog.m_cf.Flags &= ~CF_EFFECTS; // turn of color and strikethrough ets
	CSelectFontDialog.m_cf.Flags |= CF_INITTOLOGFONTSTRUCT;

	CSelectFontDialog.m_cf.iPointSize = m_component_size * 10;

	*CSelectFontDialog.m_cf.lpLogFont = CMSuperSpiceFontData.CComponentLogFont;

	if(CSelectFontDialog.DoModal() == IDOK)
	{
		 if(CSelectFontDialog.GetFaceName() != "") 
		 {
			CEditComponent = CSelectFontDialog.GetFaceName();
			sm_component_log_font = *CSelectFontDialog.m_cf.lpLogFont;
		 }
		
		 m_component_size = CSelectFontDialog.GetSize() / 10;
	}

	// To do EnumFontFamilies to init select the font;

	UpdateData(false);
}

void TCSuperSpiceSchematicProperty4::OnButtonSelectGraphFont() 
{
	TCFontDialog CSelectFontDialog;

	CSelectFontDialog.m_cf.Flags &= ~CF_EFFECTS;
	CSelectFontDialog.m_cf.Flags |= CF_INITTOLOGFONTSTRUCT; 

	CSelectFontDialog.m_cf.iPointSize = m_graph_title_size * 10;
	*CSelectFontDialog.m_cf.lpLogFont = CMSuperSpiceFontData.CWaveformTitleLogFont;

	if(CSelectFontDialog.DoModal() == IDOK)
	{
		if(CSelectFontDialog.GetFaceName() != "")
		{
			CEditGraphTitle = CSelectFontDialog.GetFaceName();
			sm_graph_log_font = *CSelectFontDialog.m_cf.lpLogFont;

		}
		m_graph_title_size = CSelectFontDialog.GetSize() / 10;
	}
	
	UpdateData(false);
}

void TCSuperSpiceSchematicProperty4::OnButtonSelectPinsFont() 
{
	TCFontDialog CSelectFontDialog;

	CSelectFontDialog.m_cf.Flags &= ~CF_EFFECTS;
	CSelectFontDialog.m_cf.Flags |= CF_INITTOLOGFONTSTRUCT; 

	CSelectFontDialog.m_cf.iPointSize = m_pins_size * 10;
	*CSelectFontDialog.m_cf.lpLogFont = CMSuperSpiceFontData.CPinsLogFont;

	if(CSelectFontDialog.DoModal() == IDOK)
	{
		if(CSelectFontDialog.GetFaceName() != "")
		{
			CEditPins = CSelectFontDialog.GetFaceName();
			sm_pins_log_font = *CSelectFontDialog.m_cf.lpLogFont;

		}
		m_pins_size = CSelectFontDialog.GetSize() / 10;
	}
	
	UpdateData(false);
}

void TCSuperSpiceSchematicProperty4::OnButtonSelectUser1Font() 
{
	TCFontDialog CSelectFontDialog;
	CString		CText;

	CSelectFontDialog.m_cf.Flags &= ~CF_EFFECTS;
	CSelectFontDialog.m_cf.Flags |= CF_INITTOLOGFONTSTRUCT;

	CSelectFontDialog.m_cf.iPointSize = m_added_text_size * 10;
	*CSelectFontDialog.m_cf.lpLogFont = CMSuperSpiceFontData.CUserLogFont;

	if(CSelectFontDialog.DoModal() == IDOK)
	{
		if(CSelectFontDialog.GetFaceName() != "")
		{
			CEditAddedText = CSelectFontDialog.GetFaceName();
			sm_added_text_log_font = *CSelectFontDialog.m_cf.lpLogFont;

		}

		 m_added_text_size = CSelectFontDialog.GetSize() / 10;
	}
	
	UpdateData(false);
}

void TCSuperSpiceSchematicProperty4::OnOK() 
{	
	CMSuperSpiceFontData.CComponents	= CEditComponent;
	CMSuperSpiceFontData.CUser			= CEditAddedText;
	CMSuperSpiceFontData.CPins			= CEditPins;
	CMSuperSpiceFontData.CWaveformTitle	= CEditGraphTitle;

	CMSuperSpiceFontData.component_size = m_component_size * 10;
	CMSuperSpiceFontData.user_size		= m_added_text_size * 10;
	CMSuperSpiceFontData.pin_size		= m_pins_size * 10;
	CMSuperSpiceFontData.wave_form_title = m_graph_title_size * 10;

	CMSuperSpiceFontData.CComponentLogFont	= sm_component_log_font;
	CMSuperSpiceFontData.CUserLogFont		= sm_added_text_log_font;
	CMSuperSpiceFontData.CPinsLogFont		= sm_pins_log_font;
	CMSuperSpiceFontData.CWaveformTitleLogFont = sm_graph_log_font;


	CPropertyPage::OnOK();
}


