// TCSuperSpiceTextDoc.cpp : implementation of the TCSuperSpiceTextDoc class
//

#include "stdafx.h"
#include "resource.h"
#include "TCSuperSpiceMainFrame.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSuperSpiceDoc.h"
#include "TCSuperSpiceTextDoc.h"
#include "TCSuperSpiceTextView.h"
#include "TCSuperSpiceTextCntrItem.h"
#include "TEPCBFormats.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern TCSuperSpiceDataBase GCSuperSpiceDataBase;
/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceTextDoc

IMPLEMENT_DYNCREATE(TCSuperSpiceTextDoc, CRichEditDoc)

BEGIN_MESSAGE_MAP(TCSuperSpiceTextDoc, CRichEditDoc)
	//{{AFX_MSG_MAP(TCSuperSpiceTextDoc)
	ON_COMMAND(ID_RUN_CREATENETLIST, OnRunCreatenetlist)
	ON_COMMAND(ID_RUN_STOP, OnRunStop)
	ON_COMMAND(ID_VIEW_TOP_LEVEL_FILES, OnViewTopLevelFiles)
	ON_COMMAND(ID_SETUP_SETTEMPERATURE, OnSetupSetTemperature)
	ON_COMMAND(ID_FILE_PCBNETLISTS_GENERIC, OnFilePcbnetlistsGeneric)
	ON_COMMAND(ID_FILE_PCBNETLISTS_ORCAD, OnFilePcbnetlistsOrcad)
	ON_COMMAND(ID_FILE_PCBNETLISTS_CREATETANGO, OnFilePcbnetlistsCreatetango)
	ON_COMMAND(ID_FILE_PCBNETLISTS_CREATEPROTEL, OnFilePcbnetlistsCreateprotel)
	ON_COMMAND(ID_FILE_PCBNETLISTS_PCLOGIC, OnFilePcbnetlistsPclogic)
	ON_COMMAND(ID_FILE_PCBNETLISTS_CREATEEAGLE, OnFilePcbnetlistsCreateeagle)
	ON_COMMAND(ID_FILE_NEWTEXTFILE, OnFileNewTextFile)
	ON_UPDATE_COMMAND_UI(ID_FILE_NEWTEXTFILE, OnUpdateFileNewtextfile)
	ON_COMMAND(ID_RUN_TERMINATEXSPICEENGINE, OnRunTerminatexspiceengine)
	ON_COMMAND(ID_RUN_ENABLELOOPGAIN, OnRunEnableloopgain)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLELOOPGAIN, OnUpdateRunEnableloopgain)
	ON_COMMAND(ID_VIEW_PARAMETERLISTRERUNFILE, OnViewParameterlistrerunfile)
	ON_COMMAND(ID_VIEW_MONTECARLORERUNFILE, OnViewMontecarlorerunfile)
	ON_COMMAND(ID_VIEW_PARAMETERLISTGENERATERFILE, OnViewParameterlistgeneraterfile)
	ON_COMMAND(ID_VIEW_MULTIPARAMETERSWEEPFILE, OnViewMultiParameterSweepFile)
	//}}AFX_MSG_MAP
	// Enable default OLE container implementation
	ON_UPDATE_COMMAND_UI(ID_OLE_EDIT_LINKS, CRichEditDoc::OnUpdateEditLinksMenu)
	ON_COMMAND(ID_OLE_EDIT_LINKS, CRichEditDoc::OnEditLinks)
	ON_UPDATE_COMMAND_UI(ID_OLE_VERB_FIRST, CRichEditDoc::OnUpdateObjectVerbMenu)
	ON_COMMAND(ID_VIEW_WORSTCASERERUNFILE, &TCSuperSpiceTextDoc::OnViewWorstCaseRerunFile)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceTextDoc construction/destruction

TCSuperSpiceTextDoc::TCSuperSpiceTextDoc()
{
	// Use OLE compound files
//	EnableCompoundFile();  // do not want compond files, messes up saving of text files.

	// TODO: add one-time construction code here
	
	PCParentSuperSpiceDoc = NULL;

	m_bRTF = false;

	update_model_libary = false;
}

TCSuperSpiceTextDoc::~TCSuperSpiceTextDoc()
{

}

BOOL TCSuperSpiceTextDoc::OnNewDocument()
{
	if (!CRichEditDoc::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}

TCSuperSpiceDoc *TCSuperSpiceTextDoc::GetParentSuperSpiceDoc(void)
{
	if(!PCParentSuperSpiceDoc) return NULL;

	if(IsBadReadPtr(PCParentSuperSpiceDoc, sizeof(TCSuperSpiceDoc))) 
	{
		ASSERT(0);

		PCParentSuperSpiceDoc = NULL;

		return NULL;
	}

	return PCParentSuperSpiceDoc;
}

CRichEditCntrItem* TCSuperSpiceTextDoc::CreateClientItem(REOBJECT* preo) const
{
	// cast away constness of this
	return new TCSuperSpiceTextCntrItem(preo, (TCSuperSpiceTextDoc*) this);
}



/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceTextDoc serialization

void TCSuperSpiceTextDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}

	// Calling the base class CRichEditDoc enables serialization
	//  of the container document's COleClientItem objects.

	CRichEditDoc::Serialize(ar);
}

/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceTextDoc diagnostics

#ifdef _DEBUG
void TCSuperSpiceTextDoc::AssertValid() const
{
	CRichEditDoc::AssertValid();
}

void TCSuperSpiceTextDoc::Dump(CDumpContext& dc) const
{
	CRichEditDoc::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceTextDoc commands

void TCSuperSpiceTextDoc::SetText(CString CText)
{
	CRichEditView* PCView = GetView();

	if(!PCView) return;

	CRichEditCtrl& CRichEditControl = PCView->GetRichEditCtrl();

	CRichEditControl.SetWindowText(CText);
}

CString TCSuperSpiceTextDoc::GetText()
{
	CString CText;

	CRichEditView* PCView = GetView();

	if(!PCView) return "";

	CRichEditCtrl& CRichEditControl = PCView->GetRichEditCtrl();

	CRichEditControl.GetWindowText(CText);

	return CText;
}

BOOL TCSuperSpiceTextDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	if (!CRichEditDoc::OnOpenDocument(lpszPathName)) return FALSE;
	
/*	if(!m_viewList.IsEmpty()) 
	{
		CRichEditCtrl &CRichEditControl = ((CRichEditView*)m_viewList.GetHead())->GetRichEditCtrl();
		
		long length = CRichEditControl.GetLineCount();

		CRichEditControl.LineScroll(length - 10);
		CRichEditControl.LineScroll(-(length - 10));
	}*/
	

	return TRUE;
}

void TCSuperSpiceTextDoc::ScrollTo(CString CText)
{
	FINDTEXTEX s_text;

	s_text.lpstrText	= CText.GetBuffer(CText.GetLength() + 1);
	s_text.chrg.cpMin	= 0;
	s_text.chrg.cpMax	= -1;

	CRichEditCtrl &CRichEditControl = ((CRichEditView*)m_viewList.GetHead())->GetRichEditCtrl();

	long position = CRichEditControl.FindText(FR_WHOLEWORD, &s_text);

	if (position == -1) return;

	CRichEditControl.SetSel(s_text.chrgText);
}

BOOL TCSuperSpiceTextDoc::OnSaveDocument(LPCTSTR lpszPathName) 
{
	BOOL value = CRichEditDoc::OnSaveDocument(lpszPathName);

	if(!value) AfxMessageBox(IDS_NO_FILE_SAVE);

	int index;

	index = GCSuperSpiceDataBase.FindModelFile(lpszPathName);

	if(index < 0) return true;

	CString CText = lpszPathName; 

	GCSuperSpiceDataBase.ReloadModelFile(CText);

	if(!PCParentSuperSpiceDoc) return true;

	CText.LoadString(IDS_STR_MODEL_FILE);

	CText += ' ' + CText + " updated";

	PCParentSuperSpiceDoc->DisplayError(IDS_EER_STATUS, CText, -1);

	return true;
}

void TCSuperSpiceTextDoc::OnCloseDocument() 
{
	// TODO: Add your specialized code here and/or call the base class

	if(PCParentSuperSpiceDoc)PCParentSuperSpiceDoc->OnNotifyDocumentClosed(this);

	CRichEditDoc::OnCloseDocument();
}

void TCSuperSpiceTextDoc::OnViewDisplaySchematic(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnViewDisplaySchematic(PCView);
}

void TCSuperSpiceTextDoc::OnViewDisplaySymbolEditor(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewDisplaySymbolEditor(PCView);
}

void TCSuperSpiceTextDoc::OnViewDisplayOutputGraph(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewDisplayOutputGraph(PCView);
}
void TCSuperSpiceTextDoc::OnViewDisplayOutputText(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewDisplayOutputText(PCView);
}

void TCSuperSpiceTextDoc::OnViewDisplaySpiceErrorLog(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewDisplaySpiceErrorLog(PCView);
}

void TCSuperSpiceTextDoc::OnViewDisplayModelsText(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnViewDisplayModelsText(PCView);
}
void TCSuperSpiceTextDoc::OnViewDisplayInputText(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnViewDisplayInputText(PCView);

}

void TCSuperSpiceTextDoc::OnViewPcbNetlist(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnViewDisplayPCBNetlist(PCView);
}

void TCSuperSpiceTextDoc::OnViewDisplayIncludeText(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnViewDisplayIncludeText(PCView);

}

void TCSuperSpiceTextDoc::OnViewDisplayDesignNotes(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnViewDisplayDesignNotes(PCView);

}


TCSuperSpiceView *TCSuperSpiceTextDoc::GetSchematicView(void)
{
	if(!PCParentSuperSpiceDoc) return NULL;

	POSITION pos = PCParentSuperSpiceDoc->GetFirstViewPosition();

	TCSuperSpiceView *PCViewInList;

	PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

	if(!PCViewInList) return NULL;

	return PCViewInList;
}


void TCSuperSpiceTextDoc::OnRunRun(CView *PCView, bool renetlist) 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnRunRun(PCView, renetlist);
}

void TCSuperSpiceTextDoc::OnRunRunDebugMode(CView *PCView, bool renetlist) 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnRunRunDebugMode(PCView, renetlist);
}


void TCSuperSpiceTextDoc::OnRunCreatenetlist() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnRunCreateNetlist();
}

void TCSuperSpiceTextDoc::OnRunStop() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnRunStop();
}

void  TCSuperSpiceTextDoc::TimerCallBack(void)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->TimerCallBack();
}

void TCSuperSpiceTextDoc::OnViewTopLevelFiles() 
{
	if(!PCParentSuperSpiceDoc) return;
	
	PCParentSuperSpiceDoc->OnViewTopLevelFiles();	
}

void TCSuperSpiceTextDoc::OnSetupSetTemperature() 
{
	if(PCParentSuperSpiceDoc) PCParentSuperSpiceDoc->OnSetupSetTemperature();	
}

void TCSuperSpiceTextDoc::OnFilePcbnetlistsGeneric() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->CreatePCBNetlist(1);	
}

void TCSuperSpiceTextDoc::OnFilePcbnetlistsOrcad() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->CreatePCBNetlist(E_PCB_FORMATS_ORCAD);		
}

void TCSuperSpiceTextDoc::OnFilePcbnetlistsCreatetango() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->CreatePCBNetlist(E_PCB_FORMATS_TANGO);	
}

void TCSuperSpiceTextDoc::OnFilePcbnetlistsCreateprotel() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->CreatePCBNetlist(E_PCB_FORMATS_PROTEL);	
}

void TCSuperSpiceTextDoc::OnFilePcbnetlistsPclogic() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->CreatePCBNetlist(E_PCB_FORMATS_PCLOGIC);	
	
}

void TCSuperSpiceTextDoc::OnFilePcbnetlistsCreateeagle() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->CreatePCBNetlist(E_PCB_FORMATS_EAGLE);	
	
}

void TCSuperSpiceTextDoc::OnViewDisplayPoleZeroText(CView *PCView)
{
	PCView;

	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewDisplayPoleZeroText(PCView);	
}

void TCSuperSpiceTextDoc::SetTitle(LPCTSTR lpszTitle) 
{
	CString CTitle = GetPathName();

	if(CTitle == "") CRichEditDoc::SetTitle(lpszTitle);
	else
	{
		if(IsModified()) CTitle += "*";
		
		CRichEditDoc::SetTitle(CTitle);
	}
}

void TCSuperSpiceTextDoc::UpdateTitle(void)
{
	SetTitle(GetPathName());
}

void TCSuperSpiceTextDoc::OnFileNewTextFile() 
{
	if(!PCParentSuperSpiceDoc) 
	{
		TCSuperSpiceMainFrame *PCSuperSpiceMainFrame = (TCSuperSpiceMainFrame *)AfxGetMainWnd();

		if(!PCSuperSpiceMainFrame) return;

		PCSuperSpiceMainFrame->OnFileNewTextFilePublic();

		return;
	}

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnFileNewTextFile();
}

void TCSuperSpiceTextDoc::OnUpdateFileNewtextfile(CCmdUI* pCmdUI) 
{
//	if(!PCParentSuperSpiceDoc)	pCmdUI->Enable(false);
//	else pCmdUI->Enable(true);

	pCmdUI->Enable(true);
}

void TCSuperSpiceTextDoc::DisplayModel(CString CFileName, CString CModelName)
{
	if(!m_viewList.IsEmpty()) 
	{
		((TCSuperSpiceTextView*)m_viewList.GetHead())->DisplayModel(CFileName, CModelName);
	}
}

void TCSuperSpiceTextDoc::OnRunTerminatexspiceengine() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnRunExitEngine();		
}

void TCSuperSpiceTextDoc::OnRunEnableloopgain() 
{
	if(!PCParentSuperSpiceDoc) return;

	TCSuperSpiceDoc *PCDoc = PCParentSuperSpiceDoc->GetTopLevelDoc();
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] == 1)
		CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] = 2;
	else 
		CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] = 1;	
}

void TCSuperSpiceTextDoc::OnUpdateRunEnableloopgain(CCmdUI* pCmdUI) 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc();

	TCSuperSpiceDoc *PCDoc = PCParentSuperSpiceDoc->GetTopLevelDoc();

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] == 1)
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);

	pCmdUI->ContinueRouting();	
}

void TCSuperSpiceTextDoc::OnViewParameterlistrerunfile() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewParameterlistrerunfile();		
}

void TCSuperSpiceTextDoc::OnViewMontecarlorerunfile() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewMonteCarloReRunFile();		
}

void TCSuperSpiceTextDoc::OnViewParameterlistgeneraterfile() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewParameterlistgeneraterfile();		
}

void TCSuperSpiceTextDoc::OnViewMultiParameterSweepFile() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewMultiParameterSweepFile();		
	
}

void TCSuperSpiceTextDoc::OnViewWorstCaseRerunFile()
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewWorstCaseReRunFile();
}

