// TCSuperSpiceTextView.cpp : implementation of the TCSuperSpiceTextView class
//

 
#include "stdafx.h"
#include "resource.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSuperSpiceDoc.h"
#include "TCSuperSpiceView.h"
#include "TCSuperSpiceTextDoc.h"
#include "TCSuperSpiceTextCntrItem.h"
#include "TCSuperSpiceTextView.h"
#include "TCPasswordId.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


extern TCSuperSpiceDoc *PCSuperSpiceDocLastFocused;
extern TCSuperSpiceView *PCSuperSpiceViewLastFocused;
extern void DisplayPopupMenu(CWnd*, CPoint, int);
extern TCSuperSpiceDataBase GCSuperSpiceDataBase;



/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceTextView

IMPLEMENT_DYNCREATE(TCSuperSpiceTextView, CRichEditView)

BEGIN_MESSAGE_MAP(TCSuperSpiceTextView, CRichEditView)
	ON_WM_CONTEXTMENU()
	//{{AFX_MSG_MAP(TCSuperSpiceTextView)
	ON_WM_DESTROY()
	ON_WM_SHOWWINDOW()
	ON_WM_RBUTTONDOWN()
	ON_WM_HELPINFO()
	ON_COMMAND(ID_VIEW_INCLUDEFILE, OnViewIncludeFile)
	ON_COMMAND(IDM_VIEW_OUTPUT_GRAPH, OnViewOutputGraph)
	ON_COMMAND(IDM_VIEW_OUTPUT_TEXT, OnViewOutputText)
	ON_COMMAND(IDM_VIEW_SPICE_TEXT, OnViewSpiceText)
	ON_COMMAND(ID_VIEW_SCHEMATIC, OnViewSchematic)
	ON_COMMAND(ID_OPTIONS_PROGRAM, OnOptionsProgram)
	ON_COMMAND(ID_OPTIONS_SCHEMATIC, OnOptionsSchematic)
	ON_COMMAND(IDM_SIMULATION_SETUP, OnSimulationSetup)
	ON_COMMAND(ID_VIEW_INCLUDEDMODELSFILE, OnViewIncludedModelsFile)
	ON_COMMAND(ID_RUN_RUN, OnRunRun)
	ON_COMMAND(ID_RUN_RUN_SAME_NRT_LIST, OnRunRunSameNetList)
	ON_WM_TIMER()
	ON_COMMAND(ID_WINDOW_NEW_GRAPHIC, OnWindowNewGraphic)
	ON_COMMAND(ID_VIEW_DESIGNNOTES, OnViewDesignNotes)
	ON_COMMAND(ID_HELP_GETCOMPUTERPASSWORD, OnHelpGetcomputerpassword)
	ON_COMMAND(ID_RUN_AC, OnRunAc)
	ON_UPDATE_COMMAND_UI(ID_RUN_AC, OnUpdateRunAc)
	ON_COMMAND(ID_RUN_DC, OnRunDc)
	ON_UPDATE_COMMAND_UI(ID_RUN_DC, OnUpdateRunDc)
	ON_COMMAND(ID_RUN_ENABLEDISTORTION, OnRunEnabledistortion)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEDISTORTION, OnUpdateRunEnabledistortion)
	ON_COMMAND(ID_RUN_ENABLEFOURIER, OnRunEnablefourier)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEFOURIER, OnUpdateRunEnablefourier)
	ON_COMMAND(ID_RUN_ENABLENOISE, OnRunEnablenoise)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLENOISE, OnUpdateRunEnablenoise)
	ON_COMMAND(ID_RUN_ENABLEOPERATINGPOINT, OnRunEnableoperatingpoint)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEOPERATINGPOINT, OnUpdateRunEnableoperatingpoint)
	ON_COMMAND(ID_RUN_ENABLEPOLEZERO, OnRunEnablepolezero)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEPOLEZERO, OnUpdateRunEnablepolezero)
	ON_COMMAND(ID_RUN_ENABLE_STATISTICS, OnRunStatistics)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLE_STATISTICS, OnUpdateRunStatistics)
	ON_COMMAND(ID_RUN_PARAMETRIC, OnRunParametric)
	ON_UPDATE_COMMAND_UI(ID_RUN_PARAMETRIC, OnUpdateRunParametric)
	ON_COMMAND(ID_RUN_RERUNS, OnRunReruns)
	ON_UPDATE_COMMAND_UI(ID_RUN_RERUNS, OnUpdateRunReruns)
	ON_COMMAND(ID_RUN_SENSITIVITY, OnRunSensitivity)
	ON_UPDATE_COMMAND_UI(ID_RUN_SENSITIVITY, OnUpdateRunSensitivity)
	ON_COMMAND(ID_RUN_TEMPERATURE, OnRunTemperature)
	ON_UPDATE_COMMAND_UI(ID_RUN_TEMPERATURE, OnUpdateRunTemperature)
	ON_COMMAND(ID_RUN_TRANSIENT, OnRunTransient)
	ON_UPDATE_COMMAND_UI(ID_RUN_TRANSIENT, OnUpdateRunTransient)
	ON_COMMAND(ID_RUN_STOP, OnRunStop)
	ON_COMMAND(ID_RUN_RUNDEBUGMODE, OnRunRunDebugmode)
	ON_COMMAND(ID_VIEW_COMPONENTMAKER, OnViewComponentMaker)
	ON_COMMAND(ID_RUN_SENSITIVITY_AC, OnRunSensitivityAc)
	ON_UPDATE_COMMAND_UI(ID_RUN_SENSITIVITY_AC, OnUpdateRunSensitivityAc)
	ON_COMMAND(ID_VIEW_SPICEENGNEERRORLOG, OnViewSpiceEngineErrorlog)
	ON_COMMAND(ID_VIEW_PCBNETLIST, OnViewPcbNetlist)
	ON_COMMAND(ID_WAVEFORMS_DISPLAYPOLEZEROWAVEFORM, OnWaveformsDisplaypolezerowaveform)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_DISPLAYPOLEZEROWAVEFORM, OnUpdateWaveformsDisplaypolezerowaveform)
	ON_WM_SETFOCUS()
	ON_COMMAND(ID_COMPONENTS_MODELLIBARY, OnComponentsModellibary)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CRichEditView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CRichEditView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CRichEditView::OnFilePrintPreview)

	ON_CONTROL_REFLECT_EX(EN_CHANGE, OnEditChange)

	ON_COMMAND(ID_RUN_ENABLEMONTECARLO, &TCSuperSpiceTextView::OnRunEnableMonteCarlo)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEMONTECARLO, &TCSuperSpiceTextView::OnUpdateRunEnableMonteCarlo)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceTextView construction/destruction

TCSuperSpiceTextView::TCSuperSpiceTextView()
{
	// TODO: add construction code here

	m_nWordWrap = WrapNone;
}

TCSuperSpiceTextView::~TCSuperSpiceTextView()
{
	
}

BOOL TCSuperSpiceTextView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CRichEditView::PreCreateWindow(cs);
}

void TCSuperSpiceTextView::OnInitialUpdate()
{
	CRichEditView::OnInitialUpdate();

	// Set the printing margins (720 twips = 1/2 inch).
	SetMargins(CRect(720, 720, 720, 720));
}

/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceTextView printing

BOOL TCSuperSpiceTextView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}


void TCSuperSpiceTextView::OnDestroy()
{
	// Deactivate the item on destruction; this is important
	// when a splitter view is being used.
   
   COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);
   if (pActiveItem != NULL && pActiveItem->GetActiveView() == this)
   {
      pActiveItem->Deactivate();
      ASSERT(GetDocument()->GetInPlaceActiveItem(this) == NULL);
   }

   CRichEditView::OnDestroy();
}


/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceTextView diagnostics

#ifdef _DEBUG
void TCSuperSpiceTextView::AssertValid() const
{
	CRichEditView::AssertValid();
}

void TCSuperSpiceTextView::Dump(CDumpContext& dc) const
{
	CRichEditView::Dump(dc);
}

TCSuperSpiceTextDoc* TCSuperSpiceTextView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(TCSuperSpiceTextDoc)));
	return (TCSuperSpiceTextDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceTextView message handlers

void TCSuperSpiceTextView::Serialize(CArchive& ar) 
{
	CRichEditView::Serialize(ar);

	if (ar.IsStoring())
	{	// storing code

	}
	else
	{	// loading code
	
	}
}

void TCSuperSpiceTextView::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CRichEditView::OnShowWindow(bShow, nStatus);
}

void TCSuperSpiceTextView::OnContextMenu(CWnd*, CPoint point)
{

	// CG: This block was added by the Pop-up Menu component
	{
		if (point.x == -1 && point.y == -1){
			//keystroke invocation
			CRect rect;
			GetClientRect(rect);
			ClientToScreen(rect);

			point = rect.TopLeft();
			point.Offset(5, 5);
		}

		CMenu menu;
		VERIFY(menu.LoadMenu(IDR_POPUP_TEXTTYPE_VIEW));

		CMenu* pPopup = menu.GetSubMenu(0);
		ASSERT(pPopup != NULL);
		CWnd* pWndPopupOwner = this;

		while (pWndPopupOwner->GetStyle() & WS_CHILD)
			pWndPopupOwner = pWndPopupOwner->GetParent();

		pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point.x, point.y,
			pWndPopupOwner);
	}
}

void TCSuperSpiceTextView::OnRButtonDown(UINT nFlags, CPoint point) 
{	
	DisplayPopupMenu(this, point, IDR_POPUP_TEXTTYPE_VIEW);

	CRichEditView::OnRButtonDown(nFlags, point);
}

void TCSuperSpiceTextView::OnViewIncludeFile() 
{
	TCSuperSpiceTextDoc* PCDoc = GetDocument();
	
	if(!PCDoc) return;

	PCDoc->OnViewDisplayIncludeText(this);
}

void TCSuperSpiceTextView::OnViewOutputGraph() 
{
	TCSuperSpiceTextDoc* PCDoc = GetDocument();
	
	if(!PCDoc) return;	

	PCDoc->OnViewDisplayOutputGraph(this);
}

void TCSuperSpiceTextView::OnViewOutputText() 
{
	TCSuperSpiceTextDoc* PCDoc = GetDocument();
	
	if(!PCDoc) return;

	PCDoc->OnViewDisplayOutputText(this);
}


void TCSuperSpiceTextView::OnViewSpiceEngineErrorlog() 
{
	TCSuperSpiceTextDoc* PCDoc = GetDocument();
	
	if(!PCDoc) return;

	PCDoc->OnViewDisplaySpiceErrorLog(this);	
}

void TCSuperSpiceTextView::OnViewSpiceText() 
{
	TCSuperSpiceTextDoc* PCDoc = GetDocument();
	
	if(!PCDoc) return;
	
	PCDoc->OnViewDisplayInputText(this);
}

void TCSuperSpiceTextView::OnViewComponentMaker() 
{
	TCSuperSpiceTextDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc->OnViewDisplaySymbolEditor(this);		
}

void TCSuperSpiceTextView::OnViewIncludedModelsFile() 
{
	TCSuperSpiceTextDoc* PCDoc = GetDocument();
	
	if(!PCDoc) return;
	
	PCDoc->OnViewDisplayModelsText(this);
}

void TCSuperSpiceTextView::OnViewSchematic() 
{
	TCSuperSpiceTextDoc* PCDoc = GetDocument();
	
	if(!PCDoc) return;
	
	PCDoc->OnViewDisplaySchematic(this);
}

void TCSuperSpiceTextView::OnOptionsProgram() 
{
	TCSuperSpiceTextDoc* PCDoc = GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	PCDoc->PCParentSuperSpiceDoc->OnOptionsProgram();
}

void TCSuperSpiceTextView::OnOptionsSchematic() 
{
	TCSuperSpiceTextDoc* PCDoc = GetDocument();
	
	if(!PCDoc) return;

	TCSuperSpiceView *PCSuperSpiceView = PCDoc->GetSchematicView();

	if(!PCSuperSpiceView) return;

	PCSuperSpiceView->OnOptionsSchematic();
	
}

void TCSuperSpiceTextView::OnSimulationSetup() 
{
	TCSuperSpiceTextDoc* PCDoc = GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	PCDoc->PCParentSuperSpiceDoc->OnViewSimulationSetup();
	
}


void TCSuperSpiceTextView::OnRunRun() 
{
	TCSuperSpiceTextDoc* PCDoc = GetDocument();
	
	if(!PCDoc) return;
	
	PCDoc->OnRunRun(this);
}

void TCSuperSpiceTextView::OnRunRunDebugmode() 
{
	TCSuperSpiceTextDoc* PCDoc = GetDocument();
	
	if(!PCDoc) return;
	
	PCDoc->OnRunRunDebugMode(this);	
}

void TCSuperSpiceTextView::OnRunRunSameNetList() 
{
	TCSuperSpiceTextDoc* PCDoc = GetDocument();
	
	if(!PCDoc) return;
	
	PCDoc->OnRunRun(this, false);
	
}

void TCSuperSpiceTextView::OnTimer(UINT_PTR nIDEvent) 
{
	TCSuperSpiceTextDoc* PCDoc = GetDocument();
	
	if(!PCDoc) return;
	
	if(PCDoc->PCParentSuperSpiceDoc)
		if(!PCDoc->GetParentSuperSpiceDoc()->GetTopLevelDoc()->PCSuperSpiceViewTimer)
		{
			KillTimer(1);

			return;
		}

	PCDoc->TimerCallBack();

	CRichEditView::OnTimer(nIDEvent);
}

void TCSuperSpiceTextView::OnWindowNewGraphic() 
{
	TCSuperSpiceTextDoc* PCDoc = GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCSuperSpiceDoc *PCSDoc = PCDoc->PCParentSuperSpiceDoc;

	PCSDoc = PCSDoc->GetTopLevelDoc();

	if(!PCSDoc) return;

	PCSDoc->OnViewNewGraph(this);
}

void TCSuperSpiceTextView::OnViewDesignNotes() 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc*) GetDocument();
	
	if(!PCDoc) return;
	
	PCDoc->OnViewDisplayDesignNotes(this);
}

void TCSuperSpiceTextView::OnHelpGetcomputerpassword() 
{
	TCPasswordId CPasswordId;

	CPasswordId.DoModal();	
}

void TCSuperSpiceTextView::OnRunAc() 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CACSetupData.CSweepData.enable = !CAnalysisSetup.CACSetupData.CSweepData.enable;

}

void TCSuperSpiceTextView::OnUpdateRunAc(CCmdUI* pCmdUI) 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CACSetupData.CSweepData.enable);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceTextView::OnRunDc() 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CDCSetupData.CSweepData1.enable = !CAnalysisSetup.CDCSetupData.CSweepData1.enable;

}

void TCSuperSpiceTextView::OnUpdateRunDc(CCmdUI* pCmdUI) 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CDCSetupData.CSweepData1.enable);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceTextView::OnRunEnabledistortion() 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CDistortionSetupData.enable = !CAnalysisSetup.CDistortionSetupData.enable;

}

void TCSuperSpiceTextView::OnUpdateRunEnabledistortion(CCmdUI* pCmdUI) 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CDistortionSetupData.enable);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceTextView::OnRunEnablefourier() 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CTransientSetupData.fourier_enable = !CAnalysisSetup.CTransientSetupData.fourier_enable;

	if(CAnalysisSetup.CTransientSetupData.fourier_enable) CAnalysisSetup.CTransientSetupData.CSweepData.enable = true;

}

void TCSuperSpiceTextView::OnUpdateRunEnablefourier(CCmdUI* pCmdUI) 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CTransientSetupData.fourier_enable);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceTextView::OnRunEnablenoise() 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CNoiseSetupData.enable = !CAnalysisSetup.CNoiseSetupData.enable;

//	if(CAnalysisSetup.CNoiseSetupData.enable) CAnalysisSetup.CACSetupData.CSweepData.enable = true;
}

void TCSuperSpiceTextView::OnUpdateRunEnablenoise(CCmdUI* pCmdUI) 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CNoiseSetupData.enable);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceTextView::OnRunEnableoperatingpoint() 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CDCSetupData.enable_operating_point = !CAnalysisSetup.CDCSetupData.enable_operating_point;

}

void TCSuperSpiceTextView::OnUpdateRunEnableoperatingpoint(CCmdUI* pCmdUI) 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(!!CAnalysisSetup.CDCSetupData.enable_operating_point);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceTextView::OnRunEnablepolezero() 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CPoleZeroSetupData.enable = !CAnalysisSetup.CPoleZeroSetupData.enable;

	if(CAnalysisSetup.CPoleZeroSetupData.enable) CAnalysisSetup.CACSetupData.CSweepData.enable = true;

}

void TCSuperSpiceTextView::OnUpdateRunEnablepolezero(CCmdUI* pCmdUI) 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CPoleZeroSetupData.enable);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceTextView::OnRunStatistics() 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CStatisticsSetupData.enable = !CAnalysisSetup.CStatisticsSetupData.enable;

	if(CAnalysisSetup.CStatisticsSetupData.enable)
	{
		if(CAnalysisSetup.CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_MULTY_RUNS)
			CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = false;
		
		CAnalysisSetup.CReRun.enable	= false;
		CAnalysisSetup.CParametricSetupData.CSweepData.enable = false;
	}
}

void TCSuperSpiceTextView::OnUpdateRunStatistics(CCmdUI* pCmdUI) 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CStatisticsSetupData.enable);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceTextView::OnRunParametric() 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CParametricSetupData.CSweepData.enable = !CAnalysisSetup.CParametricSetupData.CSweepData.enable;

	if(CAnalysisSetup.CParametricSetupData.CSweepData.enable)
	{
		if(CAnalysisSetup.CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_MULTY_RUNS)
			CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = false;
		
		CAnalysisSetup.CReRun.enable	= false;
		CAnalysisSetup.CStatisticsSetupData.enable = false;
	}
}

void TCSuperSpiceTextView::OnUpdateRunParametric(CCmdUI* pCmdUI) 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CParametricSetupData.CSweepData.enable);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceTextView::OnRunReruns() 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.enable != E_RERUN_SWEEP_TYPE_WC_MODEL_FILES)
		CAnalysisSetup.CReRun.enable = E_RERUN_SWEEP_TYPE_WC_MODEL_FILES;
	else
		CAnalysisSetup.CReRun.enable = 0;

	if(CAnalysisSetup.CReRun.enable)
	{
		if(CAnalysisSetup.CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_MULTY_RUNS)
			CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = false;
		
		CAnalysisSetup.CParametricSetupData.CSweepData.enable = false;
		CAnalysisSetup.CStatisticsSetupData.enable = false;
	}
}

void TCSuperSpiceTextView::OnUpdateRunReruns(CCmdUI* pCmdUI) 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_MODEL_FILES ||
		CAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_RERUN_FILE) pCmdUI->SetCheck(1);
	else pCmdUI->SetCheck(0);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceTextView::OnRunEnableMonteCarlo()
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.enable != E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
		CAnalysisSetup.CReRun.enable = E_RERUN_SWEEP_TYPE_MC_RERUN_FILE;
	else
		CAnalysisSetup.CReRun.enable = 0;

	if(CAnalysisSetup.CReRun.enable)
	{
		if(CAnalysisSetup.CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_MULTY_RUNS)
			CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = false;
		
		CAnalysisSetup.CParametricSetupData.CSweepData.enable = false;
		CAnalysisSetup.CStatisticsSetupData.enable = false;
	}
}

void TCSuperSpiceTextView::OnUpdateRunEnableMonteCarlo(CCmdUI *pCmdUI)
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE) pCmdUI->SetCheck(1);
	else pCmdUI->SetCheck(0);

	pCmdUI->ContinueRouting();
}


void TCSuperSpiceTextView::OnRunSensitivity() 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;// dc sensitivity

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CSensitivitySetupData.enable_dc = !CAnalysisSetup.CSensitivitySetupData.enable_dc;

	if(CAnalysisSetup.CSensitivitySetupData.enable_dc) CAnalysisSetup.CSensitivitySetupData.enable_ac = false;
}

void TCSuperSpiceTextView::OnUpdateRunSensitivity(CCmdUI* pCmdUI) 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
		
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CSensitivitySetupData.enable_dc);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceTextView::OnRunSensitivityAc() 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CSensitivitySetupData.enable_ac = !CAnalysisSetup.CSensitivitySetupData.enable_ac;

	if(CAnalysisSetup.CSensitivitySetupData.enable_ac) CAnalysisSetup.CSensitivitySetupData.enable_dc = false;
}

void TCSuperSpiceTextView::OnUpdateRunSensitivityAc(CCmdUI* pCmdUI) 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
		
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CSensitivitySetupData.enable_ac);

	pCmdUI->ContinueRouting();
}
void TCSuperSpiceTextView::OnRunTemperature() 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = !CAnalysisSetup.CTemperatureSetupData.CSweepData.enable;

	if(CAnalysisSetup.CTemperatureSetupData.CSweepData.enable &&
	   CAnalysisSetup.CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_MULTY_RUNS)
	{
		CAnalysisSetup.CParametricSetupData.CSweepData.enable = false;
		CAnalysisSetup.CStatisticsSetupData.enable = false;
		CAnalysisSetup.CReRun.enable = false;
	}
}

void TCSuperSpiceTextView::OnUpdateRunTemperature(CCmdUI* pCmdUI) 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CTemperatureSetupData.CSweepData.enable);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceTextView::OnRunTransient() 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
			
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CTransientSetupData.CSweepData.enable = !CAnalysisSetup.CTransientSetupData.CSweepData.enable;
}

void TCSuperSpiceTextView::OnUpdateRunTransient(CCmdUI* pCmdUI) 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CTransientSetupData.CSweepData.enable);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceTextView::OnRunStop() 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	PCDoc->PCParentSuperSpiceDoc->GetTopLevelDoc()->OnRunStop();
}

BOOL TCSuperSpiceTextView::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// need to modify to go direct to relevent help

	pHelpInfo;

	AfxGetApp()->WinHelpInternal(0, HELP_CONTENTS);
	
	return true;	
}

BOOL TCSuperSpiceTextView::OnEditChange()
{
	TCSuperSpiceTextDoc* PCDoc = GetDocument();
	
	if(!PCDoc) return FALSE;

	//Overide the default message map in ViewEdit.cpp

	PCDoc->SetModifiedFlag();

	PCDoc->UpdateTitle();

	return FALSE;  
}

void TCSuperSpiceTextView::OnViewPcbNetlist() 
{
	TCSuperSpiceTextDoc* PCDoc = GetDocument();
	
	if(!PCDoc) return;	

	PCDoc->OnViewPcbNetlist(this);	
}


void TCSuperSpiceTextView::OnWaveformsDisplaypolezerowaveform() 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	int index = PCDoc->PCParentSuperSpiceDoc->GetOutputWaveformData()->GetWaveFormHeaderIndex(E_SPICE_RECORD_POLE_ZERO);

	if(index < 0) return;

	PCDoc->PCParentSuperSpiceDoc->OnViewDisplayPoleZeroText(this);
}

void TCSuperSpiceTextView::OnUpdateWaveformsDisplaypolezerowaveform(CCmdUI* pCmdUI) 
{
	TCSuperSpiceTextDoc* PCDoc = (TCSuperSpiceTextDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	pCmdUI->Enable(PCDoc->PCParentSuperSpiceDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_POLE_ZERO));	
	
}

void TCSuperSpiceTextView::OnSetFocus(CWnd* pOldWnd) 
{
	CRichEditView::OnSetFocus(pOldWnd);
	
	PCSuperSpiceDocLastFocused = NULL;
	PCSuperSpiceViewLastFocused  = NULL;	
}

void TCSuperSpiceTextView::OnComponentsModellibary() 
{
	TCSuperSpiceTextDoc* PCDoc = GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	PCDoc->PCParentSuperSpiceDoc->DisplayModelLibary(this);	
}

void TCSuperSpiceTextView::DisplayModel(CString CFileName, CString CModelName)
{
	//clear ld model
	SetWindowText("");

	TCSpiceParameters CSpiceParameters;	

	CSpiceParameters.CDataBaseIdInfo.CRecordName	= CModelName;
	CSpiceParameters.CDataBaseIdInfo.CRecordFilePath = ExtractPathName(CFileName);
	CSpiceParameters.CDataBaseIdInfo.CRecordFileName = ExtractFileName(CFileName);

	if(!GCSuperSpiceDataBase.CModelDataBase.Get(CSpiceParameters)) return;

	CArray <CString, CString &> CTextLines;

	CSpiceParameters.GetToText(CTextLines);

	int count = CTextLines.GetSize();

	if(!count) return;

	CString CTextLine;
	CString CEndLine = "\r\n";

	for(int p = 0; p < count; p++)
	{
		CTextLine += CTextLines[p] + CEndLine;
	}

	SetWindowText(CTextLine);
}


