// TCSuperSpiceView.cpp : implementation of the TCSuperSpiceView class
//

#include "stdafx.h"
#include "resource.h"
#include "TESuperSpiceMsgStringsEnums.h"
#include "TCStringFunctions.h"
#include "TCSuperSpiceDataBase.h"
#include "TCOpenSchematicPage.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCSuperSpiceDoc.h"
#include "TCSuperSpiceControlItem.h"
#include "TCSuperSpiceView.h"
#include "TCAddText1.h"
#include "TCOutputWaveformData.h"
#include "TCPasswordId.h"
#include "TCTestPointDlg.h"
#include "TCNetList.h"
#include "TCWorkspaceTree.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern TCSuperSpiceDataBase GCSuperSpiceDataBase;
extern CPoint GlobalMousePosition;
extern TCMultyTaskedString CGlobalStatusMessage;
extern CPoint GlobalMouseOffset;
extern TCSuperSpiceGlobalData GCSuperSpiceGlobalData;
TCSuperSpiceDoc *PCSuperSpiceDocLastFocused = NULL;
TCSuperSpiceView *PCSuperSpiceViewLastFocused = NULL;
extern TCWorkspaceTree GCWorkspaceTree;


extern int	g_show_all_net_names;
extern int	g_show_all_dc_volts;
extern int	g_show_all_dc_currents;

IMPLEMENT_SERIAL(TCSuperSpiceViewData, CObject, ID_VERSION_NUMBER)
/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceView


TCSuperSpiceViewData::TCSuperSpiceViewData(void)
{
	CPoint CZero(0, 0);

	CLastMousePosition	=  CZero;
	page_id				= 0;
	system_state		= E_GRAPHICS_MANAGER_STATE_IDLE;
	PCMSchematicManager = NULL;
	CMaxSize			= CZero;
	CPageSize			= CZero;
	CLineSize			= CZero;
	CViewPortOrigin		= CZero;
	CScrollBarPosition  = CZero;
}

TCSuperSpiceViewData::TCSuperSpiceViewData(TCSuperSpiceViewData &CSuperSpiceViewData)
{
	*this = CSuperSpiceViewData;
}
TCSuperSpiceViewData::~TCSuperSpiceViewData(void)
{

}



IMPLEMENT_DYNCREATE(TCSuperSpiceView, CScrollView)

BEGIN_MESSAGE_MAP(TCSuperSpiceView, CScrollView)
	
	//{{AFX_MSG_MAP(TCSuperSpiceView)
	
	ON_WM_MOUSEMOVE()
	ON_WM_SETCURSOR()
	ON_WM_CONTEXTMENU()
	ON_WM_SETFOCUS()
	ON_WM_SIZE()
	
	ON_WM_RBUTTONUP()
	ON_WM_LBUTTONUP()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_VSCROLL()
	ON_WM_HSCROLL()
	ON_WM_KILLFOCUS()
	ON_WM_DESTROY()
	ON_WM_HELPINFO()
	ON_WM_TIMER()
 
	ON_COMMAND(ID_DRAWING_ZOOMIN, OnDrawingZoomIn)
	ON_UPDATE_COMMAND_UI(ID_DRAWING_ZOOMIN, OnUpdateDrawingZoomIn)
	ON_COMMAND(ID_DRAWING_ZOOMOUT, OnDrawingZoomOut)
	ON_UPDATE_COMMAND_UI(ID_DRAWING_ZOOMOUT, OnUpdateDrawingZoomOut)

	ON_COMMAND(ID_WINDOW_NEW, OnWindowNew)
	ON_COMMAND(ID_PAGES_OPENPAGE, OnPagesOpenpage)
	ON_COMMAND(ID_PAGES_DELETE_PAGE, OnPagesDeletePage)
	ON_COMMAND(ID_PAGES_NEWPAGE, OnPagesNewPage)
	ON_COMMAND(ID_PAGES_COPYPAGE, OnPagesCopyPage)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_COMMAND(ID_EDIT_CUT, OnEditCut)
	ON_COMMAND(ID_EDIT_DELETE, OnEditDelete)
	ON_COMMAND(ID_EDIT_SELECTALL, OnEditSelectAll)
	ON_COMMAND(ID_CANCEL_COMMAND, OnCancelCommand)
	ON_COMMAND(ID_EDIT_PASTE1, OnEditPaste1)
	ON_COMMAND(ID_EDIT_COPY_WITH_PASTE, OnEditCopyWithPaste)
	ON_COMMAND(ID_GET_NPN, OnGetNpn)
	ON_COMMAND(ID_GET_PNP, OnGetPnp)
	ON_COMMAND(ID_GET_CAPACITOR, OnGetCapacitor)
	ON_COMMAND(ID_GET_DIODE, OnGetDiode)
	ON_COMMAND(ID_GET_INDUCTOR, OnGetInductor)
	ON_COMMAND(ID_GET_NMOS, OnGetNmos)
	ON_COMMAND(ID_GET_PMOS, OnGetPmos)
	ON_COMMAND(ID_GET_RESISTOR, OnGetResistor)
	ON_COMMAND(IDM_SPICE_VIEW_PROPERTIES, OnSpiceViewProperties)
	ON_COMMAND(IDM_VIEW_OUTPUT_GRAPH, OnViewOutputGraph)
	ON_COMMAND(IDM_VIEW_OUTPUT_TEXT, OnViewOutputText)
	ON_COMMAND(IDM_VIEW_SPICE_TEXT, OnViewInputSpiceText)
	ON_COMMAND(ID_DRAW_WIRE, OnDrawWire)
	ON_COMMAND(ID_DRAW_BUS, OnDrawBus)
	ON_COMMAND(ID_DRAWING_ZOOM_CENTER, OnDrawingZoomCenter)
	ON_COMMAND(ID_ADD_USER_TEXT, OnAddUserText)
	ON_COMMAND(ID_OPTIONS_SCHEMATIC, OnOptionsSchematic)
	ON_COMMAND(ID_DRAWING_ROTATE, OnDrawingRotate)
	ON_COMMAND(ID_DRAWING_MIRROR, OnDrawingMirror)
	ON_COMMAND(ID_DRAWING_FLIP, OnDrawingFlip)
	ON_COMMAND(ID_GET_OPAMP, OnGetOpAmp)
	ON_COMMAND(ID_GET_VOLTAGE_SOURCE, OnGetVoltageSource)
	ON_COMMAND(ID_GET_CURRENT_SOURCE, OnGetCurrentSource)
	ON_COMMAND(ID_COMPONENTS_COMPONENTLIBARY, OnComponentsOpenComponentLibary)
	ON_COMMAND(ID_COMPONENTS_DRAWZENER, OnComponentsDrawZener)
	ON_COMMAND(ID_TESTPOINTS_DRAWVOLTAGE, OnTestpointsDrawVoltage)
	ON_COMMAND(ID_COMPONENTS_DRAWVCVC, OnComponentsDrawVCVS)
	ON_COMMAND(ID_COMPONENTS_VCIS, OnComponentsVCIS)
	ON_COMMAND(ID_COMPONENTS_NJFET, OnComponentsNJFet)
	ON_COMMAND(ID_COMPONENTS_PJFET, OnComponentsPJFet)
	ON_COMMAND(ID_COMPONENTS_GROUND, OnComponentsGround)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_DRAWSHOTKEY, OnComponentsMorecomponentsDrawShottky)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_DRAWTHYRESISTOR, OnComponentsMorecomponentsDrawThyresistor)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_DRAWDIAC, OnComponentsDrawDiac)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_DRAWGTOTRIAC, OnComponentsDrawGTOTriac)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_DRAWTRANSFORMER, OnComponentsMorecomponentsDrawtTransformer)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_DRAWTRANSMISSIONLINE, OnComponentsMorecomponentsDrawTransmissionLine)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_DRAWTRIAC, OnComponentsMorecomponentsDrawTriac)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_DRAWVCSWITCH, OnComponentsMorecomponentsDrawVCSwitch)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_DUALGATEMOSFET, OnComponentsMorecomponentsDualGateMosfet)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_IGBP, OnComponentsIGBP)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_DUALGATEPMOSFET, OnComponentsMorecomponentsDualGatePMosfet)
	ON_COMMAND(ID_COMPONENTS_FILTER, OnComponentsFilter)
	ON_COMMAND(ID_COMPONENTS_GENERIC_TWOPIN, OnComponentsGeneric2Pin)
	ON_COMMAND(ID_COMPONENTS_GENERIC_3PINCOMPONENT, OnComponentsGeneric3Pin)
	ON_COMMAND(ID_COMPONENTS_GENERIC_4PINCOMPONENT, OnComponentsGeneric4Pin)
	ON_COMMAND(ID_COMPONENTS_GENERIC_5PINCOMPONENT, OnComponentsGeneric5Pin)
	ON_COMMAND(ID_COMPONENTS_GENERIC_6PINCOMPONENT, OnComponentsGeneric6Pin)
	ON_COMMAND(ID_COMPONENTS_GENERIC_7PINCOMPONENT, OnComponentsGeneric7Pin)
	ON_COMMAND(ID_COMPONENTS_GENERIC_8PINCOMPONENT, OnComponentsGeneric8Pin)
	ON_COMMAND(ID_COMPONENTS_GENERIC_10PINCOMPONENT, OnComponentsGeneric10Pin)
	ON_COMMAND(ID_COMPONENTS_GENERIC_11PINCOMPONENT, OnComponentsGeneric11Pin)
	ON_COMMAND(ID_COMPONENTS_GENERIC_12PINCOMPONENT, OnComponentsGeneric12Pin)
	ON_COMMAND(ID_COMPONENTS_GENERIC_13PINCOMPONENT, OnComponentsGeneric13Pin)
	ON_COMMAND(ID_COMPONENTS_GENERIC_14PINCOMPONENT, OnComponentsGeneric14Pin)
	ON_COMMAND(ID_COMPONENTS_GENERIC_15PINCOMPONENT, OnComponentsGeneric15Pin)
	ON_COMMAND(ID_COMPONENTS_GENERIC_16PINCOMPONENT, OnComponentsGeneric16Pin)
	ON_COMMAND(ID_COMPONENTS_GENERIC_9PINCOMPONENT, OnComponentsGeneric9Pin)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_IGBPP, OnComponentsIGBPPNP)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_NMOS4TERMINAL, OnComponentsNmos4Terminal)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_NPN4TERMINAL, OnComponentsNpn4Terminal)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_PMOS4TERMINAL, OnComponentsPmos4Terminal)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_PNP4TERMINAL, OnComponentsPnp4Terminal)
	ON_COMMAND(ID_COMPONENTS_BUFFER, OnComponentsBuffer)
	ON_COMMAND(ID_COMPONENTS_VCA, OnComponentsVCA)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_NJFET4TERMINAL, OnComponentsNJFET4Terminal)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_PJFET4TERMINAL, OnComponentsPJFET4Terminal)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_UJUNCTIONNCHANNEL, OnComponentsUJunction)
	ON_COMMAND(ID_COMPONENTS_GENERIC_2INPUTAMP, OnComponentsGeneric2InputAmp)
	ON_COMMAND(ID_COMPONENTS_SOLDERBLOB, OnComponentsSolderBlob)
	ON_COMMAND(ID_AROW_UP, OnArowUp)
	ON_COMMAND(ID_ARROW_DOWN, OnArrowDown)
	ON_COMMAND(ID_ARROW_LEFT, OnArrowLeft)
	ON_COMMAND(ID_ARROW_RIGHT, OnArrowRight)
	ON_COMMAND(ID_PAGE_DOWN, OnPageDown)
	ON_COMMAND(ID_PAGE_UP, OnPageUp)
	ON_COMMAND(ID_DRAW_WIRE_IMMEDIATLY, OnDrawWireImmediatly)
	ON_COMMAND(ID_PROPERTY_ACCELERATER, OnPropertyAccelerater)
	ON_COMMAND(ID_TEST_GRAPHIC, OnTestGraphic)
	ON_COMMAND(IDM_SIMULATION_SETUP, OnSimulationSetup)
	ON_UPDATE_COMMAND_UI(ID_RUN_AC, OnUpdateRunAc)
	ON_COMMAND(ID_RUN_AC, OnRunAc)
	ON_COMMAND(ID_RUN_DC, OnRunDc)
	ON_UPDATE_COMMAND_UI(ID_RUN_DC, OnUpdateRunDc)
	ON_COMMAND(ID_RUN_ENABLENOISE, OnRunEnableNoise)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLENOISE, OnUpdateRunEnableNoise)
	ON_COMMAND(ID_RUN_TRANSIENT, OnRunTransient)
	ON_UPDATE_COMMAND_UI(ID_RUN_TRANSIENT, OnUpdateRunTransient)
	ON_COMMAND(ID_RUN_ENABLEFOURIER, OnRunEnableFourier)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEFOURIER, OnUpdateRunEnableFourier)
	ON_COMMAND(ID_RUN_ENABLE_STATISTICS, OnRunStatistics)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLE_STATISTICS, OnUpdateRunStatistics)
	ON_COMMAND(ID_RUN_PARAMETRIC, OnRunParametric)
	ON_UPDATE_COMMAND_UI(ID_RUN_PARAMETRIC, OnUpdateRunParametric)
	ON_COMMAND(ID_RUN_TEMPERATURE, OnRunTemperature)
	ON_UPDATE_COMMAND_UI(ID_RUN_TEMPERATURE, OnUpdateRunTemperature)
	ON_COMMAND(ID_RUN_SENSITIVITY, OnRunSensitivity)
	ON_UPDATE_COMMAND_UI(ID_RUN_SENSITIVITY, OnUpdateRunSensitivity)
	ON_COMMAND(ID_RUN_ENABLEPOLEZERO, OnRunEnablePoleZero)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEPOLEZERO, OnUpdateRunEnablePoleZero)
	ON_COMMAND(ID_RUN_ENABLEDISTORTION, OnRunEnableDistortion)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEDISTORTION, OnUpdateRunEnableDistortion)
	ON_COMMAND(ID_RUN_UPDATENETNAMES, OnRunUpdateNetNames)
	ON_COMMAND(ID_VIEW_INCLUDEFILE, OnViewIncludeFile)
	ON_COMMAND(ID_GENERATORS_ACCURRENTSOURCE, OnGeneratorsAccurrentsource)
	ON_COMMAND(ID_GENERATORS_ACSOURCE, OnGeneratorsAcsource)
	ON_COMMAND(ID_GENERATORS_DCCURRENTSOURCE, OnGeneratorsDccurrentsource)
	ON_COMMAND(ID_GENERATORS_DCSOURCE, OnGeneratorsDcsource)
	ON_COMMAND(ID_GENERATORS_EXPONENTIALCURRENTSOURCE, OnGeneratorsExponentialcurrentsource)
	ON_COMMAND(ID_GENERATORS_EXPONENTIALSOURCE, OnGeneratorsExponentialsource)
	ON_COMMAND(ID_GENERATORS_PIECEWISELINEARSOURCE, OnGeneratorsPiecewiselinearsource)
	ON_COMMAND(ID_GENERATORS_PULSE, OnGeneratorsPulse)
	ON_COMMAND(ID_GENERATORS_PULSECURRENTSOURCE, OnGeneratorsPulsecurrentsource)
	ON_COMMAND(ID_GENERATORS_SINGLEFREQUENCYFMCURRENTSOURCE, OnGeneratorsSinglefrequencyfmcurrentsource)
	ON_COMMAND(ID_GENERATORS_SINGLEFREQUENCYFMSOURCE, OnGeneratorsSinglefrequencyfmsource)
	ON_COMMAND(ID_TESTPOINTS_CURRENT, OnTestpointsCurrent)
	ON_COMMAND(ID_TESTPOINTS_CURRENTMAGNITUDEDB, OnTestpointsCurrentmagnitudedb)
	ON_COMMAND(ID_TESTPOINTS_CURRENTPHASE, OnTestpointsCurrentphase)
	ON_COMMAND(ID_TESTPOINTS_VOLTAGEMAGNITUDEDB, OnTestpointsVoltagemagnitudedb)
	ON_COMMAND(ID_TESTPOINTS_VOLTAGEPHASE, OnTestpointsVoltagephase)
	ON_COMMAND(ID_GENERATORS_PIECEWISELINEARCURRENTSOURCE, OnGeneratorsPiecewiselinearcurrentsource)
	ON_COMMAND(ID_VIEW_DC_VOLTAGES, OnViewDcVoltages)
	ON_COMMAND(ID_VIEW_NETNAMES, OnViewNetNames)
	ON_UPDATE_COMMAND_UI(ID_VIEW_DC_VOLTAGES, OnUpdateViewDcVoltages)
	ON_UPDATE_COMMAND_UI(ID_VIEW_NETNAMES, OnUpdateViewNetNames)
	ON_COMMAND(ID_VIEW_DC_CURRENTS, OnViewDcCurrents)
	ON_UPDATE_COMMAND_UI(ID_VIEW_DC_CURRENTS, OnUpdateViewDcCurrents)
	ON_COMMAND(ID_GET_NGASFET_4TERM, OnGetNGasFet4Terminal)
	ON_COMMAND(ID_GET_NGASFET, OnGetNGasFet)
	ON_COMMAND(ID_GET_PGASFET, OnGetPGasFet)
	ON_COMMAND(ID_GET_PGASFET_4_TERM, OnOnGetPGasFet4Terminal)
	ON_COMMAND(ID_GET_IC_CAPACITOR, OnGetIcCapacitor)
	ON_COMMAND(ID_GET_IC_RESISTOR, OnGetIcResistor)
	ON_COMMAND(ID_CONNECTION_POINT_INPUT, OnConnectionPointInput)
	ON_COMMAND(ID_CONNECTION_POINT_OUTPUT, OnConnectionPointOutput)
	ON_COMMAND(ID_CONNECTION_POINT_BIDIRECTIONAL, OnConnectionPointBidirectional)
	ON_UPDATE_COMMAND_UI(ID_COMPONENTS_SOLDERBLOB, OnUpdateComponentsSolderblob)
	ON_COMMAND(ID_VIEW_INCLUDEDMODELSFILE, OnViewIncludedModelsFile)
	ON_COMMAND(ID_VIEW_DECEND, OnViewDecendSchematic)
	ON_COMMAND(ID_VIEW_ACCEND, OnViewAccendSchematic)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ACCEND, OnUpdateViewAccendSchematic)
	ON_COMMAND(ID_COMPONENTS_SUBCIRCUITCONNECTOR, OnComponentsSubcircuitConnector)
	ON_COMMAND(ID_RUN_RERUNS, OnRunReruns)
	ON_UPDATE_COMMAND_UI(ID_RUN_RERUNS, OnUpdateRunReruns)
	ON_COMMAND(ID_RUN_RUN, OnRunRun)
	ON_COMMAND(ID_RUN_RUN_SAME_NRT_LIST, OnRunRunSameNetList)
	ON_COMMAND(ID_WINDOW_NEW_GRAPHIC, OnWindowNewGraph)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, OnFilePrintPreview)
	ON_COMMAND(ID_GRAPHICS_PLACENEWGRAPH, OnGraphicsPlaceNewGraph)
	ON_COMMAND(ID_WAVEFORMS_DISPLAYACWAVEFORM, OnWaveformsDisplayacwaveform)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_DISPLAYACWAVEFORM, OnUpdateWaveformsDisplayacwaveform)
	ON_COMMAND(ID_WAVEFORMS_DISPLAYDCWAVEFORM, OnWaveformsDisplaydcwaveform)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_DISPLAYDCWAVEFORM, OnUpdateWaveformsDisplaydcwaveform)
	ON_COMMAND(ID_WAVEFORMS_DISPLAYFOURIERWAVEFORM, OnWaveformsDisplayfourierwaveform)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_DISPLAYFOURIERWAVEFORM, OnUpdateWaveformsDisplayfourierwaveform)
	ON_COMMAND(ID_WAVEFORMS_DISPLAYNOISEWAVEFORM, OnWaveformsDisplaynoisewaveform)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_DISPLAYNOISEWAVEFORM, OnUpdateWaveformsDisplaynoisewaveform)
	ON_COMMAND(ID_WAVEFORMS_DISPLAYPOLEZEROWAVEFORM, OnWaveformsDisplaypolezerowaveform)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_DISPLAYPOLEZEROWAVEFORM, OnUpdateWaveformsDisplaypolezerowaveform)
	ON_COMMAND(ID_WAVEFORMS_DISPLAYSENSWAVEFORM, OnWaveformsDisplaysenswaveform)
	ON_COMMAND(ID_WAVEFORMS_DISPLAYTRANSWAVEFORM, OnWaveformsDisplaytranswaveform)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_DISPLAYTRANSWAVEFORM, OnUpdateWaveformsDisplaytranswaveform)
	ON_COMMAND(ID_WAVEFORMS_DISTORTION, OnWaveformsDistortion)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_DISTORTION, OnUpdateWaveformsDistortion)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_DISPLAYSENSWAVEFORM, OnUpdateWaveformsDisplaysenswaveform)
	ON_COMMAND(ID_RUN_ENABLEOPERATINGPOINT, OnRunEnableOperatingPoint)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEOPERATINGPOINT, OnUpdateRunEnableOperatingPoint)
	ON_COMMAND(ID_AXIS_AUTOSCALE, OnAxisAutoScale)
	ON_COMMAND(ID_AXIS_MAGNIFY, OnAxisMagnify)
	ON_COMMAND(ID_AXIS_REDUCE, OnAxisReduce)
	ON_COMMAND(ID_AXIS_SCROL_XLEFT, OnAxisScrolXLeft)
	ON_COMMAND(ID_AXIS_SCROL_XRIGHT, OnAxisScrolXRight)
	ON_COMMAND(ID_AXIS_SCROLL_YDOWN, OnAxisScrollYDown)
	ON_COMMAND(ID_AXIS_SCROLL_YUP, OnAxisScrollYUp)
	ON_COMMAND(ID_VIEW_DESIGNNOTES, OnViewDesignNotes)
	ON_COMMAND(ID_ESCAPE, OnEscape)
	ON_COMMAND(ID_HELP_GETCOMPUTERPASSWORD, OnHelpGetcomputerpassword)
	ON_COMMAND(ID_SETUP_CLEARERRORS, OnSetupClearErrors)
	ON_COMMAND(ID_EDIT_COPY_TO_WINDOWS_CLIPBOARD, OnEditCopyToWindowsClipboard)
	ON_COMMAND(ID_COMPONENTS_DIGITAL_INVERTOR, OnComponentsAnalogInvertor)
	ON_COMMAND(ID_COMPONENTS_DIGITAL_AND, OnComponentsAnalogAnd)
	ON_COMMAND(ID_COMPONENTS_DIGITAL_NAND, OnComponentsAnalogNand)
	ON_COMMAND(ID_COMPONENTS_DIGITAL_NOR, OnComponentsAnalogNor)
	ON_COMMAND(ID_COMPONENTS_DIGITAL_OR, OnComponentsAnalogOr)
	ON_COMMAND(ID_RUN_RUNDEBUGMODE, OnRunRunDebugMode)
	ON_COMMAND(ID_EDIT_UTILITIES_RENUMBERWIRES, OnEditUtilitiesRenumberWires)
	ON_COMMAND(ID_EDIT_UTILITIES_RENUMBERREFDESIGNATORS, OnEditUtilitiesRenumberRefDesignators)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TRIODEVALVETUBE, OnComponentsMorecomponentsTriodeValveTube)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_PENTODEVALVETUBE, OnComponentsMorecomponentsPentodeValveTube)
	ON_COMMAND(ID_POPUP_COMPONENTS_MORECOMPONENTS_TETRODEVALVETUBE, OnPopupComponentsMorecomponentsTetrodeValveTube)
	ON_COMMAND(ID_COMPONENTS_DIGITAL_DTYPEBISTABLE, OnComponentsDigitalDtypeBistable)
	ON_COMMAND(ID_COMPONENTS_DIGITAL_JKBISABLE, OnComponentsDigitalJkBisable)
	ON_COMMAND(ID_COMPONENTS_DIGITAL_8BITCOUNTER, OnComponentsDigital8BitCounter)
	ON_COMMAND(ID_COMPONENTS_DIGITAL_EXOR, OnComponentsAnalogExOr)
	ON_COMMAND(ID_COMPONENTS_DIGITAL_EXNOR, OnComponentsAnalogExNor)
	ON_COMMAND(ID_COMPONENTS_DIGITAL_SCHMITTTRIGGER, OnComponentsAnalogSchmittTrigger)
	ON_COMMAND(ID_TESTPOINTS_DISPLAYONWIRECLICK, OnTestpointsDisplayonWireClick)
	ON_UPDATE_COMMAND_UI(ID_TESTPOINTS_DISPLAYONWIRECLICK, OnUpdateTestpointsDisplayOnWireClick)
	ON_COMMAND(ID_TESTPOINTS_WIREONCLICKTESTPOINTSETUP, OnTestpointsWireOncliCkTestPointSetup)
	ON_COMMAND(ID_COMPONENTS_LDO, OnComponentsLdo)
	ON_COMMAND(ID_VIEW_COMPONENTMAKER, OnViewSymbolEditor)
	ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
	ON_COMMAND(ID_RUN_SENSITIVITY_AC, OnRunSensitivityAc)
	ON_UPDATE_COMMAND_UI(ID_RUN_SENSITIVITY_AC, OnUpdateRunSensitivityAc)
	ON_COMMAND(ID_WAVEFORMS_DISTORTION2, OnWaveformsDistortion2)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_DISTORTION2, OnUpdateWaveformsDistortion2)
	ON_COMMAND(ID_WAVEFORMS_DISTORTION_F2, OnWaveformsDistortionF2)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_DISTORTION_F2, OnUpdateWaveformsDistortionF2)
	ON_COMMAND(ID_COMPONENTS_DIGITALNOPINS_INVERTOR, OnComponentsDigitalInvertor)
	ON_COMMAND(ID_COMPONENTS_DIGITALNOPINS_AND, OnComponentsDigitalAnd)
	ON_COMMAND(ID_COMPONENTS_DIGITALNOPINS_NAND, OnComponentsDigitalNand)
	ON_COMMAND(ID_COMPONENTS_DIGITALNOPINS_NOR, OnComponentsDigitalNor)
	ON_COMMAND(ID_COMPONENTS_DIGITALNOPINS_OR, OnComponentsDigitalOr)
	ON_COMMAND(ID_COMPONENTS_DIGITALNOPINS_EXOR, OnComponentsDigitalExOr)
	ON_COMMAND(ID_COMPONENTS_DIGITALNOPINS_EXNOR, OnComponentsDigitalExNor)
	ON_COMMAND(ID_COMPONENTS_ANALOGTODIGITALCONVERTER, OnComponentsAnalogtoDigitalConverter)
	ON_COMMAND(ID_COMPONENTS_DIGITALTOANALOGCONVERTOR, OnComponentsDigitaltoAnalogConvertor)
	ON_COMMAND(ID_COMPONENTS_LAPLACETRANSFORM, OnComponentsLaplaceTransform)
	ON_COMMAND(ID_VIEW_SPICEENGNEERRORLOG, OnViewSpiceEngineErrorlog)
	ON_COMMAND(ID_COMPONENTS_MODELLIBARY, OnComponentsModelLibary)
	ON_COMMAND(ID_COMPONENTS_DIVIDER, OnComponentsDivider)
	ON_COMMAND(ID_COMPONENTS_NONLINEARSOURCE, OnComponentsNonlinearSource)
	ON_COMMAND(ID_WAVEFORMS_TRANTOFREQFFT, OnWaveformsTrantofreqFFT)
	ON_COMMAND(ID_WAVEFORMS_ACTOTIMEDOMAINFFT, OnWaveformsActotimedomainFFT)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_TRANTOFREQFFT, OnUpdateWaveformsTrantofreqFFT)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_ACTOTIMEDOMAINFFT, OnUpdateWaveformsActotimedomainFFT)
	ON_COMMAND(ID_WAVEFORMS_CALCULATEFFTIFFTDATA, OnWaveformsCalculatefftifftdata)
	ON_COMMAND(ID_VIEW_FANTASTICFILTER, OnViewFantasticFilter)
	ON_COMMAND(ID_EDIT_RUBBERBANING, OnEditRubberbanding)
	ON_UPDATE_COMMAND_UI(ID_EDIT_RUBBERBANING, OnUpdateEditRubberbanding)
	ON_COMMAND(ID_COMPONENTS_VARIABLERESISTOR, OnComponentsVariableResistor)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TRANSFORMERS_DUALCENTERTAPEDTRANSFORMER, OnComponentsTransformersDualCentertaped)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TRANSFORMERS_DUALTRANSFORMER, OnComponentsTransformersDual)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TRANSFORMERS_QUADCENTERTAPEDTRANSFORMER, OnComponentsTransformersQuadCentertaped)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TRANSFORMERS_QUADTRANSFORMER, OnComponentsTransformersQuad)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TRANSFORMERS_SINGLECENTERTAPTRANSFORMER, OnComponentsTransformersSingleCentertap)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TRANSFORMERS_TRIPLECENTERTAPEDTRANSFORMER, OnComponentsTransformersTripleCentertaped)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TRANSFORMERS_TRIPLETRANSFORMER, OnComponentsTransformersTriple)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TUBEDIODE, OnComponentsTubeDiode)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TUBEDIODESEPERATECATHODES, OnComponentsTubediodeseperatecathodes)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TUBEDUALDIODECOMMONK, OnComponentsTubedualdiodecommonk)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_THERMISTOR, OnComponentsThermistor)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_VARISTORMOV, OnComponentsMorecomponentsVaristorMov)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TRANSFORMERS_TUBEOUTPUTTRANSFORMER, OnComponentsMorecomponentsTransformersTubeoutputtransformer)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TRANSFORMERS_FLYBACKTRIPLETRANSFORMER, OnComponentsMorecomponentsTransformersFlybacktripletransformer)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_FUSE, OnComponentsFuse)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_CRYSTAL, OnComponentsCrystal)
	ON_COMMAND(ID_FILE_PCBNETLISTS_GENERIC, OnFilePcbNetlistsGeneric)
	ON_COMMAND(ID_VIEW_PCBNETLIST, OnViewPcbNetlist)
	ON_COMMAND(ID_FILE_PCBNETLISTS_ORCAD, OnFilePcbnetlistsOrcad)
	ON_COMMAND(ID_FILE_PCBNETLISTS_CREATEPROTEL, OnFilePcbnetlistsCreateProtel)
	ON_COMMAND(ID_FILE_PCBNETLISTS_CREATETANGO, OnFilePcbnetlistsCreateTango)
	ON_COMMAND(ID_FILE_PCBNETLISTS_PCLOGIC, OnFilePcbnetlistsPclogic)
	ON_COMMAND(ID_FILE_PCBNETLISTS_CREATEEAGLE, OnFilePcbnetlistsCreateeagle)
	ON_UPDATE_COMMAND_UI(ID_WAVEFORMS_CALCULATEFFTIFFTDATA, OnUpdateWaveformsCalculatefftifftdata)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TRANSFORMERS_INDUCTORCORED, OnComponentsMorecomponentsTransformersInductorCored)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TUBESVALVES_TRIODETUBEWITHHEATER, OnComponentsMorecomponentsTubesvalvesTriodetubewithheater)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TUBESVALVES_PENTODETUBEWITHHEATER, OnComponentsMorecomponentsTubesvalvesPentodetubewithheater)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TUBESVALVES_TETRODETUBEWITHHEATER, OnComponentsMorecomponentsTubesvalvesTetrodetubewithheater)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TUBESVALVES_TUBEDIODECC, OnComponentsMorecomponentsTubesvalvesTubediodecc)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TUBESVALVES_TUBEDIODESEPERATECATHODES, OnComponentsMorecomponentsTubesvalvesTubediodeseperatecathodes)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TUBESVALVES_TUBEDIODEWITHHEATER, OnComponentsMorecomponentsTubesvalvesTubediodewithheater)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_MOTER, OnComponentsMorecomponentsMoter)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_MOTERWITHTACHO, OnComponentsMorecomponentsMoterwithtacho)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_FLORESENTLAMPCCFL, OnComponentsMorecomponentsFloresentlampccfl)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TUBESVALVES_TUBEDUAL, OnComponentsMorecomponentsTubesvalvesTubedual)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TUBESVALVES_TUBEDUALWITHHEATER, OnComponentsMorecomponentsTubesvalvesTubedualwithheater)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TUBESVALVES_TUBE8PIN, OnComponentsMorecomponentsTubesvalvesTube8pin)
	ON_COMMAND(ID_COMPONENTS_TITLEBLOCK, OnComponentsTitleblock)
	ON_COMMAND(ID_POPUP_PROPERTIES_VIEW, OnPopupProperties)
	ON_COMMAND(ID_POPUP_CHANGEWAVECOLOUR, OnPopupChangewavecolour)
	ON_COMMAND(ID_POPUP_CLEARALLWAVEFORMS, OnPopUpClearAllWaveforms)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TUBESVALVES_TUBETRIODECATHODEHEATER, OnComponentsMorecomponentsTubesvalvesTubetriodecathodeheater)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TUBESVALVES_TUBEDIODECATHODEHEATER, OnComponentsMorecomponentsTubesvalvesTubediodecathodeheater)
	ON_COMMAND(ID_COMPONENTS_MORECOMPONENTS_TUBESVALVES_TUBEDUALDIODECATHODEHEATER, OnComponentsMorecomponentsTubesvalvesTubedualdiodecathodeheater)
	ON_COMMAND(ID_DRAW_DISPLAY_GRID, OnDrawDrawGrid)
	ON_UPDATE_COMMAND_UI(ID_DRAW_DISPLAY_GRID, OnUpdateOnDrawDrawGrid)
	ON_COMMAND(ID_DRAW_PAGE_BORDER, OnDrawDrawPageBorder)
	ON_UPDATE_COMMAND_UI(ID_DRAW_PAGE_BORDER, OnUpdateDrawDrawPageBorder)
	ON_UPDATE_COMMAND_UI(ID_AXIS_AUTOSCALE, OnUpdateAxisAutoscale)
	ON_UPDATE_COMMAND_UI(ID_POPUP_CLEARALLWAVEFORMS, OnUpdatePopupClearallwaveforms)
	ON_UPDATE_COMMAND_UI(ID_POPUP_CHANGEWAVECOLOUR, OnUpdatePopupChangewavecolour)
	ON_UPDATE_COMMAND_UI(ID_VIEW_DECEND, OnUpdateViewDecend)
	ON_COMMAND(ID_FILE_REPORTS_DCOPERATINGPOINT, OnFileReportsDcoperatingpoint)
	ON_COMMAND(ID_VIEW_REPORTS_DCOPERATINGPOINT, OnViewReportsDcoperatingpoint)
	ON_COMMAND(ID_FILE_REPORTS_DCSWEEP, OnFileReportsDcsweep)
	ON_COMMAND(ID_VIEW_REPORTS_DCSWEEP, OnViewReportsDcsweep)
	ON_COMMAND(ID_FILE_REPORTS_CREATENOISE, OnFileReportsNoise)
	ON_COMMAND(ID_VIEW_REPORTS_NOISE, OnViewReportsNoise)
	ON_COMMAND(ID_RUN_ENABLELOOPGAIN, OnRunEnableloopgain)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLELOOPGAIN, OnUpdateRunEnableloopgain)
	ON_COMMAND(ID_FILE_REPORTS_ACSWEEP, OnFileReportsAcsweep)
	ON_COMMAND(ID_VIEW_REPORTS_ACSWEEP, OnViewReportsAcsweep)
	ON_COMMAND(ID_POPUP_CHANGE_BKG_COLOUR, OnPopupChangeGraphBKGColour)
	ON_COMMAND(ID_RUN_TERMINATEXSPICEENGINE, OnRunTerminatexspiceengine)
	ON_COMMAND(ID_GRAPH_PROBEMODE, OnGraphProbeMode)
	ON_UPDATE_COMMAND_UI(ID_GRAPH_PROBEMODE, OnUpdateGraphProbeMode)
	ON_COMMAND(ID_EDIT_FINDONSCHEMATIC, OnEditFindOnSchematic)
	ON_COMMAND(ID_EDIT_UNDELETE, OnEditUndelete)
	ON_UPDATE_COMMAND_UI(ID_EDIT_UNDELETE, OnUpdateEditUndelete)
	ON_UPDATE_COMMAND_UI(ID_POPUP_CHANGE_BKG_COLOUR, OnUpdatePopupChangewavecolour)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
	
//	ON_COMMAND(ID_HELP, OnHelp)

ON_COMMAND(ID_RUN_ENABLEMONTECARLO, &TCSuperSpiceView::OnRunEnableMonteCarlo)
ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEMONTECARLO, &TCSuperSpiceView::OnUpdateRunEnableMonteCarlo)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceView construction/destruction

TCSuperSpiceView::TCSuperSpiceView()
{
	m_pSelection = NULL;
	// TODO: add construction code here

	CSuperSpiceViewData.system_state = E_GRAPHICS_MANAGER_STATE_IDLE; 

	CSuperSpiceViewData.page_id	 = -1;

	CSuperSpiceViewData.PCMSchematicManager	= NULL;

	CSuperSpiceViewData.CMaxSize.cx  = 8181;
	CSuperSpiceViewData.CMaxSize.cy  = 8181;
	CSuperSpiceViewData.CPageSize.cx = 128;
	CSuperSpiceViewData.CPageSize.cy = 128;
	CSuperSpiceViewData.CLineSize.cx = 8;
	CSuperSpiceViewData.CLineSize.cy = 8;
	
	CSuperSpiceViewData.CViewPortOrigin.x = 0;
	CSuperSpiceViewData.CViewPortOrigin.y = 0;

	CSuperSpiceViewData.CScrollBarPosition.x = 0;
	CSuperSpiceViewData.CScrollBarPosition.y = 0;

	CSize CMaxSize(CSuperSpiceViewData.CMaxSize.cx,
					 CSuperSpiceViewData.CMaxSize.cy);
	SetScrollSizes(MM_TEXT, CMaxSize, CSuperSpiceViewData.CPageSize, CSuperSpiceViewData.CLineSize);

	m_current_waveform_type = E_SPICE_RECORD_NULL;
	m_is_dragging = false;
}

TCSuperSpiceView::~TCSuperSpiceView()
{

	
}

BOOL TCSuperSpiceView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceView drawing

void TCSuperSpiceView::OnDraw(CDC* pDC)
{
	TCSuperSpiceDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
	// TODO: also draw all OLE items in the document

	// Draw the selection at an arbitrary position.  This code should be
	//  removed once your real drawing code is implemented.  This position
	//  corresponds exactly to the rectangle returned by TCSuperSpiceContorItem,
	//  to give the effect of in-place editing.

	// TODO: remove this code when final draw code is complete.

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	if(!pDC->IsPrinting())
	{
	if (m_pSelection == NULL)
	{
		POSITION pos = pDoc->GetStartPosition();
		m_pSelection = (TCSuperSpiceContorItem*)pDoc->GetNextClientItem(pos);
	}
	if (m_pSelection != NULL)
		m_pSelection->Draw(pDC, CRect(10, 10, 210, 210));

		PCDoc->OnViewDrawAll(this, CSuperSpiceViewData.PCMSchematicManager);
	}
	else
	{
		PCDoc->Print(this, pDC);
	}
}

void TCSuperSpiceView::OnInitialUpdate()
{
//	CView::OnInitialUpdate();

	// TODO: remove this code when final selection model code is written
	m_pSelection = NULL;    // initialize selection

	SetScrollSizes(MM_TEXT, CSuperSpiceViewData.CMaxSize, CSuperSpiceViewData.CPageSize, CSuperSpiceViewData.CLineSize);

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc->OnViewInitialUpdate(this);	
} 
 
void TCSuperSpiceView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	pSender; lHint;  pHint;

	TCSuperSpiceDoc* PCDoc = GetDocument();

	if(!PCDoc) return;

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSuperSpiceViewData.PCMSchematicManager->UpdateSchematicWaveforms(*PCDoc->CMSuperSpiceDocData.CWaveformDataRuns.CRuns[0]);
}

void TCSuperSpiceView::SetScrollSizesZoomed(float zoom)
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSize CMaxSize(CSuperSpiceViewData.CMaxSize.cx,
					 CSuperSpiceViewData.CMaxSize.cy);

	CMaxSize.cx = (int)(CSuperSpiceViewData.CMaxSize.cx * zoom);
	CMaxSize.cy = (int)(CSuperSpiceViewData.CMaxSize.cy * zoom);

	// MFC asserts for this, presumably due to 16 bit problems
	// need to correct this later
	if(CMaxSize.cx > 32767) CMaxSize.cx = 32767;
	if(CMaxSize.cy > 32767) CMaxSize.cy	= 32767;

	SetScrollSizes(MM_TEXT, CMaxSize, CSuperSpiceViewData.CPageSize, CSuperSpiceViewData.CLineSize);
}

TCSuperSpiceViewData &TCSuperSpiceView::GetData(void)
{
	return CSuperSpiceViewData;
}

CSize &TCSuperSpiceView::GetViewSize(void)
{	
	return CSuperSpiceViewData.CMaxSize;
}
void TCSuperSpiceView::SetViewSize(CSize &CViewSize)
{
	//CSuperSpiceViewData.CMaxSize = CViewSize;
	CViewSize;
}

void TCSuperSpiceView::SetData(TCSuperSpiceViewData &SuperSpiceViewData)
{
	CSuperSpiceViewData = SuperSpiceViewData;
}

void TCSuperSpiceViewData::operator = (TCSuperSpiceViewData &SuperSpiceViewData)
{
	CLastMousePosition	=  SuperSpiceViewData.CLastMousePosition;
	page_id				= SuperSpiceViewData.page_id;
	CPageName			= SuperSpiceViewData.CPageName;
	system_state		= SuperSpiceViewData.system_state;
	PCMSchematicManager = SuperSpiceViewData.PCMSchematicManager;
	CMaxSize			= SuperSpiceViewData.CMaxSize;
	CPageSize			= SuperSpiceViewData.CPageSize;
	CLineSize			= SuperSpiceViewData.CLineSize;
	CViewPortOrigin		= SuperSpiceViewData.CViewPortOrigin;
	CScrollBarPosition  = SuperSpiceViewData.CScrollBarPosition;
}
void TCSuperSpiceViewData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CLastMousePosition;
		CArchiveFile << page_id;
		CArchiveFile << CPageName;
		CArchiveFile.Write(&system_state, sizeof(system_state));
		CArchiveFile << CMaxSize;
		CArchiveFile << CPageSize;
		CArchiveFile << CLineSize;
		CArchiveFile << CViewPortOrigin;
		CArchiveFile << CScrollBarPosition;
	}
	else
	{	
		CArchiveFile >> CLastMousePosition;
		CArchiveFile >> page_id;
		CArchiveFile >> CPageName;
		CArchiveFile.Read(&system_state, sizeof(system_state));
		CArchiveFile >> CMaxSize;
		CArchiveFile >> CPageSize;
		CArchiveFile >> CLineSize;
		CArchiveFile >> CViewPortOrigin;
		CArchiveFile >> CScrollBarPosition;	
	}
}

TCSchematicManager *TCSuperSpiceView::GetSchematicManager(void)
{
	return CSuperSpiceViewData.PCMSchematicManager;
}

void TCSuperSpiceView::SetSchematicManager(TCSchematicManager *PCSchematicManager)
{
	CSuperSpiceViewData.PCMSchematicManager = PCSchematicManager;	
}
/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceView printing

BOOL TCSuperSpiceView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void TCSuperSpiceView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void TCSuperSpiceView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// OLE Client support and commands

BOOL TCSuperSpiceView::IsSelected(const CObject* pDocItem) const
{
	// The implementation below is adequate if your selection consists of
	//  only TCSuperSpiceContorItem objects.  To handle different selection
	//  mechanisms, the implementation here should be replaced.

	// TODO: implement this function that tests for a selected OLE client item

	return pDocItem == m_pSelection;
}
void TCSuperSpiceView::OnUpdateOleInsertNew(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
	pCmdUI->Enable(false);
}
void TCSuperSpiceView::OnInsertObject()
{
	// Invoke the standard Insert Object dialog box to obtain information
	//  for new TCSuperSpiceContorItem object.
	COleInsertDialog dlg;
	if (dlg.DoModal() != IDOK)
		return;

	BeginWaitCursor();

	TCSuperSpiceContorItem* pItem = NULL;
	TRY
	{
		// Create new item connected to this document.
		TCSuperSpiceDoc* pDoc = GetDocument();
		ASSERT_VALID(pDoc);
		pItem = new TCSuperSpiceContorItem(pDoc);
		ASSERT_VALID(pItem);

		// Initialize the item from the dialog data.
		if (!dlg.CreateItem(pItem))
			AfxThrowMemoryException();  // any exception will do
		ASSERT_VALID(pItem);

		// If item created from class list (not from file) then launch
		//  the server to edit the item.
		if (dlg.GetSelectionType() == COleInsertDialog::createNewItem)
			pItem->DoVerb(OLEIVERB_SHOW, this);

		ASSERT_VALID(pItem);

		// As an arbitrary user interface design, this sets the selection
		//  to the last item inserted.

		// TODO: reimplement selection as appropriate for your application

		m_pSelection = pItem;   // set selection to last inserted item
		pDoc->UpdateAllViews(NULL);
	}
	CATCH(CException, e)
	{
		if (pItem != NULL)
		{
			ASSERT_VALID(pItem);
			pItem->Delete();
		}
		AfxMessageBox(IDP_FAILED_TO_CREATE);
	}
	END_CATCH

	EndWaitCursor();
}

// The following command handler provides the standard keyboard
//  user interface to cancel an in-place editing session.  Here,
//  the container (not the server) causes the deactivation.
void TCSuperSpiceView::OnCancelEditCntr()
{
	// Close any in-place active item on this view.
	COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);
	if (pActiveItem != NULL)
	{
		pActiveItem->Close();
	}
	ASSERT(GetDocument()->GetInPlaceActiveItem(this) == NULL);

	OnCancelCommand();
}

// Special handling of OnSetFocus and OnSize are required for a container
//  when an object is being edited in-place.
void TCSuperSpiceView::OnSetFocus(CWnd* pOldWnd)
{
	PCSuperSpiceDocLastFocused = (TCSuperSpiceDoc *)GetDocument();
	PCSuperSpiceViewLastFocused = this;

	COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);
	if (pActiveItem != NULL &&
		pActiveItem->GetItemState() == COleClientItem::activeUIState)
	{
		// need to set focus to this item if it is in the same view
		CWnd* pWnd = pActiveItem->GetInPlaceWindow();
		if (pWnd != NULL)
		{
			pWnd->SetFocus();   // don't call the base class
			return;
		}
	}

	CView::OnSetFocus(pOldWnd);
}

void TCSuperSpiceView::OnSize(UINT nType, int cx, int cy)
{
	CView::OnSize(nType, cx, cy);
	COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);
	if (pActiveItem != NULL)
		pActiveItem->SetItemRects();
}

/////////////////////////////////////////////////////////////////////////////
// OLE Server support

// The following command handler provides the standard keyboard
//  user interface to cancel an in-place editing session.  Here,
//  the server (not the container) causes the deactivation.
void TCSuperSpiceView::OnCancelEditSrvr()
{
	GetDocument()->OnDeactivateUI(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceView diagnostics

#ifdef _DEBUG
void TCSuperSpiceView::AssertValid() const
{
	CView::AssertValid();
}

void TCSuperSpiceView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

TCSuperSpiceDoc* TCSuperSpiceView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(TCSuperSpiceDoc)));
	return (TCSuperSpiceDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceView message handlers

 

void TCSuperSpiceView::OnContextMenu(CWnd*, CPoint point)
{
	// CG: This function was added by the Pop-up Menu Graphic

	CMenu menu;
	VERIFY(menu.LoadMenu(CG_IDR_POPUP_TCSUPER_SPICE_VIEW));

	CMenu* pPopup = menu.GetSubMenu(0);
	ASSERT(pPopup != NULL);

	CWnd* pWndPopupOwner = this;
	while (pWndPopupOwner->GetStyle() & WS_CHILD)
		pWndPopupOwner = pWndPopupOwner->GetParent();

	pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point.x, point.y,
		pWndPopupOwner);
}

BOOL TCSuperSpiceView::PreTranslateMessage(MSG* pMsg)
{
	// CG: This block was added by the Pop-up Menu Graphic
	{
		// Shift+F10: show pop-up menu.
		if ((((pMsg->message == WM_KEYDOWN || pMsg->message == WM_SYSKEYDOWN) && // If we hit a key and
			(pMsg->wParam == VK_F10) && (GetKeyState(VK_SHIFT) & ~1)) != 0) ||	// it's Shift+F10 OR
			(pMsg->message == WM_CONTEXTMENU))									// Natural keyboard key
		{
			CRect rect;
			GetClientRect(rect);
			ClientToScreen(rect);

			CPoint point = rect.TopLeft();
			point.Offset(5, 5);
			OnContextMenu(NULL, point);

			return TRUE;
		}
	}

	return CView::PreTranslateMessage(pMsg);
}


int	TCSuperSpiceView::GetPageId(void)
{
	return CSuperSpiceViewData.page_id;
}

void TCSuperSpiceView::SetPageId(int page_id)
{
	CSuperSpiceViewData.page_id = page_id;
}

void TCSuperSpiceView::SetState(TE_GRAPHICS_MANAGER_SYSTEM_STATE sys_state)
{
	CSuperSpiceViewData.system_state = sys_state;
}


TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSuperSpiceView::GetState(void)
{
	return CSuperSpiceViewData.system_state;
} 

void TCSuperSpiceView::GetComponent(int graphic_id, short version)
{
	if(CSuperSpiceViewData.PCMSchematicManager)

	OnCancelCommand();

	if(graphic_id)
		CGlobalStatusMessage = E_STATUS_MSG_PLACING_COMPONENT;
	else CGlobalStatusMessage = E_STATUS_MSG_GETING_LIB_COMPONENT;

	switch(CSuperSpiceViewData.system_state)
	{
		case E_GRAPHICS_MANAGER_STATE_IDLE:					IdleGetGraphic(graphic_id, version);break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED:	GraphicsSelectedGetGraphic(graphic_id, version); break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING:		GraphicsMovingGetGraphic(graphic_id, version);break;	
		case E_GRAPHICS_MANAGER_STATE_SELECT_REGION:		SelectRegionGetGraphic(graphic_id, version);break;		 
		case E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC:			GotGraphicGetGraphic(graphic_id, version);break;
		case E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD:		GotClipboardGetGraphic(graphic_id, version);break;
		case E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE:			DrawingWireGetGraphic(graphic_id, version); break;
		case E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE: WaitingToDrawWireGetGraphic(graphic_id, version); break;
		case E_GRAPHICS_MANAGER_STATE_WAVEFORM_ON_CLICK:
			{
				CSuperSpiceViewData.system_state = E_GRAPHICS_MANAGER_STATE_IDLE;

				IdleGetGraphic(graphic_id, version);break;
			}

		default: break;
	}
}

void TCSuperSpiceView::OnLButtonDown(UINT nFlags, CPoint CMousePosition) 
{
	// TODO: Add your message handler code here and/or call default

	short key_state = GetKeyState(VK_MENU);// Gets the fucking alt key status, fucking Microshit!

	if(key_state < 0) //High order bit is set
	{
		nFlags |= MK_ALT;// Cos fucking M.S. dont pass MK_ALT when that key gets pressed!

		nFlags |= MK_EXTRA_ALT_1;// detect if a real alt detected
	}

	//force waveform on click code to be executed
	if(GCSuperSpiceGlobalData.CDrawData.probe_mode) nFlags |= MK_ALT;

	CSuperSpiceViewData.CLastLBDownMousePosition = CMousePosition;

	if(CSuperSpiceViewData.PCMSchematicManager)
	{
		TCSuperSpiceDoc *PCDoc = GetDocument();

		if(!PCDoc) return;

		PCDoc->OnViewSetZoomCenter(this, CMousePosition);
	}

	if(CSuperSpiceViewData.PCMSchematicManager)

	switch(CSuperSpiceViewData.system_state)
	{
		case E_GRAPHICS_MANAGER_STATE_IDLE:					IdleLBDown(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED:	GraphicsSelectedLBDown(nFlags, CMousePosition); break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING:		GraphicsMovingLBDown(nFlags, CMousePosition);break;	
		case E_GRAPHICS_MANAGER_STATE_SELECT_REGION:		SelectRegionLBDown(nFlags, CMousePosition);break;		 
		case E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC:			GotGraphicLBDown(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD:		GotClipboardLBDown(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE:			DrawingWireLBDown(nFlags, CMousePosition); break;
		case E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE:	WaitingToDrawWireLBDown(nFlags, CMousePosition); break;
		case E_GRAPHICS_MANAGER_STATE_SIZING_WAVEFORM_WINDOW: SizingWaveformWindowLBDown(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_WAVEFORM_ON_CLICK: WaveformOnClickLBDown(nFlags, CMousePosition);break;
//		case 
			
		default: break;
	}

	
	CView::OnLButtonDown(nFlags, CMousePosition);
}


void TCSuperSpiceView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	if(m_is_dragging) // force up to be the same as down idf draged
	{
		OnLButtonDown(nFlags, point);

		m_is_dragging = false;

		return;
	}

	short key_state = GetKeyState(VK_MENU);// Gets the fucking alt key status, fucking Microshit!

	if(key_state < 0)//High order bit is set
	{
		nFlags |= MK_ALT;// Cos fucking M.S. dont pass MK_ALT when that key gets pressed!
	}

	if(CSuperSpiceViewData.PCMSchematicManager)	
	switch(CSuperSpiceViewData.system_state)
	{
		case E_GRAPHICS_MANAGER_STATE_IDLE:					IdleLBUp(nFlags, point);break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED:	GraphicsSelectedLBUp(nFlags, point);break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING:		GraphicsMovingLBUp(nFlags, point); break;	
		case E_GRAPHICS_MANAGER_STATE_SELECT_REGION:		SelectRegionLBUp(nFlags, point);break;
		case E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC:			GotGraphicLBUp(nFlags, point);break;
		case E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD:		GotClipboardLBUp(nFlags, point);break;
		case E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE:			break;//DrawingWireLBUp(nFlags, point); break;
		case E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE: break;//WaitingToDrawWireLBUp(nFlags, point); break;
		case E_GRAPHICS_MANAGER_STATE_SIZING_WAVEFORM_WINDOW: SizingWaveformWindowLBUp(nFlags, point);break;

		default: break;
	}

	CView::OnLButtonUp(nFlags, point);
}

void TCSuperSpiceView::OnCancelCommand() 
{
	GCWorkspaceTree.ClearDragging();

	m_is_dragging = false;

	CGlobalStatusMessage = E_STATUS_MSG_IDLE;

	m_hcursor = AfxGetApp()->LoadStandardCursor(IDC_ARROW);
	SetCursor(m_hcursor);

	if(CSuperSpiceViewData.PCMSchematicManager)	
	switch(CSuperSpiceViewData.system_state)
	{
		case E_GRAPHICS_MANAGER_STATE_IDLE:					IdleOnCancel();break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED:	GraphicsSelectedOnCancel();break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING:		GraphicsMovingOnCancel(); break;	
		case E_GRAPHICS_MANAGER_STATE_SELECT_REGION:		SelectRegionOnCancel();break;
		case E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC:			GotGraphicOnCancel();break;
		case E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD:		GotClipboardOnCancel();break;
		case E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE:			DrawingWireOnCancel();
		case E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE: WaitingToDrawWireOnCancel(); break;

		case E_GRAPHICS_MANAGER_STATE_WAVEFORM_ON_CLICK:
			{
				IdleOnCancel();

				CSuperSpiceViewData.system_state = E_GRAPHICS_MANAGER_STATE_WAVEFORM_ON_CLICK;
			
				break;
			}

		default: IdleOnCancel();break;
	}
}

void TCSuperSpiceView::OnMouseMove(UINT nFlags, CPoint CMousePosition) 
{
	//Fucking MS shit
	if(CSuperSpiceViewData.CLastMousePosition == CMousePosition) return;
	
	CSuperSpiceViewData.CLastMousePosition = CMousePosition;
	GlobalMousePosition = CMousePosition; 

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	if(GCWorkspaceTree.IsDragging()) 
	{
		GCWorkspaceTree.PlaceDragedSymbol();
			
		GCWorkspaceTree.ClearDragging();
		
		m_is_dragging = true;

		return;
	}

	short key_state = GetKeyState(VK_MENU);// Gets the fucking alt key status, fucking Microshit!

	if(key_state < 0)//High order bit is set
	{
		nFlags |= MK_ALT;// Cos fucking M.S. dont pass MK_ALT when that key gets pressed!
	}

	switch(CSuperSpiceViewData.system_state)
	{
		case E_GRAPHICS_MANAGER_STATE_IDLE:					IdleMouseMoved(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED:	GraphicsSelectedMouseMoved(nFlags, CMousePosition);break ;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING:		GraphicsMovingMouseMoved(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_SELECT_REGION:		SelectRegionMouseMoved(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC:			GotGraphicMouseMoved(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD:		GotClipboardMouseMoved(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE:			DrawingWireMouseMoved(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE: WaitingToDrawWireMouseMoved(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_SIZING_WAVEFORM_WINDOW: SizingWaveformWindowMouseMoved(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_WAVEFORM_ON_CLICK:	
			{
				IdleMouseMoved(nFlags, CMousePosition);

				CSuperSpiceViewData.system_state = E_GRAPHICS_MANAGER_STATE_WAVEFORM_ON_CLICK;// overite the idle return value
			
				break;
			}

		default: break;
	}

	CView::OnMouseMove(nFlags, CMousePosition);
}
/////////////////////////////////////
void TCSuperSpiceView::SizingWaveformWindowMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewSizingWaveformWindowMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSuperSpiceView::SizingWaveformWindowLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewSizingWaveformWindowLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSuperSpiceView::WaveformOnClickLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewWaveformOnClickLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSuperSpiceView::SizingWaveformWindowLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewSizingWaveformWindowLBUp(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);

	m_hcursor = AfxGetApp()->LoadStandardCursor(IDC_ARROW);

	SetCursor(m_hcursor);
}
//////////////
void TCSuperSpiceView::OnDrawWire() 
{
	if(CSuperSpiceViewData.PCMSchematicManager)

	CGlobalStatusMessage = E_STATUS_MSG_WAITING_TO_DRAW_WIRE;

	m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_DRAW_LINE);
	SetCursor(m_hcursor);

	switch(CSuperSpiceViewData.system_state)
	{
		case E_GRAPHICS_MANAGER_STATE_IDLE:					IdleDrawWire();break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED:	GraphicsSelectedDrawWire(); break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING:		GraphicsMovingDrawWire();break;	
		case E_GRAPHICS_MANAGER_STATE_SELECT_REGION:		SelectRegionDrawWire();break;		 
		case E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC:			GotClipboardDrawWire();break;
		case E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD:		DrawingWireDrawWire();break;
		case E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE: WaitingToDrawWireDrawWire(); break;
	
		default: break;
	}
}
void TCSuperSpiceView::OnLButtonDblClk(UINT nFlags, CPoint CMousePosition) 
{
	// TODO: Add your message handler code here and/or call default
	
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	short key_state = GetKeyState(VK_MENU);// Gets the fucking alt key status, fucking Microshit!

	if(key_state < 0)//High order bit is set
	{
		nFlags |= MK_ALT;// Cos fucking M.S. dont pass MK_ALT when that key gets pressed!
	}

	CScrollView::OnLButtonDblClk(nFlags, CMousePosition);

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	if(CSuperSpiceViewData.system_state == E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE)
	{
		CSuperSpiceViewData.system_state = PCDoc->OnViewDrawingWireLBDblClk(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
	
		return;
	}
	
	PCDoc->OnLButtonDblClk(this, CMousePosition, nFlags);
}
void TCSuperSpiceView::IdleOnCancel(void)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewIdleOnCancel(this);
}

void TCSuperSpiceView::GraphicsSelectedOnCancel(void)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsSelectedOnCancel(this);
}

void TCSuperSpiceView::GraphicsMovingOnCancel(void)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsMovingOnCancel(this);	
}

void TCSuperSpiceView::SelectRegionOnCancel(void)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewSelectRegionOnCancel(this);
}

void TCSuperSpiceView::GotGraphicOnCancel(void)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotGraphicOnCancel(this);
}

void TCSuperSpiceView::GotClipboardOnCancel(void)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotClipboardOnCancel(this);
}

void TCSuperSpiceView::DrawingWireOnCancel(void)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewDrawingWireOnCancel(this);
}
void TCSuperSpiceView::WaitingToDrawWireOnCancel()
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewWaitingToDrawWireOnCancel(this);
}

void TCSuperSpiceView::OnRButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

// Right button is for Menu support only as is strongly reqested for Win 95 Logo 
	
	CView::OnRButtonUp(nFlags, point);
}

void TCSuperSpiceView::IdleGetGraphic(int graphic_id, short version)
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewIdleStateGetGraphic(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition, graphic_id, version);
}

void TCSuperSpiceView::GraphicsSelectedGetGraphic(int graphic_id, short version)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsSelectedStateGetGraphic(this, CSuperSpiceViewData.page_id,CSuperSpiceViewData.CLastMousePosition, graphic_id, version);
}

void TCSuperSpiceView::GraphicsMovingGetGraphic(int graphic_id, short version)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsMovingStateGetGraphic(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition, graphic_id, version);
}
	
void TCSuperSpiceView::SelectRegionGetGraphic(int graphic_id, short version)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewSelectRegionStateGetGraphic(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition, graphic_id, version);
}	
	 
void TCSuperSpiceView::GotGraphicGetGraphic(int graphic_id, short version)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotGraphicStateGetGraphic(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition, graphic_id, version);
}
 
void TCSuperSpiceView::DrawingWireGetGraphic(int graphic_id, short version)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewDrawingWireGetGraphic(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition, graphic_id, version);
}
void TCSuperSpiceView::WaitingToDrawWireGetGraphic(int graphic_id, short version)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewWaitingToDrawWireGetGraphic(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition, graphic_id, version);
}
void TCSuperSpiceView::GotClipboardGetGraphic(int graphic_id, short version)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotClipboardGetGraphic(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition, graphic_id, version);
}

void TCSuperSpiceView::IdleLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewIdleStateLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);	
}

void TCSuperSpiceView::GraphicsSelectedLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsSelectedStateLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSuperSpiceView::GraphicsMovingLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsMovingStateLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSuperSpiceView::SelectRegionLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewSelectRegionStateLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}


void TCSuperSpiceView::GotGraphicLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotGraphicStateLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);	
}

void TCSuperSpiceView::GotClipboardLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotClipboardLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);	

/*	if(!CSuperSpiceViewData.PCMSchematicManager->m_auto_keep_pasting)
	{
		CSuperSpiceViewData.PCMSchematicManager->m_auto_keep_pasting = true; //auto restart, bit messy

		GotClipboardOnCancel();
	}*/
}

void TCSuperSpiceView::DrawingWireLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewDrawingWireLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);	
}
void TCSuperSpiceView::WaitingToDrawWireLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewWaitingToDrawWireLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);	
}
void TCSuperSpiceView::IdleLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewIdleStateLBUp(this,  CSuperSpiceViewData.page_id, nFlags,CMousePosition);
}

void TCSuperSpiceView::GraphicsSelectedLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsSelectedStateLBUp(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSuperSpiceView::GraphicsMovingLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsMovingStateLBUp(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSuperSpiceView::SelectRegionLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewSelectRegionStateLBUp(this, CSuperSpiceViewData.page_id, nFlags, CMousePosition);

}

void TCSuperSpiceView::GotGraphicLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotGraphicStateLBUp(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSuperSpiceView::DrawingWireLBUp(UINT nFlags, CPoint CMousePosition)
{
	// not called
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewDrawingWireLBUp(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSuperSpiceView::WaitingToDrawWireLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewWaitingToDrawWireLBUp(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);

}

void TCSuperSpiceView::GotClipboardLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotClipboardLBUp(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);

}
void TCSuperSpiceView::IdleMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewIdleStateMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSuperSpiceView::GraphicsSelectedMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsSelectedStateMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSuperSpiceView::GraphicsMovingMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();
	
	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsMovingStateMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSuperSpiceView::SelectRegionMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewSelectRegionStateMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSuperSpiceView::GotGraphicMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotGraphicStateMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSuperSpiceView::GotClipboardMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotClipboardMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSuperSpiceView::DrawingWireMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewDrawingWireMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSuperSpiceView::WaitingToDrawWireMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewWaitingToDrawWireMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSuperSpiceView::OnWindowNew() 
{
	// TODO: Add your command handler code here

	TCSuperSpiceDoc *PCDoc = GetDocument();
	
	PCDoc->OnViewNewView(this);	
}

void TCSuperSpiceView::OnKillFocus(CWnd* pNewWnd) 
{
	PCSuperSpiceDocLastFocused = GetDocument();
	PCSuperSpiceViewLastFocused = this;

	CView::OnKillFocus(pNewWnd);
}

void TCSuperSpiceView::OnPagesOpenpage() 
{
	// TODO: Add your command handler code here
	
	TCSuperSpiceDoc *PCDoc = GetDocument();
	
	PCDoc->OnViewOpenPage(this, CSuperSpiceViewData.PCMSchematicManager);	
}

void TCSuperSpiceView::OnPagesDeletePage() 
{
	// TODO: Add your command handler code here
	TCSuperSpiceDoc *PCDoc = GetDocument();

	CString CMessage, CMessageLine, CCaption;

	CMessageLine.LoadString(IDS_WARNING_DELETE_PAGE);
	CCaption.LoadString(IDS_WARNING_DELETE_CAPTION);

	CMessage.Format("%s %d", CMessageLine, CSuperSpiceViewData.page_id);

	if(MessageBox(CMessage, CCaption, MB_ICONQUESTION | MB_OKCANCEL) != IDOK) return;
	
	PCDoc->OnViewDeletePage(this, CSuperSpiceViewData.PCMSchematicManager);		
}

void TCSuperSpiceView::OnPagesNewPage() 
{
	// TODO: Add your command handler code here
	
		// TODO: Add your command handler code here

	TCSuperSpiceDoc *PCDoc = GetDocument();
	
	PCDoc->OnViewNewPage(this);		
}


void TCSuperSpiceView::OnPagesCopyPage() 
{
	// TODO: Add your command handler code here

	TCSuperSpiceDoc *PCDoc = GetDocument();
	
	PCDoc->OnViewCopyPage(this);		
	
}
void TCSuperSpiceView::OnDestroy() 
{

	TCSuperSpiceDoc *PCDoc = GetDocument();
	
	PCDoc->OnViewDestroyWindow(this, CSuperSpiceViewData.PCMSchematicManager);

	CView::OnDestroy();
	
	// TODO: Add your message handler code here
	
}

void TCSuperSpiceView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default
	
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CScrollView::OnHScroll(nSBCode, nPos, pScrollBar);
	
	CDC *PCViewDC = GetDC();
	
	OnPrepareDC(PCViewDC, NULL);

	CPoint CViewPortOrigin = PCViewDC->GetViewportOrg();

	GlobalMouseOffset = CViewPortOrigin;

	ReleaseDC(PCViewDC);

	CSuperSpiceViewData.PCMSchematicManager->EraseComponentOutline();

	CSuperSpiceViewData.PCMSchematicManager->SetViewPortOrigin(CViewPortOrigin);	

	CSuperSpiceViewData.PCMSchematicManager->SetScrollBarPosition(GetScrollBarPosition());

//	PCViewDC = GetDC();

//	CSuperSpiceViewData.PCMSchematicManager->DrawPageOutline(PCViewDC, true);

//	ReleaseDC(PCViewDC);
}

void TCSuperSpiceView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CScrollView::OnVScroll(nSBCode, nPos, pScrollBar);

	CDC *PCViewDC = GetDC();
	
	OnPrepareDC(PCViewDC, NULL);

	CPoint CViewPortOrigin = PCViewDC->GetViewportOrg();

	GlobalMouseOffset = CViewPortOrigin;

	ReleaseDC(PCViewDC);

	CSuperSpiceViewData.PCMSchematicManager->EraseComponentOutline();

	CSuperSpiceViewData.PCMSchematicManager->SetViewPortOrigin(CViewPortOrigin);

	CSuperSpiceViewData.PCMSchematicManager->SetScrollBarPosition(GetScrollBarPosition());

}

void TCSuperSpiceView::SetScrollBarPosition(CPoint CScrollBarPosition)
{
	if(CScrollBarPosition.x < 0) CScrollBarPosition.x = 0;
	if(CScrollBarPosition.x >= CSuperSpiceViewData.CMaxSize.cx -1)
		CScrollBarPosition.x = CSuperSpiceViewData.CMaxSize.cx;


	CScrollBarPosition.x = CScrollBarPosition.x / CSuperSpiceViewData.CLineSize.cx;
	CScrollBarPosition.x = CScrollBarPosition.x * CSuperSpiceViewData.CLineSize.cx;

	CScrollBarPosition.y = CScrollBarPosition.y / CSuperSpiceViewData.CLineSize.cy;
	CScrollBarPosition.y = CScrollBarPosition.y * CSuperSpiceViewData.CLineSize.cy;


	if(CScrollBarPosition.y < 0) CScrollBarPosition.y = 0;
	if(CScrollBarPosition.y >= CSuperSpiceViewData.CMaxSize.cy - 1)
		CScrollBarPosition.y = CSuperSpiceViewData.CMaxSize.cy;

	SetScrollPos(SB_VERT, CScrollBarPosition.y);
	SetScrollPos(SB_HORZ, CScrollBarPosition.x);
	OnHScroll(SB_THUMBTRACK, CScrollBarPosition.x, NULL);
	OnVScroll(SB_THUMBTRACK,CScrollBarPosition.y, NULL); 
}

CPoint TCSuperSpiceView::GetScrollBarPosition(void)
{
	CPoint CScrollBarPosition;

	CScrollBarPosition.y = GetScrollPos(SB_VERT);
	CScrollBarPosition.x = GetScrollPos(SB_HORZ);

	return CScrollBarPosition;
}

CPoint	TCSuperSpiceView::GetViewPortOrigin(void)
{
	CDC *PCViewDC = GetDC();
	
	OnPrepareDC(PCViewDC, NULL);

	CSuperSpiceViewData.CViewPortOrigin = PCViewDC->GetViewportOrg();

	ReleaseDC(PCViewDC);

	return CSuperSpiceViewData.CViewPortOrigin;
}


void TCSuperSpiceView::OnEditCopy() 
{
	// TODO: Add your command handler code here

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;
	
	CSuperSpiceViewData.system_state = PCDoc->OnViewEditCopy(this);
}

void TCSuperSpiceView::OnEditCopyToWindowsClipboard() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;
	
	CSuperSpiceViewData.system_state = PCDoc->OnViewEditToWindowsClipboard(this);	
}

void TCSuperSpiceView::OnEditCut() 
{
	// TODO: Add your command handler code here
	
	
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;
	
	CSuperSpiceViewData.system_state = PCDoc->OnViewEditCut(this);
}

void TCSuperSpiceView::OnEditDelete() 
{
	// TODO: Add your command handler code here
	
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;
	
	CSuperSpiceViewData.system_state = PCDoc->OnViewEditDelete(this);
}


void TCSuperSpiceView::OnEditSelectAll() 
{
	// TODO: Add your command handler code here

	
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;
	
	CSuperSpiceViewData.system_state = PCDoc->OnViewEditSelectAll(this);
}

void TCSuperSpiceView::OnEditPaste1() 
{
	// TODO: Add your command handler code here

		
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewEditPaste(this, CSuperSpiceViewData.CLastMousePosition);
	
}

void TCSuperSpiceView::OnEditPaste() 
{
	OnEditPaste1();	
}


void TCSuperSpiceView::OnEditCopyWithPaste() 
{
	// TODO: Add your command handler code here
	
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;
	
	CSuperSpiceViewData.system_state = PCDoc->OnViewEditCopy(this);

	CSuperSpiceViewData.system_state = PCDoc->OnViewEditPaste(this, CSuperSpiceViewData.CLastMousePosition);
}

void TCSuperSpiceView::OnTestGraphic() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	PCDoc->DebugTest();
}

void TCSuperSpiceView::OnSpiceViewProperties() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc->OnViewProperties(this, CSuperSpiceViewData.PCMSchematicManager);	
}

void TCSuperSpiceView::OnViewOutputGraph() 
{
	
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	PCDoc->OnViewDisplayOutputGraph(this);
}

void TCSuperSpiceView::OnViewOutputText() 
{

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	PCDoc->OnViewDisplayOutputText(this);
}

void TCSuperSpiceView::OnViewIncludedModelsFile() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc->OnViewDisplayModelsText(this);	
}

void TCSuperSpiceView::OnViewInputSpiceText() 
{	
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc->OnViewDisplayInputText(this);
}

void TCSuperSpiceView::OnViewIncludeFile() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc->OnViewDisplayIncludeText(this);
}

void TCSuperSpiceView::OnViewDesignNotes() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc->OnViewDisplayDesignNotes(this);
}

void TCSuperSpiceView::OnViewSymbolEditor() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc->OnViewDisplaySymbolEditor(this);	
}

void TCSuperSpiceView::OnViewSpiceEngineErrorlog() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc->GetTopLevelDoc()->OnViewDisplaySpiceErrorLog(this);	
}

void TCSuperSpiceView::IdleDrawWire()
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewIdleDrawWire(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition);
}

void TCSuperSpiceView::GraphicsSelectedDrawWire()
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsSelectedDrawWire(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition);
}

void TCSuperSpiceView::GraphicsMovingDrawWire()
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsMovingDrawWire(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition);
}
	
void TCSuperSpiceView::SelectRegionDrawWire()	
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewSelectRegionDrawWire(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition);
}
	 
void TCSuperSpiceView::GotGraphicDrawWire()
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotGraphicDrawWire(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition);
}

void TCSuperSpiceView::GotClipboardDrawWire()
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotClipboardDrawWire(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition);
}

void TCSuperSpiceView::DrawingWireDrawWire()
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewDrawingWireDrawWire(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition);
}

void TCSuperSpiceView::WaitingToDrawWireDrawWire()
{
	return;
}

void TCSuperSpiceView::OnDrawBus() 
{
	// TODO: Add your command handler code here
	
}

void TCSuperSpiceView::OnDrawingZoomIn() 
{
	//SetZoomLevel(1.0);

	//UpdateViewport(NULL);

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc->OnViewZoomIn(this);

	float zoom = CSuperSpiceViewData.PCMSchematicManager->GetZoom();

	CSize CMaxSize(CSuperSpiceViewData.CMaxSize.cx,
					 CSuperSpiceViewData.CMaxSize.cy);

	CMaxSize.cx = (int)(CSuperSpiceViewData.CMaxSize.cx * zoom);
	CMaxSize.cy = (int)(CSuperSpiceViewData.CMaxSize.cy * zoom);

	// MFC asserts for this, presumably due to 16 bit problems
	// need to correct this later
	if(CMaxSize.cx > 32767) CMaxSize.cx = 32767;
	if(CMaxSize.cy> 32767) CMaxSize.cy	= 32767;

	SetScrollSizes(MM_TEXT, CMaxSize, CSuperSpiceViewData.CPageSize, CSuperSpiceViewData.CLineSize);
}

void TCSuperSpiceView::OnUpdateDrawingZoomIn(CCmdUI* pCmdUI) 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	if(PCDoc->OnViewCheckZoomIn(this))
	{
		pCmdUI->Enable();
	}
	else
	{
		pCmdUI->Enable(false);
	}
}

void TCSuperSpiceView::OnDrawingZoomOut() 
{
//	SetZoomLevel(1.5);
//	UpdateViewport(NULL);


	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSize CPageSize(CSuperSpiceViewData.CMaxSize.cx,
					 CSuperSpiceViewData.CMaxSize.cy);

	PCDoc->OnViewZoomOut(this);
	
	float zoom = CSuperSpiceViewData.PCMSchematicManager->GetZoom();

	CPageSize.cx = (int)(CSuperSpiceViewData.CMaxSize.cx * zoom);
	CPageSize.cy = (int)(CSuperSpiceViewData.CMaxSize.cy * zoom);

	if(CPageSize.cx > 32767) CPageSize.cx = 32767;
	if(CPageSize.cy> 32767) CPageSize.cy	= 32767;

	SetScrollSizes(MM_TEXT, CPageSize, CSuperSpiceViewData.CPageSize, CSuperSpiceViewData.CLineSize);
}

void TCSuperSpiceView::OnUpdateDrawingZoomOut(CCmdUI* pCmdUI) 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	if(PCDoc->OnViewCheckZoomOut(this))
	{
		pCmdUI->Enable();
	}
	else
	{
		pCmdUI->Enable(false);
	}
}

void TCSuperSpiceView::OnDrawingZoomCenter() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc->OnViewZoomCenter(this, GlobalMousePosition);
}



void TCSuperSpiceView::OnOptionsSchematic() 
{
	OnSpiceViewProperties();	
}

void TCSuperSpiceView::OnDrawingRotate() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;
	
	PCDoc->OnViewRotate(this);
}

void TCSuperSpiceView::OnDrawingMirror() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;
	
	PCDoc->OnViewMirror(this);
}

void TCSuperSpiceView::OnDrawingFlip() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;
	
	PCDoc->OnViewFlip(this);
	
}
void TCSuperSpiceView::OnAddUserText() 
{
	TCAddText1 CDlgText;
	
	CDlgText.CMEditAddText = GCSuperSpiceDataBase.CMDefaults[E_LABEL_COMPONENT].CLabel;
	
	if(CDlgText.DoModal() == IDCANCEL) return;

	CString CText = CDlgText.CMEditAddText;

	CString CTemp = CText;

	CTemp.TrimLeft();

	if(CTemp == "") return;
	
	TCSchematicObjectData CSchematicObjectDataBase;

	GCSuperSpiceDataBase.CMDefaults[E_LABEL_COMPONENT].CLabel =  CText;

	GetComponent(E_LABEL_COMPONENT, -1);

	CGlobalStatusMessage = E_STATUS_MSG_PLACING_TEXT;
}

void TCSuperSpiceView::OnGraphicsPlaceNewGraph() 
{
	GetComponent(E_WAVEFORM_COMPONENT, -1);		
}

void TCSuperSpiceView::OnComponentsOpenComponentLibary() 
{
	GetComponent(E_SUBCIRCUIT_COMPONENT);	
}

void TCSuperSpiceView::OnComponentsModelLibary() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;
	
	PCDoc->DisplayModelLibary(this);
}

void TCSuperSpiceView::OnGetNpn() 
{
	GetComponent(E_NPN_TRANSISTER_COMPONENT);
}

void TCSuperSpiceView::OnComponentsLdo() 
{
	GetComponent(E_RESERVED_GENERIC_LDO);	
}

void TCSuperSpiceView::OnGetPnp() 
{	
	GetComponent(E_PNP_TRANSISTER_COMPONENT);
}

void TCSuperSpiceView::OnComponentsMorecomponentsTriodeValveTube() 
{
	GetComponent(E_TRIODE_VALVE);
}

void TCSuperSpiceView::OnComponentsMorecomponentsPentodeValveTube() 
{
	GetComponent(E_PENTODE_VALVE);
}

void TCSuperSpiceView::OnPopupComponentsMorecomponentsTetrodeValveTube() 
{
	GetComponent(E_TETRODE_VALVE);	
}

void TCSuperSpiceView::OnComponentsSolderBlob() 
{
	GetComponent(E_CONNECTION_DOT);
}

void TCSuperSpiceView::OnUpdateComponentsSolderblob(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(false);// temperory untill implemented

//	pCmdUI->ContinueRouting();	
} 

void TCSuperSpiceView::OnGetCapacitor() 
{
	GetComponent(E_CAPACITOR_COMPONENT);
}

void TCSuperSpiceView::OnGetIcCapacitor() 
{
	GetComponent(E_IC_CAPACITOR_COMPONENT);	
}

void TCSuperSpiceView::OnGetIcResistor() 
{
	GetComponent(E_IC_RESISTOR_COMPONENT);	
}

void TCSuperSpiceView::OnGetDiode() 
{
	GetComponent(E_DIODE_COMPONENT);	
}

void TCSuperSpiceView::OnGetInductor() 
{
	GetComponent(E_INDUCTOR_COMPONENT);	
}
void TCSuperSpiceView::OnGetOpAmp() 
{
	GetComponent(E_5_PIN_OP_AMP_COMPONENT);	
}
void TCSuperSpiceView::OnGetNmos() 
{
	GetComponent(E_NMOS_TRANSISTER_COMPONENT);
//	GetComponent(E_NMOS_4TERM_TRANSISTER_COMPONENT);// 3 pin needs virtual connection to substrate
}

void TCSuperSpiceView::OnGetPmos() 
{
	GetComponent(E_PMOS_TRANSISTER_COMPONENT);// 3 pin needs virtual connection to substrate
}

void TCSuperSpiceView::OnGetResistor() 
{
	GetComponent(E_RESISTOR_COMPONENT);
}


void TCSuperSpiceView::OnComponentsVariableResistor() 
{
	GetComponent(E_VARIABLE_RESISTOR);
}

void TCSuperSpiceView::OnComponentsNJFet() 
{
	GetComponent(E_NJFET_TRANSISTER_COMPONENT);
}

void TCSuperSpiceView::OnComponentsPJFet() 
{
	GetComponent(E_PJFET_TRANSISTER_COMPONENT);	
}
void TCSuperSpiceView::OnGetVoltageSource() 
{
	GetComponent(E_DC_VOLTAGE_SOURCE, E_DC_VOLTAGE_SOURCE);	
}

void TCSuperSpiceView::OnGetCurrentSource() 
{
	GetComponent(E_DC_CURRENT_SOURCE, E_DC_CURRENT_SOURCE);	
}
void TCSuperSpiceView::OnComponentsDrawZener() 
{
	GetComponent(E_ZENER_COMPONENT);		
}

void TCSuperSpiceView::OnComponentsDrawVCVS() 
{
	GetComponent(E_VCVSRC_COMPONENT);
}

void TCSuperSpiceView::OnComponentsVCIS() 
{
	GetComponent(E_VCISRC_COMPONENT);
}

void TCSuperSpiceView::OnComponentsGround() 
{
	GetComponent(E_GROUND);	
}

void TCSuperSpiceView::OnConnectionPointInput() 
{
	GetComponent(E_PAGE_CONNECTER_INPUT);	
}
void TCSuperSpiceView::OnComponentsSubcircuitConnector() 
{
	GetComponent(E_SUBCIRCUIT_PIN_CONNECTER);
}
void TCSuperSpiceView::OnConnectionPointOutput() 
{
	GetComponent(E_PAGE_CONNECTER_OUTPUT);	
}

void TCSuperSpiceView::OnConnectionPointBidirectional() 
{
	GetComponent(E_PAGE_CONNECTER_BIDIRECTIONAL);	
}

void TCSuperSpiceView::OnComponentsMorecomponentsDrawShottky() 
{
	GetComponent(E_SHOTTKY_COMPONENT);
}

void TCSuperSpiceView::OnComponentsMorecomponentsDrawThyresistor() 
{
	GetComponent(E_THRYSISTER_COMPONENT);	
}

void TCSuperSpiceView::OnComponentsDrawDiac() 
{
	GetComponent(E_DIAC_COMPONENT);
}

void TCSuperSpiceView::OnComponentsDrawGTOTriac() 
{
	GetComponent(E_GTO_COMPONENT);
}

void TCSuperSpiceView::OnComponentsMorecomponentsDrawtTransformer() 
{
	GetComponent(E_TRANSFORMER_COMPONENT);
}

void TCSuperSpiceView::OnComponentsMorecomponentsDrawTransmissionLine() 
{
	GetComponent(E_TRANSMISSION_LINE_COMPONENT);
}

void TCSuperSpiceView::OnComponentsMorecomponentsDrawTriac() 
{
	GetComponent(E_TRIAC_COMPONENT);
}

void TCSuperSpiceView::OnComponentsMorecomponentsDrawVCSwitch() 
{
	GetComponent(E_VSWITCH_COMPONENT);
}

void TCSuperSpiceView::OnComponentsMorecomponentsDualGateMosfet() 
{
	GetComponent(E_DUAL_GATE_NMOSFET);
}


void TCSuperSpiceView::OnComponentsIGBP() 
{
	GetComponent(E_NIGBP_COMPONENT);
}
void TCSuperSpiceView::OnComponentsIGBPPNP() 
{
	GetComponent(E_PIGBP_COMPONENT);
}

void TCSuperSpiceView::OnComponentsMorecomponentsDualGatePMosfet() 
{
	GetComponent(E_DUAL_GATE_PMOSFET);
}

void TCSuperSpiceView::OnComponentsFilter() 
{
	//changed from filter
	GetComponent(E_MULIPLIER_COMPONENT);
}
void TCSuperSpiceView::OnComponentsDivider() 
{
	GetComponent(E_COMPONENT_DIVIDER);	
}
void TCSuperSpiceView::OnComponentsNpn4Terminal() 
{	
	GetComponent(E_NPN_4TERM_TRANSISTER_COMPONENT);
}
void TCSuperSpiceView::OnComponentsPnp4Terminal() 
{
	GetComponent(E_PNP_4TERM_TRANSISTER_COMPONENT);
}
void TCSuperSpiceView::OnComponentsNmos4Terminal() 
{
	GetComponent(E_NMOS_4TERM_TRANSISTER_COMPONENT);
}
void TCSuperSpiceView::OnComponentsPmos4Terminal() 
{
	GetComponent(E_PMOS_4TERM_TRANSISTER_COMPONENT);
}

void TCSuperSpiceView::OnComponentsNJFET4Terminal() 
{
	GetComponent(E_4TERM_NJFET_TRANSISTER_COMPONENT);
}

void TCSuperSpiceView::OnComponentsPJFET4Terminal() 
{
	GetComponent(E_4TERM_PJFET_TRANSISTER_COMPONENT);
}

void TCSuperSpiceView::OnComponentsUJunction() 
{
	GetComponent(E_UNIJUNCTION_COMPONENT);
}
void TCSuperSpiceView::OnComponentsBuffer() 
{
	GetComponent(E_BUFFER_COMPONENT);	
}

void TCSuperSpiceView::OnComponentsVCA() 
{
	GetComponent(E_VCA_COMPONENT);
}

void TCSuperSpiceView::OnGetNGasFet4Terminal() 
{
	GetComponent(E_NGASFET_4TERM_TRANSISTER_COMPONENT);
}

void TCSuperSpiceView::OnGetNGasFet() 
{
	GetComponent(E_NGASFET_TRANSISTER_COMPONENT);
}

void TCSuperSpiceView::OnGetPGasFet() 
{
	GetComponent(E_PGASFET_TRANSISTER_COMPONENT);
}

void TCSuperSpiceView::OnOnGetPGasFet4Terminal() 
{
	GetComponent(E_PGASFET_4TERM_TRANSISTER_COMPONENT);
}

void TCSuperSpiceView::OnComponentsGeneric2InputAmp() 
{
	GetComponent(E_GENERIC_2INPUT_AMP);
}
void TCSuperSpiceView::OnComponentsGeneric2Pin() 
{
	GetComponent(E_GENERIC_2_COMPONENT);
}

void TCSuperSpiceView::OnComponentsGeneric3Pin() 
{
	GetComponent(E_GENERIC_3_COMPONENT);
}

void TCSuperSpiceView::OnComponentsGeneric4Pin() 
{
	GetComponent(E_GENERIC_4_COMPONENT);
}

void TCSuperSpiceView::OnComponentsGeneric5Pin() 
{
	GetComponent(E_GENERIC_5_COMPONENT);
}

void TCSuperSpiceView::OnComponentsGeneric6Pin() 
{
	GetComponent(E_GENERIC_6_COMPONENT);
}

void TCSuperSpiceView::OnComponentsGeneric7Pin() 
{
	GetComponent(E_GENERIC_7_COMPONENT);
}

void TCSuperSpiceView::OnComponentsGeneric8Pin() 
{
	GetComponent(E_GENERIC_8_COMPONENT);
}
void TCSuperSpiceView::OnComponentsGeneric9Pin() 
{
	GetComponent(E_GENERIC_9_COMPONENT);
}
void TCSuperSpiceView::OnComponentsGeneric10Pin() 
{
	GetComponent(E_GENERIC_10_COMPONENT);
}

void TCSuperSpiceView::OnComponentsGeneric11Pin() 
{
	GetComponent(E_GENERIC_11_COMPONENT);
}

void TCSuperSpiceView::OnComponentsGeneric12Pin() 
{
	GetComponent(E_GENERIC_12_COMPONENT);
}

void TCSuperSpiceView::OnComponentsGeneric13Pin() 
{
	GetComponent(E_GENERIC_13_COMPONENT);
}

void TCSuperSpiceView::OnComponentsGeneric14Pin() 
{
	GetComponent(E_GENERIC_14_COMPONENT);
}

void TCSuperSpiceView::OnComponentsGeneric15Pin() 
{
	GetComponent(E_GENERIC_15_COMPONENT);
}

void TCSuperSpiceView::OnComponentsGeneric16Pin() 
{
	GetComponent(E_GENERIC_16_COMPONENT);
}

void TCSuperSpiceView::OnComponentsAnalogAnd() 
{
	GetComponent(E_AND_GATE);
}

void TCSuperSpiceView::OnComponentsAnalogNand() 
{
	GetComponent(E_NAND_GATE);
}

void TCSuperSpiceView::OnComponentsAnalogNor() 
{
	GetComponent(E_NOR_GATE);
}

void TCSuperSpiceView::OnComponentsAnalogOr() 
{
	GetComponent(E_OR_GATE);
}

void TCSuperSpiceView::OnComponentsAnalogInvertor() 
{
	GetComponent(E_INVERTOR);	
}

void TCSuperSpiceView::OnComponentsLaplaceTransform() 
{
	GetComponent(E_LAPLACE_TRANSFORM);
}

void TCSuperSpiceView::OnComponentsNonlinearSource() 
{   // KA Oct 2017, make fail
	// GetComponent(E_NONLINEAR_DEPENDANT_SOURCE);	
}

void TCSuperSpiceView::OnComponentsAnalogExOr() 
{
	GetComponent(E_EXCLUSIVE_OR);
}

void TCSuperSpiceView::OnComponentsAnalogExNor() 
{
	GetComponent(E_EXCLUSIVE_NOR);
}

void TCSuperSpiceView::OnComponentsAnalogtoDigitalConverter() 
{
	GetComponent(E_ANALOG_TO_DIGITAL);
}

void TCSuperSpiceView::OnComponentsDigitaltoAnalogConvertor() 
{
	GetComponent(E_DIGITAL_TO_ANALOG);
}

void TCSuperSpiceView::OnComponentsDigitalNand() 
{
	GetComponent(E_DIGITAL_NAND);
}

void TCSuperSpiceView::OnComponentsDigitalInvertor()
{
	GetComponent(E_DIGITAL_INVERTOR);
}
void TCSuperSpiceView::OnComponentsDigitalAnd()
{
	GetComponent(E_DIGITAL_AND);
}

void TCSuperSpiceView::OnComponentsAnalogSchmittTrigger(void)
{
	GetComponent(E_SCHMITT_TRIGGER);
}

void TCSuperSpiceView::OnComponentsDigitalNor()
{
	GetComponent(E_DIGITAL_NOR);
}
void TCSuperSpiceView::OnComponentsDigitalOr()
{
	GetComponent(E_DIGITAL_OR);
}
void TCSuperSpiceView::OnComponentsDigitalExOr()
{
	GetComponent(E_DIGITAL_EX_OR);
}
void TCSuperSpiceView::OnComponentsDigitalExNor()
{
	GetComponent(E_DIGITAL_EX_NOR);
}

void TCSuperSpiceView::OnComponentsDigitalDtypeBistable() 
{
	GetComponent(E_DTYPE);
}

void TCSuperSpiceView::OnComponentsDigitalJkBisable() 
{
	GetComponent(E_JKTYPE);
}

void TCSuperSpiceView::OnComponentsDigital8BitCounter() 
{
	GetComponent(E_8BIT_COUNTER);
}

void TCSuperSpiceView::OnArowUp() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CPoint CNewPosition;

	CNewPosition = GetScrollBarPosition();

	CNewPosition.y -= CSuperSpiceViewData.CLineSize.cy;

	SetScrollBarPosition(CNewPosition);

	TCSuperSpiceDoc *PCDoc = GetDocument();

	PCDoc->OnViewDrawAll(this, CSuperSpiceViewData.PCMSchematicManager);
}

void TCSuperSpiceView::OnArrowDown() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CPoint CNewPosition;

	CNewPosition = GetScrollBarPosition();

	CNewPosition.y += CSuperSpiceViewData.CLineSize.cy;

	SetScrollBarPosition(CNewPosition);

	TCSuperSpiceDoc *PCDoc = GetDocument();

	PCDoc->OnViewDrawAll(this, CSuperSpiceViewData.PCMSchematicManager);
}

void TCSuperSpiceView::OnArrowLeft() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CPoint CNewPosition;

	CNewPosition = GetScrollBarPosition();

	CNewPosition.x -= CSuperSpiceViewData.CPageSize.cx;

	SetScrollBarPosition(CNewPosition);

	TCSuperSpiceDoc *PCDoc = GetDocument();

	PCDoc->OnViewDrawAll(this, CSuperSpiceViewData.PCMSchematicManager);
}

void TCSuperSpiceView::OnArrowRight() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CPoint CNewPosition;

	CNewPosition = GetScrollBarPosition();

	CNewPosition.x += CSuperSpiceViewData.CPageSize.cx;

	SetScrollBarPosition(CNewPosition);

	TCSuperSpiceDoc *PCDoc = GetDocument();

	PCDoc->OnViewDrawAll(this, CSuperSpiceViewData.PCMSchematicManager);
}

void TCSuperSpiceView::OnPageDown() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CPoint CNewPosition;

	CNewPosition = GetScrollBarPosition();

	CNewPosition.y += CSuperSpiceViewData.CPageSize.cy;

	SetScrollBarPosition(CNewPosition);

	TCSuperSpiceDoc *PCDoc = GetDocument();

	PCDoc->OnViewDrawAll(this, CSuperSpiceViewData.PCMSchematicManager);
}

void TCSuperSpiceView::OnPageUp() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CPoint CNewPosition;

	CNewPosition = GetScrollBarPosition();

	CNewPosition.y -= CSuperSpiceViewData.CPageSize.cy;

	SetScrollBarPosition(CNewPosition);

	TCSuperSpiceDoc *PCDoc = GetDocument();

	PCDoc->OnViewDrawAll(this, CSuperSpiceViewData.PCMSchematicManager);
}

void TCSuperSpiceView::OnDrawWireImmediatly() 
{
	OnDrawWire();

	WaitingToDrawWireLBDown(0, GlobalMousePosition);
}

void TCSuperSpiceView::OnPropertyAccelerater() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	PCDoc->OnViewPropertyAccelerater(this);	
}



void TCSuperSpiceView::OnSimulationSetup() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	PCDoc->OnViewSimulationSetup();	
	
}

void TCSuperSpiceView::OnRunAc() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	CAnalysisSetup.CACSetupData.CSweepData.enable = !CAnalysisSetup.CACSetupData.CSweepData.enable;
}
void TCSuperSpiceView::OnUpdateRunAc(CCmdUI* pCmdUI) 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CACSetupData.CSweepData.enable);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceView::OnRunDc() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	CAnalysisSetup.CDCSetupData.CSweepData1.enable = !CAnalysisSetup.CDCSetupData.CSweepData1.enable;

	if(CAnalysisSetup.CDCSetupData.CSweepData1.enable)
		CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = !CAnalysisSetup.CDCSetupData.CSweepData1.enable;
}

void TCSuperSpiceView::OnUpdateRunDc(CCmdUI* pCmdUI) 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CDCSetupData.CSweepData1.enable);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceView::OnRunEnableOperatingPoint() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	CAnalysisSetup.CDCSetupData.enable_operating_point = !CAnalysisSetup.CDCSetupData.enable_operating_point;
}

void TCSuperSpiceView::OnUpdateRunEnableOperatingPoint(CCmdUI* pCmdUI) 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	TCSuperSpiceDoc *PCDocTop = PCDoc->GetTopLevelDoc();

	if(!PCDocTop) return;

	TCAnalysisSetup &CAnalysisSetup = PCDocTop->GetAnalysisSetup();

	pCmdUI->SetCheck(!!CAnalysisSetup.CDCSetupData.enable_operating_point);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceView::OnRunEnableNoise() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	CAnalysisSetup.CNoiseSetupData.enable = !CAnalysisSetup.CNoiseSetupData.enable;

	if(CAnalysisSetup.CNoiseSetupData.enable) 
	{
//		CAnalysisSetup.CACSetupData.CSweepData.enable = true;

		CAnalysisSetup.CTransientSetupData.enable_marching_waveforms = false;
	}
}

void TCSuperSpiceView::OnUpdateRunEnableNoise(CCmdUI* pCmdUI) 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CNoiseSetupData.enable);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceView::OnRunTransient() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	CAnalysisSetup.CTransientSetupData.CSweepData.enable = !CAnalysisSetup.CTransientSetupData.CSweepData.enable;
}

void TCSuperSpiceView::OnUpdateRunTransient(CCmdUI* pCmdUI) 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CTransientSetupData.CSweepData.enable);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceView::OnRunEnableFourier() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	CAnalysisSetup.CTransientSetupData.fourier_enable = !CAnalysisSetup.CTransientSetupData.fourier_enable;

	if(CAnalysisSetup.CTransientSetupData.fourier_enable) CAnalysisSetup.CTransientSetupData.CSweepData.enable = true;
}

void TCSuperSpiceView::OnUpdateRunEnableFourier(CCmdUI* pCmdUI) 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CTransientSetupData.fourier_enable);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceView::OnRunStatistics() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	CAnalysisSetup.CStatisticsSetupData.enable = !CAnalysisSetup.CStatisticsSetupData.enable;

	if(CAnalysisSetup.CStatisticsSetupData.enable)
	{
		if(CAnalysisSetup.CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_MULTY_RUNS)
		{
			CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = false;

			CAnalysisSetup.CTransientSetupData.enable_marching_waveforms = false;
		}
		
		CAnalysisSetup.CReRun.enable	= false;
		CAnalysisSetup.CParametricSetupData.CSweepData.enable = false;
	}
}

void TCSuperSpiceView::OnUpdateRunStatistics(CCmdUI* pCmdUI) 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CStatisticsSetupData.enable);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceView::OnRunParametric() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	CAnalysisSetup.CParametricSetupData.CSweepData.enable = !CAnalysisSetup.CParametricSetupData.CSweepData.enable;

	if(CAnalysisSetup.CParametricSetupData.CSweepData.enable)
	{
		if(CAnalysisSetup.CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_MULTY_RUNS)
		{
		   CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = false;

		   CAnalysisSetup.CTransientSetupData.enable_marching_waveforms = false;
		}

		CAnalysisSetup.CReRun.enable	= false;
		CAnalysisSetup.CStatisticsSetupData.enable = false;
	}
}

void TCSuperSpiceView::OnUpdateRunParametric(CCmdUI* pCmdUI) 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CParametricSetupData.CSweepData.enable);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceView::OnRunTemperature() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = !CAnalysisSetup.CTemperatureSetupData.CSweepData.enable;

	if(CAnalysisSetup.CTemperatureSetupData.CSweepData.enable)
		CAnalysisSetup.CDCSetupData.CSweepData1.enable = !CAnalysisSetup.CTemperatureSetupData.CSweepData.enable;

	if(CAnalysisSetup.CTemperatureSetupData.CSweepData.enable &&
	   CAnalysisSetup.CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_MULTY_RUNS)
	{
		CAnalysisSetup.CParametricSetupData.CSweepData.enable = false;
		CAnalysisSetup.CStatisticsSetupData.enable = false;
		CAnalysisSetup.CReRun.enable = false;
		CAnalysisSetup.CTransientSetupData.enable_marching_waveforms = false;
	}
}

void TCSuperSpiceView::OnUpdateRunTemperature(CCmdUI* pCmdUI) 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CTemperatureSetupData.CSweepData.enable);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceView::OnRunSensitivity() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	CAnalysisSetup.CSensitivitySetupData.enable_dc = !CAnalysisSetup.CSensitivitySetupData.enable_dc;

	if(CAnalysisSetup.CSensitivitySetupData.enable_dc) 
	{
		CAnalysisSetup.CSensitivitySetupData.enable_ac = false;

		CAnalysisSetup.CTransientSetupData.enable_marching_waveforms = false;
	}
}

void TCSuperSpiceView::OnUpdateRunSensitivity(CCmdUI* pCmdUI) 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CSensitivitySetupData.enable_dc);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceView::OnRunSensitivityAc() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	CAnalysisSetup.CSensitivitySetupData.enable_ac = !CAnalysisSetup.CSensitivitySetupData.enable_ac;

	if(CAnalysisSetup.CSensitivitySetupData.enable_ac)
	{
		CAnalysisSetup.CSensitivitySetupData.enable_dc = false;

		CAnalysisSetup.CTransientSetupData.enable_marching_waveforms = false;
	}
}

void TCSuperSpiceView::OnUpdateRunSensitivityAc(CCmdUI* pCmdUI) 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CSensitivitySetupData.enable_ac);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceView::OnRunEnablePoleZero() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	CAnalysisSetup.CPoleZeroSetupData.enable = !CAnalysisSetup.CPoleZeroSetupData.enable;

	if(CAnalysisSetup.CPoleZeroSetupData.enable) 
	{
		CAnalysisSetup.CACSetupData.CSweepData.enable = true;

		CAnalysisSetup.CTransientSetupData.enable_marching_waveforms = false;
	}
}

void TCSuperSpiceView::OnUpdateRunEnablePoleZero(CCmdUI* pCmdUI) 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CPoleZeroSetupData.enable);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceView::OnRunEnableDistortion() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	CAnalysisSetup.CDistortionSetupData.enable = !CAnalysisSetup.CDistortionSetupData.enable;

	if(CAnalysisSetup.CDistortionSetupData.enable)
		CAnalysisSetup.CTransientSetupData.enable_marching_waveforms = false;
}

void TCSuperSpiceView::OnUpdateRunEnableDistortion(CCmdUI* pCmdUI) 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CDistortionSetupData.enable);

	pCmdUI->ContinueRouting();
}


void TCSuperSpiceView::OnRunReruns() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.enable != E_RERUN_SWEEP_TYPE_WC_MODEL_FILES)
		CAnalysisSetup.CReRun.enable = E_RERUN_SWEEP_TYPE_WC_MODEL_FILES;
	else
		CAnalysisSetup.CReRun.enable = 0;

	if(CAnalysisSetup.CReRun.enable)
	{
		if(CAnalysisSetup.CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_MULTY_RUNS)
			CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = false;
		
		CAnalysisSetup.CParametricSetupData.CSweepData.enable = false;
		CAnalysisSetup.CStatisticsSetupData.enable = false;
		CAnalysisSetup.CTransientSetupData.enable_marching_waveforms = false;
	}
}

void TCSuperSpiceView::OnUpdateRunReruns(CCmdUI* pCmdUI) 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_MODEL_FILES ||
		CAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_RERUN_FILE) pCmdUI->SetCheck(1);
	else pCmdUI->SetCheck(0);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceView::OnRunEnableMonteCarlo()
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.enable != E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
		CAnalysisSetup.CReRun.enable = E_RERUN_SWEEP_TYPE_MC_RERUN_FILE;
	else
		CAnalysisSetup.CReRun.enable = 0;

	if(CAnalysisSetup.CReRun.enable)
	{
		if(CAnalysisSetup.CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_MULTY_RUNS)
			CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = false;
		
		CAnalysisSetup.CParametricSetupData.CSweepData.enable = false;
		CAnalysisSetup.CStatisticsSetupData.enable = false;
		CAnalysisSetup.CTransientSetupData.enable_marching_waveforms = false;
	}
}

void TCSuperSpiceView::OnUpdateRunEnableMonteCarlo(CCmdUI *pCmdUI)
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE) pCmdUI->SetCheck(1);
	else pCmdUI->SetCheck(0);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceView::OnRunUpdateNetNames() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc->UpdateNets(CSuperSpiceViewData.PCMSchematicManager);
}

BOOL TCSuperSpiceView::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	pWnd; nHitTest;  message;

	if(!CSuperSpiceViewData.PCMSchematicManager) return true;

	if(GCWorkspaceTree.IsDragging())
	{
		m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_DRAGGING_SYMBOL);

		SetCursor(m_hcursor);

		return true;
	}

	short shift_alt_key_state = GetKeyState(VK_MENU);// Gets the fucking alt key status, fucking Microshit!

	if(shift_alt_key_state < 0) shift_alt_key_state = MK_ALT;
	else
	{
		shift_alt_key_state = GetKeyState(VK_SHIFT);
		if(shift_alt_key_state < 0) shift_alt_key_state = MK_SHIFT;

		else shift_alt_key_state = false;
	}

	int type = CSuperSpiceViewData.PCMSchematicManager->GetComponentOutlinedType();

	TCSchematicObject *PCSchematicObject = CSuperSpiceViewData.PCMSchematicManager->PCMLastOutlinedComponent;
	bool waveform_corner = false;
	
	if(PCSchematicObject)
		if(!IsBadReadPtr(PCSchematicObject, 4))
			if(PCSchematicObject->m_type == E_WAVEFORM_COMPONENT) waveform_corner = true;

	if(CSuperSpiceViewData.system_state == E_GRAPHICS_MANAGER_STATE_WAVEFORM_ON_CLICK)
	{
		m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_SCOPE_PROBE);

		SetCursor(m_hcursor);

		return true;
	}

	if(shift_alt_key_state == MK_ALT || GCSuperSpiceGlobalData.CDrawData.probe_mode)
	{
		m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_SCOPE_PROBE);

		SetCursor(m_hcursor);

		return true;
	}

	if(type == E_SCHEMATIC_WIRE || !type)
	if(shift_alt_key_state == MK_SHIFT)
	{
		m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_SCOPE_PROBE_ERASE);

		SetCursor(m_hcursor);

		return true;
	}

	if(type)// if outlined
	{
		switch(type)
		{
			case E_SCHEMATIC_PIN:if(shift_alt_key_state == MK_SHIFT){m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_SCOPE_PROBE_ERASE);break;}
								else if(!waveform_corner){m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_DRAW_LINE);break;}
								else if(shift_alt_key_state != MK_SHIFT) m_hcursor = AfxGetApp()->LoadStandardCursor(IDC_SIZENWSE);break;

			case E_SCHEMATIC_OBJECT:		m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;
			case E_WAVEFORM_OBJECT:			m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;
			case E_SCHEMATIC_TEXT_LABEL:	m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;
			case E_SCHEMATIC_LABEL:			m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;
			case E_SCHEMATIC_WIRE:			m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;
			case E_SCHEMATIC_PIN_LABEL:		m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;

			case E_WAVEFORM_OBJECT_SCREEN: m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_SCOPE_PROBE);break;
			
			default: m_hcursor = AfxGetApp()->LoadStandardCursor(IDC_ARROW);break;
		}
		if(CSuperSpiceViewData.system_state == E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE)
			m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_DRAW_LINE);

		if(CSuperSpiceViewData.system_state == E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE)
			m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_DRAW_LINE);

	}
	else
	{
		switch(CSuperSpiceViewData.system_state)
		{
			case E_GRAPHICS_MANAGER_STATE_IDLE:		
			m_hcursor = AfxGetApp()->LoadStandardCursor(IDC_ARROW);break;
			case E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED:
			m_hcursor = AfxGetApp()->LoadStandardCursor(IDC_ARROW);break;
			case E_GRAPHICS_MANAGER_STATE_SELECT_REGION:
			m_hcursor = AfxGetApp()->LoadStandardCursor(IDC_ARROW);break;		 
			case E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC:
			m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;
			case E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD:
			m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;
			
			case E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE:			
			m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_DRAW_LINE);break;
			
			case E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE: 
			m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_DRAW_LINE);break;

			case E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING:
				m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_CLOSED_HAND);break;

			case E_GRAPHICS_MANAGER_STATE_WAVEFORM_ON_CLICK:  m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_SCOPE_PROBE);break;

			default: m_hcursor = AfxGetApp()->LoadStandardCursor(IDC_ARROW); break;
		}
	}

	SetCursor(m_hcursor);

	return true;
}

void TCSuperSpiceView::OnGeneratorsAccurrentsource() 
{
	GetComponent(E_SINE_CURRENT_SOURCE, E_SINE_CURRENT_SOURCE);
}

void TCSuperSpiceView::OnGeneratorsAcsource() 
{
	GetComponent(E_SINE_VOLTAGE_SOURCE, E_SINE_VOLTAGE_SOURCE);
}

void TCSuperSpiceView::OnGeneratorsDccurrentsource() 
{
	GetComponent(E_DC_CURRENT_SOURCE, E_DC_CURRENT_SOURCE);
}

void TCSuperSpiceView::OnGeneratorsDcsource() 
{
	GetComponent(E_DC_VOLTAGE_SOURCE, E_DC_VOLTAGE_SOURCE);
}

void TCSuperSpiceView::OnGeneratorsExponentialcurrentsource() 
{
	GetComponent(E_EXPONENTIAL_CURRENT_SOURCE, E_EXPONENTIAL_CURRENT_SOURCE);
}

void TCSuperSpiceView::OnGeneratorsExponentialsource() 
{
	GetComponent(E_EXPONENTIAL_VOLTAGE_SOURCE, E_EXPONENTIAL_VOLTAGE_SOURCE);
}

void TCSuperSpiceView::OnGeneratorsPiecewiselinearsource() 
{
	GetComponent(E_PIECEWISE_LINEAR_VOLTAGE_SOURCE, E_PIECEWISE_LINEAR_VOLTAGE_SOURCE);
}

void TCSuperSpiceView::OnGeneratorsPulse() 
{
	GetComponent(E_PULSE_VOLTAGE_SOURCE, E_PULSE_VOLTAGE_SOURCE);
}

void TCSuperSpiceView::OnGeneratorsPiecewiselinearcurrentsource() 
{
	GetComponent(E_PIECEWISE_LINEAR_CURRENT_SOURCE, E_PIECEWISE_LINEAR_CURRENT_SOURCE);
}
void TCSuperSpiceView::OnGeneratorsPulsecurrentsource() 
{
	GetComponent(E_PULSE_CURRENT_SOURCE, E_PULSE_CURRENT_SOURCE);
}

void TCSuperSpiceView::OnGeneratorsSinglefrequencyfmcurrentsource() 
{
	GetComponent(E_SINGLE_FREQ_CURRENT_FM, E_SINGLE_FREQ_CURRENT_FM);
}

void TCSuperSpiceView::OnGeneratorsSinglefrequencyfmsource() 
{
	GetComponent(E_SINGLE_FREQ_VOLTAGE_FM, E_SINGLE_FREQ_VOLTAGE_FM);	
}

void TCSuperSpiceView::OnTestpointsCurrent() 
{
	GetComponent(E_TEST_MARKER, E_TEST_POINT_MAGDEG);
}

void TCSuperSpiceView::OnTestpointsCurrentmagnitudedb() 
{
	GetComponent(E_TEST_MARKER, E_TEST_POINT_MAGRADS);
}

void TCSuperSpiceView::OnTestpointsCurrentphase() 
{
	GetComponent(E_TEST_MARKER, E_TEST_POINT_DBDEGS);
}

void TCSuperSpiceView::OnTestpointsVoltagemagnitudedb() 
{
	GetComponent(E_TEST_MARKER, E_TEST_POINT_DB);
}

void TCSuperSpiceView::OnTestpointsVoltagephase() 
{
	GetComponent(E_TEST_MARKER, E_TEST_POINT_DBDEGS);
}
void TCSuperSpiceView::OnTestpointsDrawVoltage() 
{
	GetComponent(E_TEST_MARKER, E_TEST_POINT_MAGDEG);	
}


void TCSuperSpiceView::OnViewDcVoltages() 
{
//	return;
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	g_show_all_dc_volts = !g_show_all_dc_volts;

	PCDoc->OnViewShowDcVoltages(this, g_show_all_dc_volts);
}


void TCSuperSpiceView::OnUpdateViewDcVoltages(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(g_show_all_dc_volts);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceView::OnViewNetNames() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	g_show_all_net_names = !g_show_all_net_names;

	PCDoc->OnViewShowNetNames(this, g_show_all_net_names);
}

void TCSuperSpiceView::OnUpdateViewNetNames(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(g_show_all_net_names);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceView::OnViewDcCurrents() 
{
//	return;
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	g_show_all_dc_currents = !g_show_all_dc_currents;

	PCDoc->OnViewShowDcCurrents(this, g_show_all_dc_currents);
}

void TCSuperSpiceView::OnUpdateViewDcCurrents(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(g_show_all_dc_currents);

	pCmdUI->ContinueRouting();
}

void TCSuperSpiceView::OnViewDecendSchematic() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;
	
	PCDoc->OnViewDecendSchematic(this, CSuperSpiceViewData.CLastMousePosition, MK_CONTROL);
}

void TCSuperSpiceView::OnViewAccendSchematic() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc->OnViewAccendSchematic(this);
	
}

void TCSuperSpiceView::OnUpdateViewAccendSchematic(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(false);
}

void TCSuperSpiceView::OnRunRun() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	

	PCDoc->OnRunRun(this);
}

void TCSuperSpiceView::OnRunRunDebugMode() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	

	PCDoc->OnRunRunDebugMode(this);	
}

void TCSuperSpiceView::OnRunRunSameNetList() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	

	PCDoc->OnRunRun(this, false);
}

void TCSuperSpiceView::OnTimer(UINT_PTR nIDEvent) 
{	
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	

	if(!PCDoc->PCSuperSpiceViewTimer)
	{
		KillTimer(1);

		return;
	}

	PCDoc->TimerCallBack();

	CScrollView::OnTimer(nIDEvent);
}

void TCSuperSpiceView::OnWindowNewGraph() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;
	
	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	

	PCDoc->OnViewNewGraph(this);
}

void TCSuperSpiceView::OnFilePrintPreview() 
{
	CView::OnFilePrintPreview();	
}

void TCSuperSpiceView::OnWaveformsDisplayacwaveform() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;
	
	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	if(!PCOutputWaveformData->AreAnySignalsEnabled(E_SPICE_RECORD_AC))
	{
		PCOutputWaveformData->CRecords[0].CHeader.PCWaveformDataRuns->CopySignalEnables(E_SPICE_RECORD_AC, m_current_waveform_type);
	}
	
	m_current_waveform_type = E_SPICE_RECORD_AC;

	int index = PCOutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_AC);

	if(index < 0) return;

	CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(PCDoc->GetOutputWaveformData()->CRecords[index].CHeader);
	
}

void TCSuperSpiceView::OnUpdateWaveformsDisplayacwaveform(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	pCmdUI->Enable(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_AC));
}

void TCSuperSpiceView::OnWaveformsDisplaydcwaveform() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;
	
	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	if(!PCOutputWaveformData->AreAnySignalsEnabled(E_SPICE_RECORD_DC))
	{
		PCOutputWaveformData->CRecords[0].CHeader.PCWaveformDataRuns->CopySignalEnables(E_SPICE_RECORD_DC, m_current_waveform_type);
	}

	m_current_waveform_type = E_SPICE_RECORD_DC;

	int index = PCOutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_DC);

	if(index < 0) return;

	CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(PCDoc->GetOutputWaveformData()->CRecords[index].CHeader);	
}

void TCSuperSpiceView::OnUpdateWaveformsDisplaydcwaveform(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	pCmdUI->Enable(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_DC));	
}


void TCSuperSpiceView::OnWaveformsDisplaytranswaveform() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;
	
	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	if(!PCOutputWaveformData->AreAnySignalsEnabled(E_SPICE_RECORD_TRANSIENT))
	{
		PCOutputWaveformData->CRecords[0].CHeader.PCWaveformDataRuns->CopySignalEnables(E_SPICE_RECORD_TRANSIENT, m_current_waveform_type);
	}

	m_current_waveform_type = E_SPICE_RECORD_TRANSIENT;

	int index = PCOutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_TRANSIENT);

	if(index < 0) return;

	CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(PCDoc->GetOutputWaveformData()->CRecords[index].CHeader);	
}

void TCSuperSpiceView::OnUpdateWaveformsDisplaytranswaveform(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	pCmdUI->Enable(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT));
}

void TCSuperSpiceView::OnWaveformsDisplaynoisewaveform() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;
	
	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	if(!PCOutputWaveformData->AreAnySignalsEnabled(E_SPICE_RECORD_NOISE_SPECTRAL))
	{
		PCOutputWaveformData->CRecords[0].CHeader.PCWaveformDataRuns->CopySignalEnables(E_SPICE_RECORD_NOISE_SPECTRAL, m_current_waveform_type);
	}

	m_current_waveform_type = E_SPICE_RECORD_NOISE_SPECTRAL;

	int index = PCOutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_NOISE_SPECTRAL);

	if(index < 0) return;

	CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(PCDoc->GetOutputWaveformData()->CRecords[index].CHeader);
}

void TCSuperSpiceView::OnUpdateWaveformsDisplaynoisewaveform(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	pCmdUI->Enable(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_NOISE_SPECTRAL));
}

void TCSuperSpiceView::OnWaveformsDisplayfourierwaveform() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;
	
	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	if(!PCOutputWaveformData->AreAnySignalsEnabled(E_SPICE_RECORD_FOURIER))
	{
		PCOutputWaveformData->CRecords[0].CHeader.PCWaveformDataRuns->CopySignalEnables(E_SPICE_RECORD_FOURIER, m_current_waveform_type);
	}

	m_current_waveform_type = E_SPICE_RECORD_FOURIER;

	int index = PCOutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_FOURIER);

	if(index < 0) return;

	CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(PCDoc->GetOutputWaveformData()->CRecords[index].CHeader);		
}

void TCSuperSpiceView::OnUpdateWaveformsDisplayfourierwaveform(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	pCmdUI->Enable(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_FOURIER));	
}

void TCSuperSpiceView::OnWaveformsDisplaysenswaveform() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;
	
	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	int index = PCOutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_SENSITIVITY);

	if(index < 0) return;

	PCDoc->OnViewDisplaySensitivityText(this);
}

void TCSuperSpiceView::OnUpdateWaveformsDisplaysenswaveform(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	pCmdUI->Enable(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_SENSITIVITY));
	
	
}
void TCSuperSpiceView::OnWaveformsDisplaypolezerowaveform() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();
	
	if(!PCDoc) return;

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	int index = PCDoc->GetOutputWaveformData()->GetWaveFormHeaderIndex(E_SPICE_RECORD_POLE_ZERO);

	if(index < 0) return;

	PCDoc->OnViewDisplayPoleZeroText(this);
}

void TCSuperSpiceView::OnUpdateWaveformsDisplaypolezerowaveform(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	pCmdUI->Enable(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_POLE_ZERO));	
}


void TCSuperSpiceView::OnWaveformsDistortion2() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;
	
	m_current_waveform_type = E_SPICE_RECORD_THD;// 3rd harm

	int index = PCDoc->GetOutputWaveformData()->GetWaveFormHeaderIndex(E_SPICE_RECORD_THD);

	if(index < 0) return;

	CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(PCDoc->GetOutputWaveformData()->CRecords[index].CHeader);	
}

void TCSuperSpiceView::OnUpdateWaveformsDistortion2(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	if(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_THD))
	{
		pCmdUI->Enable(true);

		return;
	}
	else pCmdUI->Enable(false);
}

void TCSuperSpiceView::OnWaveformsDistortion() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;
	
	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	m_current_waveform_type = E_SPICE_RECORD_IMD;

	int index = PCDoc->GetOutputWaveformData()->GetWaveFormHeaderIndex(E_SPICE_RECORD_IMD);

	if(index < 0) return;

	CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(PCDoc->GetOutputWaveformData()->CRecords[index].CHeader);			
}

void TCSuperSpiceView::OnUpdateWaveformsDistortion(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	if(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_IMD))
	{
		pCmdUI->Enable(true);

		return;
	}
	else pCmdUI->Enable(false);
}

void TCSuperSpiceView::OnWaveformsDistortionF2() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;
	
	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	m_current_waveform_type = E_SPICE_RECORD_DISTORTION_IMD_2F;

	int index = PCDoc->GetOutputWaveformData()->GetWaveFormHeaderIndex(E_SPICE_RECORD_DISTORTION_IMD_2F);

	if(index < 0) return;

	CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(PCDoc->GetOutputWaveformData()->CRecords[index].CHeader);			
	
}

void TCSuperSpiceView::OnUpdateWaveformsDistortionF2(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	if(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_DISTORTION_IMD_2F))
	{
		pCmdUI->Enable(true);

		return;
	}
	else pCmdUI->Enable(false);

}

void TCSuperSpiceView::OnAxisAutoScale() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;
	
	CSuperSpiceViewData.PCMSchematicManager->AxisAutoScale();
}

void TCSuperSpiceView::OnAxisMagnify() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	AfxMessageBox(IDS_NOT_YET_SUPPOTED);

	return;

	// CSuperSpiceViewData.PCMSchematicManager->AxisMagnify();
}

void TCSuperSpiceView::OnAxisReduce() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	AfxMessageBox(IDS_NOT_YET_SUPPOTED);

	return;

//	CSuperSpiceViewData.PCMSchematicManager->AxisReduce();
}

void TCSuperSpiceView::OnAxisScrolXLeft() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	AfxMessageBox(IDS_NOT_YET_SUPPOTED);

	return;

//	CSuperSpiceViewData.PCMSchematicManager->AxisScrollXLeft();	
}

void TCSuperSpiceView::OnAxisScrolXRight() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	AfxMessageBox(IDS_NOT_YET_SUPPOTED);

	return;

//	CSuperSpiceViewData.PCMSchematicManager->AxisScrollXRight();	
}

void TCSuperSpiceView::OnAxisScrollYDown() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	AfxMessageBox(IDS_NOT_YET_SUPPOTED);

//	return;

	CSuperSpiceViewData.PCMSchematicManager->AxisScrollYDown();	
}

void TCSuperSpiceView::OnAxisScrollYUp() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	AfxMessageBox(IDS_NOT_YET_SUPPOTED);

//	return;

	CSuperSpiceViewData.PCMSchematicManager->AxisScrollYUp();
}


void TCSuperSpiceView::OnEscape() 
{
	OnCancelCommand();
}

void TCSuperSpiceView::OnHelpGetcomputerpassword() 
{
	TCPasswordId CPasswordId;

	CPasswordId.DoModal();	
}

void TCSuperSpiceView::OnSetupClearErrors() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();
	
	if(!PCDoc) return;

	PCDoc->ClearError();	
}

void TCSuperSpiceView::OnEditUtilitiesRenumberWires() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();
	
	if(!PCDoc) return;

	PCDoc->RenumberWires(this);
}

void TCSuperSpiceView::OnEditUtilitiesRenumberRefDesignators() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();
	
	if(!PCDoc) return;

	PCDoc->RenumberRefDesignators(this);
}

BOOL TCSuperSpiceView::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	pHelpInfo;
	
	AfxGetApp()->WinHelpInternal(0, HELP_CONTENTS);

	return true;
}

void TCSuperSpiceView::OnTestpointsDisplayonWireClick() 
{
	return;
}

void TCSuperSpiceView::OnUpdateTestpointsDisplayOnWireClick(CCmdUI* pCmdUI) 
{
	pCmdUI;
	return;
}

void TCSuperSpiceView::OnTestpointsWireOncliCkTestPointSetup() 
{
	TCTestPointDlg CComponentProperties;
	TCSchematicObjectData CSchematicObjectData;

	CSchematicObjectData.CPinListData.SetSize(1);// quick fix, look at later
	CSchematicObjectData.CPinListData[0].CLabelListData.SetSize(E_NUM_PIN_LABELS);

	CSchematicObjectData.version = (short) GCSuperSpiceGlobalData.CConfigData.CTestPointData.new_type;

	CComponentProperties.CSchematicObjectData = CSchematicObjectData;

	if(CComponentProperties.DoModal() != IDOK) return;

	CSchematicObjectData = CComponentProperties.CSchematicObjectData;

	GCSuperSpiceGlobalData.CConfigData.CTestPointData.update_graph_views = true;
	GCSuperSpiceGlobalData.CConfigData.CTestPointData.new_type = CSchematicObjectData.version;
	GCSuperSpiceGlobalData.CConfigData.CTestPointData.old_type = CSchematicObjectData.version;
}

void TCSuperSpiceView::OnWaveformsTrantofreqFFT() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	m_current_waveform_type = E_SPICE_RECORD_TIME_TO_FREQ_FFT;

	int index = E_SPICE_RECORD_TIME_TO_FREQ_FFT;

	if(index < 0) return;

	CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(PCDoc->GetOutputWaveformData()->CRecords[index].CHeader);	
}

void TCSuperSpiceView::OnUpdateWaveformsTrantofreqFFT(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = (TCSuperSpiceDoc *)GetDocument();

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	pCmdUI->Enable(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_TIME_TO_FREQ_FFT));	
}


void TCSuperSpiceView::OnWaveformsActotimedomainFFT() 
{
	TCSuperSpiceDoc *PCDoc = (TCSuperSpiceDoc *)GetDocument();

	m_current_waveform_type = E_SPICE_RECORD_FREQ_TO_TIME_FFT;

	int index = E_SPICE_RECORD_FREQ_TO_TIME_FFT;

	if(index < 0) return;

	CSuperSpiceViewData.PCMSchematicManager->UpdateWaveforms(PCDoc->GetOutputWaveformData()->CRecords[index].CHeader);	
}


void TCSuperSpiceView::OnUpdateWaveformsActotimedomainFFT(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = (TCSuperSpiceDoc *)GetDocument();

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	pCmdUI->Enable(PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_FREQ_TO_TIME_FFT));	
}

void TCSuperSpiceView::OnWaveformsCalculatefftifftdata() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = (TCSuperSpiceDoc *)GetDocument();

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	BeginWaitCursor();

	PCDoc->CMSuperSpiceDocData.CWaveformDataRuns.ComputeFFTs();

	EndWaitCursor();
}

void TCSuperSpiceView::OnUpdateWaveformsCalculatefftifftdata(CCmdUI* pCmdUI) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = (TCSuperSpiceDoc *)GetDocument();

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	TCOutputWaveformData *PCOutputWaveformData = PCDoc->GetOutputWaveformData();

	if(!PCOutputWaveformData) return;

	bool flag = PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_AC) | 
		        PCDoc->GetOutputWaveformData()->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT);

	pCmdUI->Enable(flag);	

}

void TCSuperSpiceView::OnViewFantasticFilter() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSuperSpiceDoc *PCDoc = (TCSuperSpiceDoc *)GetDocument();
	
	CSuperSpiceViewData.system_state = PCDoc->OnViewFantasticFilter(this,  CSuperSpiceViewData.page_id, 0, CSuperSpiceViewData.CLastLBDownMousePosition);
}


void TCSuperSpiceView::OnEditRubberbanding() 
{
	GCSuperSpiceGlobalData.CDrawData.is_rubber_band_on =!GCSuperSpiceGlobalData.CDrawData.is_rubber_band_on;
}

void TCSuperSpiceView::OnUpdateEditRubberbanding(CCmdUI* pCmdUI) 
{	
	pCmdUI->SetCheck(GCSuperSpiceGlobalData.CDrawData.is_rubber_band_on);

	pCmdUI->ContinueRouting();	
}

void TCSuperSpiceView::OnComponentsTransformersDual() 
{
	GetComponent(E_TRANSFORMER_DUAL);	
}

void TCSuperSpiceView::OnComponentsTransformersTriple() 
{
	GetComponent(E_TRANSFORMER_TRIPLE);
}

void TCSuperSpiceView::OnComponentsTransformersQuad() 
{
	GetComponent(E_TRANSFORMER_QUAD);	
}

void TCSuperSpiceView::OnComponentsTransformersSingleCentertap() 
{
	GetComponent(E_TRANSFORMER_SINGLE_CENTERTAPED);	
}

void TCSuperSpiceView::OnComponentsTransformersDualCentertaped() 
{
	GetComponent(E_TRANSFORMER_DUAL_CENTERTAPED);	
}

void TCSuperSpiceView::OnComponentsTransformersTripleCentertaped() 
{
	GetComponent(E_TRANSFORMER_TRIPLE_CENTERTAPED);	
}

void TCSuperSpiceView::OnComponentsTransformersQuadCentertaped() 
{
	GetComponent(E_TRANSFORMER_QUAD_CENTERTAPED);	
}

void TCSuperSpiceView::OnComponentsTubeDiode() 
{
	GetComponent(E_TUBE_DIODE_SINGLE);	
}

void TCSuperSpiceView::OnComponentsTubediodeseperatecathodes() 
{
	GetComponent(E_TUBE_DIODE_DUAL_INDIVIDUAL_CATHODES);	
}

void TCSuperSpiceView::OnComponentsTubedualdiodecommonk() 
{
	GetComponent(E_TUBE_DIODE_DUAL_COMMON_CATHODE);	
}

void TCSuperSpiceView::OnComponentsThermistor() 
{
	GetComponent(E_SPICE_THERMISTOR);	
}

void TCSuperSpiceView::OnComponentsMorecomponentsVaristorMov() 
{
	GetComponent(E_VARISTOR_MOV);	
}

void TCSuperSpiceView::OnComponentsMorecomponentsTransformersTubeoutputtransformer() 
{
	GetComponent(E_TRANSFORMER_TUBE_OUTPUT);	
}

void TCSuperSpiceView::OnComponentsMorecomponentsTransformersFlybacktripletransformer() 
{
	GetComponent(E_TRANSFORMER_FLYBACK_TRIPLE);	
}

void TCSuperSpiceView::OnComponentsFuse() 
{
	GetComponent(E_COMPONENT_FUSE);		
}

void TCSuperSpiceView::OnComponentsCrystal() 
{
	GetComponent(E_FREQUENCY_CRYSTAL);		
}

void TCSuperSpiceView::OnFilePcbNetlistsGeneric() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	

	PCDoc->CreatePCBNetlist(E_PCB_FORMATS_GENERIC);	
}

void TCSuperSpiceView::OnViewPcbNetlist() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc->OnViewDisplayPCBNetlist(this);	
}

void TCSuperSpiceView::OnFilePcbnetlistsOrcad() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	PCDoc->CreatePCBNetlist(E_PCB_FORMATS_ORCAD);
}

void TCSuperSpiceView::OnFilePcbnetlistsCreateProtel() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	

	PCDoc->CreatePCBNetlist(E_PCB_FORMATS_PROTEL);	
}

void TCSuperSpiceView::OnFilePcbnetlistsCreateTango() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	PCDoc->CreatePCBNetlist(E_PCB_FORMATS_TANGO);	
}

void TCSuperSpiceView::OnFilePcbnetlistsPclogic() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	

	PCDoc->CreatePCBNetlist(E_PCB_FORMATS_PCLOGIC);		
}

void TCSuperSpiceView::OnFilePcbnetlistsCreateeagle() 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	

	PCDoc->CreatePCBNetlist(E_PCB_FORMATS_EAGLE);	
}

void TCSuperSpiceView::OnComponentsMorecomponentsTransformersInductorCored() 
{
	GetComponent(E_INDUCTOR_COMPONENT_CORED);
}

void TCSuperSpiceView::OnComponentsMorecomponentsTubesvalvesTriodetubewithheater() 
{
	GetComponent(E_TRIODE_VALVE_HEATER);	
}

void TCSuperSpiceView::OnComponentsMorecomponentsTubesvalvesPentodetubewithheater() 
{
	GetComponent(E_PENTODE_VALVE_HEATER);	
}

void TCSuperSpiceView::OnComponentsMorecomponentsTubesvalvesTetrodetubewithheater() 
{
	GetComponent(E_TETRODE_VALVE_HEATER);	
}

void TCSuperSpiceView::OnComponentsMorecomponentsTubesvalvesTubediodecc() 
{
	GetComponent(E_TUBE_DIODE_DUAL_COMMON_CATHODE_HEATER);	
}

void TCSuperSpiceView::OnComponentsMorecomponentsTubesvalvesTubediodeseperatecathodes() 
{
	GetComponent(E_TUBE_DIODE_DUAL_INDIVIDUAL_CATHODES_HEATER);	
}

void TCSuperSpiceView::OnComponentsMorecomponentsTubesvalvesTubediodewithheater() 
{
	GetComponent(E_TUBE_DIODE_SINGLE_HEATER);	
}

void TCSuperSpiceView::OnComponentsMorecomponentsMoter() 
{
	GetComponent(E_MOTER);	
}

void TCSuperSpiceView::OnComponentsMorecomponentsMoterwithtacho() 
{
	GetComponent(E_MOTER_TACHO);		
}

void TCSuperSpiceView::OnComponentsMorecomponentsFloresentlampccfl() 
{
	GetComponent(E_CCFL);		
}

void TCSuperSpiceView::OnComponentsMorecomponentsTubesvalvesTubedual() 
{
	GetComponent(E_TRIODE_VALVE_DUAL);	
}

void TCSuperSpiceView::OnComponentsMorecomponentsTubesvalvesTubedualwithheater() 
{
	GetComponent(E_TRIODE_VALVE_DUAL_HEATER);	
}

void TCSuperSpiceView::OnComponentsMorecomponentsTubesvalvesTube8pin() 
{
	GetComponent(E_TUBE_8PIN);	
}

void TCSuperSpiceView::OnComponentsTitleblock() 
{
	GetComponent(E_TITLE_BLOCK);	
}

void TCSuperSpiceView::OnComponentsMorecomponentsTubesvalvesTubetriodecathodeheater() 
{
	GetComponent(E_TUBE_TRIODE_COMMON_CATHODE_HEATER);
}

void TCSuperSpiceView::OnComponentsMorecomponentsTubesvalvesTubedualdiodecathodeheater() 
{
	GetComponent(E_TUBE_DIODE_DUAL_CATHODE_HEATER);
}

void TCSuperSpiceView::OnComponentsMorecomponentsTubesvalvesTubediodecathodeheater() 
{
	GetComponent(E_TUBE_TRIODE_COMMON_CATHODE_HEATER);
}

void TCSuperSpiceView::OnPopupProperties() 
{
	OnLButtonDblClk(0, CSuperSpiceViewData.CLastMousePosition);
}

void TCSuperSpiceView::OnPopupChangewavecolour() 
{
	TCSuperSpiceDoc* PCDoc = (TCSuperSpiceDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc->ChangeWaveformColour(this);
}

void TCSuperSpiceView::OnPopUpClearAllWaveforms() 
{
	TCSuperSpiceDoc* PCDoc = (TCSuperSpiceDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc->ClearAllWaveforms(this);
}

void TCSuperSpiceView::OnDrawDrawGrid(void)
{
	GCSuperSpiceGlobalData.CDrawData.is_grid_display_on = !GCSuperSpiceGlobalData.CDrawData.is_grid_display_on;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc->OnViewDrawAll(this, CSuperSpiceViewData.PCMSchematicManager);
}

void TCSuperSpiceView::OnUpdateOnDrawDrawGrid(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck(GCSuperSpiceGlobalData.CDrawData.is_grid_display_on);
}

void TCSuperSpiceView::OnDrawDrawPageBorder(void)
{
	GCSuperSpiceGlobalData.CDrawData.draw_schematic_page_border = !GCSuperSpiceGlobalData.CDrawData.draw_schematic_page_border;

	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc->OnViewDrawAll(this, CSuperSpiceViewData.PCMSchematicManager);
}

void TCSuperSpiceView::OnUpdateDrawDrawPageBorder(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck(GCSuperSpiceGlobalData.CDrawData.draw_schematic_page_border);
}


void TCSuperSpiceView::OnUpdateAxisAutoscale(CCmdUI* pCmdUI) 
{
	TCSuperSpiceDoc* PCDoc = (TCSuperSpiceDoc *) GetDocument();
	
	if(!PCDoc) return;

	OnUpdatePopupClearallwaveforms(pCmdUI);
}

void TCSuperSpiceView::OnUpdatePopupClearallwaveforms(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(false);

	TCSuperSpiceDoc* PCDoc = (TCSuperSpiceDoc *) GetDocument();
	
	if(!PCDoc) return;
	
	if(!CSuperSpiceViewData.PCMSchematicManager->PCMLastOutlinedComponent) return;

	if(CSuperSpiceViewData.PCMSchematicManager->PCMLastOutlinedComponent->m_type != E_WAVEFORM_COMPONENT) return;

	pCmdUI->Enable(true);	
}

void TCSuperSpiceView::OnUpdatePopupChangewavecolour(CCmdUI* pCmdUI) 
{	
	pCmdUI->Enable(false);

	TCSuperSpiceDoc* PCDoc = (TCSuperSpiceDoc *) GetDocument();
	
	if(!PCDoc) return;
	
	if(!CSuperSpiceViewData.PCMSchematicManager->PCMLastOutlinedComponent) return;

	if(CSuperSpiceViewData.PCMSchematicManager->PCMLastOutlinedComponent->m_type != E_WAVEFORM_COMPONENT) return;

	pCmdUI->Enable(true);
}

void TCSuperSpiceView::OnPopupChangeGraphBKGColour(void) 
{
	TCSuperSpiceDoc* PCDoc = (TCSuperSpiceDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc->ChangeGraphBKGColour(this);
}

void TCSuperSpiceView::OnUpdateViewDecend(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(false);

	TCSuperSpiceDoc* PCDoc = (TCSuperSpiceDoc *) GetDocument();
	
	if(!PCDoc) return;
	
	if(!CSuperSpiceViewData.PCMSchematicManager->PCMLastOutlinedComponent) return;

	int attached_model_type = CSuperSpiceViewData.PCMSchematicManager->PCMLastOutlinedComponent->CMSchematicObjectData.attached_model_type;

	if(attached_model_type != E_SPICE_SCHEMATIC) return;

	pCmdUI->Enable(true);
}

void TCSuperSpiceView::OnFileReportsDcoperatingpoint() 
{
	TCSuperSpiceDoc* PCDoc = (TCSuperSpiceDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	
	
	PCDoc->OnFileReportsDcoperatingpoint();
}

void TCSuperSpiceView::OnViewReportsDcoperatingpoint() 
{
	TCSuperSpiceDoc* PCDoc = (TCSuperSpiceDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	
	
	PCDoc->OnViewReportsDcoperatingpoint();	
}

void TCSuperSpiceView::OnFileReportsDcsweep() 
{
	TCSuperSpiceDoc* PCDoc = (TCSuperSpiceDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;
	
	PCDoc->OnFileReportsDcsweep();	
}

void TCSuperSpiceView::OnViewReportsDcsweep() 
{
	TCSuperSpiceDoc* PCDoc = (TCSuperSpiceDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	PCDoc->OnViewReportsDcsweep();	
}

void TCSuperSpiceView::OnFileReportsNoise() 
{
	TCSuperSpiceDoc* PCDoc = (TCSuperSpiceDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;
	
	PCDoc->OnFileReportsNoise();	
}

void TCSuperSpiceView::OnViewReportsNoise() 
{
	TCSuperSpiceDoc* PCDoc = (TCSuperSpiceDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	PCDoc->OnViewReportsNoise();	
}

void TCSuperSpiceView::OnRunEnableloopgain() 
{
	TCSuperSpiceDoc* PCDoc = (TCSuperSpiceDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] == 1)
		CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] = 2;
	else 
		CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] = 1;
}

void TCSuperSpiceView::OnUpdateRunEnableloopgain(CCmdUI* pCmdUI) 
{
	TCSuperSpiceDoc *PCDoc = GetDocument();

	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.CReserved.CIntArray[E_AC_ANALYSIS_RESERVED_LOOPGAIN_SOURCE] == 1)
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);

	pCmdUI->ContinueRouting();	
}

void TCSuperSpiceView::OnFileReportsAcsweep() 
{
	TCSuperSpiceDoc* PCDoc = (TCSuperSpiceDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;
	
	PCDoc->OnFileReportsAcsweep();	
}

void TCSuperSpiceView::OnViewReportsAcsweep() 
{
	TCSuperSpiceDoc* PCDoc = (TCSuperSpiceDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;

	
	
	PCDoc->OnViewReportsAcsweep();	
}

void TCSuperSpiceView::OnRunTerminatexspiceengine() 
{
	TCSuperSpiceDoc* PCDoc = (TCSuperSpiceDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc = PCDoc->GetTopLevelDoc();

	if(!PCDoc) return;	

	

	PCDoc->OnRunExitEngine();
}

void TCSuperSpiceView::OnGraphProbeMode() 
{
	GCSuperSpiceGlobalData.CDrawData.probe_mode = !GCSuperSpiceGlobalData.CDrawData.probe_mode;
}

void TCSuperSpiceView::OnUpdateGraphProbeMode(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(GCSuperSpiceGlobalData.CDrawData.probe_mode);
}

void TCSuperSpiceView::OnEditFindOnSchematic() 
{
	TCSuperSpiceDoc* PCDoc = (TCSuperSpiceDoc *) GetDocument();
	
	if(!PCDoc) return;
	
	PCDoc->OnEditFindOnSchematic(this);
}

void TCSuperSpiceView::OnEditUndelete() 
{
	TCSuperSpiceDoc* PCDoc = (TCSuperSpiceDoc *) GetDocument();
	
	if(!PCDoc) return;
	
	PCDoc->OnViewUndelete(this);	
}

void TCSuperSpiceView::OnUpdateEditUndelete(CCmdUI* pCmdUI) 
{
	if(CSuperSpiceViewData.PCMSchematicManager->CMGraphicDeleteList.GetSize()) pCmdUI->Enable(true);
	else pCmdUI->Enable(false);
}


