// TCSuperSpiceView.h : interface of the TCSuperSpiceView class
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _TCSUPERSPICE_VIEW_H 
#define _TCSUPERSPICE_VIEW_H 

#include "TESuperSpiceEnums.h"

class TCSuperSpiceContorItem;
class TCSchematicManager;
class TCSuperSpiceDoc;
class TCSymbolEditorDoc;

class TCSuperSpiceViewData : public CObject
{
	public:
				TCSuperSpiceViewData(void);
				TCSuperSpiceViewData(TCSuperSpiceViewData &CSuperSpiceViewData);
				~TCSuperSpiceViewData(void);

				CPoint								CLastMousePosition;
				int									page_id;
				CString								CPageName;
				TE_GRAPHICS_MANAGER_SYSTEM_STATE	system_state;
				TCSchematicManager					*PCMSchematicManager;

				CSize	CMaxSize;
				CSize	CPageSize;
				CSize	CLineSize;
				CPoint	CViewPortOrigin;
				CPoint  CScrollBarPosition;
				CPoint  CLastLBDownMousePosition;

				void operator = (TCSuperSpiceViewData &SuperSpiceViewData);

				void Serialize(CArchive& CArchiveFile);

			 DECLARE_SERIAL(TCSuperSpiceViewData)

} ;


class TCSuperSpiceView : public CScrollView
{


	
	
protected: // create from serialization only
	afx_msg void OnContextMenu(CWnd*, CPoint point);
	TCSuperSpiceView();
	DECLARE_DYNCREATE(TCSuperSpiceView)

// Attributes
public:  
	
		TCSuperSpiceViewData CSuperSpiceViewData;	

	HCURSOR m_hcursor;
	int m_current_waveform_type;
	bool m_is_dragging;

	int		GetPageId(void);
	void	SetPageId(int page_id);
	CPoint	GetScrollBarPosition(void);
	void	SetScrollBarPosition(CPoint CScrollBarPosition);
	CPoint	GetViewPortOrigin(void);
	CSize	&GetViewSize(void);
	void	SetViewSize(CSize &CViewSize);
	void	SetScrollSizesZoomed(float zoom);

	friend class TCSuperSpiceTextView;
	friend class TCOutputWaveformView;
	friend class TCSuperSpiceDoc;
	friend class TCSymbolEditorDoc;
	friend class TCOutputWaveformDoc;

	TCSchematicManager *GetSchematicManager(void);
	void SetSchematicManager(TCSchematicManager *PCSchematicManager);
	void SetState(TE_GRAPHICS_MANAGER_SYSTEM_STATE sys_state);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE GetState(void);
	TCSuperSpiceViewData &GetData(void);
	void SetData(TCSuperSpiceViewData &SuperSpiceViewData);

	void IdleOnCancel(void);				// wrong way round in naming !!
	void GraphicsSelectedOnCancel(void);
	void GraphicsMovingOnCancel(void);	
	void SelectRegionOnCancel(void);
	void GotGraphicOnCancel(void);
	void GotClipboardOnCancel(void);
	void DrawingWireOnCancel(void);
	void WaitingToDrawWireOnCancel(void);

	void GetComponent(int graphic_id, short version = 0);

	void IdleGetGraphic(int graphic_id = 0, short version = 0);
	void GraphicsSelectedGetGraphic(int graphic_id = 0, short version = 0);
	void GraphicsMovingGetGraphic(int graphic_id = 0, short version = 0);	
	void SelectRegionGetGraphic(int graphic_id = 0, short version = 0);		 
	void GotGraphicGetGraphic(int graphic_id = 0, short version = 0);
	void GotClipboardGetGraphic(int graphic_id = 0, short version = 0);
	void DrawingWireGetGraphic(int graphic_id = 0, short version = 0);
	void WaitingToDrawWireGetGraphic(int graphic_id = 0, short version = 0);

	void IdleDrawWire();
	void GraphicsSelectedDrawWire();
	void GraphicsMovingDrawWire();	
	void SelectRegionDrawWire();		 
	void GotGraphicDrawWire();
	void GotClipboardDrawWire();
	void DrawingWireDrawWire();
	void WaitingToDrawWireDrawWire();


	void IdleLBDown(UINT nFlags, CPoint CMousePosition);
	void GraphicsSelectedLBDown(UINT nFlags, CPoint CMousePosition);
	void GraphicsMovingLBDown(UINT nFlags, CPoint CMousePosition);
	void SelectRegionLBDown(UINT nFlags, CPoint CMousePosition);
	void GotGraphicLBDown(UINT nFlags, CPoint CMousePosition);
	void GotClipboardLBDown(UINT nFlags, CPoint CMousePosition);
	void DrawingWireLBDown(UINT nFlags, CPoint CMousePosition);
	void WaitingToDrawWireLBDown(UINT nFlags, CPoint CMousePosition);
	void SizingWaveformWindowLBDown(UINT nFlags, CPoint CMousePosition);

	void IdleLBUp(UINT nFlags, CPoint CMousePosition);
	void GraphicsSelectedLBUp(UINT nFlags, CPoint CMousePosition);
	void GraphicsMovingLBUp(UINT nFlags, CPoint CMousePosition);
	void SelectRegionLBUp(UINT nFlags, CPoint CMousePosition);
	void GotGraphicLBUp(UINT nFlags, CPoint CMousePosition);
	void GotClipboardLBUp(UINT nFlags, CPoint CMousePosition);
	void DrawingWireLBUp(UINT nFlags, CPoint CMousePosition);
	void WaitingToDrawWireLBUp(UINT nFlags, CPoint CMousePosition);
	void SizingWaveformWindowLBUp(UINT nFlags, CPoint CMousePosition);

	void IdleMouseMoved(UINT nFlags, CPoint CMousePosition);
	void GraphicsSelectedMouseMoved(UINT nFlags, CPoint CMousePosition);
	void GraphicsMovingMouseMoved(UINT nFlags, CPoint CMousePosition);
	void SelectRegionMouseMoved(UINT nFlags, CPoint CMousePosition);	
	void GotGraphicMouseMoved(UINT nFlags, CPoint CMousePosition);
	void GotClipboardMouseMoved(UINT nFlags, CPoint CMousePosition);
	void DrawingWireMouseMoved(UINT nFlags, CPoint CMousePosition);
	void WaitingToDrawWireMouseMoved(UINT nFlags, CPoint CMousePosition);
	void SizingWaveformWindowMouseMoved(UINT nFlags, CPoint CMousePosition);
	
	void WaveformOnClickLBDown(UINT nFlags, CPoint CMousePosition);



	virtual BOOL PreTranslateMessage(MSG* pMsg);
	TCSuperSpiceDoc* GetDocument();
	// m_pSelection holds the selection to the current TCSuperSpiceContorItem.
	// For many applications, such a member variable isn't adequate to
	//  represent a selection, such as a multiple selection or a selection
	//  of objects that are not TCSuperSpiceContorItem objects.  This selection
	//  mechanism is provided just to help you get started.

	// TODO: replace this selection mechanism with one appropriate to your app.
	TCSuperSpiceContorItem* m_pSelection;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(TCSuperSpiceView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual void OnInitialUpdate(); // called first time after construct
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual BOOL IsSelected(const CObject* pDocItem) const;// Container support
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~TCSuperSpiceView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(TCSuperSpiceView)
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnInsertObject();
	afx_msg void OnCancelEditCntr();
	afx_msg void OnCancelEditSrvr();
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnWindowNew();
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnPagesOpenpage();
	afx_msg void OnPagesDeletePage();
	afx_msg void OnPagesNewPage();
	afx_msg void OnDestroy();
	afx_msg void OnPagesCopyPage();
	afx_msg void OnEditCopy();
	afx_msg void OnEditCut();
	afx_msg void OnEditDelete();
	afx_msg void OnEditSelectAll();
	afx_msg void OnCancelCommand();
	afx_msg void OnEditPaste1();
	afx_msg void OnEditCopyWithPaste();
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnGetNpn();
	afx_msg void OnGetPnp();
	afx_msg void OnGetCapacitor();
	afx_msg void OnGetDiode();
	afx_msg void OnGetInductor();
	afx_msg void OnGetNmos();
	afx_msg void OnGetPmos();
	afx_msg void OnGetResistor();
	afx_msg void OnSpiceViewProperties();
	afx_msg void OnViewOutputGraph();
	afx_msg void OnViewOutputText();
	afx_msg void OnViewInputSpiceText();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnDrawWire();
	afx_msg void OnDrawBus();
	afx_msg void OnDrawingZoomIn();
	afx_msg void OnUpdateDrawingZoomIn(CCmdUI* pCmdUI);
	afx_msg void OnDrawingZoomOut();
	afx_msg void OnUpdateDrawingZoomOut(CCmdUI* pCmdUI);
	afx_msg void OnDrawingZoomCenter();
	afx_msg void OnAddUserText();
	afx_msg void OnOptionsSchematic();
	afx_msg void OnDrawingRotate();
	afx_msg void OnDrawingMirror();
	afx_msg void OnDrawingFlip();
	afx_msg void OnGetOpAmp();
	afx_msg void OnGetVoltageSource();
	afx_msg void OnGetCurrentSource();
	afx_msg void OnComponentsOpenComponentLibary();
	afx_msg void OnComponentsDrawZener();
	afx_msg void OnTestpointsDrawVoltage();
	afx_msg void OnComponentsDrawVCVS();
	afx_msg void OnComponentsVCIS();
	afx_msg void OnComponentsNJFet();
	afx_msg void OnComponentsPJFet();
	afx_msg void OnComponentsGround();
	afx_msg void OnComponentsMorecomponentsDrawShottky();
	afx_msg void OnComponentsMorecomponentsDrawThyresistor();
	afx_msg void OnComponentsDrawDiac();
	afx_msg void OnComponentsDrawGTOTriac();
	afx_msg void OnComponentsMorecomponentsDrawtTransformer();
	afx_msg void OnComponentsMorecomponentsDrawTransmissionLine();
	afx_msg void OnComponentsMorecomponentsDrawTriac();
	afx_msg void OnComponentsMorecomponentsDrawVCSwitch();
	afx_msg void OnComponentsMorecomponentsDualGateMosfet();
	afx_msg void OnComponentsIGBP();
	afx_msg void OnComponentsMorecomponentsDualGatePMosfet();
	afx_msg void OnComponentsFilter();
	afx_msg void OnComponentsGeneric2Pin();
	afx_msg void OnComponentsGeneric3Pin();
	afx_msg void OnComponentsGeneric4Pin();
	afx_msg void OnComponentsGeneric5Pin();
	afx_msg void OnComponentsGeneric6Pin();
	afx_msg void OnComponentsGeneric7Pin();
	afx_msg void OnComponentsGeneric8Pin();
	afx_msg void OnComponentsGeneric10Pin();
	afx_msg void OnComponentsGeneric11Pin();
	afx_msg void OnComponentsGeneric12Pin();
	afx_msg void OnComponentsGeneric13Pin();
	afx_msg void OnComponentsGeneric14Pin();
	afx_msg void OnComponentsGeneric15Pin();
	afx_msg void OnComponentsGeneric16Pin();
	afx_msg void OnComponentsGeneric9Pin();
	afx_msg void OnComponentsIGBPPNP();
	afx_msg void OnComponentsNmos4Terminal();
	afx_msg void OnComponentsNpn4Terminal();
	afx_msg void OnComponentsPmos4Terminal();
	afx_msg void OnComponentsPnp4Terminal();
	afx_msg void OnComponentsBuffer();
	afx_msg void OnComponentsVCA();
	afx_msg void OnComponentsNJFET4Terminal();
	afx_msg void OnComponentsPJFET4Terminal();
	afx_msg void OnComponentsUJunction();
	afx_msg void OnComponentsGeneric2InputAmp();
	afx_msg void OnComponentsSolderBlob();
	afx_msg void OnUpdateOleInsertNew(CCmdUI* pCmdUI);
	afx_msg void OnArowUp();
	afx_msg void OnArrowDown();
	afx_msg void OnArrowLeft();
	afx_msg void OnArrowRight();
	afx_msg void OnPageDown();
	afx_msg void OnPageUp();
	afx_msg void OnDrawWireImmediatly();
	afx_msg void OnPropertyAccelerater();
	afx_msg void OnTestGraphic();
	afx_msg void OnSimulationSetup();
	afx_msg void OnUpdateRunAc(CCmdUI* pCmdUI);
	afx_msg void OnRunAc();
	afx_msg void OnRunDc();
	afx_msg void OnUpdateRunDc(CCmdUI* pCmdUI);
	afx_msg void OnRunEnableNoise();
	afx_msg void OnUpdateRunEnableNoise(CCmdUI* pCmdUI);
	afx_msg void OnRunTransient();
	afx_msg void OnUpdateRunTransient(CCmdUI* pCmdUI);
	afx_msg void OnRunEnableFourier();
	afx_msg void OnUpdateRunEnableFourier(CCmdUI* pCmdUI);
	afx_msg void OnRunStatistics();
	afx_msg void OnUpdateRunStatistics(CCmdUI* pCmdUI);
	afx_msg void OnRunParametric();
	afx_msg void OnUpdateRunParametric(CCmdUI* pCmdUI);
	afx_msg void OnRunTemperature();
	afx_msg void OnUpdateRunTemperature(CCmdUI* pCmdUI);
	afx_msg void OnRunSensitivity();
	afx_msg void OnUpdateRunSensitivity(CCmdUI* pCmdUI);
	afx_msg void OnRunEnablePoleZero();
	afx_msg void OnUpdateRunEnablePoleZero(CCmdUI* pCmdUI);
	afx_msg void OnRunEnableDistortion();
	afx_msg void OnUpdateRunEnableDistortion(CCmdUI* pCmdUI);
	afx_msg void OnRunUpdateNetNames();
	afx_msg void OnViewIncludeFile();
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnGeneratorsAccurrentsource();
	afx_msg void OnGeneratorsAcsource();
	afx_msg void OnGeneratorsDccurrentsource();
	afx_msg void OnGeneratorsDcsource();
	afx_msg void OnGeneratorsExponentialcurrentsource();
	afx_msg void OnGeneratorsExponentialsource();
	afx_msg void OnGeneratorsPiecewiselinearsource();
	afx_msg void OnGeneratorsPulse();
	afx_msg void OnGeneratorsPulsecurrentsource();
	afx_msg void OnGeneratorsSinglefrequencyfmcurrentsource();
	afx_msg void OnGeneratorsSinglefrequencyfmsource();
	afx_msg void OnTestpointsCurrent();
	afx_msg void OnTestpointsCurrentmagnitudedb();
	afx_msg void OnTestpointsCurrentphase();
	afx_msg void OnTestpointsVoltagemagnitudedb();
	afx_msg void OnTestpointsVoltagephase();
	afx_msg void OnGeneratorsPiecewiselinearcurrentsource();
	afx_msg void OnViewDcVoltages();
	afx_msg void OnViewNetNames();
	afx_msg void OnUpdateViewDcVoltages(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewNetNames(CCmdUI* pCmdUI);
	afx_msg void OnViewDcCurrents();
	afx_msg void OnUpdateViewDcCurrents(CCmdUI* pCmdUI);
	afx_msg void OnGetNGasFet4Terminal();
	afx_msg void OnGetNGasFet();
	afx_msg void OnGetPGasFet();
	afx_msg void OnOnGetPGasFet4Terminal();
	afx_msg void OnGetIcCapacitor();
	afx_msg void OnGetIcResistor();
	afx_msg void OnConnectionPointInput();
	afx_msg void OnConnectionPointOutput();
	afx_msg void OnConnectionPointBidirectional();
	afx_msg void OnUpdateComponentsSolderblob(CCmdUI* pCmdUI);
	afx_msg void OnViewIncludedModelsFile();
	afx_msg void OnViewDecendSchematic();
	afx_msg void OnViewAccendSchematic();
	afx_msg void OnUpdateViewAccendSchematic(CCmdUI* pCmdUI);
	afx_msg void OnComponentsSubcircuitConnector();
	afx_msg void OnRunReruns();
	afx_msg void OnUpdateRunReruns(CCmdUI* pCmdUI);
	afx_msg void OnRunRun();
	afx_msg void OnRunRunSameNetList();
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	afx_msg void OnWindowNewGraph();
	afx_msg void OnFilePrintPreview();
	afx_msg void OnGraphicsPlaceNewGraph();
	afx_msg void OnWaveformsDisplayacwaveform();
	afx_msg void OnUpdateWaveformsDisplayacwaveform(CCmdUI* pCmdUI);
	afx_msg void OnWaveformsDisplaydcwaveform();
	afx_msg void OnUpdateWaveformsDisplaydcwaveform(CCmdUI* pCmdUI);
	afx_msg void OnWaveformsDisplayfourierwaveform();
	afx_msg void OnUpdateWaveformsDisplayfourierwaveform(CCmdUI* pCmdUI);
	afx_msg void OnWaveformsDisplaynoisewaveform();
	afx_msg void OnUpdateWaveformsDisplaynoisewaveform(CCmdUI* pCmdUI);
	afx_msg void OnWaveformsDisplaypolezerowaveform();
	afx_msg void OnUpdateWaveformsDisplaypolezerowaveform(CCmdUI* pCmdUI);
	afx_msg void OnWaveformsDisplaysenswaveform();
	afx_msg void OnWaveformsDisplaytranswaveform();
	afx_msg void OnUpdateWaveformsDisplaytranswaveform(CCmdUI* pCmdUI);
	afx_msg void OnWaveformsDistortion();
	afx_msg void OnUpdateWaveformsDistortion(CCmdUI* pCmdUI);
	afx_msg void OnUpdateWaveformsDisplaysenswaveform(CCmdUI* pCmdUI);
	afx_msg void OnRunEnableOperatingPoint();
	afx_msg void OnUpdateRunEnableOperatingPoint(CCmdUI* pCmdUI);
	afx_msg void OnAxisAutoScale();
	afx_msg void OnAxisMagnify();
	afx_msg void OnAxisReduce();
	afx_msg void OnAxisScrolXLeft();
	afx_msg void OnAxisScrolXRight();
	afx_msg void OnAxisScrollYDown();
	afx_msg void OnAxisScrollYUp();
	afx_msg void OnViewDesignNotes();
	afx_msg void OnEscape();
	afx_msg void OnHelpGetcomputerpassword();
	afx_msg void OnSetupClearErrors();
	afx_msg void OnEditCopyToWindowsClipboard();
	afx_msg void OnComponentsAnalogInvertor();
	afx_msg void OnComponentsAnalogAnd();
	afx_msg void OnComponentsAnalogNand();
	afx_msg void OnComponentsAnalogNor();
	afx_msg void OnComponentsAnalogOr();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void OnRunRunDebugMode();
	afx_msg void OnEditUtilitiesRenumberWires();
	afx_msg void OnEditUtilitiesRenumberRefDesignators();
	afx_msg void OnComponentsMorecomponentsTriodeValveTube();
	afx_msg void OnComponentsMorecomponentsPentodeValveTube();
	afx_msg void OnPopupComponentsMorecomponentsTetrodeValveTube();
	afx_msg void OnComponentsDigitalDtypeBistable();
	afx_msg void OnComponentsDigitalJkBisable();
	afx_msg void OnComponentsDigital8BitCounter();
	afx_msg void OnComponentsAnalogExOr();
	afx_msg void OnComponentsAnalogExNor();
	afx_msg void OnComponentsAnalogSchmittTrigger();
	afx_msg void OnTestpointsDisplayonWireClick();
	afx_msg void OnUpdateTestpointsDisplayOnWireClick(CCmdUI* pCmdUI);
	afx_msg void OnTestpointsWireOncliCkTestPointSetup();
	afx_msg void OnComponentsLdo();
	afx_msg void OnViewSymbolEditor();
	afx_msg void OnEditPaste();
	afx_msg void OnRunSensitivityAc();
	afx_msg void OnUpdateRunSensitivityAc(CCmdUI* pCmdUI);
	afx_msg void OnWaveformsDistortion2();
	afx_msg void OnUpdateWaveformsDistortion2(CCmdUI* pCmdUI);
	afx_msg void OnWaveformsDistortionF2();
	afx_msg void OnUpdateWaveformsDistortionF2(CCmdUI* pCmdUI);
	afx_msg void OnComponentsDigitalInvertor();
	afx_msg void OnComponentsDigitalAnd();
	afx_msg void OnComponentsDigitalNand();
	afx_msg void OnComponentsDigitalNor();
	afx_msg void OnComponentsDigitalOr();
	afx_msg void OnComponentsDigitalExOr();
	afx_msg void OnComponentsDigitalExNor();
	afx_msg void OnComponentsAnalogtoDigitalConverter();
	afx_msg void OnComponentsDigitaltoAnalogConvertor();
	afx_msg void OnComponentsLaplaceTransform();
	afx_msg void OnViewSpiceEngineErrorlog();
	afx_msg void OnComponentsModelLibary();
	afx_msg void OnComponentsDivider();
	afx_msg void OnComponentsNonlinearSource();
	afx_msg void OnWaveformsTrantofreqFFT();
	afx_msg void OnWaveformsActotimedomainFFT();
	afx_msg void OnUpdateWaveformsTrantofreqFFT(CCmdUI* pCmdUI);
	afx_msg void OnUpdateWaveformsActotimedomainFFT(CCmdUI* pCmdUI);
	afx_msg void OnWaveformsCalculatefftifftdata();
	afx_msg void OnViewFantasticFilter();
	afx_msg void OnEditRubberbanding();
	afx_msg void OnUpdateEditRubberbanding(CCmdUI* pCmdUI);
	afx_msg void OnComponentsVariableResistor();
	afx_msg void OnComponentsTransformersDualCentertaped();
	afx_msg void OnComponentsTransformersDual();
	afx_msg void OnComponentsTransformersQuadCentertaped();
	afx_msg void OnComponentsTransformersQuad();
	afx_msg void OnComponentsTransformersSingleCentertap();
	afx_msg void OnComponentsTransformersTripleCentertaped();
	afx_msg void OnComponentsTransformersTriple();
	afx_msg void OnComponentsTubeDiode();
	afx_msg void OnComponentsTubediodeseperatecathodes();
	afx_msg void OnComponentsTubedualdiodecommonk();
	afx_msg void OnComponentsThermistor();
	afx_msg void OnComponentsMorecomponentsVaristorMov();
	afx_msg void OnComponentsMorecomponentsTransformersTubeoutputtransformer();
	afx_msg void OnComponentsMorecomponentsTransformersFlybacktripletransformer();
	afx_msg void OnComponentsFuse();
	afx_msg void OnComponentsCrystal();
	afx_msg void OnFilePcbNetlistsGeneric();
	afx_msg void OnViewPcbNetlist();
	afx_msg void OnFilePcbnetlistsOrcad();
	afx_msg void OnFilePcbnetlistsCreateProtel();
	afx_msg void OnFilePcbnetlistsCreateTango();
	afx_msg void OnFilePcbnetlistsPclogic();
	afx_msg void OnFilePcbnetlistsCreateeagle();
	afx_msg void OnUpdateWaveformsCalculatefftifftdata(CCmdUI* pCmdUI);
	afx_msg void OnComponentsMorecomponentsTransformersInductorCored();
	afx_msg void OnComponentsMorecomponentsTubesvalvesTriodetubewithheater();
	afx_msg void OnComponentsMorecomponentsTubesvalvesPentodetubewithheater();
	afx_msg void OnComponentsMorecomponentsTubesvalvesTetrodetubewithheater();
	afx_msg void OnComponentsMorecomponentsTubesvalvesTubediodecc();
	afx_msg void OnComponentsMorecomponentsTubesvalvesTubediodeseperatecathodes();
	afx_msg void OnComponentsMorecomponentsTubesvalvesTubediodewithheater();
	afx_msg void OnComponentsMorecomponentsMoter();
	afx_msg void OnComponentsMorecomponentsMoterwithtacho();
	afx_msg void OnComponentsMorecomponentsFloresentlampccfl();
	afx_msg void OnComponentsMorecomponentsTubesvalvesTubedual();
	afx_msg void OnComponentsMorecomponentsTubesvalvesTubedualwithheater();
	afx_msg void OnComponentsMorecomponentsTubesvalvesTube8pin();
	afx_msg void OnComponentsTitleblock();
	afx_msg void OnPopupProperties();
	afx_msg void OnPopupChangewavecolour();
	afx_msg void OnPopUpClearAllWaveforms();
	afx_msg void OnComponentsMorecomponentsTubesvalvesTubetriodecathodeheater();
	afx_msg void OnComponentsMorecomponentsTubesvalvesTubediodecathodeheater();
	afx_msg void OnComponentsMorecomponentsTubesvalvesTubedualdiodecathodeheater();
	afx_msg void OnDrawDrawGrid();
	afx_msg void OnUpdateOnDrawDrawGrid(CCmdUI* pCmdUI);
	afx_msg void OnDrawDrawPageBorder(void);
	afx_msg void OnUpdateDrawDrawPageBorder(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAxisAutoscale(CCmdUI* pCmdUI);
	afx_msg void OnUpdatePopupClearallwaveforms(CCmdUI* pCmdUI);
	afx_msg void OnUpdatePopupChangewavecolour(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewDecend(CCmdUI* pCmdUI);
	afx_msg void OnFileReportsDcoperatingpoint();
	afx_msg void OnViewReportsDcoperatingpoint();
	afx_msg void OnFileReportsDcsweep();
	afx_msg void OnViewReportsDcsweep();
	afx_msg void OnFileReportsNoise();
	afx_msg void OnViewReportsNoise();
	afx_msg void OnRunEnableloopgain();
	afx_msg void OnUpdateRunEnableloopgain(CCmdUI* pCmdUI);
	afx_msg void OnFileReportsAcsweep();
	afx_msg void OnViewReportsAcsweep();
	afx_msg void OnPopupChangeGraphBKGColour();
	afx_msg void OnRunTerminatexspiceengine();
	afx_msg void OnGraphProbeMode();
	afx_msg void OnUpdateGraphProbeMode(CCmdUI* pCmdUI);
	afx_msg void OnEditFindOnSchematic();
	afx_msg void OnEditUndelete();
	afx_msg void OnUpdateEditUndelete(CCmdUI* pCmdUI);

	//}}AFX_MSG


	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnRunEnableMonteCarlo();
	afx_msg void OnUpdateRunEnableMonteCarlo(CCmdUI *pCmdUI);
};

#ifndef _DEBUG  // debug version in TCSuperSpiceView.cpp
inline TCSuperSpiceDoc* TCSuperSpiceView::GetDocument()
   { return (TCSuperSpiceDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
#endif
