// TCSwitchLabelsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "tepropertyviewtypes.h"
#include "TESuperSpiceEnums.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCMKSConvert.h"
#include "TCSchematicObjectData.h"
#include "TCSwitchLabelsDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCSwitchLabelsDlg, CPropertyPage)

extern int g_last_active_component_property_page;

/////////////////////////////////////////////////////////////////////////////
// TCSwitchLabelsDlg property page

TCSwitchLabelsDlg::TCSwitchLabelsDlg() : CPropertyPage(TCSwitchLabelsDlg::IDD)
{
	//{{AFX_DATA_INIT(TCSwitchLabelsDlg)
	m_ref_des_visable = FALSE;
	m_spice_name_visable = FALSE;
	m_value_visable = FALSE;
	CMEditSpicename = _T("");
	CMEditRefDes = _T("");
	CMEditValue = _T("");
	m_type_name_visable = FALSE;
	CMEditTypeName = _T("");
	m_check_visable_off = FALSE;
	m_check_visable_on = FALSE;
	m_check_visable_vt = FALSE;
	m_check_visable_hv = FALSE;
	//}}AFX_DATA_INIT

	m_hysterises = 1.0;
	m_roff = 1.0;
	m_ron = 1.0;
	m_threshold = 1.0;
}

TCSwitchLabelsDlg::~TCSwitchLabelsDlg()
{
}

void TCSwitchLabelsDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCSwitchLabelsDlg)
	DDX_Control(pDX, IDC_EDIT_REF_DESIGNATOR, CMEditCntlRefDes);
	DDX_Control(pDX, IDC_EDIT_VALUE, CMEditCntlValue);
	DDX_Control(pDX, IDC_EDIT_TYPE_NAME, CMEditCntlTypeName);
	DDX_Control(pDX, IDC_EDIT_SPICE_NAME, CMEditCntlSpiceName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_REF_DESIGNATOR, m_ref_des_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_SPICE_NAME, m_spice_name_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE, m_value_visable);
	DDX_Text(pDX, IDC_EDIT_SPICE_NAME, CMEditSpicename);
	DDX_Text(pDX, IDC_EDIT_REF_DESIGNATOR, CMEditRefDes);
	DDX_Text(pDX, IDC_EDIT_VALUE, CMEditValue);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TYPE_NAME, m_type_name_visable);
	DDX_Text(pDX, IDC_EDIT_TYPE_NAME, CMEditTypeName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_ROFF, m_check_visable_off);
	DDX_Check(pDX, IDC_CHECK_VISABLE_RON, m_check_visable_on);
	DDX_Check(pDX, IDC_CHECK_VISABLE_THRESHOLD, m_check_visable_vt);
	DDX_Check(pDX, IDC_CHECK_VISABLE_HYSTERISES, m_check_visable_hv);
	DDX_MKSValue(pDX, IDC_EDIT_HYSTERISES, m_hysterises);
	DDX_MKSValue(pDX, IDC_EDIT_ROFF, m_roff);
	DDX_MKSValue(pDX, IDC_EDIT_RON, m_ron);
	DDX_MKSValue(pDX, IDC_EDIT_THRESHOLD, m_threshold);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCSwitchLabelsDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCSwitchLabelsDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



BOOL TCSwitchLabelsDlg::OnKillActive() 
{
	
	CPropertyPage::OnKillActive();

	if(!PCSchematicObjectData) return true;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = !!m_type_name_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = 	CMEditTypeName;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable = !!m_value_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel = CMEditValue;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = !!m_ref_des_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = CMEditRefDes;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = !!m_spice_name_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMEditSpicename;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_VSWITCH_ROFF].is_visable = !!m_check_visable_off;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_VSWITCH_ROFF].CLabelValue = FloatToMKSString(m_ron);
	PCSchematicObjectData->CSpiceParameters.Set("RON", m_ron);

	PCSchematicObjectData->CLabelListData[E_COMPONENT_VSWITCH_RON].is_visable = !!m_check_visable_on;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_VSWITCH_RON].CLabelValue = FloatToMKSString(m_roff);
	PCSchematicObjectData->CSpiceParameters.Set("ROFF", m_roff);

	PCSchematicObjectData->CLabelListData[E_COMPONENT_VSWITCH_VT].CLabelValue = FloatToMKSString(m_threshold);
	PCSchematicObjectData->CLabelListData[E_COMPONENT_VSWITCH_VT].is_visable = !!m_check_visable_vt;
	if(PCSchematicObjectData->component_property_view_type == E_PROPERTY_SWITCH) PCSchematicObjectData->CSpiceParameters.Set("VT", m_threshold);
	else PCSchematicObjectData->CSpiceParameters.Set("IT", m_threshold);
		
	PCSchematicObjectData->CLabelListData[E_COMPONENT_VSWITCH_VH].is_visable = !!m_check_visable_hv;
	
	PCSchematicObjectData->CLabelListData[E_COMPONENT_VSWITCH_VH].CLabelValue = FloatToMKSString(m_hysterises);
	if(PCSchematicObjectData->component_property_view_type == E_PROPERTY_SWITCH) PCSchematicObjectData->CSpiceParameters.Set("VH", m_hysterises);
	else PCSchematicObjectData->CSpiceParameters.Set("IH", m_hysterises);

	PCSchematicObjectData->FormatLabel();

	return true;
}

BOOL TCSwitchLabelsDlg::OnSetActive() 
{
	g_last_active_component_property_page = 0;
	
	CMEditValue	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	PCSchematicObjectData->FormatSpiceName();

	CMEditSpicename	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

	PCSchematicObjectData->CSpiceParameters.Get("RON", &m_ron);

	PCSchematicObjectData->CSpiceParameters.Get("ROFF", &m_roff);

	if(PCSchematicObjectData->component_property_view_type == E_PROPERTY_SWITCH) PCSchematicObjectData->CSpiceParameters.Get("VT", &m_threshold);
	else PCSchematicObjectData->CSpiceParameters.Get("IT", &m_threshold);
			
	if(PCSchematicObjectData->component_property_view_type == E_PROPERTY_SWITCH) PCSchematicObjectData->CSpiceParameters.Get("VH", &m_hysterises);
	else PCSchematicObjectData->CSpiceParameters.Get("IH", &m_hysterises);

	return CPropertyPage::OnSetActive();
}

BOOL TCSwitchLabelsDlg::OnInitDialog() 
{
	 
	m_type_name_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable;
	CMEditTypeName		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel;

	m_value_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable;
	CMEditValue		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	m_ref_des_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable;
	CMEditRefDes		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	m_spice_name_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable;
	CMEditSpicename		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;


	m_check_visable_off = PCSchematicObjectData->CLabelListData[E_COMPONENT_VSWITCH_ROFF].is_visable;
	PCSchematicObjectData->CSpiceParameters.Get("RON", &m_ron);

	m_check_visable_on = PCSchematicObjectData->CLabelListData[E_COMPONENT_VSWITCH_RON].is_visable;
	PCSchematicObjectData->CSpiceParameters.Get("ROFF", &m_roff);

	m_check_visable_vt = PCSchematicObjectData->CLabelListData[E_COMPONENT_VSWITCH_VT].is_visable;

	if(PCSchematicObjectData->component_property_view_type == E_PROPERTY_SWITCH) PCSchematicObjectData->CSpiceParameters.Get("VT", &m_threshold);
	else PCSchematicObjectData->CSpiceParameters.Get("IT", &m_threshold);
		
	m_check_visable_hv = PCSchematicObjectData->CLabelListData[E_COMPONENT_VSWITCH_VH].is_visable;
	
	if(PCSchematicObjectData->component_property_view_type == E_PROPERTY_SWITCH) PCSchematicObjectData->CSpiceParameters.Get("VH", &m_hysterises);
	else PCSchematicObjectData->CSpiceParameters.Get("IH", &m_hysterises);

	CPropertyPage::OnInitDialog();
	
//	CMEditCntlSpiceName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only);
//	CMEditCntlTypeName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only);
	CMEditCntlValue.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].read_only);
	CMEditCntlRefDes.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].read_only);

	return TRUE;  
}
