// TCSymbolEditorDoc.cpp : implementation file
//

#include "stdafx.h"
#include "superspice.h"
#include "TCSymbolEditorDoc.h"
#include "stdafx.h"
#include "SuperSpice.h"
#include "resource.h"
#include "Generic.h"
#include "TCMKSConvert.h"
#include "TEPropertyViewTypes.h"
#include "TESuperSpiceMsgStringsEnums.h"
#include "TESuperSpiceOpionsEnums.h"
#include "TCStringFunctions.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCSuperSpiceClipboard.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSchematicManager.h"
#include "TCSuperSpiceDoc.h"
#include "TCSymEdPinDlg.h"
#include "TCWireLableDlg.h"
#include "TCComponentText.h"
#include "TCReferanceDesignator.h"
#include "TCSuperSpiceSchematicProperty.h"
#include "TCMasterSymbolDlg.h"
#include "TCSymbolEditorPinsDlg.h"
#include "TCSymEdPinStart.h"
#include "TCGeneralReportsTab.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

TCSuperSpiceClipboard GCSymbolEditorClipboard;

extern TCSuperSpiceDataBase GCSuperSpiceDataBase;
extern TCSuperSpiceGlobalData GCSuperSpiceGlobalData;
extern TCMultyTaskedString CGlobalStatusMessage;
extern CPoint GlobalMouseOffset;
extern CDC GlobalCDCTemp;
extern int g_last_active_program_options_page;
extern TCGeneralReportsTab GCGeneralReportsTab;


CString FloatToSpiceMKSString(double);
/////////////////////////////////////////////////////////////////////////////
// TCSymbolEditorDoc

IMPLEMENT_DYNCREATE(TCSymbolEditorDoc, CDocument)

TCSymbolEditorDoc::TCSymbolEditorDoc()
{
	PCParentSuperSpiceDoc = NULL;

	s_window_placment = GetDefaultWindowPlacment();
	m_attached_model_type = E_SPICE_DOT_SUBCIRCUIT;

	GCSymbolEditorClipboard.PCMSchematicManagerClipboard->is_symbol_editor = true;

	CFontFileName = GetSuperSpiceSystemDir() + "StickFont\\A.scl";

	first_draw = true;
}

TCSuperSpiceDoc *TCSymbolEditorDoc::GetParentSuperSpiceDoc(void)
{
	if(!PCParentSuperSpiceDoc) return NULL;

	if(IsBadReadPtr(PCParentSuperSpiceDoc, sizeof(TCSuperSpiceDoc))) 
	{
		ASSERT(0);

		PCParentSuperSpiceDoc = NULL;

		return NULL;
	}

	return PCParentSuperSpiceDoc;
}

BOOL TCSymbolEditorDoc::OnNewDocument()
{
	first_draw = true;

	if (!CDocument::OnNewDocument())
		return FALSE;

	return TRUE;
}

BOOL TCSymbolEditorDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	if (!CDocument::OnOpenDocument(lpszPathName))
		return FALSE;
	
	SetupSymbolNames(lpszPathName);
	
	return TRUE;
}

TCSymbolEditorDoc::~TCSymbolEditorDoc()
{
}


BEGIN_MESSAGE_MAP(TCSymbolEditorDoc, CDocument)
	//{{AFX_MSG_MAP(TCSymbolEditorDoc)
	ON_COMMAND(ID_SETUP_SETTEMPERATURE, OnSetupSettemperature)
	ON_COMMAND(ID_OPTIONS_PROGRAM, OnOptionsProgram)
	ON_COMMAND(ID_OPTIONS_SCHEMATIC, OnOptionsSchematic)
	ON_COMMAND(IDM_SIMULATION_SETUP, OnSimulationSetup)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_FILE_LOADACLIPBOARD, OnFileLoadaclipboard)
	ON_COMMAND(ID_FILE_SAVECURRENTCLIPBOARD, OnFileSavecurrentclipboard)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCSymbolEditorDoc diagnostics

#ifdef _DEBUG
void TCSymbolEditorDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void TCSymbolEditorDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// TCSymbolEditorDoc serialization

void TCSymbolEditorDoc::Serialize(CArchive& CArchiveFile)
{

	POSITION				CViewPosition;
	TCSymbolEditorView	*PCSymbolEditorView;
	TCSchematicManager *PCSchematicManager;

	CMSymbolEditorData.Serialize(CArchiveFile);

	int count = 0;
	int p;

	int save_serialize = 12345678;
	int load_serialize = 3456;

	if(CArchiveFile.IsStoring())
	{
		CViewPosition	= GetFirstViewPosition();

		while(CViewPosition != NULL)// first count views
		{
			count++;
			PCSymbolEditorView = (TCSymbolEditorView *)GetNextView(CViewPosition);
		}

		CArchiveFile << count;

		CViewPosition = GetFirstViewPosition();

		while(CViewPosition != NULL)
		{
			PCSymbolEditorView = (TCSymbolEditorView *)GetNextView(CViewPosition);

			PCSymbolEditorView->Serialize(CArchiveFile);
		}
	}
	else
	{
		CViewPosition	= GetFirstViewPosition();

		CArchiveFile >> count;

		for(p = 0; p < count; p++) 
		{
			if(!p)
			{
				PCSymbolEditorView = (TCSymbolEditorView *) GetNextView(CViewPosition);
			}
			else PCSymbolEditorView = (TCSymbolEditorView *) CreateNewView(this);

			if(!PCSymbolEditorView) return;// fatal error

			PCSymbolEditorView->Serialize(CArchiveFile);
			if(p) 
			{
				PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

				if(!PCSchematicManager) return;

				PCSymbolEditorView->GetParent()->SetWindowPlacement(&PCSymbolEditorView->s_window_placment);

				PCSymbolEditorView->SetScrollBarPosition(PCSchematicManager->GetScrollBarPosition());
			}
		}
	}

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << save_serialize;
	}
	else
	{
		CArchiveFile >> load_serialize;

		if(save_serialize != load_serialize)
		{
			AfxMessageBox(IDS_INVALID_FILE);

			return;
		}
	}	
	
	CObject::Serialize(CArchiveFile);
}
 
/////////////////////////////////////////////////////////////////////////////
// TCSymbolEditorDoc commands

void TCSymbolEditorDoc::SetWindowTitle(CMDIChildWnd *PCChildWnd)// Called only after already called by the framework
{
	CString CAppend;

	if(!PCChildWnd) return;

	if(!IsModified())
	{
		CAppend = "Symbol Editor " + GetPathName(); 
		
	//	::SetWindowTitle(PCChildWnd, CAppend);

		SetTitle(CAppend);

		return;
	}

	CAppend = "Symbol Editor " + GetPathName(); 
		
	CAppend += "*";

//	::SetWindowTitle(PCChildWnd, CAppend);

	SetTitle(CAppend);
}

void TCSymbolEditorDoc::SetTitle(LPCTSTR lpszTitle) 
{
	lpszTitle;

	CString CAppend;
	
	if(!IsModified())
	{
		CAppend = "Symbol Editor " + GetPathName(); 
	}
	else
	{
		CAppend = "Symbol Editor " + GetPathName(); 
		
		CAppend += "*";
	}

	CDocument::SetTitle(CAppend);
}

void TCSymbolEditorDoc::OnViewOnDraw(TCSymbolEditorView *PCView, CDC* pDC)
{
	pDC;

	if(!PCView) return;
	if(!PCView->CSuperSpiceViewData.PCMSchematicManager) return;
	
	TCSchematicManager *PCSchematicManager;

	PCSchematicManager = (TCSchematicManager *) PCView->CSuperSpiceViewData.PCMSchematicManager;

	if(first_draw)
	{
		first_draw = false;

		PCView->SetScrollBarPosition(PCSchematicManager->GetScrollBarPosition());

		SetWindowTitle((CMDIChildWnd *)PCView->GetParent());
	}

	PCSchematicManager->DrawAll();
}

void TCSymbolEditorDoc::OnCloseDocument() 
{
	if(PCParentSuperSpiceDoc)PCParentSuperSpiceDoc->OnNotifyDocumentClosed(this);
	
	CDocument::OnCloseDocument();
}

void TCSymbolEditorDoc::OnViewDisplaySchematic(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnViewDisplaySchematic(PCView);
}
void TCSymbolEditorDoc::OnViewDisplayOutputGraph(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnViewDisplayOutputGraph(PCView);
}
void TCSymbolEditorDoc::OnViewDisplayOutputText(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewDisplayOutputText(PCView);
}

void TCSymbolEditorDoc::OnViewDisplaySymbolEditor(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewDisplaySymbolEditor(PCView);
}

void TCSymbolEditorDoc::OnViewDisplayModelsText(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnViewDisplayModelsText(PCView);
}
void TCSymbolEditorDoc::OnViewDisplayInputText(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnViewDisplayInputText(PCView);

}
void TCSymbolEditorDoc::OnViewDisplayIncludeText(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnViewDisplayIncludeText(PCView);

}

void TCSymbolEditorDoc::OnSetupSettemperature() 
{
	if(PCParentSuperSpiceDoc) PCParentSuperSpiceDoc->OnSetupSetTemperature();	
	
}

TCSuperSpiceView *TCSymbolEditorDoc::GetSchematicView(void)
{
	if(!PCParentSuperSpiceDoc) return NULL;

	POSITION pos = PCParentSuperSpiceDoc->GetFirstViewPosition();

	TCSuperSpiceView *PCViewInList;

	PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

	if(!PCViewInList) return NULL;

	return PCViewInList;
}

void TCSymbolEditorDoc::OnOptionsProgram() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnOptionsProgram();	
}

void TCSymbolEditorDoc::OnOptionsSchematic() 
{
	if(!PCParentSuperSpiceDoc) return;

	TCSuperSpiceView *PCSuperSpiceView = GetSchematicView();

	if(!PCSuperSpiceView) return;

	PCSuperSpiceView->OnOptionsSchematic();	
}

void TCSymbolEditorDoc::OnSimulationSetup() 
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->OnViewSimulationSetup();	
}

void  TCSymbolEditorDoc::TimerCallBack(void)
{
	if(!PCParentSuperSpiceDoc) return;

	PCParentSuperSpiceDoc->TimerCallBack();
}

void TCSymbolEditorDoc::OnViewSetZoomCenter(CView *PCView, CPoint CMousePosition)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSchematicManager *PCSchematicManager;

	PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return;

	CPoint	CScrollOrigin	= PCSymbolEditorView->GetScrollBarPosition();
	float	zoom			= PCSchematicManager->GetZoom();

	CMousePosition.x = 	(int)((CMousePosition.x + CScrollOrigin.x) / zoom);
	CMousePosition.y = 	(int)((CMousePosition.y + CScrollOrigin.y) / zoom);

	PCSchematicManager->SetZoomCenter(CMousePosition);
}

void TCSymbolEditorDoc::OnViewZoomIn(CView *PCView)
{
	if(!PCView) return;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSchematicManager *PCSchematicManager;

	PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return;

	float zoom = PCSchematicManager->GetZoom();

	if(zoom >= 4.0 ) return;

	CPoint CCurrentOrigin = PCSymbolEditorView->GetScrollBarPosition();	

	PCSchematicManager->SetZoom(zoom * 2);

	zoom = PCSchematicManager->GetZoom();

	CPoint CZoomCenter = PCSchematicManager->GetZoomCenter();

	CZoomCenter.x = (int)(CZoomCenter.x * zoom); // Zoom about current center
	CZoomCenter.y = (int)(CZoomCenter.y * zoom);

	CRect WindowData;

	PCView->GetClientRect(&WindowData);

	int width = WindowData.Width();
	int height = WindowData.Height();

	CCurrentOrigin.x =  CZoomCenter.x - width / 2;
	CCurrentOrigin.y =  CZoomCenter.y - height / 2;

	PCSymbolEditorView->SetScrollBarPosition(CCurrentOrigin);
	PCSchematicManager->SetScrollBarPosition(CCurrentOrigin);

	PCSchematicManager->Zoom(zoom, PCSymbolEditorView->CSuperSpiceViewData.system_state);
	PCSchematicManager->DrawAll();
}

bool TCSymbolEditorDoc::OnViewCheckZoomIn(CView *PCView)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSchematicManager *PCSchematicManager;

	PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return false;

	if(PCSchematicManager->GetZoom() >= 4.0 ) return false;

	return true;
}
void TCSymbolEditorDoc::OnViewZoomOut(CView *PCView)
{
	if(!PCView) return;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSchematicManager *PCSchematicManager;

	PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return;

	float zoom = PCSchematicManager->GetZoom();

	if(zoom <= 1.0/16.0) return;

	CPoint CCurrentOrigin = PCSymbolEditorView->GetScrollBarPosition();


	PCSchematicManager->SetZoom(zoom / 2);

	zoom = PCSchematicManager->GetZoom();

	CPoint CZoomCenter = PCSchematicManager->GetZoomCenter();

	CZoomCenter.x = (int)(CZoomCenter.x * zoom); // Zoom about current center
	CZoomCenter.y = (int)(CZoomCenter.y * zoom);

	CRect WindowData;

	PCView->GetClientRect(&WindowData);

	int width = WindowData.Width();
	int height = WindowData.Height();

	CCurrentOrigin.x =  CZoomCenter.x - width / 2;
	CCurrentOrigin.y =  CZoomCenter.y - height / 2;

	PCSymbolEditorView->SetScrollBarPosition(CCurrentOrigin);
	PCSchematicManager->SetScrollBarPosition(CCurrentOrigin);

	PCSchematicManager->Zoom(zoom, PCSymbolEditorView->CSuperSpiceViewData.system_state);
	
	PCSchematicManager->DrawAll();
}

bool TCSymbolEditorDoc::OnViewCheckZoomOut(CView *PCView)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSchematicManager *PCSchematicManager;

	PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return false;

	if(PCSchematicManager->GetZoom() <= 1.0/16.0) return false;

	return true;
}

void TCSymbolEditorDoc::OnViewZoomCenter(CView *PCView, CPoint CMousePosition)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSchematicManager *PCSchematicManager;

	PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return;

	CPoint COrigin = PCSymbolEditorView->GetScrollBarPosition();

	CRect WindowData;

	PCView->GetClientRect(&WindowData);

	int width = WindowData.Width();
	int height = WindowData.Height();

	CMousePosition.x =  CMousePosition.x - width / 2;
	CMousePosition.y =  CMousePosition.y - height / 2;

	COrigin.x = COrigin.x + CMousePosition.x;
	COrigin.y = COrigin.y + CMousePosition.y;

	PCSymbolEditorView->SetScrollBarPosition(COrigin);
	PCSchematicManager->SetScrollBarPosition(COrigin);

	PCSchematicManager->DrawAll();
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewIdleOnCancel(CView *PCView)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(PCSchematicManager) PCSchematicManager->DrawAll();

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->IdleOnCancel();

	return system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGraphicsSelectedOnCancel(CView *PCView)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GraphicsSelectedOnCancel();

	return system_state;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGraphicsMovingOnCancel(CView *PCView)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GraphicsMovingOnCancel();

	return system_state;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewSelectRegionOnCancel(CView *PCView)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->SelectRegionOnCancel();

	return system_state;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGotGraphicOnCancel(CView *PCView)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicObject *PCSchematicObject = PCSchematicManager->GetLastCreatedGraphic();
	
	if(PCSchematicObject)
		if(PCParentSuperSpiceDoc)
			if(PCSchematicObject->GetType() == E_WAVEFORM_COMPONENT)
				PCParentSuperSpiceDoc->PutBackReferanceDesignator(PCSchematicObject->GetType());

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GotGraphicOnCancel();

	return system_state;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGotClipboardOnCancel(CView *PCView)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicObject *PCSchematicObject = PCSchematicManager->GetLastCreatedGraphic();

	if(PCSchematicObject)
		if(PCParentSuperSpiceDoc)
			if(PCSchematicObject->GetType() == E_WAVEFORM_COMPONENT)
				PCParentSuperSpiceDoc->PutBackReferanceDesignator(PCSchematicObject->GetType());


	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GotClipboardOnCancel();

	return system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewIdleStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CString CText;

	if(PCParentSuperSpiceDoc) // waveform id's
	{
		if(graphic_type == E_WAVEFORM_COMPONENT)
			CText = PCParentSuperSpiceDoc->GetNewReferanceDesignator(graphic_type);
	}

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->IdleStateGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);

	if(system_state == E_GRAPHICS_MANAGER_STATE_IDLE)return system_state;

	int id = PCSchematicManager->GetLastCreatedId();

	if(id < 0) system_state;

	if(CText != "") PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);
	
	if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGraphicsSelectedStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CString CText;

	if(PCParentSuperSpiceDoc) // waveform id's
	{
		if(graphic_type == E_WAVEFORM_COMPONENT)
			CText = PCParentSuperSpiceDoc->GetNewReferanceDesignator(graphic_type);
	}

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GraphicsSelectedStateGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);

	int id = PCSchematicManager->GetLastCreatedId();

	if(id < 0) system_state;

	if(CText != "") PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);
	
	if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGraphicsMovingStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CString CText;

	if(PCParentSuperSpiceDoc) // waveform id's
	{
		if(graphic_type == E_WAVEFORM_COMPONENT)
			CText = PCParentSuperSpiceDoc->GetNewReferanceDesignator(graphic_type);
	}

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GraphicsMovingStateGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);

	int id = PCSchematicManager->GetLastCreatedId();

	if(id < 0) system_state;

	if(CText != "") PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);
	
	if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewSelectRegionStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CString CText;

	if(PCParentSuperSpiceDoc) // waveform id's
	{
		if(graphic_type == E_WAVEFORM_COMPONENT)
			CText = PCParentSuperSpiceDoc->GetNewReferanceDesignator(graphic_type);
	}

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->SelectRegionStateGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);

	int id = PCSchematicManager->GetLastCreatedId();

	if(id < 0) system_state;

	if(CText != "") PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);
	
	if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");

	return system_state; 
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGotGraphicStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CString CText;

	if(PCParentSuperSpiceDoc) // waveform id's
	{
		if(graphic_type == E_WAVEFORM_COMPONENT)
			CText = PCParentSuperSpiceDoc->GetNewReferanceDesignator(graphic_type);
	}

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GotGraphicStateGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);

	int id = PCSchematicManager->GetLastCreatedId();

	if(id < 0) system_state;

	if(CText != "") PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);
	
	if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGotClipboardGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CString CText;

	if(PCParentSuperSpiceDoc) // waveform id's
	{
		if(graphic_type == E_WAVEFORM_COMPONENT)
			CText = PCParentSuperSpiceDoc->GetNewReferanceDesignator(graphic_type);
	}

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GotClipboardGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);

	int id = PCSchematicManager->GetLastCreatedId();

	if(id < 0) system_state;

	if(CText != "") PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);
	
	if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");

	return system_state; 
}
/////////////////////////////////////
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewIdleStateLBDown(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->IdleStateLBDown(mouse_flags, CScaledPoint);

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGraphicsSelectedStateLBDown(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GraphicsSelectedStateLBDown(mouse_flags, CScaledPoint);

	return system_state; 
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGraphicsMovingStateLBDown(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GraphicsMovingStateLBDown(mouse_flags, CScaledPoint);

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewSelectRegionStateLBDown(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->SelectRegionStateLBDown(mouse_flags, CScaledPoint);

	return system_state; 
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGotGraphicStateLBDown(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicObject *PCSchematicObject = PCSchematicManager->GetLastCreatedGraphic();

	if(!PCSchematicObject) return E_GRAPHICS_MANAGER_STATE_IDLE;

	int graphic_type = PCSchematicObject->GetType();

	CString CText;

	if(PCParentSuperSpiceDoc) // waveform id's
	{
		if(graphic_type == E_WAVEFORM_COMPONENT)
			CText = PCParentSuperSpiceDoc->GetNewReferanceDesignator(graphic_type);
	}

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GotGraphicStateLBDown(mouse_flags, CScaledPoint);

	int id = PCSchematicManager->GetLastCreatedId();

	if(id < 0) return system_state;

	if(CText != "") PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);
	
	if(mouse_flags & MK_LBUTTON)
	{
		SetModifiedFlag(TRUE);

		SetWindowTitle((CMDIChildWnd *)PCSymbolEditorView->GetParent());
	}

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGotClipboardLBDown(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	if(PCParentSuperSpiceDoc) PCParentSuperSpiceDoc->PutNewReferanceDesignatorsInClipboard(PCSchematicManager);

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GotClipboardLBDown(mouse_flags, CScaledPoint);

	GCSymbolEditorClipboard.Zoom(that_zoom);

	GCSymbolEditorClipboard.PasteComponents(PCSchematicManager, CScaledPoint, "*");
		// keep pasting until canceled
	GCSymbolEditorClipboard.Zoom(that_zoom);

	if(mouse_flags & MK_LBUTTON)
	{
		SetModifiedFlag(TRUE);

		SetWindowTitle((CMDIChildWnd *)PCSymbolEditorView->GetParent());
	}

	return system_state; 
}

////////////

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewIdleStateLBUp(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->IdleStateLBUp(mouse_flags, CScaledPoint);

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGraphicsSelectedStateLBUp(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GraphicsSelectedStateLBUp(mouse_flags, CScaledPoint);

	return system_state; 
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGraphicsMovingStateLBUp(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GraphicsMovingStateLBUp(mouse_flags, CScaledPoint);

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewSelectRegionStateLBUp(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->SelectRegionStateLBUp(mouse_flags, CScaledPoint);

	return system_state; 
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGotGraphicStateLBUp(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GotGraphicStateLBUp(mouse_flags, CScaledPoint);

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGotClipboardLBUp(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GotClipboardLBUp(mouse_flags, CScaledPoint);

	return system_state; 
}
/////////////////////////////////////
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewIdleStateMouseMoved(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->IdleStateMouseMoved(mouse_flags, CScaledPoint);

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGraphicsSelectedStateMouseMoved(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GraphicsSelectedStateMouseMoved(mouse_flags, CScaledPoint);

	if(mouse_flags & MK_LBUTTON)
	{
		SetModifiedFlag(TRUE);

		SetWindowTitle((CMDIChildWnd *)PCSymbolEditorView->GetParent());
	}

	return system_state; 
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGraphicsMovingStateMouseMoved(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GraphicsMovingStateMouseMoved(mouse_flags, CScaledPoint);

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewSelectRegionStateMouseMoved(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->SelectRegionStateMouseMoved(mouse_flags, CScaledPoint);

	return system_state; 
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGotGraphicStateMouseMoved(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GotGraphicStateMouseMoved(mouse_flags, CScaledPoint);

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGotClipboardMouseMoved(CView *PCView, int page_id, UINT mouse_flags, CPoint CMousePosition)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TCSchematicObjectData CSchematicObjectData;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->GotClipboardMouseMoved(mouse_flags, CScaledPoint);

	return system_state; 
}

////////////////////////
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewSizingWaveformWindowMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	page_id;

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSchematicManager->SizingWaveformWindowMouseMoved(nFlags, CScaledPoint);

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewDrawingWireGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type, short version)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSymbolEditorView *PCViewInList;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSymbolEditorView->CSuperSpiceViewData.system_state;

	int id;
	CString CText;

	TCSchematicObjectData CSchematicObjectData;

	if(!graphic_type) return system_state;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->CSuperSpiceViewData.PCMSchematicManager;

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->DrawingWireGetGraphic(CScaledPoint, graphic_type, version, CSchematicObjectData);
	
		if(system_state == E_GRAPHICS_MANAGER_STATE_IDLE)return system_state;

		id = PCSchematicManager->GetLastCreatedId();

		if(id < 0) continue;

		if(CText != "")
			PCSchematicManager->SetLabel(id, E_COMPONENT_DESIGNATOR, CText);

		if(graphic_type == E_WAVEFORM_COMPONENT) PCSchematicManager->SetLabel(id, E_WAVEFORM_ENABLE, "Inactive");
	}  
		
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->CSuperSpiceViewData.PCMSchematicManager;

		if(!PCSchematicManager) continue;

		PCViewInList->CSuperSpiceViewData.system_state = system_state;
	}

	return system_state; 	
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewDrawingWireDrawWire(CView *PCView, int page_id, CPoint CMousePosition)
{	
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSymbolEditorView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSymbolEditorView->GetState();

	TCSchematicManager *PCSchematicManager = PCSymbolEditorView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		if(PCViewInList == PCView) system_state = PCSchematicManager->DrawingWireDrawWire(CScaledPoint);

		else PCSchematicManager->DrawingWireDrawWire(CScaledPoint);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCViewInList->SetState(system_state);
	}

	SetModifiedFlag(TRUE);
	SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());// fixup later
	return system_state; 
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewDrawingWireLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSymbolEditorView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSymbolEditorView->GetState();

	int id;

	TCSchematicManager *PCSchematicManager = PCSymbolEditorView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();
	
	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->DrawingWireLBDown(nFlags, CScaledPoint);
		
		id = PCSchematicManager->GetLastCreatedId();

		if(id < 0) continue;

		TCSchematicObject *PCSchematicObject = PCSchematicManager->GetLastCreatedGraphic();
		
		if(!PCSchematicObject) continue;
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCViewInList->SetState(system_state);
	}

//	RegenerateSchematicDocumentsWindowList(false);
	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewWaitingToDrawWireLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSymbolEditorView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSymbolEditorView->GetState();

	TCSchematicManager *PCSchematicManager = PCSymbolEditorView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();
	
	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->WaitingToDrawWireLBDown(nFlags, CScaledPoint);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewDrawingWireLBDblClk(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSymbolEditorView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSymbolEditorView->GetState();

	TCSchematicManager *PCSchematicManager = PCSymbolEditorView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();
	
	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->DrawingWireLBDblClk(nFlags, CScaledPoint);	
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewDrawingWireLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSymbolEditorView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSymbolEditorView->GetState();

	TCSchematicManager *PCSchematicManager = PCSymbolEditorView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->DrawingWireLBUp(nFlags, CScaledPoint);
	}  
	//Ignore system state for this condition
/*
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSuperSpiceView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCViewInList->GetPageId() != page_id)	continue;

		PCViewInList->SetState(system_state);
	}
*/
	return system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewWaitingToDrawWireLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSymbolEditorView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSymbolEditorView->GetState();

	TCSchematicManager *PCSchematicManager = PCSymbolEditorView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->WaitingToDrawWireLBUp(nFlags, CScaledPoint);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCViewInList->SetState(system_state);
	}

	return system_state;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewDrawingWireMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSymbolEditorView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSymbolEditorView->GetState();

	TCSchematicManager *PCSchematicManager = PCSymbolEditorView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->DrawingWireMouseMoved(nFlags, CScaledPoint);
	}  
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewWaitingToDrawWireMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSymbolEditorView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSymbolEditorView->GetState();

	TCSchematicManager *PCSchematicManager = PCSymbolEditorView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		system_state = PCSchematicManager->WaitingToDrawWireMouseMoved(nFlags, CScaledPoint);
	}  
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCViewInList->SetState(system_state);
	}

	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewIdleDrawWire(CView *PCView, int page_id, CPoint CMousePosition)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSymbolEditorView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSymbolEditorView->GetState();

	TCSchematicManager *PCSchematicManager = PCSymbolEditorView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		if(PCViewInList == PCView) system_state = PCSchematicManager->IdleDrawWire(CScaledPoint);

		else PCSchematicManager->IdleDrawWire(CScaledPoint);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCViewInList->SetState(system_state);
	}

	SetModifiedFlag(TRUE);
	SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());
	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGraphicsSelectedDrawWire(CView *PCView, int page_id, CPoint CMousePosition)
{page_id;
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSymbolEditorView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSymbolEditorView->GetState();

	TCSchematicManager *PCSchematicManager = PCSymbolEditorView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		float that_zoom = PCSchematicManager->GetZoom();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		if(PCViewInList == PCView) system_state = PCSchematicManager->GraphicsSelectedDrawWire(CScaledPoint);

		else PCSchematicManager->GraphicsSelectedDrawWire(CScaledPoint);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCViewInList->SetState(system_state);
	}

	SetModifiedFlag(TRUE);
	SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());
	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGraphicsMovingDrawWire(CView *PCView, int page_id, CPoint CMousePosition)
{page_id;	
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSymbolEditorView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSymbolEditorView->GetState();

	TCSchematicManager *PCSchematicManager = PCSymbolEditorView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		if(PCViewInList == PCView) system_state = PCSchematicManager->GraphicsMovingDrawWire(CScaledPoint);

		else PCSchematicManager->GraphicsMovingDrawWire(CScaledPoint);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCViewInList->SetState(system_state);
	}

	SetModifiedFlag(TRUE);
	SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());
	return system_state; 
}
	
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewSelectRegionDrawWire(CView *PCView, int page_id, CPoint CMousePosition)
{	page_id;
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSymbolEditorView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSymbolEditorView->GetState();

	TCSchematicManager *PCSchematicManager = PCSymbolEditorView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom); // normalize offset
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); // normalize mouse position

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		if(PCViewInList == PCView) system_state = PCSchematicManager->SelectRegionDrawWire(CScaledPoint);

		else PCSchematicManager->SelectRegionDrawWire(CScaledPoint);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCViewInList->SetState(system_state);
	}

	SetModifiedFlag(TRUE);
	SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());
	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGotGraphicDrawWire(CView *PCView, int page_id, CPoint CMousePosition)
{	page_id;
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSymbolEditorView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSymbolEditorView->GetState();

	TCSchematicManager *PCSchematicManager = PCSymbolEditorView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		if(PCViewInList == PCView) system_state = PCSchematicManager->GotGraphicDrawWire(CScaledPoint);

		else PCSchematicManager->GotGraphicDrawWire(CScaledPoint);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCViewInList->SetState(system_state);
	}

	SetModifiedFlag(TRUE);
	SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());
	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewGotClipboardDrawWire(CView *PCView, int page_id, CPoint CMousePosition)
{	page_id;
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSymbolEditorView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSymbolEditorView->GetState();

	TCSchematicManager *PCSchematicManager = PCSymbolEditorView->GetSchematicManager();
	
	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 


	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		float that_zoom = PCSchematicManager->GetZoom();

		CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

		MultyplyCPoint(&CNewOffset, 1 / that_zoom);

		CNewOffset = (CPoint) (COffset - CNewOffset);

		CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

		MultyplyCPoint(&CScaledPoint, that_zoom);

		if(PCViewInList == PCView) system_state = PCSchematicManager->GotClipboardDrawWire(CScaledPoint);

		else PCSchematicManager->GotClipboardDrawWire(CScaledPoint);
	}  

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCViewInList->SetState(system_state);
	}
 
	SetModifiedFlag(TRUE);
	SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());
	return system_state; 
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewEditToWindowsClipboard(CView *PCView)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSchematicManager *PCSchematicManager;

	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSymbolEditorView->GetState();

	POSITION pos = GetFirstViewPosition();
	TCSymbolEditorView *PCViewInList;


	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		GCSymbolEditorClipboard.CopyComponentsToWindowsClipboard(PCSchematicManager);

		GCSymbolEditorClipboard.Zoom(1);

		return system_state;
	}  
	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCViewInList->SetState(system_state);
	}

	return system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewDrawingWireOnCancel(CView *PCView)
{

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSymbolEditorView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSymbolEditorView->GetState();

	POSITION pos = GetFirstViewPosition();

	TCSchematicManager *PCSchematicManager;

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		system_state = PCSchematicManager->DrawingWireOnCancel();
	}

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCViewInList->SetState(system_state);
	}

	return system_state;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewWaitingToDrawWireOnCancel(CView *PCView)
{

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSymbolEditorView *PCViewInList = NULL;
	TE_GRAPHICS_MANAGER_SYSTEM_STATE system_state = PCSymbolEditorView->GetState();

	POSITION pos = GetFirstViewPosition();

	TCSchematicManager *PCSchematicManager;

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		system_state = PCSchematicManager->WaitingToDrawWireOnCancel();
	}

	pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCViewInList->SetState(system_state);
	}

	return system_state;
}


///////////////////////////
/////////////////////////////

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewEditCancel(CView *PCView)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	//PCSchematicManager->XXX() nothing done yet

	return PCSymbolEditorView->CSuperSpiceViewData.system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewEditCut(CView *PCView)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	GCSymbolEditorClipboard.CutComponents(PCSchematicManager);

	return PCSymbolEditorView->CSuperSpiceViewData.system_state;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewEditPaste(CView *PCView, CPoint CMousePosition)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	float this_zoom = PCSchematicManager->GetZoom();

	MultyplyCPoint(&COffset, 1 / this_zoom);
	MultyplyCPoint(&CMousePosition, 1 / this_zoom); 

	float that_zoom = PCSchematicManager->GetZoom();

	if(PCParentSuperSpiceDoc) PCParentSuperSpiceDoc->PutNewReferanceDesignatorsInClipboard(PCSchematicManager);

	CPoint CNewOffset = PCSchematicManager->GetViewPortOrigin();

	MultyplyCPoint(&CNewOffset, 1 / that_zoom);

	CNewOffset = (CPoint) (COffset - CNewOffset);

	CPoint CScaledPoint = ((CPoint) (CMousePosition - CNewOffset));

	MultyplyCPoint(&CScaledPoint, that_zoom);

	GCSymbolEditorClipboard.Zoom(that_zoom);

	GCSymbolEditorClipboard.PasteComponents(PCSchematicManager, CScaledPoint, "*");

	GCSymbolEditorClipboard.Zoom(1);

	return E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewEditDelete(CView *PCView)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	PCSchematicManager->DeleteSelectedGraphics(true);

	return PCSymbolEditorView->CSuperSpiceViewData.system_state;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewEditCopy(CView *PCView)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	GCSymbolEditorClipboard.CopyComponents(PCSchematicManager);

	GCSymbolEditorClipboard.Zoom(1);

	return PCSymbolEditorView->CSuperSpiceViewData.system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewEditCopyToWindowsClipboard(CView *PCView)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	GCSymbolEditorClipboard.CopyComponentsToWindowsClipboard(PCSchematicManager);

	GCSymbolEditorClipboard.Zoom(1);

	return PCSymbolEditorView->CSuperSpiceViewData.system_state;
}

TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorDoc::OnViewEditSelectAll(CView *PCView)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return E_GRAPHICS_MANAGER_STATE_IDLE;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return E_GRAPHICS_MANAGER_STATE_IDLE;

	PCSchematicManager->SetSelectAll();

	return E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED;
}
/////////////////////
void TCSymbolEditorDoc::OnLButtonDblClk(CView *PCView, CPoint CMousePosition, UINT mouse_flags)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return;

	TCSchematicManager *PCSchematicManager = (TCSchematicManager *)PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return;

	TCSchematicComponentInfo CSchematicComponentInfo;

	bool fine = false;

	if(mouse_flags & MK_SHIFT) fine = true;

	CPoint COffset = PCSchematicManager->GetViewPortOrigin();

	CPoint CNewOffset = (CPoint) (COffset - PCSchematicManager->GetViewPortOrigin());

	CSchematicComponentInfo = PCSchematicManager->InspectSchematicObject((CPoint) (CMousePosition - CNewOffset), fine, false);

	if(CSchematicComponentInfo.id < 0) 
	{
		if(PCParentSuperSpiceDoc)
		
			PCParentSuperSpiceDoc->GetTopLevelDoc()->OnViewProperties(PCView, PCSchematicManager);

		EraseComponentOutline();

		return;
	}

	switch(CSchematicComponentInfo.type)
	{
//		case E_SCHEMATIC_OBJECT: InspectSchematicObject(PCSchematicManager, PCView, CSchematicComponentInfo); break;	
		
		case E_SCHEMATIC_OBJECT: InspectSchematicPinObject(PCSchematicManager, PCView, CSchematicComponentInfo);break;	

		case E_SCHEMATIC_LABEL: InspectSchematicLabelObject(PCSchematicManager, PCView, CSchematicComponentInfo);break;	
	
		case E_SCHEMATIC_PIN: InspectSchematicPinObject(PCSchematicManager, PCView, CSchematicComponentInfo);break;	
	}
}

void  TCSymbolEditorDoc::OnViewPropertyAccelerater(CView *PCView)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return;

	TCSchematicManager *PCSchematicManager = PCSymbolEditorView->GetSchematicManager();

	if(!PCSchematicManager) return;

	CPoint CMousePosition;

	if(PCSchematicManager->IsComponentOutlined())
	{
		CMousePosition = PCSchematicManager->GetComponentOutlinePosition();	

		PCSchematicManager->EraseComponentOutline();

		OnLButtonDblClk(PCView, CMousePosition, 0);

		return;
	}
	
	if(PCSchematicManager->GetGraphicSelectedPosition(&CMousePosition))
	{
		CMousePosition += PCSchematicManager->GetViewPortOrigin();
		OnLButtonDblClk(PCView, CMousePosition, 0);

		return;
	}

	OnViewProperties(PCView, PCSchematicManager);
}
void TCSymbolEditorDoc::OnViewProperties(CView *PCView, TCSchematicManager *PCSchematicManager)
{
	PCView;
	TCSuperSpiceSchematicProperty CPropertyPage;

	TCSuperSpiceGlobalData CData;

	if(!PCSchematicManager)
	{
		ASSERT(0);
		return;
	}

	CData.CPageData		= PCSchematicManager->GetPageData();
	CData.CDrawData		= GCSuperSpiceGlobalData.CDrawData;
	CData.CColorData	= GCSuperSpiceGlobalData.CColorData;
	CData.CFontData		= GCSuperSpiceGlobalData.CFontData;

	CPropertyPage.SetData(CData);

	if(CPropertyPage.DoModal() != IDOK)
	{
		return;
	}

	CData = CPropertyPage.GetData();

	GCSuperSpiceGlobalData.CDrawData	= CData.CDrawData;
	GCSuperSpiceGlobalData.CColorData	= CData.CColorData;
	GCSuperSpiceGlobalData.CFontData	= CData.CFontData;

	POSITION pos = GetFirstViewPosition();
	TCSymbolEditorView *PCViewInList;

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);
		
		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCSchematicManager->SetPageData(CData.CPageData);

		UpdatePageIdData(CData.CPageData, 0/*page_id*/);

		SetWindowTitle((CMDIChildWnd *)PCViewInList->GetParent());	// Page number and title may have changed
	
		PCSchematicManager->UpdateSchematicObject();
		PCSchematicManager->DrawAll();
	}  
}

void TCSymbolEditorDoc::UpdatePageIdData(TCSchematicPageData &CPageData, int page_id)
{
	TCPageIdData CPageIdData;

	int index = CMPageId.GetPageIndex(page_id);

	if(index < 0) return;

	CPageIdData = CMPageId.CPageIdData.GetAt(index);

	CPageIdData.CPageTitle	= CPageData.CPageTitle;
	CPageIdData.CPageTitle.Format("%s %d", CPageIdData.CPageTitle, CPageData.page_number);

	CMPageId.CPageIdData.SetAt(index, CPageIdData);
}
void TCSymbolEditorDoc::EraseComponentOutline(void)
{
	TCSymbolEditorView *PCViewInList;
	TCSchematicManager *PCSchematicManager;

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCSchematicManager->EraseComponentOutline();

		PCSchematicManager->DrawAll();
	}
}

void TCSymbolEditorDoc::InspectSchematicPinObject(TCSchematicManager *PCSchematicManager, CView *PCView, TCSchematicComponentInfo &CSchematicComponentInfo)
{
	PCView;
	TCSymbolEditorView *PCViewInList;
	
	int page_id = PCSchematicManager->GetPageId();

	CString CText;
	TCSchematicObject *PCSchematicObject;
		
	PCSchematicObject = PCSchematicManager->GetSchematicObject(CSchematicComponentInfo.id);
	
	if(!PCSchematicObject) return;

	CSchematicComponentInfo.pin_id = 0;// pin id should always be 0, therfore force it

	PCSchematicObject->UpdateSchematicObjectData();
		
	TCSymEdPinDlg CPinInfoDlg;

	TCSchematicObjectData CSchematicObjectData, *PCSchematicObjectData;

	PCSchematicObjectData = PCSchematicManager->GetSchematicObjectData(CSchematicComponentInfo.id);
	
	if(!PCSchematicObjectData) return;

	if(!PCSchematicObjectData->CPinListData.GetSize()) return;

	CSchematicObjectData = *PCSchematicObjectData;

	if(!CSchematicObjectData.CPinListData.GetSize()) return;

	if(!(E_COMPONENT_PIN_NET_NAME < CSchematicObjectData.CPinListData[0].CLabelListData.GetSize())) return;

	CPinInfoDlg.CMPinName	= CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel;
	CPinInfoDlg.CMPinNumber	= CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel;
	CPinInfoDlg.m_pin_id	= (int)MKSStringToFloat(CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel);

	if(CPinInfoDlg.DoModal() != IDOK) return;

	CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = CPinInfoDlg.CMPinName;
	CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel  = CPinInfoDlg.CMPinNumber;
	CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel.Format("%d", CPinInfoDlg.m_pin_id);

	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		if(PCSchematicManager->GetPageId() != page_id)	continue;

		PCSchematicManager->SetSchematicObjectData(CSchematicComponentInfo.id, CSchematicObjectData);
	}
}

void TCSymbolEditorDoc::OnComponentsPinsSetup(CView *PCView)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return;

	TCSchematicManager *PCNewSchematicManager = PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCNewSchematicManager) return;

	TCSymbolEditorPinsDlg CSymbolEditorPinsDlg;

	CSymbolEditorPinsDlg.CSchematicManager.SetView(PCView);// for copying to work

	CSymbolEditorPinsDlg.CSchematicManager = *PCNewSchematicManager;

	if(CSymbolEditorPinsDlg.DoModal() != IDOK) return;

	*PCNewSchematicManager = CSymbolEditorPinsDlg.CSchematicManager;

	PCNewSchematicManager->DrawAll();
}

void TCSymbolEditorDoc::InspectSchematicObject(TCSchematicManager *PCSchematicManager, CView *PCView, TCSchematicComponentInfo &CSchematicComponentInfo)
{
	PCView;
	
	CString CText;
	TCSchematicObject *PCSchematicObject;
		
	PCSchematicObject = PCSchematicManager->GetSchematicObject(CSchematicComponentInfo.id);

	TCSchematicObjectData CSchematicObjectData, *PCSchematicObjectData;

	PCSchematicObjectData = PCSchematicManager->GetSchematicObjectData(CSchematicComponentInfo.id);
	
	if(!PCSchematicObjectData) return;

	CSchematicObjectData = *PCSchematicObjectData;

//	int type = PCSchematicObject->GetType();

//	int view_type = CSchematicObjectData.component_property_view_type;
}

void TCSymbolEditorDoc::InspectSchematicLabelObject(TCSchematicManager *PCSchematicManager, CView *PCView, TCSchematicComponentInfo &CSchematicComponentInfo)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return;

	if(!PCSchematicManager) return;

	TCSchematicObject *PCSchematicObject;
		
	PCSchematicObject = PCSchematicManager->GetSchematicObject(CSchematicComponentInfo.id);

	int label	= CSchematicComponentInfo.label_id;
	int object_type = PCSchematicObject->GetType();


	CString CText = CSchematicComponentInfo.CText;

	TCSchematicObjectData CSchematicObjectDataBase;
	CSchematicObjectDataBase = GCSuperSpiceDataBase.CMDefaults[object_type];

	if(object_type == E_WIRE_COMPONENT)
	{
		TCWireLableDlg CWireLableDlg;

		CWireLableDlg.m_lable_id	= label;
		CWireLableDlg.CEditWireText = CText;

		if(CWireLableDlg.DoModal() != IDOK) return;
			
		CText = CWireLableDlg.CEditWireText;

	}
	else
	{
	switch(label)
	{
		case E_COMPONENT_VALUE:
		{
			TCComponentText CComponentText;

			CComponentText.CMEditComponentText	= CText;

			if(CComponentText.DoModal() != IDOK) return;

			CText = CComponentText.CMEditComponentText;

		}break;

		case E_COMPONENT_DESIGNATOR:
		{
				TCReferanceDesignator CComponentText;

				CComponentText.CEditReferanceDesignator = CText;

				if(CComponentText.DoModal() != IDOK) return;

				CText = CComponentText.CEditReferanceDesignator;
		}break;

		case E_COMPONENT_SPICE_MODEL_NAME:
		{ //node name
			TCComponentText CComponentText;

			CComponentText.CMEditComponentText	= CText;

			if(CComponentText.DoModal() != IDOK) return;

			CText = CComponentText.CMEditComponentText;


		}break;

		case E_COMPONENT_SYMBOL_NAME:
		{//node lable
			TCComponentText CComponentText;

			CComponentText.CMEditComponentText	= CText;

			if(CComponentText.DoModal() != IDOK) return;

			CText = CComponentText.CMEditComponentText;

		}break;
	}
	}

	CSchematicObjectDataBase.CLabelListData[label].CLabel = CText;

	GCSuperSpiceDataBase.CMDefaults[object_type].Copy(CSchematicObjectDataBase);

	TCSchematicObjectData CSchematicObjectData;

	PCSchematicManager->SetLabel(CSchematicComponentInfo.id, CSchematicComponentInfo.label_id, CText, true, false);

	CSchematicObjectData = PCSchematicObject->CMSchematicObjectData;

	PCSchematicManager->SetSchematicObjectData(CSchematicComponentInfo.id, CSchematicObjectData);

}

void TCSymbolEditorDoc::OnViewNewView(CView *PCView)
{
	TCSymbolEditorView *PCNewOutputWaveformView	= (TCSymbolEditorView *) CreateNewView(this);
	TCSymbolEditorView *PCSymbolEditorView		= (TCSymbolEditorView *) PCView;
	
	if(!PCNewOutputWaveformView) return;

	TCSchematicManager *PCNewSchematicManager = PCNewOutputWaveformView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCNewSchematicManager) return;

	TCSchematicManager *PCSchematicManager = PCSymbolEditorView->CSuperSpiceViewData.PCMSchematicManager;

	if(!PCSchematicManager) return;

	PCNewSchematicManager->SetScrollBarPosition(PCSchematicManager->GetScrollBarPosition());
	
	PCNewOutputWaveformView->SetScrollBarPosition(PCSchematicManager->GetScrollBarPosition());

	*PCNewSchematicManager = *PCSchematicManager;

	PCNewOutputWaveformView->ShowWindow(SW_SHOW); 
	PCNewOutputWaveformView->UpdateWindow();

}

void TCSymbolEditorDoc::SetupSymbolNames(CString CFileName)
{
	CMSymbolEditorData.CSymbolPathName = ExtractPathName(CFileName);

	CMSymbolEditorData.CSymbolName = ExtractFileName(CFileName);

	CMSymbolEditorData.CSymbolName = RemoveExtention(CMSymbolEditorData.CSymbolName); 
}

void TCSymbolEditorDoc::OnFileSave(CView *PCView)
{
	if(!PCParentSuperSpiceDoc) return;

	CString CThisFileName;

	CThisFileName = CMSymbolEditorData.CSymbolPathName + CMSymbolEditorData.CSymbolName + ".sym";

	SetPathName(CThisFileName);// fuck knows why this has to be done

	OnSaveDocument(CThisFileName);
	
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return;

	SetWindowTitle((CMDIChildWnd *)PCView->GetParent());

	TCSchematicManager *PCSchematicManager = PCSymbolEditorView->GetSchematicManager();

	if(!PCSchematicManager) return;

	TCSchematicObjectData CSchematicObjectData;

	CSchematicObjectData.attached_model_type = (unsigned char) m_attached_model_type;

	if(!CreateSymbol(PCSchematicManager, CMSymbolEditorData, CSchematicObjectData)) return;

	if(!GCSuperSpiceDataBase.CSymbolDataBase.Set(CSchematicObjectData, true))
	{
		AfxMessageBox(IDS_NO_FILE_SAVE);
	}
}

void TCSymbolEditorDoc::DisplayComponentLib(CView *PCView, CString CSymbolFileName, CString CSymbolName)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return;

	TCSchematicManager *PCSchematicManager = PCSymbolEditorView->GetSchematicManager();

	if(!PCSchematicManager) return;

	if(IsBadCodePtr((FARPROC)PCSchematicManager))
	{
		ASSERT(0);

		return;
	}
 
	TCMasterSymbolDlg CComponentLibaryDlg;

	CComponentLibaryDlg.m_enable_vi_select = true;

	if(CSymbolName != "")
	{
		CMSymbolEditorData.CSymbolFileName	= ExtractFileName(CSymbolFileName);
		CMSymbolEditorData.CSymbolPathName	= ExtractPathName(CSymbolFileName);
		CMSymbolEditorData.CSymbolName		= CSymbolName;
	}

	CComponentLibaryDlg.CComponentDataBaseData = CMSymbolEditorData; 

	GCSuperSpiceDataBase.SetDefaultSymbolDisplayed(CMSymbolEditorData);

	if(CSymbolName == "")// use the default passed through
	{
		if(CComponentLibaryDlg.DoModal() == IDCANCEL) return;

		if(CComponentLibaryDlg.button_pressed != E_LIB_PLACE_SYMBOL) return;

		CMSymbolEditorData = CComponentLibaryDlg.CComponentDataBaseData;
	
		m_attached_model_type = CComponentLibaryDlg.CMSymbolDlg.m_attached_model_type;
	}

	TCSchematicObjectData CSchematicObjectData;

	CSchematicObjectData.CSymbolData.CName		= CMSymbolEditorData.CSymbolName;
	CSchematicObjectData.CSymbolData.CFilePath	= CMSymbolEditorData.CSymbolPathName;
	CSchematicObjectData.CSymbolData.CFileName	= CMSymbolEditorData.CSymbolFileName;

	if(!GCSuperSpiceDataBase.CSymbolDataBase.Get(CSchematicObjectData)) 
	{
		AfxMessageBox(IDS_ERR_SELECT_OR_CREATE);

		return;
	}
		
#ifndef _DEBUG // will be removed once curves are supported

	if(!CSchematicObjectData.IsStraightVectorsOnly()) 
	{
		GCGeneralReportsTab.DisplayMessage(IDS_ERR_ERROR, IDS_CANNOT_EDIT_SYM_WITH_CURVES, -1);

		return;
	}
#endif

	CString CFileName;

	CString CurrentFileName = GetPathName();

	CFileName = CMSymbolEditorData.CSymbolPathName + CMSymbolEditorData.CSymbolName + ".sym"; 

	if(CurrentFileName != CFileName)
	{
		PCSchematicManager->CPinNumberStack.Reset();

		SetPathName(CFileName);
	}
	
	CString CText1, CText3;
	
	CText1.LoadString(IDS_UNABLETO_LOAD_OR_FIND);

	CText1 += CFileName + " symbol file, creating new one";
	
	CText3.LoadString(IDS_SYM_CREATE_NEW);

	CText1 += CText3;

	CString CText2;

	CText2.LoadString(IDS_SYM_UNCOMPILE_ERROR);

	if(!UnCompileSymbol(PCSchematicManager, CMSymbolEditorData))
	{
		if(FileExists(CFileName))// load existing if found
		{
			SetPathName(CFileName);

			if(!LoadGenericFromArchive(this, CFileName))
			{
				if(PCParentSuperSpiceDoc) 
				{
					PCParentSuperSpiceDoc->DisplayError(IDS_NETLIST_ERROR, CText1);
				}
			}
			else
			{
				// seralise might get a new schematic manager
				PCSchematicManager = PCSymbolEditorView->GetSchematicManager();

				CMSymbolEditorData = CComponentLibaryDlg.CComponentDataBaseData;// overwrite what was reloaded
			}
		}
		else
		{
			if(PCParentSuperSpiceDoc) 
			{
				PCParentSuperSpiceDoc->DisplayError(IDS_NETLIST_ERROR, CText1);
				PCParentSuperSpiceDoc->DisplayError(IDS_HELP_NOTE, CText2);
			}
		}
	}
	else SetPathName(CFileName);

	UpdateAllViews(NULL);

	PCSchematicManager->DrawAll();

//	OnFileSave(PCView);// a bit redundant but does other stuff
}

bool TCSymbolEditorDoc::UnCompileSymbol(TCSchematicManager *PCSchematicManager, TCComponentDataBaseData &CComponentDataBaseData)
{
	if(!PCSchematicManager) return false;

	TCSchematicObjectData CSchematicObjectData;
	
	CSchematicObjectData.CSymbolData.CName		= CComponentDataBaseData.CSymbolName;
	CSchematicObjectData.CSymbolData.CFilePath	= CComponentDataBaseData.CSymbolPathName;
	CSchematicObjectData.CSymbolData.CFileName	= CComponentDataBaseData.CSymbolFileName;

	if(!GCSuperSpiceDataBase.CSymbolDataBase.Get(CSchematicObjectData)) return false;

	int count = CSchematicObjectData.CSymbolData.CData.GetSize();

	if(!count) return false;

	CPoint CPositionLocation, CLocationOffset;

	CPoint CMCenterPoint;

	PCSchematicManager->DeleteSchematicObjects();
	PCSchematicManager->CMSchematicManagerData.CGraphicList.SetSize(0);// delete existing stuff

	float zoom = PCSchematicManager->CMSchematicManagerData.zoom;

	m_attached_model_type = CSchematicObjectData.attached_model_type;
	
	CPoint CLocation = CSchematicObjectData.CSymbolData.CData[0].CStartLocation;// all referanced to first line point

	CLocationOffset = CSchematicObjectData.CLocationOffset;
		
	MultyplyCPoint(&CLocationOffset, zoom);

	int p;

	for(p = 0; p < count; p++)
	{
		TCLineData CData = CSchematicObjectData.CSymbolData.CData[p];

		MultyplyCPoint(&CData.CStartLocation, zoom);

		if(CData.type == E_SCHEMATIC_SYMBOL_LINE)
		{
			MultyplyCPoint(&CData.CEndLocation, zoom);

			if(!PCSchematicManager->CreateWire(&GlobalCDCTemp, CData.CStartLocation + CLocationOffset, CData.CEndLocation + CLocationOffset))
			{
				ASSERT(0);

				PCSchematicManager->DeleteSchematicObjects();
				PCSchematicManager->CMSchematicManagerData.CGraphicList.SetSize(0);

				return false;
			}
		}
		else if(CData.type == E_SCHEMATIC_SYMBOL_CIRCLE)
		{
			if(!GCSuperSpiceDataBase.SetupDynamicSymbolComponent(CData))
			{
				PCSchematicManager->DeleteSchematicObjects();
				PCSchematicManager->CMSchematicManagerData.CGraphicList.SetSize(0);

				return false;
			}

			CPositionLocation = CLocation + CData.CStartLocation;

			CMCenterPoint.x = GCSuperSpiceDataBase.CMDefaults[E_DYNAMIC_SYMBOL_COMPONENT].width/2;
			CMCenterPoint.y = GCSuperSpiceDataBase.CMDefaults[E_DYNAMIC_SYMBOL_COMPONENT].height/2;

			CPositionLocation += CMCenterPoint;
		
			MultyplyCPoint(&CPositionLocation, zoom);

			CPositionLocation += CLocationOffset;

			if(!PCSchematicManager->OpenGraphic(CPositionLocation, E_DYNAMIC_SYMBOL_COMPONENT, -1, CSchematicObjectData))
			{
				PCSchematicManager->DeleteSchematicObjects();
				PCSchematicManager->CMSchematicManagerData.CGraphicList.SetSize(0);

				return false;
			}
		}
		else return false;
	}

	//Now do pins

	count = CSchematicObjectData.CPinListData.GetSize();

	int type = E_SYMBOL_POINTING_LEFT_PIN_COMPONENT;

	PCSchematicManager->is_symbol_editor = false;// This is to disable the auto create of pin names and numbers

	for(p = 0; p < count; p++)
	{
		TCSchematicPinData &CSchematicPinData = CSchematicObjectData.CPinListData[p];

		if(CSchematicPinData.type == E_POINTING_RIGHT_PIN_COMPONENT)	type = E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT;
		else if(CSchematicPinData.type == E_POINTING_UP_PIN_COMPONENT)	type = E_SYMBOL_POINTING_UP_PIN_COMPONENT;
		else if(CSchematicPinData.type == E_POINTING_DOWN_PIN_COMPONENT)type = E_SYMBOL_POINTING_DOWN_PIN_COMPONENT;
		else type = E_SYMBOL_POINTING_LEFT_PIN_COMPONENT;
		
		CMCenterPoint.x = GCSuperSpiceDataBase.CMDefaults[type].width/2;
		CMCenterPoint.y = GCSuperSpiceDataBase.CMDefaults[type].height/2;

		TCSchematicPinData &CDBPinListData = GCSuperSpiceDataBase.CMDefaults[type].CPinListData[0];
		TCSchematicPinData &CPinListData   = CSchematicObjectData.CPinListData[p];

		CDBPinListData.CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel.Format("%d", p);
		CDBPinListData.CLabelListData[E_COMPONENT_PIN_NAME].CLabel= CPinListData.CLabelListData[E_COMPONENT_PIN_NAME].CLabel;
		CDBPinListData.CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel= CPinListData.CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel;
		CDBPinListData.CLabelListData[E_COMPONENT_PIN_NAME].connection_type	= CPinListData.CLabelListData[E_COMPONENT_PIN_NAME].connection_type;

		CPositionLocation = CSchematicPinData.CLocation + CSchematicPinData.CLocationOffset;

		CPositionLocation += CLocation;

		CPositionLocation += CMCenterPoint;

		MultyplyCPoint(&CPositionLocation, zoom); 

		if(!PCSchematicManager->OpenGraphic(CPositionLocation, type, -1, CSchematicObjectData))
		{
			ASSERT(0);

			PCSchematicManager->DeleteSchematicObjects();
			PCSchematicManager->CMSchematicManagerData.CGraphicList.SetSize(0);

			PCSchematicManager->is_symbol_editor = true;

			return false;
		}
	}

	int pin_start = GetMaxPinId(PCSchematicManager);

	InitPinCount(PCSchematicManager, pin_start);

	PCSchematicManager->is_symbol_editor = true;

	return true;
}

void TCSymbolEditorDoc::OnComponentsResetPinNumbering(CView *PCView)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	
	if(!PCSymbolEditorView) return;

	TCSchematicManager *PCSchematicManager = PCSymbolEditorView->GetSchematicManager();

	if(!PCSchematicManager) return;

	TCSymEdPinStart CSymEdPinStart;

	if(CSymEdPinStart.DoModal() != IDOK) return;

	InitPinCount(PCSchematicManager, CSymEdPinStart.m_pin_start);
}

void TCSymbolEditorDoc::InitPinCount(TCSchematicManager *PCSchematicManager,int init_count)
{
	if(!PCSchematicManager) return;

	if(init_count < 0) return;
	if(init_count > 8196) return;// stop some daft arse locking up the system

	PCSchematicManager->CPinNumberStack.Reset();

	for(int p = 0; p < init_count; p++)
	{
		PCSchematicManager->CPinNumberStack.Pop();
	}
}

bool TCSymbolEditorDoc::CreateSymbol(TCSchematicManager *PCSchematicManager, TCComponentDataBaseData &CComponentDataBaseData, TCSchematicObjectData &CSchematicObjectData)
{
	if(!PCParentSuperSpiceDoc) return false;

	if(!CreateLabels(PCSchematicManager, CComponentDataBaseData, CSchematicObjectData)) return false;
	if(!CreateLines(PCSchematicManager, CSchematicObjectData)) return false;
	if(!CreatePins(PCSchematicManager, CSchematicObjectData)) return false;
	if(!CreateOutline(PCSchematicManager, CSchematicObjectData)) return false;

//	CreateCenterPoint(PCSchematicManager, CSchematicObjectData);

	return true;
}

bool TCSymbolEditorDoc::CreateLines(TCSchematicManager *PCSchematicManager, TCSchematicObjectData &CSchematicObjectData)
{
	if(!PCSchematicManager) return false;

	TCSchematicObject *PCSchematicObject;

	int count = PCSchematicManager->CMSchematicManagerData.CGraphicList.GetSize();

	CPoint COrigin;
	TCLineData CData;

	CSchematicObjectData.CSymbolData.CData.SetSize(0, 256);

	CSchematicObjectData.CLocationOffset.x = 0;
	CSchematicObjectData.CLocationOffset.y = 0;

	float this_zoom;
	bool on_pin_grid = false;

	int grid = GCSuperSpiceGlobalData.CDrawData.grid_size;

	CPoint COffset	= PCSchematicManager->GetViewPortOrigin();
	this_zoom		= PCSchematicManager->GetZoom();

	int p;

	for(int p = 0; p < count; p++)//make sure first line is on a pin boundary.
	{
		PCSchematicObject = PCSchematicManager->CMSchematicManagerData.CGraphicList[p];

		if(PCSchematicObject->m_type != E_WIRE_COMPONENT) continue;

		if(PCSchematicObject->CMLineStart.x % grid) continue;
		if(PCSchematicObject->CMLineStart.y % grid) continue;
		if(PCSchematicObject->CMLineEnd.x % grid) continue;
		if(PCSchematicObject->CMLineEnd.y % grid) continue;

		on_pin_grid = true;

		if(!p) break;// already ok

		TCSchematicObject CLSchematicObject = *PCSchematicManager->CMSchematicManagerData.CGraphicList[0];

		*PCSchematicManager->CMSchematicManagerData.CGraphicList[0] = *PCSchematicObject;

		*PCSchematicObject = CLSchematicObject;

		break;
	}

	if(!on_pin_grid)
	{
		AfxMessageBox(IDS_NOT_ON_PIN_GRID);

		return false;
	}

	for(p = 0; p < count; p++)
	{
		PCSchematicObject = PCSchematicManager->CMSchematicManagerData.CGraphicList[p];

		if(PCSchematicObject->m_type == E_WIRE_COMPONENT)
		{
			CData.CStartLocation= PCSchematicObject->CMLineStart - COffset;
			CData.CEndLocation	= PCSchematicObject->CMLineEnd - COffset;
			CData.type			= E_SCHEMATIC_SYMBOL_LINE;

			MultyplyCPoint(&CData.CStartLocation, 1 / this_zoom); 
			MultyplyCPoint(&CData.CEndLocation, 1 / this_zoom);

			CSchematicObjectData.CSymbolData.CData.Add(CData);
		}
		else if(PCSchematicObject->m_type == E_SYMBOL_CURVE_COMPONENT || PCSchematicObject->m_type == E_DYNAMIC_SYMBOL_COMPONENT)
		{
			CData = PCSchematicObject->CMSchematicObjectData.CSymbolData.CData[0];

			CData.CStartLocation	= CData.CStartLocation  - COffset;
			CData.CEndLocation		= CData.CEndLocation  - COffset;

			CData.CStartLocation	= CData.CStartLocation + PCSchematicObject->CMLocation;
			CData.CEndLocation		= CData.CEndLocation + PCSchematicObject->CMLocation;

			MultyplyCPoint(&CData.CStartLocation, 1 / this_zoom); 
			MultyplyCPoint(&CData.CEndLocation, 1 / this_zoom);

			CSchematicObjectData.CSymbolData.CData.Add(CData);
		}
	}

	if(!CSchematicObjectData.CSymbolData.CData.GetSize()) return false;

	return true;
}

void TCSymbolEditorDoc::CreateCenterPoint(TCSchematicManager *PCSchematicManager,  TCSchematicObjectData &CSchematicObjectData)
{
	if(!PCSchematicManager) return;

	TCLineData CData; 

	CData.CStartLocation.x	= CSchematicObjectData.CGrabOffset.x + CSchematicObjectData.width/2;
	CData.CStartLocation.y	= CSchematicObjectData.CGrabOffset.y + CSchematicObjectData.height/2;
	CData.CEndLocation.x	= CSchematicObjectData.CGrabOffset.x + CSchematicObjectData.width/2 + 1;
	CData.CEndLocation.y	= CSchematicObjectData.CGrabOffset.y + CSchematicObjectData.height/2 + 1;

	CSchematicObjectData.CSymbolData.CData.InsertAt(0, CData);
}

bool TCSymbolEditorDoc::CreatePins(TCSchematicManager *PCSchematicManager, TCSchematicObjectData &CSchematicObjectData)
{
	if(!PCSchematicManager) return false;

	if(!GetNumberOfPins(PCSchematicManager)) 
	{
		CSchematicObjectData.CPinListData.SetSize(0);

		return true;// allow objects with no pins
	}

	if(!CSchematicObjectData.CSymbolData.CData.GetSize()) return false;

	if(!ValidatePins(PCSchematicManager)) return false;

	TCSchematicObject *PCSchematicObject;

	int count = PCSchematicManager->CMSchematicManagerData.CGraphicList.GetSize();

	int number_ofpins = GetNumberOfPins(PCSchematicManager);

	CSchematicObjectData.CPinListData.SetSize(number_ofpins);

	if(CSchematicObjectData.CPinListData.GetSize() != number_ofpins) return false;//memory fucked

	int p;

	for(p = 0; p < number_ofpins; p++)
	{
		CSchematicObjectData.CPinListData[p].CLabelListData.SetSize(E_NUM_PIN_LABELS);
	}

	float this_zoom;

	TCSchematicPinData CPinListData;

	CPinListData.CLabelListData.SetSize(E_NUM_PIN_LABELS);

	CPoint COffset	= PCSchematicManager->GetViewPortOrigin();
	this_zoom		= PCSchematicManager->GetZoom();

	CPinListData.is_visable = true;
	CPinListData.CLocationOffset.x = 0;
	CPinListData.CLocationOffset.y = 0;

	int pin_id;

	for(p = 0; p < count; p++)
	{
		PCSchematicObject = PCSchematicManager->CMSchematicManagerData.CGraphicList[p];

		switch(PCSchematicObject->m_type)
		{
			case E_SYMBOL_POINTING_UP_PIN_COMPONENT:	CPinListData.type = E_POINTING_UP_PIN_COMPONENT; break;
			case E_SYMBOL_POINTING_DOWN_PIN_COMPONENT:	CPinListData.type = E_POINTING_DOWN_PIN_COMPONENT; break;
			case E_SYMBOL_POINTING_LEFT_PIN_COMPONENT:	CPinListData.type = E_POINTING_LEFT_PIN_COMPONENT; break;
			case E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT:	CPinListData.type = E_POINTING_RIGHT_PIN_COMPONENT; break;

			default: continue;
		}

		CPinListData.CLocation= PCSchematicObject->CMLocation - COffset;
		CPinListData.CLocation	= PCSchematicObject->CMLocation - COffset;

		MultyplyCPoint(&CPinListData.CLocation, 1 / this_zoom); 

		CPinListData.CLocation = CPinListData.CLocation - CSchematicObjectData.CSymbolData.CData[0].CStartLocation;

		pin_id = GetPinId(PCSchematicObject);

		if(pin_id < 0 || !(pin_id < number_ofpins))
		{
			AfxMessageBox(IDS_INVALID_PIN_ID);// should not happen, already checked

			return false;
		}

		CPinListData.CLabelListData[E_COMPONENT_PIN_NAME].CLabel = GetPinName(PCSchematicObject);
		CPinListData.CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = GetPinNumber(PCSchematicObject);

		CSchematicObjectData.CPinListData[pin_id] = CPinListData;
	}

	return true;
}
 
bool TCSymbolEditorDoc::ValidatePins(TCSchematicManager *PCSchematicManager)
{
	if(!PCSchematicManager) return false;

	int max_pin_id = GetMaxPinId(PCSchematicManager);

	if(max_pin_id < 0) 
	{
		AfxMessageBox(IDS_IVALID_PIN_DATA);

		return false;
	}

	if(IsPinMissing(PCSchematicManager, max_pin_id)) return false;

	return true;
}

int TCSymbolEditorDoc::GetMaxPinId(TCSchematicManager *PCSchematicManager)
{
	if(!PCSchematicManager) return -1;

	TCSchematicObject *PCSchematicObject;

	int count = PCSchematicManager->CMSchematicManagerData.CGraphicList.GetSize();

	int max_pin_id = -1;
	int new_max_pin_id = -1;

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = PCSchematicManager->CMSchematicManagerData.CGraphicList[p];

		new_max_pin_id = GetPinId(PCSchematicObject);	

		if(new_max_pin_id > max_pin_id) max_pin_id = new_max_pin_id;
	}

	return max_pin_id + 1;// Max pin id should be the count of ids
}

bool TCSymbolEditorDoc::IsPinMissing(TCSchematicManager *PCSchematicManager, int max_pin_id)
{
	if(!PCSchematicManager) return true;

	TCSchematicObject *PCSchematicObject;
	TCSchematicObject *PCSchematicObjectNext;

	int count = PCSchematicManager->CMSchematicManagerData.CGraphicList.GetSize();

	int pin_count = GetNumberOfPins(PCSchematicManager);// maybe bug, 20th Aug 2003

//	int pin_count = GetMaxPinId();//// proposed bug fix, 20th Aug 2003

	if(!pin_count) return true;

	CString CConsecutivePins;

	CConsecutivePins.LoadString(IDS_MUST_CONSECTUTIVE_PIN_NUBERS);

	if(pin_count != max_pin_id)// make sure all pins are included
	{
		AfxMessageBox(IDS_MUST_CONSECTUTIVE_PIN_NUBERS);

		GCGeneralReportsTab.DisplayMessage(IDS_ERR_ERROR, CConsecutivePins, -1);
		GCGeneralReportsTab.DisplayMessage(IDS_ERR_ERROR, IDS_CHECK_PINS, -1);

		return true;
	}
	
	int pin_id;
	int next_pin_id;

	for(int p = 0; p < count; p++)// check for doublicate/invalid pin numbers
	{
		PCSchematicObject = PCSchematicManager->CMSchematicManagerData.CGraphicList[p];

		pin_id = GetPinId(PCSchematicObject);

		if(pin_id < 0) continue;

		for(int q = 0; q < count; q++)
		{
			PCSchematicObjectNext = PCSchematicManager->CMSchematicManagerData.CGraphicList[q];

			if(PCSchematicObjectNext == PCSchematicObject) continue;

			next_pin_id = GetPinId(PCSchematicObjectNext);

			if(pin_id == next_pin_id)
			{
				AfxMessageBox(IDS_DOUBLICATE_PIN_IDS);

				return true;
			}
		}

	}

	return false;
}

int TCSymbolEditorDoc::GetNumberOfPins(TCSchematicManager *PCSchematicManager)
{
	if(!PCSchematicManager) return false;

	TCSchematicObject *PCSchematicObject;

	int count = PCSchematicManager->CMSchematicManagerData.CGraphicList.GetSize();

	int pin_count = 0;

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = PCSchematicManager->CMSchematicManagerData.CGraphicList[p];

		switch(PCSchematicObject->m_type)
		{
			case E_SYMBOL_POINTING_UP_PIN_COMPONENT:	 break;
			case E_SYMBOL_POINTING_DOWN_PIN_COMPONENT:	break;
			case E_SYMBOL_POINTING_LEFT_PIN_COMPONENT:	break;
			case E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT:	 break;

			default: continue;
		}

		pin_count++;
	}

	return pin_count;
}

int TCSymbolEditorDoc::GetPinId(TCSchematicObject *PCSchematicObject)
{
	if(!PCSchematicObject) return -1;

	CString CText;
	int pin_id;

	switch(PCSchematicObject->m_type)
	{
		case E_SYMBOL_POINTING_UP_PIN_COMPONENT:	 break;
		case E_SYMBOL_POINTING_DOWN_PIN_COMPONENT:	break;
		case E_SYMBOL_POINTING_LEFT_PIN_COMPONENT:	break;
		case E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT:	 break;

		default: return -1;
	}

	// E_COMPONENT_PIN_NET_NAME is used as the pin id as it is umused fro symbol creation
	CText = PCSchematicObject->CMSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;
	
	sscanf(CText, "%d", &pin_id);

	return pin_id;
}

CString TCSymbolEditorDoc::GetPinName(TCSchematicObject *PCSchematicObject)
{
	if(!PCSchematicObject) return "";

	CString CText;

	switch(PCSchematicObject->m_type)
	{
		case E_SYMBOL_POINTING_UP_PIN_COMPONENT:	 break;
		case E_SYMBOL_POINTING_DOWN_PIN_COMPONENT:	break;
		case E_SYMBOL_POINTING_LEFT_PIN_COMPONENT:	break;
		case E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT:	 break;

		default: return "";
	}

	CText = PCSchematicObject->CMSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel;

	return CText;
}

CString TCSymbolEditorDoc::GetPinNumber(TCSchematicObject *PCSchematicObject)
{
	if(!PCSchematicObject) return "";// ka vc9 was -1

	CString CText;

	switch(PCSchematicObject->m_type)
	{
		case E_SYMBOL_POINTING_UP_PIN_COMPONENT:	 break;
		case E_SYMBOL_POINTING_DOWN_PIN_COMPONENT:	break;
		case E_SYMBOL_POINTING_LEFT_PIN_COMPONENT:	break;
		case E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT:	 break;

		default: return "";
	}

	CText = PCSchematicObject->CMSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel;

	return CText;
}

bool TCSymbolEditorDoc::CreateLabels(TCSchematicManager *PCSchematicManager, TCComponentDataBaseData &CComponentDataBaseData, TCSchematicObjectData &CSchematicObjectData)
{
	PCSchematicManager;

	// need field to specify this
	CComponentDataBaseData.CComponentType = CComponentDataBaseData.CModelName;

	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = true;
	CSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = true;

	CComponentDataBaseData.use_index = false;// quick fix

	if(!GCSuperSpiceDataBase.GetComponent(CComponentDataBaseData, CSchematicObjectData)) 
	{
		AfxMessageBox(IDS_SYMBOL_NOT_FOUND_CREATE);

		GCGeneralReportsTab.DisplayMessage(IDS_EER_STATUS, IDS_OPEN_SYMBOL_LIB, -1);
		GCGeneralReportsTab.DisplayMessage(IDS_EER_STATUS, IDS_OPEN_SYMBOL_LIB2, -1);

		return false;
	}

	CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = CSchematicObjectData.CSymbolData.CName;
	CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = CSchematicObjectData.CSymbolData.CName;

	CSchematicObjectData.CReserved.CStringArray.SetSize(E_RESERVED_SCHEMATIC_OBJECT_DATA_MAX);
	CSchematicObjectData.CReserved.CStringArray[E_RESERVED_PCB_PACKAGE_NAME] = "SMD";
	CSchematicObjectData.CReserved.CStringArray[E_RESERVED_PCB_COMPONENT_NAME] = CSchematicObjectData.CSymbolData.CName;

	CSchematicObjectData.CReserved.CIntArray.SetSize(E_RESERVED_INT_COMPONENT_DATA_MAX);
	CSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_PCB_INCLUDE] = true;
	CSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_SPICE_INCLUDE] = true;
	CSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_POWER] = 0;
	CSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_COMPONENT_TRANSIENT_POWER] = 0;

	if(CSchematicObjectData.attached_model_type != E_SPICE_SCHEMATIC) // error correction
		CSchematicObjectData.CSymbolData.CChildFileName = "";

	// need field to specify this
	CComponentDataBaseData.CComponentType = CComponentDataBaseData.CModelName;
 
	if(CSchematicObjectData.attached_model_type == E_SPICE_GENERATOR)
		return SetupGeneratorLabels(PCSchematicManager, CSchematicObjectData);

	return true;
}

bool TCSymbolEditorDoc::SetupGeneratorLabels(TCSchematicManager *PCSchematicManager, TCSchematicObjectData &CSchematicObjectData)
{
	int index;

	index = CSchematicObjectData.version;// version indexs into the internal id of the generators

	if(index < 0) 
	{	
		ASSERT(0);//program error

		return false;
	}


	if(!(index < GCSuperSpiceDataBase.CMDefaults.GetSize())) return false;// should really use a function call

	if(index < 0) 
	{	
		ASSERT(0);//program error

		return false;
	}

	TCSchematicObjectData &CSchematicObjectDataBase = GCSuperSpiceDataBase.CMDefaults[index];

	if(GetNumberOfPins(PCSchematicManager) != 2) 
	{
		AfxMessageBox(IDS_GENERATORS_2PINS_ONLY);

		return false;
	}

	int count = CSchematicObjectDataBase.CLabelListData.GetSize();

	CSchematicObjectData.CLabelListData.SetSize(count);

	if(CSchematicObjectData.CLabelListData.GetSize() != count) return false;

	for(int p = 0; p < count; p++)// Why?
	{
		CSchematicObjectData.CLabelListData[p] = CSchematicObjectDataBase.CLabelListData[p];
	}

	CSchematicObjectData.CSpiceParameters.CopyInfo(CSchematicObjectDataBase.CSpiceParameters);

	CSchematicObjectData.component_property_view_type = CSchematicObjectDataBase.component_property_view_type;
	CSchematicObjectData.version = CSchematicObjectDataBase.version;

	return true;
}

bool TCSymbolEditorDoc::CreateOutline(TCSchematicManager *PCSchematicManager, TCSchematicObjectData &CSchematicObjectData)
{
	if(!PCSchematicManager) return false;

	if(!CSchematicObjectData.CSymbolData.CData.GetSize()) return false;

	CRect CComponentLinesRectangle;

	GetComponentLinesRectangle(PCSchematicManager, CComponentLinesRectangle, CSchematicObjectData);

	CSchematicObjectData.width	= (unsigned short)CComponentLinesRectangle.Width(); 
	CSchematicObjectData.height	= (unsigned short) CComponentLinesRectangle.Height();

	CSchematicObjectData.f_vector_graphic = true;

	return true;
}

void TCSymbolEditorDoc::GetComponentLinesRectangle(TCSchematicManager *PCSchematicManager, CRect &CComponentLinesRectangle, TCSchematicObjectData &CSchematicObjectData)
{
	TCSchematicObject *PCSchematicObject;
	PCSchematicManager;
	PCSchematicObject;

	int count = CSchematicObjectData.CSymbolData.CData.GetSize();

	if(!count) return;

	int f_up	= false;
	int f_down = false;
	int f_left = false;
	int f_right = false;

	CComponentLinesRectangle.top	= CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y;
	CComponentLinesRectangle.left	= CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x;
	CComponentLinesRectangle.bottom	= CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y;
	CComponentLinesRectangle.right	= CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x;

	for(int p = 0; p < count; p++)
	{
		TCLineData &CData = CSchematicObjectData.CSymbolData.CData[p];

		if(CData.CStartLocation.x > CComponentLinesRectangle.right) CComponentLinesRectangle.right = CData.CStartLocation.x;
		if(CData.CStartLocation.x < CComponentLinesRectangle.left) CComponentLinesRectangle.left = CData.CStartLocation.x;

		if(CData.CEndLocation.x > CComponentLinesRectangle.right) CComponentLinesRectangle.right = CData.CEndLocation.x;
		if(CData.CEndLocation.x < CComponentLinesRectangle.left) CComponentLinesRectangle.left = CData.CEndLocation.x;

		if(CData.CStartLocation.y > CComponentLinesRectangle.bottom) CComponentLinesRectangle.bottom = CData.CStartLocation.y;
		if(CData.CStartLocation.y < CComponentLinesRectangle.top) CComponentLinesRectangle.top = CData.CStartLocation.y;

		if(CData.CEndLocation.y > CComponentLinesRectangle.bottom) CComponentLinesRectangle.bottom = CData.CEndLocation.y;
		if(CData.CEndLocation.y < CComponentLinesRectangle.top) CComponentLinesRectangle.top = CData.CEndLocation.y;
	}
	
/*
	count = PCSchematicManager->CMSchematicManagerData.CGraphicList.GetSize();

	for(p = 0; p < count; p++)
	{
		PCSchematicObject = PCSchematicManager->CMSchematicManagerData.CGraphicList[p];

		switch(PCSchematicObject->m_type)
		{
			case E_SYMBOL_POINTING_UP_PIN_COMPONENT:	f_up = true; break;
			case E_SYMBOL_POINTING_DOWN_PIN_COMPONENT:	f_down = true;break;
			case E_SYMBOL_POINTING_LEFT_PIN_COMPONENT:	f_left = true;break;
			case E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT:	f_right = true;break;
		}
	}*/

// Ignore pins for now as better fit on rotation.

	CPoint COffset;// normalise to to corner, if start drawing was not there

	COffset.x = CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x - CComponentLinesRectangle.left;
	COffset.y = CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y - CComponentLinesRectangle.top;

	CSchematicObjectData.CGrabOffset = -COffset;
	
	if(f_up)	CComponentLinesRectangle.top -= (long)(16 * GCSuperSpiceDataBase.component_scale);// magic numbr, pin length!
	if(f_down) CComponentLinesRectangle.bottom += (long)(16* GCSuperSpiceDataBase.component_scale);
	if(f_left) CComponentLinesRectangle.left -=(long)(16* GCSuperSpiceDataBase.component_scale);
	if(f_right) CComponentLinesRectangle.right += (long)(16* GCSuperSpiceDataBase.component_scale);

	if(f_up) CSchematicObjectData.CGrabOffset.y = (unsigned long)(-16* GCSuperSpiceDataBase.component_scale);
	if(f_left) CSchematicObjectData.CGrabOffset.x = (unsigned long)(-16* GCSuperSpiceDataBase.component_scale);
}


void TCSymbolEditorDoc::OnFileOpen() 
{
	CString CFileName;
	CString CPromptString;

	CPromptString = "SuperSpice Symbol Files  (*.sym)| *.sym";

	CString CExt = "sym";

	CFileDialog	CLoadFileDialog(true, CExt, "", 0, CPromptString);

	if(CLoadFileDialog.DoModal() != IDOK) return;

	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return;	

	SetPathName(CFileName);

	LoadGenericFromArchive(this, CFileName);
}

void TCSymbolEditorDoc::OnFileLoadaclipboard() 
{
	CString CSysFontFileDir = GetSuperSpiceSystemDir();

	CSysFontFileDir += "StickFont\\*.scl";

	CFileDialog	CLoadFileDialog(true, "scl", CSysFontFileDir, 0,"SuperSpice Stick Font Files (*.scl)| *.scl||");

	if(CLoadFileDialog.DoModal() == IDCANCEL) return;

	CFontFileName = CLoadFileDialog.GetPathName();

	if(CFontFileName == "") return;

	GCSymbolEditorClipboard.Load(CFontFileName);

	POSITION pos = GetFirstViewPosition();

	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *) GetNextView(pos);

	PCSymbolEditorView->CSuperSpiceViewData.system_state = E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD;

	OnViewEditPaste(PCSymbolEditorView, PCSymbolEditorView->CSuperSpiceViewData.CLastMousePosition);
}

void TCSymbolEditorDoc::OnFileSavecurrentclipboard() 
{
	CString CSysFontFileDir = GetSuperSpiceSystemDir();

	CSysFontFileDir += "StickFont\\*.scl";

	CFileDialog	CSaveFileDialog(false, "scl", CSysFontFileDir, OFN_OVERWRITEPROMPT, "SuperSpice Stick Font Files (*.scl)| *.scl||");

	if(CSaveFileDialog.DoModal() != IDOK) return;

	CFontFileName = CSaveFileDialog.GetPathName();

	if(CFontFileName == "") return;	

	GCSymbolEditorClipboard.Save(CFontFileName);
}

void TCSymbolEditorDoc::OnViewUndelete(CView *PCView)
{
	TCSymbolEditorView *PCSymbolEditorView = (TCSymbolEditorView *)PCView;
	TCSymbolEditorView *PCViewInList;

	TCSchematicManager *PCSchematicManager = PCSymbolEditorView->GetSchematicManager();
	
	POSITION pos = GetFirstViewPosition();

	while (pos != NULL)
	{
		PCViewInList = (TCSymbolEditorView *)GetNextView(pos);

		PCSchematicManager = PCViewInList->GetSchematicManager();

		if(!PCSchematicManager) continue;

		PCSchematicManager->Undelete();
	}
}