#if !defined(AFX_TCSYMBOLEDITORDOC_H__5132B802_B6C4_11D3_B17C_444553540000__INCLUDED_)
#define AFX_TCSYMBOLEDITORDOC_H__5132B802_B6C4_11D3_B17C_444553540000__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// TCSymbolEditorDoc.h : header file
//
#include "TCSymbolEditorView.h"
/////////////////////////////////////////////////////////////////////////////
// TCSymbolEditorDoc document
#include "TCNumberStack.h"
#include "TCSuperSpiceDataBase.h"

class TCSuperSpiceDoc;
class TCSuperSpiceView;
class TCSchematicComponentInfo;
class TCSchematicPageData;


class TCSymbolEditorDoc : public CDocument
{
protected:
	TCSymbolEditorDoc();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(TCSymbolEditorDoc)


	WINDOWPLACEMENT				s_window_placment;

	bool first_draw;
	TCPageId					CMPageId;
	int							m_attached_model_type; // cludge 

	TCSuperSpiceDoc *PCParentSuperSpiceDoc;

	TCSuperSpiceDoc *GetParentSuperSpiceDoc(void);


// Attributes
public:

	CString CFontFileName;

	TCComponentDataBaseData CMSymbolEditorData;

	void OnViewUndelete(CView *PCView);

	void OnViewDisplaySchematic(CView *PCView);
	void OnViewDisplayOutputGraph(CView *PCView);
	void OnViewDisplayOutputText(CView *PCView);
	void OnViewDisplayInputText(CView *PCView);
	void OnViewDisplayIncludeText(CView *PCView);
	void OnViewDisplayModelsText(CView *PCView);
	void OnViewDisplaySymbolEditor(CView *PCView);
	void OnViewPropertyAccelerater(CView *PCView);

	void OnFileSave(CView *PCView);
	void OnFileNew(CView *PCView);

	void SetupSymbolNames(CString CFileName);

	void DisplayComponentLib(CView *PCView, CString CSymbolFileName, CString CSymbolName);

	TCSuperSpiceView *GetSchematicView(void);


// Operations
public:

	TCSymbolEditorView *GetView(void){return (TCSymbolEditorView *) m_viewList.GetHead();}

	void OnViewZoomIn(CView *PCView);
	bool OnViewCheckZoomIn(CView *PCView);
	void OnViewZoomOut(CView *PCView);
	bool OnViewCheckZoomOut(CView *PCView);
	void OnViewZoomCenter(CView *PCView, CPoint CMousePosition);
	void OnViewSetZoomCenter(CView *PCView, CPoint CMousePosition);

	void InitPinCount(TCSchematicManager *PCSchematicManager, int init_count);

	void OnViewNewView(CView *PCView);
	void OnComponentsResetPinNumbering(CView *PCView);	

	bool UnCompileSymbol(TCSchematicManager *PCSchematicManager, TCComponentDataBaseData &CComponentDataBaseData);

	bool CreateSymbol(TCSchematicManager *PCSchematicManager, TCComponentDataBaseData &CComponentDataBaseData, TCSchematicObjectData &CSchematicObjectData);
	bool CreateLines(TCSchematicManager *PCSchematicManager, TCSchematicObjectData &CSchematicObjectData);
	bool CreatePins(TCSchematicManager *PCSchematicManager, TCSchematicObjectData &CSchematicObjectData);
	bool CreateLabels(TCSchematicManager *PCSchematicManager, TCComponentDataBaseData &CComponentDataBaseData, TCSchematicObjectData &CSchematicObjectData);
	bool CreateOutline(TCSchematicManager *PCSchematicManager,  TCSchematicObjectData &CSchematicObjectData);
	bool ValidatePins(TCSchematicManager *PCSchematicManager);

	void CreateCenterPoint(TCSchematicManager *PCSchematicManager,  TCSchematicObjectData &CSchematicObjectData);

	int GetMaxPinId(TCSchematicManager *PCSchematicManager);
	bool IsPinMissing(TCSchematicManager *PCSchematicManager, int max_pin_id);
	int GetPinId(TCSchematicObject *PCSchematicObject);
	CString GetPinName(TCSchematicObject *PCSchematicObject);
	CString GetPinNumber(TCSchematicObject *PCSchematicObject);

	int GetNumberOfPins(TCSchematicManager *PCSchematicManager);

	bool  SetupGeneratorLabels(TCSchematicManager *PCSchematicManager, TCSchematicObjectData &CSchematicObjectData);

	void GetComponentLinesRectangle(TCSchematicManager *PCSchematicManager, CRect &CComponentLinesRectangle, TCSchematicObjectData &CSchematicObjectData);

	void  TimerCallBack(void);

	void OnRunRun(CView *PCView, bool renetlist = true);
	void OnRunRunDebugMode(CView *PCView, bool renetlist = true);

	bool Load(CString CName, bool update = true);
	bool Save(CString CName);
	void EraseComponentOutline(void);
	void OnViewProperties(CView *PCView, TCSchematicManager *PCSchematicManager);
	void UpdatePageIdData(TCSchematicPageData &CPageData, int page_id);


	void OnLButtonDblClk(CView *PCView, CPoint CMousePosition, UINT mouse_flags);
	void InspectSchematicObject(TCSchematicManager *PCSchematicManager, CView *PCView, TCSchematicComponentInfo &CSchematicComponentInfo);
	void InspectSchematicLabelObject(TCSchematicManager *PCSchematicManager, CView *PCView, TCSchematicComponentInfo &CSchematicComponentInfo);
	void InspectSchematicPinObject(TCSchematicManager *PCSchematicManager, CView *PCView, TCSchematicComponentInfo &CSchematicComponentInfo);

	void OnComponentsPinsSetup(CView *PCView);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewIdleOnCancel(CView *PCView);//
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsSelectedOnCancel(CView *PCView);//
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsMovingOnCancel(CView *PCView);	
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSelectRegionOnCancel(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotGraphicOnCancel(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotClipboardOnCancel(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewDrawingWireOnCancel(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewWaitingToDrawWireOnCancel(CView *PCView);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditToWindowsClipboard(CView *PCView);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotClipboardDrawWire(CView *PCView, int page_id, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewDrawingWireDrawWire(CView *PCView, int page_id, CPoint CMousePosition);


	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewIdleStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type = 0, short version = 0);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsSelectedStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type = 0, short version = 0);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsMovingStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type = 0, short version = 0);	
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSelectRegionStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type = 0, short version = 0);		 
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotGraphicStateGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type = 0, short version = 0);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotClipboardGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type = 0, short version = 0);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewDrawingWireLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewWaitingToDrawWireLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewIdleStateLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsSelectedStateLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsMovingStateLBDown(CView *PCView,  int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSelectRegionStateLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotGraphicStateLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotClipboardLBDown(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsSelectedDrawWire(CView *PCView, int page_id, CPoint CMousePosition);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewIdleStateLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsSelectedStateLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsMovingStateLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSelectRegionStateLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotGraphicStateLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotClipboardLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewDrawingWireLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewWaitingToDrawWireLBUp(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewIdleDrawWire(CView *PCView, int page_id, CPoint CMousePosition);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewIdleStateMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsSelectedStateMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsMovingStateMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSelectRegionStateMouseMoved(CView *PCView,int page_id,  UINT nFlags, CPoint CMousePosition);	
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotGraphicStateMouseMoved(CView *PCView,  int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotClipboardMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSizingWaveformWindowMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewDrawingWireMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewWaitingToDrawWireMouseMoved(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditCancel(CView *PCView); 
	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditCut(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditPaste(CView *PCView, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditDelete(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditCopy(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditCopyToWindowsClipboard(CView *PCView);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE	OnViewEditSelectAll(CView *PCView);

	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewDrawingWireGetGraphic(CView *PCView, int page_id, CPoint CMousePosition, int graphic_type = 0, short version = 0);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewDrawingWireLBDblClk(CView *PCView, int page_id, UINT nFlags, CPoint CMousePosition);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGraphicsMovingDrawWire(CView *PCView, int page_id, CPoint CMousePosition);	
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewSelectRegionDrawWire(CView *PCView, int page_id, CPoint CMousePosition);		 
	TE_GRAPHICS_MANAGER_SYSTEM_STATE OnViewGotGraphicDrawWire(CView *PCView, int page_id, CPoint CMousePosition);


	void OnViewOnDraw(TCSymbolEditorView *PCView, CDC* pDC);
	void SetWindowTitle(CMDIChildWnd *PCChildWnd);//

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(TCSymbolEditorDoc)
	public:
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
	virtual void OnCloseDocument();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual void SetTitle(LPCTSTR lpszTitle);
	protected:
	virtual BOOL OnNewDocument();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~TCSymbolEditorDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(TCSymbolEditorDoc)
	afx_msg void OnSetupSettemperature();
	afx_msg void OnOptionsProgram();
	afx_msg void OnOptionsSchematic();
	afx_msg void OnSimulationSetup();
	afx_msg void OnFileOpen();
	afx_msg void OnFileLoadaclipboard();
	afx_msg void OnFileSavecurrentclipboard();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TCSYMBOLEDITORDOC_H__5132B802_B6C4_11D3_B17C_444553540000__INCLUDED_)
