// TCSymbolEditorPinsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "afxpriv.h"
#include "superspice.h"
#include "TCSymbolEditorPinsDlg.h"
#include "TCSchematicManager.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern  double MKSStringToFloat(CString &CText);
/////////////////////////////////////////////////////////////////////////////
// TCSymbolEditorPinsDlg dialog


TCSymbolEditorPinsDlg::TCSymbolEditorPinsDlg(CWnd* pParent /*=NULL*/)
	: CDialog(TCSymbolEditorPinsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(TCSymbolEditorPinsDlg)
	CMPinName = _T("");
	m_check_visable_pin_name = FALSE;
	m_check_visable_pin_number = FALSE;
	CEditPinNumber = _T("");
	m_pin_id = 0;
	//}}AFX_DATA_INIT

	item_id = 0;

	SchematicObjectIDList.SetSize(0, 256);
}


void TCSymbolEditorPinsDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCSymbolEditorPinsDlg)
	DDX_Control(pDX, IDC_LIST_PIN_DATA, CMPinList);
	DDX_Text(pDX, IDC_EDIT_PIN_NAME, CMPinName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PIN_NAME, m_check_visable_pin_name);
	DDX_Check(pDX, IDC_CHECK_VISABLE_PIN_NUMBER, m_check_visable_pin_number);
	DDX_Text(pDX, IDC_EDIT_PIN_NUMBER, CEditPinNumber);
	DDX_Text(pDX, IDC_EDIT_PIN_ID, m_pin_id);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCSymbolEditorPinsDlg, CDialog)
	//{{AFX_MSG_MAP(TCSymbolEditorPinsDlg)
	ON_NOTIFY(NM_CLICK, IDC_LIST_PIN_DATA, OnClickListPinData)
	ON_BN_CLICKED(IDHELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCSymbolEditorPinsDlg message handlers


BOOL TCSymbolEditorPinsDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	SetupListHeader();

	SetDisplay();
	
	return TRUE;  
}

void TCSymbolEditorPinsDlg::SetDisplay(void)
{

	SetupPinDataList();
	SetPinData();

	CMPinList.SetItemState(0, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED );

	UpdateData(false);
}

void TCSymbolEditorPinsDlg::GetDisplay(void)
{

	UpdateData(true);



}

void TCSymbolEditorPinsDlg::SetupListHeader(void)
{
	CString CText;

	int length = (int)(CMPinList.GetStringWidth("Number Visable") * 1.2);

	CText ="Pin ID";
	CMPinList.InsertColumn(E_COMPONENT_LIST_PIN_ID, CText, LVCFMT_LEFT, (int)(length * 0.8), E_COMPONENT_LIST_PIN_ID);

	CText ="Name    ";
	CMPinList.InsertColumn(E_COMPONENT_LIST_PIN_NAME, CText, LVCFMT_LEFT, (int)(length * 0.8), E_COMPONENT_LIST_PIN_NAME);

	CText ="Name Visible";
	CMPinList.InsertColumn(E_COMPONENT_LIST_PIN_NAME_VISABLE, CText, LVCFMT_LEFT, length, E_COMPONENT_LIST_PIN_NAME_VISABLE);

	CText ="Pin Number";
	CMPinList.InsertColumn(E_COMPONENT_LIST_PIN_NUMBER, CText, LVCFMT_LEFT, (int)(length * 1.2), E_COMPONENT_LIST_PIN_NUMBER);

	CText ="Number Visible";
	CMPinList.InsertColumn(E_COMPONENT_LIST_PIN_NUMBER_VISABLE, CText, LVCFMT_LEFT, length, E_COMPONENT_LIST_PIN_NUMBER_VISABLE);

	int count = CSchematicManager.CMSchematicManagerData.CGraphicList.GetSize();
	int counter = 0;

	SchematicObjectIDList.SetSize(0, 256);

	for(int p = 0; p < count; p++)
	{
		TCSchematicObject *PCSchematicObject = CSchematicManager.CMSchematicManagerData.CGraphicList[p];

		if(PCSchematicObject->m_type !=  E_SYMBOL_POINTING_UP_PIN_COMPONENT &&
		   PCSchematicObject->m_type !=  E_SYMBOL_POINTING_DOWN_PIN_COMPONENT &&
		   PCSchematicObject->m_type !=  E_SYMBOL_POINTING_LEFT_PIN_COMPONENT &&
		   PCSchematicObject->m_type !=  E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT) continue;
		
		CText.Format("%d",p);
		
		CMPinList.InsertItem(p, CText);

		SchematicObjectIDList.Add(p);

		counter++;
	}
}

void TCSymbolEditorPinsDlg::SetupPinDataList(void)
{
	CString CText;

	int count = SchematicObjectIDList.GetSize();

	for(int p = 0; p < count; p++)
	{
		TCSchematicObjectData &CSchematicObjectData = CSchematicManager.CMSchematicManagerData.CGraphicList[SchematicObjectIDList[p]]->CMSchematicObjectData;

		CMPinList.SetItemText(p, E_COMPONENT_LIST_PIN_ID, CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel);

		CMPinList.SetItemText(p, E_COMPONENT_LIST_PIN_NAME, CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel);

		if(CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].is_visable)
			CText = "Yes";
		else CText = "No";

		CMPinList.SetItemText(p, E_COMPONENT_LIST_PIN_NAME_VISABLE, CText);

		CMPinList.SetItemText(p, E_COMPONENT_LIST_PIN_NUMBER, CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel);

		if(CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].is_visable)
			CText = "Yes";
		else CText = "No";

		CMPinList.SetItemText(p, E_COMPONENT_LIST_PIN_NUMBER_VISABLE, CText);
	}
}

void TCSymbolEditorPinsDlg::GetPinData(void)
{
	UpdateData(true);

	if(item_id < 0) m_pin_id = 0;

	if(!(item_id <SchematicObjectIDList.GetSize())) return;

	int id = SchematicObjectIDList[item_id];

	if(!(id < CSchematicManager.CMSchematicManagerData.CGraphicList.GetSize())) return;

	TCSchematicObjectData &CSchematicObjectData = CSchematicManager.CMSchematicManagerData.CGraphicList[id]->CMSchematicObjectData;

	CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel = CMPinName;
	CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel = CEditPinNumber;
	CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel.Format("%d", m_pin_id);

	CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].is_visable = !!m_check_visable_pin_name;
	CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].is_visable = !!m_check_visable_pin_number;

	CSchematicManager.SetSchematicObjectData(id, CSchematicObjectData);
}

void TCSymbolEditorPinsDlg::SetPinData(void)
{
	if(item_id < 0) item_id = 0;

	if(!(item_id <SchematicObjectIDList.GetSize())) return;

	int id = SchematicObjectIDList[item_id];

	TCSchematicObjectData &CSchematicObjectData = CSchematicManager.CMSchematicManagerData.CGraphicList[id]->CMSchematicObjectData;

	CMPinName = CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].CLabel;
	CEditPinNumber = CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].CLabel;
	m_pin_id = (int) MKSStringToFloat(CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel);

	m_check_visable_pin_name = CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NAME].is_visable;
	m_check_visable_pin_number = CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NUMBER].is_visable;
}

void TCSymbolEditorPinsDlg::OnClickListPinData(NMHDR* pNMHDR, LRESULT* pResult) 
{
	pNMHDR;
	*pResult = 0;

	GetPinData();

	item_id = CMPinList.GetNextItem(-1, LVNI_SELECTED | LVNI_FOCUSED);

	if(item_id < 0) item_id = 0;

	CMPinList.SetItemState(item_id, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);

	SetPinData();
	SetupPinDataList();

	UpdateData(false);
}

void TCSymbolEditorPinsDlg::OnOK() 
{
	GetPinData();
	
	CDialog::OnOK();
}

void TCSymbolEditorPinsDlg::OnHelp() 
{
	DWORD dwData;

	dwData = HID_BASE_RESOURCE + IDD_COMPONENT_PINS_SYM_EDITOR;

	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp*) AfxGetMainWnd();

	PCSuperSpiceApp->DialogHelp(dwData);	
}
