// TCSymbolEditorView.cpp : implementation file
//

#include "stdafx.h"
#include "superspice.h"
#include "TCSymbolEditorDoc.h"
#include "TCSymbolEditorView.h"
#include "TCSchematicManager.h"
#include "TCSuperSpiceDoc.h"
#include "TESuperSpiceMsgStringsEnums.h"
#include "TCWorkspaceTree.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern TCSuperSpiceDoc *PCSuperSpiceDocLastFocused;
extern TCSuperSpiceView *PCSuperSpiceViewLastFocused;

extern TCMultyTaskedString CGlobalStatusMessage;
extern void DisplayPopupMenu(CWnd*, CPoint, int);
extern TCWorkspaceTree GCWorkspaceTree;
/////////////////////////////////////////////////////////////////////////////
// TCSymbolEditorView

IMPLEMENT_DYNCREATE(TCSymbolEditorView, CScrollView)

TCSymbolEditorView::TCSymbolEditorView()
{
	CSuperSpiceViewData.PCMSchematicManager	= NULL;// 
	CSuperSpiceViewData.CMaxSize.cx  = 8181;
	CSuperSpiceViewData.CMaxSize.cy  = 8181;
	CSuperSpiceViewData.CPageSize.cx = 128;
	CSuperSpiceViewData.CPageSize.cy = 128;
	CSuperSpiceViewData.CLineSize.cx = 8;
	CSuperSpiceViewData.CLineSize.cy = 8;
	
	CSuperSpiceViewData.CViewPortOrigin.x = 0;
	CSuperSpiceViewData.CViewPortOrigin.y = 0;

	CSuperSpiceViewData.CScrollBarPosition.x = 0;
	CSuperSpiceViewData.CScrollBarPosition.y = 0;

	CSuperSpiceViewData.PCMSchematicManager = new TCSchematicManager;

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSuperSpiceViewData.PCMSchematicManager->is_symbol_editor = true;
	CSuperSpiceViewData.PCMSchematicManager->CMSchematicManagerData.zoom = 2;

	CSuperSpiceViewData.PCMSchematicManager->SetView(( CView *)this);
	CSuperSpiceViewData.PCMSchematicManager->SetViewSize(CSuperSpiceViewData.CMaxSize);

	CSuperSpiceViewData.system_state = E_GRAPHICS_MANAGER_STATE_IDLE;

	CSize CMaxSize(CSuperSpiceViewData.CMaxSize.cx,
					 CSuperSpiceViewData.CMaxSize.cy);
	SetScrollSizes(MM_TEXT, CMaxSize, CSuperSpiceViewData.CPageSize, CSuperSpiceViewData.CLineSize);

	first_draw = false;

}

TCSymbolEditorView::~TCSymbolEditorView()
{
	if(CSuperSpiceViewData.PCMSchematicManager) delete CSuperSpiceViewData.PCMSchematicManager;
}


BEGIN_MESSAGE_MAP(TCSymbolEditorView, CScrollView)
	//{{AFX_MSG_MAP(TCSymbolEditorView)
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_VIEW_DESIGNNOTES, OnViewDesignnotes)
	ON_COMMAND(ID_VIEW_INCLUDEDMODELSFILE, OnViewIncludedmodelsfile)
	ON_COMMAND(ID_VIEW_INCLUDEFILE, OnViewIncludefile)
	ON_COMMAND(ID_VIEW_SCHEMATIC, OnViewSchematic)
	ON_COMMAND(ID_VIEW_SCHEMATICFILES, OnViewSchematicfiles)
	ON_COMMAND(ID_VIEW_TOP_LEVEL_FILES, OnViewTopLevelFiles)
	ON_COMMAND(IDM_VIEW_SPICE_TEXT, OnViewSpiceText)
	ON_COMMAND(IDM_VIEW_OUTPUT_GRAPH, OnViewOutputGraph)
	ON_COMMAND(IDM_VIEW_OUTPUT_TEXT, OnViewOutputText)
	ON_COMMAND(ID_RUN_AC, OnRunAc)
	ON_UPDATE_COMMAND_UI(ID_RUN_AC, OnUpdateRunAc)
	ON_COMMAND(ID_RUN_CREATENETLIST, OnRunCreatenetlist)
	ON_COMMAND(ID_RUN_DC, OnRunDc)
	ON_UPDATE_COMMAND_UI(ID_RUN_DC, OnUpdateRunDc)
	ON_COMMAND(ID_RUN_ENABLEDISTORTION, OnRunEnabledistortion)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEDISTORTION, OnUpdateRunEnabledistortion)
	ON_COMMAND(ID_RUN_ENABLEFOURIER, OnRunEnablefourier)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEFOURIER, OnUpdateRunEnablefourier)
	ON_COMMAND(ID_RUN_ENABLENOISE, OnRunEnablenoise)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLENOISE, OnUpdateRunEnablenoise)
	ON_COMMAND(ID_RUN_ENABLEOPERATINGPOINT, OnRunEnableoperatingpoint)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEOPERATINGPOINT, OnUpdateRunEnableoperatingpoint)
	ON_COMMAND(ID_RUN_ENABLEPOLEZERO, OnRunEnablepolezero)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEPOLEZERO, OnUpdateRunEnablepolezero)
	ON_COMMAND(ID_RUN_ENABLE_STATISTICS, OnRunStatistics)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLE_STATISTICS, OnUpdateRunStatistics)
	ON_COMMAND(ID_RUN_PARAMETRIC, OnRunParametric)
	ON_UPDATE_COMMAND_UI(ID_RUN_PARAMETRIC, OnUpdateRunParametric)
	ON_COMMAND(ID_RUN_PAUSE_CONT, OnRunPauseCont)
	ON_COMMAND(ID_RUN_RERUNS, OnRunReruns)
	ON_COMMAND(ID_RUN_RUN, OnRunRun)
	ON_COMMAND(ID_RUN_RUN_SAME_NRT_LIST, OnRunRunSameNrtList)
	ON_COMMAND(ID_RUN_RUNDEBUGMODE, OnRunRundebugmode)
	ON_COMMAND(ID_RUN_SENSITIVITY, OnRunSensitivity)
	ON_UPDATE_COMMAND_UI(ID_RUN_SENSITIVITY, OnUpdateRunSensitivity)
	ON_COMMAND(ID_RUN_STOP, OnRunStop)
	ON_COMMAND(ID_RUN_TEMPERATURE, OnRunTemperature)
	ON_UPDATE_COMMAND_UI(ID_RUN_TEMPERATURE, OnUpdateRunTemperature)
	ON_COMMAND(ID_RUN_TRANSIENT, OnRunTransient)
	ON_UPDATE_COMMAND_UI(ID_RUN_TRANSIENT, OnUpdateRunTransient)
	ON_UPDATE_COMMAND_UI(ID_RUN_RERUNS, OnUpdateRunReruns)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_SETCURSOR()
	ON_WM_LBUTTONDBLCLK()
	ON_COMMAND(ID_CANCEL_COMMAND, OnCancelCommand)
	ON_WM_TIMER()
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_COMMAND(ID_EDIT_COPY_WITH_PASTE, OnEditCopyWithPaste)
	ON_COMMAND(ID_EDIT_CUT, OnEditCut)
	ON_COMMAND(ID_EDIT_DELETE, OnEditDelete)
	ON_COMMAND(ID_EDIT_PASTE1, OnEditPaste1)
	ON_COMMAND(ID_CANCEL_EDIT_CNTR, OnCancelEditCntr)
	ON_COMMAND(ID_AROW_UP, OnArowUp)
	ON_COMMAND(ID_ARROW_DOWN, OnArrowDown)
	ON_COMMAND(ID_ARROW_LEFT, OnArrowLeft)
	ON_COMMAND(ID_ARROW_RIGHT, OnArrowRight)
	ON_COMMAND(ID_PAGE_DOWN, OnPageDown)
	ON_COMMAND(ID_PAGE_UP, OnPageUp)
	ON_COMMAND(ID_COMPONENTS_LEFTPOINTINGPIN, OnComponentsLeftpointingpin)
	ON_COMMAND(ID_COMPONENTS_RIGHTPOINTINGPIN, OnComponentsRightpointingpin)
	ON_COMMAND(ID_COMPONENTS_UPPOINTINGPIN, OnComponentsUppointingpin)
	ON_COMMAND(ID_COMPONENTS_DOWNPOINTINGPIN, OnComponentsDownpointingpin)
	ON_COMMAND(ID_DRAW_LINE, OnDrawLine)
	ON_COMMAND(ID_DRAWING_ZOOMIN, OnDrawingZoomin)
	ON_COMMAND(ID_DRAWING_ZOOMOUT, OnDrawingZoomout)
	ON_COMMAND(ID_DRAWING_ZOOM_CENTER, OnDrawingZoomCenter)
	ON_UPDATE_COMMAND_UI(ID_DRAWING_ZOOM_CENTER, OnUpdateDrawingZoomCenter)
	ON_UPDATE_COMMAND_UI(ID_DRAWING_ZOOMIN, OnUpdateDrawingZoomin)
	ON_UPDATE_COMMAND_UI(ID_DRAWING_ZOOMOUT, OnUpdateDrawingZoomout)
	ON_COMMAND(ID_EDIT_SELECTALL, OnEditSelectall)
	ON_COMMAND(ID_PROPERTY_ACCELERATER, OnPropertyAccelerater)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	ON_COMMAND(ID_DRAW_WIRE, OnDrawWire)
	ON_COMMAND(ID_DRAW_WIRE_IMMEDIATLY, OnDrawWireImmediatly)
	ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
	ON_COMMAND(ID_COMPONENTS_COMPONENTLIBARY, OnComponentsComponentlibary)
	ON_COMMAND(ID_COMPONENTS_PINSSETUP, OnComponentsPinsSetup)
	ON_COMMAND(ID_COMPONENTS_RESETPINNUMBERING, OnComponentsResetPinNumbering)
	ON_WM_SETFOCUS()
	ON_COMMAND(ID_EDIT_UNDELETE, OnEditUndelete)
	ON_UPDATE_COMMAND_UI(ID_EDIT_UNDELETE, OnUpdateEditUndelete)
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_RUN_ENABLEMONTECARLO, &TCSymbolEditorView::OnRunEnableMonteCarlo)
	ON_UPDATE_COMMAND_UI(ID_RUN_ENABLEMONTECARLO, &TCSymbolEditorView::OnUpdateRunEnableMonteCarlo)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCSymbolEditorView drawing

void TCSymbolEditorView::OnInitialUpdate()
{
	CView::OnInitialUpdate();
	
	SetScrollSizes(MM_TEXT, CSuperSpiceViewData.CMaxSize, CSuperSpiceViewData.CPageSize, CSuperSpiceViewData.CLineSize);
}

void TCSymbolEditorView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	pSender, lHint, pHint;
	
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	SetScrollSizes(MM_TEXT, CSuperSpiceViewData.CMaxSize, CSuperSpiceViewData.CPageSize, CSuperSpiceViewData.CLineSize);	
	
}

TCSchematicManager *TCSymbolEditorView::GetSchematicManager(void)
{
	return CSuperSpiceViewData.PCMSchematicManager;
}
TE_GRAPHICS_MANAGER_SYSTEM_STATE TCSymbolEditorView::GetState(void)
{
	return CSuperSpiceViewData.system_state;
} 

void TCSymbolEditorView::SetState(TE_GRAPHICS_MANAGER_SYSTEM_STATE sys_state)
{
	CSuperSpiceViewData.system_state = sys_state;
}

void TCSymbolEditorView::OnDraw(CDC* pDC)
{
	pDC;

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(first_draw)
	{
		first_draw = false;

		SetScrollSizes(MM_TEXT, CSuperSpiceViewData.CMaxSize, CSuperSpiceViewData.CPageSize, CSuperSpiceViewData.CLineSize);

		GetParent()->SetWindowPlacement(&s_window_placment);
	}

	if(!pDC->IsPrinting())
	{
		PCDoc->OnViewOnDraw(this, pDC);
	}
}
 
/////////////////////////////////////////////////////////////////////////////
// TCSymbolEditorView diagnostics

#ifdef _DEBUG
void TCSymbolEditorView::AssertValid() const
{
	CScrollView::AssertValid();
}

void TCSymbolEditorView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// TCSymbolEditorView message handlers

void TCSymbolEditorView::SetScrollSizesZoomed(float zoom)
{
	CSize CMaxSize(CSuperSpiceViewData.CMaxSize.cx,
					 CSuperSpiceViewData.CMaxSize.cy);

	CMaxSize.cx = (int)(CSuperSpiceViewData.CMaxSize.cx * zoom);
	CMaxSize.cy = (int)(CSuperSpiceViewData.CMaxSize.cy * zoom);

	// MFC asserts for this, presumably due to 16 bit problems
	// need to correct this later
	if(CMaxSize.cx > 32767) CMaxSize.cx = 32767;
	if(CMaxSize.cy > 32767) CMaxSize.cy	= 32767;

	SetScrollSizes(MM_TEXT, CMaxSize, CSuperSpiceViewData.CPageSize, CSuperSpiceViewData.CLineSize);
}

CPoint TCSymbolEditorView::GetScrollBarPosition(void)
{
	CPoint CScrollBarPosition;

	CScrollBarPosition.y = GetScrollPos(SB_VERT);
	CScrollBarPosition.x = GetScrollPos(SB_HORZ);

	return CScrollBarPosition;
}

void TCSymbolEditorView::SetScrollBarPosition(CPoint CScrollBarPosition)
{
	if(CScrollBarPosition.x < 0) CScrollBarPosition.x = 0;
	if(CScrollBarPosition.x >= CSuperSpiceViewData.CMaxSize.cx -1)
		CScrollBarPosition.x = CSuperSpiceViewData.CMaxSize.cx;


	CScrollBarPosition.x = CScrollBarPosition.x / CSuperSpiceViewData.CLineSize.cx;
	CScrollBarPosition.x = CScrollBarPosition.x * CSuperSpiceViewData.CLineSize.cx;

	CScrollBarPosition.y = CScrollBarPosition.y / CSuperSpiceViewData.CLineSize.cy;
	CScrollBarPosition.y = CScrollBarPosition.y * CSuperSpiceViewData.CLineSize.cy;


	if(CScrollBarPosition.y < 0) CScrollBarPosition.y = 0;
	if(CScrollBarPosition.y >= CSuperSpiceViewData.CMaxSize.cy - 1)
		CScrollBarPosition.y = CSuperSpiceViewData.CMaxSize.cy;

	SetScrollPos(SB_VERT, CScrollBarPosition.y);
	SetScrollPos(SB_HORZ, CScrollBarPosition.x);
	OnHScroll(SB_THUMBTRACK, CScrollBarPosition.x, NULL);
	OnVScroll(SB_THUMBTRACK,CScrollBarPosition.y, NULL); 
}

void TCSymbolEditorView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CScrollView::OnHScroll(nSBCode, nPos, pScrollBar);
	
	CDC *PCViewDC = GetDC();
	
	OnPrepareDC(PCViewDC, NULL);

	CPoint CViewPortOrigin = PCViewDC->GetViewportOrg();

	ReleaseDC(PCViewDC);

	CSuperSpiceViewData.PCMSchematicManager->EraseComponentOutline();

	CSuperSpiceViewData.PCMSchematicManager->SetViewPortOrigin(CViewPortOrigin);	

	CSuperSpiceViewData.PCMSchematicManager->SetScrollBarPosition(GetScrollBarPosition());

}

void TCSymbolEditorView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CScrollView::OnVScroll(nSBCode, nPos, pScrollBar);

	CDC *PCViewDC = GetDC();
	
	OnPrepareDC(PCViewDC, NULL);

	CPoint CViewPortOrigin = PCViewDC->GetViewportOrg();

	ReleaseDC(PCViewDC);

	CSuperSpiceViewData.PCMSchematicManager->EraseComponentOutline();

	CSuperSpiceViewData.PCMSchematicManager->SetViewPortOrigin(CViewPortOrigin);

	CSuperSpiceViewData.PCMSchematicManager->SetScrollBarPosition(GetScrollBarPosition());
}


void TCSymbolEditorView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	DisplayPopupMenu(this, point, CG_IDR_POPUP_TCSUPER_SPICE_SYMBOL_EDITOR);

	CScrollView::OnRButtonDown(nFlags, point);
}

void TCSymbolEditorView::Serialize(CArchive& CArchive) 
{
	CSuperSpiceViewData.Serialize(CArchive);

	if (CArchive.IsStoring())
	{
		if(CSuperSpiceViewData.PCMSchematicManager) CSuperSpiceViewData.PCMSchematicManager->Serialize(CArchive);

		GetParent()->GetWindowPlacement(&s_window_placment);

		CArchive.Write(&s_window_placment, sizeof(s_window_placment));
	}
	else 
	{	
		if(CSuperSpiceViewData.PCMSchematicManager) 
		{
			// Make sure all old data is destroyed
			delete CSuperSpiceViewData.PCMSchematicManager;

			CSuperSpiceViewData.PCMSchematicManager = new TCSchematicManager;

			if(!CSuperSpiceViewData.PCMSchematicManager) return;

			CSuperSpiceViewData.PCMSchematicManager->is_symbol_editor = true;

			CSuperSpiceViewData.PCMSchematicManager->SetView(( CView *)this);
			CSuperSpiceViewData.PCMSchematicManager->SetViewSize(CSuperSpiceViewData.CMaxSize);

			CSuperSpiceViewData.PCMSchematicManager->Serialize(CArchive);

		}
		CArchive.Read(&s_window_placment, sizeof(s_window_placment));
	}
}


void TCSymbolEditorView::OnViewDesignnotes() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCSuperSpiceDoc *PCSDoc = PCDoc->PCParentSuperSpiceDoc;

	PCSDoc = PCSDoc->GetTopLevelDoc();

	if(!PCSDoc) return;

	PCSDoc->OnViewDisplayDesignNotes(this);	
}

void TCSymbolEditorView::OnViewIncludedmodelsfile() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;
	
	PCDoc->OnViewDisplayModelsText(this);	
}

void TCSymbolEditorView::OnViewIncludefile() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc->OnViewDisplayIncludeText(this);	
}

void TCSymbolEditorView::OnViewSchematic() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;
	
	PCDoc->OnViewDisplaySchematic(this);	
}

void TCSymbolEditorView::OnViewSchematicfiles() 
{
/*	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	PCDoc->PCParentSuperSpiceDoc->OnViewSchematicFiles();*/	

	GCWorkspaceTree.Refresh();
}

void TCSymbolEditorView::OnViewTopLevelFiles() 
{
	GCWorkspaceTree.Refresh();
}

void TCSymbolEditorView::OnViewSpiceText() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc->OnViewDisplayInputText(this);	
}

void TCSymbolEditorView::OnViewOutputGraph() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;	

	PCDoc->OnViewDisplayOutputGraph(this);
}

void TCSymbolEditorView::OnViewOutputText() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	PCDoc->OnViewDisplayOutputText(this);	
}

void TCSymbolEditorView::OnRunAc() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CACSetupData.CSweepData.enable = !CAnalysisSetup.CACSetupData.CSweepData.enable;	
}

void TCSymbolEditorView::OnUpdateRunAc(CCmdUI* pCmdUI) 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CACSetupData.CSweepData.enable);

	pCmdUI->ContinueRouting();	
}


void TCSymbolEditorView::OnRunDc() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CDCSetupData.CSweepData1.enable = !CAnalysisSetup.CDCSetupData.CSweepData1.enable;
	
}

void TCSymbolEditorView::OnUpdateRunDc(CCmdUI* pCmdUI) 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CDCSetupData.CSweepData1.enable);

	pCmdUI->ContinueRouting();	
}

void TCSymbolEditorView::OnRunEnabledistortion() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CDistortionSetupData.enable = !CAnalysisSetup.CDistortionSetupData.enable;
	
}

void TCSymbolEditorView::OnUpdateRunEnabledistortion(CCmdUI* pCmdUI) 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CDistortionSetupData.enable);

	pCmdUI->ContinueRouting();	
}

void TCSymbolEditorView::OnRunEnablefourier() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CTransientSetupData.fourier_enable = !CAnalysisSetup.CTransientSetupData.fourier_enable;

	if(CAnalysisSetup.CTransientSetupData.fourier_enable) CAnalysisSetup.CTransientSetupData.CSweepData.enable = true;
	
}

void TCSymbolEditorView::OnUpdateRunEnablefourier(CCmdUI* pCmdUI) 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CTransientSetupData.fourier_enable);

	pCmdUI->ContinueRouting();	
}

void TCSymbolEditorView::OnRunEnablenoise() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CNoiseSetupData.enable = !CAnalysisSetup.CNoiseSetupData.enable;

//	if(CAnalysisSetup.CNoiseSetupData.enable) CAnalysisSetup.CACSetupData.CSweepData.enable = true;
	
}

void TCSymbolEditorView::OnUpdateRunEnablenoise(CCmdUI* pCmdUI) 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CNoiseSetupData.enable);

	pCmdUI->ContinueRouting();	
}

void TCSymbolEditorView::OnRunEnableoperatingpoint() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();

	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CDCSetupData.enable_operating_point = !CAnalysisSetup.CDCSetupData.enable_operating_point;
	
}

void TCSymbolEditorView::OnUpdateRunEnableoperatingpoint(CCmdUI* pCmdUI) 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();

	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(!!CAnalysisSetup.CDCSetupData.enable_operating_point);

	pCmdUI->ContinueRouting();	
}

void TCSymbolEditorView::OnRunEnablepolezero() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CPoleZeroSetupData.enable = !CAnalysisSetup.CPoleZeroSetupData.enable;

	if(CAnalysisSetup.CPoleZeroSetupData.enable) CAnalysisSetup.CACSetupData.CSweepData.enable = true;
	
}

void TCSymbolEditorView::OnUpdateRunEnablepolezero(CCmdUI* pCmdUI) 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CPoleZeroSetupData.enable);

	pCmdUI->ContinueRouting();	
}

void TCSymbolEditorView::OnRunStatistics() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CStatisticsSetupData.enable = !CAnalysisSetup.CStatisticsSetupData.enable;

	if(CAnalysisSetup.CStatisticsSetupData.enable)
	{
		CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = false;
		CAnalysisSetup.CReRun.enable	= false;
		CAnalysisSetup.CParametricSetupData.CSweepData.enable = false;
	}	
}

void TCSymbolEditorView::OnUpdateRunStatistics(CCmdUI* pCmdUI) 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CStatisticsSetupData.enable);

	pCmdUI->ContinueRouting();	
}

void TCSymbolEditorView::OnRunParametric() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CParametricSetupData.CSweepData.enable = !CAnalysisSetup.CParametricSetupData.CSweepData.enable;

	if(CAnalysisSetup.CParametricSetupData.CSweepData.enable)
	{
		CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = false;
		 CAnalysisSetup.CReRun.enable	= false;
		CAnalysisSetup.CStatisticsSetupData.enable = false;
	}	
}

void TCSymbolEditorView::OnUpdateRunParametric(CCmdUI* pCmdUI) 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CParametricSetupData.CSweepData.enable);

	pCmdUI->ContinueRouting();	
}

void TCSymbolEditorView::OnRunPauseCont() 
{
	// TODO: Add your command handler code here
	
}

void TCSymbolEditorView::OnRunReruns() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.enable != E_RERUN_SWEEP_TYPE_WC_MODEL_FILES)
		CAnalysisSetup.CReRun.enable = E_RERUN_SWEEP_TYPE_WC_MODEL_FILES;
	else
		CAnalysisSetup.CReRun.enable = 0;


	if(CAnalysisSetup.CReRun.enable)
	{
		CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = false;
		CAnalysisSetup.CParametricSetupData.CSweepData.enable = false;
		CAnalysisSetup.CStatisticsSetupData.enable = false;
	}	
}

void TCSymbolEditorView::OnUpdateRunReruns(CCmdUI* pCmdUI) 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_MODEL_FILES ||
		CAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_WC_RERUN_FILE) pCmdUI->SetCheck(1);
	else pCmdUI->SetCheck(0);

	pCmdUI->ContinueRouting();	
}

void TCSymbolEditorView::OnRunEnableMonteCarlo()
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.enable != E_RERUN_SWEEP_TYPE_MC_RERUN_FILE)
		CAnalysisSetup.CReRun.enable = E_RERUN_SWEEP_TYPE_MC_RERUN_FILE;
	else
		CAnalysisSetup.CReRun.enable = 0;

	if(CAnalysisSetup.CReRun.enable)
	{
		if(CAnalysisSetup.CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_MULTY_RUNS)
			CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = false;
		
		CAnalysisSetup.CParametricSetupData.CSweepData.enable = false;
		CAnalysisSetup.CStatisticsSetupData.enable = false;
	}
}

void TCSymbolEditorView::OnUpdateRunEnableMonteCarlo(CCmdUI *pCmdUI)
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	if(CAnalysisSetup.CReRun.enable == E_RERUN_SWEEP_TYPE_MC_RERUN_FILE) pCmdUI->SetCheck(1);
	else pCmdUI->SetCheck(0);

	pCmdUI->ContinueRouting();
}

void TCSymbolEditorView::OnRunRun() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;
	
	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	PCDoc->PCParentSuperSpiceDoc->OnRunRun(this);		
}

void TCSymbolEditorView::OnRunRunSameNrtList() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;
	
	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	PCDoc->PCParentSuperSpiceDoc->OnRunRun(this, false);	
}

void TCSymbolEditorView::OnRunRundebugmode() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;
	
	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	PCDoc->PCParentSuperSpiceDoc->OnRunRunDebugMode(this);		
}

void TCSymbolEditorView::OnRunSensitivity() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CSensitivitySetupData.enable_ac = !CAnalysisSetup.CSensitivitySetupData.enable_ac;
	CAnalysisSetup.CSensitivitySetupData.enable_dc = CAnalysisSetup.CSensitivitySetupData.enable_ac;
	
}

void TCSymbolEditorView::OnUpdateRunSensitivity(CCmdUI* pCmdUI) 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CSensitivitySetupData.enable_ac);

	pCmdUI->ContinueRouting();	
}

void TCSymbolEditorView::OnRunStop() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	PCDoc->PCParentSuperSpiceDoc->OnRunStop();	
}

void TCSymbolEditorView::OnRunTemperature() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CTemperatureSetupData.CSweepData.enable = !CAnalysisSetup.CTemperatureSetupData.CSweepData.enable;

	if(CAnalysisSetup.CTemperatureSetupData.CSweepData.enable &&
	   CAnalysisSetup.CTemperatureSetupData.CSweepData.sweep_type == E_TEMPERATURE_SWEEP_MULTY_RUNS)
	{
		CAnalysisSetup.CParametricSetupData.CSweepData.enable = false;
		CAnalysisSetup.CStatisticsSetupData.enable = false;
		CAnalysisSetup.CReRun.enable = false;
	}	
}

void TCSymbolEditorView::OnUpdateRunTemperature(CCmdUI* pCmdUI) 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CTemperatureSetupData.CSweepData.enable);

	pCmdUI->ContinueRouting();	
}

void TCSymbolEditorView::OnRunTransient() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;
	
	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	CAnalysisSetup.CTransientSetupData.CSweepData.enable = !CAnalysisSetup.CTransientSetupData.CSweepData.enable;
	
}

void TCSymbolEditorView::OnUpdateRunTransient(CCmdUI* pCmdUI) 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;

	TCAnalysisSetup &CAnalysisSetup = PCDoc->PCParentSuperSpiceDoc->GetAnalysisSetup();

	pCmdUI->SetCheck(CAnalysisSetup.CTransientSetupData.CSweepData.enable);

	pCmdUI->ContinueRouting();	
}

void TCSymbolEditorView::OnRunCreatenetlist() 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;

	if(!PCDoc->GetParentSuperSpiceDoc()) return;	

	PCDoc->PCParentSuperSpiceDoc->OnRunCreateNetlist();	
}


void TCSymbolEditorView::OnLButtonDown(UINT nFlags, CPoint CMousePosition) 
{
	CSuperSpiceViewData.CLastLBDownMousePosition = CMousePosition;

	if(CSuperSpiceViewData.PCMSchematicManager)
	{
		TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

		PCDoc->OnViewSetZoomCenter(this, CMousePosition);
	}

	if(CSuperSpiceViewData.PCMSchematicManager)

	switch(CSuperSpiceViewData.system_state)
	{
		case E_GRAPHICS_MANAGER_STATE_IDLE:					IdleLBDown(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED:	GraphicsSelectedLBDown(nFlags, CMousePosition); break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING:		GraphicsMovingLBDown(nFlags, CMousePosition);break;	
		case E_GRAPHICS_MANAGER_STATE_SELECT_REGION:		SelectRegionLBDown(nFlags, CMousePosition);break;		 
		case E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC:			GotGraphicLBDown(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD:		GotClipboardLBDown(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE:			DrawingWireLBDown(nFlags, CMousePosition); break;
		case E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE:	WaitingToDrawWireLBDown(nFlags, CMousePosition); break;

		default: IdleOnCancel();
	}
	
	CView::OnLButtonDown(nFlags, CMousePosition);
}

void TCSymbolEditorView::OnLButtonUp(UINT nFlags, CPoint CMousePosition) 
{
	if(CSuperSpiceViewData.PCMSchematicManager)	
	switch(CSuperSpiceViewData.system_state)
	{
		case E_GRAPHICS_MANAGER_STATE_IDLE:					IdleLBUp(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED:	GraphicsSelectedLBUp(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING:		GraphicsMovingLBUp(nFlags, CMousePosition); break;	
		case E_GRAPHICS_MANAGER_STATE_SELECT_REGION:		SelectRegionLBUp(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC:			GotGraphicLBUp(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD:		GotClipboardLBUp(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE:			break;//DrawingWireLBUp(nFlags, point); break;
		case E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE: break;//WaitingToDrawWireLBUp(nFlags, point); break;

		default: IdleOnCancel();
	}
	
	CView::OnLButtonUp(nFlags, CMousePosition);
}

void TCSymbolEditorView::OnMouseMove(UINT nFlags, CPoint CMousePosition) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	if(CSuperSpiceViewData.CLastMousePosition == CMousePosition) return;

	CSuperSpiceViewData.CLastMousePosition = CMousePosition; 

	switch(CSuperSpiceViewData.system_state)
	{
		case E_GRAPHICS_MANAGER_STATE_IDLE:					IdleMouseMoved(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED:	GraphicsSelectedMouseMoved(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING:		GraphicsMovingMouseMoved(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_SELECT_REGION:		SelectRegionMouseMoved(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC:			GotGraphicMouseMoved(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD:		GotClipboardMouseMoved(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE:			DrawingWireMouseMoved(nFlags, CMousePosition);break;
		case E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE: WaitingToDrawWireMouseMoved(nFlags, CMousePosition);break;

		default: IdleOnCancel();
	}

	CView::OnMouseMove(nFlags, CMousePosition);
}

BOOL TCSymbolEditorView::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	pWnd; nHitTest;  message;

	if(!CSuperSpiceViewData.PCMSchematicManager) return true;

	int type = CSuperSpiceViewData.PCMSchematicManager->GetComponentOutlinedType();	

	if(type)
	{
		switch(type)
		{
			case E_SCHEMATIC_PIN: 
				{
					TCSchematicObject *PCSchematicObject = CSuperSpiceViewData.PCMSchematicManager->PCMLastOutlinedComponent;
	
					if(PCSchematicObject)
						if(!IsBadReadPtr(PCSchematicObject, 4))
							if(PCSchematicObject->m_type == E_WIRE_COMPONENT)
							//	m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_DRAW_LINE); 
						//	else m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;
							m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;
				}
			case E_SCHEMATIC_OBJECT:		m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;
			case E_SCHEMATIC_TEXT_LABEL:	m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;
			case E_SCHEMATIC_LABEL:			m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;
			case E_SCHEMATIC_WIRE:			m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;
			case E_SCHEMATIC_PIN_LABEL:		m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;

			
			default: m_hcursor = AfxGetApp()->LoadStandardCursor(IDC_ARROW);break;
		}
		if(CSuperSpiceViewData.system_state == E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE)
			m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_DRAW_LINE);

		if(CSuperSpiceViewData.system_state == E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE)
			m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_DRAW_LINE);

	}
	else
	{
		switch(CSuperSpiceViewData.system_state)
		{
			case E_GRAPHICS_MANAGER_STATE_IDLE:		
			 m_hcursor = AfxGetApp()->LoadStandardCursor(IDC_ARROW);break;
			case E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED:
			 m_hcursor = AfxGetApp()->LoadStandardCursor(IDC_ARROW);break;
			case E_GRAPHICS_MANAGER_STATE_SELECT_REGION:
			 m_hcursor = AfxGetApp()->LoadStandardCursor(IDC_ARROW);break;		 
			case E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC:
			 m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;
			case E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD:
			 m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_POINTING_FINGER);break;
			
			case E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE:			
			 m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_DRAW_LINE);break;
			
			case E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE: 
				m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_DRAW_LINE);break;

			case E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING:
				 m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_CLOSED_HAND);break;

			case E_GRAPHICS_MANAGER_STATE_WAVEFORM_ON_CLICK:  m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_SCOPE_PROBE);break;

			default: m_hcursor = AfxGetApp()->LoadStandardCursor(IDC_ARROW); break;
		}
	}
	SetCursor(m_hcursor);

	return true;
}

void TCSymbolEditorView::OnLButtonDblClk(UINT nFlags, CPoint CMousePosition) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CScrollView::OnLButtonDblClk(nFlags, CMousePosition);

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();
	
	if(CSuperSpiceViewData.system_state == E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE)
	{
		CSuperSpiceViewData.system_state = PCDoc->OnViewDrawingWireLBDblClk(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
	
		return;
	}

	PCDoc->OnLButtonDblClk(this, CMousePosition, nFlags);

	CView::OnLButtonDblClk(nFlags, CMousePosition);
}

void TCSymbolEditorView::GetComponent(int graphic_id, short version)
{
	if(CSuperSpiceViewData.PCMSchematicManager)

	OnCancelCommand();

	if(graphic_id)
		CGlobalStatusMessage = E_STATUS_MSG_PLACING_COMPONENT;
	else CGlobalStatusMessage = E_STATUS_MSG_GETING_LIB_COMPONENT;

	switch(CSuperSpiceViewData.system_state)
	{
		case E_GRAPHICS_MANAGER_STATE_IDLE:					IdleGetGraphic(graphic_id, version);break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED:	GraphicsSelectedGetGraphic(graphic_id, version); break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING:		GraphicsMovingGetGraphic(graphic_id, version);break;	
		case E_GRAPHICS_MANAGER_STATE_SELECT_REGION:		SelectRegionGetGraphic(graphic_id, version);break;		 
		case E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC:			GotGraphicGetGraphic(graphic_id, version);break;
		case E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD:		GotClipboardGetGraphic(graphic_id, version);break;


		default: IdleOnCancel();
	}
}

void TCSymbolEditorView::OnCancelCommand() 
{
	CGlobalStatusMessage = E_STATUS_MSG_IDLE;

	m_hcursor = AfxGetApp()->LoadStandardCursor(IDC_ARROW);
	SetCursor(m_hcursor);

	if(CSuperSpiceViewData.PCMSchematicManager)	
	switch(CSuperSpiceViewData.system_state)
	{
		case E_GRAPHICS_MANAGER_STATE_IDLE:					IdleOnCancel();break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED:	GraphicsSelectedOnCancel();break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING:		GraphicsMovingOnCancel(); break;	
		case E_GRAPHICS_MANAGER_STATE_SELECT_REGION:		SelectRegionOnCancel();break;
		case E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC:			GotGraphicOnCancel();break;
		case E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD:		GotClipboardOnCancel();break;
		case E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE:			DrawingWireOnCancel();
		case E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE: WaitingToDrawWireOnCancel(); break;

		default: break;
	}	
}

void TCSymbolEditorView::OnTimer(UINT_PTR nIDEvent) 
{
	TCSymbolEditorDoc* PCDoc = (TCSymbolEditorDoc *) GetDocument();
	
	if(!PCDoc) return;
	
	if(PCDoc->PCParentSuperSpiceDoc)
		if(!PCDoc->GetParentSuperSpiceDoc()->PCSuperSpiceViewTimer)
		{
			KillTimer(1);

			return;
		}

	PCDoc->TimerCallBack();

	CView::OnTimer(nIDEvent);
	
	CScrollView::OnTimer(nIDEvent);
}

void TCSymbolEditorView::OnEditCopy() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();	

	CSuperSpiceViewData.system_state = PCDoc->OnViewEditCopy(this);	
}

void TCSymbolEditorView::OnEditCopyWithPaste() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewEditCopy(this);

	CSuperSpiceViewData.system_state = PCDoc->OnViewEditPaste(this, CSuperSpiceViewData.CLastMousePosition);
	
}

void TCSymbolEditorView::OnEditCut() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();
	
	CSuperSpiceViewData.system_state = PCDoc->OnViewEditCut(this);	
}

void TCSymbolEditorView::OnEditDelete() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();
	
	CSuperSpiceViewData.system_state = PCDoc->OnViewEditDelete(this);	
}

void TCSymbolEditorView::OnEditPaste1() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();
	
	CSuperSpiceViewData.system_state = PCDoc->OnViewEditPaste(this, CSuperSpiceViewData.CLastMousePosition);
	
}
void TCSymbolEditorView::OnEditPaste() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();
	
	CSuperSpiceViewData.system_state = PCDoc->OnViewEditPaste(this, CSuperSpiceViewData.CLastMousePosition);
	
}
void TCSymbolEditorView::OnEditSelectall() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();
	
	CSuperSpiceViewData.system_state = PCDoc->OnViewEditSelectAll(this);	
}

void TCSymbolEditorView::OnCancelEditCntr() 
{
	OnCancelCommand();	
}

void TCSymbolEditorView::IdleGetGraphic(int graphic_id, short version)
{
	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewIdleStateGetGraphic(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition, graphic_id, version);
}

void TCSymbolEditorView::GraphicsSelectedGetGraphic(int graphic_id, short version)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsSelectedStateGetGraphic(this, CSuperSpiceViewData.page_id,CSuperSpiceViewData.CLastMousePosition, graphic_id, version);
}

void TCSymbolEditorView::GraphicsMovingGetGraphic(int graphic_id, short version)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsMovingStateGetGraphic(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition, graphic_id, version);
}
	
void TCSymbolEditorView::SelectRegionGetGraphic(int graphic_id, short version)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewSelectRegionStateGetGraphic(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition, graphic_id, version);
}	
	 
void TCSymbolEditorView::GotGraphicGetGraphic(int graphic_id, short version)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotGraphicStateGetGraphic(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition, graphic_id, version);
}
 
void TCSymbolEditorView::GotClipboardGetGraphic(int graphic_id, short version)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotClipboardGetGraphic(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition, graphic_id, version);
}

void TCSymbolEditorView::IdleLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewIdleStateLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);	
}

void TCSymbolEditorView::GraphicsSelectedLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsSelectedStateLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);

}


void TCSymbolEditorView::GraphicsMovingLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsMovingStateLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSymbolEditorView::SelectRegionLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewSelectRegionStateLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}


void TCSymbolEditorView::GotGraphicLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotGraphicStateLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);	
}

void TCSymbolEditorView::GotClipboardLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotClipboardLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);	
}

void TCSymbolEditorView::IdleLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewIdleStateLBUp(this,  CSuperSpiceViewData.page_id, nFlags,CMousePosition);
}

void TCSymbolEditorView::GraphicsSelectedLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsSelectedStateLBUp(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSymbolEditorView::GraphicsMovingLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsMovingStateLBUp(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSymbolEditorView::SelectRegionLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewSelectRegionStateLBUp(this, CSuperSpiceViewData.page_id, nFlags, CMousePosition);

}

void TCSymbolEditorView::GotGraphicLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotGraphicStateLBUp(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}


void TCSymbolEditorView::GotClipboardLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotClipboardLBUp(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);

}
void TCSymbolEditorView::IdleMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewIdleStateMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSymbolEditorView::GraphicsSelectedMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsSelectedStateMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSymbolEditorView::GraphicsMovingMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();
	
	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsMovingStateMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSymbolEditorView::SelectRegionMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewSelectRegionStateMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSymbolEditorView::GotGraphicMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotGraphicStateMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSymbolEditorView::GotClipboardMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotClipboardMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSymbolEditorView::IdleOnCancel(void)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewIdleOnCancel(this);
}

void TCSymbolEditorView::GraphicsSelectedOnCancel(void)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsSelectedOnCancel(this);
}

void TCSymbolEditorView::GraphicsMovingOnCancel(void)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsMovingOnCancel(this);	
}

void TCSymbolEditorView::SelectRegionOnCancel(void)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewSelectRegionOnCancel(this);
}

void TCSymbolEditorView::GotGraphicOnCancel(void)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotGraphicOnCancel(this);
}

void TCSymbolEditorView::GotClipboardOnCancel(void)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotClipboardOnCancel(this);
}

void TCSymbolEditorView::DrawingWireOnCancel(void)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewDrawingWireOnCancel(this);
}

void TCSymbolEditorView::WaitingToDrawWireOnCancel()
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewWaitingToDrawWireOnCancel(this);
}

void TCSymbolEditorView::DrawingWireDrawWire()
{
	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewDrawingWireDrawWire(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition);
}

void TCSymbolEditorView::DrawingWireGetGraphic(int graphic_id, short version)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewDrawingWireGetGraphic(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition, graphic_id, version);
}

void TCSymbolEditorView::WaitingToDrawWireDrawWire()
{
	return;
}

void TCSymbolEditorView::DrawingWireLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewDrawingWireLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);	
}

void TCSymbolEditorView::WaitingToDrawWireLBDown(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewWaitingToDrawWireLBDown(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);	
}

void TCSymbolEditorView::DrawingWireLBUp(UINT nFlags, CPoint CMousePosition)
{
	// not called
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewDrawingWireLBUp(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSymbolEditorView::WaitingToDrawWireLBUp(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewWaitingToDrawWireLBUp(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);

}

void TCSymbolEditorView::DrawingWireMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewDrawingWireMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

void TCSymbolEditorView::WaitingToDrawWireMouseMoved(UINT nFlags, CPoint CMousePosition)
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	CSuperSpiceViewData.system_state = PCDoc->OnViewWaitingToDrawWireMouseMoved(this,  CSuperSpiceViewData.page_id, nFlags, CMousePosition);
}

///////////////////
void TCSymbolEditorView::OnArowUp() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CPoint CNewPosition;

	CNewPosition = GetScrollBarPosition();

	CNewPosition.y -= CSuperSpiceViewData.CLineSize.cy;

	SetScrollBarPosition(CNewPosition);

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	PCDoc->OnViewOnDraw(this, NULL);	
}

void TCSymbolEditorView::OnArrowDown() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CPoint CNewPosition;

	CNewPosition = GetScrollBarPosition();

	CNewPosition.y += CSuperSpiceViewData.CLineSize.cy;

	SetScrollBarPosition(CNewPosition);

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	PCDoc->OnViewOnDraw(this, NULL);	
}

void TCSymbolEditorView::OnArrowLeft() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CPoint CNewPosition;

	CNewPosition = GetScrollBarPosition();

	CNewPosition.x -= CSuperSpiceViewData.CPageSize.cx;

	SetScrollBarPosition(CNewPosition);

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	PCDoc->OnViewOnDraw(this, NULL);	
}

void TCSymbolEditorView::OnArrowRight() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CPoint CNewPosition;

	CNewPosition = GetScrollBarPosition();

	CNewPosition.x += CSuperSpiceViewData.CPageSize.cx;

	SetScrollBarPosition(CNewPosition);

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	PCDoc->OnViewOnDraw(this, NULL);	
}

void TCSymbolEditorView::OnPageDown() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CPoint CNewPosition;

	CNewPosition = GetScrollBarPosition();

	CNewPosition.y += CSuperSpiceViewData.CPageSize.cy;

	SetScrollBarPosition(CNewPosition);

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	PCDoc->OnViewOnDraw(this, NULL);	
}

void TCSymbolEditorView::OnPageUp() 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CPoint CNewPosition;

	CNewPosition = GetScrollBarPosition();

	CNewPosition.y -= CSuperSpiceViewData.CPageSize.cy;

	SetScrollBarPosition(CNewPosition);

	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	PCDoc->OnViewOnDraw(this, NULL);
	
}

void TCSymbolEditorView::OnComponentsLeftpointingpin() 
{
	GetComponent(E_SYMBOL_POINTING_LEFT_PIN_COMPONENT);	
}

void TCSymbolEditorView::OnComponentsRightpointingpin() 
{
	GetComponent(E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT);	
}

void TCSymbolEditorView::OnComponentsUppointingpin() 
{
	GetComponent(E_SYMBOL_POINTING_UP_PIN_COMPONENT);	
}

void TCSymbolEditorView::OnComponentsDownpointingpin() 
{
	GetComponent(E_SYMBOL_POINTING_DOWN_PIN_COMPONENT);	
}


void TCSymbolEditorView::OnDrawLine() 
{
	if(CSuperSpiceViewData.PCMSchematicManager)

	CGlobalStatusMessage = E_STATUS_MSG_WAITING_TO_DRAW_WIRE;

	m_hcursor = AfxGetApp()->LoadCursor(IDC_CURSOR_DRAW_LINE);
	SetCursor(m_hcursor);

	switch(CSuperSpiceViewData.system_state)
	{
		case E_GRAPHICS_MANAGER_STATE_IDLE:					IdleDrawWire();break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED:	GraphicsSelectedDrawWire(); break;
		case E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING:		GraphicsMovingDrawWire();break;	
		case E_GRAPHICS_MANAGER_STATE_SELECT_REGION:		SelectRegionDrawWire();break;		 
		case E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC:			GotClipboardDrawWire();break;
		case E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD:		DrawingWireDrawWire();break;
		case E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE: WaitingToDrawWireDrawWire(); break;
	
		default: break;
	}
}

void TCSymbolEditorView::IdleDrawWire()
{
	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *) GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewIdleDrawWire(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition);
}

void TCSymbolEditorView::GraphicsSelectedDrawWire()
{
	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *) GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsSelectedDrawWire(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition);
}
void TCSymbolEditorView::GraphicsMovingDrawWire()
{
	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *) GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewGraphicsMovingDrawWire(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition);
}

void TCSymbolEditorView::SelectRegionDrawWire()	
{
	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *) GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewSelectRegionDrawWire(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition);
}

void TCSymbolEditorView::GotClipboardDrawWire()
{
	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *) GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSuperSpiceViewData.system_state = PCDoc->OnViewGotClipboardDrawWire(this,  CSuperSpiceViewData.page_id, CSuperSpiceViewData.CLastMousePosition);
}

/////////////////////
void TCSymbolEditorView::OnDrawingZoomin() 
{
	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc->OnViewZoomIn(this);

	float zoom = CSuperSpiceViewData.PCMSchematicManager->GetZoom();

	CSize CMaxSize(CSuperSpiceViewData.CMaxSize.cx,
					 CSuperSpiceViewData.CMaxSize.cy);

	CMaxSize.cx = (int)(CSuperSpiceViewData.CMaxSize.cx * zoom);
	CMaxSize.cy = (int)(CSuperSpiceViewData.CMaxSize.cy * zoom);

	// MFC asserts for this, presumably due to 16 bit problems
	// need to correct this later
	if(CMaxSize.cx > 32767) CMaxSize.cx = 32767;
	if(CMaxSize.cy> 32767) CMaxSize.cy	= 32767;

	SetScrollSizes(MM_TEXT, CMaxSize, CSuperSpiceViewData.CPageSize, CSuperSpiceViewData.CLineSize);	
}

void TCSymbolEditorView::OnUpdateDrawingZoomin(CCmdUI* pCmdUI) 
{
	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	if(PCDoc->OnViewCheckZoomIn(this))
	{
		pCmdUI->Enable();
	}
	else
	{
		pCmdUI->Enable(false);
	}	
}

void TCSymbolEditorView::OnDrawingZoomout() 
{
	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CSize CPageSize(CSuperSpiceViewData.CMaxSize.cx,
					 CSuperSpiceViewData.CMaxSize.cy);

	PCDoc->OnViewZoomOut(this);
	
	float zoom = CSuperSpiceViewData.PCMSchematicManager->GetZoom();

	CPageSize.cx = (int)(CSuperSpiceViewData.CMaxSize.cx * zoom);
	CPageSize.cy = (int)(CSuperSpiceViewData.CMaxSize.cy * zoom);

	if(CPageSize.cx > 32767) CPageSize.cx = 32767;
	if(CPageSize.cy> 32767) CPageSize.cy	= 32767;

	SetScrollSizes(MM_TEXT, CPageSize, CSuperSpiceViewData.CPageSize, CSuperSpiceViewData.CLineSize);
		
}

void TCSymbolEditorView::OnUpdateDrawingZoomout(CCmdUI* pCmdUI) 
{
	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	if(PCDoc->OnViewCheckZoomOut(this))
	{
		pCmdUI->Enable();
	}
	else
	{
		pCmdUI->Enable(false);
	}	
}
void TCSymbolEditorView::OnDrawingZoomCenter() 
{
	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	PCDoc;
//	PCDoc->OnViewZoomCenter(this, GlobalMousePosition);	
}

void TCSymbolEditorView::OnUpdateDrawingZoomCenter(CCmdUI* pCmdUI) 
{
	pCmdUI;	
}


void TCSymbolEditorView::OnPropertyAccelerater() 
{
	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();

	PCDoc->OnViewPropertyAccelerater(this);		
}

void TCSymbolEditorView::OnFileSave() 
{
	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();	

	PCDoc->OnFileSave(this);
}

void TCSymbolEditorView::OnDrawWire() 
{
	OnDrawLine();
}

void TCSymbolEditorView::OnDrawWireImmediatly() 
{
	OnDrawLine();	
}

void TCSymbolEditorView::OnComponentsComponentlibary() 
{
	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();	

	PCDoc->DisplayComponentLib(this, "", "");	
}



void TCSymbolEditorView::OnComponentsPinsSetup() 
{
	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();	

	PCDoc->OnComponentsPinsSetup(this);
}

void TCSymbolEditorView::OnComponentsResetPinNumbering() 
{
	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();	

	PCDoc->OnComponentsResetPinNumbering(this);	
}

void TCSymbolEditorView::OnSetFocus(CWnd* pOldWnd) 
{
	CScrollView::OnSetFocus(pOldWnd);
	
	PCSuperSpiceDocLastFocused = NULL;
	PCSuperSpiceViewLastFocused  = NULL;	
}

void TCSymbolEditorView::OnEditUndelete() 
{
	TCSymbolEditorDoc *PCDoc = (TCSymbolEditorDoc *)GetDocument();	

	PCDoc->OnViewUndelete(this);	
}

void TCSymbolEditorView::OnUpdateEditUndelete(CCmdUI* pCmdUI) 
{
	if(CSuperSpiceViewData.PCMSchematicManager->CMGraphicDeleteList.GetSize()) pCmdUI->Enable(true);
	else pCmdUI->Enable(false);	
}




