#if !defined(AFX_TCSYMBOLEDITORVIEW_H__5132B801_B6C4_11D3_B17C_444553540000__INCLUDED_)
#define AFX_TCSYMBOLEDITORVIEW_H__5132B801_B6C4_11D3_B17C_444553540000__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// TCSymbolEditorView.h : header file
//
#include "TCSuperSpiceView.h"
/////////////////////////////////////////////////////////////////////////////
// TCSymbolEditorView view

class TCSymbolEditorView : public CScrollView
{
protected:


	TCSymbolEditorView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(TCSymbolEditorView)

// Attributes
public:

// Operations
public:

	HCURSOR m_hcursor;

	TCSuperSpiceViewData		CSuperSpiceViewData;
	WINDOWPLACEMENT				s_window_placment;
	bool						first_draw;

	void SetScrollSizesZoomed(float zoom);
	CPoint GetScrollBarPosition(void);
	void	SetScrollBarPosition(CPoint CScrollBarPosition);

	TCSchematicManager *GetSchematicManager(void);
	TE_GRAPHICS_MANAGER_SYSTEM_STATE GetState(void);
	void SetState(TE_GRAPHICS_MANAGER_SYSTEM_STATE sys_state);

	void GetComponent(int graphic_id, short version = 0);

	void IdleOnCancel(void);				// wrong way round in naming !!
	void GraphicsSelectedOnCancel(void);
	void GraphicsMovingOnCancel(void);	
	void SelectRegionOnCancel(void);
	void GotGraphicOnCancel(void);
	void GotClipboardOnCancel(void);
	void DrawingWireOnCancel(void);
	void WaitingToDrawWireOnCancel(void);

	void IdleGetGraphic(int graphic_id = 0, short version = 0);
	void GraphicsSelectedGetGraphic(int graphic_id = 0, short version = 0);
	void GraphicsMovingGetGraphic(int graphic_id = 0, short version = 0);	
	void SelectRegionGetGraphic(int graphic_id = 0, short version = 0);		 
	void GotGraphicGetGraphic(int graphic_id = 0, short version = 0);
	void GotClipboardGetGraphic(int graphic_id = 0, short version = 0);
	void DrawingWireGetGraphic(int graphic_id = 0, short version = 0);
	void WaitingToDrawWireGetGraphic(int graphic_id = 0, short version = 0);

	void IdleDrawWire();
	void GraphicsSelectedDrawWire();
	void GraphicsMovingDrawWire();	
	void SelectRegionDrawWire();		 
	void GotGraphicDrawWire();
	void GotClipboardDrawWire();
	void DrawingWireDrawWire();
	void WaitingToDrawWireDrawWire();

	void IdleLBDown(UINT nFlags, CPoint CMousePosition);
	void GraphicsSelectedLBDown(UINT nFlags, CPoint CMousePosition);
	void GraphicsMovingLBDown(UINT nFlags, CPoint CMousePosition);
	void SelectRegionLBDown(UINT nFlags, CPoint CMousePosition);
	void GotGraphicLBDown(UINT nFlags, CPoint CMousePosition);
	void GotClipboardLBDown(UINT nFlags, CPoint CMousePosition);
	void DrawingWireLBDown(UINT nFlags, CPoint CMousePosition);
	void WaitingToDrawWireLBDown(UINT nFlags, CPoint CMousePosition);

	void IdleLBUp(UINT nFlags, CPoint CMousePosition);
	void GraphicsSelectedLBUp(UINT nFlags, CPoint CMousePosition);
	void GraphicsMovingLBUp(UINT nFlags, CPoint CMousePosition);
	void SelectRegionLBUp(UINT nFlags, CPoint CMousePosition);
	void GotGraphicLBUp(UINT nFlags, CPoint CMousePosition);
	void GotClipboardLBUp(UINT nFlags, CPoint CMousePosition);
	void DrawingWireLBUp(UINT nFlags, CPoint CMousePosition);
	void WaitingToDrawWireLBUp(UINT nFlags, CPoint CMousePosition);

	void IdleMouseMoved(UINT nFlags, CPoint CMousePosition);
	void GraphicsSelectedMouseMoved(UINT nFlags, CPoint CMousePosition);
	void GraphicsMovingMouseMoved(UINT nFlags, CPoint CMousePosition);
	void SelectRegionMouseMoved(UINT nFlags, CPoint CMousePosition);	
	void GotGraphicMouseMoved(UINT nFlags, CPoint CMousePosition);
	void GotClipboardMouseMoved(UINT nFlags, CPoint CMousePosition);
	void DrawingWireMouseMoved(UINT nFlags, CPoint CMousePosition);
	void WaitingToDrawWireMouseMoved(UINT nFlags, CPoint CMousePosition);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(TCSymbolEditorView)
	public:
	virtual void Serialize(CArchive& ar);
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	virtual void OnInitialUpdate();     // first time after construct
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~TCSymbolEditorView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
	//{{AFX_MSG(TCSymbolEditorView)
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnViewDesignnotes();
	afx_msg void OnViewIncludedmodelsfile();
	afx_msg void OnViewIncludefile();
	afx_msg void OnViewSchematic();
	afx_msg void OnViewSchematicfiles();
	afx_msg void OnViewTopLevelFiles();
	afx_msg void OnViewSpiceText();
	afx_msg void OnViewOutputGraph();
	afx_msg void OnViewOutputText();
	afx_msg void OnRunAc();
	afx_msg void OnUpdateRunAc(CCmdUI* pCmdUI);
	afx_msg void OnRunCreatenetlist();
	afx_msg void OnRunDc();
	afx_msg void OnUpdateRunDc(CCmdUI* pCmdUI);
	afx_msg void OnRunEnabledistortion();
	afx_msg void OnUpdateRunEnabledistortion(CCmdUI* pCmdUI);
	afx_msg void OnRunEnablefourier();
	afx_msg void OnUpdateRunEnablefourier(CCmdUI* pCmdUI);
	afx_msg void OnRunEnablenoise();
	afx_msg void OnUpdateRunEnablenoise(CCmdUI* pCmdUI);
	afx_msg void OnRunEnableoperatingpoint();
	afx_msg void OnUpdateRunEnableoperatingpoint(CCmdUI* pCmdUI);
	afx_msg void OnRunEnablepolezero();
	afx_msg void OnUpdateRunEnablepolezero(CCmdUI* pCmdUI);
	afx_msg void OnRunStatistics();
	afx_msg void OnUpdateRunStatistics(CCmdUI* pCmdUI);
	afx_msg void OnRunParametric();
	afx_msg void OnUpdateRunParametric(CCmdUI* pCmdUI);
	afx_msg void OnRunPauseCont();
	afx_msg void OnRunReruns();
	afx_msg void OnRunRun();
	afx_msg void OnRunRunSameNrtList();
	afx_msg void OnRunRundebugmode();
	afx_msg void OnRunSensitivity();
	afx_msg void OnUpdateRunSensitivity(CCmdUI* pCmdUI);
	afx_msg void OnRunStop();
	afx_msg void OnRunTemperature();
	afx_msg void OnUpdateRunTemperature(CCmdUI* pCmdUI);
	afx_msg void OnRunTransient();
	afx_msg void OnUpdateRunTransient(CCmdUI* pCmdUI);
	afx_msg void OnUpdateRunReruns(CCmdUI* pCmdUI);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnCancelCommand();
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	afx_msg void OnEditCopy();
	afx_msg void OnEditCopyWithPaste();
	afx_msg void OnEditCut();
	afx_msg void OnEditDelete();
	afx_msg void OnEditPaste1();
	afx_msg void OnCancelEditCntr();
	afx_msg void OnArowUp();
	afx_msg void OnArrowDown();
	afx_msg void OnArrowLeft();
	afx_msg void OnArrowRight();
	afx_msg void OnPageDown();
	afx_msg void OnPageUp();
	afx_msg void OnComponentsLeftpointingpin();
	afx_msg void OnComponentsRightpointingpin();
	afx_msg void OnComponentsUppointingpin();
	afx_msg void OnComponentsDownpointingpin();
	afx_msg void OnDrawLine();
	afx_msg void OnDrawingZoomin();
	afx_msg void OnDrawingZoomout();
	afx_msg void OnDrawingZoomCenter();
	afx_msg void OnUpdateDrawingZoomCenter(CCmdUI* pCmdUI);
	afx_msg void OnUpdateDrawingZoomin(CCmdUI* pCmdUI);
	afx_msg void OnUpdateDrawingZoomout(CCmdUI* pCmdUI);
	afx_msg void OnEditSelectall();
	afx_msg void OnPropertyAccelerater();
	afx_msg void OnFileSave();
	afx_msg void OnDrawWire();
	afx_msg void OnDrawWireImmediatly();
	afx_msg void OnEditPaste();
	afx_msg void OnComponentsComponentlibary();
	afx_msg void OnComponentsPinsSetup();
	afx_msg void OnComponentsResetPinNumbering();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnEditUndelete();
	afx_msg void OnUpdateEditUndelete(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnRunEnableMonteCarlo();
	afx_msg void OnUpdateRunEnableMonteCarlo(CCmdUI *pCmdUI);
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TCSYMBOLEDITORVIEW_H__5132B801_B6C4_11D3_B17C_444553540000__INCLUDED_)
