// TCSymbolModelPropertyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "Generic.h"
#include "TESuperSpiceEnums.h"
#include "TEPropertyViewTypes.h"
#include "TCFileFunctions.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSymbolModelPropertyDlg.h"
#include "TCMasterSymbolDlg.h"
#include "TCMasterLibaryDlg.h"
#include "TCMasterModelDlg.h"
#include "TCSelectGenerator.h"
#include "TCGeneralReportsTab.h"
#include "TCWorkspaceTree.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCSymbolPropertyDlg, CPropertyPage)
IMPLEMENT_DYNCREATE(TCModelPropertyDlg, CPropertyPage)

extern TCSuperSpiceGlobalData	GCSuperSpiceGlobalData;
extern TCSuperSpiceDataBase GCSuperSpiceDataBase; 
extern int g_last_active_symbol_model_property_page;

extern TCGeneralReportsTab GCGeneralReportsTab;
extern TCWorkspaceTree GCWorkspaceTree;


/////////////////////////////////////////////////////////////////////////////
// TCSymbolPropertyDlg property page

TCSymbolPropertyDlg::TCSymbolPropertyDlg() : CPropertyPage(TCSymbolPropertyDlg::IDD)
{
	//{{AFX_DATA_INIT(TCSymbolPropertyDlg)
	CMComboSymbol = _T("");
	CMComboSymbolFile = _T("");
	CFileName = _T("");
	CFilePath = _T("");
	CChildFileName = _T("");
	CChildFilePath = _T("");
	CName = _T("");
	CMDescription = _T("");
	m_attached_model_type = -1;
	CMEditModelSelected = _T("");
	//}}AFX_DATA_INIT

	PCComponentDataBaseData = NULL;
	
	button_pressed = E_LIB_CANCEL;
	PCParent = NULL;
	PCParentSymbol = NULL;

	m_component_property_view_type = E_PROPERTY_DC_VOLTAGE_SOURCE;
	m_enable_vi_select = false;
}

TCSymbolPropertyDlg::~TCSymbolPropertyDlg()
{
}

void TCSymbolPropertyDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCSymbolPropertyDlg)
	DDX_Control(pDX, IDC_BUTTON_OPEN_SCHEMATIC, CButtonSelectSchematic);
	DDX_Control(pDX, IDC_BUTTON_PLACE_SYMBOL, CButtonPlaceSymbol);
	DDX_Control(pDX, IDC_BUTTON_SELECT_MODEL, CButtonSelectModel);
	DDX_Control(pDX, IDC_BUTTON_SELECT_SOURCE, CButtonSelectSource);
	DDX_Control(pDX, IDC_EDIT_SYMBOL_SCHEMATIC_PATH, CMEditChildFilePath);
	DDX_Control(pDX, IDC_EDIT_SYMBOL_SCHEMATIC, CMEditChildFileName);
	DDX_Control(pDX, IDC_EDIT_SYMBOL_FILE_NAME, CEditFileName);
	DDX_Control(pDX, IDC_EDIT_FILE_PATH, CEditFilePath);
	DDX_Control(pDX, IDC_COMBO_COMPONENT_SYMBOLS, CMComboSymbolList);
	DDX_Control(pDX, IDC_COMBO_COMPONENT_FILES, CMComboSymbolFilesList);
	DDX_CBString(pDX, IDC_COMBO_COMPONENT_SYMBOLS, CMComboSymbol);
	DDX_CBString(pDX, IDC_COMBO_COMPONENT_FILES, CMComboSymbolFile);
	DDX_Text(pDX, IDC_EDIT_SYMBOL_FILE_NAME, CFileName);
	DDX_Text(pDX, IDC_EDIT_FILE_PATH, CFilePath);
	DDX_Text(pDX, IDC_EDIT_SYMBOL_SCHEMATIC, CChildFileName);
	DDX_Text(pDX, IDC_EDIT_SYMBOL_SCHEMATIC_PATH, CChildFilePath);
	DDX_Text(pDX, IDC_EDIT_SYMBOL_NAME, CName);
	DDX_Text(pDX, IDC_EDIT_DESCRIPTION, CMDescription);
	DDX_Radio(pDX, IDC_RADIO_ATTACHED_MODEL, m_attached_model_type);
	DDX_Text(pDX, IDC_EDIT_MODEL_SELECTED, CMEditModelSelected);
	DDX_Control(pDX, IDC_RADIO_ATTACHED_MODEL4, CRadioSelectVISource);
	//}}AFX_DATA_MAP

	
}

void TCSymbolPropertyDlg::SetSymbolFileList(void)
{
	int count, p;

	CMComboSymbolFilesList.ResetContent();

	CArray <TCSymbolDataBaseData, TCSymbolDataBaseData &> &CFiles = GCSuperSpiceDataBase.CSymbolDataBase.CFileList;

	CMComboSymbolFile = GCSuperSpiceDataBase.CSymbolDataBase.CComboEdit;
	
	count = CFiles.GetSize();

	if(!count) CMComboSymbolFile = "";

	if(count) if(CMComboSymbolFile == "") CMComboSymbolFile = CFiles[0].CType;

	for(p = 0; p < count; p++)
	{
		CMComboSymbolFilesList.InsertString(-1, CFiles[p].CType);
	}

	if(count) CMComboSymbolFilesList.SetCurSel(GCSuperSpiceDataBase.CSymbolDataBase.index);
}

void TCSymbolPropertyDlg::SetSymbolList(void)
{
	int count, p;

	int index = GCSuperSpiceDataBase.CSymbolDataBase.index;

	CMComboSymbolList.ResetContent();

	count = GCSuperSpiceDataBase.CSymbolDataBase.CFileList.GetSize();
	
	if(!count) CMComboSymbol = "";

	if(!count) return;

	if(index >= count) 
	{
		GCSuperSpiceDataBase.CSymbolDataBase.index = 0;
		index = 0;
	}

	CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[index].CSymbolList;

	CMComboSymbol = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[index].CComboEdit;

	count = CSymbolList.GetSize();

	if(count) if(CMComboSymbol == "") CMComboSymbol = CSymbolList[0].CSymbolData.CName;

	for(p = 0; p < count; p++)
	{
		CMComboSymbolList.InsertString(-1, CSymbolList[p].CSymbolData.CName);
	}

	if(count) CMComboSymbolList.SetCurSel(GCSuperSpiceDataBase.CSymbolDataBase.CFileList[index].index);
}

void TCSymbolPropertyDlg::GetDisplay(void)
{
	if(!PCComponentDataBaseData) return;

	UpdateData(true);

//	FormatLabels();// Force vsource and others to sync

	bool no_symbols		= true;
	int	symbol_index	= 0; 

	int symbol_file_index = GCSuperSpiceDataBase.CSymbolDataBase.index;
	
	PCComponentDataBaseData->use_index			= true;
	PCComponentDataBaseData->symbol_file_index	= symbol_file_index;

	if(symbol_file_index < GCSuperSpiceDataBase.CSymbolDataBase.CFileList.GetSize())
	{
		symbol_index = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].index;
		
		PCComponentDataBaseData->symbol_index	= symbol_index;
		
		no_symbols = false;
	}
	else PCComponentDataBaseData->symbol_index = 0;

	GCSuperSpiceDataBase.CSymbolDataBase.CComboEdit = CMComboSymbolFile;

	CString CText;

	if(!no_symbols)
	{
		GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].CComboEdit = CName;

		CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].CSymbolList;

		if(symbol_index < CSymbolList.GetSize())
		{

			TCSchematicObjectData &CSymbol = CSymbolList[symbol_index];

			CSymbol.CSymbolData.CFileName		= CFileName;
			CSymbol.CSymbolData.CFilePath		= CFilePath;
			CSymbol.CSymbolData.CDescription	= CMDescription;
			CSymbol.attached_model_type			= (unsigned char)m_attached_model_type;
			CSymbol.CSymbolData.CChildFileName	= CChildFileName;
			CSymbol.CSymbolData.CChildFileName	= CChildFilePath;

			CSymbol.Rename(CName);

			PCComponentDataBaseData->CSymbolName		= CSymbol.CSymbolData.CName;
			PCComponentDataBaseData->CSymbolFileName	= CSymbol.CSymbolData.CFileName;
			PCComponentDataBaseData->CSymbolPathName	= CSymbol.CSymbolData.CFilePath;

			CSymbol.type = 0;//force all types to 0, need to modify later
		
			//for up for existing stuff
			if (CSymbol.attached_model_type == E_SPICE_SCHEMATIC || CSymbol.attached_model_type == E_SPICE_DOT_SUBCIRCUIT)// fixup
			{
				CSymbol.CSpiceParameters.CDataBaseIdInfo.CRecordType = "X";
			}

			if(CSymbol.attached_model_type != E_SPICE_GENERATOR)
				GCSuperSpiceDataBase.SetSymbolViewType(CSymbol, CSymbol.CSpiceParameters);

			if(CSymbol.attached_model_type == E_SPICE_GENERATOR) 
			{
				PCComponentDataBaseData->CModelName = "";// invalidate model
				PCComponentDataBaseData->CModelPathName = "";
				PCComponentDataBaseData->CModelFileName = "";
			}

			CSymbol.FormatLabels();
		}
	}
}

void TCSymbolPropertyDlg::SetNames(void)
{
	int symbol_file_index = GCSuperSpiceDataBase.CSymbolDataBase.index;
	int symbol_index;

	if(!(symbol_file_index < GCSuperSpiceDataBase.CSymbolDataBase.CFileList.GetSize())) return;

	symbol_index = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].index;

	CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].CSymbolList;

	if(!(symbol_index < CSymbolList.GetSize())) return;

	CName		= CSymbolList[symbol_index].CSymbolData.CName;
	CFileName	= CSymbolList[symbol_index].CSymbolData.CFileName;
	CFilePath	= CSymbolList[symbol_index].CSymbolData.CFilePath;
	CChildFileName = ExtractFileName(CSymbolList[symbol_index].CSymbolData.CChildFileName);
	CChildFilePath = ExtractPathName(CSymbolList[symbol_index].CSymbolData.CChildFileName);

	CMEditModelSelected = CSymbolList[symbol_index].CSpiceParameters.CDataBaseIdInfo.CRecordName;
	
	if(CSymbolList[symbol_index].attached_model_type == E_SPICE_SCHEMATIC)
		CMEditModelSelected = "";

	if(PCComponentDataBaseData) 
	{
		PCComponentDataBaseData->CModelName		= CSymbolList[symbol_index].CSpiceParameters.CDataBaseIdInfo.CRecordName;
		PCComponentDataBaseData->CModelFileName = CSymbolList[symbol_index].CSpiceParameters.CDataBaseIdInfo.CRecordFileName;
		PCComponentDataBaseData->CModelPathName = CSymbolList[symbol_index].CSpiceParameters.CDataBaseIdInfo.CRecordFilePath;
	}

	CMDescription = CSymbolList[symbol_index].CSymbolData.CDescription;
	
	PCComponentDataBaseData->symbol_file_index	= symbol_file_index;
	PCComponentDataBaseData->symbol_index		= symbol_index;

	m_attached_model_type = CSymbolList[symbol_index].attached_model_type;

	SetButtonStates();
}

void TCSymbolPropertyDlg::SetButtonStates(void)
{
//	if(m_enable_vi_select) CRadioSelectVISource.EnableWindow(true);
//	else CRadioSelectVISource.EnableWindow(false);
	CRadioSelectVISource.EnableWindow(true);
	CButtonSelectSchematic.EnableWindow(false);

	if(m_attached_model_type == E_SPICE_DOT_MODEL ||
		m_attached_model_type == E_SPICE_DOT_SUBCIRCUIT)
	{
		CButtonSelectModel.EnableWindow(true);
		CButtonSelectSource.EnableWindow(false);

		return;
	}

	if(m_attached_model_type == E_SPICE_SCHEMATIC || 
	   m_attached_model_type == -1)
	{
		CButtonSelectModel.EnableWindow(false);
		CButtonSelectSource.EnableWindow(false);
		CButtonSelectSchematic.EnableWindow(true);

		return;
	}
 
	CButtonSelectModel.EnableWindow(false);

//	if(m_enable_vi_select) CButtonSelectSource.EnableWindow(true);
//	else CButtonSelectSource.EnableWindow(false);
	CButtonSelectSource.EnableWindow(true);
}

void TCSymbolPropertyDlg::SetDisplay(void)
{
	SetSymbolFileList();
	SetSymbolList();
	SetNames();

	CEditFileName.SetReadOnly();
	CEditFilePath.SetReadOnly();
	CMEditChildFileName.SetReadOnly();
	SetButtonStates();// model select buttons

	UpdateData(false);

	CMComboSymbolFilesList.SetCurSel(GCSuperSpiceDataBase.CSymbolDataBase.index);
}

BEGIN_MESSAGE_MAP(TCSymbolPropertyDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCSymbolPropertyDlg)
	ON_BN_CLICKED(IDC_BUTTON_ADD_SYMBOL_FILE, OnButtonAddSymbolFile)
	ON_BN_CLICKED(IDC_BUTTON_REMOVE_SYMBOL_FILE, OnButtonRemoveSymbolFile)
	ON_BN_CLICKED(IDC_BUTTON_LOAD_SETUP, OnButtonLoadSetup)
	ON_BN_CLICKED(IDC_BUTTON_SAVE_SETUP, OnButtonSaveSetup)
	ON_CBN_SELCHANGE(IDC_COMBO_COMPONENT_FILES, OnSelchangeComboComponentFiles)
	ON_CBN_SELCHANGE(IDC_COMBO_COMPONENT_SYMBOLS, OnSelchangeComboComponentSymbols)
	ON_CBN_KILLFOCUS(IDC_COMBO_COMPONENT_SYMBOLS, OnKillfocusComboComponentSymbols)
	ON_EN_KILLFOCUS(IDC_EDIT_DESCRIPTION, OnKillfocusEditDescription)
	ON_BN_CLICKED(IDC_BUTTON_COPY_SYMBOL, OnButtonCopySymbol)
	ON_BN_CLICKED(IDC_BUTTON_COPY_SYMBOL_FILE, OnButtonCopySymbolFile)
	ON_BN_CLICKED(IDC_BUTTON_PASTE_SYMBOL, OnButtonPasteSymbol)
	ON_BN_CLICKED(IDC_BUTTON_PASTE_SYMBOL_FILE, OnButtonPasteSymbolFile)
	ON_BN_CLICKED(IDC_BUTTON_REMOVE_SYMBOL, OnButtonRemoveSymbol)
	ON_EN_KILLFOCUS(IDC_EDIT_SYMBOL_NAME, OnKillfocusEditSymbolName)
	ON_BN_CLICKED(IDC_RADIO_ATTACHED_MODEL, OnRadioAttachedModel)
	ON_BN_CLICKED(IDC_RADIO_ATTACHED_MODEL3, OnRadioAttachedSubcircuit)
	ON_BN_CLICKED(IDC_RADIO_ATTACHED_MODEL2, OnRadioAttachedSchematic)
	ON_BN_CLICKED(IDC_BUTTON_PLACE_SYMBOL, OnButtonPlaceSymbol)
	ON_BN_CLICKED(IDC_BUTTON_OPEN_SCHEMATIC, OnButtonBrowseSchematic)
	ON_BN_CLICKED(IDC_BUTTON_SAVE_SYMBOL_FILE, OnButtonSaveSymbolFile)
	ON_BN_CLICKED(IDC_BUTTON_NEW_SYMBOL_FILE, OnButtonNewSymbolFile)
	ON_BN_CLICKED(IDC_BUTTON_NEW_SYMBOL, OnButtonNewSymbol)
	ON_BN_CLICKED(IDC_BUTTON_SELECT_MODEL, OnButtonSelectModel)
	ON_BN_CLICKED(IDC_BUTTON_SELECT_SOURCE, OnButtonSelectSource)
	ON_BN_CLICKED(IDC_RADIO_ATTACHED_MODEL4, OnRadioAttachedModel4)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCModelPropertyDlg property page

TCModelPropertyDlg::TCModelPropertyDlg() : CPropertyPage(TCModelPropertyDlg::IDD)
{
	//{{AFX_DATA_INIT(TCModelPropertyDlg)
	CMComboModelFile = _T("");
	CMComboModel = _T("");
	CEditRecordName = _T("");
	CEditRecordFileName = _T("");
	CEditRecordPath = _T("");
	CMEditModelData = _T("");
	m_ignore_model_path = FALSE;
	//}}AFX_DATA_INIT

	PCComponentDataBaseData = NULL;
	m_check = false;
	attached_model_type = 0;
	m_ignore_model_path = true;
	enable_edit_model_file = false;

	PCParent = NULL;
}

TCModelPropertyDlg::~TCModelPropertyDlg()
{
}

void TCModelPropertyDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCModelPropertyDlg)
	DDX_Control(pDX, IDC_BUTTON_EDIT_MODEL_FILE, CMButtonEditModel);
	DDX_Control(pDX, IDC_EDIT_RECORD_FILE_PATH, CEditFilePath);
	DDX_Control(pDX, IDC_EDIT_RECORD_FILE_NAME, CEditFileName);
	DDX_Control(pDX, IDC_COMBO_MODEL_DATA, CMComboModelList);
	DDX_Control(pDX, IDC_COMBO_MODEL_FILES, CMComboModelFileList);
	DDX_CBString(pDX, IDC_COMBO_MODEL_FILES, CMComboModelFile);
	DDX_CBString(pDX, IDC_COMBO_MODEL_DATA, CMComboModel);
	DDX_Text(pDX, IDC_EDIT_RECORD_NAME, CEditRecordName);
	DDX_Text(pDX, IDC_EDIT_RECORD_FILE_NAME, CEditRecordFileName);
	DDX_Text(pDX, IDC_EDIT_RECORD_FILE_PATH, CEditRecordPath);
	DDX_Text(pDX, IDC_EDIT_SPICE_MODEL_DATA, CMEditModelData);
	DDX_Check(pDX, IDC_CHECK_IGNORE_MODEl_PATH, m_ignore_model_path);
	//}}AFX_DATA_MAP
}

void TCModelPropertyDlg::SetModelFileList(void)
{
	int count, p;

	CMComboModelFileList.ResetContent();

	CArray <TCModelDataBaseData, TCModelDataBaseData &> &CFiles = GCSuperSpiceDataBase.CModelDataBase.CFileList;

	CMComboModelFile = GCSuperSpiceDataBase.CModelDataBase.CComboEdit;
	
	count = CFiles.GetSize();

	if(!count) CMComboModelFile = "";

	if(count) if(CMComboModelFile == "") CMComboModelFile = CFiles[0].CType;

	for(p = 0; p < count; p++)
	{
		CMComboModelFileList.InsertString(-1, CFiles[p].CType);
	}

	if(count) CMComboModelFileList.SetCurSel(GCSuperSpiceDataBase.CModelDataBase.index);
}

void TCModelPropertyDlg::SetModelList(void)
{
	int count, p;

	int index = GCSuperSpiceDataBase.CModelDataBase.index;

	count = GCSuperSpiceDataBase.CModelDataBase.CFileList.GetSize();
	
	CMComboModelList.ResetContent();

	if(!count) CMComboModel = "";
	
	if(!count) return;

	if(index >= count) 
	{
		GCSuperSpiceDataBase.CModelDataBase.index = 0;
		index = 0;
	}

	TCSpiceParametersList &CModelList = GCSuperSpiceDataBase.CModelDataBase.CFileList[index].CParametersList;

	CMComboModel = GCSuperSpiceDataBase.CModelDataBase.CFileList[index].CComboEdit;

	count = CModelList.CParameters.GetSize();

	if(count) if(CMComboModel == "") CMComboModel = CModelList.CParameters[0].CDataBaseIdInfo.CRecordName;

	for(p = 0; p < count; p++)
	{
		CMComboModelList.InsertString(-1, CModelList.CParameters[p].CDataBaseIdInfo.CRecordName);
	}

	if(count) CMComboModelList.SetCurSel(GCSuperSpiceDataBase.CModelDataBase.CFileList[index].index);
}

void TCModelPropertyDlg::OnButtonRerunfile() 
{
	GetDisplay();
	
	CString CFileName;

	CFileName =	GCSuperSpiceDataBase.CreateReRunFileFromModel(CEditRecordPath, CEditRecordFileName, CEditRecordName);
	
	if(CFileName == "") 
	{
		AfxMessageBox(IDS_FAILED_CREATE_RERUN_MODEL);

		return;
	}

	AfxGetApp()->OpenDocumentFile(CFileName);
}

void TCModelPropertyDlg::GetDisplay(void)
{
	if(!PCComponentDataBaseData) return;

	UpdateData(true);

	bool	no_models	= true;
	int		model_index	= 0;

	GCSuperSpiceGlobalData.CGeneric.ignore_model_path = m_ignore_model_path;

	PCComponentDataBaseData->use_index = true;

	int model_file_index = GCSuperSpiceDataBase.CModelDataBase.index;

	PCComponentDataBaseData->model_file_index		= model_file_index;

	if(model_file_index < GCSuperSpiceDataBase.CModelDataBase.CFileList.GetSize())
	{
		model_index  = GCSuperSpiceDataBase.CModelDataBase.CFileList[model_file_index].index;
	
		PCComponentDataBaseData->model_index = model_index;

		no_models = false;
	}
	else PCComponentDataBaseData->model_index	= 0;

	GCSuperSpiceDataBase.CModelDataBase.CComboEdit	= CMComboModelFile;

	CString CText;

	if(!no_models)
	{
//		GCSuperSpiceDataBase.CModelDataBase.CFileList[model_file_index].CComboEdit = CMComboModel;
		GCSuperSpiceDataBase.CModelDataBase.CFileList[model_file_index].CComboEdit = CEditRecordName;

		TCSpiceParametersList &CModelList = GCSuperSpiceDataBase.CModelDataBase.CFileList[model_file_index].CParametersList;

		PCComponentDataBaseData->CModelName		= CText;

		if(model_index < CModelList.CParameters.GetSize())
		{
			GetText(CModelList, model_index);

			CModelList.CParameters[model_index].CDataBaseIdInfo.CRecordName		= CEditRecordName;
			CModelList.CParameters[model_index].CDataBaseIdInfo.CRecordFileName	= CEditRecordFileName; 
			CModelList.CParameters[model_index].CDataBaseIdInfo.CRecordFilePath = CEditRecordPath;

			CModelList.CParameters[model_index].Rename(CEditRecordName);

			PCComponentDataBaseData->CModelName	= CModelList.CParameters[model_index].CDataBaseIdInfo.CRecordName;
			PCComponentDataBaseData->CModelFileName	= CModelList.CParameters[model_index].CDataBaseIdInfo.CRecordFileName;
			PCComponentDataBaseData->CModelPathName	= CModelList.CParameters[model_index].CDataBaseIdInfo.CRecordFilePath;
		}
	}

	PCComponentDataBaseData->CComponentFileName;
	PCComponentDataBaseData->CComponentPathName;
	PCComponentDataBaseData->CComponentName;
}

void TCModelPropertyDlg::SetText(TCSpiceParametersList &CModelList, int index)
{
	CMEditModelData = "";

	CArray <CString, CString&> CTempModelData;

	CTempModelData.SetSize(0, 16);

	CModelList.CParameters[index].GetToText(CTempModelData);

	int count = CTempModelData.GetSize();

	int test = count - 1;

	for(int p = 0; p < count; p++)
	{
		CMEditModelData += CTempModelData[p];

		if(p < test) CMEditModelData += "\r\n";
	}
}

void TCModelPropertyDlg::GetText(TCSpiceParametersList &CModelList, int index)
{
	CArray <CString, CString&> CTempModelData;
	CString CText;

	int size;

	char *buff;

	size = CMEditModelData.GetLength();

	buff = CMEditModelData.GetBuffer(size + 1);


	while(*buff != 0)
	{
		if(*buff == '\r')
		{
			buff++;// ignore next \n that should be there !!??
			if(*buff == '\n') buff++;

			CTempModelData.Add(CText);

			CText = "";
		}
		else CText += *buff++;
	}

	if(CText != "")CTempModelData.Add(CText);

	CModelList.CParameters[index].SetFromText(CTempModelData);
}

void TCModelPropertyDlg::SetNames(void)
{
	int model_file_index = GCSuperSpiceDataBase.CModelDataBase.index;

	PCComponentDataBaseData->model_file_index		= model_file_index;

	if(!(model_file_index < GCSuperSpiceDataBase.CModelDataBase.CFileList.GetSize())) return;
	
	int model_index  = GCSuperSpiceDataBase.CModelDataBase.CFileList[model_file_index].index;

	TCSpiceParametersList &CModelList = GCSuperSpiceDataBase.CModelDataBase.CFileList[model_file_index].CParametersList;

	if(!(model_index < CModelList.CParameters.GetSize())) return;

	CEditRecordName		= CModelList.CParameters[model_index].CDataBaseIdInfo.CRecordName;
	CEditRecordFileName = CModelList.CParameters[model_index].CDataBaseIdInfo.CRecordFileName; 
	CEditRecordPath		= CModelList.CParameters[model_index].CDataBaseIdInfo.CRecordFilePath; 

	m_ignore_model_path = GCSuperSpiceGlobalData.CGeneric.ignore_model_path;

	SetText(CModelList, model_index);

	UpdateData(false);
}

void TCModelPropertyDlg::SetDisplay(void)
{
	SetModelFileList();
	SetModelList();
	SetNames();

	CEditFileName.SetReadOnly();
	CEditFilePath.SetReadOnly();

	UpdateData(false);

	CMComboModelFileList.SetCurSel(GCSuperSpiceDataBase.CModelDataBase.index);
}

BEGIN_MESSAGE_MAP(TCModelPropertyDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCModelPropertyDlg)
	ON_BN_CLICKED(IDC_BUTTON_ADD_MODEL_FILE, OnButtonAddModelFile)
	ON_BN_CLICKED(IDC_BUTTON_REMOVE_MODEL_FILE, OnButtonRemoveModelFile)
	ON_BN_CLICKED(IDC_BUTTON_SAVE_MODEL, OnButtonSaveModel)
	ON_CBN_SELCHANGE(IDC_COMBO_MODEL_DATA, OnSelchangeComboModelData)
	ON_CBN_SELCHANGE(IDC_COMBO_MODEL_FILES, OnSelchangeComboModelFiles)
	ON_CBN_KILLFOCUS(IDC_COMBO_MODEL_DATA, OnKillfocusComboModelData)
	ON_EN_KILLFOCUS(IDC_EDIT_SPICE_MODEL_DATA, OnKillfocusEditSpiceModelData)
	ON_BN_CLICKED(IDC_BUTTON_COPY_MODEL, OnButtonCopyModel)
	ON_BN_CLICKED(IDC_BUTTON_COPY_MODEL_FILE, OnButtonCopyModelFile)
	ON_BN_CLICKED(IDC_BUTTON_PASTE_MODEL_FILE, OnButtonPasteModelFile)
	ON_BN_CLICKED(IDC_BUTTON_REMOVE_MODEL, OnButtonRemoveModel)
	ON_BN_CLICKED(IDC_BUTTON_PASTE_MODEL, OnButtonPasteModel)
	ON_EN_KILLFOCUS(IDC_EDIT_RECORD_NAME, OnKillfocusEditRecordName)
	ON_BN_CLICKED(IDC_BUTTON_EDIT_MODEL_FILE, OnButtonEditModelFile)
	ON_BN_CLICKED(IDC_BUTTON_RERUNFILE, OnButtonRerunfile)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



BOOL TCSymbolPropertyDlg::OnKillActive() 
{
	int value =  CPropertyPage::OnKillActive();

	if(value)
	{
		GetDisplay();
	}
	return value;
}

BOOL TCSymbolPropertyDlg::OnSetActive() 
{
	g_last_active_symbol_model_property_page = 0;
	
	return CPropertyPage::OnSetActive();
}

BOOL TCSymbolPropertyDlg::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	SetDisplay();
	
	//i.e if started from the symbol editor
	if(m_enable_vi_select) CButtonPlaceSymbol.SetWindowText("Edit Symbol");
	
	return TRUE;  
}

BOOL TCModelPropertyDlg::OnKillActive() 
{
	int value =  CPropertyPage::OnKillActive();

	if(value)
	{
		GetDisplay();
	}
	return value;
}

BOOL TCModelPropertyDlg::OnSetActive() 
{
	g_last_active_symbol_model_property_page = 1;

	return CPropertyPage::OnSetActive();
}

BOOL TCModelPropertyDlg::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	CMButtonEditModel.EnableWindow(false);

	SetDisplay();

	if(enable_edit_model_file) CMButtonEditModel.EnableWindow(true);

	return TRUE; 
}

void TCModelPropertyDlg::OnButtonAddModelFile() 
{
	CString CFileName;

	CString CFileDescriptor;
	
	CFileDescriptor.LoadString(IDS_STRING_MODEL_FILE_DESCRIPTOR);

	CFileDialog	CLoadFileDialog(true, "lib",GCSuperSpiceGlobalData.CGeneric.CDataBaseLastModelFileName, 0, CFileDescriptor);

	if(CLoadFileDialog.DoModal() != IDOK) 
	{
		CFileName = CLoadFileDialog.GetPathName();

		return;
	}

	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return;

	GCSuperSpiceGlobalData.CGeneric.CDataBaseLastModelFileName = CFileName;

	BeginWaitCursor();

	if(!GCSuperSpiceDataBase.AddModelFile(CFileName))
	{
		AfxMessageBox(IDS_ERR_ADD_MODEL_FILE);

		return;
	}

	SetDisplay();

	EndWaitCursor();
}

void TCModelPropertyDlg::OnButtonRemoveModelFile() 
{
	if(!GCSuperSpiceDataBase.CModelDataBase.CFileList.GetSize()) return;

	if(!GCSuperSpiceDataBase.RemoveModelFile(GCSuperSpiceDataBase.CModelDataBase.index))
	{
		AfxMessageBox(IDS_ERR_REMOVE_MODELFILE);

		return;
	}

	SetDisplay();
}

void TCModelPropertyDlg::OnButtonSaveModel() 
{
	GetDisplay();

	int index = GCSuperSpiceDataBase.CModelDataBase.index;

	if(index < 0) return;

	if(index < GCSuperSpiceDataBase.CModelDataBase.CFileList.GetSize())
	{
		if(!GCSuperSpiceDataBase.CModelDataBase.CFileList[index].Save()) AfxMessageBox(IDS_NO_FILE_SAVE);
	}
}

void TCModelPropertyDlg::OnButtonEditModelFile() 
{
	if(!PCParent) return;

	GetDisplay();

	int model_file_index = GCSuperSpiceDataBase.CModelDataBase.index;

	if(model_file_index < 0) return;

	if(!(model_file_index < GCSuperSpiceDataBase.CModelDataBase.CFileList.GetSize())) return;

	CArray <TCModelDataBaseData, TCModelDataBaseData &> &CFiles = GCSuperSpiceDataBase.CModelDataBase.CFileList;

	CEditModelFileName = CFiles[model_file_index].CPath + CFiles[model_file_index].CName;

	PCParent->PressButton(PSBTN_OK);
}

void TCSymbolPropertyDlg::OnButtonSaveSymbolFile() 
{
	GetDisplay();

	int index = GCSuperSpiceDataBase.CSymbolDataBase.index;

	if(index < 0) return;

	if(index < GCSuperSpiceDataBase.CSymbolDataBase.CFileList.GetSize())
	{
		if(!GCSuperSpiceDataBase.CSymbolDataBase.CFileList[index].Save()) AfxMessageBox(IDS_NO_FILE_SAVE);
	}
}

void TCSymbolPropertyDlg::OnButtonAddSymbolFile() 
{
	CString CFileName;

	CFileDialog	CLoadFileDialog(true, "ssm",GCSuperSpiceGlobalData.CGeneric.CDataBaseLastSymbolFileName, 0,"SuperSpice Component Files  (*.ssm)| *.ssm||");

	if(CLoadFileDialog.DoModal() != IDOK)
	{
		CFileName = CLoadFileDialog.GetPathName();

		return;
	}

	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return;

	GCSuperSpiceGlobalData.CGeneric.CDataBaseLastSymbolFileName = CFileName;

	BeginWaitCursor();

	if(!GCSuperSpiceDataBase.AddSymbolFile(CFileName))
	{
		AfxMessageBox(IDS_ERR_ADD_SYM_FILE);

		return;
	}

	SetDisplay();

	EndWaitCursor();
}

void TCSymbolPropertyDlg::OnButtonRemoveSymbolFile() 
{
	if(!GCSuperSpiceDataBase.RemoveSymbolFile(GCSuperSpiceDataBase.CSymbolDataBase.index))
	{
		AfxMessageBox(IDS_ERR_REMOVE_SYM_FILE);

		return;
	}

	SetDisplay();
}

void TCSymbolPropertyDlg::OnButtonLoadSetup() 
{
	CString CFileName;

	CFileName = GCSuperSpiceGlobalData.CGeneric.CDataBaseInitFileName;

	CFileDialog	CLoadFileDialog(true, "sdb",CFileName, 0,"SuperSpice DB Files  (*.sdb)| *.sdb||");

	if(CLoadFileDialog.DoModal() != IDOK) return;

	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return;

	if(!GCSuperSpiceDataBase.LoadAs(CFileName))
	{
		AfxMessageBox(IDS_ERR_IN_DB_FILE);

		SetDisplay();

		return;
	}

	GCSuperSpiceGlobalData.CGeneric.CDataBaseInitFileName = CFileName;

	SetDisplay();
}

void TCSymbolPropertyDlg::OnButtonSaveSetup() 
{
	CString CFileName;

	CFileName = GCSuperSpiceGlobalData.CGeneric.CDataBaseInitFileName;

	CFileDialog	CSaveFileDialog(false, "sdb", CFileName, 0, "SuperSpice DB Files  (*.sdb)| *.sdb||");

	if(CSaveFileDialog.DoModal() != IDOK) return;

	CFileName = CSaveFileDialog.GetPathName();

	if(CFileName == "") return;

	if(!GCSuperSpiceDataBase.SaveAs(CFileName))
	{
		AfxMessageBox(IDS_ERR_SAVE_DB_FILE);

		return;
	}

	GCSuperSpiceGlobalData.CGeneric.CDataBaseInitFileName = CFileName;
}

void TCSymbolPropertyDlg::OnSelchangeComboComponentFiles() 
{
	GetDisplay();

	int index = CMComboSymbolFilesList.GetCurSel();

	if(index < 0) index = 0;

	GCSuperSpiceDataBase.CSymbolDataBase.index = index;

	CArray <TCSymbolDataBaseData, TCSymbolDataBaseData &> &CFiles = GCSuperSpiceDataBase.CSymbolDataBase.CFileList;

	if(!(index < CFiles.GetSize())) return;

	GCSuperSpiceDataBase.CSymbolDataBase.CComboEdit = CFiles[index].CType;

	CMComboSymbolFile = CFiles[index].CType;

	SetDisplay();

	CMComboSymbolFilesList.SetCurSel(GCSuperSpiceDataBase.CSymbolDataBase.index);
}

void TCSymbolPropertyDlg::OnSelchangeComboComponentSymbols() 
{
	GetDisplay();

	int index = CMComboSymbolList.GetCurSel();

	if(index < 0) index = 0;
	
	if(GCSuperSpiceDataBase.CSymbolDataBase.index >= GCSuperSpiceDataBase.CSymbolDataBase.CFileList.GetSize()) return;

	GCSuperSpiceDataBase.CSymbolDataBase.CFileList[GCSuperSpiceDataBase.CSymbolDataBase.index].index = index;

	if(PCComponentDataBaseData) PCComponentDataBaseData->symbol_index = index;

	CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[GCSuperSpiceDataBase.CSymbolDataBase.index].CSymbolList;

	if(!(index < CSymbolList.GetSize())) return;

	GCSuperSpiceDataBase.CSymbolDataBase.CFileList[GCSuperSpiceDataBase.CSymbolDataBase.index].CComboEdit = CSymbolList[index].CSymbolData.CName;

	CMComboSymbol = CSymbolList[index].CSymbolData.CName;

//	SetDisplay();

	SetNames();

	UpdateData(false);

	CMComboSymbolFilesList.SetCurSel(GCSuperSpiceDataBase.CSymbolDataBase.index);
}

void TCModelPropertyDlg::OnSelchangeComboModelData() 
{
	int index = CMComboModelList.GetCurSel();

	if(index < 0) index = 0;

	if(GCSuperSpiceDataBase.CModelDataBase.index >= GCSuperSpiceDataBase.CModelDataBase.CFileList.GetSize()) return;

	GCSuperSpiceDataBase.CModelDataBase.CFileList[GCSuperSpiceDataBase.CModelDataBase.index].index = index;

	TCSpiceParametersList &CModelList = GCSuperSpiceDataBase.CModelDataBase.CFileList[GCSuperSpiceDataBase.CModelDataBase.index].CParametersList;

	if(!(index < CModelList.CParameters.GetSize())) return;

	GCSuperSpiceDataBase.CModelDataBase.CFileList[GCSuperSpiceDataBase.CModelDataBase.index].CComboEdit = CModelList.CParameters[index].CDataBaseIdInfo.CRecordName;

	CMComboModel = CModelList.CParameters[index].CDataBaseIdInfo.CRecordName;

	SetNames();

	CMComboModelFileList.SetCurSel(GCSuperSpiceDataBase.CModelDataBase.index);
}

void TCModelPropertyDlg::OnSelchangeComboModelFiles() 
{
//	GetDisplay();

	int index = CMComboModelFileList.GetCurSel();

	if(index < 0) index = 0;

	GCSuperSpiceDataBase.CModelDataBase.index = index;

	CArray <TCModelDataBaseData, TCModelDataBaseData &> &CFiles = GCSuperSpiceDataBase.CModelDataBase.CFileList;

	if(!(index < CFiles.GetSize())) return;

	GCSuperSpiceDataBase.CModelDataBase.CComboEdit = CFiles[index].CType;

	CMComboModelFile = CFiles[index].CType;

	SetModelList();

	SetNames();

	CMComboModelFileList.SetCurSel(GCSuperSpiceDataBase.CModelDataBase.index);
}

void TCSymbolPropertyDlg::OnKillfocusComboComponentSymbols() 
{
	OnSelchangeComboComponentSymbols();
}

void TCModelPropertyDlg::OnKillfocusComboModelData() 
{
	OnSelchangeComboModelData();
}

void TCSymbolPropertyDlg::OnKillfocusEditDescription() 
{
	UpdateData(true);

	int symbol_file_index = GCSuperSpiceDataBase.CSymbolDataBase.index;
	int symbol_index;

	if(!(symbol_file_index < GCSuperSpiceDataBase.CSymbolDataBase.CFileList.GetSize())) return;

	symbol_index = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].index;

	CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].CSymbolList;

	if(!(symbol_index < CSymbolList.GetSize())) return;

	CSymbolList[symbol_index].CSymbolData.CDescription = CMDescription;
}

void TCModelPropertyDlg::OnKillfocusEditSpiceModelData() 
{
	UpdateData(true);

	int model_file_index = GCSuperSpiceDataBase.CModelDataBase.index;

	if(!(model_file_index < GCSuperSpiceDataBase.CModelDataBase.CFileList.GetSize())) return;
	
	int model_index  = GCSuperSpiceDataBase.CModelDataBase.CFileList[model_file_index].index;

	TCSpiceParametersList &CModelList = GCSuperSpiceDataBase.CModelDataBase.CFileList[model_file_index].CParametersList;

	if(!(model_index < CModelList.CParameters.GetSize())) return;

	GetText(CModelList, model_index);
}


void TCSymbolPropertyDlg::OnButtonCopySymbol() 
{
	if(!PCComponentDataBaseData) return;

	GetDisplay();

	TCDataBaseClipboard CDataBaseClipboard;

	CDataBaseClipboard.CSource = *PCComponentDataBaseData;

	if(!GCSuperSpiceDataBase.CopySymbol(CDataBaseClipboard)) return;

	SetDisplay();
}

void TCSymbolPropertyDlg::OnButtonCopySymbolFile() 
{
	if(!PCComponentDataBaseData) return;

	GetDisplay();

	TCDataBaseClipboard CDataBaseClipboard;

	CDataBaseClipboard.CSource = *PCComponentDataBaseData;

	if(!GCSuperSpiceDataBase.CopySymbolFile(CDataBaseClipboard)) return;

	SetDisplay();
}

void TCSymbolPropertyDlg::OnButtonPasteSymbol() 
{
	GetDisplay();

	if(!PCComponentDataBaseData) return;

	TCDataBaseClipboard CDataBaseClipboard;

	CDataBaseClipboard.CDestination = *PCComponentDataBaseData;	

	// overwrite with symbol current file selected;
//	CDataBaseClipboard.CDestination.CSymbolFileName = CFilePath + CFileName;

	BeginWaitCursor();

	if(!GCSuperSpiceDataBase.PasteSymbol(CDataBaseClipboard)) return;

	EndWaitCursor();

	SetDisplay();
}

void TCSymbolPropertyDlg::OnButtonPasteSymbolFile() 
{
	GetDisplay();

	if(!PCComponentDataBaseData) return;

	TCDataBaseClipboard CDataBaseClipboard;

	CString CFileName;

	CFileDialog	CLoadFileDialog(false, "",GCSuperSpiceGlobalData.CGeneric.CDataBaseLastSymbolFileName, OFN_OVERWRITEPROMPT,"SuperSpice Symbol Files  (*.ssm)| *.ssm||");

	if(CLoadFileDialog.DoModal() != IDOK) 
	{
		CFileName = CLoadFileDialog.GetPathName();

		GCSuperSpiceGlobalData.CGeneric.CDataBaseLastSymbolFileName = CFileName;

		return;
	}
	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return;

	CDataBaseClipboard.CDestination.CSymbolPathName = ExtractPathName(CFileName);
	CDataBaseClipboard.CDestination.CSymbolFileName = ExtractFileName(CFileName);

	BeginWaitCursor();

	if(!GCSuperSpiceDataBase.PasteSymbolFile(CDataBaseClipboard)) 
	{
		EndWaitCursor();

		return;
	}

	EndWaitCursor();

	SetDisplay();
}

void TCSymbolPropertyDlg::OnButtonRemoveSymbol() 
{
	if(AfxMessageBox(IDS_CONFIRM_SYMBOL_DELETE, MB_OKCANCEL) != IDOK) return;

	int symbol_file_index = GCSuperSpiceDataBase.CSymbolDataBase.index;
	int symbol_index;

	if(!GCSuperSpiceDataBase.CSymbolDataBase.CFileList.GetSize()) return;

	if(!(symbol_file_index < GCSuperSpiceDataBase.CSymbolDataBase.CFileList.GetSize())) return;

	symbol_index = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].index;

	CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].CSymbolList;

	if(CSymbolList.GetSize() < 2) return;// alaways leave at least one symbol in the file

	if(!(symbol_index < CSymbolList.GetSize())) return;

	GCSuperSpiceDataBase.RemoveSymbol(symbol_file_index, symbol_index);

	SetSymbolList();

	SetNames();

	UpdateData(false);
}

void TCSymbolPropertyDlg::SyncDisplay(void)
{

}

void TCModelPropertyDlg::OnButtonCopyModel() 
{
	if(!PCComponentDataBaseData) return;

	GetDisplay();

	TCDataBaseClipboard CDataBaseClipboard;

	CDataBaseClipboard.CSource = *PCComponentDataBaseData;

	if(!GCSuperSpiceDataBase.CopyModel(CDataBaseClipboard)) return;

	SetDisplay();
}

void TCModelPropertyDlg::OnButtonCopyModelFile() 
{
	if(!PCComponentDataBaseData) return;

	GetDisplay();

	TCDataBaseClipboard CDataBaseClipboard;

	CDataBaseClipboard.CSource = *PCComponentDataBaseData;

	if(!GCSuperSpiceDataBase.CopyModelFile(CDataBaseClipboard)) return;

	SetDisplay();
}

void TCModelPropertyDlg::OnButtonPasteModelFile() 
{
	GetDisplay();

	TCDataBaseClipboard CDataBaseClipboard;

	CString CFileName;

	CString CFileDescriptor;
	
	CFileDescriptor.LoadString(IDS_STRING_MODEL_FILE_DESCRIPTOR);

	CFileDialog	CLoadFileDialog(false, "lib",GCSuperSpiceGlobalData.CGeneric.CDataBaseLastModelFileName, OFN_OVERWRITEPROMPT, CFileDescriptor);

	if(CLoadFileDialog.DoModal() != IDOK) 
	{
		CFileName = CLoadFileDialog.GetPathName();

		GCSuperSpiceGlobalData.CGeneric.CDataBaseLastModelFileName = CFileName;

		return;
	}
	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return;

	CDataBaseClipboard.CDestination.CModelPathName = ExtractPathName(CFileName);
	CDataBaseClipboard.CDestination.CModelFileName = ExtractFileName(CFileName);

	if(!GCSuperSpiceDataBase.PasteModelFile(CDataBaseClipboard)) return;

	SetDisplay();
}

void TCModelPropertyDlg::OnButtonRemoveModel() 
{
	if(AfxMessageBox("IDS_CONFIRM_DELET_MODEL", MB_OKCANCEL) != IDOK) return;

	int model_file_index = GCSuperSpiceDataBase.CModelDataBase.index;

	if(!(model_file_index < GCSuperSpiceDataBase.CModelDataBase.CFileList.GetSize())) return;
	
	int model_index  = GCSuperSpiceDataBase.CModelDataBase.CFileList[model_file_index].index;

	TCSpiceParametersList &CModelList = GCSuperSpiceDataBase.CModelDataBase.CFileList[model_file_index].CParametersList;

	if(!(model_index < CModelList.CParameters.GetSize())) return;

	if(model_index < 1) return;// ensure one model 

	GCSuperSpiceDataBase.RemoveModel(model_file_index, model_index);

	SetModelList();

	SetNames();
}

void TCModelPropertyDlg::OnButtonPasteModel() 
{
	GetDisplay();

	TCDataBaseClipboard CDataBaseClipboard;

	CDataBaseClipboard.CDestination = *PCComponentDataBaseData;

//	CDataBaseClipboard.CDestination.CModelFileName = CEditRecordPath + CEditRecordFileName;

	if(!GCSuperSpiceDataBase.PasteModel(CDataBaseClipboard)) return;

	SetDisplay();
}

void TCModelPropertyDlg::OnKillfocusEditRecordName() 
{
	GetDisplay();// gets and renames model data

	int model_file_index = GCSuperSpiceDataBase.CModelDataBase.index;

	if(model_file_index > -1 && model_file_index < GCSuperSpiceDataBase.CModelDataBase.CFileList.GetSize())
	{
		int model_index  = GCSuperSpiceDataBase.CModelDataBase.CFileList[model_file_index].index;

		TCSpiceParametersList &CModelList = GCSuperSpiceDataBase.CModelDataBase.CFileList[model_file_index].CParametersList;

		if(model_index < CModelList.CParameters.GetSize() && model_index > -1)
		{
			GCWorkspaceTree.RenameModel(CModelList.CParameters[model_index].HTreeItem, CModelList.CParameters[model_index].CDataBaseIdInfo.CRecordName);
		}
	}

	SetDisplay();
}

void TCSymbolPropertyDlg::OnKillfocusEditSymbolName() 
{
	GetDisplay();

	int symbol_file_index = GCSuperSpiceDataBase.CSymbolDataBase.index;

	if(symbol_file_index > -1 && symbol_file_index < GCSuperSpiceDataBase.CSymbolDataBase.CFileList.GetSize())
	{
		CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].CSymbolList;
		
		int symbol_index = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].index;

		if(symbol_index < CSymbolList.GetSize() && symbol_index > -1)
		{
			TCSchematicObjectData &CSymbol = CSymbolList[symbol_index];

			GCWorkspaceTree.RenameSymbol(CSymbol.HTreeItem, CSymbol.CSymbolData.CName);
		}
	}

	SetDisplay();
}

BOOL TCSymbolPropertyDlg::OnApply() 
{
	GetDisplay();

	if(!GCSuperSpiceDataBase.CSymbolDataBase.CFileList.GetSize()) return true;// error generated later

	if(!GCSuperSpiceDataBase.CheckAndCorrectSymbolData(PCComponentDataBaseData)) 
	{
		return CPropertyPage::OnApply();;
	}
	
	return CPropertyPage::OnApply();
}

BOOL TCModelPropertyDlg::OnApply() 
{
	GetDisplay(); 
	
	int value;
	
	if(m_check)
	{
		value = GCSuperSpiceDataBase.CheckAndCorrectModelData(PCComponentDataBaseData, attached_model_type);
	}
	else
	{
		value = GCSuperSpiceDataBase.CheckAndCorrectModelData(PCComponentDataBaseData, m_check);
	}

	 if(!value) 
	 {
		GCGeneralReportsTab.DisplayMessage(IDS_ERR_WARNING, IDS_MODEL_SUB_MUST_MATCH, -1);

		GCGeneralReportsTab.DisplayMessage(IDS_HELP_NOTE, IDS_SET_MODEL_TYPE, -1);
		
		return false;
	 }

	return CPropertyPage::OnApply();
}

void TCModelPropertyDlg::SetCheck(bool check)
{
	m_check = check;
}

void TCSymbolPropertyDlg::OnRadioAttachedModel() 
{
/*	if(!m_enable_vi_select && m_attached_model_type == E_SPICE_GENERATOR)
	{
		UpdateData(false);// do not let change in non editor mode

		return;
	}*/

	m_attached_model_type = E_SPICE_DOT_MODEL;

	SetButtonStates();

	CMEditChildFilePath.SetReadOnly(true);

	SymbolTypeToModelType(m_attached_model_type);
}

void TCSymbolPropertyDlg::FormatLabels(void)
{
	int symbol_file_index = GCSuperSpiceDataBase.CSymbolDataBase.index;
	int symbol_index;

	if(!(symbol_file_index < GCSuperSpiceDataBase.CSymbolDataBase.CFileList.GetSize())) return;

	symbol_index = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].index;

	CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].CSymbolList;

	if(!(symbol_index < CSymbolList.GetSize())) return;

	TCSchematicObjectData &CSymbol = CSymbolList[symbol_index];

	CSymbol.FormatLabels();
}

void TCSymbolPropertyDlg::OnRadioAttachedSubcircuit() 
{
/*	if(!m_enable_vi_select && m_attached_model_type == E_SPICE_GENERATOR)
	{
		UpdateData(false);// do not let change in non editor mode

		return;
	}*/

	m_attached_model_type = E_SPICE_DOT_SUBCIRCUIT;

	SetButtonStates();

	CMEditChildFilePath.SetReadOnly(true);

	SymbolTypeToModelType(m_attached_model_type);
}

void TCSymbolPropertyDlg::OnRadioAttachedSchematic() 
{
/*	if(!m_enable_vi_select && m_attached_model_type == E_SPICE_GENERATOR)
	{
		UpdateData(false);// do not let change in non editor mode

		return;
	}*/

	m_attached_model_type = E_SPICE_SCHEMATIC;

	SetButtonStates();

	CMEditChildFilePath.SetReadOnly(false);

	SymbolTypeToModelType(m_attached_model_type);
}

void TCSymbolPropertyDlg::OnRadioAttachedModel4() 
{
	if(!m_enable_vi_select)//if normal lib mode
	{
		int symbol_file_index = GCSuperSpiceDataBase.CSymbolDataBase.index;
		int symbol_index;

		if(!(symbol_file_index < GCSuperSpiceDataBase.CSymbolDataBase.CFileList.GetSize())) return;

		symbol_index = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].index;

		CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].CSymbolList;

		if(!(symbol_index < CSymbolList.GetSize())) return;

		TCSchematicObjectData &CSymbol = CSymbolList[symbol_index];

		if(CSymbol.CPinListData.GetSize() != 2)
		{
			AfxMessageBox(IDS_GENERATORS_2PINS_ONLY);

			UpdateData(false);

			return;
		}
	}

	m_attached_model_type = E_SPICE_GENERATOR;

	SetButtonStates();

	SymbolTypeToModelType(m_attached_model_type);
}

void TCSymbolPropertyDlg::SymbolTypeToModelType(int model_type)
{
	if(!PCComponentDataBaseData) return;
 
	int symbol_file_index = GCSuperSpiceDataBase.CSymbolDataBase.index;
	int symbol_index;

	if(!(symbol_file_index < GCSuperSpiceDataBase.CSymbolDataBase.CFileList.GetSize())) return;

	symbol_index = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].index;

	if(symbol_index < 0) return;
	
	CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].CSymbolList;

	if(!(symbol_index < CSymbolList.GetSize())) return;

	TCSchematicObjectData &CSymbol = CSymbolList[symbol_index];

	CSymbol.attached_model_type = (unsigned char)model_type;
}

void TCSymbolPropertyDlg::OnButtonPlaceSymbol() 
{
	if(!PCParent && !PCParentSymbol) return;// this should never happen;

	button_pressed = E_LIB_PLACE_SYMBOL;

	if(PCParent)
		PCParent->PressButton(PSBTN_OK);
	else if(PCParentSymbol) PCParentSymbol->PressButton(PSBTN_OK);
}

void TCSymbolPropertyDlg::OnButtonBrowseSchematic() 
{
	if(!PCParent && !PCParentSymbol) return;// this should never happen;

	int symbol_file_index = GCSuperSpiceDataBase.CSymbolDataBase.index;
	int symbol_index;

	if(!(symbol_file_index < GCSuperSpiceDataBase.CSymbolDataBase.CFileList.GetSize())) return;

	symbol_index = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].index;

	CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].CSymbolList;

	if(!(symbol_index < CSymbolList.GetSize())) return;
	
	CString CFilePathAndName;

	CFilePathAndName = CChildFilePath + CChildFileName;

	CFileDialog	CLoadFileDialog(true, "sss", CFilePathAndName, 0,"Schematic Files  (*.sss)| *.sss||");

	if(CLoadFileDialog.DoModal() != IDOK) return;

	CFilePathAndName = CLoadFileDialog.GetPathName();

	CChildFilePath = ExtractPathName(CFilePathAndName);

	CChildFileName = ExtractFileName(CFilePathAndName);

	CSymbolList[symbol_index].CSymbolData.CChildFileName = CFilePathAndName;
	CSymbolList[symbol_index].CSymbolData.CName = RemoveExtention(CChildFileName);
 
	SetDisplay();

	OnKillfocusEditSymbolName();// To rename docked file browser
}	

void TCSymbolPropertyDlg::OnButtonNewSymbolFile() 
{
	CString CFileName;

	CFileDialog	CLoadFileDialog(true, "ssm",GCSuperSpiceGlobalData.CGeneric.CDataBaseLastSymbolFileName, 0,"SuperSpice Component Files  (*.ssm)| *.ssm||");

	if(CLoadFileDialog.DoModal() != IDOK)
	{
		CFileName = CLoadFileDialog.GetPathName();

		return;
	}

	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return;

	GCSuperSpiceGlobalData.CGeneric.CDataBaseLastSymbolFileName = CFileName;

	BeginWaitCursor();

	if(!GCSuperSpiceDataBase.NewSymbolFile(CFileName))
	{
		AfxMessageBox(IDS_UNABLE_TO_VREATE_SYM_FILE);

		return;
	}

	SetDisplay();

	EndWaitCursor();	
}

void TCSymbolPropertyDlg::OnButtonNewSymbol() 
{
	if(!PCComponentDataBaseData) return;

	CString CText;

	CText = PCComponentDataBaseData->CSymbolPathName + PCComponentDataBaseData->CSymbolFileName;	
	
	if(!GCSuperSpiceDataBase.NewSymbol(CText))
	{
		AfxMessageBox(IDS_UNABLE_TO_VREATE_SYM);
	}

	SetDisplay();
}

void TCSymbolPropertyDlg::OnButtonSelectModel() 
{
	if(!PCComponentDataBaseData) return;
 
	int symbol_file_index = GCSuperSpiceDataBase.CSymbolDataBase.index;
	int symbol_index;

	if(!(symbol_file_index < GCSuperSpiceDataBase.CSymbolDataBase.CFileList.GetSize())) return;

	symbol_index = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].index;

	CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].CSymbolList;

	if(!(symbol_index < CSymbolList.GetSize())) return;

	TCMasterModelDlg CMasterModelDlg;

	CMasterModelDlg.attached_model_type = m_attached_model_type;

	CMasterModelDlg.CComponentDataBaseData = *PCComponentDataBaseData;
	
	// popup the correct model, if avalable

	GCSuperSpiceDataBase.SetDefaultModelDisplayed(*PCComponentDataBaseData);

	if(CMasterModelDlg.DoModal() != IDOK) return;

	*PCComponentDataBaseData = CMasterModelDlg.CComponentDataBaseData;

	TCSchematicObjectData &CSchematicObjectData = CSymbolList[symbol_index];

	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordName		= PCComponentDataBaseData->CModelName;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFileName	= PCComponentDataBaseData->CModelFileName;
	CSchematicObjectData.CSpiceParameters.CDataBaseIdInfo.CRecordFilePath	= PCComponentDataBaseData->CModelPathName;

	TCSpiceParameters *PCSpiceParameters = GCSuperSpiceDataBase.GetModelPointer(CSchematicObjectData.CSpiceParameters);

	if(PCSpiceParameters)
	{
		PCSpiceParameters->CDataBaseIdInfo.CSymbolName		= CSchematicObjectData.CSymbolData.CName;
		PCSpiceParameters->CDataBaseIdInfo.CSymbolFileName	= CSchematicObjectData.CSymbolData.CFilePath + CSchematicObjectData.CSymbolData.CFileName;

		PCSpiceParameters->AddSubcircuitSymbolName();

		int model_file_index = GCSuperSpiceDataBase.FindModelFile(PCComponentDataBaseData->CModelPathName + PCComponentDataBaseData->CModelPathName);

		if(!(model_file_index < 0)) GCSuperSpiceDataBase.CModelDataBase.CFileList[model_file_index].Save();

		CSchematicObjectData.CSpiceParameters = *PCSpiceParameters;
	}
	
	CSchematicObjectData.CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel =  PCComponentDataBaseData->CModelName;
	
//	CSchematicObjectData.FormatSpiceValue();

	GCSuperSpiceDataBase.SetSymbolViewType(CSchematicObjectData, *PCSpiceParameters);

//	GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].Save();

	if(CSymbolList[symbol_index].attached_model_type != E_SPICE_SCHEMATIC)
		CMEditModelSelected = PCComponentDataBaseData->CModelName;
	else CMEditModelSelected = "";

	SetDisplay();
}

void TCSymbolPropertyDlg::OnButtonSelectSource() 
{
	if(!PCComponentDataBaseData) return;
 
	int symbol_file_index = GCSuperSpiceDataBase.CSymbolDataBase.index;
	int symbol_index;

	if(!(symbol_file_index < GCSuperSpiceDataBase.CSymbolDataBase.CFileList.GetSize())) return;

	symbol_index = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].index;

	if(symbol_index < 0) return;
	
	CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].CSymbolList;

	if(!(symbol_index < CSymbolList.GetSize())) return;

	TCSchematicObjectData &CSymbol = CSymbolList[symbol_index];

	if(!m_enable_vi_select)
	if(CSymbol.CPinListData.GetSize() != 2)
	{
		AfxMessageBox(IDS_GENERATORS_2PINS_ONLY);

		return;
	}

	TCSelectGenerator CSelectGenerator;

	CSelectGenerator.m_version = CSymbol.version - E_DC_VOLTAGE_SOURCE;

	if(CSelectGenerator.DoModal() != IDOK) return;

	CSymbol.version = (short)(CSelectGenerator.m_version + E_DC_VOLTAGE_SOURCE);

	CSymbol.component_property_view_type = (unsigned char)(CSelectGenerator.m_version + E_PROPERTY_DC_VOLTAGE_SOURCE);

	m_component_property_view_type = CSymbol.component_property_view_type;
}


