// TCSymbolModelPropertyDlg.h : header file
//

#ifndef __TCSYMBOLMODELPROPERTYDLG_H__
#define __TCSYMBOLMODELPROPERTYDLG_H__
class TCComponentDataBaseData;

enum
{
	E_LIB_CANCEL,
	E_LIB_OK,
	E_LIB_PLACE_SYMBOL,
	E_LIB_OPEN_SCHEMATIC
};
/////////////////////////////////////////////////////////////////////////////
// TCSymbolPropertyDlg dialog
class TCMasterLibaryDlg;
class TCMasterSymbolDlg;
class TCMasterModelDlg;

class TCSymbolPropertyDlg : public CPropertyPage
{
	DECLARE_DYNCREATE(TCSymbolPropertyDlg)

		

// Construction
public:
	TCSymbolPropertyDlg();
	~TCSymbolPropertyDlg();

	void SetSymbolFileList(void);
	void SetSymbolList(void);
	void GetDisplay(void);
	void SetDisplay(void);
	void SetNames(void);
	void SyncDisplay(void);
	void FormatLabels(void);

	void SetButtonStates(void);

	bool IsSymbolAttachableToGenerator(void);

	int button_pressed;

	TCComponentDataBaseData *PCComponentDataBaseData;
	TCMasterLibaryDlg	*PCParent;
	TCMasterSymbolDlg *PCParentSymbol;

	unsigned char m_component_property_view_type;
	bool m_enable_vi_select;

	void SymbolTypeToModelType(int model_type);

// Dialog Data
	//{{AFX_DATA(TCSymbolPropertyDlg)
	enum { IDD = IDD_PROP_SYMBOL_LIB };
	CButton	CButtonSelectSchematic;
	CButton	CButtonPlaceSymbol;
	CButton	CButtonSelectModel;
	CButton	CButtonSelectSource;
	CEdit	CMEditChildFilePath;
	CEdit	CMEditChildFileName;
	CEdit	CEditFileName;
	CEdit	CEditFilePath;
	CComboBox	CMComboSymbolList;
	CComboBox	CMComboSymbolFilesList;
	CString	CMComboSymbol;
	CString	CMComboSymbolFile;
	CString	CFileName;
	CString	CFilePath;
	CString	CChildFileName;
	CString	CChildFilePath;
	CString	CName;
	CString	CMDescription;
	int		m_attached_model_type;
	CString	CMEditModelSelected;
	CButton CRadioSelectVISource;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCSymbolPropertyDlg)
	public:
	virtual BOOL OnKillActive();
	virtual BOOL OnSetActive();
	virtual BOOL OnApply();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCSymbolPropertyDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnButtonAddSymbolFile();
	afx_msg void OnButtonRemoveSymbolFile();
	afx_msg void OnButtonLoadSetup();
	afx_msg void OnButtonSaveSetup();
	afx_msg void OnSelchangeComboComponentFiles();
	afx_msg void OnSelchangeComboComponentSymbols();
	afx_msg void OnKillfocusComboComponentSymbols();
	afx_msg void OnKillfocusEditDescription();
	afx_msg void OnButtonCopySymbol();
	afx_msg void OnButtonCopySymbolFile();
	afx_msg void OnButtonPasteSymbol();
	afx_msg void OnButtonPasteSymbolFile();
	afx_msg void OnButtonRemoveSymbol();
	afx_msg void OnKillfocusEditSymbolName();
	afx_msg void OnRadioAttachedModel();
	afx_msg void OnRadioAttachedSubcircuit();
	afx_msg void OnRadioAttachedSchematic();
	afx_msg void OnButtonPlaceSymbol();
	afx_msg void OnButtonBrowseSchematic();
	afx_msg void OnButtonSaveSymbolFile();
	afx_msg void OnButtonNewSymbolFile();
	afx_msg void OnButtonNewSymbol();
	afx_msg void OnButtonSelectModel();
	afx_msg void OnButtonSelectSource();
	afx_msg void OnRadioAttachedModel4();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};


/////////////////////////////////////////////////////////////////////////////
// TCModelPropertyDlg dialog

class TCModelPropertyDlg : public CPropertyPage
{
	DECLARE_DYNCREATE(TCModelPropertyDlg)

		bool m_check;
		CString CEditModelFileName;
		bool enable_edit_model_file;

		TCMasterModelDlg	*PCParent;

// Construction
public:
	TCModelPropertyDlg();
	~TCModelPropertyDlg();

	TCComponentDataBaseData *PCComponentDataBaseData;

	void SetModelFileList(void);
	void SetModelList(void);
	void GetDisplay(void);
	void SetDisplay(void);
	void SetNames(void);
	void SetText(TCSpiceParametersList &CModelList, int index);
	void GetText(TCSpiceParametersList &CModelList, int index);

	void SetCheck(bool check = true);
	int attached_model_type;


// Dialog Data
	//{{AFX_DATA(TCModelPropertyDlg)
	enum { IDD = IDD_PROP_MODEL_LIB };
	CButton	CMButtonEditModel;
	CEdit	CEditFilePath;
	CEdit	CEditFileName;
	CComboBox	CMComboModelList;
	CComboBox	CMComboModelFileList;
	CString	CMComboModelFile;
	CString	CMComboModel;
	CString	CEditRecordName;
	CString	CEditRecordFileName;
	CString	CEditRecordPath;
	CString	CMEditModelData;
	BOOL	m_ignore_model_path;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCModelPropertyDlg)
	public:
	virtual BOOL OnKillActive();
	virtual BOOL OnSetActive();
	virtual BOOL OnApply();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCModelPropertyDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnButtonAddModelFile();
	afx_msg void OnButtonRemoveModelFile();
	afx_msg void OnButtonSaveModel();
	afx_msg void OnSelchangeComboModelData();
	afx_msg void OnSelchangeComboModelFiles();
	afx_msg void OnKillfocusComboModelData();
	afx_msg void OnKillfocusEditSpiceModelData();
	afx_msg void OnButtonCopyModel();
	afx_msg void OnButtonCopyModelFile();
	afx_msg void OnButtonPasteModelFile();
	afx_msg void OnButtonRemoveModel();
	afx_msg void OnButtonPasteModel();
	afx_msg void OnKillfocusEditRecordName();
	afx_msg void OnButtonEditModelFile();
	afx_msg void OnButtonRerunfile();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};



#endif // __TCSYMBOLMODELPROPERTYDLG_H__
