// TCSymbolPreView.cpp : implementation file
//

#include "stdafx.h"
#include "superspice.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSchematicManager.h"
#include "TCSymbolPreView.h"
#include "TCSuperSpiceDoc.h"
#include "TCSuperSpiceClipboard.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern TCSuperSpiceDataBase GCSuperSpiceDataBase;


/////////////////////////////////////////////////////////////////////////////
// TCSymbolPreView

IMPLEMENT_DYNCREATE(TCSymbolPreView, CScrollView)

TCSymbolPreView::TCSymbolPreView()
{
	CSuperSpiceViewData.PCMSchematicManager	= new TCSchematicManager;

	CSuperSpiceViewData.CMaxSize.cx  = 8196;
	CSuperSpiceViewData.CMaxSize.cy  = 8196;
	CSuperSpiceViewData.CPageSize.cx = 128;
	CSuperSpiceViewData.CPageSize.cy = 128;
	CSuperSpiceViewData.CLineSize.cx = 8;
	CSuperSpiceViewData.CLineSize.cy = 8;
	
	CSuperSpiceViewData.CViewPortOrigin.x = 0;
	CSuperSpiceViewData.CViewPortOrigin.y = 0;

	CSuperSpiceViewData.CScrollBarPosition.x = 0;
	CSuperSpiceViewData.CScrollBarPosition.y = 0;

	CSize CMaxSize(CSuperSpiceViewData.CMaxSize.cx,
					 CSuperSpiceViewData.CMaxSize.cy);

	SetScrollSizes(MM_TEXT, CMaxSize, CSuperSpiceViewData.CPageSize, CSuperSpiceViewData.CLineSize);


	CSuperSpiceViewData.PCMSchematicManager->SetView(this);

	CSuperSpiceViewData.PCMSchematicManager->is_symbol_viewer = true;
}

TCSymbolPreView::~TCSymbolPreView()
{
	if(CSuperSpiceViewData.PCMSchematicManager) delete CSuperSpiceViewData.PCMSchematicManager;
}


BEGIN_MESSAGE_MAP(TCSymbolPreView, CScrollView)
	//{{AFX_MSG_MAP(TCSymbolPreView)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP

	ON_WM_VSCROLL()
	ON_WM_HSCROLL()
	ON_WM_LBUTTONDBLCLK()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCSymbolPreView drawing

void TCSymbolPreView::OnDraw(CDC* pDC)
{
	pDC;
//	CDocument* pDoc = GetDocument();
	// TODO: add draw code here

	DrawAll();
}

/////////////////////////////////////////////////////////////////////////////
// TCSymbolPreView diagnostics

#ifdef _DEBUG
void TCSymbolPreView::AssertValid() const
{
	CScrollView::AssertValid();
}

void TCSymbolPreView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif //_DEBUG

void TCSymbolPreView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{	
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CScrollView::OnHScroll(nSBCode, nPos, pScrollBar);
	
	CDC *PCViewDC = GetDC();
	
	OnPrepareDC(PCViewDC, NULL);

	CPoint CViewPortOrigin = PCViewDC->GetViewportOrg();

	ReleaseDC(PCViewDC);

	CSuperSpiceViewData.PCMSchematicManager->SetViewPortOrigin(CViewPortOrigin);	

	CSuperSpiceViewData.PCMSchematicManager->SetScrollBarPosition(GetScrollBarPosition());
}

void TCSymbolPreView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	if(!CSuperSpiceViewData.PCMSchematicManager) return;

	CScrollView::OnVScroll(nSBCode, nPos, pScrollBar);

	CDC *PCViewDC = GetDC();
	
	OnPrepareDC(PCViewDC, NULL);

	CPoint CViewPortOrigin = PCViewDC->GetViewportOrg();

	ReleaseDC(PCViewDC);

	CSuperSpiceViewData.PCMSchematicManager->SetViewPortOrigin(CViewPortOrigin);

	CSuperSpiceViewData.PCMSchematicManager->SetScrollBarPosition(GetScrollBarPosition());

}

CPoint TCSymbolPreView::GetScrollBarPosition(void)
{
	CPoint CScrollBarPosition;

	CScrollBarPosition.y = GetScrollPos(SB_VERT);
	CScrollBarPosition.x = GetScrollPos(SB_HORZ);

	return CScrollBarPosition;
}
/////////////////////////////////////////////////////////////////////////////
// TCSymbolPreView message handlers

void TCSymbolPreView::DrawAll(void)
{
	CSuperSpiceViewData.PCMSchematicManager->DrawAll();
}

void TCSymbolPreView::OnLButtonDblClk(UINT nFlags, CPoint CMousePosition)
{
	nFlags,  CMousePosition;

	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp *) AfxGetApp();
	
	TCSuperSpiceDoc *PCTopDoc = PCSuperSpiceApp->GetATopLevelDocument();

	if(!PCTopDoc) return;

	CPoint COffset = CSuperSpiceViewData.PCMSchematicManager->GetViewPortOrigin();

	CPoint CNewOffset = (CPoint) (COffset - CSuperSpiceViewData.PCMSchematicManager->GetViewPortOrigin());

	TCSchematicComponentInfo CSchematicComponentInfo = CSuperSpiceViewData.PCMSchematicManager->InspectSchematicObject((CPoint) (CMousePosition - CNewOffset), false, true);

	if(CSchematicComponentInfo.type != E_SCHEMATIC_OBJECT) return;

	if(CMSchematicObjectData.CSymbolData.CFileName == "") return;

	if(CMSchematicObjectData.CSymbolData.CName  == "") return;

	if(!GCSuperSpiceDataBase.CSymbolDataBase.Get(CMSchematicObjectData)) return;

	CString CSymbolFile = CMSchematicObjectData.CSymbolData.CFilePath + CMSchematicObjectData.CSymbolData.CName + ".sym";

	CString CFileName	= CMSchematicObjectData.CSymbolData.CFilePath + CMSchematicObjectData.CSymbolData.CFileName;

	if(!CMSchematicObjectData.IsStraightVectorsOnly())
	{
		PCTopDoc->DisplayError(IDS_HELP_NOTE, IDS_CANNOT_EDIT_SYM_WITH_CURVES);

		return;
	}

	PCTopDoc->DisplaySymbolEditorDocument(CSymbolFile, CFileName, CMSchematicObjectData.CSymbolData.CName);
}

bool TCSymbolPreView::DisplayCircuit(CString CFileName, CString CCircuitName)
{
	CFileName = CFileName + "\\" + CCircuitName;

	if(!FileExists(CFileName)) return false;

	TCSuperSpiceClipboard CSuperSpiceClipboard;

	if(!CSuperSpiceClipboard.Load(CFileName)) return false;

	// now clear old stuff
	CSuperSpiceViewData.PCMSchematicManager->SetSelectAll();
	CSuperSpiceViewData.PCMSchematicManager->DeleteSelectedGraphics();
	CSuperSpiceViewData.PCMSchematicManager->PCMLastCreatedGraphic = NULL;

	CPoint CPosition(64, 64);
	CRect CRectangleExtent;

	CSuperSpiceClipboard.Zoom(0.5);

	CSuperSpiceClipboard.PCMSchematicManagerClipboard->GetComponentsExtent(CRectangleExtent);

	CPosition.x = CRectangleExtent.left;
	CPosition.y = CRectangleExtent.top;

	CSuperSpiceClipboard.PasteComponents(CSuperSpiceViewData.PCMSchematicManager, CPosition, "");

	CSuperSpiceViewData.PCMSchematicManager->ResetSelectAll(true);

	return true;
}

bool TCSymbolPreView::DisplaySymbol(CString CFileName, CString CSymbolName)
{
	CSuperSpiceViewData.PCMSchematicManager->SetSelectAll();
	CSuperSpiceViewData.PCMSchematicManager->DeleteSelectedGraphics();
	CSuperSpiceViewData.PCMSchematicManager->PCMLastCreatedGraphic = NULL;
	//create and draw new symbol

	int symbol_file_index = GCSuperSpiceDataBase.FindSymbolFile(CFileName);

	if(symbol_file_index < 0) return false;

	CArray <TCSymbolDataBaseData, TCSymbolDataBaseData &> &CFiles = GCSuperSpiceDataBase.CSymbolDataBase.CFileList;

	int symbol_index = CFiles[symbol_file_index].Find(CSymbolName);

	if(symbol_index < 0) return false;

	CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList= CFiles[symbol_file_index].CSymbolList; 

	CMSchematicObjectData = CSymbolList[symbol_index];

	CRect CRectOutline = SetupSchematicObjectData(CMSchematicObjectData);

	CPoint CPosition(0,0), CFixup;

	if(!CMSchematicObjectData.CSymbolData.CData.GetSize()) return false;

	CPosition = CMSchematicObjectData.CSymbolData.CData[0].CStartLocation;

	//bodge fixup for the few rouges
	if(CMSchematicObjectData.CSymbolData.CData[0].CStartLocation == CMSchematicObjectData.CSymbolData.CData[0].CEndLocation)
	{
		CPosition.x = 32;
		CPosition.y = 32;
	}

	CFixup = GetSpecialPositionFixup(CMSchematicObjectData);

	CPosition.x += CMSchematicObjectData.width/2 + 16;// 
	CPosition.y += CMSchematicObjectData.height/2 + 16;

	CPosition -= CMSchematicObjectData.CLocationOffset;

	CPosition = CPosition - CRectOutline.TopLeft();

	CPosition = CPosition + CFixup;

	if(!CSuperSpiceViewData.PCMSchematicManager->OpenGraphic(CPosition, 0, -1, CMSchematicObjectData)) return false;

	CSuperSpiceViewData.PCMSchematicManager->ResetSelectAll(false);

	DrawAll();

	return true;
}

CRect TCSymbolPreView::SetupSchematicObjectData(TCSchematicObjectData &CSchematicObjectData)
{
	CRect CComponentLinesRectangle = GetEnclosingRect(CSchematicObjectData);

	int count = CSchematicObjectData.CSymbolData.CData.GetSize();

	if(!count) return CComponentLinesRectangle;

	CSchematicObjectData.rotation_state = E_FIRST_QUADRANT;
	CSchematicObjectData.version = 0;
	CSchematicObjectData.format_spice_value = false;
	CSchematicObjectData.mirror_state = 0;

	count = CSchematicObjectData.CLabelListData.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{
		CSchematicObjectData.CLabelListData[p].is_visable = false;
	}

	count = CSchematicObjectData.CPinListData.GetSize();

	for(p = 0; p < count; p++)
	{
		int pin_lable_count = CSchematicObjectData.CPinListData[p].CLabelListData.GetSize();

		for(int q = 0; q < pin_lable_count; q++)
		{
			CSchematicObjectData.CPinListData[p].CLabelListData[q].is_visable = false;
		}
	}

//	CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = true;

	return CComponentLinesRectangle;
}

CRect TCSymbolPreView::GetEnclosingRect(TCSchematicObjectData &CSchematicObjectData)
{
	CRect CComponentLinesRectangle(0,0,0,0);

	int  count = CSchematicObjectData.CSymbolData.CData.GetSize();

	if(!count) return CComponentLinesRectangle;

	CComponentLinesRectangle.top	= CSchematicObjectData.CSymbolData.CData[0].CStartLocation.y;
	CComponentLinesRectangle.left	= CSchematicObjectData.CSymbolData.CData[0].CStartLocation.x;
	CComponentLinesRectangle.bottom	= CSchematicObjectData.CSymbolData.CData[0].CEndLocation.y;
	CComponentLinesRectangle.right	= CSchematicObjectData.CSymbolData.CData[0].CEndLocation.x;

	for(int p = 0; p < count; p++)
	{
		TCLineData &CData = CSchematicObjectData.CSymbolData.CData[p];

		if(CData.CStartLocation.x > CComponentLinesRectangle.right) CComponentLinesRectangle.right = CData.CStartLocation.x;
		if(CData.CStartLocation.x < CComponentLinesRectangle.left) CComponentLinesRectangle.left = CData.CStartLocation.x;

		if(CData.CEndLocation.x > CComponentLinesRectangle.right) CComponentLinesRectangle.right = CData.CEndLocation.x;
		if(CData.CEndLocation.x < CComponentLinesRectangle.left) CComponentLinesRectangle.left = CData.CEndLocation.x;

		if(CData.CStartLocation.y > CComponentLinesRectangle.bottom) CComponentLinesRectangle.bottom = CData.CStartLocation.y;
		if(CData.CStartLocation.y < CComponentLinesRectangle.top) CComponentLinesRectangle.top = CData.CStartLocation.y;

		if(CData.CEndLocation.y > CComponentLinesRectangle.bottom) CComponentLinesRectangle.bottom = CData.CEndLocation.y;
		if(CData.CEndLocation.y < CComponentLinesRectangle.top) CComponentLinesRectangle.top = CData.CEndLocation.y;
	}

	return CComponentLinesRectangle;
}

CPoint TCSymbolPreView::GetSpecialPositionFixup(TCSchematicObjectData &CSchematicObjectData)
{
	CString CName = CSchematicObjectData.CSymbolData.CName;

	CName.MakeLower();
	
	if(CName.Find("humbuck") > -1) return CPoint(-96, -16);
	if(CName.Find("digital or") > -1) return CPoint(-96, 0);
	if(CName.Find("digital nor") > -1) return CPoint(-96, 0);
	if(CName.Find("ex-or") > -1) return CPoint(-96, 0);
	if(CName.Find("ex-nor") > -1) return CPoint(-96, 0);
	if(CName.Find("analog or") > -1) return CPoint(-96, 0);
	if(CName.Find("analog nor") > -1) return CPoint(-96, 0);
	if(CName.Find("currentmodecontroller") > -1) return CPoint(-64, 0);
	if(CName.Find("voltagemodecontroller") > -1) return CPoint(-64, 0);

	if(CName == "dualnpn") return CPoint(-32, 0);
	if(CName == "dualpnp") return CPoint(-32, 0);
	if(CName == "dualnpnmat02") return CPoint(-32, 0);
	if(CName == "quadnpnmat04") return CPoint(0, -128);
	if(CName == "quadpnp") return CPoint(0, -128);
	if(CName == "pwm") return CPoint(-32, 0);

	if(CName.Find("transformer") > -1) 
	{
		CSchematicObjectData.rotation_state = E_SECOND_QUADRANT;

		if(CName.Find("tube output") > -1) return CPoint(-32, 0);
		if(CName.Find("flyback triple") > -1) return CPoint(0, -32);

		if(CName.Find("center") > -1) 
		{
			if(CName.Find("single") > -1) return CPoint(-32, 0);
			if(CName.Find("dual") > -1) return CPoint(-128, 48);
			if(CName.Find("triple") > -1) return CPoint(-208, 88);
			if(CName.Find("quad") > -1) return CPoint(-288, 128);
		}
		else
		{
			if(CName.Find("single") > -1) return CPoint(-32, 0);
			if(CName.Find("dual") > -1) return CPoint(-128, 48);
			if(CName.Find("triple") > -1) return CPoint(-208, 88);
			if(CName.Find("quad") > -1) return CPoint(-288, 128);
		}

		return CPoint(-32, 32);
	}

	if(CName == "4by4pin") 
	{
		CSchematicObjectData.rotation_state = E_THIRD_QUADRANT;

		return CPoint(48, 48);
	}

	if(CName == "6by6pin") 
	{
		CSchematicObjectData.rotation_state = E_THIRD_QUADRANT;

		return CPoint(64, 64);
	}
	
	if(CName == "8by8pin") 
	{
		CSchematicObjectData.rotation_state = E_THIRD_QUADRANT;

		return CPoint(80, 80);
	}

	if(CName == "10by10pin") 
	{
		CSchematicObjectData.rotation_state = E_THIRD_QUADRANT;

		return CPoint(96, 96);
	}

	if(CName == "12by12pin") 
	{
		CSchematicObjectData.rotation_state = E_THIRD_QUADRANT;

		return CPoint(112, 112);
	}

	if(CName == "16by16pin") 
	{
		CSchematicObjectData.rotation_state = E_THIRD_QUADRANT;

		return CPoint(144, 144);
	}

	return CPoint(0,0);
}