// TCSymbolPropertyPage.cpp : implementation file
//

#include "stdafx.h"
#include "superspice.h"
#include "TCFileFunctions.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSchematicObjectData.h"
#include "TCSymbolPropertyPage.h"
#include "TCGeneralReportsTab.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern TCSuperSpiceDataBase GCSuperSpiceDataBase;
extern TCGeneralReportsTab GCGeneralReportsTab;

/////////////////////////////////////////////////////////////////////////////
// TCSymbolPropertyPage property page

IMPLEMENT_DYNCREATE(TCSymbolPropertyPage, CPropertyPage)

extern int	g_last_active_component_property_page;

TCSymbolPropertyPage::TCSymbolPropertyPage() : CPropertyPage(TCSymbolPropertyPage::IDD)
{
	//{{AFX_DATA_INIT(TCSymbolPropertyPage)
	CMFilePath = _T("");
	CMFileName = _T("");
	CMSymbolName = _T("");
	CMSymbolSchematicName = _T("");
	CMSymbolSchematicPath = _T("");
	//}}AFX_DATA_INIT

	PCSchematicObjectData = NULL;
}

TCSymbolPropertyPage::~TCSymbolPropertyPage()
{
}

void TCSymbolPropertyPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCSymbolPropertyPage)
	DDX_Control(pDX, IDC_EDIT_SYMBOL_SCHEMATIC_PATH, CMEditSchematicPath);
	DDX_Control(pDX, IDC_EDIT_SYMBOL_SCHEMATIC, CMEditSymbolSchematicName);
	DDX_Control(pDX, IDC_EDIT_SYMBOL_NAME, CMEditSymbolName);
	DDX_Control(pDX, IDC_EDIT_SYMBOL_FILE_NAME, CMEditFileName);
	DDX_Control(pDX, IDC_EDIT_FILE_PATH, CMEditFilePath);
	DDX_Text(pDX, IDC_EDIT_FILE_PATH, CMFilePath);
	DDX_Text(pDX, IDC_EDIT_SYMBOL_FILE_NAME, CMFileName);
	DDX_Text(pDX, IDC_EDIT_SYMBOL_NAME, CMSymbolName);
	DDX_Text(pDX, IDC_EDIT_SYMBOL_SCHEMATIC, CMSymbolSchematicName);
	DDX_Text(pDX, IDC_EDIT_SYMBOL_SCHEMATIC_PATH, CMSymbolSchematicPath);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCSymbolPropertyPage, CPropertyPage)
	//{{AFX_MSG_MAP(TCSymbolPropertyPage)
	ON_EN_KILLFOCUS(IDC_EDIT_SYMBOL_NAME, OnKillfocusEditSymbolName)
	ON_BN_CLICKED(IDC_BUTTON_ATTACH_SCHEMATIC, OnButtonAttachSchematic)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCSymbolPropertyPage message handlers

BOOL TCSymbolPropertyPage::OnInitDialog() 
{
	if(PCSchematicObjectData)
	{
		CMFilePath				= PCSchematicObjectData->CSymbolData.CFilePath;
		CMFileName				= PCSchematicObjectData->CSymbolData.CFileName;
		CMSymbolName			= PCSchematicObjectData->CSymbolData.CName;
		CMSymbolSchematicName	= ExtractFileName(PCSchematicObjectData->CSymbolData.CChildFileName);
		CMSymbolSchematicPath	= ExtractPathName(PCSchematicObjectData->CSymbolData.CChildFileName);
	}

	CPropertyPage::OnInitDialog();
	

//	CMEditSchematicPath.SetReadOnly();
	CMEditSymbolSchematicName.SetReadOnly();
//	CMEditSymbolName.SetReadOnly();

	CMEditFileName.SetReadOnly();
	CMEditFilePath.SetReadOnly();
	
	return TRUE;  
}

BOOL TCSymbolPropertyPage::OnSetActive() 
{
	if(!PCSchematicObjectData) return false;

	g_last_active_component_property_page = 3;

	CMSymbolName = PCSchematicObjectData->CSymbolData.CName;

	CMSymbolSchematicName	= ExtractFileName(PCSchematicObjectData->CSymbolData.CChildFileName);

	CMEditSymbolName.SetWindowText(CMSymbolName);
	CMEditSymbolSchematicName.SetWindowText(CMSymbolSchematicName);

	return CPropertyPage::OnSetActive();
}


void TCSymbolPropertyPage::OnKillfocusEditSymbolName() 
{
	if(!PCSchematicObjectData) return;

	UpdateData(true);

	PCSchematicObjectData->Rename(CMSymbolName);
		
	CMSymbolSchematicName	= ExtractFileName(PCSchematicObjectData->CSymbolData.CChildFileName);

	UpdateData(false);
}

BOOL TCSymbolPropertyPage::OnKillActive() 
{
	int result = CPropertyPage::OnKillActive();

	if(!PCSchematicObjectData) return result;
	
	PCSchematicObjectData->CSymbolData.CFilePath = CMFilePath;
	PCSchematicObjectData->CSymbolData.CFileName = CMFileName;
//	PCSchematicObjectData->Rename(CMSymbolName);// file schematic name must sync with symbol name

	return result;
}

void TCSymbolPropertyPage::OnButtonAttachSchematic() 
{
	CString CFileName;

	CString COrgChildFileName = PCSchematicObjectData->CSymbolData.CChildFileName;
	CString CNewChildFileName;

	COrgChildFileName.MakeLower();
	COrgChildFileName.TrimLeft();
	COrgChildFileName.TrimRight();

	CFileDialog	CLoadFileDialog(true, "sss", PCSchematicObjectData->CSymbolData.CChildFileName, 0,"Schematic Files  (*.sss)| *.sss||");

	if(CLoadFileDialog.DoModal() != IDOK)
	{
		CFileName = CLoadFileDialog.GetPathName();

		return;
	}

	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return;

	CNewChildFileName = CFileName;

	CNewChildFileName.MakeLower();
	CNewChildFileName.TrimLeft();
	CNewChildFileName.TrimRight();

	if(CNewChildFileName == COrgChildFileName) return;

	//Make new symbol
	GCSuperSpiceDataBase.DoublicateSymbol(CFileName, *PCSchematicObjectData);

	CMSymbolName			= PCSchematicObjectData->CSymbolData.CName;
	CMSymbolSchematicName	= ExtractFileName(PCSchematicObjectData->CSymbolData.CChildFileName);
	CMSymbolSchematicPath	= ExtractPathName(PCSchematicObjectData->CSymbolData.CChildFileName);

	CMFileName = PCSchematicObjectData->CSymbolData.CFileName;
	CMFilePath = PCSchematicObjectData->CSymbolData.CFilePath;

	CString CStatusMsg;

	CStatusMsg.LoadString(IDS_COPY_SYMBOL);

	CStatusMsg = CStatusMsg + ' ' + CMSymbolName;

	GCGeneralReportsTab.DisplayMessage(IDS_EER_STATUS, CStatusMsg, 0);

	UpdateData(false);
}

BOOL TCSymbolPropertyPage::OnApply() 
{	
	return CPropertyPage::OnApply();
}

