#include "stdafx.h"
#include "resource.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSuperSpiceGlobalData.h"
#include "superspice.h"
#include "TCSymbolTreeDoc.h"
#include "TCTreeRename.h"
#include "TCMasterSymbolDlg.h"
#include "TCSymbolTreeView.h"
#include "TCSuperSpiceDoc.h"
#include "TCModelSymbolTab.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern TCSuperSpiceGlobalData	GCSuperSpiceGlobalData;
extern TCSuperSpiceDataBase		GCSuperSpiceDataBase; 
extern CString GLastFileTreeSymbolFile;
extern CString GLastFileTreeSymbol;
extern TCModelSymbolTab CModelSymbolTab;


HTREEITEM InsertTreeItem(CTreeCtrl * ctrl,LPCTSTR txt,int imgind,int selimgind, int id);
HTREEITEM InsertTreeItem(CTreeCtrl * ctrl,HTREEITEM hTreeItem, LPCTSTR txt,int imgind,int selimgind, int id);


/////////////////////////////////////////////////////////////////////////////
// TCSymbolTreeView

IMPLEMENT_DYNCREATE(TCSymbolTreeView, CXTTreeView)

BEGIN_MESSAGE_MAP(TCSymbolTreeView, CXTTreeView)
	//{{AFX_MSG_MAP(TCSymbolTreeView)
	ON_WM_ERASEBKGND()
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_NCHITTEST()
	//}}AFX_MSG_MAP
	// Standard printing commands

	ON_NOTIFY_REFLECT(NM_DBLCLK, OnDoubleClickTree) 
	ON_WM_CONTEXTMENU()
	ON_COMMAND(ID_REFRESH_TREE, Refresh)
	ON_COMMAND(ID_POPUP_ADDSYMBOLFILE, AddSymbolFile)
	ON_COMMAND(ID_EDIT_COPY_TREE, EditCopy)
	ON_COMMAND(ID_POPUP_COPYSYMBOLFILE, CopySymbolFile)
	ON_COMMAND(ID_EDIT_PASTE_TREE, EditPaste)
	ON_COMMAND(ID_EDIT_DELETE_TREE, EditDelete)
	ON_COMMAND(ID_POPUP_NEWSYMBOLFILE, NewSymbolFile)
	ON_COMMAND(ID_POPUP_NEWSYMBOL, NewSymbol)
	ON_COMMAND(ID_POPUP_EDITSYMBOL, Edit)
	ON_COMMAND(ID_POPUP_RENAME, Rename)
	ON_COMMAND(ID_POPUP_PROPERTIES, Properties)
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	ON_NOTIFY_REFLECT(TVN_BEGINLABELEDIT, BeginLabelEdit)
//	ON_NOTIFY(WM_NOTIFY, TVN_BEGINLABELEDIT, BeginLabelEdit)
	ON_COMMAND(ID_POPUP_OPENATTACHEDSCHEMATIC, OpenSchematic)
	ON_UPDATE_COMMAND_UI(ID_POPUP_OPENATTACHEDSCHEMATIC, OnUpdateOpenSchematic)
	ON_COMMAND(ID_POPUP_PLACESYMBOL, PlaceSymbol)
	ON_NOTIFY_REFLECT(TVN_BEGINDRAG, OnBeginDragDrop)


END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCSymbolTreeView construction/destruction



void TCSymbolTreeView::OnLButtonDown(UINT nFlags, CPoint CMousePosition) 
{
	HTREEITEM hItem;
	UINT      nHF;

	hItem = m_pTreeCtrl->HitTest(CMousePosition, &nHF);

	//Force the new selection to the current one
	if(hItem) m_pTreeCtrl->SelectItem(hItem);

	CXTTreeView::OnLButtonDown(nFlags, CMousePosition);

	CString CSymbolName = GetSymbolName();

	if(CSymbolName == "") return;

	CString CSymbolFileName = GetFileName();

	if(CSymbolFileName == "") return;

	CModelSymbolTab.DisplaySymbol(CSymbolFileName, CSymbolName);
}

void TCSymbolTreeView::BeginLabelEdit(NMHDR * pNMHDR, LRESULT* pResult)
{
	pNMHDR;
	*pResult = true;
	return;//Cancel editing
}

TCSymbolTreeView::TCSymbolTreeView()
{
	m_pTreeCtrl = &GetTreeCtrl();

	ASSERT(m_pTreeCtrl);

	hlast_saved_file = NULL;
	hlast_saved_item = NULL;
	f_last_symbol	 = true;
	m_is_dragging	 = false;
}


TCSymbolTreeView::~TCSymbolTreeView()
{

}

BOOL TCSymbolTreeView::PreCreateWindow(CREATESTRUCT& cs)
{
	if(!CXTTreeView::PreCreateWindow(cs)) return FALSE;

	// Set the style for the tree control.
	cs.style |= TVS_HASBUTTONS|TVS_HASLINES|TVS_LINESATROOT;

	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// TCSymbolTreeView drawing

void TCSymbolTreeView::OnDraw(CDC* pDC)
{
	pDC;
	TCSymbolTreeDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here

}

void TCSymbolTreeView::OnInitialUpdate()
{
	CXTTreeView::OnInitialUpdate();

	// TODO: You may populate your TreeView with items by directly accessing
	//  its tree control through a call to GetTreeCtrl().

}

/////////////////////////////////////////////////////////////////////////////
// TCSymbolTreeView diagnostics

#ifdef _DEBUG
void TCSymbolTreeView::AssertValid() const
{
	CXTTreeView::AssertValid();
}

void TCSymbolTreeView::Dump(CDumpContext& dc) const
{
	CXTTreeView::Dump(dc);
}

TCSymbolTreeDoc* TCSymbolTreeView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(TCSymbolTreeDoc)));
	return (TCSymbolTreeDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// TCSymbolTreeView message handlers

void TCSymbolTreeView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	pSender;
	lHint;
	pHint;
}

void TCSymbolTreeView::UpdateView()
{

}

BOOL TCSymbolTreeView::OnEraseBkgnd(CDC* pDC) 
{
	UNUSED_ALWAYS(pDC);
	return TRUE;
}

int TCSymbolTreeView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CXTTreeView::OnCreate(lpCreateStruct) == -1) return -1;

	CBitmap bitmap;

	m_ImageList.Create(23, 19, ILC_COLOR|ILC_MASK, 6, 4); 
	m_ImageList.SetBkColor(GetSysColor(COLOR_WINDOW));
	bitmap.LoadBitmap(IDB_TREENODES_SYMBOLS);
	m_ImageList.Add(&bitmap, (COLORREF)0xFFFFFF);
	m_pTreeCtrl->SetImageList(&m_ImageList, TVSIL_NORMAL);

	UpdateView();
 
	return 0;
}

void TCSymbolTreeView::OnRButtonDown(UINT nFlags, CPoint point)
{
	nFlags;
	OnContextMenu(NULL, point);// XT messes up context menu handling
}

void TCSymbolTreeView::OnContextMenu(CWnd*, CPoint point)
{
	CMenu menu;
	VERIFY(menu.LoadMenu(CG_IDR_POPUP_TREE_SYMBOL));

	CMenu* pPopup = menu.GetSubMenu(0);
	ASSERT(pPopup != NULL);

	ClientToScreen(&point); // XT messes up context menu handling

	CWnd* pWndPopupOwner = this;
//	while (pWndPopupOwner->GetStyle() & WS_CHILD)    // XT messes up context menu handling
//		pWndPopupOwner = pWndPopupOwner->GetParent();

	pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point.x, point.y,pWndPopupOwner);
}

LRESULT TCSymbolTreeView::OnNcHitTest(CPoint point) 
{
	UINT uFlag=0;

	if(!m_pTreeCtrl) return HTNOWHERE;
	if(!m_pTreeCtrl->m_hWnd) return HTNOWHERE;
	// Get the cursor location in client coordinates.
	CPoint pt = point;	
	ScreenToClient(&pt);

	// Get a pointer to the tooltip control.
	CToolTipCtrl* pCtrl = (CToolTipCtrl*)CWnd::FromHandle(
		(HWND)::SendMessage(m_hWnd, TVM_GETTOOLTIPS, 0, 0L));

	// If we have a valid tooltip pointer and the cursor
	// is over a tree item, the bring the tooltip control
	// to the top of the Z-order.
	if (pCtrl && m_pTreeCtrl->HitTest(pt, &uFlag)){
		pCtrl->SetWindowPos(&wndTop,0, 0, 0, 0,
			SWP_NOACTIVATE | SWP_NOSIZE |SWP_NOMOVE);
	}
	
	return CXTTreeView::OnNcHitTest(point);
}

void TCSymbolTreeView::UpdateAllData(void)
{
	int count, p, q, symbol_count;

	CString CSymbolFileName, CSymbolName;

	HTREEITEM	hTI = NULL, htmp = NULL;

	CArray <TCSymbolDataBaseData, TCSymbolDataBaseData &> &CFiles = GCSuperSpiceDataBase.CSymbolDataBase.CFileList;
	
	count = CFiles.GetSize();

	if(!count) return;

	int id;

	for(p = 0; p < count; p++)
	{
		id = CFileID.GetNewPageId("");

		int index_id = CFileID.GetPageIndex(id);

		if(index_id < 0) return;

		CFileID.CPageIdData[index_id].CPageTitle = CFiles[p].CPath + CFiles[p].CName;

		hTI = InsertTreeItem(m_pTreeCtrl, CFiles[p].CType,0,1, id);// CType is File name

		CFiles[p].HTreeItem = hTI;

		if(!hlast_saved_file)
		if(CFileID.CPageIdData[index_id].CPageTitle == GLastFileTreeSymbolFile)
		{
			hlast_saved_file = hTI;
		}

		CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[p].CSymbolList;

		symbol_count = CSymbolList.GetSize();

		for(q = 0; q < symbol_count; q++)
		{
			htmp = InsertTreeItem(m_pTreeCtrl, hTI, CSymbolList[q].CSymbolData.CName,2,3, 0);

			CSymbolList[q].HTreeItem = htmp;

			if(hlast_saved_file)
			{
				if(CSymbolList[q].CSymbolData.CName == GLastFileTreeSymbol)
				{
					hlast_saved_item = htmp;
				}
			}
		}

		m_pTreeCtrl->SelectItem(hTI);// force a redraw
	}

	f_last_symbol = true;
}

void TCSymbolTreeView::Refresh(void)
{
	ASSERT(m_pTreeCtrl);

	m_pTreeCtrl->DeleteAllItems();

	CFileID.Clear();

	UpdateAllData();
}

HTREEITEM TCSymbolTreeView::GetFileItem(CString CFileName)
{
	CArray <TCSymbolDataBaseData, TCSymbolDataBaseData &> &CFiles = GCSuperSpiceDataBase.CSymbolDataBase.CFileList;

	int index = GCSuperSpiceDataBase.FindSymbolFile(CFileName);

	if(index < 0) return NULL;

	return CFiles[index].HTreeItem;
}

HTREEITEM TCSymbolTreeView::GetSymbolItem(CString CFileName, CString CSymbolName)
{
	CArray <TCSymbolDataBaseData, TCSymbolDataBaseData &> &CFiles = GCSuperSpiceDataBase.CSymbolDataBase.CFileList;

	int index = GCSuperSpiceDataBase.FindSymbolFile(CFileName);

	if(index < 0) return NULL;

	int symbol_index = CFiles[index].Find(CSymbolName);

	if(symbol_index < 0) return NULL;

	CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[index].CSymbolList;

	return CSymbolList[symbol_index].HTreeItem;
}

void TCSymbolTreeView::OnDoubleClickTree(NMHDR * pNMHDR, LRESULT* pResult)
{ 
	*pResult = 0;

	pNMHDR;
	*pResult = 0;

	DWORD				dwpos;
	TV_HITTESTINFO		tvhti;
	HTREEITEM           htiItemClicked, hparent;
	POINT				point;

// Bullshit code that should already be done my M.S.
	// find out where the cursor was
	dwpos = GetMessagePos();
	point.x = LOWORD(dwpos);
	point.y = HIWORD(dwpos);

	::MapWindowPoints(HWND_DESKTOP, m_hWnd, &point, 1);

	tvhti.pt = point;
//
	htiItemClicked = m_pTreeCtrl->HitTest(&tvhti);

	if(!htiItemClicked) return;

	hparent = m_pTreeCtrl->GetParentItem(htiItemClicked);

	if(!hparent) return;//

	if(!(tvhti.flags & (TVHT_ONITEMLABEL | TVHT_ONITEMICON))) return;

	CString CSymbolName = m_pTreeCtrl->GetItemText(htiItemClicked);

	CString CSymbolFileNameType = m_pTreeCtrl->GetItemText(hparent);	

	int id = m_pTreeCtrl->GetItemData(hparent);

	if(id < 0) return; 
	
	id = CFileID.GetPageIndex(id);

	if(id < 0) return;

	CString CSymbolFileName = CFileID.CPageIdData[id].CPageTitle;

	int symbol_file_index = GCSuperSpiceDataBase.FindSymbolFile(CSymbolFileName);

	if(symbol_file_index < 0) return;

	CArray <TCSymbolDataBaseData, TCSymbolDataBaseData &> &CFiles = GCSuperSpiceDataBase.CSymbolDataBase.CFileList;

	int symbol_index = CFiles[symbol_file_index].Find(CSymbolName);

	if(symbol_index < 0) return;

	GCSuperSpiceDataBase.PlaceSymbolFromSymbol(symbol_file_index, symbol_index);
}

void TCSymbolTreeView::PlaceSymbol(void)
{
	int file_index, symbol_index;

	file_index = GetFileIndex();

	if(file_index < 0) return;

	symbol_index = GetIndex();

	if(symbol_index < 0) return;

	GCSuperSpiceDataBase.PlaceSymbolFromSymbol(file_index, symbol_index);

	return;
}

HTREEITEM TCSymbolTreeView::GetItemClicked(TV_HITTESTINFO &tvhti)
{
	tvhti;

	return NULL;

/*
	DWORD				dwpos;
	POINT				point;

// Bullshit code that should already be done my M.S.
	// find out where the cursor was
	dwpos = GetMessagePos();
	point.x = LOWORD(dwpos);
	point.y = HIWORD(dwpos);

	::MapWindowPoints(HWND_DESKTOP, m_hWnd, &point, 1);

	tvhti.pt = point;
	
	HTREEITEM hitem = m_pTreeCtrl->HitTest(&tvhti);

	if(!(tvhti.flags & (TVHT_ONITEMLABEL | TVHT_ONITEMICON))) return NULL;

	return hitem;*/
}

int TCSymbolTreeView::GetFileIndex()
{
	HTREEITEM		htiItemClicked, hparent;

	htiItemClicked = m_pTreeCtrl->GetSelectedItem();

	if(!htiItemClicked) return -1;

	hparent = m_pTreeCtrl->GetParentItem(htiItemClicked);

	if(!hparent) hparent = htiItemClicked;

	CString CSymbolName = m_pTreeCtrl->GetItemText(htiItemClicked);

	CString CSymbolFileNameType = m_pTreeCtrl->GetItemText(hparent);	

	int id = m_pTreeCtrl->GetItemData(hparent);

	if(id < 0) return -1; 
	
	id = CFileID.GetPageIndex(id);

	if(id < 0) return -1;

	CString CSymbolFileName = CFileID.CPageIdData[id].CPageTitle;

	return GCSuperSpiceDataBase.FindSymbolFile(CSymbolFileName);
}

int TCSymbolTreeView::GetIndex()
{
	HTREEITEM		htiItemClicked, hparent;

	htiItemClicked = m_pTreeCtrl->GetSelectedItem();// GetItemClicked(tvhti);

	if(!htiItemClicked) return -1;

	hparent = m_pTreeCtrl->GetParentItem(htiItemClicked);

	if(!hparent) return -1;

	CString CSymbolName = m_pTreeCtrl->GetItemText(htiItemClicked);

	CString CSymbolFileNameType = m_pTreeCtrl->GetItemText(hparent);	

	int id = m_pTreeCtrl->GetItemData(hparent);

	if(id < 0) return -1; 
	
	id = CFileID.GetPageIndex(id);

	if(id < 0) return -1;

	CString CSymbolFileName = CFileID.CPageIdData[id].CPageTitle;

	int symbol_file_index = GCSuperSpiceDataBase.FindSymbolFile(CSymbolFileName);

	if(symbol_file_index < 0) return -1;

	CArray <TCSymbolDataBaseData, TCSymbolDataBaseData &> &CFiles = GCSuperSpiceDataBase.CSymbolDataBase.CFileList;

	return CFiles[symbol_file_index].Find(CSymbolName);
}

CString TCSymbolTreeView::GetFileName(void)
{
	HTREEITEM		htiItemClicked, hparent;

	htiItemClicked = m_pTreeCtrl->GetSelectedItem();// GetItemClicked(tvhti);

	if(!htiItemClicked) return "";

	hparent = m_pTreeCtrl->GetParentItem(htiItemClicked);

	if(!hparent) hparent = htiItemClicked;

	CString CSymbolName = m_pTreeCtrl->GetItemText(htiItemClicked);

	CString CSymbolFileNameType = m_pTreeCtrl->GetItemText(hparent);	

	int id = m_pTreeCtrl->GetItemData(hparent);

	if(id < 0) return ""; 
	
	id = CFileID.GetPageIndex(id);

	if(id < 0) return "";

	return CFileID.CPageIdData[id].CPageTitle;
}

CString TCSymbolTreeView::GetSymbolName(void)
{
	HTREEITEM		htiItemClicked, hparent;

	htiItemClicked = m_pTreeCtrl->GetSelectedItem();

	if(!htiItemClicked) return "";

	hparent = m_pTreeCtrl->GetParentItem(htiItemClicked);

	if(!hparent) return "";

	return m_pTreeCtrl->GetItemText(htiItemClicked);
}

void TCSymbolTreeView::SelectModel(void)
{
	HTREEITEM		htiItemClicked, hparent;

	htiItemClicked = m_pTreeCtrl->GetSelectedItem();// GetItemClicked(tvhti);

	if(!htiItemClicked) return;

	hparent = m_pTreeCtrl->GetParentItem(htiItemClicked);

	if(!hparent) return;

	CString CSymbolName = m_pTreeCtrl->GetItemText(htiItemClicked);

	CString CSymbolFileNameType = m_pTreeCtrl->GetItemText(hparent);	

	int id = m_pTreeCtrl->GetItemData(hparent);

	if(id < 0) return; 
	
	id = CFileID.GetPageIndex(id);

	if(id < 0) return;

	CString CSymbolFileName = CFileID.CPageIdData[id].CPageTitle;

	int symbol_file_index = GCSuperSpiceDataBase.FindSymbolFile(CSymbolFileName);

	if(symbol_file_index < 0) return;

	CArray <TCSymbolDataBaseData, TCSymbolDataBaseData &> &CFiles = GCSuperSpiceDataBase.CSymbolDataBase.CFileList;

	int symbol_index = CFiles[symbol_file_index].Find(CSymbolName);

	if(symbol_index < 0) return;
}

bool TCSymbolTreeView::Remove(HTREEITEM HItem)
{
	int id;

	if(IsBadCodePtr((FARPROC) HItem)) return false;

	HTREEITEM hparent = m_pTreeCtrl->GetParentItem(HItem);

	if(!hparent)// must be the file folder
	{
		id = m_pTreeCtrl->GetItemData(hparent);

		if(id < 0) return false;

		CFileID.RemovePageId(id);
	}

	return !!m_pTreeCtrl->DeleteItem(HItem);
}

bool TCSymbolTreeView::Add(CString CFileName, int symbol_index)
{
	HTREEITEM HItem;

	if(symbol_index < 0) return false;

	int symbol_file_index = GCSuperSpiceDataBase.FindSymbolFile(CFileName);

	if(symbol_file_index < 0) return false;

	CArray <TCSymbolDataBaseData, TCSymbolDataBaseData &> &CFiles = GCSuperSpiceDataBase.CSymbolDataBase.CFileList;
	
	int count = CFiles.GetSize();

	if(!count) return false;
	if(!(symbol_file_index < count)) return false;

	HItem = CFiles[symbol_file_index].HTreeItem;

	if(!HItem) return false;

	if(IsBadCodePtr((FARPROC) HItem)) return false;

	CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].CSymbolList;

	int symbol_count = CSymbolList.GetSize();

	if(!symbol_count) return false;
	if(!(symbol_index < symbol_count)) return false;

	HTREEITEM htmp = InsertTreeItem(m_pTreeCtrl, HItem, CSymbolList[symbol_index].CSymbolData.CName,2,3, 0);

	CSymbolList[symbol_index].HTreeItem = htmp;

	m_pTreeCtrl->SelectItem(htmp);

	return true;
}

bool TCSymbolTreeView::AddFile(int symbol_file_index)
{
	int count, q, symbol_count;

	HTREEITEM	hTI = NULL, htmp = NULL;

	CArray <TCSymbolDataBaseData, TCSymbolDataBaseData &> &CFiles = GCSuperSpiceDataBase.CSymbolDataBase.CFileList;
	
	count = CFiles.GetSize();

	if(!count) return false;
	if(!(symbol_file_index < count)) return false;
	if(symbol_file_index < 0) return false;

	int id = CFileID.GetNewPageId("");

	int index_id = CFileID.GetPageIndex(id);

	if(index_id < 0) return false;

	CFileID.CPageIdData[index_id].CPageTitle = CFiles[symbol_file_index].CPath + CFiles[symbol_file_index].CName;
	
	hTI = InsertTreeItem(m_pTreeCtrl, CFiles[symbol_file_index].CType,0,1, id);// CType is File name

	CFiles[symbol_file_index].HTreeItem = hTI;

	CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].CSymbolList;

	symbol_count = CSymbolList.GetSize();

	for(q = 0; q < symbol_count; q++)
	{
		htmp = InsertTreeItem(m_pTreeCtrl, hTI, CSymbolList[q].CSymbolData.CName,2,3, 0);

		CSymbolList[q].HTreeItem = htmp;
	}

	m_pTreeCtrl->Expand(hTI, TVE_COLLAPSE);

	return true;
}

void TCSymbolTreeView::EditCopy(void)
{
	Copy(CMDataBaseClipboard);
}	

void TCSymbolTreeView::EditPaste(void)
{
	Paste(CMDataBaseClipboard);

	Rename();
}

void TCSymbolTreeView::Copy(TCDataBaseClipboard &CDataBaseClipboard)
{
	CString CFileName = GetFileName();

	CDataBaseClipboard.CSource.CSymbolFileName	= ExtractFileName(CFileName);
	CDataBaseClipboard.CSource.CSymbolPathName  = ExtractPathName(CFileName);
	CDataBaseClipboard.CSource.CSymbolName		= GetSymbolName();
	CDataBaseClipboard.CSource.use_index		= false;

	if(CDataBaseClipboard.CSource.CSymbolName != "")
		GCSuperSpiceDataBase.CopySymbol(CDataBaseClipboard);
	else GCSuperSpiceDataBase.CopySymbolFile(CDataBaseClipboard);
}

void TCSymbolTreeView::CopySymbolFile(void)
{
	CString CFileName = GetFileName();

	CMDataBaseClipboard.CSource.CSymbolFileName	= ExtractFileName(CFileName);
	CMDataBaseClipboard.CSource.CSymbolPathName  = ExtractPathName(CFileName);
	CMDataBaseClipboard.CSource.CSymbolName		= GetSymbolName();
	CMDataBaseClipboard.CSource.use_index		= false;

	GCSuperSpiceDataBase.CopySymbolFile(CMDataBaseClipboard);

	CFileDialog	CLoadFileDialog(false, "",GCSuperSpiceGlobalData.CGeneric.CDataBaseLastSymbolFileName, OFN_OVERWRITEPROMPT,"SuperSpice Symbol Files  (*.ssm)| *.ssm||");

	if(CLoadFileDialog.DoModal() != IDOK) return;

	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return;

	CMDataBaseClipboard.CDestination.CSymbolPathName = ExtractPathName(CFileName);
	CMDataBaseClipboard.CDestination.CSymbolFileName = ExtractFileName(CFileName);

	BeginWaitCursor();

	if(!GCSuperSpiceDataBase.PasteSymbolFile(CMDataBaseClipboard)) 
	{
		EndWaitCursor();

		return;
	}

	EndWaitCursor();
}

void TCSymbolTreeView::Paste(TCDataBaseClipboard &CDataBaseClipboard)
{
	CDataBaseClipboard.CDestination.use_index = false;

	if(CDataBaseClipboard.CSource.CSymbolName != "") 
	{
		CString CFileName = GetFileName();

		CDataBaseClipboard.CDestination.CSymbolFileName	= ExtractFileName(CFileName);
		CDataBaseClipboard.CDestination.CSymbolPathName = ExtractPathName(CFileName);

		CDataBaseClipboard.symbol_count = GetIndex() + 1;

		GCSuperSpiceDataBase.PasteSymbol(CDataBaseClipboard);

		if(!(CDataBaseClipboard.symbol_count < 0)) 
		{
			Refresh();

			m_pTreeCtrl->Expand(GetFileItem(CFileName), TVE_EXPAND);

			HTREEITEM h_item = GetSymbolItem(CFileName, CDataBaseClipboard.CDestination.CSymbolName);

			m_pTreeCtrl->SelectItem(h_item);
		}
	}
	else
	{
		TCDataBaseClipboard CDataBaseClipboard;

		CString CFileName;

		CFileDialog	CLoadFileDialog(false, "",GCSuperSpiceGlobalData.CGeneric.CDataBaseLastSymbolFileName, OFN_OVERWRITEPROMPT,"SuperSpice Symbol Files  (*.ssm)| *.ssm||");

		if(CLoadFileDialog.DoModal() != IDOK) 
		{
			CFileName = CLoadFileDialog.GetPathName();

			GCSuperSpiceGlobalData.CGeneric.CDataBaseLastSymbolFileName = CFileName;

			return;
		}

		CFileName = CLoadFileDialog.GetPathName();

		if(CFileName == "") return;

		CDataBaseClipboard.CDestination.CSymbolPathName = ExtractPathName(CFileName);
		CDataBaseClipboard.CDestination.CSymbolFileName = ExtractFileName(CFileName);

		BeginWaitCursor();

		if(!GCSuperSpiceDataBase.PasteSymbolFile(CDataBaseClipboard)) 
		{
			EndWaitCursor();

			return;
		}

		EndWaitCursor();
	}
}

void TCSymbolTreeView::EditDelete(void)
{
	int symbol_file_index, symbol_index;

	symbol_file_index = GetFileIndex();
	symbol_index = GetIndex();

	if(symbol_file_index < 0) return;

	CString CFileName, CSymbolName, CMessage;

	if(!(symbol_index < 0)) 
	{
		CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].CSymbolList;

		if(CSymbolList.GetSize() < 2) // alaways leave at least one symbol in the file
		{
			AfxMessageBox(IDS_N0_DELETE_ALL_SYMBOLS, MB_OK);
			
			return;	
		}

		CSymbolName = GetSymbolName();
		CFileName = GetFileName();

		CMessage.LoadString(IDS_CONFIRM_SYMBOL_DELETE);

		CMessage += ' ' + CSymbolName + " : " + CFileName;
		
		if(AfxMessageBox(CMessage, MB_OKCANCEL) != IDOK) return;

		GCSuperSpiceDataBase.RemoveSymbol(symbol_file_index, symbol_index);
	}
	else 
	{
		CFileName = GetFileName();

		CMessage.LoadString(IDS_CONFIRM_SYM_FILE_REMOVAL);

		CMessage += ' ' + CFileName;

		if(AfxMessageBox(CMessage, MB_OKCANCEL) != IDOK) return;

		GCSuperSpiceDataBase.RemoveSymbolFile(symbol_file_index);
	}
}

void TCSymbolTreeView::Edit(void)
{
	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp *) AfxGetApp();
	
	TCSuperSpiceDoc *PCTopDoc = PCSuperSpiceApp->GetATopLevelDocument();

	if(!PCTopDoc) return;

	CString CFilePath, CSymbolFile;
	CString CFileName	= GetFileName();

	if(CFileName == "") return;

	CString CSymbolName = GetSymbolName();

	if(CSymbolName == "") return;

	CFilePath = ExtractPathName(CFileName);

	CSymbolFile = CFilePath + CSymbolName + ".sym";

	TCSchematicObjectData CSchematicObjectData;
	
	CSchematicObjectData.CSymbolData.CName		= CSymbolName;
	CSchematicObjectData.CSymbolData.CFilePath	= CFilePath;
	CSchematicObjectData.CSymbolData.CFileName	= ExtractFileName(CFileName);

	if(!GCSuperSpiceDataBase.CSymbolDataBase.Get(CSchematicObjectData)) return;
		
	if(!CSchematicObjectData.IsStraightVectorsOnly())
	{
		PCTopDoc->DisplayError(IDS_HELP_NOTE, IDS_CANNOT_EDIT_SYM_WITH_CURVES);

		return;
	}

	PCTopDoc->DisplaySymbolEditorDocument(CSymbolFile, CFileName, CSymbolName);
}

void TCSymbolTreeView::NewSymbolFile(void)
{
	CString CFileName;

	CFileDialog	CLoadFileDialog(true, "ssm",GCSuperSpiceGlobalData.CGeneric.CDataBaseLastSymbolFileName, 0,"SuperSpice Component Files  (*.ssm)| *.ssm||");

	if(CLoadFileDialog.DoModal() != IDOK)
	{
		CFileName = CLoadFileDialog.GetPathName();

		return;
	}

	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return;

	GCSuperSpiceGlobalData.CGeneric.CDataBaseLastSymbolFileName = CFileName;

	BeginWaitCursor();

	if(!GCSuperSpiceDataBase.NewSymbolFile(CFileName))
	{
		AfxMessageBox(IDS_UNABLE_TO_VREATE_SYM_FILE);

		return;
	}

	EndWaitCursor();
}

void TCSymbolTreeView::NewSymbol(void)
{
	if(!GCSuperSpiceDataBase.NewSymbol(GetFileName()))
	{
		AfxMessageBox(IDS_UNABLE_TO_VREATE_SYM);
	}
}

void TCSymbolTreeView::AddSymbolFile(void)
{
	CString CFileName;

	CFileDialog	CLoadFileDialog(true, "ssm",GCSuperSpiceGlobalData.CGeneric.CDataBaseLastSymbolFileName, 0,"SuperSpice Component Files  (*.ssm)| *.ssm||");

	if(CLoadFileDialog.DoModal() != IDOK)
	{
		CFileName = CLoadFileDialog.GetPathName();

		return;
	}

	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return;

	GCSuperSpiceGlobalData.CGeneric.CDataBaseLastSymbolFileName = CFileName;

	BeginWaitCursor();

	if(!GCSuperSpiceDataBase.AddSymbolFile(CFileName))
	{
		AfxMessageBox(IDS_ERR_ADD_SYM_FILE);

		return;
	}

	EndWaitCursor();
}

void TCSymbolTreeView::Rename(HTREEITEM HItem, CString CName)
{
	m_pTreeCtrl->SetItemText(HItem, CName);

	m_pTreeCtrl->SelectItem(HItem);
}

void TCSymbolTreeView::Rename(void)
{
	TCTreeRename CTreeRename;
	
	CString CFileName =  GetFileName();

	if(CFileName == "") return;

	CString CSymbolName = GetSymbolName();

	if(CSymbolName == "") return;

	CTreeRename.CName = CSymbolName;

	if(CTreeRename.DoModal() != IDOK) return;

	CTreeRename.CName.TrimLeft();
	CTreeRename.CName.TrimRight();

	if(CTreeRename.CName == "") return;

	if(CTreeRename.CName == CSymbolName) return;

	GCSuperSpiceDataBase.RenameSymbol(CFileName, CSymbolName, CTreeRename.CName);
}

void TCSymbolTreeView::Properties(void)
{
	TCMasterSymbolDlg CComponentLibaryDlg;
		
	TCComponentDataBaseData CComponentDataBaseData;

	CString CFileName = GetFileName();

	CComponentDataBaseData.CSymbolFileName	= ExtractFileName(CFileName);
	CComponentDataBaseData.CSymbolPathName	= ExtractPathName(CFileName);
	CComponentDataBaseData.CSymbolName		= GetSymbolName();

	GCSuperSpiceDataBase.SetDefaultSymbolDisplayed(CComponentDataBaseData);

	CComponentLibaryDlg.DoModal();
}

void TCSymbolTreeView::OpenSchematic(void)
{
	int symbol_file_index, symbol_index;

	symbol_file_index = GetFileIndex();
	symbol_index = GetIndex();

	if(symbol_file_index < 0) return;
	if(symbol_index < 0) return;

	CString CFileName;

	CArray <TCSymbolDataBaseData, TCSymbolDataBaseData &> &CFiles = GCSuperSpiceDataBase.CSymbolDataBase.CFileList;

	TCSchematicObjectData &CSchematicObjectData = CFiles[symbol_file_index].CSymbolList[symbol_index];

	if(CSchematicObjectData.CSymbolData.CChildFileName == "") return;

	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp *)AfxGetApp();

	if(!PCSuperSpiceApp) return;

	PCSuperSpiceApp->OpenDocumentFile(CSchematicObjectData.CSymbolData.CChildFileName);
}

void TCSymbolTreeView::OnUpdateOpenSchematic(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(false);

	int symbol_file_index, symbol_index;

	symbol_file_index = GetFileIndex();
	symbol_index = GetIndex();

	if(symbol_file_index < 0) return;
	if(symbol_index < 0) return;

	CArray <TCSymbolDataBaseData, TCSymbolDataBaseData &> &CFiles = GCSuperSpiceDataBase.CSymbolDataBase.CFileList;

	TCSchematicObjectData &CSchematicObjectData = CFiles[symbol_file_index].CSymbolList[symbol_index];

	if(CSchematicObjectData.CSymbolData.CChildFileName == "") return;

	pCmdUI->Enable();
}

bool TCSymbolTreeView::IsDragging(void)
{
	return m_is_dragging;
}

bool TCSymbolTreeView::PlaceDragedSymbol(void)
{
	PlaceSymbol();

	return true;
}

void TCSymbolTreeView::ClearDragging(void)
{
	m_is_dragging	= false;
}

BOOL TCSymbolTreeView::PreTranslateMessage(MSG* pMsg) 
{
	return CXTTreeView::PreTranslateMessage(pMsg);
}

void TCSymbolTreeView::OnBeginDragDrop(NMHDR* pNMHDR, LRESULT* pResult) 
{
	pNMHDR; pResult;

	m_is_dragging = true;

	return;
}