#if !defined(AFX_TABVIEW2_H__0EDC1D11_1C40_45B7_9AE2_CC2D8E295F20__INCLUDED_)
#define AFX_TABVIEW_H__0EDC1D11_1C40_45B7_9AE2_CC2D8E295F20__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <afxcview.h>
#include "TCNumberStack.h"

class TCSymbolTreeView : public CXTTreeView
{
protected: // create from serialization only
	TCSymbolTreeView();
	DECLARE_DYNCREATE(TCSymbolTreeView)

// Attributes
public:
	TCSymbolTreeDoc* GetDocument();
	
	CTreeCtrl  *m_pTreeCtrl;
	CImageList	m_ImageList;

	TCPageId				CFileID;
	TCDataBaseClipboard		CMDataBaseClipboard;
	bool m_is_dragging;

	void UpdateAllData(void);
	void Refresh(void);
	bool Add(CString CFileName, int symbol_index);
	bool AddFile(int symbol_file_index);
	bool Remove(HTREEITEM HItem);

	void SelectModel(void);
	void NewSymbolFile(void);
	void NewSymbol(void);
	void Edit(void);
	void EditCopy(void);
	void EditPaste(void);
	void EditDelete(void);
	void CopySymbolFile(void);
	void AddSymbolFile(void);
	void Rename(HTREEITEM HItem, CString CName);
	void Rename(void);
	void Properties(void);
	void OpenSchematic(void);
	void Copy(TCDataBaseClipboard &CDataBaseClipboard);
	void Paste(TCDataBaseClipboard &CDataBaseClipboard);
	bool IsDragging(void);
	bool PlaceDragedSymbol(void);

	
	HTREEITEM GetItemClicked(TV_HITTESTINFO &tvhti);
	int GetFileIndex();
	int GetIndex();

	HTREEITEM GetFileItem(CString CFileName);
	HTREEITEM GetSymbolItem(CString CFileName, CString CModelName);

	CString GetFileName(void);
	CString GetSymbolName(void);
	void ClearDragging(void);

	HTREEITEM hlast_saved_file;
	HTREEITEM hlast_saved_item;
	bool	  f_last_symbol;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(TCSymbolTreeView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void OnInitialUpdate(); // called first time after construct
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

// Implementation
public:
	void UpdateView();
	virtual ~TCSymbolTreeView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(TCSymbolTreeView)
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg LRESULT OnNcHitTest(CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnBeginDragDrop(NMHDR* pNMHDR, LRESULT* pResult);

	//}}AFX_MSG

	afx_msg void BeginLabelEdit(NMHDR * pNMHDR, LRESULT* pResult);
	afx_msg void OnDoubleClickTree(NMHDR * pNMHDR, LRESULT* pResult); 
	afx_msg void OnContextMenu(CWnd*, CPoint point);

	afx_msg void OnUpdateOpenSchematic(CCmdUI* pCmdUI);
	afx_msg void PlaceSymbol(void);

	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in TabView.cpp
inline TCSymbolTreeDoc* TCSymbolTreeView::GetDocument()
   { return (TCSymbolTreeDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TABVIEW_H__0EDC1D11_1C40_45B7_9AE2_CC2D8E295F20__INCLUDED_)

