// TCTestPointDlg.cpp : implementation file
//

#include "stdafx.h"
#include "afxpriv.h"
#include "TESuperSpiceLabelEnums.h"
#include "resource.h"
#include "TCSuperSpiceDataBase.h"
#include "TCTestPointDlg.h"
#include "SuperSpice.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// TCTestPointDlg dialog

extern TCSuperSpiceDataBase GCSuperSpiceDataBase;

TCTestPointDlg::TCTestPointDlg(CWnd* pParent /*=NULL*/)
	: CDialog(TCTestPointDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(TCTestPointDlg)
	m_visable_ref_des = FALSE;
	m_visable_type = FALSE;
	CMEditRefDes = _T("");
	m_type = -1;
	CMEditNetPinName = _T("");
	m_visable_net_pin_name = FALSE;
	//}}AFX_DATA_INIT
}


void TCTestPointDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCTestPointDlg)
	DDX_Check(pDX, IDC_CHECK_VISABLE_REF_DESIGNATOR, m_visable_ref_des);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TYPE, m_visable_type);
	DDX_Text(pDX, IDC_EDIT_REF_DESIGNATOR, CMEditRefDes);
	DDX_Radio(pDX, IDC_RADIO_VOLTAGE, m_type);
	DDX_Text(pDX, IDC_EDIT_NET_PIN_NAME, CMEditNetPinName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_NET_PIN, m_visable_net_pin_name);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCTestPointDlg, CDialog)
	//{{AFX_MSG_MAP(TCTestPointDlg)
	ON_BN_CLICKED(IDHELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCTestPointDlg message handlers

void TCTestPointDlg::OnOK() 
{
	CDialog::OnOK();

	if(CSchematicObjectData.CLabelListData.GetSize())
	{
		CSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = !!m_visable_ref_des;
		CSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = CMEditRefDes;

		CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = !!m_visable_type;
		CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].is_visable = !!m_visable_net_pin_name;
	
		CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = GCSuperSpiceDataBase.CTestPointNames[m_type];
	}

	CSchematicObjectData.version = (short) m_type;
}

BOOL TCTestPointDlg::OnInitDialog() 
{
 	if(CSchematicObjectData.CLabelListData.GetSize())
	{
		m_visable_ref_des	= CSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].is_visable;
		CMEditRefDes		= CSchematicObjectData.CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

		m_visable_type		= CSchematicObjectData.CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable;

		m_visable_net_pin_name	= CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].is_visable;
		CMEditNetPinName		= CSchematicObjectData.CPinListData[0].CLabelListData[E_COMPONENT_PIN_NET_NAME].CLabel;
	}
	else
	{
		CMEditRefDes = "(NULL)";
		CMEditNetPinName = "(NULL)";
		m_visable_net_pin_name = 0;
		m_visable_type = 0;
	}

	m_type = CSchematicObjectData.version;

	CDialog::OnInitDialog();
	
	
	return TRUE;
}

void TCTestPointDlg::OnHelp() 
{
	DWORD dwData;

	dwData = HID_BASE_RESOURCE + IDD_DIALOGTEST_POINTS;

	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp*) AfxGetMainWnd();

	PCSuperSpiceApp->DialogHelp(dwData);
}
