#include "stdafx.h"
#include "TDVersion.h"
#include "TCTextBitmap.h"

extern HDC	HDCMDestCmp;
extern int global_screen_planes;
extern int global_screen_bitspixels;

// These local globals are to speed up the create text 
// bitmaps by avoiding dynamic creation on the stack 
CBitmap CTempBitmap; // required to create space text out and mem dc
CFont CTextFont;
CFont *COldFont = NULL;
HGDIOBJ OldObject = NULL;
HGDIOBJ HOldViewObject;
HGDIOBJ CBrushObject;

IMPLEMENT_SERIAL(TCTextBitmap, CBitmap, ID_VERSION_NUMBER)

TCTextBitmap::TCTextBitmap(void)
{

}


TCTextBitmap::TCTextBitmap(TCTextBitmap &CTextBitmap)
{
	*this = CTextBitmap;
}
TCTextBitmap::~TCTextBitmap()
{

}


CSize *TCTextBitmap::CreateTextBitmap(CDC *PCViewDC, LOGFONT &s_log_font, CString &CText, COLORREF &colour, float connection_dot)
{
	if(!CTextFont.CreateFontIndirect(&s_log_font)) return NULL;

	COldFont = PCViewDC->SelectObject(&CTextFont);

	if(!COldFont)
	{
		CTextFont.DeleteObject();

		return NULL;
	}

	CBrush	CConnectionBrush;

	CConnectionBrush.CreateSolidBrush(colour);

	CBrushObject = NULL;

	//connection_dot
	if(!connection_dot)
		CBitmapSize	= PCViewDC->GetTextExtent(CText);
	else
	{
//		CBitmapSize	= PCViewDC->GetTextExtent(CText);
		CBitmapSize.cx = (int)(connection_dot);
		CBitmapSize.cy = (int)(connection_dot);
	}

	CRect CConnectionDot(0, 0, CBitmapSize.cx, CBitmapSize.cy);

	int x = CBitmapSize.cx;
	int y = CBitmapSize.cy;

	if(!CTempBitmap.CreateBitmap(x, y, global_screen_planes, global_screen_bitspixels, NULL))
	{
		PCViewDC->SelectObject(COldFont);

		CTextFont.DeleteObject();
		
		return NULL;
	}
	
	if(!CreateBitmap(x, y, global_screen_planes, global_screen_bitspixels, NULL))
	{
		PCViewDC->SelectObject(COldFont);
		CTextFont.DeleteObject();
		CTempBitmap.DeleteObject();
		
		return NULL;
	}


	// create memory for text out

 	HOldViewObject = PCViewDC->SelectObject(CTempBitmap);

	if(!HOldViewObject)
	{
		PCViewDC->SelectObject(COldFont);
		CTextFont.DeleteObject();
		CTempBitmap.DeleteObject();
		DeleteObject();
		
		return NULL;
	}

	OldObject = SelectObject(HDCMDestCmp, *this);

	if(!OldObject)
	{
		PCViewDC->SelectObject(HOldViewObject);
		PCViewDC->SelectObject(COldFont);
		CTextFont.DeleteObject();
		CTempBitmap.DeleteObject();
		DeleteObject();
		
		return NULL;
	}

	if(connection_dot)
		CBrushObject = PCViewDC->SelectObject(CConnectionBrush);

	if(!CBrushObject && connection_dot)
	{
		PCViewDC->SelectObject(OldObject);
		PCViewDC->SelectObject(HOldViewObject);
		PCViewDC->SelectObject(COldFont);
		CTextFont.DeleteObject();
		CTempBitmap.DeleteObject();
		DeleteObject();
		
		return NULL;
	}

	COLORREF prior_colour = PCViewDC->SetTextColor(colour);

	//connection_dot
	if(!connection_dot)
		PCViewDC->TextOut(0, 0, CText);
	else
	{
	//	PCViewDC->TextOut(0, 0, CText);
	//	PCViewDC->Ellipse(CConnectionDot); 
		PCViewDC->Rectangle(CConnectionDot);
	}

	BitBlt(HDCMDestCmp, 0, 0, x, y, PCViewDC->m_hDC, 0, 0, SRCCOPY);

	PCViewDC->SetTextColor(prior_colour);

	if(connection_dot)
		PCViewDC->SelectObject(CBrushObject);
	PCViewDC->SelectObject(HOldViewObject);
	SelectObject(HDCMDestCmp, OldObject);
	PCViewDC->SelectObject(COldFont);

	CTempBitmap.DeleteObject();
	CTextFont.DeleteObject();

	return &CBitmapSize;
}

CSize *TCTextBitmap::CreateTextMaskBitmap(CDC *PCViewDC, LOGFONT &s_log_font, CString &CText, float connection_dot)
{
	if(!CTextFont.CreateFontIndirect(&s_log_font)) return NULL;

	if(!PCViewDC->m_hDC) 
	{
		ASSERT(0);

		return NULL;
	}
	COldFont	= PCViewDC->SelectObject(&CTextFont);

	if(!COldFont)
	{
		CTextFont.DeleteObject();

		return NULL;
	}

	CBrush	CConnectionBrush;

	CConnectionBrush.CreateSolidBrush(0);

	CBrushObject = NULL;

	//connection_dot
	if(!connection_dot)
		CBitmapSize	= PCViewDC->GetTextExtent(CText);
	else
	{
//		CBitmapSize	= PCViewDC->GetTextExtent(CText);
		CBitmapSize.cx = (int)(connection_dot);
		CBitmapSize.cy = (int)(connection_dot);
	}

	CRect CConnectionDot(0, 0, CBitmapSize.cx, CBitmapSize.cy);

	int x = CBitmapSize.cx;
	int y = CBitmapSize.cy;

	if(!CTempBitmap.CreateBitmap(x, y, global_screen_planes, global_screen_bitspixels, NULL))
	{
		PCViewDC->SelectObject(COldFont);

		CTextFont.DeleteObject();
		
		return NULL;
	}
	if(!CreateBitmap(x, y, global_screen_planes, global_screen_bitspixels, NULL))
	{
		PCViewDC->SelectObject(COldFont);
		CTextFont.DeleteObject();
		CTempBitmap.DeleteObject();

		return NULL;
	}
	// create memory for text out
	HOldViewObject = PCViewDC->SelectObject(CTempBitmap);

	if(!HOldViewObject)
	{
		PCViewDC->SelectObject(COldFont);
		CTextFont.DeleteObject();
		CTempBitmap.DeleteObject();
		DeleteObject();
		
		return NULL;
	}

	OldObject = SelectObject(HDCMDestCmp, *this);

	if(!OldObject)
	{
		PCViewDC->SelectObject(HOldViewObject);
		PCViewDC->SelectObject(COldFont);
		CTextFont.DeleteObject();
		CTempBitmap.DeleteObject();
		DeleteObject();
		
		return NULL;
	}

	if(connection_dot)
		CBrushObject = PCViewDC->SelectObject(CConnectionBrush);

	if(!CBrushObject && connection_dot)
	{
		PCViewDC->SelectObject(OldObject);
		PCViewDC->SelectObject(HOldViewObject);
		PCViewDC->SelectObject(COldFont);
		CTextFont.DeleteObject();
		CTempBitmap.DeleteObject();
		DeleteObject();
		
		return NULL;
	}

	//connection_dot
	if(!connection_dot)
		PCViewDC->TextOut(0, 0, CText);
	else
	{
//		PCViewDC->Ellipse(CConnectionDot);
		PCViewDC->Rectangle(CConnectionDot);
	}

	BitBlt(HDCMDestCmp, 0, 0, x, y, PCViewDC->m_hDC, 0, 0, NOTSRCCOPY);

	if(connection_dot)
		PCViewDC->SelectObject(CBrushObject);
	PCViewDC->SelectObject(HOldViewObject);
	SelectObject(HDCMDestCmp, OldObject);
	PCViewDC->SelectObject(COldFont);

	CTempBitmap.DeleteObject();
	CTextFont.DeleteObject();

	return &CBitmapSize;
}

void TCTextBitmap::Delete()
{

}

void TCTextBitmap::operator = (TCTextBitmap &CTextBitmap)
{
	CTextBitmap;
//	CBitmap::operator =(CTextBitmap);
}

void TCTextBitmap::Serialize(CArchive& CFileArchive)
{
	CBitmap::Serialize(CFileArchive);

	if(CFileArchive.IsStoring())
	{

	}
	else
	{

	}
}