#include "stdafx.h"
#include "TCTimer.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/*
// you can only use this class to implement one single time only totally 
//in any part of the whole program


//to use this class

//in user class header add data member
class TCAClass : public
{
	TCTimer CMTimer;

  static FCallBack

}

e.g in constructor

TCAClass::TCAClass
{
	CMTimer.SetCallBack();
}

*/
VOID CALLBACK  OnTimerCallBack(HWND hwnd, UINT uMsg, UINT idEvent, TIMERPROC dwTime);    
TCTimer *GPCTimer = NULL;

// 1 is verson number, Serializeaint really required for this timer class
IMPLEMENT_SERIAL(TCTimer, CObject, 1)

TCTimer::TCTimer(void)
{
	m_is_running		= false;
	m_id				= 0;
	m_resolution		= 100;
	m_handle			= 0;
	FCCallBackFunction	= NULL;
	PCCallBackThis		= NULL;
}

TCTimer::TCTimer(TCTimer &CTimer)
{
	*this = CTimer;
}

TCTimer::~TCTimer(void)
{

}

// probably not required
void TCTimer::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << m_is_running;
		CArchiveFile << m_id;
		CArchiveFile << m_resolution;

	}
	else
	{
		CArchiveFile >> m_is_running;
		CArchiveFile >> m_id;
		CArchiveFile >> m_resolution;
	}
}

// probably not required
void TCTimer::operator = (TCTimer &CTimer)
{
	m_is_running		= CTimer.m_is_running;
	m_id				= CTimer.m_id;
	m_resolution		= CTimer.m_resolution;
	m_handle			= CTimer.m_handle;
	FCCallBackFunction  = CTimer.FCCallBackFunction;
	PCCallBackThis		= CTimer.PCCallBackThis;
}


int TCTimer::Start(void)
{
	m_handle = SetTimer(NULL, m_id, m_resolution, (TIMERPROC) OnTimerCallBack);

	if(m_handle) m_is_running = true;
	else m_is_running = false;

	return m_is_running;
}

bool TCTimer::Stop(void)
{
	if(m_handle) return false;

	KillTimer(NULL, m_handle);

	m_handle = 0;
	m_is_running = false;

	return true;
}

int TCTimer::IsRunning(void)
{
	return m_is_running;
}

bool TCTimer::SetCallBack(void (*FCCallBack)(void *), void *PCThis, int id, int resolution)
{
	if(!FCCallBack)	return false;
	if(!PCThis)		return false;
	if(!resolution)	return false;
	if(!id)			return false;

	FCCallBackFunction  = FCCallBack;
	PCCallBackThis		= PCThis;
	m_id				= id;
	m_resolution		= resolution;

	GPCTimer = this;// this needs modified to create more then one timer

	return true;
}

bool TCTimer::SetCallBack(void (*FCCallBack)(void *), void *PCThis,  int resolution)
{
	return SetCallBack(FCCallBack, PCThis, 1, resolution);
}

VOID CALLBACK  OnTimerCallBack(HWND hwnd, UINT uMsg, UINT idEvent, TIMERPROC dwTime)
{
    hwnd;idEvent;dwTime;uMsg;

	if(!GPCTimer) return;

	if(!GPCTimer->FCCallBackFunction)	return;
	if(!GPCTimer->PCCallBackThis)		return;
	if(!GPCTimer->m_resolution)			return;

	GPCTimer->FCCallBackFunction(GPCTimer->PCCallBackThis);
}

