// TCTransformerLabelsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "math.h"
#include "TCMKSConvert.h"
#include "resource.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCSchematicObjectData.h"
#include "TCTransformerLabelsDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCTransformerLabelsDlg, CPropertyPage)

extern int g_last_active_component_property_page;

/////////////////////////////////////////////////////////////////////////////
// TCTransformerLabelsDlg property page

TCTransformerLabelsDlg::TCTransformerLabelsDlg() : CPropertyPage(TCTransformerLabelsDlg::IDD)
{
	//{{AFX_DATA_INIT(TCTransformerLabelsDlg)
	m_ref_des_visable = FALSE;
	m_spice_name_visable = FALSE;
	m_value_visable = FALSE;
	CMEditSpicename = _T("");
	CMEditRefDes = _T("");
	CMEditValue = _T("");
	m_type_name_visable = FALSE;
	CMEditTypeName = _T("");
	m_check_visable_coupling = FALSE;
	m_check_visable_l1 = FALSE;
	m_check_visable_l2 = FALSE;
	CMEditCoupling = _T("");
	CMEditL1 = _T("");
	CMEditL2 = _T("");
	//}}AFX_DATA_INIT
}

TCTransformerLabelsDlg::~TCTransformerLabelsDlg()
{
}

void TCTransformerLabelsDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCTransformerLabelsDlg)
	DDX_Control(pDX, IDC_EDIT_VALUE, CMEditCntlValue);
	DDX_Control(pDX, IDC_EDIT_TYPE_NAME, CMEditCntlTypeName);
	DDX_Control(pDX, IDC_EDIT_SPICE_NAME, CMEditCntlSpiceName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_REF_DESIGNATOR, m_ref_des_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_SPICE_NAME, m_spice_name_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE, m_value_visable);
	DDX_Text(pDX, IDC_EDIT_SPICE_NAME, CMEditSpicename);
	DDX_Text(pDX, IDC_EDIT_REF_DESIGNATOR, CMEditRefDes);
	DDX_Text(pDX, IDC_EDIT_VALUE, CMEditValue);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TYPE_NAME, m_type_name_visable);
	DDX_Text(pDX, IDC_EDIT_TYPE_NAME, CMEditTypeName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_K, m_check_visable_coupling);
	DDX_Check(pDX, IDC_CHECK_VISABLE_L1, m_check_visable_l1);
	DDX_Check(pDX, IDC_CHECK_VISABLE_L2, m_check_visable_l2);
	DDX_Text(pDX, IDC_EDIT_K, CMEditCoupling);
	DDX_Text(pDX, IDC_EDIT_L1, CMEditL1);
	DDX_Text(pDX, IDC_EDIT_L2, CMEditL2);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCTransformerLabelsDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCTransformerLabelsDlg)
	ON_EN_KILLFOCUS(IDC_EDIT_L1, OnKillfocusEditL1)
	ON_EN_KILLFOCUS(IDC_EDIT_L2, OnKillfocusEditL2)
	ON_EN_KILLFOCUS(IDC_EDIT_SPICE_NAME, OnKillfocusEditSpiceName)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



BOOL TCTransformerLabelsDlg::OnKillActive() 
{
	
	CPropertyPage::OnKillActive();

	if(!PCSchematicObjectData) return true;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = !!m_type_name_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = 	CMEditTypeName;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable = !!m_value_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel = CMEditValue;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = !!m_ref_des_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = CMEditRefDes;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = !!m_spice_name_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMEditSpicename;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSFORMER_COUPLING].is_visable = !!m_check_visable_coupling;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSFORMER_L1].is_visable = !!m_check_visable_l1;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSFORMER_L2].is_visable = !!m_check_visable_l2;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSFORMER_COUPLING].CLabelValue = CMEditCoupling;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSFORMER_L1].CLabelValue = CMEditL1;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSFORMER_L2].CLabelValue = CMEditL2;

	PCSchematicObjectData->FormatLabel();

	return true;
}

BOOL TCTransformerLabelsDlg::OnSetActive() 
{
	g_last_active_component_property_page = 0;
	
	PCSchematicObjectData->FormatSpiceName();
	PCSchematicObjectData->FormatSpiceValue();

	CMEditSpicename	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;
	CMEditValue = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	CMEditCntlValue.SetWindowText(CMEditValue);
	CMEditCntlSpiceName.SetWindowText(CMEditSpicename);

	return CPropertyPage::OnSetActive();
}

BOOL TCTransformerLabelsDlg::OnInitDialog() 
{
	 
	m_type_name_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable;
	CMEditTypeName		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel;

	m_ref_des_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable;
	CMEditRefDes		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	m_spice_name_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable;
	CMEditSpicename		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

	m_check_visable_coupling = PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSFORMER_COUPLING].is_visable;
	m_check_visable_l1 = PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSFORMER_L1].is_visable;
	m_check_visable_l2 = PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSFORMER_L2].is_visable;

	CMEditCoupling	= PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSFORMER_COUPLING].CLabelValue;
	CMEditL1 = PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSFORMER_L1].CLabelValue;
	CMEditL2 = PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSFORMER_L2].CLabelValue;

	//To do n1:n2

//	CMEditValue = GetTurnsRatio(CMEditL1, CMEditL2);

	CMEditValue	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	m_value_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable;
	
	CPropertyPage::OnInitDialog();
	
//	CMEditCntlSpiceName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only);
//	CMEditCntlTypeName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only);
	CMEditCntlValue.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].read_only);

	return TRUE;  
}

void TCTransformerLabelsDlg::OnKillfocusEditL1() 
{/*
	UpdateData(true);
	CMEditValue = GetTurnsRatio(CMEditL1, CMEditL2);
	UpdateData(false);*/
}

void TCTransformerLabelsDlg::OnKillfocusEditL2() 
{
/*	UpdateData(true);
	CMEditValue = GetTurnsRatio(CMEditL1, CMEditL2);
	UpdateData(false);	*/
}

void TCTransformerLabelsDlg::OnKillfocusEditSpiceName() 
{
	UpdateData(true);
	
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMEditSpicename;

	PCSchematicObjectData->FormatRecordName();
	PCSchematicObjectData->FormatSpiceValue();

	CMEditValue = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	CMEditCntlValue.SetWindowText(CMEditValue);
	
}
