// TCTransmissionLineLabelsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TCMKSConvert.h"
#include "TCSuperSpiceDataBase.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCSchematicObjectData.h"
#include "TCTransmissionLineLabelsDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCTransmissionLineLabelsDlg, CPropertyPage)

extern int g_last_active_component_property_page;
extern TCSuperSpiceDataBase GCSuperSpiceDataBase;

/////////////////////////////////////////////////////////////////////////////
// TCTransmissionLineLabelsDlg property page

TCTransmissionLineLabelsDlg::TCTransmissionLineLabelsDlg() : CPropertyPage(TCTransmissionLineLabelsDlg::IDD)
{
	//{{AFX_DATA_INIT(TCTransmissionLineLabelsDlg)
	m_ref_des_visable = FALSE;
	m_spice_name_visable = FALSE;
	m_value_visable = FALSE;
	CMEditSpicename = _T("");
	CMEditRefDes = _T("");
	CMEditValue = _T("");
	m_type_name_visable = FALSE;
	CMEditTypeName = _T("");
	m_check_visable_c = FALSE;
	m_check_visable_f = FALSE;
	m_check_visable_l = FALSE;
	m_check_visable_length = FALSE;
	m_check_visable_r = FALSE;
	m_check_visable_td = FALSE;
	m_check_visable_z = FALSE;
	CMEditC = _T("");
	CMEditF = _T("");
	CMEditL = _T("");
	CMEditLength = _T("");
	CMEditR = _T("");
	CMEditTd = _T("");
	CMEditZ = _T("");
	//}}AFX_DATA_INIT
}

TCTransmissionLineLabelsDlg::~TCTransmissionLineLabelsDlg()
{
}

void TCTransmissionLineLabelsDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCTransmissionLineLabelsDlg)
	DDX_Control(pDX, IDC_EDIT_Z0, CMEditCntlZ0);
	DDX_Control(pDX, IDC_EDIT_TD, CMEditCntlTd);
	DDX_Control(pDX, IDC_EDIT_FREQUENCY, CMEditCntlF);
	DDX_Control(pDX, IDC_EDIT_VALUE, CEditCntlSpiceValue);
	DDX_Control(pDX, IDC_EDIT_TYPE_NAME, CEditCntlTypeName);
	DDX_Control(pDX, IDC_EDIT_SPICE_NAME, CEditCntlSpiceName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_REF_DESIGNATOR, m_ref_des_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_SPICE_NAME, m_spice_name_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE, m_value_visable);
	DDX_Text(pDX, IDC_EDIT_SPICE_NAME, CMEditSpicename);
	DDX_Text(pDX, IDC_EDIT_REF_DESIGNATOR, CMEditRefDes);
	DDX_Text(pDX, IDC_EDIT_VALUE, CMEditValue);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TYPE_NAME, m_type_name_visable);
	DDX_Text(pDX, IDC_EDIT_TYPE_NAME, CMEditTypeName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_C, m_check_visable_c);
	DDX_Check(pDX, IDC_CHECK_VISABLE_FREQ, m_check_visable_f);
	DDX_Check(pDX, IDC_CHECK_VISABLE_L, m_check_visable_l);
	DDX_Check(pDX, IDC_CHECK_VISABLE_LENGTH, m_check_visable_length);
	DDX_Check(pDX, IDC_CHECK_VISABLE_R, m_check_visable_r);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TD, m_check_visable_td);
	DDX_Check(pDX, IDC_CHECK_VISABLE_Z0, m_check_visable_z);
	DDX_Text(pDX, IDC_EDIT_C, CMEditC);
	DDX_Text(pDX, IDC_EDIT_FREQUENCY, CMEditF);
	DDX_Text(pDX, IDC_EDIT_L, CMEditL);
	DDX_Text(pDX, IDC_EDIT_LENGTH, CMEditLength);
	DDX_Text(pDX, IDC_EDIT_R, CMEditR);
	DDX_Text(pDX, IDC_EDIT_TD, CMEditTd);
	DDX_Text(pDX, IDC_EDIT_Z0, CMEditZ);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCTransmissionLineLabelsDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCTransmissionLineLabelsDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



BOOL TCTransmissionLineLabelsDlg::OnKillActive() 
{
	
	CPropertyPage::OnKillActive();

	if(!PCSchematicObjectData) return true;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = !!m_type_name_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = 	CMEditTypeName;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = !!m_ref_des_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = CMEditRefDes;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = !!m_spice_name_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMEditSpicename;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable = !!m_value_visable;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_C0].is_visable = !!m_check_visable_c;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_F0].is_visable = !!m_check_visable_f;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_L0].is_visable = !!m_check_visable_l;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_LENGTH].is_visable = !!m_check_visable_length;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_R0].is_visable = !!m_check_visable_r;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_TD].is_visable = !!m_check_visable_td;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_Z0].is_visable = !!m_check_visable_z;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_TD].CLabelValue = CMEditTd;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_Z0].CLabelValue = CMEditZ;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_F0].CLabelValue = CMEditF;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_C0].CLabelValue = CMEditC;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_R0].CLabelValue = CMEditR;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_G0].CLabelValue = "";
	PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_L0].CLabelValue = CMEditL;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_LENGTH].CLabelValue = CMEditLength;
	
	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel = CMEditValue;

	double data; 

	TCSpiceParameters *PCSpiceParameters = GCSuperSpiceDataBase.GetModelPointer(PCSchematicObjectData->CSpiceParameters);

	data = MKSStringToFloat(CMEditR);
	PCSpiceParameters->Set("R", data);

	PCSpiceParameters->Get("R", &data);

	data = MKSStringToFloat(CMEditL);
	PCSpiceParameters->Set("L", data);

	data = MKSStringToFloat(CMEditC);
	PCSpiceParameters->Set("C", data);

	data = MKSStringToFloat(CMEditLength);
	PCSpiceParameters->Set("LEN", data);

	PCSpiceParameters->Set("G", 0);

	PCSchematicObjectData->FormatLabel();

	return true;
}

BOOL TCTransmissionLineLabelsDlg::OnSetActive() 
{
	g_last_active_component_property_page = 0;
	
	CMEditValue	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	PCSchematicObjectData->FormatSpiceName();

	CMEditSpicename	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

	double data;

	TCSpiceParameters *PCSpiceParameters = GCSuperSpiceDataBase.GetModelPointer(PCSchematicObjectData->CSpiceParameters);

	if(!PCSpiceParameters) return CPropertyPage::OnSetActive();
	
	PCSpiceParameters->Get("R", &data);
	CMEditR = FloatToMKSString(data);

	PCSpiceParameters->Get("L", &data);
	CMEditL = FloatToMKSString(data);

	PCSpiceParameters->Get("C", &data);
	CMEditC = FloatToMKSString(data);

	PCSpiceParameters->Get("LEN", &data);
	CMEditLength = FloatToMKSString(data);

	return CPropertyPage::OnSetActive();
}

BOOL TCTransmissionLineLabelsDlg::OnInitDialog() 
{
	 
	m_type_name_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable;
	CMEditTypeName		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel;

	m_value_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable;
	CMEditValue		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	m_ref_des_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable;
	CMEditRefDes		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	m_spice_name_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable;
	CMEditSpicename		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;


	m_check_visable_c = PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_C0].is_visable;
	m_check_visable_f = PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_F0].is_visable;
	m_check_visable_l = PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_L0].is_visable;
	m_check_visable_length = PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_LENGTH].is_visable;
	m_check_visable_r = PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_R0].is_visable;
	m_check_visable_td = PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_TD].is_visable;
	m_check_visable_z = PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_Z0].is_visable;

	CMEditF = PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_F0].CLabelValue;
	CMEditTd = PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_TD].CLabelValue;
	CMEditZ = PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_Z0].CLabelValue;

	double data;

	TCSpiceParameters *PCSpiceParameters = GCSuperSpiceDataBase.GetModelPointer(PCSchematicObjectData->CSpiceParameters);

	if(!PCSpiceParameters) return TRUE; 

	PCSpiceParameters->Get("R", &data);
	CMEditR = FloatToMKSString(data);

	PCSpiceParameters->Get("L", &data);
	CMEditL = FloatToMKSString(data);

	PCSpiceParameters->Get("C", &data);
	CMEditC = FloatToMKSString(data);

	PCSpiceParameters->Get("LEN", &data);
	CMEditLength = FloatToMKSString(data);

	CPropertyPage::OnInitDialog();
	
//	CEditCntlSpiceName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only);
//	CEditCntlTypeName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only);
	CEditCntlSpiceValue.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].read_only);
	CMEditCntlF.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_F0].read_only);
	CMEditCntlTd.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_TD].read_only);
	CMEditCntlZ0.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_TRANSMISSION_LINE_Z0].read_only);

	return TRUE;  
}
