// TCURCLabels.cpp : implementation file
//

#include "stdafx.h"
#include "superspice.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCMKSConvert.h"
#include "TCSchematicObjectData.h"
#include "TCURCLabels.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// TCURCLabels property page

IMPLEMENT_DYNCREATE(TCURCLabels, CPropertyPage)

extern int g_last_active_component_property_page;


TCURCLabels::TCURCLabels() : CPropertyPage(TCURCLabels::IDD)
{
	//{{AFX_DATA_INIT(TCURCLabels)
	m_visable_number_sections = FALSE;
	m_visable_ref_des = FALSE;
	m_visable_spice_name = FALSE;
	m_visable_type_name = FALSE;
	m_visable_value = FALSE;
	CEditNumberSections = _T("");
	CMRefDes = _T("");
	CMSpiceName = _T("");
	CMTypeName = _T("");
	CMValue = _T("");
	CMResistance = _T("");
	m_visable_resistance = FALSE;
	//}}AFX_DATA_INIT
}

TCURCLabels::~TCURCLabels()
{
}

void TCURCLabels::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCURCLabels)
	DDX_Control(pDX, IDC_EDIT_VALUE, CMEditCntlValue);
	DDX_Control(pDX, IDC_EDIT_SPICE_NAME, CMEditCntlSpiceName);
	DDX_Control(pDX, IDC_EDIT_TYPE_NAME, CMEditCntlTypeName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_NUM_SECTIONS, m_visable_number_sections);
	DDX_Check(pDX, IDC_CHECK_VISABLE_REF_DESIGNATOR, m_visable_ref_des);
	DDX_Check(pDX, IDC_CHECK_VISABLE_SPICE_NAME, m_visable_spice_name);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TYPE_NAME, m_visable_type_name);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE, m_visable_value);
	DDX_Text(pDX, IDC_EDIT_NUMBER_SECTIONS, CEditNumberSections);
	DDX_Text(pDX, IDC_EDIT_REF_DESIGNATOR, CMRefDes);
	DDX_Text(pDX, IDC_EDIT_SPICE_NAME, CMSpiceName);
	DDX_Text(pDX, IDC_EDIT_TYPE_NAME, CMTypeName);
	DDX_Text(pDX, IDC_EDIT_VALUE, CMValue);
	DDX_Text(pDX, IDC_EDIT_RESISTANCE, CMResistance);
	DDX_Check(pDX, IDC_CHECK_VISABLE_RESISTANCE, m_visable_resistance);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCURCLabels, CPropertyPage)
	//{{AFX_MSG_MAP(TCURCLabels)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCURCLabels message handlers

BOOL TCURCLabels::OnInitDialog() 
{
	m_visable_type_name = PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable;
	CMTypeName		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel;

	m_visable_value = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable;
	CMValue		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	m_visable_ref_des = PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable;
	CMRefDes		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	m_visable_spice_name = PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable;
	CMSpiceName		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

	m_visable_resistance = PCSchematicObjectData->CLabelListData[E_COMPONENT_URC_LENGTH].is_visable;
	
	CMResistance = PCSchematicObjectData->CLabelListData[E_COMPONENT_URC_LENGTH].CLabelValue;

	m_visable_number_sections = PCSchematicObjectData->CLabelListData[E_COMPONENT_URC_NUMBER_SECTIONS].is_visable;
	
	CEditNumberSections = PCSchematicObjectData->CLabelListData[E_COMPONENT_URC_NUMBER_SECTIONS].CLabelValue;

	CEditNumberSections.TrimLeft();
	CEditNumberSections.TrimRight();

	CMResistance.TrimLeft();
	CMResistance.TrimRight();

	if(CEditNumberSections == "") CEditNumberSections = "1";
	if(CMResistance == "") CMResistance = "1";

	CPropertyPage::OnInitDialog();
	
//	CMEditCntlTypeName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only);
//	CMEditCntlSpiceName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only);
	CMEditCntlValue.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].read_only);

	return TRUE; 
}

BOOL TCURCLabels::OnKillActive() 
{
	CPropertyPage::OnKillActive();

	if(!PCSchematicObjectData) return true;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = !!m_visable_type_name;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = 	CMTypeName;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable = !!m_visable_value;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel = CMValue;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = !!m_visable_ref_des;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = CMRefDes;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = !!m_visable_spice_name;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMSpiceName;


	CEditNumberSections.TrimLeft();
	CEditNumberSections.TrimRight();
	CMResistance.TrimLeft();
	CMResistance.TrimRight();

	if(!CEditNumberSections) CEditNumberSections = "1";
	if(CMResistance == "") CMResistance = "1";

	PCSchematicObjectData->CLabelListData[E_COMPONENT_URC_NUMBER_SECTIONS].is_visable = !!m_visable_number_sections;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_URC_NUMBER_SECTIONS].CLabelValue = CEditNumberSections;
	
	PCSchematicObjectData->CLabelListData[E_COMPONENT_URC_LENGTH].is_visable = !!m_visable_resistance;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_URC_LENGTH].CLabelValue = CMResistance;

	PCSchematicObjectData->FormatLabel();

	return true;
}

BOOL TCURCLabels::OnSetActive() 
{
	g_last_active_component_property_page = 0;

	CPropertyPage::OnSetActive();

	CMValue	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	PCSchematicObjectData->FormatSpiceName();

	CMSpiceName	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

	CEditNumberSections = PCSchematicObjectData->CLabelListData[E_COMPONENT_URC_NUMBER_SECTIONS].CLabelValue;

	CMResistance = PCSchematicObjectData->CLabelListData[E_COMPONENT_URC_LENGTH].CLabelValue;


	return true;
}
