// TCValueLabelsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TESuperSpiceEnums.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCMKSConvert.h"
#include "TCSchematicObjectData.h"
#include "TCValueLabelsDlg.h"
#include "TEPropertyViewTypes.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCValueLabelsDlg, CPropertyPage)

extern int g_last_active_component_property_page;

/////////////////////////////////////////////////////////////////////////////
// TCValueLabelsDlg property page

TCValueLabelsDlg::TCValueLabelsDlg() : CPropertyPage(TCValueLabelsDlg::IDD)
{
	//{{AFX_DATA_INIT(TCValueLabelsDlg)
	m_ref_des_visable = FALSE;
	m_spice_name_visable = FALSE;
	CMEditRefDes = _T("");
	m_type_name_visable = FALSE;
	CMEditTypeName = _T("");
	m_visable_value2 = FALSE;
	m_visable_value3 = FALSE;
	CMHeaderValue2 = _T("");
	CMHeaderValue3 = _T("");
	CMHeaderValue4 = _T("");
	m_visable_value4 = FALSE;
	CMHeaderValue = _T("");
	CMSpiceValue = _T("");
	CMSpiceName = _T("");
	m_check_visable_spice_value = FALSE;
	m_check_visable_rc = FALSE;
	m_visable_multiplier_m = FALSE;
	//}}AFX_DATA_INIT

	m_width = 1.0;
	m_length= 1.0;
	m_sheet= 1.0;
	m_resistance_capacitance = 1.0;
}

TCValueLabelsDlg::~TCValueLabelsDlg()
{
}

void TCValueLabelsDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCValueLabelsDlg)
	DDX_Control(pDX, IDC_EDIT_SPICE_VALUE, CMEditCntrlSpiceValue);
	DDX_Control(pDX, IDC_EDIT_TYPE_NAME, CMEditCntlTypeName);
	DDX_Control(pDX, IDC_EDIT_REF_DESIGNATOR, CMEditCntlRefDes);
	DDX_Check(pDX, IDC_CHECK_VISABLE_REF_DESIGNATOR, m_ref_des_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_SPICE_NAME, m_spice_name_visable);
	DDX_Text(pDX, IDC_EDIT_REF_DESIGNATOR, CMEditRefDes);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TYPE_NAME, m_type_name_visable);
	DDX_Text(pDX, IDC_EDIT_TYPE_NAME, CMEditTypeName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE_2, m_visable_value2);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE_3, m_visable_value3);
	DDX_MKSValue(pDX, IDC_EDIT_VALUE_2, m_width);
	DDX_MKSValue(pDX, IDC_EDIT_VALUE_3, m_length);
	DDX_Text(pDX, IDC_STATIC_VALUE_2, CMHeaderValue2);
	DDX_Text(pDX, IDC_STATIC_VALUE_3, CMHeaderValue3);
	DDX_Text(pDX, IDC_STATIC_VALUE_4, CMHeaderValue4);
	DDX_MKSValue(pDX, IDC_EDIT_VALUE_4, m_sheet);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE_4, m_visable_value4);
	DDX_Text(pDX, IDC_STATIC_VALUE, CMHeaderValue);
	DDX_MKSValue(pDX, IDC_EDIT_RC_VALUE, m_resistance_capacitance);
	DDX_Text(pDX, IDC_EDIT_SPICE_VALUE, CMSpiceValue);
	DDX_Text(pDX, IDC_EDIT_SPICE_NAME, CMSpiceName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_SPICE_VALUE, m_check_visable_spice_value);
	DDX_Check(pDX, IDC_CHECK_RC_VALUE, m_check_visable_rc);
	DDX_Check(pDX, IDC_CHECK_VISABLE_MULTIPLIER_M2, m_visable_multiplier_m);
	DDX_MKSValue(pDX, IDC_EDIT_MULTIPLIER_M2, m_multiplier_m);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCValueLabelsDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCValueLabelsDlg)
	ON_EN_KILLFOCUS(IDC_EDIT_VALUE_2, OnKillfocusEditValue2)
	ON_EN_KILLFOCUS(IDC_EDIT_VALUE_3, OnKillfocusEditValue3)
	ON_EN_KILLFOCUS(IDC_EDIT_VALUE_4, OnKillfocusEditValue4)
	ON_EN_KILLFOCUS(IDC_EDIT_RC_VALUE, OnKillfocusEditRcValue)
	ON_EN_KILLFOCUS(IDC_EDIT_MULTIPLIER_M2, OnKillfocusEditMultiplierM)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



BOOL TCValueLabelsDlg::OnKillActive() 
{
	
	CPropertyPage::OnKillActive();

	GetDisplay();

	return true;
}

BOOL TCValueLabelsDlg::OnSetActive() 
{
	SetDisplay();

	return CPropertyPage::OnSetActive();
}
void TCValueLabelsDlg::OnKillfocusEditSpiceName() 
{
	UpdateData(true);
	
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMSpiceName;

	PCSchematicObjectData->FormatRecordName();

	CMSpiceValue = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	CMEditCntrlSpiceValue.SetWindowText(CMSpiceValue);
}

BOOL TCValueLabelsDlg::OnInitDialog() 
{
	 
	m_type_name_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable;
	CMEditTypeName		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel;

	m_check_visable_spice_value = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable;
	CMSpiceValue		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	m_ref_des_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable;
	CMEditRefDes		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	m_spice_name_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable;
	CMSpiceName		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

	if(PCSchematicObjectData->component_property_view_type == E_PROPERTY_IC_RESISTOR)
	{
		CMHeaderValue = "Resistance";
		CMHeaderValue4 = "Ohms/Sq.";
	}
	else 
	{
		CMHeaderValue = "Capacitance";
		CMHeaderValue4 = "F/Sq.M";
	}

	CMHeaderValue2 = "Width";
	CMHeaderValue3 = "Length";

	if(PCSchematicObjectData->component_property_view_type == E_PROPERTY_IC_RESISTOR)
	{
		m_visable_value3 = PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_LENGTH].is_visable;
		m_length = MKSStringToFloat(PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_LENGTH].CLabelValue);

		m_visable_value2 = PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_WIDTH].is_visable;
		m_width = MKSStringToFloat(PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_WIDTH].CLabelValue);

		m_resistance_capacitance = MKSStringToFloat(PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_RESISTANCE].CLabelValue);
		m_check_visable_rc = PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_RESISTANCE].is_visable;

		m_multiplier_m = MKSStringToFloat(PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_MULTIPLIER_M].CLabelValue);
		m_visable_multiplier_m = PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_MULTIPLIER_M].is_visable;

		PCSchematicObjectData->CSpiceParameters.Get("RSH", &m_sheet);
		m_visable_value4 = PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_RESISTIVITY].is_visable;
		

	}
	else 
	{
		m_visable_value3 = PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_LENGTH].is_visable;
		m_length = MKSStringToFloat(PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_LENGTH].CLabelValue);

		m_visable_value2 = PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_WIDTH].is_visable;
		m_width = MKSStringToFloat(PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_WIDTH].CLabelValue);

		m_resistance_capacitance = MKSStringToFloat(PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_CAPAPACITANCE].CLabelValue);
		m_check_visable_rc = PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_CAPAPACITANCE].is_visable;

		m_multiplier_m = MKSStringToFloat(PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_MULTIPLIER_M].CLabelValue);
		m_visable_multiplier_m = PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_MULTIPLIER_M].is_visable;

		PCSchematicObjectData->CSpiceParameters.Get("CJ", &m_sheet);
		m_visable_value4 = PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_CAPACITIVITY].is_visable;
	}

	CPropertyPage::OnInitDialog();

//	CMEditCntrlSpiceValue.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only);
	CMEditCntlTypeName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only);
//	CMEditCntrlSpiceValue.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].read_only);
	CMEditCntlRefDes.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].read_only);


	return TRUE;  
}

void TCValueLabelsDlg::GetDisplay(void)
{
	if(!PCSchematicObjectData) return;

	UpdateData(true);

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = !!m_type_name_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = 	CMEditTypeName;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable = !!m_check_visable_spice_value;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel = CMSpiceValue;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = !!m_ref_des_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = CMEditRefDes;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = !!m_spice_name_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMSpiceName;	

	if(m_multiplier_m <= 0) m_multiplier_m = 1;

	if(PCSchematicObjectData->component_property_view_type == E_PROPERTY_IC_RESISTOR)
	{
		if(!(E_COMPONENT_RESISTOR_RESISTANCE < PCSchematicObjectData->CLabelListData.GetSize())) PCSchematicObjectData->CLabelListData.SetSize(E_COMPONENT_RESISTOR_RESISTANCE  + 1, E_COMPONENT_RESISTOR_RESISTANCE + 1);

		PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_WIDTH].is_visable = !!m_visable_value2;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_WIDTH].CLabelValue = FloatToMKSString(m_width);
		PCSchematicObjectData->CSpiceParameters.Set("W", m_width);

		PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_LENGTH].is_visable = !!m_visable_value3;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_LENGTH].CLabelValue = FloatToMKSString(m_length);
		PCSchematicObjectData->CSpiceParameters.Set("L", m_length);

		PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_RESISTIVITY].is_visable = !!m_visable_value4;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_RESISTIVITY].CLabelValue = FloatToMKSString(m_sheet);

		PCSchematicObjectData->CSpiceParameters.Set("RSH", m_sheet);

		PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_RESISTANCE].is_visable = !!m_check_visable_rc;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_RESISTANCE].CLabelValue = FloatToMKSString(m_resistance_capacitance);

		PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_MULTIPLIER_M].is_visable = !!m_visable_multiplier_m;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_MULTIPLIER_M].CLabelValue = FloatToMKSString(m_multiplier_m);
	}
	else 
	{
		if(!(E_COMPONENT_CAPACITOR_CAPAPACITANCE < PCSchematicObjectData->CLabelListData.GetSize())) PCSchematicObjectData->CLabelListData.SetSize(E_COMPONENT_CAPACITOR_CAPAPACITANCE + 1 , E_COMPONENT_CAPACITOR_CAPAPACITANCE + 1);

		PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_WIDTH].is_visable = !!m_visable_value2;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_WIDTH].CLabelValue = FloatToMKSString(m_width);
		PCSchematicObjectData->CSpiceParameters.Set("W", m_width);

		PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_LENGTH].is_visable = !!m_visable_value3;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_LENGTH].CLabelValue = FloatToMKSString(m_length);
		PCSchematicObjectData->CSpiceParameters.Set("L", m_length);

		PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_CAPACITIVITY].is_visable = !!m_visable_value4;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_CAPACITIVITY].CLabelValue = FloatToMKSString(m_sheet);

		PCSchematicObjectData->CSpiceParameters.Set("CJ", m_sheet);

		PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_CAPAPACITANCE].is_visable = !!m_check_visable_rc;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_CAPAPACITANCE].CLabelValue = FloatToMKSString(m_resistance_capacitance);

		PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_MULTIPLIER_M].is_visable = !!m_visable_multiplier_m;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_MULTIPLIER_M].CLabelValue = FloatToMKSString(m_multiplier_m);
	}


	if(PCSchematicObjectData->component_property_view_type == E_PROPERTY_IC_RESISTOR)
		PCSchematicObjectData->FormatICResistor();
	else PCSchematicObjectData->FormatICCapacitor();

}

void TCValueLabelsDlg::SetDisplay(void)
{
	g_last_active_component_property_page = 0;
		
	PCSchematicObjectData->FormatSpiceName();

	CMSpiceValue	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;
	CMSpiceName	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

	CMEditTypeName = PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel;

	CMEditCntrlSpiceValue.SetWindowText(CMSpiceValue);
	CMEditCntrlSpiceValue.SetWindowText(CMSpiceName);
	CMEditCntlTypeName.SetWindowText(CMEditTypeName);
	
	if(PCSchematicObjectData->component_property_view_type == E_PROPERTY_IC_RESISTOR)
	{
		m_visable_value3 = PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_LENGTH].is_visable;
		m_length = MKSStringToFloat(PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_LENGTH].CLabelValue);

		m_visable_value2 = PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_WIDTH].is_visable;
		m_width = MKSStringToFloat(PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_WIDTH].CLabelValue);

		m_resistance_capacitance = MKSStringToFloat(PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_RESISTANCE].CLabelValue);
		m_check_visable_rc = PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_RESISTANCE].is_visable;

		m_multiplier_m = MKSStringToFloat(PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_MULTIPLIER_M].CLabelValue);
		m_visable_multiplier_m = PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_MULTIPLIER_M].is_visable;

		PCSchematicObjectData->CSpiceParameters.Get("RSH", &m_sheet);
		m_visable_value4 = PCSchematicObjectData->CLabelListData[E_COMPONENT_RESISTOR_RESISTIVITY].is_visable;
	}
	else 
	{
		m_visable_value3 = PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_LENGTH].is_visable;
		m_length = MKSStringToFloat(PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_LENGTH].CLabelValue);

		m_visable_value2 = PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_WIDTH].is_visable;
		m_width = MKSStringToFloat(PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_WIDTH].CLabelValue);

		m_resistance_capacitance = MKSStringToFloat(PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_CAPAPACITANCE].CLabelValue);
		m_check_visable_rc = PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_CAPAPACITANCE].is_visable;

		m_multiplier_m = MKSStringToFloat(PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_MULTIPLIER_M].CLabelValue);
		m_visable_multiplier_m = PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_MULTIPLIER_M].is_visable;

		PCSchematicObjectData->CSpiceParameters.Get("CJ", &m_sheet);
		m_visable_value4 = PCSchematicObjectData->CLabelListData[E_COMPONENT_CAPACITOR_CAPACITIVITY].is_visable;
	}

	Calculate('w');

	UpdateData(false);
}

void TCValueLabelsDlg::Calculate(char type)
{
	if(m_width <= 0) m_width = 1e-6;	// soft error correction
	if(m_length <= 0) m_length = 1e-6;
	if(m_multiplier_m <= 0) m_multiplier_m = 1;

	if(PCSchematicObjectData->component_property_view_type == E_PROPERTY_IC_RESISTOR)
	{
		if(m_sheet <= 0) m_sheet = 100;
	}
	else if(m_sheet <= 0) m_sheet = 1e-3;

	if(type == 'w' || type == 'l')
	{
		if(PCSchematicObjectData->component_property_view_type == E_PROPERTY_IC_RESISTOR)
			m_resistance_capacitance = m_sheet * m_length / m_width;
		else m_resistance_capacitance = m_sheet * m_length * m_width;

		return;
	}

	if(m_resistance_capacitance <= 0) 
	{
		if(PCSchematicObjectData->component_property_view_type == E_PROPERTY_IC_RESISTOR)
			m_resistance_capacitance = 100;
		else m_resistance_capacitance = 1e-12;
	}

	if(PCSchematicObjectData->component_property_view_type == E_PROPERTY_IC_RESISTOR)
		m_length = m_resistance_capacitance * m_width / m_sheet;
	else m_length = m_resistance_capacitance  / m_sheet /m_width;
}

void TCValueLabelsDlg::OnKillfocusEditValue() 
{
	UpdateData(true);

	Calculate('r');	

	UpdateData(false);
}

void TCValueLabelsDlg::OnKillfocusEditValue2() 
{
	UpdateData(true);

	Calculate('w');

	UpdateData(false);
}

void TCValueLabelsDlg::OnKillfocusEditValue3() 
{
	UpdateData(true);

	Calculate('l');

	UpdateData(false);
}

void TCValueLabelsDlg::OnKillfocusEditValue4() 
{
	UpdateData(true);

	Calculate('l');

	UpdateData(false);
}

void TCValueLabelsDlg::OnKillfocusEditRcValue() 
{
	UpdateData(true);

 	Calculate('r');

	UpdateData(false);	
}

void TCValueLabelsDlg::OnKillfocusEditMultiplierM() 
{
	UpdateData(true);

	Calculate('w');

	UpdateData(false);	
}
