// TCVariableResistorLabelsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCMKSConvert.h"
#include "TCSchematicObjectData.h"
#include "TCVariableResistorLabelsDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCVariableResistorLabelsDlg, CPropertyPage)

extern int g_last_active_component_property_page;

/////////////////////////////////////////////////////////////////////////////
// TCVariableResistorLabelsDlg property page

TCVariableResistorLabelsDlg::TCVariableResistorLabelsDlg() : CPropertyPage(TCVariableResistorLabelsDlg::IDD)
{
	//{{AFX_DATA_INIT(TCVariableResistorLabelsDlg)
	m_ref_des_visable = FALSE;
	m_spice_name_visable = FALSE;
	m_value_visable = FALSE;
	CMEditSpicename = _T("");
	CMEditRefDes = _T("");
	CMEditValue = _T("");
	m_type_name_visable = FALSE;
	CMEditTypeName = _T("");
	m_check_visable_rotation_position = FALSE;
	m_check_visable_resistance = FALSE;
	//}}AFX_DATA_INIT

	m_rotation_position = 1.0;
	m_resistance = 1e3;
}

TCVariableResistorLabelsDlg::~TCVariableResistorLabelsDlg()
{
}

void TCVariableResistorLabelsDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCVariableResistorLabelsDlg)
	DDX_Control(pDX, IDC_EDIT_VALUE, CMEditCntlValue);
	DDX_Control(pDX, IDC_EDIT_SPICE_NAME, CMEditCntlSpiceName);
	DDX_Control(pDX, IDC_EDIT_TYPE_NAME, CMEditCntlTypeName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_REF_DESIGNATOR, m_ref_des_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_SPICE_NAME, m_spice_name_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE, m_value_visable);
	DDX_Text(pDX, IDC_EDIT_SPICE_NAME, CMEditSpicename);
	DDX_Text(pDX, IDC_EDIT_REF_DESIGNATOR, CMEditRefDes);
	DDX_Text(pDX, IDC_EDIT_VALUE, CMEditValue);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TYPE_NAME, m_type_name_visable);
	DDX_Text(pDX, IDC_EDIT_TYPE_NAME, CMEditTypeName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_BV, m_check_visable_rotation_position);
	DDX_Check(pDX, IDC_CHECK_VISABLE_AREA, m_check_visable_resistance);
	DDX_MKSValue(pDX, IDC_EDIT_BREAKDOWN_VOLT, m_rotation_position);
	DDX_MKSValue(pDX, IDC_EDIT_AREA, m_resistance);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCVariableResistorLabelsDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCVariableResistorLabelsDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



BOOL TCVariableResistorLabelsDlg::OnKillActive() 
{
	
	CPropertyPage::OnKillActive();

	if(!PCSchematicObjectData) return true;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = !!m_type_name_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = 	CMEditTypeName;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable = !!m_value_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel = CMEditValue;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = !!m_ref_des_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = CMEditRefDes;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = !!m_spice_name_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMEditSpicename;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_VARABLE_RESISTOR_RESISTANCE].is_visable = !!m_check_visable_resistance;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_VARABLE_RESISTOR_RESISTANCE].CLabelValue = FloatToMKSString(m_resistance);
	PCSchematicObjectData->CSpiceParameters.Set("R", m_resistance);

	PCSchematicObjectData->CLabelListData[E_COMPONENT_VARABLE_RESISTOR_ROTATION].is_visable = !!m_check_visable_rotation_position;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_VARABLE_RESISTOR_ROTATION].CLabelValue = FloatToMKSString(m_rotation_position);
	PCSchematicObjectData->CSpiceParameters.Set("Position", m_rotation_position);

	PCSchematicObjectData->FormatLabel();

	return true;
}

BOOL TCVariableResistorLabelsDlg::OnSetActive() 
{
	g_last_active_component_property_page = 0;
	
	CMEditValue	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	PCSchematicObjectData->FormatSpiceName();

	CMEditSpicename	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

	PCSchematicObjectData->CSpiceParameters.Get("Position", &m_rotation_position);
	PCSchematicObjectData->CSpiceParameters.Get("R", &m_resistance);

	return CPropertyPage::OnSetActive();
}

BOOL TCVariableResistorLabelsDlg::OnInitDialog() 
{
	 
	m_type_name_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable;
	CMEditTypeName		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel;

	m_value_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable;
	CMEditValue		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	m_ref_des_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable;
	CMEditRefDes		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	m_spice_name_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable;
	CMEditSpicename		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

	m_check_visable_resistance = PCSchematicObjectData->CLabelListData[E_COMPONENT_VARABLE_RESISTOR_RESISTANCE].is_visable;
	PCSchematicObjectData->CSpiceParameters.Get("R", &m_resistance);

	m_check_visable_rotation_position = PCSchematicObjectData->CLabelListData[E_COMPONENT_VARABLE_RESISTOR_ROTATION].is_visable;
	PCSchematicObjectData->CSpiceParameters.Get("Position", &m_rotation_position);

	CPropertyPage::OnInitDialog();
	
//	CMEditCntlTypeName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only);
//	CMEditCntlSpiceName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only);
	CMEditCntlValue.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].read_only);

	return TRUE;  
}
