#include "stdafx.h"
#include "TDVersion.h"
#include "TCSuperSpiceDataBase.h"
#include "TCOutputWaveformData.h"
#include "TCWaveformGraphicsManager.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern int global_screen_planes;
extern int global_screen_bitspixels;
extern TCSuperSpiceDataBase GCSuperSpiceDataBase;
bool IsBadWindowHandle(CWnd *PCWnd);
extern TCSuperSpiceGlobalData GCSuperSpiceGlobalData;

IMPLEMENT_SERIAL(TCWaveformGraphicsManager, CObject, ID_VERSION_NUMBER)


TCWaveformGraphicsManager::TCWaveformGraphicsManager(void)
{


}
TCWaveformGraphicsManager::TCWaveformGraphicsManager(TCWaveformGraphicsManager &CWaveformGraphicsManager)
{
	*this = CWaveformGraphicsManager;
}
TCWaveformGraphicsManager::~TCWaveformGraphicsManager(void)
{

}

void TCWaveformGraphicsManager::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	TCSchematicManager::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{

	}
	else
	{

	}
}

void TCWaveformGraphicsManager::operator = (TCWaveformGraphicsManager &CWaveformGraphicsManager)
{
	TCSchematicManager::operator = (CWaveformGraphicsManager);

	CWaveformGraphicsManager;
}

void TCWaveformGraphicsManager::DrawAll(void)
{
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	// Don't do border for graphics window 18th Jan 2014
	if(GCSuperSpiceGlobalData.CDrawData.draw_waveform_page_border)
		UpdatePageOutline();

	RepositionTitleBlock();
	EraseComponentOutline();

	// This is to update the origin as DrawAll gets called before the scroll bars!!
	CMSchematicManagerData.PCView->OnPrepareDC(PCViewDC);
	CMSchematicManagerData.CViewPortOrigin = PCViewDC->GetViewportOrg();
	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);

	PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CDC CMemDC;
	
	CMemDC.CreateCompatibleDC(PCViewDC);

	CBitmap CBitmapTemp;

	CRect CWindowRect;

	PCViewDC->GetClipBox(&CWindowRect); 

	int w = CWindowRect.Width();
	int h = CWindowRect.Height();

	if(!CBitmapTemp.CreateBitmap(w, h, global_screen_planes, global_screen_bitspixels,  NULL))
	{
		if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
		CMemDC.DeleteDC();

		return;
	}

	HGDIOBJ oldobject = CMemDC.SelectObject(CBitmapTemp);

	ClearScreen(&CMemDC);
	DrawGrid(&CMemDC);

// Don't do border for graphics window 18th Jan 2014
	if(GCSuperSpiceGlobalData.CDrawData.draw_waveform_page_border)
		DrawPageOutline(&CMemDC, true);

	RePasteAllGraphicsFromMemory(&CMemDC);

	PCViewDC->BitBlt(0, 0, w, h, &CMemDC, 0, 0, SRCCOPY);

	CMemDC.SelectObject(oldobject);
	CBitmapTemp.DeleteObject();
	CMemDC.DeleteDC();

	repaste_required = true;

	if(PCMLastOutlinedComponent)
	{
		OutlineGraphics(CMLastOutlinedMousePosition);
	}

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

void TCWaveformGraphicsManager::Zoom(float zoom)
{
	if(!CMSchematicManagerData.PCView) return;
	if(IsBadWindowHandle(CMSchematicManagerData.PCView)) return;

	CDC *PCViewDC = CMSchematicManagerData.PCView->GetDC();

	if(!PCViewDC) return;

	CMSchematicManagerData.zoom = zoom;

	ClearScreen(PCViewDC);

	int count = CMSchematicManagerData.CGraphicList.GetSize();

	TCSchematicObject *PCSchematicObject;

	for(int p = 0; p < count; p++)
	{
		PCSchematicObject = CMSchematicManagerData.CGraphicList.GetAt(p);

		PCSchematicObject->Zoom(zoom);
	}

// Dont do border for graphics window 18th Jan 2014

	if(GCSuperSpiceGlobalData.CDrawData.draw_waveform_page_border)
	{
		UpdatePageOutline();
		DrawPageOutline(PCViewDC, true);
	}

	RePasteAllGraphics(PCViewDC);

	if(PCViewDC) CMSchematicManagerData.PCView->ReleaseDC(PCViewDC);
}

void TCWaveformGraphicsManager::DrawGrid(CDC *CMemDC)
{
	// Do nothing
	CMemDC;
	return;
}

bool TCWaveformGraphicsManager::PrintAll(CDC *PCDC)
{
	return TCSchematicManager::PrintAll(PCDC);// to do
}

