// TCWaveformPropPages.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TCWaveformPropPages.h"
#include "TCOutputWaveformData.h"
#include "TCSchematicObjectData.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCWaveformOptionsPropPage, CPropertyPage)
IMPLEMENT_DYNCREATE(TCWaveformPropGraphSetup, CPropertyPage)
IMPLEMENT_DYNCREATE(TCWaveformPropSignalSetup, CPropertyPage)
IMPLEMENT_DYNCREATE(TCWaveformCalculatorPropPage, CPropertyPage)

extern int g_last_active_waveform_property_page;
extern TCSuperSpiceGlobalData GCSuperSpiceGlobalData;
void SetMKSNumDigits(int num_digits);
void AFXAPI DDX_MKSValue(CDataExchange* pDX, int nIDC, double& data);

// 	TCOutputWaveformDataHeader &CHeader = *CMSchematicObjectData.PCOutputWaveformDataHeader;

/////////////////////////////////////////////////////////////////////////////
// TCWaveformOptionsPropPage property page

TCWaveformCalculatorPropPage::TCWaveformCalculatorPropPage() : CPropertyPage(TCWaveformCalculatorPropPage::IDD)
{
	//{{AFX_DATA_INIT(TCWaveformCalculatorPropPage)
	m_check_degrees1 = FALSE;
	m_check_degrees2 = FALSE;
	m_check_degrees3 = FALSE;
	m_check_degrees4 = FALSE;
	m_check_magnitude1 = FALSE;
	m_check_magnitude2 = FALSE;
	m_check_magnitude3 = FALSE;
	m_check_magnitude4 = FALSE;
	m_signals1_a = 1;
	m_signals1_b = 1;
	m_signals2_a = 1;
	m_signals2_b = 1;
	m_signals3_a = 1;
	m_signals3_b = 1;
	m_signals4_a = 1;
	m_signals4_b = 1;
	m_signals1_ab_operator = 0;
	m_signals2_ab_operator = 0;
	m_signals3_ab_operator = 0;
	m_signals4_ab_operator = 0;
	m_funcion_operator1 = 0;
	m_funcion_operator3 = 0;
	m_funcion_operator4 = 0;
	m_funcion_operator2 = 0;
	calculator_enabled = 0;
	m_waveform_type = 0;
	//}}AFX_DATA_INIT

	PCSchematicObjectData = NULL;
	POutputWaveformData  = NULL;
}

TCWaveformCalculatorPropPage::~TCWaveformCalculatorPropPage()
{
}

void TCWaveformCalculatorPropPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCWaveformCalculatorPropPage)
	DDX_Control(pDX, IDC_CHECK_DEGREES4, CMCheckDegrees4);
	DDX_Control(pDX, IDC_CHECK_DEGREES3, CMCheckDegrees3);
	DDX_Control(pDX, IDC_CHECK_DEGREES2, CMCheckDegrees2);
	DDX_Control(pDX, IDC_CHECK_DEGREES1, CMCheckDegrees1);
	DDX_Control(pDX, IDC_COMBO_SIGNALS4_SCALE, CMComboFunctionOperator4);
	DDX_Control(pDX, IDC_COMBO_SIGNALS3_SCALE, CMComboFunctionOperator3);
	DDX_Control(pDX, IDC_COMBO_SIGNALS2_SCALE, CMComboFunctionOperator2);
	DDX_Control(pDX, IDC_COMBO_SIGNALS1_SCALE, CMComboFunctionOperator1);
	DDX_Control(pDX, IDC_COMBO_SIGNALS4_AB_OPERATOR, CMComboMathOperator4);
	DDX_Control(pDX, IDC_COMBO_SIGNALS3_AB_OPERATOR, CMComboMathOperator3);
	DDX_Control(pDX, IDC_COMBO_SIGNALS2_AB_OPERATOR, CMComboMathOperator2);
	DDX_Control(pDX, IDC_COMBO_SIGNALS1_AB_OPERATOR, CMComboMathOperator1);
	DDX_Control(pDX, IDC_COMBO_SIGNALS4_B, CMComboSignals4B);
	DDX_Control(pDX, IDC_COMBO_SIGNALS3_B, CMComboSignals3B);
	DDX_Control(pDX, IDC_COMBO_SIGNALS2_B, CMComboSignals2B);
	DDX_Control(pDX, IDC_COMBO_SIGNALS1_B, CMComboSignals1B);
	DDX_Control(pDX, IDC_COMBO_SIGNALS4_A, CMComboSignals4A);
	DDX_Control(pDX, IDC_COMBO_SIGNALS3_A, CMComboSignals3A);
	DDX_Control(pDX, IDC_COMBO_SIGNALS2_A, CMComboSignals2A);
	DDX_Control(pDX, IDC_COMBO_SIGNALS1_A, CMComboSignals1A);
	DDX_Check(pDX, IDC_CHECK_DEGREES1, m_check_degrees1);
	DDX_Check(pDX, IDC_CHECK_DEGREES2, m_check_degrees2);
	DDX_Check(pDX, IDC_CHECK_DEGREES3, m_check_degrees3);
	DDX_Check(pDX, IDC_CHECK_DEGREES4, m_check_degrees4);
	DDX_Check(pDX, IDC_CHECK_MAGNITUDE1, m_check_magnitude1);
	DDX_Check(pDX, IDC_CHECK_MAGNITUDE2, m_check_magnitude2);
	DDX_Check(pDX, IDC_CHECK_MAGNITUDE3, m_check_magnitude3);
	DDX_Check(pDX, IDC_CHECK_MAGNITUDE4, m_check_magnitude4);
	DDX_CBIndex(pDX, IDC_COMBO_SIGNALS1_A, m_signals1_a);
	DDX_CBIndex(pDX, IDC_COMBO_SIGNALS1_B, m_signals1_b);
	DDX_CBIndex(pDX, IDC_COMBO_SIGNALS2_A, m_signals2_a);
	DDX_CBIndex(pDX, IDC_COMBO_SIGNALS2_B, m_signals2_b);
	DDX_CBIndex(pDX, IDC_COMBO_SIGNALS3_A, m_signals3_a);
	DDX_CBIndex(pDX, IDC_COMBO_SIGNALS3_B, m_signals3_b);
	DDX_CBIndex(pDX, IDC_COMBO_SIGNALS4_A, m_signals4_a);
	DDX_CBIndex(pDX, IDC_COMBO_SIGNALS4_B, m_signals4_b);
	DDX_CBIndex(pDX, IDC_COMBO_SIGNALS1_AB_OPERATOR, m_signals1_ab_operator);
	DDX_CBIndex(pDX, IDC_COMBO_SIGNALS2_AB_OPERATOR, m_signals2_ab_operator);
	DDX_CBIndex(pDX, IDC_COMBO_SIGNALS3_AB_OPERATOR, m_signals3_ab_operator);
	DDX_CBIndex(pDX, IDC_COMBO_SIGNALS4_AB_OPERATOR, m_signals4_ab_operator);
	DDX_CBIndex(pDX, IDC_COMBO_SIGNALS1_SCALE, m_funcion_operator1);
	DDX_CBIndex(pDX, IDC_COMBO_SIGNALS3_SCALE, m_funcion_operator3);
	DDX_CBIndex(pDX, IDC_COMBO_SIGNALS4_SCALE, m_funcion_operator4);
	DDX_CBIndex(pDX, IDC_COMBO_SIGNALS2_SCALE, m_funcion_operator2);
	DDX_Radio(pDX, IDC_RADIO_USE_SIGNALS, calculator_enabled);
	DDX_Radio(pDX, IDC_RADIO_WAVEFORM_TYPE, m_waveform_type);
	DDX_Control(pDX, IDC_RADIO_WAVEFORM_TYPE, CMButtonDC);
	DDX_Control(pDX, IDC_RADIO_AC,CMButtonAC);
	DDX_Control(pDX, IDC_RADIO_SPECTRAL_NOISE, CMButtonSpectralNoise);
	DDX_Control(pDX, IDC_RADIO_PLOE_ZERO, CMButtonPoleZero);
	DDX_Control(pDX, IDC_RADIO_TRANSIENT, CMButtonTransient);
	DDX_Control(pDX, IDC_RADIO_FOURIER, CMButtonFourier);
	DDX_Control(pDX, IDC_RADIO_THD, CMButtonTHD);
	DDX_Control(pDX, IDC_RADIO_IMD, CMButtonIMD);
	DDX_Control(pDX, IDC_RADIO_IMD2_, CMButtonF2);
	DDX_Control(pDX, IDC_RADIO_SENSITIVITY, CMButtonSensitivity);

	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCWaveformCalculatorPropPage, CPropertyPage)
	//{{AFX_MSG_MAP(TCWaveformCalculatorPropPage)
	ON_BN_CLICKED(IDC_RADIO_USE_SIGNALS, OnRadioUseSignals)
	ON_BN_CLICKED(IDC_RADIO_USE_CALCULATOR, OnRadioUseCalculator)
	ON_BN_CLICKED(IDC_RADIO_AC, OnRadioAc)
	ON_BN_CLICKED(IDC_RADIO_FOURIER, OnRadioFourier)
	ON_BN_CLICKED(IDC_RADIO_IMD, OnRadioImd)
	ON_BN_CLICKED(IDC_RADIO_IMD2_, OnRadioImd2)
	ON_BN_CLICKED(IDC_RADIO_PLOE_ZERO, OnRadioPoleZero)
	ON_BN_CLICKED(IDC_RADIO_SENSITIVITY, OnRadioSensitivity)
	ON_BN_CLICKED(IDC_RADIO_SPECTRAL_NOISE, OnRadioSpectralNoise)
	ON_BN_CLICKED(IDC_RADIO_THD, OnRadioThd)
	ON_BN_CLICKED(IDC_RADIO_TRANSIENT, OnRadioTransient)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void TCWaveformCalculatorPropPage::SetDisplay(void)
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;

	SetFunctionList();
	SetOperatorList();
	SetSigmalsAList();
	SetSignalsBList();

	SetButtons();

	UpdateData(false);
}

void TCWaveformCalculatorPropPage::GetDisplay(void)
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader)return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals)return;
	if(IsBadReadPtr(PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals, 4)) return;

	UpdateData(true);

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;

//	if(!calculator_enabled) PCSchematicObjectData->PCOutputWaveformDataHeader->type = m_waveform_type;
//	else PCSchematicObjectData->PCOutputWaveformDataHeader->type = E_SPICE_RECORD_MATH_0;
		
	CWaveformDataRuns.CMathFunctionDataList[0].a_signal = m_signals1_a;
	CWaveformDataRuns.CMathFunctionDataList[1].a_signal = m_signals2_a;
	CWaveformDataRuns.CMathFunctionDataList[2].a_signal = m_signals3_a;
	CWaveformDataRuns.CMathFunctionDataList[3].a_signal = m_signals4_a;

	CWaveformDataRuns.CMathFunctionDataList[0].b_signal = m_signals1_b;
	CWaveformDataRuns.CMathFunctionDataList[1].b_signal = m_signals2_b;
	CWaveformDataRuns.CMathFunctionDataList[2].b_signal = m_signals3_b;
	CWaveformDataRuns.CMathFunctionDataList[3].b_signal = m_signals4_b;

	CWaveformDataRuns.CMathFunctionDataList[0].phase = -1;
	CWaveformDataRuns.CMathFunctionDataList[1].phase = -1;
	CWaveformDataRuns.CMathFunctionDataList[2].phase = -1;
	CWaveformDataRuns.CMathFunctionDataList[3].phase = -1;

	// to add radians buttons
	if(m_check_degrees1 == 1)CWaveformDataRuns.CMathFunctionDataList[0].phase = 0;
	if(m_check_degrees2 == 1)CWaveformDataRuns.CMathFunctionDataList[1].phase = 0;
	if(m_check_degrees3 == 1)CWaveformDataRuns.CMathFunctionDataList[2].phase = 0;
	if(m_check_degrees4 == 1)CWaveformDataRuns.CMathFunctionDataList[3].phase = 0;

	CWaveformDataRuns.CMathFunctionDataList[0].magnitude = -1;
	CWaveformDataRuns.CMathFunctionDataList[1].magnitude = -1;
	CWaveformDataRuns.CMathFunctionDataList[2].magnitude = -1;
	CWaveformDataRuns.CMathFunctionDataList[3].magnitude = -1;

	// to add db buttons
	if(m_check_magnitude1 == 1)CWaveformDataRuns.CMathFunctionDataList[0].magnitude = 0;
	if(m_check_magnitude2 == 1)CWaveformDataRuns.CMathFunctionDataList[1].magnitude = 0;
	if(m_check_magnitude3 == 1)CWaveformDataRuns.CMathFunctionDataList[2].magnitude = 0;
	if(m_check_magnitude4 == 1)CWaveformDataRuns.CMathFunctionDataList[3].magnitude = 0;

	CWaveformDataRuns.CMathFunctionDataList[0].function_operator = m_funcion_operator1; 
	CWaveformDataRuns.CMathFunctionDataList[1].function_operator = m_funcion_operator2;
	CWaveformDataRuns.CMathFunctionDataList[2].function_operator = m_funcion_operator3;
	CWaveformDataRuns.CMathFunctionDataList[3].function_operator = m_funcion_operator4;

	CWaveformDataRuns.CMathFunctionDataList[0].signals_ab_operator = m_signals1_ab_operator;
	CWaveformDataRuns.CMathFunctionDataList[1].signals_ab_operator = m_signals2_ab_operator;
	CWaveformDataRuns.CMathFunctionDataList[2].signals_ab_operator = m_signals3_ab_operator;
	CWaveformDataRuns.CMathFunctionDataList[3].signals_ab_operator = m_signals4_ab_operator;

	if(PCSchematicObjectData->PCOutputWaveformDataHeader->type == E_SPICE_RECORD_MATH_0)
	{
		CWaveformDataRuns.CMathFunctionDataList[0].calculator_enabled = calculator_enabled;
		CWaveformDataRuns.CMathFunctionDataList[1].calculator_enabled = calculator_enabled;
		CWaveformDataRuns.CMathFunctionDataList[2].calculator_enabled = calculator_enabled;
		CWaveformDataRuns.CMathFunctionDataList[3].calculator_enabled = calculator_enabled;
 	
		CWaveformDataRuns.CMathFunctionDataList[0].record_index = m_waveform_type;
		CWaveformDataRuns.CMathFunctionDataList[1].record_index = m_waveform_type;
		CWaveformDataRuns.CMathFunctionDataList[2].record_index = m_waveform_type;
		CWaveformDataRuns.CMathFunctionDataList[3].record_index = m_waveform_type;
	}	
}

BOOL TCWaveformCalculatorPropPage::OnSetActive() 
{
	g_last_active_waveform_property_page = 3;

	SetButtons();

	SetDisplay();
	
	return CPropertyPage::OnSetActive();
}

BOOL TCWaveformCalculatorPropPage::OnInitDialog() 
{

	CPropertyPage::OnInitDialog();
	
//	SetDisplay();
	
	return TRUE;  
}

BOOL TCWaveformCalculatorPropPage::OnKillActive() 
{
	BOOL value =  CPropertyPage::OnKillActive();

	if(value)
	{
		GetDisplay();
	}

	return value;
}

void TCWaveformCalculatorPropPage::SetFunctionList(void)
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader)return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals)return;
	if(IsBadReadPtr(PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals, 4)) return;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;

	TCMathFunctionTypeData CMathFunctionTypeData;

	int count = CMathFunctionTypeData.CMathFunctionTypeList.GetSize();

	CMComboFunctionOperator1.ResetContent();
	CMComboFunctionOperator2.ResetContent();
	CMComboFunctionOperator3.ResetContent();
	CMComboFunctionOperator4.ResetContent();

	for(int p = 0; p < count; p++)
	{

		CMComboFunctionOperator1.InsertString(-1, CMathFunctionTypeData.CMathFunctionTypeList[p]);
		CMComboFunctionOperator2.InsertString(-1, CMathFunctionTypeData.CMathFunctionTypeList[p]);
		CMComboFunctionOperator3.InsertString(-1, CMathFunctionTypeData.CMathFunctionTypeList[p]);
		CMComboFunctionOperator4.InsertString(-1, CMathFunctionTypeData.CMathFunctionTypeList[p]);
	}

	m_funcion_operator1 = CWaveformDataRuns.CMathFunctionDataList[0].function_operator; 
	m_funcion_operator2 = CWaveformDataRuns.CMathFunctionDataList[1].function_operator;
	m_funcion_operator3 = CWaveformDataRuns.CMathFunctionDataList[2].function_operator;
	m_funcion_operator4 = CWaveformDataRuns.CMathFunctionDataList[3].function_operator;
}

void TCWaveformCalculatorPropPage::SetOperatorList(void)
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader)return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals)return;
	if(IsBadReadPtr(PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals, 4)) return;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;

	TCMathOperatorTypeData CMathOperatorTypeData;

	int count = CMathOperatorTypeData.CMathOperatorTypeList.GetSize();

	CMComboMathOperator1.ResetContent();
	CMComboMathOperator2.ResetContent();
	CMComboMathOperator3.ResetContent();
	CMComboMathOperator4.ResetContent();

	for(int p = 0; p < count; p++)
	{

		CMComboMathOperator1.InsertString(-1, CMathOperatorTypeData.CMathOperatorTypeList[p]);
		CMComboMathOperator2.InsertString(-1, CMathOperatorTypeData.CMathOperatorTypeList[p]);
		CMComboMathOperator3.InsertString(-1, CMathOperatorTypeData.CMathOperatorTypeList[p]);
		CMComboMathOperator4.InsertString(-1, CMathOperatorTypeData.CMathOperatorTypeList[p]);
	}

	m_signals1_ab_operator = CWaveformDataRuns.CMathFunctionDataList[0].signals_ab_operator;
	m_signals2_ab_operator = CWaveformDataRuns.CMathFunctionDataList[1].signals_ab_operator;
	m_signals3_ab_operator = CWaveformDataRuns.CMathFunctionDataList[2].signals_ab_operator;
	m_signals4_ab_operator = CWaveformDataRuns.CMathFunctionDataList[3].signals_ab_operator;

}

void TCWaveformCalculatorPropPage::SetSigmalsAList(void)
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader)return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals)return;
	if(IsBadReadPtr(PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals, 4)) return;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;

	calculator_enabled = false;

	if(PCSchematicObjectData->PCOutputWaveformDataHeader->type == E_SPICE_RECORD_MATH_0) calculator_enabled = true;

	m_waveform_type		= CWaveformDataRuns.CMathFunctionDataList[0].record_index;

	if(!calculator_enabled) m_waveform_type = PCSchematicObjectData->PCOutputWaveformDataHeader->type;

	int temp_type = PCSchematicObjectData->PCOutputWaveformDataHeader->type;

	PCSchematicObjectData->PCOutputWaveformDataHeader->type = m_waveform_type;

	TCOutputWaveformDataHeader *PCHeader = CWaveformDataRuns.GetHeader(PCSchematicObjectData->PCOutputWaveformDataHeader, PCSchematicObjectData->PCOutputWaveformDataHeader->run_index);
	
	PCSchematicObjectData->PCOutputWaveformDataHeader->type = temp_type;

	if(!PCHeader) return;

	CMComboSignals1A.ResetContent();
	CMComboSignals2A.ResetContent();
	CMComboSignals3A.ResetContent();
	CMComboSignals4A.ResetContent();

	CArray <TCSignal, TCSignal &> &CSignals = *PCHeader->PCSignals;

	int count = CSignals.GetSize();

	CMCheckDegrees1.EnableWindow(false);
	CMCheckDegrees2.EnableWindow(false);
	CMCheckDegrees3.EnableWindow(false);
	CMCheckDegrees4.EnableWindow(false);

	if(count)
	{
		if(CSignals[0].CPhaseData.CX.GetSize())// all signals are of same type
		{
			CMCheckDegrees1.EnableWindow(true);
			CMCheckDegrees2.EnableWindow(true);
			CMCheckDegrees3.EnableWindow(true);
			CMCheckDegrees4.EnableWindow(true);
		}
	}

	CString CText;

	for(int p = 0; p < count; p++)
	{
		CText = CSignals[p].CName;

		CMComboSignals1A.InsertString(-1, CText);
		CMComboSignals2A.InsertString(-1, CText);
		CMComboSignals3A.InsertString(-1, CText);
		CMComboSignals4A.InsertString(-1, CText);
	}

	m_signals1_a = CWaveformDataRuns.CMathFunctionDataList[0].a_signal;
	m_signals2_a = CWaveformDataRuns.CMathFunctionDataList[1].a_signal;
	m_signals3_a = CWaveformDataRuns.CMathFunctionDataList[2].a_signal;
	m_signals4_a = CWaveformDataRuns.CMathFunctionDataList[3].a_signal;

	m_check_degrees1 = 0;
	m_check_degrees2 = 0;
	m_check_degrees3 = 0;
	m_check_degrees4 = 0;

	//rad and db to do
	if(CWaveformDataRuns.CMathFunctionDataList[0].phase == 0) m_check_degrees1 = 1;
	if(CWaveformDataRuns.CMathFunctionDataList[1].phase == 0) m_check_degrees2 = 1;
	if(CWaveformDataRuns.CMathFunctionDataList[2].phase == 0) m_check_degrees3 = 1;
	if(CWaveformDataRuns.CMathFunctionDataList[3].phase == 0) m_check_degrees4 = 1;

	if(CWaveformDataRuns.CMathFunctionDataList[0].magnitude == 0) m_check_magnitude1 = 1;
	if(CWaveformDataRuns.CMathFunctionDataList[1].magnitude == 0) m_check_magnitude2 = 1;
	if(CWaveformDataRuns.CMathFunctionDataList[2].magnitude == 0) m_check_magnitude3 = 1;
	if(CWaveformDataRuns.CMathFunctionDataList[3].magnitude == 0) m_check_magnitude4 = 1;

	if(PCSchematicObjectData->PCOutputWaveformDataHeader->type == E_SPICE_RECORD_MATH_0) OnRadioUseCalculator();
}

void TCWaveformCalculatorPropPage::SetSignalsBList(void)
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader)return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals)return;
	if(IsBadReadPtr(PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals, 4)) return;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;

	TCOutputWaveformDataHeader *PCHeader = CWaveformDataRuns.GetHeader(PCSchematicObjectData->PCOutputWaveformDataHeader, PCSchematicObjectData->PCOutputWaveformDataHeader->run_index);
	
	if(!PCHeader) return;

	CMComboSignals1B.ResetContent();
	CMComboSignals2B.ResetContent();
	CMComboSignals3B.ResetContent();
	CMComboSignals4B.ResetContent();

	CArray <TCSignal, TCSignal &> &CSignals = *PCHeader->PCSignals;

	int count = CSignals.GetSize();

	CString CText;

	for(int p = 0; p < count; p++)
	{
		CText = CSignals[p].CName;

		CMComboSignals1B.InsertString(-1, CText);
		CMComboSignals2B.InsertString(-1, CText);
		CMComboSignals3B.InsertString(-1, CText);
		CMComboSignals4B.InsertString(-1, CText);
	}

	m_signals1_b = CWaveformDataRuns.CMathFunctionDataList[0].b_signal;
	m_signals2_b = CWaveformDataRuns.CMathFunctionDataList[1].b_signal;
	m_signals3_b = CWaveformDataRuns.CMathFunctionDataList[2].b_signal;
	m_signals4_b = CWaveformDataRuns.CMathFunctionDataList[3].b_signal;
}

/////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
TCWaveformOptionsPropPage::TCWaveformOptionsPropPage() : CPropertyPage(TCWaveformOptionsPropPage::IDD)
{
	//{{AFX_DATA_INIT(TCWaveformOptionsPropPage)
	m_num_digits_displayed = 0;
	m_resolution = 0;
	m_auto_axis = -1;
	m_x_manual_major_grid_number = 0;
	m_y_manual_major_grid_number = 0;
	m_y_manual_phase_major_grid_number = 0;
	m_x_manual_minor_grid_number = 0;
	m_y_manual_minor_grid_number = 0;
	m_y_manual_phase_minor_grid_number = 0;
	m_enable_quantisation = TRUE;
	//}}AFX_DATA_INIT

	PCSchematicObjectData = NULL;
	POutputWaveformData  = NULL;
}

TCWaveformOptionsPropPage::~TCWaveformOptionsPropPage()
{
}

void TCWaveformOptionsPropPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCWaveformOptionsPropPage)
	DDX_Text(pDX, IDC_EDIT_NUMBER_DIGITS_DISPLAYED, m_num_digits_displayed);
	DDX_Text(pDX, IDC_EDIT_NUMBER_RESOLUTION, m_resolution);
	DDX_Radio(pDX, IDC_RADIO_AXIS_LABELS_AUTO, m_auto_axis);
	DDX_Text(pDX, IDC_EDIT_XAXIS_TICKS, m_x_manual_major_grid_number);
	DDX_Text(pDX, IDC_EDIT_YMAGAXIS_TICKS, m_y_manual_major_grid_number);
	DDX_Text(pDX, IDC_EDIT_YPHASEAXIS_TICKS, m_y_manual_phase_major_grid_number);
	DDX_Text(pDX, IDC_EDIT_XAXIS_MINOR_TICKS, m_x_manual_minor_grid_number);
	DDX_Text(pDX, IDC_EDIT_YMAGAXIS_MINOR_TICKS, m_y_manual_minor_grid_number);
	DDX_Text(pDX, IDC_EDIT_YPHASEAXIS_MINOR_TICKS, m_y_manual_phase_minor_grid_number);
	DDX_Check(pDX, IDC_CHECK_ENABLE_QUANTISATION, m_enable_quantisation);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCWaveformOptionsPropPage, CPropertyPage)
	//{{AFX_MSG_MAP(TCWaveformOptionsPropPage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCWaveformPropGraphSetup property page

TCWaveformPropGraphSetup::TCWaveformPropGraphSetup() : CPropertyPage(TCWaveformPropGraphSetup::IDD)
{
	//{{AFX_DATA_INIT(TCWaveformPropGraphSetup)
	m_xaxis_linear = -1;
	m_waveform_type = 0;
	m_x_auto = -1;
	m_y_auto = -1;
	m_yaxis_linear = -1;
	m_multy_magnitude = FALSE;
	m_multy_phase = FALSE;
	m_phase_axis_lin = -1;
	m_phase_auto = -1;
	m_check_intelegent_signal_default = FALSE;
	//}}AFX_DATA_INIT

	PCSchematicObjectData = NULL;
	POutputWaveformData  = NULL;

	m_x_max = 1.0;
	m_x_min = 1.0;
	m_y_max = 1.0;
	m_y_min = 1.0;
	m_phase_max = 1.0;
	m_phase_min = 1.0;
	m_ymag_div = 1.0;
	m_yphase_div = 1.0;
	m_xmag_div = 1.0;
}

TCWaveformPropGraphSetup::~TCWaveformPropGraphSetup()
{
}

void TCWaveformPropGraphSetup::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCWaveformPropGraphSetup)
	DDX_Control(pDX, IDC_EDIT_YPHASEUNITS_DIV, CMEditYPhaseDivision);
	DDX_Control(pDX, IDC_EDIT_XUNITS_DIV, CMEditXMagDivision);
	DDX_Control(pDX, IDC_EDIT_YMAGUNITS_DIV, CMEditYMagDivision);
	DDX_Control(pDX, IDC_CHECK_MULTY_PHASE, CMCheckMultyPhase);
	DDX_Control(pDX, IDC_RADIO_AUTO_PHASE_AXIS, CMButtonAutoPhase);
	DDX_Control(pDX, IDC_EDIT_YPHASE_MIN, EMEditPhaseMin);
	DDX_Control(pDX, IDC_EDIT_PHASE_MAX, EMEditPhaseMax);
	DDX_Control(pDX, IDC_EDIT_YMIN, CMEditYMin);
	DDX_Control(pDX, IDC_EDIT_YMAX, CMEditYMax);
	DDX_Control(pDX, IDC_EDIT_XMIN, CMEditXMin);
	DDX_Control(pDX, IDC_EDIT_XMAX, CMEditXMax);
	DDX_Control(pDX, IDC_RADIO_WAVEFORM_TYPE, CMButtonDC);
	DDX_Control(pDX, IDC_RADIO_AC,CMButtonAC);
	DDX_Control(pDX, IDC_RADIO_SPECTRAL_NOISE, CMButtonSpectralNoise);
	DDX_Control(pDX, IDC_RADIO_PLOE_ZERO, CMButtonPoleZero);
	DDX_Control(pDX, IDC_RADIO_TRANSIENT, CMButtonTransient);
	DDX_Control(pDX, IDC_RADIO_FOURIER, CMButtonFourier);
	DDX_Control(pDX, IDC_RADIO_THD, CMButtonTHD);
	DDX_Control(pDX, IDC_RADIO_IMD, CMButtonIMD);
	DDX_Control(pDX, IDC_RADIO_IMD2, CMButtonF2);
	DDX_Control(pDX, IDC_RADIO_SENSITIVITY, CMButtonSensitivity);
	DDX_Control(pDX, IDC_LIST_GRID_COLOUR, CMListGridColour);
	DDX_Control(pDX, IDC_LIST_BACKGROUND_COLOUR, CMListBackgroundColour);
	DDX_Radio(pDX, IDC_RADIO_XAXIS_LIN, m_xaxis_linear);
	DDX_Radio(pDX, IDC_RADIO_WAVEFORM_TYPE, m_waveform_type);
	DDX_MKSValue(pDX, IDC_EDIT_XMAX, m_x_max);
	DDX_MKSValue(pDX, IDC_EDIT_XMIN, m_x_min);
	DDX_MKSValue(pDX, IDC_EDIT_YMAX, m_y_max);
	DDX_MKSValue(pDX, IDC_EDIT_YMIN, m_y_min);
	DDX_Radio(pDX, IDC_RADIO_AUTO_X_AXIS, m_x_auto);
	DDX_Radio(pDX, IDC_RADIO_AUTO_Y_AXIS, m_y_auto);
	DDX_Radio(pDX, IDC_RADIO_YAXIS_LIN, m_yaxis_linear);
	DDX_Check(pDX, IDC_CHECK_MULTY_MAG, m_multy_magnitude);
	DDX_Check(pDX, IDC_CHECK_MULTY_PHASE, m_multy_phase);
	DDX_MKSValue(pDX, IDC_EDIT_PHASE_MAX, m_phase_max);
	DDX_MKSValue(pDX, IDC_EDIT_YPHASE_MIN, m_phase_min);
	DDX_Radio(pDX, IDC_RADIO_PHASE_AXIS_LIN, m_phase_axis_lin);
	DDX_Radio(pDX, IDC_RADIO_AUTO_PHASE_AXIS, m_phase_auto);
	DDX_MKSValue(pDX, IDC_EDIT_YMAGUNITS_DIV, m_ymag_div);
	DDX_MKSValue(pDX, IDC_EDIT_YPHASEUNITS_DIV, m_yphase_div);
	DDX_MKSValue(pDX, IDC_EDIT_XUNITS_DIV, m_xmag_div);
	DDX_Check(pDX, IDC_CHECK_INTELEGENT_DEFAULT, m_check_intelegent_signal_default);
	DDX_Control(pDX, IDC_RADIO_TRAN_TO_FREQ, CMButtonFFT);
	DDX_Control(pDX, IDC_RADIO_AC_TO_TIMR, CMButtonIFFT);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCWaveformPropGraphSetup, CPropertyPage)
	//{{AFX_MSG_MAP(TCWaveformPropGraphSetup)
	ON_BN_CLICKED(IDC_RADIO_FOURIER, OnRadioFourier)
	ON_BN_CLICKED(IDC_RADIO_IMD, OnRadioImd)
	ON_BN_CLICKED(IDC_RADIO_INTRGRATED_NOISE, OnRadioIntrgratedNoise)
	ON_BN_CLICKED(IDC_RADIO_PLOE_ZERO, OnRadioPoleZero)
	ON_BN_CLICKED(IDC_RADIO_SENSITIVITY, OnRadioSensitivity)
	ON_BN_CLICKED(IDC_RADIO_SPECTRAL_NOISE, OnRadioSpectralNoise)
	ON_BN_CLICKED(IDC_RADIO_THD, OnRadioThd)
	ON_BN_CLICKED(IDC_RADIO_TRANSIENT, OnRadioTransient)
	ON_BN_CLICKED(IDC_RADIO_WAVEFORM_TYPE, OnRadioWaveformType)
	ON_BN_CLICKED(IDC_RADIO_AC, OnRadioAc)
	ON_LBN_SELCHANGE(IDC_LIST_BACKGROUND_COLOUR, OnSelchangeListBackgroundColour)
	ON_LBN_SELCHANGE(IDC_LIST_GRID_COLOUR, OnSelchangeListGridColour)
	ON_BN_CLICKED(IDC_RADIO_AUTO_X_AXIS, OnRadioAutoXAxis)
	ON_BN_CLICKED(IDC_RADIO_AUTO_X_MANUAL, OnRadioAutoXManual)
	ON_BN_CLICKED(IDC_RADIO_AUTO_Y_AXIS, OnRadioAutoYAxis)
	ON_BN_CLICKED(IDC_RADIO_AUTO_Y_AXIS_MANUAL, OnRadioAutoYAxisManual)
	ON_BN_CLICKED(IDC_RADIO_AUTO_PHASE_AXIS, OnRadioAutoPhaseAxis)
	ON_BN_CLICKED(IDC_RADIO_AUTO_PHASE_AXIS_MANUAL, OnRadioAutoPhaseAxisManual)
	ON_WM_HELPINFO()
	ON_BN_CLICKED(IDC_RADIO_XAXIS_LIN, OnRadioXaxisLin)
	ON_BN_CLICKED(IDC_RADIO_XAXIS_LOG, OnRadioXaxisLog)
	ON_BN_CLICKED(IDC_RADIO_IMD2, OnRadioImd2)
	ON_BN_CLICKED(IDC_RADIO_CALCULATOR, OnRadioCalculator)
	ON_BN_CLICKED(IDC_RADIO_TRAN_TO_FREQ, OnRadioTranToFreq)
	ON_BN_CLICKED(IDC_RADIO_AC_TO_TIMR, OnRadioAcToTimr)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCWaveformPropSignalSetup property page

TCWaveformPropSignalSetup::TCWaveformPropSignalSetup() : CPropertyPage(TCWaveformPropSignalSetup::IDD)
{
	//{{AFX_DATA_INIT(TCWaveformPropSignalSetup)
	CMComboSignalSelected = _T("");
	m_phase = FALSE;
	m_radians = FALSE;
	m_magnitude = FALSE;
	m_db_magnitude = FALSE;
	m_use_as_x_axis = FALSE;
	CMComboStringSpiceRuns = _T("");
	m_run_selected = FALSE;
	m_real_and_imaginary = -1;
	m_phase_axis = -1;
	//}}AFX_DATA_INIT

	PCSchematicObjectData = NULL;
	POutputWaveformData  = NULL;

	m_xgain				= 1.0;
	m_xoffset			= 0.0;
	m_ygain				= 1.0;
	m_yoffset			= 0.0;
	m_magnitude			= 0;
	m_y_phase_gain		= 1.0;
	m_y_phase_offset	= 0.0;
	m_phase				= 0;
	m_radians			= 0;
	m_magnitude			= 0;
	m_db_magnitude		= 0;

}

TCWaveformPropSignalSetup::~TCWaveformPropSignalSetup()
{
}

void TCWaveformPropSignalSetup::DoDataExchange(CDataExchange* pDX)
{
	DDX_Control(pDX, IDC_RADIO_REAL_IMAGINARY2, CMRadioRealAndImaginary);

	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCWaveformPropSignalSetup)
	DDX_Control(pDX, IDC_CHECK_SPICE_RUN_SELECTED, CMCheckRunSelected);
	DDX_Control(pDX, IDC_COMBO_SPICE_RUNS, CMComboSpiceRuns);
	DDX_Control(pDX, IDC_EDIT_YPHASE_OFFSET, CMEditPhaseOffset);
	DDX_Control(pDX, IDC_EDIT_YPHASE_GAIN, CMEditPhaseGain);
	DDX_Control(pDX, IDC_LIST_SIGNAL_PHASE_COLOUR, CMPhaseColour);
	DDX_Control(pDX, IDC_CHECK_MAGNITUDE, CMCheckMagnitude);
	DDX_Control(pDX, IDC_CHECKDB__MAGNITUDE, CMCheckDBMagnitude);
	DDX_Control(pDX, IDC_CHECK_DEGREES, CMCheckDegrees);
	DDX_Control(pDX, IDC_CHECK_RADIANS, CMCheckRadians);
	DDX_Control(pDX, IDC_LIST_SIGNAL_COLOUR, CMSignalColour);
	DDX_Control(pDX, IDC_COMBO_SIGNALS, CMComboSignals);
	DDX_MKSValue(pDX, IDC_EDIT_XGAIN, m_xgain);
	DDX_MKSValue(pDX, IDC_EDIT_XOFFSET, m_xoffset);
	DDX_MKSValue(pDX, IDC_EDIT_YGAIN, m_ygain);
	DDX_MKSValue(pDX, IDC_EDIT_YOFFSET, m_yoffset);
	DDX_CBString(pDX, IDC_COMBO_SIGNALS, CMComboSignalSelected);
	DDX_Check(pDX, IDC_CHECK_DEGREES, m_phase);
	DDX_Check(pDX, IDC_CHECK_RADIANS, m_radians);
	DDX_Check(pDX, IDC_CHECK_MAGNITUDE, m_magnitude);
	DDX_Check(pDX, IDC_CHECKDB__MAGNITUDE, m_db_magnitude);
	DDX_MKSValue(pDX, IDC_EDIT_YPHASE_GAIN, m_y_phase_gain);
	DDX_MKSValue(pDX, IDC_EDIT_YPHASE_OFFSET, m_y_phase_offset);
	DDX_Check(pDX, IDC_CHECK_USEAS_XAXIS, m_use_as_x_axis);
	DDX_CBString(pDX, IDC_COMBO_SPICE_RUNS, CMComboStringSpiceRuns);
	DDX_Check(pDX, IDC_CHECK_SPICE_RUN_SELECTED, m_run_selected);
	DDX_Radio(pDX, IDC_RADIO_REAL_IMAGINARY, m_real_and_imaginary);
	DDX_Radio(pDX, IDC_RADIO_MAG_AXIS, m_phase_axis);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCWaveformPropSignalSetup, CPropertyPage)
	//{{AFX_MSG_MAP(TCWaveformPropSignalSetup)
	ON_CBN_SELCHANGE(IDC_COMBO_SIGNALS, OnSelchangeComboSignals)
	ON_LBN_SELCHANGE(IDC_LIST_SIGNAL_COLOUR, OnSelchangeListSignalColour)
	ON_LBN_KILLFOCUS(IDC_LIST_SIGNAL_COLOUR, OnKillfocusListSignalColour)
	ON_BN_CLICKED(IDC_CHECK_DEGREES, OnCheckDegrees)
	ON_BN_CLICKED(IDC_CHECK_RADIANS, OnCheckRadians)
	ON_BN_CLICKED(IDC_CHECK_MAGNITUDE, OnCheckMagnitude)
	ON_BN_CLICKED(IDC_CHECKDB__MAGNITUDE, OnCheckdbMagnitude)
	ON_LBN_SELCHANGE(IDC_LIST_SIGNAL_PHASE_COLOUR, OnSelchangeListSignalPhaseColour)
	ON_BN_CLICKED(IDC_CHECK_USEAS_XAXIS, OnCheckUseAsXaxis)
	ON_CBN_SELCHANGE(IDC_COMBO_SPICE_RUNS, OnSelchangeComboSpiceRuns)
	ON_BN_CLICKED(IDC_BUTTON_REMOVEALL, OnButtonRemoveAll)
	ON_BN_CLICKED(IDC_BUTTONSELECTALL_RUNS, OnButtonselectAllRuns)
	ON_BN_CLICKED(IDC_BUTTON_CLEAR_ALL_SIGNALS, OnButtonClearAllSignals)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



BOOL TCWaveformPropGraphSetup::OnKillActive() 
{
	BOOL value =  CPropertyPage::OnKillActive();

	if(value)
	if(PCSchematicObjectData)
	if(PCSchematicObjectData->PCOutputWaveformDataHeader)
	{
		GetDisplay();
	}


	return value;
}

BOOL TCWaveformPropGraphSetup::OnSetActive() 
{
	g_last_active_waveform_property_page = 1;
	
	CMListBackgroundColour.SetScrollPos(SB_VERT, 5, TRUE);
	CMListGridColour.SetScrollPos(SB_VERT, 5, TRUE);

	SetDisplay();
	
	return CPropertyPage::OnSetActive();
}

BOOL TCWaveformPropGraphSetup::OnInitDialog() 
{
	if(PCSchematicObjectData)
	{
		TCOutputWaveformDataHeader &COutputWaveformDataHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;
		
		m_waveform_type = COutputWaveformDataHeader.type;

		m_xaxis_linear	= COutputWaveformDataHeader.x_grid_decades;
		m_yaxis_linear	= COutputWaveformDataHeader.y_grid_decades;
		m_x_auto		= COutputWaveformDataHeader.x_manual;
		m_y_auto		= COutputWaveformDataHeader.y_manual;
		m_x_max			= COutputWaveformDataHeader.x_max;
		m_y_max			= COutputWaveformDataHeader.y_max;
		m_x_min			= COutputWaveformDataHeader.x_min;
		m_y_min			= COutputWaveformDataHeader.y_min;
		m_multy_magnitude= COutputWaveformDataHeader.multy_magnitude_axis;
		m_multy_phase	= COutputWaveformDataHeader.multy_phase_axis;

		m_phase_axis_lin= COutputWaveformDataHeader.y_phase_grid_decades;
		m_phase_auto	= COutputWaveformDataHeader.y_phase_manual;
		m_phase_max		= COutputWaveformDataHeader.y_phase_max;
		m_phase_min		= COutputWaveformDataHeader.y_phase_min;
		m_ymag_div		= COutputWaveformDataHeader.y_mag_div;
		m_yphase_div	= COutputWaveformDataHeader.y_phase_div;
		m_xmag_div		= COutputWaveformDataHeader.x_mag_div;
		m_check_intelegent_signal_default = COutputWaveformDataHeader.inteligent_signal_default;

	}

	CPropertyPage::OnInitDialog();

	CMListBackgroundColour.LoadList();
	CMListGridColour.LoadList();

	SetButtons();

	SetDisplay();
	
	return TRUE;  
}
void TCWaveformPropGraphSetup::SetDisplay(void)
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	
	TCOutputWaveformDataHeader &COutputWaveformDataHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;
		
	CMListBackgroundColour.SetColorRef(COutputWaveformDataHeader.background_colour);
	CMListGridColour.SetColorRef(COutputWaveformDataHeader.grid_colour);

	m_waveform_type = COutputWaveformDataHeader.type;

	m_xaxis_linear	= COutputWaveformDataHeader.x_grid_decades;
	m_yaxis_linear	= COutputWaveformDataHeader.y_grid_decades;
	m_x_auto		= COutputWaveformDataHeader.x_manual;
	m_y_auto		= COutputWaveformDataHeader.y_manual;
	m_x_max			= COutputWaveformDataHeader.x_max;
	m_y_max			= COutputWaveformDataHeader.y_max;
	m_x_min			= COutputWaveformDataHeader.x_min;
	m_y_min			= COutputWaveformDataHeader.y_min;
	m_multy_magnitude = COutputWaveformDataHeader.multy_magnitude_axis;
	m_multy_phase	= COutputWaveformDataHeader.multy_phase_axis;
	m_phase_axis_lin= COutputWaveformDataHeader.y_phase_grid_decades;
	m_phase_auto	= COutputWaveformDataHeader.y_phase_manual;
	m_phase_max		= COutputWaveformDataHeader.y_phase_max;
	m_phase_min		= COutputWaveformDataHeader.y_phase_min;
	m_ymag_div		= COutputWaveformDataHeader.y_mag_div;
	m_yphase_div	= COutputWaveformDataHeader.y_phase_div;
	m_xmag_div		= COutputWaveformDataHeader.x_mag_div;

	m_check_intelegent_signal_default = COutputWaveformDataHeader.inteligent_signal_default;

	UpdateData(false);
}

void TCWaveformPropGraphSetup::GetDisplay(void)
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;

	UpdateData(true);

	TCOutputWaveformDataHeader &COutputWaveformDataHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;
		
	COutputWaveformDataHeader.background_colour =  CMListBackgroundColour.GetColorRef();
	COutputWaveformDataHeader.grid_colour = CMListGridColour.GetColorRef();

	COutputWaveformDataHeader.type = m_waveform_type;

	COutputWaveformDataHeader.x_grid_decades = m_xaxis_linear;
	COutputWaveformDataHeader.y_grid_decades = m_yaxis_linear;
	COutputWaveformDataHeader.x_manual = m_x_auto;
	COutputWaveformDataHeader.y_manual = m_y_auto;
	COutputWaveformDataHeader.x_max = (float)m_x_max;
	COutputWaveformDataHeader.y_max = (float)m_y_max;
	COutputWaveformDataHeader.x_min = (float)m_x_min;
	COutputWaveformDataHeader.y_min = (float)m_y_min;

	COutputWaveformDataHeader.multy_magnitude_axis = m_multy_magnitude;
	COutputWaveformDataHeader.multy_phase_axis = m_multy_phase;

	if(!m_ymag_div)	m_ymag_div = 1;
	if(!m_yphase_div) m_yphase_div = 1;
	if(!m_xmag_div) m_xmag_div = 1;

	COutputWaveformDataHeader.y_phase_grid_decades= m_phase_axis_lin;
	COutputWaveformDataHeader.y_phase_manual	= m_phase_auto;
	COutputWaveformDataHeader.y_phase_max	= (float)m_phase_max;
	COutputWaveformDataHeader.y_phase_min	= (float)m_phase_min;
	COutputWaveformDataHeader.y_mag_div		= (float)m_ymag_div;
	COutputWaveformDataHeader.y_phase_div	= (float)m_yphase_div;
	COutputWaveformDataHeader.x_mag_div		= (float)m_xmag_div;
	COutputWaveformDataHeader.inteligent_signal_default = !!m_check_intelegent_signal_default;

	//added 8th Sept 2001. Improve the manual selection
	COutputWaveformDataHeader.y_manual_major_grid_number = (int)((COutputWaveformDataHeader.y_max - COutputWaveformDataHeader.y_min)/COutputWaveformDataHeader.y_mag_div);

	if(!COutputWaveformDataHeader.y_manual_major_grid_number) COutputWaveformDataHeader.y_manual_major_grid_number = 1;

	COutputWaveformDataHeader.y_manual_phase_major_grid_number = (int)((COutputWaveformDataHeader.y_phase_max - COutputWaveformDataHeader.y_phase_min)/COutputWaveformDataHeader.y_phase_div);

	if(!COutputWaveformDataHeader.y_manual_phase_major_grid_number) COutputWaveformDataHeader.y_manual_major_grid_number = 1;

//	COutputWaveformDataHeader.x_manual_major_grid_number = (int)((COutputWaveformDataHeader.x_max - COutputWaveformDataHeader.x_min)/COutputWaveformDataHeader.x_mag_div);

//	if(!COutputWaveformDataHeader.x_manual_major_grid_number) COutputWaveformDataHeader.x_manual_major_grid_number = 1;

	COutputWaveformDataHeader.y_manual_major_grid_number = abs(COutputWaveformDataHeader.y_manual_major_grid_number);
	COutputWaveformDataHeader.y_manual_phase_major_grid_number = abs(COutputWaveformDataHeader.y_manual_phase_major_grid_number);
//	COutputWaveformDataHeader.x_manual_major_grid_number = abs(COutputWaveformDataHeader.x_manual_major_grid_number);
}

void TCWaveformPropGraphSetup::OnSelchangeListBackgroundColour() 
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;

	TCOutputWaveformDataHeader &COutputWaveformDataHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;
	
	COutputWaveformDataHeader.background_colour = CMListBackgroundColour.GetColorRef();
}

void TCWaveformPropGraphSetup::OnSelchangeListGridColour() 
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;

	TCOutputWaveformDataHeader &COutputWaveformDataHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;
	
	COutputWaveformDataHeader.grid_colour = CMListGridColour.GetColorRef();
	
}

/////////////
BOOL TCWaveformOptionsPropPage::OnKillActive() 
{
	BOOL value =  CPropertyPage::OnKillActive();

	if(PCSchematicObjectData)
	if(value)
	{

		GetDisplay();
	}

	return value;
}

BOOL TCWaveformOptionsPropPage::OnSetActive() 
{
	g_last_active_waveform_property_page = 4;

	SetDisplay();

	return CPropertyPage::OnSetActive();
}

BOOL TCWaveformOptionsPropPage::OnInitDialog() 
{
	CWaveformData = GCSuperSpiceGlobalData.CWaveformData;

	CPropertyPage::OnInitDialog();
	
	SetDisplay();

	return TRUE;  
}

void TCWaveformOptionsPropPage::SetDisplay(void)
{
	m_num_digits_displayed	= CWaveformData.num_digits_displayed;
	m_resolution			= CWaveformData.resolution;
	m_auto_axis				= CWaveformData.auto_axis;
	m_enable_quantisation	= CWaveformData.enable_quantisation;

	UpdateData(false);

	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals) return;
	if(!POutputWaveformData) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	TCOutputWaveformDataHeader *PCHeader = PCSchematicObjectData->PCOutputWaveformDataHeader;
	
	if(!PCHeader) return;

	m_x_manual_major_grid_number		= PCHeader->x_manual_major_grid_number;
	m_y_manual_major_grid_number		= PCHeader->y_manual_major_grid_number;
	m_y_manual_phase_major_grid_number	= PCHeader->y_manual_phase_major_grid_number;

	m_x_manual_minor_grid_number		= PCHeader->x_manual_minor_grid_number;
	m_y_manual_minor_grid_number		= PCHeader->y_manual_minor_grid_number;
	m_y_manual_phase_minor_grid_number	= PCHeader->y_manual_phase_minor_grid_number;

	UpdateData(false);
}

void TCWaveformOptionsPropPage::GetDisplay(void)
{
	UpdateData(true);

	CWaveformData.num_digits_displayed	= m_num_digits_displayed;
	CWaveformData.resolution			= m_resolution;
	CWaveformData.auto_axis				= m_auto_axis;
	CWaveformData.enable_quantisation   = m_enable_quantisation;

	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals) return;
	if(!POutputWaveformData) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	TCOutputWaveformDataHeader *PCHeader = PCSchematicObjectData->PCOutputWaveformDataHeader;
	
	if(!PCHeader) return;

	PCHeader->x_manual_major_grid_number		= m_x_manual_major_grid_number;
	PCHeader->y_manual_major_grid_number		= m_y_manual_major_grid_number;
	PCHeader->y_manual_phase_major_grid_number	= m_y_manual_phase_major_grid_number;
		
	PCHeader->x_manual_minor_grid_number		= m_x_manual_minor_grid_number;
	PCHeader->y_manual_minor_grid_number		= m_y_manual_minor_grid_number;
	PCHeader->y_manual_phase_minor_grid_number	= m_y_manual_phase_minor_grid_number;
}

void TCWaveformOptionsPropPage::OnOK() 
{
	GCSuperSpiceGlobalData.CWaveformData = CWaveformData;

	SetMKSNumDigits(GCSuperSpiceGlobalData.CWaveformData.num_digits_displayed);

	CPropertyPage::OnOK();
}

//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
BOOL TCWaveformPropSignalSetup::OnKillActive() 
{
	BOOL value =  CPropertyPage::OnKillActive();

	if(PCSchematicObjectData)
	if(PCSchematicObjectData->PCOutputWaveformDataHeader)
	if(PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals)
	if(value)
	{
		GetDisplay();
	}

	return value;
}

BOOL TCWaveformPropSignalSetup::OnSetActive() 
{
	g_last_active_waveform_property_page = 2;
	
	CMSignalColour.SetScrollPos(SB_VERT, 5, TRUE);
	CMPhaseColour.SetScrollPos(SB_VERT, 5, TRUE);

	LoadRunList();
	LoadSignalList();
	
	SetDisplay();

	return CPropertyPage::OnSetActive();
}

BOOL TCWaveformPropSignalSetup::OnInitDialog() 
{
	m_xgain			= 1.0;
	m_xoffset		= 0.0;
	m_ygain			= 1.0;
	m_yoffset		= 0.0;
	m_y_phase_gain  = 1.0;
	m_y_phase_offset = 0.0;

	CPropertyPage::OnInitDialog();
	
	CMSignalColour.LoadList();
	CMPhaseColour.LoadList();

	CMRadioRealAndImaginary.EnableWindow(false);// untill implemented

	LoadRunList();
	LoadSignalList();
	SetDisplay();

	return true;
}

void TCWaveformPropSignalSetup::LoadSignalList(void)
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader)return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals)return;
	if(IsBadReadPtr(PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals, 4)) return;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;

	TCOutputWaveformDataHeader *PCHeader = CWaveformDataRuns.GetHeader(PCSchematicObjectData->PCOutputWaveformDataHeader, PCSchematicObjectData->PCOutputWaveformDataHeader->run_index);
	
	if(!PCHeader) return;

	CMComboSignals.ResetContent();

	CArray <TCSignal, TCSignal &> &CSignals = *PCHeader->PCSignals;

	int count = CSignals.GetSize();

	for(int p = 0; p < count; p++)
	{
		CMComboSignals.InsertString(-1, CSignals[p].CName);
	}
}

void TCWaveformPropSignalSetup::LoadRunList(void)
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader)return;

	TCWaveformDataRuns &PCWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(!&PCWaveformDataRuns) return;

	CMComboSpiceRuns.ResetContent();

	int index = PCSchematicObjectData->PCOutputWaveformDataHeader->type;

	index = POutputWaveformData->GetWaveFormHeaderIndex(index);

	CMComboStringSpiceRuns = PCWaveformDataRuns.CRunDiscription;

	if(index < 0) return;

	int count = PCWaveformDataRuns.CRuns.GetSize();
	CString CText;

	for(int p = 0; p < count; p++)
	{
		if(!(index < PCWaveformDataRuns.CRuns[p]->CRecords.GetSize())) return;

		CText = PCWaveformDataRuns.CRuns[p]->CRunDiscription;

		CMComboSpiceRuns.InsertString(-1, CText);
	}

	if(count)
	{
		CMComboSpiceRuns.SelectString(-1, CMComboStringSpiceRuns);
	}
}

void TCWaveformPropSignalSetup::SetDisplay(void)
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals) return;
	if(IsBadReadPtr(PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals, 4)) return;

	int index = PCSchematicObjectData->PCOutputWaveformDataHeader->signal_index;

	int axis_index = PCSchematicObjectData->PCOutputWaveformDataHeader->axis_index;

	m_run_selected	= PCSchematicObjectData->PCOutputWaveformDataHeader->run_selected;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;

	TCOutputWaveformDataHeader *PCHeader = CWaveformDataRuns.GetHeader(PCSchematicObjectData->PCOutputWaveformDataHeader, PCSchematicObjectData->PCOutputWaveformDataHeader->run_index);
	
	if(!PCHeader) return;

	CArray <TCSignal, TCSignal &> &CSignals = *PCHeader->PCSignals;

	int count = CSignals.GetSize();

	if(index < count)
	{
		TCSignal &CSignal = CSignals[index];

		CMSignalColour.SetColorRef(CSignal.normal_colour);
		CMPhaseColour.SetColorRef(CSignal.normal_phase_colour);

		CMComboSignalSelected	= CSignal.CName;
		m_xgain				= CSignal.x_gain;
		m_xoffset			= CSignal.x_offset;
		m_ygain				= CSignal.y_gain;
		m_yoffset			= CSignal.y_offset;
		m_magnitude			= CSignal.magnitude;
		m_y_phase_gain		= CSignal.y_phase_gain;
		m_y_phase_offset	= CSignal.y_phase_offset;
		m_phase				= 0;
		m_radians			= 0;
		m_magnitude			= 0;
		m_db_magnitude		= 0;
		m_phase_axis		= CSignal.phase_axis;
		m_real_and_imaginary = CSignal.rectangular;

		if(axis_index == index) m_use_as_x_axis	= true;
		else m_use_as_x_axis	= false;
		
		if(CSignal.phase == 0) m_phase		= true;
		if(CSignal.phase == 1) m_radians	= true;

		if(CSignal.magnitude == 0) m_magnitude = true;
		if(CSignal.magnitude == 1) m_db_magnitude= true;

		if(CSignal.CPhaseData.CX.GetSize())
		{
			CMCheckRadians.EnableWindow(true); 
			CMCheckDegrees.EnableWindow(true); 
			CMPhaseColour.EnableWindow(true); 
			CMEditPhaseOffset.SetReadOnly(false);
			CMEditPhaseGain.SetReadOnly(false);
		}
		else
		{
			CMCheckRadians.EnableWindow(false); 
			CMCheckDegrees.EnableWindow(false); 
			CMPhaseColour.EnableWindow(false); 
			CMEditPhaseOffset.SetReadOnly(true);
			CMEditPhaseGain.SetReadOnly(true);
		}
	}

	UpdateData(false);

	CMComboSignals.SelectString(index - 1, CMComboSignalSelected);
}

void TCWaveformPropSignalSetup::GetDisplay(void)
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals) return;
	if(IsBadReadPtr(PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals, 4)) return;
	
	UpdateData(true);

	int run_index = PCSchematicObjectData->PCOutputWaveformDataHeader->run_index;// need to sort this CMComboSpiceRuns.GetCurSel();

	if(run_index == -1) run_index = 0;

	PCSchematicObjectData->PCOutputWaveformDataHeader->run_index = run_index;

	int index = PCSchematicObjectData->PCOutputWaveformDataHeader->signal_index;

	PCSchematicObjectData->PCOutputWaveformDataHeader->run_selected = !!m_run_selected;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;

	CWaveformDataRuns.CRunDiscription = CMComboStringSpiceRuns;

	TCOutputWaveformDataHeader *PCHeader = CWaveformDataRuns.GetHeader(PCSchematicObjectData->PCOutputWaveformDataHeader, run_index);
	
	if(!PCHeader) return;
	
	CArray <TCSignal, TCSignal &> &CSignals = *PCHeader->PCSignals;

	if(index < CSignals.GetSize())
	{
		TCSignal &CSignal = CSignals[index];

		CSignal.CName			= CMComboSignalSelected;
		CSignal.x_gain			= (float)m_xgain;
		CSignal.x_offset		= (float)m_xoffset;
		CSignal.y_gain			= (float)m_ygain;
		CSignal.y_offset		= (float)m_yoffset;
		CSignal.y_phase_gain	= (float)m_y_phase_gain;
		CSignal.y_phase_offset	= (float)m_y_phase_offset;
		CSignal.normal_colour	= CMSignalColour.GetColorRef();
		CSignal.normal_phase_colour   = CMPhaseColour.GetColorRef();
		CSignal.magnitude		= -1;
		CSignal.phase			= -1;
		CSignal.phase_axis		= m_phase_axis;
		CSignal.rectangular		= m_real_and_imaginary;

		if(!CSignal.x_gain) CSignal.x_gain = 1.0;
		if(!CSignal.y_gain) CSignal.y_gain = 1.0;

		if(m_use_as_x_axis) PCSchematicObjectData->PCOutputWaveformDataHeader->axis_index = index;

		if(m_phase)		CSignal.phase = 0;
		if(m_radians)	CSignal.phase = 1;

		if(m_magnitude)	CSignal.magnitude = 0;
		if(m_db_magnitude)CSignal.magnitude = 1;
	}
}

void TCWaveformPropSignalSetup::OnSelchangeComboSpiceRuns() 
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	GetDisplay();

	int index = CMComboSpiceRuns.GetCurSel();

	if(index == -1) index = 0;

	CMComboSpiceRuns.GetLBText(index, CMComboStringSpiceRuns);

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;

	CWaveformDataRuns.CRunDiscription = CMComboStringSpiceRuns;

	TCOutputWaveformDataHeader *PCHeader = CWaveformDataRuns.GetHeader(PCSchematicObjectData->PCOutputWaveformDataHeader, PCSchematicObjectData->PCOutputWaveformDataHeader->run_index);
	
	PCSchematicObjectData->PCOutputWaveformDataHeader->run_index = index;

	if(PCHeader) 
	{
		PCHeader->select_all_runs	= PCSchematicObjectData->PCOutputWaveformDataHeader->select_all_runs;
		PCHeader->run_index			= PCSchematicObjectData->PCOutputWaveformDataHeader->run_index;
	}

	LoadRunList();
	LoadSignalList();

	SetDisplay();
}

void TCWaveformPropSignalSetup::OnSelchangeComboSignals() 
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals) return;

	GetDisplay();

	PCSchematicObjectData->PCOutputWaveformDataHeader->signal_index = CMComboSignals.GetCurSel();

	SetDisplay();
}

void TCWaveformPropSignalSetup::OnSelchangeListSignalColour() 
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals) return;
	if(!POutputWaveformData) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;

	TCOutputWaveformDataHeader *PCHeader = CWaveformDataRuns.GetHeader(PCSchematicObjectData->PCOutputWaveformDataHeader, PCSchematicObjectData->PCOutputWaveformDataHeader->run_index);
	
	if(!PCHeader) return;

	CArray <TCSignal, TCSignal &> &CSignals = *PCHeader->PCSignals;

	int index = PCSchematicObjectData->PCOutputWaveformDataHeader->signal_index;

	if(!(index < CSignals.GetSize())) return;

	TCSignal &CSignal = CSignals[index];
 
	CSignal.normal_colour = CMSignalColour.GetColorRef();
}

void TCWaveformPropSignalSetup::OnSelchangeListSignalPhaseColour() 
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals) return;
	if(!POutputWaveformData) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;

	TCOutputWaveformDataHeader *PCHeader = CWaveformDataRuns.GetHeader(PCSchematicObjectData->PCOutputWaveformDataHeader, PCSchematicObjectData->PCOutputWaveformDataHeader->run_index);
	
	if(!PCHeader) return;

	CArray <TCSignal, TCSignal &> &CSignals = *PCHeader->PCSignals;

	int index = PCSchematicObjectData->PCOutputWaveformDataHeader->signal_index;

	if(!(index < CSignals.GetSize())) return;

	TCSignal &CSignal = CSignals[index];
 
	CSignal.normal_phase_colour = CMPhaseColour.GetColorRef();
}

void TCWaveformPropSignalSetup::OnCheckDegrees() 
{	
	CMCheckRadians.SetCheck(false);
}

void TCWaveformPropSignalSetup::OnCheckRadians() 
{
	CMCheckDegrees.SetCheck(false);
}

void TCWaveformPropSignalSetup::OnKillfocusListSignalColour() 
{
	OnSelchangeListSignalColour();	
}

void TCWaveformPropSignalSetup::OnCheckMagnitude() 
{
	CMCheckDBMagnitude.SetCheck(false);
}

void TCWaveformPropSignalSetup::OnCheckdbMagnitude() 
{
	CMCheckMagnitude.SetCheck(false);
}

void TCWaveformPropSignalSetup::OnCheckUseAsXaxis() 
{
	CMCheckMagnitude.SetCheck(false);// no point in displaying axis, can be overwriten
	CMCheckDBMagnitude.SetCheck(false);
	CMCheckDegrees.SetCheck(false);
	CMCheckRadians.SetCheck(false);
}
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////

void TCWaveformPropGraphSetup::OnRadioFourier() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	int waveform_type = m_waveform_type;
	
	GetDisplay();

	// overwrite the updated GetDisplay with old type
	PCSchematicObjectData->PCOutputWaveformDataHeader->type = waveform_type;

	if(waveform_type > -1)POutputWaveformData->CRecords[waveform_type].CHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;

	
	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_FOURIER);

	if(index < 0) return;

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->SetWaveFormLabels(POutputWaveformData->CRecords[index].CHeader);

	SetDisplay();
}

void TCWaveformPropGraphSetup::OnRadioImd() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	int waveform_type = m_waveform_type;
	
	GetDisplay();

	// overwrite the updated GetDisplay with old type
	PCSchematicObjectData->PCOutputWaveformDataHeader->type = waveform_type;

	if(waveform_type > -1)POutputWaveformData->CRecords[waveform_type].CHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;

	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_IMD);

	if(index < 0) return;

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->SetWaveFormLabels(POutputWaveformData->CRecords[index].CHeader);

	SetDisplay();
}

void TCWaveformPropGraphSetup::OnRadioImd2() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	int waveform_type = m_waveform_type;
	
	GetDisplay();

	// overwrite the updated GetDisplay with old type
	PCSchematicObjectData->PCOutputWaveformDataHeader->type = waveform_type;

	if(waveform_type > -1)POutputWaveformData->CRecords[waveform_type].CHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;

	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_DISTORTION_IMD_2F);

	if(index < 0) return;

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->SetWaveFormLabels(POutputWaveformData->CRecords[index].CHeader);

	SetDisplay();
}
void TCWaveformPropGraphSetup::SetButtons(void)
{
	if(!POutputWaveformData)
	{
		CMButtonDC.EnableWindow(false);
		CMButtonAC.EnableWindow(false);
		CMButtonSpectralNoise.EnableWindow(false);
		CMButtonPoleZero.EnableWindow(false);
		CMButtonTransient.EnableWindow(false);
		CMButtonFourier.EnableWindow(false);
		CMButtonTHD.EnableWindow(false);
		CMButtonIMD.EnableWindow(false);
		CMButtonF2.EnableWindow(false);
		CMButtonSensitivity.EnableWindow(false);
		CMButtonFFT.EnableWindow(false);
		CMButtonIFFT.EnableWindow(false);

		return;
	}

	CMButtonDC.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_DC));
	CMButtonAC.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_AC));
	CMButtonSpectralNoise.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_NOISE_SPECTRAL));
//	CMButtonPoleZero.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_POLE_ZERO));
	CMButtonTransient.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT));
	CMButtonFourier.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_FOURIER));
	CMButtonTHD.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_THD));
	CMButtonIMD.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_IMD));
	CMButtonF2.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_DISTORTION_IMD_2F));
	CMButtonSensitivity.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_SENSITIVITY));
	CMButtonFFT.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_TIME_TO_FREQ_FFT));
	CMButtonIFFT.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_FREQ_TO_TIME_FFT));

	SetAxisButtons();
}

void TCWaveformPropGraphSetup::SetAxisButtons(void)
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;

	TCOutputWaveformDataHeader &COutputWaveformDataHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;

	CMEditYMin.SetReadOnly(!COutputWaveformDataHeader.y_manual);
	CMEditYMax.SetReadOnly(!COutputWaveformDataHeader.y_manual);

	CMEditXMin.SetReadOnly(!COutputWaveformDataHeader.x_manual);
	CMEditXMax.SetReadOnly(!COutputWaveformDataHeader.x_manual);
	EMEditPhaseMin.SetReadOnly(!COutputWaveformDataHeader.y_phase_manual);
	EMEditPhaseMax.SetReadOnly(!COutputWaveformDataHeader.y_phase_manual);
	
	CMEditXMagDivision.SetReadOnly(!COutputWaveformDataHeader.x_manual || COutputWaveformDataHeader.x_grid_decades);
	
	// do do later, auto change ticks
	CMEditYPhaseDivision.SetReadOnly(!COutputWaveformDataHeader.y_phase_manual);
	CMEditYMagDivision.SetReadOnly(!COutputWaveformDataHeader.y_manual);
//	CMEditYPhaseDivision.SetReadOnly();
//	CMEditYMagDivision.SetReadOnly();
}

void TCWaveformPropGraphSetup::EnableCalculator(int enable)
{// a bit messy
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns) return;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;

	if(PCSchematicObjectData->PCOutputWaveformDataHeader->type == E_SPICE_RECORD_MATH_0)
	{
		CWaveformDataRuns.CMathFunctionDataList[0].calculator_enabled = enable;
		CWaveformDataRuns.CMathFunctionDataList[1].calculator_enabled = enable;
		CWaveformDataRuns.CMathFunctionDataList[2].calculator_enabled = enable;
		CWaveformDataRuns.CMathFunctionDataList[3].calculator_enabled = enable;
	}
}

void TCWaveformPropGraphSetup::OnRadioXaxisLin() 
{
	GetDisplay();

	SetAxisButtons();
}

void TCWaveformPropGraphSetup::OnRadioXaxisLog() 
{
	GetDisplay();

	SetAxisButtons();
}


void TCWaveformPropGraphSetup::OnRadioAutoXAxis() 
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;

	TCOutputWaveformDataHeader &COutputWaveformDataHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;

	COutputWaveformDataHeader.x_manual = 0;
	m_x_auto = 0;

	SetAxisButtons();
}

void TCWaveformPropGraphSetup::OnRadioAutoXManual() 
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;

	TCOutputWaveformDataHeader &COutputWaveformDataHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;

	COutputWaveformDataHeader.x_manual = 1;
	m_x_auto = 1;

	SetAxisButtons();
}

void TCWaveformPropGraphSetup::OnRadioAutoYAxis() 
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;

	TCOutputWaveformDataHeader &COutputWaveformDataHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;

	COutputWaveformDataHeader.y_manual = 0;
	m_y_auto = 0;

	SetAxisButtons();
}

void TCWaveformPropGraphSetup::OnRadioAutoYAxisManual() 
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;

	TCOutputWaveformDataHeader &COutputWaveformDataHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;

	COutputWaveformDataHeader.y_manual = 1;
	m_y_auto = 1;

	SetAxisButtons();
}

void TCWaveformPropGraphSetup::OnRadioAutoPhaseAxis() 
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;

	TCOutputWaveformDataHeader &COutputWaveformDataHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;

	COutputWaveformDataHeader.y_phase_manual = 0;
	m_phase_auto = 0;
	SetAxisButtons();	
}

void TCWaveformPropGraphSetup::OnRadioAutoPhaseAxisManual() 
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;

	TCOutputWaveformDataHeader &COutputWaveformDataHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;

	COutputWaveformDataHeader.y_phase_manual = 1;
	m_phase_auto = 1;

	SetAxisButtons();
}

void TCWaveformPropGraphSetup::OnRadioIntrgratedNoise() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	int waveform_type = m_waveform_type;
	
	GetDisplay();

	// overwrite the updated GetDisplay with old type
	PCSchematicObjectData->PCOutputWaveformDataHeader->type = waveform_type;

	if(waveform_type > -1)POutputWaveformData->CRecords[waveform_type].CHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;

	
	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_NOISE_INTEGRATED);

	if(index < 0) return;

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->SetWaveFormLabels(POutputWaveformData->CRecords[index].CHeader);

	EnableCalculator(false);

	SetDisplay();
}

void TCWaveformPropGraphSetup::OnRadioPoleZero() 
{
	return;
/*
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	int waveform_type = m_waveform_type;
	
	GetDisplay();

	// overwrite the updated GetDisplay with old type
	PCSchematicObjectData->PCOutputWaveformDataHeader->type = waveform_type;

	if(waveform_type > -1)POutputWaveformData->CRecords[waveform_type].CHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;
	
	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_POLE_ZERO);

	if(index < 0) return;

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->SetWaveFormLabels(POutputWaveformData->CRecords[index].CHeader);
	
	EnableCalculator(false);

	SetDisplay();*/
}

void TCWaveformPropGraphSetup::OnRadioSensitivity() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	int waveform_type = m_waveform_type;
	
	GetDisplay();

	// overwrite the updated GetDisplay with old type
	PCSchematicObjectData->PCOutputWaveformDataHeader->type = waveform_type;

	if(waveform_type > -1)POutputWaveformData->CRecords[waveform_type].CHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;

	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_SENSITIVITY);

	if(index < 0) return;

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->SetWaveFormLabels(POutputWaveformData->CRecords[index].CHeader);

	EnableCalculator(false);

	SetDisplay();
}

void TCWaveformPropGraphSetup::OnRadioSpectralNoise() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	int waveform_type = m_waveform_type;
	
	GetDisplay();

	// overwrite the updated GetDisplay with old type
	PCSchematicObjectData->PCOutputWaveformDataHeader->type = waveform_type;

	if(waveform_type > -1)POutputWaveformData->CRecords[waveform_type].CHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;

	
	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_NOISE_SPECTRAL);

	if(index < 0) return;

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->SetWaveFormLabels(POutputWaveformData->CRecords[index].CHeader);

	EnableCalculator(false);

	SetDisplay();
}

void TCWaveformPropGraphSetup::OnRadioThd() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	int waveform_type = m_waveform_type;
	
	GetDisplay();

	// overwrite the updated GetDisplay with old type
	PCSchematicObjectData->PCOutputWaveformDataHeader->type = waveform_type;

	if(waveform_type > -1)POutputWaveformData->CRecords[waveform_type].CHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;

	
	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_THD);

	if(index < 0) return;

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->SetWaveFormLabels(POutputWaveformData->CRecords[index].CHeader);
	
	EnableCalculator(false);

	SetDisplay();
}

void TCWaveformPropGraphSetup::OnRadioTransient() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	int waveform_type = m_waveform_type;
	
	GetDisplay();

	// overwrite the updated GetDisplay with old type
	PCSchematicObjectData->PCOutputWaveformDataHeader->type = waveform_type;

	if(waveform_type > -1)POutputWaveformData->CRecords[waveform_type].CHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;
	
	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_TRANSIENT);

	if(index < 0) return;

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->SetWaveFormLabels(POutputWaveformData->CRecords[index].CHeader);

	EnableCalculator(false);

	SetDisplay();
}

void TCWaveformPropGraphSetup::OnRadioCalculator() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;

	int waveform_type = m_waveform_type;
	
	if(waveform_type < 0) waveform_type = 0;

	GetDisplay();

	// overwrite the updated GetDisplay with old type
	PCSchematicObjectData->PCOutputWaveformDataHeader->type = waveform_type;

	if(waveform_type > -1)POutputWaveformData->CRecords[waveform_type].CHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;
	
	int index = E_SPICE_RECORD_MATH_0;// POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_MATH_0);

	if(index < 0) return;

	if(PCSchematicObjectData->PCOutputWaveformDataHeader->type != E_SPICE_RECORD_MATH_0)
	{
		CWaveformDataRuns.CMathFunctionDataList[0].last_graphic_type = waveform_type;
	
		//Sync calculator data i.e. copy signal list
		POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0] = POutputWaveformData->CRecords[waveform_type];
	
		POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader.type = E_SPICE_RECORD_MATH_0;
		// recover signal pointer that was overwritten by above
		POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader.PCSignals = &POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CSignals;
	}

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->PCOutputWaveformDataHeader->type = E_SPICE_RECORD_MATH_0;

	PCSchematicObjectData->SetWaveFormLabels(POutputWaveformData->CRecords[index].CHeader);

	EnableCalculator(true);

	SetDisplay();	
}

void TCWaveformPropGraphSetup::OnRadioWaveformType() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	int waveform_type = m_waveform_type;

	GetDisplay();

	// overwrite the updated GetDisplay with old type
	PCSchematicObjectData->PCOutputWaveformDataHeader->type = waveform_type;

	if(waveform_type > -1)POutputWaveformData->CRecords[waveform_type].CHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;

	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_DC);

	if(index < 0) return;

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->SetWaveFormLabels(POutputWaveformData->CRecords[index].CHeader);

	EnableCalculator(false);

	SetDisplay();
}

void TCWaveformPropGraphSetup::OnRadioAc() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	int waveform_type = m_waveform_type;
	
	GetDisplay();

	// overwrite the updated GetDisplay with old type
	PCSchematicObjectData->PCOutputWaveformDataHeader->type = waveform_type;

	if(waveform_type > -1)POutputWaveformData->CRecords[waveform_type].CHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;
	
	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_AC);

	if(index < 0) return;

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->SetWaveFormLabels(POutputWaveformData->CRecords[index].CHeader);

	EnableCalculator(false);

	SetDisplay();
}


void TCWaveformPropSignalSetup::OnButtonRemoveAll() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	int count = POutputWaveformData->CRecords.GetSize();

	for(int p = 0; p < count; p++)// i should have put this int the run class, but what the fuck!
	{
		POutputWaveformData->CRecords[p].CHeader.run_selected = false; 
	}

	PCSchematicObjectData->PCOutputWaveformDataHeader->run_selected = false;

	m_run_selected = false;

	CMCheckRunSelected.SetCheck(false);	
}

void TCWaveformPropSignalSetup::OnButtonselectAllRuns() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	int count = POutputWaveformData->CRecords.GetSize();

	for(int p = 0; p < count; p++)// i should have put this int the run class, but what the fuck!
	{
		POutputWaveformData->CRecords[p].CHeader.run_selected = true; 
	}

	PCSchematicObjectData->PCOutputWaveformDataHeader->run_selected = true;

	m_run_selected = true;

	CMCheckRunSelected.SetCheck(true);
}



void TCWaveformPropSignalSetup::OnButtonClearAllSignals() 
{
	if(!PCSchematicObjectData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals) return;
	if(!POutputWaveformData) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;

	TCOutputWaveformDataHeader *PCHeader = CWaveformDataRuns.GetHeader(PCSchematicObjectData->PCOutputWaveformDataHeader, PCSchematicObjectData->PCOutputWaveformDataHeader->run_index);
	
	if(IsBadCodePtr((FARPROC)PCHeader)) return;
	
	PCHeader->ClearAllSignals();

	if(IsBadCodePtr((FARPROC)PCSchematicObjectData->PCOutputWaveformDataHeader)) return;

	PCSchematicObjectData->PCOutputWaveformDataHeader->ClearAllSignals();

	SetDisplay();
}

BOOL TCWaveformPropGraphSetup::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	AfxGetApp()->WinHelp(pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	
	return true;

//	return CPropertyPage::OnHelpInfo(pHelpInfo);
}

void TCWaveformPropGraphSetup::WinHelp(DWORD dwData, UINT nCmd) 
{
	// TODO: Add your specialized code here and/or call the base class
	
	CPropertyPage::WinHelp(dwData, nCmd);
}


void TCWaveformCalculatorPropPage::OnRadioUseSignals() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;
	if(IsBadReadPtr(PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals, 4)) return;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;

	int index = POutputWaveformData->GetWaveFormHeaderIndex(CWaveformDataRuns.CMathFunctionDataList[0].last_graphic_type);

	if(index < 0) return;

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->SetWaveFormLabels(POutputWaveformData->CRecords[index].CHeader);

	calculator_enabled = 0;

	SetButtons();
}

void TCWaveformCalculatorPropPage::OnRadioUseCalculator() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;
	if(IsBadReadPtr(PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals, 4)) return;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;

	int index = E_SPICE_RECORD_MATH_0;//POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_MATH_0);

	if(index < 0) return;

	if(PCSchematicObjectData->PCOutputWaveformDataHeader->type != E_SPICE_RECORD_MATH_0)
	{
		CWaveformDataRuns.CMathFunctionDataList[0].last_graphic_type = PCSchematicObjectData->PCOutputWaveformDataHeader->type;
	
		POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader.type = E_SPICE_RECORD_MATH_0;

		CWaveformDataRuns.CopyData(POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader, POutputWaveformData->CRecords[PCSchematicObjectData->PCOutputWaveformDataHeader->type].CHeader);
	}

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->PCOutputWaveformDataHeader->type = E_SPICE_RECORD_MATH_0;

	PCSchematicObjectData->SetWaveFormLabels(POutputWaveformData->CRecords[index].CHeader);

	calculator_enabled = 1;

	SetButtons();
}

void TCWaveformCalculatorPropPage::SetButtons(void)
{
	if(!POutputWaveformData)
	{
		CMButtonDC.EnableWindow(false);
		CMButtonAC.EnableWindow(false);
		CMButtonSpectralNoise.EnableWindow(false);
		CMButtonPoleZero.EnableWindow(false);
		CMButtonTransient.EnableWindow(false);
		CMButtonFourier.EnableWindow(false);
		CMButtonTHD.EnableWindow(false);
		CMButtonIMD.EnableWindow(false);
		CMButtonF2.EnableWindow(false);
		CMButtonSensitivity.EnableWindow(false);

		return;
	}

	if(IsBadReadPtr(POutputWaveformData, 4)) return;

	CMButtonDC.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_DC) && calculator_enabled);
	CMButtonAC.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_AC) && calculator_enabled);
	CMButtonSpectralNoise.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_NOISE_SPECTRAL) && calculator_enabled);
	CMButtonPoleZero.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_POLE_ZERO) && calculator_enabled);
	CMButtonTransient.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT) && calculator_enabled);
	CMButtonFourier.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_FOURIER) && calculator_enabled);
	CMButtonTHD.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_THD) && calculator_enabled);
	CMButtonIMD.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_IMD) && calculator_enabled);
	CMButtonF2.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_DISTORTION_IMD_2F) && calculator_enabled);
	CMButtonSensitivity.EnableWindow(POutputWaveformData->IsWaveformHeaderAvailable(E_SPICE_RECORD_SENSITIVITY) && calculator_enabled);
	
}

void TCWaveformCalculatorPropPage::OnRadioAc() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;
	if(IsBadReadPtr(PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals, 4)) return;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;	

	GetDisplay();

	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_AC);

	if(index < 0) return;

	POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader.type = E_SPICE_RECORD_MATH_0;

	CWaveformDataRuns.CopyData(POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader, POutputWaveformData->CRecords[index].CHeader);

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->PCOutputWaveformDataHeader->type = E_SPICE_RECORD_MATH_0;

	SetDisplay();
}

void TCWaveformCalculatorPropPage::OnRadioFourier() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;
	if(IsBadReadPtr(PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals, 4)) return;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;	

	GetDisplay();

	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_FOURIER);

	if(index < 0) return;

	POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader.type = E_SPICE_RECORD_MATH_0;

	CWaveformDataRuns.CopyData(POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader, POutputWaveformData->CRecords[index].CHeader);

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->PCOutputWaveformDataHeader->type = E_SPICE_RECORD_MATH_0;

	SetDisplay();
}

void TCWaveformCalculatorPropPage::OnRadioImd() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;
	if(IsBadReadPtr(PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals, 4)) return;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;	

	GetDisplay();

	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_IMD);

	if(index < 0) return;

	POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader.type = E_SPICE_RECORD_MATH_0;

	CWaveformDataRuns.CopyData(POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader, POutputWaveformData->CRecords[index].CHeader);

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->PCOutputWaveformDataHeader->type = E_SPICE_RECORD_MATH_0;

	SetDisplay();
}

void TCWaveformCalculatorPropPage::OnRadioImd2() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;
	if(IsBadReadPtr(PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals, 4)) return;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;	

	GetDisplay();

	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_DISTORTION_IMD_2F);

	if(index < 0) return;

	POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader.type = E_SPICE_RECORD_MATH_0;

	CWaveformDataRuns.CopyData(POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader, POutputWaveformData->CRecords[index].CHeader);

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->PCOutputWaveformDataHeader->type = E_SPICE_RECORD_MATH_0;

	SetDisplay();
}

void TCWaveformCalculatorPropPage::OnRadioPoleZero() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;
	if(IsBadReadPtr(PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals, 4)) return;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;	

	GetDisplay();

	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_POLE_ZERO);

	if(index < 0) return;

	POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader.type = E_SPICE_RECORD_MATH_0;

	CWaveformDataRuns.CopyData(POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader, POutputWaveformData->CRecords[index].CHeader);

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->PCOutputWaveformDataHeader->type = E_SPICE_RECORD_MATH_0;

	SetDisplay();
}

void TCWaveformCalculatorPropPage::OnRadioSensitivity() 
{
	if(PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;
	if(IsBadReadPtr(PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals, 4)) return;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;	

	GetDisplay();

	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_SENSITIVITY);

	if(index < 0) return;

	POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader.type = E_SPICE_RECORD_MATH_0;

	CWaveformDataRuns.CopyData(POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader, POutputWaveformData->CRecords[index].CHeader);

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->PCOutputWaveformDataHeader->type = E_SPICE_RECORD_MATH_0;

	SetDisplay();
}

void TCWaveformCalculatorPropPage::OnRadioSpectralNoise() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;
	if(IsBadReadPtr(PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals, 4)) return;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;

	GetDisplay();

	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_NOISE_SPECTRAL);

	if(index < 0) return;

	POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader.type = E_SPICE_RECORD_MATH_0;

	CWaveformDataRuns.CopyData(POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader, POutputWaveformData->CRecords[index].CHeader);

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->PCOutputWaveformDataHeader->type = E_SPICE_RECORD_MATH_0;

	SetDisplay();
}

void TCWaveformCalculatorPropPage::OnRadioThd() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;
	if(IsBadReadPtr(PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals, 4)) return;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;	

	GetDisplay();

	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_THD);

	if(index < 0) return;

	POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader.type = E_SPICE_RECORD_MATH_0;

	CWaveformDataRuns.CopyData(POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader, POutputWaveformData->CRecords[index].CHeader);

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->PCOutputWaveformDataHeader->type = E_SPICE_RECORD_MATH_0;

	SetDisplay();
}

void TCWaveformCalculatorPropPage::OnRadioTransient() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;
	if(IsBadReadPtr(PCSchematicObjectData->PCOutputWaveformDataHeader->PCSignals, 4)) return;

	TCWaveformDataRuns &CWaveformDataRuns = *PCSchematicObjectData->PCOutputWaveformDataHeader->PCWaveformDataRuns;

	if(IsBadReadPtr(&CWaveformDataRuns, 4)) return;

	GetDisplay();

	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_TRANSIENT);

	if(index < 0) return;

	POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader.type = E_SPICE_RECORD_MATH_0;

	CWaveformDataRuns.CopyData(POutputWaveformData->CRecords[E_SPICE_RECORD_MATH_0].CHeader, POutputWaveformData->CRecords[index].CHeader);

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->PCOutputWaveformDataHeader->type = E_SPICE_RECORD_MATH_0;

	SetDisplay();
}

void TCWaveformPropGraphSetup::OnRadioTranToFreq() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	int waveform_type = m_waveform_type;
	
	GetDisplay();

	// overwrite the updated GetDisplay with old type
	PCSchematicObjectData->PCOutputWaveformDataHeader->type = waveform_type;

	if(waveform_type > -1)POutputWaveformData->CRecords[waveform_type].CHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;

	
	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_TIME_TO_FREQ_FFT);

	if(index < 0) return;

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->SetWaveFormLabels(POutputWaveformData->CRecords[index].CHeader);

	SetDisplay();	
}

void TCWaveformPropGraphSetup::OnRadioAcToTimr() 
{
	if(!PCSchematicObjectData) return;
	if(!POutputWaveformData) return;
	if(!PCSchematicObjectData->PCOutputWaveformDataHeader) return;
	if(!POutputWaveformData->CRecords.GetSize()) return;

	int waveform_type = m_waveform_type;
	
	GetDisplay();

	// overwrite the updated GetDisplay with old type
	PCSchematicObjectData->PCOutputWaveformDataHeader->type = waveform_type;

	if(waveform_type > -1)POutputWaveformData->CRecords[waveform_type].CHeader = *PCSchematicObjectData->PCOutputWaveformDataHeader;

	
	int index = POutputWaveformData->GetWaveFormHeaderIndex(E_SPICE_RECORD_FREQ_TO_TIME_FFT);

	if(index < 0) return;

	*PCSchematicObjectData->PCOutputWaveformDataHeader = POutputWaveformData->CRecords[index].CHeader;

	PCSchematicObjectData->SetWaveFormLabels(POutputWaveformData->CRecords[index].CHeader);

	SetDisplay();	
}
