// TCWaveformPropPages.h : header file
//

#ifndef __TCWAVEFORMPROPPAGES_H__
#define __TCWAVEFORMPROPPAGES_H__

#include "TCColorListBox.h"
/////////////////////////////////////////////////////////////////////////////
// TCWaveformOptionsPropPage dialog
class TCSchematicObjectData;
class TCOutputWaveformData;
#include "TCSuperSpiceGlobalData.h"


class TCWaveformCalculatorPropPage : public CPropertyPage
{
	DECLARE_DYNCREATE(TCWaveformCalculatorPropPage)

// Construction
public:
	TCWaveformCalculatorPropPage();
	~TCWaveformCalculatorPropPage();


	TCSchematicObjectData *PCSchematicObjectData;
	TCOutputWaveformData *POutputWaveformData;
	TCWaveformData		  CWaveformData;

	void SetDisplay(void);
	void GetDisplay(void);
	void SetFunctionList(void);
	void SetOperatorList(void);
	void SetSigmalsAList(void);
	void SetSignalsBList(void);
	void SetButtons(void);

// Dialog Data
	//{{AFX_DATA(TCWaveformCalculatorPropPage)
	enum { IDD = IDD_PROPP_WAVEFORM_CALCULATOR };
	CButton	CMCheckDegrees4;
	CButton	CMCheckDegrees3;
	CButton	CMCheckDegrees2;
	CButton	CMCheckDegrees1;
	CComboBox	CMComboFunctionOperator4;
	CComboBox	CMComboFunctionOperator3;
	CComboBox	CMComboFunctionOperator2;
	CComboBox	CMComboFunctionOperator1;
	CComboBox	CMComboMathOperator4;
	CComboBox	CMComboMathOperator3;
	CComboBox	CMComboMathOperator2;
	CComboBox	CMComboMathOperator1;
	CComboBox	CMComboSignals4B;
	CComboBox	CMComboSignals3B;
	CComboBox	CMComboSignals2B;
	CComboBox	CMComboSignals1B;
	CComboBox	CMComboSignals4A;
	CComboBox	CMComboSignals3A;
	CComboBox	CMComboSignals2A;
	CComboBox	CMComboSignals1A;
	BOOL	m_check_degrees1;
	BOOL	m_check_degrees2;
	BOOL	m_check_degrees3;
	BOOL	m_check_degrees4;
	BOOL	m_check_magnitude1;
	BOOL	m_check_magnitude2;
	BOOL	m_check_magnitude3;
	BOOL	m_check_magnitude4;
	int		m_signals1_a;
	int		m_signals1_b;
	int		m_signals2_a;
	int		m_signals2_b;
	int		m_signals3_a;
	int		m_signals3_b;
	int		m_signals4_a;
	int		m_signals4_b;
	int		m_signals1_ab_operator;
	int		m_signals2_ab_operator;
	int		m_signals3_ab_operator;
	int		m_signals4_ab_operator;
	int		m_funcion_operator1;
	int		m_funcion_operator3;
	int		m_funcion_operator4;
	int		m_funcion_operator2;
	int		calculator_enabled;
	int		m_waveform_type;
	CButton	CMButtonDC;
	CButton	CMButtonAC;
	CButton	CMButtonSpectralNoise;
	CButton	CMButtonPoleZero;
	CButton	CMButtonTransient;
	CButton	CMButtonFourier;
	CButton	CMButtonTHD;
	CButton	CMButtonIMD;
	CButton	CMButtonF2;
	CButton	CMButtonSensitivity;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCWaveformCalculatorPropPage)
	public:
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCWaveformCalculatorPropPage)
	virtual BOOL OnInitDialog();
	afx_msg void OnRadioUseSignals();
	afx_msg void OnRadioUseCalculator();
	afx_msg void OnRadioAc();
	afx_msg void OnRadioFourier();
	afx_msg void OnRadioImd();
	afx_msg void OnRadioImd2();
	afx_msg void OnRadioPoleZero();
	afx_msg void OnRadioSensitivity();
	afx_msg void OnRadioSpectralNoise();
	afx_msg void OnRadioThd();
	afx_msg void OnRadioTransient();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};


//////////////////////////
class TCWaveformOptionsPropPage : public CPropertyPage
{
	DECLARE_DYNCREATE(TCWaveformOptionsPropPage)

// Construction
public:
	TCWaveformOptionsPropPage();
	~TCWaveformOptionsPropPage();

	void SetDisplay(void);
	void GetDisplay(void);

	TCSchematicObjectData *PCSchematicObjectData;
	TCOutputWaveformData *POutputWaveformData;
	TCWaveformData		  CWaveformData;

// Dialog Data
	//{{AFX_DATA(TCWaveformOptionsPropPage)
	enum { IDD = IDD_PROPP_WAVEFORM_INFO };
	int		m_num_digits_displayed;
	int		m_resolution;
	int		m_auto_axis;
	int		m_x_manual_major_grid_number;
	int		m_y_manual_major_grid_number;
	int		m_y_manual_phase_major_grid_number;
	int		m_x_manual_minor_grid_number;
	int		m_y_manual_minor_grid_number;
	int		m_y_manual_phase_minor_grid_number;
	BOOL	m_enable_quantisation;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCWaveformOptionsPropPage)
	public:
	virtual BOOL OnKillActive();
	virtual BOOL OnSetActive();
	virtual void OnOK();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCWaveformOptionsPropPage)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};


/////////////////////////////////////////////////////////////////////////////
// TCWaveformPropGraphSetup dialog

class TCWaveformPropGraphSetup : public CPropertyPage
{
	DECLARE_DYNCREATE(TCWaveformPropGraphSetup)

// Construction
public:
	TCWaveformPropGraphSetup();
	~TCWaveformPropGraphSetup();

	void SetDisplay(void);
	void GetDisplay(void);
	void SetButtons(void);
	void SetAxisButtons(void);

	void EnableCalculator(int enable);

	TCSchematicObjectData *PCSchematicObjectData;
	TCOutputWaveformData*POutputWaveformData;

// Dialog Data
	//{{AFX_DATA(TCWaveformPropGraphSetup)
	enum { IDD = IDD_PROPP_WAVEFORM_GRAPH };
	CEdit	CMEditYPhaseDivision;
	CEdit	CMEditXMagDivision;
	CEdit	CMEditYMagDivision;
	CButton	CMCheckMultyPhase;
	CButton	CMButtonAutoPhase;
	CEdit	EMEditPhaseMin;
	CEdit	EMEditPhaseMax;
	CEdit	CMEditYMin;
	CEdit	CMEditYMax;
	CEdit	CMEditXMin;
	CEdit	CMEditXMax;
	CButton	CMButtonDC;
	CButton	CMButtonAC;
	CButton	CMButtonSpectralNoise;
	CButton	CMButtonPoleZero;
	CButton	CMButtonTransient;
	CButton	CMButtonFourier;
	CButton	CMButtonTHD;
	CButton	CMButtonIMD;
	CButton	CMButtonF2;
	CButton	CMButtonSensitivity;
	CButton CMButtonFFT;
	CButton CMButtonIFFT;
	TCColorListBox	CMListGridColour;
	TCColorListBox	CMListBackgroundColour;
	int		m_xaxis_linear;
	int		m_waveform_type;
	double	m_x_max;
	double	m_x_min;
	double	m_y_max;
	double	m_y_min;
	int		m_x_auto;
	int		m_y_auto;
	int		m_yaxis_linear;
	BOOL	m_multy_magnitude;
	BOOL	m_multy_phase;
	double	m_phase_max;
	double	m_phase_min;
	int		m_phase_axis_lin;
	int		m_phase_auto;
	double	m_ymag_div;
	double	m_yphase_div;
	double	m_xmag_div;
	BOOL	m_check_intelegent_signal_default;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCWaveformPropGraphSetup)
	public:
	virtual BOOL OnKillActive();
	virtual BOOL OnSetActive();
	virtual void WinHelp(DWORD dwData, UINT nCmd = HELP_CONTEXT);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCWaveformPropGraphSetup)
	virtual BOOL OnInitDialog();
	afx_msg void OnRadioFourier();
	afx_msg void OnRadioImd();
	afx_msg void OnRadioIntrgratedNoise();
	afx_msg void OnRadioPoleZero();
	afx_msg void OnRadioSensitivity();
	afx_msg void OnRadioSpectralNoise();
	afx_msg void OnRadioThd();
	afx_msg void OnRadioTransient();
	afx_msg void OnRadioWaveformType();
	afx_msg void OnRadioAc();
	afx_msg void OnSelchangeListBackgroundColour();
	afx_msg void OnSelchangeListGridColour();
	afx_msg void OnRadioAutoXAxis();
	afx_msg void OnRadioAutoXManual();
	afx_msg void OnRadioAutoYAxis();
	afx_msg void OnRadioAutoYAxisManual();
	afx_msg void OnRadioAutoPhaseAxis();
	afx_msg void OnRadioAutoPhaseAxisManual();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void OnRadioXaxisLin();
	afx_msg void OnRadioXaxisLog();
	afx_msg void OnRadioImd2();
	afx_msg void OnRadioCalculator();
	afx_msg void OnRadioTranToFreq();
	afx_msg void OnRadioAcToTimr();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};


/////////////////////////////////////////////////////////////////////////////
// TCWaveformPropSignalSetup dialog

class TCOutputWaveformData;

class TCWaveformPropSignalSetup : public CPropertyPage
{
	DECLARE_DYNCREATE(TCWaveformPropSignalSetup)

// Construction
public:
	TCWaveformPropSignalSetup();
	~TCWaveformPropSignalSetup();

	TCSchematicObjectData *PCSchematicObjectData;
	TCOutputWaveformData  *POutputWaveformData;

	void SetDisplay(void);
	void GetDisplay(void);
	void LoadSignalList(void);
	void LoadRunList(void);

	CButton	CMRadioRealAndImaginary;
// Dialog Data
	//{{AFX_DATA(TCWaveformPropSignalSetup)
	enum { IDD = IDD_PROPP_WAVEFORM_SIGNALS };
	CButton	CMCheckRunSelected;
	CComboBox	CMComboSpiceRuns;
	CEdit	CMEditPhaseOffset;
	CEdit	CMEditPhaseGain;
	TCColorListBox	CMPhaseColour;
	CButton	CMCheckMagnitude;
	CButton	CMCheckDBMagnitude;
	CButton	CMCheckDegrees;
	CButton	CMCheckRadians;
	TCColorListBox	CMSignalColour;
	CComboBox	CMComboSignals;
	double	m_xgain;
	double	m_xoffset;
	double	m_ygain;
	double	m_yoffset;
	CString	CMComboSignalSelected;
	BOOL	m_phase;
	BOOL	m_radians;
	BOOL	m_magnitude;
	BOOL	m_db_magnitude;
	double	m_y_phase_gain;
	double	m_y_phase_offset;
	BOOL	m_use_as_x_axis;
	CString	CMComboStringSpiceRuns;
	BOOL	m_run_selected;
	int		m_real_and_imaginary;
	int		m_phase_axis;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCWaveformPropSignalSetup)
	public:
	virtual BOOL OnKillActive();
	virtual BOOL OnSetActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCWaveformPropSignalSetup)
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangeComboSignals();
	afx_msg void OnSelchangeListSignalColour();
	afx_msg void OnKillfocusListSignalColour();
	afx_msg void OnCheckDegrees();
	afx_msg void OnCheckRadians();
	afx_msg void OnCheckMagnitude();
	afx_msg void OnCheckdbMagnitude();
	afx_msg void OnSelchangeListSignalPhaseColour();
	afx_msg void OnCheckUseAsXaxis();
	afx_msg void OnSelchangeComboSpiceRuns();
	afx_msg void OnButtonRemoveAll();
	afx_msg void OnButtonselectAllRuns();
	afx_msg void OnButtonClearAllSignals();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};



#endif // __TCWAVEFORMPROPPAGES_H__
