// TCWirePropertiesDlg.cpp : implementation file
//

#include "stdafx.h"
#include "afxpriv.h"
#include "resource.h"
#include "TCMKSConvert.h"
#include "TESuperSpiceLabelEnums.h"
#include "SuperSpice.h"
#include "TCWirePropertiesDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// TCWirePropertiesDlg dialog


TCWirePropertiesDlg::TCWirePropertiesDlg(CWnd* pParent /*=NULL*/)
	: CDialog(TCWirePropertiesDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(TCWirePropertiesDlg)
	CMEditNetName = _T("");
	m_net_name_visable = FALSE;
	m_net_voltage_visable = FALSE;
	CMEditNetVoltage = _T("");
	//}}AFX_DATA_INIT
}


void TCWirePropertiesDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCWirePropertiesDlg)
	DDX_Text(pDX, IDC_EDIT_NET_NAME, CMEditNetName);
	DDX_Check(pDX, IDC_CHECK_NET_NAME_VISABLE, m_net_name_visable);
	DDX_Check(pDX, IDC_CHECK_NET_VOLTAGE_VISABLE, m_net_voltage_visable);
	DDX_Text(pDX, IDC_EDIT_NET_VOLTAGE, CMEditNetVoltage);
	DDX_MKSValue(pDX, IDC_EDIT_DESIGNER_VOLTAGE, m_designer_voltage);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCWirePropertiesDlg, CDialog)
	//{{AFX_MSG_MAP(TCWirePropertiesDlg)
	ON_BN_CLICKED(IDHELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCWirePropertiesDlg message handlers
TCSchematicObjectData &TCWirePropertiesDlg::GetData(void)
{
	return CMSchematicObjectData;
}
void TCWirePropertiesDlg::SetData(TCSchematicObjectData &CSchematicObjectData)
{
	CMSchematicObjectData = CSchematicObjectData;

	m_net_name_visable = CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].is_visable;
	CMEditNetName =  CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel;

	m_net_voltage_visable = CMSchematicObjectData.CLabelListData[E_WIRE_NET_VOLTAGE].is_visable;
	CMEditNetVoltage = CMSchematicObjectData.CLabelListData[E_WIRE_NET_VOLTAGE].CLabel;

	m_designer_voltage = (double) CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_DESIGNER_VALUE];
}

void TCWirePropertiesDlg::OnOK() 
{
	CDialog::OnOK();

	CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].is_visable = !!m_net_name_visable;
	CMSchematicObjectData.CLabelListData[E_WIRE_NET_NAME].CLabel = CMEditNetName;

	CMSchematicObjectData.CLabelListData[E_WIRE_NET_VOLTAGE].is_visable = !!m_net_voltage_visable;
	CMEditNetVoltage = CMSchematicObjectData.CLabelListData[E_WIRE_NET_VOLTAGE].CLabel = CMEditNetVoltage;

	CMSchematicObjectData.CReserved.CIntArray[E_RESERVED_INT_DESIGNER_VALUE] = (float) m_designer_voltage;
}
		
void TCWirePropertiesDlg::OnHelp() 
{
	DWORD dwData;

	dwData = HID_BASE_RESOURCE + IDD_WIRE_PROPERTIES;

	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp*) AfxGetMainWnd();

	PCSuperSpiceApp->DialogHelp(dwData);	
}
