// TCWordConvert.cpp: implementation of the TCWordConvert class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TCWordConvert.h"
 
#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

CString RemoveFirstWord(CString);

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
int CountCharacters(CString CText, char character)
{
	int count = 0;

	int length = CText.GetLength();

	if(!length) return 0;

	char *buff = CText.GetBuffer(length + 1);

	if(!buff) return 0;

	while(*buff != 0)
	{
		if(*buff++ == character) count++;
	}

	return count;
}

int CountWords(CString CText)
{
	int p = 1;

	CText.TrimLeft();
	CText.TrimRight();

	if(CText == "") return 0;

	while((CText = RemoveFirstWord(CText)) != "")
	{
		p++;
	}

	return p;
}

char **NewCharArray(int n, int size)
{
	char **array;

	if(!n || !size) return NULL;

	array = new char*[n];

	if(!array) return NULL;

	for(int p = 0; p < n; p++)
	{
		array[p] = new char[size];

		*array[p] = 0;

		if(!array[p])
		{
			for(int q = 0; q < p -1; q++) delete [] array[q];

			delete [] array;

			return NULL;
		}
	}

	return array;
}
void DeleteCharArray(char **array, int n)
{
	if(!array) return;

	for(int p = 0; p < n; p++)
	{
		if(array[p]) delete [] array[p];
	}

	delete [] array;
}

// This function extracte words from a line.
// The input is an array of char strings. The first
// Array element is the full line. Each word found
// in the line will be placed in each array position
// The remaining part of the line will be ignored
// the last string if not enough words allocated.
// = ( and ) are treated as white space

bool ExtractSpiceModelWords(char **line_in, int num_strings)
{
	if(!line_in) return false;

	if(!num_strings) return false;

	char	*words;
	char 	*chars;
	char	**line;
	int  	is_string = false;

	chars = line_in[0]; // Scans the line for chars
	line	= line_in;

	line++;

	while(*chars == '\t' || *chars == ' ')
	{
		chars++; // look for first non white space char
	}

	for(int p = 0; p < num_strings - 1; p++) // stuff all but last array with single word
	{
		words	= *line++;

		if(!is_string)// read as normal
		{
			while(*chars != ')' && *chars != '(' && *chars != '=' && *chars != '\t' && *chars != ' ' && *chars != 0) // white space
			{
				*words++ = *chars++;
			}
		}
		else //ignore white space, look for the ']' or '}', and line end if error 
		{ 
			while(*chars != ']' && *chars != '}' && *chars != '\"' && *chars != 0) // white space
			{
				*words++ = *chars++;
			}

			if(is_string == 1)
				*words++ = ']';// make sure properly terminated
			else if(is_string == 2)
				*words++ = '}';
			else if(is_string == 3)
				*words++ = '\"';

			is_string = false;// reset to start looking for next parameter name
		}

		*words = 0;  // Null terminate each word

		if(!is_string)
			while(*chars == '(' || *chars == ')' || *chars == '=' || *chars == '\t' || *chars == ' ' || *chars == ']' || *chars == '}' || *chars == '\"') chars++;
		else
			while(*chars == '=' || *chars == '\t' || *chars == ' ' || *chars == ']' || *chars == '}' || *chars == '\"' ) chars++;

		if(*chars == '[')//
		{
			is_string = 1;// read string format
		}
		else if(*chars == '{')
		{
			is_string = 2;// read string format
		}
		else if(*chars == '\"')
		{
			is_string = 3;// read string format
		}
		else
			is_string = 0; // read as nornal
	}

	words	= *line;
	
	if(is_string) //modified for wc/mc Nov 1st 2014 to support {sqrt() } ) without ) terminating
	{
		while(*chars && *chars > 0 && *chars != '}' && *chars != ']' && *chars != '\"' && *chars != '\'' ) 
		{
			*words++ = *chars++; // stuff remaining words
		}
	}
// modified for xspice support, small amout of error helping
	while(*chars && *chars > 0 && *chars != ')' && *chars != '(')  // Look for final null terminater or white space
	{
		*words++ = *chars++; // stuff remaining words
	}
	
	*words = 0;

	return true;
}

/////////
bool ExtractWords(char **line_in, int num_strings)
{
	if(!line_in) return false;

	if(!num_strings) return false;

	char	*words;
	char 	*chars;
	char	**line;

	chars = line_in[0]; // Scans the line for chars
	line	= line_in;

	line++;

	while(*chars == '\t' || *chars == ' ')
	{
		chars++; // look for first non white space char
	}

	for(int p = 0; p < num_strings - 1; p++) // stuff all but last array with single word
	{
		words	= *line++;

		while(*chars != '\t' && *chars != ' ' && *chars != 0) // white space
		{
			*words++ = *chars++;
		}

		*words = 0;  // Null terminate each word
		
		while(*chars == '\t' || *chars == ' ')
		{
			chars++; // look for next non white space char
		}
	
	}

	words	= *line;
	
	while(*chars) 					// Look for final null terminater
	{
		*words++ = *chars++;	// stuff remaining words
	}

	return true;
}


// This version of the above treats a second word "="
// as a white space delimiter as does a MS Windows ini file read

bool ExtractIniWords(char **line_in)
{
	if(!line_in) return false;

	char	*words;
	char 	*chars;
	char	**line;

	chars = line_in[0]; // Scans the line for chars
	line	= line_in;

	line++;

	while(*chars == '\t' || *chars == ' ')
	{
		chars++; // look for first non white space char
	}
	
	words	= *line++;

	while(*chars != '=' && *chars != '\t' && *chars != ' ' && *chars != 0) // white space
	{
		*words++ = *chars++;
	}

	*words = 0;  // Null terminate each word

	while(*chars == '=' || *chars == '\t' || *chars == ' ')
	{
		chars++; // look for next non white space char
	}


	words	= *line;
	
	while(*chars) 					// Look for final null terminater
	{
		*words++ = *chars++;	// stuff remaining words
	}

	return true;
}

TCWordConvert::TCWordConvert()
{

}

TCWordConvert::~TCWordConvert()
{

}
