#include "stdafx.h"
#include "TCWorkspaceTree.h"



#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern int	g_last_open_file_tree_tab;

HTREEITEM InsertTreeItem(CTreeCtrl * ctrl,LPCTSTR txt,int imgind,int selimgind, int id)
{
	ASSERT(ctrl);

	if(!ctrl) return NULL;

	TV_INSERTSTRUCT  TreeCtrlItem;
	::ZeroMemory(&TreeCtrlItem, sizeof(TV_INSERTSTRUCT));

	TreeCtrlItem.hParent = TVI_ROOT;
	TreeCtrlItem.hInsertAfter = TVI_LAST;
	TreeCtrlItem.item.mask = TVIF_IMAGE | TVIF_PARAM | TVIF_SELECTEDIMAGE | TVIF_TEXT;

	TreeCtrlItem.item.iImage = imgind;
	TreeCtrlItem.item.iSelectedImage = selimgind;
	TreeCtrlItem.item.lParam = (long) id;
	TreeCtrlItem.item.pszText = (LPTSTR)txt;
	
	HTREEITEM hTreeItem = ctrl->InsertItem(&TreeCtrlItem);

	return(hTreeItem);
}

HTREEITEM InsertTreeItem(CTreeCtrl * ctrl,HTREEITEM hTreeItem, LPCTSTR txt,int imgind,int selimgind, int id)
{
	ASSERT(ctrl);

	if(!ctrl) return NULL;
	
	TV_INSERTSTRUCT  TreeCtrlItem;  	
	::ZeroMemory(&TreeCtrlItem, sizeof(TV_INSERTSTRUCT));

	TreeCtrlItem.hParent = hTreeItem;
	TreeCtrlItem.hInsertAfter = TVI_LAST;
	TreeCtrlItem.item.mask = TVIF_IMAGE | TVIF_PARAM | TVIF_SELECTEDIMAGE | TVIF_TEXT;
	TreeCtrlItem.item.lParam = (long) id;
	TreeCtrlItem.item.iImage = imgind;
	TreeCtrlItem.item.iSelectedImage = selimgind;
	TreeCtrlItem.item.pszText = (LPTSTR)txt;

	return ctrl->InsertItem(&TreeCtrlItem);
}


TCWorkspaceTree::TCWorkspaceTree(void)
{
	f_inhibit_all = false;

	PCMModelTreeDoc = NULL;
	PCMSymbolTreeDoc= NULL;
	PCMFileTreeDoc	= NULL;
	PCMCircuitsTreeDoc = NULL;
	PCMSignalsTreeDoc = NULL;
}

TCWorkspaceTree::~TCWorkspaceTree(void)
{

}

void TCWorkspaceTree::Refresh(void)
{
	if(PCMModelTreeDoc) PCMModelTreeDoc->Refresh();
	if(PCMSymbolTreeDoc) PCMSymbolTreeDoc->Refresh();
	if(PCMFileTreeDoc) PCMFileTreeDoc->Refresh();
	if(PCMCircuitsTreeDoc) PCMCircuitsTreeDoc->Refresh();
}

void TCWorkspaceTree::RefreshSymbolFiles(void)
{
	if(PCMSymbolTreeDoc) PCMSymbolTreeDoc->Refresh();
}

void TCWorkspaceTree::RefreshCircuitsFiles(void)
{
	if(PCMCircuitsTreeDoc) PCMCircuitsTreeDoc->Refresh();
}

void TCWorkspaceTree::RefreshSchematicFiles(void)
{
	if(PCMFileTreeDoc) PCMFileTreeDoc->Refresh();
}

void TCWorkspaceTree::RefreshModelFiles(void)
{
	if(PCMModelTreeDoc) PCMModelTreeDoc->Refresh();
}

void TCWorkspaceTree::SelectSymbol(void)
{	
	if(PCMModelTreeDoc) PCMModelTreeDoc->SelectSymbol();
}

void TCWorkspaceTree::SelectModel(void)
{	
	if(PCMSymbolTreeDoc) PCMSymbolTreeDoc->SelectModel();
}

bool TCWorkspaceTree::RemoveModel(HTREEITEM HItem)
{
	if(f_inhibit_all) return true;

	if(IsBadCodePtr((FARPROC) HItem)) return false;

	if(PCMModelTreeDoc) return PCMModelTreeDoc->Remove(HItem);

	return false;
}

bool TCWorkspaceTree::AddModel(CString CFileName, int model_index)
{
	if(f_inhibit_all) return true;

	if(PCMModelTreeDoc) return PCMModelTreeDoc->Add(CFileName, model_index);

	return false;
}

bool TCWorkspaceTree::AddModelFile(int model_file_index)
{
	if(f_inhibit_all) return true;

	if(PCMModelTreeDoc) return PCMModelTreeDoc->AddFile(model_file_index);

	return false;
}

bool TCWorkspaceTree::RemoveSymbol(HTREEITEM HItem)
{
	if(f_inhibit_all) return true;

	if(IsBadCodePtr((FARPROC) HItem)) return false;

	if(PCMSymbolTreeDoc) return PCMSymbolTreeDoc->Remove(HItem);

	return false;
}

bool TCWorkspaceTree::AddSymbol(CString CFileName, int symbol_index)
{
	if(f_inhibit_all) return true;

	if(PCMSymbolTreeDoc) return PCMSymbolTreeDoc->Add(CFileName, symbol_index);

	return false;
}

bool TCWorkspaceTree::AddSymbolFile(int symbol_file_index)
{
	if(f_inhibit_all) return true;

	if(PCMSymbolTreeDoc) return PCMSymbolTreeDoc->AddFile(symbol_file_index);

	return false;
}

void TCWorkspaceTree::AddModelFile(void)
{
	if(PCMModelTreeDoc) PCMModelTreeDoc->AddModelFile();
}

void TCWorkspaceTree::AddSymbolFile(void)
{
	if(PCMSymbolTreeDoc) PCMSymbolTreeDoc->AddSymbolFile();
}

void TCWorkspaceTree::RenameModel(HTREEITEM HItem, CString CName)
{
	if(PCMModelTreeDoc) PCMModelTreeDoc->Rename(HItem, CName);
}

void TCWorkspaceTree::RenameSymbol(HTREEITEM HItem, CString CName)
{
	if(PCMSymbolTreeDoc) PCMSymbolTreeDoc->Rename(HItem, CName);
}

void TCWorkspaceTree::EditSymbol(void)
{
	if(PCMSymbolTreeDoc) PCMSymbolTreeDoc->Edit();
}

void TCWorkspaceTree::EditModel(void)
{
	if(PCMModelTreeDoc) PCMModelTreeDoc->EditModelFile();
}

void TCWorkspaceTree::NewSymbolFile(void)
{
	if(PCMSymbolTreeDoc) PCMSymbolTreeDoc->NewSymbolFile();
}

void TCWorkspaceTree::NewSymbol(void)
{
	if(PCMSymbolTreeDoc) PCMSymbolTreeDoc->NewSymbol();
}

void TCWorkspaceTree::NewModelFile(void)
{
}

void TCWorkspaceTree::NewModel(void)
{
}

void TCWorkspaceTree::UpdateAllData(void)
{
	if(PCMModelTreeDoc)		PCMModelTreeDoc->UpdateAllData();
	if(PCMSymbolTreeDoc)	PCMSymbolTreeDoc->UpdateAllData();
	if(PCMCircuitsTreeDoc)	PCMCircuitsTreeDoc->Refresh();
	if(PCMSignalsTreeDoc)   PCMSignalsTreeDoc->UpdateAllData();
}

bool TCWorkspaceTree::AddSchematicFile(TCSuperSpiceDoc *PCDoc, CString CFileName)
{
	if(PCMFileTreeDoc) 
	{
		return PCMFileTreeDoc->AddSchematicFile(PCDoc, CFileName);
	}

	return false;
}

bool TCWorkspaceTree::AddSchematicFileFolder(TCSuperSpiceDoc *PCDoc, CString CFileName)
{
	if(PCMFileTreeDoc) 
	{
		return PCMFileTreeDoc->AddSchematicFileFolder(PCDoc, CFileName);
	}

	return false;
}

bool TCWorkspaceTree::AddCircuitsFolder(int index)
{
	if(PCMCircuitsTreeDoc) 
	{
		return PCMCircuitsTreeDoc->AddCircuitsFolder(index);
	}

	return false;
}

void TCWorkspaceTree::UpdateAllSchematicData(void)
{
	if(PCMFileTreeDoc) PCMFileTreeDoc->UpdateAllData();
}

void TCWorkspaceTree::Remove(TCSuperSpiceDoc *PCDoc)
{
	if(PCMFileTreeDoc) PCMFileTreeDoc->Remove(PCDoc);
}

void TCWorkspaceTree::Remove(HTREEITEM HItem)
{
	if(PCMFileTreeDoc) PCMFileTreeDoc->Remove(HItem);
}

bool TCWorkspaceTree::IsDragging(void)
{
	if(PCMSymbolTreeDoc)if(PCMSymbolTreeDoc->IsDragging()) return true;
	if(PCMModelTreeDoc)if(PCMModelTreeDoc->IsDragging()) return true;
	if(PCMCircuitsTreeDoc) if(PCMCircuitsTreeDoc->IsDragging()) return true;

	return false;
}

bool TCWorkspaceTree::PlaceDragedSymbol(void)
{
	if(PCMSymbolTreeDoc) if(PCMSymbolTreeDoc->IsDragging()) if(PCMSymbolTreeDoc->PlaceDragedSymbol()) return true;
	if(PCMModelTreeDoc) if(PCMModelTreeDoc->IsDragging()) if(PCMModelTreeDoc->PlaceDragedSymbol()) return true;
	if(PCMCircuitsTreeDoc) if(PCMCircuitsTreeDoc->IsDragging()) if(PCMCircuitsTreeDoc->PlaceDragedSymbol()) return true;

	return false;
}

void TCWorkspaceTree::ClearDragging(void)
{
	if(PCMSymbolTreeDoc) PCMSymbolTreeDoc->ClearDragging();
	if(PCMModelTreeDoc) PCMModelTreeDoc->ClearDragging();
	if(PCMCircuitsTreeDoc)PCMCircuitsTreeDoc->ClearDragging();
}

bool TCWorkspaceTree::PlaceModel(void)
{
	if(!PCMModelTreeDoc) return false;

	return PCMModelTreeDoc->PlaceModel();
}

void TCWorkspaceTree::SelectModel(HTREEITEM hitem)
{
	if(!PCMModelTreeDoc) return;

	PCMModelTreeDoc->SelectModel(hitem);
}

void TCWorkspaceTree::SelectSymbol(HTREEITEM hitem)
{
	hitem;
}

void TCWorkspaceTree::LoadSignalsList(TCWaveformDataRuns *PCWaveformRuns, int waveform_type)
{
	if(PCMSignalsTreeDoc)  PCMSignalsTreeDoc->LoadSignalsList(PCWaveformRuns, waveform_type);
}