#ifndef TCWorkspaceTree_H
#define TCWorkspaceTree_H

#include "TCNumberStack.h"
#include "TCSuperSpiceDataBase.h"

#include "TCModelTreeDoc.h"
#include "TCSymbolTreeDoc.h"
#include "TCFileTreeDoc.h"
#include "TCModelTreeView.h"
#include "TCSymbolTreeView.h"
#include "TCFileTreeView.h"
#include "TCCircuitsTreeDoc.h"
#include "TCCircuitsTreeView.h"
#include "TCSignalsTreeDoc.h"
#include "TCSignalsTreeView.h"

class TCWorkspaceTree : public CObject
{
	public:	TCWorkspaceTree(void);
			
			~TCWorkspaceTree(void);

	TCModelTreeDoc	*PCMModelTreeDoc;
	TCSymbolTreeDoc *PCMSymbolTreeDoc;
	TCFileTreeDoc	*PCMFileTreeDoc;
	TCCircuitsTreeDoc *PCMCircuitsTreeDoc;
	TCSignalsTreeDoc *PCMSignalsTreeDoc;

	TCDataBaseClipboard			CMDataBaseClipboard;

	void UpdateAllData(void);
	bool RemoveModel(HTREEITEM HItem);
	bool AddModel(CString CFileName, int model_index);
	bool AddModelFile(int model_file_index);
	bool RemoveSymbol(HTREEITEM HItem);
	bool AddSymbol(CString CFileName, int symbol_index);
	bool AddSymbolFile(int symbol_file_index);
	void RenameModel(HTREEITEM HItem, CString CName);
	void RenameSymbol(HTREEITEM HItem, CString CName);

	bool AddSchematicFile(TCSuperSpiceDoc *PCDoc, CString CFileName);
	bool AddSchematicFileFolder(TCSuperSpiceDoc *PCDoc, CString CFileName);

	bool AddCircuitsFolder(int index);
	
	void UpdateAllSchematicData(void);
	void Remove(HTREEITEM HItem);
	void Remove(TCSuperSpiceDoc *PCDoc);
	void RefreshSchematicFiles(void);
	void RefreshModelFiles(void);
	void RefreshSymbolFiles(void);
	void RefreshCircuitsFiles(void);

	void Refresh(void);
	void SelectSymbol(void);
	void SelectModel(void);
	void NewSymbolFile(void);
	void NewModel(void);
	void NewSymbol(void);
	void NewModelFile(void);
	void EditModel(void);
	void EditSymbol(void);
	void AddSymbolFile(void);
	void AddModelFile(void);
	void EditRename(void);
	void SelectModel(HTREEITEM hitem);
	void SelectSymbol(HTREEITEM hitem);

	bool f_inhibit_all;

	bool IsDragging(void);
	bool PlaceDragedSymbol(void);
	bool PlaceModel(void);
	void ClearDragging(void);
	void LoadSignalsList(TCWaveformDataRuns *PCWaveformRuns, int waveform_type);
};


#endif