#include "stdafx.h"
#include "math.h"
#include "TDVersion.h"
#include "TCXYArray.h"
#include "TCMKSConvert.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL(TCXYArray, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCXYArrayList, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCXArray, CObject, ID_VERSION_NUMBER)


TCXArray::TCXArray(void)
{
	m_last_index		= 0;
	positive_derivative = true;
	m_last_value		= 1.0;
	stop_point			= 0;
	CX.SetSize(0);
}

TCXArray::TCXArray(TCXArray &CXArray)
{
	*this = CXArray;
}

TCXArray::~TCXArray(void)
{

}

void TCXArray::Zero(void)
{
	int p, count;

	count = CX.GetSize();

	for(p = 0; p < count; p++) CX[p] = 0.0;

	m_last_index = 0;
	m_last_value = 0 ;
	positive_derivative = true;
	stop_point = 0;
}

void TCXArray::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	int count, p;

	if(CArchiveFile.IsStoring())
	{
		count = CX.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CArchiveFile << CX[p];
	}
	else
	{
		CArchiveFile >> count;

		CX.SetSize(count, count);

		for(p = 0; p < count; p++) CArchiveFile >> CX[p];
	}
}

void TCXArray::operator = (TCXArray &CXArray)
{
	int p, count;

	count = CXArray.CX.GetSize();

	CX.SetSize(count);

	for(p = 0; p < count; p++) CX[p] = CXArray.CX[p];

	m_last_index = CXArray.m_last_index;
	m_last_value = CXArray.m_last_value;
	positive_derivative = CXArray.positive_derivative;
	stop_point = CXArray.stop_point;
}

TCXArray TCXArray::operator + (TCXArray &CXArray)
{
	TCXArray CXArrayReturned;

	int p, count, count_this;

	count = CXArray.CX.GetSize();

	count_this = CX.GetSize();

	if(count_this != count) return CXArrayReturned;

	CXArrayReturned.CX.SetSize(count);

	for(p = 0; p < count; p++) CXArrayReturned.CX[p] = CX[p] + CXArray.CX[p];

	return CXArrayReturned;
}

TCXArray TCXArray::operator - (TCXArray &CXArray)
{
	TCXArray CXArrayReturned;

	int p, count, count_this;

	count = CXArray.CX.GetSize();

	count_this = CX.GetSize();

	if(count_this != count) return CXArrayReturned;

	CXArrayReturned.CX.SetSize(count);

	for(p = 0; p < count; p++) CXArrayReturned.CX[p] = CX[p] - CXArray.CX[p];
	return CXArrayReturned;
}
TCXArray TCXArray::operator * (TCXArray &CXArray)
{
	TCXArray CXArrayReturned;

	int p, count, count_this;

	count = CXArray.CX.GetSize();

	count_this = CX.GetSize();

	if(count_this != count) return CXArrayReturned;

	CXArrayReturned.CX.SetSize(count);

	for(p = 0; p < count; p++) CXArrayReturned.CX[p] = CX[p] * CXArray.CX[p];

	return CXArrayReturned;
}

TCXArray TCXArray::operator / (TCXArray &CXArray)
{
	TCXArray CXArrayReturned;

	int p, count, count_this;

	count = CXArray.CX.GetSize();

	count_this = CX.GetSize();

	if(count_this != count) return CXArrayReturned;

	CXArrayReturned.CX.SetSize(count);

	double check;
	double data;

	for(p = 0; p < count; p++) 
	{
		check	= CXArray.CX[p];
		data	= CX[p];

		if(!check && !data) //0/0
		{
			CXArrayReturned.CX[p] = 1; // let 0/0 = 1

			continue;
		}
			
		if(!check)//x/0
		{
			if(data < 0) CXArrayReturned.CX[p] = -1e37;
			else CXArrayReturned.CX[p] = 1e37;

			continue;
		}
		
		CXArrayReturned.CX[p] = data / check;
	}

	return CXArrayReturned;
}

TCXArray TCXArray::operator ^ (TCXArray &CXArray)
{
	TCXArray CXArrayReturned;
	int p, count, count_this;

	count = CXArray.CX.GetSize();

	count_this = CX.GetSize();

	if(count_this != count) return CXArrayReturned;

	CXArrayReturned.CX.SetSize(count);

	for(p = 0; p < count; p++) 
	{
		CXArrayReturned.CX[p] =  pow(CX[p], CXArray.CX[p]);
	}

	return CXArrayReturned;
}
//////


TCXArray TCXArray::operator * (double data)
{
	TCXArray CXArrayReturned;

	int p, count;

	count = CX.GetSize();

	CXArrayReturned.CX.SetSize(count);

	for(p = 0; p < count; p++) CXArrayReturned.CX[p] = CX[p] * data;

	return CXArrayReturned;
}

TCXArray TCXArray::operator / (double ddata)
{
	TCXArray CXArrayReturned;

	int p, count;

	count = CX.GetSize();

	CXArrayReturned.CX.SetSize(count);

	double check;
	double data;

	for(p = 0; p < count; p++) 
	{
		check	= ddata;
		data	= CX[p];

		if(!check && !data) //0/0
		{
			CXArrayReturned.CX[p] = 1; // let 0/0 = 1

			continue;
		}
			
		if(!check)//x/0
		{
			if(data < 0) CXArrayReturned.CX[p] = -1e37;
			else CXArrayReturned.CX[p] = 1e37;

			continue;
		}
		
		CXArrayReturned.CX[p] = data / check;
	}

	return CXArrayReturned;
}

TCXArray TCXArray::operator ^ (double data)
{
	TCXArray CXArrayReturned;

	int p, count;

	count = CX.GetSize();

	CXArrayReturned.CX.SetSize(count);

	for(p = 0; p < count; p++) 
	{
		CXArrayReturned.CX[p] =  pow(CX[p], data);
	}

	return CXArrayReturned;
}

TCXArray TCXArray::Sqrt(void)
{
	TCXArray CXArrayReturned;

	int p, count;

	count = CX.GetSize();

	double data;

	CXArrayReturned.CX.SetSize(count);

	for(p = 0; p < count; p++) 
	{
		data = CX[p];

		if(data < 0) data = -data;

		CXArrayReturned.CX[p] =  sqrt(data);
	}

	return CXArrayReturned;
}

TCXArray TCXArray::Sin(void)
{
	TCXArray CXArrayReturned;

	int p, count;

	count = CX.GetSize();

	CXArrayReturned.CX.SetSize(count);

	for(p = 0; p < count; p++) 
	{
		CXArrayReturned.CX[p] =  sin(CX[p]);
	}

	return CXArrayReturned;
}
TCXArray TCXArray::Cos(void)
{
	TCXArray CXArrayReturned;

	int p, count;

	count = CX.GetSize();

	CXArrayReturned.CX.SetSize(count);

	for(p = 0; p < count; p++) 
	{
		CXArrayReturned.CX[p] =  cos(CX[p]);
	}

	return CXArrayReturned;
}
TCXArray TCXArray::Log10(void)
{
	TCXArray CXArrayReturned;

	int p, count;

	count = CX.GetSize();

	CXArrayReturned.CX.SetSize(count);

	for(p = 0; p < count; p++) 
	{
		CXArrayReturned.CX[p] =  Log(CX[p]);
	}

	return CXArrayReturned;
}
TCXArray TCXArray::DB20Log10(void)
{
	TCXArray CXArrayReturned;

	int p, count;

	count = CX.GetSize();

	CXArrayReturned.CX.SetSize(count);

	for(p = 0; p < count; p++) 
	{
		CXArrayReturned.CX[p] =  20*Log(CX[p]);
	}

	return CXArrayReturned;
}
TCXArray TCXArray::DB10Log(void)
{
	TCXArray CXArrayReturned;

	int p, count;

	count = CX.GetSize();

	CXArrayReturned.CX.SetSize(count);

	for(p = 0; p < count; p++) 
	{
		CXArrayReturned.CX[p] =  10*Log(CX[p]);
	}

	return CXArrayReturned;
}

TCXArray TCXArray::Derivative(TCXArray &CArrayXVariable)
{
	TCXArray CXArrayReturned;
	int p, count, count_this;
	double dx, dy;

	count = CArrayXVariable.CX.GetSize();

	count_this = CX.GetSize();

	if(count_this != count) return CXArrayReturned;

	if(!(count > 2)) return CXArrayReturned;

	CXArrayReturned.CX.SetSize(count);

	double last, next;

	last = CX[0];

	for(p = 1; p < count; p++) 
	{
		dx = CArrayXVariable.CX[p] - CArrayXVariable.CX[p - 1];

		if(!dx) continue;

		next = CX[p];

		dy = next - last;

		last = next;

		CXArrayReturned.CX[p] =  dy/dx;
	}

	CXArrayReturned.CX[0] = CXArrayReturned.CX[1];

	return CXArrayReturned;
}

double TCXArray::AVG(TCXArray &CArrayXVariable, double start, double end)
{
	int count = CArrayXVariable.CX.GetSize();

	if(!(count > 1)) return 0;

	if(!end) end = CArrayXVariable.CX[count - 1];

	if(start == end) return 0;

	return Integral(CArrayXVariable, start, end) / (end - start);
}

double TCXArray::Integral(TCXArray &CArrayXVariable, double start, double end)
{
	int p, count, count_this;
	double integral = 0;
	double x_last_value, x_next_value;

	count = CArrayXVariable.CX.GetSize();

	if(!(count > 1)) return integral;

	count_this = CX.GetSize();

	if(count_this != count) return integral;

	x_last_value = CArrayXVariable.CX[0];

	if(!end) end = CArrayXVariable.CX[count - 1];

	for(p = 1; p < count; p++) 
	{
		x_next_value = CArrayXVariable.CX[p];

		if(x_next_value < start) 
		{
			x_last_value = x_next_value;

			continue;
		}

		if(x_next_value > end) break;

		integral += CX[p] * (x_next_value - x_last_value);

		x_last_value = x_next_value;
	}

	return integral;
}

double TCXArray::IntegralSquared(TCXArray &CArrayXVariable, double start, double end, double average)
{
	int p, count, count_this;
	double integral = 0;
	double x_last_value, x_next_value;

	count = CArrayXVariable.CX.GetSize();

	if(!(count > 1)) return integral;

	count_this = CX.GetSize();

	if(count_this != count) return integral;

	x_last_value = CArrayXVariable.CX[0];

	if(!end) end = CArrayXVariable.CX[count - 1];

	for(p = 1; p < count; p++) 
	{
		x_next_value = CArrayXVariable.CX[p];

		if(x_next_value < start) 
		{
			x_last_value = x_next_value;

			continue;
		}

		if(x_next_value > end) break;

		integral += (CX[p] - average) * (CX[p] - average) * (x_next_value - x_last_value);

		x_last_value = x_next_value;
	}

	return integral;
}

double TCXArray::RMS(TCXArray &CArrayXVariable, double start, double end, bool f_average)
{
	int count = CArrayXVariable.CX.GetSize();

	if(!(count > 1)) return 0;

	if(!end) end = CArrayXVariable.CX[count - 1];

	if(start == end) return 0;

	double average = 0;

	if(f_average) average = AVG(CArrayXVariable, start, end);

	return sqrt(IntegralSquared(CArrayXVariable, start, end, average) / (end - start));
}

double TCXArray::Power(TCXArray &CVolts, TCXArray &CCurrent, double start, double end)
{
	int p, count, v_count, i_count;
	double power = 0;
	double x_last_value, x_next_value;

	count = CX.GetSize();

	if(!(count > 1)) return power;

	v_count = CVolts.CX.GetSize();

	if(v_count != count) return power;

	i_count = CCurrent.CX.GetSize();

	if(i_count != count) return power;

	if(!end) end = CX[count - 1];

	if(start == end) return 0;

	x_last_value = CX[0];

	for(p = 1; p < count; p++) 
	{
		x_next_value = CX[p];

		if(x_next_value < start) 
		{
			x_last_value = x_next_value;

			continue;
		}

		if(x_next_value > end) break;

		power += CVolts.CX[p] * CCurrent.CX[p] * (x_next_value - x_last_value);

		x_last_value = x_next_value;
	}

	power = power / (end - start);

	return power;
}

///////
double	TCXArray::GetMaxValue(int start, int end)
{
	double xmax;

	try
	{
		if(IsBadCodePtr((FARPROC)&CX))
		{
			ASSERT(0);

			return 0.0;
		}


		int count = CX.GetSize();
		
		if(count <= 0) return 0.0;

		if(stop_point) if(stop_point < count) count = stop_point;

		if(!end) end = count - 1;

		if(stop_point) end = count - 1;

		if(start == end) return 0;
	
		if(IsBadCodePtr((FARPROC)&CX[0]))
		{
			ASSERT(0);

			return 0.0;
		}
		
		xmax = CX[0];

		double value;

		for(int p = 0; p < count; p++)
		{
			if(p < start) 
			{
				xmax = CX[p];

				continue;
			}

			if(p > end) break;

			value = CX[p];

			if(value > xmax) xmax = value;

		}
	}
	catch(...)
	{
		ASSERT(0);

		return 0;
	}

	return xmax;
}

double	TCXArray::GetMinValue(int start, int end)
{
	double xmin;

	try
	{
		if(IsBadCodePtr((FARPROC)&CX))
		{
			ASSERT(0);

			return 0.0;
		}

		int count = CX.GetSize();
		
		if(count <= 0) return 0.0;

		if(stop_point) if(stop_point < count) count = stop_point;
	
		if(!end) end = count - 1;

		if(stop_point) end = count - 1;

		if(start == end) return 0;

		xmin = CX[0];

		double value;

		for(int p = 0; p < count; p++)
		{
			if(p < start) 
			{
				xmin = CX[p];
			
				continue;
			}

			if(p > end) break;

			value = CX[p];

			if(value < xmin) xmin = value;
		}
	}

	catch(...)
	{
		ASSERT(0);

		return 0;
	}

	return xmin;
}

int	TCXArray::GetReverseValuePosition(double value, int start, int polarity)
{
	int count = CX.GetSize();
		
	if(count <= 0) return -1;

	double diff;
	int old_sign, new_sign;

	bool found = false;
	int found_count = 0;
	int derivative;
	double last_value = CX[count - 1];
	double current_value = last_value;

	for(int p = count - 1; p > -1; p--)
	{
		current_value = CX[p];

		diff = value - last_value;

		if(diff < 0) old_sign = -1;
		else old_sign = 1;

		diff = value - current_value;

		if(diff < 0) new_sign = -1;
		else new_sign = 1;

		if(current_value - last_value < 0) derivative = -1;
		else derivative = 1;

		last_value = current_value;

		if(found) 
		{
			if(new_sign != old_sign) continue;

			found = false;

			continue;
		}

		if(polarity) if(polarity != derivative) continue;

		if(polarity)
		{
			if(polarity < 0) {if(new_sign < 0) continue;}
			else if(new_sign > 0) continue;
		}

		if(new_sign == old_sign && !found) continue; 

		if(start == -1) return p;

		if(found_count == start) return p;

		found_count++;

		found = true;	
	}

	//pathalogical end case
	if(value == current_value) return 0;

	return -1;
}

int	TCXArray::GetForwardValuePosition(double value, int start, int polarity)
{
	int count = CX.GetSize();
		
	if(count <= 0) return -1;

	double diff;
	int old_sign, new_sign;

	bool found = false;
	int found_count = 0;
	int derivative;
	double last_value = CX[0];
	double current_value = last_value;

	for(int p = 0; p < count; p++)
	{
		current_value = CX[p];

		diff = value - last_value;

		if(diff < 0) old_sign = -1;
		else old_sign = 1;

		diff = value - current_value;

		if(diff < 0) new_sign = -1;
		else new_sign = 1;

		if(current_value - last_value < 0) derivative = -1;
		else derivative = 1;

		last_value = current_value;

		if(found) 
		{
			if(new_sign != old_sign) continue;

			found = false;

			continue;
		}

		if(polarity) if(polarity != derivative) continue;

		if(polarity)
		{
			if(polarity < 0) {if(new_sign < 0) continue;}
			else if(new_sign > 0) continue;
		}

		if(new_sign == old_sign && !found) continue; 

		if(start == -1) return p;

		if(found_count == start) return p;

		found_count++;

		found = true;
	}

	//pathalogical end case
	if(value == current_value) return count - 1;

	return -1;
}

double	TCXArray::GetMaxDBValue(void)
{
	int count = CX.GetSize();
	
	if(count <= 0) return 0.0;

	if(stop_point) if(stop_point < count) count = stop_point;

	if(IsBadCodePtr((FARPROC)&CX[0]))
	{
		ASSERT(0);

		return 0.0;
	}

	double xmax = CX[0];

	for(int p = 0; p < count; p++)
	{
		if(IsBadReadPtr(&CX[p], 4))
		{
			ASSERT(0);

			return 0.0;
		}

		if(CX[p] > xmax) xmax = CX[p];
	}

	if(xmax < 0) xmax = -xmax;// should not occur

	if(!xmax) return -123456e-64;// soft error

	return 20*log10(xmax);
}

double	TCXArray::GetMinDBValue(void)
{
	int count = CX.GetSize();
		
	if(count <= 0) return 0.0;

	if(stop_point) if(stop_point < count) count = stop_point;

	if(IsBadCodePtr((FARPROC)&CX[0]))
	{
		ASSERT(0);

		return 0.0;
	}

	double xmin = CX[0];

	for(int p = 0; p < count; p++)
	{
		if(CX[p] < xmin) xmin = CX[p];
	}

	if(xmin < 0) xmin = -xmin;// should not occur

	if(!xmin) return -123456e-64;// soft error

	return 20*log10(xmin);
}

double TCXArray::GetDBValue(int index)
{
	// no checking for speed

	if(!(index < CX.GetSize()))
	{
		ASSERT(0);

		return 0.0;
	}

	double data = 0;
	
	data = CX[index];

	if(data < 0) data = -data;

	if(!data) return -123456e-64;// soft error

	return 20*log10(data);
}

double TCXArray::GetLogValue(int index)
{
	// no checking for speed

	if(!(index < CX.GetSize()))
	{
		ASSERT(0);

		return 0.0;
	}

	double data = 0;
	
	data = CX[index];

	if(data < 0) data = -data;

	if(!data) return -123456e-64;// soft error

	return log10(data);
}

double TCXArray::GetAntiLogValue(int index)
{
	// no checking for speed
	double data = CX[index];

	data *= 2.302585092;

	return exp(data);
}

int	TCXArray::FindIndex(double value, double resolution)
{
	int count = CX.GetSize();
		
	if(count <= 0) return -1;

	if(!(m_last_index < count))  m_last_index = 0;// inteligent scan

	double min, max;

	min = value - resolution;
	max = value + resolution;

	double xvalue;

	int p;

	if(positive_derivative)
	{
		for(p = m_last_index; p < count; p++)
		{
			xvalue = CX[p];

			if(xvalue > max) continue; 

			if(xvalue < min) continue;

			m_last_index = p;

			if(m_last_value > xvalue) positive_derivative = false;
			else positive_derivative = true;

			m_last_value = xvalue;

			return p;
		}

		for(p = 0; p < m_last_index; p++)
		{
			xvalue = CX[p];

			if(xvalue > max) continue; 

			if(xvalue < min) continue; 

			m_last_index = p;

			if(m_last_value > xvalue) positive_derivative = false;
			else positive_derivative = true;

			m_last_value = xvalue;

			return p;
		}
	}
	else
	{
		for(p = m_last_index; p > -1; p--)
		{
			xvalue = CX[p];

			if(xvalue > max) continue;

			if(xvalue < min) continue;

			m_last_index = p;

			if(m_last_value > xvalue) positive_derivative = false;
			else positive_derivative = true;

			m_last_value = xvalue;

			return p;
		}

		for(p = count - 1; p > m_last_index; p--)
		{
			xvalue = CX[p];

			if(xvalue > max) continue;

			if(xvalue < min) continue; 

			m_last_index = p;

			if(m_last_value > xvalue) positive_derivative = false;
			else positive_derivative = true;

			m_last_value = xvalue;

			return p;
		}
	}

	return -1;
}

int	TCXArray::FindDBIndex(double value, double resolution)
{
	int count = CX.GetSize();
		
	if(!count) return -1;

	if(!(m_last_index < count))  m_last_index = 0;// inteligent scan

	double min, max;

	min = value - resolution;
	max = value + resolution;

	double xvalue;

	int p;

	if(positive_derivative)
	{
		for(p = m_last_index; p < count; p++)
		{
			xvalue = GetDBValue(p);

			if(xvalue > max) continue;

			if(xvalue < min) continue;

			m_last_index = p;

			if(m_last_value > xvalue) positive_derivative = false;
			else positive_derivative = true;

			m_last_value = xvalue;

			return p;
		}

		for(p = 0; p < m_last_index; p++)
		{
			xvalue = GetDBValue(p);

			if(xvalue > max) continue;

			if(xvalue < min) continue;

			m_last_index = p;

			if(m_last_value > xvalue) positive_derivative = false;
			else positive_derivative = true;

			m_last_value = xvalue;

			return p;
		}
	}
	else
	{
		for(p = m_last_index; p > -1; p--)
		{
			xvalue = GetDBValue(p);

			if(xvalue > max) continue;

			if(xvalue < min) continue;

			m_last_index = p;

			if(m_last_value > xvalue) positive_derivative = false;
			else positive_derivative = true;

			m_last_value = xvalue;

			return p;
		}

		for(p = count - 1; p > m_last_index; p--)
		{
			xvalue = GetDBValue(p);

			if(xvalue > max) continue;

			if(xvalue < min) continue;

			m_last_index = p;

			if(m_last_value > xvalue) positive_derivative = false;
			else positive_derivative = true;

			m_last_value = xvalue;

			return p;
		}
	}

	return -1;
}

/////////////////////////////////
////////////////////////////////////////////////////////////
TCXYArrayList::TCXYArrayList(void)
{

}
TCXYArrayList::TCXYArrayList(TCXYArrayList &CXYArrayList)
{
	*this = CXYArrayList;
}
TCXYArrayList::~TCXYArrayList(void)
{

}

void TCXYArrayList::Zero(void)
{
	int p, count;

	count = CList.GetSize();

	for(p = 0; p < count; p++) 
	{
		CList[p].x = 0.0;
		CList[p].y = 0.0;
	}
}

void TCXYArrayList::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	int count, p;

	if(CArchiveFile.IsStoring())
	{
		count = CList.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CList[p].Serialize(CArchiveFile);
	}
	else
	{
		CArchiveFile >> count;

		CList.SetSize(count, count);

		for(p = 0; p < count; p++) CList[p].Serialize(CArchiveFile);
	}
}
void TCXYArrayList::operator = (TCXYArrayList &CXYArrayList)
{
	int p, count;

	count = CXYArrayList.CList.GetSize();

	CList.SetSize(count, count);

	for(p = 0; p < count; p++) CList[p] = CXYArrayList.CList[p];
}

/////////////////////////////////
TCXYArray::TCXYArray(void)
{
	x = 0.0;
	y = 0.0;
}
TCXYArray::TCXYArray(TCXYArray &CXYArray)
{
	*this = CXYArray;
}
TCXYArray::~TCXYArray(void)
{

}

void TCXYArray::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile <<	x;
		CArchiveFile <<	y;
	}
	else
	{
		CArchiveFile >>	x;
		CArchiveFile >>	y;
	}
}
void TCXYArray::operator = (TCXYArray &CXYArray)
{
	x = CXYArray.x;
	y = CXYArray.y;
}