
#ifndef _TCXYArray_H
#define _TCXYArray_H

#include <afxtempl.h>

class TCXYArray : public CObject
{
	public:	TCXYArray(void);
			TCXYArray(TCXYArray &CXYArray);
			~TCXYArray(void);

			double x;
			double y;

			void operator = (TCXYArray &CXYArray);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCXYArray)

};

class TCXYArrayList : public CObject
{
	public:	TCXYArrayList(void);
			TCXYArrayList(TCXYArrayList &CXYArrayList);
			~TCXYArrayList(void);

			CArray <TCXYArray, TCXYArray&> CList;

			void Zero(void);

			void operator = (TCXYArrayList &CXYArrayList);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCXYArrayList)

};

class TCXArray : public CObject
{
	public:	TCXArray(void);
			TCXArray(TCXArray &CXArray);
			~TCXArray(void);

			CArray <double, double&> CX;

			void Zero(void);

			void operator = (TCXArray &CXArray);
			TCXArray operator + (TCXArray &CXArray);
			TCXArray operator - (TCXArray &CXArray);
			TCXArray operator * (TCXArray &XArray);
			TCXArray operator / (TCXArray &CXArray);
			TCXArray operator ^ (TCXArray &CXArray);

			TCXArray operator * (double data);
			TCXArray operator / (double data);
			TCXArray operator ^ (double data);

			TCXArray Sqrt(void);
			TCXArray Sin(void);
			TCXArray Cos(void);
			TCXArray Log10(void);
			TCXArray DB20Log10(void);
			TCXArray DB10Log(void);
			TCXArray Derivative(TCXArray &CArrayXVariable);
			double	 Integral(TCXArray &CArrayXVariable, double start, double end);
			double	 AVG(TCXArray &CArrayXVariable, double start, double end);
			double	 IntegralSquared(TCXArray &CArrayXVariable, double start, double end, double average = 0);
			double	 RMS(TCXArray &CArrayXVariable, double start, double end, bool f_average = 0);
			double	 Power(TCXArray &CVolts, TCXArray &CCurrent, double start, double end);
	
			void Serialize(CArchive& CArchiveFile);

			int		m_last_index;
			double  m_last_value;
			bool	positive_derivative;
			int		stop_point;

			double	GetMaxValue(int start = 0, int end = 0);
			double	GetMinValue(int start = 0, int end = 0);
			double	GetMaxDBValue(void);
			double	GetMinDBValue(void);
			int		FindIndex(double value, double resolution);
			int		FindDBIndex(double value, double resolution);
			
			int		GetReverseValuePosition(double value, int start = -1, int polarity = 1);// for gain/phase margin
			int		GetForwardValuePosition(double value, int start = -1, int polarity = 1);// for gain/phase margin

			double GetDBValue(int index);
			double GetLogValue(int index);
			double GetAntiLogValue(int index);

			DECLARE_SERIAL(TCXArray)

};
#endif