
#ifndef _SUPERSPICE_ENUMS_H
#define _SUPERSPICE_ENUMS_H

// "TESuperSpiceEnums.h"
#include "TESuperSpiceLabelEnums.h"

enum TE_GRAPHICS_MANAGER_SYSTEM_STATE
{		
	E_GRAPHICS_MANAGER_STATE_IDLE,
	E_GRAPHICS_MANAGER_STATE_GRAPHICS_SELECTED,
	E_GRAPHICS_MANAGER_STATE_GRAPHICS_MOVING,
	E_GRAPHICS_MANAGER_STATE_SELECT_REGION,
	E_GRAPHICS_MANAGER_STATE_GOT_GRAPHIC,
	E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD,
	E_GRAPHICS_MANAGER_STATE_DRAWING_WIRE,
	E_GRAPHICS_MANAGER_STATE_WAITING_TO_DRAW_WIRE,
	E_GRAPHICS_MANAGER_STATE_SIZING_WAVEFORM_WINDOW,
	E_GRAPHICS_MANAGER_STATE_WAVEFORM_ON_CLICK,

	E_GRAPHICS_MANAGER_MAX_NUM_STATES
};

enum TE_TYPE_OF_COMPONENT // Main inbuilt components
{
	E_SUBCIRCUIT_COMPONENT = 0,		// The order of this is important 
	E_BOX_WAVEFORM_CURSOR,
	E_WAVEFORM_COMPONENT,
	E_POINTING_UP_PIN_COMPONENT,
	E_POINTING_DOWN_PIN_COMPONENT,
	E_POINTING_LEFT_PIN_COMPONENT,
	E_POINTING_RIGHT_PIN_COMPONENT,
	E_CURVE_COMPONENT,

	E_SYMBOL_POINTING_UP_PIN_COMPONENT,// psudo pin components
	E_SYMBOL_POINTING_DOWN_PIN_COMPONENT,
	E_SYMBOL_POINTING_LEFT_PIN_COMPONENT,
	E_SYMBOL_POINTING_RIGHT_PIN_COMPONENT,
	E_SYMBOL_CURVE_COMPONENT,

	E_WIRE_COMPONENT,
	E_CONNECTION_DOT,
	E_LABEL_COMPONENT,
	E_TEST_MARKER,
	E_CONNECTER_POWER,

	E_PAGE_CONNECTER_INPUT,
	E_PAGE_CONNECTER_OUTPUT,
	E_PAGE_CONNECTER_BIDIRECTIONAL,
	E_SUBCIRCUIT_PIN_CONNECTER,

	E_GROUND,

	E_DC_VOLTAGE_SOURCE,	// Ensure this position for v and i
	E_SINE_VOLTAGE_SOURCE,
	E_PULSE_VOLTAGE_SOURCE,
	E_EXPONENTIAL_VOLTAGE_SOURCE,
	E_PIECEWISE_LINEAR_VOLTAGE_SOURCE,
	E_SINGLE_FREQ_VOLTAGE_FM,
	E_DC_CURRENT_SOURCE,
	E_SINE_CURRENT_SOURCE,
	E_PULSE_CURRENT_SOURCE,
	E_EXPONENTIAL_CURRENT_SOURCE,
	E_PIECEWISE_LINEAR_CURRENT_SOURCE,
	E_SINGLE_FREQ_CURRENT_FM,

	E_RESISTOR_COMPONENT,// Ensure that this is always the first component
	E_IC_RESISTOR_COMPONENT,
	E_CAPACITOR_COMPONENT,
	E_IC_CAPACITOR_COMPONENT,
	E_INDUCTOR_COMPONENT,
	
	E_DIODE_COMPONENT,		// Diodes
	E_ZENER_COMPONENT,
	E_SHOTTKY_COMPONENT,

	E_NPN_TRANSISTER_COMPONENT,// Bipoler start
	E_PNP_TRANSISTER_COMPONENT,
	E_NPN_4TERM_TRANSISTER_COMPONENT,
	E_PNP_4TERM_TRANSISTER_COMPONENT,

	E_NMOS_TRANSISTER_COMPONENT, // FETS start
	E_PMOS_TRANSISTER_COMPONENT,
	E_NMOS_4TERM_TRANSISTER_COMPONENT,
	E_PMOS_4TERM_TRANSISTER_COMPONENT,
	E_NJFET_TRANSISTER_COMPONENT,
	E_PJFET_TRANSISTER_COMPONENT,
	E_4TERM_NJFET_TRANSISTER_COMPONENT,
	E_4TERM_PJFET_TRANSISTER_COMPONENT,
	E_NGASFET_TRANSISTER_COMPONENT,
	E_PGASFET_TRANSISTER_COMPONENT,
	E_NGASFET_4TERM_TRANSISTER_COMPONENT,
	E_PGASFET_4TERM_TRANSISTER_COMPONENT,

	
	E_VCVSRC_COMPONENT,
	E_ICVSRC_COMPONENT,
	E_VCISRC_COMPONENT,
	E_ICISRC_COMPONENT,
	E_NONLINEAR_DEPENDANT_SOURCE,

	E_TRANSMISSION_LINE_COMPONENT,

	E_VSWITCH_COMPONENT,
	E_ISWITCH_COMPONENT,

	E_TRANSFORMER_COMPONENT,
	
	E_5_PIN_OP_AMP_COMPONENT,// default as general spice model
	E_7_PIN_OPAMP_COMPONENT,
	E_8_PIN_OP_AMP_COMPONENT,
	E_14_PIN_OP_AMP_COMPONENT,
	E_COMPONENT_DIVIDER,
	E_DIGITAL_AND,
	E_DIGITAL_NAND,
	E_DIGITAL_OR,
	E_DIGITAL_NOR,
	E_DIGITAL_EX_OR,
	E_DIGITAL_EX_NOR,
	E_DIGITAL_INVERTOR,
	E_DIGITAL_SCHMITT_TRIGGER,
	E_VARIABLE_RESISTOR,					// any others will be added externaly in new symbol file
	E_ANALOG_TO_DIGITAL,
	E_DIGITAL_TO_ANALOG,
	E_LAPLACE_TRANSFORM,

	E_GENERIC_2INPUT_AMP,
	E_BUFFER_COMPONENT,
	E_MULIPLIER_COMPONENT,
	E_VCA_COMPONENT,
	E_DIAC_COMPONENT,
	E_DUAL_GATE_NMOSFET,
	E_DUAL_GATE_PMOSFET,
	E_UNIJUNCTION_COMPONENT,
	E_NIGBP_COMPONENT,
	E_PIGBP_COMPONENT,
	E_THRYSISTER_COMPONENT,
	E_GTO_COMPONENT,
	E_TRIAC_COMPONENT,
	E_NAND_GATE,
	E_NOR_GATE,
	E_AND_GATE,
	E_OR_GATE,		
	E_EXCLUSIVE_OR,
	E_EXCLUSIVE_NOR,
	E_INVERTOR,
	E_SCHMITT_TRIGGER,
	E_DTYPE,
	E_JKTYPE,
	E_8BIT_COUNTER,
	E_TRIODE_VALVE,
	E_PENTODE_VALVE,
	E_TETRODE_VALVE,
	E_LOSSLESS_TRANSMISSION_LINE_COMPONENT,
	E_OPTO_COUPLER,
	E_NPN_DARLINGTON,
	E_PNP_DARLINGTON,
	E_FREQUENCY_CRYSTAL,
	E_XSPICE_DIGITAL,// was E_MOTER,

	E_RESERVED_GENERIC_LDO,

	E_GENERIC_2_COMPONENT,// default marker as attached schematic
	E_GENERIC_3_COMPONENT, 
	E_GENERIC_4_COMPONENT,
	E_GENERIC_5_COMPONENT,
	E_GENERIC_6_COMPONENT,
	E_GENERIC_7_COMPONENT,
	E_GENERIC_8_COMPONENT,
	E_GENERIC_9_COMPONENT,
	E_GENERIC_10_COMPONENT,
	E_GENERIC_11_COMPONENT,
	E_GENERIC_12_COMPONENT,
	E_GENERIC_13_COMPONENT,
	E_GENERIC_14_COMPONENT,
	E_GENERIC_15_COMPONENT,
	E_GENERIC_16_COMPONENT,
	E_GENERIC_17_COMPONENT,
	E_GENERIC_18_COMPONENT,
	E_GENERIC_19_COMPONENT,
	E_GENERIC_20_COMPONENT,

	E_SYMBOL_INDUCTOR_SEMICIRCLE_COMPONENT,

	E_TRANSFORMER_DUAL,
	E_TRANSFORMER_TRIPLE,
	E_TRANSFORMER_QUAD,
	E_TRANSFORMER_SINGLE_CENTERTAPED,
	E_TRANSFORMER_DUAL_CENTERTAPED,
	E_TRANSFORMER_TRIPLE_CENTERTAPED,
	E_TRANSFORMER_QUAD_CENTERTAPED,
	E_TRANSFORMER_TUBE_OUTPUT,
	E_TRANSFORMER_FLYBACK_TRIPLE,


	E_TUBE_DIODE_SINGLE,
	E_TUBE_DIODE_DUAL_COMMON_CATHODE,
	E_TUBE_DIODE_DUAL_INDIVIDUAL_CATHODES,

	E_VARISTOR_MOV,
	E_SPICE_THERMISTOR,
	E_COMPONENT_FUSE,

	E_DYNAMIC_SYMBOL_COMPONENT,

	E_INDUCTOR_COMPONENT_CORED,
	
	E_TUBE_8PIN,
	E_TRIODE_VALVE_DUAL,
	E_TRIODE_VALVE_DUAL_HEATER,
	E_TRIODE_VALVE_HEATER,
	E_PENTODE_VALVE_HEATER,
	E_TETRODE_VALVE_HEATER,
	E_TUBE_DIODE_SINGLE_HEATER,
	E_TUBE_DIODE_DUAL_COMMON_CATHODE_HEATER,
	E_TUBE_DIODE_DUAL_INDIVIDUAL_CATHODES_HEATER,
	E_MOTER,
	E_MOTER_TACHO,
	E_CCFL,

	E_TITLE_BLOCK,

	E_TUBE_TRIODE_COMMON_CATHODE_HEATER,
	E_TUBE_DIODE_COMMON_CATHODE_HEATER,
	E_TUBE_DIODE_DUAL_CATHODE_HEATER,
	E_TRANSFORMER_ONE_CENTER_TAP,
	E_TRANSFORMER_DUAL_ONE_CENTER_TAP,

	E_DIGITAL_AND_3IN,
	E_DIGITAL_NAND_3IN,
	E_DIGITAL_OR_3IN,
	E_DIGITAL_NOR_3IN,
	E_ANALOG_AND_3IN,
	E_ANALOG_NAND_3IN,
	E_ANALOG_OR_3IN,
	E_ANALOG_NOR_3IN,

	E_URC_TRANSMISSION_LINE,

	E_MAX_COMPONENT
};

enum TE_REFERANCE_DESIGNATOR_TYPES// this will be removed in the code, function willl be in TCSpiceParameter
{
	E_REF_DESIGNATOR_PAGE_CONNECTION,
	E_REF_DESIGNATOR_GROUND,
	E_REF_DESIGNATOR_WIRE,
	E_REF_DESIGNATOR_TEST_MARKER,
	E_REF_DESIGNATOR_VOLTAGE,
	E_REF_DESIGNATOR_CURRENT,
	E_REF_DESIGNATOR_R,
	E_REF_DESIGNATOR_C,
	E_REF_DESIGNATOR_L,
	E_REF_DESIGNATOR_DIODE,
	E_REF_DESIGNATOR_Q,
	E_REF_DESIGNATOR_M,
	E_REF_DESIGNATOR_J,
	E_REF_DESIGNATOR_VCVS,
	E_REF_DESIGNATOR_VCIS,
	E_REF_DESIGNATOR_ICIS,
	E_REF_DESIGNATOR_ICVS,
	E_REF_DESIGNATOR_TRANSMISSION_LINE,
	E_REF_DESIGNATOR_MESFET,
	E_REF_DESIGNATOR_SUBCIRCUIT,
	E_REF_DESIGNATOR_VSWITCH,
	E_REF_DESIGNATOR_ISWITCH,
	E_REF_DESIGNATOR_WAVEFORM,
	E_REF_XSPICE_DIGITAL,
	E_REF_LOSSLESS_TRANSMISSION_LINE_COMPONENT,
	E_REF_NONLINEAR_DEPENDANT_SOURCE,
	E_REF_DESIGNATOR_POWER,
	E_REF_DESIGNATOR_URC,

	E_REF_DESIGNATOR_MAX
};


enum TE_SCHEMATIC_PIN_TYPE
{
	E_SCHEMATIC_PIN_ANALOGUE_INPUT	= 0,// for default pin connections
	E_SCHEMATIC_PIN_ANALOGUE_OUTPUT,
	E_SCHEMATIC_PIN_DIGITAL_INPUT,
	E_SCHEMATIC_PIN_DIGITAL_OUTPUT,

	E_SCHEMATIC_PIN_ANALOGUE_BIDIRECTIONAL,// not yet used
	E_SCHEMATIC_PIN_ANALOGUE_DONT_CARE

};

enum TE_COMPONENT_GRAPHIC_TYPE
{
	E_SCHEMATIC_OBJECT		= 1,
	E_SCHEMATIC_WIRE,
	E_SCHEMATIC_LABEL,
	E_SCHEMATIC_PIN, 
	E_SCHEMATIC_PIN_LABEL,
	E_SCHEMATIC_TEXT_LABEL,
	E_SCHEMATIC_BITMAP,
	E_WAVEFORM_OBJECT,// top bar 
	E_WAVEFORM_OBJECT_SCREEN,// overall data
	E_WAVEFORM_OBJECT_SIGNAL

};

enum E_POLE_ZERO_TYPES
{
	E_POLE_ONLY,
	E_ZERO_ONLY,
	E_POLE_AND_ZERO
};

enum E_OUTPUT_TYPES
{
	E_OUTPUT_VOLTAGE,
	E_OUTPUT_CURRENT,
	E_NET_NODES
};



enum E_MISC_ENUMS
{
	E_NO_UPDATE_OTHER_NODE_NAMES = 0,
	E_UPDATE_OTHER_NODE_NAMES = 1,
	E_UPDATE_OTHER_NODE_NAMES_SET_USER_PREFERED = 2
};

enum TE_TEST_POINTS_TYPE
{
	E_TEST_POINT_MAGNITUDE,
	E_TEST_POINT_DB,
	E_TEST_POINT_DEGS,
	E_TEST_POINT_RADS,
	
	E_TEST_POINT_MAGDEG,
	E_TEST_POINT_DBDEGS,
	E_TEST_POINT_MAGRADS,
	E_TEST_POINT_DBRADS,
	

	E_TEST_POINTS_TYPE_MAX
};



#endif