#ifndef TESuperSpiceLabelEnums_H
#define TESuperSpiceLabelEnums_H



enum TE_COMPONENT_LABEL_TYPE
{
	E_COMPONENT_SYMBOL_NAME = 0,
	E_COMPONENT_SPICE_MODEL_NAME = 1,
	E_COMPONENT_VALUE,
	E_COMPONENT_DESIGNATOR,
	E_WIRE_NET_CONNECTION_DOT1 = E_COMPONENT_SYMBOL_NAME,
	E_WIRE_NET_CONNECTION_DOT2 = E_COMPONENT_SPICE_MODEL_NAME,
	E_WIRE_NET_NAME = E_COMPONENT_DESIGNATOR,
	E_WIRE_NET_VOLTAGE = E_COMPONENT_VALUE,
	E_COMPONENT_MAX_LABEL_NUMBER = 4, // can be overiden dynamically

	E_WAVEFORM_TITLE	= E_COMPONENT_SYMBOL_NAME,
	E_WAVEFORM_DATE_AND_TIME = E_COMPONENT_SPICE_MODEL_NAME,
	E_WAVEFORM_PLOT_NAME = E_COMPONENT_VALUE,
	E_WAVEFORM_DESIGNATOR =  E_COMPONENT_DESIGNATOR,
	E_WAVEFORM_ENABLE,
	
	E_GENERATOR_DC_VALUE = E_COMPONENT_MAX_LABEL_NUMBER,// generators have additiona labels
	E_GENERATOR_AC_VALUE,
	E_GENERATOR_AC_IMD1,
	E_GENERATOR_AC_IMD2,
	E_GENERATOR_PHASE_VALUE,

	E_GENERATOR_SINE_AMPLITUDE_VALUE,
	E_GENERATOR_SINE_FREQUENCY_VALUE,
	E_GENERATOR_SINE_OFFSET_VALUE,
	E_GENERATOR_SINE_DELAY_VALUE,
	E_GENERATOR_SINE_IMD1,
	E_GENERATOR_SINE_IMD2,
	E_GENERATOR_SINE_DAMPING_VALUE,

	E_GENERATOR_PULSE_START_AMPLITUDE_VALUE = E_GENERATOR_SINE_AMPLITUDE_VALUE,
	E_GENERATOR_PULSE_STOP_AMPLITUDE_VALUE,
	E_GENERATOR_PULSE_DELAY_VALUE,
	E_GENERATOR_PULSE_RISE_TIME_VALUE,
	E_GENERATOR_PULSE_FALL_TIME_VALUE,
	E_GENERATOR_PULSE_WIDTH_VALUE,
	E_GENERATOR_PULSE_IMD1,
	E_GENERATOR_PULSE_IMD2,
	E_GENERATOR_PULSE_PERIOD_VALUE,

	E_GENERATOR_EXP_START_VALUE = E_GENERATOR_SINE_AMPLITUDE_VALUE,
	E_GENERATOR_EXP_STOP_VALUE,
	E_GENERATOR_EXP_TAU1_DELAY_VALUE,
	E_GENERATOR_EXP_TAU1_VALUE,
	E_GENERATOR_EXP_TAU2_DELAY_VALUE,
	E_GENERATOR_EXP_IMD1,
	E_GENERATOR_EXP_IMD2,
	E_GENERATOR_EXP_TAU2_VALUE,

	//IGNORE PWL for now
	E_GENERATOR_PWL_IMD1 = E_GENERATOR_SINE_AMPLITUDE_VALUE,
	E_GENERATOR_PWL_IMD2,

	E_GENERATOR_SFFM_CARRIER_AMPLITUDE_VALUE = E_GENERATOR_SINE_AMPLITUDE_VALUE,
	E_GENERATOR_SFFM_MODULATION_INDEX_VALUE,
	E_GENERATOR_SFFM_CARRIER_FREQUENCY_VALUE,
	E_GENERATOR_SFFM_MODULATION_FREQUENCY_VALUE,
	E_GENERATOR_SFFM_IMD1,
	E_GENERATOR_SFFM_IMD2,
	E_GENERATOR_SFFM_OFFSET_VALUE,

	E_COMPONENT_RESISTOR_RESISTIVITY = E_COMPONENT_MAX_LABEL_NUMBER,
	E_COMPONENT_RESISTOR_WIDTH,
	E_COMPONENT_RESISTOR_LENGTH,
	E_COMPONENT_RESISTOR_TEMPCO1,
	E_COMPONENT_RESISTOR_TEMPCO2,
	E_COMPONENT_RESISTOR_MULTIPLIER_M,
	E_COMPONENT_RESISTOR_RESISTANCE,
	
	E_COMPONENT_CAPACITOR_CAPACITIVITY = E_COMPONENT_MAX_LABEL_NUMBER,
	E_COMPONENT_CAPACITOR_WIDTH,
	E_COMPONENT_CAPACITOR_LENGTH,
	E_COMPONENT_CAPACITOR_IC,
	E_COMPONENT_CAPACITOR_TEMPCO1,
	E_COMPONENT_CAPACITOR_TEMPCO2,
	E_COMPONENT_CAPACITOR_MULTIPLIER_M,
	E_COMPONENT_CAPACITOR_CAPAPACITANCE,

	E_COMPONENT_INDUCTOR_AL = E_COMPONENT_MAX_LABEL_NUMBER,
	E_COMPONENT_INDUCTOR_IC,
	E_COMPONENT_INDUCTOR_N,
	E_COMPONENT_INDUCTOR_TEMPCO1,
	E_COMPONENT_INDUCTOR_TEMPCO2,

	E_COMPONENT_TRANSFORMER_COUPLING = E_COMPONENT_MAX_LABEL_NUMBER,
	E_COMPONENT_TRANSFORMER_L1,
	E_COMPONENT_TRANSFORMER_L2,
	E_COMPONENT_TRANSFORMER_AL,
	E_COMPONENT_TRANSFORMER_N1,
	E_COMPONENT_TRANSFORMER_N2,
	E_COMPONENT_TRANSFORMER_LMUTUAL,
	E_COMPONENT_TRANSFORMER_TEMPCO1,
	E_COMPONENT_TRANSFORMER_TEMPCO2,

	E_COMPONENT_TRANSMISSION_LINE_Z0 = E_COMPONENT_MAX_LABEL_NUMBER,
	E_COMPONENT_TRANSMISSION_LINE_TD,
	E_COMPONENT_TRANSMISSION_LINE_F0,
	E_COMPONENT_TRANSMISSION_LINE_LENGTH,
	E_COMPONENT_TRANSMISSION_LINE_R0,
	E_COMPONENT_TRANSMISSION_LINE_L0,
	E_COMPONENT_TRANSMISSION_LINE_C0,
	E_COMPONENT_TRANSMISSION_LINE_G0,

	E_COMPONENT_DIODE_M = E_COMPONENT_MAX_LABEL_NUMBER,
	E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE,

	E_COMPONENT_BIPOLAR_M = E_COMPONENT_MAX_LABEL_NUMBER,
	E_COMPONENT_BIPOLAR_NUM_RESERVED,
	E_COMPONENT_BIPOLAR_WIDTH,
	E_COMPONENT_BIPOLAR_LENGTH, 
	E_COMPONENT_BIPOLAR_PARAMETERS,

	E_COMPONENT_FET_WIDTH = E_COMPONENT_MAX_LABEL_NUMBER,
	E_COMPONENT_FET_LENGTH, 
	E_COMPONENT_FET_M,
	E_COMPONENT_FET_ENABLE_AD,
	E_COMPONENT_FET_ENABLE_AS,
	E_COMPONENT_FET_USE_DEFAULT_WL,
	E_COMPONENT_FET_PARAMETERS,

	E_COMPONENT_VSWITCH_RON = E_COMPONENT_MAX_LABEL_NUMBER,
	E_COMPONENT_VSWITCH_ROFF,
	E_COMPONENT_VSWITCH_VT,
	E_COMPONENT_VSWITCH_VH,

	E_COMPONENT_ISWITCH_RON = E_COMPONENT_MAX_LABEL_NUMBER,
	E_COMPONENT_ISWITCH_ROFF,
	E_COMPONENT_ISWITCH_IT,
	E_COMPONENT_ISWITCH_IH,

	E_COMPONENT_LAPLACE_NUMERATOR = E_COMPONENT_MAX_LABEL_NUMBER,
	E_COMPONENT_LAPLACE_DENOMINATOR,
	E_COMPONENT_LAPLACE_GAIN,
	E_COMPONENT_LAPLACE_OFFSET,
	E_COMPONENT_LAPLACE_NORMALISED_FREQUENCY,

	E_COMPONENT_VARABLE_RESISTOR_RESISTANCE = E_COMPONENT_MAX_LABEL_NUMBER,
	E_COMPONENT_VARABLE_RESISTOR_ROTATION,
	E_COMPONENT_VARABLE_RESISTOR_LOG,
	E_COMPONENT_VARABLE_RESISTOR_LOG_MULTIPLYER,

	E_COMPONENT_SUBCKT_PARAMETERS = E_COMPONENT_MAX_LABEL_NUMBER,

	E_COMPONENT_URC_LENGTH	= E_COMPONENT_MAX_LABEL_NUMBER,
	E_COMPONENT_URC_NUMBER_SECTIONS,

	E_COMPONENT_CONTROLLED_SOURCE_PARAMETERS = E_COMPONENT_MAX_LABEL_NUMBER,

	E_TITLE_BLOCK_TITLE_HEADER = 0,
	E_TITLE_BLOCK_TITLE,
	E_TITLE_BLOCK_FILE_NAME_HEADER,
	E_TITLE_BLOCK_REFDES, // not used
	E_TITLE_BLOCK_FILE_NAME,
	E_TITLE_BLOCK_DESIGNER_HEADER,
	E_TITLE_BLOCK_DESIGNER,
	E_TITLE_BLOCK_CREATED_HEADER,
	E_TITLE_BLOCK_CREATED,
	E_TITLE_BLOCK_DRAWN_HEADER,
	E_TITLE_BLOCK_DRAWN,
	E_TITLE_BLOCK_DISCRIPTION_HEADER,
	E_TITLE_BLOCK_DISCRIPTION1,
	E_TITLE_BLOCK_DISCRIPTION2,
	E_TITLE_BLOCK_SIZE_HEADER,
	E_TITLE_BLOCK_SIZE,
	E_TITLE_BLOCK_DOC_NUMBER_HEADER,
	E_TITLE_BLOCK_DOC_NUMBER,
	E_TITLE_BLOCK_REV_HEADER,
	E_TITLE_BLOCK_REV,
	E_TITLE_BLOCK_DATE_HEADER,
	E_TITLE_BLOCK_DATE,
	E_TITLE_BLOCK_SHEET,
	E_TITLE_BLOCK_NOF,
	E_TITLE_BLOCK_OF,
	E_TITLE_BLOCK_OFN,


};

enum TE_COMPONENT_PIN_LABELS
{
	E_COMPONENT_PIN_NAME,
	E_COMPONENT_PIN_NUMBER,
	E_COMPONENT_PIN_VOLTAGE,
	E_COMPONENT_PIN_CURENT,
	E_COMPONENT_PIN_NET_NAME,

	E_NUM_PIN_LABELS
	
};
#endif